#!/bin/bash --norc
# *******************************************************************************
# * MODULE     : mkbasic.sh
# * DESCRIPTION: build the basic TeXmacs SDK libs
# * COPYRIGHT  : (C) 2016-2017 Denis RAUX
# *******************************************************************************
# * This software falls under the GNU general public license version 3 or later.
# * It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
# * in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
# *******************************************************************************

. common.sh

trap "exit 250" SIGINT

CFLAGS+=" ${TMSDKDBG:=-O2}"
CXXFLAGS+=" ${TMSDKDBG:=-O2}"

typeset OSsz targets
targets="libtool zlib libiconv libpng readline gettext expat freetype gmp nettle gnutls"
case $TMOS in
lin) targets+=" fontconfig";;
esac

[[ $(uname -a) =~ 86_68 ]] && OSsz=--64

#check for the most tricky compiler options
for opt in _fgnu89_inline
do
	eval $opt=${opt//_/-}
gcc -v --help 2>/dev/null|grep -q -- ${!opt} || unset $opt
done

# libs list to build
case $1 in 
	-h) echo -l list default targets; exit 2;;
	-l) echo $targets; exit 2;;
	"") llist=$targets;;
	*) llist="$@";;
esac

#
# configuration options
#

# general options
for n in $llist; do eval $n=\(--enable-static --disable-shared\);done

# per lib options
zlib=(--64 --static $OSsz --includedir=$TMSDKPH/include --libdir=$TMSDKPH/lib)
gettext=(${gettext[*]} --disable-libasprintf --disable-openmp --without-emacs --with-lispdir --without-tools --without-os2 --without-examples)
libiconv=(${libiconv[*]} CFLAGS="$CFLAGS${CFLAGS:+ }$_fgnu89_inline")
libpng=(${libpng[*]} --with-pkgconfigdir=$TMSDKPH/lib/pkgconfig)
nettle=(${nettle[*]} --libdir=$TMSDKPH/lib --disable-assembler --disable-documentation)
gnutls=(${gnutls[*]} --with-included-libtasn1 --with-included-unistring --without-p11-kit  --disable-guile --disable-doc --disable-tools --disable-bash-tests --disable-cxx)

#as we use mingw32 we need to notice gmp
#gmp=(${gmp[*]} --disable-assembly)
test $TMOS = win && gmp=(${gmp[*]} ABI=32)

freetype=(${freetype[*]} --with-bzip2=no --with-harfbuzz=no)
test $TMOS = win && fontconfig=(${fontconfig[*]}  CFLAGS=$CFLAGS${CFLAGS:+ }-include windef.h)

readline+=(${readline[*]} "CFLAGS=$CFLAGS${CFLAGS:+ }-Wno-implicit-function-declaration")

#
# specific install target
#
INSlibtool="install-includeHEADERS install-ltdlincludeHEADERS install-libLTLIBRARIES"

#
# Specific actions according the OS
#

case $TMOS in
win) 
  # zlib is build in very specific way
  if [[ "$llist" =~ zlib ]] && ([[ "$TMMODE" == m ]] || ! isDone zlib ) 
  then llist=${llist/zlib/}
    typeset MF=Makefile
    MF=win32/Makefile.gcc
    pushd zlib-* || exit 20
    if make BINARY_PATH=$TMSDKPH/bin INCLUDE_PATH=$TMSDKPH/include  LIBRARY_PATH=$TMSDKPH/lib -f$MF install
    then setStatus true zlib
		else  
			setStatus false zlib
			echo Failure in building zlib
			exit 21
		fi		
    popd
  fi
	;;
esac

for n in $llist
do
  ([[ ! "$targets" =~ $n ]] || ([[ $TMMODE == a ]] && isDone $n))  && continue
   l=$n-*
   pushd $l || exit 20
# we need to adjust the parallel building level for some package
   case $n in
   gettext) cntproc=1;;
 esac
   
	 eval ./configure --prefix=$TMSDKPH \"\${${n}[@]}\" &&\
		if make -j$cntproc && eval make \${INS$n:-install}
    then setStatus true $n
		else  
			setStatus false $n
			echo Failure in building $n
			exit 22
		fi		
   popd
done

