#!/bin/bash --norc
# *******************************************************************************
# * MODULE     : mkgs.sh
# * DESCRIPTION: build the TeXmacs SDK ghoscript
# * COPYRIGHT  : (C) 2016-2017 Denis RAUX
# *******************************************************************************
# * This software falls under the GNU general public license version 3 or later.
# * It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
# * in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
# *******************************************************************************

. common.sh
export CFLAGS+=" ${TMSDKDBG:=-O2}  -Wno-implicit-int -Wno-implicit-function-declaration -D__CRT__NO_INLINE"
export CXXFLAGS+=" ${TMSDKDBG:=-O2}"
export CPPFLAGS+=" -DOPJ_EXPORTS"	
# gs does not use the right parameter for a static version
export PKGCONFIG="$(type -P pkg-config) --static"

[[ "$TMMODE" == a ]] && isDone ghostscript && exit 0
cd  ghostscript-* || exit 20
# add here extra lib to include
export EXTRA_INIT_FILES="*.ps *.xpm *.xbm"

if ./configure --prefix=$TMSDKPH\
  --without-x --with-drivers=FILES --disable-cups --disable-gtk --without-tesseract \
  --with-libiconv=gnu --disable-threading --disable-byteswap-h --disable-fontconfig --disable-dbus \
  --with-libtiff &&\
	mkdir -p obj && make -j$cntproc && make install-exec
	then 
		setStatus true ghostscript
#		cd $TMSDKPH/share/ghostscript/ &&\
#		 { test -d fonts || tar -zxf $SDKsrc/../TAR/_ghostscript-fonts-*.tar.gz; }
	else 
		setStatus false ghostscript
		exit 21
fi
exit 0	
