#!/bin/bash --norc
# *******************************************************************************
# * MODULE     : mkguile.sh
# * DESCRIPTION: build the TeXmacs SDK guile 1.8
# * COPYRIGHT  : (C) 2016-2017 Denis RAUX
# *******************************************************************************
# * This software falls under the GNU general public license version 3 or later.
# * It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
# * in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
# *******************************************************************************

. common.sh

#unset  CXXFLAGS CFLAGS # no debug version
CFLAGS+=" ${TMSDKDBG:=-O1}"
CXXFLAGS+=" ${TMSDKDBG:=-O1}"

[[ "$TMMODE" == a ]] && isDone guile && exit 0
cd  guile-* || exit 20

copt="--disable-shared --enable-static --disable-error-on-warning"
copt+=" --disable-networking --disable-nls"
copt+=${TMSDKDBG:+ --enable-debug-freelist --enable-debug-malloc --enable-guile-debug}

case $TMOS in
lin) export LIBS+="${LIBS:+ }-ldl"; opt="--prefix=$TMSDKPH $copt";;
mac) export LIBS+="${LIBS:+ }-ldl"; opt="--prefix=$TMSDKPH $copt";;
win) export CFLAGS+="${CFLAGS:+ }-m32"; opt="--prefix=$TMSDKPH $copt";;
esac

if ./configure $opt && make Makefile && make -j$cntproc && make install
then setStatus true guile
     exit 21
else setStatus false guile
fi
exit 0
