#!/bin/bash --norc
#!/bin/bash --norc
#*******************************************************************************
#* MODULE     : mksrc.sh
#* DESCRIPTION: untar and patch TeXmacs SDK libs
#* COPYRIGHT  : (C) 2016-2017 Denis RAUX
#*******************************************************************************
#* This software falls under the GNU general public license version 3 or later.
#* It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
#* in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
#*******************************************************************************

. common.sh

typeset opt list QTopt taropt dst QtDst
typeset -i patchlevel QTver
list="libtool zlib libiconv libpng readline gettext expat freetype fontconfig gmp nettle gnutls ghostscript guile qt"

QTstr="$(echo ../TAR/qt-*)"
QTstr=${QTstr##*-}
QTver=${QTstr%%.*}

case $QTver in
4) qt_taropt="--exclude qt-*/examples --exclude qt-*/doc --exclude qt-*/demos";;
5) qt_taropt="--exclude qt-*/qtxmlpatterns --exclude qt-*/qtwebengine --exclude qt-*/qtdeclarative";;
esac

ghostscript_taropt=$(echo "--exclude ghostscript-*"/{zlib,libpng,freetype,expat,ijs/ltmain.sh})

# Qt cannot be moved in a install directory after build
# so it has to be unpacked in the final destination
case $TMOS in
win) test -n "$TMSDKDBG" && QtDst=/Qtg || QtDst=/Qt
     qt_taropt+=" --exclude configure --strip-components=1 -C$QtDst"
     [[ -d $TMSDKPH/windows ]] || cp -r ../TAR/windows $TMSDKPH/windows
     ;;
mac)  oslevel=$(sw_vers -productVersion)
      oslevel=${oslevel#*.};oslevel=${oslevel%.*}
     	test -x ../TAR/macos/ninja -a ! -x bin/ninja && cp ../TAR/macos/ninja bin/
      ;;
*)   qt_taropt+=" --exclude configure.exe" ;;
esac

function MkPatch {
# substitute variable in patch files
   local p=$(<$1)
   test -n "$osxmin" && p=${p//TM_osxmin/$osxmin}
   patch -l -p0 <<< "$p"
   return $?
}

while getopts "vl:" opt
do
  case $opt in
  l) list=$OPTARG;;
  v) echo $list;exit;;
  *) cat<<EOF
usage: $0 [-l  "list" ] [-v]
-l: file list to expand
-v: view the actual list
EOF
  	exit;;
  esac
done



for l in $list
do
  typeset -i ver #version number
  if [[ $l =~ qt ]] 
  then
    test -n "$QtDst"  && dst=$QtDst || dst=$l-*
    ver=$QTver
  else dst=$l-*
  fi

  test -d $dst && continue
  patchlevel=$oslevel
  [[ $l =~ qt && $TMOS == win ]] && mkdir $dst && echo $QTver > $QtDst/QTver.txt

  echo process $l
  if eval tar -zxf ../TAR/$l-*tar* \${${l}_taropt}
  then 
    if pushd $dst
    then 
      test -f $SDKsrc/patches/$l$ver.patch &&  MkPatch $SDKsrc/patches/$l$ver.patch
      test -f $SDKsrc/patches/$l$ver.patch.$TMOS &&  MkPatch $SDKsrc/patches/$l$ver.patch.$TMOS
      while [[ $patchlevel > 0 ]];
      do test -f $SDKsrc/patches/$l$ver.patch.$TMOS.$patchlevel &&  MkPatch $SDKsrc/patches/$l$ver.patch.$TMOS.$patchlevel; \
        patchlevel+=-1; 
      done
      test -f $SDKsrc/patches/$l$ver.auto &&  autoreconf -fi
      test -f $SDKsrc/patches/$l$ver.auto.$TMOS &&  autoreconf -fi
      popd
    else echo Can not find $l stop processing; exit 20
    fi
  else echo tar error with $l stop processing; exit 21
  fi
  setStatus false $l
done
