<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <doc-data|<doc-title|A pulsed Sisyphus scheme for laser cooling of atomic
  (anti)hydrogen>|<doc-date|<date|>>|<doc-author|<author-data|<author-name|Saijun
  Wu>>>|<doc-author|<author-data|<author-name|Roger C.
  Brown>>>|<doc-author|<author-data|<author-name|William D.
  Phillips>>>|<doc-author|<author-data|<author-name|J. V. Porto>>>>

  <abstract-data|<\abstract>
    We propose a laser cooling technique in which atoms are selectively
    excited to a dressed metastable state whose light shift and decay rate
    are spatially correlated for Sisyphus cooling. The case of cooling
    magnetically trapped (anti)hydrogen with the 1S-2S-3P transitions using
    pulsed ultra violet and continuous-wave visible lasers is numerically
    simulated. We find a number of appealing features including rapid
    3-dimensional cooling from <math|\<sim\>>1<nbsp>K to recoil-limited,
    millikelvin temperatures, as well as suppressed spin-flip loss and
    manageable photoionization loss.
  </abstract>>

  Recent progress<nbsp><cite|octupoletrap|cusptrap> in producing antihydrogen
  (<math|<wide|<math-up|H>|\<bar\>>>) improves the prospects for precision
  spectroscopy and de Broglie wave interferometry of
  <math|<wide|<math-up|H>|\<bar\>>> that may uncover new physics in
  low-energy experiments<nbsp><cite|athena|atrap>. Antihydrogen atoms are
  synthesized from anti-protons and positrons<nbsp><cite|athena|atrap|penningtrap|octupoletrap|cusptrap>
  in such small numbers that trapping and efficient cooling to millikelvin
  temperatures are likely required for precise measurements. In contrast to
  hydrogen, which may be cooled by collisions with a buffer
  gas<nbsp><cite|buffergas05>, or by selecting low-energy atoms from an
  intense beam, cooling of <math|<wide|<math-up|H>|\<bar\>>> will likely rely
  on laser cooling techniques<nbsp><cite|metcalf>.

  The most obvious approach to laser cooling of
  <with|font-family|rm|H><nbsp><cite|Setija93> or
  <math|<wide|<math-up|H>|\<bar\>>> demands 121.6<nbsp>nm Ly-<math|\<alpha\>>
  radiation. Apart from the difficulty of manipulating VUV light, the
  generation of even <math|\<sim\>>10<nbsp>nW of CW Ly-<math|\<alpha\>>
  radiation is technically challenging<nbsp><cite|Scheid09>. In addition,
  such cooling of <math|<wide|<math-up|H>|\<bar\>>> atoms in a kelvin-deep
  magnetic trap faces several interrelated difficulties. The need to avoid
  spin-flip losses, combined with the limited fraction of phase space
  addressable with a low intensity, single-frequency laser, implies that the
  cooling will be slow. Indeed, the only experimental Ly-<math|\<alpha\>>
  cooling work so far<nbsp><cite|Setija93> used a pulsed laser with an
  average power of 160 nW (2.5<nbsp>nW at the location of atoms) to cool
  magnetically trapped <with|font-family|rm|H>, and took more than 15 minutes
  to reach 8 mK, starting from just 80<nbsp>mK. Furthermore, 3D cooling in
  this approach was aided by collisional mixing, which will be absent in
  dilute samples of <math|<wide|<math-up|H>|\<bar\>>>. Instead of relying on
  Ly-<math|\<alpha\>> radiation, there are several proposed cooling schemes
  using more readily available lasers to drive Doppler sensitive 2-photon
  transitions<nbsp><cite|Allegrini93|Zehnle01|ultrafast06>. However, in
  addition to limited phase-space addressability similar to
  Ly-<math|\<alpha\>> cooling, these schemes have the difficulty of losses
  due to photoionization.

  <big-figure|<image|diagram.eps|3.2 in|||><label|figScheme> |(a): Level
  diagram for the proposed cooling scheme (see text). (b): Simplified
  dressed-state picture of the cooling scheme. The pulsed two-photon
  excitation has bandwidth <math|1/\<tau\>>, is detuned from the bottom of
  the lattice with depth <math|U> by <math|\<delta\><rsub|0>>, and provides
  Doppler cooling by transferring momentum <math|\<hbar\>*k<rsub|g*e>> to an
  atom with velocity <math|v>. The linewidth <math|\<Gamma\><around|(|x|)>>
  of the dressed excited state <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>>
  is indicated by the width of the gray curve. As the atom climbs the hill
  the velocity (green arrow) decreases while the decay probability increases,
  leading to Sisyphus cooling. (The <math|<around|\||e<rprime|'>|\<rangle\>>\<rightarrow\><around|\||e|\<rangle\>>>
  decay is ignored in (b). Not shown is the other, detuned dressed state
  <math|<around|\||<wide|e|~><rprime|'><around|(|x|)>|\<rangle\>>>.) >

  Motivated by previous work<nbsp><cite|multiphoton09>, which used
  transitions between excited states for cooling and trapping, we propose a
  3-level cooling scheme (Fig.<nbsp><reference|figScheme>), applicable to
  magnetically trapped H, where a metastable state
  <math|<around|\||e|\<rangle\>>> is coupled to a short-lived state
  <math|<around|\||e<rprime|'>|\<rangle\>>> by a blue detuned standing wave
  coupling <math|\<Omega\><rsub|e*e<rprime|'>>>. Atoms in the ground state
  <math|<around|\||g|\<rangle\>>> are repeatedly excited to the bottom of the
  dissipative <math|<around|\||e|\<rangle\>>-<around|\||e<rprime|'>|\<rangle\>>>
  optical lattice by a pulsed, Doppler sensitive 2-photon coupling
  <math|\<Omega\><rsub|g*e>>. The proposed cooling process arises from two
  effects: 2-photon Doppler cooling<nbsp><cite|Allegrini93|Zehnle01|ultrafast06>
  associated with <math|<around|\||g|\<rangle\>>\<rightarrow\><around|\||e|\<rangle\>>>
  excitation, and Sisyphus cooling<nbsp><cite|aspect86> associated with the
  <math|<around|\||e|\<rangle\>>-<around|\||e<rprime|'>|\<rangle\>>> lattice.

  For magnetically trapped H, <math|<around|\||g|\<rangle\>>>,
  <math|<around|\||e|\<rangle\>>> and <math|<around|\||e<rprime|'>|\<rangle\>>>
  are the maximally Zeeman shifted states in the 1S, 2S and 3P manifolds
  respectively. We show that the cooling scheme provides both a large capture
  velocity (100 m/s) and a low final temperature (near the Ly-<math|\<beta\>>
  single-photon recoil temperature of 1.8<nbsp>mK), and allows for large
  volume 3D cooling. Advantages include: availability of both
  nanosecond-pulsed UV 2-photon 1S-2S radiation<nbsp><cite|Yatsenko99> and CW
  2S-3P radiation at 656 nm; reduction of UV photoionization losses; and
  suppressed spin-flip transition from the 3P level in a high field. In the
  following we first discuss the pulsed Sisyphus cooling scheme in a 1D,
  semiclassical model. After justifying the model with a 1D quantum
  simulation<nbsp><cite|Dalibard92|Camichael93>, we present a 3D
  semiclassical simulation for magnetically trapped <with|font-family|rm|H>.

  The proposed cooling scheme involves repeated pulsed excitations, each
  followed by spontaneous decay<nbsp><cite|metcalf2>. The propagation
  direction of the 2-photon excitation pulses alternates between
  <math|\<pm\><wide|x|^>>. The Rabi frequency
  <math|\<Omega\><rsub|g*e><around|(|x,t|)>> is
  <math|<around|(|\<theta\>/\<tau\>|)>*f*<around|(|t/\<tau\>|)>*e<rsup|\<pm\>i*k<rsub|g*e>*x>>,
  where <math|\<theta\>> is the pulse area, <math|k<rsub|g*e>> is the sum of
  the wavevectors of the two photons, and <math|f*<around|(|t/\<tau\>|)>> is
  a normalized pulse-shape function with characteristic duration
  <math|\<tau\>>. For <math|\<theta\>\<ll\>1> its Fourier transform
  <math|F*<around|(|\<omega\>*\<tau\>|)>> gives the excitation spectrum. The
  interval <math|T<rsub|<math-up|rep>>> between pulses is long enough so that
  excited atoms, moving in the <math|<around|\||e|\<rangle\>>-<around|\||e<rprime|'>|\<rangle\>>>
  lattice, decay to <math|<around|\||g|\<rangle\>>> with high probability. In
  the effective 2-level system (Fig.<nbsp><reference|figScheme>b), the
  spatially dependent detuning <math|\<delta\><around|(|x|)>> and linewidth
  <math|\<Gamma\><around|(|x|)>> (see Eq.<nbsp>(<reference|eq>)) allows
  spatial selectivity in both pulsed excitation and subsequent decay. The
  <math|<around|\||e|\<rangle\>>-<around|\||e<rprime|'>|\<rangle\>>>
  transition is driven by a standing wave coupling
  <math|\<Omega\><rsub|e*e<rprime|'>><around|(|x|)>> with a positive detuning
  <math|\<Delta\>>, resulting in two dressed states
  <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>> and
  <math|<around|\||<wide|e|~><rprime|'><around|(|x|)>|\<rangle\>>> which are
  spatially dependent superpositions of <math|<around|\||e|\<rangle\>>> and
  <math|<around|\||e<rprime|'>|\<rangle\>>> and connect to those states
  respectively as <math|\<Omega\><rsub|e*e<rprime|'>>\<rightarrow\>0>. The
  2-photon <math|<around|\||g|\<rangle\>>-<around|\||e|\<rangle\>>> detuning
  from the unshifted metastable state <math|<around|\||e|\<rangle\>>> (decay
  rate <math|\<gamma\><rsub|e*g>\<approx\>0>) is <math|\<delta\><rsub|0>>,
  and <math|\<gamma\><rsub|e<rprime|'>*g>,\<gamma\><rsub|e<rprime|'>*e>> are
  the decay rates from <math|<around|\||e<rprime|'>|\<rangle\>>>
  (Fig.<nbsp><reference|figScheme>a). We assume
  <math|\<Delta\>\<gg\>\<delta\><rsub|0>,\<gamma\><rsub|e<rprime|'>*g>> and
  <math|\<gamma\><rsub|e<rprime|'>*g>\<gg\>\<gamma\><rsub|e<rprime|'>*e>>.
  Atoms are predominantly excited to, and adiabatically follow, the dressed
  state <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>> (and not
  <math|<around|\||<wide|e|~><rprime|'><around|(|x|)>|\<rangle\>>>)<nbsp><cite|exp:foot1>,
  and

  <\equation>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|\<delta\><around|(|x|)>=\<delta\><rsub|0>-<around|(|<sqrt|\<Omega\><rsub|e*e<rprime|'>><around|(|x|)><rsup|2>+\<Delta\><rsup|2>>-\<Delta\>|)>/2,>>|<row|<cell|\<Gamma\><around|(|x|)>=<frac|\<delta\><rsub|0>-\<delta\><around|(|x|)>|<sqrt|\<Omega\><rsub|e*e<rprime|'>><around|(|x|)><rsup|2>+\<Delta\><rsup|2>>>*\<gamma\><rsub|e<rprime|'>*g>.>>>>><label|eq>
  </equation>

  In Eq.<nbsp>(<reference|eq>) we have ignored
  <math|\<gamma\><rsub|e<rprime|'>*e>> and <math|\<gamma\><rsub|e*g>>, but
  their inclusion has little influence on the results described below. The
  depth <math|U> of the resulting <math|<around|\||e|\<rangle\>>-<around|\||e<rprime|'>|\<rangle\>>>
  optical lattice is given by the maximum of
  <math|\<delta\><rsub|0>-\<delta\><around|(|x|)>>, and its period is
  determined by <math|k<rsub|e*e<rprime|'>>>. We define <math|k<rsub|i*j>> as
  the wavevector of the <math|i-j> transition for <math|i,j=g,e,e<rprime|'>>,
  with the associated recoil velocities and frequencies defined as
  <math|v<rsub|i*j>=\<hbar\>*k<rsub|i*j>/m> and
  <math|\<omega\><rsub|r,i*j>=\<hbar\>*k<rsub|i*j><rsup|2>/<around|(|2*m|)>>
  where <math|m> is the atomic mass.

  Doppler-sensitive <math|<around|\||g|\<rangle\>>-<around|\||e|\<rangle\>>>
  absorption leads to 2-photon Doppler cooling<nbsp><cite|Allegrini93|Zehnle01|ultrafast06>.
  The Doppler shifted, spatially dependent detuning,
  <math|\<delta\><around|(|x,v|)>=\<delta\><around|(|x|)>\<pm\>k<rsub|g*e>*v>,
  allows atoms at different velocities to be excited to the lattice potential
  at different locations. Atoms with velocity <math|v> are resonantly excited
  at positions such that <math|<around|\||\<delta\><around|(|x,v|)>|\|>*\<tau\>\<lesssim\>1>.
  For <math|\<tau\>\<gtr\>2*\<pi\>/<around|\||\<delta\><rsub|0>|\|>>, strong
  excitation only occurs in the velocity range
  <math|v<rsub|d>\<less\><around|\||v|\|>\<less\>v<rsub|c>>, with decoupling
  velocity <math|v<rsub|d>\<simeq\><around|\||\<delta\><rsub|0>|\|>/k<rsub|g*e>>
  and capture velocity <math|v<rsub|c>\<simeq\><around|(|<around|\||\<delta\><rsub|0>|\|>+U/\<hbar\>|)>/k<rsub|g*e>>.
  Atoms with <math|<around|\||v|\|>\<ll\>v<rsub|d>> or
  <math|<around|\||v|\|>\<gg\>v<rsub|c>> are off resonance and not
  efficiently excited.

  In addition to Doppler cooling, the correlation between the spatially
  dependent detuning <math|\<delta\><around|(|x|)>> and the decay rate
  <math|\<Gamma\><around|(|x|)>> leads to Sisyphus cooling since atoms
  preferentially decay from <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>>
  at the tops of the light shift potential<nbsp><cite|aspect86>. The Sisyphus
  effect is particularly efficient for atoms with <math|v> close to
  <math|v<rsub|d>>, which are excited near the bottom of the lattice. If
  <math|<frac|1|2>*m*v<rsup|2>\<less\>U>, atoms remain within one lattice
  site and typically oscillate before decaying to
  <math|<around|\||g|\<rangle\>>>. The decay is enhanced at the classical
  turning point, due to both the larger decay rate and the longer time spent
  there. Averaged over the position (and velocity) dependent decay
  probability, the velocity distribution after decay is centered at zero
  velocity, with a rms width less than <math|<frac|1|2>*v> for
  <math|v\<gg\>v<rsub|g*e>>. On average this removes more than 75<math|%> of
  the atomic kinetic energy per 2-photon excitation.

  <big-figure|<image|obe.eps|2.8 in|||><label|figOBE> |OBE simulation of
  cooling properties. (a,d): Normalized excitation probability
  <math|p<rsub|e>> vs <math|<wide|x|\<bar\>><rsub|0>=k<rsub|e*e<rprime|'>>*x<rsub|0>/\<pi\>>
  and <math|<wide|v|\<bar\>>=v/v<rsub|g*e>>. (b,e): Normalized energy loss
  per pulse <math|\<varepsilon\>> vs <math|<wide|v|\<bar\>>>.
  <math|\<varepsilon\>> is averaged over <math|x<rsub|0>> and is in units of
  <math|\<hbar\>*\<omega\><rsub|r,g*e>>. (c,f): Ratio of
  <math|\<varepsilon\>> to the normalized ionization probability,
  <math|\<varepsilon\>/p<rsub|i>> vs <math|<wide|v|\<bar\>>>. Here
  <math|\<delta\><rsub|0>=-25*\<omega\><rsub|r,g*e>>,
  <math|\<tau\>=-2.5/\<delta\><rsub|0>>, <math|f<around|(|t|)>=<frac|1|<sqrt|\<pi\>>>*e<rsup|-t<rsup|2>>>,
  <math|\<theta\>=\<pi\>/8>, <math|\<Omega\><rsub|e*e<rprime|'>><around|(|x|)>=\<Omega\><rsub|e*e<rprime|'>>*sin
  <around|(|k<rsub|e*e<rprime|'>>*x|)>>, <math|\<Delta\>=\<Omega\><rsub|e*e<rprime|'>>/2=200<nbsp>\<omega\><rsub|r,g*e>>,
  and <math|\<gamma\><rsub|e<rprime|'>*g>=8*\<gamma\><rsub|e<rprime|'>*e>=2*\<omega\><rsub|r,g*e>>.
  The red curves in (b,c,e,f) correspond to
  <math|\<Omega\><rsub|e*e<rprime|'>>=0>. The left and right panels are for
  <math|k<rsub|g*e>/k<rsub|e*e<rprime|'>>>=25 and 5.4 respectively. >

  To characterize the cooling, we define the normalized position and velocity
  dependent excitation probabilities <math|p<rsub|e>=4*P<rsub|e>/\<theta\><rsup|2>>
  and energy loss per 2-photon pulse <math|\<varepsilon\>=4*\<Delta\>*E/\<theta\><rsup|2>>,
  where <math|P<rsub|e>> is the 2-photon excitation probability,
  <math|\<Delta\>*E> is the energy loss per 2-photon pulse and
  <math|p<rsub|e>> and <math|\<varepsilon\>> are <math|\<theta\>>-independent
  for <math|\<theta\>\<ll\>1>. Figure 2(a,b,d,e) shows <math|p<rsub|e>> and
  <math|\<varepsilon\>>, determined using 3-level optical Bloch equations
  (OBE) for a \Pdragged atom\Q following a trajectory
  <math|x<around|(|t|)>=x<rsub|0>+v*t>. Figure<nbsp><reference|figOBE>(a, b)
  and Fig.<nbsp><reference|figOBE>(d, e) are for
  <math|k<rsub|g*e>/k<rsub|e*e<rprime|'>>=25> and 5.4 respectively. The
  latter ratio corresponds to <math|k<rsub|<math-up|1S-2S>>/k<rsub|<math-up|2S-3P>>>
  in hydrogen. Figure<nbsp><reference|figOBE> suggests that the simple
  picture of phase-space selective excitation plus Sisyphus cooling only
  applies for <math|k<rsub|e*e<rprime|'>>\<ll\>k<rsub|g*e>,<around|(|v*\<tau\>|)><rsup|-1>>,
  as in Fig.<nbsp><reference|figOBE>(a,b). For atoms that move more than
  <math|1/k<rsub|e*e<rprime|'>>> during <math|\<tau\>>, the excitation is
  complicated by multi-photon resonances at velocities with
  <math|k<rsub|g*e>*v+2*n*k<rsub|e*e<rprime|'>>*v\<approx\>\<delta\>> (the
  peaks of the black curve in Fig.<nbsp><reference|figOBE>e for
  <math|<wide|v|\<bar\>>\<gtr\>20>)<nbsp><cite|multiphoton09>. In addition,
  for large <math|k<rsub|e*e<rprime|'>>>, Doppleron resonant coupling to
  <math|<around|\||<wide|e|~><rprime|'><around|(|x|)>|\<rangle\>>><nbsp><cite|Doppleron90>
  occurs at moderate speeds <math|v> with
  <math|2*n*k<rsub|e*e<rprime|'>>*v\<approx\>\<Delta\>> for integer <math|n>
  (the sharp dips of the black curve in Fig.<nbsp><reference|figOBE>e near
  <math|<wide|v|\<bar\>>=70,<nbsp>80>), and leads to heating. Nevertheless,
  efficient Sisyphus cooling is still possible for moderate
  <math|k<rsub|g*e>/k<rsub|e*e<rprime|'>>> (see
  Fig.<nbsp><reference|figOBE>e). Compared to regular 2-photon cooling (red
  curves in Fig.<nbsp><reference|figOBE>(b,e)), the peak excitation
  probability is decreased by approximately
  <math|<frac|2*\<pi\>|\<tau\>>/<frac|U|\<hbar\>>> due to the spatially
  inhomogeneous broadening of <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>>
  (Fig.<nbsp><reference|figScheme>b). However, due to the Sisyphus enhanced
  energy removal per excitation, the average energy loss per pulse remains
  comparable to the Doppler-only case, but with an increased velocity capture
  range <math|v<rsub|d>\<less\><around|\||v|\|>\<less\>v<rsub|c>>.

  In addition to the increased velocity capture range, the decreased
  excitation probability to <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>>
  also helps mitigate the photonionization loss from
  <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>> to the continuum.
  For degenerate 2-photon excitation of H to the 2S level, the ionization
  probability per pulse is given by <math|P<rsub|<math-up|ioni>>=<big|int>d*t*\<gamma\><rsub|<math-up|ioni>><around|(|t|)>*\<rho\><rsub|<math-up|2S>><around|(|t|)>>
  where <math|\<rho\><rsub|<math-up|2S>><around|(|t|)>> is the 2S state
  population and <math|\<gamma\><rsub|<math-up|ioni>>> is the rate of
  ionization from 2S due to the UV radiation<nbsp><cite|Haas06>. As a measure
  of cooling efficiency per 2-photon pulse, in
  Fig.<nbsp><reference|figOBE>(c,f) we compare
  <math|\<varepsilon\>/p<rsub|i>>, the ratio between the normalized energy
  loss <math|\<varepsilon\>> and normalized ionization probability
  <math|p<rsub|i>=12*P<rsub|<math-up|ioni>>/\<theta\><rsup|3>>, with (black
  curve) and without (red curve) the Sisyphus cooling. Here we have set
  <math|\<gamma\><rsub|<math-up|ioni>>=1.6*\<Omega\><rsub|g*e>><nbsp><cite|Haas06>.
  We see that the Sisyphus effect enhances the cooling efficiency by
  approximately <math|U/<around|\||\<hbar\>*\<delta\><rsub|0>|\|>> near
  <math|v=v<rsub|d>> where the Doppler cooling has the best
  <math|\<varepsilon\>/p<rsub|i>>.

  We simulate the cooling process with a semiclassical stochastic
  wavefunction (SCSW) method<nbsp><cite|Dalibard92|Camichael93>. The
  simulation of a cooling cycle is divided into two stages: excitation
  (<math|0\<less\>t\<less\>\<tau\>>) and decay
  (<math|\<tau\>\<less\>t\<less\>T<rsub|<math-up|rep>>>) (we ignore quantum
  jumps during excitation). The external motion of the atom is described by a
  classical trajectory <math|x<around|(|t|)>>. The internal dynamics are
  described by a stochastic wavefunction <math|<around|\||\<psi\><around|(|t|)>|\<rangle\>>>,
  which, after the <math|g-e> pulse, is probabilistically projected to either
  <math|<around|\||g|\<rangle\>>> or the <math|<around|{|\|e|\<rangle\>>,<around|\||e<rprime|'>|\<rangle\>>}>
  manifold (typically almost all in <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>>)
  as <math|<around|\||\<psi\><rsub|p>|\<rangle\>>>. Due to this
  post-selection, the optical force in the excitation stage cannot be
  evaluated in the usual way as <math|<around|\<langle\>|\<psi\><around|(|t|)><around|\||<wide|F|^>|\|>*\<psi\><around|(|t|)>|\<rangle\>>>
  where <math|<wide|F|^>> is the force operator. Instead, the force is
  estimated as the real part of a \Pweak value\Q<nbsp><cite|Aharonov88>,
  <math|<around|\<langle\>|\<psi\><rsub|p><around|(|t|)><around|\||<wide|F|^>|\|>*\<psi\><around|(|t|)>|\<rangle\>>/<around|\<langle\>|\<psi\><rsub|p><around|(|t|)>\|\<psi\><around|(|t|)>|\<rangle\>>>,
  where <math|<around|\||\<psi\><around|(|t|)>|\<rangle\>>> is found by
  forward-propagating the pre-determined state
  <math|<around|\||\<psi\><around|(|0|)>|\<rangle\>>=<around|\||g|\<rangle\>>>
  and <math|<around|\<langle\>|\<psi\><rsub|p><around|(|t|)>|\|>> is found by
  back-propagating the post-determined state
  <math|<around|\<langle\>|\<psi\><rsub|p><around|(|\<tau\>|)>|\|>>, both for
  a dragged atom. This estimation method reproduces the quantum-mechanically
  expected velocity change during the pulse,
  <math|\<delta\>*v<rsub|<math-up|pulse>>>, due to both the recoil effect and
  the excited-state dipole force. During the second stage, the stochastic
  wavefunction <math|<around|\||\<psi\><rsub|p><around|(|t|)>|\<rangle\>>\<in\><around|{|\|e|\<rangle\>>,<around|\||e<rprime|'>|\<rangle\>>}>
  manifold and <math|x<around|(|t|)>> are propagated in small time-steps,
  until a quantum jump occurs<nbsp><cite|Dalibard92|Camichael93>. If the
  quantum jump is an <math|<around|\||e<rprime|'>|\<rangle\>>\<rightarrow\><around|\||e|\<rangle\>>>
  transition, we project <math|<around|\||\<psi\><rsub|p><around|(|t|)>|\<rangle\>>>
  to the dressed states <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>>
  or <math|<around|\||<wide|e|~><rprime|'><around|(|x|)>|\<rangle\>>>
  probabilistically<nbsp><cite|ChenJian93>, while for an
  <math|<around|\||e<rprime|'>|\<rangle\>>\<rightarrow\><around|\||g|\<rangle\>>>
  jump, we propagate <math|x<around|(|t|)>> freely until the next pulse. Upon
  each spontaneous emission, we use random velocity jumps to account for the
  recoil effect.

  <big-figure|<image|CQ.eps|3. in|||><label|FigCQ> |Comparison of 1D SCSW and
  QSW simulations. Here <math|\<Omega\><rsub|e*e<rprime|'>>/<around|(|4*\<pi\>|)>=\<Delta\>/<around|(|2*\<pi\>|)>>=2.7
  GHz as in Fig.<nbsp><reference|figOBE>,
  <math|\<delta\><rsub|0>=-2*\<pi\>/\<tau\>>, <math|\<theta\>=\<pi\>/4>. (a):
  Average speed <math|<around|\<langle\>|<around|\||v|\|>|\<rangle\>>> vs
  pulse number for three different pulse durations <math|\<tau\>>. 4<nbsp>ns
  represents a compromise between 1<nbsp>ns, where the bandwidth is so large
  that there is little spatial selectivity, and 7<nbsp>ns, where the
  bandwidth is so small that only a small fraction of atoms are excited.
  Thick lines are an average of 30 QSW trajectories, while thin lines are an
  average of 20 SCSW trajectories. (b): The equilibrium temperature
  <math-up|T> vs pulse duration <math|\<tau\>>. At small velocities the SCSW
  method becomes less accurate for <math|\<tau\>\<gtr\>9><nbsp>ns, roughly
  set by half the oscillation period in a single
  <math|<around|\||e|\<rangle\>>-<around|\||e<rprime|'>|\<rangle\>>> lattice
  site. >

  We use a 1D full quantum stochastic wavefunction (QSW)
  simulation<nbsp><cite|Dalibard92|Camichael93>, which includes both internal
  and external degrees of freedom of a 3-level atom, to confirm that the SCSW
  method correctly predicts the cooling dynamics and the final temperature.
  In Fig.<nbsp><reference|FigCQ> typical results for smoothed square
  pulses<nbsp><cite|exp:foot5> are compared, for the appropriate hydrogen
  1S-2S-3P parameters, <math|\<gamma\><rsub|e<rprime|'>*g>/<around|(|2*\<pi\>|)>=26.6><nbsp>MHz,
  <math|\<gamma\><rsub|e<rprime|'>*e>/<around|(|2*\<pi\>|)>=3.6><nbsp>MHz,
  <math|<around|{|v<rsub|g*e>,v<rsub|e*e<rprime|'>>,v<rsub|g*e<rprime|'>>|}>=<around|{|3.3,0.6,3.9|}>><nbsp>m/s,
  and <math|<around|{|\<omega\><rsub|r,g*e>,\<omega\><rsub|r,e*e<rprime|'>>,\<omega\><rsub|r,g*e<rprime|'>>|}>/<around|(|2*\<pi\>|)>=<around|{|13.4,0.46,18.8|}>><nbsp>MHz,
  which are also used in Fig.<nbsp><reference|figOBE>(d-f). We find good
  agreement between the SCSW and QSW methods as long as the dragged atom
  picture is valid during the pulse, i.e., if the optical force during the
  short excitation does not significantly displace the trajectory compared to
  the wavelength (<math|k<rsub|e*e<rprime|'>><nbsp>\<delta\>*v<rsub|<math-up|pulse>><nbsp>\<tau\>\<ll\>1>)(Fig.<nbsp><reference|FigCQ>b).
  The attainable 1D temperature predicted by the quantum simulation decreases
  with decreasing bandwidth <math|1/\<tau\>>, and is remarkably low
  (<math|\<sim\>>3 mK) even with <math|\<tau\>=5><nbsp>ns.

  Having verified the semiclassical approach for our parameters, we use SCSW
  to simulate 3D cooling of magnetically trapped H. To describe the 3D
  light-atom interaction, we included all ten electronic levels in the
  1S-2S-3P manifold (ignoring hyperfine structure). In a high magnetic field,
  the cooling process is dominated by the three maximally Zeeman-shifted
  states of the 1S, 2S and 3P levels (corresponding to
  <math|<around|\||g|\<rangle\>>>, <math|<around|\||e|\<rangle\>>> and
  <math|<around|\||e<rprime|'>|\<rangle\>>>), which would form a closed
  system under 1S-2S 2-photon coupling <math|\<Omega\><rsub|g*e>> and perfect
  <math|\<sigma\><rsup|+>> 2S-3P coupling
  <math|\<Omega\><rsub|e*e<rprime|'>>>. We consider a magnetic trap with
  <math|<with|font-series|bold|B>=<around|{|B<rsub|x>,B<rsub|y>,B<rsub|z>|}>=<around|{|B<rsub|1>*y-B<rsub|2>*z*x/2,B<rsub|1>*x-B<rsub|2>*z*y/2,B<rsub|0>+B<rsub|2>*<around|(|2*z<rsup|2>-x<rsup|2>-y<rsup|2>|)>/4|}>>,
  <math|B<rsub|0>=0.75><nbsp>T, <math|B<rsub|1>>=0.8<nbsp>T/cm and
  <math|B<rsub|2>=12><nbsp>mT/cm<rsup|<math|2>>, similar to those for an
  existing antihydrogen apparatus<nbsp><cite|penningtrap>. Both
  <math|<around|\||g|\<rangle\>>> and <math|<around|\||e|\<rangle\>>> feel a
  trapping potential <math|V\<approx\>\<mu\><rsub|<math-up|B>><around|\||<with|font-series|bold|B>|\|>>
  (<math|\<mu\><rsub|<math-up|B>>> is the Bohr magneton), so the
  <math|<around|\||g|\<rangle\>>-<around|\||e|\<rangle\>>> detuning
  <math|\<delta\><rsub|0>> is nearly free from Zeeman
  shifts<nbsp><cite|Cesar96>. The <math|<around|\||e|\<rangle\>>-<around|\||e<rprime|'>|\<rangle\>>>
  detuning <math|\<Delta\><around|(|B|)>\<approx\>\<Delta\>-\<mu\><rsub|<math-up|B>>*B/\<hbar\>>,
  on the other hand, is field-sensitive and has a position-dependent shift.

  We consider a 2S-3P lattice composed of three pairs of standing wave
  Gaussian beams, each with <math|1/e<rsup|2>> diameter <math|d>, arranged
  symmetrically with equal intersection angles <math|\<alpha\>> to
  <math|<wide|z|^>>. The choice of relative phases between standing waves is
  not critical to the cooling scheme. The beams are circularly polarized to
  maximize the <math|\<sigma\><rsup|+>> components (relative to
  <math|<wide|B|^>>). In the Paschen-Back regime considered here, with
  <math|\<mu\><rsub|<math-up|B>>*B\<gg\>\<hbar\>*\<Delta\><rsub|<math-up|3P,
  fine>>> (<math|\<Delta\><rsub|<math-up|3P,
  fine>>/<around|(|2*\<pi\>|)>=3.25><nbsp>GHz), the <math|\<pi\>> coupling
  induces spin flip losses after 2S excitation with a branching ratio of
  <math|r<rsub|<math-up|sf>>=<frac|2|9>*\<Delta\><rsub|<math-up|3P,
  fine>><rsup|2>/<around|(|\<Delta\>+\<mu\><rsub|<math-up|B>>*B/\<hbar\>|)><rsup|2>>
  (similar for <math|\<sigma\><rsup|->> coupling). Even for 2S-3P light that
  is purely <math|\<pi\>> or <math|\<sigma\><rsup|->> polarized, the
  spin-flip probability per 2S excitation is still less than <math|0.3%> in a
  field of 1<nbsp>T.

  <big-figure|<image|trapsimu2.eps|3.4 in|||><label|figSetup> |Evolution of
  atomic velocity (a) and position (b) for a typical classical trajectory
  during the simulated cooling of magnetically trapped H. The insets give the
  quasi-equilibrium distributions.>

  Figure<nbsp><reference|figSetup> plots a typical classical trajectory of H
  during cooling. The simulation starts with H in
  <math|<around|\||g|\<rangle\>>> at the trap bottom (<math|B=0.75><nbsp>T),
  with initial longitudinal (<math|z>) and transverse (<math|x,y>) kinetic
  energy of <math|E<rsub|l>=0.5><nbsp>K and <math|E<rsub|t>=>0.25<nbsp>K
  respectively. The 2-photon excitation beam overlaps with the 2S-3P beams in
  a 12<nbsp>cm long and 1.8 cm wide cooling zone, approximately covering the
  trap up to the 0.2<nbsp>K equipotential surface<nbsp><cite|exp:foot4>. We
  choose <math|d=3><nbsp>cm and <math|\<alpha\>=0.1> for the 2S-3P beams,
  with peak intensity of 0.46<nbsp>kW/cm<rsup|<math|2>> per beam
  corresponding to <math|\<Omega\><rsub|e*e<rprime|'>>/<around|(|2*\<pi\>|)>=>1.3<nbsp>GHz.
  <math|\<Delta\><around|(|0.75<math-up|T>|)>/<around|(|2*\<pi\>|)>=5.3><nbsp>GHz
  is chosen so that <math|\<Delta\><around|(|B|)>\<gg\>\<gamma\><rsub|e<rprime|'>*g>>
  within the cooling zone. In a flatter octopole
  trap<nbsp><cite|octupoletrap> the detuning constraint is reduced, allowing
  for a reduced <math|\<Omega\><rsub|e*e<rprime|'>>> and less 656<nbsp>nm
  power. The total power requirements can also be lessened with a moderate
  finesse optical cavity. We choose <math|\<theta\>=\<pi\>/8>,
  <math|\<tau\>=4><nbsp>ns and <math|T<rsub|<math-up|rep>>=2><nbsp><math|\<mu\>>s<nbsp><cite|exp:foot7>.
  The 2-photon detuning <math|\<delta\><rsub|0>=-\<pi\>/\<tau\>> is chosen to
  improve the scattering rate for longitudinally cold atoms that are
  transversely hot.

  The rapid cooling trajectory shown in Fig.<nbsp><reference|figSetup> is
  typical for atoms with <math|E<rsub|l>\<less\>0.5><nbsp>K and
  <math|E<rsub|t>\<less\>0.25><nbsp>K, which are cooled to quasi-equilibrium
  within <math|N<rsub|<math-up|total>>=4\<times\>10<rsup|4>> pulses during a
  cooling time of only 80 ms. While some atoms with <math|E<rsub|t>>
  significantly larger than 0.2<nbsp>K may orbit around the cooling zone and
  not be efficiently cooled, the final velocity distribution for most atoms
  is remarkably isotropic with <math|5><nbsp>m/s width
  (Fig.<nbsp><reference|figSetup>a inset), which can be further reduced by
  increasing <math|\<tau\>> (Fig.<nbsp><reference|FigCQ>b). The total
  spin-flip loss is found to be less than <math|0.1%>. As with other hydrogen
  cooling proposals<nbsp><cite|Allegrini93|Zehnle01|ultrafast06>, one must
  consider limitations imposed by photoionization losses. We perturbatively
  calculate photoionization from state populations determined by internal
  state dynamics that ignore photoionization. For a reasonable two-color
  2-photon excitation scheme where the stronger laser beam cannot ionize H
  from the 2S state in a single step<nbsp><cite|Yatsenko99>, we found
  ionization losses less than 25<math|%><nbsp><cite|exp:foot3>. Even if
  243<nbsp>nm radiation is used for the 1S-2S excitation<nbsp><cite|Haas06>,
  photoionization loss would still be less than 25<math|%> for cooling, by
  applying <math|N<rsub|<math-up|total>>=10<rsup|9>>,
  <math|\<theta\>=2.5><nbsp>mrad pulses<nbsp><cite|exp:foot8> in
  <math|2000><nbsp>s.

  We have proposed and analyzed a pulsed Sisyphus laser cooling scheme
  applicable to magnetically trapped H or <math|<wide|<math-up|H>|\<bar\>>>.
  The approach leads to rapid 3D cooling to <math|\<less\>>10<nbsp>mK in a
  magnetic trap over a large volume with small spin-flip losses. Approaches
  to reduce photoionization losses to practical levels are proposed. Cooling
  efficiency may be further improved by exploring the spatial-temporal
  control of both the 2-photon excitation and the excited state lattice. This
  excited-state Sisyphus method may open new possibilities for cooling of
  deuterium, tritium or other species with metastable states.

  <\acknowledgments*>
    We would like to thank Amy Cassidy, Gretchen Campbell, and Jonathan
    Wrubel for helpful discussions.
  </acknowledgments*>

  <\thebibliography|99>
    <bibitem|octupoletrap>G.<nbsp>B.<nbsp>Andresen <with|font-shape|italic|et
    al>, Nature <with|font-series|bold|468>, 673 (2010).

    <bibitem|cusptrap>Y.<nbsp>Enomoto <with|font-shape|italic|et al>, Phys.
    Rev. Lett. <with|font-series|bold|105>, 243401 (2010).

    <bibitem|athena>M.<nbsp>Amoretti <with|font-shape|italic|et al>, Nature
    <with|font-series|bold|419>, 456 (2002).

    <bibitem|atrap>G. Gabrielse <with|font-shape|italic|et al>, Phys. Rev.
    Lett. <with|font-series|bold|89>, 213401 (2002).

    <bibitem|penningtrap>G. Gabrielse <with|font-shape|italic|et al>, Phys.
    Rev. Lett. <with|font-series|bold|100>, 113001 (2008).

    <bibitem|buffergas05>R.<nbsp>deCarvalho <with|font-shape|italic|et al>,
    Can. J. Phys. <with|font-series|bold|83>, 293 (2005).

    <bibitem|metcalf><with|font-shape|italic|Laser Cooling and Trapping>,
    H.<nbsp>Metcalf and P.<nbsp>van der<nbsp>Straten (Springer-Verlag, 1999).

    <bibitem|Setija93>I.<nbsp>Setija <with|font-shape|italic|et al>, Phys.
    Rev. Lett. <with|font-series|bold|70>, 2257 (1993).

    <bibitem|Scheid09>M.<nbsp>Scheid <with|font-shape|italic|et al>, Optics
    Express <with|font-series|bold|17>, 11274 (2009).

    <bibitem|Allegrini93>M.<nbsp>Allegrini <with|font-shape|italic|et al>,
    Phys. Lett. A <with|font-series|bold|172>, 271 (1993).

    <bibitem|Zehnle01>V.<nbsp>Zehnle <with|font-shape|italic|et al>, Phys.
    Rev. A <with|font-series|bold|63>, 021402 (2001).

    <bibitem|ultrafast06>D.<nbsp>Kielpinski, Phys. Rev. A
    <with|font-series|bold|73>, 063407 (2006).

    <bibitem|multiphoton09>S.<nbsp>Wu <with|font-shape|italic|et al>, Phys.
    Rev. Lett. <with|font-series|bold|103>, 173003 (2009).

    <bibitem|aspect86>A.<nbsp>Aspect <with|font-shape|italic|et al>, Phys.
    Rev. Lett. <with|font-series|bold|57>, 1688 (1986).

    <bibitem|Yatsenko99>A two-color excitation scheme is proposed by
    L.<nbsp>Yatsenko <with|font-shape|italic|et al> in Phys. Rev. A
    <with|font-series|bold|60>, 4237 (1999). Also see T.<nbsp>Kanai
    <with|font-shape|italic|et al>, Opt. Exp. <with|font-series|bold|17>,
    8696 (2009) for wavelength conversions.

    <bibitem|Dalibard92>J.<nbsp>Dalibard <with|font-shape|italic|et al>,
    Phys. Rev. Lett. <with|font-series|bold|68>, 580 (1992).

    <bibitem|Camichael93>H.<nbsp>J.<nbsp>Carmichael, Lecture Notes in
    Physics, Vol. m18 (Springer, Berlin, 1993).

    <bibitem|metcalf2>T.<nbsp>Breeden <with|font-shape|italic|et al>, Phys.
    Rev. Lett. <with|font-series|bold|47>, 1726 (1981).

    <bibitem|exp:foot1>For atom moving with velocity <math|v>, the adiabatic
    following requires <math|<around|\<langle\>|<wide|e|~><around|(|x|)>*<around|\||v*\<partial\><rsub|x>|\|>*<wide|e|~><around|(|x|)>|\<rangle\>>>
    <math|\<approx\>k<rsub|e*e<rprime|'>>*v*<frac|\<Omega\><rsub|e*e<rprime|'>>|\<Delta\>>\<ll\>\<Delta\>>.
    The excitation predominantly to <math|<around|\||<wide|e|~><around|(|x|)>|\<rangle\>>>
    requires <math|k<rsub|g*e>*v\<ll\>\<Delta\>>.

    <bibitem|Doppleron90>J.<nbsp>J.<nbsp>Tollett <with|font-shape|italic|et
    al>, Phys. Rev. Lett. <with|font-series|bold|65>, 559 (1990).

    <bibitem|Haas06>M.<nbsp>Haas <with|font-shape|italic|et al>, Phys. Rev. A
    <with|font-series|bold|73>, 052501 (2006).

    <bibitem|Aharonov88>Y.<nbsp>Aharonov <with|font-shape|italic|et al>,
    Phys. Rev. Lett. <with|font-series|bold|60>, 1351 (1988).

    <bibitem|ChenJian93>J.<nbsp>Chen <with|font-shape|italic|et al>, Phys.
    Rev. A <with|font-series|bold|47>, 2128 (1993).

    <bibitem|exp:foot5>Rising/falling edges are smoothed by sine functions
    over <math|20%> of the pulse duration.

    <bibitem|Cesar96>C.<nbsp>L.<nbsp>Cesar <with|font-shape|italic|et al>,
    Phys. Rev. Lett. <with|font-series|bold|77>, 255 (1996).

    <bibitem|exp:foot4>To avoid excitation outside the cooling zone, one can
    overlap two excitation beams with distinct frequencies of
    <math|\<omega\><rsub|1>> and <math|\<omega\><rsub|2>=\<omega\><rsub|<math-up|2S>>-\<omega\><rsub|1>>
    respectively, where <math|\<omega\><rsub|<math-up|2S>>> is the frequency
    of the 1S-2S transition. Also see ref.<nbsp><cite|Yatsenko99>.

    <bibitem|exp:foot7>To allow slowest atoms confined by the
    <math|<around|\||e|\<rangle\>>-<around|\||e<rprime|'>|\<rangle\>>>
    lattice to decay, the <math|<around|\||e|\<rangle\>>\<rightarrow\><around|\||g|\<rangle\>>>
    decay rate (<math|\<gamma\><rsub|e*g>>) is increased from 0 to 10
    <math|\<mu\>>s<rsup|<math|-1>> for <math|t\<gtr\>1><nbsp><math|\<mu\>>s.
    This can be effectively realized with a broadband
    <math|<around|\||e|\<rangle\>>-<around|\||e<rprime|'>|\<rangle\>>>
    coupling pulse.

    <bibitem|exp:foot3>The 2S-3P radiation also photoionizes H from 3P, which
    in the simulation leads to less than <math|4%> total loss for cooling
    from <math|E<rsub|l>+E<rsub|t>> at 0.75 K. Also see P. Antoine
    <with|font-shape|italic|et al>, J. Phys. B <with|font-series|bold|29>,
    5367 (1996).

    <bibitem|exp:foot8>Reducing the pulse area while increasing the total
    pulse number suppresses the total photoionization loss, as the ionization
    loss <math|\<propto\>\<theta\><rsup|3>> for <math|\<theta\>\<ll\>1>.
  </thebibliography>
</body>