<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <\hide-preamble>
    <assign|sfrac|<macro|1|2|<with|math-display|false|<frac|<arg|1>|<arg|2>>>>>

    <assign|nn|<macro|<tformat|<table|<row|<cell|<no-number>>|<cell|>|<cell|>>|<row|<cell|>|<cell|>|<cell|>>>>>>

    <assign|NNN|<macro|<math|N*<space|-0.17em>N*<space|-0.17em>N>>>

    <assign|NNNNNN|<macro|<math|N*<space|-0.17em>N*<space|-0.17em>N\<rightarrow\>N*<space|-0.17em>N*<space|-0.17em>N>>>

    <assign|bk|<macro|<wide|k|\<bar\>>>>

    <assign|bq|<macro|<wide|q|\<bar\>>>>

    <assign|bp|<macro|<wide|p|\<bar\>>>>

    <assign|bu|<macro|<wide|u|\<bar\>>>>

    <assign|tPhi|<macro|<wide|\<Phi\>|~>>>

    <assign|tphi|<macro|<wide|\<phi\>|~>>>

    <assign|tX|<macro|<wide|X|~>>>

    <assign|tY|<macro|<wide|Y|~>>>

    <assign|tT|<macro|<wide|T|~>>>

    <assign|tv|<macro|<wide|v|~>>>

    <assign|ttt|<macro|<wide|t|~>>>

    <assign|td|<macro|<wide|d|~>>>

    <assign|tj|<macro|<wide|j|~>>>

    <assign|tG|<macro|<wide|G|~>>>

    <assign|la|<macro|\<langle\>>>

    <assign|ra|<macro|\<rangle\>>>

    <assign|bfr|<macro|<with|font-series|bold|r>>>

    <assign|pslash|<macro|<neg|>-0.7mmp>>

    <assign|ben|<macro|>>

    <assign|een|<macro|>>

    <assign|be|<macro|>>

    <assign|ee|<macro|>>

    <assign|bea|<macro|>>

    <assign|eea|<macro|>>

    <assign|eqn|<macro|1|<label|1>>>

    <assign|eq|<macro|1|Eq.<nbsp>(<reference|1>)>>

    <assign|eqs|<macro|1|Eqs.<nbsp>(<reference|1>)>>

    <assign|fign|<macro|1|<label|1>>>

    <assign|fig|<macro|1|Fig.<nbsp><reference|1>>>

    <assign|bPsi|<macro|<wide|\<Psi\>|\<bar\>>>>

    <assign|bPhi|<macro|<wide|\<Phi\>|\<bar\>>>>

    <assign|bphi|<macro|<wide|\<phi\>|\<bar\>>>>

    <assign|bfp|<macro|<with|font-series|bold|p>>>

    <assign|bfP|<macro|<with|font-series|bold|P>>>

    <assign|bfq|<macro|<with|font-series|bold|q>>>

    <assign|bfk|<macro|<with|font-series|bold|k>>>
  </hide-preamble>

  <doc-data|<doc-title|Natural Resolution of the Proton Size
  Puzzle>|<doc-author|<author-data|<author-name|G.<nbsp>A.<nbsp>Miller,<rsup|<math|1>>
  A.<nbsp>W.<nbsp>Thomas<rsup|<math|2>>, J.<nbsp>D.<nbsp>Carroll<rsup|<math|2>>,
  and J. Rafelski<rsup|<math|3>>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    We show that off-mass-shell effects arising from the internal structure
    of the proton provide a new proton polarization mechanism in the Lamb
    shift, proportional to the lepton mass to the fourth power. This effect
    is capable of resolving the current puzzle regarding the difference in
    the proton radius extracted from muonic compared with electronic
    hydrogen. These off-mass-shell effects could be probed in several other
    experiments.
  </abstract>>

  The recent, extremely precise extraction of the proton
  radius<nbsp><cite|pohl> from the measured energy difference between the
  <math|2*P<rsub|3/2><rsup|F=2>> and <math|2*S<rsub|1/2><rsup|F=1>> states of
  muonic hydrogen (H) has created considerable interest. Their analysis
  yields a proton radius that is smaller than the CODATA<nbsp><cite|codata>
  value (extracted mainly from electronic H) by about 4% or 5.0 standard
  deviations. This implies<nbsp><cite|pohl> that either the Rydberg constant
  has to be shifted by 4.9 standard deviations or that the QED calculations
  for hydrogen are insufficient. Since the Rydberg constant is extremely well
  measured, and the QED calculations seem to be very extensive and highly
  accurate, the muonic H finding presents a significant puzzle to the entire
  physics community.

  Our analysis is motivated by the fact that muonic hydrogen is far smaller
  than electronic hydrogen and therefore more sensitive to corrections
  arising from hadron structure. In particular, we consider the lowest order
  correction associated with off-shell behaviour at the photon-nucleon
  vertex, showing that it can very naturally account for the difference
  reported by Pohl <with|font-shape|italic|et al.>. Since at the present
  state of development of hadronic physics it is not possible to provide a
  precise value for this correction, our result may be viewed as a
  phenomenological study of the sensitivity of muonic hydrogen to important
  aspects of proton structure. It should spur further study of processes
  which could be sensitive to off-shell changes in proton structure. In
  alternate language, the explanation which we present may be viewed as a new
  contribution from proton polarization that is not constrained by dispersion
  relations but which can be studied in systems other than the hydrogen atom.

  We begin with a brief discussion of the relevant phenomenology. Pohl
  <with|font-shape|italic|et al.> show that the energy difference between the
  <math|2*P<rsub|3/2><rsup|F=2>> and <math|2*S<rsub|1/2><rsup|F=1>> states,
  <math|\<Delta\><wide|E|~>> is given by

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|\<Delta\><wide|E|~>=209.9779<around|(|49|)>-5.2262*r<rsub|p><rsup|2>+0.0347*r<rsub|p><rsup|3><space|0.27em><math-up|meV>,<eq-number><label|rad>>>>>>

  where <math|r<rsub|p>> is given in units of fm. Each of the three
  coefficients is obtained from extensive theoretical work that has typically
  been confirmed by several groups. Our study of the relevant
  calculations<nbsp><cite|eides|friar|atomcalcs|zemach|grotchyennie> and
  corresponding efforts to improve those have revealed no variations large
  enough to significantly affect the above equation<nbsp><cite|jent|carroll>.
  Hence, using this equation, we see that the difference between the Pohl and
  CODATA values of the proton radius would be entirely removed by an increase
  of the first term on the rhs of Eq.<nbsp>(1) by just 0.15 meV. Finding a
  new effect of that size and sign would resolve the puzzle provided that the
  corresponding effect in electronic H was no more than a few parts in a
  million (the current difference between theory and
  experiment<nbsp><cite|eides>). An effect that gives a contribution to
  <math|\<Delta\><wide|E|~>> of the form <math|\<alpha\><rsup|5>*<frac|m<rsup|4>|M<rsup|3>>>
  (with <math|m> the lepton mass and <math|M> the proton mass) could
  therefore resolve the proton radius puzzle and cause no disagreement in
  electronic H.

  The search to find such an effect has attracted considerable interest. New
  physics beyond the Standard Model must satisfy a variety of low-energy
  constraints and so far no explanation of the proton radius puzzle has been
  found that satisfies these constraints<nbsp><cite|Barger:2010aj|Jaeckel:2010xx|TuckerSmith:2010ra|jent1|Brax:2010gp>.
  Attention has been paid to the third term of <eq|rad><nbsp><cite|dr>, with
  the result that its current uncertainties are far too small to resolve the
  proton radius puzzle<nbsp><cite|Cloet:2010qa|walcher>.

  <assign|boldsigma|<macro|<with|math-font-series|bold|mode|math|\<sigma\>>>><assign|boldgamma|<macro|<with|math-font-series|bold|mode|math|\<gamma\>>>><assign|boldSigma|<macro|<with|math-font-series|bold|mode|math|\<Sigma\>>>>We
  therefore seek an explanation based on the fact that the proton is not an
  elementary Dirac particle and that many features of its interactions are
  still unknown. In particular, consider the electromagnetic form factor,
  which must depend on all of the relevant invariants. For a proton of
  initial four-momentum <math|p>, the most general expression for the
  electromagnetic form factor must have a term proportional to
  <math|p<rsup|2>-m<rsup|2>>. Such terms have been discussed for a very long
  time in atomic<nbsp><cite|zemach|grotchyennie> and nuclear
  physics<nbsp><cite|tony>-<cite|Ciofi>. They have been of special concern in
  relation to the difference between free and bound deep inelastic structure
  functions measured in the EMC effect<nbsp><cite|emc>, nucleon-nucleon
  scattering and electromagnetic interactions involving
  nucleons<nbsp><cite|bincer|Naus:1987kv>, notably quasi-elastic
  scattering<nbsp><cite|Strauch:2010nm|Paolone:2010qc|Lu:1997mu|Lu:1998tn|Cloet:2009tx>.

  We proceed by writing the Dirac part of the vertex function for a proton of
  momentum <math|p> to absorb a photon of momentum <math|q=p<rprime|'>-p> as:

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|\<Gamma\><rsup|\<mu\>>=\<gamma\><rsub|N><rsup|\<mu\>>*F<rsub|1>(-q<rsup|2>)<around*|[|1+\<lambda\>*F|(>-q<rsup|2>)<around|(|<frac|p*'<rsup|2>-M<rsup|2>|M<rsup|2>>+<frac|p<rsup|2>-M<rsup|2>|M<rsup|2>>|)>|]>,<eq-number><label|off>>>>>>

  where <math|F<rsub|1>(-q<rsup|2>)> is the usual Dirac form factor of the
  proton which is empirically well represented as a dipole
  <math|F<rsub|1>(-q<rsup|2>)=<around|(|1-q<rsup|2>/\<Lambda\><rsup|2>|)><rsup|-2>>,
  with <math|\<Lambda\>> = 840 MeV. This gives a good representation of the
  data for the values of <math|-q<rsup|2>\<equiv\>Q<rsup|2>\<gtr\>0> of up to
  about 1 GeV<rsup|<math|2>> needed here. The second term on the right hand
  side of <eq|off> is a natural off-shell extension where the dimensionless
  parameter <math|\<lambda\>> represents the strength of the effect and
  <math|F(-q<rsup|2>)> is an off-shell form factor. The subscript <math|N>
  indicates an operator acting on the proton. Operators acting on the
  electron have no index. The virtuality of the proton is represented by the
  terms involving the difference between the square of the proton
  four-momentum and <math|M<rsup|2>>. The value of <math|\<lambda\>> is
  constrained by nuclear physics for which the size of the expected effect in
  nuclear physics (using <math|<around|(|p<rsup|2>-M<rsup|2>|)>/M<rsup|2>\<sim\>2*V/M\<approx\>0.08>)
  is about <math|0.08*\<lambda\>*F(-q<rsup|2>>). Typical effects at the
  center of nuclear matter are constrained by a variety of phenomena such as
  the EMC effect, uncertainties in quasi-elastic electron-nuclear
  scattering<nbsp><cite|bobm>, and deviations from the Coulomb sum
  rule<nbsp><cite|zm>. Such effects are typically constrained to be no larger
  than 10%. The relevant quantity determining the influence of off-shell
  effects is the ratio, <math|R>

  <eqnarray|<tformat|<table|<row|<cell|R=0.08*<space|0.27em>\<lambda\>*<space|0.27em>F(-q<rsup|2>).<eq-number><label|ratio>>>>>>

  Thus existing nuclear physics knowledge prevents the magnitude of
  <math|\<lambda\>> from being chosen arbitrarily large. Light-front
  quark-models<nbsp> <cite|Lepage:1982gd> of the nucleon wave function
  <math|\<psi\>>, show that it contains a propagator of the form
  <math|D<around|(|M<rsup|2>|)>\<equiv\>M<rsup|2>-<big|sum><rsub|i><frac|<bfk><rsub|\<perp\>,i>+m<rsub|i><rsup|2>|x<rsub|i>>>.
  The <math|p<rsup|2>-M<rsup|2>> term term is proportional to
  <math|<frac|\<partial\>*\<psi\>|\<partial\>*M<rsup|2>>\<sim\><frac|1|D<around|(|M<rsup|2>|)>>*\<psi\>>.
  The average value of the denominator is typically of the order of the
  nucleon mass and thus the natural value of the parameter <math|\<lambda\>>
  is of order unity.

  We take the off-shell form factor <math|F(-q<rsup|2>)> to vanish at
  <math|q<rsup|2>=0>. This means that the charge of the off-shell proton will
  be the same as the charge of a free proton, and is demanded by current
  conservation as expressed through the Ward-Takahashi identity
  <cite|bincer|Naus:1987kv>. Otherwise, it is completely unknown. We assume

  <eqnarray|<tformat|<table|<row|<cell|F(-q<rsup|2>)=<frac|<frac|2|\<pi\>>*tan<rsup|-1><around|(|<frac|-q<rsup|2>|b<rsup|2>>|)>|<around|(|1-q<rsup|2>/<wide|\<Lambda\>|~><rsup|2>|)><rsup|\<xi\>>>.<eq-number><label|model2>>>>>>

  This form is simple and purely phenomenological. It is clearly not unique.
  The parameter <math|b> is expected to be of the order of the pion mass,
  because these longest range components of the nucleon are least bound and
  more susceptible to external perturbations which put the nucleon off its
  mass shell. At large values of <math|<around|\||q<rsup|2>|\|>>, <math|F>
  becomes the same as <math|F<rsub|1>>, if <math|\<xi\>=0>. But, in
  principle, there is no reason why <math|\<xi\>> should vanish.

  The lowest order term in which the nucleon is sufficiently off-shell in a
  muonic atom for this correction to produce a significant effect is the
  two-photon exchange diagram of Fig.<nbsp><reference|fd1> and its crossed
  partner.

  <big-figure|<image|OSFF_2.eps|6.0cm|||><label|fd1> |Direct two-photon
  exchange graph corresponding to the hitherto neglected term. The dashed
  line denotes the lepton; the solid line, the nucleon; the wavy lines,
  photons; and the ellipse, the off-shell nucleon.>

  Feynman rules, using the Lorentz Gauge, give the change in the invariant
  amplitude caused by using <eq|off>, <math|\<cal-M\><rsub|<math-up|Off>>> as
  evaluated in the lepton/nucleon rest frame as

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|\<cal-M\><rsub|<math-up|Off>>=e<rsup|4>*<frac|2*\<lambda\>|M<rsup|2>>*<big|int><frac|d<rsup|4>*k|<around|(|2*\<pi\>|)><rsup|4>>*F<rsub|1><rsup|2>(-k<rsup|2>)F(-k<rsup|2>)<around*|[|\<gamma\><rsub|\<mu\>>*<frac|<around|(|l\<cdot\>\<gamma\>-k\<cdot\>\<gamma\>+m|)>|k<rsup|2>-2*l\<cdot\>k+i*\<epsilon\>>*\<gamma\><rsub|\<nu\>>+\<gamma\><rsub|\<nu\>>*<frac|<around|(|l\<cdot\>\<gamma\>+k\<cdot\>\<gamma\>+m|)>|k<rsup|2>+2*l\<cdot\>k+i*\<epsilon\>>*\<gamma\><rsub|\<mu\>>|]><around|(|<frac|1|k<rsup|2>+i*\<epsilon\>>|)><rsup|2>>>|<row|<cell|>|<cell|>|<cell|\<times\>\<gamma\><rsub|N><rsup|\<mu\>>*<around|(|P\<cdot\>\<gamma\>+k\<cdot\>\<gamma\>+M|)>*\<gamma\><rsub|N><rsup|\<nu\>>,<eq-number><label|md>>>>>>

  where the lepton momentum is <math|l=<around|(|m,0,0,0|)>> and <math|m> its
  mass, the virtual photon momentum is <math|k> and the nucleon momentum
  <math|P=<around|(|M,0,0,0|)>>. The denominator of the proton propagator is
  cancelled by the term involving the virtuality of the intermediate proton.
  Thus this graph can be thought of as involving a contact interaction and
  the amplitude in <eq|md> as a new type of proton polarization correction
  corresponding to a subtraction term in the dispersion relation for the
  two-photon exchange diagram that is not constrained by the cross section
  data<nbsp><cite|drell>.

  Evaluation proceeds in the standard way by taking the sum over Dirac
  indices, performing the integral over <math|k<rsup|0>> by contour rotation,
  <math|k<rsup|0>\<rightarrow\>-i*k<rsup|0>>, and integrating over the
  angular variables. The matrix element <math|\<cal-M\>> is well approximated
  by a constant in momentum space, for the momenta typical of a muonic atom,
  so that the corresponding potential <math|V=i*\<cal-M\>> takes the form
  <math|V<around|(|<bfr>|)>=V<rsub|0>*\<delta\><around|(|<bfr>|)>> in
  coordinate space. This approach is called the \Pscattering
  approximation"<nbsp><cite|eides>. Then the relevant matrix elements have
  the form <math|V<rsub|0><around*|\||\<Psi\><rsub|2*S><around|(|0|)>|\|><rsup|2>>,
  where <math|\<Psi\><rsub|2*S>> is the muonic hydrogen wave function in the
  2s-state of relevance to the experiment of Pohl <with|font-shape|italic|et
  al.> This potential gives no contribution to <math|P> states. We use
  <math|<around*|\||\<Psi\><rsub|2*S><around|(|0|)>|\|><rsup|2>=<frac|1|8*\<pi\>*a<rsub|0><rsup|3>>>,
  with <math|a<rsub|0>=<frac|1|\<alpha\>*m<rsub|r>>> and <math|m<rsub|r>> the
  lepton-proton reduced mass.

  The result is

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<around|\<langle\>|2*S<around|\||V|\|>*2*S|\<rangle\>>=<frac|-\<alpha\><rsup|5>*m<rsub|r><rsup|3>|M<rsup|2>>*<frac|2|\<pi\>>*\<lambda\>*<frac|8*m*M|\<Lambda\><rsup|2>>*F<rsub|L><around|(|m|)>+<frac|4|3>*<frac|\<alpha\><rsup|5>*m<rsub|r><rsup|3>|M<rsup|2>>*<frac|2|\<pi\>>*\<lambda\><boldsigma>\<cdot\><boldsigma><rsub|N>F<rsub|H*F*S><around|(|m|)>,<eq-number>>>|<row|<cell|>|<cell|>|<cell|F<rsub|L><around|(|m|)>\<equiv\><frac|2|\<pi\>>*<big|int><rsub|0><rsup|\<infty\>><frac|d*x|x>*<frac|1|<around|(|1+x<rsup|2>|)><rsup|4+\<xi\>>>*tan<rsup|-1><around|(|x<rsup|2>*<frac|\<Lambda\><rsup|2>|b<rsup|2>>|)><space|0.27em><frac|<around*|(|<sqrt|<frac|x+\<beta\>|x>>-1|)>|\<beta\>>,<eq-number><label|fl>>>|<row|<cell|>|<cell|>|<cell|F<rsub|H*F*S><around|(|m|)>\<equiv\><frac|2|\<pi\>>*<big|int><rsub|0><rsup|\<infty\>>x*d*x*<frac|1|<around|(|1+x<rsup|2>|)><rsup|4+\<xi\>>>*tan<rsup|-1><around|(|x<rsup|2>*<frac|\<Lambda\><rsup|2>|b<rsup|2>>|)><space|0.27em><frac|<around*|(|-<sqrt|x*<around|(|x+\<beta\>|)>>+x+\<beta\>|)>|\<beta\>*<around|(|x+\<beta\>|)>>,<eq-number><label|fhfs2>>>>>>

  where <math|\<beta\>\<equiv\>4*m<rsup|2>/\<Lambda\><rsup|2>>. There is a
  contribution to the Lamb shift which contains a factor of the product of
  the lepton and nucleon masses in addition to the factor from the wave
  function, leading to an <math|m<rsup|4>> dependence. This term will
  automatically be negligible for electronic hydrogen. There is also a
  contribution to the hyperfine splitting HFS.

  We next seek values of the model parameters <math|b,\<xi\>> of <eq|model2>.
  These are chosen so as to reproduce the value of the needed energy shift of
  0.15 meV with a value of <math|\<lambda\>> of order unity. Numerical
  evaluation, using <math|\<xi\>=0> for simplicity, shows that
  <math|\<lambda\>=2> for <math|b=85> MeV. If <math|\<xi\>> is changed
  substantially from 0 to 2 (using <math|<wide|\<Lambda\>|~>=\<Lambda\>>) the
  value of <math|\<lambda\>> required to reproduce a 0.15 meV change in the
  Lamb shift is increased by 5%. If our mechanism increases the muonic Lamb
  shift by 0.15 meV, the change in the electronic H Lamb shift for the
  2S-state is well below 1 kHz, which is significantly below the current
  uncertainty in both theory and experiment<nbsp><cite|eides>. We note that
  the HFS shift caused by our effect, is just 3% of the present correction to
  the Lamb shift, so we neglect it for muonic H. For electronic H it
  contributes less than 1 kHz to the HFS, again within current experimental
  and theoretical limits. Should some other effect account for part of the
  proton radius puzzle, the value of <math|\<lambda\>> would be reduced. We
  also caution that other systems in which one might aim to test this effect
  could show sensitivity to the value of <math|\<xi\>> or
  <math|<wide|\<Lambda\>|~>> in Eq.<nbsp>(<reference|model2>).

  In conclusion, we have shown that a simple off-shell correction to the
  photon-proton vertex, which arises naturally in quantum field theory and is
  of natural size and consistent with the constraints of gauge invariance, is
  capable of resolving the discrepancy between the extraction of the proton
  charge radius from Lamb shift measurements in muonic and electronic
  hydrogen. Indeed, off-shell effects were an explicit concern of both
  Zemach<nbsp><cite|zemach> and Grotch & Yennie<nbsp><cite|grotchyennie>.
  However, it is only with the remarkable improvement in experimental
  precision recently achieved that it has become of practical importance.
  Within nuclear physics there is great interest in the role that the
  modification of nucleon structure in-medium may play in nuclear
  structure<nbsp><cite|Guichon:1995ue|Guichon:2004xg>. We stress that the
  effect postulated here can be investigated in lepton-nucleus scattering via
  the binding effects of the nucleon as well as by lepton-proton scattering
  in arenas where two photon (or <math|\<gamma\>,Z>) effects are relevant. It
  may also be that the study of other muonic atoms, such as muonic deuterium,
  may provide an independent constraint on such terms.

  <section*|Acknowledgments>

  This research was supported by the United States Department of Energy,
  (GAM) grant FG02-97ER41014; (JR) grant DE-FG02-04ER41318; (JDC, in part)
  contract DE-AC05-06OR23177 (under which Jefferson Science Associates, LLC,
  operates JeffersonLab), and by the Australian Research Council and the
  University of Adelaide (AWT, JDC). GAM and JR gratefully acknowledge the
  support and hospitality of the University of Adelaide while the project was
  undertaken.

  <\thebibliography|99>
    <bibitem|pohl>R.<nbsp>Pohl <with|font-shape|italic|et al.>, Nature
    <with|font-series|bold|466>, 213 (2010).

    <bibitem|codata>P.<nbsp>J.<nbsp>Mohr, B.<nbsp>N.<nbsp>Taylor, and
    D.<nbsp>B.<nbsp>Newell, Rev. Mod. Phys. <with|font-series|bold|80>, 633
    (2008).

    <bibitem|eides>M.<nbsp>I.<nbsp>Eides, H.<nbsp>Grotch and
    V.<nbsp>A.<nbsp>Shelyuto, Phys. Rept. <with|font-series|bold|342>, 63
    (2001).

    <bibitem|friar>J.<nbsp>L.<nbsp>Friar, Annals Phys.
    <with|font-series|bold|122>, 151 (1979).

    <bibitem|atomcalcs>S.<nbsp>G.<nbsp>Karshenboim, Phys. Rept.
    <with|font-series|bold|422>, 1 (2005); K.<nbsp>Pachucki, Phys. Rev. A
    <with|font-series|bold|53>, 2092 (1996); K.<nbsp>Pachucki, Phys. Rev. A
    <with|font-series|bold|60>, 3593-3598 (1999); E.<nbsp>Borie, Z. Phys.
    <with|font-series|bold|A278>, 127 (1976) 463; E.<nbsp>Borie, Phys. Rev. A
    <with|font-series|bold|71>, 032508 (2005); A.<nbsp>P.<nbsp>Martynenko,
    Phys. Rev. A <with|font-series|bold|71>, 022506 (2005);
    A.<nbsp>P.<nbsp>Martynenko, Phys. At. Nucl. <with|font-series|bold|71>,
    125 (2008); K.<nbsp>Pachucki, and U.<nbsp>D.<nbsp>Jentschura, Phys. Rev.
    Lett. 91, 113005 (2003); A.<nbsp>Veitia, K.<nbsp>Pachucki, Phys. Rev. A
    <with|font-series|bold|69>, 042501 (2004); A.<nbsp>Antognini
    <with|font-shape|italic|et al.>, AIP Conf. Proc. 796, 253 (2005);
    T.<nbsp>Kinoshita, M.<nbsp>Nio, Phys. Rev. Lett. 82, 3240 (1999);
    V.<nbsp>G.<nbsp>Ivanov, E.<nbsp>Y.<nbsp>Korzinin and
    S.<nbsp>G.<nbsp>Karshenboim, Phys. Rev. D <with|font-series|bold|80>,
    027702 (2009); R.<nbsp>N.<nbsp>Faustov, E.<nbsp>V.<nbsp>Cherednikova and
    A.<nbsp>P.<nbsp>Martynenko, Nucl. Phys. A <with|font-series|bold|703>,
    365 (2002); A.<nbsp>Di Giacomo, Nucl. Phys. <with|font-series|bold|B> 11,
    411 (1969); G.<nbsp>A.<nbsp>Rinker, Phys. Rev. A
    <with|font-series|bold|14>, 18 (1976); E.<nbsp>Borie and
    G.<nbsp>A.<nbsp>Rinker, Phys. Rev. A <with|font-series|bold|18>, 324
    (1978); R.<nbsp>Barbieri, M.<nbsp>Caffo, E.<nbsp>Remiddi, Lett. Nuovo
    Cim. 7S2 (1973) 60-62; H.<nbsp>Suura, E.<nbsp>H.<nbsp>Wichmann, Phys.
    Rev. 105, 1930 (1957); E.<nbsp>Petermann, Phys. Rev. 105, 1931 (1957);
    E.<nbsp>Borie, Helv. Phys. Acta 48, 671 (1975); J.<nbsp>L.<nbsp>Friar,
    J.<nbsp>Martorell and D.<nbsp>W.<nbsp>L.<nbsp>Sprung, Phys. Rev. A
    <with|font-series|bold|59>, 4061 (1999); R.<nbsp>N.<nbsp>Faustov and
    A.<nbsp>P.<nbsp>Martynenko, Phys. Atom. Nucl. <with|font-series|bold|63>,
    845 (2000); A.<nbsp>P.<nbsp>Martynenko and R.<nbsp>N.<nbsp>Faustov, Phys.
    Atom. Nucl. <with|font-series|bold|64>, 1282 (2001); R.<nbsp>Rosenfelder,
    Phys. Lett. B <with|font-series|bold|463>, 317 (1999);
    J.<nbsp>L.<nbsp>Friar, Z. Phys. A <with|font-series|bold|292>, 1 (1979);
    J.<nbsp>L.<nbsp>Friar, Z. Phys. A <with|font-series|bold|303>, 84 (1981);
    L.<nbsp>A.<nbsp>Borisoglebsky and E.<nbsp>E.<nbsp>Trofimenko, Phys. Lett.
    B <with|font-series|bold|81>, 175 (1979); A.<nbsp>Czarnecki,
    M.<nbsp>Dowling, J.<nbsp>Mondejar and J.<nbsp>H.<nbsp>Piclum, Nucl. Phys.
    Proc. Suppl. <with|font-series|bold|205-206>, 271 (2010).

    <bibitem|zemach>A.<nbsp>C.<nbsp>Zemach, Phys. Rev.
    <with|font-series|bold|104>, 1771 (1956).

    <bibitem|grotchyennie>H.<nbsp>Grotch and D.<nbsp>R.<nbsp>Yennie Rev. Mod.
    Phys. <with|font-series|bold|41>, 350 (1969).

    <bibitem|jent>U.<nbsp>D.<nbsp>Jentschura, arXiv:1011.5275.

    <bibitem|carroll>J.<nbsp>D.<nbsp>Carroll, <with|font-shape|italic|et al.>
    to be published.

    <bibitem|Barger:2010aj>V.<nbsp>Barger, C.<nbsp>W.<nbsp>Chiang,
    W.<nbsp>Y.<nbsp>Keung and D.<nbsp>Marfatia, arXiv:1011.3519 [hep-ph].

    <bibitem|Jaeckel:2010xx>J.<nbsp>Jaeckel and S.<nbsp>Roy, Phys. Rev. D
    <with|font-series|bold|82>, 125020 (2010).

    <bibitem|TuckerSmith:2010ra>D.<nbsp>Tucker-Smith and I.<nbsp>Yavin,
    arXiv:1011.4922 [hep-ph].

    <bibitem|Brax:2010gp>P.<nbsp>Brax and C.<nbsp>Burrage, arXiv:1010.5108
    [hep-ph].

    <bibitem|jent1>U.<nbsp>D.<nbsp>Jentschura, arXiv:1011.5453.

    <bibitem|dr>A.<nbsp>De Rjula, Phys. Lett. B <with|font-series|bold|693>,
    555 (2010).

    <bibitem|Cloet:2010qa>I.<nbsp>C.<nbsp>Cloet and G.<nbsp>A.<nbsp>Miller,
    arXiv:1008.4345 [hep-ph], in press Phys. Rev. C.

    <bibitem|walcher>M.<nbsp>O.<nbsp>Distler, J.<nbsp>C.<nbsp>Bernauer and
    T.<nbsp>Walcher, arXiv:1011.1861 [nucl-th].

    <bibitem|emc>D.<nbsp>F.<nbsp>Geesaman, K.<nbsp>Saito and
    A.<nbsp>W.<nbsp>Thomas, Ann. Rev. Nucl. Part. Sci.
    <with|font-series|bold|45>, 337 (1995); M.<nbsp>M.<nbsp>Sargsian
    <with|font-shape|italic|et al.>, J. Phys. G <with|font-series|bold|29>,
    R1 (2003).

    <bibitem|tony>G.<nbsp>V.<nbsp>Dunne and A.<nbsp>W.<nbsp>Thomas, Nucl.
    Phys. A <with|font-series|bold|455>, 701 (1986).

    <bibitem|wally>W.<nbsp>Melnitchouk, A.<nbsp>W.<nbsp>Schreiber and
    A.<nbsp>W.<nbsp>Thomas, Phys. Rev. D <with|font-series|bold|49>, 1183
    (1994).

    <bibitem|franz>F.<nbsp>Gross and S.<nbsp>Liuti, Phys. Rev. C
    <with|font-series|bold|45>, 1374 (1992).

    <bibitem|Gross:2008ps>F.<nbsp>Gross and A.<nbsp>Stadler, Phys. Rev. C
    <with|font-series|bold|78>, 014005 (2008).

    <bibitem|Ciofi>C.<nbsp>Ciofi<nbsp>degli<nbsp>Atti,
    L.<nbsp>L.<nbsp>Frankfurt, L.<nbsp>P.<nbsp>Kaptari and
    M.<nbsp>I.<nbsp>Strikman, Phys. Rev. C <with|font-series|bold|76>, 055206
    (2007).

    <bibitem|bobm>R.<nbsp>D.<nbsp>McKeown, Phys. Rev. Lett.
    <with|font-series|bold|56>, 1452 (1986).

    <bibitem|zm>Z.<nbsp>E.<nbsp>Meziani <with|font-shape|italic|et al.>,
    Phys. Rev. Lett. <with|font-series|bold|52>, 2130 (1984).

    <bibitem|Lepage:1982gd>G.<nbsp>P.<nbsp>Lepage, S.<nbsp>J.<nbsp>Brodsky,
    T.<nbsp>Huang and P.<nbsp>B.<nbsp>Mackenzie, Invited talk given at Banff
    Summer Inst. on Particle Physics, Banff, Alberta, Canada, Aug 16-28,
    (1981).

    <bibitem|bincer>A.<nbsp>M.<nbsp>Bincer, Phys. Rev.
    <with|font-series|bold|118>, 855 (1960).

    <bibitem|Naus:1987kv>H.<nbsp>W.<nbsp>L.<nbsp>Naus and
    J.<nbsp>H.<nbsp>Koch, Phys. Rev. C <with|font-series|bold|36>, 2459
    (1987); J.<nbsp>W.<nbsp>Bos and J.<nbsp>H.<nbsp>Koch, Nucl. Phys. A
    <with|font-series|bold|563>, 539 (1993).

    <bibitem|Strauch:2010nm>S.<nbsp>Strauch <with|font-shape|italic|et al.>
    [for the Jefferson Lab Hall A and for the Jefferson Lab Hall A
    Collaborations], [arXiv:1012.4095 [nucl-ex]].

    <bibitem|Paolone:2010qc>M.<nbsp>Paolone, S.<nbsp>P.<nbsp>Malace,
    S.<nbsp>Strauch <with|font-shape|italic|et al.>, Phys. Rev. Lett.
    <with|font-series|bold|105>, 072001 (2010).

    <bibitem|Lu:1997mu>D.<nbsp>-H.<nbsp>Lu, A.<nbsp>W.<nbsp>Thomas,
    K.<nbsp>Tsushima <with|font-shape|italic|et al.>, Phys. Lett.
    <with|font-series|bold|B417>, 217-223 (1998).

    <bibitem|Lu:1998tn>D.<nbsp>-H.<nbsp>Lu, K.<nbsp>Tsushima,
    A.<nbsp>W.<nbsp>Thomas, A.<nbsp>G.<nbsp>Williams, K.<nbsp>Saito,K, Phys.
    Rev. <with|font-series|bold|C60>, 068201 (1999); J.<nbsp>R.<nbsp>Smith
    and G.<nbsp>A.<nbsp>Miller, Phys. Rev. C <with|font-series|bold|70>,
    065205 (2004).

    <bibitem|Cloet:2009tx>I.<nbsp>C.<nbsp>Cloet, G.<nbsp>A.<nbsp>Miller,
    E.<nbsp>Piasetzky and G.<nbsp>Ron, Phys. Rev. Lett.
    <with|font-series|bold|103>, 082301 (2009).

    <bibitem|drell>S.<nbsp>D.<nbsp>Drell and J.<nbsp>D.<nbsp>Sullivan, Phys.
    Lett. <with|font-series|bold|19>, 516 (1965).

    <bibitem|Guichon:1995ue>P.<nbsp>A.<nbsp>M.<nbsp>Guichon, K.<nbsp>Saito,
    E.<nbsp>N.<nbsp>Rodionov <with|font-shape|italic|et al.>, Nucl. Phys.
    <with|font-series|bold|A601>, 349-379 (1996); P.<nbsp>G.<nbsp>Blunden and
    G.<nbsp>A.<nbsp>Miller, Phys. Rev. C <with|font-series|bold|54>, 359
    (1996)<bibitem|Guichon:2004xg>P.<nbsp>A.<nbsp>M.<nbsp>Guichon,
    A.<nbsp>W.<nbsp>Thomas, Phys. Rev. Lett. <with|font-series|bold|93>,
    132502 (2004);
  </thebibliography>
</body>