<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <\hide-preamble>
    <assign|mytitle|<macro|Impact of hollow-atom formation on coherent x-ray
    scattering at high intensity>>

    <assign|ket|<macro|1|<math|<around|\||<arg|1>|\<rangle\>>>>>

    <assign|bra|<macro|1|<math|<around|\<langle\>|<arg|1>|\|>>>>

    <assign|braket|<macro|1|2|<math|<around|\<langle\>|<arg|1>\|<arg|2>|\<rangle\>>>>>

    <assign|braketoperator|<macro|1|2|3|<math|<around*|\<langle\>|<arg|1><around*|\<lvert\>|<arg|2>|\<rvert\>><arg|3>|\<rangle\>>>>>

    <assign|reducedmatrix|<macro|1|2|3|<math|<around*|\<langle\>|<arg|1><around*|\<lVert\>|<arg|2>|\<rVert\>><arg|3>|\<rangle\>>>>>

    <assign|pd|<macro|1|2|<math|<frac|\<partial\><arg|1>|\<partial\><arg|2>>>>>

    <assign|degree|<macro|<rsup|<math|\<circ\>>>>>

    <assign|config|<macro|1|2|3|1s<rsup|<math|<arg|1>>>2s<rsup|<math|<arg|2>>>2p<rsup|<math|<arg|3>>>>>
  </hide-preamble>

  <doc-data|<doc-title|<mytitle>>|<doc-date|<date|>>|<doc-author|<author-data|<author-name|Sang-Kil
  Son <CJKfamily|mj>(\<#C190\>\<#C0C1\>\<#AE38\>)>|<author-email|sangkil.son@cfel.de>|<author-affiliation|Center
  for Free-Electron Laser Science, DESY, 22607 Hamburg,
  Germany>>>|<doc-author|<author-data|<author-name|Linda
  Young>|<author-email|young@anl.gov>|<author-affiliation|Argonne National
  Laboratory, Argonne, Illinois 60439, USA>>>|<doc-author|<author-data|<author-name|Robin
  Santra>|<author-email|robin.santra@cfel.de>|<author-affiliation|Center for
  Free-Electron Laser Science, DESY, 22607 Hamburg,
  Germany>|<author-affiliation|Department of Physics, University of Hamburg,
  20355 Hamburg, Germany>>>>

  <abstract-data|<\abstract>
    X-ray free-electron lasers (FELs) are promising tools for structural
    determination of macromolecules via coherent x-ray scattering. During
    ultrashort and ultraintense x-ray pulses with an atomic scale wavelength,
    samples are subject to radiation damage and possibly become highly
    ionized, which may influence the quality of x-ray scattering patterns. We
    develop a toolkit to treat detailed ionization, relaxation, and
    scattering dynamics for an atom within a consistent theoretical
    framework. The coherent x-ray scattering problem including radiation
    damage is investigated as a function of x-ray FEL parameters such as
    pulse length, fluence, and photon energy. We find that the x-ray
    scattering intensity saturates at a fluence of <math|\<sim\>10<rsup|7>>
    photons/<rsup|<math|2>> per pulse, but can be maximized by using a pulse
    duration much shorter than the time scales involved in the relaxation of
    the inner-shell vacancy states created. Under these conditions, both
    inner-shell electrons in a carbon atom are removed, and the resulting
    hollow atom gives rise to a scattering pattern with little loss of
    quality for a spatial resolution <math|\<gtr\>1><nbsp>. Our numerical
    results predict that in order to scatter from a carbon atom 0.1 photons
    per x-ray pulse, within a spatial resolution of 1.7<nbsp>, a fluence of
    <math|1\<times\>10<rsup|7>> photons/<rsup|<math|2>> per pulse is
    required at a pulse length of 1<nbsp>fs and a photon energy of
    12<nbsp>keV. By using a pulse length of a few hundred attoseconds, one
    can suppress even secondary ionization processes in extended systems. The
    present results suggest that high-brightness attosecond x-ray FELs would
    be ideal for single-shot imaging of individual macromolecules.
  </abstract>|<abstract-pacs|32.90.+a| 32.80.Fb| 87.59.<math|->e| 87.15.ag>>

  <section|Introduction><label|sec:intro>

  X-ray free-electron lasers (FELs)<nbsp><cite|Feldhaus05|Pellegrini04>
  provide unparalleled peak brightness and open a new era in science and
  technology, offering many possibilities that have not been conceivable with
  conventional light sources<nbsp><cite|Mancuso10|Piancastelli10|Neutze04>.
  The world's first x-ray FEL\Vthe Linac Coherent Light Source (LCLS) at SLAC
  National Accelerator Laboratory<nbsp><cite|Emma10>\Vhas been in operation
  since 2009, with a photon energy of up to 8.3<nbsp>keV, up to
  <math|2\<times\>10<rsup|12>><nbsp>photons per pulse, and a
  full-width-half-maximum (FWHM) pulse length as short as a few femtoseconds.
  The SPring-8 Compact SASE Source (SCSS) at SPring-8<nbsp><cite|SCSS> and
  the European X-ray FEL at DESY<nbsp><cite|XFEL> are under construction and
  are planned to deliver up to 12<nbsp>keV photon energy with an average
  brightness 5\U500 times higher than LCLS.

  One of the prospective applications of x-ray FELs is single-shot imaging of
  individual macromolecules<nbsp><cite|Hajdu00|Gaffney07|Miao08>, which
  employs coherent x-ray scattering to determine the atomically resolved
  structure of non-crystallized biomolecules or other
  nanoparticles<nbsp><cite|Miao99|Robinson01|Chapman06|Chapman07|Schmidt08|Barty08|Marchesini08|Bogan08|Nishino09>.
  Single-shot imaging becomes possible because the high fluence of a tightly
  focused x-ray FEL pulse could produce a significant amount of scattered
  photons from single-molecule samples. One of the key challenges in
  single-shot imaging using ultraintense x rays is radiation
  damage<nbsp><cite|Howells09>. Each target molecule undergoes electronic
  damage via processes such as photoionization and Auger decay. The
  positively charged atomic ions formed in this way repel each other, thus
  leading to Coulomb explosion of the target
  molecule<nbsp><cite|Wabnitz02|Saalmann02|Ziaja09a>. Since the fluence
  required for single-shot imaging exceeds the conventional damage limit (200
  photons/<rsup|<math|2>>)<nbsp><cite|Henderson95>, these damage effects
  could degrade the scattering patterns and hinder the determination of the
  atomic positions in the target molecule. To suppress the impact of the
  molecular Coulomb explosion on atomically resolved imaging, one must
  effectively freeze the atomic motion during the x-ray pulse, requiring a
  pulse duration of no more than ten femtoseconds<nbsp><cite|Solem82|Neutze00>.
  Following this idea, several theoretical approaches were used to simulate
  the radiation damage processes including the movement of the atoms:
  References<nbsp><cite|Neutze00|Jurek04|Jurek04a|Bergh04|Faigel05|Jurek08|Jurek09>
  employed molecular dynamics, Refs.<nbsp><cite|Hau-Riege04|Hau-Riege05|Hau-Riege07b|Hau-Riege07c|Hau-Riege08>
  based their description on a hydrodynamic model, and
  Refs.<nbsp><cite|Ziaja06a|Ziaja08|Ziaja08a|Ziaja09|Ziaja09a> used a kinetic
  Boltzmann model.

  For <with|font-shape|italic|electronic> damage processes, which in the
  x-ray regime are mainly atom-specific, one may concentrate, to a first
  approximation, on the interaction of the x rays with individual atoms. The
  dynamics of bound electrons in an isolated atom during an ultraintense
  x-ray pulse were investigated theoretically in connection with hollow-atom
  formation<nbsp><cite|Moribayashi98|Rohringer07>, x-ray
  fluorescence<nbsp><cite|Moribayashi04|Moribayashi07|Moribayashi08>, and
  radiation damage<nbsp><cite|Kai10>. It is important to note that even if
  the atomic motion during an x-ray pulse is negligible, electronic damage
  dynamics during the x-ray pulse may directly influence x-ray scattering
  patterns by altering the electronic density in the
  target<nbsp><cite|Hau-Riege07>. It is, therefore, crucial to understand
  detailed ionization and relaxation dynamics in individual atoms under
  ultrashort and ultraintense x-ray pulses.

  A series of recent experiments conducted at LCLS revealed how electrons
  interact with ultraintense, ultrafast x-ray
  pulses<nbsp><cite|Young10|Hoener10|Cryan10|Fang10>. In the x-ray regime,
  photoabsorption predominantly affects inner-shell (core) electrons. If
  inner-shell photoabsorption is saturated, all inner-shell electrons in a
  given atom may be removed before Auger decay or other relaxation processes
  occur<nbsp><cite|Moribayashi98|Rohringer07>. The transient state thus
  produced is referred to as a hollow atom. If the pulse length is short
  enough, the hollow atom retains its core vacancies during the pulse.
  Because the x-ray photoabsorption probability is smaller for valence
  electrons than for inner-shell electrons, hollow-atom formation suppresses
  further electronic damage. This effect is called x-ray
  transparency<nbsp><cite|Young10> or frustrated
  absorption<nbsp><cite|Hoener10>, and might be beneficial for single-shot
  imaging of individual molecules<nbsp><cite|Young10|Hoener10>. The present
  paper investigates this idea in detail and provides criteria for the x-ray
  FEL parameters required.

  To treat x-ray\Uatom interactions, we employ a consistent
  <with|font-shape|italic|ab initio> framework<nbsp><cite|Santra09> based on
  nonrelativistic quantum electrodynamics and perturbation theory. This x-ray
  atomic theory has been applied to study x-ray absorption by laser-dressed
  atoms<nbsp><cite|Buth07|Buth07a|Buth08|Glover10> and x-ray scattering from
  laser-aligned molecules<nbsp><cite|Ho08|Ho09a|Pabst10>. In this paper, we
  present a practical implementation of this <with|font-shape|italic|ab
  initio> framework as a toolkit to calculate cross sections and rates of
  x-ray-induced processes for various charge states and electronic
  configurations of an isolated atom within an approximation to the
  Hartree\UFock model. With those parameters, we simulate hollow-atom
  formation dynamics under ultrashort and ultraintense x-ray pulses by means
  of time-dependent rate equations<nbsp><cite|Rohringer07|Makris09|Young10>.
  Then we investigate the effects of hollow-atom formation on coherent x-ray
  scattering from atomic carbon.

  The paper is organized as follows. In Sec.<nbsp><reference|sec:method>, we
  present theoretical methods to compute cross sections and rates of all
  electronic damage processes, which are integrated into a set of rate
  equations. In Sec.<nbsp><reference|sec:results>, we explore coherent x-ray
  scattering signals influenced by hollow-atom formation and their dependence
  on x-ray FEL parameters such as pulse length, fluence, and photon energy,
  and on the spatial resolution of the image. We also discuss the role of
  electron impact ionization in molecules. We conclude with a summary and
  future perspectives in Sec.<nbsp><reference|sec:conclusion>.

  <section|Theory and Numerical details><label|sec:method>

  The present toolkit of x-ray atomic processes covers ionization, relaxation
  (Auger decay and fluorescence), and coherent x-ray scattering. We assume
  that inelastically (Compton) scattered photons are energetically
  distinguishable from elastically (coherently) scattered photons and focus
  on coherent scattering processes for imaging problems. Compton scattering
  contributes to electronic damage, but is negligible in comparison with
  photoionization for the photon energies under
  consideration<nbsp><cite|Thompson01>. Shake-up and shake-off
  processes<nbsp><cite|Carlson65|Omar92|Persson01> also make a small
  contribution to electronic damage and are not included in our model. We
  also neglect impact ionization<nbsp><cite|Hau-Riege04|Jurek04|Ziaja05|Ziaja06|Kai10>,
  i.e., secondary ionization in molecules induced by photoelectrons and/or
  Auger electrons via (e,2e) processes. We will discuss a straightforward
  strategy to reduce impact ionization in Sec.<nbsp><reference|sec:impact>.
  Atomic units are used in this section.

  <subsection|Hartree\UFock\USlater model><label|sec:HFS>

  In order to implement the <with|font-shape|italic|ab initio>
  framework<nbsp><cite|Santra09>, we use the Hartree\UFock\USlater (HFS)
  model<nbsp><cite|Slater51|Herman63>, which employs a local density
  approximation to the exact exchange interaction. The effective one-electron
  (mean-field) Schrdinger equation to be solved is

  <\equation>
    <label|eq:SE><around*|[|-<frac|1|2>*\<nabla\><rsup|2>+V<around|(|<math-bf|r>|)>|]>*\<psi\><around|(|<math-bf|r>|)>=\<varepsilon\>*\<psi\><around|(|<math-bf|r>|)>.
  </equation>

  Here the potential is given by

  <\equation>
    <label|eq:potential>V<around|(|<math-bf|r>|)>=-<frac|Z|r>+<big|int><space|-0.17em><frac|\<rho\><around|(|<math-bf|r>|)>|<around|\||<math-bf|r>-<math-bf|r><rprime|'>|\|>>*<space|0.27em>d<rsup|3>*r<rprime|'>+V<rsub|<text>>*x<around|(|<math-bf|r>|)>,
  </equation>

  where <math|Z> is the nuclear charge and the electronic density
  <math|\<rho\><around|(|<math-bf|r>|)>> is given by

  <\equation>
    \<rho\><around|(|<math-bf|r>|)>=<big|sum><rsub|i><rsup|N<rsub|<text>>*e*l*e*c>\<psi\><rsub|i><rsup|\<dag\>><around|(|<math-bf|r>|)>*\<psi\><rsub|i><around|(|<math-bf|r>|)>,
  </equation>

  where <math|i> is the spin\Uorbital index and <math|N<rsub|<text>>*e*l*e*c>
  is the number of electrons. The exchange term is approximated by the Slater
  exchange potential<nbsp><cite|Slater51>,

  <\equation>
    <label|eq:V>V<rsub|<text>>*x<around|(|<math-bf|r>|)>=-<frac|3|2>*<around*|[|<frac|3|\<pi\>>*\<rho\><around|(|<math-bf|r>|)>|]><rsup|1/3>.
  </equation>

  In addition, the potential includes the Latter tail
  correction<nbsp><cite|Latter55> to obtain the proper long-range potential
  for both occupied and unoccupied orbitals, i.e., we put
  <math|V<around|(|<math-bf|r>|)>=-<around|(|Z<rprime|'>+1|)>/r> if the
  right-hand side of Eq.<nbsp>(<reference|eq:potential>) is less negative
  than <math|-<around|(|Z<rprime|'>+1|)>/r>, where
  <math|Z<rprime|'>=Z-N<rsub|<text>>*e*l*e*c> is the effective charge of the
  system.

  After angular momentum averaging, the problem becomes spherically
  symmetric, and each solution of Eq.<nbsp>(<reference|eq:SE>) can be
  expressed in terms of the product of a radial wave function and a spherical
  harmonic. For example, a bound-state spatial orbital with quantum numbers
  <math|<around|(|n,l,m|)>> may be written as

  <\equation>
    \<psi\><rsub|n*l*m><around|(|<math-bf|r>|)>=<frac|P<rsub|n*l><around|(|r|)>|r>*Y<rsup|m><rsub|l><around|(|\<theta\>,\<phi\>|)>.
  </equation>

  For the bound states, the radial wave function
  <math|P<rsub|n*l><around|(|r|)>> is accurately solved by the generalized
  pseudospectral method<nbsp><cite|Yao93a|Tong97a> on a nonuniform grid. For
  the continuum states, <math|P<rsub|\<varepsilon\>*l><around|(|r|)>> is
  numerically solved by the fourth-order Runge\UKutta method for a given
  energy <math|\<varepsilon\>> on a uniform
  grid<nbsp><cite|Cooper62|Manson68>. To evaluate integrals involving both
  bound and continuum states, we use spline interpolation to map the
  bound-state orbitals from the nonuniform grid to the denser uniform grid
  employed for the continuum states.

  For the bound-state calculations, the theoretical procedure presented here
  is identical to the Herman\USkillman code<nbsp><cite|Herman63>, which has
  been widely used in atomic physics, but the numerical part of the present
  toolkit utilizes a different grid method with the following advantages.
  Firstly, it is easy to control convergence with respect to the grid
  parameters. Secondly, we can avoid truncation of the maximum radius
  internally imposed by the Herman\USkillman code, which causes numerical
  instability for photoabsorption cross section calculations. Lastly, the
  matrix eigenvalue problem is solved by a modern linear algebra
  package<nbsp><cite|LAPACK>. For the present calculations, we use 200 grid
  points and a maximum radius of 50<nbsp>a.u. for the bound states
  (nonuniform grids) and a radial step size of 0.001<nbsp>a.u. for the
  continuum states (uniform grids) to achieve machine accuracy for cross
  sections and rates.

  We calculate all cross sections and rates for all possible electronic
  configurations. For example, a neutral carbon atom has a <config|2|2|2>
  ground configuration, so the number of all configurations that can be
  formed by removing 0, 1, 2, 3, 4, 5, or all 6 electrons from the occupied
  orbitals is <math|1+3+6+7+6+3+1=27>. Note that we perform a separate HFS
  calculation for each configuration. In other words, the orbitals are
  optimized in the presence of core and/or valence vacancies. Thus, orbital
  relaxation for the core-hole configurations is automatically included, a
  strategy that is known to be in good agreement with multiconfigurational
  self-consistent-field calculations<nbsp><cite|Hau-Riege07>.

  <subsection|X-ray absorption process><label|sec:photionization>

  The cross section for ionizing an electron in the <math|i>th subshell by
  absorbing an x-ray photon with energy <math|\<omega\>> is given
  by<nbsp><cite|Santra09>

  <\widetext>
    <\equation>
      \<sigma\><rsub|<text>>*P<around|(|i,\<omega\>|)>=<frac|4|3>*\<alpha\>*\<pi\><rsup|2>*\<omega\>*N<rsub|i>*<big|sum><rsub|l<rsub|j>=<around|\||l<rsub|i>-1|\|>><rsup|l<rsub|i>+1><frac|l<rsub|\<gtr\>>|2*l<rsub|i>+1><around*|\||<big|int><rsub|0><rsup|\<infty\>>P<rsub|n<rsub|i>*l<rsub|i>><around|(|r|)>*P<rsub|\<varepsilon\>*l<rsub|j>><around|(|r|)>*<space|0.27em>r*<space|0.27em>d*r|\|><rsup|2>,
    </equation>
  </widetext>

  \ where <math|\<alpha\>> is the fine-structure constant, <math|N<rsub|i>>
  is the occupation number of the <math|i>th subshell,
  <math|l<rsub|\<gtr\>>=max <around|(|l<rsub|i>,l<rsub|j>|)>>, and
  <math|\<varepsilon\>=\<omega\>-E<rsub|i>> is the photoelectron energy.
  Here, <math|E<rsub|i>> is the ionization energy of the <math|i>th subshell
  (<math|E<rsub|i>=-\<varepsilon\><rsub|i>>) by Koopmans'
  theorem<nbsp><cite|Koopmans34>, which is approximately valid in the HFS
  model. The orbital energy <math|\<varepsilon\><rsub|i>> and the radial wave
  functions <math|P<rsub|n<rsub|i>*l<rsub|i>><around|(|r|)>> and
  <math|P<rsub|\<varepsilon\>*l<rsub|j>><around|(|r|)>> are calculated for a
  given electronic configuration. We do not consider orbital hole alignment
  after ionization by linearly-polarized x-ray pulses and, hence, assume that
  the density of bound electrons remains spherically symmetric throughout.

  Table<nbsp><reference|table:pcs> shows x-ray absorption cross sections for
  all configurations of carbon (except the bare nucleus) at photon energies
  of 8<nbsp>keV and 12<nbsp>keV, respectively. The photon energy range
  considered here is consistent with that available at current and future
  x-ray FELs<nbsp><cite|Emma10|SCSS|XFEL>. Note that the present total cross
  sections are in agreement with those in the literature<nbsp><cite|Verner93>
  to within less than 10%.

  The impact of orbital relaxation is evident in the subshell cross sections
  shown in Table<nbsp><reference|table:pcs>. For instance, the 2s subshell
  cross section for the <config|1|2|2> and <config|0|2|2> configurations
  differ by 40% and 90%, respectively, from the 2s subshell cross section for
  the ground configuration of neutral carbon.

  As may be seen in Table<nbsp><reference|table:pcs>, the cross sections for
  the 1s and 2s subshells are much greater than the 2p subshell cross
  section, because <math|\<sigma\><rsub|<text>>*P> is proportional to
  <math|\<omega\><rsup|-l-7/2>> in the high energy limit<nbsp><cite|Bethe08>.
  Therefore, absorption of linearly polarized x rays does not, in general,
  induce any orbital hole alignment. This justifies our assumption of
  spherically symmetric electron densities.

  <with|par-columns|1|<big-table| <ruledtabular|
  <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|3|3|cell-col-span|3>|<cwith|1|1|3|3|cell-halign|c>|<cwith|1|1|3|3|cell-rborder|0ln>|<cwith|1|1|6|6|cell-col-span|3>|<cwith|1|1|6|6|cell-halign|c>|<cwith|1|1|6|6|cell-rborder|0ln>|<cwith|1|1|3|5|cell-bborder|1ln>|<cwith|1|1|6|8|cell-bborder|1ln>|<cwith|2|2|3|3|cell-col-span|1>|<cwith|2|2|3|3|cell-halign|c>|<cwith|2|2|3|3|cell-rborder|0ln>|<cwith|2|2|4|4|cell-col-span|1>|<cwith|2|2|4|4|cell-halign|c>|<cwith|2|2|4|4|cell-rborder|0ln>|<cwith|2|2|5|5|cell-col-span|1>|<cwith|2|2|5|5|cell-halign|c>|<cwith|2|2|5|5|cell-rborder|0ln>|<cwith|2|2|6|6|cell-col-span|1>|<cwith|2|2|6|6|cell-halign|c>|<cwith|2|2|6|6|cell-rborder|0ln>|<cwith|2|2|7|7|cell-col-span|1>|<cwith|2|2|7|7|cell-halign|c>|<cwith|2|2|7|7|cell-rborder|0ln>|<cwith|2|2|8|8|cell-col-span|1>|<cwith|2|2|8|8|cell-halign|c>|<cwith|2|2|8|8|cell-rborder|0ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|3|3|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|12|12|1|-1|cell-bborder|1ln>|<cwith|19|19|1|-1|cell-bborder|1ln>|<cwith|25|25|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|>|<cell|<math|\<sigma\><rsub|<text>>*P>
  (10<rsup|<math|-8>> a.u.) at 8<nbsp>keV>|<cell|>|<cell|>|<cell|<math|\<sigma\><rsub|<text>>*P>
  (10<rsup|<math|-8>> a.u.) at 12<nbsp>keV>|<cell|>|<cell|>>|<row|<cell|Charge>|<cell|Configuration>|<cell|1s>|<cell|2s>|<cell|2p>|<cell|1s>|<cell|2s>|<cell|2p>>|<row|<cell|<math|+0>>|<cell|<config|2|2|2>>|<cell|287>|<cell|14.8>|<cell|0.0897>|<cell|77.8>|<cell|4.05>|<cell|0.0164>>|<row|<cell|<math|+1>>|<cell|<config|1|2|2>>|<cell|155>|<cell|20.8>|<cell|0.219>|<cell|41.9>|<cell|5.70>|<cell|0.0399>>|<row|<cell|>|<cell|<config|2|1|2>>|<cell|287>|<cell|8.28>|<cell|0.118>|<cell|78.0>|<cell|2.27>|<cell|0.0214>>|<row|<cell|>|<cell|<config|2|2|1>>|<cell|287>|<cell|16.6>|<cell|0.0590>|<cell|77.9>|<cell|4.53>|<cell|0.0107>>|<row|<cell|<math|+2>>|<cell|<config|0|2|2>>|<cell|->|<cell|27.9>|<cell|0.387>|<cell|->|<cell|7.61>|<cell|0.0699>>|<row|<cell|>|<cell|<config|1|1|2>>|<cell|155>|<cell|11.5>|<cell|0.258>|<cell|42.0>|<cell|3.16>|<cell|0.0474>>|<row|<cell|>|<cell|<config|1|2|1>>|<cell|155>|<cell|23.4>|<cell|0.132>|<cell|42.0>|<cell|6.41>|<cell|0.0243>>|<row|<cell|>|<cell|<config|2|0|2>>|<cell|288>|<cell|->|<cell|0.145>|<cell|78.2>|<cell|->|<cell|0.0266>>|<row|<cell|>|<cell|<config|2|1|1>>|<cell|288>|<cell|9.25>|<cell|0.0737>|<cell|78.2>|<cell|2.53>|<cell|0.0134>>|<row|<cell|>|<cell|<config|2|2|0>>|<cell|288>|<cell|18.6>|<cell|->|<cell|78.1>|<cell|5.10>|<cell|->>|<row|<cell|<math|+3>>|<cell|<config|0|1|2>>|<cell|->|<cell|15.1>|<cell|0.435>|<cell|->|<cell|4.13>|<cell|0.0790>>|<row|<cell|>|<cell|<config|0|2|1>>|<cell|->|<cell|31.1>|<cell|0.221>|<cell|->|<cell|8.48>|<cell|0.0397>>|<row|<cell|>|<cell|<config|1|0|2>>|<cell|156>|<cell|->|<cell|0.300>|<cell|42.1>|<cell|->|<cell|0.0548>>|<row|<cell|>|<cell|<config|1|1|1>>|<cell|156>|<cell|12.8>|<cell|0.153>|<cell|42.2>|<cell|3.51>|<cell|0.0280>>|<row|<cell|>|<cell|<config|1|2|0>>|<cell|156>|<cell|26.0>|<cell|->|<cell|42.3>|<cell|7.11>|<cell|->>|<row|<cell|>|<cell|<config|2|0|1>>|<cell|289>|<cell|->|<cell|0.0885>|<cell|78.4>|<cell|->|<cell|0.0165>>|<row|<cell|>|<cell|<config|2|1|0>>|<cell|289>|<cell|10.8>|<cell|->|<cell|78.5>|<cell|2.93>|<cell|->>|<row|<cell|<math|+4>>|<cell|<config|0|0|2>>|<cell|->|<cell|->|<cell|0.454>|<cell|->|<cell|->|<cell|0.0841>>|<row|<cell|>|<cell|<config|0|1|1>>|<cell|->|<cell|16.6>|<cell|0.246>|<cell|->|<cell|4.54>|<cell|0.0442>>|<row|<cell|>|<cell|<config|0|2|0>>|<cell|->|<cell|33.8>|<cell|->|<cell|->|<cell|9.23>|<cell|->>|<row|<cell|>|<cell|<config|1|0|1>>|<cell|156>|<cell|->|<cell|0.180>|<cell|42.2>|<cell|->|<cell|0.0323>>|<row|<cell|>|<cell|<config|1|1|0>>|<cell|157>|<cell|14.7>|<cell|->|<cell|42.4>|<cell|4.03>|<cell|->>|<row|<cell|>|<cell|<config|2|0|0>>|<cell|284>|<cell|->|<cell|->|<cell|76.3>|<cell|->|<cell|->>|<row|<cell|<math|+5>>|<cell|<config|0|0|1>>|<cell|->|<cell|->|<cell|0.285>|<cell|->|<cell|->|<cell|0.0522>>|<row|<cell|>|<cell|<config|0|1|0>>|<cell|->|<cell|18.0>|<cell|->|<cell|->|<cell|4.91>|<cell|->>|<row|<cell|>|<cell|<config|1|0|0>>|<cell|156>|<cell|->|<cell|->|<cell|42.2>|<cell|->|<cell|->>>>>>|<label|table:pcs>X-ray
  absorption cross sections (<math|\<sigma\><rsub|<text>>*P>) for various
  configurations of carbon at 8<nbsp>keV and 12<nbsp>keV. >>

  <subsection|Auger decay process><label|sec:Auger>

  The Auger decay rate that an electron from the <math|j>th subshell fills
  the <math|i>th subshell and another electron from the <math|j<rprime|'>>th
  subshell is ejected into the continuum may be written
  as<nbsp><cite|Santra09|Bhalla73>

  <\widetext>
    <\equation>
      <label|eq:Auger>\<Gamma\><rsub|<text>>*A*<around|(|i,j*j<rprime|'>|)>=\<pi\>*<frac|N<rsup|<text>>*H<rsub|i>*N<rsub|j*j<rprime|'>>|2*l<rsub|i>+1>*<big|sum><rsub|L=<around|\||l<rsub|j>-l<rsub|j<rprime|'>>|\|>><rsup|l<rsub|j>+l<rsub|j<rprime|'>>><big|sum><rsub|S=0><rsup|1><space|0.27em><space|0.27em><big|sum><rsub|l<rsub|i<rprime|'>>><around|(|2*L+1|)>*<around|(|2*S+1|)><around|\||M<rsub|L*S><around|(|j,j<rprime|'>,i,i<rprime|'>|)>|\|><rsup|2>,
    </equation>

    where <math|i<rprime|'>> indicates the continuum state with Auger
    electron energy <math|\<varepsilon\>=E<rsub|i>-E<rsub|j>-E<rsub|j<rprime|'>>>,
    <math|N<rsup|<text>>*H<rsub|i>> is the number of holes in the <math|i>th
    subshell, and

    <\equation>
      N<rsub|j*j<rprime|'>>=<choice|<tformat|<table|<row|<cell|<frac|N<rsub|j>*N<rsub|j<rprime|'>>|<around|(|4*l<rsub|j>+2|)>*<around|(|4*l<rsub|j<rprime|'>>+2|)>>>|<cell|<text|for
      inequivalent electrons>,>>|<row|<cell|<frac|N<rsub|j>*<around|(|N<rsub|j>-1|)>|<around|(|4*l<rsub|j>+2|)>*<around|(|4*l<rsub|j>+2-1|)>>>|<cell|<text|for
      equivalent electrons>.>>>>>
    </equation>

    Here, averaging schemes over initial and final states to compute
    transition rates are adopted from Refs.<nbsp><cite|Walters71|Walters71b|Bhalla73>.

    The matrix element <math|M<rsub|L*S>> is given by

    <\equation>
      <around*|\<nobracket\>|M<rsub|L*S><around|(|j,j<rprime|'>,i,i<rprime|'>|)>=\<tau\>(-1)<rsup|L+l<rsub|j>+l<rsub|i<rprime|'>>><big|sum><rsub|K><around*|[|R<rsub|K><around|(|j,j<rprime|'>,i,i<rprime|'>|)>*A<rsub|K><around|(|j,j<rprime|'>,i,i<rprime|'>|)>+|(>-1)<rsup|L+S>R<rsub|K><around|(|j<rprime|'>,j,i,i<rprime|'>|)>*A<rsub|K><around|(|j<rprime|'>,j,i,i<rprime|'>|)>|]>
    </equation>
  </widetext>

  \ where <math|\<tau\>=1/<sqrt|2>> if <math|j> and <math|j<rprime|'>> are
  equivalent electrons and <math|\<tau\>=1> otherwise. <math|A<rsub|K>> is a
  coefficient related to 3j- and 6j-symbols<nbsp><cite|Zare88>,

  <\equation>
    A<rsub|K><around|(|j,j<rprime|'>,i,i<rprime|'>|)>=<reducedmatrix|l<rsub|i>|C<rsub|K>|l<rsub|j>><reducedmatrix|l<rsub|i<rprime|'>>|C<rsub|K>|l<rsub|j<rprime|'>>><Bmatrix|<tformat|<table|<row|<cell|l<rsub|i>>|<cell|l<rsub|i<rprime|'>>>|<cell|L>>|<row|<cell|l<rsub|j<rprime|'>>>|<cell|l<rsub|j>>|<cell|K>>>>>,
  </equation>

  where

  <\equation>
    <reducedmatrix|l|C<rsub|K>|l<rprime|'>>=<frac|(-1)<rsup|l>|<sqrt|<around|(|2*l+1|)>*<around|(|2*l<rprime|'>+1|)>>><matrix|<tformat|<table|<row|<cell|l<rprime|'>>|<cell|K>|<cell|l>>|<row|<cell|0>|<cell|0>|<cell|0>>>>>,
  </equation>

  and <math|R<rsub|K>> is a double radial integral defined as

  <\widetext>
    <\equation>
      R<rsub|K><around|(|j,j<rprime|'>,i,i<rprime|'>|)>=<big|int><rsub|0><rsup|\<infty\>><space|-0.17em><space|-0.17em><big|int><rsub|0><rsup|\<infty\>>P<rsub|n<rsub|j>*l<rsub|j>><around|(|r<rsub|1>|)>*P<rsub|n<rsub|j<rprime|'>>*l<rsub|j<rprime|'>>><around|(|r<rsub|2>|)><frac|r<rsub|\<less\>><rsup|K>|r<rsub|\<gtr\>><rsup|K+1>>*P<rsub|n<rsub|i>*l<rsub|i>><around|(|r<rsub|1>|)>*P<rsub|\<varepsilon\>*l<rsub|i<rprime|'>>><around|(|r<rsub|2>|)>*<space|0.27em>d*r<rsub|1>*<space|0.27em>d*r<rsub|2>.
    </equation>
  </widetext>

  Table<nbsp><reference|table:rates> lists the Auger rates computed using
  Eq.<nbsp>(<reference|eq:Auger>) for various configurations of carbon.
  <math|K*L<rsub|1>*L<rsub|1>>, <math|K*L<rsub|1>*L<rsub|23>>, and
  <math|K*L<rsub|23>*L<rsub|23>> represent
  <math|\<Gamma\><rsub|<text>>*A>(1s,2s2s),
  <math|\<Gamma\><rsub|<text>>*A>(1s,2s2p), and
  <math|\<Gamma\><rsub|<text>>*A>(1s,2p2p), respectively. For the 1s hole
  configuration, the present results are in good agreement with other
  theoretical results<nbsp><cite|McGuire69|Walters71|Moribayashi08>. Note
  that Ref.<nbsp><cite|Moribayashi08> includes Auger and fluorescence rates
  for all possible configurations of carbon computed by Cowan's atomic
  structure code<nbsp><cite|Cowan81>. The decay rates in
  Ref.<nbsp><cite|Moribayashi08> are in fair agreement, to within about 40%,
  with the present results. We note that the experimental Auger lifetime for
  a free carbon ion, averaged over the subset of all doublet states in the
  <config|1|2|2> configuration, is 7.3<nbsp>fs<nbsp><cite|Schlachter04>, and
  possibly fortuitously agrees somewhat better with our calculated value
  (<math|\<approx\>>10<nbsp>fs) than with Ref.<nbsp><cite|Moribayashi08>
  (<math|\<approx\>>14<nbsp>fs).

  <subsection|Fluorescence process><label|sec:fluorescence>

  The fluorescence rate for the electric dipole transition of an electron
  from the <math|j>th subshell to a hole in the <math|i>th subshell is given
  by<nbsp><cite|Santra09|Bhalla73>

  <\widetext>
    <\equation>
      \<Gamma\><rsub|<text>>*F<around|(|i,j|)>=<frac|4|3>*\<alpha\><rsup|3>*<around|(|I<rsub|i>-I<rsub|j>|)><rsup|3>*<frac|N<rsup|<text>>*H<rsub|i>*N<rsub|j>|4*l<rsub|j>+2>\<cdot\><frac|l<rsub|\<gtr\>>|2*l<rsub|i>+1><around*|\||<big|int><rsub|0><rsup|\<infty\>>P<rsub|n<rsub|i>*l<rsub|i>><around|(|r|)>*P<rsub|n<rsub|j>*l<rsub|j>><around|(|r|)>*<space|0.27em>r*<space|0.27em>d*r|\|><rsup|2>.
    </equation>
  </widetext>

  \ The last two columns in Table<nbsp><reference|table:rates> show the x-ray
  fluorescence rates and yields [<math|=\<Gamma\><rsub|<text>>*F/<around|(|\<Gamma\><rsub|<text>>*F+<big|sum>\<Gamma\><rsub|<text>>*A|)>>]
  for various configurations of carbon, where <math|K*\<alpha\>> indicates
  <math|\<Gamma\><rsub|<text>>*F>(1s,2p). For the 1s hole configuration, the
  x-ray fluorescence yield is compared with experimental
  data<nbsp><cite|Hubbell94>. In light atoms like carbon, the x-ray
  fluorescence yield is generally small. Note, however, that x-ray
  fluorescence is the only decay process available in C<rsup|<math|4+>>
  <config|1|0|1> and C<rsup|<math|5+>> <config|0|0|1>. All fluorescence rates
  are included in our damage dynamics model for completeness.

  <with|par-columns|1|<big-table| <ruledtabular|
  <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|3|3|cell-col-span|3>|<cwith|1|1|3|3|cell-halign|c>|<cwith|1|1|3|3|cell-rborder|0ln>|<cwith|1|1|6|6|cell-col-span|1>|<cwith|1|1|6|6|cell-halign|c>|<cwith|1|1|6|6|cell-rborder|0ln>|<cwith|1|1|7|7|cell-col-span|1>|<cwith|1|1|7|7|cell-halign|c>|<cwith|1|1|7|7|cell-rborder|0ln>|<cwith|1|1|3|5|cell-bborder|1ln>|<cwith|1|1|6|6|cell-bborder|1ln>|<cwith|2|2|3|3|cell-col-span|1>|<cwith|2|2|3|3|cell-halign|c>|<cwith|2|2|3|3|cell-rborder|0ln>|<cwith|2|2|4|4|cell-col-span|1>|<cwith|2|2|4|4|cell-halign|c>|<cwith|2|2|4|4|cell-rborder|0ln>|<cwith|2|2|5|5|cell-col-span|1>|<cwith|2|2|5|5|cell-halign|c>|<cwith|2|2|5|5|cell-rborder|0ln>|<cwith|2|2|6|6|cell-col-span|1>|<cwith|2|2|6|6|cell-halign|c>|<cwith|2|2|6|6|cell-rborder|0ln>|<cwith|2|2|7|7|cell-col-span|1>|<cwith|2|2|7|7|cell-halign|c>|<cwith|2|2|7|7|cell-rborder|0ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|8|8|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<cwith|16|16|1|-1|cell-bborder|1ln>|<cwith|20|20|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|>|<cell|<math|\<Gamma\><rsub|<text>>*A>
  (10<rsup|<math|-3>> a.u.)>|<cell|>|<cell|>|<cell|<math|\<Gamma\><rsub|<text>>*F>
  (10<rsup|<math|-5>> a.u.)>|<cell|Fluorescence>>|<row|<cell|Charge>|<cell|Configuration>|<cell|<math|K*L<rsub|1>*L<rsub|1>>>|<cell|<math|K*L<rsub|1>*L<rsub|23>>>|<cell|<math|K*L<rsub|23>*L<rsub|23>>>|<cell|<math|K*\<alpha\>>>|<cell|yield>>|<row|<cell|<math|+1>>|<cell|<config|1|2|2>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|>|<cell|Present>|<cell|0.961>|<cell|0.970>|<cell|0.439>|<cell|0.836>|<cell|0.0035>>|<row|<cell|>|<cell|A>|<cell|0.929>|<cell|0.987>|<cell|0.435>|<cell|0.824>|<cell|0.0035>>|<row|<cell|>|<cell|B>|<cell|0.680>|<cell|0.697>|<cell|0.392>|<cell|0.651>|<cell|0.0037>>|<row|<cell|>|<cell|C>|<cell|0.857>|<cell|0.824>|<cell|0.378>|<cell|0.486>|<cell|0.0024>>|<row|<cell|>|<cell|EXP>|<cell|->|<cell|->|<cell|->|<cell|->|<cell|0.0026>>|<row|<cell|<math|+2>>|<cell|<config|0|2|2>>|<cell|2.89>|<cell|3.33>|<cell|1.75>|<cell|2.74>|<cell|0.0034>>|<row|<cell|>|<cell|<config|1|1|2>>|<cell|->|<cell|0.602>|<cell|0.574>|<cell|0.975>|<cell|0.0082>>|<row|<cell|>|<cell|<config|1|2|1>>|<cell|1.18>|<cell|0.620>|<cell|->|<cell|0.498>|<cell|0.0028>>|<row|<cell|<math|+3>>|<cell|<config|0|1|2>>|<cell|->|<cell|1.98>|<cell|2.13>|<cell|3.04>|<cell|0.0073>>|<row|<cell|>|<cell|<config|0|2|1>>|<cell|3.46>|<cell|1.99>|<cell|->|<cell|1.55>|<cell|0.0028>>|<row|<cell|>|<cell|<config|1|0|2>>|<cell|->|<cell|->|<cell|0.703>|<cell|1.11>|<cell|0.0155>>|<row|<cell|>|<cell|<config|1|1|1>>|<cell|->|<cell|0.370>|<cell|->|<cell|0.569>|<cell|0.0151>>|<row|<cell|>|<cell|<config|1|2|0>>|<cell|1.39>|<cell|->|<cell|->|<cell|->|<cell|<math|->>>|<row|<cell|<math|+4>>|<cell|<config|0|0|2>>|<cell|->|<cell|->|<cell|2.59>|<cell|3.27>|<cell|0.0125>>|<row|<cell|>|<cell|<config|0|1|1>>|<cell|->|<cell|1.15>|<cell|->|<cell|1.69>|<cell|0.0145>>|<row|<cell|>|<cell|<config|0|2|0>>|<cell|3.91>|<cell|->|<cell|->|<cell|->|<cell|<math|->>>|<row|<cell|>|<cell|<config|1|0|1>>|<cell|->|<cell|->|<cell|->|<cell|0.648>|<cell|1.0000>>|<row|<cell|<math|+5>>|<cell|<config|0|0|1>>|<cell|->|<cell|->|<cell|->|<cell|1.97>|<cell|1.0000>>>>>>|<label|table:rates>Auger
  rates (<math|\<Gamma\><rsub|<text>>*A>) and fluorescence rates
  (<math|\<Gamma\><rsub|<text>>*F>) for various configurations of carbon. For
  the 1s hole configuration, the present values are compared with other
  approaches. A: Herman--Skillman code<nbsp><cite|McGuire69>, B: Cowan
  code<nbsp><cite|Moribayashi08>, C: semi-empirical
  method<nbsp><cite|Walters71>, and EXP: experimental
  data<nbsp><cite|Hubbell94>. >>

  <subsection|Rate equations for ionization and relaxation
  dynamics><label|sec:rate>

  To simulate electronic damage dynamics in intense x-ray pulses, we use the
  rate equation approach that has been successfully used to describe
  x-ray-induced multiple ionization<nbsp><cite|Rohringer07|Makris09|Young10>.
  The transitions among all possible electronic configurations
  <math|<around|{|I|}>> of a given atom are described by a set of coupled
  rate equations of the form

  <\equation>
    <label|eq:rate><frac|d|d*t>*P<rsub|I><around|(|t|)>=<big|sum><rsub|I<rprime|'>\<neq\>I><rsup|<text>>a*l*l*c*o*n*f*i*g.*<around*|[|\<Gamma\><rsub|I<rprime|'>\<rightarrow\>I>*P<rsub|I<rprime|'>><around|(|t|)>-\<Gamma\><rsub|I\<rightarrow\>I<rprime|'>>*P<rsub|I><around|(|t|)>|]>,
  </equation>

  where <math|P<rsub|I>> is the population of the <math|I>th configuration,
  and <math|\<Gamma\><rsub|I\<rightarrow\>I<rprime|'>>> is the rate for
  transitions from the configuration <math|I> to the configuration
  <math|I<rprime|'>>. Here <math|\<Gamma\>> can be either a time-independent
  Auger or fluorescence rate, or a time-dependent photoionization rate given
  by <math|\<sigma\><rsub|<text>>*PJ<around|(|t|)>>, where
  <math|J<around|(|t|)>> is the photon flux of the x-ray pulse at a given
  time <math|t>. In our calculations on carbon, all configurations connected
  by the photoionization, Auger decay, and x-ray fluorescence processes
  listed in Tables<nbsp><reference|table:pcs> and <reference|table:rates> are
  included, and the corresponding rate equations are numerically solved using
  the fourth-order Runge\UKutta method. We assume that the temporal shape of
  the x-ray pulse is Gaussian. In the regime considered here, the spiky
  structure of the individual pulses generated by x-ray FELs such as the LCLS
  is largely irrelevant<nbsp><cite|Rohringer07>.

  <subsection|Coherent x-ray scattering process><label|sec:scattering>

  The coherent x-ray scattering form factor for a given electronic density
  <math|\<rho\><around|(|<math-bf|r>|)>> is given by<nbsp><cite|Santra09>

  <\equation>
    <label|eq:cff>f<rsup|0><around|(|<math-bf|Q>|)>=<big|int>\<rho\><around|(|<math-bf|r>|)>*<space|0.17em>e<rsup|i<math-bf|Q>\<cdot\><math-bf|r>>*<space|0.27em>d<rsup|3>*r,
  </equation>

  where <math|<math-bf|Q>> is the photon momentum transfer. We assume that
  the atomic electron density is spherically symmetric. Then the atomic form
  factor depends only on the magnitude of the momentum transfer, so
  Eq.<nbsp>(<reference|eq:cff>) may be simplified to

  <\equation>
    <label|eq:cff>f<rsup|0><around|(|Q|)>=4*\<pi\>*<big|int><rsub|0><rsup|\<infty\>>r<rsup|2>*\<rho\><around|(|r|)><frac|sin
    <around|(|Q*r|)>|Q*r>*<space|0.27em>d*r,
  </equation>

  where <math|Q=<around|\||<math-bf|Q>|\|>=2*\<alpha\>*\<omega\>*sin
  <around|(|\<theta\>/2|)>> and <math|\<theta\>> is the polar angle of the
  momentum of the scattered photon with respect to the propagation axis of
  the incoming x rays.

  For the unpolarized x rays, the differential cross section for coherent
  scattering is given by

  <\equation>
    <label|eq:sigma><frac|d*\<sigma\><rsub|<text>>*S|d*\<Omega\>>=\<alpha\><rsup|4><around|\||f<rsup|0><around|(|Q|)>|\|><rsup|2><frac|1+cos<rsup|2>
    \<theta\>|2>,
  </equation>

  and for linearly polarized x rays, the differential cross section is given
  by

  <\equation>
    <label|eq:sigma><frac|d*\<sigma\><rsub|<text>>*S|d*\<Omega\>>=\<alpha\><rsup|4><around|\||f<rsup|0><around|(|Q|)>|\|><rsup|2>*<around|(|1-cos<rsup|2>
    \<phi\>*sin<rsup|2> \<theta\>|)>,
  </equation>

  where <math|\<phi\>> is the azimuthal angle of the scattered photon
  momentum with respect to the x-ray propagation and polarization axes. This
  differential cross section gives the x-ray scattering pattern one would
  obtain for a fixed electronic configuration. From measurement of the x-ray
  scattering pattern, one can retrieve electronic density information. Based
  on the discrete Fourier transform relationship between real space and
  <math|Q> space, the smallest length in real space (the resolution <math|d>)
  corresponds to the largest length in <math|Q> space
  (<math|Q<rsub|<text>>*m*a*x>), while the largest length in real space (the
  object size <math|D>) corresponds to the smallest length in <math|Q> space
  (the pixel size <math|\<Delta\>*Q>). In other words, the spatial resolution
  desired determines the photon momentum transfer up to which statistically
  significant scattering data must be available,
  <math|Q<rsub|<text>>*m*a*x=2*\<pi\>/d>; the size of the object in real
  space determines the maximum pixel size permitted in <math|Q> space,
  <math|\<Delta\>*Q=2*\<pi\>/D>. For a purely atomic target (the case
  considered here), the object size is close to the desirable spatial
  resolution, so all relevant information in momentum space is captured in
  one pixel. The number of photons scattered into that pixel is proportional
  to the integral of the differential cross section over the solid angle
  <math|\<Omega\>> up to the desired resolution. We note that the integrals
  of Eqs.<nbsp>(<reference|eq:sigma>) and (<reference|eq:sigma>) over
  <math|\<Omega\>> are identical.

  During exposure to an ultraintense x-ray pulse, the atomic electron density
  is dynamically modified, as a consequence of x-ray-induced processes. This
  makes it necessary to introduce a suitably averaged, time-dependent
  differential scattering cross section,

  <\equation>
    <label|eq:sigma(t)><frac|d*\<sigma\><rsub|<text>>*S|d*\<Omega\>><around|(|t|)>=<big|sum><rsub|I><rsup|<text>>a*l*l*c*o*n*f*i*g.*P<rsub|I><around|(|t|)><frac|d*\<sigma\><rsub|<text>>*S|d*\<Omega\>><mid|\|><rsub|I>,
  </equation>

  where <math|P<rsub|I><around|(|t|)>> is the population of the <math|I>th
  configuration, which is obtained as a solution of the rate equations in
  Eq.<nbsp>(<reference|eq:rate>). The differential scattering cross section
  for the <math|I>th configuration is evaluated from the form factor of
  Eq.<nbsp>(<reference|eq:cff>) using the density
  <math|\<rho\><around|(|r|)>> calculated from the orbitals optimized for the
  <math|I>th configuration. In this way, we incorporate electronic damage
  dynamics into simulations of coherent x-ray scattering at high intensity.

  <subsection|Measurement of the strength and the quality of scattering
  signals><label|sec:scattering>

  To describe the strength of the x-ray scattering signals, we compute the
  number of scattered photons (<math|N<rsub|<text>>*S>) by integrating over
  the Ewald sphere<nbsp><cite|Als-Nielsen01>, limited to the desired spatial
  resolution length <math|d>,

  <\equation>
    N<rsub|<text>>*S<around|(|d|)>=<big|int><rsub|Q\<less\>Q<rsub|<text>>*m*a*x<around|(|d|)>><space|-0.17em><space|-0.17em><around*|[|<big|int><rsub|-\<infty\>><rsup|\<infty\>><space|-0.17em>J<around|(|t|)><frac|d*\<sigma\><rsub|<text>>*S|d*\<Omega\>><around|(|t|)>*<space|0.27em>d*t|]>*d*\<Omega\>,
  </equation>

  where <math|J<around|(|t|)>> is the incident photon flux at a given time
  <math|t>, and the time-dependent differential scattering cross section is
  defined in Eq.<nbsp>(<reference|eq:sigma(t)>). Here
  <math|Q<rsub|<text>>*m*a*x> is determined by the spatial resolution length,
  <math|d=2*\<pi\>/Q<rsub|<text>>*m*a*x>.

  <\widetext>
    \ To measure the quality of the x-ray scattering patterns, we employ a
    modified <math|R>-factor expression with an explicit dependence on the
    spatial resolution<nbsp><cite|Hau-Riege05>,

    <\equation>
      <label|eq:R-factor>R<around|(|d|)>=<big|int><rsub|Q\<less\>Q<rsub|<text>>*m*a*x<around|(|d|)>><space|-0.17em><space|-0.17em><around*|\||<frac|<sqrt|N<rsub|<text>>*r*e*a*l<around|(|\<Omega\>|)>>|<big|int><rsub|Q<rprime|'>\<less\>Q<rsub|<text>>*m*a*x<around|(|d|)>><space|-0.17em><space|-0.17em><sqrt|N<rsub|<text>>*r*e*a*l<around|(|\<Omega\><rprime|'>|)>>*<space|0.27em>d*\<Omega\><rprime|'>>-<frac|<sqrt|N<rsub|<text>>*i*d*e*a*l<around|(|\<Omega\>|)>>|<big|int><rsub|Q<rprime|'>\<less\>Q<rsub|<text>>*m*a*x<around|(|d|)>><space|-0.17em><space|-0.17em><sqrt|N<rsub|<text>>*i*d*e*a*l<around|(|\<Omega\><rprime|'>|)>>*<space|0.27em>d*\<Omega\><rprime|'>>|\|>*d*\<Omega\>,
    </equation>
  </widetext>

  \ where

  <\equation>
    N<rsub|<text>>*r*e*a*l<around|(|\<Omega\>|)>=<frac|d*N<rsub|<text>>*S|d*\<Omega\>>=<big|int><rsub|-\<infty\>><rsup|\<infty\>><space|-0.17em>J<around|(|t|)><frac|d*\<sigma\><rsub|<text>>*S|d*\<Omega\>><around|(|t|)>*<space|0.27em>d*t
  </equation>

  is the number of photons (per unit solid angle) scattered from the sample
  undergoing x-ray-induced electronic damage, and

  <\equation>
    N<rsub|<text>>*i*d*e*a*l<around|(|\<Omega\>|)>=<around*|(|<big|int><rsub|-\<infty\>><rsup|\<infty\>><space|-0.17em>J<around|(|t|)>*<space|0.27em>d*t|)><frac|d*\<sigma\><rsub|<text>>*S|d*\<Omega\>><mid|\|><rsub|<text>>n*e*u*t*r*a*l=F<space|0.17em><frac|d*\<sigma\><rsub|<text>>*S|d*\<Omega\>><mid|\|><rsub|<text>>n*e*u*t*r*a*l
  </equation>

  is the number of photons (per unit solid angle) scattered from the
  undamaged sample, which is given by the fluence (<math|F>) times the
  differential cross section of the undamaged sample. In our case, the
  undamaged sample is the neutral carbon atom in its ground configuration.

  <section|Results and discussion><label|sec:results>

  We investigate high-intensity coherent x-ray scattering including
  electronic damage dynamics with x-ray parameters achievable using x-ray
  FELs<nbsp><cite|Emma10|SCSS|XFEL>. The FWHM pulse length in our
  calculations varies from 1<nbsp>fs to 120<nbsp>fs, the pulse envelope being
  a Gaussian. The number of incident photons varies from <math|10<rsup|9>> to
  <math|10<rsup|15>>, and the beam size used is
  100<nbsp>nm<math|\<times\>>100<nbsp>nm, corresponding to a fluence ranging
  from <math|10<rsup|3>> to <math|10<rsup|9>> photons/<rsup|<math|2>>. The
  photon energy is chosen as 8<nbsp>keV and 12<nbsp>keV, respectively. With
  the Gaussian envelope and these fluences, the peak intensity ranges from
  <math|1\<times\>10<rsup|17>> to <math|1\<times\>10<rsup|23>><nbsp>W/cm<rsup|<math|2>>,
  for a photon energy of 8<nbsp>keV and a pulse length of 120<nbsp>fs.

  <subsection|Atomic form factors for core hole states><label|sec:form>

  In order to examine variations of x-ray scattering patterns for different
  electronic configurations, especially for core-hole configurations created
  via photoabsorption, we calculate atomic form factors for the filled core
  (neutral: <config|2|2|2>), the single-core-hole (<config|1|2|2>), and the
  double-core-hole (<config|0|2|2>) configurations (see
  Fig.<nbsp><reference|fig:cff>). To facilitate a direct comparison between
  the three different charge states, the form factors in
  Fig.<nbsp><reference|fig:cff> are normalized in the same fashion as used in
  the <math|R>-factor expression in Sec.<nbsp><reference|sec:scattering>.
  Specifically, the normalization factor is

  <\equation>
    <around*|\<nobracket\>|<big|int><rsub|Q\<less\>Q<rsub|<text>>*m*a*x<around|(|d|)>><space|-0.17em><space|-0.17em><sqrt|N<rsub|<text>>*n*e*u*t*r*a*l<around|(|\<Omega\>|)>>*<space|0.27em>d*\<Omega\><mid|/><big|int><rsub|Q\<less\>Q<rsub|<text>>*m*a*x<around|(|d|)>><space|-0.17em><space|-0.17em><sqrt|N<rsub|I><around|(|\<Omega\>|)>>*<space|0.27em>d*\<Omega\>,|\<nobracket\>>
  </equation>

  where <math|N<rsub|I><around|(|\<Omega\>|)>=d*\<sigma\><rsub|<text>>*S/d*\<Omega\>>
  for a given configuration <math|I>. We keep <math|d=1.7><nbsp> fixed as a
  desirable resolution for further analysis. Within this resolution, i.e.,
  for <math|Q> up to <math|Q<rsub|<text>>*m*a*x>, the shapes of the three
  normalized form factors are quite similar to each other. The computed
  <math|R>-factors for the single-core-hole and double-core-hole
  configurations with respect to the ground configuration of the neutral atom
  are 1.7% and 2.6%, respectively. This fact indicates that core-hole
  formation causes little degradation of the quality of the x-ray scattering
  pattern. We will discuss the optimal resolution minimizing the
  <math|R>-factor in Sec.<nbsp><reference|sec:resolution>.

  <big-figure|<image|plot_cff.eps||||><label|fig:cff>|(Color online)
  Normalized atomic form factor for different electronic configurations.>

  <subsection|Hollow-atom formation in ultrashort and ultraintense x-ray
  pulses><label|sec:charge>

  The time-averaged charge weighted by the normalized pulse envelope provides
  a simple measure of electronic damage during the x-ray
  pulse<nbsp><cite|Kai10|Hau-Riege07>. The time-averaged population of the
  <math|I>th configuration is given by

  <\equation>
    <label|eq:time-averaged><wide|P|\<bar\>><rsub|I>=<big|int><rsub|-\<infty\>><rsup|\<infty\>><space|-0.17em>P<rsub|I><around|(|t|)>*f<around|(|t|)>*<space|0.27em>d*t,
  </equation>

  where <math|P<rsub|I><around|(|t|)>> is the time-dependent population of
  the <math|I>th configuration, and <math|f<around|(|t|)>> is the normalized
  x-ray pulse envelope. Then the time-averaged charge is given by

  <\equation*>
    <wide|Z|\<bar\>>=<big|sum><rsub|I><rsup|<text>>a*l*l*c*o*n*f*i*g.*Z<rsub|I>*<wide|P|\<bar\>><rsub|I>,
  </equation*>

  where <math|Z<rsub|I>> is the charge corresponding to the <math|I>th
  configuration.

  <with|par-columns|1|<big-figure|<subfigure*|
  8<nbsp>keV|<image|plot_charge_8keV_log.eps||||>> <subfigure*|
  12<nbsp>keV|<image|plot_charge_12keV_log.eps||||>><label|fig:charge>|(Color
  online) Time-averaged charge weighted by the normalized pulse envelope for
  8<nbsp>keV and 12<nbsp>keV photon energies. Each line corresponds to a
  different fluence <math|F> (photons/<rsup|<math|2>>). The vertical lines
  labeled by <math|\<tau\><rsub|<text>>*S> and <math|\<tau\><rsub|<text>>*D>
  indicate the single-core-hole and double-core-hole lifetimes,
  respectively.>>

  Figure<nbsp><reference|fig:charge> shows the time-averaged charge of atomic
  carbon as a function of the pulse length for several fluences. When the
  pulse length is short enough to compete with core-hole lifetimes as marked
  in Fig.<nbsp><reference|fig:charge> (<math|\<tau\><rsub|<text>>*S\<approx\>10><nbsp>fs
  for the single-core-hole configuration and
  <math|\<tau\><rsub|<text>>*D\<approx\>3><nbsp>fs for the double-core-hole
  configuration), <math|<wide|Z|\<bar\>>> starts to decrease. This reduction
  of electronic damage is the signature of x-ray
  transparency<nbsp><cite|Young10> or frustrated
  absorption<nbsp><cite|Hoener10>, which may be understood as follows.
  Photoionization of a core electron initiates electronic damage. If the
  x-ray pulse length is long enough for Auger decay to occur during the
  pulse, then a valence electron fills the core vacancy. Eventually, many
  electrons can be stripped off in a sequence of core photoionization and
  Auger decay steps. Note that in this limit, the effective x-ray absorption
  cross section remains essentially constant throughout the pulse. For
  instance, the x-ray absorption cross sections for the configurations
  <config|2|2|2> (neutral ground configuration) and <config|2|2|0> (the
  dominant Auger decay channel for the single-hole configuration) are almost
  identical. As Fig.<nbsp><reference|fig:charge> illustrates, the
  time-averaged charge is practically independent of the pulse duration (and,
  therefore, independent of the peak intensity) for pulse lengths much longer
  than 10 fs. For pulses shorter than 10 fs, there are two stages of x-ray
  transparency or frustrated absorption. In the first stage, if the pulses
  are still longer than the double-core-hole lifetime
  (<math|\<tau\><rsub|<text>>*D\<approx\>3><nbsp>fs) and only
  single-core-hole production is saturated, the effective x-ray absorption
  cross section drops by a factor of 1.7 relative to the neutral atom (cf.
  Table<nbsp><reference|table:pcs>). The second stage becomes accessible for
  pulse durations shorter than the double-core-hole lifetime. In this case,
  by saturating hollow-atom formation, the effective x-ray absorption cross
  section drops further by a factor of 6.2, i.e., relative to the neutral
  atom the effective x-ray absorption cross section drops by almost a factor
  of 11 (cf. Table<nbsp><reference|table:pcs>). The somewhat counterintuitive
  consequence of this is that by decreasing the pulse duration and, thereby,
  increasing the peak intensity, the time-averaged charge
  <math|<wide|Z|\<bar\>>> can be minimized, as shown in
  Fig.<nbsp><reference|fig:charge>.

  We compare the time-averaged charge for two different photon energies in
  Fig.<nbsp><reference|fig:charge>: (a) 8<nbsp>keV and (b) 12<nbsp>keV. For a
  given fluence, the time-averaged charge at 8<nbsp>keV is higher than that
  at 12<nbsp>keV, because the photoabsorption cross section at 8<nbsp>keV is
  about 4 times higher than that at 12<nbsp>keV
  (Table<nbsp><reference|table:pcs>). This is also expected based on the
  scaling behavior of the photoabsorption cross section in the high energy
  limit, <math|\<sigma\><rsub|<text>>*P\<propto\>\<omega\><rsup|-7/2>*<around|(|l=0|)>><nbsp><cite|Bethe08>.
  Since a higher photon energy induces less electronic damage, it has an
  advantage with respect to the <math|R>-factor for x-ray scattering, which
  will be discussed in Sec.<nbsp><reference|sec:resolution>.

  <with|par-columns|1|<big-figure|<subfigure*|
  8<nbsp>keV|<image|plot_prob_8keV.eps||||>> <subfigure*|
  12<nbsp>keV|<image|plot_prob_12keV.eps||||>><label|fig:prob>|(Color online)
  Time-averaged populations of the single-core-hole and double-core-hole
  configurations for 8<nbsp>keV and 12<nbsp>keV photon energies. The pulse
  length is fixed at 1<nbsp>fs FWHM.>>

  As one can see in Fig.<nbsp><reference|fig:charge>, <math|<wide|Z|\<bar\>>>
  increases in increments of decreasing magnitude as the fluence becomes
  higher, indicating a saturation effect. To make this point clearer, we plot
  the time-averaged population <math|<wide|P|\<bar\>><rsub|I>> of the single
  (<math|I>=<config|1|2|2>) and double (<math|I>=<config|0|2|2>) core-hole
  configurations as a function of the fluence in
  Fig.<nbsp><reference|fig:prob>. The pulse length is fixed at 1<nbsp>fs
  FWHM, which is less than the lifetimes of the core-hole configurations.
  Both populations follow a power-law dependence for fluences up to about
  10<rsup|<math|6>> photons/<rsup|<math|2>>: single-core-hole production is
  a one-photon process and therefore is a linear function of the fluence
  (below 10<rsup|<math|6>> photons/<rsup|<math|2>>), whereas
  double-core-hole production is a two-photon process and therefore is a
  quadratic function of the fluence. Saturation occurs around
  10<rsup|<math|6>>\U10<rsup|<math|8>> photons/<rsup|<math|2>>. For even
  higher fluences, the populations of both configurations decrease due to
  further photoionization (core ionization in the single-core-hole
  configuration and valence ionization in the double-core-hole configuration,
  respectively).

  <subsection|Influence of hollow-atom formation on x-ray scattering
  intensity>

  The pulse-length and fluence dependence of the time-averaged charge affects
  the number of scattered photons, which must be maximized in single-shot
  experiments such as to obtain an optimal signal-to-noise ratio. In
  Fig.<nbsp><reference|fig:N>, the number of scattered photons is plotted as
  a function of the fluence for 8<nbsp>keV and 12<nbsp>keV photon energies.
  The spatial resolution is fixed at <math|d>=1.7<nbsp> and three different
  pulse lengths are considered (1, 10, and 100<nbsp>fs). For fluences below
  <math|\<sim\>10<rsup|6>><nbsp>photons/<rsup|<math|2>>,
  <math|N<rsub|<text>>*S> depends linearly on the fluence of incident
  photons, but is independent of the pulse length (see
  Fig.<nbsp><reference|fig:N>). In this low-fluence regime, the number of
  photons scattered per atom and per pulse is less than 0.1. In order to
  scatter at least 0.1 photons, the fluence must be in the regime above
  <math|10<rsup|6>><nbsp>photons/<rsup|<math|2>>. At high fluence, after
  saturation of inner-shell ionization, <math|N<rsub|<text>>*S> is no longer
  a linear function of the fluence and, particularly, depends sensitively on
  the pulse length. As can be seen in Fig.<nbsp><reference|fig:N>, the number
  of photons scattered may be maximized at a given fluence by using a pulse
  duration shorter than the double-core-hole lifetime
  (<math|\<tau\><rsub|<text>>*D\<approx\>3><nbsp>fs).

  <with|par-columns|1|<big-figure|<subfigure*|
  8<nbsp>keV|<image|plot_Nsc_F_8keV.eps||||>> <subfigure*|
  12<nbsp>keV|<image|plot_Nsc_F_12keV.eps||||>><label|fig:N>|(Color online)
  Number of scattered photons for 8<nbsp>keV and 12<nbsp>keV photon energies.
  A spatial resolution of 1.7<nbsp> is assumed. The thin dotted lines
  extrapolate the linear fluence dependence valid at low fluence.>>

  If we require that a carbon atom scatters, say, 0.1 photons per pulse and
  per pixel, then, assuming a pulse length of 1<nbsp>fs and a photon energy
  of 12<nbsp>keV, a fluence of <math|1\<times\>10<rsup|7>>
  photons/<rsup|<math|2>> per pulse is needed. However, if we assume a 10 fs
  pulse instead, then the fluence required would increase by a factor of
  four. Figure<nbsp><reference|fig:N> illustrates quite distinctly the impact
  of hollow-atom formation on coherent x-ray scattering at high intensity. In
  a molecule consisting of <math|N<rsub|<text>>*a*t*o*m> atoms, the number of
  scattered photons is proportional to at least
  <math|N<rsub|<text>>*a*t*o*m<rsup|1/3>> per pulse and per
  pixel<nbsp><cite|Shneerson08>. For example, with the above x-ray
  parameters, a molecule consisting of 100,000 carbon atoms would scatter at
  least 5 photons per pulse and per pixel. Note that 5 photons per pixel
  would be sufficient for successful 3-dimensional structural
  reconstruction<nbsp><cite|Shen04>.

  <subsection|Dependence of the <math|R>-factor on the desired
  resolution><label|sec:resolution>

  In addition to the strength of the scattering signal, another important
  factor is the quality of the x-ray scattering pattern. The scattering
  pattern from the damaged sample should be as similar as possible to the
  scattering pattern that would be obtained if the sample were unaffected by
  radiation damage. Using the <math|R>-factor in
  Eq.<nbsp>(<reference|eq:R-factor>), we measure the quality of the x-ray
  scattering pattern.

  <big-figure|<image|plot_res_1E13.eps||||><label|fig:resolution>|(Color
  online) <math|R>-factor as a function of the spatial resolution for
  8<nbsp>keV and 12<nbsp>keV photon energies. The fluence is
  <math|10<rsup|7>><nbsp>photons/<rsup|<math|2>> and the pulse length is
  1<nbsp>fs FWHM.>

  In Fig.<nbsp><reference|fig:resolution>, we examine the correlation between
  the <math|R>-factor and the desired spatial resolution for 8<nbsp>keV and
  12<nbsp>keV photon energies. The pulse length assumed is 1<nbsp>fs FWHM and
  the fluence is fixed at <math|10<rsup|7>><nbsp>photons/<rsup|<math|2>>.
  Under these conditions, inner-shell ionization is saturated (see
  Fig.<nbsp><reference|fig:prob>), and every ten pulses about one photon is
  scattered per carbon atom (see Fig.<nbsp><reference|fig:N>). Each curve in
  Fig.<nbsp><reference|fig:resolution> ends at the finest spatial resolution
  possible at the respective photon energy. Because of the reduction of
  electronic damage at higher photon energies, the <math|R>-factor at
  12<nbsp>keV is less than that at 8<nbsp>keV. For a spatial resolution
  <math|d\<gtr\>1><nbsp>, the spatially localized reduction of electron
  density in the 1s shell in the single-core-hole and double-core-hole
  configurations is difficult to resolve, rendering the <math|R>-factor
  rather low. The small local maximum around 2.5<nbsp> is due to the 2s
  vacancy formed by valence ionization in the double-core-hole configuration.
  For very fine resolution (<math|d\<less\>1><nbsp>), the core vacancy can
  be resolved, so the <math|R>-factor rapidly increases. Note, however, that
  the <math|R>-factor values in Fig.<nbsp><reference|fig:resolution> are
  still less than 20%, which is a typical value for x-ray crystallographic
  data<nbsp><cite|Hau-Riege05>. For <math|d>=1.7\U1.9<nbsp>, the
  <math|R>-factor takes on a local minimum value of less than 2%.

  <subsection|Role of impact ionization><label|sec:impact>

  So far, we have focused on electronic damage processes that are not
  strongly affected by the molecular environment. An important damage
  mechanism characteristic of extended molecular systems is impact ionization
  by (quasi-)free electrons<nbsp><cite|Hau-Riege04|Jurek04|Ziaja05|Ziaja06|Kai10>.
  For an x-ray pulse much shorter than inner-shell decay lifetimes, impact
  ionization by Auger electrons is irrelevant for the formation of electronic
  damage during the pulse. On the other hand, impact ionization by
  photoelectrons is not, in general, negligible. Here we discuss how to
  reduce photoelectron impact ionization by using short pulses.

  The mean free path for a 12<nbsp>keV photoelectron in a carbon-based medium
  (diamond) is about 13<nbsp>nm<nbsp><cite|Ziaja06>. Let us assume that the
  photoelectron travels in the <math|x> direction in a homogeneous sample.
  From the definition of the mean free path, it follows that the impact
  ionization probability is given by

  <\equation>
    P<rsub|<text>>*i*m*p*a*c*t<around|(|x|)>=1-e<rsup|-x/\<lambda\>>,
  </equation>

  where <math|x> is the distance traveled and <math|\<lambda\>> is the mean
  free path. If we allow an impact ionization probability of 20%, the maximum
  <math|x> permitted is <math|-\<lambda\>*log
  <around|(|1-0.2|)>=22%\<times\>\<lambda\>>. Therefore, for molecules with a
  diameter of 3<nbsp>nm or less, the impact ionization probability per
  photoelectron is less than 20%. For much larger molecules, the role of
  impact ionization can be reduced by using an x-ray pulse that is so short
  that it is over before impact ionization has taken place with a probability
  less than a certain percentage. In analogy to
  Eq.<nbsp>(<reference|eq:time-averaged>), one can define the time-averaged
  impact ionization probability during the x-ray pulse as

  <\equation>
    <wide|P|\<bar\>><rsub|<text>>*i*m*p*a*c*t=<big|int><rsub|0><rsup|\<tau\>>P<rsub|<text>>*i*m*p*a*c*t<around*|(|x<around|(|t|)>|)>*f<around|(|t|)>*<space|0.27em>d*t,
  </equation>

  where <math|\<tau\>> is the pulse duration and <math|f<around|(|t|)>> is
  the normalized x-ray pulse envelope. It is assumed that the electron starts
  to travel at the beginning of the pulse, i.e., <math|x<around|(|t|)>=v*t>,
  where <math|v> is the speed of the photoelectron. If we use a flat-top
  pulse envelope, <math|f<around|(|t|)>=1/\<tau\>> for
  <math|0\<leq\>t\<leq\>\<tau\>>, then <math|<wide|P|\<bar\>><rsub|<text>>*i*m*p*a*c*t=1+\<lambda\>/<around|(|v*\<tau\>|)><around|[|exp|(>-v*\<tau\>/\<lambda\>)-1>].
  Figure<nbsp><reference|fig:impact> plots <math|\<tau\>> versus
  <math|<wide|P|\<bar\>><rsub|<text>>*i*m*p*a*c*t> for a mean free path of
  13<nbsp>nm and a photoelectron energy of 12<nbsp>keV. For a pulse-weighted
  impact ionization probability of 20%, the pulse duration required is about
  100 attoseconds, corresponding to a Fourier-limited bandwidth of the order
  of 10<nbsp>eV. In calculations using a Gaussian pulse envelope, we obtained
  very similar results.

  <big-figure|<image|plot_impact_ionization.eps||||><label|fig:impact>|Plot
  of the pulse duration required for a given impact ionization probability,
  for a photoelectron with a kinetic energy of 12<nbsp>keV in a carbon-based
  medium with a mean free path of 13<nbsp>nm.>

  <section|Conclusion><label|sec:conclusion>

  In this paper, we have investigated electronic damage and coherent x-ray
  scattering using ultrashort and ultraintense x-ray pulses attainable with
  current and future x-ray FELs. For all possible electronic configurations
  of the atomic system, we have calculated rate parameters for x-ray-induced
  damage processes including photoionization, Auger decay, and fluorescence,
  in a consistent <with|font-shape|italic|ab initio> framework. The impact of
  electronic damage has been studied by employing a set of coupled rate
  equations, which we have incorporated into simulations of coherent x-ray
  scattering signals. We have implemented an integrated toolkit,
  <with|font-shape|small-caps|xatom>, to treat all above-mentioned processes.

  Our numerical simulations of coherent x-ray scattering signals including
  electronic damage dynamics show that hollow-atom formation and the
  associated phenomenon of x-ray transparency or frustrated absorption play a
  crucial role in optimizing the strength and quality of single-shot x-ray
  scattering signals. Hollow-atom formation is particularly important when
  the x-ray pulse length is a few femtoseconds or shorter, and saturates, in
  the case of carbon, around a fluence of
  10<rsup|<math|6>>\U10<rsup|<math|8>><nbsp>photons/<rsup|<math|2>>,
  corresponding to 10<rsup|<math|12>>\U10<rsup|<math|14>> photons per pulse
  at a beam size of 100<nbsp>nm<math|\<times\>>100<nbsp>nm. At a fluence of
  10<rsup|<math|7>><nbsp>photons/<rsup|<math|2>>, for instance, the number
  of photons scattered per pulse, within a spatial resolution of
  1.7<nbsp><space|0.17em> is about 0.1 per carbon atom, at a pulse length of
  1<nbsp>fs and a photon energy of 12<nbsp>keV. A hollow atom is resistant to
  further electronic damage via photoionization and, for a spatial resolution
  <math|d\<gtr\>1><nbsp>, gives rise to an x-ray scattering pattern that
  differs little from that obtained for the neutral atom in its ground
  electronic configuration. A comparison between our data for 8<nbsp>keV and
  12<nbsp>keV photon energies shows that there are no qualitative
  differences. By using a higher photon energy, the quality of the scattering
  pattern, as defined by the <math|R>-factor, can be increased (by reducing
  electronic damage), but the number of photons scattered per pulse decreases
  somewhat.

  Finally, we have analyzed the role of impact ionization in molecules and
  provided a simple estimate of the pulse duration required to suppress
  impact ionization during the x-ray pulse. This estimate, in combination
  with the calculations presented in this paper, suggests that attosecond
  x-ray FELs<nbsp><cite|Zholents04|Saldin06|Zholents08|Ding09> with a pulse
  length of <math|\<sim\>100><nbsp>as, <math|\<sim\>10<rsup|13>> photons per
  pulse, and a photon energy of <math|\<sim\>12><nbsp>keV are ideal for
  single-shot imaging of individual macromolecules at atomic resolution.

  <acknowledgments*|We thank Stefan Pabst for helpful discussions. This work
  was partially supported by the Chemical Sciences, Geosciences, and
  Biosciences Division of the Office of Basic Energy Sciences, Office of
  Science, US Department of Energy (DE-AC02-06CH11357).>

  <assign|@ifxundefined|<macro|1|<@ifx|<arg|1><undefined>>
  >><assign|@ifnum|<macro|1|<ifnum><arg|1><expandafter><@firstoftwo>
  <else><expandafter><@secondoftwo> <fi>>><assign|@ifx|<macro|1|<ifx><arg|1><expandafter><@firstoftwo>
  <else><expandafter><@secondoftwo> <fi>>><assign|natexlab|<macro|1|<arg|1>>><assign|enquote|<macro|1|\P<arg|1>\Q>><assign|bibnamefont|<macro|1|<arg|1>>><assign|bibfnamefont|<macro|1|<arg|1>>><assign|citenamefont|<macro|1|<arg|1>>><assign|href@noop|<macro|<@secondoftwo>>><assign|href|<macro|<@sanitize@url><@href>>><assign|@href|<macro|1|<@@startlink|<arg|1>><@@href>>><assign|@@href|<macro|1|<arg|1><@@endlink>>><assign|@sanitize@url|<macro|<catcode>`<next-line>12<catcode>`$12<catcode>
  `&12<catcode>`#12<catcode>`<math|<wide|<text|1>|^>>2<catcode>`_12<catcode>`%12>><assign|@@startlink|<macro|1|>><assign|@@endlink|<macro|>><assign|url|<macro|<@sanitize@url><@url>>>

  <\assign|@url>
    <\macro|1>
      <@href|<arg|1>>

      <\slink>
        refix }}%

        \\
      </slink>

      rovidecommand

      <\slink>
        refix \ [0]{URL }%

        \\
      </slink>

      rovidecommand <Eprint*|0|<hlink||>><assign|doibase|<macro|http://dx.doi.org/>><assign|selectlanguage|<macro|<@gobble>>><assign|bibinfo|<macro|<@secondoftwo>>><assign|bibfield|<macro|<@secondoftwo>>><assign|translation|<macro|1|[<arg|1>]>><assign|BibitemOpen|<macro|>><assign|bibitemStop|<macro|>><assign|bibitemNoStop|<macro|.<EOS>>><assign|EOS|<macro|<spacefactor>3000>><assign|BibitemShut|<macro|1|<csname>bibitem<arg|1><endcsname>>><let><auto@bib@innerbib><@empty><bibitem-with-key|
      (2005), , and |Feldhaus05><BibitemOpen> <bibfield>author
      <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|Feldhaus>,
      <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|Arthur>,\ 

      \ and <bibinfo>author <bibfnamefont|J.<nbsp>B.> <bibnamefont|Hastings>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Phys. B: At.
      Mol. Opt. Phys. <with|font-series|bold|<bibinfo>volume 38>,
      <bibinfo>pages S799 (<bibinfo>year 2005)<BibitemShut|NoStop><bibitem-with-key|
      and (2004)|Pellegrini04><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Pellegrini> and <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Reiche>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal J. Sel. Top. Quantum Electron.
      <with|font-series|bold|<bibinfo>volume 10>, <bibinfo> pages 1393
      (<bibinfo>year 2004)<BibitemShut|NoStop><bibitem-with-key| (2010), ,
      and |Mancuso10><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|A.<nbsp>P.> <bibnamefont|Mancuso>, <bibinfo>author
      <bibfnamefont|O.<nbsp>M.> <bibnamefont|Yefanov>, \ and <bibinfo>author
      <bibfnamefont|I.<nbsp>A.> <bibnamefont|Vartanyants>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal J. Biotechnol.
      <with|font-series|bold|<bibinfo>volume 149>, <bibinfo>pages 229
      (<bibinfo>year 2010)<BibitemShut|NoStop><bibitem-with-key| (2010), ,
      and |Piancastelli10><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|M.<nbsp>N.> <bibnamefont|Piancastelli>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Simon>, \ and <bibinfo>author
      <bibfnamefont|K.><nbsp><bibnamefont|Ueda>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Electron
      Spectrosc. Relat. Phenom. <with|font-series|bold|<bibinfo>volume 181>,
      <bibinfo> pages 98 (<bibinfo>year 2010)<BibitemShut|NoStop><bibitem-with-key|
      (2004), , , and |Neutze04><BibitemOpen> <bibfield>author
      <bibinfo>author <bibfnamefont|R.><nbsp><bibnamefont|Neutze>,
      <bibinfo>author <bibfnamefont|G.><nbsp><bibnamefont|Huldt>,
      <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>, \ and
      <bibinfo> author <bibfnamefont|D.><nbsp><bibnamefont|van der Spoel>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Radiat. Phys. Chem.
      <with|font-series|bold|<bibinfo>volume 71>, <bibinfo>pages 905
      (<bibinfo>year 2004)<BibitemShut|NoStop><bibitem-with-key| (2010), , ,
      , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,
      and |Emma10><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|P.><nbsp><bibnamefont|Emma>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Akre>, <bibinfo> author
      <bibfnamefont|J.><nbsp><bibnamefont|Arthur>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Bionta>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Bostedt>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Bozek>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Brachmann>, <bibinfo>author
      <bibfnamefont|P.><nbsp><bibnamefont|Bucksbaum>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Coffee>, <bibinfo>author
      <bibfnamefont|F.-J.>

      \ <bibnamefont|Decker>, <bibinfo>author
      <bibfnamefont|Y.><nbsp><bibnamefont|Ding>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Dowell>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Edstrom>, <bibinfo> author
      <bibfnamefont|A.><nbsp><bibnamefont|Fisher>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Frisch>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Gilevich>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Hastings>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Hays>, <bibinfo>author
      <bibfnamefont|P.><nbsp><bibnamefont|Hering>, <bibinfo>author
      <bibfnamefont|Z.><nbsp><bibnamefont|Huang>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Iverson>, <bibinfo> author
      <bibfnamefont|H.><nbsp><bibnamefont|Loos>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Messerschmidt>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Miahnahri>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Moeller>, <bibinfo>author
      <bibfnamefont|H.-D.> <bibnamefont|Nuhn>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Pile>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Ratner>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Rzepiela>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Schultz>, <bibinfo> author
      <bibfnamefont|T.><nbsp><bibnamefont|Smith>, <bibinfo>author
      <bibfnamefont|P.><nbsp><bibnamefont|Stefan>, <bibinfo>author
      <bibfnamefont|H.><nbsp><bibnamefont|Tompkins>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Turner>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Welch>, <bibinfo>author
      <bibfnamefont|W.><nbsp><bibnamefont|White>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Wu>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Yocky>, \ and <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Galayda>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Nature Photon.
      <with|font-series|bold|<bibinfo>volume 4>, <bibinfo>pages 641
      (<bibinfo>year 2010)<BibitemShut|NoStop><bibitem-with-key| and
      (2005)|SCSS><BibitemOpen> <bibinfo>editor
      <bibfnamefont|T.><nbsp><bibnamefont|Tanaka> and <bibinfo> editor
      <bibfnamefont|T.><nbsp><bibnamefont|Shintake>, eds.,
      <hlink|<em|<bibinfo>title SCSS X-FEL Conceptual Design
      Report>|http://www-xfel.spring8.or.jp/> (<bibinfo>address RIKEN, Japan,
      <bibinfo> year 2005)<BibitemShut|NoStop><bibitem-with-key| (2007), , ,
      , , , , , , , , , , , , , , , , , , , , , , , and |XFEL><BibitemOpen>
      <bibinfo>editor <bibfnamefont|M.><nbsp><bibnamefont|Altarelli>,
      <bibinfo> editor <bibfnamefont|R.><nbsp><bibnamefont|Brinkmann>,
      <bibinfo>editor <bibfnamefont|M.><nbsp><bibnamefont|Chergui>,
      <bibinfo>editor <bibfnamefont|W.><nbsp><bibnamefont|Decking>,
      <bibinfo>editor <bibfnamefont|B.><nbsp><bibnamefont|Dobson>,
      <bibinfo>editor <bibfnamefont|S.><nbsp><bibnamefont|Dsterer>,
      <bibinfo>editor <bibfnamefont|G.><nbsp><bibnamefont|Grbel>,
      <bibinfo>editor <bibfnamefont|W.><nbsp><bibnamefont|Graeff>,
      <bibinfo>editor <bibfnamefont|H.><nbsp><bibnamefont|Graafsma>,
      <bibinfo>editor <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>,
      <bibinfo>editor <bibfnamefont|J.><nbsp><bibnamefont|Marangos>,
      <bibinfo>editor <bibfnamefont|J.><nbsp><bibnamefont|Pflger>,
      <bibinfo>editor <bibfnamefont|H.><nbsp><bibnamefont|Redlin>,
      <bibinfo>editor <bibfnamefont|D.><nbsp><bibnamefont|Riley>,
      <bibinfo>editor <bibfnamefont|I.><nbsp><bibnamefont|Robinson>,
      <bibinfo>editor <bibfnamefont|J.><nbsp><bibnamefont|Rossbach>,
      <bibinfo>editor <bibfnamefont|A.><nbsp><bibnamefont|Schwarz>,
      <bibinfo>editor <bibfnamefont|K.><nbsp><bibnamefont|Tiedtke>,
      <bibinfo>editor <bibfnamefont|T.><nbsp><bibnamefont|Tschentscher>,
      <bibinfo>editor <bibfnamefont|I.><nbsp><bibnamefont|Vartaniants>,
      <bibinfo>editor <bibfnamefont|H.><nbsp><bibnamefont|Wabnitz>,
      <bibinfo>editor <bibfnamefont|H.><nbsp><bibnamefont|Weise>,
      <bibinfo>editor <bibfnamefont|R.><nbsp><bibnamefont|Wichmann>,
      <bibinfo>editor <bibfnamefont|K.><nbsp><bibnamefont|Witte>,
      <bibinfo>editor <bibfnamefont|A.><nbsp><bibnamefont|Wolf>,
      <bibinfo>editor <bibfnamefont|M.><nbsp><bibnamefont|Wulff>, \ and
      <bibinfo>editor <bibfnamefont|M.><nbsp><bibnamefont|Yurkov>, eds.,
      <hlink|<em|<bibinfo> title The European X-Ray Free-Electron Laser
      Technical Design Report>|http://xfel.desy.de/tdr/tdr/>

      \ (<bibinfo>address DESY, Germany, <bibinfo>year
      2007)<BibitemShut|NoStop><bibitem-with-key|(2000)|Hajdu00><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Curr. Opin. Struct.
      Biol. <with|font-series|bold|<bibinfo>volume 10>, <bibinfo>pages 569
      (<bibinfo>year 2000)<BibitemShut|NoStop><bibitem-with-key| and
      (2007)|Gaffney07><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|K.<nbsp>J.> <bibnamefont|Gaffney> and <bibinfo>author
      <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Science
      <with|font-series|bold|<bibinfo>volume 316>, <bibinfo>pages 1444
      (<bibinfo>year 2007)<BibitemShut|NoStop><bibitem-with-key| (2008), , ,
      and |Miao08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Miao>, <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Ishikawa>, <bibinfo>author
      <bibfnamefont|Q.><nbsp><bibnamefont|Shen>, \ and <bibinfo> author
      <bibfnamefont|T.><nbsp><bibnamefont|Earnest>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Annu. Rev. Phys. Chem.
      <with|font-series|bold|<bibinfo>volume 59>, <bibinfo>pages 387
      (<bibinfo>year 2008)<BibitemShut|NoStop><bibitem-with-key| (1999), , ,
      and |Miao99><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Miao>, <bibinfo>author
      <bibfnamefont|P.><nbsp><bibnamefont|Charalambous>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Kirz>, \ and <bibinfo> author
      <bibfnamefont|D.><nbsp><bibnamefont|Sayre>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Nature
      <with|font-series|bold|<bibinfo> volume 400>, <bibinfo>pages 342
      (<bibinfo>year 1999)<BibitemShut|NoStop><bibitem-with-key| (2001), , ,
      , and |Robinson01><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|I.<nbsp>K.> <bibnamefont|Robinson>, <bibinfo>author
      <bibfnamefont|I.<nbsp>A.> <bibnamefont|Vartanyants>, <bibinfo>author
      <bibfnamefont|G.<nbsp>J.> <bibnamefont|Williams>, <bibinfo>author
      <bibfnamefont|M.<nbsp>A.> <bibnamefont|Pfeifer>, \ and <bibinfo>author
      <bibfnamefont|J.<nbsp>A.> <bibnamefont|Pitney>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo>volume 87>, <bibinfo>pages 195505
      (<bibinfo>year 2001)<BibitemShut|NoStop><bibitem-with-key| (2006), , ,
      , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , and
      |Chapman06><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Barty>, <bibinfo>author
      <bibfnamefont|M.<nbsp>J.> <bibnamefont|Bogan>, <bibinfo> author
      <bibfnamefont|S.><nbsp><bibnamefont|Boutet>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Frank>, <bibinfo>author
      <bibfnamefont|S.<nbsp>P.> <bibnamefont|Hau-Riege>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Marchesini>, <bibinfo>author
      <bibfnamefont|B.<nbsp>W.>

      \ <bibnamefont|Woods>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Bajt>, <bibinfo>author
      <bibfnamefont|W.<nbsp>H.> <bibnamefont|Benner>, <bibinfo>author
      <bibfnamefont|R.<nbsp>A.> <bibnamefont|London>, <bibinfo> author
      <bibfnamefont|E.><nbsp><bibnamefont|Plnjes>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Kuhlmann>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Treusch>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Dsterer>, <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Tschentscher>, <bibinfo>author
      <bibfnamefont|J.<nbsp>R.>

      \ <bibnamefont|Schneider>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Spiller>, <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Mller>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Bostedt>, <bibinfo> author
      <bibfnamefont|M.><nbsp><bibnamefont|Hoener>, <bibinfo>author
      <bibfnamefont|D.<nbsp>A.> <bibnamefont|Shapiro>, <bibinfo>author
      <bibfnamefont|K.<nbsp>O.> <bibnamefont|Hodgson>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Van<nbsp>der Spoel>,
      <bibinfo>author <bibfnamefont|F.><nbsp><bibnamefont|Burmeister>,
      <bibinfo>author <bibfnamefont|M.><nbsp><bibnamefont|Bergh>,
      <bibinfo>author <bibfnamefont|C.><nbsp><bibnamefont|Caleman>,
      <bibinfo>author <bibfnamefont|G.><nbsp><bibnamefont|Huldt>,
      <bibinfo>author <bibfnamefont|M.<nbsp>M.>

      \ <bibnamefont|Seibert>, <bibinfo>author <bibfnamefont|F.<nbsp>R.
      N.<nbsp>C.>

      \ <bibnamefont|Maia>, <bibinfo>author <bibfnamefont|R.<nbsp>W.>
      <bibnamefont|Lee>, <bibinfo>author <bibfnamefont|A.><nbsp><bibnamefont|Szke>,
      <bibinfo>author <bibfnamefont|N.><nbsp><bibnamefont|Timneanu>, \ and

      \ <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Nature Phys.
      <with|font-series|bold|<bibinfo> volume 2>, <bibinfo>pages 839
      (<bibinfo>year 2006)<BibitemShut|NoStop><bibitem-with-key| (2007), , ,
      , , , , , , , , , , , , , , , , , , , , , , and
      |Chapman07><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>, <bibinfo>author
      <bibfnamefont|S.<nbsp>P.> <bibnamefont|Hau-Riege>, <bibinfo>author
      <bibfnamefont|M.<nbsp>J.> <bibnamefont|Bogan>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Bajt>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Barty>, <bibinfo> author
      <bibfnamefont|S.><nbsp><bibnamefont|Boutet>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Marchesini>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Frank>, <bibinfo>author
      <bibfnamefont|B.<nbsp>W.> <bibnamefont|Woods>, <bibinfo>author
      <bibfnamefont|W.<nbsp>H.>

      \ <bibnamefont|Benner>, <bibinfo>author <bibfnamefont|R.<nbsp>A.>

      \ <bibnamefont|London>, <bibinfo>author
      <bibfnamefont|U.><nbsp><bibnamefont|Rohner>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Szke>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Spiller>, <bibinfo> author
      <bibfnamefont|T.><nbsp><bibnamefont|Mller>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Bostedt>, <bibinfo>author
      <bibfnamefont|D.<nbsp>A.> <bibnamefont|Shapiro>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Kuhlmann>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Treusch>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Plnjes>, <bibinfo>author
      <bibfnamefont|F.><nbsp><bibnamefont|Burmeister>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Bergh>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Caleman>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Huldt>, <bibinfo>author
      <bibfnamefont|M.<nbsp>M.>

      \ <bibnamefont|Seibert>, \ and <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>, <hlink||>@noop
      \ <bibfield>journal <bibinfo> journal Nature
      <with|font-series|bold|<bibinfo>volume 448>, <bibinfo>pages 676
      (<bibinfo>year 2007)<BibitemShut|NoStop><bibitem-with-key| (2008), , ,
      , , , , , and |Schmidt08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|K.<nbsp>E.> <bibnamefont|Schmidt>, <bibinfo>author
      <bibfnamefont|J.<nbsp>C.<nbsp>H.> <bibnamefont|Spence>, <bibinfo>author
      <bibfnamefont|U.><nbsp><bibnamefont|Weierstall>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Kirian>, <bibinfo> author
      <bibfnamefont|X.><nbsp><bibnamefont|Wang>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Starodub>, <bibinfo>author
      <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>, <bibinfo>author
      <bibfnamefont|M.<nbsp>R.> <bibnamefont|Howells>, \ and <bibinfo>author
      <bibfnamefont|R.<nbsp>B.> <bibnamefont|Doak>, <hlink||>@noop
      \ <bibfield> journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo> volume 101>, <bibinfo>pages 115507
      (<bibinfo>year 2008)<BibitemShut|NoStop><bibitem-with-key| (2008), , ,
      , , , , , , , , , , , , , , and |Barty08><BibitemOpen> <bibfield>author
      <bibinfo>author <bibfnamefont|A.><nbsp><bibnamefont|Barty>,
      <bibinfo>author <bibfnamefont|S.><nbsp><bibnamefont|Boutet>,
      <bibinfo>author <bibfnamefont|M.<nbsp>J.> <bibnamefont|Bogan>,
      <bibinfo> author <bibfnamefont|S.><nbsp><bibnamefont|Hau-Riege>,
      <bibinfo>author <bibfnamefont|S.><nbsp><bibnamefont|Marchesini>,
      <bibinfo>author <bibfnamefont|K.><nbsp><bibnamefont|Sokolowski-Tinten>,
      <bibinfo>author <bibfnamefont|N.><nbsp><bibnamefont|Stojanovic>,
      <bibinfo>author <bibfnamefont|R.><nbsp><bibnamefont|Tobey>,
      <bibinfo>author <bibfnamefont|H.><nbsp><bibnamefont|Ehrke>,
      <bibinfo>author <bibfnamefont|A.><nbsp><bibnamefont|Cavalleri>,
      <bibinfo>author <bibfnamefont|S.><nbsp><bibnamefont|Dsterer>,
      <bibinfo>author <bibfnamefont|M.><nbsp><bibnamefont|Frank>,
      <bibinfo>author <bibfnamefont|S.><nbsp><bibnamefont|Bajt>,
      <bibinfo>author <bibfnamefont|B.<nbsp>W.>

      \ <bibnamefont|Woods>, <bibinfo>author <bibfnamefont|M.<nbsp>M.>
      <bibnamefont|Seibert>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Treusch>, \ and

      \ <bibinfo>author <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Nature Photon.

      \ <with|font-series|bold|<bibinfo>volume 2>, <bibinfo>pages 415
      (<bibinfo>year 2008)<BibitemShut|NoStop><bibitem-with-key| (2008), , ,
      , , , , , , , , , , , , , , and |Marchesini08><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|S.><nbsp><bibnamefont|Marchesini>,
      <bibinfo>author <bibfnamefont|S.><nbsp><bibnamefont|Boutet>,
      <bibinfo>author <bibfnamefont|A.<nbsp>E.> <bibnamefont|Sakdinawat>,
      <bibinfo>author <bibfnamefont|M.<nbsp>J.> <bibnamefont|Bogan>,
      <bibinfo> author <bibfnamefont|S.><nbsp><bibnamefont|Bajt>,
      <bibinfo>author <bibfnamefont|A.><nbsp><bibnamefont|Barty>,
      <bibinfo>author <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>,
      <bibinfo>author <bibfnamefont|M.><nbsp><bibnamefont|Frank>,
      <bibinfo>author <bibfnamefont|S.<nbsp>P.>

      \ <bibnamefont|Hau-Riege>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Szke>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Cui>, <bibinfo>author
      <bibfnamefont|D.<nbsp>A.> <bibnamefont|Shapiro>, <bibinfo> author
      <bibfnamefont|M.<nbsp>R.> <bibnamefont|Howells>, <bibinfo>author
      <bibfnamefont|J.<nbsp>C.<nbsp>H.> <bibnamefont|Spence>, <bibinfo>author
      <bibfnamefont|J.<nbsp>W.> <bibnamefont|Shaevitz>, <bibinfo>author
      <bibfnamefont|J.<nbsp>Y.> <bibnamefont|Lee>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>, \ and <bibinfo>author
      <bibfnamefont|M.<nbsp>M.>

      \ <bibnamefont|Seibert>, <hlink||>@noop \ <bibfield>journal <bibinfo>
      journal Nature Photon. <with|font-series|bold|<bibinfo>volume 2>,
      <bibinfo> pages 560 (<bibinfo>year 2008)<BibitemShut|NoStop><bibitem-with-key|
      (2008), , , , , , , , , , , , , , , , , and |Bogan08><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|M.<nbsp>J.>
      <bibnamefont|Bogan>, <bibinfo>author <bibfnamefont|W.<nbsp>H.>
      <bibnamefont|Benner>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Boutet>, <bibinfo> author
      <bibfnamefont|U.><nbsp><bibnamefont|Rohner>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Frank>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Barty>, <bibinfo>author
      <bibfnamefont|M.<nbsp>M.>

      \ <bibnamefont|Seibert>, <bibinfo>author
      <bibfnamefont|F.><nbsp><bibnamefont|Maia>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Marchesini>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Bajt>, <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Woods>, <bibinfo>author
      <bibfnamefont|V.><nbsp><bibnamefont|Riot>, <bibinfo>author
      <bibfnamefont|S.<nbsp>P.>

      \ <bibnamefont|Hau-Riege>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Svenda>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Marklund>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Spiller>, <bibinfo> author
      <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>, \ and <bibinfo>author
      <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>, <hlink||>@noop
      \ <bibfield> journal <bibinfo>journal Nano Lett.
      <with|font-series|bold|<bibinfo>volume 8>, <bibinfo>pages 310
      (<bibinfo>year 2008)<BibitemShut|NoStop><bibitem-with-key| (2009), , ,
      , and |Nishino09><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|Y.><nbsp><bibnamefont|Nishino>, <bibinfo>author
      <bibfnamefont|Y.><nbsp><bibnamefont|Takahashi>, <bibinfo>author
      <bibfnamefont|N.><nbsp><bibnamefont|Imamoto>, <bibinfo> author
      <bibfnamefont|T.><nbsp><bibnamefont|Ishikawa>, \ and <bibinfo> author
      <bibfnamefont|K.><nbsp><bibnamefont|Maeshima>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo>volume 102>, <bibinfo>pages 018101
      (<bibinfo>year 2009)<BibitemShut|NoStop><bibitem-with-key| (2009), , ,
      , , , , , , , , , , and |Howells09><BibitemOpen> <bibfield>author
      <bibinfo>author <bibfnamefont|M.<nbsp>R.> <bibnamefont|Howells>,
      <bibinfo>author <bibfnamefont|T.><nbsp><bibnamefont|Beetz>,
      <bibinfo>author <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>,
      <bibinfo> author <bibfnamefont|C.><nbsp><bibnamefont|Cui>,
      <bibinfo>author <bibfnamefont|J.<nbsp>M.> <bibnamefont|Holton>,
      <bibinfo>author <bibfnamefont|C.<nbsp>J.> <bibnamefont|Jacobsen>,
      <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|Kirz>,
      <bibinfo>author <bibfnamefont|E.><nbsp><bibnamefont|Lima>,
      <bibinfo>author <bibfnamefont|S.><nbsp><bibnamefont|Marchesini>,
      <bibinfo>author <bibfnamefont|H.><nbsp><bibnamefont|Miao>,
      <bibinfo>author <bibfnamefont|D.><nbsp><bibnamefont|Sayre>, <bibinfo>
      author <bibfnamefont|D.<nbsp>A.> <bibnamefont|Shapiro>, <bibinfo>author
      <bibfnamefont|J.<nbsp>C.<nbsp>H.> <bibnamefont|Spence>, \ and
      <bibinfo>author <bibfnamefont|D.><nbsp><bibnamefont|Starodub>,
      <hlink||>@noop \ <bibfield> journal <bibinfo>journal J. Electron
      Spectrosc. Relat. Phenom.

      \ <with|font-series|bold|<bibinfo>volume 170>, <bibinfo>pages 4
      (<bibinfo>year 2009)<BibitemShut|NoStop><bibitem-with-key| (2002), , ,
      , , , , , , , , , , , , , , , , , , and |Wabnitz02><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|H.><nbsp><bibnamefont|Wabnitz>,
      <bibinfo>author <bibfnamefont|L.><nbsp><bibnamefont|Bittner>,
      <bibinfo>author <bibfnamefont|A.<nbsp>R.<nbsp>B.>
      <bibnamefont|de<nbsp>Castro>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Dhrmann>, <bibinfo> author
      <bibfnamefont|P.><nbsp><bibnamefont|Grtler>, <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Laarmann>, <bibinfo>author
      <bibfnamefont|W.><nbsp><bibnamefont|Laasch>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Schulz>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Swiderski>, <bibinfo>author
      <bibfnamefont|K.><nbsp><bibnamefont|von Haeften>, <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Mller>, <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Faatz>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Fateev>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Feldhaus>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Gerth>, <bibinfo>author
      <bibfnamefont|U.><nbsp><bibnamefont|Hahn>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Saldin>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Schneidmiller>, <bibinfo>author
      <bibfnamefont|K.><nbsp><bibnamefont|Sytchev>, <bibinfo>author
      <bibfnamefont|K.><nbsp><bibnamefont|Tiedtke>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Treusch>, \ and

      \ <bibinfo>author <bibfnamefont|M.><nbsp><bibnamefont|Yurkov>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Nature
      <with|font-series|bold|<bibinfo> volume 420>, <bibinfo>pages 482
      (<bibinfo>year 2002)<BibitemShut|NoStop><bibitem-with-key| and
      (2002)|Saalmann02><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|U.><nbsp><bibnamefont|Saalmann> and <bibinfo>author
      <bibfnamefont|J.-M.> <bibnamefont|Rost>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo>volume 89>, <bibinfo>pages 143401
      (<bibinfo>year 2002)<BibitemShut|NoStop><bibitem-with-key| (2009a), , ,
      , and |Ziaja09a><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Ziaja>, <bibinfo>author
      <bibfnamefont|H.><nbsp><bibnamefont|Wabnitz>, <bibinfo>author
      <bibfnamefont|F.><nbsp><bibnamefont|Wang>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Weckert>, \ and <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Mller>, <hlink||>@noop
      \ <bibfield> journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo> volume 102>, <bibinfo>pages 205002
      (<bibinfo>year 2009a)<BibitemShut|NoStop><bibitem-with-key|(1995)|Henderson95><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|R.><nbsp><bibnamefont|Henderson>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Q. Rev. Biophys.
      <with|font-series|bold|<bibinfo>volume 28>, <bibinfo>pages 171
      (<bibinfo>year 1995)<BibitemShut|NoStop><bibitem-with-key| and
      (1982)|Solem82><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|J.<nbsp>C.> <bibnamefont|Solem> and <bibinfo>author
      <bibfnamefont|G.<nbsp>C.> <bibnamefont|Baldwin>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Science
      <with|font-series|bold|<bibinfo>volume 218>, <bibinfo>pages 229
      (<bibinfo>year 1982)<BibitemShut|NoStop><bibitem-with-key| (2000), , ,
      , and |Neutze00><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Neutze>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Wouts>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|van der Spoel>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Weckert>, \ and

      \ <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Nature
      <with|font-series|bold|<bibinfo> volume 406>, <bibinfo>pages 752
      (<bibinfo>year 2000)<BibitemShut|NoStop>

      <\bibitem-with-key>
        \ (2004a), ,

        \ and
      </bibitem-with-key|Jurek04>

      <BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|Z.><nbsp><bibnamefont|Jurek>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Faigel>,\ 

      \ and <bibinfo>author <bibfnamefont|M.><nbsp><bibnamefont|Tegze>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Eur. Phys. J. D

      \ <with|font-series|bold|<bibinfo>volume 29>, <bibinfo>pages 217
      (<bibinfo>year 2004a)<BibitemShut|NoStop><bibitem-with-key| (2004b), ,
      and |Jurek04a><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|Z.><nbsp><bibnamefont|Jurek>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Oszlnyi>, \ and <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Faigel>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Europhys. Lett.

      \ <with|font-series|bold|<bibinfo>volume 65>, <bibinfo>pages 491
      (<bibinfo>year 2004b)<BibitemShut|NoStop><bibitem-with-key| (2004), ,
      and |Bergh04><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Bergh>, <bibinfo>author
      <bibfnamefont|N.><nbsp><bibnamefont|T<math|<wide|<text|\Y>|^>>mneanu>,
      \ and <bibinfo>author <bibfnamefont|D.><nbsp><bibnamefont|van<nbsp>der
      Spoel>, <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev.
      E <with|font-series|bold|<bibinfo>volume 70>, <bibinfo>pages 051904
      (<bibinfo>year 2004)<BibitemShut|NoStop><bibitem-with-key| (2005), , ,
      and |Faigel05><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Faigel>, <bibinfo>author
      <bibfnamefont|Z.><nbsp><bibnamefont|Jurek>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Oszlanyi>, \ and

      \ <bibinfo>author <bibfnamefont|M.><nbsp><bibnamefont|Tegze>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Alloys Compd.
      <with|font-series|bold|<bibinfo>volume 401>, <bibinfo>pages 86
      (<bibinfo>year 2005)<BibitemShut|NoStop><bibitem-with-key| and
      (2008)|Jurek08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|Z.><nbsp><bibnamefont|Jurek> and <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Faigel>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Eur. Phys. J. D

      \ <with|font-series|bold|<bibinfo>volume 50>, <bibinfo>pages 35
      (<bibinfo>year 2008)<BibitemShut|NoStop><bibitem-with-key| and
      (2009)|Jurek09><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|Z.><nbsp><bibnamefont|Jurek> and <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Faigel>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Europhys. Lett.

      \ <with|font-series|bold|<bibinfo>volume 86>, <bibinfo>pages 68003
      (<bibinfo>year 2009)<BibitemShut|NoStop><bibitem-with-key| (2004), ,
      and |Hau-Riege04><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|S.<nbsp>P.> <bibnamefont|Hau-Riege>, <bibinfo>author
      <bibfnamefont|R.<nbsp>A.> <bibnamefont|London>, \ and <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Szoke>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. E
      <with|font-series|bold|<bibinfo>volume 69>, <bibinfo>pages 051906
      (<bibinfo>year 2004)<BibitemShut|NoStop>

      <\bibitem-with-key>
        \ (2005), , , and
      </bibitem-with-key|Hau-Riege05>

      <BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|S.<nbsp>P.> <bibnamefont|Hau-Riege>, <bibinfo>author
      <bibfnamefont|R.<nbsp>A.> <bibnamefont|London>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Huldt>,\ 

      \ and <bibinfo>author <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. E

      \ <with|font-series|bold|<bibinfo>volume 71>, <bibinfo>pages 061919
      (<bibinfo> year 2005)<BibitemShut|NoStop><bibitem-with-key| (2007a), ,
      , , and |Hau-Riege07b><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|S.<nbsp>P.> <bibnamefont|Hau-Riege>, <bibinfo>author
      <bibfnamefont|R.<nbsp>A.> <bibnamefont|London>, <bibinfo>author
      <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Szoke>, \ and <bibinfo> author
      <bibfnamefont|N.><nbsp><bibnamefont|Timneanu>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo>volume 98>, <bibinfo>pages 198302
      (<bibinfo>year 2007a)<BibitemShut|NoStop><bibitem-with-key| (2007b), ,
      , and |Hau-Riege07c><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|S.<nbsp>P.> <bibnamefont|Hau-Riege>, <bibinfo>author
      <bibfnamefont|R.<nbsp>A.> <bibnamefont|London>, <bibinfo>author
      <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>, \ and <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Bergh>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. E

      \ <with|font-series|bold|<bibinfo>volume 76>, <bibinfo>pages 046403
      (<bibinfo> year 2007b)<BibitemShut|NoStop><bibitem-with-key| and
      (2008)|Hau-Riege08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|S.<nbsp>P.> <bibnamefont|Hau-Riege> and <bibinfo>author
      <bibfnamefont|H.<nbsp>N.> <bibnamefont|Chapman>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. E
      <with|font-series|bold|<bibinfo>volume 77>, <bibinfo>pages 041902
      (<bibinfo>year 2008)<BibitemShut|NoStop><bibitem-with-key| (2006a), , ,
      and |Ziaja06a><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Ziaja>, <bibinfo>author
      <bibfnamefont|A.<nbsp>R.<nbsp>B.> <bibnamefont|de<nbsp>Castro>,
      <bibinfo>author <bibfnamefont|E.><nbsp><bibnamefont|Weckert>, \ and
      <bibinfo>author <bibfnamefont|T.><nbsp><bibnamefont|Mller>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Eur. Phys. J. D

      \ <with|font-series|bold|<bibinfo>volume 40>, <bibinfo>pages 465
      (<bibinfo>year 2006a)<BibitemShut|NoStop><bibitem-with-key| (2008a), ,
      , and |Ziaja08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Ziaja>, <bibinfo>author
      <bibfnamefont|H.><nbsp><bibnamefont|Wabnitz>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Weckert>, \ and

      \ <bibinfo>author <bibfnamefont|T.><nbsp><bibnamefont|Mller>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal New J. Phys.

      \ <with|font-series|bold|<bibinfo>volume 10>, <bibinfo>pages 043003
      (<bibinfo> year 2008a)<BibitemShut|NoStop><bibitem-with-key| (2008b), ,
      , and |Ziaja08a><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Ziaja>, <bibinfo>author
      <bibfnamefont|H.><nbsp><bibnamefont|Wabnitz>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Weckert>, \ and

      \ <bibinfo>author <bibfnamefont|T.><nbsp><bibnamefont|Mller>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Europhys. Lett.

      \ <with|font-series|bold|<bibinfo>volume 82>, <bibinfo>pages 24002
      (<bibinfo>year 2008b)<BibitemShut|NoStop><bibitem-with-key| (2009b), ,
      , , , , and |Ziaja09><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Ziaja>, <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Laarmann>, <bibinfo>author
      <bibfnamefont|H.><nbsp><bibnamefont|Wabnitz>, <bibinfo> author
      <bibfnamefont|F.><nbsp><bibnamefont|Wang>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Weckert>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Bostedt>, \ and <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Mller>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal New J. Phys.
      <with|font-series|bold|<bibinfo>volume 11>,

      \ <bibinfo>pages 103012 (<bibinfo>year
      2009b)<BibitemShut|NoStop><bibitem-with-key| (1998), , and
      |Moribayashi98><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|K.><nbsp><bibnamefont|Moribayashi>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Sasaki>, \ and <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Tajima>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. A

      \ <with|font-series|bold|<bibinfo>volume 58>, <bibinfo>pages 2007
      (<bibinfo>year 1998)<BibitemShut|NoStop><bibitem-with-key| and
      (2007)|Rohringer07><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|N.><nbsp><bibnamefont|Rohringer> and <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Santra>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. A
      <with|font-series|bold|<bibinfo>volume 76>, <bibinfo>pages 033416
      (<bibinfo>year 2007)<BibitemShut|NoStop><bibitem-with-key| (2004), ,
      and |Moribayashi04><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|K.><nbsp><bibnamefont|Moribayashi>, <bibinfo>author
      <bibfnamefont|T.><nbsp><bibnamefont|Kagawa>, \ and <bibinfo>author
      <bibfnamefont|D.<nbsp>E.> <bibnamefont|Kim>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Phys. B: At.
      Mol. Opt. Phys. <with|font-series|bold|<bibinfo>volume 37>,
      <bibinfo>pages 4119 (<bibinfo>year 2004)<BibitemShut|NoStop><bibitem-with-key|(2007)|Moribayashi07><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|K.><nbsp><bibnamefont|Moribayashi>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. A
      <with|font-series|bold|<bibinfo>volume 76>, <bibinfo>pages 042705
      (<bibinfo>year 2007)<BibitemShut|NoStop><bibitem-with-key|(2008)|Moribayashi08><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|K.><nbsp><bibnamefont|Moribayashi>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Phys. B: At.
      Mol. Opt. Phys. <with|font-series|bold|<bibinfo>volume 41>,

      \ <bibinfo>pages 085602 (<bibinfo>year
      2008)<BibitemShut|NoStop><bibitem-with-key|(2010)|Kai10><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|T.><nbsp><bibnamefont|Kai>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. A
      <with|font-series|bold|<bibinfo>volume 81>, <bibinfo>pages 023201
      (<bibinfo>year 2010)<BibitemShut|NoStop><bibitem-with-key|(2007)|Hau-Riege07><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|S.<nbsp>P.>
      <bibnamefont|Hau-Riege>, <hlink||>@noop \ <bibfield>journal
      <bibinfo>journal Phys. Rev. A <with|font-series|bold|<bibinfo>volume
      76>, <bibinfo>pages 042511 (<bibinfo>year
      2007)<BibitemShut|NoStop><bibitem-with-key| (2010), , , , , , , , , , ,
      , , , , , , , , , , , and |Young10><BibitemOpen> <bibfield>author
      <bibinfo>author <bibfnamefont|L.><nbsp><bibnamefont|Young>,
      <bibinfo>author <bibfnamefont|E.<nbsp>P.> <bibnamefont|Kanter>,
      <bibinfo>author <bibfnamefont|B.><nbsp><bibnamefont|Krssig>, <bibinfo>
      author <bibfnamefont|Y.><nbsp><bibnamefont|Li>, <bibinfo>author
      <bibfnamefont|A.<nbsp>M.> <bibnamefont|March>, <bibinfo>author
      <bibfnamefont|S.<nbsp>T.> <bibnamefont|Pratt>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Santra>, <bibinfo>author
      <bibfnamefont|S.<nbsp>H.> <bibnamefont|Southworth>, <bibinfo>author
      <bibfnamefont|N.><nbsp><bibnamefont|Rohringer>, <bibinfo>author
      <bibfnamefont|L.<nbsp>F.>

      \ <bibnamefont|DiMauro>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Doumy>, <bibinfo>author
      <bibfnamefont|C.<nbsp>A.> <bibnamefont|Roedig>, <bibinfo>author
      <bibfnamefont|N.><nbsp><bibnamefont|Berrah>, <bibinfo> author
      <bibfnamefont|L.><nbsp><bibnamefont|Fang>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Hoener>, <bibinfo>author
      <bibfnamefont|P.<nbsp>H.> <bibnamefont|Bucksbaum>, <bibinfo>author
      <bibfnamefont|J.<nbsp>P.>

      \ <bibnamefont|Cryan>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Ghimire>, <bibinfo>author
      <bibfnamefont|J.<nbsp>M.> <bibnamefont|Glownia>, <bibinfo>author
      <bibfnamefont|D.<nbsp>A.> <bibnamefont|Reis>, <bibinfo>author
      <bibfnamefont|J.<nbsp>D.> <bibnamefont|Bozek>, <bibinfo> author
      <bibfnamefont|C.><nbsp><bibnamefont|Bostedt>, \ and <bibinfo> author
      <bibfnamefont|M.><nbsp><bibnamefont|Messerschmidt>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Nature
      <with|font-series|bold|<bibinfo> volume 466>, <bibinfo>pages 56
      (<bibinfo>year 2010)<BibitemShut|NoStop><bibitem-with-key| (2010), , ,
      , , , , , , , , , , , , , , , , , , , , , , and |Hoener10><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|M.><nbsp><bibnamefont|Hoener>,
      <bibinfo>author <bibfnamefont|L.><nbsp><bibnamefont|Fang>,
      <bibinfo>author <bibfnamefont|O.><nbsp><bibnamefont|Kornilov>,
      <bibinfo> author <bibfnamefont|O.><nbsp><bibnamefont|Gessner>,
      <bibinfo>author <bibfnamefont|S.<nbsp>T.> <bibnamefont|Pratt>,
      <bibinfo>author <bibfnamefont|M.><nbsp><bibnamefont|Ghr>,
      <bibinfo>author <bibfnamefont|E.<nbsp>P.> <bibnamefont|Kanter>,
      <bibinfo>author <bibfnamefont|C.><nbsp><bibnamefont|Blaga>,
      <bibinfo>author <bibfnamefont|C.><nbsp><bibnamefont|Bostedt>,
      <bibinfo>author <bibfnamefont|J.<nbsp>D.>

      \ <bibnamefont|Bozek>, <bibinfo>author <bibfnamefont|P.<nbsp>H.>
      <bibnamefont|Bucksbaum>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Buth>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Chen>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Coffee>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Cryan>, <bibinfo>author
      <bibfnamefont|L.><nbsp><bibnamefont|DiMauro>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Glownia>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Hosler>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Kukk>, <bibinfo>author
      <bibfnamefont|S.<nbsp>R.>

      \ <bibnamefont|Leone>, <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|McFarland>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Messerschmidt>, <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Murphy>, <bibinfo>author
      <bibfnamefont|V.><nbsp><bibnamefont|Petrovic>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Rolles>, \ and <bibinfo> author
      <bibfnamefont|N.><nbsp><bibnamefont|Berrah>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo>volume 104>, <bibinfo>pages 253002
      (<bibinfo>year 2010)<BibitemShut|NoStop><bibitem-with-key| (2010), , ,
      , , , , , , , , , , , , , , , , , , , , , , , , , , , , and
      |Cryan10><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|J.<nbsp>P.> <bibnamefont|Cryan>, <bibinfo>author
      <bibfnamefont|J.<nbsp>M.> <bibnamefont|Glownia>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Andreasson>, <bibinfo> author
      <bibfnamefont|A.><nbsp><bibnamefont|Belkacem>, <bibinfo>author
      <bibfnamefont|N.><nbsp><bibnamefont|Berrah>, <bibinfo>author
      <bibfnamefont|C.<nbsp>I.> <bibnamefont|Blaga>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Bostedt>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Bozek>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Buth>, <bibinfo>author
      <bibfnamefont|L.<nbsp>F.>

      \ <bibnamefont|DiMauro>, <bibinfo>author
      <bibfnamefont|L.><nbsp><bibnamefont|Fang>, <bibinfo>author
      <bibfnamefont|O.><nbsp><bibnamefont|Gessner>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Guehr>, <bibinfo> author
      <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>, <bibinfo>author
      <bibfnamefont|M.<nbsp>P.> <bibnamefont|Hertlein>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Hoener>, <bibinfo>author
      <bibfnamefont|O.><nbsp><bibnamefont|Kornilov>, <bibinfo>author
      <bibfnamefont|J.<nbsp>P.>

      \ <bibnamefont|Marangos>, <bibinfo>author <bibfnamefont|A.<nbsp>M.>

      \ <bibnamefont|March>, <bibinfo>author <bibfnamefont|B.<nbsp>K.>
      <bibnamefont|McFarland>, <bibinfo>author
      <bibfnamefont|H.><nbsp><bibnamefont|Merdji>, <bibinfo>author
      <bibfnamefont|V.<nbsp>S.> <bibnamefont|Petrovi>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Raman>, <bibinfo> author
      <bibfnamefont|D.><nbsp><bibnamefont|Ray>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Reis>, <bibinfo>author
      <bibfnamefont|F.><nbsp><bibnamefont|Tarantelli>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Trigo>, <bibinfo>author
      <bibfnamefont|J.<nbsp>L.>

      \ <bibnamefont|White>, <bibinfo>author
      <bibfnamefont|W.><nbsp><bibnamefont|White>, <bibinfo>author
      <bibfnamefont|L.><nbsp><bibnamefont|Young>, <bibinfo>author
      <bibfnamefont|P.<nbsp>H.> <bibnamefont|Bucksbaum>, \ and

      \ <bibinfo>author <bibfnamefont|R.<nbsp>N.> <bibnamefont|Coffee>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. Lett.

      \ <with|font-series|bold|<bibinfo>volume 105>, <bibinfo>pages 083004
      (<bibinfo> year 2010)<BibitemShut|NoStop><bibitem-with-key| (2010), , ,
      , , , , , , , , , , , , , , , and |Fang10><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|L.><nbsp><bibnamefont|Fang>,
      <bibinfo>author <bibfnamefont|M.><nbsp><bibnamefont|Hoener>,
      <bibinfo>author <bibfnamefont|O.><nbsp><bibnamefont|Gessner>, <bibinfo>
      author <bibfnamefont|F.><nbsp><bibnamefont|Tarantelli>, <bibinfo>author
      <bibfnamefont|S.<nbsp>T.> <bibnamefont|Pratt>, <bibinfo>author
      <bibfnamefont|O.><nbsp><bibnamefont|Kornilov>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Buth>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Ghr>, <bibinfo>author
      <bibfnamefont|E.<nbsp>P.>

      \ <bibnamefont|Kanter>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Bostedt>, <bibinfo>author
      <bibfnamefont|J.<nbsp>D.> <bibnamefont|Bozek>, <bibinfo>author
      <bibfnamefont|P.<nbsp>H.> <bibnamefont|Bucksbaum>, <bibinfo> author
      <bibfnamefont|M.><nbsp><bibnamefont|Chen>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Coffee>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Cryan>, <bibinfo>author
      <bibfnamefont|M.><nbsp><bibnamefont|Glownia>, <bibinfo>author
      <bibfnamefont|E.><nbsp><bibnamefont|Kukk>, <bibinfo>author
      <bibfnamefont|S.<nbsp>R.>

      \ <bibnamefont|Leone>, \ and <bibinfo>author
      <bibfnamefont|N.><nbsp><bibnamefont|Berrah>, <hlink||>@noop
      \ <bibfield>journal <bibinfo> journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo>volume 105>, <bibinfo> pages 083005
      (<bibinfo>year 2010)<BibitemShut|NoStop><bibitem-with-key|(2009)|Santra09><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|R.><nbsp><bibnamefont|Santra>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Phys. B: At.
      Mol. Opt. Phys. <with|font-series|bold|<bibinfo>volume 42>, <bibinfo>
      pages 023001 (<bibinfo>year 2009)<BibitemShut|NoStop><bibitem-with-key|
      and (2007)|Buth07><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Buth> and <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Santra>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. A

      \ <with|font-series|bold|<bibinfo>volume 75>, <bibinfo>pages 033412
      (<bibinfo> year 2007)<BibitemShut|NoStop><bibitem-with-key| (2007), ,
      and |Buth07a><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Buth>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Santra>, \ and

      \ <bibinfo>author <bibfnamefont|L.><nbsp><bibnamefont|Young>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo>volume 98>, <bibinfo>pages 253001
      (<bibinfo>year 2007)<BibitemShut|NoStop><bibitem-with-key| and
      (2008)|Buth08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Buth> and <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Santra>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. A

      \ <with|font-series|bold|<bibinfo>volume 78>, <bibinfo>pages 043409
      (<bibinfo> year 2008)<BibitemShut|NoStop><bibitem-with-key| (2010), , ,
      , , , , , , , , and |Glover10><BibitemOpen> <bibfield>author
      <bibinfo>author <bibfnamefont|T.<nbsp>E.> <bibnamefont|Glover>,
      <bibinfo>author <bibfnamefont|M.<nbsp>P.> <bibnamefont|Hertlein>,
      <bibinfo>author <bibfnamefont|S.<nbsp>H.> <bibnamefont|Southworth>,
      <bibinfo>author <bibfnamefont|T.<nbsp>K.> <bibnamefont|Allison>,
      <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|van Tilborg>,
      <bibinfo>author <bibfnamefont|E.<nbsp>P.> <bibnamefont|Kanter>,
      <bibinfo>author <bibfnamefont|B.><nbsp><bibnamefont|Krssig>, <bibinfo>
      author <bibfnamefont|H.<nbsp>R.> <bibnamefont|Varma>, <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Rude>, <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Santra>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Belkacem>, \ and <bibinfo>author
      <bibfnamefont|L.><nbsp><bibnamefont|Young>, \ <bibfield>journal
      <bibinfo>journal Nature Phys. <with|font-series|bold|<bibinfo> volume
      6>, <bibinfo>pages 69 (<bibinfo>year
      2010)<BibitemShut|NoStop><bibitem-with-key| and
      (2008)|Ho08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|P.<nbsp>J.> <bibnamefont|Ho> and <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Santra>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. A

      \ <with|font-series|bold|<bibinfo>volume 78>, <bibinfo>pages 053409
      (<bibinfo> year 2008)<BibitemShut|NoStop><bibitem-with-key| (2009), , ,
      , , and |Ho09a><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|P.<nbsp>J.> <bibnamefont|Ho>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Starodub>, <bibinfo>author
      <bibfnamefont|D.<nbsp>K.> <bibnamefont|Saldin>, <bibinfo> author
      <bibfnamefont|V.<nbsp>L.> <bibnamefont|Shneerson>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Ourmazd>, \ and <bibinfo>author
      <bibfnamefont|R.><nbsp><bibnamefont|Santra>, <hlink||>@noop
      \ <bibfield> journal <bibinfo>journal J. Chem. Phys.
      <with|font-series|bold|<bibinfo>volume 131>, <bibinfo>pages 131101
      (<bibinfo>year 2009)<BibitemShut|NoStop><bibitem-with-key| (2010), ,
      and |Pabst10><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Pabst>, <bibinfo>author
      <bibfnamefont|P.<nbsp>J.> <bibnamefont|Ho>,\ 

      \ and <bibinfo>author <bibfnamefont|R.><nbsp><bibnamefont|Santra>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. A

      \ <with|font-series|bold|<bibinfo>volume 81>, <bibinfo>pages 043425
      (<bibinfo> year 2010)<BibitemShut|NoStop><bibitem-with-key| (2009), ,
      and |Makris09><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|M.<nbsp>G.> <bibnamefont|Makris>, <bibinfo>author
      <bibfnamefont|P.><nbsp><bibnamefont|Lambropoulos>, \ and
      <bibinfo>author <bibfnamefont|A.><nbsp><bibnamefont|Miheli>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo>volume 102>, <bibinfo>pages 033002
      (<bibinfo>year 2009)<BibitemShut|NoStop><bibitem-with-key| and
      (2001)|Thompson01><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|A.<nbsp>C.> <bibnamefont|Thompson> and <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Vaughan>,
      <hlink|<enquote|<bibinfo>title X-ray data booklet,>
      |http://xdb.lbl.gov/><bibinfo>address Center for X-ray Optics and
      Advanced Light Source, Lawrence Berkeley National Laboratory, Berkeley,
      CA (<bibinfo> year 2001)<BibitemShut|NoStop><bibitem-with-key| and
      (1965)|Carlson65><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|T.<nbsp>A.> <bibnamefont|Carlson> and <bibinfo>author
      <bibfnamefont|M.<nbsp>O.> <bibnamefont|Krause>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev.
      <with|font-series|bold|<bibinfo>volume 140>, <bibinfo>pages A1057
      (<bibinfo>year 1965)<BibitemShut|NoStop><bibitem-with-key| and
      (1992)|Omar92><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Omar> and <bibinfo>author
      <bibfnamefont|Y.><nbsp><bibnamefont|Hahn>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Z. Phys. D

      \ <with|font-series|bold|<bibinfo>volume 25>, <bibinfo>pages 31
      (<bibinfo>year 1992)<BibitemShut|NoStop><bibitem-with-key| (2001), , ,
      , and |Persson01><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|P.><nbsp><bibnamefont|Persson>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Lunell>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Szke>, <bibinfo> author
      <bibfnamefont|B.><nbsp><bibnamefont|Ziaja>, \ and <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>, <hlink||>@noop \ <bibfield>
      journal <bibinfo>journal Protein Sci.
      <with|font-series|bold|<bibinfo>volume 10>, <bibinfo>pages 2480
      (<bibinfo>year 2001)<BibitemShut|NoStop><bibitem-with-key| (2005), ,
      and |Ziaja05><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Ziaja>, <bibinfo>author
      <bibfnamefont|R.<nbsp>A.> <bibnamefont|London>,\ 

      \ and <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Appl. Phys.

      \ <with|font-series|bold|<bibinfo>volume 97>, <bibinfo>pages 064905
      (<bibinfo> year 2005)<BibitemShut|NoStop>

      <\bibitem-with-key>
        \ (2006b), ,

        \ and
      </bibitem-with-key|Ziaja06>

      <BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|B.><nbsp><bibnamefont|Ziaja>, <bibinfo>author
      <bibfnamefont|R.<nbsp>A.> <bibnamefont|London>,\ 

      \ and <bibinfo>author <bibfnamefont|J.><nbsp><bibnamefont|Hajdu>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Appl. Phys.

      \ <with|font-series|bold|<bibinfo>volume 99>, <bibinfo>pages 033514
      (<bibinfo> year 2006b)<BibitemShut|NoStop><bibitem-with-key|(1951)|Slater51><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|J.<nbsp>C.>
      <bibnamefont|Slater>, <hlink||>@noop \ <bibfield>journal
      <bibinfo>journal Phys. Rev. <with|font-series|bold|<bibinfo>volume 81>,
      <bibinfo>pages 385 (<bibinfo> year 1951)<BibitemShut|NoStop><bibitem-with-key|
      and (1963)|Herman63><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|F.><nbsp><bibnamefont|Herman> and <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Skillman>, <hlink||>@noop
      \ <em|<bibinfo>title Atomic Structure Calculations> (<bibinfo>publisher
      Prentice-Hall, <bibinfo>address Englewood Cliffs, NJ, <bibinfo>year
      1963)<BibitemShut|NoStop><bibitem-with-key|(1955)|Latter55><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|R.><nbsp><bibnamefont|Latter>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev.
      <with|font-series|bold|<bibinfo>volume 99>, <bibinfo>pages 510
      (<bibinfo> year 1955)<BibitemShut|NoStop><bibitem-with-key| and
      (1993)|Yao93a><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|G.<nbsp>H.> <bibnamefont|Yao> and <bibinfo>author
      <bibfnamefont|S.<nbsp>I.> <bibnamefont|Chu>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Chem. Phys. Lett.
      <with|font-series|bold|<bibinfo>volume 204>, <bibinfo>pages 381
      (<bibinfo> year 1993)<BibitemShut|NoStop><bibitem-with-key| and
      (1997)|Tong97a><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|X.<nbsp>M.> <bibnamefont|Tong> and <bibinfo>author
      <bibfnamefont|S.<nbsp>I.> <bibnamefont|Chu>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Chem. Phys.

      \ <with|font-series|bold|<bibinfo>volume 217>, <bibinfo>pages 119
      (<bibinfo>year 1997)<BibitemShut|NoStop><bibitem-with-key|(1962)|Cooper62><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|J.<nbsp>W.>
      <bibnamefont|Cooper>, <hlink||>@noop \ <bibfield>journal
      <bibinfo>journal Phys. Rev. <with|font-series|bold|<bibinfo>volume
      128>, <bibinfo>pages 681 (<bibinfo> year
      1962)<BibitemShut|NoStop><bibitem-with-key| and
      (1968)|Manson68><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|S.<nbsp>T.> <bibnamefont|Manson> and <bibinfo>author
      <bibfnamefont|J.<nbsp>W.> <bibnamefont|Cooper>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev.
      <with|font-series|bold|<bibinfo>volume 165>, <bibinfo>pages 126
      (<bibinfo> year 1968)<BibitemShut|NoStop><bibitem-with-key| (1999), , ,
      , , , , , , , and |LAPACK><BibitemOpen> <bibfield>author
      <bibinfo>author <bibfnamefont|E.><nbsp><bibnamefont|Anderson>,
      <bibinfo>author <bibfnamefont|Z.><nbsp><bibnamefont|Bai>,
      <bibinfo>author <bibfnamefont|C.><nbsp><bibnamefont|Bischof>, <bibinfo>
      author <bibfnamefont|S.><nbsp><bibnamefont|Blackford>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Demmel>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Dongarra>, <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Du<nbsp>Croz>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Greenbaum>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Hammarling>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|McKenney>, \ and <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Sorensen>, <hlink||>@noop
      \ <em|<bibinfo>title LAPACK Users' Guide>, <bibinfo>edition 3rd ed.
      (<bibinfo> publisher Society for Industrial and Applied Mathematics,
      <bibinfo> address Philadelphia, PA, <bibinfo>year
      1999)<BibitemShut|NoStop><bibitem-with-key|(1934)|Koopmans34><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|T.><nbsp><bibnamefont|Koopmans>,
      <hlink||>@noop \ <bibfield>journal <bibinfo>journal Physica
      <with|font-series|bold|<bibinfo>volume 1>, <bibinfo>pages 104
      (<bibinfo>year 1934)<BibitemShut|NoStop><bibitem-with-key| (1993), , ,
      and |Verner93><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|D.<nbsp>A.> <bibnamefont|Verner>, <bibinfo>author
      <bibfnamefont|D.<nbsp>G.> <bibnamefont|Yakovlev>, <bibinfo>author
      <bibfnamefont|I.<nbsp>M.> <bibnamefont|Band>, \ and <bibinfo>author
      <bibfnamefont|M.<nbsp>B.> <bibnamefont|Trzhaskovskaya>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal At. Data Nucl. Data Tables
      <with|font-series|bold|<bibinfo>volume 55>, <bibinfo> pages 233
      (<bibinfo>year 1993)<BibitemShut|NoStop><bibitem-with-key| and
      (2008)|Bethe08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|H.<nbsp>A.> <bibnamefont|Bethe> and <bibinfo>author
      <bibfnamefont|E.<nbsp>E.> <bibnamefont|Salpeter>, <hlink||>@noop
      \ <em|<bibinfo>title Quantum Mechanics of One- and Two-Electron Atoms>
      (<bibinfo>publisher Dover, <bibinfo> address Mineola, NY, <bibinfo>year
      2008)<BibitemShut|NoStop><bibitem-with-key| (1973), , and
      |Bhalla73><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|C.<nbsp>P.> <bibnamefont|Bhalla>, <bibinfo>author
      <bibfnamefont|N.<nbsp>O.> <bibnamefont|Folland>, \ and <bibinfo>author
      <bibfnamefont|M.<nbsp>A.> <bibnamefont|Hein>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Phys. Rev. A

      \ <with|font-series|bold|<bibinfo>volume 8>, <bibinfo>pages 649
      (<bibinfo>year 1973)<BibitemShut|NoStop><bibitem-with-key| and
      (1971a)|Walters71><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|D.<nbsp>L.> <bibnamefont|Walters> and <bibinfo>author
      <bibfnamefont|C.<nbsp>P.> <bibnamefont|Bhalla>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal At. Data
      <with|font-series|bold|<bibinfo>volume 3>, <bibinfo>pages 301
      (<bibinfo> year 1971a)<BibitemShut|NoStop><bibitem-with-key| and
      (1971b)|Walters71b><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|D.<nbsp>L.> <bibnamefont|Walters> and <bibinfo>author
      <bibfnamefont|C.<nbsp>P.> <bibnamefont|Bhalla>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. A
      <with|font-series|bold|<bibinfo>volume 3>, <bibinfo>pages 1919
      (<bibinfo> year 1971b)<BibitemShut|NoStop><bibitem-with-key|(1988)|Zare88><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|R.<nbsp>N.>
      <bibnamefont|Zare>, <hlink||>@noop \ <em|<bibinfo>title Angular
      Momentum: Understanding Spatial Aspects in Chemistry and Physics>
      (<bibinfo> publisher Wiley-Interscience, <bibinfo>address New York, NY,
      <bibinfo> year 1988)<BibitemShut|NoStop><bibitem-with-key|(1969)|McGuire69><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|E.<nbsp>J.>
      <bibnamefont|McGuire>, <hlink||>@noop \ <bibfield>journal
      <bibinfo>journal Phys. Rev. <with|font-series|bold|<bibinfo>volume
      185>, <bibinfo>pages 1 (<bibinfo> year
      1969)<BibitemShut|NoStop><bibitem-with-key|(1981)|Cowan81><BibitemOpen>
      <bibfield>author <bibinfo>author <bibfnamefont|R.<nbsp>D.>
      <bibnamefont|Cowan>, <hlink||>@noop \ <em|<bibinfo>title The Theory of
      Atomic Structure and Spectra> (<bibinfo>publisher University of
      California Press, <bibinfo>address Berkeley, CA, <bibinfo>year
      1981)<BibitemShut|NoStop><bibitem-with-key| (2004), , , , , , , , , , ,
      , and |Schlachter04><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|A.<nbsp>S.> <bibnamefont|Schlachter>, <bibinfo>author
      <bibfnamefont|M.<nbsp>M.> <bibnamefont|Sant'Anna>, <bibinfo>author
      <bibfnamefont|A.<nbsp>M.> <bibnamefont|Covington>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Aguilar>, <bibinfo>author
      <bibfnamefont|M.<nbsp>F.> <bibnamefont|Gharaibeh>, <bibinfo> author
      <bibfnamefont|E.<nbsp>D.> <bibnamefont|Emmons>, <bibinfo>author
      <bibfnamefont|S.<nbsp>W.<nbsp>J.> <bibnamefont|Scully>, <bibinfo>author
      <bibfnamefont|R.<nbsp>A.> <bibnamefont|Phaneuf>, <bibinfo>author
      <bibfnamefont|G.><nbsp><bibnamefont|Hinojosa>, <bibinfo>author
      <bibfnamefont|I.><nbsp><bibnamefont|lvarez>, <bibinfo>author
      <bibfnamefont|C.><nbsp><bibnamefont|Cisneros>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Mller>, \ and <bibinfo>author
      <bibfnamefont|B.<nbsp>M.> <bibnamefont|McLaughlin>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal J. Phys. B: At. Mol. Opt. Phys.

      \ <with|font-series|bold|<bibinfo>volume 37>, <bibinfo>pages L103
      (<bibinfo>year 2004)<BibitemShut|NoStop><bibitem-with-key| (1994), , ,
      , , , , , and |Hubbell94><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|J.<nbsp>H.> <bibnamefont|Hubbell>, <bibinfo>author
      <bibfnamefont|P.<nbsp>N.> <bibnamefont|Trehan>, <bibinfo>author
      <bibfnamefont|N.><nbsp><bibnamefont|Singh>, <bibinfo> author
      <bibfnamefont|B.><nbsp><bibnamefont|Chand>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Mehta>, <bibinfo>author
      <bibfnamefont|M.<nbsp>L.> <bibnamefont|Garg>, <bibinfo>author
      <bibfnamefont|R.<nbsp>R.>

      \ <bibnamefont|Garg>, <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Singh>, \ and <bibinfo>author
      <bibfnamefont|S.><nbsp><bibnamefont|Puri>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Phys. Chem.
      Ref. Data <with|font-series|bold|<bibinfo>volume 23>, <bibinfo>pages
      339 (<bibinfo>year 1994)<BibitemShut|NoStop><bibitem-with-key| and
      (2001)|Als-Nielsen01><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|J.><nbsp><bibnamefont|Als-Nielsen> and <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|McMorrow>, <hlink||>@noop
      \ <em|<bibinfo>title Elements of Modern X-ray Physics>
      (<bibinfo>publisher John Wiley & Sons, <bibinfo> address Chichester,
      <bibinfo>year 2001)<BibitemShut|NoStop><bibitem-with-key| (2008), , and
      |Shneerson08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|V.<nbsp>L.> <bibnamefont|Shneerson>, <bibinfo>author
      <bibfnamefont|A.><nbsp><bibnamefont|Ourmazd>, \ and <bibinfo>author
      <bibfnamefont|D.<nbsp>K.> <bibnamefont|Saldin>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal Acta Cryst.

      \ <with|font-series|bold|<bibinfo>volume A64>, <bibinfo>pages 303
      (<bibinfo>year 2008)<BibitemShut|NoStop><bibitem-with-key| (2004), ,
      and |Shen04><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|Q.><nbsp><bibnamefont|Shen>, <bibinfo>author
      <bibfnamefont|I.><nbsp><bibnamefont|Bazarov>,\ 

      \ and <bibinfo>author <bibfnamefont|P.><nbsp><bibnamefont|Thibault>,

      \ <hlink||>@noop \ <bibfield>journal <bibinfo>journal J. Synchrotron
      Radiat. <with|font-series|bold|<bibinfo>volume 11>, <bibinfo>pages 432
      (<bibinfo>year 2004)<BibitemShut|NoStop><bibitem-with-key| and
      (2004)|Zholents04><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|A.<nbsp>A.> <bibnamefont|Zholents> and <bibinfo>author
      <bibfnamefont|W.<nbsp>M.> <bibnamefont|Fawley>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. Lett.
      <with|font-series|bold|<bibinfo>volume 92>, <bibinfo>pages 224801
      (<bibinfo>year 2004)<BibitemShut|NoStop><bibitem-with-key| (2006), ,
      and |Saldin06><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|E.<nbsp>L.> <bibnamefont|Saldin>, <bibinfo>author
      <bibfnamefont|E.<nbsp>A.> <bibnamefont|Schneidmiller>, \ and
      <bibinfo>author <bibfnamefont|M.<nbsp>V.>

      \ <bibnamefont|Yurkov>, <hlink||>@noop \ <bibfield>journal <bibinfo>
      journal Phys. Rev. ST Accel. Beams <with|font-series|bold|<bibinfo>volume
      9>,

      \ <bibinfo>pages 050702 (<bibinfo>year
      2006)<BibitemShut|NoStop><bibitem-with-key| and
      (2008)|Zholents08><BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|A.<nbsp>A.> <bibnamefont|Zholents> and <bibinfo>author
      <bibfnamefont|M.<nbsp>S.> <bibnamefont|Zolotorev>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal New J. Phys.
      <with|font-series|bold|<bibinfo>volume 10>, <bibinfo>pages 025005
      (<bibinfo>year 2008)<BibitemShut|NoStop>

      <\bibitem-with-key>
        \ (2009), , , ,

        \ and
      </bibitem-with-key|Ding09>

      <BibitemOpen> <bibfield>author <bibinfo>author
      <bibfnamefont|Y.><nbsp><bibnamefont|Ding>, <bibinfo>author
      <bibfnamefont|Z.><nbsp><bibnamefont|Huang>, <bibinfo>author
      <bibfnamefont|D.><nbsp><bibnamefont|Ratner>, <bibinfo> author
      <bibfnamefont|P.><nbsp><bibnamefont|Bucksbaum>, \ and <bibinfo> author
      <bibfnamefont|H.><nbsp><bibnamefont|Merdji>, <hlink||>@noop
      \ <bibfield>journal <bibinfo>journal Phys. Rev. ST Accel. Beams

      \ <with|font-series|bold|<bibinfo>volume 12>, <bibinfo>pages 060703
      (<bibinfo> year 2009)<BibitemShut|NoStop>
    </macro>
  </assign>
</body>