<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|proposition|proposition>

    <new-theorem|lemma|Lemma>

    <new-theorem|alg|Algorithm>

    <new-theorem|corollary|Corollary>

    <new-theorem|theorem|Theorem>

    <new-theorem|claim|Claim>

    <new-theorem|conjecture|Conjecture>

    <new-theorem|observation|Observation>

    <new-theorem|fact|Fact>

    <new-theorem|definition|Definition>

    <assign|DEF|<macro|1|<with|font-shape|italic|<arg|1>>>>

    <assign|myitemsep|<macro|>>

    <assign|NN|<macro|<math|\<bbb-N\>>>>

    <assign|ZZ|<macro|<math|\<bbb-Z\>>>>

    <assign|ol|<macro|1|<wide|<arg|1>|\<bar\>>>>

    <assign|req|<macro|1|(<reference|1>)>>

    <assign|a|<macro|\<alpha\>>>

    <assign|b|<macro|\<beta\>>>

    <assign|c|<macro|\<gamma\>>>

    <assign|d|<macro|\<delta\>>>

    <assign|Ofpt|<macro|O<rsup|fpt>>>

    <assign|tw|<macro|<with|font-family|rm|tw>>>

    <assign|pw|<macro|<with|font-family|rm|pw>>>

    <assign|ltw|<macro|<with|font-family|rm|ltw>>>

    <assign|less|<macro|\<preccurlyeq\>>>

    <assign|bag|<macro|\<cal-B\>>>

    <assign|bw|<macro|<with|font-series|bold|bw>>>

    <assign|bor|<macro|<with|font-series|bold|bd>>>

    <assign|eg|<macro|<with|font-series|bold|eg>>>

    <assign|qed|<macro|<rule|6pt|6pt>>>

    <assign|render-proof|<macro|1|body|<\surround|<paragraph|Proof<arg|1>>|<htab|0pt><qed><vspace|1fn><next-line>>
      <arg|body>
    </surround>>><assign|proof|<macro|body|<render-proof||<arg|body>>>>

    <assign|C|<macro|\<cal-C\>>>

    <assign|Ckw|<macro|<math|<C><rsub|k><rsup|w>>>>

    <assign|Ckwq|<macro|<math|<C><rsub|k,q><rsup|w>>>>

    <assign|mqed|<macro|<space|2em>\<square\>>>

    <assign|alephnull|<macro|\<aleph\><rsub|0>>>

    <assign|ew|<macro|<with|font-family|tt|ew>>>

    <assign|fw|<macro|<with|font-family|tt|fw>>>

    <assign|ve|<macro|\<varepsilon\>>>

    <assign|ins|<macro|<with|font-series|bold|ins>>>

    <assign|bd|<macro|<with|font-series|bold|bd>>>

    <assign|blob|<macro|<circle>*0.3>>

    <assign|blobb|<macro|<circle>*0.15>>

    <assign|cT|<macro|\<cal-T\>>>

    <assign|cP|<macro|\<cal-P\>>>

    <assign|cR|<macro|\<cal-R\>>>

    <assign|cS|<macro|\<cal-S\>>>

    <assign|cK|<macro|\<cal-K\>>>

    <assign|ttslice|<macro|<with|font-family|tt|slice>>>

    <assign|ttprefix|<macro|<with|font-family|tt|prefix>>>

    <assign|showlabel|<macro|1|>>

    <assign|showfiglabel|<macro|1|>>

    <assign|date|<macro|<date|>>>

    <assign|minimal|<macro|minimal>>

    <assign|uom|<macro|\<Omega\>>>

    <assign|lam|<macro|\<lambda\>>>

    <assign|calw|<macro|\<cal-W\>>>

    <assign|udel|<macro|\<Delta\>>>

    <assign|ugam|<macro|\<Gamma\>>>

    <assign|junk|<macro|1|>>

    <assign|journal|<macro|1|>>

    <assign|minimal|<macro|minimal>>

    <assign|uom|<macro|\<Omega\>>>

    <assign|lam|<macro|\<lambda\>>>

    <assign|calw|<macro|\<cal-W\>>>

    <assign|udel|<macro|\<Delta\>>>

    <assign|ugam|<macro|\<Gamma\>>>
  </hide-preamble>

  <doc-data|<doc-title|Minimum <math|k>-way cut of bounded size is
  fixed-parameter tractable>|<doc-author|<author-data|<author-misc|Research
  partly supported by Japan Society for the Promotion of Science,
  Grant-in-Aid for Scientific Research, by C & C Foundation, by Kayamori
  Foundation and by Inoue Research Award for Young
  Scientists.>|<author-name|<with|font-shape|italic|Ken-ichi
  Kawarabayashi><next-line>National Institute of Informatics<next-line>2-1-2
  Hitotsubashi, Chiyoda-ku<next-line>Tokyo 101-8430,
  Japan<next-line><with|font-family|tt|k_keniti@nii.ac.jp>>>>|<doc-author|<author-data|<author-name|<with|font-shape|italic|Mikkel
  Thorup><next-line>AT&T Labs<emdash>Research<next-line>180 Park Avenue,
  Florham Park, NJ 07932, USA<next-line><with|font-family|tt|mthorup@research.att.com>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    We consider a the minimum <math|k>-way cut problem for unweighted graphs
    with a size bound <math|s> on the number of cut edges allowed. Thus we
    seek to remove as few edges as possible so as to split a graph into
    <math|k> components, or report that this requires cutting more than
    <math|s> edges. We show that this problem is fixed-parameter tractable
    (FPT) in <math|s>. More precisely, for <math|s=O<around|(|1|)>>, our
    algorithm runs in quadratic time while we have a different linear time
    algorithm for planar graphs and bounded genus graphs.

    Our tractability result stands in contrast to known W[1] hardness of
    related problems. Without the size bound, Downey et al.<nbsp>[2003]
    proved that the minimum <math|k>-way cut problem is W[1] hard in <math|k>
    even for simple unweighted graphs. Downey et al.<nbsp>asked about the
    status for planar graphs. Our result implies tractability in <math|k> for
    the planar graphs since the minimum <math|k>-way cut of a planar graph is
    of size at most <math|6*k> (in fact, the size is <math|f<around|(|k|)>>
    for any bounded degree graphs for some fixed function <math|f> of
    <math|k>. This class includes bounded genus graphs, and simple graphs
    with an excluded minor).

    A simple reduction shows that vertex cuts are at least as hard as edge
    cuts, so the minimum <math|k>-way vertex cut is also W[1] hard in terms
    of <math|k>. Marx [2004] proved that finding a minimum <math|k>-way
    vertex cut of size <math|s> is also W[1] hard in <math|s>. Marx asked
    about the FPT status with edge cuts, which we prove tractable here. We
    are not aware of any other cut problem where the vertex version is W[1]
    hard but the edge version is FPT.
  </abstract>>

  <reset-counter|page>

  <thispagestyle|empty><new-page>

  <journal|<with|font-series|bold|Keywords> : <math|k>-way-cut, planar
  graphs, bounded genus graphs and FPT.>

  <section|Introduction>

  We consider the <with|font-shape|italic|minimum <math|k>-way cut
  problem<footnote|There is a lot of confusing terminology associated with
  cut problems, e.g., in the original conference version of <cite|DJPSY94>,
  ``multiway cut'' referred to the separation of given terminals, but that
  term is fortunately corrected to ``multiterminal cut'' in the final journal
  version. Here we follow the latter more explicit terminology: <math|k>-way
  cut for arbitrary splitting into <math|k> pieces, <math|k>-terminal cut for
  splitting <math|k> terminals, <math|k>-pair cut for splitting <math|k>
  pairs, and so forth...>> of graph. The goal is to find a minimum set of
  <with|font-shape|italic|cut> edges so as to split the graph into at least
  <math|k> components. If a given graph is unweighted, minimum means minimum
  cardinality; otherwise it means minimum total weight. Goldscmidt and
  Hochbaum <cite|GH94> proved that the problem is NP-hard when <math|k> is
  part of the input but solvable in polynomial time for any fixed <math|k>.
  Finding a minimum <math|k>-way cut is an extension of the classical minimum
  cut problem, and it has applications in the area of VLSI system design,
  parallel computing systems, clustering, network reliability and finding
  cutting planes for the traveling salesman problem.

  Our focus is the minimum <math|k>-way cut problem for an unweighted graph,
  deciding if there is a <math|k>-way cut of size <math|s>. For constant
  <math|s> we solve this problem in quadratic time. In the case of weights,
  our algorithms generalize to finding the minimum weight <math|k>-way cut
  with at most <math|s> edges.

  For planar and, more generally, bounded genus graphs, we present a
  different linear time algorithm for bounded size minimum <math|k>-way cut.
  For simple unweighted bounded genus graphs, we know that a minimum
  <math|k>-way cut has size <math|\<Theta\><around|(|k|)>>, so we get linear
  time whenever <math|k=O<around|(|1|)>>.

  Our result implies that the <math|k>-way cut problem is fixed-parameter
  tractable when parameterized by the cut size <math|s>. Recall here that
  fixed-parameter tractable (FPT) in a parameter <math|t> means that there is
  an algorithm with running time <math|O*<around|(|f<around|(|t|)>*n<rsup|c>|)>>
  for some fixed function <math|f> and constant <math|c>. In our case we get
  <math|t=s>, <math|c=2>, and <math|f<around|(|t|)>=t<rsup|t<rsup|O<around|(|t|)>>>>
  for general graphs. For bounded genus graphs, we get <math|t=s>, <math|c=1>
  and <math|f<around|(|t|)>=2<rsup|O<around|(|t<rsup|2>|)>>>. If the bounded
  genus graphs are simple and unweighted, we can also use <math|t=k> as
  parameter and get the same asymptotic bounds.

  <\big-table>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|parametrized
    by <math|k>>|<cell|parametrized by size
    <math|s>>>|<row|<cell|<math|k>-way vertex cut of size
    <math|s>>|<cell|W[1] hard <cite|DEFPR03>>|<cell|W[1] hard
    <cite|Mar06>>>|<row|<cell|<math|k>-way edge cut of size
    <math|s>>|<cell|W[1] hard <cite|DEFPR03>>|<cell|FPT [This
    paper]>>>>><label|tab:FPT>
  </big-table|FPT status of <math|k>-way cut problems>

  Our FPT result stands in contrast to known W[1] hardness of related
  problems (c.f. Table <reference|tab:FPT>). Recall that if a problem is W[1]
  hard in <math|t>, then it is not FPT in <math|t> unless NP<math|=>P.
  Without the size bound, Downey et al.<nbsp><cite|DEFPR03> proved that the
  minimum <math|k>-way cut problem is W[1] hard in <math|k> even for simple
  unweighted graphs. Downey et al.<nbsp><cite|DEFPR03> asked about the status
  for planar graphs. Our result implies tractability in <math|k> for the
  planar graphs since the minimum <math|k>-way cut of a planar graph is of
  size at most <math|6*k>. Vertex cuts are at least as hard as edge cuts, so
  the minimum <math|k>-way vertex cut is also W[1] hard in terms of <math|k>.
  Marx <cite|Mar06> proved that finding a minimum <math|k>-way vertex cut of
  size <math|s> is also W[1] hard in <math|s>. Marx <cite|Mar06> asked about
  the FPT status with bounded size edge cuts, which we prove tractable here.

  The discovered difference in FPT status between the edge and the vertex
  version of the bounded size <math|k>-way cut problem is unusual for cut
  problems. As mentioned above, both versions are W[1] hard when only
  <math|k> is bounded. On the other hand, Marx <cite|Mar06> has proved that
  the bounded size <math|k>-terminal cut problem is FPT both for vertex and
  edge cuts. He also proved FPT for a bounded size cut of a bounded number of
  pairs. Recently this was strenthened by Marx and Razgon <cite|MR10> and
  Bousquet et al. <cite|BDT10>, showing that finding a bounded size cut of an
  unbounded set of pairs is FPT both for vertex and edge cuts.

  Henceforth, unless otherwise specified, cuts are understood to be edge
  cuts.

  <subsection|More history>

  <paragraph|General graphs.> Goldschmidt and Hochbaum <cite|GH94> proved
  that finding a minimum <math|k>-way cut is NP-hard when <math|k> is part of
  the input, but polynomial time solvable for fixed <math|k>. Their algorithm
  finds a minimum <math|k>-way cut in <math|O<around|(|n<rsup|<around|(|1/2-o<around|(|1|)>|)>*k<rsup|2>>|)>>
  time and works for weighted graphs. Karger and Stein <cite|KS96> proposed
  an extremely simple randomized Monto Carlo algorithm for the <math|k>-way
  cut problem whose running time is <math|O<around|(|n<rsup|<around|(|2-o<around|(|1|)>|)>*k>|)>>.
  Then Kamidoi et al.<nbsp><cite|KYN06> presented a deterministic algorithm
  that runs in <math|O<around|(|n<rsup|<around|(|4+o<around|(|1|)>|)>*k>|)>>
  time, and finally, Thorup <cite|Tho08> presented the current fastest
  deterministic algorithm with a running time of
  <math|<wide|O|~><around|(|m*n<rsup|2*k-2>|)>>.

  The obvious big target would be to move the dependence on <math|k> from the
  exponent of <math|n>. However, this is impossible due to the above
  mentioned W[1] hardness in <math|k> by Downey et al. <cite|DEFPR03>.

  As alternative to <math|k>, a very natural parameter to look at is the cut
  size <math|s>, i.e., the size of the desired output. Getting polynomial
  time for fixed <math|s> is trivial since we can try all subsets of <math|s>
  edges in <math|O<around|(|n<rsup|2*s>|)>> time. Reducing this to
  <math|O<around|(|n<rsup|s>|)>> time straightforward using the
  sparsification from <cite|NI92>. The challenge here is if we can move
  <math|s> from the exponent of <math|n> and get FPT in <math|s>. As
  mentioned above, in the case of vertex cuts, the bounded cut size was
  considered by Marx <cite|Mar06> who proved the <math|k>-way vertex cut to
  be W[1] hard in the size <math|s>. He asked if the edge version was also
  hard. Here we show that the edge version is tractable with a quadratic
  algorithm for any fixed cut size <math|s>. Our algorithm implies that the
  minimum <math|k>-way cut problem is solvable in polynomial time for bounded
  degree unweighted graphs. This class includes planar graphs, bounded genus
  graphs, and simple graphs with an excluded minor. In fact, we give a linear
  time algorithm for planar graphs and bounded genus graphs. Let us see more
  precisely.

  <paragraph|Planar graphs.> The special case of planar graphs has been quite
  well-studied. In the case of weighted planar graphs, Dahlhaus et al.
  <cite|DJPSY94> solved the <math|k>-way cut problem in
  <math|O*<around|(|n<rsup|3*k-1>*log n|)>> time. The bound was later
  improved to <math|<wide|O|~><around|(|n<rsup|2*k-1>|)>> time by Hartvigsen
  <cite|Har93>. This was, however, matched by the later
  <math|<wide|O|~><around|(|m*n<rsup|2*k-2>|)>> bound by Thorup <cite|Tho08>
  for general graphs.

  The case of simple unweighted planar graphs has also received attention.
  Hochbaum and Shmoys <cite|HS85> gave an <math|O<around|(|n<rsup|2>|)>>
  algorithm for simple unweighted planar graphs when <math|k=3>. This was
  improved by He <cite|He91> to <math|O*<around|(|n*log n|)>>. The motivation
  given in <cite|HS85|He91> is the case of general <math|k>, with <math|k=3>
  being the special case for which they provide an efficient solution.

  As mentioned previously, having proved the <math|k>-way cut problem W[1]
  hard for simple unweighted general graphs, Downey et al. <cite|DEFPR03>
  asked about the FPT status for planar graphs.

  We resolve the question from <cite|DEFPR03> with an
  <math|O*<around|(|2<rsup|k<rsup|2>>*n|)>> algorithm for simple unweighted
  planar graphs. Even in the special case of <math|k=3>, our result improves
  on the above mentioned algorithms of Shmoys and Hochbaum <cite|HS85> and He
  <cite|He91>.

  Our planar algorithm is generalized to the bounded genus case, where it
  runs in time <math|O*<around|(|2<rsup|O*<around|(|g<rsup|2>*k<rsup|2>|)>>*n|)>>.

  <paragraph|Techniques.> Our main result, the quadratic algorithm for
  general graphs, is a simple combinatorial algorithm not relying on any
  previous results. To solve the problem recursively, we will define \Qthe
  powercut problem", which is much stronger than the minimum <math|k>-way cut
  problem. It also generalizes the muli-pair cut problem with <math|p> pairs
  for fixed <math|p> (this pair problem is, however, known to be FPT both for
  vertices and edge cuts <cite|Mar06>). The approach can be seen as a typical
  example that a stronger inductive hypothesis gives a much simpler inductive
  proof. With the powercut problem, it is easy to handle all high degree
  vertices except for one, which acts like an apex vertex in graph minor
  theory. The rest is a bounded degree graph in which we identify a
  contractible edge.

  For planar graphs, like previous algorithms <cite|HS85|He91>, we exploit
  that a minimum <math|k>-way cut has size <math|O<around|(|k|)>>. Otherwise
  our algorithm for the planar case is based on a decomposition lemma from
  Klein's <cite|Kle08> approximate TSP algorithm. In fact, this appears to be
  the simplest direct application of Klein's lemma for a classic problem.
  Klein's lemma is related to Baker's layered approach <cite|Bak94> to planar
  graphs. Whereas Baker deletes layers to get bounded tree-width, Klein
  contracts layers (deletion in the dual) and such a contraction does not
  affect cuts avoiding the contracted layers. We present a linear time
  version of this approach for bounded genus graphs. In doing so, we also get
  a linear time approximate TSP algorithm, improving an
  <math|O*<around|(|n*log n|)>> algorithm based on work of Cabello et
  al.<nbsp><cite|CC07> and Demaine et al.<nbsp><cite|DHM07>.

  <section|FPT algorithm to find minimum <math|k>-way cuts of bounded size>

  We want to find a minimum <math|k>-way cut of size at most <math|s>.
  Assuming that a given graph is connected, the problem can only be feasible
  if <math|k\<leq\>s+1>. In the spirit of FPT, we are going to
  <math|O<rsup|\<ast\>>> to denote <math|O> assuming that the relevant
  parameters are constant. We will solve the problem in
  <math|O*<around|(|s<rsup|s<rsup|O><around|(|s|)>>*n<rsup|2>|)>=O<rsup|\<ast\>><around|(|n<rsup|2>|)>>
  time.

  <subsection|The powercut problem>

  To solve the problem <math|k>-way cut problem inductively, we are going to
  address a more general problem:

  <\definition>
    The powercut problem takes as input a triple <math|<around|(|G,T,s|)>>
    where <math|G> is a connected graph, <math|T\<subseteq\>V<around|(|G|)>>
    a set of terminals, and <math|s> a size bound parameter. For every
    <math|j\<leq\>s+1> and for every partition <math|P> of <math|T> into
    <math|j> sets, some of which may be empty, we want a minimal <math|j>-way
    cut <math|C<rsub|j,P>> of <math|G> whose sides partitions <math|T>
    according to <math|P> but only if there is such a feasible cut of size at
    most <math|s>. The powercut is thus a cut family <math|<C>> containing
    the cuts <math|C<rsub|j,P>>, each of size at most <math|s>.
  </definition>

  It may be that we for different partitions <math|P>, <math|P<rprime|'>> get
  the same edge cut <math|C<rsub|j,P>=C<rsub|j,P<rprime|'>>>. Often we will
  identify a powercut with its set of distinct edge cuts.

  Note that if <math|<around|\||T|\|>> and <math|s> are bounded, then so is
  the total size of the power cut. More precisely,

  <\observation>
    <label|obs:edge-bound>The total number of edges in a power cut is bounded
    by <math|s*<big|sum><rsub|j=2><rsup|s+1><around|(|j<rsup|<around|\||T|\|>>/j!|)>\<less\><around|(|s+1|)><rsup|<around|\||T|\|>+1>>.
  </observation>

  We will show how to solve the powercut problem in quadratic time when
  <math|<around|\||T|\|>,k,s=O<around|(|1|)>>. To solve our original problem,
  we solve the powercut problem with an empty set of terminals
  <math|T=\<emptyset\>>. In this case, for each <math|j\<leq\>s+1>, we only
  have a single trivial partition <math|P<rsub|j>> of <math|T> consisting of
  <math|j> empty sets, and then we return <math|C<rsub|k,P<rsub|k>>>.

  We can, of course, also use our powercut algorithm to deal with cut
  problems related to a bounded number of terminals, e.g., the <math|p>-pair
  cut problem which for <math|p> pairs <math|<around|{|<around|(|s<rsub|1>,t<rsub|1>|)>,...,<around|(|s<rsub|p>,t<rsub|p>|)>|}>>
  ask for a minimum cut that splits every pair, that is, for each <math|i>,
  the cut separates <math|s<rsub|i>> from <math|t<rsub|i>>. If there is such
  a cut of size at most <math|s>, we find it with a powercut setting
  <math|T=<around|{|s<rsub|1>,...,s<rsub|p>,t<rsub|1>,...,t<rsub|p>|}>> and
  <math|k=s+1>. In the output powercut family
  <math|<around|{|C<rsub|j,P>|}>>, we consider all partitions <math|P>
  splitting every pair, returning the minimum of the corresponding cuts. Such
  problems with a bounded number of terminals and a bounded cut size, but no
  restrictions on the number of components, are easier to solve directly, as
  done in many cases by Marx <cite|Mar06> even for vertex cuts. However, for
  vertex cuts, Marx <cite|Mar06> proved that the <math|k>-way cut problem is
  W[1] hard. Hence the hardness is not in splitting of a bounded set of
  terminals, but in getting a certain number of components. With our powercut
  algorithm, we show that getting any specified number of components is
  feasible with size bounded edge cuts.

  Below we will show how to solve the power cut problem recursively in
  quadratic time, let <math|T<rsub|0>> be the initial set of terminals, e.g.,
  <math|T<rsub|0>=\<emptyset\>> for the <math|k>-way cut problem. We now fix

  <\equation>
    <label|eq:t>t=max <around|{|2*s,<around|\||T<rsub|0>|\|>|}>.
  </equation>

  In our recursive problems we will never have more than <math|t> terminals.
  The parameter <math|s> will not change.

  <paragraph|Identifying vertices and terminals> Our basic strategy will be
  to look for vertices that can be identified while preserving some powercut.
  To make sense of such a statement, we specify a cut as a set of edges, and
  view each edge as having its own identity which is preserved even if its
  end-points are identified with other vertices. Note that when we identify
  vertices <math|u> and <math|v>, then we destroy any cut that would split
  <math|u> and <math|v>. However, the identification cannot create any new
  cuts. We say that <math|u> and <math|v> are
  <with|font-shape|italic|identifiable> if they are not separated by any cut
  of some powercut <math|<C>>. It follows that if <math|u> and <math|v> are
  identifiably, then <math|<C>> is also a powercut after their
  identification, and then every powercut <math|<C><rprime|'>> after the
  identification is also a powercut before the identification. Since loops
  are irrelevant for minimal cuts, identifying the end-points of an edge is
  the same as contracting the edge. Therefore, if the end-points of an edge
  are identifiably, we say the edge is <with|font-shape|italic|contractible>.

  We do allow for the case of identifiable terminals <math|t> and
  <math|t<rprime|'>> that are not split by any cut in some powercut
  <math|<C>>. By definition of a powercut, this must imply that there is no
  feasible cut of size at most <math|s> between <math|t> and
  <math|t<rprime|'>>.

  Often we will identify many vertices. Generalizing the above notion, we say
  a set of vertex pairs is <with|font-shape|italic|simultaneously
  identifiable> if there is a powercut that does not separate any of them.
  This implies that we can identify all the pairs while preserving some
  powercut.

  Note that we can easily have cases with identifiable vertex pairs that are
  not simultaneously identifiable, e.g., if the graph is a path of two edges
  between two terminals, then either edge is contractible, yet they are not
  simultaneously contractible.

  <paragraph|Recursing on subgraphs> Often we will find identifiable vertices
  recursing via a subgraph <math|H\<subseteq\>G>. If <math|<C>> is a powercut
  of <math|G>, then <math|<C>\|H> denotes <math|<C>>
  <with|font-shape|italic|restricted> to <math|H> in the sense that each cut
  <math|C\<in\><C>> is replaced by its edges <math|C\<cap\>E<around|(|H|)>>
  in <math|H>, ignoring cuts that do not intersect <math|H>.

  <\lemma>
    <label|lem:recurse-identify>Let <math|H> be a connected subgraph of
    <math|G>. Let <math|S> be the set of vertices in <math|H> with incident
    edges not in <math|H>. Define <math|T<rsub|H>=S\<cup\><around|(|T\<cap\>V<around|(|H|)>|)>>
    to be the terminals of <math|H>. Then each powercut <math|<C><rsub|H>> of
    <math|<around|(|H,T<rsub|H>,s|)>> is the restriction to <math|H> of some
    powercut <math|<C>> of <math|<around|(|G,T,s|)>>. Hence, if pairs of
    vertices are simultaneously identifiable in
    <math|<around|(|H,T<rsub|H>,s|)>>, then they are also simultaneously
    identifiable in <math|<around|(|G,T,s|)>>.
  </lemma>

  <\proof>
    \ Since the pairs are simultaneously identifiable in
    <math|<around|(|H,T<rsub|H>,s|)>>, there is a powercut <math|<C><rsub|H>>
    of <math|<around|(|H,T<rsub|H>,s|)>> with no cut separating any of the
    pairs. Now consider a powercut <math|<C>> of <math|<around|(|G,T,s|)>>,
    and let <math|C> be any cut in <math|<C>>. Then <math|H\<setminus\>C> has
    a certain number <math|j\<leq\>s+1> of components inducing a certain
    partition <math|P> of <math|T<rsub|H>>. In <math|C> we now replace
    <math|C\<cap\>H> with <math|C<rsub|j,P>> from <math|<C><rsub|H>>,
    denoting the new cut <math|C<rprime|'>>. Since <math|C<rsub|j,P>> is a
    minimal, this can only decrease the size of <math|C>. It is also clear
    that <math|G\<setminus\>C> and <math|H\<setminus\>C> have the same number
    of components inducing the same partition of <math|T>. This way we get a
    powercut <math|<C><rprime|'>> of <math|<around|(|G,T,s|)>> such that
    <math|<C><rprime|'>\|H=<C><rsub|H>>. In particular it follows that our
    pairs from <math|H> are simultaneously identifiable in
    <math|<around|(|G,T,s|)>>.
  </proof>

  <subsection|Good separation>

  For our recursion, we are going to look for good separations as defined
  below. A <with|font-shape|italic|separation> of the graph <math|G> is
  defined via an edge partition into two connected subgraphs <math|A> and
  <math|B>, that is, each edge of <math|G> is in exactly one of <math|A> and
  <math|B>. We refer to <math|A> and <math|B> as the
  <with|font-shape|italic|sides> of the separation. Let <math|S> be the set
  of vertices in both <math|A> and <math|B>. Then <math|S>
  <with|font-shape|italic|separates> <math|V<around|(|A|)>> from
  <math|V<around|(|B|)>> in the sense that any path between them will
  intersect <math|S>. Contrasting vertex cut terminology, we include <math|S>
  in what is separated by <math|S>. In order to define a good separation, we
  fix

  <\equation>
    <label|eq:pq>p=<around|(|s+1|)><rsup|t+1>*<text|and
    >q=2*<around|(|p+1|)>.
  </equation>

  Then <math|p> is the upper bound from Observation
  <reference|obs:edge-bound> on the total number of edges in a power cut with
  at most <math|t> terminals. The separation is <with|font-shape|italic|good>
  if <math|<around|\||S|\|>\<leq\>s> and both <math|A> and <math|B> have at
  least <math|q> vertices.

  Suppose we have found a good separation. Then one of <math|A> and <math|B>
  will contain at most half the terminals from <math|T> because
  <math|<around|\||T|\|>\<leq\>2*s>. Suppose it is <math|A>. Recursively we
  will find a powercut <math|<C><rsub|A>> of <math|A> with terminal set
  <math|T<rsub|A>=S\<cup\><around|(|T\<cap\>V<around|(|A|)>|)>> as in Lemma
  <reference|lem:recurse-identify>. Finally in <math|G> we contract all edges
  from <math|A> that are not in the powercut <math|<C><rsub|A>>.

  For the validity of the recursive call, we note that
  <math|<around|\||T<rsub|A>|\|>\<leq\>s+t/2\<leq\>t>. The last inequality
  follows because <math|t\<geq\>2*s>. For the positive effect of the
  contraction, recall that <math|A> has at least <math|q=2*<around|(|p+1|)>>
  vertices where <math|p> bounds the number of edges in <math|<C><rsub|A>>.
  We know that <math|A> is connected, and it will remain so when we contract
  the edges from <math|A> that are not in <math|<C><rsub|A>>. In the end,
  <math|A> has at most <math|p> non-contracted edges, and they can span at
  most <math|p+1> distinct vertices. The contractions thus reduce the number
  of vertices in <math|G> by at least <math|<around|\||A|\|>-p-1>.

  Below, splitting into a few cases, we will look for good separations to
  recurse over.

  <subsection|Multiple high degree vertices><label|sec:high-degrees>

  A vertex has <with|font-shape|italic|high degree> if it has at least

  <\equation>
    <label|eq:d>d=q+s-1
  </equation>

  neighbors. Here <math|q> was the lower bound from <req|eq:pq> on the number
  of vertices in a side of a good separation. Suppose that the current graph
  <math|G> has two high degree vertices <math|u> and <math|v>. In that case,
  check if there is a cut <math|D> between <math|u>-<math|v>-cut of size at
  most <math|s>. If not, we can trivially identify <math|u> and <math|v> and
  recurse.

  If there is a cut <math|D> of size at most <math|s> between <math|u> and
  <math|v>, let <math|A> be the component containing <math|u> in
  <math|G\<setminus\>D>, and let <math|B> be the subgraph with all edges not
  in <math|A>.

  <\lemma>
    The subgraphs <math|A> and <math|B> form a good separation.
  </lemma>

  <\proof>
    \ The set <math|S> of vertices in both <math|A> and <math|B> are exactly
    the end-points on the <math|u>-side of the edges in <math|D>. Therefore
    <math|<around|\||S|\|>\<leq\><around|\||D|\|>\<leq\>s>. We now need to
    show that each of <math|A> and <math|B> span at least <math|q> vertices.
    This is trivial for <math|B> since <math|B> contains <math|v> plus all
    the <math|d=q+s-1> neighbors of <math|v>. For the case of <math|A>, we
    note that <math|D> can separate <math|u> from at most <math|s> of its
    neighbors. This means that <math|u> is connected to at least
    <math|d-s=q-1> vertices in <math|G\<setminus\>D>, so <math|A> contains at
    least <math|q> nodes.
  </proof>

  \ Thus, if we have two high degree vertices, depending on the edge
  connectivity between <math|u> and <math|v>, we can either just identify
  <math|u> and <math|v>, or recurse via a good separation. Below we may
  therefore assume that the graph has at most one high degree vertex.

  <subsection|No high degree vertex><label|sec:small-degrees>

  Below we assume that no vertex with high degree <math|\<geq\>d>\Vc.f.
  <req|eq:d>. The case of one high degree \Papex\Q vertex will later be added
  a straightforward extension.

  <paragraph|A kernel with surrounding layers> We start by picking a start
  vertex <math|v<rsub|0>> and grow an arbitrary connected subgraph
  <math|H<rsub|0>>, called the <with|font-shape|italic|kernel> from
  <math|v<rsub|0>> such that <math|H<rsub|0>> contains all edges leaving
  <math|v<rsub|0>> and <math|H<rsub|0>> spans <math|h\<geq\>d> vertices where
  <math|h=O<rsup|\<ast\>><around|(|1|)>> is a parameter to be fixed later.
  Next we pick edge disjoint minimal <with|font-shape|italic|layers>
  <math|H<rsub|i>>, <math|i=1,...,p>, subject to the following constraints:

  <\itemize>
    <item*|(i)>The layer <math|H<rsub|i>> contains no edges from
    <math|H<rsub|\<less\>i>=<big|cup><rsub|j\<less\>i>H<rsub|j>>, but
    <math|H<rsub|i>> contains all other edges from <math|G> incident to the
    vertices in <math|H<rsub|\<less\>i>>.

    <item*|(ii)>Each component of <math|H<rsub|i>> is either a
    <with|font-shape|italic|big component> with at least <math|q> vertices,
    or a <with|font-shape|italic|limited component> with no edge from
    <math|G\<setminus\>H<rsub|\<leq\>i>> leaving it\Vif a component is both,
    we view it as big.
  </itemize>

  Recall that a powercut <math|<C>> can have at most <math|p> edges. This
  means that there must be at least one of the <math|p+1> edge disjoint
  subgraphs <math|H<rsub|i>> which has no edges in <math|<C>>. Supposing we
  have guessed this <math|H<rsub|i>>, we will find a set <math|F<rsub|i>> of
  simultaneously contractible edges from <math|H<rsub|0>> (note that we mean
  <math|H<rsub|0>>, not <math|H<rsub|i>>). By definition,
  <math|F<rsub|0>=E<around|(|H<rsub|0>|)>>. If <math|i\<gtr\>0>, condition
  (i) implies that <math|H<rsub|i>> is a cut between <math|H<rsub|\<less\>i>>
  and the rest of the graph, and we will use this fact to find the set
  <math|F<rsub|i>>. Since one of the guesses must be correct, the
  intersection <math|F=<big|cap><rsub|i>F<rsub|i>=<big|cap><rsub|i=1><rsup|p>F<rsub|i>>
  must be simultaneously contractible. An alternative outcome will be that we
  find a good separation which requires <math|q> vertices on either side.
  This is where condition (ii) comes in, saying that we have to grow each
  component of <math|H<rsub|i>> until either it becomes a big component with
  <math|q> vertices, or it cannot be grown that big because no more edges are
  leaving it.

  Before elaborating on the above strategy, we note that the graphs
  <math|H<rsub|i>> are of limited size:

  <\lemma>
    <label|lem:growth>The graph <math|H<rsub|\<leq\>i>> has at most
    <math|h*d<rsup|i>> vertices.
  </lemma>

  <\proof>
    \ We prove the lemma by induction on <math|i>. By definition
    <math|<around|\||V<around|(|H<rsub|0>|)>|\|>=h>. For the inductive step
    with <math|i\<gtr\>0>, we prove the more precise statement that layer
    <math|H<rsub|i>> has at most <math|d> times more vertices than the
    vertices it contains from layer <math|H<rsub|i-1>>.

    Since each layer is a cut, the edges leaving <math|H<rsub|\<less\>i>>
    must all be incident to <math|H<rsub|i-1>>. We will argue that each
    component of <math|H<rsub|i>> has at most <math|d> vertices. This is
    trivially satisfied when we start, since each vertex from
    <math|H<rsub|i-1>> comes with its at most <math|d-1> neighbors. Now, if
    we grow a component along an edge, it is because it has less than
    <math|q\<less\>d> vertices, including at least one from
    <math|H<rsub|i-1>>. Either the edge brings us to a new vertex, increasing
    the size of the component by 1, which is fine, or the edge connects to
    some other component from <math|H<rsub|i>> which by induction had at most
    <math|d> vertices per vertex in <math|H<rsub|i-1>>.
  </proof>

  \ If the <math|V<around|(|G|)>=V<around|(|H<rsub|\<leq\>q>|)>>, then
  <math|G> has only <math|h*d<rsup|i>=O<rsup|\<ast\>><around|(|1|)>>
  vertices, and then we can solve the powercut problem exhaustively. Below we
  assume this is not the case.

  <paragraph|Pruning layers checking for good separations> Consider a layer
  <math|H<rsub|i>>, <math|i\<gtr\>0>, and let <math|H<rsub|i><rsup|->> be the
  union of the big components of <math|H<rsub|i>>. Moreover let
  <math|H<rsub|\<less\>i><rsup|+>> be <math|H<rsub|\<less\>i>> combined with
  all the limited components from <math|H<rsub|i>>. We call
  <math|H<rsup|-><rsub|i>> the <with|font-family|rm|pruned layer>. Since the
  limited components have no incident edges from
  <math|G\<setminus\>H<rsub|\<leq\>i>>, we note that <math|H<rsup|-><rsub|i>>
  is a cut between <math|H<rsub|\<less\>i><rsup|+>> and the rest of the
  graph. The lemma below summarizes the important properties obtained:

  <\lemma>
    <label|lem:pruned-layers>For <math|i=1,...,p>:

    <\itemize>
      <item*|(i)>Pruned layer <math|H<rsub|i><rsup|->\<subseteq\>H<rsub|i>>
      is a cut separating <math|H<rsub|0>> from
      <math|G\<setminus\>V<around|(|H<rsub|\<leq\>q>|)>>. In particular, we
      get an articulation point if we identify all of
      <math|H<rsub|i><rsup|->> in a single vertex.

      <item*|(ii)>Each component of <math|H<rsub|i><rsup|->> is of size at
      least <math|q>.
    </itemize>
  </lemma>

  Now, we take each pruned layer <math|H<rsub|i><rsup|->> separately, and
  order the components arbitrarily. For every pair <math|A> and <math|B> of
  consecutive components (of order at least <math|q>), we check if their edge
  connectivity is at least <math|s> in <math|G>. If not, there is a cut
  <math|D> in <math|G> with at most <math|s> edges which separates <math|A>
  and <math|B>. We claim this leads to a good separation. On the one side of
  the separation, we have the component <math|<ol|A>> of
  <math|G\<setminus\>D> containing <math|A>, and on the other we have the
  reminder <math|<ol|B>> of <math|G> which includes <math|B> and cut edges
  from <math|D>. Then <math|<ol|A>> and <math|<ol|B>> intersect in at most
  <math|<around|\||D|\|>\<leq\>s> vertices, and both <math|<ol|A>> and
  <math|<ol|B>> have at least <math|q> vertices. Thus we get a good
  separation.

  Below we assume that for each pruned layer, the edge connectivity between
  consecutive components is at least <math|s>. <paragraph|Articulation points
  from pruned layers>

  <\lemma>
    <label|lem:layer-collapse>If there is a powercut of
    <math|<around|(|G,T,s|)>> that does not use any edge from
    <math|H<rsub|i>>, then all vertices in the pruned layer
    <math|H<rsub|i><rsup|->> can be identified in a single vertex
    <math|v<rsub|i>>.
  </lemma>

  <\proof>
    \ We are claiming that no cut <math|D> from <math|<C>> separates any
    vertices from <math|H<rsub|i><rsup|->>. Otherwise, since <math|D> does
    not contain any edges from <math|H<rsub|i>>, the cut would have to go
    between components from <math|H<rsub|i><rsup|->>. In particular, there
    would be two consecutive components of <math|H<rsub|i><rsup|->> separated
    by <math|D>. However, <math|D> has at most <math|s> edges, and we already
    checked that there was no such small cut between any components of
    <math|H<rsub|i><rsup|->>.
  </proof>

  \ Below we assume we have guessed a layers <math|H<rsub|i>> that is not
  used in some powercut of <math|<around|(|G,T,s|)>>. Let
  <math|<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>> denote that all
  vertices from <math|H<rsub|i><rsup|->> are identified in a single vertex
  <math|v<rsub|i>>, which we call the <em|articulation point>. From Lemma
  <reference|lem:layer-collapse> it follows that some powercut is preserved
  in <math|<around|(|G*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>,T*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>,s|)>>.

  Next, from Lemma <reference|lem:pruned-layers> (i) we get that
  <math|H<rsub|\<leq\>i>*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>>
  is a block of <math|G*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>>
  separated from the rest by the articulation point <math|v<rsub|i>>. As in
  Lemma <reference|lem:recurse-identify>, we now find a powercut
  <math|<C><rsub|i>> of

  <\equation*>
    <\around*|(>
      H<rsub|\<leq\>i>*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>,

      <around|{|v<rsub|0>|}>\<cup\><around|(|T\<cap\>V<around|(|H<rsub|\<leq\>i>|)>|)>*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>,s
    </around*|)>

    .
  </equation*>

  The powercut <math|<C><rsub|i>> can be found exhaustively since
  <math|H<rsub|\<leq\>i>> has at most <math|h*d<rsup|i>=O<rsup|\<ast\>><around|(|1|)>>
  vertices. Since this is not a recursive call, so it is OK if
  <math|<around|{|v<rsub|0>|}>\<cup\><around|(|T\<cap\>V<around|(|H<rsub|\<leq\>i>|)>|)>*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>>
  involves <math|t+1> terminals.

  <\lemma>
    <label|lem:excl-i>If there is a powercut of <math|<around|(|G,T,s|)>>
    that does not use any edge from <math|H<rsub|i>>, then there is such a
    powercut which agrees with <math|<C><rsub|i>> on <math|H<rsub|\<leq\>i>>,
    and on <math|H<rsub|0>> in particular.
  </lemma>

  <\proof>
    \ From Lemma <reference|lem:recurse-identify> we get that
    <math|<C><rsub|i>> is the restriction to
    <math|H<rsub|\<leq\>i>*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>>
    of some powercut <math|<C><rsub|i><rprime|'>> of
    <math|<around|(|G*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>,T*<around|[|H<rsub|i><rsup|->\<mapsto\>v<rsub|i>|]>,s|)>>.
    From Lemma <reference|lem:layer-collapse> it follows that
    <math|<C><rsub|i><rprime|'>> is also a powercut of
    <math|<around|(|G,T,s|)>>. Since <math|<C><rprime|'><rsub|i>> does not
    contain any edges contracted in <math|H<rsub|i><rsup|->>, we conclude
    that <math|<C><rsub|i>> is the restriction of
    <math|<C><rsub|i><rprime|'>> to <math|H<rsub|\<leq\>i>>.
  </proof>

  \ With our assumption that <math|H<rsub|i>> is not used in some powercut,
  we get that all edges in <math|F<rsub|i>=E<around|(|H<rsub|0>|)>\<setminus\>E<around|(|<C><rsub|i>|)>>
  are identifiable. Disregarding the assumption, we are now ready to prove

  <\lemma>
    <label|lem:no-high>Let <math|F=<big|cap><rsub|i=1><rsup|p>F<rsub|i>> be
    the set of edges from <math|H<rsub|0>> that are not used in any
    <math|<C><rsub|i>>, <math|i=1,...,p>. The edges from <math|F> are
    simultaneously contractible.
  </lemma>

  <\proof>
    \ Given any powercut <math|<C>> of <math|<around|(|G,T,s|)>>, since it
    has at most <math|p> edges, we know there is come
    <math|i\<in\><around|{|0,...,p|}>> such that <math|<C>> does not use any
    edge from <math|H<rsub|i>>. If <math|i> is <math|0>, this means all edges
    from <math|H<rsub|0>> are contractible. For any other <math|i>, the claim
    follows from Lemma <reference|lem:excl-i>.
  </proof>

  \ With Lemma <reference|lem:no-high> we contract all edges from
  <math|H<rsub|0>> that are not in some <math|<C><rsub|i>>. From Observation
  <reference|obs:edge-bound>, we know that each <math|<C><rsub|i>> involves
  at most <math|<around|(|s+1|)><rsup|t+2>> edges, so combined they involve
  at most <math|p*<around|(|s+1|)><rsup|t+2>> un-contracted edges, spanning
  at most <math|p*<around|(|s+1|)><rsup|t+2>+1> distinct vertices. As the
  initial size for <math|H<rsub|0>>, we start with

  <\equation>
    <label|eq:h>h=2*<around|(|p*<around|(|s+1|)><rsup|t+2>+1|)>
  </equation>

  vertices. Therefore, when we contracting all edges from <math|H<rsub|0>>
  that are not in some <math|<C><rsub|i>>, we get rid of half the vertices
  from <math|H<rsub|0>>.

  <subsection|A single high degree \Papex\Q vertex>

  All that remains is to consider the case where there is a single high
  degree vertex <math|r> with degree <math|\<geq\>d>\Vc.f. <req|eq:d>. We are
  basically going to run the reduction for no high degree from
  Section<nbsp><reference|sec:small-degrees> on the graph
  <math|G\<setminus\><around|{|r|}>>, but with some subtle extensions
  described below.

  Starting from an arbitrary vertex that is <math|v<rsub|0>> neighbor to
  <math|r>, we construct the layers <math|H<rsub|i>> in
  <math|G\<setminus\><around|{|r|}>>. If this includes all vertices of
  <math|G\<setminus\><around|{|r|}>>, then <math|G> has
  <math|O<rsup|\<ast\>><around|(|1|)>> vertices, and then we find the
  powercut exhaustively.

  Next we add the vertex <math|r> to each layer <math|H<rsub|i>>, including
  all edges between <math|r> and <math|H<rsub|i>\<setminus\>H<rsub|\<less\>i>>.
  We denote this graph <math|H<rsup|r><rsub|i>>. Note that
  <math|H<rsub|0><rsup|r>> is connected since <math|r> is a neighbor of
  <math|v<rsub|0>>. Also note that all the <math|H<rsup|r><rsub|i>> are edge
  disjoint like the <math|H<rsub|i>>.

  After the addition of <math|r>, for <math|i\<gtr\>0>, we turn any limited
  component involving <math|r> big. More precisely, in
  <math|H<rsup|r><rsub|i>> we say that a component is
  <with|font-shape|italic|big> if it is has <math|q> or more vertices or if
  it contains <math|r>. The remaining components are
  <with|font-shape|italic|limited>. Removing all other limited components
  from <math|H<rsup|r><rsub|i>> we get the <with|font-shape|italic|pruned
  layer> <math|H<rsup|r-><rsub|i>>. Similarly, we have the graph
  <math|H<rsup|r+><rsub|\<less\>i>> which is <math|H<rsup|r><rsub|\<less\>i>>
  expanded with the limited components from <math|H<rsup|r><rsub|i>>.
  Corresponding to Lemma <reference|lem:pruned-layers>, we get

  <\lemma>
    <label|lem:pruned-layers-r>For <math|i=1,...,p>:

    <\itemize>
      <item*|(i)>The vertices from the pruned layer <math|H<rsup|r-><rsub|i>>
      form a vertex separator in <math|G> between <math|H<rsub|0><rsup|r>>
      and <math|G\<setminus\>H<rsup|r><rsub|\<leq\>q>>. In particular, we get
      an articulation point if we identify <math|H<rsup|r><rsub|i>> in a
      single vertex.

      <item*|(ii)>Each component of <math|H<rsub|i><rsup|r->> which does not
      contain <math|r> has at least <math|q> vertices.
    </itemize>
  </lemma>

  <\proof>
    \ Above (ii) is trivial. Concerning (i), we already have from Lemma
    <reference|lem:pruned-layers> that the edges from
    <math|H<rsup|-><rsub|i>> provide a cut of
    <math|G\<setminus\><around|{|r|}>> between <math|H<rsub|0>> and
    <math|G\<setminus\><around|{|r|}>\<setminus\>H<rsub|\<leq\>q>>. The
    vertices in <math|H<rsup|-><rsub|i>> provide a corresponding vertex
    separation in <math|G\<setminus\><around|{|r|}>>. When adding <math|r> to
    the graph and to the separation, we get a vertex separation
    <math|V<around|(|H<rsup|r-><rsub|i>|)>> between <math|H<rsub|0>> and
    <math|G\<setminus\>H<rsup|r><rsub|\<leq\>q>>.
  </proof>

  \ Now, as in Section <reference|sec:small-degrees>, we order the components
  of <math|H<rsup|r-><rsub|i>> arbitrarily, and check if the edge
  connectivity between pairs of consecutive components is at least <math|s>
  in <math|G>. If not, we claim there is a good separation. Let <math|D> be a
  cut in <math|G> of size at most <math|s> between two components <math|A>
  and <math|B> of <math|H<rsup|r-><rsub|i>>. If <math|A> and <math|B> both
  have at least <math|q> vertices, then we have the same good separation as
  in Section <reference|sec:small-degrees>. Otherwise, one of them, say
  <math|B> involves <math|r>. In this case we have an argument similar to
  that used for two high degree vertices in Section
  <reference|sec:high-degrees>. On one side of the good separation, we have
  the component <math|<ol|A>> of <math|G\<setminus\>D> including <math|A>.
  Clearly it has at least <math|<around|\||V<around|(|A|)>|\|>\<geq\>q>
  vertices. The other side <math|<ol|B>> is the rest of <math|G> including
  <math|B> and the cut edges from <math|D>. Then <math|<ol|B>> includes the
  neighborhood of all vertices in <math|B> including all neighbors of
  <math|r>, so <math|<ol|B>> has at least <math|d+1\<gtr\>q> vertices. Below
  we assume that we did not find such a good separation.

  We now continue exactly as in Section <reference|sec:small-degrees>. For
  <math|i=1,...,q> we identify the vertices of <math|H<rsup|r-><rsub|i>> in a
  vertex <math|v<rsub|i>> which becomes an articulation point, and then we
  find a powercut <math|<C><rsub|i>> of

  <\equation*>
    <\around*|\<nobracket\>>
      <\around*|(>
        H<rsup|r><rsub|\<leq\>i>*<around|[|H<rsub|i><rsup|r->\<mapsto\>v<rsub|i>|]>,

        <around|{|v<rsub|0>|}>\<cup\><around|(|T\<cap\>V<around|(|H<rsup|r><rsub|\<leq\>i>|)>|)>*<around|[|H<rsub|i><rsup|r->\<mapsto\>v<rsub|i>|]>
      </around*|)>

      ,s
    </around*|)>.
  </equation*>

  Corresponding to Lemma <reference|lem:no-high>, we get

  <\lemma>
    <label|lem:no-high-r>The edges from <math|H<rsub|0><rsup|r>> that are not
    used in any <math|<C><rsub|i>>, <math|i=1,...,p> are simultaneously
    contractible.
  </lemma>

  As in Section <reference|sec:small-degrees>, we conclude that we get at
  most <math|p*<around|(|s+1|)><rsup|t+2>> un-contracted edges from Lemma
  <reference|lem:no-high-r> and they span at most
  <math|p*<around|(|s+1|)><rsup|t+2>+1> distinct vertices. As the initial
  size for <math|H<rsub|0><rsup|r>>, we start with
  <math|h+1=2*<around|(|p*<around|(|s+1|)><rsup|t+2>+1|)>> vertices. Then the
  contractions of Lemma <reference|lem:no-high-r> allows us to get rid of at
  least half the <math|h> vertices in <math|H<rsub|0><rsup|r>>.

  <subsection|Analysis and implementation>

  We are now going to analyze the running time including some implementation
  details of the above recursive algorithm, proving a time bound of

  <\equation>
    <label|eq:T>T<around|(|n|)>=O*<around*|(|s<rsup|t<rsup|<space|0.17em>O<around|(|t|)>>>*n<rsup|2>|)>.
  </equation>

  First, we argue that we can assume sparsity with at most
  <math|O*<around|(|s*n|)>> edges. More precisely, if the graph at some point
  has <math|m\<geq\>2*s*n> edges, as in <cite|NI92> we find <math|s> edge
  disjoint maximal spanning forests If an edge <math|<around|(|v,w|)>> is not
  in one of these spanning forests, then <math|v> and <math|w> are <math|s>
  edge connected. We can therefore contract all such outside edges, leaving
  us with at most <math|s*n\<leq\>m/2> edges. This may also reduce the number
  of vertices, which is only positive. The overall cost of this process is
  easily bounded by <math|O*<around|(|s*n<rsup|2>|)>>.

  In our analysis, for simplicity, we just focus on the case with no high
  degree vertices from Section<nbsp><reference|sec:small-degrees>. When we
  look for good separations, we check if the edge connectivity between two
  vertex sets is <math|s>. As we saw above, the graph can be assumed to have
  at most <math|2*n*s> edges, so this takes only
  <math|O*<around|(|s<rsup|2>*n|)>> time <cite|FF65> including identifying a
  cut with <math|s> edges if it exists. The number of such good separation
  checks is limited by the total number of components in all the layers
  <math|H<rsub|i>>, and for each layer, this is limited by the number of
  vertices. Thus, by Lemma <reference|lem:growth>, we have at most
  <math|<big|sum><rsub|i=1><rsup|p>h*d<rsup|i>\<less\>2*h*d<rsup|p>> good
  separation checks, each of which takes <math|O*<around|(|s<rsup|2>*n|)>>
  time. With <math|t\<geq\>2*s>, <math|p=<around|(|s+1|)><rsup|t+1>>,
  <math|q=2*<around|(|p+1|)>>, <math|d=q+s-1>, and
  <math|h=2*<around|(|p*<around|(|s+1|)><rsup|t+2>+1|)>>\Vc.f. <req|eq:t>,
  <req|eq:pq>, <req|eq:d>, and <req|eq:h>\Vwe get that the total time for
  good separation checks is bounded by

  <\equation*>
    O*<around|(|2*h*d<rsup|p>*s<rsup|2>*n|)>=O*<around|(|s<rsup|t<rsup|<space|0.17em>O<around|(|t|)>>>*n|)>.
  </equation*>

  If we do find a good separation, we recurse on one of the sides <math|A>,
  which we know has at least <math|q> vertices. Including the separating
  vertices, we know that <math|A> has at most <math|n-q+s> vertices. After
  the recursion, we can identify all but <math|q/2> vertices in <math|A>. All
  this leads to a the recurrence

  <\equation*>
    T<around|(|n|)>\<leq\>max<rsub|q\<leq\>\<ell\>\<leq\>n-q+s>
    O*<around*|(|s<rsup|t<rsup|<space|0.17em>O<around|(|t|)>>>*n|)>+T<around|(|\<ell\>|)>+T*<around|(|n-\<ell\>+q/2|)>.
  </equation*>

  Inductively this recurrence satisfies <req|eq:T>, the worst-case being when
  <math|\<ell\>> attains one of its extreme values.

  If we do not find a good separation, for <math|i=1,...,p>, we exhaustively
  find a powercut of a graph with at most <math|h*d<rsup|i>> vertices and
  <math|s*h*d<rsup|i>> edges. We simply consider all the
  <math|<around|(|s*h*d<rsup|i>|)><rsup|s>> potential cuts with <math|s>
  edges, and that is done in <math|O*<around*|(|s<rsup|t<rsup|<space|0.17em>O<around|(|t|)>>>*n|)>>
  total time. This reduces the number of vertices in <math|H<rsub|0>> from
  <math|h> to <math|h/2>, so again we get a recurrence satisfying <req|eq:T>,
  completing the proof that <req|eq:T> bounds our overall running time. In
  the case of the <math|k>-way cut problem, we start with no terminals. Then
  <math|t=2*s>, and then our running time is bounded by
  <math|O*<around*|(|s<rsup|s<rsup|O<around|(|s|)>>>*n<rsup|2>|)>>.

  <section|Planar graphs and bounded genus graphs><label|sec:planar>

  We now present a simple algorithm for the planar case. We need several
  known ingredients. First, since a planar graph always has a vertex of
  degree at most 5, we get a <math|k>-way cut of size at most
  <math|5*<around|(|k-1|)>> if we <math|k-1> times cut out the vertex of
  current smallest degree. Thus we have

  <\observation>
    <label|obs:triv-cut>A simple planar graph has a <math|k>-way cut of size
    at most <math|5*<around|(|k-1|)>>.
  </observation>

  The same observation was used in the previous slower algorithms for
  <math|3>-way cuts <cite|He91|HS85>.

  Our new <math|k>-way cut algorithm applies to planar graphs with parallel
  edges, but like our algorithm for general graphs, it needs a bound <math|s>
  on the size of the cuts considered. Such a size bound will also be used for
  bounded genus graphs. We will apply the algorithm to a simple planar graph
  using the bound <math|s=5*k-5> from Observation <reference|obs:triv-cut>.
  Parallel edges will turn up as the algorithm contracts edges in the
  original graph, but the size of the minimum <math|k>-way cut will not
  change and neither will the value of <math|s>.

  Our algorithm uses the notion of tree decompositions and tree-width. The
  formal definitions are reviewed in Appendix <reference|sec:tree-width>,
  which also includes the proof of the lemma below which is kind of folklore:

  <\lemma>
    <label|lem:Ken>If a planar graph <math|H> has tree width at most
    <math|w>, then we can find a minimum <math|k>-way cut in
    <math|O<around|(|2<rsup|O*<around|(|k*w|)>><around|\||V<around|(|H|)>|\|>|)>>
    time. For a general graph <math|H> of tree width at most <math|w>, we can
    find a minimum <math|k>-way cut in <math|O<around|(|w<rsup|k*w><around|\||V<around|(|H|)>|\|>|)>>
    time.
  </lemma>

  Hereafter, <math|n> always means the number of vertices of the input graph
  <math|G>. For any set <math|A> of edges, we let <math|G/A> denote <math|G>
  with the edges <math|A> contracted. If <math|G> is embedded, respecting the
  embedding, we contract the edges from <math|A> one by one, except that
  loops are deleted. We need the following theorem:

  <\lemma>
    [Klein <cite|Kle08>]<label|lem:Klein> For any parameter <math|q> and a
    planar graph <math|G> with <math|n> vertices, there is an
    <math|O<around|(|n|)>> time algorithm to partition the edges of <math|G>
    into <math|q> disjoint edge sets <math|S<rsub|0>>,...,<math|S<rsub|q-1>>
    such that for each <math|i\<in\><around|[|q|]>>, the graph
    <math|G/S<rsub|i>> has tree width <math|O<around|(|q|)>>.
  </lemma>

  <paragraph|A planar minimum <math|k>-way cut algorithm> If a given graph is
  not already embedded, we embed it in <math|O<around|(|n|)>> time using the
  algorithm from <cite|planarity>. Therefore we assume that <math|G> is
  embedded into a plane. To find a minimum <math|k>-way cut in <math|G>, we
  set <math|q=s+1=5*k-4> in Lemma <reference|lem:Klein>, and apply Lemma
  <reference|lem:Klein> to <math|G>. Next, using Lemma <reference|lem:Ken>,
  we compute the minimum <math|k>-way cut <math|D<rsub|i>> of each
  <math|G/S<rsub|i>> in <math|O*<around|(|q*2<rsup|O*<around|(|k*q|)>>*n|)>=O*<around|(|2<rsup|O*<around|(|k*q|)>>*n|)>=O*<around|(|2<rsup|O<around|(|k<rsup|2>|)>>*n|)>>
  total time. We return the smallest of these cuts <math|D<rsub|i>>.

  <\theorem>
    <label|thm:min-cut>We can solve the <math|k>-way cut problem for a simple
    unweighted planar graph in <math|O*<around|(|2<rsup|O<around|(|k<rsup|2>|)>>*n|)>>
    time.
  </theorem>

  <\proof>
    \ Cutting after some edges have been contracted is also a cut in the
    original graph, so the cut returned by our algorithm is indeed a
    <math|k>-way cut. We need to argue that one of the <math|D<rsub|i>> is a
    minimal one for <math|G>. From Observation <reference|obs:triv-cut>, we
    know that the minimum <math|k>-way cut <math|D> has at most <math|s>
    edges, which means that it must be disjoint from at least one of the
    <math|s+1> disjoint <math|S<rsub|i>>. Then <math|D> is also a
    <math|k>-way cut of <math|G/S<rsub|i>>. Hence the minimum <math|k>-way
    cut <math|D<rsub|i>> of <math|G/S<rsub|i>> is also a minimum <math|k>-way
    cut of <math|G>.
  </proof>

  <paragraph|Bounded genus> If a given graph is not already embedded, we
  embed it in <math|O*<around|(|2<rsup|g>*n|)>> time using the algorithm from
  <cite|mohar>. Therefore we assume that <math|G> is embedded into a surface
  of genus <math|g>. We now extend our planar algorithm to the bounded genus
  case. From Euler's formula, we get

  <\observation>
    <label|obs:bdg>A simple graph embedded into a surface with genus <math|g>
    and <math|n=<around|\||V<around|(|G|)>|\|>\<geq\>6*g+k> has a minimum
    <math|k>-way cut in <math|G> of size at most <math|6*k-6>.
  </observation>

  Next we need the following generalization of Klein's Lemma
  <reference|lem:Klein>:

  <\lemma>
    <label|lem:kk>For any parameter <math|q> and a graph <math|G> embedded
    into a surface of genus <math|g> with <math|n> vertices, there is an
    <math|O*<around|(|2<rsup|O*<around|(|g<rsup|2>*q|)>>*n|)>> time algorithm
    to partition the edges of <math|G> into <math|q> disjoint edge sets
    <math|S<rsub|0>>,...,<math|S<rsub|q-1>> such that for each
    <math|i\<in\><around|[|q|]>>, the graph <math|G/S<rsub|i>> has tree width
    <math|O*<around|(|g<rsup|2>*q|)>>.
  </lemma>

  Lemma <reference|lem:kk> with a partition time of
  <math|O*<around|(|g<rsup|3>*n*log n|)>> follows from <cite|CC07|DHM07>. Our
  time bound is better when <math|g,q=O<around|(|1|)>>. Our proof of Lemma
  <reference|lem:kk> is deferred to Appendix <reference|app:genus>. We can
  now proceed as in the planar case and prove:

  <\theorem>
    <label|thm:genus-cut>We can solve the <math|k>-way cut problem for a
    simple unweighted graph with genus <math|g> in
    <math|O*<around|(|2<rsup|O*<around|(|k<rsup|2>*g<rsup|2>|)>>*n|)>> time.
  </theorem>

  In fact, we can also plug Lemma <reference|lem:kk> back into Klein's
  original approximate TSP algorithm, generalizing his linear time solution
  from the planar to the bounded genus case.

  <\bibliography|bib|abbrv|paper>
    <bib-list|[99]|>
  </bibliography>

  <surround|<new-page>||<with|font-size|1.68|<\center>
    Appendix
  </center>>>

  <section|Tree width Bounded Case><label|sec:tree-width>

  In this section, we shall deal with the tree width bounded case.

  Recall that a <DEF|tree decomposition> of a graph <math|G> is a pair
  <math|<around|(|T,R|)>>, where <math|T> is a tree and <math|R> is a family
  <math|<around|{|R<rsub|t>\<mid\>t\<in\>V<around|(|T|)>|}>> of vertex sets
  <math|R<rsub|t>\<subseteq\>V<around|(|G|)>>, such that the following two
  properties hold:

  <\enumerate>
    <item*|(1)><math|<big|cup><rsub|t\<in\>V<around|(|T|)>>R<rsub|t>=V<around|(|G|)>>,
    and every edge of <math|G> has both ends in some <math|R<rsub|t>>.

    <item*|(2)>If <math|t,t<rprime|'>,t<rprime|''>\<in\>V<around|(|T|)>> and
    <math|t<rprime|'>> lies on the path in <math|T> between <math|t> and
    <math|t<rprime|''>>, then <math|R<rsub|t>\<cap\>R<rsub|t<rprime|''>>\<subseteq\>R<rsub|t<rprime|'>>>.
  </enumerate>

  The <DEF|width> of a tree-decomposition is <math|max
  <around|\||R<rsub|t>|\|>> for <math|t\<in\>V<around|(|T|)>>. The <DEF|tree
  width> of <math|G> is defined as the minimum width taken over all tree
  decompositions of <math|G>. We often refer to the sets <math|R<rsub|t>> as
  a <DEF|bags> of the tree decomposition.

  We first observe that if a given graph has tree-width at most <math|w>,
  then we can construct a tree-decomposition of width at most <math|w> in
  <math|O*<around|(|w<rsup|w>*n|)>> time by Theorem <reference|grid> below.

  <\theorem>
    [<cite|bod>]<label|grid> For any constant <math|w>, there exists an
    <math|O*<around|(|w<rsup|w>*n|)>> time algorithm that, given a graph
    <math|G>, either finds a tree-decomposition of <math|G> of width <math|w>
    or concludes that <math|G> has tree width at least <math|w>. For a planar
    graph, the time complexity can be improved to
    <math|O*<around|(|2<rsup|w>*n|)>>.
  </theorem>

  Thus we just need to prove the following:

  <\quote-env>
    Given a tree-decomposition of width at most <math|w>, and for any fixed
    <math|k>, there is an <math|O*<around|(|w<rsup|k*w>*n|)>> time algorithm
    to find a minimum <math|k>-way cut.
  </quote-env>

  We first observe that each graph with tree width <math|w> has a vertex of
  degree at most <math|w>. Thus we get a <math|k>-way cut of size at most
  <math|k*w> if we <math|k-1> times cut the vertex of current smallest
  degree.

  We follow the approach in <cite|AP89>. In fact, our proof is almost
  identical to that in <cite|AP89>. So we only give sketch of our proof.

  The dynamic programming approach of Arnborg and Proskurowski <cite|AP89>
  assumes that <math|T> is a rooted tree whose edges are directed away from
  the root. For <math|t<rsub|1>*t<rprime|'><rsub|1>\<in\>E<around|(|T|)>>
  (where <math|t<rsub|1>> is closer to the root than
  <math|t<rprime|'><rsub|1>>), define <math|S<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>=R<rsub|t<rsub|1>>\<cap\>R<rsub|t<rprime|'><rsub|1>>>
  and <math|G<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>> to be the induced
  subgraph of <math|G> on vertices <math|<big|cup>R<rsub|s>>, where the union
  runs over all nodes of <math|T> that are in the component of
  <math|T-t<rsub|1>*t<rprime|'><rsub|1>> that does not contain the root. The
  algorithm of Arnborg and Proskurowski starts at all the leaves of <math|T>
  and then we have to compute the following:

  <\quote-env>
    For every <math|t<rsub|1>*t<rprime|'><rsub|1>\<in\>E<around|(|T|)>>
    (where <math|t<rsub|1>> is closer to the root than
    <math|t<rprime|'><rsub|1>>), we compute the powercut with input
    <math|<around|(|G<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>,S<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>,k*w|)>>.
  </quote-env>

  It is clear that we can compute the powercut in each leaf in time
  <math|O<around|(|w<rsup|k>|)>> by brute force. Given that we have computed
  the powercut for all the children of <math|t<rprime|'><rsub|1>> (i.e, for
  every children <math|t<rprime|''><rsub|1>> of <math|t<rprime|'><rsub|1>>,
  we have computed the powercut <math|<around|(|G<around|(|t<rprime|'><rsub|1>,t<rprime|''><rsub|1>|)>,S<around|(|t<rprime|'><rsub|1>,t<rprime|''><rsub|1>|)>,k*w|)>>),
  we have to compute the powercut with input
  <math|<around|(|G<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>,S<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>,k*w|)>>.

  From each children bag <math|R<rsub|t<rprime|''><rsub|1>>> of
  <math|R<rsub|t<rprime|'><rsub|1>>>, we have at most <math|w<rsup|k>>
  information to be taken account when we work on the bag
  <math|R<rsub|t<rprime|'><rsub|1>>>. However, some information can be
  merged.

  <vspace|0.5fn>(1) If <math|A,B,S> are a separation in <math|G> (i.e,
  <math|A\<cap\>B=S>), and the powercuts are computed with inputs both
  <math|<around|(|A,S,k*w|)>> and <math|<around|(|B,S,k*w|)>>, then, in
  <math|O<around|(|w<rsup|k>|)>> time, we can compute the powercut with input
  <math|<around|(|G,S,k*w|)>>.

  <vspace|0.5fn>Since the information for <math|A> and <math|B> can be easily
  combined, thus (1) follows.

  <vspace|1fn>By (1), if there are two children <math|t<rsub|2>,t<rsub|3>> of
  <math|t<rprime|'><rsub|1>> such that <math|S<around|(|t<rprime|'><rsub|1>,t<rsub|2>|)>=S<around|(|t<rprime|'><rsub|1>,t<rsub|3>|)>>,
  then we can combine the powercuts (with inputs
  <math|<around|(|G<around|(|t<rprime|'><rsub|1>,t<rsub|2>|)>,S<around|(|t<rprime|'><rsub|1>,t<rsub|2>|)>,k*w|)>>
  and <math|<around|(|G<around|(|t<rprime|'><rsub|1>,t<rsub|3>|)>,S<around|(|t<rprime|'><rsub|1>,t<rsub|3>|)>,k*w|)>>)
  from them.

  Since there are at most <math|2<rsup|w>> different subsets of
  <math|R<rsub|t<rprime|'><rsub|1>>>, thus from the children of
  <math|t<rprime|'><rsub|1>>, we have at most
  <math|w<rsup|k>\<times\>2<rsup|w>> information in total to take into
  account.

  Therefore in time <math|O*<around|(|2<rsup|w>*w<rsup|k>*w<rsup|k>|)>=O<around|(|w<rsup|k*w>|)>>,
  we can compute the powercut with input <math|<around|(|G<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>,S<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>,k*w|)>>.

  We keep working from the leaves to the root. At the root, we can pick up a
  minimum <math|k>-way cut. Since there are at most <math|n> pieces in the
  tree-decomposition <math|<around|(|T,R|)>>, in
  <math|O*<around|(|w<rsup|k*w>*n|)>> time, we can compute a minimum
  <math|k>-way cut in <math|G>. <qed>

  <vspace|1fn>We now prove the planar case in Lemma <reference|lem:Ken>. We
  follow the above proof of Lemma <reference|lem:Ken> for the general case.
  We shall show that the running time in the above proof can be improved to
  <math|O*<around|(|2<rsup|k*w>*n|)>> when an input graph <math|G> is planar.

  Two points in the above proof can be improved when an input graph <math|G>
  is planar.

  First, in the above proof for the general case, for any <math|t>, we need
  to consider <math|2<rsup|<around|\||R<rsub|t>|\|>>> partitions of
  <math|R<rsub|t>> when we take the information of the children of <math|t>
  into account (by (1), if there are more than
  <math|2<rsup|<around|\||R<rsub|t>|\|>>> children of <math|t>, we can merge
  some information from the children of <math|t>). But when a given graph is
  planar, since <math|G> does not have a Kuratowski graph, i.e, either a
  <math|K<rsub|3,3>>-minor or a <math|K<rsub|5>>-minor, we can improve the
  bound <math|2<rsup|<around|\||R<rsub|t>|\|>>> to
  <math|3<around|\||R<rsub|t>|\|><rsup|3>> as follows:

  We are interested in the number of children of <math|t> that share at least
  three vertices with <math|R<rsub|t>>. There are at most <math|w<rsup|3>>
  choices to choose three vertices. But on the other hand, if some three
  vertices of <math|R<rsub|t>> are attached to three children of <math|t>, we
  can get a <math|K<rsub|3,3>>-minor. This is because, for each such a child
  <math|t<rprime|'>> of <math|t>, a subgraph of <math|G> induced by
  <math|<big|cup>R<rsub|s>>, where the union runs over all nodes of <math|T>
  that are in the component of <math|T-t*t<rprime|'>> that contains
  <math|t<rprime|'>>, is connected (otherwise, we can \Psplit\Q the children
  <math|t<rprime|'>>). Thus we can easily find a <math|K<rsub|3,3>>-minor by
  contracting each such a connected subgraph into a single vertex. This
  implies that there are at most <math|2*w<rsup|3>> children that share at
  least three vertices with <math|R<rsub|t>>.

  For the children of <math|t> that share at most two vertices with
  <math|R<rsub|t>>, we just need to take <math|w+w<rsup|2>> subsets of
  <math|R<rsub|t>> into account by (1). This implies that, for each node
  <math|t> of <math|T>, we only need to consider at most <math|3*w<rsup|3>>
  partitions of <math|R<rsub|t>> when we take the information of the children
  of <math|t> into account, as claimed.

  Second, since <math|S<around|(|t<rprime|''>,t|)>> is a vertex-cut in a
  planar <math|G>, where <math|t<rprime|''>> is a parent of <math|t>, a
  minimal vertex cut in <math|S<around|(|t<rprime|''>,t|)>> consists of
  closed curve(s) <math|C> in a plane. If <math|C> does not contain a vertex
  <math|v> in <math|S<around|(|t<rprime|''>,t|)>>, then either <math|v> does
  not have any neighbor in <math|G<around|(|t<rprime|''>,t|)>-R<rsub|t<rprime|''>>>,
  in which case, <math|v> does not have to be in
  <math|S<around|(|t<rprime|''>,t|)>>, or <math|v> does not have any neighbor
  in <math|R<rsub|t<rprime|''>>-S<around|(|t<rprime|''>,t|)>>, in which case,
  again, <math|v> does not have to be in <math|S<around|(|t<rprime|''>,t|)>>
  either. Thus we may assume that <math|C> consists of all the vertices in
  <math|S<around|(|t<rprime|''>,t|)>>. In addition, all the vertices in
  <math|G<around|(|t<rprime|''>,t|)>> is contained inside some curve(s) in
  <math|C>. Given a cyclic order of <math|S<around|(|t<rprime|''>,t|)>> along
  each curve in <math|C>, by the planarity, we cannot have a \Pcrossed\Q
  partition, i.e, there are no four vertices
  <math|s<rsub|1>,s<rsub|2>,t<rsub|1>,t<rsub|2>> in the clockwise order along
  a curve in <math|C> such that both <math|s<rsub|i>> and <math|t<rsub|i>>
  are contained in the same component in <math|R<rsub|t>-D> for <math|i=1,2>,
  where <math|D> is a cut. If <math|C> consists of more than two curves, we
  can apply this argument separately. Thus it follows that when we consider
  the powercut with input <math|<around|(|G<around|(|t<rprime|''>,t|)>,S<around|(|t<rprime|''>,t|)>,k*w|)>>,
  we only need to consider at most <math|2<rsup|k*w>> ways to partition
  <math|S<around|(|t<rprime|'>,t|)>> into at most <math|k> parts. So when we
  do exhaustive search for each bag <math|R<rsub|t>>, we need to consider
  only <math|2<rsup|k*w>> ways for the planar case (in contrast, we need to
  consider <math|w<rsup|k>> ways for the general case, as above). In summary:

  <\quote-env>
    Given a tree-decomposition of width at most <math|w> for a planar graph,
    and for any fixed <math|k>, there is an
    <math|O*<around|(|2<rsup|k*w>*n|)>> time algorithm to find a minimum
    <math|k>-way cut.
  </quote-env>

  This completes the proof of Lemma <reference|lem:Ken>.

  <section|Bounded genus><label|app:genus>

  In this section, we prove Lemma <reference|lem:kk>. We assume that the
  graph is already embedded in a surface of minimal genus <math|g>. Thus it
  suffices to prove

  <\lemma>
    <label|lem:kk1>For any parameter <math|q> and a graph <math|G> embedded
    into a surface of Euler genus <math|g> with <math|n> vertices, there is
    an <math|O*<around|(|2<rsup|g<rsup|2>*q>*n|)>> time algorithm to
    partition the edges of <math|G> into <math|q> disjoint edge sets
    <math|S<rsub|0>>,...,<math|S<rsub|q-1>> such that for each
    <math|i\<in\><around|[|q|]>>, the graph <math|G/S<rsub|i>> has tree width
    <math|O*<around|(|g<rsup|2>*q|)>>.
  </lemma>

  All the arguments in Theorem 3.3 in <cite|DHM07>, except for finding a
  shortest non-contractible cycle in <math|G>, can be implemented in linear
  time. This expensive part needs <math|O*<around|(|g<rsup|5/2>*n<rsup|3/2>*log
  n|)>> time.

  Thus we shall just give a linear time algorithm for this only super linear
  subproblem.

  In order to prove Lemma <reference|lem:kk1>, we need some definitions.

  Let <math|R> be an embedding of <math|G> in a surface <math|S>. Recall that
  a surface minor is defined as follows. For each edge <math|e> of <math|G>,
  <math|R> induces an embedding of both <math|G\<setminus\>e> and <math|G/e>.
  The induced embedding of <math|G/e> is always in the same surface, but the
  removal of <math|e> may give rise to a face which is not homeomorphic to a
  disk, in which case the induced embedding of <math|G\<setminus\>e> may be
  in another surface (of smaller genus). A sequence of contractions and
  deletions of edges results in a <math|R<rprime|'>>-embedded minor
  <math|G<rprime|'>> of <math|G>, and we say that the
  <math|R<rprime|'>>-embedded minor <math|G<rprime|'>> is a <DEF|surface
  minor> of <math|R>-embedded graph <math|G>.

  A graph <math|G> embedded in a surface <math|S> has <DEF|face-width> or
  <DEF|representativity> at least <math|l>, if every non-contractible closed
  curve in the surface intersects the graph in at least <math|l> points. This
  notion turns out to be of great importance in the graph minor theory of
  Robertson and Seymour and in topological graph theory,
  cf.<nbsp><cite|MT01>. Let <math|C> be a non-contractible cycle. We say that
  a cycle <math|C<rprime|'>> is <DEF|homotopic> to <math|C> if
  <math|C<rprime|'>> can be continuously deformed into <math|C> in the
  surface.

  An embedding of a given graph is <DEF|minimal of face-width <math|l>>, if
  it has face-width <math|l>, but for each edge <math|e> of <math|G>, the
  face-width of both <math|G\<setminus\>e> and <math|G/e> is less than
  <math|l>. It is known that a graph <math|G> has an embedding in the surface
  <math|S> with face-width at least <math|l> if and only if <math|G> contains
  at least one of minimal embeddings of face-width <math|l> as a surface
  minor, see <cite|MT01>.

  Theorems 5.6.1 and 5.4.1 in <cite|MT01> guarantee the following:

  <\theorem>
    <label|mini><showlabel|mini> A minimal embedding of face-width <math|l>
    in a surface of Euler genus <math|g> has at most
    <math|N=N<around|(|g,l|)>> vertices, where the integer <math|N> depends
    on <math|g> and <math|l> only.
  </theorem>

  In <cite|KM08>, the following linear time algorithm is given.

  <\theorem>
    <label|linmin><showlabel|linmin> Suppose <math|G> has an embedding of
    face-width at least <math|l> in a surface <math|S> of Euler genus
    <math|g>. Then there is an <math|O*<around|(|2<rsup|g*l>*n|)>> time
    algorithm to detect one of the minimal embeddings of face-width <math|l>
    in the surface <math|S> as a surface minor in <math|G>.
  </theorem>

  We also need the following result in <cite|KM08>.

  <\theorem>
    <label|short><showlabel|short> For each surface <math|S> with Euler genus
    <math|g> and a given integer <math|l>, there is an
    <math|O*<around|(|2<rsup|g*l>*n|)>> time algorithm to decide, for a graph
    <math|G> embedded in the surface <math|S>, if the embedding of <math|G>
    has face-width at least <math|l>. Furthermore, if face-width is at most
    <math|l>, then there is an <math|O*<around|(|2<rsup|g*l>*n|)>> time
    algorithm to find a shortest non-contractible curve.
  </theorem>

  Finally, we need one more definition. If <math|G> is a plane 2-connected
  graph with outer cycle <math|C<rsub|1>> and another facial cycle
  <math|C<rsub|0>> disjoint from <math|C<rsub|1>>, then we call <math|G> a
  <DEF|cylinder> with <DEF|outer cycle> <math|C<rsub|1>> and <DEF|inner
  cycle> <math|C<rsub|0>>. Disjoint cycles
  <math|C<rsub|1>,\<ldots\>,C<rsub|n>> in <math|G> are <em|concentric> if
  they bound discs <math|D<rsub|C<rsub|1>>\<supseteq\>\<ldots\>\<supseteq\>D<rsub|C<rsub|n>>>.
  The <DEF|cylinder-width> of <math|G> is the largest integer <math|q> such
  that <math|G> has <math|q> pairwise disjoint concentric cycles
  <math|C<rsub|1>,\<ldots\>,C<rsub|q>> with the outer cycle <math|C<rsub|1>>.

  We are now ready to prove Lemma <reference|lem:kk1>.

  <with|font-shape|italic|Proof of Lemma <reference|lem:kk1>.>

  We just follow the proof of Theorem 3.3 in <cite|DHM07>. As mentioned
  above, the only super linear subproblem is to find a shortest
  non-contractible cycle in <cite|DHM07>.

  We now show how to avoid finding the shortest non-contractible cycles.

  The proof of Theorem 3.3 in <cite|DHM07> needs to find the shortest
  non-contractible cycles for these two points:

  <\enumerate>
    <item*|(a)>We need to deal with the case that the face-width is
    <math|O*<around|(|g*q|)>>. In this case, <cite|DHM07> (c.f Lemma
    <reference|lem:kk1>) needs to find a shortest non-contractible curve.

    <item*|(b)>On the other hand, if the face-width of <math|G> is at least
    <math|64*q*g>, we need to find a cylinder <math|Q> with the outer cycle
    <math|C<rsub|1>> such that <math|C<rsub|1>> is a non-contractible cycle,
    and the cylinder-width of <math|Q> is at least <math|8*q>. Normally, this
    can be found by using a shortest non-contractible cycle.
  </enumerate>

  Having (a) and (b), the proof of Theorem 3.3 in <cite|DHM07> can be
  implemented in <math|O*<around|(|2<rsup|g<rsup|2>*q>*n|)>>.

  We now obtain (a) and (b) in <math|O*<around|(|2<rsup|g*q>*n|)>> time and
  in <math|O*<around|(|2<rsup|g<rsup|2>*q>*n|)>> time, respectively.

  First, Theorem <reference|short> gives rise to (a) in time
  <math|O*<around|(|2<rsup|g*q>*n|)>> with <math|l=O*<around|(|g*q|)>>.
  Suppose that face-width is at least <math|64*g*q>. We first apply Theorem
  <reference|linmin> to <math|G> and the surface <math|S> of Euler genus
  <math|g>, with <math|l=64*g*q>, to get one of the minimal embeddings of
  face-width <math|l> in the surface <math|S> as a surface minor, say
  <math|R>, in <math|G>. We know from <cite|MT01> that this minor <math|R>
  has a cylinder <math|Q> (as a subgraph) with the outer cycle
  <math|C<rsub|1>> such that <math|C<rsub|1>> is a non-contractible cycle,
  and the cylinder-width of <math|Q> is at least <math|8*q> (see
  <cite|MT01>). <math|Q> can be easily found because <math|R> has at most
  <math|N=N<around|(|g,l|)>> vertices by Theorem <reference|mini>. This
  completes the proof of Lemma <reference|lem:kk1>.<qed>

  <subsection|Alternative formulation>

  Suppose <math|<around|(|H,T<rprime|'>,s|)>> is obtained from
  <math|<around|(|G,T,s|)>> as follows. First we pick a connected subgraph
  <math|I> of <math|G> with a vertex set <math|U>....

  The edges of <math|H> should correspond to unique edges from <math|G>, but
  vertices from <math|G> may have been identified in <math|H>. This may
  create loops in <math|H> and the identification may include identification
  of some terminals.

  Note that it doesn't matter if we have terminals not in a graph. These will
  just have to be separate in any feasible partition.

  We say that <math|<around|(|H,T<rprime|'>,s|)>> preserves powercuts from
  <math|<around|(|G,T,s|)>> if any optimal powercut <math|<C><rsub|H>> from
  <math|<around|(|H,T<rprime|'>,s|)>> can be extended to an powercut
  <math|<C><rsub|G>> from <math|<around|(|G,T,s|)>>. This means that for each
  <math|C> in <math|<C><rsub|G>>, if <math|C> contains edges from <math|H>,
  then there is a cut in <math|<C><rsub|H>> containing exactly these edges.

  <\lemma>
    <label|lem:preservation>If <math|<around|(|H,T<rprime|'>,s|)>> preserves
    powercuts from <math|<around|(|G,T,s|)>> and <math|<C><rsub|H>> is an
    optimal powercut then, preserving powercuts, we can identify any vertices
    in <math|G> that are connected in <math|H\<setminus\>E<around|(|<C><rsub|H>|)>>.
  </lemma>

  A trivial case is <math|<around|(|H,T<rsub|H>,s|)>>.

  We now focus on the planar case. We begin with the following easy lemma.
  Recall the definitions of <math|P<around|[|x,y|]>>, i.e, a center distance
  <math|d<rsub|P>> between <math|x> and <math|y> (so we fix a center).

  <\lemma>
    <label|lem:layer-contract>Suppose <math|G> is a plane graph. The graph
    <math|P<around|[|x,y|]>> has at most <math|y-x+1> edge layers.
  </lemma>

  <\proof>
    \ In the embedding, instead of contracting a loop edge, we simply delete
    it. All edges from <math|P*<around|[|1,x-1|]>> are contracted to a new
    center, and we claim that all surviving edges have distance at most
    <math|y-x+1> to this center.

    To see this, take an edge <math|e<rsub|z>> with some original center
    distance <math|z\<in\><around|[|x,y|]>>. Here edge <math|e<rsub|d>> is at
    center distance <math|d>. There is a witnessing curve <math|\<phi\>> that
    starts in <math|e<rsub|z>>, cross edges <math|e<rsub|z-1>,...,e<rsub|1>>
    and ends in the center <math|v<rsub|0>>. The curve <math|\<phi\>> touches
    no other edges or vertices. Before contracting
    <math|P*<around|[|1,x-1|]>>, we stop the curve when it hits
    <math|e<rsub|x-1>>. This point gets contracted to the new center. None of
    the edges <math|e<rsub|z-1>,...,e<rsub|x>> get contracted, so the curve
    is still only crossing these in the interior, and deleting loops can only
    decrease the number of edges crossed. Hence the resulting curve crosses
    at most <math|z-1-<around|(|x-1|)>=z-x> edges on its way to the center,
    witnessing that <math|e<rsub|z>> has center distance <math|z-x+1> in the
    resulting graph.
  </proof>

  Let us recall that an <em|<math|r>-wall> or a <em|wall of height <math|r>>
  is a graph which is isomorphic to a subdivision of the following graph
  <math|W<rsub|r>>. We start with vertex set
  <math|V=<around|{|<around|(|i,j|)>\<mid\>1\<le\>i\<le\>r,1\<le\>j\<le\>r|}>>
  and make two vertices <math|<around|(|i,j|)>> and
  <math|<around|(|i<rprime|'>,j<rprime|'>|)>> adjacent if one of the
  following possibilities holds: <math|<around|(|1|)>> <math|i<rprime|'>=i>
  and <math|j<rprime|'>\<in\><around|{|j-1,j+1|}>> or <math|<around|(|2|)>>
  <math|j<rprime|'>=j> and <math|i<rprime|'>=i+(-1)<rsup|i+j>>. Some vertices
  of the so obtained graph may be of degree 1. We remove them to obtain a
  2-connected graph <math|W<rsub|r>>.

  It follows from Lemma <reference|lem:layer-contract> that the graph
  <math|P<around|[|x,y|]>> cannot have a wall of height
  <math|<around|(|y-x+1|)>>. Thus it follows from <cite|RST94> (which says
  that if a planar graph <math|G> has no wall of height <math|r>, then the
  tree-width of <math|G> is at most <math|6*r-6>) that the following holds.

  <\lemma>
    <label|lem:layer-tree>Suppose <math|G> is a plane graph. The graph
    <math|P<around|[|x,y|]>> has tree-width at most
    <math|6*<around|(|y-x|)>>.
  </lemma>
</body>