<TeXmacs|1.99.7>

<style|<tuple|ieeetran|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|remark|Remark>

    <new-theorem|lemma|Lemma>

    <new-theorem|proposition|Proposition>

    <new-theorem|corollary|Corollary>
  </hide-preamble>

  <doc-data|<doc-title|Mobility Control for Machine-to-Machine LTE
  Systems>|<doc-author|<author-data|<author-name|Beom Hee Lee, Seong-Lyun
  Kim>|<author-data>|<author-affiliation|School of Electrical and Electronic
  Engineering Yonsei University<next-line>134 Sinchon-Dong, Seodaemun-Gu,
  Seoul 120-749, Korea<next-line>Email: bhlee@ramo.yonsei.ac.kr,
  slkim@yonsei.ac.kr>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    In this paper, we propose an efficient mobility control algorithm for the
    downlink multi-cell orthogonal frequency division multiplexing access
    (OFDMA) system for co-channel interference reduction. It divides each
    cell into several areas. The mobile nodes in each area find their own
    optimal position according to their present location. Both the signal to
    interference plus noise ratio (SINR) and the capacity for each node are
    increased by the proposed mobility control algorithm. Simulation results
    say that, even the frequency reuse factor (FRF) is equal to 1, the
    average capacity is improved after applying the mobility control
    algorithm, compared to existing partial frequency reuse (PFR) scheme.
  </abstract>>

  <IEEEpeerreviewmaketitle>

  <section|Introduction>

  As the growing demand for wireless communication service, the cellular
  network system develops rapidly. To satisfy these demands, the long-term
  evolution (LTE) is introduced by 3rd Generation Partnership Project (3GPP)
  as the state-of-the-art technology. The object of the evolution is to
  obtain high date rates with low latency for human-to-human (H2H)
  communication. LTE Release 8 provides high peak data rates of 300 Mbps on
  the downlink and 75 Mbps on the uplink for a 20 MHz bandwidth <cite|Ghosh>.

  Recently, not only the H2H communication but also machine-to-machine (M2M)
  communication is studied by standards bodies like ETSI <cite|ETSI> and 3GPP
  <cite|3GPP_b|3GPP_c>. The M2M communication is defined as a form of data
  communication between entities that do not necessarily need human
  interaction <cite|3GPP>. M2M communication can be used for smart metering,
  e-Health, city automation and automotive applications. For those use cases,
  the M2M devices are considered as mainly stationary machines or sensors
  installed in a fixed location.

  However, some parts of the automotive application including unmanned V2V
  (vehicle to vehicle) and robotic networks will belong to the class of M2M
  with controllable mobility <cite|robot>, <cite|robo>. In this case, the M2M
  devices have mobility characteristics and we can control these mobility
  features (position or speed of each node) according to their application
  purpose. Even though M2M with controllable mobility is receiving less
  attention, controllable mobility itself is an interesting research
  dimension in wireless communications. In this paper, we evaluate the effect
  from controllable mobility nodes in cellular LTE networks with frequency
  reuse factor (FRF) 1 and partial frequency reuse (PFR) scheme
  <cite|Najjar>.

  OFDMA is the key technology for the future cellular wireless network. WiMAX
  uses OFDMA for IEEE 802.16 <cite|IEEE> while 3GPP LTE uses OFDMA on the
  downlink and Single-Carrier Frequency Division Multiple Access (SC-FDMA) on
  the uplink <cite|Ghosh>. In OFDMA, the whole spectrum is divided into a
  number of orthogonal sub-carriers to obtain high spectrum efficiency. Since
  the sub-carriers within a cell are orthogonal to each other, Inter-Cell
  Interference (ICI) mitigation becomes one of the most major concerns in LTE
  downlink. To avoid interference at cell edge, various fractional frequency
  reuse (FFR) schemes has been proposed <cite|Rahman>. Also, the two
  variations of the FFR scheme, PFR and soft frequency reuse (SFR) schemes
  are proposed <cite|Najjar>, <cite|Lei>, <cite|Huawei>. These schemes use a
  mix of FRF 1 and 3 to reduce the interference at cell edge region.

  In this paper, we are interested in each node's controllable mobility to
  gain high spectral efficiency. Each node's proper movement guarantees
  higher SINR that naturally leads higher capacity. In this case, to define
  \Pproper movement," we consider mainly two factors; SINR gain and lifetime
  of the nodes. To achieve higher SINR, each node tries to reduce the path
  loss from its own serving base station, while increasing the path loss
  between other cells. This means that, moving far away from other cells, the
  mobile node could move closer to its serving base station to increase SINR.
  The mobile node communicates and moves to other position by using its
  battery power which limits the lifetime. Considering these two factors -
  SINR gain and lifetime, we proposed a mobility control (MC) algorithm that
  allows nodes in the cell edge to achieve higher capacity.

  The performance of the proposed MC algorithm is evaluated using system
  level simulation. The simulations focus on network-related issues like
  interference management and spectral efficiency. The SINR and the capacity
  for the cell edge node are investigated to see how proposed MC behaves in
  comparison with the existing PFR scheme.

  The rest of this paper is organized as follows: In Section II, system model
  is defined and described. Our mobility control algorithm is proposed in
  Section III. Section IV describes the simulation scenarios and settings.
  According to the simulation results, the capacity at the cell edge region
  is six times higher than the conventional scheme with FRF 1 and 1.5 times
  higher than PFR. Section V summarizes the key findings of this paper and
  discuss the effects of controllable mobility on M2M communications.

  <section|System Model>

  We investigate how our mobility control scheme enhances the performance the
  OFDMA cellular system adopting PFR <cite|Najjar>. We use a similar system
  model described in [8], as a general hexagonal cell structure with FRF 1.

  <subsection|37 Multi-cell structure>

  Consider the downlink of an OFDMA macro-cellular system with 37-cells (Fig.
  <reference|F:cell>). In this system, to deploy PFR, each cell is divided
  into two parts; inner cell with FRF 1 and outer cell with FRF 3. In Fig.
  <reference|F:cell>, the inner cell is illustrated as a white center cell in
  every single cell. The subcarriers allocated to the inner cells (mobile
  nodes) are reused in all 37 cells. However, the outer cell subcarriers are
  divided into three parts, which makes FRF 3. Then the total available
  subcarriers are classified into two groups corresponding to the area of
  inner cells and outer cells. We assume that nodes are distributed uniformly
  in each cell.

  <subsection|The signal to interference plus noise ratio (SINR)>

  We consider the distance-dependent path loss and shadow fading to determine
  the channel gain between a mobile node and a specific cell. The path loss
  model between node <math|k> and serving cell <math|m> can be formulated as,

  <\equation>
    P*L<around|(|R|)>=128.1+10*\<alpha\>*log<rsub|10><around|(|R|)>+\<theta\><rsub|\<sigma\>>*<space|1em><around|(|d*B|)><label|eq:eqs1>
  </equation>

  <no-indent>where <math|R> is the distance between node <math|k> and serving
  cell <math|m> in kilometer and the decay factor <math|\<alpha\>> is 3.76
  <cite|Sawahashi>. Also, <math|\<theta\><rsub|\<sigma\>>> is the lognormal
  shadowing effect which has a shadowing standard deviation <math|\<sigma\>>.
  Considering distance-dependant pass loss, the channel gain between node
  <math|k> and cell <math|m> on subcarrier <math|i> is described as follows:

  <\equation>
    G<rsub|k,m,i>=10<rsup|P*L<around|(|R|)>/10><label|eq:eqs2>
  </equation>

  The number of OFDM subcarriers allocated each node varies from less than
  one hundred to several thousands. In this subcarrier allocation, the
  orthogonality between nodes within a single cell is guaranteed. Hence, at
  least in principle, within one cell there is no intra-cell interference
  <cite|Parkvall>. The inter-cell interference is a considerable factor that
  influences the performance in terms of spectral efficiency. In this system,
  we indexed 37 cells and define the set <math|S<rsub|m>> which contains
  interference cells for cell <math|m>.

  <big-figure|<with|par-mode|center|<image|cell_structure.eps|0.45tex-text-width|||><label|F:cell>>|37-cell-structure
  and frequency allocation>

  <\equation*>
    S<rsub|m>=<around|{|<nbsp>j<nbsp>\|<nbsp>j<nbsp><with|font-family|rm|i*n*t*e*r*f*e*r*e*n*c*e*c*e*l*l*s*f*o*r*c*e*l*lm>|}>
  </equation*>

  Without loss of generality, the SINR for the mobile node <math|k> on
  subcarrier <math|i> can be written as,

  <\equation>
    S*I*N*R<rsub|k,i>=<frac|G<rsub|k,m,i>*P<rsub|k,m,i>|N<rsub|0>*f<rsub|s>+<big|sum><rsub|l\<in\>S<rsub|m>><rsup|\<nosymbol\>>G<rsub|k,l,i>*P<rsub|k,l,i>><label|eq:eqs3>
  </equation>

  <no-indent>where <math|P<rsub|k,m,i>> and <math|G<rsub|k,m,i>> are
  respectively, the transmit power and the channel gain for node <math|k> on
  subcarrier <math|i> assigned to its serving cell. <math|P<rsub|k,l,i>> and
  <math|G<rsub|k,l,i>> are respectively, the transmit power and channel gain
  between the <math|l<rsup|t*h>> co-channel cell and node <math|k> on
  subcarrier <math|i>. <math|N<rsub|0>> is the power spectrum density of
  AWGN. <math|f<rsub|s>> is the subcarrier spacing, with
  <math|f<rsub|s>=1/T<rsub|s>>, where <math|T<rsub|s>> is the OFDM symbol
  period.

  The nodes within the inner cell suffer from inter-cell interference from
  all other cells. For instance, node k within cell 1 receives interference
  from 36 other cells. On the other hands, the nodes in the outer region of
  cell 1 receives interference from only 12 cells.

  <subsection|Subcarrier allocation>

  Within a cell, we assume that all available subcarriers are allocated to
  mobile nodes fairly and dynamically. First of all, every node in the same
  cell obtains the same number of subcarriers. In this circumstance, since
  the number of subcarriers allocated to a node is dynamically changed
  according to the number of nodes in a cell, increasing the number of mobile
  nodes causes decreasing the capacity for a single node.

  In case of PFR, the whole available subcarriers are dividend into two parts
  - one for inner cell nodes and the other for outer cell nodes. The
  subcarriers for outer cell nodes are separated into <math|N> parts, where
  <math|N> is the frequency reuse factor for the cell outer region. We assume
  that the mobile nodes are distributed uniformly. Thus, the number of
  subcarriers allocated to the inner cell and the outer cell is depending on
  how wide the area is. We represent <math|R> as the cell radius and
  <math|\<alpha\>*R> as the inner cell radius, where
  <math|\<alpha\>\<in\><around|(|0,1|)>>. Since the size of the inner cell
  and the outer cell are proportional <math|\<alpha\><rsup|2>*R<rsup|2>*\<pi\>>
  and <math|<around|(|1-\<alpha\><rsup|2>|)>*R<rsup|2>*\<pi\>> respectively,
  the total subcarriers <math|M> is divided into <math|\<alpha\><rsup|2>*M>
  for the inner cell and <math|<around|(|1-\<alpha\><rsup|2>|)>*M> for the
  outer cell.

  <subsection|Reference model (PFR)>

  In [8], the optimal <math|\<alpha\>> say <math|\<alpha\><rsub|o*p*t>>, is
  determined by the average to variance ratio of the received SINR at nodes.
  That is, <math|\<alpha\><rsub|o*p*t>> is obtained by solving a simple
  optimization problem given by,

  <\equation>
    \<alpha\><rsub|o*p*t>=arg max<rsub|\<alpha\>>
    <frac|<wide|\<gamma\>|\<bar\>><around|(|\<alpha\>|)>|\<sigma\><rsup|2><rsub|\<gamma\>><around|(|\<alpha\>|)>><label|eq:eqs4>
  </equation>

  <no-indent>where <math|<wide|\<gamma\>|\<bar\>><around|(|\<alpha\>|)>> and
  <math|\<sigma\><rsup|2><rsub|\<gamma\>><around|(|\<alpha\>|)>> are the
  average and the variance of the instantaneous received SINR by nodes for a
  given <math|\<alpha\>>. In <cite|Najjar>, since the capacity analysis is
  skipped, we evaluate the capacity for each node at cell edge, in order to
  compare the performance on PFR and our MC scheme.

  <subsection|Capacity>

  The capacity for node <math|k> on subcarrier <math|i> can be expressed as
  <cite|Shen>,

  <\equation>
    C<rsub|k,i>=f<rsub|s>*l*o*g<rsub|2>*<around|(|1+\<beta\>*S*I*N*R<rsub|k,i>|)><label|eq:eqs5>
  </equation>

  <no-indent>where, <math|\<beta\>> is the constant value with
  <math|\<beta\>=-1.5/ln <around|(|5*B*E*R|)>> and BER is set to
  <math|10<rsup|-6>> <cite|Lei>. The capacity for node <math|k>,
  <math|C<rsub|k>>, is obtained from summing the capacity for all subcarriers
  allocated to the node, which is written by,

  <\equation>
    C<rsub|k>=<big|sum><rsub|i>f<rsub|s>*l*o*g<rsub|2>*<around|(|1+\<beta\>*S*I*N*R<rsub|k,i>|)><label|eq:eqs6>
  </equation>

  <no-indent>where, <math|i> denotes <math|i<rsup|t*h>> subcarrier allocated
  to node <math|k>.

  <section|Proposed Mobility Control Algorithm >

  In our mobility control scheme, we assume that every node can estimate the
  distance to its serving BS and uses its residual energy for relocation of
  the position. Each node can also estimate its SINR gain and battery loss
  when location is changed. Considering the trade-off between SINR gain and
  battery loss, nodes choose their optimized moving distance. The cell edge
  nodes tend to move over longer distance to achieve high SINR, even if this
  will loose their battery power considerably.

  <subsubsection|Lifetime Factor Function>

  To consider each node's lifetime, we define the <em|lifetime factor> that
  has normalized values varying between <math|0> and <math|1>. At the initial
  state, every node's lifetime factor is set to <math|1>, and it becomes
  <math|0> when the battery runs down. Other than <math|0> and <math|1>, the
  lifetime factor does necessarily not indicates the exact remaining battery
  power. Let us now introduce a lifetime factor function that relate lifetime
  factor values to the node's location in the cell. Fig. 2 shows that
  <math|k<rsup|t*h>> node's lifetime factor <math|L<rsub|k><around|(|x|)>> as
  a function of the moving distance <math|x> to its serving BS. The shape of
  the function <math|L<rsub|k><around|(|x|)>> differs, depending on the
  initial position of the node. For example, in Fig. 2, one cell is divided
  into four areas and nodes within each area have different lifetime factor
  functions. For the cell edge node, the lifetime factor decreases slowly at
  first, compared to the cell center node. Even if the nodes within area
  <math|1> and area <math|4> move the same distance and use exactly the same
  battery power, the nodes in area <math|4> are aware that their remaining
  lifetime is longer than the nodes within area <math|1>. Cell edge nodes
  endure their battery loss more than cell center nodes. However, if a node
  travels the maximum moving distance <math|x<rsub|m*a*x>>, the lifetime
  factor goes to <math|0>.

  <big-figure|<with|par-mode|center|<subfigure|<image|LT_b.eps|0.2tex-text-width|||><label|fig:sub1>
  > <subfigure|<image|LT_a.eps|0.5tex-text-width|||><label|fig:sub2>
  ><label|F:lifetime> >|Cell division and lifetime factor function
  (<math|x<rsub|m*a*x>> is set to 400 meters).>

  <subsubsection|Utility Function>

  Every node calculates its utility from two factors: SINR gain and lifetime
  factor value. The value of the utility function (for node k) is expressed
  as,

  <\equation>
    U<rsub|k><around|(|x|)>=r<rsub|k><around|(|x|)>*L<rsub|k><around|(|x|)>*N<rsub|k><around|(|x|)>*<space|1em><space|1em>0\<leq\>x\<leq\>x<rsub|m*a*x><label|eq:eqs7>
  </equation>

  <no-indent>where <math|x> is the moving distance for node <math|k> and
  <math|r<rsub|k><around|(|x|)>>, <math|L<rsub|k><around|(|x|)>> denote SINR
  gain and lifetime factor, respectively. The value of <math|r<around|(|x|)>>
  can be obtained from <eqref|eq:eqs3>. When the node moves over the distance
  <math|x>, the distance between the node and BSs in 37 cells are varied
  accordingly. For nodes within cell 1 in Fig. <reference|F:cell>, in terms
  of SINR gain, the simplest and most effective way is to move toward the
  serving BS. <math|N<rsub|k><around|(|x|)>> represents the number of
  subcarriers allocated to node <math|k>. <math|N<rsub|k><around|(|x|)>>
  could be <math|\<alpha\><rsub|o*p*t><rsup|2>*M> and
  <math|<around|(|1-\<alpha\><rsub|o*p*t><rsup|2>|)>*M> according to the
  position of node, where M is the number of available subcarriers. The
  optimal moving distance <math|x<rsub|o*p*t>> for node <math|k> is obtained
  from the optimization problem described as follows:

  <\equation>
    x<rsub|o*p*t>=arg max<rsub|x> U<rsub|k><around|(|x|)><label|eq:eqs9>
  </equation>

  Each node decides its optimal moving distance to maximize the value of the
  utility function, which maximizes three factors: SINR level, lifetime
  factor function and the number of allocated subcarriers.

  <section|Simulation Results>

  In this section, we present simulation results to evaluate the performance
  of the proposed MC scheme. As a comparison, we use PFR in a multi-cell
  OFDMA system (Fig. <reference|F:cell>). The simulation parameters are
  chosen form <cite|Lei>, <cite|LTESPEC>. We assume that all the available
  subcarriers are transmitted with the same fixed power. The detailed
  simulation parameters are listed in TABLE <reference|T:simul para>.

  Fig. 3 shows that the positions of nodes in cell 1. In this figure, the
  positions of nodes are classified into three cases: the initial position
  and changed position after applying MC under FRF 1 and PFR respectively.
  Since under the conventional scheme (FRF 1) the SINR is lower than PFR,
  Mobile nodes move longer distance under FRF 1 than PFR to achieve high
  capacity.

  <big-table|<tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<table|<row|<cell|Parameter>|<cell|Values>>|<row|<cell|Cellular
  layout>|<cell|Hexagonal grid, 37 cell sites>>|<row|<cell|Cell radius
  (R)>|<cell|1000 m>>|<row|<cell|Distance dependent path loss>|<cell|128.1 +
  37.6 log<rsub|<math|10>> (R) dB>>|<row|<cell|Shadowing standard
  deviation>|<cell|8 dB>>|<row|<cell|Channel bandwidth>|<cell|5
  MHz>>|<row|<cell|Number of subcarriers>|<cell|300>>|<row|<cell|Subcarrier
  spacing>|<cell|15 kHz>>|<row|<cell|BS transmit power>|<cell|43
  dBm>>|<row|<cell|Noise density>|<cell|-174 dBm/Hz>>|<row|<cell|Max moving
  distance (<math|x<rsub|m*a*x>>)>|<cell|400 m>>>>><label|T:simul
  para>|Simulation parameters>

  Fig. <reference|F:SINR> shows the downlink SINR level at each location in
  cell 1. At the cell edge, the interference from other cells is
  significantly increased. In our simulation, using the criterion (6), we
  obtain the optimal value of <math|\<alpha\>>,
  <math|\<alpha\><rsub|o*p*t>=0.467>, which determines the radius of inner
  cell <math|\<alpha\>*R> as 467 (m). The SINR level of MC is in some part
  overlaped the performance of the conventional scheme (FRF = 1). This is
  because the frequency reuse factor of both schemes is equal to 1. However,
  since every node moves to the BS according to the equation <eqref|eq:eqs9>
  The SINR low bound of MC is higher than FRF 1. Due to the mobile movement
  to the BS, the SINR level and nodes do not exist in the interval from 667
  (m) to 1000 (m).

  <big-figure|<with|par-mode|center|<subfigure|<image|node_b.eps|0.45tex-text-width|||><label|F:sub1>
  > <subfigure|<image|txt.eps|0.19tex-text-width|||><label|F:sub3>
  ><label|F:node> >|position of 30 nodes in cell 1>

  <big-figure|<with|par-mode|center|<image|SINR.eps|0.5tex-text-width|||><label|F:SINR>>|Received
  SINR as a function of the distance>

  Fig. <reference|F:capacity> depicts the average capacity at the cell edge
  region versus the total number of mobile nodes located in cell 1. We define
  the cell edge region as an area where the SINR level is lower than 0 (dB).
  In Fig. <reference|F:SINR>, we can see that SINR is almost 0 (dB) at 800
  (m). At the cell edge region, the average capacity of PFR is higher than
  conventional scheme (FRF 1). However, the capacity improvement from PFR is
  limited, due to the fewer number of allocated subcarriers at cell edge. In
  Fig. <reference|F:capacity>, we notice that the average capacity of the
  nodes is increased after applying MC algorithm. The average capacity at the
  cell edge region is increased more than 6 times than FRF 1, and more than
  1.5 times than PFR.

  <big-figure|<with|par-mode|center|<image|capacity.eps|0.5tex-text-width|||><label|F:capacity>>|Average
  capacity at cell edge region as a function of the number of nodes>

  <big-figure|<with|par-mode|center|<image|LT_ratio.eps|0.5tex-text-width|||><label|F:LT>>|Ratio
  of moving distance to the maximum moving distance at each area>

  Fig. <reference|F:LT> shows that the average ratio of the moving distance
  of mobile nodes to the maximum allowable moving distance
  <math|x<rsub|m*a*x>=400>. Since we assume that the power of battery
  decreases linearly according to the moving distance, normalized moving
  distance implies energy consumption for each node. We also assumed that, in
  case of MC with FRF 1, cell 1 is divided into 4 areas and the lifetime
  factor function for each area is defined as shown in Fig. 2. For MC with
  PFR, the cell is divided into 2 areas; the inner cell and the outer cell.
  In this case, the lifetime factor functions for the inner cell and the
  outer cell are equivalent to those of area 2 and area 4 in Fig. 2. The
  optimal moving distance for each node within area 4 is much higher than the
  nodes within area 1. For the nodes in area 4, they use almost 80% of their
  battery power to get higher SINR, while the nodes in area 1 use only 30%
  (in case of MC with FRF 1). Fig. <reference|F:LT> also shows that nodes
  move longer distance under FRF 1 than PFR. Under FRF 1, since SINR level is
  lower than PFR, nodes consume more energy to achieve higher capacity.
  Especially, at area 4, there is a wide SINR gap between FRF 1 and PFR,
  nodes under FRF 1 use more energy and move longer distance than PFR. Thus,
  in terms of energy efficiency, nodes consume less energy when MC scheme is
  deployed under PFR. In Fig. <reference|F:LT>, we notice that the total
  number of nodes (14 and 42 nodes) has less relevance to the moving
  distance. Moving distances for nodes in a same area are similar each other
  regardless of the number of nodes in a cell.

  <section|Conclusion>

  Recently, M2M communication using cellular LTE network is studied actively
  <cite|3GPP_b>. If we can control the mobility for those M2M devices
  efficiently, the performance at the cell edge will be enhanced even under
  the worst frequency reuse planning (FRF is equal to 1). We analyzed how
  this controllable mobility affects the performance in a LTE cellular system
  and how much energy is consumed for the performance enhancement. In this
  paper, we proposed an efficient MC algorithm for multi-cell OFDMA systems.
  The simulation results showed the MC scheme brings higher channel capacity
  at the cell edge region, while minimizing the battery usage for each node.
  Numerical results showed that the proposed scheme provides better
  performance than the classical conventional scheme (FRF 1) and PFR proposed
  in <cite|Najjar>.

  <section*|Acknowledgment>

  The author's supported by Samsung Electronics Co., Ltd., Suwon 443-742,
  Korea.

  <\thebibliography|1>
    <bibitem|Ghosh>A.<nbsp>Ghosh, R.<nbsp>Ratasuk, B.<nbsp>Mondal,
    N.<nbsp>Mangalvedhe and T.<nbsp>Thomas, \PLTE-advanced: Next-generation
    wireless broadband technology," <em|IEEE Wireless Commun. Mag.>,
    vol.<nbsp>17, no.<nbsp>3, pp.<nbsp>10\U22, June<nbsp>2010.

    <bibitem|ETSI>ETSI TR 102 691 V1.1.1, \PMachine-to-Machine communications
    (M2M); Smart metering use cases," May<nbsp>2010.

    <bibitem|3GPP_b>3GPP TR 23.888, V1.0.0, \PSystem improvements for
    Machine-Type Communications (MTC)," Sept.<nbsp>2010.

    <bibitem|3GPP_c>3GPP TS 23.368, V10.2.0, \PService requirements for
    Machine-Type Communications (MTC)," July<nbsp>2010.

    <bibitem|3GPP>3GPP TR 22.868, V8.0.0, \PStudy on facilitating
    Machine-to-Machine communication in 3GPP systems (Release 8),"
    March<nbsp>2007.

    <bibitem|robot>S.<nbsp>-L.<nbsp>Kim, W.<nbsp>Burgard and D.<nbsp>Kim,
    \PWireless communications in networked robotics," <em|IEEE Wireless
    Commun.>, vol.<nbsp>16, no.<nbsp>1, pp.<nbsp>4\U5, Feb.<nbsp>2009.

    <bibitem|robo>J.<nbsp>H.<nbsp>Jung, S.<nbsp>Park and
    S.<nbsp>-L.<nbsp>kim, \PMulti-robot Path-finding with Wireless Multihop
    Communications," <em|IEEE Commun. Mag.>, vol.<nbsp>48, no.<nbsp>7,
    pp.<nbsp>126\U132, July<nbsp>2010.

    <bibitem|Najjar>A.<nbsp>Najjar, N.<nbsp>Hamdi and A.<nbsp>Bouallegue,
    \PEfficient frequency reuse scheme for multi-cell OFDMA system," in
    <em|Proc.<nbsp>ISCC 2009>, pp.<nbsp>261\U265, July<nbsp>2009.

    <bibitem|IEEE>IEEE, \PIEEE standard for local and metropolitan area
    networks part 16: air interface for fixed and mobile broadband wireless
    access systems amendment 2," Feb.<nbsp>2006.

    <bibitem|Rahman>M.<nbsp>Rahman, H.<nbsp>Yanikomeroglu, \PEnhancing
    cell-edge performance: A downlink dynamic interference avoidance scheme
    with inter-cell coordination," <em|IEEE Trans. on Wireless Commun.>,
    vol.<nbsp>9, no.<nbsp>4, pp.<nbsp>1414\U1425, April<nbsp>2010.

    <bibitem|Lei>H.<nbsp>Lei, L.<nbsp>Zhang, X.<nbsp>Zhang and D.<nbsp>Yang,
    \PA novel multi-cell OFDMA system structure using fractional frequency
    reuse," in <em|Proc.<nbsp>PIMRC 2007>, pp.<nbsp>1\U5, Sept.<nbsp>2007.

    <bibitem|Huawei>R1-050507, \PSoft frequency reuse scheme for UTRAN LTE,"
    Huawei, 3GPP TSG RAN WG1 Meeting #41, Athens, Greece, May<nbsp>2005.

    <bibitem|Sawahashi>M.<nbsp>Sawahashi, Y.<nbsp>Kishiyama,
    A.<nbsp>Morimoto, D.<nbsp>Nishikawa and M.<nbsp>Tanno, \PCoordinated
    multipoint transmission/reception techniques for LTE-advanced," <em|IEEE
    Commun. Mag.>, vol.<nbsp>17, no.<nbsp>3, pp.<nbsp>26\U34, June<nbsp>2010.

    <bibitem|Parkvall>S.<nbsp>Parkvall and D.<nbsp>Astely, \PThe evolution of
    LTE towards IMT-Advanced," <em|Journal of Commun.>, vol.<nbsp>4,
    no.<nbsp>3, pp.<nbsp>146\U154, April<nbsp>2009.

    <bibitem|Shen>Z.<nbsp>Shen, J.<nbsp>G.<nbsp>Andrews and
    B.<nbsp>L.<nbsp>Evans, \PAdaptive resource allocation in multiuser OFDM
    systems with proportional rate constraints," <em|IEEE Trans. on Wireless
    Commun.>, vol.<nbsp>4, no.<nbsp>6, pp.<nbsp>2726\U2737, Nov.<nbsp>2005.

    <bibitem|LTESPEC>3GPP TR 36.814, V9.0.0, \PFurther Advancements for
    E-UTRA Physical Layer Aspects," March<nbsp>2010.
  </thebibliography>
</body>