<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <doc-data|<doc-title|Numerical Evaluation of Algorithmic Complexity for
  Short Strings<next-line><with|font-size|1.41|A Glance into the Innermost
  Structure of Randomness>>|<doc-author|<author-data|<author-name|Jean-Paul
  Delahaye<footnote|delahaye@lifl.fr> <with|font-size|1.19|and Hector
  Zenil<footnote|hector.zenil-chavez@malix.univ-paris1.fr><next-line>Laboratoire
  d'Informatique Fondamentale de Lille (CNRS)<next-line>Universit de Lille
  1>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    We describe a method that combines several theoretical and experimental
    results to numerically approximate the algorithmic (Kolmogorov-Chaitin)
    complexity of all <math|<big|sum><rsub|n=1><rsup|8>2<rsup|n>> bit strings
    up to 8 bits, and some bit strings between 9 and 16 bits. This is done by
    an exhaustive execution of all deterministic 2-symbol Turing machines
    with up to 4 states for which the halting times are known thanks to the
    busy beaver problem, that is 11<space|0.17em>019<space|0.17em>960<space|0.17em>576
    machines. An output frequency distribution is then computed, from which
    the algorithmic probability is calculated and the algorithmic complexity
    evaluated by way of the (Levin-Chaitin) coding theorem.<next-line>

    <no-indent><with|font-series|bold|Keywords>: algorithmic probability,
    program-size complexity, Chaitin's halting probability Omega, Levin's
    Universal Distribution, coding theorem, Busy Beaver problem,
    Kolmogorov-Chaitin complexity.
  </abstract>>

  <assign|myenumerate|<macro|body|<\surround|<new-line>|<setlength>>
    <arg|body>
  </surround>>><parskip>0pt }}

  <assign|myitemize|<macro|body|<\surround|<new-line>|<setlength>>
    <arg|body>
  </surround>>><parskip>0pt }}

  <assign|page-nr|1>

  <section|Overview><label|overview>

  The algorithmic complexity of a bit string is defined as the length of the
  shortest binary computer program that prints out the string (hence also
  called <em|program-size> complexity). However, no general, finite and
  deterministic procedure exists to calculate algorithmic complexity. For a
  given string there are infinite many programs producing it. The most common
  approach to calculate the algorithmic complexity of a string is the use of
  compression algorithms exploiting the regularities of the string and
  producing shorter compressed versions. Compression algorithms have been
  used over the years, with the Lempel-Ziv algorithm<cite|lempel> being one
  of the most prominent examples. The result of a compressed version of a
  string is an upper bound of the algorithmic complexity (denoted by
  <math|C<around|(|s|)>>) of the string s.

  In practice, it is a known problem that one cannot compress short strings,
  shorter, for example, than the length in bits of the compression program
  which is added to the compressed version of s, making the result (the
  program producing s) sensitive to the compressor choice and the parameters
  involved. However, short strings are quite often the kind of data
  encountered in many practical settings. While compressors' asymptotic
  behavior guarantees the eventual convergence to <math|C<around|(|s|)>>
  thanks to the invariance theorem (to be enunciated later), measurements
  differ considerably in the domain of short strings. A few attempts to deal
  with this problem have been reported before<cite|speidel>. The conclusion
  is that estimators are always challenged by short strings.

  Attempts to compute the uncomputable are always challenging, see for
  example <cite|rado|brady|marxen> and more recently <cite|caludeomega> and
  <cite|hertel>. This often requires combining theoretical and experimental
  results. In this paper we describe a method to compute the algorithmic
  complexity (hereafter denoted by <math|C<around|(|s|)>>) of (short) bit
  strings by running a set of (relatively) large number of Turing machines
  for which the halting runtimes are known thanks to the busy beaver
  problem<cite|rado>. The method describes a way to find the shortest program
  given a standard formalism of Turing machines, executing all machines from
  the shortest (in number of states) to a certain (small) size one by one
  recording how many of them produce a string and then using a theoretical
  result linking this string frequency with the algorithmic complexity of a
  string that we use to approximate <math|C<around|(|s|)>>.

  The approach we adopt here is different and independent of the machine size
  (small machines are used only because they allow us to calculate all of
  them up to a small size) and relies only on the concept of algorithmic
  probability. The exhaustive approach is in the lines of Wolfram's
  paradigm<cite|wolfram> consisting of exploring the space of simple programs
  by way of computer experiments. The result is a novel approach that we put
  forward for numerically calculate the complexity of short strings as an
  alternative to the indirect method using compression algorithms. The
  procedure makes use of a combination of results from related areas of
  computation, such as the concept of halting probability<cite|chaitin>, the
  busy beaver problem<cite|rado>, algorithmic probability<cite|solomonoff>,
  Levin's semi-measure and Levin-Chaitin's coding theorem<cite|levin>.

  This approach, never attempted before to the authors' knowledge, consists
  in the thorough execution of all 4-state, 2-symbol Turing machines (the
  exact model is described in <reference|D>) which, upon halting, generate a
  set of output strings from which a frequency distribution is calculated to
  obtain the algorithmic probability of a string to be the result of a
  halting machine. The algorithmic complexity of a string is then evaluated
  from the algorithmic probability using the Levin-Chaitin's coding theorem.

  The paper is structured as follows. In section <reference|preliminaries> it
  is introduced the various theoretical concepts and experimental results
  utilized in the experiment, providing essential definitions and referring
  the reader to the relevant papers and textbooks. Section <reference|D>
  introduces the definition of our empirical probability distribution
  <math|D>. In <reference|method> we present the methodology for calculating
  <math|D>. In <reference|results> we calculate <math|D> and provide
  numerical values of the algorithmic complexity for short strings (the
  probability distribution produced by all 4-state 2-symbol Turing machines)
  by way of the theory presented in <reference|preliminaries>, particularly
  the so-called coding theorem. Finally, in <reference|conclusions> we
  summarize, discuss possible applications, and suggest potential directions
  for further research.

  <section|Preliminaries><label|preliminaries>

  <subsection|The Halting problem and Chaitin's <math|\<Omega\>>>

  The Halting problem for Turing machines is the problem of deciding whether
  an arbitrary Turing machine T eventually halts on an arbitrary input
  <math|s>. One can ask whether there is a Turing machine <math|U> which,
  given <math|c*o*d*e<around|(|T|)>> and the input <math|s>, eventually stops
  and produces <math|1> if <math|T<around|(|s|)>> halts, and <math|0> if
  <math|T<around|(|s|)>> does not halt. Turing's result<cite|turing> proves
  that there is no such <math|U>. A Cantor diagonalization
  argument<cite|turing> shows that the set of all such functions is not
  enumerable, whereas the set of all Turing machines is enumerable.
  Therefore, there are functions that are noncomputable.

  Halting computations can be recognized by simply running them for the time
  they take to halt. The problem is to detect non-halting programs, about
  which one cannot know if the program will run forever or will eventually
  halt.

  An elegant and concise representation of the halting problem is Chaitin's
  irrational number <math|\<Omega\>><cite|chaitin>, defined as the halting
  probability of a universal computer programmed by coin tossing.
  Formally,<next-line>

  <no-indent><with|font-shape|small-caps|Definition 1.>
  <math|0\<less\>\<Omega\>=<big|sum><rsub|<with|font-size|1|ph*a*l*t*s>>2<rsup|-<around|\||p|\|>>\<less\>1><no-indent>with
  <math|<around|\||p|\|>> the size of p in bits.<next-line>

  <math|\<Omega\>> is the halting probability of a universal
  (prefix-free<footnote|A set of programs A is prefix-free if there are no
  two programs <math|p<rsub|1>> and <math|p<rsub|2>> such that
  <math|p<rsub|2>> is a proper extension of <math|p<rsub|1>>. Kraft's
  inequality<cite|calude> guarantees that for any prefix-free set A,
  <math|<big|sum><rsub|x\<in\>A>2<rsup|-<around|\||x|\|>>\<leq\>1>.>) Turing
  machine running a random program<footnote|The differences and
  compatibilities between plain and prefix-free complexity are studied in
  detail in basic texts such as <cite|calude|li>.>. From now on only plain
  complexity will be used in this paper, unless explicitly stated otherwise.

  In contrast with the mathematical constant <math|\<pi\>>, for which, given
  enough time, one can in principle compute any number of digits of its
  binary expansion, for an <math|\<Omega\>> number one cannot compute more
  than a finite number of digits. The numerical value of
  <math|\<Omega\>=\<Omega\><rsub|U>> depends on the choice of universal
  Turing machine <math|U>. There are, for example, <math|\<Omega\>> numbers
  for which no digit can be computed<cite|chaitin>. For a <math|\<Omega\>>
  number it matters only whether a program halts or not; the time at which a
  halting program stops and the output upon halting is irrelevant.

  A program that halts will eventually halt and its contribution to
  <math|\<Omega\>> can be recorded. Knowing the first n bits of
  <math|\<Omega\>> allows to determine whether a program of length
  <math|\<leq\>> n bits halts by simply running all programs in parallel
  until the sum exceeds <math|\<Omega\><rsub|n>>. All programs with length
  <math|\<leq\>> n not halting yet will not halt. Using these results, Calude
  and Stay<cite|calude2> have shown that most programs either stop
  \Pquickly\Q or never halt because the halting runtime (and therefore the
  length of the output upon halting) is ultimately bounded by its
  program-size complexity. The results herein connect theory with experiments
  by providing empirical values of halting times and string length
  frequencies.

  <subsection|Algorithmic (program-size) complexity>

  The algorithmic complexity <math|C<rsub|U><around|(|s|)>> of a string
  <math|s> with respect to a universal Turing machine <math|U>, measured in
  bits, is defined as the length in bits of the shortest Turing machine
  <math|U> that produces the string <math|s> and
  halts<cite|solomonoff|kolmogorov|levin|chaitin>. Formally,<next-line>

  <no-indent><with|font-shape|small-caps|Definition 2.>
  <math|C<rsub|U><around|(|s|)>=min <around|{|<around|\||p|\|>,U<around|(|p|)>=s|}>><no-indent>where
  <math|<around|\||p|\|>> is the length of p measured in bits.<next-line>

  This complexity measure clearly seems to depend on <math|U>, and one may
  ask whether there exists a Turing machine which yields different values of
  <math|C<around|(|s|)>>. The answer is that there is no such Turing machine
  which can be used to decide whether a short description of a string is the
  shortest (for formal proofs see <cite|calude|li>).

  The ability of universal machines to efficiently simulate each other
  implies a corresponding degree of robustness. The invariance
  theorem<cite|solomonoff> states that if <math|C<rsub|U><around|(|s|)>> and
  <math|C<rsub|U<rprime|'>><around|(|s|)>> are the shortest programs
  generating s using the universal Turing machines <math|U> and
  <math|U<rprime|'>> respectively, their difference will be bounded by an
  additive constant independent of <math|s>. Formally:<next-line>

  <no-indent><with|font-shape|small-caps|Theorem
  (invariance<cite|solomonoff>) 1.> <math|<around|\||C<rsub|U><around|(|s|)>-C<rsub|U<rprime|'>><around|(|s|)>|\|>\<leq\>c<rsub|U,U<rprime|'>>><next-line>

  It is easy to see that the underlying concept is that, since both <math|U>
  and <math|U<rprime|'>> are universal Turing machines, one can always write
  a general translator (a compiler) between <math|U> and <math|U<rprime|'>>
  such that one can run either Turing machine and get one or another
  complexity value, simply adding the constant length of the translator to
  the result.

  Algorithmic complexity formalizes the concept of simplicity versus
  complexity. It opposes what is simple to what is complex or random. Chaitin
  proves, for example, that his <math|\<Omega\>> numbers are algorithmically
  random. Unlike a simple string, a random one is hard to describe and only
  long programs, of about the original string length, can produce it.

  A major drawback of <math|C> as a function taking s to the length of the
  shortest program producing s, is its non-computability proven by reduction
  to the halting problem. In other words, there is no program which takes a
  string s as input and produces the integer <math|C<around|(|s|)>> as
  output.

  <subsection|Algorithmic probability>

  Deeply connected to Chaitin's halting probability <math|\<Omega\>>, is
  Solomonoff's concept of algorithmic probability, independently proposed and
  further formalized by Levin's<cite|levin> semi-measure usually denoted by
  <math|m<around|(|s|)>>.

  Unlike Chaitin's <math|\<Omega\>>, it is not only whether a program halts
  or not that matters for the concept of algorithmic probability; the output
  and halting time of a halting Turing machine are also relevant in this
  case.

  Levin's semi-measure <math|m<around|(|s|)>> is the probability of producing
  a string <math|s> with a random program <math|p> when running on a
  universal prefix-free Turing machine <math|U>. Formally,<next-line>

  <no-indent><with|font-shape|small-caps|Definition 3.>
  <math|m<around|(|s|)>=\<Sigma\><rsub|p:U<around|(|p|)>=s>*2<rsup|-<around|\||p|\|>>=p*r*<around|(|U<around|(|p|)>=s|)>><next-line>

  <no-indent>i.e. the sum over all the programs for which the (prefix-free)
  universal Turing machine <math|U> outputs the string <math|s> and halts, or
  the probability that <math|U> with when provided with a sequence of fair
  coin flip inputs as a program <math|p> produces <math|s>. <math|m> is
  related to the algorithmic complexity in that <math|m<around|(|s|)>> is at
  least the maximum term in the summation of programs, which is
  <math|2<rsup|-C<around|(|s|)>>>. So by approximating or calculating
  <math|m<around|(|s|)>>, one can obtain <math|C<around|(|s|)>>.<next-line>

  <no-indent><with|font-shape|small-caps|Definition 4. (coding
  theorem<cite|levin3|chaitin>)> <math|-log
  <with|font-size|1|m<around|(|s|)>=C<around|(|s|)>+O<around|(|1|)>>><next-line>

  The coding theorem states that the shortest description of a given binary
  string is the negative logarithm of its algorithmic probability up to an
  additive constant. Roughly speaking, if there are many long descriptions of
  a certain string, then there is also a short description. Here,
  'description' is understood as defined for algorithmic complexity: a
  program for a universal Turing machine that outputs the string upon
  halting. <math|m<around|(|s|)>> as a function of <math|s> is, like
  <math|C<around|(|s|)>> and Chaitin's <math|\<Omega\>>, noncomputable due to
  the halting problem<footnote|An important property of <math|m> as
  semi-measure is that it dominates any other effective semi-measure
  <math|\<mu\>> because there is a constant <math|c<rsub|\<mu\>>> such that,
  for all s <math|m<around|(|s|)>\<geq\>c<rsub|\<mu\>>*\<mu\><around|(|s|)>>.
  For this reason <math|m<around|(|s|)>> is often called a <em|universal
  distribution><cite|kirchherr>.>.

  Levin's semi-measure formalizes the concept of Occam's razor, that is, the
  principle that favors selecting the competing hypothesis that makes the
  fewest assumptions when the hypotheses are equal in all other respects
  (e.g. size). The program that has the greater chance of being the origin of
  the produced output is likely to be the one actually producing it. Since
  shorter programs are more probable, simpler strings are more likely to be
  printed out than complicated ones.

  <subsection|The busy beaver problem><label|beaver>

  <no-indent><with|font-shape|small-caps|Notation:> We denote by (n,2) the
  class (or space) of all n-state 2-symbol Turing machines (with the halting
  state not included among the n states).<next-line>

  <no-indent><with|font-shape|small-caps|Definition 6.><cite|rado> If
  <math|\<sigma\><rsub|T>> is the number of 1s on the tape of a Turing
  machine <math|T> upon halting, then: <math|<big|sum><around|(|n|)>=max
  {\<sigma\><rsub|T>:T\<in\><around|(|n,2|)><with|font-size|1|T<around|(|n|)>*h*a*l*t*s}>>.<next-line>

  <no-indent><with|font-shape|small-caps|Definition 7.><cite|rado> If
  <math|t<rsub|T>> is the number of steps that a machine <math|T> takes upon
  halting, then <math|S<around|(|n|)>=max
  {t<rsub|T>:T\<in\><around|(|n,2|)><with|font-size|1|T<around|(|n|)>*h*a*l*t*s}>>.<next-line>

  <math|<big|sum><around|(|n|)>> and <math|S<around|(|n|)>> as defined in 7
  and 8 are noncomputable by reduction to the halting problem. Yet values are
  known for (n,2) with <math|n\<leq\>4>. The solution for (n,2) with
  <math|n\<less\>3> is trivial, the process leading to the solution in (3,2)
  is discussed by Lin and Rado<cite|lin>, and the process leading to the
  solution in (4,2) is discussed in <cite|brady>.

  A program showing the evolution of all known busy beaver machines developed
  by one of this paper's authors is available online<cite|busyhz>. The
  formalism followed in this paper is exactly the same as the one originally
  described and followed for the busy beaver problem as introduced by
  Rado<cite|rado> .

  <subsubsection|Solving the halting problem for small machines>

  The halting problem and the halting probability problem are closely related
  to the busy beaver problem in that a solution to any one of them would
  yield a solution to each of the others.

  It is easy to see that <math|<big|sum><around|(|1|)>=1> and
  <math|<big|sum><around|(|2|)>=4>. Lin and Rado<cite|lin> proved
  <math|<big|sum><around|(|3|)>=6>. The exact known values so far are
  <math|<big|sum><around|(|n|)>=<around|{|1,4,6,13|}>> and
  <math|<big|sum><around|(|n|)>=<around|{|1,6,21,107|}>> for
  <math|n=<around|{|1,2,3,4|}>>.

  <section|The empirical distribution <math|D>><label|D>

  <no-indent><with|font-shape|small-caps|Definition 8.> Consider a Turing
  machine with the binary alphabet <math|\<Sigma\>=<around|{|0,1|}>> and
  <math|n> states <math|<around|{|1,2,\<ldots\>*n|}>> and an additional Halt
  state denoted by 0 (just as defined in Rado's original busy beaver
  paper<cite|rado>).<next-line>

  The machine runs on a <math|2>-way unbounded tape. At each step:

  <\myenumerate>
    <item>the machine's current ``state'' (instruction); and

    <item>the tape symbol the machine's head is scanning
  </myenumerate>

  define each of the following:

  <\myenumerate>
    <item>a unique symbol to write (the machine can overwrite a <math|1> on a
    <math|0>, a <math|0> on a <math|1>, a <math|1> on a <math|1>, and a
    <math|0> on a <math|0>);

    <item>a direction to move in: <math|-1> (left), <math|1> (right) or
    <math|0> (none, when halting); and

    <item>a state to transition into (may be the same as the one it was in).
  </myenumerate>

  The machine halts if and when it reaches the special halt state
  0.<next-line>

  Since the domain of the program has size <math|2*n> and the target space
  has size <math|4*<around|(|n+1|)>>, we can easily count the number of
  Turing machines. There are <math|4*<around|(|n+1|)><rsup|2*n>> Turing
  machines with <math|n> states and 2 symbols according to the formalism
  described above.

  No transition starting from the halting state exists, and the blank symbol
  is one of the 2 symbols (0 or 1) in the first run, while the other is used
  in the second run (in order to avoid any asymmetries due to the choice of a
  single blank symbol). In other words, we run each machine twice, one with 0
  as the blank symbol (the symbol with which the tape starts out and is
  filled with), and an additional run with 1 as the blank symbol<footnote|Due
  to the symmetry of the computation, there is no real need to run each
  machine twice; one can <em|complete> the string frequencies assuming that
  each string produced its reversed and complemented version with the same
  frequency, and then group and divide by symmetric groups. A more detailed
  explanation of how this is done is in <cite|delahayezenil>.>.<next-line>

  <no-indent><with|font-shape|small-caps|Definition 9.>
  <math|D<around|(|n|)>=> the function that assigns to every finite bit
  string s the quotient (number of times that a machine (n,2) produces s) /
  (number of machines in (n,2)).<next-line>

  The output string is taken from the number of contiguous cells on the tape
  the head of the halting n-state machine has gone through upon
  halting.<next-line>

  Examples of <math|D<around|(|n|)>> for <math|n=1,n=2>:

  <\center>
    <math|D<around|(|1|)>=0\<rightarrow\>0.5;1\<rightarrow\>0.5><next-line><math|D<around|(|2|)>=0\<rightarrow\>0.328;1\<rightarrow\>0.328;00\<rightarrow\>.*0834*\<ldots\>><next-line>
  </center>

  <math|D<around|(|n|)>> is the probability distribution of the strings
  produced by all 2-symbol halting Turing machines with <math|n> states.
  Tables 1, 2 and 3 in <reference|results> show the full results for
  <math|D<around|(|1|)>>, <math|D<around|(|2|)>> and <math|D<around|(|3|)>>,
  and Table 4 the top ranking of <math|D<around|(|4|)>>.<next-line>

  <no-indent><with|font-shape|small-caps|Theorem 2.> <math|D<around|(|n|)>>
  is not computable.<next-line>

  <no-indent><with|font-shape|small-caps|Proof (by contradiction)> Suppose
  that <math|n\<rightarrow\>D<around|(|n|)>> is computable. Let n be a given
  integer. Let <math|D<around|(|n|)>> be computed. Once this finished the
  busy beaver functions <math|S<around|(|n|)>> and
  <math|\<Sigma\><around|(|n|)>> can be known for any n. This means this is a
  method to calculate Rado's busy beaver functions. Which is a contradiction
  with the non-computability of Rado's busy beaver functions.<next-line>

  Exact values can be calculated for small (n,2) Turing machines up to
  <math|n=4> states because the maximum halting runtime is known thanks to
  the busy beaver values <math|S<around|(|n|)>> for <math|n\<less\>5>. Turing
  machines that run more than <math|S<around|(|n|)>> steps will therefore
  never halt. For example, for <math|n=4>, <math|S<around|(|4|)>=107>, so 107
  is the maximum runtime we have to run each machine in (4,2) in order to get
  the all the outputs.

  For each busy beaver candidate with <math|n\<gtr\>4> states, a sample of
  Turing machines running up to the candidate <math|S<around|(|n|)>> is
  possible. As for Rado's busy beaver functions
  <math|<big|sum><around|(|n|)>> and <math|S<around|(|n|)>>, <math|D> is also
  approachable <em|from above>. For larger <math|n> sampling methods
  asymptotically converging to <math|D<around|(|n|)>> can be used to
  approximate <math|D<around|(|n|)>>. In <reference|results> we provide exact
  values of <math|D<around|(|n|)>> for <math|n\<less\>5> for which the busy
  beaver functions are known.

  Another common property between <math|D<around|(|n|)>> and Rado's busy
  beaver functions is that <math|D<around|(|4|)>> is well-defined in the
  sense that the calculation of the digits of <math|D<around|(|n|)>> are
  fully determined as is in the decimal expansion of the mathematical
  constant <math|\<pi\>>, but the calculation of <math|D<around|(|n|)>>
  rapidly becomes impractical to determine for even a slightly larger number
  of states.

  <section|Methodology><label|method>

  The approach for evaluating the complexity <math|C<around|(|s|)>> of a
  string s presented herein is limited by (1) the halting problem and (2)
  computing time constraints. Restriction (1) was overcome because the values
  of the busy beaver problem provided the halting times for all (4,2) Turing
  machines that started with a blank tape. Restriction (2) represented a
  challenge in terms of computing time and programming skills. It is also the
  same restriction that has kept others from attempting to solve the busy
  beaver problem for a greater number of states. Constraint (2) and the
  knowledge of the values of the busy beaver function permitted us to
  systematically study machines up to 4 states. We were able to compute up to
  about <math|1.3775\<times\>10<rsup|9>> machines per day or
  15<space|0.17em>943 per second, taking us about 9 days<footnote|Running on
  a single computer on a MacBook Intel Core Duo at 1.83Ghz, 2Gb. of memory
  and a solid state hard drive, using the TuringMachine[] function available
  in <math|M*a*t*h*e*m*a*t*i*c*a> 8 for <math|n\<less\>4> and a C++ program
  for <math|n=4>. Since for <math|n=4> there were
  <math|2.56\<times\>10<rsup|8>> machines involved, running on both 0 and 1
  as blank, further optimizations were required. The use of a bignum library
  and an actual enumeration of the machines rather than producing the rules
  beforehand (which would have meant overloading the memory even before the
  actual calculation) was necessary.> to run all (4,2) Turing machines each
  up to the number of steps bounded by the busy beaver values.

  Our quest is similar in several respects to the busy beaver problem or the
  calculation of the digits of Chaitin's <math|\<Omega\>> number. The main
  underlying difficulty in analyzing thoroughly a given class of machines is
  their uncomputability. Just as it is done for solving small values of the
  busy beaver problem, we rely on the experimental approach to analyze and
  describe a computable fraction of the uncomputable. A similar quest for the
  calculation of the digits of a Chaitin's <math|\<Omega\>> number was
  undertaken by Calude et al.<cite|caludeomega>, but unlike Chaitin's
  <math|\<Omega\>>, the calculation of <math|D<around|(|n|)>> does not depend
  on the enumeration of Turing machines. In <math|D<around|(|n|)>>, however,
  one obtains different probabilities for the same string for each n, but the
  relative order seems to be preserved. In fact, every
  <math|<around|(|2,n|)>> machine contributing to <math|D<around|(|n|)>> is
  included in <math|D*<around|(|n+1|)>> simply because every machine rule in
  <math|<around|(|2,n|)>> is in <math|<around|(|2,n+1|)>>.

  <subsection|Numerical evaluation of <math|D>><label|calculating>

  We consider the space (n,2) of Turing machines with
  <math|0\<less\>n\<less\>5>. The halting \Phistory\Q and output probability
  followed by their respective runtimes, presented in Tables 1, 2 and 3, show
  the times at which the programs in the domain of M halt, the frequency of
  the strings produced, and the time at which they halted after writing down
  the output string on their tape.

  We provide exact values for <math|n=<around|{|2,3,4|}>> in the Results
  <reference|results>. We derive <math|D<around|(|n|)>> for <math|n\<less\>5>
  from counting the number of n-strings produced by all (n,2) Turing machines
  upon halting. We define <math|D> to be an <math|e*m*p*i*r*i*c*a*l>
  <em|universal distribution> in Levin's sense, and calculate the algorithmic
  complexity <math|C> of a string <math|s> in terms of <math|D> using the
  coding theorem.

  We calculated the 72, 20<space|0.17em>000,
  15<space|0.17em>059<space|0.17em>072 and
  22<space|0.17em>039<space|0.17em>921<space|0.17em>152 two-way tape Turing
  machines started with a tape filled with 0s and 1s for
  <math|D<around|(|2|)>>, <math|D<around|(|3|)>> and
  <math|D<around|(|4|)>><footnote|We ran the experiment on several computers
  and cores in parallel, which allowed us to shorten the time by about a
  fourth of that calculated in a single processor. The space occupied by the
  machine outputs was 77.06 GB (of which only 38.53 GB was actually necessary
  by taking advantage of machine rule symmetries that could be later
  compensed without having to run them).>. The number of Turing machines to
  calculate grows exponentially with the number of states. For
  <math|D<around|(|5|)>> there are 53<space|0.17em>119<space|0.17em>845<space|0.17em>582<space|0.17em>848
  machines to calculate, which makes the task as difficult as finding the
  busy beaver values for <math|<big|sum><around|(|5|)>> and
  <math|S<around|(|5|)>>, busy beaver values which are currently unknown but
  for which the best candidate may be <math|S<around|(|5|)>=47*<space|0.17em>176*<space|0.17em>870>
  which makes the exploration of (5,2) quite a challenge.

  Although several ideas exploiting symmetries to reduce the total number of
  Turing machines have been proposed and used for finding busy beaver
  candidates<cite|brady|machlin|holkner> in large spaces such as
  <math|n\<geq\>5>, to preserve the structure of the data we couldn't apply
  all of them. This is because, unlike the busy beaver challenge, in which
  only the maximum values are important, the construction of a probability
  distribution requires every output to be equally considered. Some reduction
  techniques were, however, utilized, such as running only one-direction
  rules with a tape only filled with 0s and then completing the strings by
  reversion and complementation to avoid running every machine a second time
  with a tape filled with 1s. For an explanation of how we counted the number
  of symmetries to recuperate the outputs of the machines that were skipped
  see <cite|delahayezenil>.

  <section|Results><label|results>

  <subsection|Algorithmic complexity tables>

  <math|D<around|(|1|)>> is trivial. (1,2) Turing machines produce only two
  strings, with the same number of machines producing each. The busy beaver
  values for <math|n=1> are <math|<big|sum><around|(|1|)>=1> and
  <math|S<around|(|1|)>=1>. That is, all machines that halt do so after 1
  step, and print at most one symbol.

  <\big-table>
    \;

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<table|<row|<cell|0
    <math|\<rightarrow\>> 0.5>>|<row|<cell|1 <math|\<rightarrow\>> 0.5>>>>>

    <label|default>
  </big-table|Complete <math|D<around|(|1|)>> from 24 (1,2)-Turing machines
  that halt out of a total of 64.>

  The busy beaver values for <math|n=2> are <math|<big|sum><around|(|1|)>=4>
  and <math|S<around|(|1|)>=6>. <math|D<around|(|2|)>> is quite simple but
  starts to display some basic structure, such as a clear correlation between
  string length and occurrence, following what may be an exponential
  decrease:

  <\center>
    <math|P*<around|(|<around|\||s|\|>=1|)>=0.657><next-line><math|P*<around|(|<around|\||s|\|>=2|)>=0.333><next-line><math|P*<around|(|<around|\||s|\|>=3|)>=0.0065><next-line><math|P*<around|(|<around|\||s|\|>=4|)>=0.0026><next-line>
  </center>

  <\big-table>
    \;

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<table|<row|<cell|0
    <math|\<rightarrow\>> .328>|<cell|010 <math|\<rightarrow\>>
    .00065>>|<row|<cell|1 <math|\<rightarrow\>> .328>|<cell|101
    <math|\<rightarrow\>> .00065>>|<row|<cell|00 <math|\<rightarrow\>>
    .0834>|<cell|111 <math|\<rightarrow\>> .00065>>|<row|<cell|01
    <math|\<rightarrow\>> .0834>|<cell|0000 <math|\<rightarrow\>>
    .00032>>|<row|<cell|10 <math|\<rightarrow\>> .0834>|<cell|0010
    <math|\<rightarrow\>> .00032>>|<row|<cell|11 <math|\<rightarrow\>>
    .0834>|<cell|0100 <math|\<rightarrow\>> .00032>>|<row|<cell|001
    <math|\<rightarrow\>> .00098>|<cell|0110 <math|\<rightarrow\>>
    .00032>>|<row|<cell|011 <math|\<rightarrow\>> .00098>|<cell|1001
    <math|\<rightarrow\>> .00032>>|<row|<cell|100 <math|\<rightarrow\>>
    .00098>|<cell|1011 <math|\<rightarrow\>> .00032>>|<row|<cell|110
    <math|\<rightarrow\>> .00098>|<cell|1101 <math|\<rightarrow\>>
    .00032>>|<row|<cell|000 <math|\<rightarrow\>> .00065>|<cell|1111
    <math|\<rightarrow\>> .00032>>>>>

    <label|default>
  </big-table|Complete <math|D<around|(|2|)>> (22 bit-strings) from
  6<space|0.17em>088 (2,2)-Turing machines that halt out of
  20<space|0.17em>000. Each string is followed by its probability (from the
  number of times produced), sorted from highest to lowest.>

  <no-indent>Among the various facts one can draw from
  <math|D<around|(|2|)>>, there are:

  <\myitemize>
    <item>The relative string order in <math|D<around|(|1|)>> is preserved in
    <math|D<around|(|2|)>>.

    <item>A fraction of <math|1/3> of the total machines halt while the
    remaining <math|2/3> do not. That is, 24 among 72 (running each machine
    twice with tape filled with 1 and 0 as explained before).

    <item>The longest string produced by <math|D<around|(|2|)>> is of length
    4.

    <item><math|D<around|(|2|)>> does not produce all
    <math|<big|sum><rsub|1><rsup|4>2<rsup|n>=30> strings shorter than 5, only
    22. The missing strings are 0001, 0101 and 0011 never produced, hence
    neither were their complements and reversions: 0111, 1000, 1110, 1010 and
    1100.
  </myitemize>

  <\big-table>
    \;

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|43|43|1|-1|cell-bborder|1ln>|<table|<row|<cell|0
    <math|\<rightarrow\>> 0.250>|<cell|11110 <math|\<rightarrow\>>
    0.0000470>|<cell|100101 <math|\<rightarrow\>>
    <with|font-size|1|1.43<math|\<times\>10<rsup|-6>>>>>|<row|<cell|1
    <math|\<rightarrow\>> 0.250>|<cell|00100 <math|\<rightarrow\>>
    0.0000456>|<cell|101001 <math|\<rightarrow\>>
    <with|font-size|1|1.43<math|\<times\>10<rsup|-6>>>>>|<row|<cell|00
    <math|\<rightarrow\>> 0.101>|<cell|11011 <math|\<rightarrow\>>
    0.0000456>|<cell|000011 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|01
    <math|\<rightarrow\>> 0.101>|<cell|01010 <math|\<rightarrow\>>
    0.0000419>|<cell|000110 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|10
    <math|\<rightarrow\>> 0.101>|<cell|10101 <math|\<rightarrow\>>
    0.0000419>|<cell|001100 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|11
    <math|\<rightarrow\>> 0.101>|<cell|01001 <math|\<rightarrow\>>
    0.0000391>|<cell|001101 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|000
    <math|\<rightarrow\>> 0.0112>|<cell|01101 <math|\<rightarrow\>>
    0.0000391>|<cell|001111 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|111
    <math|\<rightarrow\>> 0.0112>|<cell|10010 <math|\<rightarrow\>>
    0.0000391>|<cell|010001 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|001
    <math|\<rightarrow\>> 0.0108>|<cell|10110 <math|\<rightarrow\>>
    0.0000391>|<cell|010010 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|011
    <math|\<rightarrow\>> 0.0108>|<cell|01110 <math|\<rightarrow\>>
    0.0000289>|<cell|010011 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|100
    <math|\<rightarrow\>> 0.0108>|<cell|10001 <math|\<rightarrow\>>
    0.0000289>|<cell|011000 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|110
    <math|\<rightarrow\>> 0.0108>|<cell|00101 <math|\<rightarrow\>>
    0.0000233>|<cell|011101 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|010
    <math|\<rightarrow\>> 0.00997>|<cell|01011 <math|\<rightarrow\>>
    0.0000233>|<cell|011110 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|101
    <math|\<rightarrow\>> 0.00997>|<cell|10100 <math|\<rightarrow\>>
    0.0000233>|<cell|100001 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|0000
    <math|\<rightarrow\>> 0.000968>|<cell|11010 <math|\<rightarrow\>>
    0.0000233>|<cell|100010 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|1111
    <math|\<rightarrow\>> 0.000968>|<cell|00011 <math|\<rightarrow\>>
    0.0000219>|<cell|100111 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|0010
    <math|\<rightarrow\>> 0.000699>|<cell|00111 <math|\<rightarrow\>>
    0.0000219>|<cell|101100 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|0100
    <math|\<rightarrow\>> 0.000699>|<cell|11000 <math|\<rightarrow\>>
    0.0000219>|<cell|101101 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|1011
    <math|\<rightarrow\>> 0.000699>|<cell|11100 <math|\<rightarrow\>>
    0.0000219>|<cell|101110 <math|\<rightarrow\>>
    <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|1101
    <math|\<rightarrow\>> 0.000699>|<cell|000000 <math|\<rightarrow\>>
    <with|font-size|1|3.733<math|\<times\>10<rsup|-6>>>>|<cell|110000
    <math|\<rightarrow\>> <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|0101
    <math|\<rightarrow\>> 0.000651>|<cell|111111 <math|\<rightarrow\>>
    <with|font-size|1|3.733<math|\<times\>10<rsup|-6>>>>|<cell|110010
    <math|\<rightarrow\>> <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|1010
    <math|\<rightarrow\>> 0.000651>|<cell|000001 <math|\<rightarrow\>>
    <with|font-size|1|2.793<math|\<times\>10<rsup|-6>>>>|<cell|110011
    <math|\<rightarrow\>> <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|0001
    <math|\<rightarrow\>> 0.000527>|<cell|011111 <math|\<rightarrow\>>
    <with|font-size|1|2.793<math|\<times\>10<rsup|-6>>>>|<cell|111001
    <math|\<rightarrow\>> <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|0111
    <math|\<rightarrow\>> 0.000527>|<cell|100000 <math|\<rightarrow\>>
    <with|font-size|1|2.793<math|\<times\>10<rsup|-6>>>>|<cell|111100
    <math|\<rightarrow\>> <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|1000
    <math|\<rightarrow\>> 0.000527>|<cell|111110 <math|\<rightarrow\>>
    <with|font-size|1|2.793<math|\<times\>10<rsup|-6>>>>|<cell|0101010
    <math|\<rightarrow\>> <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|1110
    <math|\<rightarrow\>> 0.000527>|<cell|000100 <math|\<rightarrow\>>
    <with|font-size|1|2.333<math|\<times\>10<rsup|-6>>>>|<cell|1010101
    <math|\<rightarrow\>> <with|font-size|1|9.313<math|\<times\>10<rsup|-7>>>>>|<row|<cell|0110
    <math|\<rightarrow\>> 0.000510>|<cell|001000 <math|\<rightarrow\>>
    <with|font-size|1|2.333<math|\<times\>10<rsup|-6>>>>|<cell|001110
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|1001
    <math|\<rightarrow\>> 0.000510>|<cell|110111 <math|\<rightarrow\>>
    <with|font-size|1|2.333<math|\<times\>10<rsup|-6>>>>|<cell|011100
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|0011
    <math|\<rightarrow\>> 0.000321>|<cell|111011 <math|\<rightarrow\>>
    <with|font-size|1|2.333<math|\<times\>10<rsup|-6>>>>|<cell|100011
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|1100
    <math|\<rightarrow\>> 0.000321>|<cell|000010 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|110001
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|00000
    <math|\<rightarrow\>> 0.0000969>|<cell|001001 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|0000010
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|11111
    <math|\<rightarrow\>> 0.0000969>|<cell|001010 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|0000110
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|00110
    <math|\<rightarrow\>> 0.0000512>|<cell|010000 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|0100000
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|01100
    <math|\<rightarrow\>> 0.0000512>|<cell|010100 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|0101110
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|10011
    <math|\<rightarrow\>> 0.0000512>|<cell|011011 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|0110000
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|11001
    <math|\<rightarrow\>> 0.0000512>|<cell|100100 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|0111010
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|00010
    <math|\<rightarrow\>> 0.0000489>|<cell|101011 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|1000101
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|01000
    <math|\<rightarrow\>> 0.0000489>|<cell|101111 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|1001111
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|10111
    <math|\<rightarrow\>> 0.0000489>|<cell|110101 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|1010001
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|11101
    <math|\<rightarrow\>> 0.0000489>|<cell|110110 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|1011111
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|00001
    <math|\<rightarrow\>> 0.0000470>|<cell|111101 <math|\<rightarrow\>>
    <with|font-size|1|1.863<math|\<times\>10<rsup|-6>>>>|<cell|1111001
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|01111
    <math|\<rightarrow\>> 0.0000470>|<cell|010110 <math|\<rightarrow\>>
    <with|font-size|1|1.43<math|\<times\>10<rsup|-6>>>>|<cell|1111101
    <math|\<rightarrow\>> <with|font-size|1|4.663<math|\<times\>10<rsup|-7>>>>>|<row|<cell|10000
    <math|\<rightarrow\>> 0.0000470>|<cell|011010 <math|\<rightarrow\>>
    <with|font-size|1|1.43<math|\<times\>10<rsup|-6>>>>|<cell|>>>>>

    <label|default>
  </big-table|Complete <math|D<around|(|3|)>> (128 bit-strings) produced by
  all the 15<space|0.17em>059<space|0.17em>072 (3,2)-halting Turing
  machines.>

  Given the number of machines to run, <math|D<around|(|3|)>> constitutes the
  first non trivial probability distribution to calculate. The busy beaver
  values for <math|n=3> are <math|<big|sum><around|(|3|)>=6> and
  <math|S<around|(|3|)>=14>.<next-line>

  <no-indent>Among the various facts for <math|D<around|(|3|)>>:

  <\myitemize>
    <item>There are 4<space|0.17em>294<space|0.17em>368 machines that halt
    among the 15<space|0.17em>059<space|0.17em>072 in (3,2). That is a
    fraction of 0.2851.

    <item>The longest string produced in (3,2) is of length 7.

    <item><math|D<around|(|3|)>> has not all
    <math|<big|sum><rsub|1><rsup|4>2<rsup|n>=254> strings shorter than 7 but
    128 only, half of all the possible strings up to that length.

    <item><math|D<around|(|3|)>> preserves the string order of
    <math|D<around|(|2|)>>.
  </myitemize>

  <math|D<around|(|3|)>> ratifies the tendency of classifying strings by
  length with exponentially decreasing values. The distribution comes sorted
  by length blocks from which one cannot easily say whether those at the
  bottom are more random-looking than those in the middle, but one can
  definitely say that the ones at the top, both for the entire distribution
  and by length block, are intuitively the simplest. Both <math|0<rsup|k>>
  and its reversed <math|1<rsup|k>> for <math|n\<leq\>8> are always at the
  top of each block, with 0 and 1 at the top of them all. There is a single
  exception in which strings were not sorted by length, this is the string
  group <math|0101010> and <math|1010101> that are found four places further
  away from their length block, which we take as a second indication of a
  complexity classification becoming more visible since these 2 strings
  correspond to what one would intuitively consider less random-looking
  because they are easily described as the repetition of two bits.

  <math|D<around|(|4|)>> with 22<space|0.17em>039<space|0.17em>921<space|0.17em>152
  machines to run was the first true challenge, both in terms of programming
  specification and computational resources. The busy beaver values for
  <math|n=4> are <math|<big|sum><around|(|3|)>=13> and
  <math|S<around|(|n|)>=107>. Evidently every machine in (n,2) for
  <math|n\<leq\>4> is in (4,2) because a rule in (n,2) with <math|n\<leq\>4>
  is a rule in (4,2) in which a part of it is never used and halts, which is
  guaranteed to exist because the computation is exhaustive over
  (4,2).<next-line>

  <\big-table>
    <label|d>

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|43|43|1|-1|cell-bborder|1ln>|<table|<row|<cell|0
    <math|\<rightarrow\>> 0.205>|<cell|01101 <math|\<rightarrow\>>
    0.000145>|<cell|110111 <math|\<rightarrow\>> 0.0000138>>|<row|<cell|1
    <math|\<rightarrow\>> 0.205>|<cell|10010 <math|\<rightarrow\>>
    0.000145>|<cell|111011 <math|\<rightarrow\>> 0.0000138>>|<row|<cell|00
    <math|\<rightarrow\>> 0.102>|<cell|10110 <math|\<rightarrow\>>
    0.000145>|<cell|001001 <math|\<rightarrow\>> 0.0000117>>|<row|<cell|01
    <math|\<rightarrow\>> 0.102>|<cell|01010 <math|\<rightarrow\>>
    0.000137>|<cell|011011 <math|\<rightarrow\>> 0.0000117>>|<row|<cell|10
    <math|\<rightarrow\>> 0.102>|<cell|10101 <math|\<rightarrow\>>
    0.000137>|<cell|100100 <math|\<rightarrow\>> 0.0000117>>|<row|<cell|11
    <math|\<rightarrow\>> 0.102>|<cell|00110 <math|\<rightarrow\>>
    0.000127>|<cell|110110 <math|\<rightarrow\>> 0.0000117>>|<row|<cell|000
    <math|\<rightarrow\>> 0.0188>|<cell|01100 <math|\<rightarrow\>>
    0.000127>|<cell|010001 <math|\<rightarrow\>> 0.0000109>>|<row|<cell|111
    <math|\<rightarrow\>> 0.0188>|<cell|10011 <math|\<rightarrow\>>
    0.000127>|<cell|011101 <math|\<rightarrow\>> 0.0000109>>|<row|<cell|001
    <math|\<rightarrow\>> 0.0180>|<cell|11001 <math|\<rightarrow\>>
    0.000127>|<cell|100010 <math|\<rightarrow\>> 0.0000109>>|<row|<cell|011
    <math|\<rightarrow\>> 0.0180>|<cell|00101 <math|\<rightarrow\>>
    0.000124>|<cell|101110 <math|\<rightarrow\>> 0.0000109>>|<row|<cell|100
    <math|\<rightarrow\>> 0.0180>|<cell|01011 <math|\<rightarrow\>>
    0.000124>|<cell|000011 <math|\<rightarrow\>> 0.0000108>>|<row|<cell|110
    <math|\<rightarrow\>> 0.0180>|<cell|10100 <math|\<rightarrow\>>
    0.000124>|<cell|001111 <math|\<rightarrow\>> 0.0000108>>|<row|<cell|010
    <math|\<rightarrow\>> 0.0171>|<cell|11010 <math|\<rightarrow\>>
    0.000124>|<cell|110000 <math|\<rightarrow\>> 0.0000108>>|<row|<cell|101
    <math|\<rightarrow\>> 0.0171>|<cell|00011 <math|\<rightarrow\>>
    0.000108>|<cell|111100 <math|\<rightarrow\>> 0.0000108>>|<row|<cell|0000
    <math|\<rightarrow\>> 0.00250>|<cell|00111 <math|\<rightarrow\>>
    0.000108>|<cell|000110 <math|\<rightarrow\>> 0.0000107>>|<row|<cell|1111
    <math|\<rightarrow\>> 0.00250>|<cell|11000 <math|\<rightarrow\>>
    0.000108>|<cell|011000 <math|\<rightarrow\>> 0.0000107>>|<row|<cell|0001
    <math|\<rightarrow\>> 0.00193>|<cell|11100 <math|\<rightarrow\>>
    0.000108>|<cell|100111 <math|\<rightarrow\>> 0.0000107>>|<row|<cell|0111
    <math|\<rightarrow\>> 0.00193>|<cell|01110 <math|\<rightarrow\>>
    0.0000928>|<cell|111001 <math|\<rightarrow\>> 0.0000107>>|<row|<cell|1000
    <math|\<rightarrow\>> 0.00193>|<cell|10001 <math|\<rightarrow\>>
    0.0000928>|<cell|001101 <math|\<rightarrow\>> 0.0000101>>|<row|<cell|1110
    <math|\<rightarrow\>> 0.00193>|<cell|000000 <math|\<rightarrow\>>
    0.0000351>|<cell|010011 <math|\<rightarrow\>> 0.0000101>>|<row|<cell|0101
    <math|\<rightarrow\>> 0.00191>|<cell|111111 <math|\<rightarrow\>>
    0.0000351>|<cell|101100 <math|\<rightarrow\>> 0.0000101>>|<row|<cell|1010
    <math|\<rightarrow\>> 0.00191>|<cell|000001 <math|\<rightarrow\>>
    0.0000195>|<cell|110010 <math|\<rightarrow\>> 0.0000101>>|<row|<cell|0010
    <math|\<rightarrow\>> 0.00190>|<cell|011111 <math|\<rightarrow\>>
    0.0000195>|<cell|001100 <math|\<rightarrow\>>
    <with|font-size|1|9.943<math|\<times\>10<rsup|-6>>>>>|<row|<cell|0100
    <math|\<rightarrow\>> 0.00190>|<cell|100000 <math|\<rightarrow\>>
    0.0000195>|<cell|110011 <math|\<rightarrow\>>
    <with|font-size|1|9.943<math|\<times\>10<rsup|-6>>>>>|<row|<cell|1011
    <math|\<rightarrow\>> 0.00190>|<cell|111110 <math|\<rightarrow\>>
    0.0000195>|<cell|011110 <math|\<rightarrow\>>
    <with|font-size|1|9.633<math|\<times\>10<rsup|-6>>>>>|<row|<cell|1101
    <math|\<rightarrow\>> 0.00190>|<cell|000010 <math|\<rightarrow\>>
    0.0000184>|<cell|100001 <math|\<rightarrow\>>
    <with|font-size|1|9.633<math|\<times\>10<rsup|-6>>>>>|<row|<cell|0110
    <math|\<rightarrow\>> 0.00163>|<cell|010000 <math|\<rightarrow\>>
    0.0000184>|<cell|011001 <math|\<rightarrow\>>
    <with|font-size|1|9.3<math|\<times\>10<rsup|-6>>>>>|<row|<cell|1001
    <math|\<rightarrow\>> 0.00163>|<cell|101111 <math|\<rightarrow\>>
    0.0000184>|<cell|100110 <math|\<rightarrow\>>
    <with|font-size|1|9.3<math|\<times\>10<rsup|-6>>>>>|<row|<cell|0011
    <math|\<rightarrow\>> 0.00161>|<cell|111101 <math|\<rightarrow\>>
    0.0000184>|<cell|000101 <math|\<rightarrow\>>
    <with|font-size|1|8.753<math|\<times\>10<rsup|-6>>>>>|<row|<cell|1100
    <math|\<rightarrow\>> 0.00161>|<cell|010010 <math|\<rightarrow\>>
    0.0000160>|<cell|010111 <math|\<rightarrow\>>
    <with|font-size|1|8.753<math|\<times\>10<rsup|-6>>>>>|<row|<cell|00000
    <math|\<rightarrow\>> 0.000282>|<cell|101101 <math|\<rightarrow\>>
    0.0000160>|<cell|101000 <math|\<rightarrow\>>
    <with|font-size|1|8.753<math|\<times\>10<rsup|-6>>>>>|<row|<cell|11111
    <math|\<rightarrow\>> 0.000282>|<cell|010101 <math|\<rightarrow\>>
    0.0000150>|<cell|111010 <math|\<rightarrow\>>
    <with|font-size|1|8.753<math|\<times\>10<rsup|-6>>>>>|<row|<cell|00001
    <math|\<rightarrow\>> 0.000171>|<cell|101010 <math|\<rightarrow\>>
    0.0000150>|<cell|001110 <math|\<rightarrow\>>
    <with|font-size|1|7.863<math|\<times\>10<rsup|-6>>>>>|<row|<cell|01111
    <math|\<rightarrow\>> 0.000171>|<cell|010110 <math|\<rightarrow\>>
    0.0000142>|<cell|011100 <math|\<rightarrow\>>
    <with|font-size|1|7.863<math|\<times\>10<rsup|-6>>>>>|<row|<cell|10000
    <math|\<rightarrow\>> 0.000171>|<cell|011010 <math|\<rightarrow\>>
    0.0000142>|<cell|100011 <math|\<rightarrow\>>
    <with|font-size|1|7.863<math|\<times\>10<rsup|-6>>>>>|<row|<cell|11110
    <math|\<rightarrow\>> 0.000171>|<cell|100101 <math|\<rightarrow\>>
    0.0000142>|<cell|110001 <math|\<rightarrow\>>
    <with|font-size|1|7.863<math|\<times\>10<rsup|-6>>>>>|<row|<cell|00010
    <math|\<rightarrow\>> 0.000166>|<cell|101001 <math|\<rightarrow\>>
    0.0000142>|<cell|001011 <math|\<rightarrow\>>
    <with|font-size|1|6.523<math|\<times\>10<rsup|-6>>>>>|<row|<cell|01000
    <math|\<rightarrow\>> 0.000166>|<cell|001010 <math|\<rightarrow\>>
    0.0000141>|<cell|110100 <math|\<rightarrow\>>
    <with|font-size|1|6.523<math|\<times\>10<rsup|-6>>>>>|<row|<cell|10111
    <math|\<rightarrow\>> 0.000166>|<cell|010100 <math|\<rightarrow\>>
    0.0000141>|<cell|000111 <math|\<rightarrow\>>
    <with|font-size|1|6.243<math|\<times\>10<rsup|-6>>>>>|<row|<cell|11101
    <math|\<rightarrow\>> 0.000166>|<cell|101011 <math|\<rightarrow\>>
    0.0000141>|<cell|111000 <math|\<rightarrow\>>
    <with|font-size|1|6.243<math|\<times\>10<rsup|-6>>>>>|<row|<cell|00100
    <math|\<rightarrow\>> 0.000151>|<cell|110101 <math|\<rightarrow\>>
    0.0000141>|<cell|0000000 <math|\<rightarrow\>>
    <with|font-size|1|3.723<math|\<times\>10<rsup|-6>>>>>|<row|<cell|11011
    <math|\<rightarrow\>> 0.000151>|<cell|000100 <math|\<rightarrow\>>
    0.0000138>|<cell|1111111 <math|\<rightarrow\>>
    <with|font-size|1|3.723<math|\<times\>10<rsup|-6>>>>>|<row|<cell|01001
    <math|\<rightarrow\>> 0.000145>|<cell|001000 <math|\<rightarrow\>>
    0.0000138>|<cell|0101010 <math|\<rightarrow\>>
    <with|font-size|1|2.393<math|\<times\>10<rsup|-6>>>>>>>>

    <label|default>
  </big-table|The top 129 strings from <math|D<around|(|4|)>> with highest
  probability from a total of 1832 different produced strings.>

  <no-indent>Among the various facts from these results:

  <\myitemize>
    <item>There are 5<space|0.17em>970<space|0.17em>768<space|0.17em>960
    machines that halt among the 22<space|0.17em>039<space|0.17em>921<space|0.17em>152
    in (4,2). That is a fraction of 0.27.

    <item>A total number of 1824 strings were produced in (4,2).

    <item>The longest string produced is of length 14 (only 8 among all the
    <math|2<rsup|1>*4> possible were generated).

    <item>The busy beaver machines (writing more 1s than any other and
    halting) found in (4,2) had very low probability among all the halting
    machines: <math|p*r<around|(|11111111111101|)>=2.01\<times\>10<rsup|-9>>.
    Because of the reverted string (10111111111111), the total probability of
    finding a busy beaver in (4,2) is therefore
    <math|4.02\<times\>10<rsup|-9>> only (or twice that number if the
    complemented string with the maximum number of 0s is taken).

    <item>The longest strings in (4,2) were in the string group formed by:
    1101010 101010101, 1101010100010101, 1010101010101011 and
    1010100010101011, each with 5.4447<math|\<times\>10<rsup|-10>>
    probability, i.e. an even smaller probability than for the busy beavers,
    and therefore the most random in the classification.

    <item>(4,2) produces all strings up to length 8, then the number of
    strings larger than 8 decreases. The following are the number of strings
    by length <math|<around|\||<around|{|s:<around|\||s|\|>=l|}>|\|>>
    generated and represented in <math|D<around|(|4|)>> from a total of
    1<space|0.17em>824 different strings. From <math|i=1,\<ldots\>,15> the
    values l of <math|<around|\||<around|{|s:<around|\||s|\|>=n|}>|\|>> are
    2, 4, 8, 16, 32, 64, 128, 256, 486, 410, 252, 112, 46, 8, and 0, which
    indicated all <math|2<rsup|l>> strings where generated for
    <math|n\<leq\>8>.

    <item>While the probability of producing a string with an odd number of
    1s is the same than the probability of producing a string with an even
    number of 1s (and therefore the same for 0s), the probability of
    producing a string of odd length is .559 and .441 for even length.

    <item>As in <math|D<around|(|3|)>>, where we report that one string group
    (0101010 and its reversion), in <math|D<around|(|4|)>> 399 strings
    climbed to the top and were not sorted among their length groups.

    <item>In <math|D<around|(|4|)>> string length was no longer a determinant
    for string positions. For example, between positions 780 and 790, string
    lengths are: 11, 10, 10, 11, 9, 10, 9, 9, 9, 10 and 9 bits.

    <item><math|D<around|(|4|)>> preserves the string order of
    <math|D<around|(|3|)>> except in 17 places out of 128 strings in
    <math|D<around|(|3|)>> ordered from highest to lowest string frequency.
    The maximum rank distance among the farthest two differing elements in
    <math|D<around|(|3|)>> and <math|D<around|(|4|)>> was 20, with an average
    of 11.23 among the 17 misplaced cases and a standard deviation of about 5
    places. The Spearman's rank correlation coefficient between the two
    rankings had a critical value of 0.98, meaning that the order of the 128
    elements in <math|D<around|(|3|)>> compared to their order in
    <math|D<around|(|4|)>> were in an interval confidence of high
    significance with almost null probability to have produced by chance.
  </myitemize>

  <\big-table>
    \;

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|r>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|15|15|1|-1|cell-bborder|1ln>|<table|<row|<cell|<with|font-size|1|number>>|<cell|>>|<row|<cell|<with|font-size|1|n
    of 1s >>|<cell|<with|font-size|1|pr(n)
    >>>|<row|<cell|1>|<cell|0.472>>|<row|<cell|2>|<cell|0.167>>|<row|<cell|3>|<cell|0.0279>>|<row|<cell|4>|<cell|0.00352>>|<row|<cell|5>|<cell|0.000407>>|<row|<cell|6>|<cell|0.0000508>>|<row|<cell|7>|<cell|<with|font-size|1|6.5<math|\<times\>10<rsup|-6>>>>>|<row|<cell|8>|<cell|<with|font-size|1|1.31<math|\<times\>10<rsup|-6>>>>>|<row|<cell|9>|<cell|<with|font-size|1|2.25<math|\<times\>10<rsup|-7>>>>>|<row|<cell|10>|<cell|<with|font-size|1|3.62<math|\<times\>10<rsup|-8>>>>>|<row|<cell|11>|<cell|<with|font-size|1|1.61<math|\<times\>10<rsup|-8>>>>>|<row|<cell|12>|<cell|<with|font-size|1|1.00<math|\<times\>10<rsup|-8>>>>>|<row|<cell|13>|<cell|<with|font-size|1|4.02<math|\<times\>10<rsup|-9>>>>>>>>

    <label|default>
  </big-table|Probabilities of finding n 1s (or 0s) in
  <math|<around|(|4,2|)>>.>

  <\big-table>
    \;

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|r>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|32|32|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|>>|<row|<cell|<with|font-size|1|string
    group>>|<cell|<with|font-size|1|occurrences>>>|<row|<cell|0,
    1>|<cell|1224440064>>|<row|<cell|01, 10>|<cell|611436144>>|<row|<cell|00,
    11>|<cell|611436144>>|<row|<cell|001, 011, 100,
    110>|<cell|215534184>>|<row|<cell|000,
    111>|<cell|112069020>>|<row|<cell|010,
    101>|<cell|102247932>>|<row|<cell|0001, 0111, 1000,
    1110>|<cell|23008080>>|<row|<cell|0010, 0100, 1011,
    1101>|<cell|22675896>>|<row|<cell|0000,
    1111>|<cell|14917104>>|<row|<cell|0101,
    1010>|<cell|11425392>>|<row|<cell|0110,
    1001>|<cell|9712752>>|<row|<cell|0011,
    1100>|<cell|9628728>>|<row|<cell|00001, 01111, 10000,
    11110>|<cell|2042268>>|<row|<cell|00010, 01000, 10111,
    11101>|<cell|1984536>>|<row|<cell|01001, 01101, 10010,
    10110>|<cell|1726704>>|<row|<cell|00000,
    11111>|<cell|1683888>>|<row|<cell|00110, 01100, 10011,
    11001>|<cell|1512888>>|<row|<cell|00101, 01011, 10100,
    11010>|<cell|1478244>>|<row|<cell|00011, 00111, 11000,
    11100>|<cell|1288908>>|<row|<cell|00100,
    11011>|<cell|900768>>|<row|<cell|01010,
    10101>|<cell|819924>>|<row|<cell|01110,
    10001>|<cell|554304>>|<row|<cell|000001, 011111, 100000,
    111110>|<cell|233064>>|<row|<cell|000010, 010000, 101111,
    111101>|<cell|219552>>|<row|<cell|000000,
    111111>|<cell|209436>>|<row|<cell|010110, 011010, 100101,
    101001>|<cell|169896>>|<row|<cell|001010, 010100, 101011,
    110101>|<cell|167964>>|<row|<cell|000100, 001000, 110111,
    111011>|<cell|164520>>|<row|<cell|001001, 011011, 100100,
    110110>|<cell|140280>>|<row|<cell|010001, 011101, 100010,
    101110>|<cell|129972>>>>>

    <label|default>
  </big-table|String groups formed by reversion and complementation followed
  by the total machines producing them.>

  These are the top 10 string groups (i.e. with their reverted and
  complemented counterparts) appearing sooner than expected and getting away
  from their length blocks. That is, their lengths were greater than the next
  string in the classification order): 11111111, 11110111, 000000000,
  111111111, 000010000, 111101111, 111111110, 010101010, 101010101,
  000101010. This means these string groups had greater algorithmic
  probability and therefore less algorithmic complexity than shorter strings.

  <subsubsection|Same length string distribution>

  <\big-table>
    \;

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|r>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|13|13|1|-1|cell-bborder|1ln>|<table|<row|<cell|<with|font-size|1|length
    n>>|<cell|<with|font-size|1|pr(n) >>>|<row|<cell|1>|<cell|0.410>>|<row|<cell|2>|<cell|0.410>>|<row|<cell|3>|<cell|0.144>>|<row|<cell|4>|<cell|0.0306>>|<row|<cell|5>|<cell|0.00469>>|<row|<cell|6>|<cell|0.000818>>|<row|<cell|7>|<cell|0.000110>>|<row|<cell|8>|<cell|0.0000226>>|<row|<cell|9>|<cell|<with|font-size|1|4.69<math|\<times\>10<rsup|-6>>>>>|<row|<cell|10>|<cell|<with|font-size|1|1.42<math|\<times\>10<rsup|-6>>>>>|<row|<cell|11>|<cell|<with|font-size|1|4.9<math|\<times\>10<rsup|-7>>>>>|<row|<cell|12>|<cell|<with|font-size|1|1.69<math|\<times\>10<rsup|-7>>>>>>>>

    <label|default>
  </big-table|The probability of producing a string of length n exponentially
  decreases as n linearly increases. The slowdown in the rate of decrease for
  string length <math|l\<gtr\>8> is due to the few longer strings produced in
  (4,2).>

  <big-figure|<label|stringlengthprobability><with|par-mode|center|<scalebox|.7|<image|stringlengthprobability.eps||||>>
  >|(4,2) frequency distribution by string length.>

  <big-figure|<label|dens><with|par-mode|center|<scalebox|.57|<image|probabilitydensity.eps||||>>
  <scalebox|.66|<image|cumulativeprobabilitydensity.eps||||>> >|Probability
  density function of bit strings of length <math|l=8> from
  <math|<around|(|4,2|)>>. The histogram (left) shows the probabilities to
  fall within a particular region. The cumulative version (right) shows how
  well the distribution fits a Pareto distribution (dashed) with location
  parameter <math|k=10>. The reader may see but a single curve, that is
  because the lines overlap. <math|D<around|(|4|)>> (and the
  sub-distributions it contains) is therefore log-normal.>

  Table 8 displays some statistical information of the distribution. The
  distribution is skewed to the right, the mass of the distribution is
  therefore concentrated on the left with a long right tail, as shown in
  Figure 2.

  <\big-table>
    <label|stats>

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|value>>|<row|<cell|<with|font-size|1|mean>>|<cell|0.00391>>|<row|<cell|<with|font-size|1|median>>|<cell|0.00280>>|<row|<cell|<with|font-size|1|variance>>|<cell|0.0000136>>|<row|<cell|<with|font-size|1|kurtosis>>|<cell|23>>|<row|<cell|<with|font-size|1|skewness>>|<cell|3.6>>>>>

    <label|default>
  </big-table|Statistical values of the empirical distribution function
  <math|D<around|(|4|)>> for strings of length <math|l=8>.>

  <subsection|Algorithmic complexity tables>

  Program-size (C) complexity values from the output probability distribution
  <math|D<around|(|4|)>> by application of the coding theorem.

  Columns in table 9 show the strings after the evaluation of their
  algorithmic complexity, the program-size length (the algorithmic
  complexity) through the application of the coding theorem to the
  algorithmic probabilities values obtained from <math|D<around|(|4|)>>.

  <\big-table>
    <label|c>

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|1ln>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|5|5|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|45|45|1|-1|cell-bborder|1ln>|<table|<row|<cell|0<math|\<rightarrow\>>2.29>|<cell|10110<math|\<rightarrow\>>12.76>|<cell|100100<math|\<rightarrow\>>16.38>|<cell|0100000<math|\<rightarrow\>>19.10>>|<row|<cell|1<math|\<rightarrow\>>2.29>|<cell|01010<math|\<rightarrow\>>12.83>|<cell|110110<math|\<rightarrow\>>16.38>|<cell|1011111<math|\<rightarrow\>>19.10>>|<row|<cell|00<math|\<rightarrow\>>3.29>|<cell|10101<math|\<rightarrow\>>12.83>|<cell|010001<math|\<rightarrow\>>16.49>|<cell|1111101<math|\<rightarrow\>>19.10>>|<row|<cell|01<math|\<rightarrow\>>3.29>|<cell|00110<math|\<rightarrow\>>12.95>|<cell|011101<math|\<rightarrow\>>16.49>|<cell|0000100<math|\<rightarrow\>>19.38>>|<row|<cell|10<math|\<rightarrow\>>3.29>|<cell|01100<math|\<rightarrow\>>12.95>|<cell|100010<math|\<rightarrow\>>16.49>|<cell|0010000<math|\<rightarrow\>>19.38>>|<row|<cell|11<math|\<rightarrow\>>3.29>|<cell|10011<math|\<rightarrow\>>12.95>|<cell|101110<math|\<rightarrow\>>16.49>|<cell|1101111<math|\<rightarrow\>>19.38>>|<row|<cell|000<math|\<rightarrow\>>5.74>|<cell|11001<math|\<rightarrow\>>12.95>|<cell|000011<math|\<rightarrow\>>16.49>|<cell|1111011<math|\<rightarrow\>>19.38>>|<row|<cell|111<math|\<rightarrow\>>5.74>|<cell|00101<math|\<rightarrow\>>12.98>|<cell|001111<math|\<rightarrow\>>16.49>|<cell|0001000<math|\<rightarrow\>>19.45>>|<row|<cell|001<math|\<rightarrow\>>5.79>|<cell|01011<math|\<rightarrow\>>12.98>|<cell|110000<math|\<rightarrow\>>16.49>|<cell|1110111<math|\<rightarrow\>>19.45>>|<row|<cell|011<math|\<rightarrow\>>5.79>|<cell|10100<math|\<rightarrow\>>12.98>|<cell|111100<math|\<rightarrow\>>16.49>|<cell|0000110<math|\<rightarrow\>>19.64>>|<row|<cell|100<math|\<rightarrow\>>5.79>|<cell|11010<math|\<rightarrow\>>12.98>|<cell|000110<math|\<rightarrow\>>16.52>|<cell|0110000<math|\<rightarrow\>>19.64>>|<row|<cell|110<math|\<rightarrow\>>5.79>|<cell|00011<math|\<rightarrow\>>13.18>|<cell|011000<math|\<rightarrow\>>16.52>|<cell|1001111<math|\<rightarrow\>>19.64>>|<row|<cell|010<math|\<rightarrow\>>5.87>|<cell|00111<math|\<rightarrow\>>13.18>|<cell|100111<math|\<rightarrow\>>16.52>|<cell|1111001<math|\<rightarrow\>>19.64>>|<row|<cell|101<math|\<rightarrow\>>5.87>|<cell|11000<math|\<rightarrow\>>13.18>|<cell|111001<math|\<rightarrow\>>16.52>|<cell|0101110<math|\<rightarrow\>>19.68>>|<row|<cell|0000<math|\<rightarrow\>>8.64>|<cell|11100<math|\<rightarrow\>>13.18>|<cell|001101<math|\<rightarrow\>>16.59>|<cell|0111010<math|\<rightarrow\>>19.68>>|<row|<cell|1111<math|\<rightarrow\>>8.64>|<cell|01110<math|\<rightarrow\>>13.39>|<cell|010011<math|\<rightarrow\>>16.59>|<cell|1000101<math|\<rightarrow\>>19.68>>|<row|<cell|0001<math|\<rightarrow\>>9.02>|<cell|10001<math|\<rightarrow\>>13.39>|<cell|101100<math|\<rightarrow\>>16.59>|<cell|1010001<math|\<rightarrow\>>19.68>>|<row|<cell|0111<math|\<rightarrow\>>9.02>|<cell|000000<math|\<rightarrow\>>14.80>|<cell|110010<math|\<rightarrow\>>16.59>|<cell|0010001<math|\<rightarrow\>>20.04>>|<row|<cell|1000<math|\<rightarrow\>>9.02>|<cell|111111<math|\<rightarrow\>>14.80>|<cell|001100<math|\<rightarrow\>>16.62>|<cell|0111011<math|\<rightarrow\>>20.04>>|<row|<cell|1110<math|\<rightarrow\>>9.02>|<cell|000001<math|\<rightarrow\>>15.64>|<cell|110011<math|\<rightarrow\>>16.62>|<cell|1000100<math|\<rightarrow\>>20.04>>|<row|<cell|0101<math|\<rightarrow\>>9.03>|<cell|011111<math|\<rightarrow\>>15.64>|<cell|011110<math|\<rightarrow\>>16.66>|<cell|1101110<math|\<rightarrow\>>20.04>>|<row|<cell|1010<math|\<rightarrow\>>9.03>|<cell|100000<math|\<rightarrow\>>15.64>|<cell|100001<math|\<rightarrow\>>16.66>|<cell|0001001<math|\<rightarrow\>>20.09>>|<row|<cell|0010<math|\<rightarrow\>>9.04>|<cell|111110<math|\<rightarrow\>>15.64>|<cell|011001<math|\<rightarrow\>>16.76>|<cell|0110111<math|\<rightarrow\>>20.09>>|<row|<cell|0100<math|\<rightarrow\>>9.04>|<cell|000010<math|\<rightarrow\>>15.73>|<cell|100110<math|\<rightarrow\>>16.76>|<cell|1001000<math|\<rightarrow\>>20.09>>|<row|<cell|1011<math|\<rightarrow\>>9.04>|<cell|010000<math|\<rightarrow\>>15.73>|<cell|000101<math|\<rightarrow\>>16.80>|<cell|1110110<math|\<rightarrow\>>20.09>>|<row|<cell|1101<math|\<rightarrow\>>9.04>|<cell|101111<math|\<rightarrow\>>15.73>|<cell|010111<math|\<rightarrow\>>16.80>|<cell|0010010<math|\<rightarrow\>>20.11>>|<row|<cell|0110<math|\<rightarrow\>>9.26>|<cell|111101<math|\<rightarrow\>>15.73>|<cell|101000<math|\<rightarrow\>>16.80>|<cell|0100100<math|\<rightarrow\>>20.11>>|<row|<cell|1001<math|\<rightarrow\>>9.26>|<cell|010010<math|\<rightarrow\>>15.93>|<cell|111010<math|\<rightarrow\>>16.80>|<cell|1011011<math|\<rightarrow\>>20.11>>|<row|<cell|0011<math|\<rightarrow\>>9.28>|<cell|101101<math|\<rightarrow\>>15.93>|<cell|001110<math|\<rightarrow\>>16.96>|<cell|1101101<math|\<rightarrow\>>20.11>>|<row|<cell|1100<math|\<rightarrow\>>9.28>|<cell|010101<math|\<rightarrow\>>16.02>|<cell|011100<math|\<rightarrow\>>16.96>|<cell|0010101<math|\<rightarrow\>>20.15>>|<row|<cell|00000<math|\<rightarrow\>>11.79>|<cell|101010<math|\<rightarrow\>>16.02>|<cell|100011<math|\<rightarrow\>>16.96>|<cell|0101011<math|\<rightarrow\>>20.15>>|<row|<cell|11111<math|\<rightarrow\>>11.79>|<cell|010110<math|\<rightarrow\>>16.10>|<cell|110001<math|\<rightarrow\>>16.96>|<cell|1010100<math|\<rightarrow\>>20.15>>|<row|<cell|00001<math|\<rightarrow\>>12.51>|<cell|011010<math|\<rightarrow\>>16.10>|<cell|001011<math|\<rightarrow\>>17.23>|<cell|1101010<math|\<rightarrow\>>20.15>>|<row|<cell|01111<math|\<rightarrow\>>12.51>|<cell|100101<math|\<rightarrow\>>16.10>|<cell|110100<math|\<rightarrow\>>17.23>|<cell|0100101<math|\<rightarrow\>>20.16>>|<row|<cell|10000<math|\<rightarrow\>>12.51>|<cell|101001<math|\<rightarrow\>>16.10>|<cell|000111<math|\<rightarrow\>>17.29>|<cell|0101101<math|\<rightarrow\>>20.16>>|<row|<cell|11110<math|\<rightarrow\>>12.51>|<cell|001010<math|\<rightarrow\>>16.12>|<cell|111000<math|\<rightarrow\>>17.29>|<cell|1010010<math|\<rightarrow\>>20.16>>|<row|<cell|00010<math|\<rightarrow\>>12.55>|<cell|010100<math|\<rightarrow\>>16.12>|<cell|0000000<math|\<rightarrow\>>18.03>|<cell|1011010<math|\<rightarrow\>>20.16>>|<row|<cell|01000<math|\<rightarrow\>>12.55>|<cell|101011<math|\<rightarrow\>>16.12>|<cell|1111111<math|\<rightarrow\>>18.03>|<cell|0001010<math|\<rightarrow\>>20.22>>|<row|<cell|10111<math|\<rightarrow\>>12.55>|<cell|110101<math|\<rightarrow\>>16.12>|<cell|0101010<math|\<rightarrow\>>18.68>|<cell|0101000<math|\<rightarrow\>>20.22>>|<row|<cell|11101<math|\<rightarrow\>>12.55>|<cell|000100<math|\<rightarrow\>>16.15>|<cell|1010101<math|\<rightarrow\>>18.68>|<cell|1010111<math|\<rightarrow\>>20.22>>|<row|<cell|00100<math|\<rightarrow\>>12.69>|<cell|001000<math|\<rightarrow\>>16.15>|<cell|0000001<math|\<rightarrow\>>18.92>|<cell|1110101<math|\<rightarrow\>>20.22>>|<row|<cell|11011<math|\<rightarrow\>>12.69>|<cell|110111<math|\<rightarrow\>>16.15>|<cell|0111111<math|\<rightarrow\>>18.92>|<cell|0100001<math|\<rightarrow\>>20.26>>|<row|<cell|01001<math|\<rightarrow\>>12.76>|<cell|111011<math|\<rightarrow\>>16.15>|<cell|1000000<math|\<rightarrow\>>18.92>|<cell|0111101<math|\<rightarrow\>>20.26>>|<row|<cell|01101<math|\<rightarrow\>>12.76>|<cell|001001<math|\<rightarrow\>>16.38>|<cell|1111110<math|\<rightarrow\>>18.92>|<cell|1000010<math|\<rightarrow\>>20.26>>|<row|<cell|10010<math|\<rightarrow\>>12.76>|<cell|011011<math|\<rightarrow\>>16.38>|<cell|0000010<math|\<rightarrow\>>19.10>|<cell|1011110<math|\<rightarrow\>>20.26>>>>>

    <label|default>
  </big-table|Top 180 strings sorted from lowest to highest algorithmic
  complexity calculated from <math|D<around|(|4|)>> by applying the coding
  theorem.>

  The largest complexity value <math|max <around|{|C<around|(|s|)>:s\<in\>D<around|(|4|)>|}>=29>
  bits. The output strings (11111111111101 and 10111111111111) produced by
  the busy beavers in (4,2) were close to the maximal complexity in this
  space for the number of printed 1s among all the produced strings, with a
  program-size complexity of 28 bits.

  <big-figure|<label|frequencyprobability><with|par-mode|center|<scalebox|.8|<image|frequencyprobability.eps||||>>
  >|(4,2) output log-frequency plot, ordered from most to less frequent
  string, the slope is clearly exponential.>

  <subsubsection|Same length string complexity>

  The classification table 10 allows to make a comparison of the structure of
  the strings related to their calculated complexity among all the strings of
  the same length extracted from <math|D<around|(|4|)>>.

  <\big-table>
    <label|thetable>

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|32|32|1|-1|cell-bborder|1ln>|<table|<row|<cell|0000000<math|\<rightarrow\>>18.03>|<cell|1001000<math|\<rightarrow\>>20.09>|<cell|0101001<math|\<rightarrow\>>20.42>|<cell|0000111<math|\<rightarrow\>>20.99>>|<row|<cell|1111111<math|\<rightarrow\>>18.03>|<cell|1110110<math|\<rightarrow\>>20.09>|<cell|0110101<math|\<rightarrow\>>20.42>|<cell|0001111<math|\<rightarrow\>>20.99>>|<row|<cell|0101010<math|\<rightarrow\>>18.68>|<cell|0010010<math|\<rightarrow\>>20.11>|<cell|1001010<math|\<rightarrow\>>20.42>|<cell|1110000<math|\<rightarrow\>>20.99>>|<row|<cell|1010101<math|\<rightarrow\>>18.68>|<cell|0100100<math|\<rightarrow\>>20.11>|<cell|1010110<math|\<rightarrow\>>20.42>|<cell|1111000<math|\<rightarrow\>>20.99>>|<row|<cell|0000001<math|\<rightarrow\>>18.92>|<cell|1011011<math|\<rightarrow\>>20.11>|<cell|0001100<math|\<rightarrow\>>20.48>|<cell|0011110<math|\<rightarrow\>>21.00>>|<row|<cell|0111111<math|\<rightarrow\>>18.92>|<cell|1101101<math|\<rightarrow\>>20.11>|<cell|0011000<math|\<rightarrow\>>20.48>|<cell|0111100<math|\<rightarrow\>>21.00>>|<row|<cell|1000000<math|\<rightarrow\>>18.92>|<cell|0010101<math|\<rightarrow\>>20.15>|<cell|1100111<math|\<rightarrow\>>20.48>|<cell|1000011<math|\<rightarrow\>>21.00>>|<row|<cell|1111110<math|\<rightarrow\>>18.92>|<cell|0101011<math|\<rightarrow\>>20.15>|<cell|1110011<math|\<rightarrow\>>20.48>|<cell|1100001<math|\<rightarrow\>>21.00>>|<row|<cell|0000010<math|\<rightarrow\>>19.10>|<cell|1010100<math|\<rightarrow\>>20.15>|<cell|0110110<math|\<rightarrow\>>20.55>|<cell|0111110<math|\<rightarrow\>>21.03>>|<row|<cell|0100000<math|\<rightarrow\>>19.10>|<cell|1101010<math|\<rightarrow\>>20.15>|<cell|1001001<math|\<rightarrow\>>20.55>|<cell|1000001<math|\<rightarrow\>>21.03>>|<row|<cell|1011111<math|\<rightarrow\>>19.10>|<cell|0100101<math|\<rightarrow\>>20.16>|<cell|0011010<math|\<rightarrow\>>20.63>|<cell|0011001<math|\<rightarrow\>>21.06>>|<row|<cell|1111101<math|\<rightarrow\>>19.10>|<cell|0101101<math|\<rightarrow\>>20.16>|<cell|0101100<math|\<rightarrow\>>20.63>|<cell|0110011<math|\<rightarrow\>>21.06>>|<row|<cell|0000100<math|\<rightarrow\>>19.38>|<cell|1010010<math|\<rightarrow\>>20.16>|<cell|1010011<math|\<rightarrow\>>20.63>|<cell|1001100<math|\<rightarrow\>>21.06>>|<row|<cell|0010000<math|\<rightarrow\>>19.38>|<cell|1011010<math|\<rightarrow\>>20.16>|<cell|1100101<math|\<rightarrow\>>20.63>|<cell|1100110<math|\<rightarrow\>>21.06>>|<row|<cell|1101111<math|\<rightarrow\>>19.38>|<cell|0001010<math|\<rightarrow\>>20.22>|<cell|0100010<math|\<rightarrow\>>20.68>|<cell|0001110<math|\<rightarrow\>>21.08>>|<row|<cell|1111011<math|\<rightarrow\>>19.38>|<cell|0101000<math|\<rightarrow\>>20.22>|<cell|1011101<math|\<rightarrow\>>20.68>|<cell|0111000<math|\<rightarrow\>>21.08>>|<row|<cell|0001000<math|\<rightarrow\>>19.45>|<cell|1010111<math|\<rightarrow\>>20.22>|<cell|0100110<math|\<rightarrow\>>20.77>|<cell|1000111<math|\<rightarrow\>>21.08>>|<row|<cell|1110111<math|\<rightarrow\>>19.45>|<cell|1110101<math|\<rightarrow\>>20.22>|<cell|0110010<math|\<rightarrow\>>20.77>|<cell|1110001<math|\<rightarrow\>>21.08>>|<row|<cell|0000110<math|\<rightarrow\>>19.64>|<cell|0100001<math|\<rightarrow\>>20.26>|<cell|1001101<math|\<rightarrow\>>20.77>|<cell|0010011<math|\<rightarrow\>>21.10>>|<row|<cell|0110000<math|\<rightarrow\>>19.64>|<cell|0111101<math|\<rightarrow\>>20.26>|<cell|1011001<math|\<rightarrow\>>20.77>|<cell|0011011<math|\<rightarrow\>>21.10>>|<row|<cell|1001111<math|\<rightarrow\>>19.64>|<cell|1000010<math|\<rightarrow\>>20.26>|<cell|0010110<math|\<rightarrow\>>20.81>|<cell|1100100<math|\<rightarrow\>>21.10>>|<row|<cell|1111001<math|\<rightarrow\>>19.64>|<cell|1011110<math|\<rightarrow\>>20.26>|<cell|0110100<math|\<rightarrow\>>20.81>|<cell|1101100<math|\<rightarrow\>>21.10>>|<row|<cell|0101110<math|\<rightarrow\>>19.68>|<cell|0000101<math|\<rightarrow\>>20.29>|<cell|1001011<math|\<rightarrow\>>20.81>|<cell|0110001<math|\<rightarrow\>>21.13>>|<row|<cell|0111010<math|\<rightarrow\>>19.68>|<cell|0101111<math|\<rightarrow\>>20.29>|<cell|1101001<math|\<rightarrow\>>20.81>|<cell|0111001<math|\<rightarrow\>>21.13>>|<row|<cell|1000101<math|\<rightarrow\>>19.68>|<cell|1010000<math|\<rightarrow\>>20.29>|<cell|0001101<math|\<rightarrow\>>20.87>|<cell|1000110<math|\<rightarrow\>>21.13>>|<row|<cell|1010001<math|\<rightarrow\>>19.68>|<cell|1111010<math|\<rightarrow\>>20.29>|<cell|0100111<math|\<rightarrow\>>20.87>|<cell|1001110<math|\<rightarrow\>>21.13>>|<row|<cell|0010001<math|\<rightarrow\>>20.04>|<cell|0000011<math|\<rightarrow\>>20.38>|<cell|1011000<math|\<rightarrow\>>20.87>|<cell|0011100<math|\<rightarrow\>>21.19>>|<row|<cell|0111011<math|\<rightarrow\>>20.04>|<cell|0011111<math|\<rightarrow\>>20.38>|<cell|1110010<math|\<rightarrow\>>20.87>|<cell|1100011<math|\<rightarrow\>>21.19>>|<row|<cell|1000100<math|\<rightarrow\>>20.04>|<cell|1100000<math|\<rightarrow\>>20.38>|<cell|0011101<math|\<rightarrow\>>20.93>|<cell|0001011<math|\<rightarrow\>>21.57>>|<row|<cell|1101110<math|\<rightarrow\>>20.04>|<cell|1111100<math|\<rightarrow\>>20.38>|<cell|0100011<math|\<rightarrow\>>20.93>|<cell|0010111<math|\<rightarrow\>>21.57>>|<row|<cell|0001001<math|\<rightarrow\>>20.09>|<cell|0010100<math|\<rightarrow\>>20.39>|<cell|1011100<math|\<rightarrow\>>20.93>|<cell|1101000<math|\<rightarrow\>>21.57>>|<row|<cell|0110111<math|\<rightarrow\>>20.09>|<cell|1101011<math|\<rightarrow\>>20.39>|<cell|1100010<math|\<rightarrow\>>20.93>|<cell|1110100<math|\<rightarrow\>>21.57>>>>>

    <label|default>
  </big-table|Classification--from less to more random--for 7-bit strings
  extracted from <math|D<around|(|4|)>>.>

  <subsubsection|Halting summary>

  <\big-figure>
    <label|stringlengthprobability>

    <scalebox|.55|<image|haltingprobability.eps||||>>
    <scalebox|.5|<image|haltingsummary.eps||||>>

    \;
  </big-figure|Graphs showing the halting probabilities among (n,2),
  <math|n\<less\>5>. The list plot on the left shows the decreasing
  probability of the number of halting Turing machines while the paired bar
  chart on the right allows a visual comparison between both halting and
  non-halting machines side by side.>

  In summary, among the (running over a tape filled with 0 only): 12,
  3<space|0.17em>044, 2<space|0.17em>147<space|0.17em>184 and
  2<space|0.17em>985<space|0.17em>384<space|0.17em>480 Turing machines in
  (n,2), <math|n\<less\>5>, there were 36, 10<space|0.17em>000,
  7<space|0.17em>529<space|0.17em>536 and
  11<space|0.17em>019<space|0.17em>960<space|0.17em>576 that halted, that is
  slightly decreasing fractions of 0.333..., 0.3044, 0.2851 and 0.2709
  respectively.<next-line>

  <no-indent>Full results can be found online at
  <slink|http://www.mathrix.org/experimentalAIT/>

  <subsection|Runtimes investigation>

  Runtimes much longer than the lengths of their respective halting programs
  are rare and the empirical distribution approaches the <em|a priori>
  computable probability distribution on all possible runtimes predicted in
  <cite|calude>. As reported in <cite|calude> \Plong\Q runtimes are
  effectively rare. The longer it takes to halt, the less likely it is to
  stop.

  <big-figure|<with|par-mode|center|<scalebox|.6|<image|runtimeprobability.eps||||>>
  >|Runtimes distribution in (4,2).>

  <\big-table>
    \;

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|9|9|cell-halign|c>|<cwith|1|-1|9|9|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<cwith|12|12|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|<math|t=1>>|<cell|<math|t=2>>|<cell|<math|t=3>>|<cell|<math|t=4>>|<cell|<math|t=5>>|<cell|<math|t=6>>|<cell|<math|t=7>>|<cell|>>|<row|<cell|<with|font-size|1|n=1>>|<cell|1.0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|n=2>>|<cell|0>|<cell|1.0>|<cell|0.60>|<cell|0.45>|<cell|0.21>|<cell|0.11>|<cell|0.052>|<cell|0.025>>|<row|<cell|<with|font-size|1|n=3>>|<cell|0>|<cell|0>|<cell|0.40>|<cell|0.46>|<cell|0.64>|<cell|0.57>|<cell|0.50>|<cell|0.36>>|<row|<cell|<with|font-size|1|n=4>>|<cell|0>|<cell|0>|<cell|0>|<cell|0.092>|<cell|0.15>|<cell|0.29>|<cell|0.39>|<cell|0.45>>|<row|<cell|<with|font-size|1|n=5>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0.034>|<cell|0.055>|<cell|0.16>>|<row|<cell|<with|font-size|1|n=6>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0.0098>>|<row|<cell|<with|font-size|1|n=7>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|n=8>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|n=9>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|n=10>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|Total>>|<cell|1>|<cell|1>|<cell|1>|<cell|1>|<cell|1>|<cell|1>|<cell|1>|<cell|1>>>>>

    <label|default>
  </big-table|Probability that a n-bit string among all <math|n\<less\>10>
  bit strings is produced at times <math|t\<less\>8>.>

  <\big-table>
    \;

    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|8|8|cell-rborder|1ln>|<cwith|1|-1|9|9|cell-halign|c>|<cwith|1|-1|9|9|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<cwith|12|12|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|<math|t=1>>|<cell|<math|t=2>>|<cell|<math|t=3>>|<cell|<math|t=4>>|<cell|<math|t=5>>|<cell|<math|t=6>>|<cell|<math|t=7>>|<cell|Total>>|<row|<cell|<with|font-size|1|n=1>>|<cell|0.20>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0.20>>|<row|<cell|<with|font-size|1|n=2>>|<cell|0>|<cell|0.14>|<cell|0.046>|<cell|0.016>|<cell|0.0045>|<cell|0.0012>|<cell|0.00029>|<cell|0.20>>|<row|<cell|<with|font-size|1|n=3>>|<cell|0>|<cell|0>|<cell|0.030>|<cell|0.017>|<cell|0.014>|<cell|0.0063>|<cell|0.0028>|<cell|0.070>>|<row|<cell|<with|font-size|1|n=4>>|<cell|0>|<cell|0>|<cell|0>|<cell|0.0034>|<cell|0.0032>|<cell|0.0031>|<cell|0.0022>|<cell|0.012>>|<row|<cell|<with|font-size|1|n=5>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0.00037>|<cell|0.00031>|<cell|0.00069>>|<row|<cell|<with|font-size|1|n=6>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|n=7>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|n=8>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|n=9>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|n=10>>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<with|font-size|1|Total>>|<cell|0.21>|<cell|0.14>|<cell|0.076>|<cell|0.037>|<cell|0.021>|<cell|0.011>|<cell|0.0057>|<cell|>>>>>

    <label|default>
  </big-table|Probability that a n-bit string with <math|n\<less\>10> is
  produced at time <math|t\<less\>7>.>

  <no-indent>Among the various miscellaneous facts from these results:

  <\myitemize>
    <item>All 1-bit strings were produced at <math|t=1>.

    <item>2-bit strings were produced at all <math|2\<less\>t\<less\>14>
    times.

    <item><math|t=3> was the time at which the first 2 bit strings of
    different lengths were produced (<math|n=2> and <math|n=3>).

    <item>Strings produced before 8 steps account for 49% of the strings
    produced by all (4,2) halting machines.

    <item>There were 496 string groups produced by (4,2), that is strings
    that are not symmetric under reversion or complementation.

    <item>There is a relation between t and n; no n-bit string is produced
    before <math|t\<less\>n>. This is obvious because a machine needs at
    least t steps to print t symbols.

    <item>At every time t there was at least one string of length n for
    <math|1\<less\>n\<less\>t>.
  </myitemize>

  <section|Discussion>

  Intuitively, one may be persuaded to assign a lower or higher algorithmic
  complexity to some strings when looking at tables 9 and 10, because they
  may seem simpler or more random than others of the same length. We think
  that very short strings may appear to be more or less random but may be as
  hard to produce as others of the same length, because Turing machines
  producing them may require the same quantity of resources to print them out
  and halt as they would with others of the same (very short) length.

  For example, is 0101 more or less complex than 0011? Is 001 more or less
  complex than 010? The string 010 may seem simpler than 001 to us because we
  may picture it as part of a larger sequence of alternating bits, forgetting
  that such is not the case and that 010 actually was the result of a machine
  that produced it when entering into the halting state, using this extra
  state to somehow delimit the length of the string. No satisfactory argument
  may exist to say whether 010 is really more or less random than 001, other
  than actually running the machines and looking at their objective ranking
  according to the formalism and method described herein. The situation
  changes for larger strings, when an alternating string may in effect
  strongly suggest that it should be less random than other strings because a
  short description is possible in terms of the simple alternation of bits.
  Some strings may also assume their correct rank when the calculation is
  taken further, for example if we were able to compute
  <math|D<around|(|5|)>>.

  On the other hand, it may seem odd that the program size complexity of a
  string of length <math|l> is systematically larger than <math|l> when
  <math|l> can be produced by a <em|print> function of length l+{the length
  of the print program}, and indeed one can interpret the results exactly in
  this way. The surplus can be interpreted as a constant product of a
  <em|print> phenomenon which is particularly significant for short strings.
  But since it is a constant, one can subtract it from all the strings. For
  example, subtracting 1 from all values brings the complexity results for
  the shortest strings to exactly their size, which is what one would expect
  from the values for algorithmic complexity. On the other hand, subtracting
  the constant preserves the relative order, even if larger strings continue
  having algorithmic complexity values larger than their lengths. What we
  provide herein, besides the numerical values, is a hierarchical structure
  from which one can tell whether a string is of greater, lesser or equal
  algorithmic complexity.

  The <em|print program> assumes the implicit programming of the halting
  configuration. In C language, for example, this is delimited by the
  semicolon. The fact then that a single bit string requires a 2 bit
  \Pprogram\Q may be interpreted as the additional information represented by
  the length of the string; the fact that a string is of length n is not the
  result of an arbitrary decision but it is encoded in the producing machine.
  In other words, the string not only carries the information of its n bits,
  but also of the delimitation of its length. This is different to, for
  example, approaching the algorithmic complexity by means of cellular
  automata\Uthere being no encoded halting state, one has to manually stop
  the computation upon producing a string of a certain arbitrary length
  according to an arbitrary stopping time. This is a research program that we
  have explored before<cite|zenildelahaye> and that we may analyze in further
  detail somewhere else.

  It is important to point out that after the application of the coding
  theorem one often gets a non-integer value when calculating
  <math|C<around|(|s|)>> from <math|m<around|(|s|)>>. Even though when
  interpreted as the size in bits of the program produced by a Turing machine
  should be taken to its closest integer value (or the ceiling value) because
  the size of a program can only be given in an integer number of bits. The
  non-integer values are, however, useful to provide a finer structure
  providing information on the exact places in which strings have been
  ranked.

  An open question is how much of the relative string order (hence the
  relative algorithmic probability and the relative algorithmic complexity)
  of <math|D<around|(|n|)>> will be preserved when calculating
  <math|D<around|(|i|)>> for larger Turing machine spaces such that
  <math|0\<less\>n\<less\>i>. As reported here, <math|D<around|(|n|)>>
  preserves most of the string orders of <math|D*<around|(|n-1|)>> for
  <math|1\<less\>n\<less\>5>. While each space (n,2) contains all (n-1,2)
  machines, the exponential increase in number of machines when adding states
  may easily produce strings such that the order of the previous distribution
  is changed. What the results presented here show, however, is that each new
  space of larger machines contributes in the same proportion to the number
  of strings produced in the smaller spaces, in such a way that they preserve
  much of the previous string order of the distributions of smaller spaces,
  as shown by calculating the Spearman coefficient indicating a very strong
  ranking correlation. In fact, some of the ranking variability between the
  distributions of spaces of machines with different numbers of states
  occurred later in the classification, likely due to the fact that the
  smaller spaces missed the production of some strings. For example, the
  first rank difference between <math|D<around|(|3|)>> and
  <math|D<around|(|4|)>> occurred in place 20, meaning that the string order
  in <math|D<around|(|3|)>> was strictly preserved in <math|D<around|(|4|)>>
  up to the top 20 strings sorted from higher to lower frequency. Moreover,
  one may ask whether the actual frequency values of the strings converge.

  <section|Concluding remarks><label|conclusions>

  We have provided numerical tables with values of the algorithmic complexity
  for short strings. The experimental approach for calculating
  <math|D<around|(|n|)>> gives us valuable insights into the structure of a
  real calculated algorithmic complexity structure giving rise to theoretical
  questions and potential practical applications. On the one hand, the
  calculation of <math|D<around|(|n|)>> provides an empirical and
  <em|natural> distribution that does not depend on an additive constant and
  may be used in Bayesian contexts as a prior distribution. On the other
  hand, it might turn out to have valuable applications, especially because
  of the known issues explained in <reference|overview> related to the
  problem of approaching the complexity of short strings by means of
  compression algorithms often failing for short strings.

  The presented approach provides numerical evaluations of <math|C> using the
  same formalism of Turing machines as defined by Rado in his busy beaver
  problem<cite|rado> and described in <reference|beaver>. This direct
  approach by way of algorithmic probability reduces the impact of the
  additive constant involved in the choice of computing model (or programming
  language), shedding light on the behavior of small Turing machines and
  tangibly grasping the concept of the algorithmic complexity of a string by
  exposing its structure on the basis of a complexity ranking.

  To our knowledge this is the first time that numerical values of
  algorithmic complexity are provided and tabulated. We wanted to provide a
  table of values useful for several purposes, both to make conjectures about
  the continuation of the distribution\Uperhaps providing a statistical
  framework for a statistical calculation of the algorithmic complexity for
  longer strings\Uas well as to shed light on both the behavior of small
  Turing machines and the use of empirical approaches for practical
  applications of algorithmic complexity to the real-world.<footnote|For
  example, the authors of this paper have undertaken efforts to characterize
  and classify images by their complexity<cite|zenil>, for which these tables
  may be of great use.> The full results and complete tables are available
  online available at <slink|http://www.mathrix.org/experimentalAIT/>

  <\thebibliography|99>
    <bibitem|brady>A. H. Brady, The Determination of the Value of Rado's
    Noncomputable Function <math|<big|sum><around|(|k|)>> for Four-State
    Turing Machines. <em|Math. Comput.> 40, 647-665,
    1983.<bibitem|delahayezenil>J-P. Delahaye and H. Zenil, On the
    Kolmogorov-Chaitin complexity for short sequences. in C.S. Calude (ed.)
    <em|Randomness and Complexity: From Leibniz to Chaitin.> World
    Scientific, 2007.<bibitem|chaitin>G.J. Chaitin, <em|Algorithmic
    Information Theory.> Cambridge University Press,
    1987.<bibitem|chaitin2>G.J. Chaitin, Computing the busy beaver function,
    in: T.M. Cover, B. Gopinath (Eds.), <em|Open Problems in Communication
    and Computation>, Springer-Verlag, Heidelberg, pp.108\U112,
    1987<bibitem|calude>C.S. Calude, <em|Information and Randomness: An
    Algorithmic Perspective.> (Texts in Theoretical Computer Science. An
    EATCS Series), Springer; 2nd. edition, 2002.<bibitem|calude2>C.S. Calude
    and M.A. Stay, <em|Most programs stop quickly or never halt, Advances in
    Applied Mathematics,> 40 295\U308, 2005.<bibitem|caludeomega>C.S. Calude,
    M.J. Dinneen, and C-K. Shu, <em|Computing a glimpse of randomness>,
    Experimental Mathematics, 11(2): 369-378, 2002.<bibitem|hertel>J. Hertel,
    <em|Computing the Uncomputable Rado Sigma Function: An Automated,
    Symbolic Induction Prover for Nonhalting Turing Machines>, The
    Mathematica Journal 11:2 2009.<bibitem|holkner>A. Holkner,
    <em|Acceleration Techniques for Busy Beaver Candidates>, Proceedings of
    the Second Australian Undergraduate Students' Computing Conference,
    2004.<bibitem|stout>Q.F. Stout, The Complex Behaviour Of Simple
    Machines<bibitem|kirchherr>W. Kirchherr, M. Li and P. Vitanyi, <em|The
    miraculous universal distribution>, Math. Intelligencer. 19(4), 7\U15,
    1997.<bibitem|kolmogorov>A. N. Kolmogorov. <em|Three approaches to the
    quantitative definition of information>. Problems of Information and
    Transmission, 1(1): 1\U7, 1965.<bibitem|lempel>A. Lempel and J. Ziv,
    <em|On the Complexity of Finite Sequences>, IEEE Trans. Inform. Theory,
    22(1), pp. 75-81, 1976.<bibitem|levin>L. Levin, <em|Laws of information
    conservation (non-growth) and aspects of the foundation of probability
    theory.> Problems In Form. Transmission 10, 206\U210,
    1974.<bibitem|levin2>L. Levin, <em|On a Concrete Method of Assigning
    Complexity Measures>, Doklady Akademii nauk SSSR, vol.18(3), pp. 727-731,
    1977.<bibitem|levin3>L. Levin. <em|Universal Search Problems.> 9(3):
    265-266, 1973 (c). (submitted: 1972, reported in talks: 1971). English
    translation in: B.A.Trakhtenbrot. <em|A Survey of Russian Approaches to
    Perebor (Brute-force Search) Algorithms.> Annals of the History of
    Computing 6(4): 384-400, 1984.<bibitem|li>M. Li, P. Vitnyi, <em|An
    Introduction to Kolmogorov Complexity and Its Applications,>, Springer,
    3rd. Revised edition, 2008.<bibitem|lin>S. Lin and T. Rado, <em|Computer
    Studies of Turing Machine Problems>, J. ACM. 12, 196\U212,
    1965.<bibitem|machlin>R. Machlin, and Q. F. Stout, The Complex Behavior
    of Simple Machines. <em|Physica 42D.> 85-98, 1990.<bibitem|marxen>H.
    Marxen and J. Buntrock. <em|Attacking the busy beaver 5>, Bull EATCS 40,
    247\U251, 1990.<bibitem|rado>T. Rado, <em|On noncomputable Functions>,
    <em|Bell System Technical J.> 41, 877\U884, May
    1962.<bibitem|solomonoff>R. Solomonoff, <em|A Preliminary Report on a
    General Theory of Inductive Inference.> (Revision of Report V-131),
    Contract AF 49(639)-376, Report ZTB\U138, Zator Co., Cambridge, Mass.,
    Nov, 1960.<bibitem|speidel>U. Speidel, <em|A note on the estimation of
    string complexity for short strings>, 7th International Conference on
    Information, Communications and Signal Processing (ICICS),
    2009.<bibitem|turing>A.M. Turing, <em|On Computable Numbers, with an
    Application to the Entscheidungsproblem>, Proceedings of the London
    Mathematical Society. 2 42: 230\U65, 1936, published in
    1937.<bibitem|wolfram>S. Wolfram, <em|A New Kind of Science>, Wolfram
    Media, 2002.<bibitem|zenildelahaye>H. Zenil and J.P. Delahaye, \POn the
    Algorithmic Nature of the World," in Gordana Dodig-Crnkovic and Mark
    Burgin (eds), <em|Information and Computation>, World Scientific,
    2010.<bibitem|zenil>H. Zenil, J.P. Delahaye and C. Gaucherel,
    <em|Information content characterization and classification of images by
    physical complexity,> arXiv: 1006.0051v1 [cs.CC].<bibitem|busyhz>H.
    Zenil, <em|busy beaver>, from The Wolfram Demonstrations
    Project,<next-line><slink|http://demonstrations.wolfram.com/BusyBeaver/>.
  </thebibliography>
</body>