<TeXmacs|1.99.7>

<style|<tuple|generic|cite-author-year|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|thm|Theorem>

    <new-theorem|cor|Corollary>

    <new-theorem|lem|Lemma>

    <new-theorem|prop|Proposition>

    <new-theorem|defn|Definition>

    <new-theorem|nota|Notation>

    <new-theorem|ass|Assumption>

    <new-theorem|asss|Assumptions>

    <new-theorem|rem|Remark>

    <new-theorem|exa|Example>

    <new-theorem|que|Question>

    <assign|norm|<macro|1|<left|\|\|><arg|1><right|\|\|>>>

    <assign|abs|<macro|1|<left|\|><arg|1><right|\|>>>

    <assign|set|<macro|1|<left|{><arg|1><right|}>>>

    <assign|Real|<macro|\<bbb-R\>>>

    <assign|Natural|<macro|\<bbb-N\>>>

    <assign|eps|<macro|\<varepsilon\>>>

    <assign|To|<macro|\<longrightarrow\>>>

    <assign|BX|<macro|<math-bf|B>(X)>>

    <assign|A|<macro|\<cal-A\>>>

    <assign|such|<macro|<space|0.17em> \| <space|0.17em> >>

    <assign|prob|<macro|\<bbb-P\>>>

    <assign|Exp|<macro|\<cal-E\>>>

    <assign|parti|<macro|\<bbb-T\>>>

    <assign|Time|<macro|\<frak-T\>>>

    <assign|Timestar|<macro|<Time>[0, \<tau\><rsup|*>]>>

    <assign|oTime|<macro|<wide|<Time>|\<bar\>>>>

    <assign|oE|<macro|<wide|E|\<bar\>>>>

    <assign|ove|<macro|<wide|e|\<bar\>>>>

    <assign|qprob|<macro|\<bbb-Q\>>>

    <assign|expec|<macro|\<bbb-E\>>>

    <assign|expecp|<macro|<expec><rsub|<prob>>>>

    <assign|expecq|<macro|<expec><rsub|<qprob>>>>

    <assign|var|<macro|<math-up|var>>>

    <assign|cov|<macro|<math-up|cov>>>

    <assign|corr|<macro|<math-up|cor>>>

    <assign|probtriple|<macro|(\<Omega\>, \<cal-F\>, <prob>)>>

    <assign|basis|<macro|(\<Omega\>, <space|0.17em> (<F><rsub|t>)<rsub|t
    \<in\><Real><rsub|+>>, <space|0.17em> <prob>)>>

    <assign|filtration|<macro|<math-bf|F> = <pare|\<cal-F\><rsub|t>><rsub|t
    \<in\><Real><rsub|+>>>>

    <assign|F|<macro|\<cal-F\>>>

    <assign|G|<macro|\<cal-G\>>>

    <assign|B|<macro|\<cal-B\>>>

    <assign|cadlag|<macro|cdlg>>

    <assign|caglad|<macro|cgld>>

    <assign|ud|<macro|<math-up|d>>>

    <assign|inner|<macro|1|2|<left|langle><arg|1> , <arg|2> <right|rangle>>>

    <assign|liminfn|<macro|liminf<rsub|n \<to\>\<infty\>>>>

    <assign|limsupn|<macro|limsup<rsub|n \<to\>\<infty\>>>>

    <assign|limT|<macro|lim<rsub|T \<to\>\<infty\>>>>

    <assign|plim|<macro|<prob><with|font-family|rm|-> lim>>

    <assign|plimT|<macro|<plim><rsub|T \<to\>\<infty\>>>>

    <assign|ttau|<macro|<wide|\<tau\>|~>>>

    <assign|otau|<macro|<wide|\<tau\>|\<bar\>>>>

    <assign|uS|<macro|<wide*|S|\<bar\>>>>

    <assign|oS|<macro|<wide|S|\<bar\>>>>

    <assign|uC|<macro|<wide*|\<cal-C\>|\<bar\>>>>

    <assign|oC|<macro|<wide|\<cal-C\>|\<bar\>>>>

    <assign|pare|<macro|1|<left|(><arg|1><right|)>>>

    <assign|bra|<macro|1|<left|[><arg|1><right|]>>>

    <assign|dbra|<macro|1|[<kern>-0.15em[ <arg|1> ]<kern>-0.15em]>>

    <assign|dbraco|<macro|1|[<kern>-0.15em[ <arg|1> [<kern>-0.15em[>>

    <assign|dbraoc|<macro|1|]<kern>-0.15em] <arg|1> ]<kern>-0.15em]>>

    <assign|og|<macro|<wide|g|\<bar\>>>>

    <assign|dfn|<macro|<space|0.17em> := <space|0.17em>>>

    <assign|htau|<macro|<wide|\<tau\>|^>>>

    <assign|indic|<macro|1>>

    <assign|tsigma|<macro|<wide|\<sigma\>|~>>>

    <assign|wh|<macro|1|<wide|<arg|1>|^>>>

    <assign|X|<macro|\<cal-X\>>>

    <assign|C|<macro|\<cal-C\>>>

    <assign|bL|<macro|\<bbb-L\>>>

    <assign|cL|<macro|\<cal-L\>>>

    <assign|fR|<macro|\<frak-R\>>>

    <assign|ufR|<macro|<wide|\<frak-R\>|\<bar\>>>>

    <assign|lfR|<macro|<wide*|\<frak-R\>|\<bar\>>>>

    <assign|fH|<macro|\<frak-H\>>>

    <assign|cM|<macro|\<cal-M\>>>

    <assign|cB|<macro|\<cal-B\>>>

    <assign|esssup|<macro|1|esssup<rsub|<arg|1>>>>

    <assign|com|<macro|1|<with|color|blue|font-series|bold|[<arg|1>]>>>

    <assign|nada|<macro|1|>>

    <assign|tbF|<macro|<wide|<math-bf|F>|~>>>

    <assign|tF|<macro|<wide|<F>|~>>>

    <assign|tS|<macro|<wide|S|~>>>

    <assign|tX|<macro|<wide|X|~>>>

    <assign|comment|<macro|1|<with|color|blue|<with|font-series|bold|[<arg|1>]>
    >>>
  </hide-preamble>

  <doc-data|<doc-title|Abstract, Classic, and Explicit
  Turnpikes>|<doc-author|<author-data|<author-name|<fnms|Paolo>
  <snm|Guasoni><corref|><thanksref|t2><ead*|label=e1|guasoni@bu.edu>>>>|<doc-author|<author-data|<author-name|<fnms|Constantinos>
  <snm|Kardaras><thanksref|t3><ead*|label=e2|kardaras@bu.edu>>>>|<doc-author|<author-data|<author-name|<fnms|Scott>
  <snm|Robertson><ead*|label=e3|scottrob@andrew.cmu.edu>>>>|<doc-author|<author-data|<author-name|<fnms|Hao>
  <snm|Xing><ead*|label=e4|h.xing@lse.ac.uk>>>>>

  <abstract-data|<\abstract>
    Portfolio turnpikes state that, as the investment horizon increases,
    optimal portfolios for generic utilities converge to those of isoelastic
    utilities. This paper proves three kinds of turnpikes. The <em|abstract>
    turnpike, valid in a general semimartingale setting, states that final
    payoffs and portfolios converge under their myopic probabilities.
    Diffusion models with several assets and a single state variable lead to
    the <em|classic> turnpike, in which optimal portfolios converge under the
    physical probability, and to the <em|explicit turnpike>, which identifies
    the limit of optimal portfolios in terms of the solution of an ergodic
    HJB equation.
  </abstract>>

  <thispagestyle|empty>

  <section|Introduction>

  In the theory of portfolio choice, ruled by particular and complicated
  results, turnpike theorems are the happy exception \U general and simple.
  Loosely defined, these theorems state that, when the investment horizon is
  distant, the optimal portfolio of <em|any> investor approaches that of an
  investor with isoelastic utility, suggesting that <em|for long-term
  investments, only isoelastic utilities matter>.

  This paper proves turnpike theorems in a general framework, which includes
  discrete and continuous time, and nests diffusion models with several
  assets, stochastic drifts, volatilities, and interest rates. The paper
  departs from the existing literature, in which either asset returns are
  independent over time, or markets are complete. It is precisely when both
  these assumptions fail that portfolio choice becomes most challenging \U
  and turnpike theorems most useful.

  Our results have three broad implications. First, turnpike theorems are a
  powerful tool in portfolio choice, because they apply not only when optimal
  portfolios are myopic, but also when the <em|intertemporal hedging>
  component is present. Finding this component is the central problem of
  portfolio choice, and the only tractable but non trivial analysis is based
  on isoelastic utilities, combined with long horizon asymptotics. Turnpike
  theorems make this analysis relevant for a large class of utility
  functions, and for large but finite horizons.

  Second, we clarify the roles of preferences and market structure for
  turnpike results. Under regularity conditions on utility functions, we show
  that an <em|abstract turnpike> theorem holds regardless of market
  structure, as long as utility maximization is well posed, and longer
  horizons lead to higher payoffs. This abstract turnpike yields the
  convergence of optimal portfolios to their isoelastic limit under the
  <em|myopic> probability <math|<prob><rsup|T>>, which changes with the
  horizon. Market structure becomes crucial to pass from from the abstract to
  the <em|classic turnpike> theorem, in which convergence holds under the
  physical probability <math|<prob>>.

  Third, in addition to the classical version, we prove a new kind of result,
  the <em|explicit turnpike>, in which the limit portfolio is identified as
  the <em|long-run optimal> portfolio, that is the solution to an ergodic
  Hamilton Jacobi Bellman equation. This result offers the first theoretical
  basis to the long-standing practice of interpreting solutions of ergodic
  HJB equations as long-run limits of utility maximization
  problems<footnote|This interpretation underpins the literature on
  <em|risk-sensitive control>, introduced by <cite-textual*|MR1358100>, and
  applied to optimal portfolio choice by <cite-author-link|MR1802598>
  <citeyearpar|MR1802598,MR1910647>, <cite-author-link|MR1882297>
  <citeyearpar|MR1790132,MR1882297>, <cite-author-link|MR1890061>
  <citeyearpar|MR1890061,MR1882294> among others.>. We show that this
  intuition is indeed correct for a large class of diffusion models, and that
  its scope includes a broader class of utility functions.

  Portfolio turnpikes start with the work of
  <cite-textual*|mossin1968optimal> on affine risk tolerance
  (<math|-U<rprime|'><around|(|x|)>/U<rprime|''><around|(|x|)>=a*x+b>), which
  envisions many of the later developments. In his concluding remarks, he
  writes: <em|\PDo any of these results carry over to arbitrary utility
  functions? They seem reasonable enough, but the generalization does not
  appear easy to make. As one usually characterizes those problems one hasn't
  been able to solve oneself: this is a promising area for future
  research\Q.>

  <cite-textual*|leland1972turnpike> coins the expression <em|portfolio
  turnpike>, extending Mossin's result to larger classes of utilities,
  followed by <cite-textual*|ross1974portfolio> and
  <cite-textual*|hakansson1974convergence>. <cite-textual*|MR736053> prove a
  necessary and sufficient condition for the turnpike property. As in the
  previous literature, they consider discrete time models with independent
  returns. <cite-textual*|cox1992continuous> prove the first turnpike theorem
  in continuous time, using contingent claim methods.
  <cite-textual*|MR1629559> extends their results to include consumption, and
  <cite-textual*|MR1805320> obtain similar results using viscosity solutions.
  <cite-textual*|dybvig1999portfolio> dispose of the assumption of
  independent returns, proving a turnpike theorem for complete markets based
  on the Brownian filtration.

  In summary, the literature either exploits independent returns, which make
  dynamic programming attractive, or complete markets, which make martingale
  methods convenient. Since market completeness and independence of returns
  have a tenuous relation, neither of these concepts appears to be central to
  turnpike theorems. We confirm this intuition, by relaxing both assumptions
  in this paper.

  The main results are in section <reference|sec: myopic>, which is divided
  into two parts. The first part shows the conditions leading to the abstract
  turnpike, whereby final payoffs and portfolios converge under the myopic
  probabilities <math|<prob><rsup|T>>. Regarding preferences (Assumption
  <reference|ass: utility>), we require a marginal utility that is
  asymptotically isoelastic as wealth increases <eqref|ass: conv>, and that
  does not stray from its reference at low wealth levels (<eqref|ass: R lb 0>
  and <eqref|ass: R ub 0>). Market structure remains irrelevant, beyond the
  basic conditions that utility maximization is well-posed (Assumption
  <reference|ass: wellpose>), and that wealth processes can be freely
  compounded (Assumption <reference|ass: wealth proc>).

  The second part of section <reference|sec: myopic> states the classic and
  explicit turnpike theorems for a class of diffusion models with several
  assets, but with a single state variable driving expected returns,
  volatilities and interest rates. Under further well-posedness assumptions,
  we show a classic turnpike theorem, in which optimal portfolios of generic
  utility functions converge to their isoelastic counterparts. The same
  machinery leads to the explicit turnpike, in which optimal portfolios for a
  generic utility and a finite horizon converge to the long-run optimal
  portfolio, that is the solution of an ergodic HJB equation. The examples in
  Section 3 show the significance and the limits of these results, and in
  particular the relevance of the assumptions made to obtain them.

  Section 4 contains the proofs of the abstract turnpike, while the classic
  and the explicit turnpike for diffusions are proved in section 5. Section 4
  is divided into three parts. The first part proves for log utility a
  preliminary turnpike property, that is the convergence of the ratio of
  final payoffs. The second part of section 4 proves the same result for
  power utility, and is independent of the first part. In the third part, the
  convergence of wealth processes is derived from the convergence of payoff
  ratios. Section 5 is divided into three parts, the first one proving the
  necessary verification results, the second one obtaining the convergence of
  conditional densities that underlies the classic and explicit turnpikes,
  then these turnpike results are proved in the third part.

  In conclusion, this paper shows that turnpike theorems are an useful tool
  to make portfolio choice tractable, even in the most intractable setting of
  incomplete markets combined with stochastic investment opportunities.
  Still, these results are likely to admit extensions to more general
  settings, like diffusions with multiple state variables, and processes with
  jumps. As Mossin put it gracefully, this is a promising area for future
  research.

  <section|Main Results><label|sec: myopic>

  This section contains the statements of the main results and their
  implications. The first subsection states an abstract version of the
  turnpike theorem, which focuses on payoff spaces and wealth processes,
  without explicit reference to the structure of the underlying market. In
  this setting, asymptotic conditions on the utility functions and on wealth
  growth imply that, as the horizon increases, optimal wealths and optimal
  portfolios converge to their isoelastic counterparts.

  The defining feature of the abstract turnpike is that convergence takes
  place under a family of <em|myopic> probability measures that change with
  the horizon. By contrast, in the <em|classic> turnpike the convergence of
  these quantities holds under the physical probability measure. Thus,
  passing from the abstract to the classic turnpike theorem requires the
  convergence of the myopic probabilities, which in turn commands additional
  assumptions. The second subsection achieves this task for a class of
  diffusion models with several risky assets, and with a single state
  variable driving investment opportunities. This class nests several models
  in the literature, and allows for return predictability, stochastic
  volatility, and stochastic interest rates.

  The <em|explicit> turnpike \U stated at the end of the second subsection \U
  holds for the same class of diffusion models. While in the abstract and
  classical turnpikes the benchmark is the optimal portfolio for a isoelastic
  utility, but with the same finite horizon, in the explicit turnpike the
  benchmark is the long-run optimal portfolio, that is the optimal portfolio
  for asymptotic expected utility.

  <subsection|The Abstract Turnpike>

  Consider two investors. One of them has Constant Relative Risk Aversion
  (henceforth CRRA) equal to <math|1-p>, which corresponds to either power
  utility <math|x<rsup|p>/p> (<math|0\<ne\>p\<less\>1>), or to logarithmic
  utility <math|log x> (<math|p=0>). The other investor has a generic utility
  function <math|U:<Real><rsub|+>\<rightarrow\><Real>>. The marginal utility
  ratio <math|<fR><around|(|x|)>> measures how close <math|U> is to the
  reference utility:

  <\equation*>
    <fR><around|(|x|)>\<assign\><frac|U<rprime|'><around|(|x|)>|x<rsup|p-1>>,<space|1em>x\<gtr\>0.
  </equation*>

  <\ass>
    <label|ass: utility>The utility function
    <math|U:<Real><rsub|+>\<rightarrow\><Real>> is continuously
    differentiable, strictly increasing, strictly concave, and satisfies the
    Inada conditions <math|U<rprime|'><around|(|0|)>=\<infty\>> and
    <math|U<rprime|'><around|(|\<infty\>|)>=0>. The marginal utility ratio
    satisfies:

    <align|<tformat|<table|<row|<cell|<label|ass:
    conv>lim<rsub|x*\<uparrow\>*\<infty\>><fR><around|(|x|)>>|<cell|=1,>>|<row|<cell|0\<less\>liminf<rsub|x*\<downarrow\>*0><fR><around|(|x|)>,>|<cell|<space|1.6cm><text|for
    >0\<neq\>p\<less\>1,<label|ass: R lb 0>>>|<row|<cell|limsup<rsub|x*\<downarrow\>*0><fR><around|(|x|)>>|<cell|\<less\>\<infty\>,<space|0.5cm><text|for
    >p\<less\>1.<label|ass: R ub 0>>>>>>
  </ass>

  Condition <eqref|ass: conv> entails that, when investors are rich, their
  marginal utilities are very close. Put differently, good outcomes have a
  similar impact for the two investors. Such a condition is typical of
  turnpike results (cf. <cite-textual*|dybvig1999portfolio> and
  <cite-textual*|MR1805320>).

  Conditions <eqref|ass: R lb 0> and <eqref|ass: R ub 0> require that, when
  investors are poor, their marginal utilities are not too far apart, in that
  their ratio is bounded within a positive interval. Because these conditions
  involve the behavior of the utility near zero, they seem less relevant for
  turnpike results. Yet, their importance stems from the potentially large
  impact of bad outcomes with small probability. Unless bad outcomes, in
  addition to good ones, have a comparable effect for both investors, their
  portfolios may remain far apart, even for long horizons.

  Both investors choose from the same set <math|<X><rsup|T>> of wealth
  processes. Given a filtered probability space
  <math|<around|(|\<Omega\>,<around|(|<F><rsub|t>|)><rsub|t\<in\><around|[|0,T|]>>,<F>,<prob>|)>>,
  the set <math|<X><rsup|T>> satisfies the following:

  <\ass>
    <label|ass: wealth proc>For each <math|T\<in\><Real><rsub|+>>,
    <math|<X><rsup|T>> is a set of nonnegative semimartingales such that:

    <\enumerate>
      <item><math|X<rsub|0>=1> for all <math|X\<in\><X><rsup|T>>;

      <item><math|<X><rsup|T>> contains some strictly positive <math|X> (i.e.
      <math|inf<rsub|t\<in\><around|[|0,T|]>> X<rsub|t>\<gtr\>0>
      <math|<prob>>-a.s.);

      <item><math|<X><rsup|T>> is <em|convex>:
      <math|<pare|<around|(|1-\<alpha\>|)>*X+\<alpha\>*X<rprime|'>>\<in\><X><rsup|T>>
      for any <math|X,X<rprime|'>\<in\><X><rsup|T>> and
      <math|\<alpha\>\<in\><around|[|0,1|]>>;

      <item><math|<X><rsup|T>> is stable under <em|compounding>: if
      <math|X,X<rprime|'>\<in\><X><rsup|T>> with <math|X<rprime|'>> strictly
      positive and <math|\<tau\>> is a <math|<around|[|0,T|]>>-valued
      stopping time, then <math|<X><rsup|T>> contains the process
      <math|X<rprime|''>> that compounds <math|X> with <math|X<rprime|'>> at
      <math|\<tau\>>:

      <\equation*>
        X<rprime|''>=X<indic><rsub|[<space|-0.17em>[0,\<tau\><around|[|<space|-0.17em>|[>>+X<rprime|'>*<frac|X<rsub|\<tau\>>|X<rprime|'><rsub|\<tau\>>><indic><rsub|<around|[|<space|-0.17em><around|[|\<tau\>,T|]><space|-0.17em>|]>>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|X<rsub|t><around|(|\<omega\>|)>,>|<cell|<text|if
        ><math|t\<in\><around|[|0,\<tau\><around|(|\<omega\>|)>|[>>>>|<row|<cell|<pare|X<rsub|\<tau\>><around|(|\<omega\>|)>/X<rsub|\<tau\>>*'<around|(|\<omega\>|)>>X<rsub|t>*'<around|(|\<omega\>|)>,>|<cell|<text|if
        ><math|t\<in\><around|[|\<tau\><around|(|\<omega\>|)>,T|]>>>>>>>|\<nobracket\>>
      </equation*>
    </enumerate>
  </ass>

  <\nada>
    <ass|<label|ass: convex> <math|<C><rsup|T>\<subseteq\><bL><rsup|0><rsub|+>>
    is convex, and <math|<C><rsup|T>\<cap\><bL><rsup|0><rsub|++>\<neq\>\<emptyset\>>
    for all <math|T\<geq\>0>.>
  </nada>

  The existence of a strictly positive wealth is a non-degeneracy condition,
  and is trivial in the presence of a safe asset. Convexity and compounding
  mean that wealth processes are stable under portfolio formation, across
  payoffs and over time. Using the index <math|0> for the CRRA investor, and
  <math|1> for the generic investor, their maximization problems are:

  <\equation>
    <label|def: value u>u<rsup|0,T>=sup<rsub|X\<in\><X><rsup|T>><expec><rsup|<prob>><bra|X<rsub|T><rsup|p>/p>,<space|2em>u<rsup|1,T>=sup<rsub|X\<in\><X><rsup|T>><expec><rsup|<prob>><bra|U<pare|X<rsub|T>>>.
  </equation>

  The next assumption requires that these problems are well-posed:

  <\ass>
    <label|ass: wellpose>For all <math|T\<gtr\>0> and <math|i=0,1>,
    <math|-\<infty\>\<less\>u<rsup|i,T>\<less\>\<infty\>> and there exist an
    optimal <math|X<rsup|i,T>>.
  </ass>

  <\nada>
    At this point, it is necessary to identify the payoffs in
    <math|<C><rsup|T>> with terminal values of wealth processes. This
    additional structure is introduced in the following:

    <ass|<label|ass: concat> For each payoff <math|f\<in\><C><rsup|T>>, there
    exists a positive semimartingale <math|<around|(|f<rsub|t>|)><rsub|t\<in\><around|[|0,T|]>>>
    on <math|<basis>>, such that <math|f<rsub|0>=1>, <math|f<rsub|T>=f>, and
    <math|<around|{|f<rsub|s>=0|}>\<subseteq\><around|{|f<rsub|t>=0|}>> for
    <math|s\<le\>t>. In addition, the following <em|compounding property>
    holds: for any <math|f,g\<in\><C><rsup|T>>,
    <math|s\<in\><around|[|0,T|)>>, and any event <math|A\<in\><F><rsub|s>>,
    the process <math|<around|(|h<rsub|t>|)><rsub|t\<in\><around|[|0,T|]>>>
    defined by <math|h<rsub|t>=f<rsub|t><space|0.17em><indic><rsub|A<rsup|c><rsub|s,t>>+f<rsub|s>*<frac|g<rsub|t>|g<rsub|s>><space|0.17em><indic><rsub|A<rsub|s,t>>>,
    with <math|A<rsub|s,t>=<around|{|s\<leq\>t,g<rsub|s>\<gtr\>0|}>\<cap\>A>,
    leads to a terminal payoff <math|h<rsub|T>\<in\><C><rsup|T>>.>

    The assumption <math|f<rsub|0>=1> indicates that all wealth processes
    start with unit initial capital. The assumption that
    <math|<around|{|f<rsub|s>=0|}>\<subset\><around|{|f<rsub|t>=0|}>> is a
    minimal form of absence of arbitrage: once wealth reaches zero, it must
    stay at zero. The compounding assumption is slightly more restrictive, in
    that it accommodates constraints, but it excludes certain frictions such
    as proportional transaction costs. Still, it is trivially satisfied by
    usual semimartingale models in discrete and continuous time alike.
  </nada>

  The central objects in the abstract turnpike theorem are the ratio of
  optimal wealth processes, and their stochastic logarithms:

  <\equation*>
    r<rsup|T><rsub|u>\<assign\><frac|X<rsup|1,T><rsub|u>|X<rsup|0,T><rsub|u>>,<space|2em>\<Pi\><rsup|T><rsub|u>\<assign\><big|int><rsub|0><rsup|u><frac|d*r<rsup|T><rsub|v>|r<rsup|T><rsub|v->>,<space|1em><text|for
    >u\<in\><around|[|0,T|]>.
  </equation*>

  These objects are well-defined (cf. Corollary<nbsp><reference|cor:
  opt\<gtr\>0> and Remark<nbsp><reference|rem: foc for CRRA> below). Moreover
  <math|r<rsub|0><rsup|T>=1> since both investors have the same initial
  capital. Define also the <em|myopic probabilities> <rsub|<math|T\<geq\>0>>
  by:

  <\equation>
    <label|def: p><frac|d<prob><rsup|T>|d<prob>>=<frac|<pare|X<rsup|0,T><rsub|T>><rsup|p>|<expec><rsup|<prob>><bra|<pare|X<rsup|0,T><rsub|T>><rsup|p>>>.
  </equation>

  The above densities are well-defined and strictly positive (again by
  Remark<nbsp><reference|rem: foc for CRRA>), and
  <math|<prob><rsup|T>=<prob>> in the logarithmic case <math|p=0>. These
  myopic probabilities are interpreted as follows: an investor with relative
  risk aversion <math|1-p> under the probability <math|<prob>> selects the
  same optimal payoff as another investor under the probability
  <math|<prob><rsup|T>>, but with logarithmic utility, that is with unit risk
  aversion<footnote|These probabilities already appear in the work of
  <cite-author-link|Kramkov-Sirbu-06a> <citeyearpar|Kramkov-Sirbu-06a,Kramkov-Sirbu-06b,Kramkov-Sirbu-07>
  under the name of <math|<with|font-series|bold|R>>.>.

  Finally, the next assumption prescribes that, as the horizon increases,
  payoff spaces include arbitrary large elements, in the following sense:

  <\ass>
    <label|ass: growth>There exists a family
    <math|<around|(|<wide|X|^><rsup|T>|)><rsub|T\<ge\>0>> such that
    <math|<wide|X|^><rsup|T>\<in\><X><rsup|T>> and:

    <\equation>
      lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|<wide|X|^><rsup|T><rsub|T>\<geq\>N|)>=1*<space|2em><text|for
      any >N\<gtr\>0.
    </equation>
  </ass>

  This assumption is central to turnpike results, and is readily checked in
  applications. It is satisfied, in particular, if the market includes a safe
  rate <math|r> bounded from below by a constant
  <math|<wide*|r|\<bar\>>\<gtr\>0>, therefore the payoff space contains
  <math|<wide|X|^><rsup|T>\<geq\>e<rsup|<wide*|r|\<bar\>>T>>. In fact,
  Assumption <reference|ass: growth> is satisfied even in certain markets
  with no safe asset, or with a zero safe rate (cf. Example <reference|exa:
  BS> below).

  With the above definitions, the abstract version of the turnpike theorem
  reads as follows:

  <\thm>
    [Abstract Turnpike]<label|thm: opt-port conv> Let Assumptions
    <reference|ass: utility> <emdash> <reference|ass: growth> hold. Then, for
    any <math|\<epsilon\>\<gtr\>0>,

    <\enumerate>
      <item><math|lim<rsub|T\<to\>\<infty\>><prob><rsup|T><pare|sup<rsub|u\<in\><around|[|0,T|]>><around*|\||r<rsup|T><rsub|u>-1|\|>\<geq\>\<epsilon\>>=0>,

      <item><math|lim<rsub|T\<to\>\<infty\>><prob><rsup|T><pare|<bra|\<Pi\><rsup|T>,\<Pi\><rsup|T>><rsub|T>\<geq\>\<epsilon\>>=0>,
      where <math|<bra|\<cdot\>,\<cdot\>>> denotes the square bracket of
      semimartingales.
    </enumerate>
  </thm>

  <\rem>
    <label|rem: finite time><no-indent>

    <\enumerate>
      <item>Since <math|<prob><rsup|T>\<equiv\><prob>> for <math|p=0>,
      convergence holds under <math|<prob>> in the case of logarithmic
      utility. In addition, the logarithmic case does not require the
      condition <eqref|ass: R lb 0>.

      <item>For a market with asset prices
      <math|d*S<rsub|u>/S<rsub|u>=\<mu\><rsub|u>*<space|0.17em>d*u+\<sigma\><rsub|u>*d*W<rsub|u>>,
      with <math|\<mu\><rsub|\<cdot\>>\<in\><Real><rsup|d>>, and a
      <math|<Real><rsup|d>>-valued Brownian motion <math|W>, the wealth
      processes satisfy <math|<frac|d*X<rsup|i,T><rsub|u>|X<rsup|i,T><rsub|u>>=\<pi\><rsup|i,T>*<frac|d*S<rsub|u>|S<rsub|u>>>
      for <math|i=0,1>. Thus, <math|<around|[|\<Pi\><rsup|T>,\<Pi\><rsup|T>|]>>
      measures the square distance between the portfolios
      <math|\<pi\><rsup|1,T>> and <math|\<pi\><rsup|0,T>>:

      <\equation*>
        <bra|\<Pi\><rsup|T>,\<Pi\><rsup|T>><rsub|\<cdot\>>=<big|int><rsub|0><rsup|\<cdot\>><around|\<\|\|\>|\<sigma\><pare|\<pi\><rsup|1,T><rsub|u>-\<pi\><rsup|0,T><rsub|u>>|\<\|\|\>><rsup|2>*<space|0.17em>d*u.
      </equation*>

      <item>The theorem implies that both optimal wealth processes and
      portfolios are close in any time window <math|<around|[|0,t|]>> for any
      fixed <math|t\<gtr\>0>, under the probability <math|<prob><rsup|T>>.
      Indeed, for any <math|\<epsilon\>,t\<gtr\>0>:

      <\equation*>
        lim<rsub|T\<to\>\<infty\>><prob><rsup|T><pare|sup<rsub|u\<in\><around|[|0,t|]>><around*|\||r<rsup|T><rsub|u>-1|\|>\<geq\>\<epsilon\>>=0*<space|2em><text|and><space|2em>lim<rsub|T\<to\>\<infty\>><prob><rsup|T><pare|<bra|\<Pi\><rsup|T>,\<Pi\><rsup|T>><rsub|t>\<geq\>\<epsilon\>>=0.
      </equation*>
    </enumerate>
  </rem>

  Except for logarithmic utility, Theorem <reference|thm: opt-port conv> is
  not a classic turnpike theorem, in that convergence holds under the
  probabilities <math|<prob><rsup|T>>, which change with the horizon
  <math|T>. However, since the events <math|<around|{|sup<rsub|u\<in\><around|[|0,t|]>><around|\||r<rsup|T><rsub|u>-1|\|>\<geq\>\<epsilon\>|}>>
  and <math|<around|{|<around|[|\<Pi\><rsup|T>,\<Pi\><rsup|T>|]><rsub|t>\<geq\>\<epsilon\>|}>>
  are <math|<F><rsub|t>>-measurable, and any such event <math|A> satisfies
  <math|<prob><rsup|T><around|(|A|)>=<expec><rsup|<prob>><bra|<indic><rsub|A><around*|\<nobracket\>|<frac|d<prob><rsup|T>|d<prob>>|\|><rsub|<F><rsub|t>>>>,
  the relation between <math|<prob><rsup|T><around|(|A|)>> and
  <math|<prob><around|(|A|)>> depends on the density:

  <\equation>
    <label|def: cond density><around*|\<nobracket\>|<frac|d<prob><rsup|T>|d<prob>>|\|><rsub|<F><rsub|t>>=<frac|<expec><rsup|<prob>><rsub|t><bra|<pare|X<rsup|0,T><rsub|T>><rsup|p>>|<expec><rsup|<prob>><bra|<pare|X<rsup|0,T><rsub|T>><rsup|p>>>.
  </equation>

  Understanding the convergence of these densities is the crucial step to
  bridge the gap from the abstract to the classic version of the turnpike
  theorem.

  In fact, the densities in <eqref|def: cond density> become trivial under
  two additional assumptions: that the optimal CRRA strategy is myopic, and
  that its wealth process has independent returns. Under these assumptions,
  which hold in all the turnpike literature, with the exception of
  <cite-textual*|dybvig1999portfolio>, the density
  <math|<around*|\<nobracket\>|d<prob><rsup|T>/d<prob>|\|><rsub|<F><rsub|t>>>
  is independent of <math|T>, and the classic turnpike theorem follows:

  <\cor>
    [IID Myopic Turnpike]<label|thm: power mayopic> If, in addition to
    Assumptions <reference|ass: utility> <emdash> <reference|ass: growth>:

    <\enumerate>
      <item><math|X<rsup|0,T><rsub|t>=X<rsup|0,S><rsub|t>\<equiv\>X<rsub|t>>
      a.s. for all <math|t\<le\>S,T> (myopic optimality);

      <item><math|X<rsub|s>/X<rsub|t>> and <math|<F><rsub|t>> are independent
      for all <math|t\<le\>s> (independent returns).
    </enumerate>

    then, for any <math|\<epsilon\>,t\<gtr\>0>:

    <\enumerate>
      <item><math|lim<rsub|T\<to\>\<infty\>><prob><pare|sup<rsub|u\<in\><around|[|0,t|]>><around*|\||r<rsup|T><rsub|u>-1|\|>\<geq\>\<epsilon\>>=0>,

      <item><math|lim<rsub|T\<to\>\<infty\>><prob><pare|<bra|\<Pi\><rsup|T>,\<Pi\><rsup|T>><rsub|t>\<geq\>\<epsilon\>>=0>.
    </enumerate>
  </cor>

  In practice, if asset prices have independent returns, the optimal strategy
  for a CRRA investor entails a myopic portfolio with independent returns,
  and both conditions above hold. This is the case, for example, if asset
  prices follow exponential Lvy processes, as in <cite|Kallsen>. Note
  however, that a myopic CRRA portfolio is not sufficient to ensure that
  <math|<prob><rsup|T>> is independent of <math|T> (cf.
  Example<nbsp><reference|exa: zero cor> below).

  Thus, the abstract turnpike readily yields a classic turnpike theorem under
  the additional assumption of independent returns, which is common in the
  literature. However, such an additional assumption excludes the models in
  which portfolio choice is least tractable \U and turnpike results are
  needed the most. This topic is discussed next in the context of diffusions.

  <subsection|A Turnpike for Diffusions><label|subsec: turnpike for
  diffusion>

  This subsection states the classic turnpike theorem for a class of
  diffusion models, in which a single state variable drives investment
  opportunities. The state variable takes values in some interval
  <math|E=<around|(|\<alpha\>,\<beta\>|)>\<subseteq\><Real>>, with
  <math|-\<infty\>\<leq\>\<alpha\>\<less\>\<beta\>\<leq\>\<infty\>>, and has
  the dynamics:

  <\equation>
    <label|eq: state sde>d*Y<rsub|t>=b<around|(|Y<rsub|t>|)>*<space|0.17em>d*t+a<around|(|Y<rsub|t>|)>*<space|0.17em>d*W<rsub|t>.
  </equation>

  The market includes a safe rate <math|r<around|(|Y<rsub|t>|)>> and <math|d>
  risky assets, with prices <math|S<rsup|i><rsub|t>> satisfying:

  <\equation*>
    <frac|d*S<rsub|t><rsup|i>|S<rsub|t><rsup|i>>=r<around|(|Y<rsub|t>|)>*<space|0.17em>d*t+d*R<rsub|t><rsup|i>,<space|1em>1\<leq\>i\<leq\>d,
  </equation*>

  where the cumulative excess return process
  <math|R=<around|(|R<rsup|1>,\<cdots\>,R<rsup|d>|)><rprime|'>> is defined
  as:

  <\equation>
    <label|eq: excess return>d*R<rsub|t><rsup|i>=\<mu\><rsub|i><around|(|Y<rsub|t>|)>*<space|0.17em>d*t+<big|sum><rsub|j=1><rsup|d>\<sigma\><rsub|i*j><around|(|Y<rsub|t>|)>*<space|0.17em>d*Z<rsup|j><rsub|t>,<space|1em>1\<leq\>i\<leq\>d.
  </equation>

  Here <math|W> and <math|Z=<around|(|Z<rsup|1>,\<cdots\>,Z<rsup|d>|)><rprime|'>>
  are multivariate Wiener processes with instantaneous correlation
  <math|\<rho\>=<around|(|\<rho\><rsup|1>,\<cdots\>,\<rho\><rsup|d>|)><rprime|'>>,
  i.e. <math|d<around|\<langle\>|Z<rsup|i>,W|\<rangle\>><rsub|t>=\<rho\><rsup|i><around|(|Y<rsub|t>|)>*<space|0.17em>d*t>
  for <math|1\<leq\>i\<leq\>d>, and the prime sign is for matrix
  transposition. Denote by <math|\<Sigma\>=\<sigma\>*\<sigma\><rprime|'>>,
  <math|A=a<rsup|2>>, and <math|\<Upsilon\>=\<sigma\>*\<rho\>*a>. The model's
  coefficients are assumed regular and non-degenerate, in the following
  sense:

  <\ass>
    <label|ass: regular coeffs><math|r\<in\>C<rsup|\<gamma\>><around|(|E,<Real>|)>>,
    <math|b\<in\>C<rsup|1,\<gamma\>><around|(|E,<Real>|)>>,
    <math|\<mu\>\<in\>C<rsup|1,\<gamma\>><around|(|E,<Real><rsup|d>|)>>,
    <math|A\<in\>C<rsup|2,\<gamma\>><around|(|E,<Real>|)>>,
    <math|\<Sigma\>\<in\>C<rsup|2,\<gamma\>><around|(|E,<Real><rsup|d\<times\>d>|)>>,
    and <math|\<Upsilon\>\<in\>C<rsup|2,\<gamma\>><around|(|E,<Real><rsup|d>|)>>
    for some <math|\<gamma\>\<in\><around|(|0,1|]>>. For all <math|y\<in\>E>,
    <math|\<Sigma\>> is strictly positive definite and <math|A> is strictly
    positive.
  </ass>

  These regularity conditions imply the local existence and uniqueness of a
  solution to the joint dynamics of the state variable and asset prices. To
  ensure the existence of a unique global solution, a further assumption is
  needed, along with some more notation. Let <math|\<Omega\>> be the space of
  continuous maps <math|\<omega\>:<Real><rsub|+>\<to\><Real><rsup|d+1>> and
  <math|<around|(|<B><rsub|t>|)><rsub|t\<geq\>0>> be the filtration generated
  by the coordinate process <math|\<Xi\>> defined by
  <math|\<Xi\><rsub|t><around|(|\<omega\>|)>=\<omega\><rsub|t>> for
  <math|\<omega\>\<in\>\<Omega\>>. Let <math|<F>=\<sigma\>*<around*|(|\<Xi\><rsub|t>,t\<geq\>0|)>>
  and <math|<F><rsub|t>=<B><rsub|t+>>. Setting
  <math|\<xi\>=<around|(|z,y|)>\<in\><Real><rsup|d>\<times\>E>, the
  infinitesimal generator of <math|<around|(|R,Y|)>> is given by:

  <\equation>
    <label|eq: L def>L=<frac|1|2>*<big|sum><rsub|i,j=1><rsup|d+1><wide|A|~><rsub|i*j><around|(|\<xi\>|)><frac|\<partial\><rsup|2>|\<partial\>*\<xi\><rsub|i>*\<partial\>*\<xi\><rsub|j>>+<big|sum><rsub|i=1><rsup|d+1><wide|b|~><rsub|i><around|(|\<xi\>|)><frac|\<partial\>|\<partial\>*\<xi\><rsub|i>>,<space|1em><wide|A|~>=<pare|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|\<Sigma\>>|<cell|\<Upsilon\>>>|<row|<cell|\<Upsilon\><rprime|'>>|<cell|A>>>>>><text|and
    ><wide|b|~>=<pare|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|\<mu\>>>|<row|<cell|b>>>>>>.
  </equation>

  <\defn>
    <label|def: martingale problem>A family of probability measures
    <math|<around|(|<prob><rsup|\<xi\>>|)><rsub|\<xi\>\<in\><Real><rsup|d>\<times\>E>>
    on <math|<around|(|\<Omega\>,<F>|)>> is a solution of the martingale
    problem for <math|L> on <math|<Real><rsup|d>\<times\>E> if, for each
    <math|\<xi\>\<in\><Real><rsup|d>\<times\>E>:
    <math|i):<prob><rsup|\<xi\>><around|(|\<Xi\><rsub|0>=\<xi\>|)>=1>,
    <math|i*i):<prob><rsup|\<xi\>><around|(|\<Xi\><rsub|t>\<in\><Real><rsup|d>\<times\>E,\<forall\>t\<geq\>0|)>=1>,
    and <math|i*i*i):<around*|(|f<around|(|\<Xi\><rsub|t>|)>-f<around|(|\<Xi\><rsub|0>|)>-<big|int><rsub|0><rsup|t>L*f<around|(|\<Xi\><rsub|u>|)>*<space|0.17em>d*u;<B><rsub|t>|)>>
    is a <math|<prob><rsup|\<xi\>>> martingale for all
    <math|f\<in\>C<rsup|2><rsub|0>*<around|(|<Real><rsup|d>\<times\>E|)>>.
  </defn>

  <\ass>
    <label|ass: WP P>The martingale problem for <math|L> is <em|well posed>,
    in that it has a unique solution.<footnote|A solution to the martingale
    problem for <math|L> is equivalent to a weak solution to the SDEs for
    <math|<around|(|R,Y|)>> in <eqref|eq: state sde> and <eqref|eq: excess
    return> <cite-detail|MR1780932|Chapter V>. In particular, under
    Assumptions <reference|ass: regular coeffs> and <reference|ass: WP P>,
    for any <math|\<xi\>\<in\><Real><rsup|d>\<times\>E>, there exists a
    probability measure <math|<qprob><rsup|\<xi\>>> on
    <math|<around|(|\<Omega\>,<F>|)>> and independent
    <math|<around|(|<qprob><rsup|\<xi\>>,<around|(|<F><rsub|t>|)><rsub|t\<geq\>0>|)>>
    Wiener processes <math|B> and <math|W>, with respective dimensions
    <math|d> and <math|1>, such that <math|<pare|<around|(|R,Y|)>,<around|(|B,W|)>,<around|(|\<Omega\>,<F>,<around|(|<F><rsub|t>|)><rsub|t\<geq\>0>,<qprob><rsup|\<xi\>>|)>>>
    is a weak solution to <eqref|eq: state sde> and <eqref|eq: excess return>
    with <math|<around|(|R<rsub|0>,Y<rsub|0>|)>=\<xi\>>. Here, we have set
    <math|Z=\<rho\>*W+<wide|\<rho\>|\<bar\>>*B> where
    <math|<wide|\<rho\>|\<bar\>>> is the positive square root of
    <math|1<rsub|d>-\<rho\>*\<rho\><rprime|'>>. Because of this
    correspondence, solutions to martingale problems and weak solutions of
    the associated SDEs are used interchangeably. >
  </ass>

  This assumption is merely technical, in that it requires that the original
  market is well defined. By contrast, the next assumption places some
  restrictions on market dynamics.

  <\ass>
    <label|ass: correl><math|\<rho\><rprime|'>*\<rho\>> is constant (i.e. it
    does not depend on <math|y>), and <math|sup<rsub|y\<in\>E>
    c<around|(|y|)>\<less\>\<infty\>>, where

    <\equation>
      <label|eq: potential def>c<around|(|y|)>\<assign\><frac|1|\<delta\>>*<around|(|p*r-<frac|q|2>*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>|)><around|(|y|)>,<space|2em>y\<in\>E,
    </equation>

    with <math|q\<assign\><frac|p|p-1>> and
    <math|\<delta\>\<assign\><frac|1|1-q*\<rho\><rprime|'>*\<rho\>>>.
  </ass>

  Assumption <reference|ass: correl> is straightforward to check, and holds
  when <math|p\<leq\>0> for virtually all models in the literature, with the
  exception of correlation risk (cf. <cite-textual*|buraschi2010correlation>).

  Recall that an <em|admissible portfolio> is an
  <math|<around|(|<F><rsub|t>|)><rsub|t\<geq\>0>> adapted,
  <math|R>-integrable process <math|<around|(|\<pi\><rsub|t>|)><rsup|1\<le\>i\<le\>d><rsub|t\<ge\>0>>,
  representing the proportions of wealth invested in each risky asset, such
  that its corresponding wealth process <math|<around|(|X<rsup|\<pi\>><rsub|t>|)><rsub|t\<ge\>0>>,
  starting with initial capital <math|X<rsub|0>=x\<gtr\>0>, satisfies the
  relation:

  <\equation>
    <label|eq: wealth dynamics><frac|d*X<rsup|\<pi\>><rsub|t>|X<rsup|\<pi\>><rsub|t>>=r<around|(|Y<rsub|t>|)>*d*t+\<pi\><rprime|'><rsub|t>*<space|0.17em>d*R<rsub|t>.
  </equation>

  The value function for the horizon <math|T\<in\><Real><rsub|+>> is given
  by:

  <\equation>
    <label|def: u>u<rsup|T><around|(|t,x,y|)>=sup<rsub|\<pi\><text|admissible>><expec><rsup|<prob>><bra|<pare|X<rsub|T><rsup|\<pi\>>><rsup|p>/p<such>X<rsub|t>=x,Y<rsub|t>=y>,<space|1em><text|for
    >t\<in\><around|[|0,T|]>.
  </equation>

  These utility maximization problems are well posed at all horizons under
  the following assumption:

  <\ass>
    <label|ass: ptphat>There exist <math|<around|(|<wide|v|^>,\<lambda\><rsub|c>|)>>
    such that <math|<wide|v|^>\<in\>C<rsup|2><around|(|E|)>>,
    <math|<wide|v|^>\<gtr\>0>, and solves the equation:<label|ass: WP hat-v>

    <\equation>
      <label|eq: eign eqn><cL><space|0.17em>v+c*<space|0.17em>v=\<lambda\>*<space|0.17em>v,<space|1em>y\<in\>E,
    </equation>

    where <math|<cL>\<assign\><frac|1|2>*A*<space|0.17em>\<partial\><rsup|2><rsub|y*y>+B*<space|0.17em>\<partial\><rsub|y>>
    and <math|B\<assign\>b-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>>.
    Also, the following conditions are satisfied:

    <align|<tformat|<table|<row|<cell|<label|ass:
    recurrent><big|int><rsub|\<alpha\>><rsup|y<rsub|0>><frac|1|<wide|v|^><rsup|2>*A*m<around|(|y|)>>*d*y=>|<cell|\<infty\>>|<cell|<big|int><rsub|y<rsub|0>><rsup|\<beta\>><frac|1|<wide|v|^><rsup|2>*A*m<around|(|y|)>>*d*y=>|<cell|\<infty\>,>>|<row|<cell|<label|ass:
    posrec l1><big|int><rsub|\<alpha\>><rsup|\<beta\>><wide|v|^><rsup|2>*<space|0.17em>m<around|(|y|)>*<space|0.17em>d*y\<less\>>|<cell|\<infty\>>|<cell|<big|int><rsub|\<alpha\>><rsup|\<beta\>><wide|v|^>*<space|0.17em>m<around|(|y|)>*<space|0.17em>d*y\<less\>>|<cell|\<infty\>,>>>>>

    where, for some <math|y<rsub|0>\<in\>E>:

    <\equation>
      <label|eq: mnu def>m<around|(|y|)>\<assign\><frac|1|A<around|(|y|)>>*exp
      <pare|<big|int><rsub|y<rsub|0>><rsup|y><frac|2*B<around|(|z|)>|A<around|(|z|)>>*d*z>.
    </equation>
  </ass>

  This assumption is understood as follows. Equation <eqref|eq: eign eqn> is
  the ergodic HJB equation, which controls the long-run limit of the utility
  maximization problem (cf. <cite-textual*|Guasoni-Robertson> Theorem<nbsp>7
  and Section<nbsp>2.2.1). Its solution <math|<wide|v|^>> approximates the
  finite-horizon value functions <math|u<rsup|T>>, for large <math|T>, by
  <math|u<rsup|T><around|(|x,y,0|)>\<sim\><around|(|x<rsup|p>/p|)>*<around|(|e<rsup|\<lambda\>*T>*<wide|v|^><around|(|y|)>|)><rsup|\<delta\>>>
  (see <eqref|def : v<rsup|T>>, Propositions<nbsp><reference|lemma: HJB
  verification> and <reference|prop: ergodic> below for details). Thus,
  assuming that <eqref|eq: eign eqn> has a solution guarantees that the
  long-run optimization problem is well posed. Note that the value of
  <math|\<delta\>> reflects the power transformation of <cite|Zariphopoulou>,
  which allows to write the ergodic HJB equation in the linear form
  <eqref|eq: eign eqn>.

  To understand the meaning of <eqref|ass: recurrent> and <eqref|ass: posrec
  l1>, define the operator:

  <\equation>
    <label|eq: phat L def><wide|<cL>|^>=<frac|1|2>*<big|sum><rsub|i,j=1><rsup|d+1><wide|A|~><rsub|i*j><around|(|\<xi\>|)><frac|\<partial\><rsup|2>|\<partial\>*\<xi\><rsub|i>*\<partial\>*\<xi\><rsub|j>>+<big|sum><rsub|i=1><rsup|d+1><wide|b|^><rsub|i><around|(|\<xi\>|)><frac|\<partial\>|\<partial\>*\<xi\><rsub|i>>,<space|1em><wide|b|^>=<pare|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<frac|1|1-p>*<around*|(|\<mu\>+\<delta\>*\<Upsilon\>*<frac|<wide|v|^><rsub|y>|<wide|v|^>>|)>>>|<row|<cell|B+A*<frac|<wide|v|^><rsub|y>|<wide|v|^>>>>>>>>,
  </equation>

  where <math|<wide|A|~>> is the same as in <eqref|eq: L def>. Condition
  <eqref|ass: recurrent> in Assumption<nbsp><reference|ass: ptphat> implies
  that the martingale problem for <math|<wide|<cL>|^>> on
  <math|<Real><rsup|d>\<times\>E> has a unique solution
  <math|<around|(|<wide|<prob>|^><rsup|\<xi\>>|)><rsub|\<xi\>\<in\><Real><rsup|d>\<times\>E>>
  (see Lemma<nbsp><reference|lemma: WP hat-P> below), the <em|long-run>
  probability. <math|<wide|<prob>|^><rsup|\<xi\>>> is equivalent to
  <math|<prob><rsup|\<xi\>>> (Lemma<nbsp><reference|lemma: WP hat-P>, part
  <math|i*i>)), and the stochastic differential equation associated to the
  operator <math|<wide|<cL>|^>> has a unique weak solution starting at
  <math|\<xi\>>:

  <\equation>
    <label|eq: phat sde>

    <eqsplit|<tformat|<table|<row|<cell|>|<cell|d*R<rsub|t>=<frac|1|1-p><pare|\<mu\>+\<delta\>*\<Upsilon\>*<frac|<wide|v|^><rsub|y>|<wide|v|^>>><around|(|Y<rsub|t>|)>*<space|0.17em>d*t+\<sigma\><around|(|Y<rsub|t>|)>*<space|0.17em>d*<wide|Z|^><rsub|t>,>>|<row|<cell|>|<cell|d*Y<rsub|t>=<pare|B+A*<frac|<wide|v|^><rsub|y>|<wide|v|^>>><around|(|Y<rsub|t>|)>*<space|0.17em>d*t+a<around|(|Y<rsub|t>|)>*<space|0.17em>d*<wide|W|^><rsub|t>,>>>>>
  </equation>

  On the other hand, condition <eqref|ass: posrec l1> implies that <math|Y>
  is positively recurrent under <math|<wide|<prob>|^><rsup|\<xi\>>> for any
  <math|\<xi\>\<in\><Real><rsup|d>\<times\>E> (cf. Corollary 5.1.11 in
  <cite|Pinsky>). This property is also key to understand the long-run
  asymptotics of <math|<frac|d<prob><rsup|T>|d<prob>>\|<rsub|<F><rsub|t>>>. A
  simple criterion to check Assumption <reference|ass: ptphat> is the
  following:

  <\prop>
    <label|prop: turnpike holds>Let Assumptions <reference|ass: regular
    coeffs>, <reference|ass: WP P> and <reference|ass: correl> hold. If
    <math|c> in <eqref|eq: potential def> and <math|m> in <eqref|eq: mnu def>
    satisfy:

    <align|<tformat|<table|<row|<cell|<label|eq: m prob
    requirement>>|<cell|<big|int><rsub|\<alpha\>><rsup|\<beta\>>m<around|(|y|)>*d*y\<less\>\<infty\>,>>|<row|<cell|<label|eq:
    c decay requirement>>|<cell|lim<rsub|y*\<downarrow\>*\<alpha\>>
    c<around|(|y|)>=lim<rsub|y*\<uparrow\>*\<beta\>>
    c<around|(|y|)>=-\<infty\>.>>>>>

    Then, Assumption <reference|ass: ptphat> holds.
  </prop>

  <\rem>
    If the interest rate <math|r> is bounded from below, and
    <math|p\<less\>0>, <eqref|eq: c decay requirement> states that, the
    squared norm of the vector of risk premia
    <math|\<sigma\><rsup|-1>*\<mu\>> goes to <math|\<infty\>> at the boundary
    of the state space <math|E>.
  </rem>

  A major advantage of Assumption <reference|ass: ptphat> is to guarantee
  (see Proposition<nbsp><reference|lemma: HJB verification> below) that at
  all finite horizons <math|T>, the value functions <math|u<rsup|T>> in
  <eqref|def: u> can be represented via <math|u<rsup|T><around|(|t,x,y|)>=<frac|x<rsup|p>|p><around|(|v<rsup|T><around|(|t,y|)>|)><rsup|\<delta\>>>
  for <math|<around|(|t,x,y|)>\<in\><around|[|0,T|]>\<times\><Real><rsub|+>\<times\>E>,
  where <math|v<rsup|T>> is a strictly positive classical solution to the
  linear parabolic PDE:

  <\equation>
    <label|eq: HJB>

    <eqsplit|<tformat|<table|<row|<cell|>|<cell|\<partial\><rsub|t>*v+<cL>v+c*<space|0.17em>v=0,<space|1em><around|(|t,y|)>\<in\><around|(|0,T|)>\<times\>E,>>|<row|<cell|>|<cell|v<around|(|T,y|)>=1,<space|1.7cm>y\<in\>E.>>>>>
  </equation>

  Moreover, the optimal portfolio for the horizon <math|T> is (all functions
  are evaluated at <math|<around|(|t,Y<rsub|t>|)>>):

  <\equation>
    <label|eq: finite opt>\<pi\><rsup|T>=<frac|1|1-p>*\<Sigma\><rsup|-1><pare|\<mu\>+\<delta\>*\<Upsilon\>*<frac|v<rsup|T><rsub|y>|v<rsup|T>>>.
  </equation>

  Thus, the wealth process corresponding to this portfolio leads to the the
  optimal terminal wealth <math|X<rsup|\<pi\><rsup|T>><rsub|T>>, which in
  turn defines the probability<footnote|Since <math|R<rsub|0>=0> by
  assumption, <math|<prob><rsup|\<xi\>>> with <math|\<xi\>=<around|(|0,y|)>>
  is denoted as <math|<prob><rsup|y>>. The same convention applies to
  <math|<wide|<prob>|^><rsup|\<xi\>>>.> <math|<prob><rsup|T,y>> by
  <eqref|def: p<rsup|T>>. Understanding the convergence of
  <math|<frac|d<prob><rsup|T,y>|d<prob><rsup|y>>\|<rsub|<F><rsub|t>>> is key
  to go beyond the abstract version of the turnpike. To this end, observe
  from <eqref|eq: phat sde> that the portfolio:

  <\equation>
    <label|eq: long-run opt><wide|\<pi\>|^>=<frac|1|1-p>*\<Sigma\><rsup|-1><pare|\<mu\>+\<delta\>*\<Upsilon\>*<frac|<wide|v|^><rsub|y>|<wide|v|^>>>
  </equation>

  is optimal for logarithmic utility under the probability
  <math|<wide|<prob>|^><rsup|y>>. This fact suggests that the conditional
  densities of <math|<wide|<prob>|^><rsup|y>> are natural candidates for the
  limits of the conditional densities <math|<frac|d<prob><rsup|T,y>|d<prob><rsup|y>>\|<rsub|<F><rsub|t>>>.
  Combined with the positive recurrence of <math|Y> under
  <math|<around|(|<wide|<prob>|^><rsup|y>|)><rsub|y\<in\>E>> (implied by
  <eqref|ass: posrec l1>), the next result follows:

  <\lem>
    <label|thm: conv cond den>Let Assumptions<nbsp><reference|ass: regular
    coeffs>, <reference|ass: WP P>, <reference|ass: correl>, and
    <reference|ass: ptphat> hold. Then, for all <math|y\<in\>E> and
    <math|t\<ge\>0>:

    <\equation>
      <label|eq: conv cond den><wide|<prob>|^><rsup|y><text|->lim<rsub|T\<rightarrow\>\<infty\>>
      <frac|d<prob><rsup|T,y>|d<wide|<prob>|^><rsup|y>><mid|\|><rsub|<F><rsub|t>>=1.
    </equation>
  </lem>

  This result essentially allows to replace <math|<prob><rsup|T,y>> in
  Theorem <reference|thm: opt-port conv> with probabilities
  <math|<wide|<prob>|^><rsup|y>>. Then the classic turnpike follows from the
  equivalence of <math|<wide|<prob>|^><rsup|y>> and <math|<prob><rsup|y>>
  (cf. Lemma<nbsp><reference|lemma: WP hat-P>, part (ii)):

  <\thm>
    [Classic Turnpike]<label|thm: power 1-factor> Let
    Assumptions<nbsp><reference|ass: utility> <emdash> <reference|ass:
    growth>, <reference|ass: regular coeffs>, and <reference|ass: WP P>
    <emdash> <nada|, <reference|ass: correl> and> <reference|ass: ptphat>
    hold. Then, for all <math|y\<in\>E>, <math|0\<ne\>p\<less\>1> and
    <math|\<epsilon\>,t\<gtr\>0>:

    <\enumerate>
      <item><math|lim<rsub|T\<to\>\<infty\>><prob><rsup|y><space|0.17em><around|(|sup<rsub|u\<in\><around|[|0,t|]>><around*|\||r<rsup|T><rsub|u>-1|\|>\<geq\>\<epsilon\>|)>=0>,

      <item><math|lim<rsub|T\<to\>\<infty\>><prob><rsup|y><pare|<bra|\<Pi\><rsup|T>,\<Pi\><rsup|T>><rsub|t>\<geq\>\<epsilon\>>=0>.
    </enumerate>
  </thm>

  Abstract and classic turnpikes compare the finite-horizon optimal portfolio
  of a generic utility to that of its CRRA benchmark at the same finite
  horizon. By contrast, the explicit turnpike, discussed next, uses as
  benchmark the long horizon limit of the optimal CRRA portfolio.

  This result has two main implications: first, and most importantly, it
  shows that the two approximations of replacing a generic utility with a
  power, and a finite horizon problem with its long-run limit, lead to small
  errors as the horizon becomes large. Second, this theorem has a nontrivial
  statement even for <math|U> of CRRA type: in this case, it states that the
  optimal finite-horizon portfolio converges to the long-run optimal
  portfolio, identified as a solution to the ergodic HJB equation <eqref|eq:
  eign eqn>.

  To state the explicit turnpike, define the ratio of optimal wealth
  processes relative to the long-run benchmark, and their stochastic
  logarithms as:

  <\equation*>
    <wide|r|^><rsup|T><rsub|u>\<assign\><frac|X<rsup|1,T><rsub|u>|<wide|X|^><rsub|u>>,<space|2em><wide|\<Pi\>|^><rsup|T><rsub|u>\<assign\><big|int><rsub|0><rsup|u><frac|d*<wide|r|^><rsup|T><rsub|v>|<wide|r|^><rsup|T><rsub|v->>,<space|1em><text|for
    >u\<in\><around|[|0,T|]>,
  </equation*>

  where <math|<wide|X|^>> is the wealth process of the long-run portfolio
  <math|<wide|\<pi\>|^>>. The explicit turnpike then reads as:

  <\thm>
    [Explicit Turnpike]<label|cor: power 1-factor myopic> Under the
    assumptions of Theorem<nbsp><reference|thm: power 1-factor>, for any
    <math|y\<in\>E>, <math|\<epsilon\>,t\<gtr\>0> and
    <math|0\<ne\>p\<less\>1>:

    <\enumerate>
      <item><math|lim<rsub|T\<to\>\<infty\>><prob><rsup|y><space|0.17em><around|(|sup<rsub|u\<in\><around|[|0,t|]>><around*|\||<wide|r|^><rsup|T><rsub|u>-1|\|>\<geq\>\<epsilon\>|)>=0>,

      <item><math|lim<rsub|T\<to\>\<infty\>><prob><rsup|y><pare|<bra|<wide|\<Pi\>|^><rsup|T>,<wide|\<Pi\>|^><rsup|T>><rsub|t>\<geq\>\<epsilon\>>=0>.
    </enumerate>

    If <math|U> is of CRRA type, Assumption<nbsp><reference|ass: growth> is
    not needed for the above convergence.
  </thm>

  <section|Examples>

  The examples in this section show the relevance of the assumptions made in
  the statements of the main results. The first example is a simple
  Black-Scholes market with a zero safe rate. Its message is twofold: first,
  it shows that Assumption<nbsp><reference|ass: growth> may hold even without
  a positive rate. Second, it shows that replacing the myopic probabilities
  <math|<prob><rsup|T>> with the physical probability <math|<prob>> does not
  yield an equivalent condition, even in the simplest model.

  <\exa>
    <label|exa: BS>Consider the Black-Scholes market, where the interest rate
    is zero and a single risky asset <math|S> satisfies
    <math|<frac|d*S<rsub|t>|S<rsub|t>>=\<mu\>*<space|0.17em>d*t+\<sigma\>*<space|0.17em>d*W<rsub|t>>
    for some constants <math|\<mu\>> and <math|\<sigma\>\<gtr\>0>. The
    optimal portfolio for power utility <math|x<rsup|p>/p> is
    <math|\<pi\>=<frac|1|1-p>*<frac|\<mu\>|\<sigma\><rsup|2>>> (see
    <cite|Merton>). Hence, the optimal wealth process satisfies
    <math|<frac|d*X<rsub|t>|X<rsub|t>>=<frac|1|1-p>*<around|(|\<lambda\><rsup|2>*<space|0.17em>d*t+\<lambda\>*<space|0.17em>d*W<rsub|t>|)>>,
    where <math|\<lambda\>=\<mu\>/\<sigma\>> is the Sharpe ratio. Then:

    <\equation*>
      X<rsub|T>=x*exp <pare|<pare|1-<frac|1|2*<around|(|1-p|)>>><frac|\<lambda\><rsup|2>|1-p>*T+<frac|\<lambda\>|1-p>*W<rsub|T>>,<space|1em><text|for
      any >T\<geq\>0.
    </equation*>

    It then follows from <eqref|def: p<rsup|T>> that

    <\equation*>
      <frac|d<prob><rsup|T>|d<prob>>=<Exp><pare|<frac|p|1-p>*\<lambda\>*W><rsub|T>,
    </equation*>

    where <math|<Exp><around|(|\<cdummy\>|)>> denotes the stochastic
    exponential. Under <math|<prob><rsup|T>>, the optimal wealth process
    reads as:

    <\equation*>
      X<rsub|T>=x*exp <pare|<frac|\<lambda\><rsup|2>|2*<around|(|1-p|)><rsup|2>>*T+<frac|\<lambda\>|1-p>*<wide|W|~><rsub|T>>,<space|1em><text|for
      any >T\<geq\>0,
    </equation*>

    where <math|<wide|W|~><rsub|t>=W<rsub|t>-\<lambda\>*<frac|p|1-p>*t> is a
    Brownian motion under <math|<prob><rsup|T>>. As a result, the optimal
    wealth process <math|X> satisfies <eqref|ass: growth>, as long as
    <math|\<mu\>\<neq\>0>. By contrast, note that
    <math|lim<rsub|T\<to\>\<infty\>> X<rsub|T>=0> under <math|<prob>> for
    <math|p\<geq\>1/2>.
  </exa>

  Next, consider a market in which returns have constant volatility, but
  their drift is an independent Ornstein-Uhlenbeck process. Such independence
  entails that optimal CRRA portfolios are myopic, as in assumption <math|i)>
  of Corollary<nbsp><reference|thm: power mayopic>. By contrast, the
  time-varying drift makes returns dependent over time, hence assumption
  <math|i*i)> of the same corollary does not hold.

  In this example, the conditional myopic densities
  <math|<frac|d<prob><rsup|T>|d<prob>>\|<rsub|<F><rsub|t>>> change with
  <math|T>, even though the optimal CRRA portfolio is myopic. As a result,
  the proof of Corollary<nbsp><reference|thm: power mayopic> fails, because
  it requires that <math|<frac|d<prob><rsup|T>|d<prob>>\|<rsub|<F><rsub|t>>>
  is constant with respect to <math|T>, which in turn requires the
  independence of returns. Yet, both the classic and the explicit turnpikes
  hold in this model, in that Theorems <reference|thm: power 1-factor> and
  <reference|cor: power 1-factor myopic> do apply. Of course, these results
  depend on the ergodicity of the diffusion <math|Y>.

  <\exa>
    <label|exa: zero cor>Consider the following special case of diffusion
    models in Section<nbsp><reference|subsec: turnpike for diffusion>:

    <\equation*>
      d*R<rsub|t>=Y<rsub|t>*<space|0.17em>d*t+d*Z<rsub|t>*<space|1em><text|and
      ><space|1em>d*Y<rsub|t>=-Y<rsub|t>*<space|0.17em>d*t+d*W<rsub|t>,
    </equation*>

    where the correlation between <math|Z> and <math|W> is <math|\<rho\>=0>
    and the safe rate <math|r\<gtr\>0>. The optimal portfolio for a CRRA
    investor is a myopic portfolio <math|\<pi\><rsup|T><rsub|t>=<frac|Y<rsub|t>|1-p>>;
    see <eqref|eq: finite opt>. However, the conditional density
    <math|<frac|d<prob><rsup|T>|d<prob>>\|<rsub|<F><rsub|t>>> depends on the
    horizon <math|T>. Indeed, it follows from Proposition <reference|prop:
    Ito-Girsanov result> below that

    <\equation*>
      <frac|d<prob><rsup|T>|d<prob>>\|<rsub|<F><rsub|t>>=<Exp><pare|<big|int><frac|v<rsup|T><rsub|y><around|(|s,Y<rsub|s>|)>|v<rsup|T><around|(|s,Y<rsub|s>|)>>*<space|0.17em>d*W<rsub|s>-q*<big|int><rsub|0><rsup|\<cdot\>>Y<rsub|s>*<space|0.17em>d*Z<rsub|s>><rsub|t>,
    </equation*>

    where <math|v<rsup|T>> satisfies the HJB equation
    <math|\<partial\><rsub|t>*v+<frac|1|2>*\<partial\><rsup|2><rsub|y*y>*v-y*\<partial\><rsub|y>*v+<around|(|r*p-<frac|q|2>*y<rsup|2>|)>*v=0>
    with <math|v<around|(|T,y|)>=1>. The above conditional density is
    independent of <math|T> only if <math|g<rsup|T><around|(|t,y|)>\<assign\><frac|v<rsup|T><rsub|y><around|(|t,y|)>|v<rsup|T><around|(|t,y|)>>>
    is independent of <math|T> for any fixed <math|<around|(|t,y|)>>. It is
    easy to check that <math|g<rsup|T>> satisfies
    <math|\<partial\><rsub|t>*g+<frac|1|2>*\<partial\><rsup|2><rsub|y*y>*g+<around|(|g-y|)>*\<partial\><rsub|y>*g-g-q*y=0>
    with <math|g<around|(|T,y|)>=0>. If <math|g<rsup|T>> was independent of
    <math|T>, <math|0> should be a solution to the previous equation.
    However, this is clearly not the case for <math|q\<neq\>0>
  </exa>

  The last example of this section shows a model in which the log optimal
  portfolio is optimal \U at least at integer-valued horizons \U for any
  utility function. By contrast, <cite-textual*|MR736053> prove that in
  discrete time, and with independent returns, the classic turnpike holds if
  and only if the utility function satisfies a regular variation assumption.
  This is the only necessary and sufficient condition in the turnpike
  literature, and the natural question is whether a similar result holds when
  returns are dependent. The next example provides a negative answer, because
  the turnpike property holds, in a rather trivial sense, regardless of
  regular variation conditions.

  <\exa>
    Consider a Black-Scholes model with zero interest rate and
    <math|d*S<rsub|t>/S<rsub|t>=\<mu\>*d*t+\<sigma\>*d*W<rsub|t>>, with
    <math|\<mu\>,\<sigma\>\<neq\>0>. Wealth processes are defined as usual,
    starting from unit capital. In this model, the log-optimal wealth process
    <math|X> satisfies <math|log X<rsub|t>=<around|(|\<lambda\><rsup|2>/2|)>*t+\<lambda\>*W<rsub|t>>
    for <math|t\<in\><Real><rsub|+>>, where
    <math|\<lambda\>=\<mu\>/\<sigma\>>. Define a sequence of random horizons
    <math|<around|(|\<tau\><rsub|n>|)><rsub|n\<in\><Natural>>> setting
    <math|\<tau\><rsub|n>=inf <around|{|t\<in\><Real><rsub|+><such>X<rsub|t>=n|}>>.
    It is clear that <math|<prob><around|(|\<tau\><rsub|n>\<less\>\<infty\>|)>=1>
    for all <math|n\<in\><Natural>>, and that
    <math|<prob><around|(|lim<rsub|n\<to\>\<infty\>>
    \<tau\><rsub|n>=\<infty\>|)>=1>.

    By the numraire property of the log-optimal portfolio, any wealth
    process <math|\<xi\>> with <math|\<xi\><rsub|0>=1> satisfies
    <math|<expec><rsup|<prob>><around|[|\<xi\><rsub|\<tau\><rsub|n>>/X<rsub|\<tau\><rsub|n>>|]>\<leq\>1>
    or, equivalently, <math|<expec><rsup|<prob>><around|[|\<xi\><rsub|\<tau\><rsub|n>>|]>\<leq\>n>.
    Therefore, for an investor with <em|any> concave and increasing utility
    function <math|U>, Jensen's inequality gives
    <math|<expec><rsup|<prob>><around|[|U<around|(|\<xi\><rsub|\<tau\><rsub|n>>|)>|]>\<leq\>U<around|(|<expec><rsup|<prob>><around|[|\<xi\><rsub|\<tau\><rsub|n>>|]>|)>\<leq\>U<around|(|n|)>=<expec><rsup|<prob>><around|[|U<around|(|X<rsub|\<tau\><rsub|n>>|)>|]>>.
    In other words, for every time-horizon <math|\<tau\><rsub|n>>,
    <math|n\<in\><Natural>>, every investor's optimal wealth is the same.

    The previous construction can be adapted to become a sequence of
    deterministic times via a time-change. To wit, set <math|L=log X> and
    consider the strictly increasing, adapted process <math|A> given by:

    <\equation*>
      A<rsub|t>=n-exp <pare|-<big|int><rsub|\<tau\><rsub|n-1>><rsup|t><frac|1|<around|(|n-L<rsub|u>|)><rsup|2>>*d*u>,<text|for
      >t\<in\><around|[|\<tau\><rsub|n-1>,<space|0.17em>\<tau\><rsub|n>|)>.
    </equation*>

    We claim that, <math|<prob>>-a.s, <math|A<rsub|\<tau\><rsub|n>>=n> holds
    for all <math|n\<in\><Natural>>. Indeed, for all <math|n\<in\><Natural>>,
    the process <math|\<chi\><rsup|n>> defined via
    <math|\<chi\><rsup|n><rsub|t>=n-L<rsub|\<tau\><rsub|n>\<wedge\>t>> for
    <math|t\<in\><Real><rsub|+>> is a Brownian motion with
    <math|\<chi\><rsup|n><rsub|0>=1>, drift rate <math|-\<lambda\><rsup|2>/2>
    and volatility <math|\<lambda\>>, stopped when it reaches zero, the
    latter happening at time <math|\<tau\><rsub|n>>. Since

    <\equation*>
      log <around|(|\<chi\><rsup|n><rsub|t>|)>=<big|int><rsub|\<tau\><rsub|n-1>><rsup|t><frac|1|\<chi\><rsup|n><rsub|u>>*d*\<chi\><rsup|n><rsub|u>-<frac|\<lambda\><rsup|2>|2>*<big|int><rsub|\<tau\><rsub|n-1>><rsup|t><frac|1|<around|(|\<chi\><rsup|n><rsub|u>|)><rsup|2>>*d*u*<text|holds
      for >t\<in\><around|[|\<tau\><rsub|n-1>,<space|0.17em>\<tau\><rsub|n>|)>
    </equation*>

    (note that <math|\<chi\><rsup|n><rsub|\<tau\><rsub|n-1>>=1>), on the
    event <math|=> one would have <math|\<chi\><rsup|n><rsub|\<tau\><rsub|n>>\<gtr\>0>;
    in view of <math|<prob><bra|\<chi\><rsup|n><rsub|\<tau\><rsub|n>>=0>=1>,
    <math|<prob><bra|A<rsub|\<tau\><rsub|n>>=n>=1> for all
    <math|n\<in\><Natural>> has to hold. Continuing, define <math|C> as the
    inverse of <math|A>, that is <math|C<rsub|t>=inf
    <around|{|u\<in\><Real><rsub|+><such>A<rsub|u>\<geq\>t|}>> for
    <math|t\<in\><Real><rsub|+>>. Note that <math|C> is strictly increasing,
    <math|C<rsub|n>=\<tau\><rsub|n>> for all <math|n\<in\><Natural>>, and
    each <math|C<rsub|t>> is a stopping time. Consider now a new price
    process <math|<tS>> adapted to the filtration
    <math|<tbF>=<around|(|<tF><rsub|t>|)><rsub|t\<in\><Real><rsub|+>>>, where
    <math|<tS><rsub|t>=S<rsub|C<rsub|t>>> and
    <math|<tF><rsub|t>=<F><rsub|C<rsub|t>>> for all
    <math|t\<in\><Real><rsub|+>>. In this setting, the log-optimal portfolio
    <math|<tX>> satisfies <math|<tX><rsub|t>=X<rsub|C<rsub|t>>> for
    <math|t\<in\><Real><rsub|+>>; in particular,
    <math|<tX><rsub|n>=X<rsub|C<rsub|n>>=X<rsub|\<tau\><rsub|n>>=n> for all
    <math|n\<in\><Natural>>. Again, for every time-horizon
    <math|n\<in\><Natural>>, the log optimal wealth process remains optimal
    for any investor with an integer horizon <math|n>.
  </exa>

  <section|Proof of the Abstract Turnpike>

  This section contains the results leading to the abstract version of the
  turnpike theorem. The proof proceeds through three main steps:

  <\enumerate>
    <item>Derive the first order condition for optimal payoffs;

    <item>Show that optimal payoffs for the generic utility converge to their
    CRRA counterparts;

    <item>Obtain from the convergence of optimal payoffs the convergence of
    wealth processes.
  </enumerate>

  The first subsection studies the first order condition and its
  implications. The second subsection derives the convergence of optimal
  payoffs, and is divided into two parts. The first part treats logarithmic
  utility, which is technically simpler, and leads to a slightly stronger
  result. The second part deals with power utility. These two subsections
  make no reference to market structure, and can be thought of as results on
  sequences of one-period models. By contrast, the identification of payoffs
  as terminal values of wealth processes is the main topic in the third
  subsection.

  <subsection|The First Order Condition><label|sec: first order cond>

  The first order condition is commonly used in the literature as an
  assumption, or as an ansatz to find a candidate optimal payoff. By
  contrast, the first order condition in this paper is derived under
  well-posedness of the finite horizon problem, and under the assumption that
  the utility function is close to a member of the CRRA class.

  Since the marginal utility ratio <math|<fR>> is continuous on
  <math|<Real><rsub|+>>, <eqref|ass: R ub 0> and <eqref|ass: conv> imply
  that:

  <\equation>
    <label|ass: R ub><ufR>\<assign\>sup<rsub|x\<gtr\>0><fR><around|(|x|)>\<less\>\<infty\>;
  </equation>

  Similarly, <eqref|ass: R lb 0> and <eqref|ass: conv> imply that:

  <\equation>
    <label|ass: R lb><lfR>\<assign\>inf<rsub|x\<gtr\>0><fR><around|(|x|)>\<gtr\>0.
  </equation>

  Denote by <math|<C><rsup|T>=<around|{|X<rsub|T>:X\<in\><X><rsup|T>|}>> the
  set of final payoffs of the class of wealth processes <math|<X><rsup|T>>.
  Note that <math|<C><rsup|T>\<subseteq\><bL><rsup|0><rsub|+>> is convex,
  and, setting <math|<bL><rsup|0><rsub|++>=<around|{|f\<in\>L<rsup|0><rsub|T>\|<prob><around|(|f\<gtr\>0|)>=1|}>>,
  <math|<C><rsup|T>\<cap\><bL><rsup|0><rsub|++>\<neq\>\<emptyset\>> for all
  <math|T\<geq\>0>. The first order condition reads as follows:

  <\lem>
    <label|lemma: first order condition>Let <eqref|ass: R ub> hold and, if
    <math|p\<ne\>0> let also <eqref|ass: R lb> hold. If
    Assumption<nbsp><reference|ass: wellpose> holds, then
    <math|<expec><rsup|<prob>><around|[|<around|(|f<rsup|1,T>|)><rsup|p>|]>\<less\>\<infty\>>,
    where <math|f<rsup|1,T>\<assign\>X<rsup|1,T><rsub|T>>, and:

    <\equation>
      <label|eq: first order cond><expec><rsup|<prob>><bra|U<rprime|'><around|(|f<rsup|1,T>|)><around|(|f|)>>\<le\><expec><rsup|<prob>><bra|U<rprime|'><around|(|f<rsup|1,T>|)><around|(|f<rsup|1,T>|)>>\<less\>\<infty\>,<space|1em><text|for
      any >f\<in\><C><rsup|T>.
    </equation>
  </lem>

  <\proof>
    In this proof, all expectations are under <math|<prob>> and the
    superscript <math|1> is omitted. For any <math|f\<in\><C><rsup|T>>, fix
    <math|\<epsilon\>\<in\><around|(|0,1/2|)>>. By the convexity of
    <math|<C><rsup|T>>, <math|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>\<in\><C><rsup|T>>.
    The optimality of <math|f<rsup|T>> implies that:

    <\equation*>
      <expec><bra|<frac|1|\<epsilon\>><bra|U*<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)>-U<around|(|f<rsup|T>|)>>>\<leq\>0.
    </equation*>

    There exists an integrable random variable <math|g> such that
    <math|<bra|U*<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)>-U<around|(|f<rsup|T>|)>>/\<epsilon\>\<geq\>g>
    for any <math|\<epsilon\>\<in\><around|(|0,1/2|)>>. Indeed, the concavity
    of <math|U> implies that:

    <\equation>
      <label|eq: lb est 1>

      <eqsplit|<tformat|<table|<row|<cell|<frac|1|\<epsilon\>><bra|U*<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)>-U<around|(|f<rsup|T>|)>>>|<cell|\<geq\>U<rprime|'>*<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)>*<around|(|f-f<rsup|T>|)><indic><rsub|\<nosymbol\>>>>|<row|<cell|>|<cell|=<fR><around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)>*<frac|f-f<rsup|T>|<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)><rsup|1-p>><indic><rsub|\<nosymbol\>>,>>>>>
    </equation>

    where <math|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>\<gtr\>0> when
    <math|0\<leq\>f\<less\>f<rsup|T>>. Now, note that:

    <\equation>
      <label|eq: lb est 2><frac|f-f<rsup|T>|<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)><rsup|1-p>>\<geq\>-<around|(|1-\<epsilon\>|)><rsup|p-1><around|(|f<rsup|T>|)><rsup|p>*<space|1em><text|for
      any >f*<text|such that >0\<leq\>f\<less\>f<rsup|T>.
    </equation>

    Indeed, define <math|F<around|(|x|)>\<assign\><frac|x|<around|(|f<rsup|T>+\<epsilon\>*x|)><rsup|1-p>>>
    for <math|x\<in\>[-f<rsup|T>,0)>. Next, estimate the numerator of its
    derivative <math|F<rprime|'><around|(|x|)>=<frac|f<rsup|T>+p*\<epsilon\>*x|<around|(|f<rsup|T>+\<epsilon\>*x|)><rsup|2-p>>>.
    For <math|p\<leq\>0>, the numerator is clearly nonnegative for
    <math|x\<in\>[-f<rsup|T>,0)>. For <math|0\<less\>p\<less\>1>,
    <math|f<rsup|T>+p*\<epsilon\>*x\<geq\>f<rsup|T>-p*\<epsilon\>*f<rsup|T>\<geq\>0>
    because <math|1-p*\<epsilon\>\<gtr\>0>. Therefore, as an increasing
    function on <math|[-f<rsup|T>,0)>, <math|F> attains its minimum at
    <math|-f<rsup|T>> on <math|[-f<rsup|T>,0)>. Hence the claim follows. Now,
    combining <eqref|eq: lb est 1>, <eqref|eq: lb est 2>, and
    <math|\<epsilon\>\<in\><around|(|0,1/2|)>>, it follows that:

    <\equation*>
      <frac|1|\<epsilon\>><bra|U*<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)>-U<around|(|f<rsup|T>|)>>\<geq\>-2<rsup|1-p><space|0.17em><ufR><space|0.17em><around|(|f<rsup|T>|)><rsup|p>=:g.
    </equation*>

    The above inequality also holds when <math|f<rsup|T>=0>. In the next
    paragraph, we shall show that <math|g> is integrable for different values
    of <math|p>.

    It suffices to show that <math|<around|(|f<rsup|T>|)><rsup|p>> is
    integrable. This is trivial for <math|p=0>. For
    <math|0\<less\>p\<less\>1>, <eqref|ass: R lb> implies that
    <math|U<rprime|'><around|(|x|)>\<geq\><lfR><space|0.17em>x<rsup|p-1>> for
    <math|x\<in\><Real><rsub|++>>. Integrating this inequality on
    <math|<around|(|x<rsub|\<ast\>>,x|)>> for some fixed constant
    <math|x<rsub|\<ast\>>> gives

    <\equation*>
      <frac|1|<lfR>><pare|U<around|(|x|)>-U<around|(|x<rsub|\<ast\>>|)>>\<geq\><frac|1|p>*<around|(|x<rsup|p>-x<rsub|\<ast\>><rsup|p>|)>.
    </equation*>

    Therefore on the set <math|<around|{|f<rsup|T>\<gtr\>x<rsub|\<ast\>>|}>>,

    <\equation*>
      <around|(|f<rsup|T>|)><rsup|p>\<leq\>x<rsub|\<ast\>><rsup|p>+<frac|p|<lfR>><pare|U<around|(|f<rsup|T>|)>-U<around|(|x<rsub|\<ast\>>|)>>.
    </equation*>

    Taking expectation on both sides, and recalling with the assumption
    <math|<expec><around|[|U<around|(|f<rsup|T>|)>|]>\<less\>\<infty\>>, it
    follows that <math|<expec><around|[|<around|(|f<rsup|T>|)><rsup|p><indic><rsub|\<nosymbol\>>|]>\<less\>\<infty\>>.
    On the other hand, <math|<expec><around|[|<around|(|f<rsup|T>|)><rsup|p><indic><rsub|\<nosymbol\>>|]>\<leq\>x<rsub|\<ast\>><rsup|p>>
    for <math|0\<less\>p\<less\>1>. Hence the claim
    <math|<expec><around|[|<around|(|f<rsup|T>|)><rsup|p>|]>\<less\>\<infty\>>
    follows. For <math|p\<less\>0>, a similar argument applies, while
    integrating <eqref|ass: R lb> on <math|<around|(|x,x<rsub|\<ast\>>|)>>.

    Now <eqref|ass: R ub> and <math|<expec><around|[|<around|(|f<rsup|T>|)><rsup|p>|]>\<less\>\<infty\>>
    combined implies that

    <\equation>
      <label|eq: exp u'><expec><bra|U<rprime|'><around|(|f<rsup|T>|)>*f<rsup|T>>\<leq\><wide|<fR>|\<bar\>><expec><bra|<around|(|f<rsup|T>|)><rsup|p>>\<less\>\<infty\>.
    </equation>

    On the other hand, the lower bound <math|g> yields:

    <\equation*>
      <eqsplit|<tformat|<table|<row|<cell|liminf<rsub|\<epsilon\>*\<downarrow\>*0><expec><bra|<frac|1|\<epsilon\>><bra|U*<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)>-U<around|(|f<rsup|T>|)>>-g>>|<cell|=liminf<rsub|\<epsilon\>*\<downarrow\>*0><expec><bra|<frac|1|\<epsilon\>><bra|U*<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)>-U<around|(|f<rsup|T>|)>>-g>>>|<row|<cell|>|<cell|\<geq\><expec><bra|liminf<rsub|\<epsilon\>*\<downarrow\>*0>
      <frac|1|\<epsilon\>><bra|U*<around|(|f<rsup|T>+\<epsilon\>*<around|(|f-f<rsup|T>|)>|)>-U<around|(|f<rsup|T>|)>>-g>>>|<row|<cell|>|<cell|=<expec><bra|U<rprime|'><around|(|f<rsup|T>|)>*<around|(|f-f<rsup|T>|)>-g>,>>>>>
    </equation*>

    in which the inequality follows from Fatou's lemma. Then adding
    <math|<expec><around|[|g|]>> on both sides of previous inequality, noting
    that <math|-\<infty\>\<less\><expec><around|[|g|]>\<less\>\<infty\>>, it
    follows that <math|<expec><bra|U<rprime|'><around|(|f<rsup|T>|)>*<around|(|f-f<rsup|T>|)>>\<leq\>0>.
    Therefore <eqref|eq: exp u'> and the previous inequality combined implies
    <eqref|eq: first order cond>.
  </proof>

  As a consequence of the first order condition, the optimizer
  <math|f<rsup|1,T>> is strictly positive <math|<prob>>-a.s.

  <\cor>
    <label|cor: opt\<gtr\>0>Under the assumptions of
    Lemma<nbsp><reference|lemma: first order condition>,
    <math|f<rsup|1,T>\<gtr\>0>, <math|<prob>>-a.s..
  </cor>

  <\proof>
    By contradiction, suppose that <math|<prob><around|(|f<rsup|1,T>=0|)>\<gtr\>0>.
    Then, for any <math|f\<in\><bL><rsup|0><rsub|++>\<cap\><C><rsup|T>>, it
    would follow that:

    <\equation*>
      \<infty\>=<expec><rsup|<prob>><bra|U<rprime|'><around|(|f<rsup|1,T>|)>*f>\<leq\><expec><rsup|<prob>><bra|U<rprime|'><around|(|f<rsup|1,T>|)>*f<rsup|1,T>>\<less\>\<infty\>,
    </equation*>

    in which the first equality follows from
    <math|U<rprime|'><around|(|0|)>=\<infty\>>, the rest inequalities hold
    thanks to Lemma<nbsp><reference|lemma: first order condition>.
  </proof>

  <\rem>
    <label|rem: foc for CRRA>Using the same reasoning,
    Lemma<nbsp><reference|lemma: first order condition> and
    Corollary<nbsp><reference|cor: opt\<gtr\>0> also hold for CRRA utility
    <math|x<rsup|p>/p> and its optimal payoff <math|f<rsup|0,T>>.
  </rem>

  <subsection|Logarithmic Utility><label|sec: log>

  This section derives the convergence of terminal payoffs, in the case of a
  reference investor with logarithmic utility, corresponding to <math|p=0>.
  Then, <math|<fR>> is the ratio between the marginal utility of <math|U> and
  that of logarithmic utility. Recall that
  <math|<prob><rsup|T>\<equiv\><prob>> for <math|p=0>, <eqref|ass: growth> is
  equivalent to the following assumption:

  <\equation>
    <label|ass: growth log><text|There exists a sequence
    ><around|(|h<rsup|T>|)><rsub|T\<geq\>0>,<text|with
    >h<rsup|T>\<in\><C><rsup|T>,<text|such that ><plimT>h<rsup|T>=\<infty\>.
  </equation>

  The existence of such an unbounded sequence of payoffs implies that the
  sequence of optimal payoffs <math|<around|(|f<rsup|i,T>|)><rsub|T\<geq\>0>>
  is also unbounded:

  <\lem>
    <label|lemma: optimizer unbounded>Let <eqref|ass: R ub> and <eqref|ass:
    growth log> hold. Then <math|<plimT>f<rsup|i,T>=\<infty\>> for
    <math|i=0,1>.
  </lem>

  <\proof>
    Only <math|i=1> case is proved here, <math|i=0> case follows similarly.
    Choosing <math|f> in <eqref|eq: first order cond> as <math|h<rsup|T>> in
    <eqref|ass: growth log>, it follows that
    <math|<expec><rsup|<prob>><around|[|U<rprime|'><around|(|f<rsup|1,T>|)>*h<rsup|T>|]>\<leq\><expec><rsup|<prob>><around|[|U<rprime|'><around|(|f<rsup|1,T>|)>*f<rsup|1,T>|]>>.
    Here the right-hand-side of the last inequality is bounded from above by
    <math|<ufR>> thanks to <eqref|ass: R ub>. As a result,
    <math|<plimT>U<rprime|'><around|(|f<rsup|1,T>|)>=0>, if
    <math|<plimT>h<rsup|T>=\<infty\>>. Since
    <math|U<rprime|'><around|(|x|)>\<gtr\>0> for
    <math|x\<in\><Real><rsub|++>> and <math|lim<rsub|x*\<uparrow\>*\<infty\>>
    U<rprime|'><around|(|x|)>=0>, it follows that
    <math|<plimT>f<rsup|1,T>=\<infty\>>.
  </proof>

  Even though both <math|f<rsup|0,T>> and <math|f<rsup|1,T>> are unbounded as
  <math|T\<to\>\<infty\>>, the following main result of this subsection shows
  that their ratio <math|r<rsup|T>\<assign\>r<rsup|T><rsub|T>=<frac|f<rsup|1,T>|f<rsup|0,T>>>
  converges.

  <\thm>
    <label|thm: r-\<gtr\>1 log>Assume that <eqref|ass: R ub 0>, <eqref|ass:
    conv>, and <eqref|ass: growth log> are satisfied. Then

    <\equation>
      <label|eq: r-\<gtr\>1 log>lim<rsub|T\<to\>\<infty\>><expec><rsup|<prob>><bra|<around|\||r<rsup|T>-1|\|>>=0.
    </equation>
  </thm>

  The proof of this result depends on the following lemma.

  <\lem>
    <label|lemma: expec bound>Let <eqref|ass: R ub> hold. Then

    <\equation>
      <label|eq: expec bound><expec><rsup|<prob>><bra|<around*|\||<pare|r<rsup|T>-1><pare|1-<frac|<fR><around|(|f<rsup|1,T>|)>|r<rsup|T>>>|\|>>\<leq\>2<space|0.17em><expec><rsup|<prob>><bra|<pare|<fR><around|(|f<rsup|1,T>|)>-1><rsup|2>>.
    </equation>

    In addition, if <eqref|ass: R ub 0>, <eqref|ass: conv>, and <eqref|ass:
    growth log> are satisfied, then

    <\equation>
      <label|eq: expec conv>lim<rsub|T\<to\>\<infty\>><expec><rsup|<prob>><bra|<around*|\||<pare|r<rsup|T>-1><pare|1-<frac|<fR><around|(|f<rsup|1,T>|)>|r<rsup|T>>>|\|>>=0.
    </equation>
  </lem>

  <\proof>
    All expectations are taken under <math|<prob>> in this proof. Applying
    the first order condition to <math|log x> and <math|U>
    respectively<footnote|<eqref|ass: R ub> is required for the first order
    condition.>, it follows that:

    <\equation*>
      <expec><bra|r<rsup|T>-1>\<leq\>0<space|1em><text|and><space|1em><expec><bra|<frac|<fR><around|(|f<rsup|1,T>|)>|r<rsup|T>><pare|1-r<rsup|T>>>\<leq\>0,<space|1em><text|for
      any >T\<geq\>0.
    </equation*>

    The first inequality is known as the <em|numraire> property of
    <math|f<rsup|0,T>>. The sum of these inequalities yields

    <\equation>
      <label|eq: expec \<less\> 0><expec><bra|<pare|r<rsup|T>-1><pare|1-<frac|<fR><around|(|f<rsup|1,T>|)>|r<rsup|T>>>>\<leq\>0.
    </equation>

    Observe that <math|<pare|r<rsup|T>-1><pare|1-<fR><around|(|f<rsup|1,T>|)>/r<rsup|T>>>
    is negative, if and only if <math|1\<less\>r<rsup|T>\<less\><fR><around|(|f<rsup|1,T>|)>>
    or <math|<fR><around|(|f<rsup|1,T>|)>\<less\>r<rsup|T>\<less\>1>. In
    either cases, setting <math|x<rsub|->=max <around|(|0,-x|)>> and
    <math|x<rsub|+>=max <around|(|0,x|)>>:

    <\equation>
      <label|eq: est neg><pare|<pare|r<rsup|T>-1><pare|1-<frac|<fR><around|(|f<rsup|1,T>|)>|r<rsup|T>>>><rsub|->\<leq\><pare|<fR><around|(|f<rsup|1,T>|)>-1><rsup|2>.
    </equation>

    On the other hand, it follows from <eqref|eq: expec \<less\> 0> that

    <\equation>
      <label|eq: est pos><expec><bra|<pare|<pare|r<rsup|T>-1><pare|1-<frac|<fR><around|(|f<rsup|1,T>|)>|r<rsup|T>>>><rsub|+>>\<leq\><expec><bra|<pare|<pare|r<rsup|T>-1><pare|1-<frac|<fR><around|(|f<rsup|1,T>|)>|r<rsup|T>>>><rsub|->>\<leq\><expec><bra|<pare|<fR><around|(|f<rsup|1,T>|)>-1><rsup|2>>.
    </equation>

    As a result, the first statement follows from <eqref|eq: est pos>.

    Combining <eqref|ass: conv> and Lemma<nbsp><reference|lemma: optimizer
    unbounded>, we have <math|<plim><rsub|T\<to\>\<infty\>><fR><around|(|f<rsup|1,T>|)>=1>.
    Note that <math|<fR><around|(|f<rsup|1,T>|)>> is bounded from above
    thanks to <eqref|ass: R ub>. The second statement follows from applying
    the bounded convergence theorem to the right-hand-side of <eqref|eq:
    expec bound>.
  </proof>

  <\proof>
    <dueto|Proof of Theorem<nbsp><reference|thm: r-\<gtr\>1 log>>All
    expectations are taken under <math|<prob>> in this proof. It suffices to
    prove

    <\equation>
      <label|eq: prob conv r><plimT>r<rsup|T>=1.
    </equation>

    Indeed, note that <math|r<rsup|T>-1\<geq\>-1>, Fatou's lemma implies that

    <\equation*>
      0=<expec><around|[|liminf<rsub|T\<to\>\<infty\>>
      r<rsup|T>-1|]>\<leq\>liminf<rsub|T\<to\>\<infty\>><expec><around|[|r<rsup|T>-1|]>\<leq\>0,
    </equation*>

    in which the first equality follows from <eqref|eq: prob conv r> and the
    second inequality holds by the numraire property of <math|f<rsup|0,T>>.
    As a result of the last sequence of inequalities,
    <math|lim<rsub|T\<to\>\<infty\>><expec><around|[|r<rsup|T>|]>=1>, which
    leads to <eqref|eq: r-\<gtr\>1 log> after appealing to Scheff's lemma.

    To prove <eqref|eq: prob conv r>, observe that <eqref|ass: conv> and
    Lemma<nbsp><reference|lemma: optimizer unbounded> imply

    <\equation>
      <label|eq: R f -\<gtr\>1>lim<rsub|T\<to\>\<infty\>><prob><pare|<around*|\||<fR><around|(|f<rsup|1,T>|)>-1|\|>\<geq\>\<delta\>>=0,<space|1em><text|for
      any >\<delta\>\<gtr\>0.
    </equation>

    On the other hand, for fixed <math|\<epsilon\>\<gtr\>0> and
    <math|T\<geq\>0>, consider the set

    <\equation*>
      D<rsup|T>=.
    </equation*>

    Next, derive a lower bound for <math|<around*|\||1-<fR><around|(|f<rsup|1,T>|)>/r<rsup|T>|\|>>
    on <math|D<rsup|T>>. If <math|r<rsup|T>\<gtr\>1+\<epsilon\>>, then
    <math|<fR><around|(|f<rsup|1,T>|)>/r<rsup|T>\<leq\><around|(|1+\<epsilon\>|)><rsup|-1/2>\<less\>1>,
    hence <math|1-<fR><around|(|f<rsup|1,T>|)>/r<rsup|T>\<geq\>1-<around|(|1+\<epsilon\>|)><rsup|-1/2>\<gtr\>0>.
    If <math|r<rsup|T>\<less\>1-\<epsilon\>>, then
    <math|<fR><around|(|f<rsup|1,T>|)>/r<rsup|T>\<geq\><around|(|1-\<epsilon\>|)><rsup|-1/2>\<gtr\>1>,
    hence <math|1-<fR><around|(|f<rsup|1,T>|)>/r<rsup|T>\<leq\>1-<around|(|1-\<epsilon\>|)><rsup|-1/2>\<less\>0>.
    Denoting <math|\<eta\>=min <around|{|1-<around|(|1+\<epsilon\>|)><rsup|-1/2>,<around|(|1-\<epsilon\>|)><rsup|-1/2>-1|}>\<gtr\>0>,
    from the previous two cases we conclude that

    <\equation*>
      <around*|\||1-<frac|<fR><around|(|f<rsup|1,T>|)>|r<rsup|T>>|\|>\<geq\>\<eta\>*<space|1em><text|on
      >D<rsup|T>.
    </equation*>

    This implies

    <\equation*>
      <expec><bra|<around*|\||<around|(|r<rsup|T>-1|)><pare|1-<frac|<fR><around|(|f<rsup|1,T>|)>|r<rsup|T>>>|\|>>\<geq\>\<epsilon\>*<space|0.17em>\<eta\><space|0.17em><prob><around|(|D<rsup|T>|)>.
    </equation*>

    Combining previous estimate with <eqref|eq: expec conv>, it follows that
    <math|lim<rsub|T\<to\>\<infty\>><prob><around|(|D<rsup|T>|)>=0>. Now note
    that

    <\equation*>
      <prob><around|(|<around|\||r<rsup|T>-1|\|>\<gtr\>\<epsilon\>|)>\<leq\><prob><around|(|D<rsup|T>|)>+<prob><around|(|<around|\||<fR><around|(|f<rsup|1,T>|)>-1|\|>\<geq\>\<delta\>|)>,
    </equation*>

    where <math|\<delta\>\<assign\>min <around|{|<around|(|1+\<epsilon\>|)><rsup|1/2>-1,1-<around|(|1-\<epsilon\>|)><rsup|1/2>|}>>.
    Sending <math|T\<to\>\<infty\>>, it follows that
    <math|lim<rsub|T\<to\>\<infty\>><prob><around|(|<around|\||r<rsup|T>-1|\|>\<gtr\>\<epsilon\>|)>=0>
    from <eqref|eq: R f -\<gtr\>1> and <math|lim<rsub|T\<to\>\<infty\>><prob><around|(|D<rsup|T>|)>=0>.
  </proof>

  <subsection|Power utility case><label|sec: power>

  This subsection presents a version of Theorem<nbsp><reference|thm:
  r-\<gtr\>1 log> for power utility. Here <math|<fR>> is the ratio between
  marginal utilities of <math|U> and <math|x<rsup|p>/p> with
  <math|0\<ne\>p\<less\>1>.

  Recall the probability measure <math|<prob><rsup|T>> defined in <eqref|def:
  p<rsup|T>>. The optimizer <math|f<rsup|0,T>> has the numraire property
  under <math|<prob><rsup|T>>, i.e., <math|<expec><rsup|<prob><rsup|T>><bra|f/f<rsup|0,T>>\<leq\>1>
  for any <math|f\<in\><C><rsup|T>>. This claim follows by the inequality
  <math|<expec><rsup|<prob>><bra|<around|(|f<rsup|0,T>|)><rsup|p><pare|<frac|f|f<rsup|0,T>>-1>>\<leq\>0>,
  obtained by applying the first order condition to the utility
  <math|x<rsup|p>/p>, and switching the expectation from <math|<prob>> to
  <math|<prob><rsup|T>>.

  Thus, the power utility case is linked to the logarithmic case under the
  sequence of measures <rsub|<math|T\<geq\>0>>. In this setting, Assumption
  <reference|ass: growth> takes the following form:

  <align*|<tformat|<table|<row|<cell|<label|ass: growth
  power>>|<cell|<text|There exists ><rsub|T\<geq\>0><text|such that
  >h<rsup|T>\<in\><C><rsup|T><text|and >lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|h<rsup|T>\<geq\>N|)>=1*<text|for
  any >N\<gtr\>0.>>>>>

  The analogue of Theorem<nbsp><reference|thm: r-\<gtr\>1 log> for power
  utility reads as follows:

  <\thm>
    <label|thm: r-\<gtr\>1 power>Assume that <eqref|ass: R ub 0>, <eqref|ass:
    R lb 0>, <eqref|ass: conv>, and <eqref|ass: growth power> are satisfied.
    Then

    <\equation*>
      lim<rsub|T\<to\>\<infty\>><expec><rsup|<prob><rsup|T>><bra|<around|\||r<rsup|T>-1|\|>>=0.
    </equation*>
  </thm>

  As in the previous subsection, the proof of this theorem requires some
  similar preliminary lemmas. The following one is the analogue of
  Lemma<nbsp><reference|lemma: optimizer unbounded>.

  <\lem>
    <label|lemma: opt unbounded power>Let <eqref|ass: R ub>, <eqref|ass: R
    lb>, and <eqref|ass: growth power> hold. Then

    <\equation>
      <label|eq: f0T unbounded power>lim<rsub|T\<to\>\<infty\>><prob><rsup|T><pare|f<rsup|0,T>\<geq\>N>=1,<space|1em><text|for
      any >N\<gtr\>0.
    </equation>
  </lem>

  <\proof>
    It suffices to prove <math|limsup<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|f<rsup|0,T>\<less\>N|)>=0>
    for each fixed <math|N>. To this end, the numraire property implies
    that:

    <\equation*>
      1\<geq\><expec><rsup|<prob><rsup|T>><bra|<frac|h<rsup|T>|f<rsup|0,T>>>\<geq\><expec><rsup|<prob><rsup|T>><bra|<frac|h<rsup|T>|f<rsup|0,T>><space|0.17em><indic><rsub|\<nosymbol\>>>\<geq\><frac|<wide|N|~>|N><space|0.17em><prob><rsup|T><pare|f<rsup|0,T>\<less\>N,h<rsup|T>\<geq\><wide|N|~>>,
    </equation*>

    for any positive constant <math|<wide|N|~>>. As a result,
    <math|<prob><rsup|T><around|(|f<rsup|0,T>\<less\>N,h<rsup|T>\<geq\><wide|N|~>|)>\<leq\>N/<wide|N|~>>.
    Combining the last inequality with <eqref|ass: growth power>, we have

    <\equation*>
      limsup<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|f<rsup|0,T>\<less\>N|)>\<leq\>limsup<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|f<rsup|0,T>\<less\>N,h<rsup|T>\<geq\><wide|N|~>|)>+lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|h<rsup|T>\<less\><wide|N|~>|)>\<leq\><frac|N|<wide|N|~>>.
    </equation*>

    Then, the statement follows since <math|<wide|N|~>> is chosen
    arbitrarily.
  </proof>

  At this point, introducing the analogue of Lemma<nbsp><reference|lemma:
  expec bound> requires some notation. Define:

  <\equation*>
    <label|def: H>I<around|(|y|)>\<assign\><around|(|U<rprime|'>|)><rsup|-1><around|(|y|)>*<space|1em><text|for
    >y\<gtr\>0*<space|1em><text|and ><space|1em>H<around|(|x|)>\<assign\>I<around|(|x<rsup|p-1>|)>*<space|1em><text|for
    >x\<gtr\>0.
  </equation*>

  <\lem>
    <label|lemma: H/x>Let <eqref|ass: R ub 0> and <eqref|ass: conv> hold.
    Then

    <\equation>
      <label|eq: H/x>lim<rsub|x*\<uparrow\>*\<infty\>>
      <frac|H<around|(|x|)>|x>=1<space|1em><text|and
      ><space|1em><fH>\<assign\>sup<rsub|x\<gtr\>0><around*|\||<frac|H<around|(|x|)>|x>-1|\|>\<less\>\<infty\>.
    </equation>
  </lem>

  <\proof>
    Note that <math|H<around|(|x|)>/x> is positive and continuous on
    <math|<Real><rsub|++>>. The second statement follows from the claim
    <math|limsup<rsub|x*\<uparrow\>*\<infty\>>
    H<around|(|x|)>/x\<less\>\<infty\>> and
    <math|limsup<rsub|x*\<downarrow\>*0> H<around|(|x|)>/x\<less\>\<infty\>>,
    which is proved in the next two paragraphs.

    Denote <math|y=x<rsup|p-1>>, and observe that:

    <\equation*>
      <frac|H<around|(|x|)>|x>=<frac|I<around|(|y|)>|y<rsup|<frac|1|p-1>>>=<pare|<frac|I<around|(|y|)><rsup|p-1>|U<rprime|'><around|(|I<around|(|y|)>|)>>><rsup|<frac|1|p-1>>.
    </equation*>

    If <math|x*\<uparrow\>*\<infty\>>, due to <math|p\<less\>1> and the Inada
    conditions, we have <math|y*\<downarrow\>*0>, hence
    <math|I<around|(|y|)>*\<uparrow\>*\<infty\>>. As a result,

    <\equation*>
      lim<rsub|x*\<uparrow\>*\<infty\>> <frac|H<around|(|x|)>|x>=lim<rsub|y*\<downarrow\>*0><pare|<frac|I<around|(|y|)><rsup|p-1>|U<rprime|'><around|(|I<around|(|y|)>|)>>><rsup|<frac|1|p-1>>=1,
    </equation*>

    in which the second equality follows from <eqref|ass: conv>.

    When <math|x> is close to zero, denote by
    <math|z=U<rprime|'><around|(|x|)>>. Then <eqref|ass: R ub> implies that
    <math|z<space|0.17em><around|(|I<around|(|z|)>|)><rsup|1-p>\<leq\><ufR>>,
    whence <math|I<around|(|z|)>\<leq\><pare|<frac|<ufR>|z>><rsup|<frac|1|1-p>>>
    since <math|p\<less\>1>. As a result,
    <math|A\<assign\>limsup<rsub|z*\<uparrow\>*\<infty\>>
    <frac|I<around|(|z|)>|z<rsup|<frac|1|p-1>>>\<leq\><ufR><rsup|<frac|1|1-p>>>,
    which yields

    <\equation*>
      limsup<rsub|x*\<downarrow\>*0> <frac|H<around|(|x|)>|x>=limsup<rsub|y*\<uparrow\>*\<infty\>>
      <frac|I<around|(|y|)>|y<rsup|<frac|1|p-1>>>=A\<less\>\<infty\>.
    </equation*>

    This concludes the proof.
  </proof>

  This is the analogue of Lemma<nbsp><reference|lemma: expec bound>.

  <\lem>
    <label|lemma: expec bound power>Assume that <eqref|ass: R ub> and
    <eqref|ass: R lb> are satisfied. Then

    <\equation>
      <label|eq: expec bound power><expec><rsup|<prob><rsup|T>><bra|<around*|\||<pare|1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>>|\|>*<around|\||r<rsup|T>-1|\|>>\<leq\>2<space|0.17em><expec><rsup|<prob><rsup|T>><bra|<pare|1-<fR><around|(|f<rsup|0,T>|)>><pare|1-<frac|H<around|(|f<rsup|0,T>|)>|f<rsup|0,T>>>>.
    </equation>

    Moreover, if <eqref|ass: R ub 0>, <eqref|ass: R lb 0>, <eqref|ass: conv>,
    and <eqref|ass: growth power> are satisfied, then

    <\equation>
      <label|eq: expec conv power>lim<rsub|T\<to\>\<infty\>><expec><rsup|<prob><rsup|T>><bra|<around*|\||<pare|1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>>|\|>*<around|\||r<rsup|T>-1|\|>>=0.
    </equation>
  </lem>

  <\proof>
    Applying the first order condition to utilities <math|x<rsup|p>/p> and
    <math|U> respectively, and summing the resulting inequalities, it follows
    that <math|<expec><rsup|<prob>><bra|<around|(|f<rsup|0,T>|)><rsup|p><pare|1-<frac|U<rprime|'><around|(|f<rsup|1,T>|)>|<around|(|f<rsup|0,T>|)><rsup|p-1>>><pare|r<rsup|T>-1>>\<leq\>0>.
    After changing to the measure <math|<prob><rsup|T>>, the previous
    inequality reads

    <\equation*>
      <expec><rsup|<prob><rsup|T>><bra|<pare|1-<frac|U<rprime|'><around|(|f<rsup|1,T>|)>|<around|(|f<rsup|0,T>|)><rsup|p-1>>><pare|r<rsup|T>-1>>\<leq\>0.
    </equation*>

    Observe that <math|<pare|1-<frac|U<rprime|'><around|(|f<rsup|1,T>|)>|<around|(|f<rsup|0,T>|)><rsup|p-1>>><pare|r<rsup|T>-1>\<leq\>0>
    if and only if <math|f<rsup|0,T>\<leq\>f<rsup|1,T>\<leq\>H<around|(|f<rsup|0,T>|)>>
    or <math|H<around|(|f<rsup|0,T>|)>\<leq\>f<rsup|1,T>\<leq\>f<rsup|0,T>>.
    Thus, the following estimate, similar to <eqref|eq: est neg>, follows:

    <\equation*>
      <bra|<pare|1-<frac|U<rprime|'><around|(|f<rsup|1,T>|)>|<around|(|f<rsup|0,T>|)><rsup|p-1>>><pare|r<rsup|T>-1>><rsub|->\<leq\><pare|1-<fR><around|(|f<rsup|0,T>|)>><pare|1-<frac|H<around|(|f<rsup|0,T>|)>|f<rsup|0,T>>>.
    </equation*>

    Note that the right-hand-side of this inequality is nonnegative because
    <math|U<rprime|'><around|(|f<rsup|0,T>|)>\<leq\><around|(|f<rsup|0,T>|)><rsup|p-1>>
    if and only if <math|f<rsup|0,T>\<geq\>H<around|(|f<rsup|0,T>|)>>. Now
    <eqref|eq: expec bound power> follows from the same argument after
    <eqref|eq: est neg>.

    The second statement follows once we prove that

    <\equation*>
      lim<rsub|T\<to\>\<infty\>><expec><rsup|<prob><rsup|T>><bra|<pare|1-<fR><around|(|f<rsup|0,T>|)>><pare|1-<frac|H<around|(|f<rsup|0,T>|)>|f<rsup|0,T>>>>=0.
    </equation*>

    In view of <eqref|eq: H/x>, for any <math|\<epsilon\>\<gtr\>0>, there
    exists a sufficiently large <math|N<rsub|\<epsilon\>>>, such that
    <math|<around*|\||1-<frac|H<around|(|x|)>|x>|\|>\<leq\>\<epsilon\>> for
    any <math|x\<geq\>N<rsub|\<epsilon\>>>. Then we estimate

    <\equation*>
      <eqsplit|<tformat|<table|<row|<cell|>|<cell|<expec><rsup|<prob><rsup|T>><bra|<pare|1-<fR><around|(|f<rsup|0,T>|)>><pare|1-<frac|H<around|(|f<rsup|0,T>|)>|f<rsup|0,T>>>>>>|<row|<cell|>|<cell|<space|0.5cm>\<leq\><expec><rsup|<prob><rsup|T>><bra|<around*|\||1-<fR><around|(|f<rsup|0,T>|)>|\|>*<around*|\||1-<frac|H<around|(|f<rsup|0,T>|)>|f<rsup|0,T>>|\|><space|0.17em><indic><rsub|\<nosymbol\>>>+<fH><around|(|1+<ufR>|)><space|0.17em><prob><rsup|T><around|(|f<rsup|0,T>\<less\>N<rsub|\<epsilon\>>|)>>>|<row|<cell|>|<cell|<space|0.5cm>\<leq\>\<epsilon\>*<space|0.17em><around|(|1+<ufR>|)>+<fH><around|(|1+<ufR>|)><space|0.17em><prob><rsup|T><around|(|f<rsup|0,T>\<less\>N<rsub|\<epsilon\>>|)>,>>>>>
    </equation*>

    in which the first inequality holds due to <eqref|eq: H/x>. Now, sending
    <math|T\<to\>\<infty\>>,

    <\equation*>
      limsup<rsub|T\<to\>\<infty\>><expec><rsup|<prob><rsup|T>><bra|<pare|1-<fR><around|(|f<rsup|0,T>|)>><pare|1-<frac|H<around|(|f<rsup|0,T>|)>|f<rsup|0,T>>>>\<leq\>\<epsilon\>*<around|(|1+<ufR>|)>+<fH><around|(|1+<ufR>|)>*<space|0.17em>limsup<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|f<rsup|0,T>\<less\>N<rsub|\<epsilon\>>|)>=\<epsilon\>*<around|(|1+<ufR>|)>,
    </equation*>

    in which the last equality follows from <eqref|eq: f0T unbounded power>.
    Since the choice of <math|\<epsilon\>> is arbitrary, the claim then
    follows.
  </proof>

  As a corollary of the above result, <math|r<rsup|T>> is bounded away from
  both <math|0> and <math|\<infty\>> in the limit <math|T\<to\>\<infty\>>.

  <\cor>
    <label|cor: r>Let <eqref|ass: R ub 0>, <eqref|ass: R lb 0>, <eqref|ass:
    conv>, and <eqref|ass: growth power> hold. Then there exists a
    sufficiently large <math|N> such that

    <\equation>
      <label|eq: r>lim<rsub|T\<to\>\<infty\>><prob><rsup|T><pare|<frac|1|N>\<leq\>r<rsup|T>\<leq\>N>=1.
    </equation>
  </cor>

  <\proof>
    Choose <math|N\<gtr\><ufR><rsup|<frac|1|1-p>>\<vee\><lfR><rsup|<frac|1|p-1>>\<vee\>1>.
    We will show in this paragraph that <math|lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|r<rsup|T>\<gtr\>N|)>=0>.
    Since <math|N\<gtr\>1> and <math|<ufR>N<rsup|p-1>\<less\>1> (note
    <math|p\<less\>1>), then <math|<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>\<less\><ufR>N<rsup|p-1>\<less\>1>
    on the set <math|<around|{|r<rsup|T>\<gtr\>N|}>>. It then follows that

    <\equation*>
      <eqsplit|<tformat|<table|<row|<cell|<expec><rsup|<prob><rsup|T>><bra|<around*|\||1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>|\|>*<around|\||r<rsup|T>-1|\|>>>|<cell|\<geq\><expec><rsup|<prob><rsup|T>><bra|<around*|\||1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>|\|>*<around|\||r<rsup|T>-1|\|><indic><rsub|\<nosymbol\>>>>>|<row|<cell|>|<cell|\<geq\><around|(|1-<ufR>N<rsup|p-1>|)>*<around|(|N-1|)><space|0.17em><prob><rsup|T><around|(|r<rsup|T>\<gtr\>N|)>.>>>>>
    </equation*>

    Combining the last estimate with <eqref|eq: expec conv power>, it follows
    that <math|lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|r<rsup|T>\<gtr\>N|)>=0>.

    To prove <math|lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|r<rsup|T>\<less\>1/N|)>=0>,
    observe that on <math|<around|{|r<rsup|T>\<less\>1/N|}>>,

    <\equation*>
      <eqsplit|<tformat|<table|<row|<cell|<expec><rsup|<prob><rsup|T>><bra|<around*|\||1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>|\|>*<around|\||r<rsup|T>-1|\|>>>|<cell|\<geq\><expec><rsup|<prob><rsup|T>><bra|<around*|\||1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>|\|>*<around|\||r<rsup|T>-1|\|><space|0.17em><indic><rsub|\<nosymbol\>>>>>|<row|<cell|>|<cell|\<geq\><around|(|<lfR>N<rsup|1-p>-1|)><pare|1-<frac|1|N>><space|0.17em><prob><rsup|T><around|(|r<rsup|T>\<less\>1/N|)>,>>>>>
    </equation*>

    in which the second inequality follows from <eqref|ass: R lb> and
    <math|<lfR>N<rsup|1-p>\<gtr\>1>. Combining the last estimate with with
    <eqref|eq: expec conv power>, it follows that
    <math|lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|r<rsup|T>\<less\>1/N|)>=0>.
    This concludes the proof.
  </proof>

  Combining Lemma<nbsp><reference|lemma: opt unbounded power> and
  Corollary<nbsp><reference|cor: r>, it follows that:

  <\equation>
    <label|eq: f1 unbound>lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|f<rsup|1,T>\<geq\>N|)>=1,<space|1em><text|for
    sufficiently large >N.
  </equation>

  Indeed, observe that <math|<prob><rsup|T><around|(|f<rsup|1,T>\<geq\>N|)>\<geq\><prob><rsup|T><around|(|r<rsup|T>\<geq\>1/N;f<rsup|0,T>\<geq\>N<rsup|2>|)>>,
  then <eqref|eq: f1 unbound> follows from <eqref|eq: f0T unbounded power>
  and <eqref|eq: r<rsup|T> bounded>.

  In what follows, we will show that <math|r<rsup|T>> converges to <math|1>
  under <math|<prob><rsup|T>> as <math|T\<to\>\<infty\>>.

  <\prop>
    <label|prop: r>Let <eqref|ass: R ub 0>, <eqref|ass: R lb 0>, <eqref|ass:
    conv>, and <eqref|ass: growth power> hold. Then

    <\equation>
      <label|eq: r>lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|<around|\||r<rsup|T>-1|\|>\<geq\>\<epsilon\>|)>=0,<space|1em><text|for
      all >\<epsilon\>\<gtr\>0.
    </equation>
  </prop>

  <\proof>
    First note that, from <eqref|ass: conv> and <eqref|eq: f1 unbound>:

    <\equation>
      <label|eq: R f -\<gtr\>1 power>lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|<around|\||<fR><around|(|f<rsup|1,T>|)>-1|\|>\<geq\>\<delta\>|)>=0,<text|for
      any >\<delta\>\<gtr\>0.
    </equation>

    Indeed, for any <math|\<delta\>\<gtr\>0>, due to <eqref|ass: conv>, there
    exists a sufficiently large <math|N<rsub|\<delta\>>> such that
    <math|<around|\||<fR><around|(|x|)>-1|\|>\<less\>\<delta\>> for any
    <math|x\<gtr\>N<rsub|\<delta\>>>. As a result,
    <math|<prob><rsup|T><around|(|<around|\||<fR><around|(|f<rsup|1,T>|)>-1|\|>\<geq\>\<delta\>,f<rsup|1,T>\<gtr\>N<rsub|\<delta\>>|)>=0>.
    Combining this with <math|lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|f<rsup|1,T>\<leq\>N<rsub|\<delta\>>|)>=0>
    from <eqref|eq: f1 unbound>, we confirm the claim.

    Now take <math|\<epsilon\>\<in\><around|(|0,1|)>> and consider the set

    <\equation*>
      D<rsup|T>=.
    </equation*>

    In the following, we will estimate the lower bound of
    <math|<around*|\||1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>|\|>>
    on <math|D<rsup|T>> for the cases <math|r<rsup|T>\<gtr\>1+\<epsilon\>>
    and <math|r<rsup|T>\<less\>1-\<epsilon\>> separately.

    For <math|r<rsup|T>\<gtr\>1+\<epsilon\>>, we have
    <math|<fR><around|(|f<rsup|1,T>|)><around|(|r<rsup|T>|)><rsup|p-1>\<less\><around|(|1+\<epsilon\>|)><rsup|<frac|p-1|2>>\<less\>1>
    on <math|D<rsup|T>> whence

    <\equation*>
      1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>\<geq\>1-<around|(|1+\<epsilon\>|)><rsup|<frac|p-1|2>>\<gtr\>0;
    </equation*>

    For <math|r<rsup|T>\<less\>1-\<epsilon\>>, we have
    <math|<fR><around|(|f<rsup|1,T>|)><around|(|r<rsup|T>|)><rsup|p-1>\<gtr\><around|(|1-\<epsilon\>|)><rsup|<frac|p-1|2>>\<gtr\>1>
    on <math|D<rsup|T>> whence

    <\equation*>
      1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>\<leq\>1-<around|(|1-\<epsilon\>|)><rsup|<frac|p-1|2>>\<less\>0.
    </equation*>

    Denote <math|\<eta\>=min>. In either of the above cases,
    <math|<around*|\||1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>|\|>\<geq\>\<eta\>>,
    therefore

    <\equation*>
      <expec><rsup|<prob><rsup|T>><bra|<around*|\||1-<frac|<fR><around|(|f<rsup|1,T>|)>|<around|(|r<rsup|T>|)><rsup|1-p>>|\|>*<around|\||r<rsup|T>-1|\|>>\<geq\>\<epsilon\>*<space|0.17em>\<eta\><space|0.17em><prob><rsup|T><around|(|D<rsup|T>|)>.
    </equation*>

    Combining the previous inequality with <eqref|eq: expec conv power>, it
    follows that

    <\equation>
      <label|eq: prob D-\<gtr\>0>lim<rsub|T\<to\>\<infty\>><prob><rsup|T><around|(|D<rsup|T>|)>=0.
    </equation>

    Now, combining <eqref|eq: r<rsup|T> bounded>, <eqref|eq: R f -\<gtr\>1
    power> and <eqref|eq: prob D-\<gtr\>0>, and choosing
    <math|\<delta\>\<leq\>min> in <eqref|eq: R f -\<gtr\>1 power>, we
    conclude the proof.
  </proof>

  Now we have done all the preparation work for proving
  Theorem<nbsp><reference|thm: r-\<gtr\>1 power>.

  <\proof>
    <dueto|Proof of Theorem<nbsp><reference|thm: r-\<gtr\>1 power>>The proof
    consists of the following two steps, whose combination confirms the
    claim.

    <wide*|Step 1:|\<bar\>> Show that

    <\equation>
      <label|eq: pow L1 est 1>lim<rsub|T\<rightarrow\>\<infty\>><expec><rsup|<prob><rsup|T>><bra|<around*|\||r<rsup|T>-1|\|>\<wedge\><around|(|N-1|)>>=0,
    </equation>

    where <math|N> is the constant appearing in <eqref|eq: r<rsup|T>
    bounded>. To this end, for a sufficiently small
    <math|\<epsilon\>\<gtr\>0>, we have

    <\equation*>
      <eqsplit|<tformat|<table|<row|<cell|>|<cell|<expec><rsup|<prob><rsup|T>><bra|<around*|\||r<rsup|T>-1|\|>\<wedge\><around|(|N-1|)>>>>|<row|<cell|>|<cell|<space|1em>=<expec><rsup|<prob><rsup|T>><bra|<around|\||r<rsup|T>-1|\|>\<wedge\><around|(|N-1|)><indic><rsub|\<nosymbol\>>>+<expec><rsup|<prob><rsup|T>><bra|<around|\||r<rsup|T>-1|\|>\<wedge\><around|(|N-1|)><indic><rsub|\<nosymbol\>>>>>|<row|<cell|>|<cell|<space|0.8cm>+<expec><rsup|<prob><rsup|T>><bra|<around|\||r<rsup|T>-1|\|>\<wedge\><around|(|N-1|)><indic><rsub|\<nosymbol\>>>>>|<row|<cell|>|<cell|<space|1em>\<leq\>\<epsilon\><space|0.17em><prob><rsup|T><pare|r<rsup|T>\<leq\>N,<around|\||r<rsup|T>-1|\|>\<leq\>\<epsilon\>>+<around|(|N-1|)><space|0.17em><prob><rsup|T><pare|<around|\||r<rsup|T>-1|\|>\<gtr\>\<epsilon\>>+<around|(|N-1|)><space|0.17em><prob><rsup|T><around|(|r<rsup|T>\<gtr\>N|)>.>>>>>
    </equation*>

    As <math|T*\<uparrow\>*\<infty\>> in the previous inequalities,
    <eqref|eq: pow L1 est 1> follows from <eqref|eq: r<rsup|T> bounded>,
    <eqref|eq: r<rsup|T>-\<gtr\>1 power>, and the arbitrary choice of
    <math|\<epsilon\>>.

    <wide*|Step 2:|\<bar\>> Show that

    <\equation>
      <label|eq: pow L1 est 2>lim<rsub|T\<rightarrow\>\<infty\>><expec><rsup|<prob><rsup|T>><bra|<around|\||r<rsup|T>-1|\|><space|0.17em><indic><rsub|\<nosymbol\>>>=0.
    </equation>

    Note that <math|<around|(|r<rsup|T>|)><rsup|1-p>\<gtr\>N<rsup|1-p>> on
    <math|>. Recall that <math|<ufR>N<rsup|p-1>\<less\>1>, thus

    <\equation*>
      <pare|1-<ufR>N<rsup|p-1>><space|0.17em><expec><rsup|<prob><rsup|T>><bra|<around|\||r<rsup|T>-1|\|><space|0.17em><indic><rsub|\<nosymbol\>>>\<leq\><expec><rsup|<prob><rsup|T>><bra|<around*|\||1-<frac|R<pare|f<rsup|1,T>>|<around|(|r<rsup|T>|)><rsup|1-p>>|\|>*<around*|\||r<rsup|T>-1|\|>>.
    </equation*>

    Now sending <math|T*\<uparrow\>*\<infty\>>, <eqref|eq: pow L1 est 2>
    follows from <eqref|eq: expec conv power>.
  </proof>

  <subsection|Convergence of Wealth Processes><label|sec: proof mopic>

  Now we switch from the convergence of optimal payoffs to the convergence of
  corresponding wealth processes. The following lemma bridges this
  transition.

  <\lem>
    <label|lemma: stoch-log conv>Consider a sequence
    <rsub|<math|T\<in\><Real><rsub|+>>> of <cadlag><space|0.17em> processes
    and a sequence <rsub|<math|T\<in\><Real><rsub|+>>> of probability
    measures, such that:

    <\enumerate>
      <item>For each <math|T\<in\><Real><rsub|+>>, <math|Y<rsup|T><rsub|0>=1>
      and <math|Y<rsup|T><rsub|t>\<gtr\>0> for all
      <math|t\<in\><Real><rsub|+>>, <math|<prob><rsup|T>>-a.s..

      <item>Each <math|Y<rsup|T>> is a <math|<prob><rsup|T>>-supermartingale.

      <item><math|lim<rsub|T\<to\>\<infty\>><expec><rsup|<prob><rsup|T>><bra|<around|\||Y<rsup|T><rsub|T>-1|\|>>=0>.
    </enumerate>

    Then:

    <\enumerate>
      <item><math|lim<rsub|T\<to\>\<infty\>><prob><rsup|T><pare|sup<rsub|u\<in\><around|[|0,T|]>><around*|\||Y<rsup|T><rsub|u>-1|\|>\<geq\>\<epsilon\>>=0>,
      for any <math|\<epsilon\>\<gtr\>0>.

      <item>Define <math|L<rsup|T>\<assign\><big|int><rsub|0><rsup|\<cdot\>><around|(|1/Y<rsup|T><rsub|t->|)>*<space|0.17em>d*Y<rsup|T><rsub|t>>,
      i.e., <math|L<rsup|T>> is the stochastic logarithm of <math|Y<rsup|T>>,
      for each <math|T\<in\><Real><rsub|+>>. Then
      <math|lim<rsub|T\<to\>\<infty\>><prob><rsup|T><pare|<bra|L<rsup|T>,L<rsup|T>><rsub|T>\<geq\>\<epsilon\>>=0>,
      for any <math|\<epsilon\>\<gtr\>0>, where
      <math|<around|[|\<cdummy\>,\<cdummy\>|]><rsub|T>> is the square bracket
      on <math|<around|[|0,T|]>>.
    </enumerate>
  </lem>

  <\proof>
    This result follows from Theorem<nbsp>2.5 and Remark<nbsp>2.6 in
    <cite|Kardaras>. (Note that Theorem<nbsp>2.5 in <cite|Kardaras> is stated
    under a fixed probability <math|<wide|<prob>|\<bar\>>> and on a fixed
    time interval <math|<around|[|0,T|]>>, but its proof remains valid for a
    sequence of probability measures <rsub|<math|T\<in\><Real><rsub|+>>> and
    a family of time intervals <math|<around|{|<around|[|0,T|]>|}><rsub|T\<in\><Real><rsub|+>>>.)
  </proof>

  The next Lemma shows that once wealth reaches zero, it must stay at zero.

  <\lem>
    Let Assumptions <reference|ass: wealth proc> and <reference|ass:
    wellpose> hold. Then <math|<prob><around|(|X<rsub|s>=0,X<rsub|t>\<gtr\>0|)>=0>
    for all <math|0\<leq\>s\<less\>t\<leq\>T> and <math|X\<in\><X><rsup|T>>.
  </lem>

  <\proof>
    By contradiction, suppose there exist <math|0\<leq\>s\<less\>t\<leq\>T>
    and <math|\<xi\>\<in\><X><rsup|T>> such that the event
    <math|B<value|dfn><around|{|\<xi\><rsub|s>=0,\<xi\><rsub|t>\<gtr\>0|}>>
    is not <math|<prob>>-null. Let <math|\<zeta\>\<in\><X><rsup|T>> be
    strictly positive and set <math|\<xi\><rsup|n>=<around|(|1/<around|(|n+1|)>|)>*\<zeta\>+<around|(|n/<around|(|n+1|)>|)>*\<xi\>>
    for all <math|n\<in\><Natural>>; of course, <math|\<xi\><rsup|n>> is
    strictly positive and belongs to <math|<X><rsup|T>> for all
    <math|n\<in\><Natural>>. Now, let <math|A=\<supseteq\>B> and define
    <math|\<tau\>=s<indic><rsub|A>+T<indic><rsub|\<Omega\>\<setminus\>A>>.
    Then, <math|<prob><around|(|A|)>\<gtr\>0> and <math|\<tau\>> is a
    stopping time, so that <math|A=<around|{|\<tau\>\<less\>T|}>>. Following
    <math|\<zeta\>> until <math|\<tau\>>, then switching to
    <math|\<xi\><rsup|n>> at <math|\<tau\>>, and switching back to
    <math|\<zeta\>> at time <math|t>, construct
    <math|g<rsup|n>\<in\><X><rsup|T>> such that

    <\equation*>
      g<rsup|n><rsub|T>=\<zeta\><rsub|T><pare|<indic><rsub|\<Omega\>\<setminus\>A>+<frac|\<zeta\><rsub|s>|\<zeta\><rsub|t>>*<frac|\<xi\><rsup|n><rsub|t>|\<xi\><rsup|n><rsub|s>><indic><rsub|A>>=\<zeta\><rsub|T><pare|<indic><rsub|\<Omega\>\<setminus\>A>+<frac|\<zeta\><rsub|s>|\<zeta\><rsub|t>>*<frac|\<zeta\><rsub|t>+n*\<xi\><rsub|t>|\<zeta\><rsub|s>+n*\<xi\><rsub|s>><indic><rsub|A>>\<geq\>n*\<xi\><rsub|t>*<frac|\<zeta\><rsub|T>|\<zeta\><rsub|t>><indic><rsub|B>,
    </equation*>

    where the last inequality follows from <math|B\<subseteq\>A> and
    <math|\<xi\><rsub|s><indic><rsub|A>=0>. Now, suppose that
    <math|f\<in\><X><rsup|T>> maximizes expected power utility, and set
    <math|f<rsup|n>=<around|(|1-1/<sqrt|n>|)>*f+<around|(|1/<sqrt|n>|)>*g<rsup|n>>
    for <math|n\<in\><Natural>>. Since <math|<expec><rsup|<prob>><around|[|U*<around|(|\<alpha\>*f|)>|]>\<gtr\>-\<infty\>>
    holds for all <math|\<alpha\>\<in\><around|(|0,1|]>> (recall that
    <math|U> is a power utility and <math|<expec><rsup|<prob>><around|[|U<around|(|f|)>|]>\<gtr\>-\<infty\>>),
    and the inequality <math|f<rsup|n><rsub|T>\<geq\><around|(|1-1/<sqrt|n>|)>*f+<sqrt|n>*\<xi\><rsub|t>*<around|(|\<zeta\><rsub|T>/\<zeta\><rsub|t>|)><indic><rsub|B>>
    is valid, where the right-hand side in a nondecreasing sequence in
    <math|n\<in\><Natural>>, <math|<expec><rsup|<prob>><around|[|U<around|(|f<rsup|n>|)>|]>\<leq\><expec><rsup|<prob>><around|[|U<around|(|f|)>|]>>
    for all <math|n\<in\><Natural>> holds only if
    <math|<prob><around|(|B|)>=0>. This results contradicts the existence of
    <math|\<xi\>\<in\><X><rsup|T>> such that
    <math|<prob><around|(|\<xi\><rsub|s>=0,\<xi\><rsub|t>\<gtr\>0|)>\<gtr\>0>,
    completing the proof.
  </proof>

  Combining the previous lemmas with Theorems<nbsp><reference|thm: r-\<gtr\>1
  log> and <reference|thm: r-\<gtr\>1 power>, Theorem<nbsp><reference|thm:
  opt-port conv> is proved as follows.

  <\proof>
    <dueto|Proof of Theorem<nbsp><reference|thm: opt-port conv>>The
    statements follow from Lemma<nbsp><reference|lemma: stoch-log conv>
    directly, once we check that the assumptions of
    Lemma<nbsp><reference|lemma: stoch-log conv> are satisfied. First,
    <math|r<rsub|0><rsup|T>=1> since both investors have the same initial
    capital. Second, assuming <math|r<rsup|T><rsub|\<cdot\>>> being a
    <math|<prob><rsup|T>>-supermartingale for a moment, then
    <math|r<rsub|t><rsup|T>\<gtr\>0>, <math|<prob><rsup|T>>-a.s., for any
    <math|t\<leq\>T>, because <math|r<rsup|T><rsub|T>\<gtr\>0>,
    <math|<prob><rsup|T>>-a.s. (see Corollary<nbsp><reference|cor:
    opt\<gtr\>0> and Remark<nbsp><reference|rem: foc for CRRA>). Third,
    <math|lim<rsub|T\<to\>\<infty\>><expec><rsup|<prob><rsup|T>><bra|<around|\||r<rsup|T><rsub|T>-1|\|>>=0>
    follows from Theorems<nbsp><reference|thm: r-\<gtr\>1 log> and
    <reference|thm: r-\<gtr\>1 power>. Hence it remains to show that
    <math|r<rsup|T><rsub|\<cdot\>>> is a <math|<prob><rsup|T>>-supermartingale.

    Combining Assumption<nbsp><reference|ass: wealth proc> and the numraire
    property, it follows that <math|<expec><rsup|<prob><rsup|T>><bra|X<rsub|T>/X<rsup|0,T><rsub|T>>\<leq\>1>
    for any wealth process <math|X> such that
    <math|X<rsub|T>\<in\><C><rsup|T>>. Then for any
    <math|s\<less\>t\<leq\>T>, it remains to show that:

    <\equation>
      <label|eq: exp f/f><expec><rsup|<prob><rsup|T>><bra|X<rsub|t>/X<rsup|0,T><rsub|t>\|<F><rsub|s>>\<leq\>X<rsub|s>/X<rsup|0,T><rsub|s>.
    </equation>

    Both denominators in above inequality are nonzero, since
    <math|X<rsup|0,T><rsub|T>\<gtr\>0> and
    <math|<around|{|X<rsup|0,T><rsub|s>=0|}>\<subseteq\><around|{|X<rsup|0,T><rsub|t>=0|}>>
    for any <math|s\<leq\>t>. To prove <eqref|eq: exp f/f<rsup|0>>, fix any
    <math|A\<in\><F><rsub|s>>, and construct the wealth process
    <math|<wide|X|~>> via

    <\equation*>
      <wide|X|~><rsub|u>\<assign\><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|X<rsup|0,T><rsub|u>,>|<cell|u\<in\><around|[|0,s|)>>>|<row|<cell|X<rsup|0,T><rsub|s>*<frac|X<rsub|u>|X<rsub|s>><indic><rsub|A>+X<rsup|0,T><rsub|u><indic><rsub|\<Omega\>\<setminus\>A>,>|<cell|u\<in\><around|[|s,t|)>>>|<row|<cell|X<rsup|0,T><rsub|s>*<frac|X<rsub|t>|X<rsub|s>>*<frac|X<rsup|0,T><rsub|u>|X<rsup|0,T><rsub|t>><indic><rsub|A>+X<rsup|0,T><rsub|u><indic><rsub|\<Omega\>\<setminus\>A>,>|<cell|u\<in\><around|[|t,T|]>>>>>>|\<nobracket\>>.
    </equation*>

    The compounding property in Assumption<nbsp><reference|ass: wealth proc>
    implies that <math|<wide|X|~><rsub|T>\<in\><C><rsup|T>>. Noting that

    <\equation*>
      <frac|<wide|X|~><rsub|T>|X<rsup|0,T><rsub|T>>=<frac|X<rsub|s><rsup|0,T>|X<rsub|s>>*<frac|X<rsub|t>|X<rsup|0,T><rsub|t>><indic><rsub|A>+<indic><rsub|\<Omega\>\<setminus\>A>,
    </equation*>

    the claim follows from <math|<expec><rsup|<prob><rsup|T>><bra|<wide|X|~><rsub|T>/X<rsup|0,T><rsub|T>>\<leq\>1>
    and the arbitrary choice of <math|A>.
  </proof>

  <\proof>
    <dueto|Proof of Corollary<nbsp><reference|thm: power mayopic>>First, note
    that <math|<around|(|<frac|d<prob><rsup|T>|d<prob>>\|<rsub|<F><rsub|t>>|)><rsub|T\<geq\>0>>
    is a constant sequence. Indeed, for any <math|t\<leq\>T\<leq\>S>,

    <\equation*>
      <eqsplit|<tformat|<table|<row|<cell|<around*|\<nobracket\>|<frac|d<prob><rsup|S>|d<prob>>|\|><rsub|<F><rsub|t>>>|<cell|=<frac|<expec><rsub|t><rsup|<prob>><bra|<pare|X<rsub|S><rsup|0,S>><rsup|p>>|<expec><rsup|<prob>><bra|<pare|X<rsub|S><rsup|0,S>><rsup|p>>>=<frac|<expec><rsub|t><rsup|<prob>><bra|<pare|X<rsub|T><rsup|0,S>><rsup|p><pare|X<rsup|0,S><rsub|S>/X<rsup|0,S><rsub|T>><rsup|p>>|<expec><rsup|<prob>><bra|<pare|X<rsub|T><rsup|0,S>><rsup|p><pare|X<rsup|0,S><rsub|S>/X<rsup|0,S><rsub|T>><rsup|p>>>=<frac|<expec><rsub|t><rsup|<prob>><bra|<pare|X<rsub|T><rsup|0,S>><rsup|p>><expec><rsup|<prob>><rsub|t><bra|<pare|X<rsup|0,S><rsub|S>/X<rsup|0,S><rsub|T>><rsup|p>>|<expec><rsup|<prob>><bra|<pare|X<rsub|T><rsup|0,S>><rsup|p>><expec><rsup|<prob>><bra|<pare|X<rsup|0,S><rsub|S>/X<rsup|0,S><rsub|T>><rsup|p>>>>>|<row|<cell|>|<cell|=<frac|<expec><rsub|t><rsup|<prob>><bra|<pare|X<rsup|0,S><rsub|T>><rsup|p>>|<expec><rsup|<prob>><bra|<pare|X<rsup|0,S><rsub|T>><rsup|p>>>=<frac|<expec><rsub|t><rsup|<prob>><bra|<pare|X<rsup|0,T><rsub|T>><rsup|p>>|<expec><rsup|<prob>><bra|<pare|X<rsup|0,T><rsub|T>><rsup|p>>>=<around*|\<nobracket\>|<frac|d<prob><rsup|T>|d<prob>>|\|><rsub|<F><rsub|t>>.>>>>>
    </equation*>

    Here, the third equality follows from the assumption that
    <math|X<rsup|0,S><rsub|T>> and <math|X<rsup|0,S><rsub|S>/X<rsup|0,S><rsub|T>>
    are independent; the fourth equality holds since
    <math|X<rsup|0,S><rsub|S>/X<rsup|0,S><rsub|T>> is independent of
    <math|<F><rsub|t>>; and the fifth equality holds thanks to the myopic
    optimality <math|X<rsup|0,T><rsub|T>=X<rsup|0,S><rsub|T>>.

    Second, note that <math|<frac|d<prob><rsup|T>|d<prob>>> is a strictly
    positive martingale; see the discussion after <eqref|def: p<rsup|T>>, it
    then induces a probability measure <math|<wide|<prob>|~>>, which is
    equivalent to <math|<prob>> on <math|<F><rsub|t>>. As a result, the rest
    statements follows from Theorem<nbsp><reference|thm: opt-port conv> and
    Remark<nbsp><reference|rem: finite time> part iii) directly.
  </proof>

  <section|Proof of the Turnpike for Diffusions>

  This section proves the turnpike theorem for diffusions and the explicit
  turnpike. First, <math|v<rsup|T>> is constructed and its associated
  verification result is proved in Section<nbsp><reference|subsec: v>. Next,
  for a fixed <math|t\<gtr\>0> and <math|y\<in\>E>, the limiting behavior of
  <math|<frac|d<prob><rsup|T,y>|d<prob><rsup|y>>\|<rsub|<F><rsub|t>>> as
  <math|T\<to\>\<infty\>> is studied in Section<nbsp><reference|subsec:
  densities conv> . The proof of Proposition<nbsp><reference|thm: conv cond
  den> shows that the family of densities
  <math|<around|(|<frac|d<prob><rsup|T,y>|d<prob><rsup|y>>\|<rsub|\<cal-F\><rsub|t>>|)><rsub|T\<gtr\>0>>
  converges to the long-run density <math|<frac|d<wide|<prob>|^><rsup|y>|d<prob><rsup|y>>\|<rsub|\<cal-F\><rsub|t>>>
  when the coordinate process of

  <math|<around|(|<wide|<prob>|^><rsup|y>|)><rsub|y\<in\>E>> is positive
  recurrent. Finally, Theorems <reference|thm: power 1-factor> and
  <reference|cor: power 1-factor myopic> are proved in Section
  <reference|subsec: proof diffusion>.

  <\rem>
    <label|R:stoch>To ease notation, denote in the sequel:

    <\equation*>
      <Exp><pare|<big|int>H*<space|0.17em>d*W><rsub|t,s>\<assign\>exp
      <pare|<big|int><rsub|t><rsup|s>H<rsub|u>*<space|0.17em>d*W<rsub|u>-<frac|1|2>*<big|int><rsub|t><rsup|s><around|\<\|\|\>|H<rsub|u>|\<\|\|\>><rsup|2>*<space|0.17em>d*u><space|1em><text|for
      any integrand >H*<text|and >t\<leq\>s
    </equation*>

    and by <math|<Exp><pare|<big|int>H*<space|0.17em>d*W><rsub|t>=<Exp><pare|<big|int>H*<space|0.17em>d*W><rsub|0,t>>.
  </rem>

  <subsection|Construction of <math|v<rsup|T>>><label|subsec: v>

  As a solution to <eqref|eq: HJB>, <math|v<rsup|T>> is constructed via its
  long-run analogue <math|e<rsup|\<lambda\><rsub|c>*<around|(|T-\<cdot\>|)>>*<wide|v|^>>.
  Let us first construct the long-run measure
  <math|<around|(|<wide|<prob>|^><rsup|\<xi\>>|)><rsub|\<xi\>\<in\><Real><rsup|d>\<times\>E>>
  introduced after Assumption<nbsp><reference|ass: ptphat>.

  <\lem>
    <label|lemma: WP hat-P>Let Assumptions <reference|ass: regular coeffs>
    and <reference|ass: ptphat> hold<footnote|Condition <eqref|ass: posrec
    l1> is not needed for this Lemma.>. Then:

    <\enumerate>
      <item*|(i)>There exists a unique solution
      <math|<around|(|<wide|<prob>|^><rsup|\<xi\>>|)><rsub|\<xi\>\<in\><Real><rsup|d>\<times\>E>>
      to the martingale problem for <math|<wide|<cL>|^>> on
      <math|<Real><rsup|d>\<times\>E>;

      <item*|(ii)><math|<wide|<prob>|^><rsup|\<xi\>>\<sim\><prob><rsup|\<xi\>>>
      for any <math|\<xi\>\<in\><Real><rsup|d>\<times\>E>.
    </enumerate>
  </lem>

  <\proof>
    Let <math|\<Omega\><rsup|k>> be the space of continuous maps from
    <math|<around|[|0,\<infty\>|)>> into <math|<Real><rsup|k>>, and
    <math|<B><rsup|k>> its Borel sigma algebra. Note that
    <math|<around|(|\<Omega\>,<B>|)>=<around|(|\<Omega\><rsup|k+1>,<B><rsup|k+1>|)>>.
    According to <cite-detail|Pinsky|Theorem 5.1.1>, Assumption
    <reference|ass: WP hat-v> part <eqref|ass: recurrent> ensures a solution
    <math|<around|(|<prob><rsup|y><rsub|Y>|)><rsub|y\<in\>E>\<in\>M<rsub|1><around|(|\<Omega\><rsup|1>,<B><rsup|1>|)>>
    to the martingale problem for <math|<cL><rsup|<wide|v|^>,0>=<cL>+A*<frac|<wide|v|^><rsub|y>|<wide|v|^>>>
    on <math|E>, such that the coordinate process <math|Y> is recurrent in
    <math|E>. In particular <math|<prob><rsup|y><rsub|Y><around|(|Y<rsub|t>\<in\>E,\<forall\>t\<geq\>0|)>=1>,
    for any <math|y\<in\>E>. Therefore, with
    <math|<around*|(|<qprob><rsup|z>|)><rsub|z\<in\><Real><rsup|d>>> denoting
    Wiener measure on <math|<around|(|\<Omega\><rsup|d>,<B><rsup|d>|)>>, it
    follows that <math|<around*|(|<prob><rsup|\<xi\>><rsub|<wide|B|^>,Y>\<assign\><qprob><rsup|z>\<times\><prob><rsup|y><rsub|Y>|)><rsub|\<xi\>\<in\><Real><rsup|d>\<times\>E>>
    solves the martingale problem for <math|<cL><rsub|<wide|B|^>,Y>> on
    <math|<Real><rsup|d>\<times\>E>, where:

    <\equation*>
      <cL><rsub|<wide|B|^>,Y>=<frac|1|2>*<big|sum><rsub|i,j=1><rsup|d+1>A<rsup|<wide|B|^>,Y><rsub|i*j><around|(|\<xi\>|)><frac|\<partial\><rsup|2>|\<partial\>*\<xi\><rsub|i>*\<partial\>*\<xi\><rsub|j>>+<big|sum><rsub|i=1><rsup|d+1>b<rsup|<wide|B|^>,Y><rsub|i><around|(|\<xi\>|)><frac|\<partial\>|\<partial\>*\<xi\><rsub|i>>,<space|1em>A<rsup|<wide|B|^>,Y>=<pare|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|1<rsub|d>>|<cell|0>>|<row|<cell|0>|<cell|A>>>>>>,<space|1em>b<rsup|<wide|B|^>,Y>=<pare|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|0>>|<row|<cell|B+A*<frac|<wide|v|^><rsub|y>|<wide|v|^>>>>>>>>.
    </equation*>

    Set <math|<F><rsub|t>=<B><rsub|t+>> for <math|t\<geq\>0>. Since
    <math|A<rsup|<wide|B|^>,Y>> is non-degenerate and <math|A> satisfies
    Assumption <reference|ass: regular coeffs>, it follows that under
    <math|<prob><rsub|<wide|B|^>,Y><rsup|\<xi\>>>, there exist independent
    Wiener processes <math|<wide|W|^>> and <math|<wide|B|^>> such that
    <math|<around|(|<wide|B|^>,<wide|W|^>|)>> is a <math|d+1> dimensional
    Wiener process with respect to <math|<around|(|<F><rsub|t>|)><rsub|t\<geq\>0>>.
    Defining <math|<wide|Z|^>=\<rho\>*<wide|W|^>+<wide|\<rho\>|\<bar\>>*<wide|B|^>>
    and

    <\equation*>
      R<rsub|t>\<assign\>z+<big|int><rsub|0><rsup|t><frac|1|1-p>*<around|(|\<mu\>+\<delta\>*\<Upsilon\>*<frac|<wide|v|^><rsub|y>|<wide|v|^>>|)><around|(|Y<rsub|s>|)>*d*s+<big|int><rsub|0><rsup|t>\<sigma\><around|(|Y<rsub|s>|)>*d*<wide|Z|^><rsub|s>,
    </equation*>

    it follows that <math|<pare|<around|(|R,Y|)>,<around|(|<wide|Z|^>,<wide|W|^>|)>,<around|(|\<Omega\>,<F>,<around|(|<F><rsub|t>|)><rsub|t\<geq\>0>,<prob><rsub|<wide|B|^>,Y><rsup|\<xi\>>|)>>>
    solves <eqref|eq: phat sde>. Moreover, it follows from Assumption
    <reference|ass: regular coeffs> and <math|<prob><rsub|Y><rsup|y><around|(|Y<rsub|t>\<in\>E,\<forall\>t\<geq\>0|)>=1>
    that <math|<prob><rsup|\<xi\>><rsub|<wide|B|^>,Y><around|(|<around|(|R<rsub|t>,Y<rsub|t>|)>\<in\><Real><rsup|d>\<times\>E,\<forall\>t\<geq\>0|)>=1>
    for any <math|\<xi\>\<in\><Real><rsup|d>\<times\>E>.

    Since weak solutions induce solutions to the martingale problem via Ito's
    formula, it follows that if <math|<wide|<prob>|^><rsup|\<xi\>>\<in\>M<rsub|1><around|(|\<Omega\>,<F>|)>>
    is defined by <math|<wide|<prob>|^><rsup|\<xi\>><around|(|A|)>=<prob><rsup|\<xi\>><rsub|<wide|B|^>,Y><around|(|<around|(|R,Y|)>\<in\>A|)>>
    with <math|A\<in\><F>>, then <math|<around|(|<wide|<prob>|^><rsup|\<xi\>>|)><rsub|\<xi\>\<in\><Real><rsup|d>\<times\>E>>
    solves the martingale problem for <math|<wide|<cL>|^>>. Hence, the SDE
    <eqref|eq: phat sde> holds for the coordinate process
    <math|<around|(|R,Y|)>> under <math|<wide|<prob>|^><rsup|\<xi\>>>.

    The statement in part (ii) follows from
    <cite-detail|Cheridito-Filipovic-Yor|Remark 2.6>. Note that the
    assumption in <cite|Cheridito-Filipovic-Yor> is satisfied because of our
    Assumption <reference|ass: regular coeffs>, <math|<wide|v|^>\<gtr\>0> and
    <math|<wide|v|^>\<in\>C<rsup|2><around|(|E|)>> in Assumption
    <reference|ass: ptphat>, and the fact that
    <math|<prob><rsup|\<xi\>><around|(|<around|(|R<rsub|t>,Y<rsub|t>|)>\<in\><Real><rsup|d>\<times\>E,\<forall\>t\<geq\>0|)>=<wide|<prob>|^><rsup|\<xi\>><around|(|<around|(|R<rsub|t>,Y<rsub|t>|)>\<in\><Real><rsup|d>\<times\>E,\<forall\>t\<geq\>0|)>=1>
    for any <math|\<xi\>\<in\><Real><rsup|d>\<times\>E>.
  </proof>

  This is the proof for a sufficient condition for Assumption <reference|ass:
  ptphat>.

  <\proof>
    <dueto|Proof of Proposition <reference|prop: turnpike holds>>By Theorem
    18 in <cite|*>Guasoni-Robertson, under Assumptions <reference|ass:
    regular coeffs>, <reference|ass: WP P>, and <reference|ass: correl>,
    <eqref|eq: c decay requirement> yields the existence of a function
    <math|<wide|v|^>> which satisfies <eqref|eq: eign eqn>, <eqref|ass:
    recurrent>, along with the first inequality in <eqref|ass: posrec l1>. By
    Holder's inequality, <eqref|eq: m prob requirement> ensures that the
    second inequality in <eqref|ass: posrec l1> holds as well, proving the
    assertion.
  </proof>

  Recall that <math|<wide|<prob>|^><rsup|\<xi\>>> is denoted by
  <math|<wide|<prob>|^><rsup|y>> for <math|\<xi\>=<around|(|0,y|)>>. Now, to
  construct the solution <math|v<rsup|T>> to <eqref|eq: HJB>, introduce the
  auxiliary function <math|h<rsup|T>>, defined as:

  <\equation>
    <label|def: h>h<rsup|T><around|(|t,y|)>\<assign\><expec><rsup|<wide|<prob>|^><rsup|y>><bra|<pare|<wide|v|^><around|(|Y<rsub|T-t>|)>><rsup|-1>>,<space|1em><text|for
    ><around|(|t,y|)>\<in\><around|[|0,T|]>\<times\>E.
  </equation>

  Then, the candidate reduced value function <math|v<rsup|T>> is:

  <\equation>
    <label|def : v>v<rsup|T><around|(|t,y|)>\<assign\>e<rsup|\<lambda\><rsub|c>*<around|(|T-t|)>>*<wide|v|^><around|(|y|)>*h<rsup|T><around|(|t,y|)>.
  </equation>

  Thus, <math|h<rsup|T>> is the ratio between <math|v<rsup|T>> and its
  long-run analogue <math|e<rsup|\<lambda\><rsub|c>*<around|(|T-\<cdot\>|)>>*<wide|v|^>>.
  The verification result Proposition<nbsp><reference|lemma: HJB
  verification> below confirms that <math|v<rsup|T>> is a strictly positive
  classical solution to <eqref|eq: HJB> and the relation
  <math|u<rsup|T><around|(|t,x,y|)>=<frac|x<rsup|p>|p><around|(|v<rsup|T><around|(|t,y|)>|)><rsup|\<delta\>>>
  holds for <math|<around|(|t,x,y|)>\<in\><around|[|0,T|]>\<times\><Real><rsub|+>\<times\>E>.

  The next Proposition characterizes the function <math|h<rsup|T>>. Clearly,
  <math|h<rsup|T><around|(|t,y|)>\<gtr\>0> for
  <math|<around|(|t,y|)>\<in\><around|[|0,T|]>\<times\>E>.

  <\prop>
    <label|prop: v>Let Assumptions <reference|ass: regular coeffs>,
    <reference|ass: WP P>, <reference|ass: correl> and <reference|ass:
    ptphat> hold<footnote|Condition <eqref|ass: posrec l1> is not needed for
    this Proposition.>. Then <math|h<rsup|T><around|(|t,y|)>\<less\>\<infty\>>
    for all <math|<around|(|t,y|)>\<in\><around|[|0,T|]>\<times\>E>,
    <math|h<rsup|T><around|(|t,y|)>\<in\>C<rsup|1,2>*<around|(|<around|(|0,T|)>\<times\>E|)>>,
    and <math|h<rsup|T>> satisfies

    <\equation>
      <label|eq: pde-h>

      <eqsplit|<tformat|<table|<row|<cell|>|<cell|\<partial\><rsub|t>*h<rsup|T>+<cL><rsup|<wide|v|^>,0>h<rsup|T>=0,<space|1em><around|(|t,y|)>\<in\><around|(|0,T|)>\<times\>E,>>|<row|<cell|>|<cell|h<rsup|T><around|(|T,y|)>=<frac|1|<wide|v|^><around|(|y|)>>,<space|1em>y\<in\>E,>>>>>
    </equation>

    where <math|<cL><rsup|<wide|v|^>,0>\<assign\><cL>+A*<frac|<wide|v|^><rsub|y>|<wide|v|^>>*\<partial\><rsub|y>>.
  </prop>

  <\proof>
    To see that <math|h<rsup|T><around|(|t,y|)>\<less\>\<infty\>> for all
    <math|<around|(|t,y|)>\<in\><around|[|0,T|]>\<times\>E>, note that by
    <eqref|eq: phat L def> the generator for <math|Y> under
    <math|<wide|<prob>|^><rsup|y>> is <math|<cL><rsup|<wide|v|^>,0>=<cL>+A*<frac|<wide|v|^><rsub|y>|<wide|v|^>>*\<partial\><rsub|y>>.
    It follows from <eqref|eq: eign eqn> that

    <\equation>
      <label|eq: eqn-1/v><cL><rsup|<wide|v|^>,0><pare|<around|(|<wide|v|^>|)><rsup|-1>>=<around|(|c-\<lambda\><rsub|c>|)><around|(|<wide|v|^>|)><rsup|-1>*<space|1em><text|on
      >E.
    </equation>

    Combining the previous equation with <math|sup<rsub|y\<in\>E>
    c<around|(|y|)>\<less\>\<infty\>> in Assumption <reference|ass: correl>,
    we can find <math|K\<gtr\>0> such that

    <\equation*>
      <around*|(|\<partial\><rsub|t>+<cL><rsup|<wide|v|^>,0>|)><around*|(|<frac|e<rsup|-K*t>|<wide|v|^><around|(|y|)>>|)>\<leq\>0<space|1em><text|on
      ><around|[|0,T|]>\<times\>E.
    </equation*>

    Thus, using the strict positivity of <math|<wide|v|^>>, Assumption
    <reference|ass: regular coeffs> and Fatou's lemma, it follows that:

    <\equation>
      <label|eq: h>h<rsup|T><around|(|t,y|)>=<expec><rsup|<wide|<prob>|^>><bra|<pare|<wide|v|^><around|(|Y<rsub|T>|)>><rsup|-1><mid|\|>Y<rsub|t>=y>\<leq\><frac|e<rsup|K*<around|(|T-t|)>>|<wide|v|^><around|(|y|)>>\<less\>\<infty\>.
    </equation>

    It is next shown that <math|h<rsup|T>\<in\>C<rsup|1,2>*<around|(|<around|(|0,T|)>\<times\>E|)>>
    satisfies <eqref|eq: pde-h>. To this end, the classical version of the
    Feynman-Kac formula (see e.g. Theorem<nbsp>5.3 in
    <cite|friedman-stochastic> pp. 148) does not apply directly because a)
    the operator <math|<cL><rsup|<wide|v|^>,0>> is not assumed to be
    uniformly elliptic on <math|E>, and b)
    <math|<around|(|<wide|v|^>|)><rsup|-1>> may grow faster than polynomial
    near the boundary of <math|E>. Rather, the statement is proved using
    Theorem<nbsp>1 in <cite|Heath-Schweizer>, which yields that
    <math|h<rsup|T>> is a classical solution of <eqref|eq: pde-h>.

    To check that the assumptions of Theorem<nbsp>1 in <cite|Heath-Schweizer>
    are satisfied, note that, since <math|A> is locally Lipschitz on <math|E>
    due to Assumption<nbsp><reference|ass: regular coeffs>, Lemma 1.1 in
    <cite|friedman-stochastic> pp. 128 implies that <math|a> is also locally
    Lipschitz on <math|E>. On the other hand, the local Lipschitz continuity
    of <math|B+A*<frac|<wide|v|^><rsub|y>|<wide|v|^>>> is ensured by
    Assumption<nbsp><reference|ass: regular coeffs> and
    <math|<wide|v|^>\<in\>C<rsup|2><around|(|E|)>>. Hence (A1) in
    <cite|Heath-Schweizer> is satisfied. Second, (A2) in
    <cite|Heath-Schweizer> holds thanks to the well-posedness of the
    martingale problem <math|<around|(|<wide|<prob>|^>|)>>, in particular the
    coordinate process <math|Y> does not hit the boundary of <math|E> under
    <math|<wide|<prob>|^>>. Third, (A3') in <cite|Heath-Schweizer>,
    (A3a')-(A3d') are clearly satisfied under our assumptions.

    In order to check (A3e'), it suffices to show that <math|h<rsup|T>> is
    continuous in any compact sub-domain of
    <math|<around|(|0,T|)>\<times\>E>. To this end, recall that the domain is
    <math|E=<around|(|\<alpha\>,\<beta\>|)>> for
    <math|-\<infty\>\<leq\>\<alpha\>\<less\>\<beta\>\<leq\>\<infty\>>. Let
    <math|<around|{|\<alpha\><rsub|m>|}>> and
    <math|<around|{|\<beta\><rsub|m>|}>> two sequences such that
    <math|\<alpha\><rsub|m>\<less\>\<beta\><rsub|m>> for all <math|m>,
    <math|\<alpha\><rsub|m>> strictly decreases to <math|\<alpha\>>, and
    <math|\<beta\><rsub|m>> strictly increases to <math|\<beta\>>. Set
    <math|E<rsub|m>=<around|(|\<alpha\><rsub|m>,\<beta\><rsub|m>|)>>. For
    each <math|m> there exists a function
    <math|\<psi\><rsub|m><around|(|y|)>\<in\>C<rsup|\<infty\>><around|(|E|)>>
    such that a) <math|\<psi\><rsub|m><around|(|y|)>\<leq\>1>, b)
    <math|\<psi\><rsub|m><around|(|y|)>=1> on <math|E<rsub|m>>, and c)
    <math|\<psi\><rsub|m><around|(|y|)>=0> on
    <math|E\<cap\>E<rsup|c><rsub|m+1>>. To construct such
    <math|\<psi\><rsub|m>> let <math|<eps><rsub|m>=<frac|1|3>*min
    <around*|{|\<beta\><rsub|m+1>-\<beta\><rsub|m>,\<alpha\><rsub|m>-\<alpha\><rsub|m+1>|}>>
    and then take

    <\equation*>
      \<psi\><rsub|m><around|(|y|)>=\<eta\><rsub|<eps><rsub|m>>\<ast\><indic><rsub|<around|{|\<alpha\><rsub|m>-<eps><rsub|m>,\<beta\><rsub|m>+<eps><rsub|m>|}>><around|(|y|)>,
    </equation*>

    where <math|\<eta\><rsub|<eps><rsub|m>>> is the standard mollifier and
    <math|\<ast\>> is the convolution operator. Define the functions
    <math|f<rsub|m>> and <math|h<rsup|T,m>> by

    <\equation*>
      f<rsub|m><around|(|y|)>=<frac|\<psi\><rsub|m><around|(|y|)>|<wide|v|^><around|(|y|)>>*<space|1em><text|and
      ><space|1em>h<rsup|T,m><around|(|t,y|)>=<expec><rsup|<wide|P|^><rsup|y>><bra|f<rsub|m><around|(|Y<rsub|T-t>|)>>.
    </equation*>

    By construction, for all <math|y\<in\>E>,
    <math|\<uparrow\>*lim<rsub|m*\<uparrow\>*\<infty\>>
    f<rsub|m><around|(|y|)>=<around|(|<wide|v|^><around|(|y|)>|)><rsup|-1>>.
    It then follows from the monotone convergence theorem and <eqref|eq:
    h<rsup|T> ev finite> that <math|lim<rsub|m*\<uparrow\>*\<infty\>>
    h<rsup|T,m><around|(|t,y|)>=h<rsup|T><around|(|t,y|)>>.

    Since <math|<wide|v|^>\<in\>C<rsup|2><around|(|E|)>> and
    <math|<wide|v|^>\<gtr\>0>, each <math|f<rsub|m><around|(|y|)>\<in\>C<rsup|2><around|(|E|)>>
    is bounded. It then follows from the Feller property for
    <math|<wide|<prob>|^><rsup|y>> (see Theorem 1.13.1 in <cite|Pinsky>) that
    <math|h<rsup|T,m>> is continuous in <math|y>. On the other hand, by
    construction of <math|f<rsub|m>> and <eqref|eq: eqn-1/v>, there exists a
    constant <math|K<rsub|m>\<gtr\>0> such that

    <\equation>
      <label|eq: der est>a<around|\||<wide|f|\<dot\>><rsub|m>|\|>\<leq\>K<rsub|m>,<space|2em><around*|\||<cL><rsup|<wide|v|^>,0>f<rsub|m>|\|>\<leq\>K<rsub|m>,<space|1em><text|on
      >E.
    </equation>

    Moreover, Ito's formula gives that, for any
    <math|0\<leq\>s\<leq\>t\<leq\>T>,

    <\equation*>
      f<rsub|m><around|(|Y<rsub|t>|)>=f<rsub|m><around|(|Y<rsub|s>|)>+<big|int><rsub|s><rsup|t><cL><rsup|<wide|v|^>,0>f<rsub|m><around|(|Y<rsub|u>|)>*<space|0.17em>d*u+<big|int><rsub|s><rsup|t>a*<wide|f|\<dot\>><rsub|n><around|(|Y<rsub|u>|)>*<space|0.17em>d*<wide|W|^><rsub|u>.
    </equation*>

    Combining the previous equation with estimates in <eqref|eq: der est>, it
    follows that:

    <\equation*>
      sup<rsub|y\<in\>E><around*|\||<expec><rsup|<wide|<prob>|^><rsup|y>><bra|f<rsub|m><around|(|Y<rsub|t>|)>-f<rsub|m><around|(|Y<rsub|s>|)>>|\|>\<leq\>K<rsub|m>*<around|(|t-s|)>.
    </equation*>

    Therefore, <math|h<rsup|T,m>> is uniformly continuous in <math|t>.
    Combining with the continuity of <math|h<rsup|T,m>> in <math|y>, we
    conclude that <math|h<rsup|T,m>> is jointly continuous in
    <math|<around|(|t,y|)>> on <math|<around|[|0,T|]>\<times\>E>.

    Note that the operator <math|<cL><rsup|<wide|v|^>,0>> is uniformly
    elliptic in the parabolic domain <math|<around|(|0,T|)>\<times\>E<rsub|m>>.
    It then follows from a straightforward calculation that
    <math|h<rsup|T,m>> satisfies the differential equation:

    <\equation*>
      <eqsplit|<tformat|<table|<row|<cell|\<partial\><rsub|t>*h<rsup|T,m>+<cL><rsup|<wide|v|^>,0>h<rsup|T,m>>|<cell|=0<space|1em><around|(|t,y|)>\<in\><around|(|0,T|)>\<times\>E<rsub|m>.>>|<row|<cell|>|<cell|>>>>>
    </equation*>

    Note that <math|<around|(|h<rsup|T,m>|)><rsub|m\<geq\>0>> is uniformly
    bounded from above by <math|h<rsup|T>>, which is finite on
    <math|<around|[|0,T|]>\<times\>E<rsub|m>>. Appealing to the <em|interior
    Schauder estimate> (see e.g. Theorem<nbsp>15 in <cite|friedman-parabolic>
    pp. 80), there exists a subsequence <math|<around|(|h<rsup|T,m<rprime|'>>|)><rsub|m<rprime|'>>>
    which converges to <math|h<rsup|T>> uniformly in
    <math|<around|(|0,T|)>\<times\>D> for any compact sub-domain <math|D> of
    <math|E<rsub|m>>. Since each <math|h<rsup|T,m<rprime|'>>> is continuous
    and the convergence is uniform, we confirm that <math|h<rsup|T>> is
    continuous in <math|<around|(|0,T|)>\<times\>D>. Since the choice of
    <math|D> is arbitrary in <math|E<rsub|m>>, (A3e') in
    <cite|Heath-Schweizer> is satisfied.
  </proof>

  We prepare for the verification result in Proposition <reference|lemma: HJB
  verification> by introducing some notation. Let Assumption <reference|ass:
  regular coeffs> and <reference|ass: WP P> hold. For any
  <math|w<around|(|t,y|)>:<around|[|0,T|]>\<times\>E> which is strictly
  positive and in <math|C<rsup|1,2>*<around|(|<around|(|0,T|)>\<times\>E|)>>,
  define the process

  <\equation>
    <label|eq: D>D<rsup|w><rsub|t>\<assign\><Exp><around*|(|<big|int><around*|(|-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+A*<frac|w<rsub|y>|w>|)><rprime|'>*<frac|1|a>*d*W-q*<big|int><around*|(|\<Sigma\><rsup|-1>*\<mu\>+\<Sigma\><rsup|-1>*\<Upsilon\>*\<delta\>*<frac|w<rsub|y>|w>|)><rprime|'>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B|)><rsub|t>,
  </equation>

  where <math|<around|(|B,W|)>> is a <math|d+1> dimensional
  <math|<around|(|<prob><rsup|y>,<around|(|<F><rsub|t>|)><rsub|t\<geq\>0>|)>>
  Wiener process. For <math|t\<leq\>s\<leq\>T> define
  <math|D<rsup|w><rsub|t,s>> as in Remark <reference|R:stoch>. Set the
  portfolio

  <\equation>
    <label|eq: pi>\<pi\><rsup|w>=<frac|1|1-p>*\<Sigma\><rsup|-1>*<around*|(|\<mu\>+\<delta\>*\<Upsilon\>*<frac|w<rsub|y>|w>|)>
  </equation>

  evaluated at <math|<around|(|t,Y<rsub|t>|)>> and let
  <math|X<rsup|\<pi\><rsup|w>>> denote the wealth process. Set
  <math|\<eta\><rsup|w>=\<delta\>*<frac|w<rsub|y>|w>> and define the process
  <math|M<rsup|\<eta\><rsup|w>>> via

  <\equation>
    <label|eq: eta>M<rsup|\<eta\><rsup|w>><rsub|t>=e<rsup|-<big|int><rsub|0><rsup|t>r*d*t><Exp><around*|(|<big|int><around*|(|-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+<around|(|A-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>*\<eta\><rsup|w>|)><rprime|'>*<frac|1|a>*d*W-<big|int><around*|(|\<Sigma\><rsup|-1>*\<mu\>+\<Sigma\><rsup|-1>*\<Upsilon\>*\<eta\><rsup|w>|)><rprime|'>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B|)><rsub|t>.
  </equation>

  The following Proposition plays a central role to verify the optimality of
  both finite horizon and long-run optimal portfolios as well as comparing
  their terminal wealths. A similar statement for the long-run limit is
  proved in <cite-detail|Guasoni-Robertson|Theorem 7>.

  <\prop>
    <label|prop: Ito-Girsanov result>Let Assumptions <reference|ass: regular
    coeffs> and <reference|ass: WP P> hold. Assume there exists a function
    <math|w:<around|[|0,T|]>\<times\>E\<to\><Real>> and a constant
    <math|\<lambda\>\<in\><Real>>, such that
    <math|w\<in\>C<rsup|1,2>*<around|(|<around|(|0,T|)>\<times\>E,<Real>|)>>
    is strictly positive and satisfies the differential expression

    <\equation*>
      \<partial\><rsub|t>*w+<cL>w+<around|(|c-\<lambda\>|)>*w=0,<space|1em><around|(|t,y|)>\<in\><around|(|0,T|)>\<times\>E.
    </equation*>

    Then the following conclusions hold:

    <\enumerate>
      <item>For all admissible portfolios <math|\<pi\>> and all
      <math|y\<in\>E>, the process <math|X<rsup|\<pi\>>*M<rsup|\<eta\><rsup|w>>>
      is a non-negative supermartingale under <math|<prob><rsup|y>> where
      <math|M<rsup|\<eta\><rsup|w>>> is given in <eqref|eq: eta<rsub|w>>.

      <item>For all <math|t\<leq\>s\<leq\>T> and <math|y\<in\>E> the
      processes <math|X<rsup|\<pi\><rsup|w>>> and
      <math|M<rsup|\<eta\><rsup|w>>> satisfy the <math|<prob><rsup|y>> almost
      sure identities

      <\equation>
        <label|eq: primal dual as eq>

        <eqsplit|<tformat|<table|<row|<cell|<around*|(|X<rsup|\<pi\><rsup|w>><rsub|s>|)><rsup|p>>|<cell|=<around*|(|X<rsup|\<pi\><rsup|w>><rsub|t>|)><rsup|p>*<around*|(|w<around|(|t,Y<rsub|t>|)>*e<rsup|\<lambda\>*<around|(|s-t|)>>|)><rsup|\<delta\>>*D<rsup|w><rsub|t,s>*w<around|(|s,Y<rsub|s>|)><rsup|-\<delta\>>,>>|<row|<cell|<around*|(|M<rsup|\<eta\><rsup|w>><rsub|s>|)><rsup|q>>|<cell|=<around*|(|M<rsup|\<eta\><rsup|w>><rsub|t>|)><rsup|q>*<around*|(|w<around|(|t,Y<rsub|t>|)>*e<rsup|\<lambda\>*<around|(|s-t|)>>|)><rsup|<frac|\<delta\>|1-p>>*D<rsup|w><rsub|t,s>*w<around|(|s,Y<rsub|s>|)><rsup|-<frac|\<delta\>|1-p>>,>>|<row|<cell|>|<cell|>>>>>
      </equation>

      where <math|\<pi\><rsup|w>>, <math|M<rsup|\<eta\><rsup|w>>> and
      <math|D<rsup|w>> are as in <eqref|eq: pi<rsub|w>>, <eqref|eq:
      eta<rsub|w>> and <eqref|eq: D<rsub|h>atpw<rsub|p>> respectively.
    </enumerate>
  </prop>

  <\proof>
    Given upon <math|w>, it is clear, using stochastic integration by parts,
    that for <math|i=1,\<ldots\>,d> the process
    <math|M<rsup|\<eta\><rsup|w>>*S<rsup|i>> is a non-negative
    supermartingale under <math|<prob><rsup|y>> for any <math|y\<in\>E>.
    Thus, part <math|<around|(|i|)>> follows.

    It remains the show the almost-sure identities. To this end fix
    <math|t\<leq\>s\<leq\>T>. By <eqref|eq: wealth dynamics> it follows that

    <\equation>
      <label|eq: primal dual rel>

      <eqsplit|<tformat|<table|<row|<cell|<frac|<around*|(|X<rsup|\<pi\><rsup|w>><rsub|s>|)><rsup|p>|<around*|(|X<rsup|\<pi\><rsup|w>><rsub|t>|)><rsup|p>>>|<cell|=exp
      <around*|(|<big|int><rsub|t><rsup|s><around*|(|p*\<mu\><rprime|'>*\<pi\><rsup|w>+p*r-<frac|p|2><around|(|\<pi\><rsup|w>|)><rprime|'>*\<Sigma\>*\<pi\><rsup|w>|)>*d*\<tau\>+p*<big|int><rsub|t><rsup|s><around|(|\<pi\><rsup|w>|)><rprime|'>*\<sigma\>*d*Z<rsub|\<tau\>>|)>,>>|<row|<cell|<frac|<around*|(|M<rsup|\<eta\><rsup|w>><rsub|s>|)><rsup|q>|<around*|(|M<rsup|\<eta\><rsup|w>><rsub|t>|)><rsup|q>>>|<cell|=e<rsup|-q*<big|int><rsub|t><rsup|s>r*d*\<tau\>><Exp><around*|(|<big|int><around*|(|-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+<around|(|A-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>*\<eta\><rsup|w>|)><rprime|'>*<frac|1|a>*d*W-<big|int><around*|(|\<Sigma\><rsup|-1>*\<mu\>+\<Sigma\><rsup|-1>*\<Upsilon\>*\<eta\><rsup|w>|)><rprime|'>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B|)><rsup|q><rsub|t,s>.>>>>>
    </equation>

    To prove the first equality, it suffices to show, by taking logarithms
    and expanding <math|Z=\<rho\>*W+<wide|\<rho\>|\<bar\>>*B> that

    <multline|<tformat|<table|<row|<cell|<label|eq:
    trading><big|int><rsub|t><rsup|s><around*|(|p*\<mu\><rprime|'>*\<pi\><rsup|w>+p*r-<frac|p|2><around|(|\<pi\><rsup|w>|)><rprime|'>*\<Sigma\>*\<pi\><rsup|w>|)>*d*\<tau\>+p*<big|int><rsub|t><rsup|s><around|(|\<pi\><rsup|w>|)><rprime|'>*\<sigma\>*\<rho\>*d*W<rsub|\<tau\>>+p*<big|int><rsub|t><rsup|s><around|(|\<pi\><rsup|w>|)><rprime|'>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B<rsub|\<tau\>>>>|<row|<cell|=\<delta\>*log
    w<around|(|t,Y<rsub|t>|)>+\<delta\>*\<lambda\>*<around|(|s-t|)>+log
    D<rsup|w><rsub|t,s>-\<delta\>*log w<around|(|s,Y<rsub|s>|)>.>>>>>

    Multidimensional notation makes calculations more transparent. Set
    <math|\<omega\>\<assign\>\<delta\>*log w>. Then <math|\<omega\>> solves
    the semi-linear differential expression

    <\equation*>
      \<partial\><rsub|t>*\<omega\>+<cL>\<omega\>+<frac|1|2>*\<nabla\>*\<omega\><rprime|'>*<around*|(|A-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>*\<nabla\>*\<omega\>+\<delta\>*<around|(|c-\<lambda\>|)>=0,<space|1em><around|(|t,y|)>\<in\><around|(|0,T|)>\<times\>E,
    </equation*>

    because <math|\<delta\><rsup|-1>*A=A-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>>.
    Since <math|<cL>=<frac|1|2>*A*\<partial\><rsub|y*y>+<around|(|b-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>|)>*\<partial\><rsub|y>>,
    Ito's formula implies that <em|under <math|<prob><rsup|y>>> (see
    <eqref|eq: state sde>), and expanding
    <math|c=<frac|1|\<delta\>>*<around*|(|p*r-<frac|1|2>*q*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>|)>>:

    <multline|<tformat|<table|<row|<cell|<label|E:temp>\<delta\>*log
    w<around|(|s,Y<rsub|s>|)>-\<delta\>*log
    w<around|(|t,Y<rsub|t>|)>=>>|<row|<cell|<big|int><rsub|t><rsup|s><around*|(|q*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>*\<nabla\>*\<omega\>-<frac|1|2>*\<nabla\>*\<omega\><rprime|'>*<around|(|A-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>*\<nabla\>*\<omega\>+\<delta\>*\<lambda\>-<around*|(|p*r-<frac|1|2>*q*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>|)>|)>*d*\<tau\>+<big|int><rsub|t><rsup|s>\<nabla\>*\<omega\><rprime|'>*a*d*W<rsub|\<tau\>>.>>>>>

    Again, using <math|\<delta\><rsup|-1>*A=A-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>>
    and noting that <math|\<delta\>*<frac|w<rsub|y>|w>=\<omega\><rsub|y>>,
    after some simplifications it follows that:

    <\equation>
      <label|E:temp>

      <eqsplit|<tformat|<table|<row|<cell|log
      D<rsup|w><rsub|t,s>>|<cell|=<big|int><rsub|t><rsup|s><around*|(|-q*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>+\<nabla\>*\<omega\><rprime|'>*<around|(|A-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>|)>*<frac|1|a>*d*W>>|<row|<cell|>|<cell|-q*<big|int><rsub|t><rsup|s><around*|(|\<mu\><rprime|'>*\<Sigma\><rsup|-1>+\<nabla\>*\<omega\>*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>|)>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B>>|<row|<cell|>|<cell|+<big|int><rsub|t><rsup|s><around*|(|-<frac|1|2>*q<rsup|2>*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+q*<around|(|1-q|)>*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>*\<nabla\>*\<omega\>-<frac|1|2>*\<nabla\>*\<omega\><rprime|'>*<around*|(|A-<around|(|2*q-q<rsup|2>|)>*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>*\<nabla\>*\<omega\>|)>*d*\<tau\>.>>>>>
    </equation>

    Lastly, plugging in for <math|\<pi\><rsup|w>> yields

    <\equation>
      <label|E:temp>

      <eqsplit|<tformat|<table|<row|<cell|>|<cell|<big|int><rsub|t><rsup|s><around*|(|p*\<mu\><rprime|'>*\<pi\><rsup|w>+p*r-<frac|p|2><around|(|\<pi\><rsup|w>|)><rprime|'>*\<Sigma\>*\<pi\><rsup|w>|)>*d*\<tau\>+p*<big|int><rsub|t><rsup|s><around|(|\<pi\><rsup|w>|)><rprime|'>*\<sigma\>*\<rho\>*d*W<rsub|\<tau\>>+p*<big|int><rsub|t><rsup|s><around|(|\<pi\><rsup|w>|)><rprime|'>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B<rsub|\<tau\>>>>|<row|<cell|>|<cell|=<big|int><rsub|t><rsup|s><around*|(|p*r-<frac|1|2>*q*<around|(|1+q|)>*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>-q<rsup|2>*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>*\<nabla\>*\<omega\>-<frac|1|2>*q*<around|(|q-1|)>*\<nabla\>*\<omega\><rprime|'>*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>*\<nabla\>*\<omega\>|)>*d*\<tau\>>>|<row|<cell|>|<cell|<space|2em>-q*<big|int><rsub|t><rsup|s><around*|(|\<mu\><rprime|'>+\<nabla\>*\<omega\><rprime|'>*\<Upsilon\><rprime|'>|)>*\<Sigma\><rsup|-1>*\<sigma\>*\<rho\>*d*W<rsub|\<tau\>>-q*<big|int><rsub|t><rsup|s><around*|(|\<mu\><rprime|'>+\<nabla\>*\<omega\><rprime|'>*\<Upsilon\><rprime|'>|)>*\<Sigma\><rsup|-1>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B<rsub|\<tau\>>.>>>>>
    </equation>

    Now, using <eqref|E:temp<rsub|p>1>, <eqref|E:temp<rsub|p>2> and
    <eqref|E:temp<rsub|p>3>, the equality in <eqref|eq: trading<rsub|e>qual>
    follows by matching the respective <math|d*\<tau\>>, <math|d*W> and
    <math|d*B> terms.

    The proof for the second identity in <eqref|eq: primal dual as eq> is
    similar. Given <eqref|eq: primal dual rel>, it suffices to show that, by
    taking logarithms

    <multline|<tformat|<table|<row|<cell|<label|eq: dual
    equal><big|int><rsub|t><rsup|s>r*d*\<tau\>+log
    <Exp><around*|(|<big|int><around*|(|-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+<around|(|A-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>*\<eta\><rsup|w>|)>*<frac|1|a>*d*W-<big|int><around*|(|\<Sigma\><rsup|-1>*\<mu\>+\<Sigma\><rsup|-1>*\<Upsilon\>*\<eta\><rsup|w>|)>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B|)><rsub|t,s>>>|<row|<cell|=<frac|\<delta\>|1-p>*log
    w<around|(|t,Y<rsub|t>|)>+<frac|\<delta\>|1-p>*\<lambda\>*<around|(|s-t|)>+log
    D<rsup|w><rsub|t,s>-<frac|\<delta\>|1-p>*log
    w<around|(|s,Y<rsub|s>|)>.>>>>>

    The equality in <eqref|E:temp<rsub|p>1> (multiplied by
    <math|<frac|1|1-p>>), combined with that in <eqref|E:temp<rsub|p>2> yield
    an expression for the right hand side of the above equation in terms of
    integrals from <math|s> to <math|t> of <math|d*\<tau\>,d*W> and
    <math|d*B>. As for the left hand side, a lengthy calculation shows that

    <\equation>
      <label|E:temp>

      <eqsplit|<tformat|<table|<row|<cell|>|<cell|<big|int><rsub|t><rsup|s>q*r*d*\<tau\>+q*log
      <Exp><around*|(|<big|int><around*|(|-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+<around|(|A-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>*\<eta\><rsup|w>|)><rprime|'>*<frac|1|a>*d*W-<big|int><around*|(|\<Sigma\><rsup|-1>*\<mu\>+\<Sigma\><rsup|-1>*\<Upsilon\>*\<eta\><rsup|w>|)><rprime|'>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B|)><rsub|t,s>>>|<row|<cell|=>|<cell|<big|int><rsub|t><rsup|s><around*|(|-q*r-<frac|1|2>*q*\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>-<frac|1|2>*q*\<nabla\>*\<omega\><rprime|'>*<around|(|A-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>*\<nabla\>*\<omega\>|)>*d*\<tau\>>>|<row|<cell|>|<cell|+q*<big|int><rsub|t><rsup|s><around*|(|-\<mu\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>+\<nabla\>*\<omega\><rprime|'>*<around|(|A-\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<Upsilon\>|)>|)>*<frac|1|a>*d*W<rsub|\<tau\>>>>|<row|<cell|>|<cell|-q*<big|int><rsub|t><rsup|2><around*|(|\<mu\><rprime|'>*\<Sigma\><rsup|-1>+\<nabla\>*\<omega\><rprime|'>*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>|)>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B<rsub|\<tau\>>.>>>>>
    </equation>

    Thus, using <eqref|E:temp<rsub|p>1>, <eqref|E:temp<rsub|p>2> and
    <eqref|E:temp<rsub|p>4>, the equality in <eqref|eq: dual equal> follows
    by matching <math|d*\<tau\>,d*W> and <math|d*B> terms.
  </proof>

  Now we are ready to state the verification result for the finite horizon
  problem.

  <\prop>
    <label|lemma: HJB verification>Let Assumptions <reference|ass: regular
    coeffs>, <reference|ass: WP P>, <reference|ass: correl> and Assumption
    <reference|ass: ptphat> hold<footnote|Condition <eqref|ass: posrec l1> is
    not needed for this Proposition.>. Then:

    <\enumerate>
      <item><math|v<rsup|T>> has the stochastic representation:

      <\equation>
        <label|eq: stoch rep v>v<rsup|T><around|(|t,y|)>=<expec><rsup|<prob>><bra|exp
        <pare|<big|int><rsub|t><rsup|T>c<around|(|Y<rsub|s>|)>*d*s><mid|\|>Y<rsub|t>=y>,<space|1em><text|for
        ><around|(|t,y|)>\<in\><around|[|0,T|]>\<times\>E.
      </equation>

      <item><math|v<rsup|T>\<gtr\>0>, <math|v<rsup|T>\<in\>C<rsup|1,2>*<around|(|<around|(|0,T|)>\<times\>E|)>>,
      and it solves <eqref|eq: HJB>.

      <item><math|u<rsup|T><around|(|t,x,y|)>=<frac|x<rsup|p>|p><pare|v<rsup|T><around|(|t,y|)>><rsup|\<delta\>>>
      on <math|<around|[|0,T|]>\<times\><Real><rsub|+>\<times\>E> and
      <math|\<pi\><rsup|T>> in <eqref|eq: finite opt> is the optimal
      portfolio.
    </enumerate>
  </prop>

  <\rem>
    <label|rem: stoch rep v>The representation <eqref|eq: stoch rep
    v<rsup|T>> has been shown in Remark<nbsp>3.4 of <cite|Zariphopoulou>. We
    provide a novel proof which ties to the <math|h>-transform
    <cite-detail|Pinsky|Chapter 4> of <math|<cL>+c>.
  </rem>

  <\proof>
    Items (i) and (ii) are proved first. Given that <math|h<rsup|T>> solves
    <eqref|eq: pde-h>, long but straightforward calculations using <eqref|eq:
    eign eqn> show that <math|v<rsup|T>> solves <eqref|eq: HJB>. Moreover,
    <math|v<rsup|T>\<in\>C<rsup|1,2>*<around|(|<around|(|0,T|)>\<times\>E|)>>
    because <math|<wide|v|^>\<in\>C<rsup|2><around|(|E|)>> and
    <math|h<rsup|T>\<in\>C<rsup|1,2>*<around|(|<around|(|0,T|)>\<times\>E|)>>.

    To prove the stochastic representation in <eqref|eq: stoch rep
    v<rsup|T>>, define the operator:

    <\equation*>
      <cL><rsup|<wide|v|^>>\<assign\><cL><rsup|<wide|v|^>,0>+\<lambda\><rsub|c>.
    </equation*>

    where <math|<cL><rsup|<wide|v|^>,0>> is the same as in Proposition
    <reference|prop: v>. It is the <math|h>-transform of <math|<cL>+c> with
    <math|h=<wide|v|^>> <cite-detail|Pinsky|Chapter 4.2>. Following the
    notation in <cite-detail|Pinsky|Chapter 4.0>, define the transition
    measure <math|<wide|p|^>*<around|(|t,y,d*z|)>> of
    <math|<cL><rsup|<wide|v|^>>> on <math|E> by

    <\equation>
      <label|def: hat p><wide|p|^><around|(|s,y,B|)>\<assign\><expec><rsup|<wide|<prob>|^><rsup|y>><bra|e<rsup|\<lambda\><rsub|c>*s><space|0.17em><indic><rsub|B>>,<space|1em><text|for
      any measurable >B\<subseteq\>E;
    </equation>

    and the transition measure <math|p*<around|(|t,y,d*z|)>> for the operator
    <math|<cL>+c> on <math|E> by

    <\equation>
      <label|def: p>p<around|(|s,y,B|)>\<assign\><expec><rsup|<prob><rsup|y>><bra|exp
      <pare|<big|int><rsub|0><rsup|s>c<around|(|Y<rsub|s>|)>*d*s><space|0.17em><indic><rsub|B>>,<space|1em><text|for
      any measurable >B\<subseteq\>E,
    </equation>

    where <math|c<around|(|y|)>> is from Assumption <reference|ass: correl>.
    These two transition measures are related by the following identity
    <cite-detail|Pinsky|Theorem 4.1.1>:

    <\equation>
      <label|eq: density relation><wide|v|^><around|(|y|)>*<wide|p|^>*<around|(|s,y,d*z|)><frac|1|<wide|v|^><around|(|z|)>>=p*<around|(|s,y,d*z|)>,<space|1em><text|for
      any >s\<geq\>0,y,z\<in\>E.
    </equation>

    Thus, choosing <math|s=T-t> in <eqref|eq: density relation> and
    integrating both sides on <math|E>, the Markov property implies that:

    <\equation*>
      v<rsup|T><around|(|y,t|)>=e<rsup|\<lambda\><rsub|c>*<around|(|T-t|)>>*<wide|v|^><around|(|y|)><space|0.17em><expec><rsup|<wide|<prob>|^><rsup|y>><bra|<pare|<wide|v|^><around|(|Y<rsub|T>|)>><rsup|-1><mid|\|>Y<rsub|t>=y>=<expec><rsup|<prob><rsup|y>><bra|exp
      <pare|<big|int><rsub|t><rsup|T>c<around|(|Y<rsub|s>|)>*d*s><mid|\|>Y<rsub|t>=y>,
    </equation*>

    where the first identity follows from <eqref|def: h<rsup|T>> and the
    definition of <math|v<rsup|T>> in <eqref|def : v<rsup|T>>. This proves
    <eqref|eq: stoch rep v<rsup|T>>. Given <eqref|eq: stoch rep v<rsup|T>>
    the strict positivity of <math|v<rsup|T>> follows immediately.

    It remains to show the verification result in item
    <math|<around|(|i*i*i|)>>. By applying Proposition <reference|prop:
    Ito-Girsanov result> to <math|w=v<rsup|T>,\<lambda\>=0> it follows by
    evaluating <eqref|eq: primal dual as eq> at <math|t=t,s=T> that for the
    portfolio in <eqref|eq: finite opt> and the process
    <math|M<rsup|\<eta\><rsup|v<rsup|T>>>> from <eqref|eq: eta<rsub|w>>

    <\equation>
      <label|eq: opt wealth integ value><expec><rsup|<prob><rsup|y>><bra|<frac|1|p><around*|(|X<rsup|\<pi\><rsup|T>><rsub|T>|)><rsup|p><mid|\|>X<rsub|t>=x,Y<rsub|t>=y>=<frac|x<rsup|p>|p><around*|(|v<rsup|T><around|(|t,y|)>|)><rsup|\<delta\>><expec><rsup|<prob><rsup|y>><bra|D<rsup|v<rsup|T>><rsub|t,T><mid|\|>X<rsub|t>=x,Y<rsub|t>=y>,
    </equation>

    since <math|v<rsup|T><around|(|T,y|)>=1>. In a similar manner

    <\equation*>
      <frac|x<rsup|p>|p><expec><rsup|<prob><rsup|y>><bra|<around*|(|M<rsup|\<eta\><rsup|v<rsup|T>>><rsub|T>|)><rsup|q><mid|\|>X<rsub|t>=x,Y<rsub|t>=y><rsup|1-p>=<frac|x<rsup|p>|p><around*|(|v<rsup|T><around|(|t,y|)>|)><rsup|\<delta\>><expec><rsup|<prob><rsup|y>><bra|D<rsup|v<rsup|T>><rsub|t,T><mid|\|>X<rsub|t>=x,Y<rsub|t>=y><rsup|1-p>.
    </equation*>

    Therefore, thanks to duality results for power utility between payoffs
    and stochastic discount factors <cite-detail|Guasoni-Robertson|Lemma 5>,
    the claims in part <math|<around|(|i*i*i|)>> of Proposition
    <reference|lemma: HJB verification> will follow if it can be shown that
    <math|D<rsup|v<rsup|T>>> is a <math|<prob><rsup|y>> martingale for all
    <math|y\<in\>E>.

    To this end, note that for <math|w=<wide|v|^>> the process of <eqref|eq:
    D<rsub|h>atpw<rsub|p>> is precisely the stochastic exponential which
    changes the dynamics from <math|<prob><rsup|y>> to those for
    <math|<wide|<prob>|^><rsup|y>>. It follows from part (ii) of
    Lemma<nbsp><reference|lemma: WP hat-P> and the backward martingale
    theorem <cite-detail|Cheridito-Filipovic-Yor|Remark 2.3.2> that
    <math|D<rsup|<wide|v|^>>> is a <math|<around|(|<wide|<prob>|^><rsup|y>,<around|(|<F><rsub|t>|)><rsub|t\<geq\>0>|)>>
    martingale. Therefore, it follows that

    <\equation>
      <label|eq: p phat rn><frac|d<wide|<prob>|^><rsup|y>|d<prob><rsup|y>><mid|\|><rsub|<F><rsub|t>>=D<rsup|<wide|v|^>><rsub|t>.
    </equation>

    Furthermore, the Brownian motions <math|<wide|B|^>,<wide|W|^>> from
    <eqref|eq: phat sde> are related to <math|B,W> by

    <\equation*>
      <eqsplit|<tformat|<table|<row|<cell|<wide|B|^>>|<cell|=B+q*<wide|\<rho\>|\<bar\>>*\<sigma\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+q*\<Delta\><rprime|'>*a*<frac|<wide|v|^><rsub|y>|<wide|v|^>>,>>|<row|<cell|<wide|W|^>>|<cell|=W+q*\<rho\>*\<sigma\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>-a*<frac|<wide|v|^><rsub|y>|<wide|v|^>>,>>>>>
    </equation*>

    where <math|\<Delta\>=q*\<delta\>*\<rho\><rprime|'>*<wide|\<rho\>|\<bar\>>>.
    The dynamics of <math|Y> under <math|<wide|<prob>|^><rsup|y>> are given
    in <eqref|eq: phat sde>. Using the differential expression for <math|h>
    in <eqref|eq: pde-h>, Ito's formula implies for all <math|t> that

    <\equation>
      <label|eq: h><frac|h<rsup|T><around|(|t,Y<rsub|t>|)>|h<rsup|T><around|(|0,y|)>>=<Exp><pare|<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*d*<wide|W|^><rsub|s>><rsub|t>.
    </equation>

    It follows from <eqref|def : v<rsup|T>> that

    <\equation>
      <label|eq: log der rel><frac|v<rsup|T><rsub|y>|v<rsup|T>>=<frac|<wide|v|^><rsub|y>|<wide|v|^>>+<frac|h<rsup|T><rsub|y>|h<rsup|T>>.
    </equation>

    Now, using <eqref|eq: log der rel>, <math|D<rsup|v<rsup|T>>> specifies to

    <\equation>
      <label|eq: D v>

      <eqsplit|<tformat|<table|<row|<cell|D<rsup|v<rsup|T>><rsub|t>>|<cell|=<Exp><around*|(|<big|int><around*|(|-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+A*<frac|v<rsup|T><rsub|y>|v<rsup|T>>|)><rprime|'>*<frac|1|a>*d*W-q*<big|int><around*|(|\<Sigma\><rsup|-1>*\<mu\>+\<Sigma\><rsup|-1>*\<Upsilon\>*\<delta\>*<frac|v<rsup|T><rsub|y>|v<rsup|T>>|)><rprime|'>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B|)><rsub|t>>>|<row|<cell|=>|<cell|<Exp><around*|(|<big|int><around*|(|-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+A*<around*|(|<frac|<wide|v|^><rsub|y>|<wide|v|^>>+<frac|h<rsup|T><rsub|y>|h<rsup|T>>|)>|)><rprime|'>*<frac|1|a>*d*W-q*<big|int><around*|(|\<Sigma\><rsup|-1>*\<mu\>+\<Sigma\><rsup|-1>*\<Upsilon\>*\<delta\>*<around*|(|<frac|<wide|v|^><rsub|y>|<wide|v|^>>+<frac|h<rsup|T><rsub|y>|h<rsup|T>>|)>|)><rprime|'>*\<sigma\>*<wide|\<rho\>|\<bar\>>*d*B|)><rsub|t>>>|<row|<cell|=>|<cell|<Exp><around*|(|<big|int><around*|(|-q*\<Upsilon\><rprime|'>*\<Sigma\><rsup|-1>*\<mu\>+A*<frac|<wide|v|^><rsub|y>|<wide|v|^>>|)><rprime|'>*<frac|1|a>*d*W-q*<big|int><around*|(|\<Sigma\><rsup|-1>*\<mu\>+\<Sigma\><rsup|-1>*\<Upsilon\>*\<delta\>*<frac|<wide|v|^><rsub|y>|<wide|v|^>><rprime|'>*\<sigma\>*<wide|\<rho\>|\<bar\>>|)>*d*B|)><rsub|t>>>|<row|<cell|>|<cell|<Exp><pare|<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*d*<wide|W|^><rsub|t>-<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*\<Delta\><rprime|'>*d*<wide|B|^>><rsub|t>>>|<row|<cell|=>|<cell|D<rsup|<wide|v|^>><rsub|t><Exp><pare|<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*d*<wide|W|^><rsub|t>-<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*\<Delta\><rprime|'>*d*<wide|B|^>><rsub|t>.>>>>>
    </equation>

    The second to last equality follows from the identity for any processes
    <math|a,b> and Wiener process <math|W> that

    <\equation*>
      <Exp><around*|(|<big|int><around|(|a<rsub|s>+b<rsub|s>|)>*d*W<rsub|s>|)>=<Exp><around*|(|<big|int>a<rsub|s>*d*W<rsub|s>|)><Exp><around*|(|<big|int>b<rsub|s>*d*W<rsub|s>-<big|int>b<rsub|s>*a<rsub|s>*d*s|)>.
    </equation*>

    It follows from Proposition<nbsp><reference|prop: v> that
    <math|0\<less\><expec><rsup|<wide|<prob>|^><rsup|y>><bra|h<rsup|T><around|(|T,Y<rsub|T>|)>>=h<rsup|T><around|(|0,y|)>\<less\>\<infty\>>.
    Then the right hand side of <eqref|eq: h<rsup|T> mart> is a strictly
    positive <math|<wide|<prob>|^><rsup|y>> martingale on
    <math|<around|[|0,T|]>>. The continuity assumptions upon
    <math|A,h<rsup|T>> imply <math|<big|int><rsub|0><rsup|t>A*<around|(|h<rsup|T><rsub|y>/h<rsup|T>|)><rsup|2><around|(|t,Y<rsub|t>|)>*<space|0.17em>d*t\<less\>\<infty\>,<wide|<prob>|^><rsup|y>-a.*s>.
    Thus, since <math|Y,<wide|B|^>> are independent we can apply Lemma 4.8 in
    <cite|Karatzas-Kardaras> to conclude that

    <\equation*>
      <Exp><pare|<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*d*<wide|W|^><rsub|t>-<big|int>a*\<Delta\>*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*d*<wide|B|^>><rsub|\<cdot\>>
    </equation*>

    is also a strictly positive <math|<wide|P|^><rsup|y>> martingale on
    <math|<around|[|0,T|]>>. Therefore, using <eqref|eq: D v<rsup|T> temp> it
    follows that <math|<expec><rsup|<prob><rsup|y>><around|[|D<rsup|v<rsup|T>><rsub|t>|]>=1>
    and hence <math|D<rsup|v<rsup|T>>> is a strictly positive
    <math|<prob><rsup|y>> martingale. This finishes the proof.
  </proof>

  <subsection|Convergence of conditional densities and wealth
  processes><label|subsec: densities conv>

  Before proving Proposition <reference|thm: conv cond den>, it is necessary
  to relate the terminal wealths resulting from using the finite horizon
  optimal strategies <math|\<pi\><rsup|T>> of <eqref|eq: finite opt> and the
  long-run optimal strategy <math|<wide|\<pi\>|^>> of <eqref|eq: long-run
  opt>.

  Set <math|D<rsup|T>\<assign\>D<rsup|v<rsup|T>>>. Proposition
  <reference|lemma: HJB verification> implies that, for <math|w=v<rsup|T>>
  and <math|\<lambda\>=0> the hypotheses of Proposition <reference|prop:
  Ito-Girsanov result> hold. Therefore, <eqref|eq: primal dual as eq> implies
  that for <math|\<pi\><rsup|T>> as in <eqref|eq: finite opt> and any
  <math|0\<leq\>t\<leq\>T>, under <math|<wide|<prob>|^><rsup|y>> the
  corresponding wealth <math|X<rsup|\<pi\><rsup|T>><rsub|t>> satisfies
  (recall that <math|<prob><rsup|y>> and <math|<wide|<prob>|^><rsup|y>> are
  equivalent on <math|<F><rsub|t>>)

  <\equation>
    <label|eq: wealth-finite><pare|X<rsup|\<pi\><rsup|T>><rsub|t>><rsup|p>=x<rsup|p>*D<rsup|T><rsub|t><pare|<frac|v<rsup|T><around|(|0,y|)>|v<rsup|T><around|(|t,Y<rsub|t>|)>>><rsup|\<delta\>>=x<rsup|p>*D<rsup|T><rsub|t>*e<rsup|\<delta\>*\<lambda\><rsub|c>*t><pare|<frac|<wide|v|^><around|(|y|)>*h<rsup|T><around|(|0,y|)>|<wide|v|^><around|(|Y<rsub|t>|)>*h<rsup|T><around|(|t,Y<rsub|t>|)>>><rsup|\<delta\>>,
  </equation>

  where we have used <eqref|def : v<rsup|T>>. In a similar manner, Assumption
  <reference|ass: ptphat> implies that, for <math|w=<wide|v|^>> and
  <math|\<lambda\>=\<lambda\><rsub|c>>, the hypothesis of Proposition
  <reference|prop: Ito-Girsanov result> hold. Therefore, with
  <math|<wide|D|^>\<assign\>D<rsup|<wide|v|^>>> it follows by <eqref|eq:
  primal dual as eq> that under <math|<wide|<prob>|^><rsup|y>>, for the
  long-run optimal strategy <math|<wide|\<pi\>|^>> defined in <eqref|eq:
  long-run opt>, the corresponding wealth process satisfies for any
  <math|0\<leq\>t\<leq\>T>

  <\equation>
    <label|eq: wealth-long-run><pare|X<rsup|<wide|\<pi\>|^>><rsub|t>><rsup|p>=x<rsup|p>*<wide|D|^><rsub|t>*e<rsup|\<delta\>*\<lambda\><rsub|c>*t><pare|<frac|<wide|v|^><around|(|y|)>|<wide|v|^><around|(|Y<rsub|t>|)>>><rsup|\<delta\>>.
  </equation>

  By <eqref|eq: D v<rsup|T> temp> and <eqref|eq: h<rsup|T> mart> it follows
  that

  <\equation>
    <label|eq: Z ratio t><frac|D<rsup|T><rsub|t>|<wide|D|^><rsub|t>>=<frac|h<rsup|T><around|(|t,Y<rsub|t>|)>|h<rsup|T><around|(|0,y|)>><space|0.17em><Exp><pare|-<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*\<Delta\><rprime|'>*d*<wide|B|^>><rsub|t>.
  </equation>

  Therefore, <eqref|eq: wealth-finite>, <eqref|eq: wealth-long-run> and
  <eqref|eq: Z ratio t> imply

  <\equation>
    <label|eq: wealth ratio t><frac|X<rsup|\<pi\><rsup|T>><rsub|t>|X<rsup|<wide|\<pi\>|^>><rsub|t>>=<around*|(|<frac|D<rsup|T><rsub|t>|<wide|D|^><rsub|t>>|)><rsup|1/p><around*|(|<frac|h<rsup|T><around|(|t,Y<rsub|t>|)>|h<rsup|T><around|(|0,y|)>>|)><rsup|-\<delta\>/p>=<pare|<frac|h<rsup|T><around|(|t,Y<rsub|t>|)>|h<rsup|T><around|(|0,y|)>>><rsup|<frac|1-\<delta\>|p>><Exp><pare|-<big|int>a*\<Delta\>*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|B|^>><rsub|t><rsup|<frac|1|p>>.
  </equation>

  where the last equality uses <eqref|eq: Z ratio t>.

  The proof of Proposition <reference|lemma: HJB verification> showed
  <math|D<rsup|T>> is a

  <math|<prob><rsup|y>> martingale for each <math|y\<in\>E>. Thus, <eqref|eq:
  opt wealth integ value> and <eqref|eq: wealth-finite> in conjunction with
  <eqref|def: p<rsup|T>> implies that <math|D<rsup|T><rsub|t>=<frac|d<prob><rsup|T,y>|d<prob><rsup|y>>\|<rsub|<F><rsub|t>>>.
  Similarly, as shown in <eqref|eq: p phat rn>,
  <math|<wide|D|^><rsub|t>=<frac|d<prob><rsup|T,y>|d<prob><rsup|y>>\|<rsub|<F><rsub|t>>>.
  Therefore, equations <eqref|eq: Z ratio t> and <eqref|eq: wealth ratio t>
  will be used to study the long horizon (<math|T\<to\>\<infty\>>) behavior
  of the ratios between wealth processes <math|X<rsup|\<pi\><rsup|T>><rsub|t>>
  and <math|X<rsup|<wide|\<pi\>|^>><rsub|t>> of the finite horizon and long
  run optimal portfolios, and their corresponding density processes
  <math|d<prob><rsup|T>/d<prob>\|<rsub|\<cal-F\><rsub|t>>> and
  <math|d<wide|<prob>|^><rsup|y>/d<prob>\|<rsub|\<cal-F\><rsub|t>>>.

  In order to prove Theorem<nbsp><reference|thm: conv cond den>, in light of
  <eqref|eq: Z ratio t> it is important to understand limit of
  <math|h<rsup|T>> as <math|T\<to\>\<infty\>>. Under <eqref|ass: posrec l1>,
  an ergodic argument yields the existence of a strictly positive constant
  <math|K> such that:

  <\equation*>
    lim<rsub|T\<rightarrow\>\<infty\>> h<rsup|T><around|(|t,y|)>=K,<space|1em><text|for
    all ><around|(|t,y|)>\<in\><Real><rsub|+>\<times\>E.
  </equation*>

  Developing this argument requires some terminology from ergodic theory.
  Consider a second order elliptic operator
  <math|L=<frac|1|2>*a<rsub|i*j>*\<partial\><rsup|2><rsub|i*j>+b<rsub|i>*<space|0.17em>\<partial\><rsub|i>>
  on <math|\<cal-D\>\<subseteq\><Real><rsup|n>>. Let <math|L<rsup|\<ast\>>>
  denote its adjoint operator (if it exists). Suppose the martingale problem
  for the operator <math|L> is well posed on <math|\<cal-D\>>, and denote its
  solution by <math|<around|(|<prob><rsup|x>|)><rsub|x\<in\>\<cal-D\>>>, with
  coordinate process <math|\<Xi\>>. In the language of ergodic theory,
  <math|\<Xi\>> is <em|recurrent>, if <math|<prob><rsup|x><around|(|\<tau\><around|(|\<epsilon\>,y|)>\<less\>\<infty\>|)>=1>
  for any <math|<around|(|x,y|)>\<in\>\<cal-D\><rsup|2>> and
  <math|\<epsilon\>\<gtr\>0>, where <math|\<tau\><around|(|\<epsilon\>,y|)>=inf>.
  If <math|\<Xi\>> is recurrent, Theorem<nbsp>4.3.3 (i) in <cite|Pinsky>
  implies that <math|L> is <em|critical>; see the Definition in pp. 145 of
  <cite|Pinsky>. Then there exists a unique solution <math|\<varphi\>> (up to
  a constant multiple) of <math|L*\<varphi\>=0>. This solution is called the
  <em|ground state> of <math|L>; see the Definition in pp. 149 of
  <cite|Pinsky>. For the <math|L> given above, its ground state is
  <math|\<varphi\>=1>. On the other hand, Theorem 4.3.3 (v) in <cite|Pinsky>
  shows that <math|L> is critical if and only if <math|L<rsup|\<ast\>>> is
  critical. Then, denote the ground state of <math|L<rsup|\<ast\>>> by
  <math|\<varphi\><rsup|\<ast\>>>. Now if <math|\<Xi\>> is recurrent, it is
  <em|positive recurrent>, or <em|ergodic>, if
  <math|<big|int><rsub|\<cal-D\>>\<varphi\><rsup|\<ast\>><around|(|y|)>*<space|0.17em>d*y\<less\>\<infty\>>,
  and <em|null recurrent> otherwise.

  Now we are ready the show the limiting behavior of <math|h<rsup|T>> as
  <math|T*\<uparrow\>*\<infty\>>.

  <\prop>
    <label|prop: ergodic>Let Assumptions<nbsp><reference|ass: regular coeffs>
    and <reference|ass: ptphat> hold. Then:

    <\equation*>
      lim<rsub|T\<rightarrow\>\<infty\>> h<rsup|T><around|(|t,y|)>=<frac|<big|int><rsup|\<beta\>><rsub|\<alpha\>><wide|v|^>*<space|0.17em>m<around|(|y|)>*<space|0.17em>d*y|<big|int><rsup|\<beta\>><rsub|\<alpha\>><wide|v|^><rsup|2>*<space|0.17em>m<around|(|y|)>*<space|0.17em>d*y>=:K,<space|1em><text|for
      any ><around|(|t,y|)>\<in\><Real><rsub|+>\<times\>E.
    </equation*>
  </prop>

  <\proof>
    Consider the second order operator <math|<cL><rsup|<wide|v|^>,0>> from
    Proposition <reference|prop: v>. As shown in Lemma <reference|lemma: WP
    hat-P>, <eqref|ass: recurrent> in Assumption<nbsp><reference|ass: ptphat>
    ensures that the martingale problem for <math|<cL><rsup|<wide|v|^>,0>> on
    <math|E> is well-posed, and <math|Y> denotes its coordinate process. It
    then follows from Corollary<nbsp>5.1.11 in <cite|Pinsky> that <math|Y> is
    positive recurrent if and only if the first integral inequality in
    <eqref|ass: posrec l1> holds. Then <math|<cL><rsup|<wide|v|^>,0>> is
    critical and <math|1> is its ground state. On the other hand, thanks to
    Assumption<nbsp><reference|ass: regular coeffs> and
    <math|<wide|v|^>\<in\>C<rsup|2><around|(|E|)>>, the adjoint operator
    <math|<around|(|<cL><rsup|<wide|v|^>,0>|)><rsup|\<ast\>>> exists and its
    ground state is <math|<wide|v|^><rsup|2>*m<around|(|y|)>>; see Theorem
    5.1.10 in <cite|Pinsky>.

    Now let <math|<wide|p|^><rsup|0><around|(|s,y,z|)>> be the density
    associated to <math|<cL><rsup|<wide|v|^>,0>>; see (2.4) in
    <cite|Pinchover> for its construction. It follows that

    <\equation*>
      h<rsup|T><around|(|t,y|)>=<big|int><rsub|E><wide|p|^><rsup|0>*<around|(|T-t,y,z|)>*<frac|1|<wide|v|^><around|(|z|)>>*<space|0.17em>d*z.
    </equation*>

    Then the statement follows from Corollary<nbsp>5.2 in <cite|Pinchover>.
    In this corollary, we choose <math|k<rsup|M><rsub|P>=<wide|p|^><rsup|0>>,
    <math|f=<around|(|<wide|v|^>|)><rsup|-1>>, <math|\<varphi\>=1>, and
    <math|\<varphi\><rsup|\<ast\>>=<wide|v|^><rsup|2>*m<around|(|y|)>>. Then
    this corollary is applicable given the second integral inequality in
    <eqref|ass: posrec l1> holds, which ensures the numerator <math|K> is
    finite. That <math|K\<gtr\>0> follows because both <math|<wide|v|^>> and
    <math|m> are strictly positive, and <math|<big|int><rsub|\<alpha\>><rsup|\<beta\>><wide|v|^><rsup|2>*<space|0.17em>m<around|(|y|)>*<space|0.17em>d*y\<less\>\<infty\>>.
  </proof>

  With these results, Lemma<nbsp><reference|thm: conv cond den> and Theorems
  <reference|thm: power 1-factor> and <reference|cor: power 1-factor myopic>
  are now proved.

  <\proof>
    <dueto|Proof of Lemma<nbsp><reference|thm: conv cond den>>The proof of
    Proposition <reference|lemma: HJB verification> show that for all
    <math|y\<in\>E> <math|D<rsup|T>> and <math|<wide|D|^>> are
    <math|<around|(|<prob><rsup|y>,<around|(|<F><rsub|t>|)><rsub|t\<geq\>0>|)>>
    martingales and that <math|<frac|d<prob><rsup|T,y>|d<prob><rsup|y>>\|<rsub|<F><rsub|t>>=D<rsup|T><rsub|t>>,
    <math|<frac|d<wide|<prob>|^><rsup|y>|d<prob><rsup|y>>\|<rsub|<F><rsub|t>>=<wide|D|^><rsub|t>>.
    Recalling <eqref|eq: Z ratio t>, the limit in <eqref|eq: conv cond den>
    holds provided that:

    <\equation>
      <label|eq: conv ratio Z><wide|<prob>|^><rsup|y><text|->lim<rsub|T\<rightarrow\>\<infty\>>
      <frac|h<rsup|T><around|(|t,Y<rsub|t>|)>|h<rsup|T><around|(|0,y|)>><space|0.17em><Exp><pare|-<big|int>a*\<Delta\>*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|B|^>><rsub|t>=1.
    </equation>

    To prove this identity, it follows from Proposition<nbsp><reference|prop:
    ergodic> that, <math|<wide|<prob>|^><rsup|y>>-a.s.,
    <math|lim<rsub|T\<rightarrow\>\<infty\>>
    <frac|h<rsup|T><around|(|t,Y<rsub|t>|)>|h<rsup|T><around|(|0,y|)>>=1> .
    Recall from <eqref|eq: h<rsup|T> mart> that
    <math|<frac|h<rsup|T><around|(|t,Y<rsub|t>|)>|h<rsup|T><around|(|0,y|)>>=L<rsup|T><rsub|t>>,
    where <math|L<rsup|T><rsub|t>\<assign\><Exp><around|(|<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|W|^>|)><rsub|t>>.
    Then <rsub|<math|T\<geq\>0>> is a sequence of positive
    <math|<wide|<prob>|^><rsup|y>>-local martingales such that
    <math|<wide|<prob>|^><rsup|y>>-<math|lim<rsub|T\<rightarrow\>\<infty\>>
    L<rsup|T><rsub|t>=1>. As a result, it follows from Fatou's lemma that
    <math|1\<geq\>lim<rsub|T\<to\>\<infty\>><expec><rsup|<wide|<prob>|^><rsup|y>><around|[|L<rsub|t><rsup|T>|]>\<geq\><expec><rsup|<wide|<prob>|^><rsup|y>><around|[|liminf<rsub|T\<to\>\<infty\>>
    L<rsup|T><rsub|t>|]>=1>, which implies
    <math|lim<rsub|T\<to\>\<infty\>><expec><rsup|<wide|<prob>|^><rsup|y>><bra|<around|\||L<rsub|t><rsup|T>-1|\|>>=0>
    due to Scheff's lemma. Now Lemma<nbsp><reference|lemma: stoch-log conv>
    yields <math|<wide|<prob>|^><rsup|y>>-<math|lim<rsub|T\<rightarrow\>\<infty\>><bra|<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|W|^>,<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|W|^>><rsub|t>=0>,
    where <math|<big|int>a*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|W|^>>
    is the stochastic logarithm of <math|L<rsup|T>>. Observing that
    <math|<around|\<\|\|\>|\<Delta\>|\<\|\|\>><rsup|2>> is a constant (due to
    Assumption<nbsp><reference|ass: correl>), the previous identity implies
    that <math|<wide|<prob>|^><rsup|y>>-<math|lim<rsub|T\<rightarrow\>\<infty\>><bra|<big|int>a*\<Delta\>*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|B|^>,<big|int>a*\<Delta\>*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|B|^>><rsub|t>=0>.
    This gives <math|<wide|<prob>|^><rsup|y>>-<math|lim<rsub|T\<rightarrow\>\<infty\>>
    <big|int><rsub|0><rsup|t>a*\<Delta\>*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|B|^>=0>,
    which implies <math|<wide|<prob>|^><rsup|y>>-<math|lim<rsub|T\<rightarrow\>\<infty\>><Exp><pare|<big|int>a*\<Delta\>*<frac|h<rsup|T><rsub|y>|h<rsup|T>>*<space|0.17em>d*<wide|B|^>><rsub|t>=1>,
    i.e., the second term on the left-hand-side of <eqref|eq: conv ratio Z>
    also converges to <math|1>. This concludes the proof of <eqref|eq: conv
    ratio Z>.
  </proof>

  <subsection|Proof of main results in Section<nbsp><reference|subsec:
  turnpike for diffusion>><label|subsec: proof diffusion>

  <\proof>
    <dueto|Proof of Theorem<nbsp><reference|thm: power 1-factor>>Let
    <math|\<cal-S\><rsub|T>> be either <math|<around|{|sup<rsub|u\<in\><around|[|0,t|]>><around*|\||r<rsup|T><rsub|u>-1|\|>\<geq\>\<epsilon\>|}>>
    or <math|<around|{|<bra|\<Pi\><rsup|T>,\<Pi\><rsup|T>><rsub|t>\<geq\>\<epsilon\>|}>>;
    both of them are <math|<F><rsub|t>>-measurable. It follows from
    Theorem<nbsp><reference|thm: opt-port conv> and
    Remark<nbsp><reference|rem: finite time> part iii) that

    <\equation>
      <label|eq: conv prob p>lim<rsub|T\<to\>\<infty\>><expec><rsup|<wide|<prob>|^><rsup|y>><bra|<around*|\<nobracket\>|<frac|d<prob><rsup|T,y>|d<wide|<prob>|^><rsup|y>>|\|><rsub|<F><rsub|t>><space|0.17em><indic><rsub|\<cal-S\><rsub|T>>>=0.
    </equation>

    On the other hand, <eqref|eq: conv cond den> and Scheff's lemma combined
    imply that <math|lim<rsub|T\<rightarrow\>\<infty\>><expec><rsup|<wide|<prob>|^><rsup|y>><bra|<around*|\||<around*|\<nobracket\>|<frac|d<prob><rsup|T,y>|d<wide|<prob>|^><rsup|y>>|\|><rsub|<F><rsub|t>>-1|\|>>=0>.
    Hence, combining the previous identity with <eqref|eq: conv prob
    p<rsup|T>>, it follows that <math|lim<rsub|T\<to\>\<infty\>><wide|<prob>|^><rsup|y><around|(|\<cal-S\><rsub|T>|)>=0>.
    Now, recall that <math|<wide|<prob>|^><rsup|y>\<sim\><prob>> on
    <math|<F><rsub|t>> from Proposition <reference|prop: Ito-Girsanov
    result>, we conclude that

    <\equation*>
      lim<rsub|T\<to\>\<infty\>><prob><rsup|y><around|(|\<cal-S\><rsub|T>|)>=lim<rsub|T\<to\>\<infty\>><expec><rsup|<wide|<prob>|^><rsup|y>><bra|<around*|\<nobracket\>|<frac|d<prob><rsup|y>|d<wide|<prob>|^><rsup|y>>|\|><rsub|<F><rsub|t>><space|0.17em><indic><rsub|\<cal-S\><rsub|T>>>=0,
    </equation*>

    where the last equality follows from the dominated convergence theorem.
  </proof>

  <\proof>
    <dueto|Proof of Theorem<nbsp><reference|cor: power 1-factor
    myopic>>First, following a similar argument as that in the proof of
    Proposition<nbsp><reference|thm: conv cond den> and using <eqref|eq:
    wealth ratio t>, we have <math|<wide|<prob>|^><rsup|y>>-<math|lim<rsub|T\<to\>\<infty\>>
    X<rsup|0,T><rsub|t>/X<rsup|<wide|\<pi\>|^>><rsub|t>=1>. On the other
    hand, Theorem<nbsp><reference|thm: power 1-factor> part a), combined with
    the equivalence between <math|<prob>> and <math|<wide|<prob>|^><rsup|y>>,
    implies <math|<wide|<prob>|^><rsup|y>>-<math|lim<rsub|T\<to\>\<infty\>>
    X<rsup|1,T><rsub|t>/X<rsup|0,T><rsub|t>=1>. Hence the last two identities
    combined gives <math|<wide|<prob>|^><rsup|y>>-<math|lim<rsub|T\<to\>\<infty\>>
    <wide|r|^><rsup|T><rsub|t>=1>. Now recall that <math|<wide|\<pi\>|^>> is
    the optimal portfolio for the logarithmic investor under
    <math|<wide|<prob>|^><rsup|y>>, it then follows from the numraire
    property of <math|<wide|\<pi\>|^>> that
    <math|<wide|r|^><rsup|T><rsub|\<cdot\>>> is a
    <math|<wide|<prob>|^><rsup|y>>-supermartingale. This induces
    <math|lim<rsub|T\<to\>\<infty\>><expec><rsup|<wide|<prob>|^><rsup|y>><bra|<around|\||<wide|r|^><rsup|T><rsub|t>-1|\|>>=0>,
    thanks to Fatou's lemma and Scheff's lemma. As a result, the statements
    follow from applying Lemma<nbsp><reference|lemma: stoch-log conv> under
    probability <math|<wide|<prob>|^><rsup|y>> and switching back to the
    probability <math|<prob><rsup|y>> at last.
  </proof>

  <\bibliography|bib|plainnat|biblio>
    <bib-list|[99]|>
  </bibliography>

  m the numraire property of <math|<wide|\<pi\>|^>> that
  <math|<wide|r|^><rsup|T><rsub|\<cdot\>>> is
</body>