<TeXmacs|1.99.7>

<style|<tuple|elsarticle|std-latex>>

<\body>
  <\hide-preamble>
    <assign|Levy|<macro|vy <space|0.17em>>>

    <assign|pit|<macro|\<pi\><rsub|t>>>

    <assign|pis|<macro|\<pi\><rsub|s>>>

    <assign|mut|<macro|\<mu\><rsub|t>>>

    <assign|sigt|<macro|\<sigma\><rsub|t>>>

    <assign|sigs|<macro|\<sigma\><rsub|s>>>

    <assign|Ro|<macro|<R>-{0}>>

    <assign|U|<macro|<math-bf|U>>>

    <assign|N|<macro|<math-bf|N>>>

    <assign|R|<macro|<math-bf|R>>>

    <assign|E|<macro|<math-bf|E>>>

    <assign|V|<macro|<math-bf|Var>>>

    <assign|F|<macro|<math-bf|F>>>

    <assign|calS|<macro|\<cal-S\>>>

    <assign|calB|<macro|\<cal-B\>>>

    <assign|calC|<macro|\<cal-C\>>>

    <assign|calN|<macro|\<cal-N\>>>

    <assign|calM|<macro|\<cal-M\>>>

    <assign|calF|<macro|\<cal-F\>>>

    <assign|calK|<macro|\<cal-K\>>>

    <assign|calH|<macro|\<cal-H\>>>

    <assign|calA|<macro|\<cal-A\>>>

    <assign|half|<macro|<frac|1|2>>>

    <new-theorem|thm|Theorem>

    <new-theorem|lemma|Lemma>

    <new-theorem|prop|Proposition>

    <new-theorem|cor|Corollary>

    <new-theorem|remark|Remark>

    <new-theorem|defn|Definition>

    <new-theorem|example|Example>
  </hide-preamble>

  <doc-data|<doc-title|A Mispricing Model of Stocks Under Asymmetric
  Information>|<doc-author|<author-data|<author-name|W.
  Buckley>|<author-affiliation|CBA, Florida International University, Miami,
  FL 33199, USA.<next-line>Email: <with|font-family|tt|wbuck001@fiu.edu>>>>|<doc-author|<author-data|<author-name|G.
  Brown>|<author-affiliation|Corresponding author: Statistical Laboratory,
  CMS, Cambridge University, CB3 0WB UK.<next-line>Email:
  <with|font-family|tt|gob20@statslab.cam.ac.uk>;>>>|<doc-author|<author-data|<author-name|M.
  Marshall>|<author-affiliation|School of Management, University of Texas at
  Dallas, Richardson, Texas 75080, USA.<next-line>Email:
  <with|font-family|tt|mario.marshall@student.utdallas.edu>>>>|<doc-title-options|cluster-all>>

  <abstract-data|<\abstract>
    We extend the theory of asymmetric information in mispricing models for
    stocks following geometric Brownian motion to constant relative risk
    averse investors. Mispricing follows a continuous mean--reverting
    Ornstein--Uhlenbeck process. Optimal portfolios and maximum expected
    log--linear utilities from terminal wealth for informed and uninformed
    investors are derived. We obtain analogous but more general results which
    nests those of Guasoni (2006) as a special case of the relative risk
    aversion approaching one.
  </abstract>|<abstract-keywords| Finance|Utility theory|Investment
  Analysis|Optimization>>

  <section|Introduction>

  A simple mathematical model of two small investors on a financial market,
  one of which is better informed than the other has attracted much attention
  in recent years. Their information is modelled by two different
  filtrations\Uthe less informed investor has a sigma\Ufield
  <math|<calF><rsup|0>>, corresponding to the natural evolution of the
  market, while the better informed investor has the larger filtration
  <math|<calF><rsup|1>>, which contains the information of the uninformed
  investor. Understanding the link between asset mispricing and asymmetric
  information is a topic of ongoing interest in the finance
  literature.<next-line>

  Mispricing models for stocks under asymmetric information were first
  studied in Shiller (1981) and Summers (1986) in a purely deterministic
  setting. This was extended by Guasoni (2006) to the purely continuous
  random environment, where stock prices follow geometric Brownian motion
  (GBM) and utility is logarithmic. Fads/mispricing follow a continuous
  mean\Ureverting Ornstein\UUhlenbeck (O\UU) process. There are two investors
  trading in the market\U the uninformed and informed investors. Guasoni
  (2006) gives optimal portfolios and maximum expected logarithmic utilities,
  including asymptotic utilities for both uninformed and informed investors.
  He also gives the excess asymptotic utility of the informed investor.

  Buckley (2009) extends this theory to <Levy>markets, where stock prices
  jump. Utility functions are assumed to be logarithmic. Jumps are modelled
  by pure jump <Levy>processes, while the mispricing is represented by a
  purely continuous mean\Ureverting O\UU process driven by a standard
  Brownian motion, as in Guasoni (2006). The author obtains optimal
  portfolios and maximum expected logarithmic utilities for both the informed
  and uninformed investors, including asymptotic excess utility which is
  analogous to the result obtained in Guasoni (2006) in the purely continuous
  case. The random portfolios of the investors are linked to the symmetric,
  purely deterministic optimal portfolios of Lvy diffusion markets having
  deterministic market coefficients.<next-line>

  In this paper, we generalize the theory of mispricing models of stocks
  under asymmetric information, where investors preference are from the power
  utility family. We allow the stock price dynamic to move continuously as
  geometric Brownian motion, while the mispricing process remains as a
  continuous mean-reverting Ornstein\UUhlenbeck process. We obtain analogous
  but more general results which includes those of Guasoni (2006) as a
  special case of the risk aversion approaching one.<next-line>

  The rest of the paper is organized as follows: Section 2 gives a brief
  literature review and the model is introduced in Section 3. Filtrations are
  defined in Section 4, while price dynamics for both informed and uninformed
  investors are introduced in Section 5. Section 6 introduces CRRA (Constant
  Relative Risk Aversion) utility functions of the power class, while Section
  7 presents portfolio and wealth processes. The main result is presented in
  Sections 8. We obtain optimal portfolios and log\Ulinear maximum expected
  utilities for both the informed and uninformed investors, including
  asymptotic excess utility for the informed investor. Section 9 concludes.

  <section|Literature review>

  <subsection|Continuous\UTime Mispricing Models>

  In this section, we give a brief literature review of asymmetric
  information in mispricing models in a purely continuous random market\U
  that is, in a market where stock prices and mispricing move continuously,
  without jumping. Discrete-time fads/mispricing models were first introduced
  in Shiller (1981) and Leroy and Porter (1981) as plausible alternatives to
  the efficient market/constant expected returns/discount rate assumption (cf
  Fama (1970)).

  Studies by Flavin (1983), Kleidon (1986), and March and Merton (1986),
  criticize these findings based on the statistical validity of these
  volatility tests. However, other studies confirm the earlier findings of
  the variance bounds tests of Shiller (1981), and Leroy and Porter (1981).
  For example, West (1988) develops a stock market volatility test that
  overcame these criticisms. West's inequality test prove that, if discount
  rates are constant, the variance of the change in the expected present
  discounted value of future dividends is larger when less information is
  used. He also finds that stock prices are too volatile to be the expected
  present discounted value of dividends when the discount rate is
  constant.<next-line>

  Campbell and Shiller (1987) find that when dividends and prices are
  non-stationary, they are co-integrated under the dividend discounted model,
  that is, there is a linear combination of the two that is stationary. Using
  cointegration and the VAR (vector autoregressive) framework, they also
  confirm the findings of Shiller (1981).

  Given the failure of the discounted dividend model to explain stock price
  variations, some researchers introduced behavioural finance models as
  possible alternatives. Summers (1986), and Cutler et al.(1990) introduce
  irrational/noise traders, and the slow response to changes in fundamentals.
  DeLong et al. (1990), suggest that noise trading in the market can increase
  price volatility, which impacts the risk of investing in the stock market
  and the risk premium. Campbell and Kyle (1993) also suggest that the
  existence of noise trading in the market can help explain the high
  volatility of stock prices. Daniel et al. (1998) develop a theory of
  mispricing based on investor overconfidence resulting from biased
  self-attribution of investment outcomes.<next-line>

  Barberis et al. (1998) provide an explanation for over and under-reactions
  based on a learning model in which actual earnings follow a random walk but
  individuals believe that earnings follow a steady growth trend, or are mean
  reverting. Odean (1998) provides a model where overconfident traders can
  cause markets to under-react to the information of rational traders,leading
  to positive serially correlated returns.<next-line>

  Wang (1993) gives a model of intertemporal/continuous\Utime asset pricing
  under asymmetric information. In his paper, investors have different
  information concerning the future growth rate of dividends, which satisfies
  a mean\Ureverting Ornstein\UUhlenbeck process. Informed investors know the
  future dividend growth rate, while uninformed investors do not. All
  investors observe current dividend payments and stock prices. The growth
  rate of dividends determines the rate of appreciation of stock prices, and
  stock price changes provide signals about the future growth of dividends.
  Uninformed investors rationally extract information about the economy from
  prices, as well as dividends. Wang (1993) shows that asymmetry among
  investors can increase price volatility and negative autocorrelation in
  returns; that is, there is mean\Ureverting behaviour of stock prices. Thus,
  imperfect information of some investors can cause stock prices to be more
  volatile than in the symmetric case, when all investors are perfectly
  informed.<next-line>

  Brunnermeier (2001) presents an extensive review of asset pricing models
  under asymmetric information mainly in the discrete setting. He shows how
  information affects trading activity, and that expected returns depend on
  the information set or filtration of the investor. These models show that
  past prices still carry valuable information, which can be exploited using
  technical/chart analysis, which uses part or all of past prices to predict
  future prices.<next-line>

  Guasoni (2006) extends the model of Summers (1986) to the purely continuous
  random setting. He develops models of stock price evolution for two
  disjoint classes of investors; the informed and uninformed investors. The
  informed investor, indexed by <math|i=1>, observes both the fundamental and
  market values of the stock, while the so\Ucalled uninformed investor,
  indexed by <math|i=0>, observes market prices only. Both investors have
  filtrations or information banks <math|<calF><rsup|i>,<space|0.17em>i\<in\><around|{|0,1|}>>
  with <math|<calF><rsup|0>\<subset\><calF><rsup|1>\<subset\><calF>>, where
  <math|<calF>> is a fixed sigma\Ualgebra. The problem of the maximization of
  expected logarithmic utility from terminal wealth is solved for each
  investor, and an explicit formula for the asymptotic excess utility of the
  informed investor takes the form <math|<frac|\<lambda\>|2>*p*<space|0.17em><around|(|1-p|)>*<space|0.17em>T>
  where <math|T> is the long run investment horizon, <math|\<lambda\>> is the
  reversion speed, and <math|q<rsup|2>=1-p<rsup|2>> is the proportion of
  mispricing in the market.<next-line>

  Buckley (2009) extends this theory to include stock prices that jump.
  Utility functions are still assumed to be logarithmic. Jumps are modelled
  by pure jump <Levy>processes, while mispricing is represented by a purely
  continuous mean\Ureverting O\UU process driven by a standard Brownian
  motion. The author obtains optimal portfolios and maximum expected
  logarithmic utilities for both the informed and uninformed investors,
  including asymptotic excess utility of the form
  <math|<frac|<wide|\<lambda\>|~>|2>*<space|0.17em>p*<space|0.17em><around|(|1-p|)>*<space|0.17em>T>,
  which is analogous to the result obtained by Guasoni (2006) in the purely
  continuous case. The random portfolios of the investors are linked to the
  symmetric, purely deterministic optimal portfolios of Lvy diffusion
  markets having deterministic market coefficients.

  <section|The Model>

  The model consists of two assets;<space|0.17em>a riskless asset
  <with|font-series|bold|B> called bond, bank account or money market, and a
  risky asset <math|S> called stock. The bond earns a continuously compounded
  risk\Ufree interest rate <math|r<rsub|t>>, while the stock has total
  percentage appreciation rate or <with|font-series|bold|expected returns>
  <math|<mut>>, at time <math|t\<in\><around|[|0,T|]>>. The stock is subject
  to volatility <math|\<sigma\><rsub|t>\<gtr\>0>. The market parameters are
  <math|<mut>,<space|0.17em>r<rsub|t>,<space|0.17em>\<sigma\><rsub|t>,<space|0.17em>>,
  and are <with|font-series|bold|deterministic> functions.<next-line>

  <no-indent><with|font-series|bold|Standing Assumptions :><next-line>(1)
  <math|T\<gtr\>0>, is the investment horizon; all transactions take place in
  <math|<around|[|0,T|]>>.<next-line>(2) The market parameters
  <math|r,<space|0.17em>\<mu\>,<space|0.17em>\<sigma\><rsup|2>> are Lebesgue
  integrable deterministic functions.<next-line>(3) The stock's
  <with|font-series|bold|Sharpe ratio > or <with|font-series|bold|market
  price of risk> <math|\<theta\>>, is square integrable.<next-line>(4) The
  risky asset <math|S> lives on a probability space
  <math|<around|(|<with|math-font-family|bf|\<Omega\>>,<space|0.17em><calF>,<space|0.17em><math-bf|P>|)>>
  on which is defined two independent standard Brownian motions
  <math|W=<around|(|W<rsub|t>|)><rsub|t\<geq\>0>> and
  <math|B=<around|(|B<rsub|t>|)><rsub|t\<geq\>0>>. <math|<calF>> is an
  sigma\Ualgebra of subsets of <math|<with|math-font-family|bf|\<Omega\>>>,
  and <math|<math-bf|P>> is the \Preal\Uworld" probability measure on
  <math|<calF>>.<next-line>(5) Fads or mispricing are modelled by the a
  mean\Ureverting <with|font-series|bold|Ornstein\UUhlenbeck> (O\UU) process
  <math|U=<around|(|U<rsub|t>|)><rsub|t\<geq\>0>> with mean\Ureversion rate
  or speed <math|\<lambda\>>.<next-line>(6) Utility are from the power class;
  i.e., linear functions of <math|U<around|(|x|)>=x<rsup|\<gamma\>>>, where
  <math|\<gamma\>\<less\>1>.<next-line>(7) Informed and uninformed investors
  are represented by the indices \P1", and \P0",
  respectively.<next-line><no-indent><with|font-series|bold|The Price
  Dynamic><next-line>The bond <math|<with|font-series|bold|B>> has price
  <math|<math-bf|B><rsub|t>=exp <around*|(|<big|int><rsub|0><rsup|t>r<rsub|s>*d*s|)>>,
  while the stock has log return dynamic

  <eqnarray|<tformat|<table|<row|<cell|d<around|(|log
  S<rsub|t>|)>>|<cell|=>|<cell|<around|(|<mut>-<half>\<sigma\><rsup|2><rsub|t>|)>*d*t+\<sigma\><rsub|t>*d*Y<rsub|t>,<space|0.22em><space|0.22em><space|0.22em>t\<in\><around|[|0,T|]>,<eq-number><label|2.1>>>|<row|<cell|Y<rsub|t>>|<cell|=>|<cell|p*<space|0.17em>W<rsub|t>+q*<space|0.17em>U<rsub|t>,<space|0.22em><space|0.22em><space|0.22em>p<rsup|2>+q<rsup|2>=1,<space|0.27em>p\<geq\>0,<space|0.17em>q\<geq\>0,<eq-number><label|2.2>>>|<row|<cell|d*U<rsub|t>>|<cell|=>|<cell|-\<lambda\>*U<rsub|t>*d*t+d*B<rsub|t>,<space|0.22em><space|0.22em><space|0.22em>U<rsub|0>=0,<space|0.17em><space|0.17em><space|0.17em>\<lambda\>\<gtr\>0.<eq-number><label|2.3>>>>>>

  Applying It's transformation formula to (<reference|2.1>) gives percentage
  return for the stock:

  <\equation>
    <frac|d*S<rsub|t>|S<rsub|t>>=<mut>d*t+\<sigma\><rsub|t>*d*Y<rsub|t>,<space|0.22em><space|0.22em><space|0.22em>t\<in\><around|[|0,T|]>.<label|2.1a>
  </equation>

  Observe that <math|<mut>> is the expected percentage return on the stock,
  while <math|\<sigma\><rsub|t>*d*Y<rsub|t>> is the
  <with|font-series|bold|excess> percentage returns. The fads or mispricing
  process <math|U> is a mean\Ureverting Ornstein\UUhlenbeck process with
  speed <math|\<lambda\>>, which is the unique solution of the
  <with|font-series|bold|Langevin stochastic differential equation:>
  (<reference|2.3>) with explicit solution

  <\equation>
    <label|2.9>U<rsub|t>=<big|int><rsub|0><rsup|t>e<rsup|-\<lambda\>*<around|(|t-s|)>>*d*B<rsub|s>,<space|0.22em><space|0.22em><space|0.22em>t\<in\><around|[|0,T|]>,
  </equation>

  with mean <math|<space|0.17em><space|0.17em><E><around|[|U<rsub|t>|]>=0>,
  and variance <math|<math-bf|Var><around|[|U<rsub|t>|]>=<frac|1-e<rsup|-2*\<lambda\>*t>|2*\<lambda\>>>.<next-line>If
  the speed <math|\<lambda\>> is close to zero, mean reversion is slow and
  there is a high likelihood of mispricing, while if
  <math|\<lambda\>\<gtr\>\<gtr\>0>, the mispricing reverts rapidly, thereby
  reducing any advantages of mispricing. <with|font-series|bold|<math|100*q<rsup|2>>
  % is the percentage of mispricing in the market.> Equation
  (<reference|2.1>) or equivalently, (<reference|2.1a>), has unique solution

  <\equation>
    <label|2.5>S<rsub|t>=S<rsub|0>*<space|0.17em>exp
    <around*|(|<big|int><rsub|0><rsup|t><around|(|\<mu\><rsub|s>-<half>\<sigma\><rsup|2><rsub|s>|)>*d*s+<big|int><rsub|0><rsup|t>\<sigma\><rsub|s>*d*Y<rsub|s>|)>,<space|0.22em><space|0.22em><space|0.22em>t\<in\><around|[|0,T|]>.
  </equation>

  By imposing (<reference|2.3>) on (<reference|2.2>), we see that <math|Y> is
  a combination of a martingale <math|W>, which represents permanent price
  shocks, and <math|U> the mean\Ureverting O\UU process, which represents
  temporary shocks. If <math|\<lambda\>=0> or <math|q=0>, (and <math|<mut>>
  and <math|<sigt>> are constants) we revert to the usual geometric Brownian
  motion (GBM) of Merton (1971).<no-indent>

  <section|Filtrations or Information Flows of Investors>

  <\defn>
    <label|def2.1>Let <math|X=<around|(|X<rsub|t>|)><rsub|t\<geq\>0>> be a
    process defined on <math|<around|(|<with|math-font-family|bf|\<Omega\>>,<space|0.17em><calF>,<space|0.17em><math-bf|P>|)>>.
    Its natural filtration <math|<calF><rsup|X>=<around|(|<calF><rsub|t><rsup|X>|)><rsub|t\<geq\>0>>
    is the sub--<math|\<sigma\>> algebra of <math|<calF>> generated by
    <math|X>, and is given by

    <\equation*>
      <label|2.10><calF><rsub|t><rsup|X><above|=|\<triangle\>>\<sigma\>*<around|(|X<rsub|s>:s\<leq\>t|)>=<around|{|X<rsup|-1><around|(|A|)>\<subset\><with|math-font-family|bf|\<Omega\>>:A\<in\><calB><around|(|<R>|)>|}>.
    </equation*>
  </defn>

  <no-indent><math|<calF><rsub|t><rsup|X>> is the information generated by
  <math|X> up to time <math|t>.

  <subsection|Augmentation>

  We can make <math|<calF><rsub|t><rsup|X>> right\Ucontinuous and complete by
  augmenting it with <math|<calN>>, the <math|<math-bf|P>>\Unull sets of
  <math|<calF>>, given by <math|<calN>=<around|{|A\<subset\><with|math-font-family|bf|\<Omega\>>:\<exists\><space|0.17em>B\<in\><calF>,<space|0.22em><space|0.22em>A\<subset\>B,<space|0.22em><space|0.22em><math-bf|P><around|(|B|)>=0|}>>.<no-indent>The
  augmented filtration of <math|X> is <math|\<sigma\>*<space|0.17em><around|(|<calF><rsup|X>\<vee\><calN>|)>>.
  <math|<calF><rsup|X>> is <with|font-series|bold|complete> if it contains
  the <math|<math-bf|P>>\Unull sets of <math|<calF>>, e.g., if
  <math|<calN>\<subset\><calF><rsub|0><rsup|X>>. A filtration
  <math|<around|(|<calF><rsub|t>|)>> is <with|font-series|bold|right
  continuous> if <math|<calF><rsub|t+>=<calF><rsub|t>,<space|0.22em><space|0.22em><space|0.22em><space|0.22em><space|0.22em><text|where<space|0.17em><space|0.17em>
  ><calF><rsub|t+>=<big|cap><rsub|s\<gtr\>t><calF><rsub|s>>.

  <no-indent>In the sequel, we assume that all filtrations
  <math|<around|(|<calF><rsub|t>|)>> are right\Ucontinuous and complete. In
  this case, we say the filtration satisfies the <with|font-series|bold|usual
  hypothesis> (Applebaum, 2004). Thus, <math|<calF><rsup|X>=<around|(|<calF><rsub|t><rsup|X>|)><rsub|t\<geq\>0>>
  will denote the complete right\Ucontinuous filtration generated by <math|X>
  on <math|<around|(|<with|math-font-family|bf|\<Omega\>>,<space|0.17em><calF>,<space|0.17em><math-bf|P>|)>>.
  The informed investor observes the pair
  <math|<around|(|S,<space|0.17em>U|)>>, while the uninformed investor
  observes only the stock price <math|S>.

  <\defn>
    [<with|font-series|bold|Filtrations of Investors>]<label|def2.13> Let
    <math|<calF><rsup|1>=<around|(|<calF><rsup|1><rsub|t>|)><rsub|t\<geq\>0>>
    and <math|<calF><rsup|0>=<around|(|<calF><rsup|0><rsub|t>|)><rsub|t\<geq\>0>>
    be the filtrations generated by <math|<around|(|S,<space|0.17em>U|)>> and
    <math|S>, respectively. That is, for each <math|t\<in\><around|[|0,T|]>>

    <\equation*>
      <calF><rsup|1><rsub|t><above|=|\<triangle\>>\<sigma\>*<space|0.17em><around|(|S<rsub|s>,<space|0.17em>U<rsub|s>:s\<leq\>t|)>=<calF><rsup|S,<space|0.17em>U><rsub|t><space|0.17em><space|0.17em><space|0.17em><text|and><space|0.17em><space|0.17em><space|0.17em><space|0.17em><calF><rsup|0><rsub|t><above|=|\<triangle\>>\<sigma\>*<space|0.17em><around|(|S<rsub|s>:s\<leq\>t|)>=<calF><rsup|S><rsub|t><label|2.13s>.
    </equation*>
  </defn>

  <no-indent><math|<calF><rsup|1>> and <math|<calF><rsup|0>> are the
  respective information flows of the informed and uninformed investors.
  Equivalently, since <math|W> and <math|B> generate <math|S> and <math|U>
  for the informed investor, while <math|Y> generates <math|S> for the
  uninformed investor, then

  <\equation*>
    <calF><rsup|1><rsub|t><above|=|\<triangle\>>\<sigma\>*<space|0.17em><around|(|W<rsub|s>,<space|0.17em>B<rsub|s>:s\<leq\>t|)>=<calF><rsup|S,<space|0.17em>U><rsub|t><space|0.17em><space|0.17em><space|0.17em><text|and><space|0.17em><space|0.17em><space|0.17em><space|0.17em><calF><rsup|0><rsub|t><above|=|\<triangle\>>\<sigma\>*<space|0.17em><around|(|Y<rsub|s>:s\<leq\>t|)>=<calF><rsup|Y><rsub|t><label|2.14s>.
  </equation*>

  Clearly <math|<calF><rsup|0>\<subset\><calF><rsup|1>\<subset\><calF><space|0.22em><space|0.22em><space|0.22em>\<Longleftrightarrow\><calF><rsup|0><rsub|t>\<subset\><calF><rsup|1><rsub|t>>
  for all <math|<space|0.22em><space|0.22em><space|0.27em>t\<in\><around|[|0,T|]>>.
  The market participants can be classified in accordance to their respective
  information flows. Those with access to <math|<calF><rsup|1>>, are called
  informed investors\Uthey observed both the fundamental and market prices of
  the risky asset. Those with access to <math|<calF><rsup|0>> only, are
  called uninformed investors\Uthey observe market prices only. These
  uninformed investors know that there is mispricing in the market but cannot
  observe them directly.

  <section|The Stock Price Dynamic for the Investors>

  It follows from (<reference|2.1a>), that for both investors the general
  percentage return for the stock has dynamic
  <math|<frac|d*S<rsub|t>|S<rsub|t>>=<mut><space|0.17em>d*t+\<sigma\><rsub|t>*<space|0.17em>d*Y<rsub|t>>.<no-indent>We
  rewrite this dynamic for each investor.

  <subsection|Price Dynamic for the Uninformed Investor>

  Using the Hitsuda (1968) representation of Gaussian processes (see
  Cheridito,2003), Guasoni (2006) gives an <math|<calF><rsup|0>>\UBrownian
  motion <math|B<rsup|0>> and a random process <math|\<upsilon\><rsup|0>>,
  such that <math|d*Y<rsub|t>=d*B<rsup|0><rsub|t>+\<upsilon\><rsub|t><rsup|0>*d*t>.
  We now invoke a useful part of Theorem 2.1, Guasoni (2006).<next-line>Let
  <math|<around|(|<with|math-font-family|bf|\<Omega\>>,<space|0.17em><calF>,<space|0.17em><math-bf|P>|)>>
  be a probability space on which independent Brownian motions <math|W> and
  <math|B> are defined. Let <math|<calF><rsup|0>=<around|(|<calF><rsup|0><rsub|t>|)><rsub|t\<geq\>0>\<equiv\><around|(|<calF><rsup|Y><rsub|t>|)><rsub|t\<geq\>0>>
  be the filtration generated by <math|Y> satisfying the usual hypothesis.
  Let

  <\equation>
    <label|2.24>\<gamma\><around|(|s|)>=<frac|1-p<rsup|2>|1+p*tanh
    <around|(|p*\<lambda\>*s|)>>-1.
  </equation>

  Then, we can construct an <math|<calF><rsup|0>>\U Brownian motion
  <math|B<rsup|0>=<around|(|B<rsup|0><rsub|t>|)>> on
  <math|<around|(|<with|math-font-family|bf|\<Omega\>>,<space|0.17em><calF>,<space|0.17em><math-bf|P>|)>>
  such that in terms of <space|0.22em><space|0.22em><math|Y<rsub|s>:s\<leq\>t>,

  <\equation>
    <label|2.30>Y<rsub|t>=B<rsup|0><rsub|t>+<big|int><rsub|0><rsup|t>\<upsilon\><rsup|0><rsub|s>*d*s,
  </equation>

  where <math|\<upsilon\><rsub|t><rsup|0>> is given by

  <\equation>
    <label|2.23>\<upsilon\><rsub|t><rsup|0><above|=|\<triangle\>>-\<lambda\>*<space|0.17em><big|int><rsub|0><rsup|t>e<rsup|-\<lambda\>*<space|0.17em><around|(|t-s|)>>*<around|(|1+\<gamma\><around|(|s|)>|)>*<space|0.17em>d*B<rsup|0><rsub|s>.
  </equation>

  <\remark>
    <math|\<gamma\><around|(|u|)>> is the solution of the equation:
    <math|\<gamma\><rprime|'><around|(|s|)>=\<lambda\>*<around|(|\<gamma\><rsup|2><around|(|s|)>-p<rsup|2>|)>,<space|0.22em><space|0.22em><space|0.22em>\<gamma\><around|(|0|)>=-p<rsup|2>>.
  </remark>

  <subsection|Price Dynamic for the Investors>

  The stock price dynamic of each investor, relative to his or her
  filtration, now follows.

  <\prop>
    <label|pro1>Let <math|i\<in\><around|{|0,<space|0.17em>1|}>>. Under
    <math|<calF><rsup|i>>, the price dynamic of the <math|i>--th investor is

    <\equation>
      <label|2.21.0><frac|d*S<rsub|t>|S<rsub|t>>=<mut><rsup|i>d*t+\<sigma\><rsub|t>*d*B<rsup|i><rsub|t>,
    </equation>

    with price

    <\equation>
      <label|2.26>S<rsub|t>=S<rsub|0>*<space|0.17em>exp
      <around*|(|<big|int><rsub|0><rsup|t><around|(|\<mu\><rsup|i><rsub|s>-<half>\<sigma\><rsup|2><rsub|s>|)>*d*s+<big|int><rsub|0><rsup|t>\<sigma\><rsub|s>*d*B<rsup|i><rsub|s>|)>,<space|0.22em><space|0.22em><space|0.22em>t\<in\><around|[|0,T|]>,
    </equation>

    where the stock has random drift

    <\equation>
      <label|2.22><mut><rsup|i><above|=|\<triangle\>><mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>,
    </equation>

    with <math|B<rsup|1><rsub|t>=p*<space|0.17em>W<rsub|t>+q*<space|0.17em>B<rsub|t>>,
    <space|0.17em><space|0.17em><math|\<upsilon\><rsup|1><rsub|t>=-q*\<lambda\>*<space|0.17em>U<rsub|t>>,
    and <math|\<upsilon\><rsub|t><rsup|0>>,<space|0.17em><space|0.17em>
    <math|B<rsub|t><rsup|0>> are defined in Equations
    (<reference|2.30>--<reference|2.23>).
  </prop>

  <\proof>
    See Appendix A for proof.
  </proof>

  <\remark>
    Observe from (<reference|2.21.0>) that for the <math|i>\Uth investor,
    that is, relative to the filtration <math|<calF><rsup|i>>, the drift of
    the stock price is <math|<mut><rsup|i>>, is
    <with|font-series|bold|random>, while they both share a common
    deterministic volatility <math|\<sigma\><rsub|t>>, which is the
    volatility of the original driving process given by (<reference|2.1a>),
    which has a deterministic drift <math|<mut>>. Moreover,
    <math|<E><mut><rsup|i>=<mut>>
  </remark>

  We state without proof, a useful result for
  <math|\<upsilon\><rsup|i><rsub|t>> that will be required in the sequel.

  <\prop>
    <label|pro2>Let <math|i\<in\><around|{|0,1|}>>,
    <math|p\<in\><around|[|0,<space|0.17em>1|]>>,
    <math|p<rsup|2>+q<rsup|2>=1> and <math|t\<in\><around|[|0,<space|0.17em>T|]>>.<next-line>Let
    <math|\<upsilon\><rsup|0><rsub|t>=-\<lambda\>*<big|int><rsub|0><rsup|t>e<rsup|-\<lambda\>*<around|(|t-s|)>>*<around|(|1+\<gamma\><around|(|s|)>|)>*d*B<rsup|0><rsub|s>>
    and <math|\<upsilon\><rsup|1><rsub|t>=-\<lambda\>*<space|0.17em>q*<space|0.17em>U<rsub|t>>.
    Then<next-line><math|<around|(|0|)>><space|.1in>
    <math|<E><around|[|\<upsilon\><rsup|i><rsub|t>|]>=0>.<next-line><math|<around|(|1|)>><space|.1in>
    <math|<E><around|[|\<upsilon\><rsup|0><rsub|t>|]><rsup|2>=\<lambda\><rsup|2>*<big|int><rsub|0><rsup|t>e<rsup|-2*\<lambda\>*<around|(|t-s|)>>*<around|(|1+\<gamma\><around|(|s|)>|)><rsup|2>*d*s\<le\><half>\<lambda\>*<space|0.17em>q<rsup|2>>.<next-line><math|<around|(|2|)>><space|.1in>
    <math|<E><around|[|\<upsilon\><rsup|1><rsub|t>|]><rsup|2>=<frac|\<lambda\>|2>*<space|0.17em><around|(|1-p<rsup|2>|)>*<space|0.17em><around|(|1-e<rsup|-2*\<lambda\>*t>|)>\<le\><half>\<lambda\>*<space|0.17em>q<rsup|2>>.<next-line><math|<around|(|3|)>><space|.1in>
    <math|<E><around|[|\<upsilon\><rsup|i><rsub|t>|]><rsup|2>=<frac|\<lambda\>|2>*<around|(|1-p|)>*<around|(|1+|(>-1)<rsup|i+1>p),<space|0.22em><space|0.22em><space|0.22em><text|as
    >t\<rightarrow\>\<infty\>>.<next-line><math|<around|(|4|)>><space|.1in>
    <math|<big|int><rsub|0><rsup|T><E><around|[|\<upsilon\><rsup|i><rsub|t>|]><rsup|2>*d*t\<simeq\><frac|\<lambda\>|2>*<space|0.17em><around|(|1-p|)>*<around|(|1+|(>-1)<rsup|i+1>p)<space|0.17em>T,<space|0.22em><space|0.22em><space|0.22em><text|as
    ><space|0.22em><space|0.22em>T\<longrightarrow\>\<infty\>>.<next-line><math|<around|(|5|)>><space|.1in>
    As <math|T\<longrightarrow\>\<infty\>>, the asymptotic excess cumulative
    variance of the <math|v<rsup|i>>s is

    <\equation*>
      <big|int><rsub|0><rsup|T><E><around|[|\<upsilon\><rsup|1><rsub|t>|]><rsup|2>*d*t-<big|int><rsub|0><rsup|T><E><around|[|\<upsilon\><rsup|0><rsub|t>|]><rsup|2>*d*t\<simeq\>\<lambda\>*<space|0.17em>p*<space|0.17em><around|(|1-p|)>*<space|0.17em>T\<leq\><frac|\<lambda\>|4>*<space|0.17em>T.
    </equation*>
  </prop>

  <\remark>
    <math|<around|(|0|)>> Observe that for the <math|i>\Uth investor, the
    random process <math|\<upsilon\><rsup|i><rsub|t>> has a mean of 0, and is
    simply the number of standard deviations (volatility units) of its random
    drift (<math|<mut><rsup|i>>) given in its price dynamic from its
    deterministic mean (<math|<mut>>). That is,
    <math|<E><mut><rsup|i>=<mut>><next-line><math|<around|(|1|)>> Moreover,
    <math|\<upsilon\><rsup|i><rsub|t>> is an integrated Brownian motion,
    explicitly given by

    <eqnarray|<tformat|<table|<row|<cell|\<upsilon\><rsup|0><rsub|t>>|<cell|=>|<cell|-\<lambda\>*<big|int><rsub|0><rsup|t>e<rsup|-\<lambda\>*<around|(|t-s|)>>*<around|(|1+\<gamma\><around|(|s|)>|)>*d*B<rsup|0><rsub|s>,>>|<row|<cell|\<upsilon\><rsup|1><rsub|t>>|<cell|=>|<cell|-\<lambda\>*<space|0.17em>q*<space|0.17em>U<rsub|t>=-\<lambda\>*<space|0.17em>q*<space|0.17em><big|int><rsub|0><rsup|t>e<rsup|-\<lambda\>*<around|(|t-s|)>>*d*B<rsub|s>,<space|0.22em><space|0.22em><space|0.22em>t\<in\><around|[|0,T|]>.<eq-number><label|2.2215>>>>>>

    <math|<around|(|2|)>> The variance of the process
    <math|\<upsilon\><rsup|i><rsub|t>> is
    <math|<E><around|[|\<upsilon\><rsup|i><rsub|t>|]><rsup|2>>, a
    monotonically increasing function of <math|t>, the mean-reversion speed
    <math|\<lambda\>>, and the mispricing level <math|q<rsup|2>>. The
    variance is bounded by half of the reversion speed and goes to zero if
    any of these quantities approach zero.<next-line><math|<around|(|3|)>>
    The cumulative variances are also bounded above by the mean-reversion
    speed, the mispricing level <math|q<rsup|2>>, and the investment horizon
    <math|T>.
  </remark>

  <section|Power Utility Functions>

  We assume that each investor has a utility function
  <math|<U>:<around|(|0,<space|0.17em>\<infty\>|)>\<rightarrow\><R>> for
  wealth that satisfies the Inada condition, i.e., it is strictly increasing,
  strictly concave, continuously differentiable, with

  <\equation*>
    <U><rprime|'><around|(|0|)>=lim<rsub|w*\<downarrow\>*0><U><rprime|'><around|(|w|)>=+\<infty\>,<space|.5in><U><rprime|'><around|(|\<infty\>|)>=lim<rsub|w\<rightarrow\>\<infty\>><U><rprime|'><around|(|w|)>=0.
  </equation*>

  <no-indent><math|<U><rsub|0><around|(|w|)>=log w>, the logarithmic utility
  and <math|<U><rsub|\<gamma\>><around|(|w|)>=<frac|w<rsup|\<gamma\>>|\<gamma\>>,<space|0.22em><space|0.22em>\<gamma\>\<less\>1>,
  the power utility, satisfy this condition. In the sequel, all utility
  functions are assumed to be power, with constant relative risk aversion
  (RRA), <math|1-\<gamma\>>. In particular, it is easy to show that
  <math|<U><rsub|\<gamma\>><around|(|w|)>=<frac|w<rsup|\<gamma\>>-1|\<gamma\>>\<longrightarrow\><space|0.17em>U<rsub|0><around|(|w|)>=log
  w,<space|0.27em><space|0.27em><text|when><space|0.17em>\<gamma\>\<longrightarrow\>0>.<label|2.36aa>

  <section|Portfolio and Wealth Processes of Investors>

  <\defn>
    [<with|font-series|bold|Portfolio Process>] A portfolio process
    <math|\<pi\>:<around|[|0,<space|0.17em>T|]>\<times\>\<Omega\>\<rightarrow\><R>>,
    is an <math|<calF>=<around|(|<calF><rsub|t>|)><rsub|t\<geq\>0>>--adapted
    process satisfying <math|<big|int><rsub|0><rsup|T><around|(|<pit><sigt>|)><rsup|2>*d*t\<less\>\<infty\>,<space|0.17em><space|0.17em><space|0.17em>><text|almost
    surely.>
  </defn>

  <no-indent>Although <math|\<pi\>> is a function of
  <math|<around|(|t,\<omega\>|)>>, in the sequel we keep <math|\<Omega\>> in
  the background, and assume that <math|\<pi\>> is primarily a function of
  time <math|t>, where <math|<pit>> is the proportion of an investor's wealth
  invested in the stock at time <math|t>. The remainder <math|1-<pit>>, is
  invested in the bond or money market. <math|\<pi\>> is not restricted to
  [0,<space|0.17em>1] for the purely continuous model\Uwe allow
  short\Uselling (<math|\<pi\>\<less\>0>) and borrowing
  (<math|\<pi\>\<gtr\>1>) at the risk\Ufree rate.

  <\defn>
    [<with|font-series|bold|Self--financing>] A portfolio process
    <math|\<pi\>> is called self--financing if

    <\equation>
      <label|2.37a>d*V<rsub|t>=<around|(|1-<pit>|)>*r<rsub|t>*V<rsub|t>*<space|0.17em>d*t+<pit>V<rsub|t>*<frac|d*S<rsub|t>|S<rsub|t>>,
    </equation>

    where <math|V<rsub|t>> is the wealth or value of the holding of stock and
    bond at time <math|t\<in\><around|[|0,T|]>>.
  </defn>

  <no-indent>Thus, for self\Ufinancing portfolios, the change in the wealth
  is due only to the change in prices, <with|font-series|bold|provided> that
  no money is brought in or taken out by the investor.<next-line>

  <no-indent><with|font-series|bold|The Wealth Process:> For a given
  non\Urandom initial wealth <math|x\<gtr\>0>, let
  <math|V<rsup|x,<space|0.17em>\<pi\>>\<equiv\>V<rsup|\<pi\>>\<equiv\>V=<around|(|V<rsub|t>|)><rsub|t\<geq\>0>>
  denote the wealth process corresponding to a self\Ufinancing portfolio
  <math|\<pi\>> with <math|V<rsub|0>=x>, and satisfying the stochastic
  differential equation (<reference|2.37a>).

  <no-indent>We now present wealth dynamics for each investor.

  <\thm>
    <label|th2.3>Let <math|i\<in\><around|{|0,1|}>> and let <math|r<rsub|t>>
    be the risk--free interest rate. Let <math|\<pi\><rsup|i>> and
    <math|V<rsup|i>> be the respective portfolio and wealth processes for the
    <math|i>--th investor as a result of investing in the stock, with Sharpe
    ratio

    <\equation>
      <label|2.50>\<theta\><rsup|i><rsub|t>=<frac|<mut><rsup|i>-r<rsub|t>|\<sigma\><rsub|t>>,<space|0.22em><space|0.22em><space|0.22em><mut><rsup|i>=<mut>+\<upsilon\><rsup|i><rsub|t>*<space|0.17em>\<sigma\><rsub|t>,<space|0.22em><space|0.22em>t\<in\><around|[|0,<space|0.17em>T|]>,
    </equation>

    and percentage return dynamic driven by an <math|<calF><rsup|i>>--adapted
    Brownian motion <math|B<rsup|i>>, given by (<reference|2.21.0>). Then the
    wealth process <math|V<rsup|i>=V<rsup|i,<space|0.17em>\<pi\>>>
    corresponding to <math|\<pi\>>, and initial wealth
    <math|<space|0.17em>x\<gtr\>0>, has percentage return dynamic

    <\equation>
      <label|2.52><frac|d*V<rsup|i><rsub|t>|V<rsup|i><rsub|t>>=<around|(|r<rsub|t>+<pit><rsup|i>\<sigma\><rsub|t>*\<theta\><rsup|i><rsub|t>|)>*<space|0.17em>d*t+<pit><rsup|i><space|0.17em>\<sigma\><rsub|t>*d*B<rsup|i><rsub|t>,
    </equation>

    with unique discounted wealth process

    <\equation>
      <label|2.53><wide|V|~><rsup|i><rsub|t>=x*<space|0.17em>exp
      <around*|(|<big|int><rsub|0><rsup|t><around|(|<pis><rsup|i>\<sigma\><rsub|s>*\<theta\><rsup|i><rsub|s>-<half><around|(|<pis><rsup|i>|)><rsup|2>*\<sigma\><rsup|2><rsub|s>|)>*d*s+<big|int><rsub|0><rsup|t><pis><rsup|i>\<sigma\><rsub|s>*d*B<rsup|i><rsub|s>|)>
    </equation>

    and under power utility <math|<U><around|(|w|)>=w<rsup|\<gamma\>>=e<rsup|\<gamma\>*<space|0.17em>log
    w>,<space|0.22em><space|0.22em>w\<gtr\>0,<space|0.17em>\<gamma\>\<less\>1>,

    <\equation>
      <label|2.55aa><U><around|(|<wide|V|~><rsup|i><rsub|t>|)>=e<rsup|\<gamma\>*<space|0.17em>log
      <wide|V|~><rsup|i><rsub|t>>=e<rsup|\<gamma\>*<space|0.17em>log
      x+\<gamma\>*<space|0.17em>H<rsup|i><around|(|t|)>>
    </equation>

    where

    <\equation>
      <label|2.55ab>H<rsup|i><around|(|t|)>=<half><big|int><rsub|0><rsup|t><around|(|2*\<theta\><rsub|s><rsup|i><pis><rsup|i>\<sigma\><rsub|s>-<around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>|)>*d*s+<big|int><rsub|0><rsup|t><pis><rsup|i>\<sigma\><rsub|s>*d*B<rsup|i><rsub|s>.
    </equation>
  </thm>

  <\proof>
    See appendix A for proof.
  </proof>

  <section|Utility Maximization from Terminal Wealth>

  Each investor is assumed to be rational; that is, the investor is a utility
  maximizer. Thus, both informed and uninformed investors maximize their
  respective expected utility from terminal wealth <math|V<rsub|T>>, where
  <math|T> is the investment horizon. The terminal wealth <math|V<rsub|T>> is
  represented by its discounted value <math|<wide|V|~><rsub|T>>. We then
  maximize <math|<E><rsub|\<pi\>><U><around|(|<wide|V|~><rsub|T>|)>> where
  <math|\<pi\>> is selected from an admissible set
  <math|<calA><around|(|x|)>>.

  <\defn>
    [<with|font-series|bold|Admissible Portfolio>] A self--financing
    portfolio <math|\<pi\>> is admissible if <math|V<rsup|\<pi\>><rsub|t>> is
    lower bounded for all <math|t\<in\><around|[|0,<space|0.17em>T|]>>. That
    is, there exists <math|K\<gtr\>-\<infty\>> such that almost surely,
    <math|V<rsup|\<pi\>><rsub|t>\<gtr\>K> for all
    <math|t\<in\><around|[|0,T|]>>.-(cf Oksendal 2005, page 265)
  </defn>

  <no-indent>Since <math|x\<gtr\>0>, we assume that
  <math|V<rsub|t><rsup|\<pi\>>\<gtr\>0> and therefore
  <math|<wide|V|~><rsub|t><rsup|\<pi\>>\<gtr\>0> for all
  <math|t\<in\><around|[|0,<space|0.17em>T|]>>. Thus equivalently,
  <math|\<pi\>> is admissible if <math|<wide|V|~><rsub|t><rsup|\<pi\>>\<gtr\>0>
  for all <math|t\<in\><around|[|0,T|]>>. Karatzas and Shreve (1991), define
  an admissible portfolio in terms of the utility function
  <math|<U><around|(|x|)>> by the prescription:
  <math|<E><around|[|<U><around|(|<wide|V|~><rsub|t><rsup|\<pi\>>|)>|]><rsup|->\<less\>\<infty\>>,
  where <math|a<rsup|->=max <around|{|0,-a|}>>. Either definition will
  suffice!

  <\defn>
    [ <with|font-series|bold|Admissible set>] Let <math|x\<gtr\>0> be the
    initial wealth of the investor. The admissible set
    <math|<calA><around|(|x|)>> of this investor is defined by

    <\equation*>
      <label|2.57><calA><around|(|x|)>=<around*|{|\<pi\>:\<pi\>-a*d*m*i*s*s*i*b*l*e,S-i*n*t*e*g*r*a*b*l*e,<calF>-p*r*e*d*i*c*t*a*b*l*e|}>.
    </equation*>
  </defn>

  <no-indent><math|\<pi\>> is <math|<calF>>\Upredictable if it is measurable
  relative to the predictable sigma\Ualgebra on
  <math|<around|[|0,<space|0.17em>T|]>\<times\>\<Omega\>> (see Protter(2004)
  for details).

  <subsection|Utility Maximization Problem and Optimal Portfolios>

  For a given utility function <math|U<around|(|\<cdummy\>|)>> and initial
  wealth <math|x\<gtr\>0>, we maximize the expected utility from (discounted)
  terminal wealth <math|<E><around|[|<U><around|(|<wide|V|~><rsub|t><rsup|\<pi\>>|)>|]>>,
  over the investors admissible set <math|<calA><around|(|x|)>>. The value
  function for this problem is <math|u<around|(|x|)><above|=|\<triangle\>>sup<rsub|\<pi\>\<in\><calA><around|(|x|)>><E><around|[|<U><around|(|<wide|V|~><rsub|t><rsup|\<pi\>>|)>|]>>,
  where it is assumed that <math|u<around|(|x|)>\<less\>\<infty\>> for all
  <math|x\<gtr\>0>. That is, there is an optimal portfolio
  <math|\<pi\><rsup|\<ast\>>\<in\><calA><around|(|x|)>> such that
  <math|u<around|(|x|)>=<E><around|[|<U><around|(|<wide|V|~><rsub|t><rsup|\<pi\><rsup|\<ast\>>>|)>|]>>.
  In other words, suppressing superscripts for investors,
  <math|\<pi\><rsub|t><rsup|\<ast\>>=arg sup
  <E><around|[|<U><around|(|<wide|V|~><rsub|t><rsup|\<pi\><rsup|\<ast\>>>|)>|]>>.
  Let <math|i\<in\><around|{|0,1|}>>. For the <math|i>\Uth investor, define
  an admissible set: <math|<calA><rsup|i><around|(|x|)>=<around*|{|\<pi\>:<wide|V|~><rsub|t><rsup|\<pi\>>\<gtr\>0,<space|0.22em>a.*s.,S-i*n*t*e*g*r*a*b*l*e,<calF><rsup|i>-p*r*e*d*i*c*t*a*b*l*e|}>>
  and a utility maximization problem: <math|sup<rsub|\<pi\>><around*|{|<E><around|[|<U><around|(|<wide|V|~><rsub|t><rsup|\<pi\>>|)>|]>:\<pi\>\<in\><calA><rsup|i><around|(|x|)>|}>>,
  with respective value functions:

  <\equation>
    <label|2.63>u<rsup|i><around|(|x|)>=sup<rsub|\<pi\>><around*|{|<E><around|[|<U><around|(|<wide|V|~><rsub|t><rsup|\<pi\>>|)>|]>:\<pi\>\<in\><calA><rsup|i><around|(|x|)>|}>=<E><U><around|(|<wide|V|~><rsub|t><rsup|\<pi\><rsup|\<ast\>,<space|0.17em>i>>|)>.
  </equation>

  The logarithmic utility function is used by Guasoni (2006) so that an
  explicit solution of (<reference|2.63>) is obtained (cf Amendinger et
  al.(1998), Imkeller and Ankirchner (2006), Karatzas and Pikovsky (1996)).
  We now give a slightly modified version of Guasoni's solution to
  (<reference|2.63>) using the notation developed in preceding sections.

  <\thm>
    [ Guasoni (2006), Theorem 3.1]<label|th2.4> Let
    <math|i\<in\><around|{|0,1|}>>, <math|u<rsup|i><around|(|x|)>> be the
    value function, and <math|\<pi\><rsup|\<ast\>,<space|0.17em>i>> the
    optimal portfolio for the <math|i>-th investor that solves
    (<reference|2.63>), where utility is assumed to be logarithmic and the
    risk--free interest rate is <math|r=0>.<next-line><math|<around|(|1|)>><space|.1in>
    The optimal portfolio for the <math|i>--th investor is:

    <\equation>
      <label|2.64><pit><rsup|\<ast\>,<space|0.17em>i>=<frac|\<theta\><rsup|i><rsub|t>|\<sigma\><rsub|t>>=<frac|<mut><rsup|i>|\<sigma\><rsup|2><rsub|t>>=<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|\<sigma\><rsup|2><rsub|t>>,<space|0.27em><space|0.27em><space|0.27em>t\<in\><around|[|0,T|]>,
    </equation>

    where <math|\<theta\><rsup|i>> is the Sharpe ratio of the stock for the
    <math|i>--th investor.<next-line><math|<around|(|2|)>> <space|.1in>The
    maximum expected utility from terminal wealth for the <math|i>--th
    investor is

    <eqnarray|<tformat|<table|<row|<cell|u<rsup|i><around|(|x|)>>|<cell|=>|<cell|log
    x+<half><E><big|int><rsub|0><rsup|T><around|(|\<theta\><rsup|i><rsub|t>|)><rsup|2>*d*t=log
    x+<half><E><big|int><rsub|0><rsup|T><around*|(|<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|\<sigma\><rsub|t>>|)><rsup|2>*d*t<eq-number><label|2.65>>>>>>

    <math|<around|(|3|)>><space|.1in> As <math|T\<longrightarrow\>\<infty\>>,
    the asymptotic maximum expected utility is

    <\equation>
      <label|2.67>u<rsup|i><rsub|\<infty\>><around|(|x|)>\<simeq\>log
      x+<half><big|int><rsub|0><rsup|T><frac|<mut><rsup|2>|\<sigma\><rsup|2><rsub|t>>*<space|0.17em>d*t+<frac|\<lambda\>|4>*<around|(|1-p|)>*<around|(|1+|(>-1)<rsup|i+1>p)<space|0.17em>T.
    </equation>

    <math|<around|(|4|)>><space|.1in> The excess asymptotic maximum expected
    utility of the informed investor is

    <\equation>
      <label|2.68>u<rsup|1><rsub|\<infty\>><around|(|x|)>-u<rsup|0><rsub|\<infty\>><around|(|x|)>\<simeq\><frac|\<lambda\>|2>*<space|0.17em>p*<around|(|1-p|)>*<space|0.17em>T.
    </equation>
  </thm>

  <\remark>
    The optimal portfolio for each investor, relative to its filtration, is
    its Sharpe ratio divided by the common volatility of the driving Brownian
    motion. It is random, being depended on the random processes
    <math|\<upsilon\><rsup|i><rsub|t>>. The expected optimal portfolio is the
    deterministic ratio of the mean return ( <math|<mut>>) and the variance
    (<math|\<sigma\><rsub|t><rsup|2>>) of the stock.<next-line>From (2), we
    observed that optimal utility is directly related to the natural
    logarithm of the initial investment <math|x>. In (3), the asymptotic
    expected utility for each investor depends on
    <math|p=<sqrt|(>*1-q<rsup|2>>) and hence on <math|q<rsup|2>>, the
    proportion of mispricing in the stock price. It therefore follows in (4),
    that the excess asymptotic utility which is a function of <math|p>, also
    depends on <math|q<rsup|2>>, the proportion of mispricing in the stock
    price.
  </remark>

  We now give an analogous result to Guasoni (2006), starting with the
  optimal portfolio.

  <\prop>
    <label|pro2.22a>Let <math|i\<in\><around|{|0,1|}>>, and
    <math|\<pi\><rsup|\<ast\>,<space|0.17em>i>> the optimal portfolio for the
    <math|i>-th investor that solves (<reference|2.63>), where utility is the
    basis power function <math|w<rsup|\<gamma\>>> with RRA
    <math|1-\<gamma\>>, and the risk--free interest rate is
    <math|r=0>.<next-line><math|<around|(|1|)>><space|.1in> The optimal
    portfolio for the <math|i>--th investor is:

    <\equation>
      <label|2.64><pit><rsup|\<ast\>,<space|0.17em>i>=<frac|\<theta\><rsub|\<gamma\>><rsup|i><around|(|t|)>|\<sigma\><rsub|t>>=<frac|<mut><rsup|i>|<around|(|1-\<gamma\>|)>*\<sigma\><rsup|2><rsub|t>>=<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|<around|(|1-\<gamma\>|)>*\<sigma\><rsup|2><rsub|t>>,<space|0.27em><space|0.27em><space|0.27em>t\<in\><around|[|0,T|]>,
    </equation>

    where <math|\<theta\><rsub|\<gamma\>><rsup|i>=<frac|\<theta\><rsup|i>|1-\<gamma\>>>
    is the risk-adjusted Sharpe ratio of the stock owned by the <math|i>--th
    investor.
  </prop>

  <\proof>
    <with|font-series|bold|{Proof of Proposition
    <reference|pro2.22a>}><next-line>From Theorem <reference|th2.3>,
    <math|H<rsup|i><around|(|t|)>=<half><big|int><rsub|0><rsup|t><around|(|2*\<theta\><rsub|s><rsup|i><pis><rsup|i>\<sigma\><rsub|s>-<around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>|)>*d*s+<big|int><rsub|0><rsup|t><pis><rsup|i>\<sigma\><rsub|s>*d*B<rsup|i><rsub|s>>.
    Therefore,<next-line><math|<E><around|(|H<rsup|i><around|(|t|)>|)>=<half><E><big|int><rsub|0><rsup|t><around|(|2*\<theta\><rsub|s><rsup|i><pis><rsup|i>\<sigma\><rsub|s>-<around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>|)>*d*s>,
    and by Ito's isometry, its variance is
    <math|<V><around|(|H<rsup|i><around|(|t|)>|)>=<E><around|(|<big|int><rsub|0><rsup|t><pis><rsup|i>\<sigma\><rsub|s>*d*B<rsup|i><rsub|s>|)><rsup|2>=<big|int><rsub|0><rsup|t><around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>*d*s>.
    Whence, <math|<E><U><around|(|<wide|V|~><rsup|i><rsub|t>|)>=<E>e<rsup|\<gamma\>*<space|0.17em>log
    x+\<gamma\>*<space|0.17em>H<rsup|i><around|(|t|)>><next-line>=e<rsup|\<gamma\>*<space|0.17em>log
    x+<E><around|(|\<gamma\>*<space|0.17em>H<rsup|i><around|(|t|)>|)>+<half><V><around|(|\<gamma\>*<space|0.17em>H<rsup|i><around|(|t|)>|)>>=e<rsup|\<gamma\>*<space|0.17em>log
    x+\<gamma\><space|0.17em><E><around|(|H<rsup|i><around|(|t|)>|)>+<half>\<gamma\><rsup|2><space|0.17em><V><around|(|H<rsup|i><around|(|t|)>|)>>>.
    Since the exp function is increasing, <math|u<rsup|i><around|(|x|)>=sup
    e<rsup|\<gamma\>*<space|0.17em>log x+\<gamma\><space|0.17em><E><around|(|H<rsup|i><around|(|t|)>|)>+<half>\<gamma\><rsup|2><space|0.17em><V><around|(|H<rsup|i><around|(|t|)>|)>>=e<rsup|sup
    <around|(|\<gamma\>*<space|0.17em>log
    x+\<gamma\><space|0.17em><E><around|(|H<rsup|i><around|(|t|)>|)>+<half>\<gamma\><rsup|2><space|0.17em><V><around|(|H<rsup|i><around|(|t|)>|)>|)>>>.
    Thus <math|<pit><rsup|\<ast\>,<space|0.17em>i>> <math|=arg sup
    <around|(|\<gamma\>*<space|0.17em>log
    x+\<gamma\><space|0.17em><E><around|(|H<rsup|i><around|(|t|)>|)>+<half>\<gamma\><rsup|2><space|0.17em><V><around|(|H<rsup|i><around|(|t|)>|)>|)>=arg
    max <around|[|\<gamma\>*<space|0.17em>log
    x+\<gamma\><E><around|(|<half><big|int><rsub|0><rsup|t><around|(|2*\<theta\><rsub|s><rsup|i><pis><rsup|i>\<sigma\><rsub|s>-<around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>|)>*d*s|)>+<half>\<gamma\><rsup|2>*<space|0.17em><big|int><rsub|0><rsup|t><around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>*d*s|]>=arg
    max <around|[|\<gamma\><around|(|<half><E><big|int><rsub|0><rsup|t><around|(|2*\<theta\><rsub|s><rsup|i><pis><rsup|i>\<sigma\><rsub|s>-<around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>|)>*d*s|)>+<half>\<gamma\><rsup|2>*<space|0.17em><big|int><rsub|0><rsup|t><around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>*d*s|]>=arg
    max <half><space|0.17em>\<gamma\>*<space|0.17em><around|[|<E><big|int><rsub|0><rsup|t><around|(|2*\<theta\><rsub|s><rsup|i><pis><rsup|i>\<sigma\><rsub|s>-<around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>|)>*d*s+\<gamma\>*<space|0.17em><big|int><rsub|0><rsup|t><around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>*d*s|]><next-line>=arg
    max [<E><big|int><rsub|0><rsup|t><around|(|2*\<theta\><rsub|s><rsup|i><space|0.17em><pis><rsup|i>\<sigma\><rsub|s>-<around|(|1-\<gamma\>|)>*<space|0.17em><big|int><rsub|0><rsup|t><around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>*d*s|]>=arg
    max <around|[|<E><big|int><rsub|0><rsup|t><around|(|2*\<theta\><rsub|s><rsup|i><space|0.17em><pis><rsup|i>\<sigma\><rsub|s>-<around|(|1-\<gamma\>|)><space|0.17em><around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>|)>*d*s|]><next-line>=arg
    max <around|(|1-\<gamma\>|)><E><around|[|<big|int><rsub|0><rsup|t><around|(|2*<frac|\<theta\><rsub|s><rsup|i>|1-\<gamma\>><space|0.17em><pis><rsup|i>\<sigma\><rsub|s>-<around|(|<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>|)>*d*s|]>=arg
    max <E><around|[|<big|int><rsub|0><rsup|t><around|(|<frac|\<theta\><rsub|s><rsup|i>|1-\<gamma\>>|)><rsup|2>*d*s-<big|int><rsub|0><rsup|t><around|(|<frac|\<theta\><rsub|s><rsup|i>|1-\<gamma\>>-<pis><rsup|i>\<sigma\><rsub|s>|)><rsup|2>*d*s|]>>.
    Thus optimal is achieved iff <math|<frac|\<theta\><rsub|s><rsup|i>|1-\<gamma\>>-<pis><rsup|i>\<sigma\><rsub|s>=0>.
    Therefore

    <\equation*>
      <pit><rsup|\<ast\>,<space|0.17em>i>=<frac|\<theta\><rsub|\<gamma\>><rsup|i><around|(|t|)>|\<sigma\><rsub|t>>=<frac|<mut><rsup|i>|<around|(|1-\<gamma\>|)>*\<sigma\><rsup|2><rsub|t>>=<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|<around|(|1-\<gamma\>|)>*\<sigma\><rsup|2><rsub|t>>,<space|0.27em><space|0.27em><space|0.27em>t\<in\><around|[|0,T|]>,
    </equation*>

    where <math|\<theta\><rsub|\<gamma\>><rsup|i>=<frac|\<theta\><rsup|i>|1-\<gamma\>>>
    is the risk-adjusted Sharpe ratio of the stock for the <math|i>\Uth
    investor. It also follows that the value function for the <math|i>\Uth
    investor is

    <\equation*>
      u<rsup|i><around|(|x|)>=e<rsup|\<gamma\>*<space|0.17em>log
      x+<half>\<gamma\>*<space|0.17em><around|(|1-\<gamma\>|)><E><big|int><rsub|0><rsup|t><around|(|<frac|\<theta\><rsub|s><rsup|i>|1-\<gamma\>>|)><rsup|2>*d*s>=e<rsup|\<gamma\>*<space|0.17em>log
      x+<half><space|0.17em><frac|\<gamma\>|<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|t><around|(|\<theta\><rsub|s><rsup|i>|)><rsup|2>*d*s>.
    </equation*>
  </proof>

  <\remark>
    (1) Under power utility the optimal portfolio for each investor, relative
    to is filtration, is its risk-adjusted Sharpe ratio divided by the common
    volatility of the driving Brownian motion. It is random, being depended
    on the random processes <math|\<upsilon\><rsup|i><rsub|t>>. Optimal
    portfolios are inversely proportional to the coefficient of RRA,
    <math|1-\<gamma\>> . When the RRA approaches 1, that is as
    <math|\<gamma\>\<rightarrow\>0>, we recover the optimal portfolio of the
    logarithmic utility, as seen in Guasoni's Theorem 3.1 above. However, as
    the RRA approach 0, the portfolios explode, while as the RRA becomes
    infinite, the portfolios become zero and all funds are invested in the
    risk\Ufree asset.<next-line>(2) For both investors, the expected optimal
    portfolio is <with|font-series|bold|deterministic> and inversely
    proportional to the RRA, and is independent of the mean-reversion speed
    and the mispricing level <math|q<rsup|2>>. It explodes as the RRA
    approaches 0, that is, when <math|\<gamma\>\<rightarrow\>0>, and becomes
    essentially zero when either the RRA or stock price volatility becomes
    very large or infinite.
  </remark>

  <\prop>
    <label|th2.22a>Let <math|i\<in\><around|{|0,1|}>>, and
    <math|u<rsup|i><around|(|x|)>> be the value function that solves
    (<reference|2.63>), where utility is the basis power function
    <math|w<rsup|\<gamma\>>> with RRA <math|1-\<gamma\>>. Let
    <math|\<theta\><rsub|\<gamma\>><rsup|i>=<frac|\<theta\><rsup|i>|1-\<gamma\>>>
    be the risk-adjusted Sharpe ratio of the stock for the <math|i>--th
    investor , and risk--free rate <math|r=0>.<next-line><math|<around|(|1|)>>
    <space|.1in>The maximum expected power utility of terminal wealth for the
    <math|i>--th investor is

    <eqnarray|<tformat|<table|<row|<cell|u<rsup|i><around|(|x|)>>|<cell|=>|<cell|e<rsup|\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|T><around|(|\<theta\><rsup|i><rsub|t>|)><rsup|2>*d*t>=e<rsup|\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>*<around|(|1-\<gamma\>|)>|2><E><big|int><rsub|0><rsup|T><around|(|<around|(|\<theta\><rsup|i><rsub|\<gamma\>>|)><rsub|t>|)><rsup|2>*d*t>>>|<row|<cell|>|<cell|=>|<cell|e<rsup|\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|T><around*|(|<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|\<sigma\><rsub|t>>|)><rsup|2>*d*t>.<eq-number><label|2.65>>>>>>

    <math|<around|(|2|)>> <space|.1in>As <math|T\<longrightarrow\>\<infty\>>,
    the asymptotic maximum expected power utility is

    <\equation>
      <label|2.67>u<rsup|i><rsub|\<infty\>><around|(|x|)>\<simeq\>e<rsup|<around*|\<nobracket\>|\<gamma\>*<space|0.17em>log
      x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>>*<around*|(|<big|int><rsub|0><rsup|T><frac|<mut><rsup|2>|\<sigma\><rsup|2><rsub|t>>*<space|0.17em>d*t+<frac|\<lambda\>|2>*<around|(|1-p|)>*<around|(|1+|(>-1|)><rsup|i+1>*p)<space|0.17em>T|)>>.
    </equation>

    and the (wealth) relative asymptotic maximum expected basis power utility
    is

    <\equation>
      <label|2.67><frac|u<rsup|1><rsub|\<infty\>><around|(|x|)>|u<rsup|0><rsub|\<infty\>><around|(|x|)>>=e<rsup|<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>>*<space|0.17em>\<lambda\>*<space|0.17em>p*<around|(|1-p|)>*<space|0.17em>T>.<next-line>
    </equation>
  </prop>

  <\proof>
    <with|font-series|bold|{Proof of Proposition
    <reference|th2.22a>}><next-line><math|<around|(|1|)>> From Proposition
    <reference|pro2.22a>, the optimal portfolio is
    <math|<pit><rsup|\<ast\>,<space|0.17em>i>=<frac|<mut><rsup|i>|<around|(|1-\<gamma\>|)>*\<sigma\><rsup|2><rsub|t>>=<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|<around|(|1-\<gamma\>|)>*\<sigma\><rsup|2><rsub|t>>>.
    Thus for the <math|i>\Uth investor, the value function or maximum
    expected power utility is <math|u<rsup|i><around|(|x|)>=>

    <\equation*>
      e<rsup|\<gamma\>*<space|0.17em>log x+<half>\<gamma\>*<space|0.17em><around|(|1-\<gamma\>|)><E><big|int><rsub|0><rsup|t><around|(|<frac|\<theta\><rsub|s><rsup|i>|1-\<gamma\>>|)><rsup|2>*d*s>=e<rsup|\<gamma\>*<space|0.17em>log
      x+<half><space|0.17em><frac|\<gamma\>|<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|t><around|(|\<theta\><rsub|s><rsup|i>|)><rsup|2>*d*s>=e<rsup|\<gamma\>*<space|0.17em>log
      x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|T><around*|(|<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|\<sigma\><rsub|t>>|)><rsup|2>*d*t>.
    </equation*>

    <math|<around|(|2|)>>. From Proposition <reference|pro2> ,
    <math|<big|int><rsub|0><rsup|T><E><around|[|\<upsilon\><rsup|i><rsub|t>|]><rsup|2>*d*t\<rightarrow\><frac|\<lambda\>|2>*<space|0.17em><around|(|1-p|)>*<around|(|1+|(>-1)<rsup|i+1>p)<space|0.17em>T>,
    as <math|T\<rightarrow\>\<infty\>>. But
    <math|<big|int><rsub|0><rsup|T><E><around|(|<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|\<sigma\><rsub|t>>|)><rsup|2>*d*t=<big|int><rsub|0><rsup|T><E><around|(|<frac|<mut>|\<sigma\><rsub|t>>+\<upsilon\><rsup|i><rsub|t>|)><rsup|2>*d*t=<big|int><rsub|0><rsup|T><around|(|<frac|<mut>|\<sigma\><rsub|t>>|)><rsup|2>*d*t+<big|int><rsub|0><rsup|T><E><around|(|\<upsilon\><rsup|i><rsub|t>|)><rsup|2>*d*t>
    which converges to <math|<big|int><rsub|0><rsup|T><around|(|<frac|<mut>|\<sigma\><rsub|t>>|)><rsup|2>*d*t+<frac|\<lambda\>|2>*<space|0.17em><around|(|1-p|)>*<around|(|1+|(>-1)<rsup|i+1>p)<space|0.17em>T<space|0.17em><space|0.17em>>as
    <math|T\<rightarrow\>\<infty\>>. Substituting this approximation into
    part <math|<around|(|1|)>> yields, <math|u<rsup|i><rsub|\<infty\>><around|(|x|)>\<simeq\>e<rsup|<around*|\<nobracket\>|\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>>*<around*|(|<big|int><rsub|0><rsup|T><frac|<mut><rsup|2>|\<sigma\><rsup|2><rsub|t>>*<space|0.17em>d*t+<frac|\<lambda\>|2>*<around|(|1-p|)>*<around|(|1+|(>-1|)><rsup|i+1>*p)<space|0.17em>T|)>>>.
    Imposing Part <math|<around|(|3|)>> of Proposition <reference|pro2> and
    simplifying the the quotient of the value function of the informed and
    the uninformed investors yield the desired result.
  </proof>

  <\remark>
    (1) The maximum expected power utility from terminal wealth grows
    exponentially with the natural logarithm initial wealth <math|x> adjusted
    by one minus the RRA.<next-line>(2) Observe that the wealth relative
    asymptotic power utility is an exponential function of the
    <with|font-series|bold|risk-adjusted> excess asymptotic utility under
    logarithmic utility, which is independent of the initial wealth of the
    investors. This is an important unexpected result!
  </remark>

  We now present our main result for the general power utility function,
  which is analogous to the previous theorem.

  <\thm>
    [<with|font-series|bold|Main>]<label|th2.22b> Let
    <math|i\<in\><around|{|0,1|}>>, <math|u<rsup|i><around|(|x|)>> be the
    value function, and <math|\<pi\><rsup|\<ast\>,<space|0.17em>i>> the
    optimal portfolio for the <math|i>-th investor that solves
    (<reference|2.63>), where utility is assumed to be general power utility
    function <math|<U><rsub|\<gamma\>><around|(|w|)>=<frac|w<rsup|\<gamma\>>-1|\<gamma\>>,<space|0.17em><space|0.17em>\<gamma\>\<less\>1>
    and the risk--free interest rate is <math|r=0>. Define the log-linear
    value function <math|\<psi\><rsup|i><around|(|x|)>=log
    <around|(|1+\<gamma\>*<space|0.17em>u<rsup|i><around|(|x|)>|)>>, where
    <math|x> is the initial wealth and <math|1-\<gamma\>> is the relative
    risk aversion. Let <math|\<theta\><rsub|\<gamma\>><rsup|i>=<frac|\<theta\><rsup|i>|1-\<gamma\>>>
    be the risk-adjusted Sharpe ratio of the stock for the <math|i>--th
    investor , and risk--free rate <math|r=0>.<next-line><math|<around|(|1|)>>
    <space|.1in>The optimal portfolios are given by Proposition
    <reference|pro2.22a>.<next-line><math|<around|(|2|)>> <space|.1in>The
    log-linear maximum expected utility of terminal wealth is

    <eqnarray|<tformat|<table|<row|<cell|\<psi\><rsup|i><around|(|x|)>>|<cell|=>|<cell|\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|T><around|(|\<theta\><rsup|i><rsub|t>|)><rsup|2>*d*t=\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>*<around|(|1-\<gamma\>|)>|2><E><big|int><rsub|0><rsup|T><around|(|\<theta\><rsub|\<gamma\>><rsup|i>|)><rsub|t><rsup|2>*d*t>>|<row|<cell|>|<cell|=>|<cell|\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|T><around*|(|<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|\<sigma\><rsub|t>>|)><rsup|2>*d*t.<eq-number><label|2.65>>>>>>

    <math|<around|(|3|)>><space|.1in> As <math|T\<longrightarrow\>\<infty\>>,
    the asymptotic log-linear maximum expected power utility is

    <\equation>
      <around*|\<nobracket\>|<label|2.67>\<psi\><rsup|i><rsub|\<infty\>><around|(|x|)>=\<gamma\>*<space|0.17em>log
      x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>>*<around*|(|<big|int><rsub|0><rsup|T><frac|<mut><rsup|2>|\<sigma\><rsup|2><rsub|t>>*<space|0.17em>d*t+<frac|\<lambda\>|2>*<around|(|1-p|)>*<around|(|1+|(>-1|)><rsup|i+1>*p)<space|0.17em>T|)><next-line>
    </equation>

    <math|<around|(|4|)>><space|.1in> The excess asymptotic log-linear
    maximum expected utility is

    <\equation>
      <label|2.68>\<psi\><rsup|1><rsub|\<infty\>><around|(|x|)>-\<psi\><rsup|0><rsub|\<infty\>><around|(|x|)>\<simeq\><frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>>*\<lambda\>*<space|0.17em>p*<around|(|1-p|)>*<space|0.17em>T,
    </equation>

    which vanishes as the RRA tends to 1.<next-line><math|<around|(|5|)>>
    Moreover, the excess asymptotic maximum expected utility is

    <\equation>
      <label|2.68a>u<rsup|1><rsub|\<infty\>><around|(|x|)>-u<rsup|0><rsub|\<infty\>><around|(|x|)>\<simeq\><frac|1|2>*\<lambda\>*<space|0.17em>p*<around|(|1-p|)>*<space|0.17em>T,
    </equation>
  </thm>

  <\proof>
    <with|font-series|bold|{Proof of Main Theorem
    }><next-line><math|<around|(|1|)>><space|0.17em> Since the utility
    function is a linear transformation of that the utility function used in
    the proof of Proposition <reference|pro2.22a>, the optimal portfolio is
    identical for each respective investor, and the proof is the
    same.<next-line><math|<around|(|2|)>><space|0.17em> From Proposition
    <reference|pro2.22a>, the value function for the general power utility
    function is <math|u<rsup|i><around|(|x|)>=<frac|e<rsup|\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|T><around|(|\<theta\><rsup|i><rsub|t>|)><rsup|2>*d*t>-1|\<gamma\>>=<frac|e<rsup|\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>*<around|(|1-\<gamma\>|)>|2)><E><big|int><rsub|0><rsup|T><around|(|\<theta\><rsub|\<gamma\>><rsup|i>|)><rsub|t><rsup|2>*d*t>-1|\<gamma\>>>.<next-line>Rearranging,
    the log-linear value function for each investor
    is<next-line><math|\<psi\><rsup|i><around|(|x|)>=log
    <around|(|1+\<gamma\>*<space|0.17em>u<rsup|i><around|(|x|)>|)>=\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|T><around|(|\<theta\><rsup|i><rsub|t>|)><rsup|2>*d*t=\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>><E><big|int><rsub|0><rsup|T><around*|(|<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|\<sigma\><rsub|t>>|)><rsup|2>*d*t>.<next-line><math|<around|(|3|)>>
    Fix <math|\<gamma\>>, and let <math|T\<rightarrow\>\<infty\>>. Then
    <math|<E><big|int><rsub|0><rsup|T><around*|(|<frac|<mut>+\<upsilon\><rsup|i><rsub|t>*\<sigma\><rsub|t>|\<sigma\><rsub|t>>|)><rsup|2>*d*t\<rightarrow\><big|int><rsub|0><rsup|T><frac|<mut><rsup|2>|\<sigma\><rsup|2><rsub|t>>*<space|0.17em>d*t+<frac|\<lambda\>|2>*<around|(|1-p|)>*<around|(|1+|(>-1)<rsup|i+1>p)<space|0.17em>T>,
    whence <math|<around*|\<nobracket\>|\<psi\><rsup|i><around|(|x|)>\<rightarrow\>\<gamma\>*<space|0.17em>log
    x+<frac|\<gamma\>|2*<around|(|1-\<gamma\>|)>>*<around*|(|<big|int><rsub|0><rsup|T><frac|<mut><rsup|2>|\<sigma\><rsup|2><rsub|t>>*<space|0.17em>d*t+<frac|\<lambda\>|2>*<around|(|1-p|)>*<around|(|1+|(>-1|)><rsup|i+1>*p)<space|0.17em>T|)>>.<next-line><math|<around|(|4|)>><space|0.17em>
    The excess asymptotic log-linear maximum expected power utility follows
    from<math|<around|(|3|)>>.<next-line><math|<around|(|5|)>><space|0.17em>
    Let <math|\<gamma\>\<rightarrow\>0>. From <math|<around|(|2|)>>
    <math|<around*|\<nobracket\>|<around*|\<nobracket\>|<frac|\<psi\><rsup|i><around|(|x|)>|\<gamma\>>=lim<rsub|\<gamma\>\<rightarrow\>0>
    log x+<frac|1|2*<around|(|1-\<gamma\>|)>>*<around*|(|<big|int><rsub|0><rsup|T><frac|<mut><rsup|2>|\<sigma\><rsup|2><rsub|t>>*<space|0.17em>d*t+<frac|\<lambda\>|2>*<around|(|1-p|)>*<around|(|1+|(>-1|)><rsup|i+1>*p)<space|0.17em>T|)><next-line>=log
    x+<frac|1|2>*<around*|(|<big|int><rsub|0><rsup|T><frac|<mut><rsup|2>|\<sigma\><rsup|2><rsub|t>>*<space|0.17em>d*t+<frac|\<lambda\>|2>*<around|(|1-p|)>*<around|(|1+|(>-1|)><rsup|i+1>*p)<space|0.17em>T|)>>.
    But we also have <math|lim<rsub|\<gamma\>\<rightarrow\>0>
    <frac|\<psi\><rsup|i><around|(|x|)>|\<gamma\>>=lim<rsub|\<gamma\>\<rightarrow\>0>
    <frac|log <around|(|1+\<gamma\>*<space|0.17em>u<rsup|i><around|(|x|)>|)>|\<gamma\>>=u<rsup|i><around|(|x|)>>,
    which yields the required result by differencing.
  </proof>

  <section|Conclusion>

  We extend the theory of asymmetric information in mispricing models of
  stocks with prices that follow geometric Brownian motion to investors
  having CRRA preferences. We obtain optimal portfolios and utilities,
  including asymptotic utilities for informed and uninformed investors under
  the general power log\Ulinear power utility. Our results contain those of
  Guasoni (2006) as a special case of the relative risk aversion approaching
  one.

  <section*|References>

  Amendinger, J., P.<nbsp>Imkeller, and M.<nbsp>Schweizer (1998).
  <newblock>Additional logarithmic utility of an insider.
  <newblock><with|font-shape|italic|Stochastic Processes and their
  Application><nbsp><with|font-shape|italic|<with|font-series|bold|75>,
  263\U286.>

  Applebaum, D. (2004). <newblock><with|font-shape|italic|Lvy Processes and
  Stochastic Calculus>. <newblock>Cambridge University Press.

  Barberis, N., A.<nbsp>Shleifer, and R.<nbsp>Vishny (1998). <newblock>A
  model of investor sentiment. <newblock><with|font-shape|italic|Journal of
  Financial Economics><nbsp><with|font-shape|italic|<with|font-series|bold|49>,
  307\U43.>

  Brunnermeier, M.<nbsp>K. (2001). <newblock><with|font-shape|italic|Asset
  Pricing Under Asymmetric Information: Bubbles, Crashes, Technical Analysis
  and Herding>. <newblock>Oxford University Press.

  Buckley, W. (2009). <newblock><with|font-shape|italic|Asymmetric
  information in fads models in Lvy markets>. <newblock>Ph. D. thesis,
  Florida Atlantic University.

  Campbell, J.<nbsp>Y. and A.<nbsp>S. Kyle (1993). <newblock>Smart Money,
  Noise Trading and Stock Price Behaviour.
  <newblock><with|font-shape|italic|Review of Economic
  Studies><nbsp><with|font-shape|italic|<with|font-series|bold|60>(1),
  1\U34.>

  Campbell, J.<nbsp>Y. and R.<nbsp>J. Shiller (1987). <newblock>Cointegration
  and Tests of Present Value Models. <newblock><with|font-shape|italic|Journal
  of Political Economy><nbsp><with|font-shape|italic|<with|font-series|bold|95>(5),
  1062\U1088.>

  Cheridito, P. (2003). <newblock>Representation of Gaussian measures that
  are equivalent to Wiener measure. <newblock><with|font-shape|italic|Seminar
  de Probabilities><nbsp><with|font-shape|italic|<with|font-series|bold|XXXVII>,
  81\U89. <newblock>Springer Lecture Notes in Mathematics 1832.>

  Cutler, D., J.<nbsp>Poterba, and L.<nbsp>Summers (1990).
  <newblock>Speculative dynamics and the role of feedback traders.
  <newblock><with|font-shape|italic|American Economic
  Review><nbsp><with|font-shape|italic|<with|font-series|bold|80>, 63\U68.>

  Daniel, K., D.<nbsp>Hirshleifer, and A.<nbsp>Subrahmanyam (1998).
  <newblock>Investor Psychology and Security Market Under- and Overreactions.
  <newblock><with|font-shape|italic|Journal of
  Finance><nbsp><with|font-shape|italic|<with|font-series|bold|53>,
  1839\U85.>

  De Long, J.<nbsp>B., A.<nbsp>Shleifer, L.<nbsp>H. Summers, and R.<nbsp>J.
  Waldmann (1990). <newblock>Noise Trader Risk in Financial Markets.
  <newblock><with|font-shape|italic|Journal of Political
  Economy><nbsp><with|font-shape|italic|<with|font-series|bold|98>, 703\U73.>

  Fama, E. (1970). <newblock>Efficient Capital Markets: A Review of Theory
  and Empirical Work. <newblock><with|font-shape|italic|Journal of
  Finance><nbsp><with|font-shape|italic|<with|font-series|bold|25>,
  383\U417.>

  Flavin, M.<nbsp>A. (1983). <newblock>Excess Volatility in the Financial
  Markets: A Reassessment of the Empirical Evidence.
  <newblock><with|font-shape|italic|Journal of Political
  Economy><nbsp><with|font-shape|italic|<with|font-series|bold|91>(6),
  929\U956.>

  Guasoni, P. (2006). <newblock>Asymmetric information in fads models.
  <newblock><with|font-shape|italic|Finance and
  Stochastics><nbsp><with|font-shape|italic|<with|font-series|bold|10>,
  159\U177.>

  Hitsuda, M. (1968). <newblock>Representation of Gaussian processes
  equivalent to Wiener process. <newblock><with|font-shape|italic|Osaka
  Journal of Mathematics><nbsp><with|font-shape|italic|<with|font-series|bold|5>,
  299\U312.>

  Imkeller, P. and S.<nbsp>Ankirchner (2006, August). <newblock>Financial
  markets with asymmetric information, information drift, additional utility
  and entropy. <newblock>Technical report, Humboldt University.

  Karatzas, I. and I.<nbsp>Pikovsky (1996). <newblock>Anticipative portfolio
  optimization. <newblock><with|font-shape|italic|Advances in Applied
  Probability><nbsp><with|font-shape|italic|<with|font-series|bold|28>,
  1095\U1122.>

  Karatzas, I. and S.<nbsp>Shreve (1991). <newblock>Martingale and duality
  methods for utility maximization in an incomplete market.
  <newblock><with|font-shape|italic|SIAM Journal on Control and
  Optimization><nbsp><with|font-shape|italic|<with|font-series|bold|29>(3),
  702\U730.>

  Karatzas, I. and S.<nbsp>Shreve (1999).
  <newblock><with|font-shape|italic|Brownian Motion and Stochastic Calculus>
  (2nd ed.). <newblock>Springer.

  Kleidon, A.<nbsp>W. (1986). <newblock>Variance Bounds Tests and Stock Price
  Valuation Models. <newblock><with|font-shape|italic|Journal of Political
  Economy><nbsp><with|font-shape|italic|<with|font-series|bold|94>,
  953\U1001.>

  LeRoy, S.<nbsp>F. and R.<nbsp>D. Porter (1981). <newblock>The Present-Value
  Relation: Tests Based on Implied Variance Bounds.
  <newblock><with|font-shape|italic|Econometrica><nbsp><with|font-shape|italic|<with|font-series|bold|49>(3),
  555\U574.>

  March, T. and R.<nbsp>Merton (1986). <newblock>Dividend variability and
  variance bounds tests for the rationality of stock market prices.
  <newblock><with|font-shape|italic|American Economic
  Review><nbsp><with|font-shape|italic|<with|font-series|bold|76>, 483\U98.>

  Merton, R.<nbsp>C. (1971). <newblock>Optimum consumption and portfolio
  rules in a continuous-time model. <newblock><with|font-shape|italic|Journal
  of Economic Theory><nbsp><with|font-shape|italic|<with|font-series|bold|3>,
  373\U413.>

  Odean, T. (1998). <newblock>Volume, Volatility, Price, and Profit When All
  Traders Are Above Average. <newblock><with|font-shape|italic|Journal of
  Finance><nbsp><with|font-shape|italic|<with|font-series|bold|53>,
  1887\U1934.>

  Oksendal, B. (2005). <newblock><with|font-shape|italic|Stochastic Integral
  Equations> (6th ed.). <newblock>Springer.

  Protter, P. (2004). <newblock><with|font-shape|italic|Stochastic
  Integration and Differential Equations> (2nd ed.). <newblock>Springer.

  Shiller, R. (1981). <newblock>Do stock prices move to much to be justified
  by subsequent changes in dividends? <newblock><with|font-shape|italic|American
  Economic Review><nbsp><with|font-shape|italic|<with|font-series|bold|71>,
  421\U436.>

  Summers, L.<nbsp>H. (1986). <newblock>Does the Stock Market Rationally
  Reflect Fundamental Values? <newblock><with|font-shape|italic|Journal of
  Finance><nbsp><with|font-shape|italic|<with|font-series|bold|41>,
  591\U601.>

  Summers, L.<nbsp>H. and J.<nbsp>M. Poterba (1988). <newblock>Mean reversion
  in stock prices: Evidence and implications.
  <newblock><with|font-shape|italic|Journal of Financial
  Economics><nbsp><with|font-shape|italic|<with|font-series|bold|21>(1),
  27\U59.>

  Wang, J. (1993). <newblock>A Model of Intertemporal Asset Prices Under
  Asymmetric Information. <newblock><with|font-shape|italic|Review of
  Economic Studies><nbsp><with|font-shape|italic|<with|font-series|bold|60>,
  249\U282.>

  West, K.<nbsp>D. (1988). <newblock>Dividend Innovations and Stock Price
  Volatility. <newblock><with|font-shape|italic|Econometrica><nbsp><with|font-shape|italic|<with|font-series|bold|56>,
  37\U61.>

  <section|>

  <\proof>
    <with|font-series|bold|{Proof of Proposition 1:}> From equations
    (<reference|2.2>) and (<reference|2.3>), we have for the informed
    investor (<math|i=1>) <math|d*Y<rsub|t>=p*<space|0.17em>d*W<rsub|t>+q*<space|0.17em>d*U<rsub|t>=p*<space|0.17em>d*W<rsub|t>+q*<space|0.17em>d(-\<lambda\>*U<rsub|t>*d*t+d*B<rsub|t>)=p*<space|0.17em>d*W<rsub|t>+q*<space|0.17em>d*B<rsub|t>-q*<space|0.17em>\<lambda\>*U<rsub|t>*d*t=d*B<rsup|1><rsub|t>-q*<space|0.17em>\<lambda\>*U<rsub|t>*d*t=d*B<rsup|1><rsub|t>+\<upsilon\><rsub|t><rsup|1>*d*t>,
    where

    <\equation>
      B<rsup|1><rsub|t><above|=|\<triangle\>>p*<space|0.17em>W<rsub|t>+q*<space|0.17em>B<rsub|t>,<space|0.17em><space|0.17em>\<upsilon\><rsup|1><rsub|t><above|=|\<triangle\>>-q*<space|0.17em>\<lambda\>*U<rsub|t>.<label|2.18a>
    </equation>

    Substituting (<reference|2.18a>) into (<reference|2.1>), yields
    <math|<frac|d*S<rsub|t>|S<rsub|t>>=<mut>d*t+\<sigma\><rsub|t>*d*Y<rsub|t>=<mut>d*t+\<sigma\><rsub|t>*<around|(|d*B<rsup|1><rsub|t>+\<upsilon\><rsub|t><rsup|1>*d*t|)><next-line>=<around|(|<mut>+\<upsilon\><rsup|1><rsub|t>*\<sigma\><rsub|t>|)>*d*t+\<sigma\><rsub|t>*d*B<rsup|1><rsub|t>*<no-number>=<mut><rsup|1><space|0.17em>d*t+\<sigma\><rsub|t>*d*B<rsup|1><rsub|t>>,
    where

    <\equation>
      <label|2.19><mut><rsup|1><above|=|\<triangle\>><mut>+\<upsilon\><rsup|1><rsub|t>*\<sigma\><rsub|t>.
    </equation>

    So under <math|<calF><rsup|1>>, the informed investor has stock price

    <\equation>
      <label|2.21>S<rsub|t>=S<rsub|0>*<space|0.17em>exp
      <around*|(|<big|int><rsub|0><rsup|t><around|(|\<mu\><rsup|1><rsub|s>-<half>\<sigma\><rsup|2><rsub|s>|)>*d*s+<big|int><rsub|0><rsup|t>\<sigma\><rsub|s>*d*B<rsup|1><rsub|s>|)>,<space|0.22em><space|0.22em><space|0.22em>t\<in\><around|[|0,<space|0.17em>T|]>,
    </equation>

    where <math|B<rsup|1>> is an <math|<calF><rsup|1>>\UBrownian motion given
    by (<reference|2.18a>) and <math|<mut><rsup|1>> is given by
    (<reference|2.19>).<next-line>For the uninformed investor(<math|i=0>), we
    have <math|d*Y<rsub|t>=d*B<rsup|0><rsub|t>+\<upsilon\><rsub|t><rsup|0>*d*t>
    from Equation <reference|2.30>, where
    <math|<mut><rsup|0>=<mut>+\<upsilon\><rsup|0><rsub|t>*\<sigma\><rsub|t>>.
    Substituting into (<reference|2.1>) yields the desired result.
  </proof>

  <no-indent><with|font-series|bold|Proof of Theorem 1>:<space|0.17em> This
  follows below with <math|<mut><rsup|i>,\<theta\><rsub|t><rsup|i>,<pit><rsup|i>,V<rsub|t><rsup|i>>,
  etc, replacing the relevant variables, and <math|B<rsub|t><rsup|i>>
  replacing <math|Y<rsub|t>>.

  <\proof>
    It is clear that <math|<frac|d*V<rsub|t>|V<rsub|t>>=<around|(|1-<pit>|)>*<space|0.17em>r<rsub|t>*<space|0.17em>d*t+<pit><space|0.17em><frac|d*S<rsub|t>|S<rsub|t>>>.
    Imposing the stock price dynamic (<reference|2.1a>) on the last equation,
    yields <math|<frac|d*V<rsub|t>|V<rsub|t>>>
    <math|=<around|(|1-<pit>|)>*r<rsub|t>*<space|0.17em>d*t+<pit><space|0.17em><around|(|<mut>d*t+\<sigma\><rsub|t>*<space|0.17em>d*Y<rsub|t>|)>=<around|(|r<rsub|t>+<pit><around|(|<mut>-r<rsub|t>|)>|)>*<space|0.17em>d*t+<pit><space|0.17em>\<sigma\><rsub|t>*<space|0.17em>d*Y<rsub|t>>.
    Thus, we get the percentage returns dynamic of the wealth process

    <\equation>
      <label|2.40><frac|d*V<rsub|t>|V<rsub|t>>=<around|(|r<rsub|t>+<pit><space|0.17em>\<sigma\><rsub|t>*<space|0.17em>\<theta\><rsub|t>|)>*<space|0.17em>d*t+<pit><space|0.17em>\<sigma\><rsub|t>*<space|0.17em>d*Y<rsub|t>,
    </equation>

    where <math|\<theta\>>, is the stock's Sharpe ratio or market price of
    risk. By the It formula, the unique solution to (<reference|2.40>) with
    <math|V<rsub|0>=x>, is the stochastic exponential

    <\equation>
      <label|2.41>V<rsub|t>=x*<space|0.17em>exp
      <around*|(|<big|int><rsub|0><rsup|t>r<rsub|s>*<space|0.17em>d*s+<big|int><rsub|0><rsup|t><around|(|<pis><space|0.17em>\<sigma\><rsub|s>*<space|0.17em>\<theta\><rsub|s>-<half><space|0.17em><pis><rsup|2><space|0.17em>\<sigma\><rsup|2><rsub|s>|)>*<space|0.17em>d*s+<big|int><rsub|0><rsup|t><pis>\<sigma\><rsub|s>*<space|0.17em>d*Y<rsub|s>|)>,
    </equation>

    with discounted wealth process <math|<wide|V|~>> given by

    <\equation*>
      <label|2.42><wide|V|~><rsub|t><above|=|\<triangle\>>exp
      (-<big|int><rsub|0><rsup|t><space|0.17em>r<rsub|s>*<space|0.17em>d*s)<space|0.17em>V<rsub|t>=x*<space|0.17em>exp
      <around*|(|<big|int><rsub|0><rsup|t><around|(|<pis><space|0.17em>\<sigma\><rsub|s>*<space|0.17em>\<theta\><rsub|s>-<half><space|0.17em><pis><rsup|2><space|0.17em>\<sigma\><rsup|2><rsub|s><space|0.17em>|)>*d*s+<big|int><rsub|0><rsup|t><pis><space|0.17em>\<sigma\><rsub|s>*<space|0.17em>d*Y<rsub|s>|)>.
    </equation*>

    The power utility of discounted wealth is
    <math|<U><around|(|<wide|V|~><rsub|t>|)>=e<rsup|\<gamma\>*<space|0.17em>log
    <wide|V|~><rsub|t>>==e<rsup|\<gamma\>*<space|0.17em>log
    x+\<gamma\>*<space|0.17em>H<around|(|t|)>>>, where <math|log
    <wide|V|~><rsub|t>=log x+<big|int><rsub|0><rsup|t><around|(|<pis>\<sigma\><rsub|s>*\<theta\><rsub|s>-<half><pis><rsup|2>\<sigma\><rsup|2><rsub|s>|)>*d*s+<big|int><rsub|0><rsup|t><pis>\<sigma\><rsub|s>*d*Y<rsub|s>=log
    x+<half><big|int><rsub|0><rsup|t>\<theta\><rsup|2><rsub|s>*d*s-<half><big|int><rsub|0><rsup|t><around|(|<pis>\<sigma\><rsub|s>-\<theta\><rsub|s>|)><rsup|2>*d*s+<big|int><rsub|0><rsup|t><pis>\<sigma\><rsub|s>*d*Y<rsub|s>=log
    <around|(|x|)>+H<around|(|t|)>>.
  </proof>
</body>