<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <\hide-preamble>
    <assign|currentvolume|<macro|1>>

    <assign|currentissue|<macro|1>>

    <assign|currentyear|<macro|2011>>

    <assign|month|<macro|January>>
  </hide-preamble>

  <doc-data|<doc-title|Sensitivity analysis of the early
  exercise<next-line>boundary for American style of Asian
  options>|<doc-author|<author-data|<author-name|D.
  evovi>>>|<doc-author|<author-data|<author-name|M.
  Tak>>>|<doc-date|January 15, 2011>>

  <\abstract>
    In this paper we analyze American style of floating strike Asian call
    options belonging to the class of financial derivatives whose payoff
    diagram depends not only on the underlying asset price but also on the
    path average of underlying asset prices over some predetermined time
    interval. The mathematical model for the option price leads to a free
    boundary problem for a parabolic partial differential equation. Applying
    fixed domain transformation and transformation of variables we develop an
    efficient numerical algorithm based on a solution to a non-local
    parabolic partial differential equation for the transformed variable
    representing the synthesized portfolio. For various types of averaging
    methods we investigate the dependence of the early exercise boundary on
    model parameters.\ 
  </abstract>

  <commby|Lubin G. Vulkov>

  <section|Introduction>

  Asian path dependent options belong to the class of financial derivatives
  whose payoff diagram depends not only on the underlying asset price but
  also on the path average of underlying asset prices over some predetermined
  time interval. Such path dependent options can be often found at
  commodities markets such as oil, grain trade, etc. At expiration, the
  payoff diagram of such options is less sensitive with respect to sudden
  changes of the underlying asset value. Therefore a holder of an Asian
  option can effectively hedge the risk arising from a sudden price jump
  close to expiry. Typically, the payoff diagram of an Asian path dependent
  option depends on either arithmetic or geometric average of the spot price
  of the underlying asset. Such contingent claims can be used as a financial
  instrument for hedging highly volatile assets or goods. We refer the reader
  to references <cite|PW-SH-JD-1995|JCH-1997|LW-YKK-HY-1999|ATH-PLJ-2000|JD-2006|MD-YKK-2006|UW-2006|YKK-2008|BCK-YSO-2004|RW-MCF-2003|VL-2004>
  discussing qualitative and quantitative aspects of pricing Asian path
  dependent options.

  In this paper, we focus on a special subclass of Asian options. Namely, we
  will investigate the so-called average strike Asian call options. At the
  time of expiry <math|t=T>, a holder of such an option contract has the
  right (but not obligation) to purchase the underlying asset for the strike
  price given as the path average of underlying asset prices. This means that
  the terminal payoff diagram for such an option has the form:
  <math|V<around|(|S,A,T|)>=max <around|{|S-A,0|}>>, where <math|S=S<rsub|T>>
  is the spot price of the underlying asset, <math|A=A<rsub|T>> is the path
  average of the asset prices <math|S<rsub|t>,t\<in\><around|[|0,T|]>>, over
  the time interval <math|<around|[|0,T|]>> and <math|T\<gtr\>0> is the time
  of maturity.

  Concerning the method how the path averaged asset price <math|A=A<rsub|t>>
  is calculated at a time <math|t\<in\><around|[|0,T|]>>, we can distinguish
  the following methods of averaging of the path
  <math|S<rsub|u>,u\<in\><around|[|0,t|]>>:

  <\itemize>
    <item>arithmetic averaged options, where the average
    <math|A<rsup|a><rsub|t>> is given by

    <\equation>
      A<rsup|a><rsub|t>=<frac|1|t>*<big|int><rsub|0><rsup|t>S<rsub|\<xi\>>*d*\<xi\>,<label|arit-aver>
    </equation>

    <item>weighted arithmetic averaged options, with the average
    <math|A<rsup|w*a><rsub|t>> is given by

    <\equation>
      A<rsup|w*a><rsub|t>=<frac|1|K<around|(|t|)>>*<big|int><rsub|0><rsup|t>a*<around|(|t-\<xi\>|)>*S<rsub|\<xi\>>*d*\<xi\>,<space|2em><text|where>K<around|(|t|)>=<big|int><rsub|0><rsup|t>a<around|(|\<xi\>|)>*d*\<xi\>,<label|aritweight-aver>
    </equation>

    and <math|a> is an exponential weight function
    <math|a<around|(|\<xi\>|)>=exp (-\<lambda\>*\<xi\>)> with the averaging
    factor <math|\<lambda\>\<gtr\>0>,

    <item>geometric averaged options, where the average
    <math|A<rsup|g><rsub|t>> is given by

    <\equation>
      ln A<rsup|g><rsub|t>=<frac|1|t>*<big|int><rsub|0><rsup|t>ln
      S<rsub|\<xi\>>*d*\<xi\>.<label|geom-aver>
    </equation>
  </itemize>

  In Figure <reference|fig:asianExample2> we plot two different sample paths
  of the underlying asset price (solid lines) and their arithmetic, geometric
  and weighted arithmetic path averages. In the case of weighted arithmetic
  averaging with a weight factor <math|\<lambda\>\<gtr\>0> we can observe
  that the average <math|A<rsup|w*a><rsub|t>> approaches the sample path
  <math|S<rsub|t>> when <math|\<lambda\>\<to\>+\<infty\>>. On the other hand,
  the weighted arithmetic average <math|A<rsup|a><rsub|t>> approaches the
  arithmetic average when <math|\<lambda\>\<to\>0<rsup|+>>.

  <\big-figure>
    <\with|par-mode|center>
      <image|images/asian1|7.5truecm|||> <image|images/asian2|7.5truecm|||>

      <label|fig:asianExample2>
    </with>
  </big-figure|<with|font-size|0.84|Examples of evolution of underlying asset
  prices (solid lines) and their path averages (dashed lines).>>

  In this paper we are concerned with American style of Asian floating strike
  options giving its holder the right to exercise it anytime before the
  obligatory expiration time <math|t=T>. Our main purpose is to provide a
  numerical quantitative analysis of the early exercise boundary position for
  a floating strike Asian call option by means of a solution to the
  transformed nonlocal parabolic partial differential equation derived by
  Bokes and evovi <cite|sevcovicEarly|sevcovic:nova> for the case of
  arithmetic averaging. The main goal of this paper is to analyze the
  dependence and sensitivity of the early exercise boundary with respect to
  various model parameters.

  The paper is organized as follows. In the next section, we recall the
  partial differential equation for pricing floating strike Asian options. We
  also recall the method of dimension reduction of the equation. Next we
  discuss American style of Asian options and the early exercise boundary. A
  key tool for derivation of our numerical algorithm is transformation of the
  reduced equation to a fixed spatial domain. The resulting equation is a
  nonlocal parabolic PDE with an algebraic constraint between its solution
  and the free boundary position. In Section 3 we employ the method of finite
  difference approximation. We discretize our nonlocal equation in space and
  time. To this end we make use of multiplicative operator splitting method.
  Results of numerical computations are presented in Section 4. We discuss
  the impact of the averaging method on the form of the early exercise
  boundary. We furthermore analyze the dependence of the early exercise
  boundary with respect to various model parameters. We furthermore make a
  comparison of its position for different averaging methods.

  <section|Partial differential equation for pricing average strike Asian
  options>

  In this section we recall the parabolic partial differential equation for
  pricing Asian options. Derivation of the pricing equation is based on
  standard assumptions made on stochastic behavior of the underlying asset
  price <math|S<rsub|t>,t\<in\><around|[|0,T|]>>. Henceforth, we will suppose
  that <math|S<rsub|t>> follows a geometric Brownian motion, that is,

  <\equation*>
    d*S<rsub|t>=<around|(|r-q|)>*S<rsub|t>*d*t+\<sigma\>*S<rsub|t>*d*B<rsub|t>,
  </equation*>

  where <math|r\<gtr\>0> is the risk-free interest rate, <math|q\<ge\>0> is
  the dividend yield on the asset, <math|B<rsub|t>,t\<in\><around|[|0,T|]>>,
  is the standard Wiener process. Although the aforementioned assumption made
  on <math|S<rsub|t>> has obvious deficiencies like constancy of the
  volatility <math|\<sigma\>> or normality of the distribution of asset
  returns, we adopt this assumption throughout the paper.

  Since the payoff diagram <math|V<around|(|S,A,T|)>=max <around|{|S-A,0|}>>
  depends on both the spot asset price <math|S> and the path average <math|A>
  at <math|t=T> so does the price <math|V> of an Asian option for
  <math|0\<le\>t\<less\>T>. It means <math|V> is a function depending not
  only on the underlying asset spot price <math|S> and time <math|t> but also
  on the average <math|A> of the underlying asset price over the interval
  <math|<around|[|0,t|]>>, i.e. <math|V=V<around|(|S,A,t|)>>. In order to
  derive the pricing equation for an option price <math|V> one has to
  calculate its differential <math|d*V> over a time interval with an
  infinitesimal length <math|d*t>. The price <math|S=S<rsub|t>> as well as
  its path average <math|A=A<rsub|t>> are stochastic variables and so does
  the option price <math|V<rsub|t>=V<around|(|S<rsub|t>,A<rsub|t>,t|)>>. To
  calculate the differential <math|d*V> we have to find a relationship
  between the differential of the path average <math|A<rsub|t>> and the time
  <math|t>. Taking a differential of (<reference|arit-aver>) we obtain the
  expression:

  <\equation*>
    <frac|d*A<rsup|a><rsub|t>|d*t>=-<frac|1|t<rsup|2>>*<big|int><rsub|0><rsup|t>S<rsub|\<tau\>>*d*\<tau\>+<frac|1|t>*S<rsub|t>=<frac|S<rsub|t>-A<rsup|a><rsub|t>|t>
  </equation*>

  for the case of arithmetic average <math|A<rsup|a><rsub|t>>. On the other
  hand, for the case of geometric averaging we obtain from
  (<reference|geom-aver>):

  <\equation*>
    <frac|1|A<rsup|g><rsub|t>>*<frac|d*A<rsup|g><rsub|t>|d*t>=-<frac|1|t<rsup|2>>*<big|int><rsub|0><rsup|t>ln
    S<rsub|\<tau\>>*d*\<tau\>+<frac|1|t>*ln S<rsub|t>=<frac|ln S<rsub|t>-ln
    A<rsup|g><rsub|t>|t>.
  </equation*>

  Similarly, for the exponentially weighted arithmetic average
  <math|A<rsup|w*a><rsub|t>> with the weight parameter
  <math|\<lambda\>\<gtr\>0> we obtain

  <\equation*>
    <frac|d*A<rsup|w*a><rsub|t>|d*t>=<frac|\<lambda\>*<around|(|S<rsub|t>-A<rsup|w*a><rsub|t>|)>|1-exp
    (-\<lambda\>*t)>.
  </equation*>

  In all averaging methods under consideration, we can conclude the following
  relation between the differential <math|d*A> as a function of the
  stochastic variable <math|S> and the differential <math|d*t>.

  <\equation>
    d*A=A*<space|0.17em>f<around*|(|<frac|S|A>,t|)>*d*t,<label|6kap-dif-priemer>
  </equation>

  where the function <math|f> is given by

  <\equation>
    f<around|(|x,t|)>=<around*|{|<tabular*|<tformat|<table|<row|<cell|<frac|x-1|t>,<htab|0pt>>|<cell|<text|for
    arithmetic averaging>,<htab|0pt>>>|<row|<cell|>|<cell|>>|<row|<cell|<frac|\<lambda\>*<around|(|x-1|)>|1-exp
    (-\<lambda\>*t)>,<htab|0pt>>|<cell|<text|for exponentially weighted
    arithmetic averaging>,>>|<row|<cell|>|<cell|>>|<row|<cell|<frac|ln
    <around|(|x|)>|t>,<htab|0pt>>|<cell|<text|for geometric
    averaging>.<htab|0pt>>>>>>|\<nobracket\>>
  </equation>

  It means that the differential <math|d*A> is a stochastic variable with the
  leading order term of the order <math|d*t> (see Kwok <cite|YKK-2008>, Dai
  <cite|MD-YKK-2006>, evovi<cite|sevcovic:nova>). Applying
  It<math|<wide|<text|o>|\<bar\>>>'s lemma (cf. Kwok <cite|YKK-2008>) for the
  function <math|V=V<around|(|S,A,t|)>> and taking into account
  (<reference|6kap-dif-priemer>) we conclude the stochastic differential
  equation for the option price <math|V> in the form:

  <\equation*>
    d*V=<frac|\<partial\>*V|\<partial\>*S>*d*S+<around*|(|<frac|\<partial\>*V|\<partial\>*t>+<frac|\<sigma\><rsup|2>|2>*S<rsup|2>*<frac|\<partial\><rsup|2>*V|\<partial\>*S<rsup|2>>+<frac|\<partial\>*V|\<partial\>*A>*A*f<around*|(|<frac|S|A>,t|)>|)>*d*t.
  </equation*>

  Under the assumption of perfect replicability of the market and
  nonexistence of arbitrage opportunities (cf. Kwok <cite|YKK-2008>), it can
  be shown that the risk neutral price <math|V=V<around|(|S,A,t|)>> of an
  Asian call option is a solution to the parabolic partial differential
  equation

  <\equation>
    <label|PDR:azijske><frac|\<partial\>*V|\<partial\>*t>+<frac|\<sigma\><rsup|2>|2>*S<rsup|2>*<frac|\<partial\><rsup|2>*V|\<partial\>*S<rsup|2>>+<around|(|r-q|)>*S*<frac|\<partial\>*V|\<partial\>*S>+A*f<around*|(|<frac|S|A>,t|)><frac|\<partial\>*V|\<partial\>*A>-r*V=0,
  </equation>

  satisfying the payoff diagram corresponding to the averaged strike Asian
  option, i.e.

  <\equation*>
    V<around|(|S,A,T|)>=max <around|{|S-A,0|}>,
  </equation*>

  where <math|S,A\<gtr\>0,t\<in\><around|(|0,T|)>>.

  It is also well known that the PDE for average strike Asian options allows
  for a dimension reduction by introducing a new state variable <math|x> and
  the function <math|W> defined as follows:

  <\equation>
    x=<frac|S|A>,<space|2em>W<around|(|x,\<tau\>|)>=<frac|1|A>*V<around|(|S,A,t|)>,<label|subst>
  </equation>

  where <math|\<tau\>=T-t>. After straightforward computations we obtain a
  parabolic PDE for the function <math|W<around|(|x,\<tau\>|)>>:

  <\equation>
    <label|PDR:azijskeRegukovana><frac|\<partial\>*W|\<partial\>*\<tau\>>+<around*|[|f*<around|(|x,T-\<tau\>|)>-r+q|]>*x*<frac|\<partial\>*W|\<partial\>*x>-<frac|\<sigma\><rsup|2>|2>*x<rsup|2>*<frac|\<partial\><rsup|2>*W|\<partial\>*x<rsup|2>>+<around|[|r-f*<around|(|x,T-\<tau\>|)>|]>*W=0,
  </equation>

  where <math|\<tau\>\<in\><around|(|0,T|)>,x\<gtr\>0>. A solution <math|W>
  satisfies the initial condition:

  <\equation*>
    W<around|(|x,0|)>=max <around|{|x-1,0|}>.
  </equation*>

  A solution <math|W<around|(|x,\<tau\>|)>> to the aforementioned equation
  (<reference|PDR:azijskeRegukovana>) is defined on the fixed spatial
  interval <math|0\<less\>x\<less\>\<infty\>>. The function
  <math|V<around|(|S,A,t|)>> given by <math|V<around|(|S,A,t|)>=A*W*<around|(|S/A,T-t|)>>
  corresponds to the price of an Asian floating strike path dependent option
  for the so-called European style of contracts for which the option expires
  exactly at the time <math|t=T>.

  <subsection|American-style of Asian call options>

  In this paper we are concerned with American style of Asian options (cf.
  <cite|ATH-PLJ-2000|MD-YKK-2006|YKK-2008>). In contrast to European style of
  options, American style options can be exercised at any time until the
  obligatory maturity time <math|t=T>. The holder of such an option has the
  right to exercise it or to keep it depending on the spot price of the
  underlying <math|S<rsub|t>> at time <math|t> and its history
  <math|<around|{|S<rsub|u>,0\<le\>u\<le\>t|}>> prior the time <math|t>. The
  boundary between \Pcontinuation\Q and \Pstopping\Q regions plays an
  important role in pricing American-style of options. It can be described by
  the function <math|<around|(|A<rsup|\<ast\>><rsub|t>,t|)>\<mapsto\>S<rsup|\<ast\>><rsub|t>=S<rsub|f><around|(|A<rsub|t>,t|)>>,
  where <math|S<rsup|\<ast\>><rsub|t>> is the so-called early exercise
  boundary (cf. <cite|JCH-1997|RG-HEJ-1984|RG-RR-1984|IK-1988|JC-2008|YKK-2008|RAK-JBK-1998|RM-2002|AP-2008>).
  According to Kwok <cite|YKK-2008>, the set

  <\equation*>
    \<cal-E\>=<around|{|<around|(|S,A,t|)>\<in\><around|[|0,\<infty\>|)>\<times\><around|[|0,\<infty\>|)>\<times\><around|[|0,T|)>,V<around|(|S,A,t|)>=V<around|(|S,A,T|)>|}>
  </equation*>

  is the exercise region. For the case of a call option, there exists a early
  exercise boundary function <math|S<rsub|f>=S<rsub|f><around|(|A,t|)>> such
  that

  <\equation*>
    \<cal-E\>=<around|{|<around|(|S,A,t|)>\<in\><around|[|0,\<infty\>|)>\<times\><around|[|0,\<infty\>|)>\<times\><around|[|0,T|)>,S\<geq\>S<rsub|f><around|(|A,t|)>|}>.
  </equation*>

  It means that <math|S<rsup|\<ast\>><rsub|t>=S<rsub|f><around|(|A<rsub|t>,t|)>>,
  where <math|A<rsub|t>> is the path average of underlying asset prices
  <math|<around|{|S<rsub|u>,0\<le\>u\<le\>t|}>>. We can search the early
  exercise boundary function in a separated form

  <\equation*>
    S<rsub|f><around|(|A,t|)>=A*x<rsub|f><around|(|t|)>.
  </equation*>

  For more details we refer the reader to Dai and Kwok <cite|MD-YKK-2006> or
  Bokes and evovi <cite|sevcovicEarly|sevcovic:nova>. The corresponding
  spatial domain for the reduced function <math|W=W<around|(|x,\<tau\>|)>>
  satisfying (<reference|PDR:azijskeRegukovana>) is therefore given by

  <\equation*>
    0\<less\>x\<less\>\<rho\><around|(|\<tau\>|)>,\<tau\>\<in\><around|(|0,T|)>,
  </equation*>

  where <math|\<rho\><around|(|\<tau\>|)>=x<rsub|f>*<around|(|T-\<tau\>|)>>.
  From the <math|C<rsup|1>> continuity of <math|V<around|(|S,A,t|)>> at
  <math|<around|(|S<rsub|f><around|(|A,t|)>,A,t|)>> we conclude that

  <\equation>
    <frac|\<partial\>*V|\<partial\>*S><around|(|S<rsub|f><around|(|A,t|)>,A,t|)>=1.
  </equation>

  It follows from the payoff diagram that

  <\equation>
    V<around|(|S<rsub|f><around|(|A,t|)>,A,t|)>=S<rsub|f><around|(|A,t|)>-A,
  </equation>

  for <math|A\<gtr\>0> and <math|t\<in\><around|(|0,T|)>>. In terms of the
  new state variable <math|x>, we conclude the following boundary conditions
  for the function <math|W<around|(|x,\<tau\>|)>>:

  <align|<tformat|<table|<row|<cell|W<around|(|0,\<tau\>|)>>|<cell|=0,>|<cell|W<around|(|x,\<tau\>|)>>|<cell|=x-1,>|<cell|<frac|\<partial\>*W|\<partial\>*x><around|(|x,\<tau\>|)>>|<cell|=1,<text|at>x=\<rho\><around|(|\<tau\>|)>,<label|eq:derivaciaWatboundary>>>>>>

  for <math|\<tau\>\<in\><around|(|0,T|)>>. The initial condition for
  <math|W<around|(|x,\<tau\>|)>> is

  <\equation>
    W<around|(|x,0|)>=max <around|{|x-1,0|}>,<space|1em>\<forall\>x\<gtr\>0.
  </equation>

  Equation (<reference|PDR:azijskeRegukovana>) and boundary conditions
  (<reference|eq:derivaciaWatboundary>) represent a free boundary problem,
  because the spatial domain <math|0\<less\>x\<less\>\<rho\><around|(|\<tau\>|)>>
  depends on the unknown free boundary function <math|\<rho\>> which is a
  part of a solution of the problem.

  <subsection|Fixed domain transformation>

  Following ideas of transformation methodology developed by evovi in
  <cite|sevcovic:nova> (see also <cite|sevcovicEarly>) we introduce a new
  state variable <math|\<xi\>> and the transformed function
  <math|\<Pi\>=\<Pi\><around|(|\<xi\>,\<tau\>|)>> defined as:

  <\equation>
    \<xi\>=ln <around*|(|<frac|\<rho\><around|(|\<tau\>|)>|x>|)>,<space|2em>\<Pi\><around|(|\<xi\>,\<tau\>|)>=W<around|(|x,\<tau\>|)>-x*<frac|\<partial\>*W|\<partial\>*x><around|(|x,\<tau\>|)>.<label|transform>
  </equation>

  After straightforward calculations we obtain that
  <math|\<Pi\><around|(|\<xi\>,\<tau\>|)>> is a solution to the following
  linear parabolic equation

  <\equation>
    <frac|\<partial\>*\<Pi\>|\<partial\>*\<tau\>>+a<around|(|\<xi\>,\<tau\>|)><frac|\<partial\>*\<Pi\>|\<partial\>*\<xi\>>-<frac|\<sigma\><rsup|2>|2>*<frac|\<partial\><rsup|2>*\<Pi\>|\<partial\>*\<xi\><rsup|2>>+b<around|(|\<xi\>,\<tau\>|)>*\<Pi\>=0,<label|finalnaPDR>
  </equation>

  where

  <\equation*>
    a<around|(|\<xi\>,\<tau\>|)>=<frac|d|d*\<tau\>>*ln
    \<rho\><around|(|\<tau\>|)>-f*<around|(|\<rho\><around|(|\<tau\>|)>*e<rsup|-\<xi\>>,T-\<tau\>|)>+r-q-<frac|\<sigma\><rsup|2>|2>,
  </equation*>

  <\equation*>
    b<around|(|\<xi\>,\<tau\>|)>=<around*|\<nobracket\>|r+x*<frac|\<partial\>*f|\<partial\>*x>-f*<around|(|x,T-\<tau\>|)>|\|><rsub|x=\<rho\>*e<rsup|-\<xi\>>>.
  </equation*>

  For details of derivation of (<reference|finalnaPDR>) we refer the reader
  to <cite|sevcovicEarly|sevcovic:nova>. The initial condition for the
  solution <math|\<Pi\><around|(|\<xi\>,0|)>> is:

  <\equation>
    <label|eq:initialCondition>\<Pi\><around|(|\<xi\>,0|)>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|-1,<space|1em>>|<cell|\<xi\>\<less\>ln
    \<rho\><around|(|0|)>,>>|<row|<cell|0,<space|1em>>|<cell|\<xi\>\<gtr\>ln
    \<rho\><around|(|0|)>.>>>>>|\<nobracket\>>
  </equation>

  The limiting value <math|\<rho\><around|(|0|)>> of the early exercise
  boundary at expiry <math|\<tau\>=0> (i.e. <math|t=T>) for the continuous
  arithmetic average type of an Asian option has been derived by Dai and Kwok
  <cite|MD-YKK-2006>. For the geometric average it has been discovered by Wu
  in <cite|LW-YKK-HY-1999> (see also Detemple <cite-detail|JD-2006|p. 69>).
  For arithmetic weighted averaged floating strike call option it has been
  derived by Bokes and evovi in <cite|sevcovicEarly>. The value
  <math|\<rho\><around|(|0|)>> is given by:

  <\equation>
    \<rho\><around|(|0|)>=<around*|{|<tabular*|<tformat|<table|<row|<cell|\<rho\><rsup|a><around|(|0|)>=max
    <around*|{|<frac|1+r*T|1+q*T>,1|}>,<htab|0pt>>|<cell|<text|arithmetic
    averaging>,<htab|0pt>>>|<row|<cell|>|<cell|>>|<row|<cell|\<rho\><rsup|w*a><around|(|0|)>=max
    <around*|{|<frac|\<lambda\>+r*<around|(|1-e<rsup|-\<lambda\>*T>|)>|\<lambda\>+q*<around|(|1-e<rsup|-\<lambda\>*T>|)>>,1|}>,<htab|0pt>>|<cell|<text|weighted
    arith. averaging>,>>|<row|<cell|>|<cell|>>|<row|<cell|\<rho\><rsup|g><around|(|0|)>=max
    <around*|{|<wide|x|~>,1|}>,<htab|0pt>>|<cell|<text|geometric
    averaging>.<htab|0pt>>>>>>|\<nobracket\>><label|expr-ro>
  </equation>

  In the case of geometric averaging, the auxiliary number <math|<wide|x|~>>
  entering the expression of <math|\<rho\><around|(|0|)>> is a unique
  solution to the transcendental equation:

  <\equation>
    <wide|x|~>*q*T-r*T+ln <around|(|<wide|x|~>|)>=0.<label|geomrovnica>
  </equation>

  Next we recall the boundary conditions for a solution <math|\<Pi\>>. Taking
  into account equations (<reference|eq:derivaciaWatboundary>) we end up with
  the Dirichlet boundary conditions:

  <align|<tformat|<table|<row|<cell|\<Pi\><around|(|0,\<tau\>|)>>|<cell|=-1,>|<cell|\<Pi\><around|(|\<infty\>,\<tau\>|)>>|<cell|=0.>>>>>

  Since <math|<frac|\<partial\>*\<Pi\>|\<partial\>*\<xi\>>=x<rsup|2>*<frac|\<partial\><rsup|2>*W|\<partial\>*x<rsup|2>>>
  and <math|<frac|\<partial\>*W|\<partial\>*x><around|(|\<rho\><around|(|\<tau\>|)>,\<tau\>|)>=1>
  we obtain <math|<frac|\<partial\>*W|\<partial\>*\<tau\>><around|(|\<rho\><around|(|\<tau\>|)>,\<tau\>|)>=0>
  at <math|x=\<rho\><around|(|\<tau\>|)>>. In the limit
  <math|x\<to\>\<rho\><around|(|\<tau\>|)>>, assuming the <math|C<rsup|2>>
  continuity of <math|\<Pi\><around|(|\<xi\>,\<tau\>|)>> up to the boundary
  <math|\<xi\>=0>, we obtain

  <\equation*>
    x<rsup|2>*<frac|\<partial\><rsup|2>*W|\<partial\>*x<rsup|2>><around|(|x,\<tau\>|)>\<to\><frac|\<partial\>*\<Pi\>|\<partial\>*\<xi\>><around|(|0,\<tau\>|)>,<space|2em>x*<frac|\<partial\>*W|\<partial\>*x>\<to\>\<rho\><around|(|\<tau\>|)>.
  </equation*>

  Passing to the limit <math|x\<to\>\<rho\><around|(|\<tau\>|)>> in equation
  (<reference|PDR:azijskeRegukovana>) we obtain the following algebraic
  constraint between <math|\<rho\><around|(|\<tau\>|)>> and the solution
  <math|\<Pi\><around|(|\<xi\>,\<tau\>|)>>:

  <\equation*>
    -<around|(|r-q|)>*\<rho\><around|(|\<tau\>|)>-<frac|\<sigma\><rsup|2>|2>*<frac|\<partial\>*\<Pi\>|\<partial\>*\<xi\>><around|(|0,\<tau\>|)>+r*<around|(|\<rho\><around|(|\<tau\>|)>-1|)>+f*<around|(|\<rho\><around|(|\<tau\>|)>,T-\<tau\>|)>=0.
  </equation*>

  Therefore we obtain the following algebraic constraint equation between the
  free boundary position <math|\<rho\><around|(|\<tau\>|)>> and the partial
  derivative <math|\<partial\><rsub|\<xi\>>*\<Pi\><around|(|0,\<tau\>|)>>:

  <\equation>
    q*\<rho\><around|(|\<tau\>|)>-r-<frac|\<sigma\><rsup|2>|2>*<frac|\<partial\>*\<Pi\>|\<partial\>*\<xi\>><around|(|0,\<tau\>|)>+f*<around|(|\<rho\><around|(|\<tau\>|)>,T-\<tau\>|)>=0.<label|eq:rovnicaPomocnaIII>
  </equation>

  Notice, that this expression contains term
  <math|<frac|\<partial\>*\<Pi\>|\<partial\>*\<xi\>><around|(|0,\<tau\>|)>>
  and therefore this is not suitable for numerical scheme, because the whole
  solution is sensitive of this term. Bokes and evovi <cite|sevcovicEarly>
  suggested an equivalent form of (<reference|eq:rovnicaPomocnaIII>). They
  integrated equation (<reference|finalnaPDR>) with respect to
  <math|\<xi\>\<in\><around|(|0,\<infty\>|)>>. Taking into account boundary
  conditions for <math|\<Pi\><around|(|\<xi\>,\<tau\>|)>> and
  <math|<frac|\<partial\>*\<Pi\>|\<partial\>*\<xi\>><around|(|\<infty\>,\<tau\>|)>=0>
  and using equality (<reference|eq:rovnicaPomocnaIII>) they derived an ODE
  replacing the algebraic constraint between the free boundary position
  <math|\<varrho\><around|(|\<tau\>|)>> and
  <math|<frac|\<partial\>*\<Pi\>|\<partial\>*\<xi\>><around|(|0,\<tau\>|)>>
  of the solution <math|\<Pi\>>. It has the form:

  <eqnarray|<tformat|<table|<row|<cell|0>|<cell|=>|<cell|<frac|d|d*\<tau\>>*<around*|(|ln
  \<rho\><around|(|\<tau\>|)>+<big|int><rsub|0><rsup|\<infty\>>\<Pi\><around|(|\<xi\>,\<tau\>|)>*d*\<xi\>|)>+q*\<rho\><around|(|\<tau\>|)>-q-<frac|\<sigma\><rsup|2>|2><eq-number><label|eq:integralnyconstrain>>>|<row|<cell|>|<cell|>|<cell|+<big|int><rsub|0><rsup|\<infty\>><around|(|r-f*<around|(|\<rho\><around|(|\<tau\>|)>*e<rsup|-\<xi\>>,T-\<tau\>|)>|)>*\<Pi\><around|(|\<xi\>,\<tau\>|)>*d*\<xi\>.>>>>>

  <\remark>
    Denote by <math|x<rsup|a>=<around|(|1+r*T|)>/<around|(|1+q*T|)>>. Then
    <math|x<rsup|a>*q*T-r*T+ln <around|(|x<rsup|a>|)>\<less\>x<rsup|a>*q*T-r*T+x<rsup|a>-1=0>
    provided that <math|r\<neq\>q>. Since the function
    <math|x\<mapsto\>x*q*T-r*T+ln <around|(|x|)>> is increasing we have
    <math|x<rsup|a>\<less\><wide|x|~>> and consequently
    <math|\<rho\><rsup|a><around|(|0|)>\<less\>\<rho\><rsup|g><around|(|0|)>>.
    Similarly, for any <math|\<lambda\>\<gtr\>0> we have
    <math|\<rho\><rsup|w*a><around|(|0|)>\<less\>\<rho\><rsup|a><around|(|0|)>>.
    In summary, we derived the following inequalities for the initial values
    of the early exercise boundary

    <\equation>
      \<rho\><rsup|w*a><around|(|0|)>\<less\>\<rho\><rsup|a><around|(|0|)>\<less\>\<rho\><rsup|g><around|(|0|)>,<space|1em><text|if>r\<neq\>q.<label|nerovnosti>
    </equation>

    Clearly, <math|\<rho\><rsup|w*a><around|(|0|)>=\<rho\><rsup|a><around|(|0|)>=\<rho\><rsup|g><around|(|0|)>=1>
    in the case <math|r=q>.
  </remark>

  <\remark>
    The solution <math|W=W<around|(|x,\<tau\>|)>> can be easily calculated
    from the solution <math|\<Pi\>> and the free boundary position
    <math|\<rho\>>. With regard to (<reference|transform>) we obtain:

    <\equation*>
      <frac|\<partial\>|\<partial\>*x>*<around*|(|x<rsup|-1>*W<around|(|x,\<tau\>|)>|)>=-x<rsup|-2>*\<Pi\><around*|(|ln
      <around*|(|\<rho\><around|(|\<tau\>|)>/x|)>,<space|0.17em>\<tau\>|)>.
    </equation*>

    Taking into account the boundary condition
    <math|W<around|(|x,\<tau\>|)>=x-1> at
    <math|x=\<rho\><around|(|\<tau\>|)>> and integrating the above equation
    from <math|x> to <math|\<rho\><around|(|\<tau\>|)>>, we obtain

    <\equation*>
      W<around|(|x,\<tau\>|)>=<frac|x|\<rho\><around|(|\<tau\>|)>>*<around*|(|\<rho\><around|(|\<tau\>|)>-1+<big|int><rsub|0><rsup|ln
      <frac|\<rho\><around|(|\<tau\>|)>|x>><math-up|e><rsup|\<xi\>><space|0.17em>\<Pi\><around|(|\<xi\>,\<tau\>|)>*<space|0.17em>d*\<xi\>|)>.
    </equation*>

    Then the option price can be calculated from equality
    <math|V<around|(|S,A,t|)>=A*W*<around|(|S/A,T-t|)>>.
  </remark>

  <section|Numerical algorithm>

  In this section, we make use of the numerical algorithm proposed by Bokes
  and evovi in <cite|sevcovicEarly|sevcovic:nova> for calculating of the
  early exercise boundary position <math|\<rho\>>. We notice that the
  original algorithm was derived for arithmetic averaged floating strike
  Asian call option. In this paper, we generalize it for the case of
  geometric and exponentially weighted averaged floating strike options.

  The algorithm is based on a finite difference discretization in space and
  time variables. We restrict the spatial domain to a finite interval
  <math|\<xi\>\<in\><around|(|0,L|)>>, where <math|L\<gg\>1> is sufficiently
  large. For practical purposes, it is sufficient to take
  <math|L\<approx\>3>. Let <math|k=<frac|T|m>\<gtr\>0> is a time
  discretization step and <math|h=<frac|L|n>\<gtr\>0> is a spatial
  discretization step. We denote by <math|\<Pi\><rsup|j>> time discretization
  of <math|\<Pi\><around|(|\<xi\>,\<tau\><rsub|j>|)>> and
  <math|\<rho\><rsup|j>=\<rho\><around|(|\<tau\><rsub|j>|)>>, where
  <math|\<tau\><rsub|j>=j*k>. By <math|\<Pi\><rsub|i><rsup|j>> we denote full
  space-time approximation of the value <math|\<Pi\><around|(|\<xi\><rsub|i>,\<tau\><rsub|j>|)>>.
  Then the Euler backward in time finite difference approximation of
  (<reference|finalnaPDR>) reads as follows:

  <eqnarray*|<tformat|<table|<row|<cell|0>|<cell|=>|<cell|<frac|\<Pi\><rsup|j>-\<Pi\><rsup|j-1>|k>+c<rsup|j>*<frac|\<partial\>*\<Pi\><rsup|j>|\<partial\>*\<xi\>>-<around*|(|<frac|\<sigma\><rsup|2>|2>+f*<around|(|\<rho\><rsup|j>*e<rsup|-\<xi\>>,T-\<tau\>|)>|)>*<frac|\<partial\>*\<Pi\><rsup|j>|\<partial\>*\<xi\>>-<frac|\<sigma\><rsup|2>|2>*<frac|\<partial\><rsup|2>*\<Pi\>|\<partial\>*\<xi\><rsup|2>>>>|<row|<cell|>|<cell|>|<cell|+<around*|[|<around*|\<nobracket\>|r+x*<frac|\<partial\>*f|\<partial\>*x>-f*<around|(|x,T-\<tau\>|)>|\|><rsub|x=\<rho\><rsup|j>*e<rsup|-\<xi\>>>|]>*\<Pi\><rsup|j>,>>>>>

  where <math|c<rsup|j>=c<around|(|\<tau\><rsub|j>|)>> and
  <math|c<around|(|\<tau\>|)>=<frac|d|d*\<tau\>>*ln
  \<rho\><around|(|\<tau\>|)>+r-q>. We prescribe Dirichlet boundary
  conditions at <math|\<xi\>=0> and <math|\<xi\>=L> for the function
  <math|\<Pi\><rsup|j>>. As for the initial condition, we use the vector
  <math|\<Pi\><rsup|0>> where <math|\<Pi\><rsup|0><rsub|i>=\<Pi\><around|(|\<xi\><rsub|i>,0|)>>.
  Following <cite|sevcovicEarly>, we make use of the operator splitting
  method to the above problem by introducing an auxiliary intermediate step
  <math|\<Pi\><rsup|j-<frac|1|2>>> that splits the problem into two parts:

  <\itemize>
    <item>Convective part

    <\equation>
      <frac|\<Pi\><rsup|j-<frac|1|2>>-\<Pi\><rsup|j-1>|k>+c<rsup|j>*<frac|\<partial\>*\<Pi\><rsup|j-<frac|1|2>>|\<partial\>*\<xi\>>=0,<label|eq:convective>
    </equation>

    <item>Diffusive part

    <eqnarray|<tformat|<table|<row|<cell|0>|<cell|=>|<cell|<frac|\<Pi\><rsup|j>-\<Pi\><rsup|j-<frac|1|2>>|k>-<around*|(|<frac|\<sigma\><rsup|2>|2>+f*<around|(|\<rho\><rsup|j>*e<rsup|-\<xi\>>,T-\<tau\>|)>|)>*<frac|\<partial\>*\<Pi\><rsup|j>|\<partial\>*\<xi\>>-<frac|\<sigma\><rsup|2>|2>*<frac|\<partial\><rsup|2>*\<Pi\><rsup|j>|\<partial\>*\<xi\><rsup|2>><eq-number><label|eq:diffusive>>>|<row|<cell|>|<cell|>|<cell|+<around*|[|<around*|\<nobracket\>|r+x*<frac|\<partial\>*f|\<partial\>*x>-f*<around|(|x,T-\<tau\>|)>|\|><rsub|x=\<rho\><rsup|j>*e<rsup|-\<xi\>>>|]>*\<Pi\><rsup|j>.>>>>>
  </itemize>

  A solution <math|\<Pi\><rsup|j-<frac|1|2>>> to equation
  (<reference|eq:convective>) can be approximated by the explicit solution to
  the transport equation

  <\equation*>
    <frac|\<partial\>*<wide|\<Pi\>|~>|\<partial\>*\<tau\>>+c<around|(|\<tau\>|)><frac|\<partial\>*<wide|\<Pi\>|~>|\<partial\>*\<xi\>>=0,
  </equation*>

  for <math|\<xi\>\<gtr\>0> and <math|\<tau\>\<in\><around|(|\<tau\><rsub|j-1>,\<tau\><rsub|j>|]>>
  satisfying the initial condition <math|<wide|\<Pi\>|~><around|(|\<xi\>,\<tau\><rsub|j-1>|)>=\<Pi\><rsup|j-1><around|(|\<xi\>|)>>
  and the boundary condition <math|<wide|\<Pi\>|~><around|(|0,\<tau\>|)>=-1>.
  After some computations (for further details see e.g. Bokes and evovi
  <cite|sevcovicEarly>) we end up with the following solution:

  <\equation>
    \<Pi\><rsub|i><rsup|j-<frac|1|2>><label|eq:operatorT>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|\<Pi\><rsup|j-1><around|(|\<nu\><rsub|i>|)>,>|<cell|<text|if>\<nu\><rsub|i>=\<xi\><rsub|i>+ln
    <frac|\<rho\><rsup|j-1>|\<rho\><rsup|j>>-<around|(|r-q|)>*k\<gtr\>0,>>|<row|<cell|-1,>|<cell|<text|otherwise>.>>>>>|\<nobracket\>>
  </equation>

  In order to derive full space\Utime discretization scheme we make use of
  the central finite difference approximation of equation
  (<reference|eq:diffusive>). We obtain

  <eqnarray|<tformat|<table|<row|<cell|0>|<cell|=>|<cell|<frac|\<Pi\><rsub|i><rsup|j>-\<Pi\><rsub|i><rsup|j-<frac|1|2>>|k>+<around*|[|<around*|\<nobracket\>|r+x*<frac|\<partial\>*f|\<partial\>*x>-f*<around|(|x,T-\<tau\>|)>|\|><rsub|x=\<rho\><rsup|j>*e<rsup|-\<xi\><rsub|i>>>|]>*\<Pi\><rsub|i><rsup|j>>>|<row|<cell|>|<cell|>|<cell|-<around*|(|<frac|\<sigma\><rsup|2>|2>+f*<around|(|\<rho\><rsup|j>*e<rsup|-\<xi\><rsub|i>>,T-\<tau\>|)>|)>*<frac|\<Pi\><rsup|j><rsub|i+1>-\<Pi\><rsup|j><rsub|i-1>|2*h>-<frac|\<sigma\><rsup|2>|2>*<frac|\<Pi\><rsup|j><rsub|i+1>-2*\<Pi\><rsup|j><rsub|i>+\<Pi\><rsup|j><rsub|i-1>|h<rsup|2>>.<eq-number>>>|<row|<cell|>|<cell|>|<cell|<eq-number>>>>>>

  Hence the vector <math|\<Pi\><rsup|j>> is a solution of a tridiagonal
  system of linear equations

  <\equation>
    <label|eq:operatorA>\<alpha\><rsub|i><rsup|j>*\<Pi\><rsup|j><rsub|i-1>+\<beta\><rsub|i><rsup|j>*\<Pi\><rsub|i><rsup|j>+\<gamma\><rsub|i><rsup|j>*\<Pi\><rsup|j><rsub|i+1>=\<Pi\><rsub|i><rsup|j-<frac|1|2>>,
  </equation>

  for <math|i=1,2,\<ldots\>,n>, where

  <eqnarray|<tformat|<table|<row|<cell|\<alpha\><rsup|j><rsub|i><around|(|\<rho\><rsup|j>|)>>|<cell|=>|<cell|-<frac|k|2*h<rsup|2>>*\<sigma\><rsup|2>+<frac|k|2*h>*<around*|(|<frac|\<sigma\><rsup|2>|2>+f*<around|(|\<rho\><rsup|j>*e<rsup|-\<xi\><rsub|i>>,T-\<tau\><rsub|j>|)>|)>,>>|<row|<cell|\<beta\><rsup|j><rsub|i><around|(|\<rho\><rsup|j>|)>>|<cell|=>|<cell|1+b*<around|(|\<xi\><rsub|i>,T-\<tau\><rsub|j>|)>*k-<around|(|\<alpha\><rsub|i><rsup|j>+\<gamma\><rsub|i><rsup|j>|)>,>>|<row|<cell|\<gamma\><rsup|j><rsub|i><around|(|\<rho\><rsup|j>|)>>|<cell|=>|<cell|-<frac|k|2*h<rsup|2>>*\<sigma\><rsup|2>-<frac|k|2*h>*<around*|(|<frac|\<sigma\><rsup|2>|2>+f*<around|(|\<rho\><rsup|j>*e<rsup|-\<xi\><rsub|i>>,T-\<tau\><rsub|j>|)>|)>.>>>>>

  Boundary conditions for <math|\<Pi\><rsup|j>> are given by:
  <math|\<Pi\><rsub|0><rsup|j>=-1,\<Pi\><rsub|n><rsup|j>=0>, for
  <math|j=1,2,\<ldots\>,m>. The initial condition for <math|\<Pi\><rsup|0>>
  is given by equations (<reference|eq:initialCondition>) and
  (<reference|expr-ro>). In order to determine the free boundary position we
  take equation (<reference|eq:integralnyconstrain>) into account. Applying
  the forward finite difference approximation we obtain

  <eqnarray|<tformat|<table|<row|<cell|ln \<rho\><rsup|j>>|<cell|=>|<cell|ln
  \<rho\><rsup|j-1>+<big|int><rsub|0><rsup|\<infty\>>\<Pi\><rsup|j-1><around|(|\<xi\>|)>*d*\<xi\>-<big|int><rsub|0><rsup|\<infty\>>\<Pi\><rsup|j><around|(|\<xi\>|)>*d*\<xi\><eq-number><label|eq:operatorF>>>|<row|<cell|>|<cell|>|<cell|+k*<around*|(|q+<frac|\<sigma\><rsup|2>|2>-q*\<rho\><rsup|j-1>-<big|int><rsub|0><rsup|\<infty\>><around*|(|r-f*<around|(|\<rho\><rsup|j-1>*e<rsup|-\<xi\>>,T-\<tau\><rsub|j>|)>|)>*\<Pi\><rsup|j><around|(|\<xi\>|)>*d*\<xi\>|)>.>>>>>

  As for the approximation of the integral
  <math|<big|int><rsub|0><rsup|\<infty\>>\<Pi\><rsup|j><around|(|\<xi\>|)>*d*\<xi\>>,
  we use the trapezoid quadrature method. If we rewrite equations into the
  operator form then we obtain the following system of nonlinear algebraic
  equation for the unknown vector <math|\<Pi\><rsup|j>> and the free boundary
  position <math|\<rho\><rsup|j>> at the time <math|\<tau\><rsub|j>>:

  <\equation>
    \<rho\><rsup|j>=\<cal-F\><around|(|\<Pi\><rsup|j>|)>,<space|1em>\<Pi\><rsup|j-<frac|1|2>>=\<cal-T\><around|(|\<rho\><rsup|j>|)>,<space|1em>\<cal-A\><around|(|\<rho\><rsup|j>|)>*\<Pi\><rsup|j>=\<Pi\><rsup|j-<frac|1|2>>,<label|eq:operators>
  </equation>

  where <math|\<cal-T\><around|(|\<rho\><rsup|j>|)>> is a solution of the
  transport equation given by (<reference|eq:operatorT>),
  <math|\<cal-A\><around|(|\<rho\><rsup|j>|)>> is a tridiagonal matrix given
  by (<reference|eq:operatorA>) and <math|ln
  \<cal-F\><around|(|\<Pi\><rsup|j>|)>> is right side of equation
  (<reference|eq:operatorF>). System of equations (<reference|eq:operators>)
  can be effectively solved by means of successive iterations procedure. For
  <math|j\<geq\>1>, we set <math|\<Pi\><rsup|j,0>=\<Pi\><rsup|j-1>> and
  <math|\<rho\><rsup|j,0>=\<rho\><rsup|j-1>>. Then <math|<around|(|p+1|)>>-th
  approximation of <math|\<Pi\><rsup|j>> and <math|\<rho\><rsup|j>> is a
  solution of following system:

  <eqnarray|<tformat|<table|<row|<cell|\<rho\><rsup|j,p+1>>|<cell|=>|<cell|\<cal-F\><around|(|\<Pi\><rsup|j,p>|)>,<eq-number><label|eq:1>>>|<row|<cell|\<Pi\><rsup|j-<frac|1|2>,p+1>>|<cell|=>|<cell|\<cal-T\><around|(|\<rho\><rsup|j,p+1>|)>,<eq-number><label|eq:2>>>|<row|<cell|\<cal-A\><around|(|\<rho\><rsup|j,p+1>|)>*\<Pi\><rsup|j,p+1>>|<cell|=>|<cell|\<Pi\><rsup|j-<frac|1|2>,p+1>.<eq-number><label|eq:3>>>>>>

  We repeat the above iteration procedure for <math|p=1,...,p<rsub|m*a*x>>
  until the prescribed tolerance <math|<around|\||\<rho\><rsup|j,p+1>-\<rho\><rsup|j,p>|\|>\<less\>t*o*l*l>
  is achieved (see Table<nbsp><reference|flowchart>).

  <\big-figure>
    <\Ovalbox>
      <\vbox>
        <vglue>3truemm

        <tabbing|<textbf>|Input model parameters:
        <math|q\<geq\>0,r,\<sigma\>,T\<gtr\>0,\<lambda\>\<gtr\>0>,<next-line><with|font-series|bold|Input
        numerical parameters:> <math|n,m,L,p<rsub|m*a*x>,t*o*l*l><next-line><nbsp>
        <space|1cm> <math|<wide|<text|~>|\<bar\>>> <space|1cm>
        <math|<wide|<text|~>|\<bar\>>> <space|1cm>
        <math|<wide|<text|~>|\<bar\>>> <space|1cm>
        <math|<wide|<text|<kill>>|\<bar\>>><with|font-series|bold|Initialization:><next-line><\>>
        <math|k=T/m><next-line><\>> <math|h=L/n><next-line><\>>
        <math|\<rho\><rsup|0>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|max
        <around|{|<frac|1+r*T|1+q*T>,1|}>,>|<cell|<text|// arith. avg.,
        >>>|<row|<cell|max <around*|{|<wide|x|~>,1|}>,>|<cell|<text|// geom.
        avg., >>>|<row|<cell|max <around|{|<frac|\<lambda\>+r*<around|(|1-e<rsup|-\<lambda\>*T>|)>|\<lambda\>+q*<around|(|1-e<rsup|-\<lambda\>*T>|)>>,1|}>,>|<cell|<text|//
        weighted arith. avg., >>>>>>|\<nobracket\>>><next-line><\>>
        <math|\<Pi\><rsup|0>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|-1,>|<cell|\<xi\>\<less\>ln
        \<rho\><rsup|0>,>>|<row|<cell|0,>|<cell|\<xi\>\<gtr\>ln
        \<rho\><rsup|0>,>>>>>|\<nobracket\>>><next-line><with|font-series|bold|for>
        <math|j=1> <with|font-series|bold|to> <math|m>:
        <math|<space|1em>><next-line><\>>
        <math|\<Pi\><rsup|j><rsub|0>=\<Pi\><rsup|j-1>><next-line><\>>
        <math|\<rho\><rsup|j><rsub|0>=\<rho\><rsup|j-1>><next-line><\>>
        <with|font-series|bold|for> <math|p=0> <with|font-series|bold|to>
        <math|p<rsub|m*a*x>>: <math|<space|1em>><next-line><\>> <\>>
        <math|\<rho\><rsup|j,p+1>=\<cal-F\><around|(|\<Pi\><rsup|j,p>|)>><next-line><\>>
        <\>> <math|\<Pi\><rsup|j-<frac|1|2>,p+1>=\<cal-T\><around|(|\<rho\><rsup|j,p+1>|)>><next-line><\>>
        <\>> <with|font-series|bold|Solve:>
        <math|\<cal-A\><around|(|\<rho\><rsup|j,p+1>|)>*\<Pi\><rsup|j,p+1>=\<Pi\><rsup|j-<frac|1|2>,p+1>>
        for <math|\<Pi\><rsup|j,p+1>><next-line><\>> <\>>
        <with|font-series|bold|if> (<math|<around|\||\<rho\><rsup|j,p+1>-\<rho\><rsup|j,p>|\|>\<less\>t*o*l*l>)<next-line><\>>
        <\>> <\>> <with|font-series|bold|break><next-line><\>> <\>>
        <with|font-series|bold|endif><next-line><\>>
        <with|font-series|bold|end><next-line><with|font-series|bold|end>>

        <vglue>3truemm
      </vbox>
    </Ovalbox>

    <label|flowchart>
  </big-figure|A flowchart of the numerical algorithm. Input model
  parameters: <math|r> is the interest rate, <math|q> is the dividend yield,
  <math|T> expiration time, <math|n> is the number of spatial grid points,
  <math|m> is the time step, <math|L=3>, <math|\<lambda\>> is the weight
  parameter.>

  <section|Numerical results>

  The aim of this section is to present various computational examples of
  calculation of the early exercise boundary position <math|\<rho\>> for
  varying model parameters and averaging methods. In all examples discussed
  in this section we use the following numerical parameters: <math|m=10000>,
  <math|n=300>, <math|L=3>, <math|p<rsub|max>=500>,
  <math|t*o*l*l=10<rsup|-8>>. In graphical plots we display the position of
  the early exercise <math|\<rho\>> only.

  <subsection|Free boundary for floating strike call options>

  <subsubsection|Arithmetic averaged floating strike call options>

  In Figure <reference|fig:sevcoviccompare> we compare the free boundary
  position <math|\<rho\>> for various interest rates <math|r=0.02,0.04,0.06>.
  Other model parameters are: <math|T=50,\<sigma\>=0.2,q=0.04>. We also
  compare the free boundary position computed by the algorithm described in
  Section 3 (blue line) and computational results obtained by Dai and Kwok in
  <cite|MD-YKK-2006> (red dots).

  <big-figure|<with|par-mode|center|<image|images/sevcoviccompare|10truecm|||><label|fig:sevcoviccompare>>|A
  comparison position of the free boundary position for various
  <math|r=0.02,0.04,0.06>. We also compare our results with the method due to
  Dai and Kwok <cite|MD-YKK-2006>.>

  In Figure <reference|fig:p> we show the number of maximal inner iteration
  steps <math|p<rsub|m*a*x>> needed for achievement of the desired tolerance
  <math|0\<less\>t*o*l*l\<ll\>1>. We can observe that the algorithm requires
  considerably more inner iteration steps for small times
  <math|0\<less\>\<tau\>\<ll\>1> for which the time derivative of
  <math|\<rho\><around|(|\<tau\>|)>> is large. As for the model parameters we
  chose: <math|T=50,\<sigma\>=0.2,q=0.04,r=0.06>.

  <big-figure|<with|par-mode|center|<image|images/errors|8truecm|||><label|fig:p>>|A
  number of the inner-loop iteration in the algorithm needed to achieve
  prescribed tolerance.>

  <\big-figure>
    <\with|par-mode|center>
      <image|images/sigma|10truecm|||> <image|images/malesigma|10truecm|||>

      <label|fig:sigmaCompare>
    </with>
  </big-figure|A comparison of the free boundary position <math|\<rho\>> for
  large (top) and small (bottom) values of the volatility parameter
  <math|\<sigma\>>.>

  In Figure <reference|fig:sigmaCompare> we plot
  <math|\<rho\><around|(|\<tau\>|)>> for different values of the volatility
  parameter <math|\<sigma\>>. Other parameters are:
  <math|T=50,r=0.06,q=0.04>. It is worthwile noting that, for
  <math|\<sigma\>\<to\>0>, the underlying stochastic process for
  <math|S<rsub|t>> becomes deterministic. The option price at the time
  <math|t> can be therefore calculated as:
  <math|S<rsub|t>=S<rsub|0>*e<rsup|<around|(|r-q|)>*t>>. Its arithmetic
  average is given by <math|A<rsub|t>=<frac|1|t>*S<rsub|0>*<frac|e<rsup|<around|(|r-q|)>*t>-1|r-q>>.
  In the case of <math|q\<gtr\>r> we have <math|S<rsub|t>\<less\>A<rsub|t>>
  for all <math|t\<gtr\>0>. Therefore the corresponding option price is equal
  to zero because it is not worth to exercise it for any
  <math|0\<le\>t\<le\>T>. In the case <math|r=q>, both
  <math|S<rsub|t>=A<rsub|t>>. Hence <math|\<rho\><around|(|t|)>\<equiv\>1>.
  Finally, in the case <math|r\<gtr\>q> we obtain
  <math|S<rsub|t>\<gtr\>A<rsub|t>>, for all <math|t\<gtr\>0>. Since we are
  dealing with American style of options we exercise the option at the time
  <math|t<rsup|\<ast\>>=arg max<rsub|t\<in\><around|[|0,T|]>>
  e<rsup|-r*<around|(|T-t|)>>*<around|(|S<rsub|t>-A<rsub|t>|)>>. Denote by
  <math|\<Psi\><around|(|t|)>=<frac|S<rsub|t>-A<rsub|t>|S<rsub|0>>>. Then
  <math|t<rsup|\<ast\>>=arg max<rsub|t\<in\><around|[|0,T|]>>
  S<rsub|0>*e<rsup|-r*T>*e<rsup|r*t>*\<Psi\><around|(|t|)>>. Now it is easy
  to verify that

  <\equation*>
    <frac|d*\<Psi\><around|(|t|)>|d*t>=<big|sum><rsub|n=0><rsup|\<infty\>><frac|n+1|<around|(|n+2|)>*n!>*<around|(|r-q|)><rsup|n+1>*t<rsup|n>\<gtr\>0,<space|1em><text|for
    all>t\<gtr\>0.
  </equation*>

  Hence <math|\<Psi\><around|(|t|)>> is an increasing function. As both
  <math|\<Psi\><around|(|t|)>> and <math|e<rsup|r*t>> we conclude that
  <math|t<rsup|\<ast\>>=T>.

  In the case of an arithmetic averaged Asian call option we obtain from
  (<reference|eq:rovnicaPomocnaIII>) the following explicit expression for
  the free boundary position:

  <\equation>
    \<rho\><around|(|\<tau\>|)>=max <around*|{|1,<frac|1+r*<around|(|T-\<tau\>|)>|1+q*<around|(|T-\<tau\>|)>>|}>,<space|1em><text|for>\<sigma\>=0.<label|eq:sigma0>
  </equation>

  <subsubsection|Geometric averaged floating strike call option>

  In Figure <reference|fig:aritmgeom> we compare the free boundary position
  <math|\<rho\>> computed for the case of arithmetic and geometric averaging.
  Model parameters were chosen as: <math|T=50,\<sigma\>=0.2,q=0.04,r=0.06>.
  Notice that <math|\<rho\><rsup|a><around|(|\<tau\>|)>\<less\>\<rho\><rsup|g><around|(|\<tau\>|)>>
  for all <math|\<tau\>\<in\><around|[|0,T|]>>.

  <big-figure|<with|par-mode|center|<image|images/aritmgeom|10truecm|||><label|fig:aritmgeom>>|A
  comparison of the free boundary position for arithmetic and geometric
  averaging methods.>

  <subsubsection|Weighted arithmetic averaged floating strike call option>

  In Figure <reference|fig:lambdaCompare> we plot the free boundary position
  <math|\<rho\>> for various weight parameters
  <math|\<lambda\>=0.001,0.1,0.2,0.5,1>.

  <big-figure|<with|par-mode|center|<image|images/lambda|4in|||><label|fig:lambdaCompare>>|A
  comparison of the free boundary position for exponentially weighted
  arithmetic averaged Asian options for various weight parameters
  <math|\<lambda\>\<gtr\>0>. >

  It is easy to verify that <math|<with|math-display|true|lim<rsub|\<lambda\>\<to\>\<infty\>>
  A<rsub|t><rsup|\<lambda\>>=S<rsub|t>>>. As a consequence we deduce that the
  option price is equal to zero. This is also reason for the limit
  <math|lim<rsub|\<lambda\>\<to\>\<infty\>> \<rho\><rsub|\<lambda\>>=1>. In
  what follows, we will estimate rate of convergence of
  <math|\<rho\><rsub|\<lambda\>>\<to\>1> using the so-called experimental
  order of convergence. Assuming that

  <\equation*>
    <around|\<\|\|\>|\<rho\><rsub|\<lambda\>>-\<rho\><rsub|\<infty\>>|\<\|\|\>><rsub|\<infty\>>\<equiv\>max<rsub|0\<le\>\<tau\>\<le\>T><around|\||\<rho\><rsub|\<lambda\>><around|(|\<tau\>|)>-\<rho\><rsub|\<infty\>><around|(|\<tau\>|)>|\|>=O<around|(|\<lambda\><rsup|-\<alpha\>>|)>,
  </equation*>

  as <math|\<lambda\>\<to\>\<infty\>>, we can approximate the order parameter
  <math|\<alpha\>> as follows:

  <\equation>
    \<alpha\>\<approx\><frac|ln <around|(|\<lambda\><rsub|2>|)>-ln
    <around|(|\<lambda\><rsub|1>|)>|ln <around|(|<around|\<\|\|\>|\<rho\><rsub|\<lambda\><rsub|1>>-\<rho\><rsub|\<infty\>>|\<\|\|\>><rsub|\<infty\>>|)>-ln
    <around|(|<around|\<\|\|\>|\<rho\><rsub|\<lambda\><rsub|2>>-\<rho\><rsub|\<infty\>>|\<\|\|\>><rsub|\<infty\>>|)>>,
  </equation>

  where <math|\<lambda\><rsub|1>\<less\>\<lambda\><rsub|2>>. The results
  shown in Table <reference|tab:eoc> indicate <math|\<alpha\>\<approx\>1/3>.
  It means that it might be reasonable to conjecture that

  <\equation*>
    <around|\<\|\|\>|\<rho\><rsub|\<lambda\>>-\<rho\><rsub|\<infty\>>|\<\|\|\>><rsub|\<infty\>>=O<around|(|\<lambda\><rsup|-1/3>|)>,<space|1em><text|as>\<lambda\>\<to\>\<infty\>.
  </equation*>

  <\big-table>
    <\with|par-mode|center>
      \;

      <with|font-size|0.84|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-bborder|2ln>|<cwith|10|10|1|-1|cell-bborder|1ln>|<table|<row|<cell|<math|\<lambda\>>>|<cell|<math|<around|\<\|\|\>|\<rho\><rsub|\<lambda\>>-\<rho\><rsub|\<infty\>>|\<\|\|\>><rsub|\<infty\>>>>|<cell|<math|\<alpha\>>>>|<row|<cell|0.2>|<cell|0.561828>|<cell|-->>|<row|<cell|0.5>|<cell|0.413783>|<cell|0.333>>|<row|<cell|1.0>|<cell|0.320136>|<cell|0.370>>|<row|<cell|2.0>|<cell|0.247010>|<cell|0.374>>|<row|<cell|3.0>|<cell|0.212705>|<cell|0.368>>|<row|<cell|4.0>|<cell|0.191862>|<cell|0.358>>|<row|<cell|5.0>|<cell|0.177658>|<cell|0.344>>|<row|<cell|10.0>|<cell|0.147227>|<cell|0.271>>|<row|<cell|20.0>|<cell|0.113350>|<cell|0.377>>>>>>

      <label|tab:eoc>
    </with>
  </big-table|Experimental order of convergence <math|\<alpha\>> for the
  difference <math|<around|\<\|\|\>|\<rho\><rsub|\<lambda\>>-\<rho\><rsub|\<infty\>>|\<\|\|\>><rsub|\<infty\>>=O<around|(|\<lambda\><rsup|-\<alpha\>>|)>>
  as <math|\<lambda\>\<to\>\<infty\>>. >

  <subsection|Comparison of the early exercise boundary position for various
  averaging methods.>

  In Remark 1 we pointed out that <math|\<rho\><rsup|w*a><around|(|0|)>\<less\>\<rho\><rsup|a><around|(|0|)>\<less\>\<rho\><rsup|g><around|(|0|)>>
  if <math|r\<neq\>q> and <math|\<rho\><rsup|w*a><around|(|0|)>=\<rho\><rsup|a><around|(|0|)>=\<rho\><rsup|g><around|(|0|)>=1>
  in the case <math|r=q>, where <math|\<rho\><rsup|a>,\<rho\><rsup|g>,\<rho\><rsup|w*a>>
  are the free boundary position for arithmetic, geometric and weighted
  arithmetic averaged Asian call options, respectively (see
  (<reference|nerovnosti>)). This relation has been rigorously derived for
  <math|\<tau\>=0> only. However, it follows from results depicted in Figures
  <reference|fig:aritmgeom> and <reference|fig:lambdaCompare> that it might
  be plausible to state the following conjecture on the comparison of early
  exercise boundaries for various averaging methods:

  <\conjecture>
    Let <math|\<rho\><rsup|a>,\<rho\><rsup|g>,\<rho\><rsup|w*a>> be the free
    boundary positions for arithmetic, geometric and exponentially weighted
    arithmetic averaged Asian call options. Then for any
    <math|0\<less\>\<tau\>\<le\>T> it holds:

    <\equation*>
      \<rho\><rsup|w*a><around|(|\<tau\>|)>\<less\>\<rho\><rsup|a><around|(|\<tau\>|)>\<less\>\<rho\><rsup|g><around|(|\<tau\>|)>.
    </equation*>
  </conjecture>

  The rigorous proof of this conjecture based on the analysis of the
  governing equation (<reference|finalnaPDR>) with constraint
  (<reference|eq:rovnicaPomocnaIII>) remains an open problem.

  <subsection|Initial early exercise boundary position>

  In this section, we investigate the initial early exercise boundary
  position <math|x<rsub|f><around|(|0|)>> at <math|t=0>. It corresponds to
  the value <math|\<varrho\><around|(|T|)>=x<rsub|f><around|(|0|)>> at
  <math|\<tau\>=T>.

  Let us denote by <math|\<rho\><around|(|\<tau\>|)>=\<rho\><around|(|\<tau\>;r,q,\<sigma\>,T|)>>
  the free boundary position as a function of
  <math|\<tau\>\<in\><around|[|0,T|]>> and remaining model parameters, i.e.
  <math|r,q,\<sigma\>,T>. Using obvious scaling properties of the governing
  equation (<reference|finalnaPDR>) and the algebraic constraint
  (<reference|eq:rovnicaPomocnaIII>) we can conclude that for arithmetic,
  geometric or weighted arithmetic average the following scaling property
  holds true:

  <\equation*>
    \<rho\><around|(|\<tau\>;r,q,\<sigma\>,T|)>=\<rho\>*<around*|(|<frac|\<tau\>|T>;T*r,T*q,<sqrt|T>*\<sigma\>,1|)>.
  </equation*>

  With regard to the previous argument, it is therefore sufficient to study
  dependence of <math|\<rho\><around|(|T|)>> on <math|r,q,\<sigma\>> for
  arbitrary but fixed value of the parameter <math|T>. In Figure
  <reference|fig:dependence> (top) we plot dependence of
  <math|\<rho\><around|(|T;r,q,\<sigma\>,T|)>> on
  <math|r\<in\><around|(|0.005,0.1|)>> for <math|\<sigma\>=0.2,q=0.04>. In
  Figure <reference|fig:dependence> (middle) we plot dependence of
  <math|\<rho\><around|(|T;r,q,\<sigma\>,T|)>> on
  <math|q\<in\><around|(|0.05,0.1|)>> for <math|\<sigma\>=0.2,r=0.06>.
  Finally, in Figure <reference|fig:dependence> (bottom) we plot dependence
  of <math|\<rho\><around|(|T;r,q,\<sigma\>,T|)>> on
  <math|\<sigma\>\<in\><around|(|0.01,0.4|)>> for <math|r=0.06,q=0.04>. In
  all case we chose <math|T=50>.

  <\big-figure>
    <\with|par-mode|center>
      <image|images/zavislosti_r|12truecm|||>

      <image|images/zavislosti_q|12truecm|||>
      <image|images/zavislosti_sigma|12truecm|||>

      <label|fig:dependence>
    </with>
  </big-figure|Dependence of <math|\<rho\><around|(|T|)>> on the parameter
  <math|r> (top), <math|q> (middle) and <math|\<sigma\>> (bottom).>

  We furthermore proposed and consequently estimated the analytical formula
  for dependence of <math|\<rho\><around|(|T;r,q,\<sigma\>,T|)>> on
  <math|r,q,\<sigma\>,T>. With respect to the scaling property we can fix
  <math|T=50>. Among various nonlinear estimators for the value
  <math|\<rho\><around|(|T;r,q,\<sigma\>,T|)>> on <math|r,q,\<sigma\>,1> the
  best estimation results we achieved with the function

  <\equation*>
    \<varrho\><rsup|a*p*p><around|(|T;r,q,\<sigma\>,T|)>\<equiv\>\<varrho\><rsup|a*p*p>*<around|(|1;T*r,T*q,<sqrt|T>*\<sigma\>,1|)>\<assign\>1+<around*|(|<frac|\<sigma\><rsup|2>|\<beta\><rsub|1>*r+\<beta\><rsub|2>*q>|)><rsup|\<beta\><rsub|3>>+<frac|r|q>*\<beta\><rsub|4>
  </equation*>

  with <math|\<beta\><rsub|1>=-0.15064,\<beta\><rsub|2>=7.74793,\<beta\><rsub|3>=0.79067,\<beta\><rsub|4>=0.09193>
  with <math|R*S*S=8.6723.10<rsup|-4>> where as an error indicator we chose
  the least square minimizer:

  <\equation*>
    R*S*S=<big|sum><rsub|j=1><rsup|M><around|(|\<varrho\><rsup|a*p*p><around|(|T;r<rsub|j>,q<rsub|j>,\<sigma\><rsub|j>,T|)>-\<rho\><rsub|j><around|(|T|)>|)><rsup|2>,
  </equation*>

  where <math|T=50> and parameter samples
  <math|r<rsub|j>,q<rsub|j>,\<sigma\><rsub|j>\<in\><around|[|0.01,0.11|]>\<times\><around|[|0.01,0.11|]>\<times\><around|[|0.2,0.8|]>>
  were generated from <math|M=100> random vectors. We denoted by
  <math|\<rho\><rsub|j><around|(|T|)>> the numerically computed free boundary
  position <math|\<rho\>> at <math|\<tau\>=T> computed for the model
  parameters <math|r=r<rsub|j>,q=q<rsub|j>,\<sigma\>=\<sigma\><rsub|j>> and
  time horizon <math|T>.

  <section*|Acknowledgments>

  The research was supported by ERDF-017/2009/4.1/OPVaV-CESIUK project and
  bilateral Slovak\UBulgarian project APVV SK-BG-0034-08.

  <\thebibliography|99>
    <bibitem|sevcovicEarly>T. Bokes and D. evovi, Early Exercise Boundary
    for American Type of Floating Strike Asian Option and Its Numerical
    Approximation, Applied Mathematical Finance, 2011.

    <bibitem|JC-2008>J.<nbsp>Chadam, Free Boundary Problems in Mathematical
    Finance, in Progress in industrial mathematics at ECMI 2006, vol.<nbsp>12
    of Math. Ind., p.<nbsp>655\U665, Springer, Berlin, 2008.

    <bibitem|MD-YKK-2006>M. Dai and Y. K. Kwok, Characterization of Optimal
    Stopping Regions of American Asian and Lookback Options, Math. Finance
    <with|font-series|bold|16> (1) (2006) 63\U82.

    <bibitem|JD-2006>J.<nbsp>Detemple, American-Style Derivatives: Valuation
    and Computation, Chapman and Hall/CRC, 2006.

    <bibitem|RG-HEJ-1984>R.<nbsp>Geske and H.<nbsp>E. Johnson, The American
    Put Option Valued Analytically, J. Finance, <with|font-series|bold|39>
    (1984) <nbsp>1511\U1524.

    <bibitem|RG-RR-1984>R.<nbsp>Geske and R.<nbsp>Roll, On Valuing American
    Call Options with the Black\UScholes European Formula, J. Finance,
    <with|font-series|bold|89> (1984) <nbsp>443\U455.

    <bibitem|ATH-PLJ-2000>A.<nbsp>T. Hansen and P.<nbsp>L. Jrgensen,
    Analytical Valuation of American-style Asian Options, Management Science,
    <with|font-series|bold|46> (2000) <nbsp>1116\U1136.

    <bibitem|JCH-1997>J.<nbsp>C. Hull, Options, Futures and Other Derivative
    Securities, Prentice Hall, third<nbsp>ed., 1997.

    <bibitem|IK-1988>I.<nbsp>Karatzas, On the Pricing American Options, Appl.
    Math. Optim., <with|font-series|bold|17> (1988) <nbsp>37\U60.

    <bibitem|BCK-YSO-2004>B.<nbsp>C. Kim and S.<nbsp>Y. Oh, Pricing of
    American-style Fixed Strike Asian Options with Continuous Arithmetic
    Average, 2004.

    <bibitem|RAK-JBK-1998>R.<nbsp>A. Kuske and J.<nbsp>B. Keller, Optimal
    Exercise Boundary for an American Put Option, Applied Mathematical
    Finance, <with|font-series|bold|5> (1998) <nbsp>107\U116.

    <bibitem|YKK-2008>Y. K. Kwok, Mathematical Models of Financial
    Derivatives, Springer Finance, Springer, Berlin, second<nbsp>ed., 2008.

    <bibitem|VL-2004>V.<nbsp>Linetsky, Spectral Expansions for Asian (Average
    Price) Options, Operations Research, <with|font-series|bold|52> (2004)
    <nbsp>856\U867.

    <bibitem|RM-2002>R.<nbsp>Mallier, Evaluating Approximations for the
    American Put Option, Journal of Applied Mathematics,
    <with|font-series|bold|2> (2002) <nbsp>71\U92.

    <bibitem|AP-2008>A.<nbsp>Pascucci, Free Boundary and Optimal Stopping
    Problems for American Asian Options, Finance Stoch,
    <with|font-series|bold|12> (2008) <nbsp>21\U41.

    <bibitem|sevcovic:nova>D. evovi, Transformation Methods for Evaluating
    Approximations to the Optimal Exercise Boundary for Linear and Nonlinear
    Black\UScholes Equations, In: M. Ehrhardt (ed.), Nonlinear Models in
    Mathematical Finance: New Research Trends in Option Pricing, p. 153-198,
    Nova Science Publishers, Inc., Hauppauge, 2008.

    <bibitem|PW-SH-JD-1995>P.<nbsp>Wilmott, S.<nbsp>Howison, and
    J.<nbsp>Dewynne, The mathematics of financial derivatives, Cambridge
    University Press, Cambridge, 1995. <newblock>A student introduction.

    <bibitem|LW-YKK-HY-1999>L.<nbsp>Wu, Y.<nbsp>K. Kwok and H.<nbsp>Yu, Asian
    Options with the American Early Exercise Feature, International Journal
    of Theoretical and Applied Finance, <with|font-series|bold|2> (1999)
    <nbsp>101\U111.

    <bibitem|RW-MCF-2003>R.<nbsp>Wu and M.<nbsp>C. Fu, Optimal Exercise
    Policies and Simulation-based Valuation for American-Asian Options,
    Operations Research, <with|font-series|bold|51> (2003) <nbsp>52\U66.

    <bibitem|UW-2006>U.<nbsp>Wystup, FX Options and Structured Products,
    www.mathfinance.com, 2006.
  </thebibliography>
</body>