<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <\hide-preamble>
    <assign|be|<macro|>>

    <assign|ee|<macro|>>

    <assign|bee|<macro|>>

    <assign|ene|<macro|>>

    <assign|bes|<macro|>>

    <assign|ees|<macro|>>

    <assign|br|<macro|<with|font-series|bold|r>>>

    <assign|bv|<macro|<with|font-series|bold|v>>>

    <assign|bn|<macro|<with|font-series|bold|n>>>

    <assign|bk|<macro|<with|font-series|bold|k>>>

    <assign|bq|<macro|<with|font-series|bold|q>>>

    <assign|bc|<macro|<with|font-series|bold|c>>>

    <assign|ba|<macro|<with|font-series|bold|a>>>

    <assign|bB|<macro|<with|font-series|bold|B>>>

    <assign|bb|<macro|<with|font-series|bold|b>>>

    <assign|hpsi|<macro|<wide|\<psi\>|^>>>

    <assign|hphi|<macro|<wide|\<phi\>|^>>>

    <assign|hPsi|<macro|<wide|\<Psi\>|^>>>

    <assign|hPhi|<macro|<wide|\<Phi\>|^>>>

    <assign|vk|<macro|<wide|\<kappa\>|\<vect\>>>>

    <assign|vrho|<macro|<wide|\<rho\>|\<vect\>>>>

    <assign|tOm|<macro|<wide|\<Omega\>|~>>>
  </hide-preamble>

  <doc-data|<doc-title|Financial Rogue Waves Appearing in the Coupled
  Nonlinear<next-line><vspace|0.1in> Volatility and Option Pricing
  Model>|<doc-author|<author-data|<author-name|<vspace|0.2in>
  <with|font-series|bold|Zhenya Yan><footnote|Email address:
  zyyan@mmrc.iss.ac.cn; zyyan_math@yahoo.com.>>|<author-affiliation|<vspace|0.1in>
  Key Laboratory of Mathematics Mechanization, Institute of Systems Science,
  AMSS, Chinese Academy of Sciences, Beijing 100190, China>>>>

  <abstract-data|<\abstract>
    <baselineskip>=18pt

    <vspace|0.2in><with|font-series|bold|Abstract.> The coupled nonlinear
    volatility and option pricing model presented recently by Ivancevic is
    investigated, which generates a leverage effect, i.e., stock volatility
    is (negatively) correlated to stock returns, and can be regarded as a
    coupled nonlinear wave alternative of the Black-Scholes option pricing
    model. In this short report, we analytically propose the two-component
    financial rogue waves of the coupled nonlinear volatility and option
    pricing model without an embedded <math|w->learning. Moreover, we exhibit
    their dynamical behaviors for chosen different parameters. The
    two-component financial rogue wave solutions may be used to describe the
    possible physical mechanisms for the rogue wave phenomena and to further
    excite the possibility of relative researches and potential applications
    of rogue waves in the financial markets and other related
    fields.<next-line>

    <no-indent><with|font-series|bold|Key words:> Black-Scholes option
    pricing model; The coupled nonlinear volatility and option pricing model;
    Adaptive nonlinear Schrdinger equation; Controlled stochastic
    volatility; Financial markets; Financial rogue waves/rogons<next-line>

    <no-indent><with|font-series|bold|PACS numbers:> 89.65.Gh; 05.45.Yv
  </abstract>>

  <vspace|9in>

  <baselineskip>=15pt

  <section|Introduction>

  The use of the term freak wave was first introduced to the scientific
  community by Draper<nbsp><cite|rwd|rgd2>. Freak waves are also called rogue
  waves, giant waves, monster waves, killer waves, extreme waves, abnormal
  waves, huge waves, super waves, or gigantic waves, which are formed due to
  the interaction of the nonlinearity and dispersion in the wave propagation.
  Nowadays, there is no unique definite for the rogue waves, but, a wave
  called a rogue wave means that the wave height <math|H> (i.e., distance
  from trough to crest) or the crest height <math|\<eta\><rsub|c>> (i.e.,
  distance from mean sea level to crest) exceeds a certain threshold related
  to the sea state<nbsp><cite|rgd2>. Generally speaking, the common criteria
  of rogue waves is that <math|H\<gtr\>2*H<rsub|s>> or
  <math|\<eta\><rsub|c>\<gtr\>1.5*H<rsub|s>>, where <math|H<rsub|s>> stands
  for the significant wave height<nbsp><cite|rgd2>.

  Rogue waves, as a special type of solitary waves, have drawn much attention
  in some fields of nonlinear science such as
  oceanics<nbsp><cite|rgd2|RW1|RW2|RW3|RW4|RW5>, nonlinear
  optics<nbsp><cite|ORW|exp1|exp2|ABC1|ABC2|ABC3|BKA|ypla10|ypla102>,
  Bose-Einstein condensations<nbsp><cite|BRW|ypre10>,
  atmospherics<nbsp><cite|arg>, and even finance<nbsp><cite|frg>. The
  first-order rational solution of the self-focusing nonlinear Schrdinger
  (NLS) equation was first found by Peregrine<nbsp><cite|PS> to describe the
  rogue wave phenomenon, which was known as Peregrine soliton (or Peregrine
  breather) and could be regarded as a limiting case of the Ma breather when
  the breathing period approaches to infinity<nbsp><cite|Ma|PST> or of the
  Akhmediev breather as the spatial period tends to
  infinity<nbsp><cite|AK|PST>.

  More recently, multi-rogue wave solutions of the self-focusing NLS equation
  were also found on basis of the deformed Darboux transformation
  in<nbsp><cite|ABC1|ABC2>. Moreover, nonautonomous rogue wave solutions have
  also been found for the generalized NLS equations with variable
  coefficients in one-dimensional space<nbsp><cite|ypla10|ypla102> and in
  three-dimensional spaces<nbsp><cite|ypre10> based on the similarity
  analysis idea. The term `rogue (freak) waves' was called `rogons
  (freakons)' if they reappeared virtually unaffected in size or shape
  shortly after their interactions<nbsp><cite|ypla10>. In nonlinear optics,
  optical rogue waves have been observed in two different experiments, based
  on two nonlinear optical models, i.e., the higher-order NLS
  equation<nbsp><cite|exp1> and the NLS equation<nbsp><cite|exp2>,
  respectively. Moreover, they have verified that optical rogue waves reveal
  an approach to exert maximal control over a nonlinear system with minimal
  effort and can be used to produce highly stable
  supercontinuum<nbsp><cite|exp1>.

  As is well known, the celebrated Black-Scholes (alias as
  Black-Scholes-Merton) option pricing model<nbsp><cite|BS|BS2>

  <eqnarray|<tformat|<table|<row|<cell|<frac|\<partial\>*C<around|(|S,t|)>|\<partial\>*t>+<frac|1|2>*\<sigma\><rsup|2>*S<rsup|2>*<frac|\<partial\><rsup|2>*C<around|(|S,t|)>|\<partial\>*S<rsup|2>>+r*S*<frac|\<partial\>*C<around|(|S,t|)>|\<partial\>*S>-r*C<around|(|S,t|)>=0,<eq-number>>>>>>

  was presented, based on the the geometric Brownian motion (i.e. the
  stochastic differential equation) <math|d*S=\<mu\>*S*d*t+\<sigma\>*d*W<around|(|t|)>>
  satisfied by the stock (asset) price <math|S> and the
  It<math|<wide|<math-up|o>|^>> lemma<nbsp><cite|Ito>, where
  <math|C<around|(|S,t|)>> is the value of European call option on the asset
  price <math|S> at time <math|t>, <math|\<mu\>> is the instantaneous mean
  return, <math|\<sigma\>> is the stock volatility, <math|W> is a Wiener
  process, and <math|r> is the risk-free interest rate. This model has drawn
  much attention and also opens the new area of study in financial
  mathematics or financial engineering. The Black-Scholes model can be widely
  used for valuing the pricing of European-style options, but it cannot be
  used for valuing other exotic types of options such as American Options or
  Asian Options as it cannot incorporate exercise features or any path
  dependencies<nbsp><cite|book1|book2|book3>.

  More recently, based on the modern adaptive markets hypothesis due to
  Lo<nbsp><cite|Lo|Lo2>, Elliott wave market
  theory<nbsp><cite|Elliot|Elliot2>, and quantum neural computation
  approach<nbsp><cite|Ivan>, Ivancevic presented a novel nonlinear option
  pricing model (called the <with|font-shape|italic|Ivancevic option pricing
  model>)<nbsp><cite|Ivan2>

  <eqnarray|<tformat|<table|<row|<cell|i*<frac|\<partial\>*\<psi\><around|(|S,t|)>|\<partial\>*t>=-<frac|1|2>*\<sigma\>*<frac|\<partial\><rsup|2>*\<psi\><around|(|S,t|)>|\<partial\>*S<rsup|2>>-\<beta\><around*|\||\<psi\><around|(|S,t|)>|\|><rsup|2>*\<psi\><around|(|S,t|)>,<space|2em>i=<sqrt|-1><eq-number><label|nls>>>>>>

  in order to satisfy efficient and behavioral markets, and their essential
  nonlinear complexity, where <math|\<psi\><around|(|S,t|)>> denotes the
  <with|font-shape|italic|option-price wave function>, the dispersion
  frequency coefficient <math|\<sigma\>> is the volatility (which can be
  either a constant or stochastic process itself), the Landau coefficient
  <math|\<beta\>=\<beta\><around|(|r,w|)>> represents the adaptive market
  potential. Some periodic wave solutions of Eq. (<reference|nls>) have been
  obtained<nbsp><cite|Ivan2>. Recently, we first presented the two financial
  rogue wave solutions of the Ivancevic option pricing model
  (<reference|nls>) and illustrated their dynamics<nbsp><cite|frg>, which may
  explain real financial crisis/storms (e.g., 1997 Asian financial
  crisis/storm and the current global financial crisis/storm). In addition,
  for the aim of including a controlled stochastic volatility into the
  adaptive Ivancevic option pricing model (<reference|nls>), the adaptive,
  symmetrically coupled, volatility and option pricing model (with interest
  rate <math|r> and Hebbian learning rate <math|c>) has been presented, which
  represents a bidirectional spatio-temporal associative
  memory<nbsp><cite|Ivan2|Ivan3>. In the following, we would like to study
  the financial rogue waves of the coupled nonlinear model.

  <section|The coupled nonlinear volatility and option pricing model>

  By introducing a controlled stochastic volatility into the adaptive-wave
  model (<reference|nls>), Ivancevic also presented the coupled nonlinear
  volatility and option pricing model in the form<nbsp><cite|Ivan2|Ivan3>

  <\subequations>
    <label|nlsc>

    <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|i*<frac|\<partial\>*\<sigma\><around|(|S,t|)>|\<partial\>*t>=-<frac|1|2>*<frac|\<partial\><rsup|2>*\<sigma\><around|(|S,t|)>|\<partial\>*S<rsup|2>>-\<beta\><around|(|r,w|)>*<around*|[|<mid|\|><space|0.17em>\<sigma\><around|(|S,t|)><mid|\|><rsup|2>+<mid|\|><space|0.17em>\<psi\><around|(|S,t|)><mid|\|><rsup|2>|]>*\<sigma\><around|(|S,t|)>,<eq-number><label|nlsc1>>>|<row|<cell|>|<cell|>|<cell|i*<frac|\<partial\>*\<psi\><around|(|S,t|)>|\<partial\>*t>=-<frac|1|2>*<frac|\<partial\><rsup|2>*\<psi\><around|(|S,t|)>|\<partial\>*S<rsup|2>>-\<beta\><around|(|r,w|)>*<around*|[|<mid|\|><space|0.17em>\<sigma\><around|(|S,t|)><mid|\|><rsup|2>+<mid|\|><space|0.17em>\<psi\><around|(|S,t|)><mid|\|><rsup|2>|]>*\<psi\><around|(|S,t|)>,<space|2em>i=<sqrt|-1><eq-number><label|nlsc2>>>>>>
  </subequations>

  to generate a leverage effect, i.e., stock volatility is (negatively)
  correlated to stock returns<nbsp><cite|nlsc|nlsc2>, where
  Eqs.<nbsp>(<reference|nlsc1>) and (<reference|nlsc2>) are called the
  volatility model and option pricing model, respectively,
  <math|\<psi\><around|(|S,t|)>> denotes the <with|font-shape|italic|option
  pricing wave function>, playing the role of a nonlinear coefficient in the
  volatility model (<reference|nlsc1>), <math|\<sigma\><around|(|S,t|)>>
  denotes the <with|font-shape|italic|volatility wave function>, standing for
  a nonlinear coefficient in the option pricing model (<reference|nlsc2>).
  Both processes thus evolve in a common self-organizing market heat
  potential, so they effectively represent an adaptively controlled Brownian
  behavior of a hypothetical financial market,
  <math|\<beta\><around|(|r,w|)>=r*<big|sum><rsub|j=1><rsup|N>w<rsub|j>*g<rsub|j>>
  with the adaptation equation <math|<wide|w|\<dot\>><rsub|j>=-w<rsub|j>+c<around|\||\<sigma\>|\|>*g<rsub|j><around|\||\<psi\>|\|>><nbsp><cite|Ivan2>.
  Eqs.<nbsp>(<reference|nlsc1>) and (<reference|nlsc2>) without an embedded
  <math|w->learning (i.e., for constant <math|\<beta\>=r>-the interest rate),
  possessed the solitary wave solutions<nbsp><cite|Ivan2>.

  To the best of our knowledge, the analytical financial rogue waves of
  Eqs.<nbsp>(<reference|nlsc1>) and (<reference|nlsc2>) were not reported
  before. In the following, we would like to investigate the two-component
  financial rogue wave solutions of Eqs.<nbsp>(<reference|nlsc1>) and
  (<reference|nlsc2>) without an embedded <math|w->learning, which may play
  an important role to explain some occurred financial crisis/storms (e.g.,
  1997 Asian financial crisis/storm and the current global financial
  crisis/storm).

  <section|Financial rogue waves (rogons)>

  Here, based on the similarity analysis and the approach developed in
  Refs.<nbsp><cite|ABC1|ABC2|ypla10|ypre10|frg>, we show that the coupled
  nonlinear volatility and option pricing model (<reference|nlsc1>) and
  (<reference|nlsc2>) without an embedded <math|w->learning also admits the
  financial multi-rogon (rogue wave) solutions, which may be used to describe
  the possible formation mechanisms for rogue wave phenomenon in financial
  markets. In the following, we only give the first two representative
  financial rogue wave (rogon) solutions of Eqs.<nbsp>(<reference|nlsc1>) and
  (<reference|nlsc2>) without an embedded <math|w->learning .

  <subsection|Financial one-rogue waves (rogons)>

  The financial one-rogon solution of Eqs.<nbsp>(<reference|nlsc1>) and
  (<reference|nlsc2>) without an embedded <math|w->learning for the coupled
  volatility wave function <math|\<sigma\><around|(|S,t|)>> and option
  pricing wave function <math|\<psi\><around|(|S,t|)>> can be written as

  <\subequations>
    <label|solu1>

    <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|\<sigma\><rsub|1><around|(|S,t|)>=<frac|\<alpha\>*a|<sqrt|2*\<beta\>*<around|(|a<rsup|2>+b<rsup|2>|)>>>*<around*|[|1-<frac|4*<around|(|1+i*<space|0.17em>\<alpha\><rsup|2>*t|)>|1+2*\<alpha\><rsup|2>*<around|(|S-k*t|)><rsup|2>+\<alpha\><rsup|4>*t<rsup|2>>|]>*e<rsup|i*<around|[|k*S+<around|(|\<alpha\><rsup|2>-k<rsup|2>|)>*t/2|]>>,<eq-number><label|solu1a>>>|<row|<cell|>|<cell|>|<cell|\<psi\><rsub|1><around|(|S,t|)>=<frac|\<alpha\>*b|<sqrt|2*\<beta\>*<around|(|a<rsup|2>+b<rsup|2>|)>>>*<around*|[|1-<frac|4*<around|(|1+i*<space|0.17em>\<alpha\><rsup|2>*t|)>|1+2*\<alpha\><rsup|2>*<around|(|S-k*t|)><rsup|2>+\<alpha\><rsup|4>*t<rsup|2>>|]>*e<rsup|i*<around|[|k*S+<around|(|\<alpha\><rsup|2>-k<rsup|2>|)>*t/2|]>>,<eq-number><label|solu1b>>>>>>
  </subequations>

  in terms of the complex rational functions of the stock price <math|S> and
  time <math|t>, which involves five free parameters
  <math|\<alpha\>,<space|0.17em>\<beta\>,<space|0.17em>a,<space|0.17em>b>,
  and <math|k> to manage the different types of financial one-rogue wave
  propagations, whose intensity distributions
  <math|<around|\||\<sigma\><rsub|1><around|(|S,t|)>|\|><rsup|2>> and
  <math|<around|\||\<psi\><rsub|1><around|(|S,t|)>|\|><rsup|2>> are displayed
  in Figs.<nbsp><reference|fig:1> and <reference|fig:2> for the chosen
  adaptive market potential <math|\<beta\>=1>, the scaling
  <math|\<alpha\>=1.5>, amplitude parameters <math|a=2,<space|0.17em>b=5>,
  and the gauge <math|k=0,<space|0.17em>0.5>. Notice that time <math|t> in
  these two figures can be chosen to be negative since the solution is
  invariant under the translation transformation
  <math|t\<rightarrow\>t-t<rsub|0>>.

  <\big-figure>
    <scalebox|0.7|[>0.7]<image|f1.eps||||>

    <vspace|-0.2in>

    <label|fig:1>
  </big-figure|<with|font-size|0.84|(color online). Financial rogue wave
  propagations for the coupled volatility wave function
  <math|\<sigma\><rsub|1><around|(|S,t|)>> and option pricing wave function
  <math|\<psi\><rsub|1><around|(|S,t|)>> of the financial one-rogon solutions
  given by Eqs.<nbsp>(<reference|solu1a>) and (<reference|solu1b>) for
  parameters <math|\<alpha\>=1.5,<space|0.17em>\<beta\>=1,<space|0.17em>a=2,<space|0.17em>b=5>,
  and <math|k=0>. (a) The intensity distribution
  <math|<around|\||\<sigma\><rsub|1><around|(|S,t|)>|\|><rsup|2>>; (b) the
  density distridution of <math|<around|\||\<sigma\><rsub|1><around|(|S,t|)>|\|><rsup|2>>;
  (c) The intensity distribution <math|<around|\||\<sigma\><rsub|1><around|(|S,t|)>|\|><rsup|2>>
  for time <math|t=0> (solid line), <math|t=0.4> (dashed line), <math|t=1.0>
  (dashed-dotted line); (d) The intensity distribution
  <math|<around|\||\<psi\><rsub|1><around|(|S,t|)>|\|><rsup|2>>; (e) the
  density distribution of <math|<around|\||\<psi\><rsub|1><around|(|S,t|)>|\|><rsup|2>>;
  (f) The intensity distribution <math|<around|\||\<psi\><rsub|1><around|(|S,t|)>|\|><rsup|2>>
  for time <math|t=0> (solid line), <math|t=0.4> (dashed line), <math|t=1.0>
  (dashed-dotted line). >>

  <\big-figure>
    <vspace|0.05in><scalebox|0.7|[>0.75]<image|f2.eps||||>

    <vspace|-0.2in>

    <label|fig:2>
  </big-figure|<with|font-size|0.84|(color online). Financial rogue wave
  propagations for the coupled volatility wave function
  <math|\<sigma\><rsub|1><around|(|S,t|)>> and option pricing wave function
  <math|\<psi\><rsub|1><around|(|S,t|)>> of the financial one-rogon solutions
  given by Eqs.<nbsp>(<reference|solu1a>) and (<reference|solu1b>) for
  parameters <math|\<alpha\>=1.5,<space|0.17em>\<beta\>=1,<space|0.17em>a=2,<space|0.17em>b=5>,
  and <math|k=0.5>. (a) The intensity distribution
  <math|<around|\||\<sigma\><rsub|1><around|(|S,t|)>|\|><rsup|2>>; (b) the
  density distridution of <math|<around|\||\<sigma\><rsub|1><around|(|S,t|)>|\|><rsup|2>>;
  (c) The intensity distribution <math|<around|\||\<sigma\><rsub|1><around|(|S,t|)>|\|><rsup|2>>
  for time <math|t=0> (solid line), <math|t=0.4> (dashed line), <math|t=1.0>
  (dashed-dotted line); (d) The intensity distribution
  <math|<around|\||\<psi\><rsub|1><around|(|S,t|)>|\|><rsup|2>>; (e) the
  density distribution of <math|<around|\||\<psi\><rsub|1><around|(|S,t|)>|\|><rsup|2>>;
  (f) The intensity distribution <math|<around|\||\<psi\><rsub|1><around|(|S,t|)>|\|><rsup|2>>
  for time <math|t=0> (solid line), <math|t=0.4> (dashed line), <math|t=1.0>
  (dashed-dotted line).>>

  <subsection|Financial two-rogue waves (rogons)>

  <space|1em>Similarly, based on the symmetry analysis, we can obtain the
  financial two-rogon solutions of Eqs.<nbsp>(<reference|nlsc1>) and
  (<reference|nlsc2>) without an embedded <math|w->learning for the coupled
  volatility wave function <math|\<sigma\><around|(|S,t|)>> and option
  pricing wave function <math|\<psi\><around|(|S,t|)>> in the form

  <\subequations>
    <label|solu2>

    <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|\<sigma\><rsub|2><around|(|S,t|)>=<frac|\<alpha\>*a|<sqrt|2*\<beta\>*<around|(|a<rsup|2>+b<rsup|2>|)>>>*<around*|[|1+<frac|P<rsub|2><around|(|S,t|)>-<around|(|1/2|)>*<space|0.17em>i*<space|0.17em>\<alpha\><rsup|2>*t*<space|0.17em>Q<rsub|2><around|(|S,t|)>|H<rsub|2><around|(|S,t|)>>|]>*e<rsup|i*<around|[|k*S+<around|(|\<alpha\><rsup|2>-k<rsup|2>|)>*t/2|]>>,<eq-number><label|solu2a>>>|<row|<cell|>|<cell|>|<cell|\<psi\><rsub|2><around|(|S,t|)>=<frac|\<alpha\>*b|<sqrt|2*\<beta\>*<around|(|a<rsup|2>+b<rsup|2>|)>>>*<around*|[|1+<frac|P<rsub|2><around|(|S,t|)>-<around|(|1/2|)>*<space|0.17em>i*<space|0.17em>\<alpha\><rsup|2>*t*<space|0.17em>Q<rsub|2><around|(|S,t|)>|H<rsub|2><around|(|S,t|)>>|]>*e<rsup|i*<around|[|k*S+<around|(|\<alpha\><rsup|2>-k<rsup|2>|)>*t/2|]>>,<eq-number><label|solu2b>>>>>>
  </subequations>

  with these above-mentioned functions <math|P<rsub|2><around|(|S,t|)>,Q<rsub|2><around|(|S,t|)>>
  and <math|H<rsub|2><around|(|S,t|)>> being of polynomials in the stock
  price <math|S> and time <math|t> in the form

  <eqnarray|<tformat|<table|<row|<cell|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|P<rsub|2><around|(|S,t|)>=-<frac|\<alpha\><rsup|4>|2>*<around|(|S-k*t|)><rsup|4>-<frac|3*\<alpha\><rsup|6>|2>*<around|(|S-k*t|)><rsup|2>*t<rsup|2>-<frac|5*\<alpha\><rsup|8>|8>*t<rsup|4>-<frac|3*\<alpha\><rsup|2>|2>*<around|(|S-k*t|)><rsup|2>-<frac|9*\<alpha\><rsup|4>|4>*t<rsup|2>+<frac|3|8>,<vspace|0.1in>>>|<row|<cell|Q<rsub|2><around|(|S,t|)>=\<alpha\><rsup|4>*<around|(|S-k*t|)><rsup|4>+\<alpha\><rsup|6>*<around|(|S-k*t|)><rsup|2>*t<rsup|2>+<frac|\<alpha\><rsup|8>|4>*t<rsup|4>-3*\<alpha\><rsup|2>*<around|(|S-k*t|)><rsup|2>+<frac|\<alpha\><rsup|4>|2>*t<rsup|2>-<frac|15|4>,<vspace|0.1in>>>|<row|<cell|H<rsub|2><around|(|S,t|)>=<frac|\<alpha\><rsup|6>|12>*<around|(|S-k*t|)><rsup|6>+<frac|\<alpha\><rsup|8>|8>*<around|(|S-k*t|)><rsup|4>*t<rsup|2>+<frac|\<alpha\><rsup|10>|16>*<around|(|S-k*t|)><rsup|2>*t<rsup|4>+<frac|\<alpha\><rsup|12>|96>*t<rsup|6>+<frac|\<alpha\><rsup|4>|8>*<around|(|S-k*t|)><rsup|4><vspace|0.08in>>>|<row|<cell|<space|2em><space|2em><space|1em><space|1em>-<frac|3*\<alpha\><rsup|6>|8>*<around|(|S-k*t|)><rsup|2>*t<rsup|2>+<frac|9*\<alpha\><rsup|8>|32>*t<rsup|4>+<frac|9*\<alpha\><rsup|2>|16>*<around|(|S-k*t|)><rsup|2>+<frac|33*\<alpha\><rsup|4>|32>*t<rsup|2>+<frac|3|32>,>>>>><eq-number><label|solu2c>>>>>>

  which contain five free parameters <math|\<alpha\>,<space|0.17em>\<beta\>,<space|0.17em>a,<space|0.17em>b>,
  and <math|k> to manage the different types of financial two-rogue wave
  propagations whose intensity distributions
  <math|<around|\||\<sigma\><rsub|2><around|(|S,t|)>|\|><rsup|2>> and
  <math|<around|\||\<psi\><rsub|2><around|(|S,t|)>|\|><rsup|2>> are depicted
  in Figs.<nbsp><reference|fig:3> and <reference|fig:4> for the chosen
  adaptive market potential <math|\<beta\>=1>, the scaling
  <math|\<alpha\>=1.5>, amplitude parameters <math|a=2,<space|0.17em>b=5> and
  the gauge <math|k=0,<space|0.17em>0.5>.

  <\big-figure>
    <vspace|0.1in><scalebox|0.7|[>0.72]<image|f3.eps||||>

    <vspace|-0.1in>

    <label|fig:3>
  </big-figure|<with|font-size|0.84|(color online). Financial rogue wave
  propagations for the coupled volatility wave function
  <math|\<sigma\><rsub|2><around|(|S,t|)>> and option pricing wave function
  <math|\<psi\><rsub|2><around|(|S,t|)>> of the financial two-rogon solutions
  given by Eqs.<nbsp>(<reference|solu2a>) and (<reference|solu2b>) for
  parameters <math|\<alpha\>=1.5,<space|0.17em>\<beta\>=1,<space|0.17em>a=2,<space|0.17em>b=5>,
  and <math|k=0>. (a) The intensity distribution
  <math|<around|\||\<sigma\><rsub|2><around|(|S,t|)>|\|><rsup|2>>; (b) the
  density distridution of <math|<around|\||\<sigma\><rsub|2><around|(|S,t|)>|\|><rsup|2>>;
  (c) The intensity distribution <math|<around|\||\<sigma\><rsub|2><around|(|S,t|)>|\|><rsup|2>>
  for time <math|t=0> (solid line), <math|t=0.4> (dashed line), <math|t=1.2>
  (dashed-dotted line); (d) The intensity distribution
  <math|<around|\||\<psi\><rsub|2><around|(|S,t|)>|\|><rsup|2>>; (e) the
  density distribution of <math|<around|\||\<psi\><rsub|2><around|(|S,t|)>|\|><rsup|2>>;
  (f) The intensity distribution <math|<around|\||\<psi\><rsub|2><around|(|S,t|)>|\|><rsup|2>>
  for time <math|t=0> (solid line), <math|t=0.4> (dashed line), <math|t=1.2>
  (dashed-dotted line). >>

  <\big-figure>
    <vspace|0.1in><scalebox|0.7|[>0.72]<image|f4.eps||||>

    <vspace|-0.1in>

    <label|fig:4>
  </big-figure|<with|font-size|0.84|(color online). Financial rogue wave
  propagations for the coupled volatility wave function
  <math|\<sigma\><rsub|2><around|(|S,t|)>> and option pricing wave function
  <math|\<psi\><rsub|2><around|(|S,t|)>> of the financial two-rogon solutions
  given by Eqs.<nbsp>(<reference|solu2a>) and (<reference|solu2b>) for
  parameters <math|\<alpha\>=1.5,<space|0.17em>\<beta\>=1,<space|0.17em>a=2,<space|0.17em>b=5>,
  and <math|k=0.5>. (a) The intensity distribution
  <math|<around|\||\<sigma\><rsub|2><around|(|S,t|)>|\|><rsup|2>>; (b) the
  density distridution of <math|<around|\||\<sigma\><rsub|2><around|(|S,t|)>|\|><rsup|2>>;
  (c) The intensity distribution <math|<around|\||\<sigma\><rsub|2><around|(|S,t|)>|\|><rsup|2>>
  for time <math|t=0> (solid line), <math|t=0.8> (dashed line), <math|t=1.5>
  (dashed-dotted line); (d) The intensity distribution
  <math|<around|\||\<psi\><rsub|2><around|(|S,t|)>|\|><rsup|2>>; (e) the
  density distribution of <math|<around|\||\<psi\><rsub|2><around|(|S,t|)>|\|><rsup|2>>;
  (f) The intensity distribution <math|<around|\||\<psi\><rsub|2><around|(|S,t|)>|\|><rsup|2>>
  for time <math|t=0> (solid line), <math|t=0.8> (dashed line), <math|t=1.5>
  (dashed-dotted line). >>

  <section|Conclusions>

  In conclusion, based on the symmetry analysis, we have investigated the
  coupled nonlinear volatility and option pricing model (<reference|nlsc1>)
  and (<reference|nlsc2>) without an embedded <math|w->learning such that we
  present its analytical financial one- and two-rogon solutions with some
  free parameters. Moreover, we also illustrate their dynamical behaviors for
  chosen different parameters <math|\<alpha\>,<space|0.17em>\<beta\>,<space|0.17em>k,<space|0.17em>a>,
  and <math|b> (see Figs.<nbsp><reference|fig:1>-<reference|fig:4>).

  Our results may play an important role to explain some real financial
  crisis/storms (e.g., 1997 Asian financial crisis/storm and the current
  global financial crisis/storm). Moreover, these results may further excite
  the possibility of relative researches and potential applications for the
  financial rogue-wave phenomena in the financial markets and other related
  fields of science.

  <vspace|0.15in><no-indent><with|font-series|bold|Acknowledgements>

  <vspace|0.01in>The work was partially supported by the NSFC60821002/F02 and
  NSFC11071242.

  <\thebibliography|99>
    <baselineskip>=15pt

    <bibitem|rwd>L. Draper, Oceanus 10 (1964) 13.

    <bibitem|rgd2>K. Dysthe, H. E. Krogstad, and P. Mller, Annu. Rev. Fluid
    Mech. 40 (2008) 287.

    <bibitem|RW1>G. Lowton, New Sci. 170 (2001) 28.

    <bibitem|RW2>C. Kharif and E. Pelinovsky, Eur. J. Mech. B (Fluids) 22
    (2003) 603.

    <bibitem|RW3>P. Mller, Ch. Garrett, and A. Osborne, Oceanography 18
    (2005) 66.

    <bibitem|RW4>A. R. Osborne, <with|font-shape|italic|Nonlinear Ocean
    Waves> (Academic Press, New York, 2009).

    <bibitem|RW5>C. Kharif, E. Pelinovsky, and A. Slunyaev,
    <with|font-shape|italic|Rogue Waves in the Ocean, Observation, Theories
    and Modeling> (Springer, New York, 2009).

    <bibitem|ORW>D. R. Solli, C. Ropers, P. Koonath, and B. Jalali, Nature
    450 (2007) 1054.

    <bibitem|exp1>D. R. Solli, C. Ropers, and B. Jalali, Phys. Rev. Lett. 101
    (2008) 233902.

    <bibitem|exp2>B. Kibler, J. Fatome, C. Finot, G. Millot, F. Dias, G.
    Genty, N. Akhmediev, and J. M. Dudley,<next-line>Nature Phys. 6 (2010) 1.

    <bibitem|ABC1>N. Akhmediev, A. Ankiewicz, and J. M. Soto-Crespo, Phys.
    Rev. E 80 (2009) 026601.

    <bibitem|ABC2>N. Akhmediev, A. Ankiewicz, and M. Taki, Phys. Lett. A 373
    (2009) 675.

    <bibitem|ABC3>A. Ankiewicz, <slink|http://demonstrations.wolfram.com/RogueOceanWaves>.

    <bibitem|BKA>Yu. V. Bludov, V. V. Konotop, and N. Akhmebiev, Opt. Lett.
    <with|font-series|bold|34>, 3015 (2009).

    <bibitem|ypla10>Z. Y. Yan, Phys. Lett. A 374 (2010) 672.

    <bibitem|ypla102>Z. Y. Yan, <slink|http://demonstrations.wolfram.com/OpticalRogueWavesRogons>.

    <bibitem|BRW>Yu. V. Bludov, V. V. Konotop, and N. Akhmediev, Phys. Rev. A
    80 (2009) 033610.

    <bibitem|ypre10>Z. Y. Yan, V. V. Konotop, and N. Akhmediev, Phys. Rev. E
    <with|font-series|bold|82>, 036610 (2010).

    <bibitem|arg>L. Stenflo and M. Marklund, J. Plasma Phys. 76 (2010) 293.
    [e-print, arXiv: 0911.1654.]

    <bibitem|frg>Z. Y. Yan, Commun. Thero. Phys. 54 (2010) 947. [e-print,
    arXiv: 0911.4259.]

    <bibitem|PS>D. H. Peregrine, J. Austral. Math. Soc. Ser. B 25 (1983) 16.

    <bibitem|Ma>Ya.-C. Ma, Stud. Appl. Math. 60 (1979) 43.

    <bibitem|AK>N. Akhmediev, V. M. Eleonskii, and N. E. Kulagin, Theor.
    Math. Phys. 72 (1987) 809.

    <bibitem|PST>K. B. Dysthe and K. Trulsen, Phys. Scr. T82 (1999) 48.

    <bibitem|BS>F. Black and M. Scholes, J. Pol. Econ. 81 (1973) 637.

    <bibitem|BS2>R. C. Merton, J. Econ. Mana. Sci. 4 (1973) 141.

    <bibitem|Ito>K. It<math|<wide|<math-up|o>|^>>, Mem. Am. Math. Soc. 4
    (1951) 1.

    <bibitem|book1>M. Kijima, <with|font-shape|italic|Stochastic Processes
    with Applications to Finance> (Chapman & Hall, London, 2002).

    <bibitem|book2>M. Steele, <with|font-shape|italic|Stochastic Calculus and
    Financial Applications> (Springer-Verlag, Berlin, 2001).

    <bibitem|book3>P. Wilmott, J. Dewynne and S. Howison,
    <with|font-shape|italic|Option Pricing: Mathematical Models and
    Computation> (Cambridge Financial Press, Cambridge, 1995).

    <bibitem|Lo>A. W. Lo, J. Portf. Manag. 30 (2004) 15.

    <bibitem|Lo2>A. W. Lo, J. Inves. Consult. 7 (2005) 21.

    <bibitem|Elliot>A. J. Frost and R. R. Prechter,
    <with|font-shape|italic|Elliott Wave Principle: Key to Market Behavior>
    (Wiley, New York, 1978); <with|font-shape|italic|Elliott Wave
    International> (10th Ed.) (Wiley, New York, 2009).

    <bibitem|Elliot2>P. Steven, <with|font-shape|italic|Applying Elliott Wave
    Theory Profitably> (Wiley, New York, 2003).

    <bibitem|Ivan>V. G. Ivancevic and T. Ivancevic,
    <with|font-shape|italic|Quantum Neural Computation> (Springer, New York,
    2009).

    <bibitem|Ivan2>V. G. Ivancevic, e-print, arXiv: 0911.1834.

    <bibitem|Ivan3>V. G. Ivancevic, e-print, arXiv: 1001.0615.

    <bibitem|nlsc>H. E. Roman, M. Porto, and C. Dose, EPL 84 (2008) 28001.

    <bibitem|nlsc2>F. Black, Proc. 1976 Meet. Ame. Stat. Assoc. Bus. Econ.
    Stat. 1976, pp.177.
  </thebibliography>
</body>