<TeXmacs|1.99.7>

<style|<tuple|elsart|std-latex>>

<\body>
  <\hide-preamble>
    <assign|simgreat|<macro|<simgreatbox>>>

    <assign|simless|<macro|<simlessbox>>>
  </hide-preamble>

  <doc-data|<doc-title|An `almost' linear stochastic map model for economic
  dynamics>|<doc-author|<author-data|<author-name|Anindya S. Chakrabarti>>>>

  <abstract-data|<\abstract>
    <no-indent>We propose a very simple (almost linear) stochastic map model
    of economic dynamics. In the last decade, an array of observations in
    economics has been investigated in the econophysics literature, a major
    example being the universal features of inequality in terms of income and
    wealth. Another area of inquiry is the formation of opinion in a society.
    Our proposed model can generate the Gamma-like and the power law
    distributions as has been observed in the real data of income and wealth
    distributions. Also, it is able to produce a non-trivial phase transition
    in the opinion of a society (opinion formation). A number of physical
    models also generates similar results. In particular, the kinetic
    exchange models have been especially successful in this regard.
    Therefore, we compare the results obtained from these two approaches and
    point out a number of new features obtained from the map model.
  </abstract>>

  <section|Introduction>

  <no-indent>It is known that the distributions of income and wealth possess
  some robust and stable features which are independent of the
  economy-specific conditions <cite|yako-rosser;09>. But the exact form of
  the distribution is still debated <cite|kleiber;02>. It has been a
  tradition in the economics literature to model the left tail and the mode
  of the distributions of the incomes with a log-normal <cite|gibrat;31>
  distribution and the right tail with a Pareto distribution i.e., a power
  law <cite|pareto;97>. However, a number of recent studies in econophysics
  literature argue that the left tail and the mode of the distribution is
  best described by the gamma distribution and the right tail of the
  distribution follows a power law (See Ref.
  <cite|drag-yako;01|drag-yako;01a|acbkc;07|chakrabartis;10>). Also, a
  significant number of attempts have been devoted to explain the emergence
  of a consensus in a society and the possibility of a non-trivial
  phase-transition in the average opinion of the society (See Ref.
  <cite|weisbuch|lallouache;10>).

  <no-indent>Here, we propose a minimal stochastic map which produces all of
  the aforementioned features and in addition, it shows some new features as
  well. Below, we propose the model and discuss its relative merits and
  demerits with respect to the kinetic exchange models which also generates
  similar results.

  <section|The map><label|sec:map>

  <no-indent>The map has the following form

  <\equation>
    m*<around|(|t+1|)>=m*i*n<nbsp><around|{|<around|(|\<lambda\><rsub|1>+\<epsilon\><rsub|t>*\<lambda\><rsub|2>|)>*m<around|(|t|)>+\<xi\><rsub|t>*\<lambda\><rsup|n><rsub|3>,\<theta\>|}><label|map>
  </equation>

  <no-indent>where <math|\<lambda\><rsub|1>>, <math|\<lambda\><rsub|2>> and
  <math|\<lambda\><rsub|3>> are linear functions of a single parameter
  <math|\<lambda\>> with <math|0\<le\>\<lambda\>\<le\>1> such that
  <math|0\<le\>\<lambda\><rsub|i>\<le\>1> for <math|i>=1, 2 and 3. We assume
  that <math|-\<infty\>\<le\>n\<leq\>1>, <math|\<theta\>> takes value either
  a positive, finite value (we assume <math|\<theta\>> = 1, for convinience)
  or <math|\<infty\>> (or a sufficiently large value) and
  <math|\<epsilon\><rsub|t>,\<xi\><rsub|t>\<sim\>u*n*i<around|[|0,1|]>> and
  independent, unless specified. In all the simulations, we have assumed
  <math|m<around|(|0|)>> = 1. We denote the time index by subscripts for
  exogenous random variables (<math|\<epsilon\>> and <math|\<xi\>>) which we
  shall drop when no confusion arises. While the parameter space is seemingly
  too large to be considered in details, we shall restrict the it
  considerably by assuming very simple forms of <math|\<lambda\><rsub|i>> for
  all <math|i>.

  <vspace|1fn><section|Statistical features of the map at some limits>

  <subsection|A <math|\<Gamma\>>-like distribution><label|subsec: Case 1>

  <no-indent>

  <no-indent>We assume <math|\<lambda\><rsub|1>=\<lambda\>>,
  <math|\<lambda\><rsub|2>=\<lambda\><rsub|3>=1-\<lambda\>>, <math|n=1> and
  <math|\<theta\>=\<infty\>>. The equation becomes

  <\equation>
    m*<around|(|t+1|)>=<around|(|\<lambda\>+\<epsilon\>*<around|(|1-\<lambda\>|)>|)>*m<around|(|t|)>+\<xi\>*<around|(|1-\<lambda\>|)>.<label|gamma1>
  </equation>

  <no-indent>See Fig. <reference|almostgamma> for steady state distributions
  corresponding to different values of <math|\<lambda\>>. Though we do not
  know the exact algebraic form of the steady state distributions produced by
  Eqn. <reference|gamma1>, we can find out its moments in order to describe
  them qualitatively. We can ignore the time index in the steady state.
  Taking expectations over both sides of Eqn. <reference|gamma1>, we get

  <\equation>
    <around|\<langle\>|m|\<rangle\>>=1.
  </equation>

  <no-indent>

  <no-indent>Also, we have the variance of <math|m> as

  <\equation>
    V<around|(|m|)>=<around|\<langle\>|x<rsup|2>|\<rangle\>>-<around|\<langle\>|x|\<rangle\>><rsup|2><label|variance>
  </equation>

  <no-indent>where <math|x=<around*|(|\<lambda\>+\<epsilon\>*<around|(|1-\<lambda\>|)>|)>*m+\<xi\>*<around|(|1-\<lambda\>|)>>.
  Now, we make a few almost trivial observations. Note the fact that
  <math|<around|\<langle\>|x|\<rangle\>>=1>. Hence,
  <math|<around|\<langle\>|m<rsup|2>|\<rangle\>>> can be written as
  <math|V<around|(|m|)>+<around|\<langle\>|m|\<rangle\>><rsup|2>> (by defn.
  of <math|V<around|(|m|)>>) i.e., <math|V<around|(|m|)>+1>. Also,
  <math|\<epsilon\>> and <math|\<xi\>> are uniformly distributed. Therefore,
  <math|<around|\<langle\>|\<epsilon\>|\<rangle\>>> = 1/2 =
  <math|<around|\<langle\>|\<xi\>|\<rangle\>>> and
  <math|<around|\<langle\>|\<epsilon\><rsup|2>|\<rangle\>>> = 1/3 =
  <math|<around|\<langle\>|\<xi\><rsup|2>|\<rangle\>>> (recall that
  <math|V<around|(|\<epsilon\>|)>> = 1/12 = <math|V<around|(|\<xi\>|)>>).
  Using all of these and by expanding Eqn. <reference|variance> we get

  <eqnarray|<tformat|<table|<row|<cell|V<around|(|m|)>>|<cell|=>|<cell|<around|[|\<lambda\><rsup|2>+\<lambda\>*<around|(|1-\<lambda\>|)>+<frac|1|3>*<around|(|1-\<lambda\>|)><rsup|2>|]>*<around*|(|V<around|(|m|)>+1|)>>>|<row|<cell|>|<cell|>|<cell|+<frac|1|3>*<around|(|1-\<lambda\>|)><rsup|2>*\<lambda\>*<around|(|1-\<lambda\>|)>+<frac|1|2>*<around|(|1-\<lambda\>|)><rsup|2>-1.>>>>>

  <no-indent>Simplifying the above expression we get the result for
  <math|\<lambda\>\<ne\>1>,

  <\equation>
    V<around|(|m|)>=<frac|1|2><around*|(|<frac|1-\<lambda\>|2-\<lambda\>>|)><label|gamma2>
  </equation>

  <no-indent>which clearly shows that the distribution tends to a delta
  function as <math|\<lambda\>\<rightarrow\>1>. It is noteworthy that though
  these distributions have a visual resemblance with the <math|\<Gamma\>>
  distributions, they are not exactly so. With <math|\<lambda\>> = 0, Eqn.
  <reference|gamma1> produces a distribution with a sharp peak at <math|m>
  very close to 1. However, for <math|\<lambda\><nbsp>\<gtr\><nbsp>0.3> this
  sharpness goes away.

  <\big-figure>
    <no-indent><image|almostgamma.eps|6cm|||> Stable distributions generated
    by Eqn. <reference|gamma1>: Three cases are shown above, viz.,
    <math|\<lambda\>=0> (+), <math|\<lambda\>=0.4> (<math|\<times\>>),
    <math|\<lambda\>=0.7> (<math|\<ast\>>).<label|almostgamma>
  </big-figure|<protect>>

  <no-indent>One can consider an even simpler case with <math|\<xi\><rsub|t>>
  =<math|\<epsilon\><rsub|t>> for all <math|t> so that the map becomes

  <\equation>
    m*<around|(|t+1|)>=\<lambda\>*m<around|(|t|)>+\<epsilon\>*<around|(|1-\<lambda\>|)>*<around*|(|m<around|(|t|)>+1|)><label|gamma3>
  </equation>

  <no-indent>which is almost the same as the usual kinetic exchange model
  with a constant savings factor i.e., the CC model (See Ref.
  <cite|chakraborti;00>; See also Ref. <cite|acbkc;07>),

  <\equation>
    m<rsub|i>*<around|(|t+1|)>=\<lambda\>*m<rsub|i><around|(|t|)>+\<epsilon\>*<around|(|1-\<lambda\>|)>*<around*|(|m<rsub|i><around|(|t|)>+m<rsub|j><around|(|t|)>|)>.<label|gamma4>
  </equation>

  <no-indent>The variance of the distribution generated by
  Eqn.<reference|gamma3> is given by

  <\equation>
    V<around|(|m|)>=<around*|(|<frac|1-\<lambda\>|2+\<lambda\>>|)>.<label|gamma5>
  </equation>

  <no-indent>For the sake of completeness, we mention that the variance of
  the distribution generated by Eqn. <reference|gamma4> is given by (See Ref.
  <cite|richmond;05>)

  <\equation>
    V<around|(|m|)>=<frac|<around|(|1-\<lambda\>|)>|<around|(|1+2*\<lambda\>|)>>.<label|gamma6>
  </equation>

  <no-indent>It is noteworthy that for <math|\<lambda\><nbsp>=<nbsp>0>, the
  distribution generated by Eqn. <reference|gamma3> has a peculiar form. For
  <math|m\<leq\>1>, <math|P<around|(|m|)>> is uniformly distributed and for
  <math|m<nbsp>\<gtr\><nbsp>1>, the distribution has an excellent fit with
  <math|P<around|(|m|)><nbsp>=<nbsp>0.5<nbsp><with|font-family|rm|e*x*p(-(>*m-1)<rsup|1.5>)>
  (See the inset of the Fig. <reference|almostgamma1>). For larger values of
  <math|\<lambda\>>, the distribution looks like a <math|\<Gamma\>> function
  (See Fig. <reference|almostgamma1>). It is to be noted that we cannot
  generate an exponential distribution from Eqn. <reference|gamma5> since its
  maximum variance is 1/2 (for <math|\<lambda\>=0>) whereas the variance of
  the exponential distribution generated by the following Eqn. (See Ref.
  <cite|acbkc;07>)

  <\equation>
    m<rsub|i>*<around|(|t+1|)>=\<epsilon\>*<around*|(|m<rsub|i><around|(|t|)>+m<rsub|j><around|(|t|)>|)><label|exp>
  </equation>

  <no-indent>is unity. Hence this model can not generate purely exponential
  distribution. An intuitive explanation can very easily be provided. Recall
  that with <math|\<lambda\>=0>, Eqn. <reference|gamma3> is

  <\equation>
    m<rsub|i>*<around|(|t+1|)>=\<epsilon\>*<around*|(|m<rsub|i><around|(|t|)>+1|)>.<label|noexp>
  </equation>

  <no-indent>Clearly in Eqn. <reference|exp>,
  <math|m<rsub|i>*<around|(|t+1|)>> has two sources of variations, one is
  variation in <math|\<epsilon\>> and the other is the variation is
  <math|m<rsub|j><around|(|t|)>>. It is the second term which is absent in
  Eqn. <reference|noexp>. In fact, it is substituted there by 1 i.e., the
  average value of <math|m<rsub|j><around|(|t|)>> (in a population with
  <math|M/N> = 1). Therefore, there is a loss of variability in Eqn.
  <reference|noexp> and hence, its variance is less. Comparison between Eqn.
  <reference|gamma5> and Eqn. <reference|gamma6> also shows that the variance
  of the system given by Eqn. <reference|gamma3> is consistently less than
  that of Eqn. <reference|gamma4> (for all
  <math|\<lambda\><nbsp>\<less\><nbsp>1>).

  <\big-figure>
    <no-indent><image|almostgamma1.eps|6cm|||> Stable distributions generated
    by Eqn. <reference|gamma3>: Three cases are shown above, viz.,
    <math|\<lambda\>=0> (+), <math|\<lambda\>=0.4> (<math|\<times\>>),
    <math|\<lambda\>=0.7> (<math|\<ast\>>). <with|font-shape|italic|Inset> :
    The steady state distribution for <math|\<lambda\>> = 0, in the semi-log
    plot. Clearly, for <math|m<nbsp>\<less\><nbsp>1> the distribution is
    uniform. The rest fits very well with
    <math|0.5<nbsp><with|font-family|rm|e*x*p{-(>*m-1)<rsup|1.5>}> (see the
    continuous line).<label|almostgamma1>
  </big-figure|<protect>>

  <subsection|Power law distribution><label|subsec: Case 2>

  <no-indent>

  <no-indent>We assume <math|\<lambda\><rsub|1>=\<lambda\>>,
  <math|\<lambda\><rsub|2>=\<lambda\><rsub|3>=1-\<lambda\>>,
  <math|-\<infty\>\<le\>n\<le\>0> and <math|\<theta\>=\<infty\>>.

  The relevant equation is

  <\equation>
    m*<around|(|t+1|)>=<around|{|\<lambda\>+\<epsilon\>*<around|(|1-\<lambda\>|)>|}>*m<around|(|t|)>+\<xi\>*<around|(|1-\<lambda\>|)><rsup|n>.<label|power2>
  </equation>

  <no-indent>We show that the distribution of the average value of <math|m>
  depends on the distribution of <math|\<lambda\>>. In particular, if
  <math|\<lambda\>> is uniformly distributed, then <math|m>'s distribution
  would follow a power law. This implies that if there is a population of
  agents with different <math|\<lambda\>> but each of the income evolution
  process is modelled by Eqn. <reference|power2>, then a power law in the
  income distribution will be observed. Note that we did not require the
  population to be interacting to generate the result as was assumed by the
  earlier models <cite|acbkc;07>.

  <\big-figure>
    <no-indent><image|power1.eps|6cm|||> A power law distribution (<math|n> =
    <math|-20> in Eqn. <reference|power2>). The straight line with slope -1
    is drawn as a guide.<label|powerlaw1>
  </big-figure|<protect>>

  <\big-figure>
    <no-indent><image|power2.eps|6cm|||> A power law distribution (<math|n> =
    0 in Eqn. <reference|power2>). The straight line with slope -2 is drawn
    as a guide.<label|powerlaw2>
  </big-figure|<protect>>

  <no-indent>A very simple proof is considered below. Note that (in the
  steady state) by taking expectations on both sides of the equation, we can
  rewrite it as

  <\equation>
    <around|(|1-\<lambda\>|)><rsup|1-n><around|\<langle\>|m|\<rangle\>>=1<label|power3>
  </equation>

  <no-indent>By taking total differentiation and rearrenging terms, we get

  <\equation>
    <frac|d*\<lambda\>|d*m>=<frac|1|1-n>*m<rsup|-<frac|n-2|n-1>><label|power4>
  </equation>

  <no-indent>where <math|m> represents <math|<around|\<langle\>|m|\<rangle\>>>.
  Hence, the average amount of money held by an agent with a particular
  <math|\<lambda\>> is given by Eqn. <reference|power3>. Also, the relation
  between the distribution of <math|\<lambda\>> with that of <math|m> is
  given by the following Eqn.

  <\equation>
    P<around|(|m|)>*d*m=\<rho\><around|(|\<lambda\>|)>*d*\<lambda\>.<label|power5>
  </equation>

  <no-indent>Eqn. <reference|power4> and <reference|power5> shows that in an
  population of agents with uniformly distributed <math|\<lambda\>>, the
  distribution of <math|m> would be

  <\equation>
    P<around|(|m|)>\<sim\>m<rsup|-<frac|n-2|n-1>>.
  </equation>

  It is trivial to note that the CCM model (See Ref. <cite|chatterjee;04>;
  See also Ref. <cite|acbkc;07>) derived the result analogous to the case
  where <math|n=0> (see Fig. <reference|powerlaw2>). Also, if <math|n> is
  large in modulus then the steady state would be power law distribution with
  power -1 (see Fig. <reference|powerlaw1>).

  <subsection|A non-trivial phase transition><label|subsec: Case 3>

  <no-indent>Here, we briefly mention that a special case of the map shows a
  non-trivial phase transition. If we assume
  <math|\<lambda\><rsub|1>=\<lambda\><rsub|2>=\<lambda\>>,
  <math|\<lambda\><rsub|3>=0>, <math|n=1> and <math|\<theta\>=1>. The
  equation becomes

  <\equation>
    m*<around|(|t+1|)>=m*i*n*<around|{|\<lambda\>*<around|(|1+\<epsilon\>|)>*m<around|(|t|)>,1|}>
  </equation>

  <no-indent>Ref. <cite|lallouache;10> considered this map and showed that
  this map shows a phase transition (with respect to <math|\<lambda\>>) in
  the average value of <math|m>, the critical point being
  <math|\<lambda\><rsub|c>> <math|\<simeq\>> 0.6796. For further details on
  this map, see Ref. <cite|lallouache;10>. Interestingly, this map has a
  parallel in the kinetic exchange models, also discusses in the same
  reference. For detailed analysis on the nature of such transitions see Ref.
  <cite|sen;10|biswas;10>.

  <subsection|The law of proportionate effect><label|subsec: Case 4>

  <no-indent>

  <no-indent>We assume <math|\<lambda\><rsub|1>=\<lambda\><rsub|2>=1>,
  <math|\<lambda\><rsub|3>=0> and <math|\<theta\>=\<infty\>>.

  The equation becomes

  <\equation>
    m*<around|(|t+1|)>=<around|(|1+\<epsilon\><rsub|t>|)>*m<around|(|t|)>
  </equation>

  <no-indent>which is very wellknown as a generator of log-normal
  distribution (See Ref. <cite|gibrat;31>). To find the distribution of
  <math|m<around|(|t|)>>, note that the above equation can be rewritten (by
  iteration) as

  <\equation>
    m*<around|(|t+1|)>=<big|prod><rsub|t><around|(|1+\<epsilon\><rsub|t>|)>*m<around|(|1|)>
  </equation>

  <no-indent>and by taking log on both sides, it can be written as

  <eqnarray|<tformat|<table|<row|<cell|log
  <nbsp>m*<around|(|t+1|)>>|<cell|=>|<cell|<big|sum><rsub|t>log
  <nbsp><around|(|1+\<epsilon\><rsub|t>|)>+l*o*g<nbsp>m<around|(|1|)>>>|<row|<cell|>|<cell|=>|<cell|<big|sum><rsub|t>\<epsilon\><rsub|t>+log
  <nbsp>m<around|(|1|)><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><text|(by
  approximation).>>>|<row|<cell|>|<cell|>|<cell|<eq-number>>>>>>

  <no-indent>By applying the Central Limit Theorem, we see that <math|log
  <nbsp>m<around|(|t|)>> is distributed normally, hence
  <math|m<around|(|t|)>> is distributed log-normally.

  <section|Summary>

  <no-indent>In recent years, a number of economic regularities have been
  investigated in the econophysics literature, one of the most prominent
  themes being the distributions of income/wealth. The two candidate
  distributions for explaining the left tail and the mode of the
  distributions of income/wealth are Gamma and Log-normal. There is a
  consensus that the heavy right tail is best described by a power law (See
  Ref. <cite|yako-rosser;09|acbkc;07>). Also, the process of opinion
  formation due to interactions among numerous agents have been studied in
  details. The phenomena of emerging consensus and a phase transition in the
  opinion formation have been tried to be modelled in many ways (See Ref.
  <cite|weisbuch|lallouache;10>).

  <no-indent>In this paper, we examine a simple iterative equation to model
  the economic process of income/wealth distribution and the sociological
  process of opinion formation. Previously, a class of models called the
  kinetic exchange models, had been employed to understand each of these
  phenomena <cite|acbkc;07|lallouache;10>. We show that there are some
  completely new results produced by this map model whereas other results
  mostly conform with those derived in the kinetic exchange models.

  <vspace|1fn><with|font-series|bold|Acknowledgement>

  <vspace|1fn><no-indent>I am grateful to Arnab Chatterje and Bikas K.
  Chakrabarti for some useful discussions and careful reading of the
  manuscript.

  <\thebibliography|99>
    <bibitem|yako-rosser;09>V. Yakovenko, J. B. Rosser,
    <with|font-shape|italic|Colloquium: Statistical mechanics of money,
    wealth and income>, Rev. Mod. Phys., <with|font-series|bold|81> (2009)
    1703-25.

    <bibitem|kleiber;02>C. Kleiber, S. Kotz,
    <with|font-shape|italic|Statistical size distributions in economics and
    acturial sciences>, Wiley, New Jersey, 2003.

    <bibitem|gibrat;31>R. Gibrat, <with|font-shape|italic|Les inegalites
    economiques>, Libraire du Recueil Sirey, Paris, 1931.

    <bibitem|pareto;97>V. Pareto, <with|font-shape|italic|Cours d'economie
    politique>, F. Rouge, Laussane, 1897.

    <bibitem|drag-yako;01>A. A. Dragulescu, V. M. Yakovenko,
    <with|font-shape|italic|Evidence for exponential distribution of income
    in the USA>, Eur. Phys. J. B <with|font-series|bold|20> 585-89.

    <bibitem|drag-yako;01a>A. A. Dragulescu, V. M. Yakovenko,
    <with|font-shape|italic|Exponential and power law probability
    distribution of wealth and income in the United Kingdom and the United
    States>,Physica A <with|font-series|bold|299> (2001) 213-221.

    <bibitem|acbkc;07>A. Chatterjee, B. K. Chakrabarti,
    <with|font-shape|italic|Kinetic exchange models for income and wealth
    distributions>, Eur. Phys. J. B <with|font-series|bold|60> (2007) 135-49.

    <bibitem|chakrabartis;10>A. S. Chakrabarti, B. K. Chakrabarti,
    <with|font-shape|italic|Statistical theories of income and wealth
    distribution>, Economics: The Open-Access, Open-Assessment E-journal 4,
    2010-4.

    <bibitem|weisbuch>G. Deffuant, F. Amblard, G. Weisbuch, T. Faure,
    <with|font-shape|italic|How can extremism prevail? A study based on the
    relative agreement interaction model>, J. Art. Soc. Soc. Simul.
    <with|font-series|bold|5> (2002) 4. G. Weisbuch, G. Deffuant, F. Amblard,
    <with|font-shape|italic|Persuasion dynamics>, Physica A
    <with|font-series|bold|353> (2005) 555-75. P. Holme, M. E. J. Newman,
    <with|font-shape|italic|Nonequilibrium phase transition in the
    coevolution of networks and opinions>, Phys. Rev. E
    <with|font-series|bold|74> (2006) 056108.

    <bibitem|lallouache;10>M. Lallouache, A. S. Chakrabarti, A. Chakraborti,
    B. K. Chakrabarti, <with|font-shape|italic|Opinion formation in the
    kinetic exchange model: Spontaneous symmetry breaking transition>,
    Physical Review E <with|font-series|bold|82> (2010) 056112.

    <bibitem|chakraborti;00>A. Chakraborti, B. K. Chakrabarti,
    <with|font-shape|italic|Statistical mechanics of money; How savings
    propensity affects its distribution>, Eur. Phys. J. B
    <with|font-series|bold|17> (2000) 167-170.

    <bibitem|richmond;05>P. Repetowicz, S. Hutzler, P. Richmond,
    <with|font-shape|italic|Dynamics of money and income distributions>,
    Physica A <with|font-series|bold|356> (2005) 641-54.

    <bibitem|chatterjee;04>A. Chatterjee, B. K. Chakrabarti, S. S. Manna,
    <with|font-shape|italic|Pareto law in a kinetic model of market with
    random saving propensity>, Physica A <with|font-series|bold|335> (2004)
    155-163.

    <bibitem|sen;10>P. Sen, <with|font-shape|italic|Phase transitions in a
    two parameter model of opinion dynamics with random kinetic exchanges>,
    arXiv:1009.4315.

    <bibitem|biswas;10>S. Biswas, A. K. Chandra, A. Chatterjee,
    <with|font-shape|italic|Phase transition and non-equilibrium relaxation
    in kinetic models of opinion formation>, arXiv:1010.3190.
  </thebibliography>
</body>