<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <doc-data|<doc-title|Stability in the Busemann-Petty and Shephard
  problems>|<doc-author|<author-data|<author-name|Alexander
  Koldobsky>|<author-affiliation|Department of
  Mathematics<next-line>University of Missouri<next-line>Columbia, MO
  65211>|<author-email|koldobskiya@@missouri.edu>>>>

  <abstract-data|<\abstract>
    A comparison problem for volumes of convex bodies asks whether
    inequalities <math|f<rsub|K><around|(|\<xi\>|)>\<le\>f<rsub|L><around|(|\<xi\>|)>>
    for all <math|\<xi\>\<in\>S<rsup|n-1>> imply that
    <math|<vol><rsub|n><around|(|K|)>\<le\><vol><rsub|n><around|(|L|)>>,
    where <math|K,L> are convex bodies in <math|<R><rsup|n>>, and
    <math|f<rsub|K>> is a certain geometric characteristic of <math|K>. By
    linear stability in comparison problems we mean that there exists a
    constant <math|c> such that for every <math|<e>\<gtr\>0>, the
    inequalities <math|f<rsub|K><around|(|\<xi\>|)>\<le\>f<rsub|L><around|(|\<xi\>|)>+<e>>
    for all <math|\<xi\>\<in\>S<rsup|n-1>> imply that
    <math|<around*|(|<vol><rsub|n><around|(|K|)>|)><rsup|<frac|n-1|n>>\<le\><around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|n-1|n>>+c<e>>.

    We prove such results in the settings of the Busemann-Petty and Shephard
    problems and their generalizations. We consider the section function
    <math|f<rsub|K><around|(|\<xi\>|)>=S<rsub|K><around|(|\<xi\>|)>=<vol><rsub|n-1><around|(|K\<cap\>\<xi\><rsup|\<bot\>>|)>>
    and the projection function <math|f<rsub|K><around|(|\<xi\>|)>=P<rsub|K><around|(|\<xi\>|)>=<vol><rsub|n-1><around|(|K\|\<xi\><rsup|\<bot\>>|)>>,
    where <math|\<xi\><rsup|\<perp\>>> is the central hyperplane
    perpendicular to <math|\<xi\>>, and <math|K\|\<xi\><rsup|\<bot\>>> is the
    orthogonal projection of <math|K> to <math|\<xi\><rsup|\<bot\>>>. In
    these two cases we prove linear stability under additional conditions
    that <math|K> is an intersection body or <math|L> is a projection body,
    respectively. Then we consider other functions <math|f<rsub|K>>, which
    allows to remove the additional conditions on the bodies in higher
    dimensions.
  </abstract>>

  <assign|R|<macro|\<bbb-R\>>><assign|Z|<macro|\<bbb-Z\>>><assign|C|<macro|\<bbb-C\>>><assign|trace|<macro|<with|font-family|rm|trace>>><assign|Ex|<macro|\<bbb-E\>>><assign|Prob|<macro|\<bbb-P\>>><assign|E|<macro|\<cal-E\>>><assign|F|<macro|\<cal-F\>>><new-theorem|df|Definition><new-theorem|theorem|Theorem><new-theorem|lemma|Lemma><new-theorem|pr|Proposition><new-theorem|co|Corollary><assign|n|<macro|\<nu\>>><assign|sign|<macro|sign
  >><assign|a|<macro|\<alpha\>>><assign|N|<macro|\<bbb-N\>>><assign|A|<macro|\<cal-A\>>><assign|L|<macro|\<cal-L\>>><assign|X|<macro|\<cal-X\>>><assign|F|<macro|\<cal-F\>>><assign|c|<macro|<wide|c|\<bar\>>>><assign|v|<macro|\<nu\>>><assign|d|<macro|\<delta\>>><assign|diam|<macro|<with|font-family|rm|dim>>><assign|vol|<macro|<with|font-family|rm|Vol>>><assign|b|<macro|\<beta\>>><assign|t|<macro|\<theta\>>><assign|l|<macro|\<lambda\>>><assign|e|<macro|\<varepsilon\>>><assign|colon|<macro|:<space|0.27em>>><assign|pf|<macro|<no-indent><with|font-series|bold|Proof
  : \ >>>

  <\assign|endpf>
    <\macro>
      <right-aligned|<math|\<Box\>><next-line>>
    </macro>
  </assign>

  <section|Introduction>

  A typical comparison problem for the volume of convex bodies asks whether
  inequalities

  <\equation*>
    f<rsub|K><around|(|\<xi\>|)>\<le\>f<rsub|L><around|(|\<xi\>|)>,<space|2em>\<forall\>\<xi\>\<in\>S<rsup|n-1>
  </equation*>

  imply <math|<vol><rsub|n><around|(|K|)>\<le\><vol><rsub|n><around|(|L|)>>
  for any <math|K,L> from a certain class of origin-symmteric convex bodies
  in <math|<R><rsup|n>>, where <math|f<rsub|K>> is a certain geometric
  characteristic of <math|K> and <math|<vol><rsub|n>> is the
  <math|n>-dimensional volume.

  If <math|f<rsub|K>=S<rsub|K>> is the section function of <math|K> defined
  by

  <\equation*>
    S<rsub|K><around|(|\<xi\>|)>=<vol><rsub|n-1><around|(|K\<cap\>\<xi\><rsup|\<perp\>>|)>,<space|2em>\<xi\>\<in\>S<rsup|n-1>,
  </equation*>

  where <math|\<xi\><rsup|\<perp\>>> is the central hyperplane in
  <math|<R><rsup|n>> orthogonal to <math|\<xi\>>, the corresponding
  comparison question is the matter of the Busemann-Petty problem, raised in
  1956 in <cite|BP> and solved in the end of the 1990's as the result of a
  sequence of papers <cite|LR>, <cite|Ba>, <cite|Gi>, <cite|Bo>, <cite|L>,
  <cite|Pa>, <cite|G1>, <cite|G2>, <cite|Z1>, <cite|Z2>, <cite|K2>,
  <cite|K3>, <cite|Z3>, <cite|GKS> ; see <cite-detail|K4|p. 3> or
  <cite-detail|G3|p. 343> for the history of the solution. The answer is
  affirmative if <math|n\<le\>4>, and it is negative if <math|n\<ge\>5>.

  Another example is the Shephard problem with <math|f<rsub|K>=P<rsub|K>>
  being the projection function

  <\equation*>
    P<rsub|K><around|(|\<xi\>|)>=<vol><rsub|n-1><around|(|K\|\<xi\><rsup|\<perp\>>|)>,<space|2em>\<xi\>\<in\>S<rsup|n-1>,
  </equation*>

  where <math|K\|\<xi\><rsup|\<perp\>>> is the orthogonal projection of
  <math|K> to the hyperplane <math|\<xi\><rsup|\<perp\>>>. The Shephard
  problem was posed in 1964 in <cite|Sh> and solved soon after that by Petty
  <cite|Pe> and Schneider <cite|S1>. The answer if affirmative only in
  dimension 2.

  Since the answers to the Busemann-Petty and Shephard problems are negative
  in most dimensions, one may ask what information about the functions
  <math|S<rsub|K>> and <math|P<rsub|K>> does allow to compare the volumes in
  all dimensions. In the section case an answer to this question was given in
  <cite|KYY>: for two origin-symmetric infinitely smooth bodies <math|K,L> in
  <math|<R><rsup|n>> and <math|\<alpha\>\<in\><around|[|n-4,n-1|)>> the
  inequalities

  <eqnarray|<tformat|<table|<row|<cell|(-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|K><around|(|\<xi\>|)>\<le\>(-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|L><around|(|\<xi\>|)>,<space|2em>\<forall\>\<xi\>\<in\>S<rsup|n-1><eq-number><label|eqn:condition1>>>>>>

  imply that <math|<vol><rsub|n><around|(|K|)>\<le\><vol><rsub|n><around|(|L|)>>,
  while for <math|\<alpha\>\<less\>n-4> this is not necessarily true. Here
  <math|\<Delta\>> is the Laplace operator on <math|<R><rsup|n>>, and the
  fractional powers of the Laplacian are defined by

  <\equation*>
    (-\<Delta\>)<rsup|\<alpha\>/2>f=<frac|1|<around|(|2*\<pi\>|)><rsup|n>>*<around|(|<around|\||x|\|><rsub|2><rsup|\<alpha\>>*<wide|f|^><around|(|x|)>|)><rsup|\<wedge\>>,
  </equation*>

  where the Fourier transform is considered in the sense of distributions,
  <math|<around|\||x|\|><rsub|2>> stands for the Euclidean norm in
  <math|<R><rsup|n>>, and the functions <math|S<rsub|K>> and <math|S<rsub|L>>
  are extended in (<reference|eqn:condition1>) to homogeneous functions of
  degree -1 on the whole <math|<R><rsup|n>>. This result contains the
  solution to the original Busemann-Petty problem as a particular case and
  means that one has to differentiate the section functions at least
  <math|n-4> times in order to compare the <math|n>-dimensional volumes.

  The situation is different for projections where a similar extension does
  not directly generalize the solution to Shephard's problem. Yaskin <cite|Y>
  proved that for <math|\<alpha\>\<in\><around|[|n,n+1|)>> the inequalities

  <eqnarray|<tformat|<table|<row|<cell|(-\<Delta\>)<rsup|\<alpha\>/2>P<rsub|K><around|(|\<xi\>|)>\<ge\>(-\<Delta\>)<rsup|\<alpha\>/2>P<rsub|L><around|(|\<xi\>|)>,<space|2em>\<forall\>\<xi\>\<in\>S<rsup|n-1><eq-number><label|eqn:condition2>>>>>>

  imply that <math|<vol><rsub|n><around|(|K|)>\<le\><vol><rsub|n><around|(|L|)>>,
  where the projection functions are extended to homogeneous functions of
  degree 1 on the whole <math|<R><rsup|n>>. The latter result is no longer
  true for <math|\<alpha\>\<in\><around|[|n-2,n|)>>, which would be a natural
  extension of the solution to the original Shephard's problem. <medbreak>In
  this article we study the flexibility of the results mentioned above. By
  <with|font-shape|italic|linear stability> in a comparison result we mean
  that there exists a constant <math|c> such that for any <math|K,L> from
  certain classes of convex bodies and every <math|<e>\<gtr\>0> the
  inequalities

  <\equation*>
    f<rsub|K><around|(|\<xi\>|)>\<le\>f<rsub|L><around|(|\<xi\>|)>+<e>,<space|2em>\<forall\>\<xi\>\<in\>S<rsup|n-1>
  </equation*>

  imply

  <\equation*>
    <vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>\<le\><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>+c<e>.
  </equation*>

  We also consider <with|font-shape|italic|linear separation> in comparison
  problems, where we are looking for a constant <math|c> such that for any
  <math|K,L> from certain classes of convex bodies and every
  <math|<e>\<gtr\>0> the inequalities

  <\equation*>
    f<rsub|K><around|(|\<xi\>|)>\<le\>f<rsub|L><around|(|\<xi\>|)>-<e>,<space|2em>\<forall\>\<xi\>\<in\>S<rsup|n-1>
  </equation*>

  imply

  <\equation*>
    <vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>\<le\><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>-c<e>.
  </equation*>

  We first prove linear stability and separation for the section function
  <math|f<rsub|K>=S<rsub|K>> under the additional assumption that <math|K> is
  an intersection body. In the stability result the constant <math|c=1>, but
  in the case of separation <math|c> depends on the inradius of <math|K> and
  on the dimension <math|n>. Since every origin-symmetric convex body in
  <math|<R><rsup|n>,2\<le\>n\<le\>4> is an intersection body, in these
  dimensions the results apply to arbitrary origin-symmetric convex bodies
  <math|K,L>. An easy consequence (see Corollary <reference|n4>) is that for
  <math|2\<le\>n\<le\>4> and any origin-symmetric convex bodies <math|K,L> in
  <math|<R><rsup|n>>,

  <\equation*>
    <around*|\||<vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>-<vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>|\|>\<le\><around|\<\|\|\>|S<rsub|K>-S<rsub|L>|\<\|\|\>><rsub|C<around|(|S<rsup|n-1>|)>>.
  </equation*>

  We also prove linear stability and separation for the projection function
  <math|f<rsub|K>=P<rsub|K>> under the additional assumption that <math|L> is
  a projection body. Here in the stability result the constant <math|c>
  depends on <math|n> and on the circumradius of <math|L>, while in the case
  of separation we have <math|c=<sqrt|1/e>>.

  In order to remove the additional assumptions on the bodies and make the
  results work in general in higher dimensions, we prove linear stability and
  separation in the results from <cite|KYY> and <cite|Y> mentioned above. We
  consider the cases where

  <\equation*>
    f<rsub|K>=(-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|K>,<space|2em>\<alpha\>\<in\><around|[|n-4,n-1|)>
  </equation*>

  and

  <\equation*>
    f<rsub|K>=(-\<Delta\>)<rsup|\<alpha\>/2>P<rsub|K>,<space|2em>\<alpha\>\<in\><around|[|n,n+1|)>,
  </equation*>

  and <math|K,L> are arbitrary infinitely smooth convex bodies in
  <math|<R><rsup|n>>. In the stability case the constant <math|c> for
  sections depends only on <math|\<alpha\>> and <math|n>, while for
  projections the constant also depends on the circumradius of <math|L>. In
  the separation case, <math|c> depends only on <math|\<alpha\>> and <math|n>
  for projections, and also depends on the inradius of <math|K> for sections.

  In most cases we employ the techniques of the Fourier analytic approach to
  sections and projections that has recently been developed; see <cite|K4>
  and <cite|KY>. We use a more geometric Radon transform approach in the case
  <math|f<rsub|K>=S<rsub|K>> to show the variety of methods, it is also
  possible to solve this case with the Fourier transform.

  <section|Stability and separation for sections>

  We say that a closed bounded set <math|K> in <math|<R><rsup|n>> is a
  <with|font-shape|italic|star body> if every straight line passing through
  the origin crosses the boundary of <math|K> at exactly two points different
  from the origin, the origin is an interior point of <math|K>, and the
  <with|font-shape|italic|Minkowski functional> of <math|K> defined by

  <\equation*>
    <around|\<\|\|\>|x|\<\|\|\>><rsub|K>=min <around|{|a\<ge\>0:x\<in\>a*K|}>
  </equation*>

  is a continuous function on <math|<R><rsup|n>>.

  The <with|font-shape|italic|radial function> of a star body <math|K> is
  defined by

  <\equation*>
    \<rho\><rsub|K><around|(|x|)>=<around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>,<space|2em>x\<in\><R><rsup|n>.
  </equation*>

  If <math|x\<in\>S<rsup|n-1>> then <math|\<rho\><rsub|K><around|(|x|)>> is
  the radius of <math|K> in the direction of <math|x>.

  Writing the volume of <math|K> in polar coordinates, one gets

  <\equation>
    <label|polar-volume><vol><rsub|n><around|(|K|)>=<frac|1|n>*<big|int><rsub|S<rsup|n-1>>\<rho\><rsub|K><rsup|n><around|(|\<theta\>|)>*d*\<theta\>=<frac|1|n>*<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|\<theta\>|\<\|\|\>><rsub|K><rsup|-n>*d*\<theta\>.
  </equation>

  The <with|font-shape|italic|spherical Radon transform>
  <math|R:C<around|(|S<rsup|n-1>|)>\<mapsto\>C<around|(|S<rsup|n-1>|)>> is a
  linear operator defined by

  <\equation*>
    R*f<around|(|\<xi\>|)>=<big|int><rsub|S<rsup|n-1>\<cap\>\<xi\><rsup|\<bot\>>>f<around|(|x|)>*d*x,<space|1em>\<xi\>\<in\>S<rsup|n-1>
  </equation*>

  for every function <math|f\<in\>C<around|(|S<rsup|n-1>|)>>.

  The polar formula for the volume of a hyperplane section expresses this
  volume in terms of the spherical Radon transform (see for example
  <cite-detail|K4|p.15>):

  <\equation>
    <label|volume=spherradon>S<rsub|K><around|(|\<xi\>|)>=<vol><rsub|n-1><around|(|K\<cap\>\<xi\><rsup|\<bot\>>|)>=<frac|1|n-1>*R<around|(||\<\|\|\>>\<cdot\><around|\<\|\|\>|<rsub|K><rsup|-n+1>|)><around|(|\<xi\>|)>.
  </equation>

  The spherical Radon transform is self-dual (see <cite-detail|Gr|Lemma
  1.3.3> ): for any functions <math|f,g\<in\>C<around|(|S<rsup|n-1>|)>>

  <\equation>
    <label|selfdual><big|int><rsub|S<rsup|n-1>>R*f<around|(|\<xi\>|)>*g<around|(|\<xi\>|)>*d*\<xi\>=<big|int><rsub|S<rsup|n-1>>f<around|(|\<xi\>|)>*R*g<around|(|\<xi\>|)>*d*\<xi\>.
  </equation>

  The spherical Radon transform can be extended to measures. Let
  <math|\<mu\>> be a finite Borel measure on <math|S<rsup|n-1>>. We define
  the spherical Radon transform of <math|\<mu\>> as a functional
  <math|R*\<mu\>> on the space <math|C<around|(|S<rsup|n-1>|)>> acting by

  <\equation*>
    <around|(|R*\<mu\>,f|)>=<around|(|\<mu\>,R*f|)>=<big|int><rsub|S<rsup|n-1>>R*f<around|(|x|)>*d*\<mu\><around|(|x|)>.
  </equation*>

  By Riesz's characterization of continuous linear functionals on the space
  <math|C<around|(|S<rsup|n-1>|)>>, <math|R*\<mu\>> is also a finite Borel
  measure on <math|S<rsup|n-1>>. If <math|\<mu\>> has continuous density
  <math|g>, then by (<reference|selfdual>) the Radon transform of
  <math|\<mu\>> has density <math|R*g>.

  The class of intersection bodies was introduced by Lutwak <cite|L>. Let
  <math|K,L> be origin-symmetric star bodies in <math|<R><rsup|n>>. We say
  that <math|K> is the intersection body of <math|L> if the radius of
  <math|K> in every direction is equal to the
  <math|<around|(|n-1|)>>-dimensional volume of the section of <math|L> by
  the central hyperplane orthogonal to this direction, i.e. for every
  <math|\<xi\>\<in\>S<rsup|n-1>>,

  <\equation>
    <label|intbodyofstar>\<rho\><rsub|K><around|(|\<xi\>|)>=<around|\<\|\|\>|\<xi\>|\<\|\|\>><rsub|K><rsup|-1>=<vol><rsub|n-1><around|(|L\<cap\>\<xi\><rsup|\<bot\>>|)>.
  </equation>

  <index|intersection body of a star body>All the bodies <math|K> that appear
  as intersection bodies of different star bodies form
  <with|font-shape|italic|the class of intersection bodies of star bodies>.

  Note that the right-hand side of (<reference|intbodyofstar>) can be written
  using (<reference|volume=spherradon>):

  <\equation*>
    <around|\<\|\|\>|\<xi\>|\<\|\|\>><rsub|K><rsup|-1>=<frac|1|n-1>*<big|int><rsub|S<rsup|n-1>\<cap\>\<xi\><rsup|\<bot\>>><around|\<\|\|\>|\<theta\>|\<\|\|\>><rsub|L><rsup|-n+1>*d*\<theta\>=<frac|1|n-1>*R<around|(||\<\|\|\>>\<cdot\><around|\<\|\|\>|<rsub|L><rsup|-n+1>|)><around|(|\<xi\>|)>,
  </equation*>

  where <math|R> is the spherical Radon transform. It means that a star body
  <math|K> is the intersection body of a star body if and only if the
  function <math|<around|\<\|\|\>|\<cdummy\>|\<\|\|\>><rsub|K><rsup|-1>> is
  the spherical Radon transform of a continuous positive function on
  <math|S<rsup|n-1>>. This allows us to introduce a more general class of
  bodies. We say that a star body <math|K> in <math|<R><rsup|n>> is an
  <with|font-shape|italic|intersection body> if there exists a finite Borel
  measure<index|intersection body><math|\<mu\>> on the sphere
  <math|S<rsup|n-1>> so that <math|<around|\<\|\|\>|\<cdummy\>|\<\|\|\>><rsub|K><rsup|-1>=R*\<mu\>>
  as functionals on <math|C<around|(|S<rsup|n-1>|)>>, i.e. for every
  continuous function <math|f> on <math|S<rsup|n-1>>,

  <\equation>
    <label|defintbody><big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>*f<around|(|x|)>*d*x=<big|int><rsub|S<rsup|n-1>>R*f<around|(|x|)>*d*\<mu\><around|(|x|)>.
  </equation>

  Intersection bodies played the crucial role in the solution of the
  Busemann-Petty problem due to the following connection found by Lutwak
  <cite|L>: if <math|K> in an origin-symmetric intersection body in
  <math|<R><rsup|n>> and <math|L> is any origin-symmetric star body in
  <math|<R><rsup|n>>, then the inequalities
  <math|S<rsub|K><around|(|\<xi\>|)>\<le\>S<rsub|L><around|(|\<xi\>|)>> for
  all <math|\<xi\>\<in\>S<rsup|n-1>> imply that
  <math|<vol><rsub|n><around|(|K|)>\<le\><vol><rsub|n><around|(|L|)>>, i.e.
  the answer to the Busemann-Petty problem in this situation is affirmative.
  For more information about intersection bodies, see <cite-detail|K4|Ch.4>,
  <cite|KY>, <cite-detail|G3|Ch.8> and references there.

  In this section we prove the stability of Lutwak's connection. First, we
  need some simple facts about the <math|\<Gamma\>>-function.

  <\lemma>
    <label|gammafunction>For any <math|n\<in\><N>>, the following
    inequalities hold:

    <\equation*>
      1\<le\><frac|<around*|(|\<Gamma\>*<around|(|<frac|n|2>+1|)>|)><rsup|<frac|n-1|n>>|\<Gamma\><around|(|<frac|n+1|2>|)>>\<le\><sqrt|e>,
    </equation*>

    <\equation*>
      <frac|\<Gamma\><around|(|<frac|n-1|2>|)>|<around*|(|\<Gamma\><around|(|<frac|n|2>|)>|)><rsup|<frac|n-1|n>>>\<le\><frac|n<rsup|<frac|n-1|n>>*2<rsup|<frac|1|n>>|n-1>
    </equation*>

    and

    <\equation*>
      <sqrt|<frac|n|2>>\<le\><frac|\<Gamma\>*<around|(|<frac|n|2>+1|)>|\<Gamma\><around|(|<frac|n+1|2>|)>>\<le\><sqrt|<frac|n+1|2>>.
    </equation*>
  </lemma>

  <pf>The the first inequality see for example <cite-detail|KL|Lemma 2.1>.
  The second inequality is a simple modification of the lower estimate in the
  first, using the property <math|\<Gamma\>*<around|(|x+1|)>=x*\<Gamma\><around|(|x|)>>
  of the <math|\<Gamma\>>-function.

  The third inequality follows from log-convexity of the
  <math|\<Gamma\>>-function (see <cite-detail|K4|p.30>):

  <\equation*>
    \<Gamma\><rsup|2>*<around*|(|<frac|n|2>+1|)>\<le\>\<Gamma\><around*|(|<frac|n+3|2>|)>*\<Gamma\><around*|(|<frac|n+1|2>|)>=<around*|(|<frac|n+1|2>|)>*\<Gamma\><rsup|2><around*|(|<frac|n+1|2>|)>,
  </equation*>

  and

  <\equation*>
    \<Gamma\><rsup|2><around*|(|<frac|n+1|2>|)>\<le\>\<Gamma\>*<around*|(|<frac|n|2>+1|)>*\<Gamma\><around*|(|<frac|n|2>|)>=<frac|2|n>*\<Gamma\><rsup|2>*<around*|(|<frac|n|2>+1|)>.*\<Box\>
  </equation*>

  <bigbreak>

  <\theorem>
    <label|main-int>Suppose that <math|<e>\<gtr\>0>, <math|K> and <math|L>
    are origin-symmetric star bodies in <math|<R><rsup|n>>, and <math|K> is
    an intersection body. If for every <math|\<xi\>\<in\>S<rsup|n-1>>

    <eqnarray|<tformat|<table|<row|<cell|S<rsub|K><around|(|\<xi\>|)>\<le\>S<rsub|L><around|(|\<xi\>|)>+<e>,<eq-number><label|sect1>>>>>>

    then

    <\equation*>
      <vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>\<le\><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>+<e>.
    </equation*>
  </theorem>

  <pf>By (<reference|volume=spherradon>), the condition (<reference|sect1>)
  can be written as

  <\equation>
    <label|radon-buspetty>R<around|(||\<\|\|\>>\<cdot\><around|\<\|\|\>|<rsub|K><rsup|-n+1>|)><around|(|\<xi\>|)>\<le\>R<around|(||\<\|\|\>>\<cdot\><around|\<\|\|\>|<rsub|L><rsup|-n+1>|)><around|(|\<xi\>|)>+<around|(|n-1|)><e>,\<forall\>\<xi\>\<in\>S<rsup|n-1>.
  </equation>

  Since <math|K> is an intersection body, there exists a finite Borel measure
  <math|\<mu\>> on <math|S<rsup|n-1>> such that
  <math|<around|\<\|\|\>|\<cdummy\>|\<\|\|\>><rsub|K><rsup|-1>=R*\<mu\>> as
  functionals on <math|C<around|(|S<rsup|n-1>|)>>. Together with
  (<reference|polar-volume>), (<reference|radon-buspetty>) and the definition
  of <math|R*\<mu\>>, the latter implies that

  <\equation*>
    n<vol><rsub|n><around|(|K|)>=<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n+1>*d*x
  </equation*>

  <\equation*>
    =<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n+1>*d*<around|(|R*\<mu\>|)><around|(|x|)>=<big|int><rsub|S<rsup|n-1>>R<around*|(||\<\|\|\>>\<cdot\><around*|\<\|\|\>|<rsub|K><rsup|-n+1>|)><around|(|\<xi\>|)>*d*\<mu\><around|(|\<xi\>|)>
  </equation*>

  <\equation*>
    \<le\><big|int><rsub|S<rsup|n-1>>R<around*|(||\<\|\|\>>\<cdot\><around*|\<\|\|\>|<rsub|L><rsup|-n+1>|)><around|(|\<xi\>|)>*d*\<mu\><around|(|\<xi\>|)>+<around|(|n-1|)><e><big|int><rsub|S<rsup|n-1>>d*\<mu\><around|(|\<xi\>|)>
  </equation*>

  <\equation>
    <label|eq11>=<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1><around|\<\|\|\>|x|\<\|\|\>><rsub|L><rsup|-n+1>*d*x+<around|(|n-1|)><e><big|int><rsub|S<rsup|n-1>>d*\<mu\><around|(|x|)>.
  </equation>

  We estimate the first term in (<reference|eq11>) using Hlder's inequality:

  <\equation*>
    <big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1><around|\<\|\|\>|x|\<\|\|\>><rsub|L><rsup|-n+1>*d*x\<le\><around*|(|<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n>*d*x|)><rsup|<frac|1|n>><around*|(|<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|L><rsup|-n>*d*x|)><rsup|<frac|n-1|n>>
  </equation*>

  <\equation>
    <label|eq12>=n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>.
  </equation>

  We now estimate the second term in (<reference|eq11>) adding the Radon
  transform of the unit constant function under the integral
  (<math|R*1<around|(|x|)>=<around*|\||S<rsup|n-2>|\|>> for every
  <math|x\<in\>S<rsup|n-1>>), using again the fact that
  <math|<around|\<\|\|\>|\<cdummy\>|\<\|\|\>><rsub|K><rsup|-1>=R*\<mu\>> and
  then applying Hlder's inequality:

  <\equation>
    <label|eq55><around|(|n-1|)><e><big|int><rsub|S<rsup|n-1>>d*\<mu\><around|(|x|)>=<frac|<around|(|n-1|)><e>|<around*|\||S<rsup|n-2>|\|>>*<big|int><rsub|S<rsup|n-1>>R*1<around|(|x|)>*d*\<mu\><around|(|x|)>
  </equation>

  <\equation*>
    =<frac|<around|(|n-1|)><e>|<around*|\||S<rsup|n-2>|\|>>*<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>*d*x
  </equation*>

  <\equation>
    <label|eq13>\<le\><frac|<around|(|n-1|)><e>|<around*|\||S<rsup|n-2>|\|>><around*|\||S<rsup|n-1>|\|><rsup|<frac|n-1|n>><around*|(|<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n>*d*x|)><rsup|<frac|1|n>>,
  </equation>

  where

  <\equation*>
    <around*|\||S<rsup|n-2>|\|>=<frac|2*\<pi\><rsup|<frac|n-1|2>>|\<Gamma\><around|(|<frac|n-1|2>|)>><space|2em><math-up|and><space|2em><around*|\||S<rsup|n-1>|\|>=<frac|2*\<pi\><rsup|<frac|n|2>>|\<Gamma\><around|(|<frac|n|2>|)>>
  </equation*>

  are the surface areas of the unit spheres in <math|<R><rsup|n-1>> and
  <math|<R><rsup|n>>, correspondingly.

  We get that the quantity in (<reference|eq13>) is equal to

  <\equation*>
    <frac|<around|(|n-1|)>*\<Gamma\><around|(|<frac|n-1|2>|)>|2<rsup|<frac|1|n>><around*|(|\<Gamma\><around|(|<frac|n|2>|)>|)><rsup|<frac|n-1|n>>><e><around*|(|n<vol><rsub|n><around|(|K|)>|)><rsup|<frac|1|n>>\<le\>n<e><around*|(|<vol><rsub|n><around|(|K|)>|)><rsup|<frac|1|n>>
  </equation*>

  by the second inequality of Lemma <reference|gammafunction>.

  Combining the latter inequality with (<reference|eq11>) and
  (<reference|eq12>),

  <\equation*>
    n<vol><rsub|n><around|(|K|)>\<le\>n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>+n<e><around*|(|<vol><rsub|n><around|(|K|)>|)><rsup|<frac|1|n>>.*\<Box\>
  </equation*>

  <bigbreak>It is known that for <math|2\<le\>n\<le\>4> every origin
  symmetric convex body in <math|<R><rsup|n>> is an intersection body (see
  <cite|G2>, <cite|Z3>, <cite|GKS> or <cite-detail|K4|p. 73>). This means
  that the result of Theorem <reference|main-int> holds in these dimensions
  for arbitrary origin-symmetric convex bodies <math|K,L>. Moreover,
  interchanging <math|K,L> in Theorem <reference|main-int>, we prove

  <\co>
    <label|n4>If <math|2\<le\>n\<le\>4>, then for any origin-symmetric convex
    bodies <math|K,L> in <math|<R><rsup|n>>,

    <\equation*>
      <around*|\||<vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>-<vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>|\|>\<le\><around|\<\|\|\>|S<rsub|K>-S<rsub|L>|\<\|\|\>><rsub|C<around|(|S<rsup|n-1>|)>>.
    </equation*>
  </co>

  <bigbreak>

  We now prove the linear separation property of Lutwak's connection. Denote
  by

  <\equation*>
    r<around|(|K|)>=<frac|min<rsub|\<xi\>\<in\>S<rsup|n-1>>
    \<rho\><rsub|K><around|(|\<xi\>|)>|<vol><rsub|n><around|(|K|)><rsup|1/n>>
  </equation*>

  the normalized inradius of <math|K>.

  <\theorem>
    <label|main-int1>Let <math|K> and <math|L> be origin-symmetric star
    bodies in <math|<R><rsup|n>> and <math|<e>\<gtr\>0>. Assume that <math|K>
    is an intersection body. If for every <math|\<xi\>\<in\>S<rsup|n-1>>

    <eqnarray|<tformat|<table|<row|<cell|S<rsub|K><around|(|\<xi\>|)>\<le\>S<rsub|L><around|(|\<xi\>|)>-<e>,<eq-number><label|sect2>>>>>>

    then

    <\equation*>
      <vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>\<le\><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>-<sqrt|<frac|2*\<pi\>|n+1>>*r<around|(|K|)><e>.
    </equation*>
  </theorem>

  <pf>The proof goes along the same lines as that of Theorem
  <reference|main-int>, with the difference that now we need a lower estimate
  in place of the upper estimate (<reference|eq13>). Similarly to
  (<reference|eq11>) and (<reference|eq12>), we get

  <\equation>
    <label|same>n<vol><rsub|n><around|(|K|)>\<le\>n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>-<around|(|n-1|)><e><big|int><rsub|S<rsup|n-1>>d*\<mu\><around|(|x|)>.
  </equation>

  Similarly to (<reference|eq55>),

  <\equation*>
    <around|(|n-1|)><e><big|int><rsub|S<rsup|n-1>>d*\<mu\><around|(|x|)>=<frac|<around|(|n-1|)><e>|<around*|\||S<rsup|n-2>|\|>>*<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>*d*x,
  </equation*>

  and, since <math|<around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>=\<rho\><rsub|K><around|(|x|)>>
  for <math|x\<in\>S<rsup|n-1>>, using the definition of
  <math|r<around|(|K|)>> we estimate the latter by

  <\equation*>
    \<ge\><frac|<e><around|(|n-1|)>*r<around|(|K|)><vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><around*|\||S<rsup|n-1>|\|>|<around*|\||S<rsup|n-2>|\|>>
  </equation*>

  <\equation*>
    =<e>r<around|(|K|)>*n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><frac|<around|(|n-1|)>*\<pi\><rsup|<frac|n|2>>*\<Gamma\><around|(|<frac|n-1|2>|)>|n*\<pi\><rsup|<frac|n-1|2>>*\<Gamma\><around|(|<frac|n|2>|)>>
  </equation*>

  (we multipiled and divided by <math|n> and now use
  <math|\<Gamma\>*<around|(|x+1|)>=x*\<Gamma\><around|(|x|)>> and the third
  inequality of Lemma <reference|gammafunction>)

  <\equation*>
    =<e>r<around|(|K|)>*n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><sqrt|\<pi\>>*<frac|\<Gamma\><around|(|<frac|n+1|2>|)>|\<Gamma\>*<around|(|<frac|n|2>+1|)>>\<ge\><e>r<around|(|K|)>*n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><sqrt|<frac|2*\<pi\>|n+1>>.
  </equation*>

  Combining this with (<reference|same>), we get

  <\equation*>
    n<vol><rsub|n><around|(|K|)>\<le\>n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>-n<e>r<around|(|K|)><vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><sqrt|<frac|2*\<pi\>|n+1>>.*\<Box\>
  </equation*>

  <bigbreak>

  We now pass to stability in the comparison result from [KYY]. The goal here
  is to establish stability of volume comparison in dimensions higher than 4
  without the assumption that <math|K> is an intersection body. We use the
  techniques of the Fourier approach to sections of convex bodies that has
  recently been developed; see <cite|K4> and <cite|KY>.

  The Fourier transform of a distribution <math|f> is defined by
  <math|<around|\<langle\>|<wide|f|^>,\<phi\>|\<rangle\>>=<around|\<langle\>|f,<wide|\<phi\>|^>|\<rangle\>>>
  for every test function <math|\<phi\>> from the Schwartz space
  <math|\<cal-S\>> of rapidly decreasing infinitely differentiable functions
  on <math|<R><rsup|n>>. For any even distribution <math|f>, we have
  <math|<around|(|<wide|f|^>|)><rsup|\<wedge\>>=<around|(|2*\<pi\>|)><rsup|n>*f>.

  If <math|K> is a star body and <math|0\<less\>p\<less\>n>, then
  <math|<around|\<\|\|\>|\<cdummy\>|\<\|\|\>><rsub|K><rsup|-p>> is a locally
  integrable function on <math|<R><rsup|n>> and represents a distribution.
  Suppose that <math|K> is infinitely smooth, i.e.
  <math|<around|\<\|\|\>|\<cdummy\>|\<\|\|\>><rsub|K>\<in\>C<rsup|\<infty\>><around|(|S<rsup|n-1>|)>>
  is an infinitely differentiable function on the sphere. Then by
  <cite-detail|K4|Lemma 3.16>, the Fourier transform of
  <math|<around|\<\|\|\>|\<cdummy\>|\<\|\|\>><rsub|K><rsup|-p>> is an
  extension of some function <math|g\<in\>C<rsup|\<infty\>><around|(|S<rsup|n-1>|)>>
  to a homogeneous function of degree <math|-n+p> on <math|<R><rsup|n>>. When
  we write <math|<around*|(||\<\|\|\>>\<cdot\><around*|\<\|\|\>|<rsub|K><rsup|-p>|)><rsup|\<wedge\>><around|(|\<xi\>|)>>,
  we mean <math|g<around|(|\<xi\>|)>,\<xi\>\<in\>S<rsup|n-1>>. If <math|K,L>
  are infinitely smooth star bodies, the following spherical version of
  Parseval's formula was proved in <cite|K5> (see <cite-detail|K4|Lemma
  3.22>): for any <math|p\<in\>(-n,0>)

  <\equation>
    <label|parseval><big|int><rsub|S<rsup|n-1>><around*|(||\<\|\|\>>\<cdot\><around*|\<\|\|\>|<rsub|K><rsup|-p>|)><rsup|\<wedge\>><around|(|\<xi\>|)><around*|(||\<\|\|\>>\<cdot\><around*|\<\|\|\>|<rsub|L><rsup|-n+p>|)><rsup|\<wedge\>><around|(|\<xi\>|)>=<around|(|2*\<pi\>|)><rsup|n>*<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-p><around|\<\|\|\>|x|\<\|\|\>><rsub|L><rsup|-n+p>*d*x.
  </equation>

  A distribution is called <with|font-shape|italic|positive definite> if its
  Fourier transform is a positive distribution in the sense that
  <math|<around|\<langle\>|<wide|f|^>,\<phi\>|\<rangle\>>\<ge\>0> for every
  non-negative test function <math|\<phi\>>. The following was proved in
  <cite|KYY>:

  <\lemma>
    <label|Lem:pos-def><with|font-series|bold|(<cite-detail|KYY|Lemma 2.3>)>
    Let <math|K> be an origin-symmetric convex body in <math|<R><rsup|n>>.
    Assume that <math|\<alpha\>\<in\><around|[|n-4,n-1|)>>, then
    <math|<around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>\<cdot\><around|\||x|\|><rsup|-\<alpha\>><rsub|2>>
    is a positive definite distribution on <math|<R><rsup|n>>.
  </lemma>

  If <math|K> is infinitely smooth, by Lemma <reference|Lem:pos-def> and
  <cite-detail|K4|Lemma 3.16>, the Fourier transform
  <math|<around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>>>
  is an extension of a non-negative infinitely differentiable function on
  <math|S<rsup|n-1>> to the whole <math|<R><rsup|n>>.

  <\theorem>
    <label|main>Let <math|<e>\<gtr\>0,\<alpha\>\<in\><around|[|n-4,n-1|)>>,
    and let <math|K> and <math|L> be origin-symmetric infinitely smooth
    convex bodies in <math|<R><rsup|n>>, <math|n\<ge\>4>, so that for every
    <math|\<xi\>\<in\>S<rsup|n-1>>

    <eqnarray|<tformat|<table|<row|<cell|(-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|K><around|(|\<xi\>|)>\<le\>(-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|L><around|(|\<xi\>|)>+<e>.<eq-number><label|eqn:condition11>>>>>>

    Then

    <\equation*>
      <vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>\<le\><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>+c<e>,
    </equation*>

    where

    <\equation*>
      c=c<around|(|\<alpha\>,n|)>=<frac|<sqrt|\<pi\>>*<around|(|n-1|)>*\<Gamma\><around|(|<frac|n-\<alpha\>-1|2>|)>|2<rsup|\<alpha\>+<frac|1|n>>*n<rsup|<frac|n-1|n>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)><around*|(|\<Gamma\><around|(|<frac|n|2>|)>|)><rsup|<frac|n-1|n>>>.
    </equation*>
  </theorem>

  <pf>It was proved in <cite|K1> that

  <eqnarray|<tformat|<table|<row|<cell|S<rsub|K><around|(|\<xi\>|)>=<frac|1|\<pi\>*<around|(|n-1|)>><around|(|<around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n+1>|)><rsup|\<wedge\>><around|(|\<xi\>|)>,<space|2em>\<forall\>\<xi\>\<in\>S<rsup|n-1>.<eq-number><label|eqn:defS>>>>>>

  Extending <math|S<rsub|K><around|(|\<xi\>|)>> to <math|<R><rsup|n>> as a
  homogeneous function of degree <math|-1> and using the definition of
  fractional powers of the Laplacian we get

  <\equation*>
    (-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|K><around|(|\<theta\>|)>=<frac|1|\<pi\>*<around|(|n-1|)>><around|(|<around|\||x|\|><rsup|\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n+1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>,
  </equation*>

  therefore

  <\equation*>
    <around|(|2*\<pi\>|)><rsup|n>*n<vol><rsub|n><around|(|K|)>=<around|(|2*\<pi\>|)><rsup|n>*<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n+1><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>*d*x
  </equation*>

  <\equation*>
    =<around|(|2*\<pi\>|)><rsup|n>*<big|int><rsub|S<rsup|n-1>><around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><around|(|<around|\||x|\|><rsup|\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n+1>|)>*d*x
  </equation*>

  <\equation*>
    =<big|int><rsub|S<rsup|n-1>><around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>><around|(|\<theta\>|)><around|(|<around|\||x|\|><rsup|\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n+1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>*d*\<theta\>
  </equation*>

  <\equation*>
    =\<pi\>*<around|(|n-1|)>*<big|int><rsub|S<rsup|n-1>><around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>(-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|K><around|(|\<theta\>|)>*d*\<theta\>.
  </equation*>

  Here we used Parseval's formula on the sphere (<reference|parseval>). By
  Lemma <reference|Lem:pos-def>, <math|<around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>>>
  is a non-negative function on <math|S<rsup|n-1>>, and we can use
  (<reference|eqn:condition11>) to estimate the latter quantity:

  <\equation*>
    \<le\>\<pi\>*<around|(|n-1|)>*<big|int><rsub|S<rsup|n-1>><around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>(-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|L><around|(|\<theta\>|)>*d*\<theta\>
  </equation*>

  <\equation>
    <label|eq21>+\<pi\>*<around|(|n-1|)><e><big|int><rsub|S<rsup|n-1>><around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>*d*\<theta\>.
  </equation>

  Repeating the above calculation in the opposite order, we get that the
  first summand in (<reference|eq21>) is equal to

  <\equation>
    <label|eq22><around|(|2*\<pi\>|)><rsup|n>*<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|L><rsup|-n+1><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>*d*x\<le\><around|(|2*\<pi\>|)><rsup|n>*n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>
  </equation>

  by Hlder's inequality.

  To estimate the second summand in (<reference|eq21>), we use the formula
  for the Fourier transform (in the sense of distributions; see
  <cite-detail|GS|p.194>)

  <\equation*>
    <around*|(|<around|\||x|\|><rsub|2><rsup|-n+\<alpha\>+1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>=<frac|2<rsup|\<alpha\>+1>*\<pi\><rsup|<frac|n|2>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)>|\<Gamma\><around|(|<frac|n-\<alpha\>-1|2>|)>><around|\||\<theta\>|\|><rsub|2><rsup|-\<alpha\>-1>.
  </equation*>

  Again using Parseval's formula and then Hlder's inequality,

  <\equation*>
    <big|int><rsub|S<rsup|n-1>><around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>*d*\<theta\>
  </equation*>

  <\equation*>
    =<frac|\<Gamma\><around|(|<frac|n-\<alpha\>-1|2>|)>|2<rsup|\<alpha\>+1>*\<pi\><rsup|<frac|n|2>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)>>*<big|int><rsub|S<rsup|n-1>><around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>><around|(|\<theta\>|)><around*|(|<around|\||x|\|><rsub|2><rsup|-n+\<alpha\>+1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>*d*\<theta\>
  </equation*>

  <\equation*>
    =<frac|<around|(|2*\<pi\>|)><rsup|n>*\<Gamma\><around|(|<frac|n-\<alpha\>-1|2>|)>|2<rsup|\<alpha\>+1>*\<pi\><rsup|<frac|n|2>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)>>*<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>*d*x
  </equation*>

  <\equation*>
    \<le\><frac|<around|(|2*\<pi\>|)><rsup|n>*\<Gamma\><around|(|<frac|n-\<alpha\>-1|2>|)><around*|\||S<rsup|n-1>|\|><rsup|<frac|n-1|n>>|2<rsup|\<alpha\>+1>*\<pi\><rsup|<frac|n|2>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)>><around*|(|<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-n>*d*x|)><rsup|<frac|1|n>>
  </equation*>

  <\equation*>
    =<frac|<around|(|2*\<pi\>|)><rsup|n>*\<Gamma\><around|(|<frac|n-\<alpha\>-1|2>|)><around*|\||S<rsup|n-1>|\|><rsup|<frac|n-1|n>>|2<rsup|\<alpha\>+1>*\<pi\><rsup|<frac|n|2>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)>><around*|(|n<vol><rsub|n><around|(|K|)>|)><rsup|<frac|1|n>>
  </equation*>

  Combining this with (<reference|eq21>) and (<reference|eq22>), we get

  <\equation*>
    <around|(|2*\<pi\>|)><rsup|n>*n<vol><rsub|n><around|(|K|)>\<le\><around|(|2*\<pi\>|)><rsup|n>*n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>
  </equation*>

  <\equation*>
    +<frac|<around|(|2*\<pi\>|)><rsup|n><e>\<pi\>*<around|(|n-1|)>*n<rsup|<frac|1|n>>*\<Gamma\><around|(|<frac|n-\<alpha\>-1|2>|)><around*|\||S<rsup|n-1>|\|><rsup|<frac|n-1|n>>|2<rsup|\<alpha\>+1>*\<pi\><rsup|<frac|n|2>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)>><around*|(|<vol><rsub|n><around|(|K|)>|)><rsup|<frac|1|n>>,
  </equation*>

  which implies the result. <endpf>For <math|\<alpha\>\<less\>n-4> the
  statement of Theorem <reference|main> is no longer true, simply because the
  comparison result itself does not hold, as shown in <cite|KYY>.
  <bigbreak>The corresponding separation result looks as follows:

  <\theorem>
    <label|main2>Let <math|<e>\<gtr\>0,\<alpha\>\<in\><around|[|n-4,n-1|)>>,
    <math|K> and <math|L> be origin-symmetric infinitely smooth convex bodies
    in <math|<R><rsup|n>>, <math|n\<ge\>4>, so that for every
    <math|\<xi\>\<in\>S<rsup|n-1>>

    <eqnarray|<tformat|<table|<row|<cell|(-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|K><around|(|\<xi\>|)>\<le\>(-\<Delta\>)<rsup|\<alpha\>/2>S<rsub|L><around|(|\<xi\>|)>-<e>.<eq-number><label|eqn:condition>>>>>>

    Then

    <\equation*>
      <vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>\<le\><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>-c<e>,
    </equation*>

    where

    <\equation*>
      c=r<around|(|K|)><frac|\<pi\>*<around|(|n-1|)>*\<Gamma\><around|(|<frac|n-\<alpha\>-1|2>|)>|n*2<rsup|\<alpha\>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)>*\<Gamma\><around|(|<frac|n|2>|)>>.
    </equation*>
  </theorem>

  <pf>Following the proof of Theorem <reference|main>, we get

  <\equation*>
    <around|(|2*\<pi\>|)><rsup|n>*n<vol><rsub|n><around|(|K|)>\<le\><around|(|2*\<pi\>|)><rsup|n>*n<vol><rsub|n><around|(|K|)><rsup|<frac|1|n>><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>
  </equation*>

  <\equation*>
    -\<pi\>*<around|(|n-1|)><e><big|int><rsub|S<rsup|n-1>><around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>*d*\<theta\>.
  </equation*>

  The difference with the proof of Theorem <reference|main> is that now we
  have to estimate

  <\equation*>
    <big|int><rsub|S<rsup|n-1>><around|(|<around|\||x|\|><rsup|-\<alpha\>><rsub|2><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>|)><rsup|\<wedge\>><around|(|\<theta\>|)>*d*\<theta\>
  </equation*>

  from below. In the same way as in Theorem <reference|main> we write this
  integral as

  <\equation*>
    <frac|<around|(|2*\<pi\>|)><rsup|n>*\<Gamma\><around|(|<frac|n-\<alpha\>-1|2>|)>|2<rsup|\<alpha\>+1>*\<pi\><rsup|<frac|n|2>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)>>*<big|int><rsub|S<rsup|n-1>><around|\<\|\|\>|x|\<\|\|\>><rsub|K><rsup|-1>*d*x.
  </equation*>

  The latter integral is greater or equal to
  <math|r<around|(|K|)><around*|(|<vol><rsub|n><around|(|K|)>|)><rsup|<frac|1|n>><around*|\||S<rsup|n-1>|\|>>.
  The result follows. <endpf>

  <section|Stability and separation for projections>

  We need several more definitions from convex geometry. We refer the reader
  to <cite|S2> for details.

  The <with|font-shape|italic|support function> of a convex body <math|K> in
  <math|<R><rsup|n>> is defined by

  <\equation*>
    h<rsub|K><around|(|x|)>=max<rsub|<around|{|\<xi\>\<in\><R><rsup|n>:<around|\<\|\|\>|\<xi\>|\<\|\|\>><rsub|K>=1|}>><around|(|x,\<xi\>|)>,<space|1em>x\<in\><R><rsup|n>.
  </equation*>

  If <math|K> is origin-symmetric, then <math|h<rsub|K>> is a norm on
  <math|<R><rsup|n>>.

  The <with|font-shape|italic|surface area measure>
  <math|S*<around|(|K,\<cdot\>|)>> of a convex body <math|K> in
  <math|<R><rsup|n>> is defined as follows: for every Borel set
  <math|E\<subset\>S<rsup|n-1>>, <math|S<around|(|K,E|)>> is equal to
  Lebesgue measure of the part of the boundary of <math|K> where normal
  vectors belong to <math|E>. We usually consider bodies with absolutely
  continuous surface area measures. A convex body <math|K> is said to have
  the <with|font-shape|italic|curvature function>

  <\equation*>
    f<rsub|K>:S<rsup|n-1>\<to\><R>,
  </equation*>

  if its surface area measure <math|S*<around|(|K,\<cdot\>|)>> is absolutely
  continuous with respect to Lebesgue measure <math|\<sigma\><rsub|n-1>> on
  <math|S<rsup|n-1>>, and

  <\equation*>
    <frac|d*S*<around|(|K,\<cdot\>|)>|d*\<sigma\><rsub|n-1>>=f<rsub|K>\<in\>L<rsub|1><around|(|S<rsup|n-1>|)>,
  </equation*>

  so <math|f<rsub|K>> is the density of <math|S<around|(|K,\<cdummy\>|)>>.

  By the approximation argument of <cite-detail|S2|Th. 3.3.1>, we may assume
  in the formulation of Shephard's problem that the bodies <math|K> and
  <math|L> are such that their support functions <math|h<rsub|K>,h<rsub|L>>
  are infinitely smooth functions on <math|<R><rsup|n>\<setminus\><around|{|0|}>>.
  Using <cite-detail|K4|Lemma 3.16> we get in this case that the Fourier
  transforms <math|<wide|h<rsub|K>|^>,<wide|h<rsub|L>|^>> are the extensions
  of infinitely differentiable functions on the sphere to homogeneous
  distributions on <math|<R><rsup|n>> of degree <math|-n-1>. Moreover, by a
  similar approximation argument (see also <cite-detail|GZ|Section 5>), we
  may assume that our bodies have absolutely continuous surface area
  measures. Therefore, in the rest of this section, <math|K> and <math|L> are
  convex symmetric bodies with infinitely smooth support functions and
  absolutely continuous surface area measures.

  The following version of Parseval's formula was proved in <cite|KRZ> (see
  also <cite-detail|K4|Lemma 8.8>):

  <\equation>
    <label|pars-proj><big|int><rsub|S<rsup|n-1>><wide|h<rsub|K>|^><around|(|\<xi\>|)><wide|f<rsub|L>|^><around|(|\<xi\>|)>*d*\<xi\>=<around|(|2*\<pi\>|)><rsup|n>*<big|int><rsub|S<rsup|n-1>>h<rsub|K><around|(|x|)>*f<rsub|L><around|(|x|)>*d*x.
  </equation>

  The volume of a body can be expressed in terms of its support function and
  curvature function:

  <\equation>
    <label|vol-proj><vol><rsub|n><around|(|K|)>=<frac|1|n>*<big|int><rsub|S<rsup|n-1>>h<rsub|K><around|(|x|)>*f<rsub|K><around|(|x|)>*d*x.
  </equation>

  If <math|K> and <math|L> are two convex bodies in <math|<R><rsup|n>> the
  <with|font-shape|italic|mixed volume> <math|V<rsub|1><around|(|K,L|)>> is
  equal to

  <\equation*>
    V<rsub|1><around|(|K,L|)>=<frac|1|n>*lim<rsub|<e>\<to\>+0>
    <frac|<vol><rsub|n><around|(|K+\<epsilon\>*L|)>-<vol><rsub|n><around|(|K|)>|<e>>.
  </equation*>

  We use the following first Minkowski inequality (see
  <cite-detail|K4|p.23>): for any convex bodies <math|K,L> in
  <math|<R><rsup|n>>,

  <\equation>
    <label|firstmink>V<rsub|1><around|(|K,L|)>\<ge\><vol><rsub|n><around|(|K|)><rsup|<around|(|n-1|)>/n><vol><rsub|n><around|(|L|)><rsup|1/n>.
  </equation>

  The mixed volume can also be expressed in terms of the support and
  curvature functions:

  <\equation>
    <label|mixvol-proj>V<rsub|1><around|(|K,L|)>=<frac|1|n>*<big|int><rsub|S<rsup|n-1>>h<rsub|L><around|(|x|)>*f<rsub|K><around|(|x|)>*d*x.
  </equation>

  Let <math|K> be an origin-symmetric convex body in <math|<R><rsup|n>>. The
  <with|font-shape|italic|projection body> <math|\<Pi\>*K> of <math|K> is
  defined as an origin-symmetric convex body in <math|<R><rsup|n>> whose
  support function in every direction is equal to the volume of the
  hyperplane projection of <math|K> to this direction: for every
  <math|\<theta\>\<in\>S<rsup|n-1>>,

  <\equation>
    <label|def:proj>h<rsub|\<Pi\>*K><around|(|\<theta\>|)>=<vol><rsub|n-1><around|(|K\|\<theta\><rsup|\<perp\>>|)>.
  </equation>

  If <math|L> is the projection body of some convex body, we simply say that
  <math|L> is a projection body.

  Both Petty <cite|Pe> and Schneider <cite|S1> in their solutions of the
  Shephard problem (see the introduction) used the connection with projection
  bodies: if the body <math|L> (with greater projections) is a projection
  body then the answer to the question of the Shephard problem is affirmative
  for any body <math|K>. We now prove the stability of this connection.

  Define the normalized circumradius of <math|L> by

  <\equation*>
    R<around|(|L|)>=<frac|max<rsub|\<xi\>\<in\>S<rsup|n-1>>
    \<rho\><rsub|L><around|(|\<xi\>|)>|<vol><rsub|n><around|(|L|)><rsup|<frac|1|n>>>.
  </equation*>

  <\theorem>
    <label|main-proj>Suppose that <math|<e>\<gtr\>0>, <math|K> and <math|L>
    are origin-symmetric convex bodies in <math|<R><rsup|n>>, and <math|L> is
    a projection body. If for every <math|\<xi\>\<in\>S<rsup|n-1>>

    <eqnarray|<tformat|<table|<row|<cell|P<rsub|K><around|(|\<xi\>|)>\<le\>P<rsub|L><around|(|\<xi\>|)>+<e>,<eq-number><label|proj1>>>>>>

    then

    <\equation*>
      <vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>\<le\><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>+<sqrt|<frac|2*\<pi\>|n>>*R<around|(|L|)><e>.
    </equation*>
  </theorem>

  <pf>It was proved in <cite|KRZ> that

  <\equation>
    <label|f-proj>P<rsub|K><around|(|\<xi\>|)>=-<frac|1|\<pi\>><wide|f<rsub|K>|^><around|(|\<theta\>|)>,<space|2em>\<forall\>\<xi\>\<in\>S<rsup|n-1>,
  </equation>

  where <math|f<rsub|K>> is extended from the sphere to a homogeneous
  function of degree <math|-n-1> on the whole <math|<R><rsup|n>>, and the
  Fourier transform <math|<wide|f<rsub|K>|^>> is the extension of a
  continuous function <math|P<rsub|K>> on the sphere to a homogeneous of
  degree 1 function on <math|<R><rsup|n>>.

  Therefore, the condition (<reference|proj1>) can be written as

  <\equation>
    <label|fourier-proj>-<frac|1|\<pi\>><wide|f<rsub|K>|^><around|(|\<xi\>|)>\<le\>-<frac|1|\<pi\>><wide|f<rsub|L>|^><around|(|\<xi\>|)>+<e>,<space|2em>\<forall\>\<xi\>\<in\>S<rsup|n-1>.
  </equation>

  It was also proved in <cite|KRZ> that an infinitely smooth origin-symmetric
  convex body <math|L> in <math|<R><rsup|n>> is a projection body if and only
  if <math|<wide|h<rsub|L>|^>\<le\>0> on the sphere <math|S<rsup|n-1>>.
  Therefore, integrating (<reference|fourier-proj>) with respect to a
  negative density,

  <\equation*>
    <big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)><wide|f<rsub|L>|^><around|(|\<xi\>|)>*d*\<xi\>\<ge\><big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)><wide|f<rsub|K>|^><around|(|\<xi\>|)>*d*\<xi\>+\<pi\><e><big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)>*d*\<xi\>.
  </equation*>

  Using this, (<reference|vol-proj>) and (<reference|pars-proj>), we get

  <\equation*>
    <around|(|2*\<pi\>|)><rsup|n>*n<vol><rsub|n><around|(|L|)>=<around|(|2*\<pi\>|)><rsup|n>*<big|int><rsub|S<rsup|n-1>>h<rsub|L><around|(|x|)>*f<rsub|L><around|(|x|)>*d*x=<big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)><wide|f<rsub|L>|^><around|(|\<xi\>|)>*d*\<xi\>
  </equation*>

  <\equation*>
    \<ge\><big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)><wide|f<rsub|K>|^><around|(|\<xi\>|)>*d*\<xi\>+\<pi\><e><big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)>*d*\<xi\>
  </equation*>

  <\equation>
    <label|eq31>=<around|(|2*\<pi\>|)><rsup|n>*<big|int><rsub|S<rsup|n-1>>h<rsub|L><around|(|x|)>*f<rsub|K><around|(|x|)>*d*x+\<pi\><e><big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)>*d*\<xi\>.
  </equation>

  We estimate the first summand from below using the first Minkowski
  inequality:

  <\equation>
    <label|eq32><around|(|2*\<pi\>|)><rsup|n>*<big|int><rsub|S<rsup|n-1>>h<rsub|L><around|(|x|)>*f<rsub|K><around|(|x|)>*d*x\<ge\><around|(|2*\<pi\>|)><rsup|n>*n<around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|1|n>><around*|(|<vol><rsub|n><around|(|K|)>|)><rsup|<frac|n-1|n>>.
  </equation>

  To estimate the second summand in (<reference|eq31>), note that, by
  (<reference|f-proj>), the Fourier transform of the curvature function of
  the Euclidean ball

  <\equation*>
    <wide|f<rsub|2>|^><around|(|\<xi\>|)>=-\<pi\><vol><rsub|n-1><around|(|B<rsub|2><rsup|n-1>|)>=-<frac|\<pi\><rsup|<frac|n+1|2>>|\<Gamma\><around|(|<frac|n+1|2>|)>>,<space|2em>\<forall\>\<xi\>\<in\>S<rsup|n-1>,
  </equation*>

  where <math|B<rsub|2><rsup|n-1>> is the unit Euclidean ball in
  <math|<R><rsup|n-1>>. Therefore,

  <\equation*>
    \<pi\><e><big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)>*d*\<xi\>=-<e><frac|\<Gamma\><around|(|<frac|n+1|2>|)>|\<pi\><rsup|<frac|n-1|2>>>*<big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)><wide|f<rsub|2>|^><around|(|\<xi\>|)>*d*\<xi\>
  </equation*>

  <\equation*>
    =-<around|(|2*\<pi\>|)><rsup|n><e><frac|\<Gamma\><around|(|<frac|n+1|2>|)>|\<pi\><rsup|<frac|n-1|2>>>*<big|int><rsub|S<rsup|n-1>>h<rsub|L><around|(|x|)>*f<rsub|2><around|(|x|)>*d*x
  </equation*>

  <\equation*>
    =-<around|(|2*\<pi\>|)><rsup|n><e><frac|\<Gamma\><around|(|<frac|n+1|2>|)>|\<pi\><rsup|<frac|n-1|2>>>*<big|int><rsub|S<rsup|n-1>>h<rsub|L><around|(|x|)>*d*x
  </equation*>

  <\equation*>
    \<ge\>-<around|(|2*\<pi\>|)><rsup|n><e><frac|\<Gamma\><around|(|<frac|n+1|2>|)>|\<pi\><rsup|<frac|n-1|2>>>*R<around|(|L|)><around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|1|n>><around*|\||S<rsup|n-1>|\|>
  </equation*>

  <\equation*>
    =-<around|(|2*\<pi\>|)><rsup|n>*n<e><frac|<sqrt|\<pi\>>*R<around|(|L|)><around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|1|n>>*\<Gamma\><around|(|<frac|n+1|2>|)>|\<Gamma\>*<around|(|<frac|n|2>+1|)>>,
  </equation*>

  where we again used Parseval's formula, the fact that <math|f<rsub|2>=1>,
  and a simple estimate <math|h<rsub|L><around|(|x|)>\<le\>R<around|(|L|)><around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|1|n>>>.

  Combining this with (<reference|eq31>) and (<reference|eq32>), and using
  the third inequality of Lemma <reference|gammafunction>, we get

  <\equation*>
    <around|(|2*\<pi\>|)><rsup|n>*n<vol><rsub|n><around|(|L|)>\<ge\><around|(|2*\<pi\>|)><rsup|n>*n<around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|1|n>><around*|(|<vol><rsub|n><around|(|K|)>|)><rsup|<frac|n-1|n>>
  </equation*>

  <\equation*>
    -<around|(|2*\<pi\>|)><rsup|n>*n*<sqrt|<frac|2*\<pi\>|n>>*R<around|(|L|)><around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|1|n>><e>,
  </equation*>

  which finishes the proof. <endpf>We now prove the corresponding separation
  result.

  <\theorem>
    <label|main-proj1>Suppose that <math|<e>\<gtr\>0>, <math|K> and <math|L>
    are origin-symmetric convex bodies in <math|<R><rsup|n>>, and <math|L> is
    a projection body. If for every <math|\<xi\>\<in\>S<rsup|n-1>>

    <eqnarray|<tformat|<table|<row|<cell|P<rsub|K><around|(|\<xi\>|)>\<le\>P<rsub|L><around|(|\<xi\>|)>-<e>,<eq-number><label|proj2>>>>>>

    then

    <\equation*>
      <vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>\<le\><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>-<frac|<e>|<sqrt|e>>.
    </equation*>
  </theorem>

  <pf>Similarly to the proof of Theorem <reference|main-proj>, we get
  (<reference|eq31>), but with negative sign in front of <math|<e>>:

  <\equation>
    <label|eq33><around|(|2*\<pi\>|)><rsup|n>*n<vol><rsub|n><around|(|L|)>\<ge\><around|(|2*\<pi\>|)><rsup|n>*<big|int><rsub|S<rsup|n-1>>h<rsub|L><around|(|x|)>*f<rsub|K><around|(|x|)>*d*x-\<pi\><e><big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)>*d*\<xi\>.
  </equation>

  The difference with the proof of Theorem <reference|main-proj> is that now
  we need an upper estimate for

  <\equation*>
    \<pi\><e><big|int><rsub|S<rsup|n-1>><wide|h<rsub|L>|^><around|(|\<xi\>|)>*d*\<xi\>=-<around|(|2*\<pi\>|)><rsup|n><e><frac|\<Gamma\><around|(|<frac|n+1|2>|)>|\<pi\><rsup|<frac|n-1|2>>>*<big|int><rsub|S<rsup|n-1>>h<rsub|L><around|(|x|)>*f<rsub|2><around|(|x|)>*d*x.
  </equation*>

  Using the first Minkowski inequality (<reference|firstmink>), the latter is

  <\equation*>
    \<le\>-<around|(|2*\<pi\>|)><rsup|n>*n<e><frac|\<Gamma\><around|(|<frac|n+1|2>|)>|\<pi\><rsup|<frac|n-1|2>>><around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|1|n>><around*|(|<vol><rsub|n><around|(|B<rsub|2><rsup|n>|)>|)><rsup|<frac|n-1|n>>
  </equation*>

  <\equation*>
    =-<around|(|2*\<pi\>|)><rsup|n>*n<e><frac|\<Gamma\><around|(|<frac|n+1|2>|)>|<around*|(|\<Gamma\>*<around|(|<frac|n|2>+1|)>|)><rsup|<frac|n-1|n>>><around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|1|n>>\<le\>-<frac|<around|(|2*\<pi\>|)><rsup|n>*n<e>|<sqrt|e>><around*|(|<vol><rsub|n><around|(|L|)>|)><rsup|<frac|1|n>>
  </equation*>

  by the first inequality of Lemma <reference|gammafunction>. In conjunction
  with (<reference|eq33>) and (<reference|firstmink>),
  (<reference|mixvol-proj>), this implies the result. <endpf> Finally, we
  formulate the stability version of the result from <cite|Y> mentioned in
  the introduction, which treats projections in arbitrary dimension without
  the additional assumption that <math|L> is a projection body. The proof
  follows the lines of the proof of Theorem <reference|main-proj> with
  changes corresponding to those in the proof of Theorem <reference|main>; we
  leave this proof to the willing reader, as well as the separation result in
  this case. Let us just mention that one has to use the fact that for every
  <math|\<alpha\>\<in\><around|[|n,n+1|)>> the distribution
  <math|<around|\||x|\|><rsub|2><rsup|-\<alpha\>>*h<rsub|L><around|(|x|)>> is
  positive definite, which is explained in <cite|Y>.

  <\theorem>
    <label|main-1>Let <math|<e>\<gtr\>0,\<alpha\>\<in\><around|[|n,n+1|)>>,
    <math|K> and <math|L> be origin-symmetric infinitely smooth convex bodies
    in <math|<R><rsup|n>>, <math|n\<ge\>3>, so that for every
    <math|\<xi\>\<in\>S<rsup|n-1>>

    <\equation*>
      (-\<Delta\>)<rsup|\<alpha\>/2>P<rsub|L><around|(|\<xi\>|)>\<le\>(-\<Delta\>)<rsup|\<alpha\>/2>P<rsub|K><around|(|\<xi\>|)>+<e>.
    </equation*>

    Then

    <\equation*>
      <vol><rsub|n><around|(|K|)><rsup|<frac|n-1|n>>\<le\><vol><rsub|n><around|(|L|)><rsup|<frac|n-1|n>>+c<e>,
    </equation*>

    where

    <\equation*>
      c=<frac|\<Gamma\><around|(|<frac|n-\<alpha\>+1|2>|)><around*|\||S<rsup|n-1>|\|>*R<around|(|L|)>|2<rsup|\<alpha\>+1>*\<pi\><rsup|<frac|n|2>>*\<Gamma\><around|(|<frac|\<alpha\>+1|2>|)>*n>.
    </equation*>
  </theorem>

  Note that this is no longer true if <math|\<alpha\>\<less\>n>, because the
  underlying comparison result fails, as shown in <cite|Y>.
  <bigbreak|<with|font-series|bold|Acknowledgement.>> The author wishes to
  thank the US National Science Foundation for support through grants
  DMS-0652571 and DMS-1001234.

  <\thebibliography|99>
    <bibitem-with-key|Ba|Ba> K.<nbsp>Ball, <with|font-shape|italic|Some
    remarks on the geometry of convex sets>, Geometric aspects of functional
    analysis (1986/87), Lecture Notes in Math. <with|font-series|bold|1317>,
    Springer-Verlag, Berlin-Heidelberg-New York, 1988, 224\U231.

    <bibitem-with-key|Bo|Bo> J.<nbsp>Bourgain, <with|font-shape|italic|On the
    Busemann-Petty problem for perturbations of the ball>, Geom. Funct. Anal.
    <with|font-series|bold|1> (1991), 1\U13.

    <bibitem-with-key|BP|BP> H.<nbsp>Busemann and C.<nbsp>M.<nbsp>Petty,
    <with|font-shape|italic|Problems on convex bodies>, Math. Scand.
    <with|font-series|bold|4> (1956), 88\U94.

    <bibitem-with-key|G1|G1> R.<nbsp>J.<nbsp>Gardner,
    <with|font-shape|italic|Intersection bodies and the Busemann-Petty
    problem>, Trans. Amer. Math. Soc. <with|font-series|bold|342> (1994),
    435\U445.

    <bibitem-with-key|G2|G2> R.<nbsp>J.<nbsp>Gardner,
    <with|font-shape|italic|A positive answer to the Busemann-Petty problem
    in three dimensions>, Annals of Math. <with|font-series|bold|140> (1994),
    435\U447.

    <bibitem-with-key|G3|G3> R.<nbsp>J.<nbsp>Gardner,
    <with|font-shape|italic|Geometric tomography>, Second edition, Cambridge
    University Press, Cambridge, 2006.

    <bibitem-with-key|GKS|GKS> R.<nbsp>J.<nbsp>Gardner, A.<nbsp>Koldobsky and
    Th.<nbsp>Schlumprecht, <with|font-shape|italic|An analytic solution to
    the Busemann-Petty problem on sections of convex bodies>, Annals of Math.
    <with|font-series|bold|149> (1999), 691\U703.

    <bibitem-with-key|GS|GS> I.<nbsp>M.<nbsp>Gelfand and
    G.<nbsp>E.<nbsp>Shilov, <with|font-shape|italic|Generalized functions,
    vol.<nbsp>1. Properties and operations>, Academic Press, New York, 1964.

    <bibitem-with-key|Gi|Gi> A.<nbsp>Giannopoulos, <with|font-shape|italic|A
    note on a problem of H.<nbsp>Busemann and C.<nbsp>M.<nbsp>Petty
    concerning sections of symmetric convex bodies>, Mathematika
    <with|font-series|bold|37> (1990), 239\U244.

    <bibitem-with-key|GZ|GZ> E.<nbsp>Grinberg and Gaoyong Zhang,
    <with|font-shape|italic|Convolutions, transforms, and convex bodies>,
    Proc. London Math. Soc. (3) <with|font-series|bold|78> (1999), 77\U115.

    <bibitem-with-key|Gr|Gr> H.<nbsp>Groemer,
    <with|font-shape|italic|Geometric applications of Fourier series and
    spherical harmonics>, Cambridge University Press, New York, 1996.

    <bibitem-with-key|K1|K1> A.<nbsp>Koldobsky, <with|font-shape|italic|An
    application of the Fourier transform to sections of star bodies>, Israel
    J. Math. <with|font-series|bold|106> (1998), 157\U164.

    <bibitem-with-key|K2|K2> A. Koldobsky,
    <with|font-shape|italic|Intersection bodies, positive definite
    distributions and the Busemann-Petty problem>, Amer. J. Math.
    <with|font-series|bold|120> (1998), 827\U840.

    <bibitem-with-key|K3|K3> A. Koldobsky,
    <with|font-shape|italic|Intersection bodies in <math|<R><rsup|4>>>, Adv.
    Math. <with|font-series|bold|136> (1998), 1\U14.

    <bibitem-with-key|K4|K4> A.<nbsp>Koldobsky,
    <with|font-shape|italic|Fourier analysis in convex geometry>, Amer. Math.
    Soc., Providence RI, 2005.

    <bibitem-with-key|K5|K5> A.<nbsp>Koldobsky, <with|font-shape|italic|A
    generalization of the Busemann-Petty problem on sections of convex
    bodies>, Israel J. Math. <with|font-series|bold|110> (1999), 75\U91.

    <bibitem-with-key|KL|KL> A.<nbsp>Koldobsky and M.<nbsp>Lifshits,
    <with|font-shape|italic|Average volume of sections of star bodies>,
    Geometric aspects of functional analysis, 119\U146, Lecture Notes in
    Math., 1745, Springer, Berlin, 2000.

    <bibitem-with-key|KRZ|KRZ> A.<nbsp>Koldobsky, D.<nbsp>Ryabogin and
    A.<nbsp>Zvavitch, <with|font-shape|italic|Projections of convex bodies
    and the Fourier transform>, Israel J. Math. <with|font-series|bold|139>
    (2004), 361\U380.

    <bibitem-with-key|KYY|KYY> A.<nbsp>Koldobsky, V.<nbsp>Yaskin and
    M.<nbsp>Yaskina, <with|font-shape|italic|Modified Busemann-Petty problem
    on sections of convex bodies>, Israel J. Math.
    <with|font-series|bold|154> (2006), 191\U207.

    <bibitem-with-key|KY|KY> A.<nbsp>Koldobsky and V.<nbsp>Yaskin,
    <with|font-shape|italic|The interface between convex geometry and
    harmonic analysis>, CBMS Regional Conference Series in Mathematics, 108,
    American Mathematical Society, Providence, RI, 2008.

    <bibitem-with-key|LR|LR> D.<nbsp>G.<nbsp>Larman and
    C.<nbsp>A.<nbsp>Rogers, <with|font-shape|italic|The existence of a
    centrally symmetric convex body with central sections that are
    unexpectedly small>, Mathematika <with|font-series|bold|22> (1975),
    164\U175.

    <bibitem-with-key|L|L> E.<nbsp>Lutwak,
    <with|font-shape|italic|Intersection bodies and dual mixed volumes>, Adv.
    Math. <with|font-series|bold|71> (1988), 232\U261.

    <bibitem-with-key|Pa|Pa> M.<nbsp>Papadimitrakis,
    <with|font-shape|italic|On the Busemann-Petty problem about convex,
    centrally symmetric bodies in <math|<R><rsup|n>>>, Mathematika
    <with|font-series|bold|39> (1992), 258\U266.

    <bibitem-with-key|Pe|Pe>C.<nbsp>M.<nbsp>Petty,
    <with|font-shape|italic|Projection bodies>, Proc. Coll. Convexity
    (Copenhagen 1965), Kobenhavns Univ. Mat. Inst., 234-241.

    <bibitem-with-key|S1|S1>R. Schneider, <with|font-shape|italic|Zu einem
    problem von Shephard ber die projektionen konvexer Krper,> Math. Z.
    <with|font-series|bold|101> (1967), 71-82.

    <bibitem-with-key|S2|S2> R.<nbsp>Schneider,
    <with|font-shape|italic|Convex bodies: the Brunn-Minkowski theory>,
    Cambridge University Press, Cambridge, 1993.

    <bibitem-with-key|Sh|Sh>G.<nbsp>C.<nbsp>Shephard,
    <with|font-shape|italic|Shadow systems of convex bodies>, Israel J. Math.
    <with|font-series|bold|2> (1964), 229-306.

    <bibitem-with-key|Y|Y> V.<nbsp>Yaskin, <with|font-shape|italic|Modified
    Shephard's problem on projections of convex bodies>, Israel J. Math.
    <with|font-series|bold|168> (2008), 221\U238.

    <bibitem-with-key|Z1|Z1> Gaoyong Zhang, <with|font-shape|italic|Centered
    bodies and dual mixed volumes>, Trans. Amer. Math. Soc.
    <with|font-series|bold|345> (1994), 777\U801.

    <bibitem-with-key|Z2|Z2> Gaoyong Zhang,
    <with|font-shape|italic|Intersection bodies and Busemann-Petty
    inequalities in <math|<R><rsup|4>>>, Annals of Math.
    <with|font-series|bold|140> (1994), 331\U346.

    <bibitem-with-key|Z3|Z3> Gaoyong Zhang, <with|font-shape|italic|A
    positive answer to the Busemann-Petty problem in four dimensions>, Annals
    of Math. <with|font-series|bold|149> (1999), 535\U543.
  </thebibliography>
</body>