<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <doc-data|<doc-title|Growth rates of dimensional invariants of compact
  quantum groups and a theorem of Hegh-Krohn, Landstad and
  Strmer>|<doc-author|<author-data|<author-name|Claudia
  Pinzari>>>|<doc-date|>>

  <abstract-data|<\abstract>
    We give local upper and lower bounds for the eigenvalues of the modular
    operator associated to an ergodic action of a compact quantum group on a
    unital <math|C<rsup|\<ast\>>>--algebra. They involve the modular theory
    of the quantum group and the growth rate of quantum dimensions of its
    representations and they become sharp if other integral invariants grow
    subexponentially. For compact groups, this reduces to the finiteness
    theorem of Hegh-Krohn, Landstad and Strmer. Consequently, compact
    quantum groups of Kac type admitting an ergodic action with a non-tracial
    invariant state must have representations whose dimensions grow
    exponentially. In particular, <math|S<rsub|-1>*U<around|(|d|)>> acts
    ergodically only on tracial <math|C<rsup|\<ast\>>>--algebras. For quantum
    groups with non-involutive coinverse, we derive a lower bound for the
    parameters <math|0\<less\>\<lambda\>\<less\>1> of factors of type
    III<rsub|<math|\<lambda\>>> that can possibly arise from the GNS
    representation of the invariant state of an ergodic action with a
    factorial centralizer.
  </abstract>>

  <\center>
    <with|font-shape|italic|Dedicated to the memory of Claudio D'Antoni>
    <vspace|2fn>
  </center>

  <section|Introduction>

  In the early 80's Hegh-Krohn, Landstad and Strmer proved that the
  multiplicity of an irreducible representation of a compact group acting
  ergodically on a unital <math|C<rsup|\<ast\>>>\Ualgebra is bounded above by
  its dimension and moreover the unique invariant state is a trace
  <cite|HLS>. This result is often used as a finiteness criterion in operator
  algebras. Moreover, Wassermann, starting from this, showed the negative
  result that <with|font-family|rm|SU><math|<around|(|2|)>> acts ergodically
  only on type I von Neumann algebras <cite|Wassermann3>.

  If we consider compact quantum groups instead of compact groups, ergodic
  theory on operator algebras becomes much richer. For example, as is well
  known, finiteness fails, as compact quantum groups may have non-involutive
  coinverse and, in this case, the Haar state has a non-trivial modular
  theory <cite|WoronowiczCMP>. Boca generalized some of these results to
  ergodic actions of compact quantum groups. He proved that the quantum
  dimension is an upper bound for the multiplicity of an irreducible
  representation and that the invariant state satisfies the KMS property
  <cite|Boca>. Wang has found many examples of ergodic actions of the free
  unitary quantum groups on factors of type II and III <cite|Wang>. In
  particular, his examples show that finiteness fails already in the case of
  compact quantum groups with involutive coinverse, often called of Kac type,
  even though these have trivial modular theory. Indeed,
  <math|A<rsub|u><around|(|n|)>> can act ergodically on factors on type
  III<math|<rsub|\<nosymbol\>>1*n>. Bichon, De Rijdt and Vaes have
  constructed actions of <math|A<rsub|o><around|(|F|)>> with multiplicities
  larger than the integral dimensions <cite|BDV>. We have shown in
  <cite|PRsubfactors> that any finite index inclusion of factors of type
  II<rsub|<math|1>> gives rise to ergodic actions of
  <math|A<rsub|o><around|(|F|)>>. Moreover, the classification of ergodic
  actions of compact quantum groups is related to the classification of
  tensor <math|C<rsup|\<ast\>>>\Ucategories with conjugates
  <cite|PRinduction>.

  The aim of this note is to show an analogue of the second part of the
  finiteness theorem of <cite|HLS> for compact quantum groups.

  The examples of <cite|BDV>, as well as subsequent developments of the
  general theory of ergodic actions <cite|PR>, contributed to a further
  understanding of the invariant state. It became clear, for example, that it
  is always almost periodic in the sense of Connes <cite|ConnesAP>, meaning
  that the associated modular operator is diagonal, and that its eigenvalues
  exhibit an explicit, separated, dependence on both the modular theory of
  the quantum group and the eigenvalues of certain positive spectral matrices
  canonically associated to the ergodic action. Hence the problem of studying
  modularity of the invariant state of an ergodic action reduces to that of
  studying the spectra of these matrices. In retrospect, the theorem of
  <cite|HLS> amounts to showing that these matrices are always trivial in the
  classical case. Moreover, if the invariant state of an ergodic action of a
  non-Kac type compact quantum group is factorial and has factorial
  centralizer, then the associated factor is necessarily of type
  III<rsub|<math|\<lambda\>>> with <math|0\<less\>\<lambda\>\<leq\>1> (cf.
  Sect. 2 for a more precise statement). Note that the invariant state of the
  mentioned examples of Wang satisfy this factoriality condition.

  Vaes and Vergnioux <cite|VV> have recently studied the translation action
  of <math|A<rsub|o><around|(|F|)>> over itself. They were able to prove,
  among other things, that if <math|F> has rank at least <math|3> and
  satisfies a suitable condition, then the Haar state is factorial and
  moreover the factor generated by the the GNS construction is full in the
  sense of Connes <cite|ConnesAP>.

  We introduce two growth rates of dimensional invariants of compact quantum
  groups, that of integral dimensions, Dim<rsub|<math|u>>, and of quantum
  dimensions, <math|D<rsub|u>>.

  These growth rates distinguish between <math|S*U<around|(|2|)>>,
  <math|S<rsub|q>*U<around|(|2|)>> for <math|0\<less\>q\<less\>1>,
  <math|A<rsub|o><around|(|F|)>>, for rank<math|<around|(|F|)>\<geq\>3>, and
  <math|A<rsub|u><around|(|F|)>>. More precisely, in the group case, quantum
  dimensions are just the integral dimensions, and the growth rate is always
  polynomial, as a consequence of Weyl's dimension formula, hence
  <math|D<rsub|u>=<text|Dim><rsub|u>=1> for all representations. This
  polynomial growth rate played an important role in the original proof of
  the finitenss theorem of <cite|HLS>.

  Growth rate of quantum dimensions for <math|S<rsub|q>*U<around|(|2|)>>,
  <math|0\<less\>q\<less\>1> is instead exponential. However, integral
  dimensions of irreducibles are the same as in the classical case, hence
  they grow polynomially. This is opposed to <math|A<rsub|o><around|(|F|)>>,
  for rank<math|<around|(|F|)>\<geq\>3>, for which both growth rates are
  exponential. In the case of <math|A<rsub|u><around|(|F|)>>, both
  dimensional invariants of the fundamental representation have the largest
  possible growth rates as all tensor powers of this representation are
  irreducible.

  We shall see that the growth rate of the integral dimensions is
  subexponential, then that of quantum dimensions, <math|D<rsub|u>>, is
  explicitly determined by the eigenvalues of the modular operator of the
  quantum group (Prop. 3.3). However, this fact is not generally true,
  <math|A<rsub|o><around|(|n|)>>, <math|n\<geq\>3>, and
  <math|A<rsub|u><around|(|n|)>>, <math|n\<geq\>2>, are the first examples.

  Given an ergodic action of a compact quantum group on a unital
  <math|C<rsup|\<ast\>>>\Ualgebra, our main result consists of showing that
  <math|D<rsub|u>> and <math|D<rsub|u><rsup|-1>> are upper and lower bounds
  for the spectral radii of the spectral matrices involved in the modular
  operator of the ergodic action (see Theorem 3.8). In particular, we
  reproduce the finiteness theorem of <cite|HLS> from the fact that
  <math|D<rsub|u>=1> in the group case. Our bounds become equalities in the
  case of ergodic actions with high quantum multiplicities in the sense of
  <cite|BDV>, but integral multiplicities with subexponential growth rate. We
  shall show that the invariant <math|D> determines the parameter
  <math|\<lambda\>=<frac|1|n>> of the Connes invariant in Wang's example with
  <math|A<rsub|u><around|(|n|)>>.

  The rate of growth of dimensions clarify which compact quantum groups of
  Kac type can act on infinite factors. More precisely, one of the
  consequences of our result is that, among compact quantum groups of Kac
  type, only those having some irreducible representation whose integral
  dimension grows exponentially can possibly act on
  <math|C<rsup|\<ast\>>>\Ualgebras with a non-tracial invariant state. For
  example, all ergodic <math|C<rsup|\<ast\>>>\Ualgebras for
  <math|S<rsub|-1>*U<around|(|d|)>> are tracial.

  For compact quantum groups with non-involutive coinverse, we derive a
  general lower bound for the possible parameters
  <math|0\<less\>\<lambda\>\<less\>1> of the type III<rsub|<math|\<lambda\>>>
  factors than can arise from the GNS representation of the invariant state,
  provided the centralizer algebra is a factor. This lower bound involves the
  modular theory of the quantum group, the growth rates <math|D<rsub|u>>, and
  the spectrum of the action, see Cor. 3.13. We thus see that many parameters
  <math|\<lambda\>> may be excluded if some spectral information is known.
  For example, for <math|S<rsub|q>*U<around|(|2|)>>, with
  <math|0\<less\><around|\||q|\|>\<less\>1> then
  <math|\<lambda\>\<geq\><around|\||q|\|><rsup|2*r>>, where <math|r> labels
  the first spectral irreducible representation. For
  <math|A<rsub|o><around|(|F|)>>, with <math|F> of rank <math|\<geq\>3>, then
  <math|\<lambda\>\<geq\><around|(|<frac|q|<around|\<\|\|\>|F|\<\|\|\>><rsup|2>>|)><rsup|r>>
  where <math|q+<frac|1|q>\<assign\><text|Trace><around|(|F<rsup|\<ast\>>*F|)>>
  and <math|r> is as before. As another example,
  <math|\<lambda\>\<geq\><frac|min <around|{|q<rsub|0>,q<rsub|n><rsup|-1>|}>|<text|Trace><around|(|F<rsup|\<ast\>>*F|)>>>,
  for <math|A<rsub|u><around|(|F|)>>, with <math|q<rsub|0>> and
  <math|q<rsub|n>> the smallest and largest eigenvalues of
  <math|F<rsup|\<ast\>>*F> if the fundamental representation is spectral.

  Our methods differ from the original proof of the classical finiteness
  theorem. They rely on the duality theorem of <cite|PR>, which allows a
  rather simple presentation.

  <section|Preliminaries>

  <no-indent><with|font-shape|italic|Standard solutions of the conjugate
  equations.> We shall briefly recall the main features of tensor
  <math|C<rsup|\<ast\>>>\Ucategories with conjugates <cite|LR>. Let
  <math|\<cal-A\>> be a tensor <math|C<rsup|\<ast\>>>\Ucategory (always
  assumed to be strict, with irreducible tensor unit <math|\<iota\>>,
  subobjects and direct sums). Arrows <math|R\<in\><around|(|\<iota\>,<wide|u|\<bar\>>\<otimes\>u|)>>
  and <math|<wide|R|\<bar\>>\<in\><around|(|\<iota\>,u\<otimes\><wide|u|\<bar\>>|)>>
  are said to define a conjugate <math|<wide|u|\<bar\>>> of the object
  <math|u> if they satisfy the conjugate equations

  <\equation*>
    <wide|R|\<bar\>><rsup|\<ast\>>\<otimes\>1<rsub|u>\<circ\>1<rsub|u>\<otimes\>R=1<rsub|u>,<space|1em>R<rsup|\<ast\>>\<otimes\>1<rsub|<wide|u|\<bar\>>>\<circ\>1<rsub|<wide|u|\<bar\>>>\<otimes\><wide|R|\<bar\>>=1<rsub|<wide|u|\<bar\>>>.
  </equation*>

  If <math|R<rsub|u>>, <math|<wide|R|\<bar\>><rsub|u>> and <math|R<rsub|v>>,
  <math|<wide|R|\<bar\>><rsub|v>> are solutions for <math|u> and <math|v>
  then <math|R<rsub|u\<otimes\>v>\<assign\>1<rsub|<wide|v|\<bar\>>>\<otimes\>R<rsub|u>\<otimes\>1<rsub|v>\<circ\>R<rsub|v>>,
  <math|<wide|R|\<bar\>><rsub|u\<otimes\>v>\<assign\>1<rsub|u>\<otimes\><wide|R|\<bar\>><rsub|v>\<otimes\>1<rsub|<wide|u|\<bar\>>>\<circ\><wide|R|\<bar\>><rsub|u>>
  are solutions for <math|u\<otimes\>v>, respectively. Similarly,
  <math|R<rsub|<wide|u|\<bar\>>>\<assign\><wide|R|\<bar\>><rsub|u>>,
  <math|<wide|R|\<bar\>><rsub|<wide|u|\<bar\>>>\<assign\>R<rsub|u>> are
  solutions for <math|<wide|u|\<bar\>>>. They are called the conjugate and
  tensor product solutions respectively. If conjugates exist, every object is
  the direct sum of irreducible objects. The category
  Rep<math|<around|(|G|)>> of (unitary, finite dimensional) representations
  of a compact quantum group is embedded in the category of finite
  dimensional Hilbert spaces, hence arrows are linear maps. Solutions of the
  conjugate equations take the form <math|R=<big|sum><rsub|i>j*\<psi\><rsub|i>\<otimes\>\<psi\><rsub|i>>,
  <math|<wide|R|\<bar\>>=<big|sum><rsub|k>j<rsup|-1>*\<phi\><rsub|k>\<otimes\>\<phi\><rsub|k>>,
  with <math|j:H<rsub|u>\<to\>H<rsub|<wide|u|\<bar\>>>> a unique invertible
  antilinear map between the representation Hilbert spaces and
  <math|<around|(|\<psi\><rsub|i>|)>>, <math|<around|(|\<phi\><rsub|k>|)>>
  orthonormal bases. Conjugate and tensor product solutions correspond to
  <math|j<rsub|<wide|u|\<bar\>>>\<assign\>j<rsub|u><rsup|-1>>,
  <math|j<rsub|u\<otimes\>v>=j<rsub|v>\<otimes\>j<rsub|u>*\<theta\>>, with
  <math|\<theta\>:H<rsub|u>\<otimes\>H<rsub|v>\<to\>H<rsub|v>\<otimes\>H<rsub|u>>
  the flip map. In a tensor <math|C<rsup|\<ast\>>>\Ucategory with conjugates
  it is convenient to select <with|font-shape|italic|standard solutions> of
  the conjugate equations, meaning that <math|<around|\<\|\|\>|R<rsub|u>|\<\|\|\>>=<around|\<\|\|\>|<wide|R|\<bar\>><rsub|u>|\<\|\|\>>>
  if <math|u> is an irreducible object, while if
  <math|u\<simeq\>\<oplus\><rsub|i>u<rsub|i>> with <math|u<rsub|i>>
  irreducible, <math|R<rsub|u>\<assign\><big|sum><rsub|i><wide|S|\<bar\>><rsub|i>\<otimes\>S<rsub|i>\<circ\>R<rsub|u<rsub|i>>>
  <math|<wide|R|\<bar\>><rsub|u>\<assign\><big|sum><rsub|i>S<rsub|i>\<otimes\><wide|S|\<bar\>><rsub|i>\<circ\><wide|R|\<bar\>><rsub|u<rsub|i>>>,
  where <math|R<rsub|u<rsub|i>>>, <math|<wide|R|\<bar\>><rsub|u<rsub|i>>> are
  standard solutions and <math|<around|{|S<rsub|i>\<in\><around|(|u<rsub|i>,u|)>|}>>,
  <math|<around|{|<wide|S|\<bar\>><rsub|i>\<in\><around|(|<wide|u|\<bar\>><rsub|i>,<wide|u|\<bar\>>|)>|}>>
  are two sets of isometries whose ranges are pairwise orthogonal add up to
  <math|1<rsub|u>> and <math|1<rsub|<wide|u|\<bar\>>>>, respectively.
  Clearly, the conjugate of a standard solution is standard. Standard
  solutions are unique up to <with|font-shape|italic|unitary> equivalence.
  Most importantly, they realize the minimal value of
  <math|<around|\<\|\|\>|R<rsub|u>|\<\|\|\>><around|\<\|\|\>|<wide|R|\<bar\>><rsub|u>|\<\|\|\>>>
  among all solutions, and they are characterized, up to scalars, by this
  property. This minimal value is the quantum (or intrinsic) dimension of
  <math|u>, denoted by <math|d<around|(|u|)>>. This implies the following
  fact, which will play a role. <vspace|1fn>

  <no-indent><with|font-series|bold|2.1. Theorem.> <cite|LR>
  <with|font-shape|italic|The tensor product of standard solutions is
  standard.><vspace|1fn> We shall also need the following fact. In the
  category Rep<math|<around|(|G|)>>, if <math|j<rsub|u>:H<rsub|u>\<to\>H<rsub|<wide|u|\<bar\>>>>
  defines a standard solution of the conjugate equations for <math|u>,
  <math|j<rsub|u><rsup|\<ast\>>*j<rsub|u>> is a positive operator on
  <math|H<rsub|u>> which does not depend on the choice of the standard
  solutions. This operator correspond to <math|F<rsub|u><rsup|-1>> of
  Woronowicz <cite|WoronowiczCMP>. It follows that the spectrum of
  <math|j<rsub|u><rsup|\<ast\>>*j<rsub|u>> as well as its smallest and
  largest eigenvalues, denoted <math|\<lambda\><rsub|u>> and
  <math|\<Lambda\><rsub|u>> respectively, are invariantly associated to
  <math|u> (in fact, to its equivalence class). Note that
  <math|\<lambda\><rsub|<wide|u|\<bar\>>>=\<Lambda\><rsub|u><rsup|-1>>,
  <math|\<lambda\><rsub|u\<otimes\>v>=\<lambda\><rsub|u>*\<lambda\><rsub|v>>,
  and similarly for <math|\<Lambda\>>. <vspace|1fn>

  <no-indent><with|font-shape|italic|Ergodic actions, spectral functor and
  quasitensor functors.> To a certain extent, we may think of the
  relationship between an ergodic action of a compact quantum group on a
  unital <math|C<rsup|\<ast\>>>-algebra, the associated spectral functor and
  an abstract quasitensor functor, as analogous to that between a Lie group,
  the associated Lie algebra and an abstract Lie algebra. The analogy is
  supported by the following properties of ergodic actions <cite|PR>. The
  spectral functor of an ergodic action is a quasitensor functor. For any
  ergodic action, there always is a maximal ergodic action which has the same
  spectral functor as the original one. It is the completion in the maximal
  <math|C<rsup|\<ast\>>>\Unorm of the dense spectral subalgebra of the given
  ergodic action. The maximal ergodic action with a given spectral functor is
  unique and canonically associated with it. Any abstract quasitensor functor
  from the representation category of <math|G> to the Hilbert spaces is the
  spectral functor of an ergodic action. Two maximal ergodic actions of a
  given compact quantum group <math|G> are conjugate if and only if the
  associated spectral functors are related by a unitary natural
  transformation. Hence quasitensor functors
  Rep<math|<around|(|G|)>\<to\>>Hilb classify maximal ergodic
  <math|C<rsup|\<ast\>>>\Uactions of <math|G>.

  In some more detail, let <math|G> be a compact quantum group
  <cite|WoronowiczLesHouches> and

  <\equation*>
    \<alpha\>:\<cal-C\>\<to\>\<cal-C\>\<otimes\>\<cal-Q\>
  </equation*>

  an ergodic action of <math|G> on a unital <math|C<rsup|\<ast\>>>\Ualgebra
  <math|\<cal-C\>> (i.e. <math|\<cal-C\><rsup|\<alpha\>>\<assign\><around|{|c\<in\>\<cal-C\>,\<alpha\><around|(|c|)>=c\<otimes\>I|}>=\<bbb-C\>>).
  <math|\<cal-Q\>> denotes the Hopf <math|C<rsup|\<ast\>>>\Ualgebra of
  <math|G>. Let <math|u> be a representation of <math|G> on the Hilbert space
  <math|H<rsub|u>>. Consider the space of linear maps
  <math|T:H<rsub|u>\<to\>\<cal-C\>> intertwining <math|u> with the action
  <math|\<alpha\>>. The map taking <math|u> to this space of intertwiners is
  a functor from the representation category of <math|G> to the category of
  vector spaces. However, it is a contravariant functor, hence for
  convenience we consider the covariant functor obtained passing to the
  category of dual vector spaces. This covariant functor will be donoted by
  <math|L> (while we used the notation <math|<wide|L|\<bar\>>> in previous
  papers). As a consequence of ergodicity, the predual of <math|L<rsub|u>>,
  and hence of <math|L<rsub|u>> itself, is a Hilbert space. We may explicit
  <math|L<rsub|u>=<around|{|<big|sum><rsub|i>\<psi\><rsub|i>\<otimes\>c<rsub|,>*<space|1em>\<alpha\><around|(|c<rsub|i>|)>=<big|sum><rsub|j>c<rsub|j>\<otimes\>u<rsub|j,i><rsup|\<ast\>>,<space|1em>\<psi\><rsub|i><text|o.
  b.>|}>> and thus think of <math|L<rsub|u>> as the space of fixed points
  <math|<around|(|H<rsub|u>\<otimes\>\<cal-C\>|)><rsup|u\<otimes\>\<alpha\>>>
  with inner product arising from the restriction of the
  <math|\<cal-C\>>\Uvalued inner product of the free Hilbert module
  <math|H<rsub|u>\<otimes\>\<cal-C\>>. If <math|A\<in\><around|(|u,v|)>> is
  an intertwiner in Rep<math|<around|(|G|)>>, <math|L<rsub|A>> acts as
  <math|A\<otimes\>I> from <math|L<rsub|u>> to <math|L<rsub|v>>.

  A <rsup|<math|\<ast\>>>\Ufunctor <math|\<mu\>:\<cal-A\>\<to\>\<cal-M\>>
  between two tensor <math|C<rsup|\<ast\>>>\Ucategories is called quasitensor
  if there are isometries <math|<wide|\<mu\>|~><rsub|u,v>\<in\><around|(|\<mu\><rsub|u>\<otimes\>\<mu\><rsub|v>,\<mu\><rsub|u\<otimes\>v>|)>>,
  such that

  <\equation*>
    \<mu\><rsub|\<iota\>>=\<iota\>,<eqno><around|(|2.1|)>
  </equation*>

  <\equation*>
    <wide|\<mu\>|~><rsub|u,\<iota\>>=<wide|\<mu\>|~><rsub|\<iota\>,u>=1<rsub|\<mu\><rsub|u>>,<eqno><around|(|2.2|)>
  </equation*>

  <\equation*>
    <wide|\<mu\>|~><rsub|u,v\<otimes\>w><rsup|\<ast\>>\<circ\><wide|\<mu\>|~><rsub|u\<otimes\>v,w>=1<rsub|\<mu\><rsub|u>>\<otimes\><wide|\<mu\>|~><rsub|v,w>\<circ\><wide|\<mu\>|~><rsub|u,v><rsup|\<ast\>>\<otimes\>1<rsub|\<mu\><rsub|w>><eqno><around|(|2.3|)>
  </equation*>

  and natural in <math|u>, <math|v>,

  <\equation*>
    \<mu\>*<around|(|S\<otimes\>T|)>\<circ\><wide|\<mu\>|~><rsub|u,v>=<wide|\<mu\>|~><rsub|u<rprime|'>,v<rprime|'>>\<circ\>\<mu\><around|(|S|)>\<otimes\>\<mu\><around|(|T|)>,<eqno><around|(|2.4|)>
  </equation*>

  for objects <math|u>, <math|v>, <math|w>, <math|u<rprime|'>>,
  <math|v<rprime|'>> of <math|\<cal-A\>> and arrows
  <math|S\<in\><around|(|u,u<rprime|'>|)>>,
  <math|T\<in\><around|(|v,v<rprime|'>|)>>. This definition was given in
  <cite|PR>. Note that the most relevant axiom, <math|<around|(|2.3|)>>,
  implies associativity: <math|<wide|\<mu\>|~><rsub|u,v,w>\<assign\><wide|\<mu\>|~><rsub|u\<otimes\>v,w>\<circ\><wide|\<mu\>|~><rsub|u,v>\<otimes\>1<rsub|\<mu\><rsub|w>>=<wide|\<mu\>|~><rsub|u,v\<otimes\>w>\<circ\>1<rsub|\<mu\><rsub|u>>\<otimes\><wide|\<mu\>|~><rsub|v,w>>.
  If all the isometries <math|<wide|\<mu\>|~><rsub|u,v>> are unitary,
  <math|<around|(|2.3|)>>, is equivalent to associativity. In this case
  <math|<around|(|\<mu\>,<wide|\<mu\>|~>|)>> will be called a
  <with|font-shape|italic|relaxed tensor> functor. There are non-isomorphic
  compact quantum groups <math|G>, <math|G<rprime|'>> with tensor equivalent
  tensor <math|C<rsup|\<ast\>>>\Ucategories. A well known class of example is
  <math|S<rsub|\<mu\>>*U<around|(|2|)>> and <math|A<rsub|o><around|(|F|)>>
  for suitable conditions on <math|F>. Composition of an equivalence
  Rep<math|<around|(|G|)>\<to\><text|Rep><around|(|G<rprime|'>|)>> with the
  embending functor of Rep<math|<around|(|G<rprime|'>|)>> is a relaxed tensor
  functor Rep<math|<around|(|G|)>\<to\>>Hilb.

  For the spectral functor <math|L> of an ergodic action, the related
  isometries are given by <math|<wide|L|~><rsub|u,v><around|(|<big|sum>\<psi\><rsub|i>\<otimes\>c<rsub|i>|)>\<otimes\><around|(|\<phi\><rsub|j>\<otimes\>d<rsub|j>|)>=<big|sum><around|(|\<psi\><rsub|i>\<otimes\>\<phi\><rsub|j>|)>\<otimes\>d<rsub|j>*c<rsub|i>>.
  Note that the spectral space of a non spectral representation is trivial,
  hence, quasitensor functors, unlike the relaxed tensor ones, may take a
  nonzero object to the zero object.

  A quasitensor functor <math|<around|(|\<mu\>,<wide|\<mu\>|~>|)>> preserves
  conjugates, in the sense that if a nonzero object <math|u> of
  <math|\<cal-A\>> has a conjugate defined by arrows
  <math|R\<in\><around|(|\<iota\>,<wide|u|\<bar\>>\<otimes\>u|)>> and
  <math|<wide|R|\<bar\>>\<in\><around|(|\<iota\>,u\<otimes\><wide|u|\<bar\>>|)>>
  then <math|\<mu\><rsub|<wide|u|\<bar\>>>> is a conjugate of
  <math|\<mu\><rsub|u>>, defined by <math|<wide|R|^>=<wide|\<mu\>|~><rsub|<wide|u|\<bar\>>,u><rsup|\<ast\>>\<circ\>\<mu\><around|(|R|)>>,
  <math|<wide|<wide|R|\<bar\>>|^>=<wide|\<mu\>|~><rsub|u,<wide|u|\<bar\>>><rsup|\<ast\>>\<circ\>\<mu\><around|(|<wide|R|\<bar\>>|)>>.
  This is a straightforward consequence of the axioms. The property of
  conservation of conjugates of a quasitensor functor <math|\<mu\>> implies
  an estimate for the intrinsic dimension of an image object,
  <math|d<around|(|\<mu\><rsub|u>|)>\<leq\><around|\<\|\|\>|<wide|R|^>|\<\|\|\>><around|\<\|\|\>|<wide|<wide|R|\<bar\>>|^>|\<\|\|\>>\<leq\>d<around|(|u|)>>.

  Hence, in particular, for the spectral functor of an ergodic action we may
  associate an antilinear invertible map <math|J<rsub|u>:L<rsub|u>\<to\>L<rsub|<wide|u|\<bar\>>>>
  to a solution <math|<around|(|R<rsub|u>,<wide|R|\<bar\>><rsub|u>|)>> of the
  conjugate equations of a representation <math|u> of <math|G> by

  <\equation*>
    <big|sum><rsub|k>J<rsub|u>*T<rsub|k>\<otimes\>T<rsub|k>=<wide|L|~><rsub|<wide|u|\<bar\>>,u><rsup|\<ast\>>\<circ\>L<around|(|R<rsub|u>|)>,
  </equation*>

  where <math|T<rsub|k>> is an orthonormal basis of <math|L<rsub|u>>. For a
  spectral functor, the estimate of the intrinsic dimension of an image
  object becomes a multiplicity bound of an irreducible representation in the
  spectum of the related ergodic action. Indeed, the scalar
  <math|<around|\<\|\|\>|<wide|R|^>|\<\|\|\>><around|\<\|\|\>|<wide|<wide|R|\<bar\>>|^>|\<\|\|\>>>
  arising from the solution of the conjugate equations of an irreducible
  representation <math|u>, reduces to the quantum multiplicity
  <math|q-<text|mult><around|(|u|)>> of <cite|BDV>, while the intrinsic
  dimension of <math|L<rsub|u>> is just the integral dimension of
  <math|L<rsub|u>>, i.e. the ordinary multiplicity mult<math|<around|(|u|)>>
  of <math|u> in the action. The above estimate says
  mult<math|<around|(|u|)>\<leq\><text|q-mult><around|(|u|)>\<leq\>d<around|(|u|)>>
  a fact shown in <cite|BDV> refining the inequality
  mult<math|<around|(|u|)>\<leq\>d<around|(|u|)>> previously obtained by
  <cite|Boca>. In the classical case, i.e. when <math|G> is a compact group,
  the quantum dimension of a representation is just its integral dimension,
  and we thus in turn recover the classical result of Hegh-Krohn Landstad
  and Stormer that mult<math|<around|(|u|)>\<leq\><text|dim><around|(|H<rsub|u>|)>>.

  We shall need the following facts proved in <cite|PR>.

  <vspace|1fn><no-indent><with|font-series|bold|2.2. Lemma.>
  <with|font-shape|italic|Let <math|G> be a compact quantum group acting
  ergodically on a unital <math|C<rsup|\<ast\>>>\Ualgebra with spectral
  functor <math|<around|(|L,<wide|L|~>|)>>. If <math|J<rsub|u>> and
  <math|J<rsub|v>> are associated to solutions <math|j<rsub|u>> and
  <math|j<rsub|v>> of the conjugate equations for representations <math|u>
  and <math|v> of <math|G> respectively, then >

  <\with|font-shape|italic>
    <\description>
      <item><with|font-family|rm|a)> <math|J<rsub|u\<otimes\>v>*<wide|L|~><rsub|u,v>=<wide|L|~><rsub|<wide|v|\<bar\>>,<wide|u|\<bar\>>>*J<rsub|v>\<otimes\>J<rsub|u>*\<Theta\>>,
      where <math|J<rsub|u\<otimes\>v>> is associated to the tensor product
      solution for <math|u\<otimes\>v> and
      <math|\<Theta\>:L<rsub|u>\<otimes\>L<rsub|v>\<to\>L<rsub|v>\<otimes\>L<rsub|u>>
      is the flip map,

      <item><with|font-family|rm|b)> for any <math|A\<in\><around|(|u,v|)>>,
      <math|L*<around|(|j<rsub|v>*A*j<rsub|u><rsup|-1>|)>*J<rsub|u>=J<rsub|v>*L<around|(|A|)>>.
    </description>
  </with>

  <vspace|1fn>Recall that conversely, given a quasitensor functor
  <math|<around|(|\<mu\>,<wide|\<mu\>|~>|)>:<text|Rep><around|(|G|)>\<to\>>Hilb,
  we may associate a maximal ergodic action of <math|G> in the following way.
  Form the linear space <math|<rsup|\<circ\>>\<cal-C\><rsub|\<mu\>>\<assign\><big|sum><rsub|u\<in\><text|Rep><around|(|G|)>><wide|\<mu\><rsub|u>|\<bar\>>\<otimes\><rsub|<text|Rep><around|(|G|)>>H<rsub|u>>,
  where <math|\<otimes\><rsub|<text|Rep><around|(|G|)>>> indicates a suitable
  tensor product treating the arrows of Rep<math|<around|(|G|)>> as scalars.
  The algebraic operations are defined by, dropping the indices,
  <math|<around|(|<wide|k|\<bar\>>\<otimes\>\<psi\>|)>*<around|(|<wide|k<rprime|'>|\<bar\>>\<otimes\>\<psi\><rprime|'>|)>=<wide|\<mu\>|~><around|(|k\<otimes\>k<rprime|'>|)>\<otimes\><around|(|\<psi\>\<otimes\>\<psi\><rprime|'>|)>>,
  <math|<around|(|<wide|k|\<bar\>>\<otimes\>\<psi\>|)><rsup|\<ast\>>=<wide|J*k|\<bar\>>\<otimes\>j<rsup|-1\<ast\>>*\<psi\>>.
  The action of the quantum group on each subspace
  <math|<wide|\<mu\><rsub|u>|\<bar\>>\<otimes\>H<rsub|u>> is the tensor
  product of the trivial action on the first factor and the representation
  <math|u> on the second. This action is ergodic.

  Most importantly, the linear functional <math|\<omega\>> on
  <math|<rsup|\<circ\>>\<cal-C\><rsub|\<mu\>>> which annihilates each
  subspace <math|<wide|\<mu\><rsub|u>|\<bar\>>\<otimes\>H<rsub|u>>,
  <math|u\<in\><wide|G|^>>, <math|u\<neq\>\<iota\>> and takes <math|I> to
  <math|1> is a positive and faithful state, it is the unique state invariant
  under the action (i.e. <math|\<omega\>\<otimes\><text|id>\<circ\>\<alpha\>=\<omega\>>)
  . Therefore <math|<rsup|\<circ\>>\<cal-C\><rsub|\<mu\>>> has a
  <math|C<rsup|\<ast\>>>\Unorm. It turns out that the maximal
  <math|C<rsup|\<ast\>>>\Unorm is finite. We thus have at our disposal two
  possible completions of <math|<rsup|\<circ\>>\<cal-C\><rsub|\<mu\>>>, which
  are different in general, the completion in the maximal
  <math|C<rsup|\<ast\>>>\Unorm, denoted <math|\<cal-C\><rsub|\<mu\>>>, and
  the completion in the norm provided by the GNS representation
  <math|\<pi\><rsub|\<omega\>>> of the invariant state, called the reduced
  completion.

  The <math|G>\Uaction clearly extends to the maximal completion. In the case
  of the reduced completion, note that the action of <math|G> on
  <math|<rsup|\<circ\>>\<cal-C\><rsub|\<mu\>>> is in fact only an action of
  the dense spectral Hopf <rsup|<math|\<ast\>>>\Usubalgebra. This action
  extends to an action of the reduced compact quantum group
  <math|G<rsub|red>> and in turn it lifts to a normal action of the Hopf\Uvon
  Neumann algebra generated by the regular representation of <math|G> on the
  von Neumann algebra <math|\<pi\><rsub|\<omega\>><around|(|\<cal-C\>|)><rprime|''>>.
  In all these cases, the extended action is ergodic, see Theorem 2.5 of
  <cite|Wang>.

  <vspace|1fn><no-indent><with|font-shape|italic|Modular theory of the
  invariant state>. In view of the above results we may and shall think of
  the spectral functor of an ergodic <math|C<rsup|\<ast\>>>\Uaction of a
  compact quantum group <math|G> as an abstract quasitensor functor
  <math|<around|(|\<mu\>,<wide|\<mu\>|~>|)>:<text|Rep><around|(|G|)>\<to\>>Hilb.
  Correspondingly, we shall represent the dense spectral subalgebra with
  generators and relations described in the previous subsection.

  If <math|a=<wide|k|\<bar\>>\<otimes\>\<psi\>>,
  <math|b=<wide|k<rprime|'>|\<bar\>>\<otimes\>\<psi\><rprime|'>> have support
  in the irreducible representations <math|u> and <math|v> respectively then

  <\equation*>
    \<omega\>*<around|(|a<rsup|\<ast\>>*b|)>=\<delta\><rsub|u,v><around|\<\|\|\>|R<rsub|u>|\<\|\|\>><rsup|-2>*<around|(|k<rprime|'>,J<rsub|u><rsup|\<ast\>>*J<rsub|u>*k|)><around|(|\<psi\>,\<psi\><rprime|'>|)>,<eqno><around|(|2.5|)>
  </equation*>

  <\equation*>
    \<omega\>*<around|(|b*a<rsup|\<ast\>>|)>=\<delta\><rsub|u,v><around|\<\|\|\>|<wide|R|\<bar\>><rsub|u>|\<\|\|\>><rsup|-2><around|(|k<rprime|'>,k|)>*<around|(|\<psi\>,<around|(|j<rsub|u><rsup|\<ast\>>*j<rsub|u>|)><rsup|-1>*\<psi\><rprime|'>|)>,<eqno><around|(|2.6|)>
  </equation*>

  see Sect. 8 in <cite|PR> for explicit computations. These formulas may be
  used to derive modular properties of the invariant state, in turn
  generalizing the corresponding properties of the Haar state
  <cite|WoronowiczCMP|Boca>. In fact, for every irreducible representation
  <math|u> choose a standard solution <math|<around|(|R<rsub|u>,<wide|R|\<bar\>><rsub|u>|)>>.
  We have a densely defined multiplicative map such that on
  <math|<wide|\<mu\><rsub|u>|\<bar\>>\<otimes\>H<rsub|u>>,

  <\equation*>
    \<sigma\><rsub|-i>*<around|(|<wide|k|\<bar\>>\<otimes\>\<psi\>|)>=<wide|<around|(|J<rsub|u><rsup|\<ast\>>*J<rsub|u>|)>*k|\<bar\>>\<otimes\>j<rsub|u><rsup|\<ast\>>*j<rsub|u>*\<psi\>
  </equation*>

  with inverse

  <\equation*>
    \<sigma\><rsub|i>*<around|(|<wide|k|\<bar\>>\<otimes\>\<psi\>|)>=<wide|<around|(|J<rsub|u><rsup|\<ast\>>*J<rsub|u>|)><rsup|-1>*k|\<bar\>>\<otimes\><around|(|j<rsub|u><rsup|\<ast\>>*j<rsub|u>|)><rsup|-1>*\<psi\>.<eqno><around|(|2.7|)>
  </equation*>

  Since a different standard solution is of the form <math|U*j<rsub|u>>, with
  <math|U> unitary, the associated <math|J<rsub|u>> changes into
  <math|\<mu\><around|(|U|)>*J<rsub|u>>, hence <math|\<sigma\><rsub|-i>> and
  its inverse do not change. A quick computation shows that the KMS property
  holds,

  <\equation*>
    \<omega\>*<around|(|\<sigma\><rsub|-i><around|(|b|)>*a<rsup|\<ast\>>|)>=\<omega\>*<around|(|a<rsup|\<ast\>>*b|)>.
  </equation*>

  We may choose <math|j<rsub|<wide|u|\<bar\>>>=j<rsub|u><rsup|-1>>, which
  implies <math|J<rsub|<wide|u|\<bar\>>>=J<rsub|u><rsup|-1>>. It follows that
  <math|\<sigma\><rsub|-i><around|(|a<rsup|\<ast\>>|)>=\<sigma\><rsub|i><around|(|a|)><rsup|\<ast\>>>.
  We collect the conclusions of the above discussion. <vspace|1fn>

  <no-indent><with|font-series|bold|2.3. Theorem.>
  <with|font-shape|italic|The invariant state of an ergodic action of a
  compact quantum group <math|G> on a unital <math|C<rsup|\<ast\>>>\Ualgebra
  satisfies the KMS condition on the dense spectral subalgebra. It is a trace
  if and only if for any spectral irreducible representation <math|u> of
  <math|G>, >

  <\with|font-shape|italic>
    <\description>
      <item><with|font-family|rm|a)> <math|d<around|(|u|)>=<math-up|dim><around|(|u|)>>,
      i.e. the antilinear <math|j<rsub|u>> defining a standard solution is
      antiunitary, and

      <item><with|font-family|rm|b)> <math|q-<math-up|mult><around|(|u|)>=<math-up|mult><around|(|u|)>>,
      i.e. the associated <math|J<rsub|u>> is antiunitary.
    </description>
  </with>

  <vspace|1fn><vspace|1fn><no-indent>Recall that the condition
  <math|d<around|(|u|)>=<text|dim><around|(|u|)>> for all <math|u> means
  precisely that the quantum group is of Kac type, i.e. it has involutive
  coinverse. For example, quantum dimensions of the real deformations
  <math|G<rsub|q>>, <math|0\<less\>q\<less\>1> of classical compact Lie
  groups are known to be strictly larger than the corresponding integral
  dimensions, hence the invariant state of any ergodic
  <math|C<rsup|\<ast\>>>\Ualgebra under the action of any of these quantum
  groups is not a trace. <vspace|1fn>

  <no-indent><with|font-shape|italic|Almost periodicity of the invariant
  state.> If <math|<around|(|\<cal-C\>,\<alpha\>,G|)>> is an ergodic action
  of a compact quantum group, the dense spectral subalgebra of
  <math|\<cal-C\>> is the domain of a one parameter group of
  <rsup|<math|\<ast\>>>\Uautomorphisms, the modular group, given by

  <\equation*>
    \<sigma\><rsub|t>*<around|(|<wide|k|\<bar\>>\<otimes\>\<psi\>|)>=<wide|<around|(|J<rsub|u><rsup|\<ast\>>*J<rsub|u>|)><rsup|i*t>*k|\<bar\>>\<otimes\><around|(|j<rsub|u><rsup|\<ast\>>*j<rsub|u>|)><rsup|-i*t>*\<psi\>.
  </equation*>

  This group extends to a one parameter automorphism group of the maximal
  completion <math|\<cal-C\><rsub|\<mu\>>>. Moreover, it extends to
  <math|\<pi\><rsub|\<omega\>><around|(|\<cal-C\><rsub|\<mu\>>|)>> or
  <math|M\<assign\>\<pi\><rsub|\<omega\>><around|(|\<cal-C\><rsub|\<mu\>>|)><rprime|''>>
  as well since it leaves <math|\<omega\>> invariant. In this subsection we
  only consider the extension to the von Neumann algebra <math|M>. Note that
  the cyclic vector <math|\<Omega\>> associated to the GNS representation of
  <math|\<omega\>> is separating for <math|M>. This may be shown with
  arguments similar to those of Sect. 4 of <cite|DLRZ>. Hence, by the KMS
  property, <math|\<sigma\><rsub|i>> becomes the restriction of the modular
  operator <math|\<Delta\><rsub|\<omega\>>> associated to <math|\<omega\>>
  under the canonical inclusion <math|<rsup|\<circ\>>\<cal-C\><rsub|\<mu\>>\<to\>L<rsup|2><around|(|\<cal-C\>,\<omega\>|)>>.
  Recall that Connes defined a normal faithful state <math|\<phi\>> on a von
  Neumann algebra to be <with|font-shape|italic|almost periodic> if
  <math|\<Delta\><rsub|\<phi\>>> is diagonal. In the case of an ergodic
  action, the expressions for the inner product <math|<around|(|2.5|)>> and
  for <math|\<sigma\><rsub|i>>, <math|<around|(|2.7|)>>, show that the cyclic
  state of <math|M> thus obtained is always almost periodic. Moreover, the
  point spectrum of <math|\<Delta\><rsub|\<omega\>>> is completely determined
  by the eigenvalues if <math|j<rsub|u><rsup|\<ast\>>*j<rsub|u>> and
  <math|J<rsub|u><rsup|\<ast\>>*J<rsub|u>> for <math|u> describing a complete
  set of irreducible spectral representations. While the spectrum of
  <math|j<rsub|u><rsup|\<ast\>>*j<rsub|u>> is a structural property of the
  quantum group, that of <math|J<rsub|u><rsup|\<ast\>>*J<rsub|u>>, depends on
  the ergodic action, and this is the most mysterious part. Indeed, although
  <math|J<rsub|u>> is explicitly associated with <math|j<rsub|u>>, we can not
  infer that properties of <math|j<rsub|u>> pass to <math|J<rsub|u>>. For
  example, we may have <math|j<rsub|u>> antiunitary for all spectral <math|u>
  but <math|J<rsub|u>> not antiunitary, or, in other words, we may have
  ergodic actions of compact quantum groups of Kac type on a unital
  <math|C<rsup|\<ast\>>>\Ualgebra <math|\<cal-C\>> for which
  <math|M=\<pi\><rsub|\<omega\>><around|(|\<cal-C\>|)><rprime|''>> is a type
  III factor <cite|Wang>. Similarly, we may have <math|j<rsub|u>> not
  antiunitary for all spectral <math|u> but <math|J<rsub|u>> always
  antiunitary, as in the examples arising from subfactors, described in
  detail in <cite|PRsubfactors>. <vspace|1fn>

  We conclude this section with a few more remarks on the modular theory of
  <math|<around|(|\<cal-C\>,\<alpha\>,G|)>>. Let
  Sp<math|<around|(|\<Delta\><rsub|\<omega\>>|)>>
  (Sp<math|<rsub|p><around|(|\<Delta\><rsub|\<omega\>>|)>>) denote the
  spectrum (point spectrum) of <math|\<Delta\><rsub|\<omega\>>>. The
  following fact may be known, a proof is included for convenience.

  <vspace|1fn><no-indent><with|font-series|bold|2.4. Theorem.>
  <with|font-shape|italic|If an ergodic <math|C<rsup|\<ast\>>>\Uaction of a
  compact quantum group <math|G> on <math|\<cal-C\>> admits a spectral
  irreducible representation <math|u> of <math|G> such that
  <math|d<around|(|u|)>\<gtr\><text|<with|font-shape|italic|font-family|rm|dim>><around|(|u|)>>
  then <with|font-shape|italic|font-family|rm|Sp><math|<rsub|p><around|(|\<Delta\><rsub|\<omega\>>|)>\<neq\><around|{|1|}>>.
  If in addition both <math|M=\<pi\><rsub|\<omega\>><around|(|\<cal-C\>|)><rprime|''>>
  and the centralizer <math|M<rsub|\<omega\>>> are factors, then <math|M> is
  of type <with|font-family|rm|III><rsub|<math|\<lambda\>>> with
  <math|0\<less\>\<lambda\>\<leq\>1>. <vspace|1fn><no-indent>Proof If
  <math|u> is a spectral irreducible representation for which
  <math|j<rsub|u>> is not antiunitary, then
  <math|j<rsub|u><rsup|\<ast\>>*j<rsub|u>> has an eigenvalue <math|\<less\>1>
  and another <math|\<gtr\>1> since <math|j<rsub|u>> is standard. Hence
  <math|\<Delta\><rsub|\<omega\>>> has an eigenvalue <math|\<neq\>1> on
  <math|<wide|\<mu\><rsub|u>|\<bar\>>\<otimes\>H<rsub|u>>. If <math|M> and
  <math|M<rsub|\<omega\>>> are factors, it is well known that
  <math|S<around|(|M|)>=<text|Sp><around|(|\<Delta\><rsub|\<omega\>>|)>>,
  with <math|S<around|(|M|)>> the Connes invariant (Cor. 3.2.7 in
  <cite|ConnesIII>). Hence <math|S<around|(|M|)>\<neq\><around|{|1|}>> and
  <math|S<around|(|M|)>\<neq\><around|{|0,1|}>>, so <math|M> is not
  semifinite or of type <with|font-family|rm|III><rsub|<math|0>>.
  <vspace|1fn>>

  In the next section we shall give general lower and upper bounds for the
  eigenvalues of the modular operator <math|\<Delta\><rsub|\<omega\>>>,
  depending only on the quantum group. We shall derive a general lower bound
  for the possible parameters <math|0\<less\>\<lambda\>\<less\>1> such that
  <math|M=\<pi\><rsub|\<omega\>><around|(|\<cal-C\>|)><rprime|''>> is a
  factor of type III<rsub|<math|\<lambda\>>> with a factorial centralizer
  <math|M<rsub|\<omega\>>>.

  <vspace|1fn><section|An analogue of the finiteness theorem for CQG>

  We have thus seen that the point spectrum of the modular operator
  <math|\<Delta\><rsub|\<omega\>>> associated to an ergodic action is
  completely determined by the spectra of the positive matrices
  <math|<around|(|J<rsub|u><rsup|\<ast\>>*J<rsub|u>|)>\<otimes\><around|(|j<rsub|u><rsup|\<ast\>>*j<rsub|u>|)>>
  associated to the spectral irreducible representations <math|u> of the
  quantum group.

  In this section we derive a general estimate for the eigenvalues of the
  operators <math|J<rsub|u><rsup|\<ast\>>*J<rsub|u>>. Our estimate involves
  the growth rate of the quantum dimension of <math|u>. It allows to
  reproduce the finiteness result of <cite|HLS>, and also to derive various
  other modular properties of the invariant state.

  We define the growth rate of the intrinsic dimension of an object <math|u>
  of a tensor <math|C<rsup|\<ast\>>>\Ucategory,

  <\equation*>
    D<rsub|u,n>\<assign\>max <around|{|d<around|(|v|)>,<text|irreducible
    subobjects <math|v> of >u<rsup|\<otimes\>n>|}>,
  </equation*>

  <\equation*>
    D<rsub|u>\<assign\>lim<rsub|n><around|(|D<rsub|u,n>|)><rsup|1/n>.
  </equation*>

  This limit always exists since <math|D<rsub|u,n>> is a submultiplicative
  sequence. Note that <math|D<rsub|u>\<leq\>d<around|(|u|)>>,
  <math|D<rsub|u>=D<rsub|v>> if <math|u> and <math|v> are equivalent, and
  <math|D<rsub|<wide|u|\<bar\>>>=D<rsub|u>>. We say that the intrinsic
  dimension of <math|u> has subexponential (exponential) growth if
  <math|D<rsub|u>=1> (<math|D<rsub|u>\<gtr\>1>). Note that if <math|w> is a
  subrepresentation of some tensor power <math|u<rsup|\<otimes\>k>> of
  <math|u>, <math|D<rsub|w>\<leq\>D<rsub|u><rsup|k>>. Hence, if the tensor
  powers of <math|u> contain all the irreducibles and if
  <math|d<around|(|u|)>> has subexponential growth so does every
  irreducible.<vspace|1fn>

  <no-indent><with|font-series|bold|3.1. Example.> Let <math|G> be a compact
  group. In this case the quantum dimension of any representation <math|u> is
  just the integral dimension of the corresponding Hilbert space. It is known
  that this dimension always has polynomial, and hence subexponential,
  growth. This fact relies on Weyl's dimension formula and played an
  important role in the original proof of the finiteness theorem of
  <cite|HLS>. <vspace|1fn>

  Let <math|<around|(|\<cal-C\>,\<alpha\>|)>> be an ergodic action of a
  compact quantum group <math|G> on a unital <math|C<rsup|\<ast\>>>\Ualgebra.
  We shall also need to consider the growth rate of integral multiplicities
  of irreducible representations of <math|G>. Given a representation
  <math|u>, set

  <\equation*>
    <text|Mult><rsub|u,n>\<assign\>max <around|{|<text|mult><around|(|v|)>,<text|irreducible
    subrepresentations <math|v> of >u<rsup|\<otimes\>n>|}>,
  </equation*>

  <\equation*>
    <text|Mult><rsub|u>\<assign\>liminf<rsub|n><text|Mult><rsub|u,n><rsup|1/n>,
  </equation*>

  which enjoys properties similar to those of <math|D<rsub|u>>. In the
  particular case of the translation action of <math|G> over itself, integral
  multiplicities mult<math|<around|(|u|)>> reduce to integral dimensions
  dim<math|<around|(|u|)>>. We shall accordingly denote the corresponding
  growth rate by Dim<rsub|<math|u>> and refer to it as the growth rate of
  integral multiplicities. In both cases, we have the notion of
  subexponential or exponential growth. A comparison between the various
  growth rates introduced may be easily derived,

  <\equation*>
    <text|Mult><rsub|u>\<leq\>D<rsub|u>,<space|1em><text|Dim><rsub|u>\<leq\>D<rsub|u>.
  </equation*>

  <vspace|1fn>

  <no-indent><with|font-series|bold|3.2. Example.> Let <math|G> be a
  classical compact Lie group and <math|G<rsub|q>> the associated deformed
  compact matrix quantum group by a positive parameter
  <math|0\<less\>q\<less\>1>. The integral dimensions of irreducibles have
  subexponential growth as they are the same as in the classical case. On the
  other hand, the quantum dimensions of irreducibles have exponential growth
  rate. This last assertion is known. However, it may also be derived from
  the following proposition. Indeed, <math|D<rsub|u>=1> would imply
  <math|\<lambda\><rsub|u>=\<Lambda\><rsub|u>=1>, hence <math|j<rsub|u>>
  antiunitary. <vspace|1fn>

  <no-indent><with|font-series|bold|3.3. Proposition.>
  <with|font-shape|italic|For any representation <math|u> of a compact
  quantum group,>

  <with|font-shape|italic|<\equation*>
    D<rsub|u><rsup|-1>\<leq\>\<lambda\><rsub|u>\<leq\>\<Lambda\><rsub|u>\<leq\>D<rsub|u>.
  </equation*>>

  <with|font-shape|italic|If <with|font-shape|italic|font-family|rm|Dim><math|<rsub|u>=1>
  then the first and last inequalities are equalities.><vspace|1fn>

  <no-indent><with|font-shape|italic|Proof> The middle inequality being
  obvious, it suffices to show that <math|\<Lambda\><rsub|u>\<leq\>D<rsub|u>>,
  as <math|\<lambda\><rsub|u>\<geq\>D<rsub|u><rsup|-1>> follows passing to
  the conjugate solution. The <math|n>\Uth tensor product solution
  <math|j<rsub|u<rsup|\<otimes\>n>>=<around|(|j<rsub|u>\<otimes\>\<ldots\>\<otimes\>j<rsub|u>|)>*\<theta\><rsub|n>>
  for <math|u<rsup|\<otimes\>n>>, with <math|\<theta\><rsub|n>> a suitable
  permutation operator, is standard if <math|j<rsub|u>> is. If <math|v> is an
  irreducible subrepresentation of <math|u<rsup|\<otimes\>n>> and
  <math|j<rsub|v>> is a standard solution for <math|v>,
  <math|d<around|(|v|)>=<text|Trace><around|(|j<rsub|v><rsup|\<ast\>>*j<rsub|v>|)>\<geq\>\<Lambda\><rsub|v>>.
  Hence

  <\equation*>
    D<rsub|u,n>\<geq\>max <around|{|\<Lambda\><rsub|v>,v*<text|irreducible
    subrepresentation of >u<rsup|\<otimes\>n>|}>=
  </equation*>

  <\equation*>
    \<Lambda\><rsub|u<rsup|\<otimes\>n>>=\<Lambda\><rsub|u><rsup|n>.
  </equation*>

  On the other hand <math|d<around|(|v|)>\<leq\>\<Lambda\><rsub|v><text|dim><around|(|v|)>>
  implies

  <\equation*>
    D<rsub|u,n>\<leq\>\<Lambda\><rsub|u<rsup|\<otimes\>n>><text|Dim><rsub|u,n>=\<Lambda\><rsub|u><rsup|n><text|Dim><rsub|u,n>,
  </equation*>

  hence <math|D<rsub|u>\<leq\>\<Lambda\><rsub|u>> if the integral dimension
  of <math|u> has subexponential growth rate. <vspace|1fn>

  <no-indent><with|font-shape|italic|Remark> This proposition may be used to
  explain why the spectrum of the associated matrices
  <math|j<rsub|u><rsup|\<ast\>>*j<rsub|u>> has a symmetric shape for the
  deformed compact matrix quantum groups <math|G<rsub|q>>. <vspace|1fn>

  For the Wang-Van Daele quantum groups <math|A<rsub|o><around|(|F|)>> and
  <math|A<rsub|u><around|(|F|)>>, we follow the notation of <cite|Banica>. We
  shall always normalize <math|F> so that
  Trace<math|<around|(|F<rsup|\<ast\>>*F|)>=<text|Trace><around|(|<around|(|F<rsup|\<ast\>>*F|)><rsup|-1>|)>>.
  Recall that for <math|A<rsub|o><around|(|F|)>>, the matrix <math|F> is
  required to satisfy <math|F*<wide|F|\<bar\>>=\<pm\>1>. <vspace|1fn>

  <no-indent><with|font-series|bold|3.4. Example.> If <math|u> is the
  fundamental representation of <math|A<rsub|u><around|(|F|)>>, with
  rank<math|<around|(|F|)>\<geq\>2>, all tensor powers
  <math|u<rsup|\<otimes\>n>> are irreducible <cite|Banica>, showing that
  <math|D<rsub|u,n>=d<around|(|u|)><rsup|n>> by multiplicativity of quantum
  dimension. Hence <math|D<rsub|u>=d<around|(|u|)>=<text|Trace><around|(|F<rsup|\<ast\>>*F|)>>
  is the largest possible value. Similarly,
  Dim<math|<rsub|u>=<text|dim><around|(|u|)>>. In particular, the extreme
  inequalities in Prop. 3.3 are always strict (the first examples being
  <math|A<rsub|u><around|(|m|)>>, <math|\<lambda\><rsub|u>=\<Lambda\><rsub|u>=1>
  but <math|D<rsub|u>=<text|Dim><rsub|u>=m>), while the middle inequality is
  generically strict. <vspace|1fn>

  <no-indent><with|font-series|bold|3.5. Example.> If <math|u<rsub|1>> is the
  fundamental representation of <math|G=S<rsub|q>*U<around|(|2|)>>, for a
  nonzero <math|<around|\||q|\|>\<leq\>1>,
  <math|<around|\||q|\|><rsup|1/2>*R=\<psi\><rsub|1>\<otimes\>\<psi\><rsub|2>-q*\<psi\><rsub|2>\<otimes\>\<psi\><rsub|1>>
  is a standard solution, hence <math|j<rsub|u<rsub|1>><rsup|\<ast\>>*j<rsub|u<rsub|1>>=<text|diag><around|(|<around|\||q|\|>,<around|\||q|\|><rsup|-1>|)>>.
  Let <math|u<rsub|r>> be the unique irreducible <math|r+1>\Udimensional
  representation. The Clebsch\UGordan rule
  <math|u<rsub|1>\<otimes\>u<rsub|r>\<simeq\>u<rsub|r-1>\<oplus\>u<rsub|r+1>>
  gives <math|j<rsub|u<rsub|r>><rsup|\<ast\>>*j<rsub|u<rsub|r>>=<text|diag><around|(|<around|\||q|\|><rsup|r>,<around|\||q|\|><rsup|r-2>,\<ldots\>,<around|\||q|\|><rsup|-r>|)>>.
  Hence <math|\<lambda\><rsub|u<rsub|r>>=\<Lambda\><rsub|u<rsub|r>><rsup|-1>=D<rsub|u<rsub|r>><rsup|-1>=<around|\||q|\|><rsup|r>>.

  <vspace|1fn><no-indent><with|font-series|bold|3.6. Example.> Consider the
  quantum group <math|A<rsub|o><around|(|F|)>>. It is well known that the
  representation categories of <math|A<rsub|o><around|(|F|)>> and
  <math|S<rsub|\<mp\>q>*U<around|(|2|)>> are tensor equivalent if
  <math|q\<gtr\>0> is defined by <math|q+<frac|1|q>=<text|Trace><around|(|F<rsup|\<ast\>>*F|)>>.
  Hence <math|D<rsup|A<rsub|o><around|(|F|)>><rsub|u<rsub|r>>=q<rsup|-r>> by
  3.5. Note that <math|\<lambda\><rsub|u<rsub|r>>=\<Lambda\><rsub|u<rsub|r>><rsup|-1>>.
  This follows from the validity for <math|r=1> and the Clebsch-Gordan rule.
  A computation shows that for every <math|F> and for the fundamental
  representation <math|u<rsub|1>>, the extreme inequalities in Prop. 3.3 are
  strict iff rank<math|<around|(|F|)>\<geq\>3>.

  <vspace|1fn><no-indent><with|font-series|bold|3.7. Example.> For
  rank<math|<around|(|F|)>\<geq\>3>, the integral dimension of the
  fundamental representation <math|u<rsub|1>> of
  <math|A<rsub|o><around|(|F|)>> has exponential growth. This may be seen in
  the following way. Independently of the matrix <math|F>, irreducible
  representations of <math|A<rsub|o><around|(|F|)>> satisfy the same fusion
  rules as those of <math|S*U<around|(|2|)>> <cite|Banica>. Hence, denoting
  with the same symbol the corresponding irreducible representations, the
  integral dimensions are determined by the Clebsch\UGordan rule,
  dim<math|<around|(|u<rsub|r+1>|)>=<text|dim><around|(|u<rsub|1>|)><text|dim><around|(|u<rsub|r>|)>-<text|dim><around|(|u<rsub|r-1>|)>\<geq\>2<text|dim><around|(|u<rsub|r>|)>>,
  hence Dim<math|<rsub|u<rsub|1>,r>=<text|dim><around|(|u<rsub|r>|)>\<geq\>2<rsup|r-1><text|dim><around|(|u<rsub|1>|)>>.
  <vspace|1fn>

  The following is our main result. <vspace|1fn>

  <no-indent><with|font-series|bold|3.8. Theorem.>
  <with|font-shape|italic|For any spectral irreducible representation
  <math|u> of an ergodic action of a compact quantum group on a unital
  <math|C<rsup|\<ast\>>>\Ualgebra, >

  <\with|font-shape|italic>
    <\description>
      <item><with|font-family|rm|a)> <math|D<rsub|u><rsup|-1>\<leq\>J<rsub|u><rsup|\<ast\>>*J<rsub|u>\<leq\>D<rsub|u>>,
      where <math|J<rsub|u>> is associated to a standard solution
      <math|j<rsub|u>> for <math|u>.

      <item><with|font-family|rm|b)> If the spectral functor is relaxed
      tensor and if <with|font-family|rm|Mult><math|<rsub|u>=1> then
      <math|<frac|1|D<rsub|u>>> and <math|D<rsub|u>> are respectively the
      smallest and the largest eigenvalues of
      <math|J<rsub|u><rsup|\<ast\>>*J<rsub|u>>.
    </description>
  </with>

  <vspace|1fn><no-indent><with|font-shape|italic|Proof> a) The first
  inequality follows from the second applied to <math|<wide|u|\<bar\>>>. By
  Lemma 2.2 a), for any positive integer <math|n>, if <math|J<rsub|u>> is
  associated to any solution <math|j<rsub|u>> for <math|u>,

  <\equation*>
    <around|\<\|\|\>|J<rsub|u><rsup|\<ast\>>*J<rsub|u>|\<\|\|\>><rsup|n>=<around|\<\|\|\>|J<rsub|u><rsup|\<ast\>>*J<rsub|u>\<otimes\>\<ldots\>\<otimes\>J<rsub|u><rsup|\<ast\>>*J<rsub|u>|\<\|\|\>>=
  </equation*>

  <\equation*>
    <around|\<\|\|\>|<wide|\<mu\>|~><rsub|u,\<ldots\>,u><rsup|\<ast\>>*J<rsub|u<rsup|\<otimes\>n>><rsup|\<ast\>>*J<rsub|u<rsup|\<otimes\>n>>*<wide|\<mu\>|~><rsub|u,\<ldots\>,u>|\<\|\|\>>\<leq\><around|\<\|\|\>|J<rsub|u<rsup|\<otimes\>n>><rsup|\<ast\>>*J<rsub|u<rsup|\<otimes\>n>>|\<\|\|\>>,
  </equation*>

  where <math|J<rsub|u<rsup|\<otimes\>n>>> is associated to the <math|n>\Uth
  tensor product solution <math|j<rsub|u<rsup|\<otimes\>n>>=<around|(|j<rsub|u>\<otimes\>\<ldots\>\<otimes\>j<rsub|u>|)>*\<theta\><rsub|n>>
  for <math|u<rsup|\<otimes\>n>>. Consider a complete reduction of
  <math|u<rsup|\<otimes\>n>> into a direct sum of irreducible representations
  <math|v> and let <math|S<rsub|v>\<in\><around|(|v,u<rsup|\<otimes\>n>|)>>
  be the isometry associated to <math|v>. We may compute
  <math|<around|\<\|\|\>|J<rsub|u<rsup|\<otimes\>n>><rsup|\<ast\>>*J<rsub|u<rsup|\<otimes\>n>>|\<\|\|\>>>
  as the norm of the positive operator\Uvalued matrix
  <math|<around|(|\<mu\><around|(|S<rsub|v><rsup|\<ast\>>|)>*J<rsub|u<rsup|\<otimes\>n>><rsup|\<ast\>>*J<rsub|u<rsup|\<otimes\>n>>*\<mu\><around|(|S<rsub|w>|)>|)><rsub|v,w>>.
  By lemma 2.2 b), <math|\<mu\>*<around|(|j<rsub|u<rsup|\<otimes\>n>>*S<rsub|v>*j<rsub|v><rsup|-1>|)>*J<rsub|v>=J<rsub|u<rsup|\<otimes\>n>>*\<mu\><around|(|S<rsub|v>|)>>,
  with respect to any solution <math|j<rsub|v>> for <math|v>, with associated
  <math|J<rsub|v>>. Now we fix standard solutions for <math|u> and all the
  <math|v>. Since <math|j<rsub|u<rsup|\<otimes\>n>>> is standard, we may find
  <math|<around|{|S<rsub|v>|}>> such that
  <math|j<rsub|u<rsup|\<otimes\>n>>*S<rsub|v>*j<rsub|v><rsup|-1>=:<wide|S|\<bar\>><rsub|v>>
  are pairwise orthogonal isometries. Hence

  <\equation*>
    \<mu\><around|(|S<rsub|v><rsup|\<ast\>>|)>*J<rsub|u<rsup|\<otimes\>n>><rsup|\<ast\>>*J<rsub|u<rsup|\<otimes\>n>>*\<mu\><around|(|S<rsub|w>|)>=J<rsub|v><rsup|\<ast\>>*\<mu\>*<around|(|<wide|S|\<bar\>><rsub|v><rsup|\<ast\>>*<wide|S|\<bar\>><rsub|w>|)>*J<rsub|w>=\<delta\><rsub|v,w>*J<rsub|v><rsup|\<ast\>>*J<rsub|w>.
  </equation*>

  Combination with the previous estimate gives,

  <\equation*>
    <around|\<\|\|\>|J<rsub|u><rsup|\<ast\>>*J<rsub|u>|\<\|\|\>>\<leq\><around|\<\|\|\>|<text|diag><rsub|v><around|(|J<rsub|v><rsup|\<ast\>>*J<rsub|v>|)>|\<\|\|\>><rsup|1/n>=<around|(|max<rsub|v><around|{|<around|\<\|\|\>|J<rsub|v><rsup|\<ast\>>*J<rsub|v>|\<\|\|\>>|}>|)><rsup|1/n>\<leq\>
  </equation*>

  <\equation*>
    <around|(|max<rsub|v><around|{|<text|Trace><around|(|J<rsub|v><rsup|\<ast\>>*J<rsub|v>|)>|}>|)><rsup|1/n>=<around|(|max<rsub|v><around|{|<around|\<\|\|\>|<wide|R<rsub|v>|^>|\<\|\|\>><rsup|2>|}>|)><rsup|1/n>\<leq\><around|(|max<rsub|v><around|{|<around|\<\|\|\>|R<rsub|v>|\<\|\|\>><rsup|2>|}>|)><rsup|1/n>=D<rsub|u,n><rsup|1/n>.
  </equation*>

  b) If the spectral functor is relaxed tensor, all the
  <math|<wide|\<mu\>|~>> are unitary, hence the first and the last
  inequalities are equalities. On the other hand the estimate
  <math|max<rsub|v><around|{|<text|Trace><around|(|J<rsub|v><rsup|\<ast\>>*J<rsub|v>|)>|}>\<leq\>max<rsub|v><around|{|<around|\<\|\|\>|J<rsub|v><rsup|\<ast\>>*J<rsub|v>|\<\|\|\>>|}><text|Mult><rsub|u,n>>
  shows that <math|<around|\<\|\|\>|J<rsub|u><rsup|\<ast\>>*J<rsub|u>|\<\|\|\>>=D<rsub|u>>
  if the integral multiplicity of <math|u> has subexponential growth.
  <vspace|1fn>

  <no-indent><with|font-series|bold|3.9. Corollary.> <cite|HLS>
  <with|font-shape|italic|The invariant state of an ergodic action of a
  compact group on a unital <math|C<rsup|\<ast\>>>\Ualgebra is a
  trace.><vspace|1fn>

  <no-indent><with|font-shape|italic|Proof> As recalled above, for all
  <math|u>, <math|D<rsub|u,n>> has polynomial growth. Hence <math|J<rsub|u>>
  are all antiunitary by Theorem 3.8. On the other hand the same holds in the
  classical case for standard solutions <math|j<rsub|u>> of
  <math|G>\Urespresentations, hence we may apply Theorem 2.3. <vspace|1fn>

  We next discuss examples satisfying b) with <math|D<rsub|u>\<gtr\>1> and
  which are not translation actions.<vspace|1fn>

  <no-indent><with|font-series|bold|3.10. Example.> More in detail, let
  <math|G<rsub|q>> be as above a deformed classical compact Lie group, and
  let <math|\<Phi\>:<text|Rep><around|(|G<rprime|'>|)>\<to\><text|Rep><around|(|G<rsub|q>|)>>
  be a tensor equivalence, with <math|G<rprime|'>> another compact matrix
  quantum group (e.g. <math|G=S*U<around|(|2|)>> and
  <math|G<rprime|'>=A<rsub|o><around|(|F|)>>). The composition
  <math|\<mu\>:<text|Rep><around|(|G<rprime|'>|)>\<to\><text|Rep><around|(|G<rsub|q>|)>\<to\>>Hilb
  with the embedding functor of Rep<math|<around|(|G<rsub|q>|)>> is a relaxed
  tensor functor. Consider the maximal ergodic action associated to
  <math|\<mu\>>. The integral multiplicity of an irreducible representation
  <math|u> of <math|G<rprime|'>> is the integral dimension of
  <math|\<Phi\><around|(|u|)>>, which is the same as in the classical case,
  hence Mult<math|<rsub|u><rsup|G<rprime|'>>=<text|Dim><rsub|\<Phi\><around|(|u|)>><rsup|G<rsub|q>>=1>.
  Note that these are just the inverses of the tensor equivalences of
  <cite|BDV>. <vspace|1fn>

  <no-indent><with|font-series|bold|3.11. Corollary.>
  <with|font-shape|italic|If a compact quantum group <math|G> of Kac type
  admits an ergodic action on a unital <math|C<rsup|\<ast\>>>\Ualgebra with
  non-tracial invariant state then the integral dimension of some spectral
  irreducible representation of <math|G> has exponential growth.><vspace|1fn>

  <no-indent><with|font-shape|italic|Proof> Since <math|G> has involutive
  coinverse, every standard solution <math|j<rsub|u>> is antiunitary. If all
  the quantum dimensions of spectral irreducibles <math|u> had subexponential
  growth, the associated <math|J<rsub|u>> would be antiunitary by Theorem
  3.8., hence the invariant state would be a trace by Theorem 2.3.
  <vspace|1fn>

  <no-indent><with|font-series|bold|3.12. Corollary.>
  <with|font-shape|italic|<math|S<rsub|-1>*U<around|(|d|)>> acts ergodically
  only on tracial <math|C<rsup|\<ast\>>>\Ualgebras.><vspace|1fn>

  <no-indent><with|font-series|bold|3.13. Corollary.>
  <with|font-shape|italic|Let <math|G> be a compact quantum group acting
  ergodically on <math|\<cal-C\>> and admitting a spectral irreducible
  representation <math|u> s.t. <math|d<around|(|u|)>\<gtr\><text|<with|font-shape|italic|font-family|rm|dim>><around|(|u|)>>.
  Assume that <math|M\<assign\>\<pi\><rsub|\<omega\>><around|(|\<cal-C\>|)><rprime|''>>
  and <math|M<rsub|\<omega\>>> are factors. >

  <\with|font-shape|italic>
    <\description>
      <item><with|font-family|rm|a)> If <math|M> is of type
      <with|font-family|rm|III><rsub|<math|\<lambda\>>>,
      <math|0\<less\>\<lambda\>\<less\>1>, then

      <\equation*>
        \<lambda\>\<geq\>sup <around|{|<frac|min
        <around|{|\<lambda\><rsub|u>,\<Lambda\><rsub|u><rsup|-1>|}>|D<rsub|u>>,u*<text|spectral
        irr. s.t. >d<around|(|u|)>\<gtr\><math-up|dim><around|(|u|)>|}>,
      </equation*>

      <item><with|font-family|rm|b)> if the above supremum is <math|1>,
      <math|M> is of type <with|font-family|rm|III><rsub|<math|1>>.
    </description>
  </with>

  <vspace|1fn><no-indent><with|font-shape|italic|Proof> a) Let <math|u> be a
  spectral irreducible representation such that
  <math|d<around|(|u|)>\<gtr\><text|dim><around|(|u|)>>. As argued in Theorem
  2.4., the modular group of <math|\<omega\>> does not act trivially on the
  spectral subspace <math|<wide|\<mu\><rsub|u>|\<bar\>>\<otimes\>H<rsub|u>>.
  On the other hand, the smallest and largest eigenvalues of the restriction
  of the modular operator <math|\<Delta\><rsub|\<omega\>>> to
  <math|<wide|\<mu\><rsub|u>|\<bar\>>\<otimes\>H<rsub|u>> are bounded below
  by <math|<frac|1|D<rsub|u>*\<Lambda\><rsub|u>>> and above by
  <math|<frac|D<rsub|u>|\<lambda\><rsub|u>>>. Taking into consideration the
  fact that the eigenvalues of <math|\<Delta\><rsub|\<omega\>>> belong to
  <math|S<around|(|M|)>>, we see that either
  <math|<frac|1|D<rsub|u>*\<Lambda\><rsub|u>>\<leq\>\<lambda\>> or
  <math|\<lambda\><rsup|-1>\<leq\><frac|D<rsub|u>|\<lambda\><rsub|u>>>. b) If
  the supremum is 1, by a), <math|M> is not of type
  III<rsub|<math|\<lambda\>>> for any <math|0\<less\>\<lambda\>\<less\>1>.
  Hence <math|M> must be of type III<rsub|<math|1>> by Theorem 2.4.
  <vspace|1fn>

  <no-indent><with|font-shape|italic|Remark> If the quantum group is of Kac
  type, under the same assumptions of the previous corollary, we may derive
  <math|\<lambda\>\<geq\><frac|1|n>>, with <math|n> the minimal dimension of
  a spectral irreducible representation for which the restriction of the
  modular group on the associated spectral subspace is non-trivial. For
  example, for the ergodic actions of <math|A<rsub|u><around|(|n|)>> on the
  type III<rsub|<math|<frac|1|n>>> factors of <cite|Wang>, the spectral space
  of the fundamental representation carries a non trivial action of the
  modular group. This example shows that <math|D<rsub|u>>, together with
  triviality of the modular theory of <math|A<rsub|u><around|(|n|)>>, explain
  completely the factorial type.<vspace|1fn>

  If <math|\<lambda\><rsub|u>=D<rsub|u><rsup|-1>=\<Lambda\><rsub|u><rsup|-1>>,
  e.g. under the condition of Prop. 3.3, the lower bound for
  <math|\<lambda\>> becomes simply <math|sup
  <around|{|\<lambda\><rsub|u><rsup|2>,u:d<around|(|u|)>\<gtr\><text|dim><around|(|u|)>|}>>.
  <vspace|1fn>

  <no-indent><with|font-series|bold|3.14. Example.> For
  <math|S<rsub|q>*U<around|(|2|)>>, with <math|0\<less\><around|\||q|\|>\<less\>1>,
  under the same assumptions of the previous theorem, the possible parameters
  <math|\<lambda\>> satisfy <math|\<lambda\>\<geq\><around|\||q|\|><rsup|2*r>>,
  where <math|r> is the smallest strictly positive integer such that
  <math|u<rsub|r>> is spectral. Hence, for a given <math|q>, small values of
  <math|\<lambda\>> are possible only if the spectrum of the action has gaps.
  <vspace|1fn>

  The following example shows that the assumption of subexponential growth of
  integral multiplicities can not be removed in Theorem 3.8 b).<vspace|1fn>

  <no-indent><with|font-series|bold|3.15. Example.> For
  <math|A<rsub|o><around|(|F|)>>, with <math|F> of rank <math|\<geq\>3>,
  taking into account Example 3.6 and <math|\<lambda\><rsub|u<rsub|r>>=\<Lambda\><rsub|u<rsub|r>><rsup|-1>=<around|\<\|\|\>|F|\<\|\|\>><rsup|-2*r>>,
  we see that <math|\<lambda\>\<geq\><around|(|<frac|q|<around|\<\|\|\>|F|\<\|\|\>><rsup|2>>|)><rsup|r>>,
  where <math|q> is defined by Trace<math|<around|(|F<rsup|\<ast\>>*F|)>=<text|Trace><around|(|<around|(|F<rsup|\<ast\>>*F|)><rsup|-1>|)>=q+<frac|1|q>>
  and <math|u<rsub|r>> is again the first spectral irreducible. In
  particular, consider the translation action of
  <math|A<rsub|o><around|(|F|)>> over itself. Vaes and Vergnioux have shown,
  among other things, that if Trace<math|<around|(|F<rsup|\<ast\>>*F|)>\<geq\><sqrt|5><around|\<\|\|\>|F|\<\|\|\>><rsup|2>>
  then the Haar state <math|h> is factorial and the associated von Neumann
  algebra is a full factor. Moreover, if the spectrum of
  <math|<around|(|F<rsup|\<ast\>>*F|)><rsup|-1>\<otimes\>F<rsup|\<ast\>>*F>
  generates the subgroup <math|<around|{|\<lambda\><rsup|n>,n\<in\>\<bbb-Z\>|}>>,
  for some <math|0\<less\>\<lambda\>\<less\>1>,
  <math|\<pi\><rsub|h><around|(|A<rsub|o><around|(|F|)>|)><rprime|''>> is a
  factor of type III<rsub|<math|\<lambda\>>> <cite|VV>. The fundamental
  representation is spectral. In this example our lower bound
  <math|\<lambda\>\<geq\><frac|q|<around|\<\|\|\>|F|\<\|\|\>><rsup|2>>> is
  not optimal already for <math|F<rsup|\<ast\>>*F=<text|diag><around|(|\<lambda\>,1,\<lambda\><rsup|-1>|)>>.
  <vspace|1fn>

  <no-indent><with|font-shape|italic|Acknowledgements.> I would like to thank
  Alessandro Fig-Talamanca for a conversation related to this note.

  <\thebibliography|VD>
    <bibitem|Banica>T. Banica: Le groupe quantique compact libre
    <with|font-family|rm|U><math|<around|(|n|)>>.
    <with|font-shape|italic|Comm. Math. Phys.>, <with|font-series|bold|190>
    (1997), 143\U172.

    <bibitem|BDV>J. Bichon, A. De Rijdt, S. Vaes: Ergodic coactions with
    large multiplicity and monoidal equivalence of quantum groups.
    <with|font-shape|italic|Comm. Math. Phys.>, <with|font-series|bold|262>
    (2006), 703\U728.

    <bibitem|Boca>F.P. Boca: Ergodic actions of compact matrix pseudogroups
    on <math|C<rsup|\<ast\>>>-algebras. In: Recent advances in operator
    algebras (Orlans, 1992). <with|font-shape|italic|Astrisque>
    <with|font-series|bold|232> (1995), 93\U109.

    <bibitem|ConnesIII>A. Connes: Une classification des facteurs de type
    <with|font-family|rm|III>. <with|font-shape|italic|Ann. Sci. cole Norm.
    Sup.>, <with|font-series|bold|6> (1973), 133\U252.

    <bibitem|ConnesAP>A. Connes: Almost periodic states and factors of type
    <with|font-family|rm|III><rsub|<math|1>>. <with|font-shape|italic|J.
    Funct. Analysis>, <with|font-series|bold|16> (1974), 415\U445.

    <bibitem|DLRZ>S. Doplicher, R. Longo, J.E. Roberts, L. Zsido: A remark on
    quantum group actions and nuclearity. <with|font-shape|italic|Rev. Math.
    Phys.>, <with|font-series|bold|14> (2002), 787\U796.

    <bibitem|HLS>R. Hegh-Krohn, M.B. Landstad, E. Strmer: Compact ergodic
    groups of automorphisms, <with|font-shape|italic|Ann. of Math.>,
    <with|font-series|bold|114> (1981), 75\U86.

    <bibitem|LR>R. Longo, J.E. Roberts: A theory of dimension.
    <with|font-shape|italic|<math|K>-Theory>, <with|font-series|bold|11>,
    (1997), 103\U159.

    <bibitem|PR>C. Pinzari, J.E. Roberts: A duality theorem for ergodic
    actions of compact quantum groups on <math|C<rsup|\<ast\>>>-algebras.
    <with|font-shape|italic|Comm. Math. Phys.>, <with|font-series|bold|277>
    (2008), 385\U421.

    <bibitem|PRsubfactors>C. Pinzari, J.E. Roberts: Ergodic actions of
    <math|S<rsub|\<mu\>>*U<around|(|2|)>> on <math|C<rsup|\<ast\>>>-algebras
    from <with|font-family|rm|II><rsub|<math|1>> subfactors.
    <with|font-shape|italic|J. Geom. Phys.>, <with|font-series|bold|60>
    (2010), 403\U416.

    <bibitem|PRinduction>C. Pinzari, J.E. Roberts: A theory of induction and
    classification of tensor <math|C<rsup|\<ast\>>>\Ucategories,
    <with|font-shape|italic|J, Noncomm. Geom.>, to appear, arXiv:0907.2459.

    <bibitem|VV>S. Vaes, R. Vergnioux: The boundary of universal discrete
    quantum groups, exactness, and factoriality. <with|font-shape|italic|Duke
    Math. J.>, <with|font-series|bold|140> (2007), 35\U84.

    <bibitem|Wang>S. Wang: Ergodic actions of universal quantum groups on
    operator algebras. <with|font-shape|italic|Comm. Math. Phys.>,
    <with|font-series|bold|203> (1999), 481\U498.

    <bibitem|Wassermann3>A. Wassermann: Ergodic actions of compact groups on
    operator algebras. III. Classification for <math|S*U<around|(|2|)>>.
    <with|font-shape|italic|Invent. Math.>, <with|font-series|bold|93>
    (1988), 309\U354.

    <bibitem|WoronowiczCMP>S.L. Woronowicz: Compact matrix pseudogroups.
    <with|font-shape|italic|Comm. Math. Phys.>, <with|font-series|bold|111>
    (1987), 613\U665.

    <bibitem|WoronowiczLesHouches>S.L. Woronowicz: Compact quantum groups.
    In: Symtries quantiques (Les Houches, 1995), 845\U884, North-Holland,
    Amsterdam, 1998.
  </thebibliography>

  <no-indent>Claudia Pinzari, Dipartimento di Matematica, Sapienza Universit
  di Roma, 00185\URoma, Italy; e-mail: pinzari@mat.uniroma1.it
</body>