<TeXmacs|1.99.7>

<style|<tuple|ieeetran|std-latex>>

<\body>
  <\hide-preamble>
    <assign|B|<macro|1|<with|math-font-family|bf|<arg|1>>>>

    <assign|real|<macro|\<bbb-R\>>>

    <assign|mwcphi|<macro|<B|\<Phi\>>>>

    <assign|mwcpsi|<macro|<B|\<Psi\>>>>

    <assign|rdphi|<macro|<B|\<Sigma\>>>>

    <assign|rdpsi|<macro|<B|\<Psi\>>>>

    <assign|indicator|<macro|1|<B|1><rsub|<arg|1>>>>

    <assign|rect|<macro|1|rect(<arg|1>)>>

    <assign|sinc|<macro|1|sinc<arg|1>>>

    <assign|single|<macro|<assign|baselinestretch|<macro|1>>>>

    <assign|double|<macro|<assign|baselinestretch|<macro|1.4>>>>

    <assign|mwcM|<macro|M'>>

    <assign|mwcL|<macro|L'>>

    <assign|mwcq|<macro|q'>>

    <assign|mwcW|<macro|W'>>
  </hide-preamble>

  <doc-data|<doc-title|Reconciling Compressive Sampling Systems for
  Spectrally-sparse Continuous-time Signals>|<doc-author|<author-data|<author-misc|The
  authors are with the Institute of Digital Communications (IDCOM) & the
  Joint Research Institute for Signal and Image Processing, School of
  Engineering, The University of Edinburgh, Alexander Graham Bell Building,
  The King's Buildings, Mayfield Road, Edinburgh EH9 2JL, United Kingdom;
  Phone: ML +44 (0)131-650-5659, MD +44 (0)131-650-5795, JT +44
  (0)131-650-5585; Fax: +44 (0)131-650-6554; Email: {michael.lexa,
  mike.davies, john.thompson}@ed.ac.uk.>|<author-name|Michael<nbsp>A.<nbsp>Lexa*<nbsp><IEEEmembership|Member,<nbsp>IEEE>,
  Mike<nbsp>E.<nbsp>Davies<nbsp><IEEEmembership|Member,<nbsp>IEEE> and
  John<nbsp>S.<nbsp>Thompson<nbsp><IEEEmembership|Member,<nbsp>IEEE>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    The Random Demodulator (RD) and the Modulated Wideband Converter (MWC)
    are two recently proposed compressed sensing (CS) techniques for the
    acquisition of continuous-time spectrally-sparse signals. They extend the
    standard CS paradigm from sampling discrete, finite dimensional signals
    to sampling continuous and possibly infinite dimensional ones, and thus
    establish the ability to capture these signals at sub-Nyquist sampling
    rates. The RD and the MWC have remarkably similar structures (similar
    block diagrams), but their reconstruction algorithms and signal models
    strongly differ. To date, few results exist that compare these systems,
    and owing to the potential impacts they could have on spectral estimation
    in applications like electromagnetic scanning and cognitive radio, we
    more fully investigate their relationship in this paper. Specifically, we
    show that the RD and the MWC are both based on the general concept of
    random filtering, but that the sampling functions characterising the
    systems differ significantly. We next demonstrate a previously unreported
    model sensitivity the MWC has to short duration signals that resembles
    the known sensitivity the RD has to nonharmonic tones. We also show that
    block convolution is a fundamental aspect of the MWC, allowing it to
    successfully sample and reconstruct block-sparse (multiband) signals.
    This aspect is lacking in the RD, but we use it to propose a new CS based
    acquisition system for continuous-time signals whose amplitudes are block
    sparse. The paper includes detailed time and frequency domain analyses of
    the RD and the MWC that differ, sometimes substantially, from published
    results.
  </abstract>>

  <section|Introduction><label|sect:introduction>

  The theory of compressed sensing (CS) says that if a signal is sufficiently
  sparse with respect to some basis or frame, then it can be faithfully
  reconstructed from a small set of linear, nonadaptive measurements, even if
  the support of the signal is unknown<nbsp><cite|donoho2006|candes2006|candes_wakin2008>.
  When the signal belongs to a finite dimensional space, this statement means
  that it can be reconstructed from a set of measurements whose cardinality
  may be significantly less than the space's dimension. It also implies that
  the measurement process is described by an underdetermined linear system of
  equations, or equivalently, a rectangular matrix with more columns than
  rows. The fundamental work of Candes, Romberg, and
  Tao<nbsp><cite|candes_romberg_tao2006> and Donoho<nbsp><cite|donoho2006>
  established sufficient conditions upon such sensing matrices, that if
  satisfied, allow the stable inversion of the linear system. A key aspect of
  CS, and one which plays an important role in this paper, is that sensing
  matrices drawn at random<footnote|There are several ways to construct
  viable random sensing matrices. For example, its entries could simply be
  independent and identically distributed realisations of a a zero mean, unit
  variance Gaussian random variable.> often satisfy these conditions.

  Conceptually, CS theory has three main thrusts: (1) the development of
  recovery methods that efficiently and faithfully reconstruct the original
  signal from its compressed samples, (2) the investigation of new signal
  models that effectively represent signal sparsity or other signal
  structure, and (3) the creation of new sampling (measurement) mechanisms
  that acquire signals in a compressed manner. All three lines of research
  are intertwined and all need to be considered when designing a sampling
  system. The first concerns the reconstruction process and asks how one
  specifically reconstructs the original signal from the CS measurements
  (see, e.g.,<cite|donoho2006|candes_romberg_tao2006|tropp2007>). The second
  concerns the examination of different signal classes of interest and asks
  if there exists a structured representation that can be
  exploited<nbsp><cite|baraniuk_etal2010|eldar2009|lu_do2008>. The third
  concerns the design of the physical sampling system and asks how one
  devises a system to acquire CS measurements<nbsp><cite|eldar2009|romberg2009|tropp_etal2010|mishali_eldar2010>.
  This paper concerns sampling systems and signal models.

  Several CS based signal acquisition systems have been proposed for both
  continuous (analogue) and discrete signals. For example, the single-pixel
  camera<nbsp><cite|duarte_etal2008> is a novel compressive imaging system,
  where light is projected onto a random basis using a micro-mirror device,
  and then the projected image is captured by a single photo-diode (the
  single \Ppixel\Q). Other examples include random
  filtering<nbsp><cite|tropp_wakin_etal2006> and random
  convolution<nbsp><cite|romberg2009> that advocate random linear filtering
  and low rate sampling as a means to collect CS measurements. In these
  cases, \Prandom\Q filters are linear filters whose impulse responses are
  realisations of particular random processes.

  Along the same lines, the <em|Random Demodulator>
  (RD)<nbsp><cite|kirolos_etal2006|laska_etal2007|tropp_etal2010> and the
  <em|Modulated Wideband Converter> (MWC)<nbsp><cite|mishali_eldar2010|mishali_eldar_dcc2010|chen_etal2010|mishali_elron_eldar_icassp2010>
  have recently been proposed as CS sampling systems that target
  continuous-time spectrally-sparse signals. The RD is a single channel,
  uniform sub-Nyquist sampling strategy for acquiring <em|sparse multitone
  signals>; the MWC is a multi-channel, uniform sub-Nyquist sampling strategy
  for acquiring <em|sparse multiband signals>. (Precise definitions for these
  two signal classes are provided in Section<nbsp><reference|sect:signal>.)
  The RD and the MWC have tremendous potential impact because of the
  longstanding, proven usefulness of spectral signal models in many
  engineering and scientific applications (e.g. electromagnetic scanning,
  cognitive radio, radar, and medical imaging). Perhaps owing to the near
  coincidental emergence of these systems, however, few results exist to date
  that reconcile their remarkably similar structures (see
  Figure<nbsp><reference|fig:sampling>) with their different reconstruction
  algorithms. In fact, the current literature paints a somewhat artificial
  dividing line between the RD and the MWC, this works preferring to focus
  primarily on one scheme rather than drawing connections between them.

  In this paper, we offer new insights into the relationship between the RD
  and the MWC that complement the original works of Tropp et
  al.<nbsp><cite|tropp_etal2010> and Mishali and
  Eldar<nbsp><cite|mishali_eldar2010>. We apply tools from modern sampling
  theory and classical Fourier analysis and show that the RD and the MWC are
  two manifestations of the same CS sampling approach, namely random
  filtering/convolution<nbsp><cite|tropp_wakin_etal2006|romberg2009>. This
  fact reflects the systems' similar structure. At the same time, we show
  that the sampling functions characterising the systems strongly distinguish
  the two schemes. For example, the RD's sampling functions have finite
  support in time and infinite support in frequency, whereas the MWC's
  sampling functions have infinite support in time and finite support in
  frequency. In Section<nbsp><reference|sect:signal>, we discuss two signal
  model sensitivities exhibited by the RD and the MWC. In particular, we
  demonstrate the MWC's sensitivity to short duration multiband signals that
  is the counterpart to the known RD sensitivity to nonharmonic multitone
  signals. In each case, a perturbation to the signal model triggers a
  possible loss in signal sparsity and endangers CS reconstruction. In
  Section<nbsp><reference|sect:more>, we highlight the MWC's use of block
  convolution as a principle processing step that enables it to successfully
  sample and recover \Pblock\Q sparse signals, i.e. signals whose nonzero
  components are grouped together. The RD does not use block convolution,
  hence signal reconstruction for it can become computationally expensive for
  these types of signals. Extending the idea, we lastly propose a new CS
  based sampling system and show through an example that it can successfully
  sample and reconstruct continuous-time signals that are block sparse in the
  time domain.

  The main contribution of this paper is the recognition that both systems
  are based on the underlying concept of random filtering, yet each
  implements the concept differently because of the different signal classes
  they target. The insights regarding model sensitivities, the differences in
  sampling functions, and the MWC's use of block convolution build a better
  understanding of these systems and allows further application of these
  ideas to new signal classes, like the new acquisition system for time
  block-sparse signals proposed in Section<nbsp><reference|sect:more>.

  To be clear, we do not discuss the conditions of successful reconstruction,
  nor implementation issues in this paper. The original works of Tropp et
  al.<nbsp><cite|tropp_etal2010> and Mishali and
  Eldar<nbsp><cite|mishali_eldar2010>, and even some subsequent
  scholarship<nbsp><cite|chen_etal2010|mishali_elron_eldar_icassp2010|mishali_eldar_dcc2010>,
  extensively investigate these issues. Some of the reconstruction conditions
  will be tacitly stated in the descriptions of the systems in
  Section<nbsp><reference|sect:sampling>, but the presumption throughout the
  paper is that the RD and the MWC are theoretically proven CS based
  techniques to sample and reconstruct continuous-time spectrally-sparse
  signals.

  <section|Sampling mechanisms and signal models><label|sect:sampling>

  In this section, we examine the sampling mechanisms of the RD and the MWC
  from a modern sampling theory perspective. We show the output samples for
  both systems are equal to the inner products of the input signal with a set
  of sampling functions that arise from the systems' designs. We observe that
  unlike typical sampling functions, these sampling functions involve random
  waveforms, a central component in many CS sampling systems. If the inner
  products are interpreted as analogue filtering operations, we show that the
  samples result from a generalised random filtering or random convolution as
  described by Romberg<nbsp><cite|romberg2009> and Tropp et
  al.<nbsp><cite|tropp_wakin_etal2006> as a means to acquire CS samples. This
  analysis suggests that the RD and the MWC are two manifestations of the
  same sampling approach, but differ in the specific form of the sampling
  functions. The difference in sampling functions also reflects the
  difference in the assumed signal models for the RD and the MWC.

  We do not introduce the notion of signal sparsity in this section because
  the conclusions reached do not depend on this aspect. Signal sparsity and
  its consequences are discussed in Section<nbsp><reference|sect:signal>.

  <subsection|Sampling with the random demodulator><label|subsect:sampling>

  <\big-figure>
    <\subfigure*|Random demodulator>
      <minipage|f|0.48tex-text-width| <image|rd_structure.eps|5.5cm|||>>

      <label|subfig:rd>
    </subfigure*>

    \;

    <\subfigure*|Modulated wideband converter>
      <minipage|f|0.48tex-text-width| <image|mwc_structure.eps|6.5cm|||>>

      <label|subfig:mwc>
    </subfigure*>

    <label|fig:sampling>
  </big-figure|Time domain block diagrams of the random demodulator (RD) and
  the modulated wideband converter (MWC). The RD is characterised by
  <math|T>, the duration of the observation interval and <math|M>, a sampling
  rate parameter. The MWC is similarly characterised by <math|W>, the
  bandwidth of the input signal <math|x<around|(|t|)>> and <math|<mwcM>>, a
  sampling rate parameter. Note that the primary difference in the sampling
  structures is the type of filter prior to the sampling operation<emdash>the
  RD uses a ideal integrator and the MWC uses ideal low pass filters.>

  Let <math|x<around|(|t|)>> be a continuous-time, complex-valued signal
  defined on the real line. The RD acquires samples of <math|x<around|(|t|)>>
  on a finite observation interval where here, we assume, without loss of
  generality, that the samples are collected in the interval
  <math|<around|[|0,T|]>> seconds. In<nbsp><cite|tropp_etal2010>, Tropp et
  al. adopt a particular signal model for <math|x<around|(|t|)>> on this
  interval. They assume in part that <math|x<around|(|t|)>> has a Fourier
  series (FS) expansion on <math|<around|[|0,T|]>> which has bounded
  harmonics, i.e. <math|-W\<leq\><frac|n|T>\<less\>W> Hz for
  <math|n\<in\>\<bbb-Z\>>. On this interval, <math|x<around|(|t|)>> is
  therefore modeled as

  <\equation>
    <label|equ:multitone>x<around|(|t|)>=<big|sum><rsub|n=-N/2><rsup|N/2-1>X<around|(|n|)>*e<rsup|j*<frac|2*\<pi\>|T>*n*t>,<space|1em>t\<in\><around|[|0,T|]>,
  </equation>

  where <math|<around|{|X<around|(|n|)>|}>> denotes the FS coefficients of
  <math|x<around|(|t|)>> and <math|N=T*W>. For ease of exposition, <math|N>
  is assumed to be an even positive integer. This signal model is often
  called a <em|multitone> model.

  To acquire the samples, a RD first multiplies <math|x<around|(|t|)>> by a
  waveform <math|p<around|(|t|)>> and then filters and samples the product
  <math|x<around|(|t|)>*p<around|(|t|)>> on <math|<around|[|0,T|]>> (see
  Figure<nbsp><reference|subfig:rd>). The signal <math|p<around|(|t|)>> is
  taken to be a realisation of a continuous random process derived from a
  vector of Bernoulli random variables. Let
  <math|<B|Z>=<around|[|Z<rsub|0>,\<ldots\>,Z<rsub|L-1>|]>> be a vector of
  independent and identically distributed random variables <math|Z<rsub|l>>
  taking values <math|\<pm\>1> with equal probability and let
  <math|p<around|(|t;<B|Z>|)>> denote the random process

  <\equation>
    p<around|(|t;<B|Z>|)>=Z<rsub|l>,<space|1em>t\<in\><around*|[|<frac|l|W>,<frac|l+1|W>|)>,<space|1em>l=0,\<ldots\>,N-1.
  </equation>

  A realisation <math|<B|Z><rsub|0>> of <math|<B|Z>> produces a single
  realisation <math|p<around|(|t;<B|Z><rsub|0>|)>> of
  <math|p<around|(|t;<B|Z>|)>>. Here, we abbreviate
  <math|p<around|(|t;<B|Z><rsub|0>|)>> by <math|p<around|(|t|)>> and thus
  consider <math|p<around|(|t|)>> to be a deterministic quantity, although
  its randomness plays an important role in proving performance
  guarantees<nbsp><cite|tropp_etal2010>. In this paper, we sometimes refer to
  <math|p<around|(|t|)>> as a random waveform in deference to this point. We
  stress that when acquiring samples on <math|<around|[|0,T|]>>, the RD uses
  a single realisation of <math|p<around|(|t;<B|Z>|)>>, but different
  realisations may be used for other observation intervals. Note also that
  <math|p<around|(|t|)>> has the FS representation,

  <\equation>
    p<around|(|t|)>=<big|sum><rsub|n=-\<infty\>><rsup|\<infty\>>P<around|(|n|)>*e<rsup|j*<frac|2*\<pi\>|T>*n*t>,<space|1em>t\<in\><around|[|0,T|]>
  </equation>

  where <math|<around|{|P<around|(|n|)>|}>> is the set of FS coefficients of
  <math|p<around|(|t|)>>.

  The analogue filter in the RD design is taken to be an ideal integrator
  with impulse response <math|h<around|(|t|)>=<text|rect><around*|(|<frac|2*M|T>*t-1|)>>,
  where

  <\equation>
    <label|equ:rect><text|rect><around|(|x|)>=<choice|<tformat|<table|<row|<cell|1<space|1em><text|for<nbsp>>-1\<leq\>x\<leq\>1>>|<row|<cell|0<space|1em><text|otherwise>>>>>>,
  </equation>

  and <math|M\<in\>\<bbb-Z\><rsup|+>>. The sampling period <math|T<rsub|s>>
  is taken to be <math|M> times shorter than the observation window
  (<math|T<rsub|s>=T/M>). The system therefore samples at the rate of
  <math|M/T> Hz. The multitone signal model and the RD sampling system are
  therefore parameterised by <math|N>, the parameter equal to the
  time-frequency product <math|T*W> and <math|M>, the parameter that controls
  the RD's sampling rate. Here, we assume that <math|M\<less\>N>.

  The goal of the RD is to sample <math|x<around|(|t|)>> at low rates while
  retaining the ability to reconstruct it in the interval
  <math|<around|[|0,T|]>>. Reconstruction entails the discovery of the active
  frequencies (the signal's spectral support) and the amplitude of the
  corresponding FS coefficients. If <math|x<around|(|t|)>> is spectrally
  sparse on <math|<around|[|0,T|]>>, then reconstruction is possible using CS
  algorithms<nbsp><cite|tropp_etal2010>. In this case, we note that signal
  reconstruction only implies the recovery of the spectral content of
  <math|x<around|(|t|)>> in the observation interval. In other words, the
  samples <math|y<around|(|k|)>,k=0,\<ldots\>,M-1>, do not convey information
  about the spectral content of <math|x<around|(|t|)>> outside of this
  interval. To obtain spectral information outside of
  <math|<around|[|0,T|]>>, the RD must be applied to other intervals (of
  possibly different durations). If the RD is applied to consecutive
  intervals, a time-frequency decomposition of <math|x<around|(|t|)>> similar
  to the short-time Fourier transform can be obtained for multitone signals.

  <with|font-series|bold|Time domain description.> By inspection of
  Figure<nbsp><reference|subfig:rd>, the output samples
  <math|y<around|(|k|)>> can be expressed as

  <\equation>
    <around*|\<nobracket\>|<label|equ:rd>y<around|(|k|)>=g<around*|(|<around|(|k+1|)><tfrac|T|M>|)>=<big|int><rsub|0><rsup|T>x<around|(|\<tau\>|)>*p<around|(|\<tau\>|)><rect|<tfrac|2*M|T><around|(|t-\<tau\>|)>-1><nbsp>d*\<tau\>|\<rvert\>><rsub|t=<around|(|k+1|)><tfrac|T|M>>,<nbsp>k=0,\<ldots\>,M-1.
  </equation>

  By substituting<nbsp><eqref|equ:multitone<rsub|m>odel> into this expression
  and evaluating the integral, the following equation relating the time
  domain samples <math|y<around|(|k|)>> to the FS coefficients
  <math|X<around|(|n|)>> results:

  <\equation>
    <label|equ:rd>y<around|(|k|)>=<frac|N|W>*<big|sum><rsub|n=-N/2><rsup|N/2-1><big|sum><rsub|l=k<tfrac|N|M>><rsup|<around|(|k+1|)><tfrac|N|M>-1>p<rsub|l>*<space|0.17em><frac|e<rsup|j*<frac|2*\<pi\>|N>*n>-1|j*2*\<pi\>*n>*<space|0.17em>e<rsup|j<tfrac|2*\<pi\>|N>n*l>*<space|0.17em>X<around|(|n|)>,<space|1em>k=0,\<ldots\>,M-1,
  </equation>

  where <math|p<rsub|l>=p*<around|(|l/W|)>>. Tropp et al.
  derived<nbsp><eqref|equ:rd<rsub|l>inearsystem>
  in<nbsp><cite|tropp_etal2010> by analysing an equivalent digital system. In
  Appendix<nbsp><reference|app:RD>, we provide an alternate derivation that
  explicitly shows the analogue processing inherent in sampling with the RD.

  Because sampling is a linear operation with the RD, the samples
  <math|y<around|(|k|)>> can be viewed as inner products of
  <math|x<around|(|t|)>> with the set of sampling functions
  <math|<around*|{|p<around|(|\<tau\>|)><rect|2*k+1-<tfrac|2*M|T>\<tau\>>|}>>
  where

  <\equation>
    <label|equ:rd>y<around|(|k|)>=g<around*|(|<around|(|k+1|)><tfrac|T|M>|)>=<around*|\<langle\>|x<around|(|\<tau\>|)>,p<around|(|\<tau\>|)>*<text|rect><around*|(|2*k+1-<tfrac|2*M|T>\<tau\>|)>|\<rangle\>>,<space|1em>k=0,\<ldots\>,M-1,
  </equation>

  and

  <\equation*>
    <around*|\<langle\>|s<around|(|t|)>,x<around|(|t|)>|\<rangle\>>=<big|int><rsub|0><rsup|T>s<rsup|\<ast\>><around|(|t|)>*x<around|(|t|)><nbsp>d*t,
  </equation*>

  for two continuous functions <math|x<around|(|t|)>>, <math|s<around|(|t|)>>
  on <math|<around|[|0,T|]>>. These sampling functions have finite duration
  in time (<math|T/M> seconds), but because their Fourier transforms involve
  <math|<sinc|>> functions, they extend infinitely in frequency. In the
  time-frequency plane, their support partitions the space into vertical
  strips of equal width (see Figure<nbsp><reference|fig:time-freq>, left
  panel). We note that unlike modern sampling theory<nbsp><cite|unser2000>,
  the sampling functions in<nbsp><eqref|equ:rd<rsub|s>amplingfunctions>
  contain the random waveform <math|p<around|(|t|)>>, and the conditions they
  must satisfy to ensure stable recovery is governed by CS theory and not
  Shannon-Nyquist based sampling theory. (Refer to<nbsp><cite|unser2000>
  and<nbsp><cite|eldar2009> for details regarding the conditions that
  sampling functions typically must satisfy.)

  <\big-figure>
    <minipage|f|0.48tex-text-width| <image|rd_time_freq_support.eps|5.5cm|||>>

    <minipage|f|0.48tex-text-width|<image|mwc_time_freq_support.eps|5.5cm|||>>

    <label|fig:time-freq>
  </big-figure|The output samples of both the RD and the MWC can be described
  as inner products of the input signal <math|x<around|(|t|)>> with certain
  sets of sampling functions. The panel on the left depicts the
  time-frequency support of the RD sampling functions where each vertical
  strip represents the support of one sampling function. Similarly, the panel
  on the right depicts the support of the MWC sampling functions where each
  horizontal strip represents the support of one sampling function. For the
  RD and the MWC, the support characteristics of the sampling functions
  directly derive from the type of analogue filters used prior to sampling.
  The RD and the MWC represent two extreme cases: The RD has perfectly
  localised support in time but completely unlocalized support in frequency.
  The MWC is the exact opposite.>

  From<nbsp><eqref|equ:rd<rsub|t>imedomain>, it is clear the samples
  <math|y<around|(|k|)>> can be thought of pointwise evaluations of the
  convolution between <math|x<around|(|t|)>*p<around|(|t|)>> and an ideal
  integrator. Equally valid, however, is the view that the samples are
  pointwise evaluations of a random, linear filtering operation involving
  <math|x<around|(|t|)>> and the time-varying analogue filter
  <math|h<around|(|t,\<tau\>|)>=p<around|(|\<tau\>|)><rect|<tfrac|2*M|T><around|(|t-\<tau\>|)>-1>>,

  <\equation>
    <around*|\<nobracket\>|<label|equ:rd>y<around|(|k|)>=<big|int><rsub|0><rsup|T>x<around|(|\<tau\>|)>*h<around|(|t,\<tau\>|)><nbsp>d*\<tau\>|\<rvert\>><rsub|t=<around|(|k+1|)><tfrac|T|M>>*<space|1em>k=0,\<ldots\>,M-1.
  </equation>

  Here, the impulse response <math|h<around|(|t,\<tau\>|)>> is considered
  random because at each time instance it is a windowed portion of a signal
  that randomly alternates between <math|\<pm\>1>. The samples
  <math|y<around|(|k|)>> can therefore can be thought of as the result of a
  random filtering operation, conceptually similar to the random filtering
  schemes proposed in<nbsp><cite|romberg2009>
  and<nbsp><cite|tropp_wakin_etal2006>. In<nbsp><cite|tropp_wakin_etal2006>,
  Tropp et al. proposed a CS sampling scheme where a sparse discrete-time
  signal is first filtered by a digital filter whose impulse response is a
  realisation of a sequence of independent and identically distributed random
  variables, and then subsampled at a low rate. They illustrated through
  examples that with the use of CS recovery algorithms random filtering is a
  potential sampling structure to acquire CS measurements for sparse discrete
  time signals. In<nbsp><cite|romberg2009>, Romberg proposed and examined a
  similar idea but considered a specific digital filter that randomly changes
  the phase of the input signal. Interestingly, Romberg considered the RD as
  a separate, follow-on processing step to his approach instead of
  considering it as a generalisation to his notion of random convolution.
  Here,<nbsp><eqref|equ:rd<rsub|r>andomfiltering> shows that the sampling
  mechanism of the RD can be viewed as a random filtering operation applied
  to continuous-time signals. We note, however, that the filtering operation
  in<nbsp><eqref|equ:rd<rsub|r>andomfiltering> is not a convolution because
  of the time-varying nature of <math|h<around|(|t,\<tau\>|)>>. Strictly
  speaking then<nbsp><eqref|equ:rd<rsub|r>andomfiltering> is distinct from
  the systems proposed in<nbsp><cite|tropp_wakin_etal2006>
  and<nbsp><cite|romberg2009>, although random filtering remains a common
  thread.

  <with|font-series|bold|Frequency domain description.> An equivalent
  frequency domain expression to<nbsp><eqref|equ:rd<rsub|t>imedomain> can be
  derived (see Appendix<nbsp><reference|app:RD>) that relates the discrete
  Fourier transform (DFT) of <math|y<around|(|k|)>>, denoted by
  <math|Y<around|(|n|)>>, to the FS coefficients <math|X<around|(|n|)>>,

  <\equation>
    <label|equ:rd>Y<around|(|n|)>=T*<big|sum><rsub|m=n-<tfrac|N|2>+1><rsup|n+<tfrac|N|2>>P<around|(|m|)>*e<rsup|-j*<frac|2*\<pi\>|T>*n><sinc|<around|(|<tfrac|\<pi\>|M>n|)>><space|0.17em>X*<around|(|n-m|)>,<space|1em>n=0,\<ldots\>,M-1,
  </equation>

  where <math|<sinc|<around|(|x|)>>=sin <around|(|x|)>/x,x\<in\><real>>. This
  equation clearly shows the frequency domain convolution caused by the
  multiplication with <math|p<around|(|t|)>> and the effect of filtering with
  an ideal integrator, indicated by the presence of the
  <math|e<rsup|-j*<frac|2*\<pi\>|T>*n><sinc|<around|(|<tfrac|\<pi\>|M>n|)>>>
  term. Thus, one can also interpret <math|Y<around|(|n|)>> as the output of
  a random, frequency-varying filter with impulse response
  <math|H<around|(|n,m|)>=P<around|(|m|)>*e<rsup|-j*<frac|2*\<pi\>|T>*n><sinc|<around|(|<tfrac|\<pi\>|M>n|)>>>.
  We see therefore that the RD's output in either the time or frequency
  domains can be viewed as the output of a random filter or convolution.

  <subsection|Sampling with the modulated wideband
  converter><label|subsect:mwc>

  We now let <math|x<around|(|t|)>> be a bandlimited, continuous-time, finite
  energy signal. The spectral content of <math|x<around|(|t|)>> on
  <math|\<bbb-R\>> is thus appropriately given by its Fourier transform (FT)
  <math|X<around|(|\<omega\>|)>>,

  <\equation*>
    X<around|(|\<omega\>|)>=<big|int><rsub|-\<infty\>><rsup|\<infty\>>x<around|(|t|)>*<space|0.17em>e<rsup|j*\<omega\>*t><nbsp>d*t.
  </equation*>

  Here, <math|x<around|(|t|)>> is bandlimited in the usual sense, i.e.,
  <math|X<around|(|\<omega\>|)>> is assumed to be bounded:
  <math|X<around|(|\<omega\>|)>=0> for <math|<around|\<lvert\>|\<omega\>|\<rvert\>>\<geq\>\<pi\><mwcW>>
  radians per second, <math|<mwcW>\<in\>\<bbb-R\><rsup|+>>, where
  <math|\<pi\><mwcW>> is the bandwidth of <math|x<around|(|t|)>> and
  <math|2*\<pi\><mwcW>> is the Nyquist frequency in radians per second. We
  adopt the following definition from<nbsp><cite|bresler2008>. The class of
  <em|multiband> signals <math|\<cal-B\><around|(|\<cal-F\>,<mwcW>|)>> is
  then the set of bandlimited, continuous-time, finite energy signals whose
  spectral support is a finite union of bounded intervals,

  <align|<tformat|<table|<row|<cell|>|<cell|\<cal-B\><around|(|\<cal-F\>,<mwcW>|)>=<around*|{|x<around|(|t|)>\<in\>L<rsup|2><around|(|\<bbb-R\>|)>\<cap\>C<around|(|\<bbb-R\>|)>:X<around|(|\<omega\>|)>=0,\<omega\>\<nin\>\<cal-F\>|}><label|equ:mwc><intertext|w*h*e*r*e>>|<cell|\<cal-F\>=<big|cup><rsub|i=1><rsup|K><around|[|a<rsub|i>,b<rsub|i>|)>,<space|1em><around|\<lvert\>|a<rsub|i>|\<rvert\>>,<around|\<lvert\>|b<rsub|i>|\<rvert\>>\<leq\>\<pi\><mwcW><text|<nbsp>radians
  per second, for all<nbsp>>i.<label|equ:mwc>>>>>>

  In the following description of the MWC, primes are added to the parameters
  to distinguish them from the parameters of the RD. The same letters are,
  however, used for similar quantities. For example, <math|W> denotes the
  bound on the harmonics of multitone signals while <math|\<pi\><mwcW>>
  denotes the bandwidth of the multiband signals.

  Like the RD, the <math|i>th channel of the MWC multiplies
  <math|x<around|(|t|)>> by a random signal <math|p<rsub|i><around|(|t|)>>,
  then filters and samples the product <math|x<around|(|t|)>*p<rsub|i><around|(|t|)>>
  at a sub-Nyquist rate (see Figure<nbsp><reference|subfig:mwc>). As in the
  original formulation, we assume each channel's filter is an ideal low pass
  filter, although it has been shown that the MWC can operate with non-ideal
  low pass filters<nbsp><cite|chen_etal2010>. Here, we examine its original
  formulation to make a clearer comparison to the RD. The signals
  <math|p<rsub|i><around|(|t|)>,i=0,\<ldots\>,<mwcq>-1>, are periodic
  extensions of different realisations of a continuous random process similar
  to that used for the RD. Formally, let <math|<B|Z>=<around|{|Z<rsub|l>|}>>,
  be a sequence of independent and identically distributed random variables
  taking values <math|\<pm\>1> with equal probability and let
  <math|p<around|(|t;<B|Z>|)>> denote the random process

  <\equation>
    p<around|(|t;<B|Z>|)>=<choice|<tformat|<table|<row|<cell|Z<rsub|l>,<space|1em>t\<in\><around*|[|<frac|l|<mwcW>>,<frac|l+1|<mwcW>>|)>,<space|1em>l=0,\<ldots\>,<around|\<lfloor\>|<mwcL>|\<rfloor\>>-1,>>|<row|<cell|Z<rsub|<around|\<lfloor\>|<mwcL>|\<rfloor\>>-1>,<space|1em>t\<in\><around*|[|<frac|<around|\<lfloor\>|<mwcL>|\<rfloor\>>-1|<mwcW>>,T<rsub|p>|)>>>>>>
  </equation>

  where <math|T<rsub|p>=<mwcL>/<mwcW>>. The signals
  <math|p<rsub|i><around|(|t|)>> are then periodic extensions of the
  realisations <math|p<around|(|t;<B|Z><rsub|i>|)>> of
  <math|p<around|(|t;<B|Z>|)>>:

  <\equation>
    p<rsub|i>*<around|(|t+m*T<rsub|p>|)>=p<around|(|t;<B|Z><rsub|i>|)>,<space|1em><text|for<nbsp>>t\<in\><around|[|0,T<rsub|p>|]>,<nbsp>m\<in\>\<bbb-Z\>,<nbsp>i=0,\<ldots\>,<mwcq>-1,
  </equation>

  where <math|<B|Z><rsub|i>> denotes a particular realisation of
  <math|<B|Z>>.

  The impulse response of the ideal low pass analogue filter is
  <math|h<around|(|t|)>=<tfrac|\<pi\><mwcW>|<mwcM>><sinc|(><tfrac|\<pi\><mwcW>|<mwcM>>t)>,
  <math|<mwcM>\<in\><real><rsup|+>>, <math|<mwcM>\<gtr\>1> and thus has a
  cut-off frequency of <math|<tfrac|2*\<pi\><mwcW>|<mwcM>>> radians per
  second, where <math|<tfrac|1|T<rsub|s>>=<tfrac|<mwcW>|<mwcM>>> is each
  channel's sampling rate (in Hertz). Every channel thus samples at a rate
  that is <math|<mwcM>> times slower than the Nyquist rate. The system's
  average sampling rate is <math|<mwcq><mwcW>/<mwcM>> Hz. Mishali and
  Eldar<nbsp><cite|mishali_eldar2010> showed that a necessary condition for
  successful reconstruction is <math|<mwcq>\<leq\><mwcM>\<leq\><mwcL>> which
  implies that <math|T<rsub|s>\<leq\>T<rsub|p>>. We assume this condition
  holds for the MWC throughout the paper.

  <with|font-series|bold|Time domain description.> By inspection of
  Figure<nbsp><reference|subfig:mwc>, we obtain the following time-domain
  expression for a single channel of the MWC:

  <\equation>
    <around*|\<nobracket\>|<label|equ:mwc>y<rsub|i><around|(|k|)>=g<rsub|i><around*|(|k<tfrac|<mwcM>|<mwcW>>|)>=<frac|\<pi\><mwcW>|<mwcM>><big|int><rsub|-\<infty\>><rsup|\<infty\>>x<around|(|\<tau\>|)>*p<rsub|i><around|(|\<tau\>|)><sinc|<around|(|<tfrac|\<pi\><mwcW>|<mwcM>><around|(|t-\<tau\>|)>|)>><nbsp>d*\<tau\>|\<rvert\>><rsub|t=k<tfrac|<mwcM>|<mwcW>>>,<space|1em><text|for
    all<nbsp>>k\<in\>\<bbb-Z\>.
  </equation>

  This expression corresponds to the analogous time domain expression
  in<nbsp><eqref|equ:rd<rsub|t>imedomain> for the RD. Like the RD, the
  samples <math|y<rsub|i><around|(|k|)>> can be interpreted as inner products
  with a set of sampling functions <math|<around|{|<tfrac|\<pi\><mwcW>|<mwcM>>p<rsub|i><around|(|\<tau\>|)><sinc|<around*|(|\<pi\>*<around|(|k-<tfrac|<mwcW>|<mwcM>>\<tau\>|)>|)>>|}>>
  where

  <\equation>
    <label|equ:mwc>y<rsub|i><around|(|k|)>=g<rsub|i><around*|(|k<tfrac|<mwcM>|<mwcW>>|)>=<around*|\<langle\>|x<around|(|\<tau\>|)>,<tfrac|\<pi\><mwcW>|<mwcM>>p<rsub|i><around|(|\<tau\>|)><sinc|<around*|(|\<pi\>*<around|(|k-<tfrac|<mwcW>|<mwcM>>\<tau\>|)>|)>>|\<rangle\>>,<space|1em><text|for
    all<nbsp>>k\<in\>\<bbb-Z\>.
  </equation>

  In contrast to the RD, however, these sampling functions have finite
  frequency support and infinite support in time. In the time-frequency
  plane, their support partitions the space into horizontal strips of width
  <math|<mwcW>/<mwcM>> Hz (see Figure<nbsp><reference|fig:time-freq>, right
  panel). This particular set of sampling functions represents one instance
  of a general theory put forth by Eldar<nbsp><cite|eldar2009> to
  compressively sample continuous-time signals from unions of shift-invariant
  spaces, of which multiband signals are members. The theory combines modern
  sampling theory with CS theory in such a way that samples are acquired in a
  typical manner by projecting the signal onto a set of sampling functions
  (as in<nbsp><eqref|equ:mwc<rsub|i>nnerprod>), but CS theory is needed to
  reconstruct it. We do not review the details of this theory here because it
  does not apply to the RD.

  Interpreting<nbsp><eqref|equ:mwc<rsub|t>imedomain> as a random filtering,
  we identify the time-vary impulse response as
  <math|h<around|(|t,\<tau\>|)>=<tfrac|\<pi\><mwcW>|<mwcM>>p<rsub|i><around|(|\<tau\>|)><sinc|<around|(|<tfrac|\<pi\><mwcW>|<mwcM>><around|(|t-\<tau\>|)>|)>>>.
  Because the MWC employs an ideal low pass filter, the impulse response
  contains a <math|<sinc|>> function instead of a rectangular function as
  seen in<nbsp><eqref|equ:rd<rsub|t>imedomain>. Consequently, the impulse
  response has infinite temporal extent in this (ideal) setting. For the MWC,
  <math|h<around|(|t,\<tau\>|)>> is random in the same general sense as the
  RD's time-varying impulse response\Vthe <math|<sinc|>> function is
  multiplied by a realisation of a random process.

  <with|font-series|bold|Frequency domain description.> Using standard
  Fourier analysis techniques, Mishali and
  Eldar<nbsp><cite|mishali_eldar2010> derived the following frequency domain
  description for one channel of the MWC,

  <\equation>
    <label|equ:mwc>Y<rsub|i><around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcW>>>|)><indicator|[-<frac|\<pi\><mwcW>|<mwcM>>,<frac|\<pi\><mwcW>|<mwcM>>)>=<frac|<mwcW>|<mwcM>>*<big|sum><rsub|m=-<around|\<lfloor\>|<frac|<mwcL>|2<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>+1><rsup|<around|\<lfloor\>|<frac|<mwcL>|2<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>>P<around|(|m|)><rect|<tfrac|<mwcM>|\<pi\><mwcW>>\<omega\>><space|0.17em>X*<around|(|\<omega\>-m<tfrac|2*\<pi\><mwcW>|<mwcL>>|)>,
  </equation>

  for <math|i=0,\<ldots\>,<mwcq>-1>, where
  <math|<indicator|<around|[|\<cdummy\>|)>>> denotes the indicator function
  and <math|<around|\<lfloor\>|\<cdummy\>|\<rfloor\>>> denotes the floor
  rounding operation. Appendix<nbsp><reference|app:MWC> contains a slightly
  different derivation of<nbsp><eqref|equ:mwc<rsub|f>reqdomain> than that
  presented in<nbsp><cite|mishali_eldar2010>.
  Comparing<nbsp><eqref|equ:mwc<rsub|f>reqdomain>
  to<nbsp><eqref|equ:rd<rsub|f>reqdomain>, we observe that the DTFT of the
  output sequences <math|y<rsub|i><around|(|k|)>> can again be interpreted as
  the result of a random convolution, where the frequency-varying impulse
  response is given by <math|H<around|(|m,\<omega\>|)>=P<around|(|m|)><rect|<tfrac|<mwcM>|\<pi\><mwcW>>\<omega\>>>.
  The spectral content of the samples <math|y<rsub|i><around|(|k|)>> is
  expressed by the DTFT, as opposed to the DFT, because
  <math|x<around|(|t|)>> is defined on the entire real line for the MWC
  instead of on an interval. An implication of this modeling difference is
  explored in Section<nbsp><reference|sect:signal>.

  <with|font-series|bold|Single channel MWC.> There are two ways to collapse
  the MWC into an equivalent single channel system. One can either lengthen
  the observation interval by a factor of <math|<mwcq>> (keeping all other
  parameters fixed), or one can consider increasing the sampling rate while
  maintaining the same observation interval. If the observation interval is
  lengthened, the sequence of samples from a single channel MWC can be
  partitioned into <math|<mwcq>> groups of <math|<mwcW>T/<mwcM>>, where each
  group of samples is thought of as the output from an individual channel in
  the multi-channel configuration. Alternatively, one can set the sampling
  rate of a single channel MWC equal to the average rate of a multi-channel
  MWC, i.e., set the sampling rate to <math|<mwcq><mwcW>/<mwcM>> Hz, and
  accordingly adjust the low pass filter's cut-off frequency to
  <math|<mwcq><mwcW>/<mwcM>> Hz since it acts as an anti-aliasing filter (see
  Figure<nbsp><reference|fig:mwc>). In this case, we still maintain the
  requirement <math|<mwcM>\<leq\><mwcL>>, but assume specifically that
  <math|<mwcL>=<mwcq><mwcM>> or that <math|T<rsub|p>> is <math|<mwcq>> times
  larger than <math|T<rsub|s>>. The frequency domain description of this
  single channel MWC can now be obtained from<nbsp><eqref|equ:mwc<rsub|f>reqdomain>
  by substituting <math|<mwcM>/<mwcq>> for <math|<mwcM>> and
  <math|<mwcq><mwcM>> for <math|<mwcL>>:

  <\equation>
    Y<around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcq><mwcW>>>|)><indicator|[-<frac|\<pi\><mwcq><mwcW>|<mwcM>>,<frac|\<pi\><mwcq><mwcW>|<mwcM>>)>=<frac|<mwcq><mwcW>|<mwcM>>*<big|sum><rsub|m=-<around|\<lfloor\>|<frac|<mwcq>|2>*<around|(|<mwcM>+<mwcq>|)>|\<rfloor\>>+1><rsup|<around|\<lfloor\>|<frac|<mwcq>|2>*<around|(|<mwcM>+<mwcq>|)>|\<rfloor\>>>P<around|(|m|)><rect|<tfrac|<mwcM>|\<pi\><mwcq><mwcW>>\<omega\>><space|0.17em>X*<around|(|\<omega\>-m<tfrac|2*\<pi\><mwcW>|<mwcq><mwcM>>|)>.
  </equation>

  <big-figure|<image|mwc_structure_single_channel.eps|6.5cm|||><label|fig:mwc>
  |Block diagram of a single channel MWC as described
  in<nbsp><cite|mishali_eldar2010>. To be equivalent to the multi-channel
  system depicted in Figure<nbsp><reference|subfig:mwc>, this system samples
  at a rate <math|<mwcq>> times faster and has a low pass filter with a
  cut-off frequency <math|<mwcq>> times greater. Additional digital
  processing is also required to form the linear system
  in<nbsp><eqref|equ:mwc<rsub|m>atrixform>.>

  <with|font-series|bold|Summary.> Equations<nbsp><eqref|equ:rd<rsub|t>imedomain>,<nbsp><eqref|equ:rd<rsub|f>reqdomain>,<nbsp><eqref|equ:mwc<rsub|t>imedomain>,
  and<nbsp><eqref|equ:mwc<rsub|f>reqdomain> all indicate that the sampling
  mechanisms for the RD and the MWC are based on analogue random
  filtering/convolution. However, the RD's integrator and the MWC's low pass
  filter induce significant differences in the specific form of the random
  convolutions, or equivalently, in their sampling functions. In fact, the
  different filters induce bipolar time-frequency characterisations that make
  them well-suited for the signal models they target\Van ideal integrator
  with a finite impulse response is well-suited to signals modeled on a
  finite interval and an ideal low pass filter with a finite frequency
  response is well-suited to signals modeled on a finite frequency band.

  <section|Model sensitivities for sparse signal models><label|sect:signal>

  In this section, we introduce the notion of sparsity into the multitone and
  multiband models and discuss two model sensitivities\Vone for the RD, one
  for the MWC. These sensitivities are a set of circumstances in which the
  sparsity of the assumed the models could potentially be lost, jeopardising
  the ability of any algorithm to correctly recover the unknown signal from a
  set of compressed measurements. The model sensitivity of the RD is already
  a familiar limitation that was first mentioned by Tropp et al.
  in<nbsp><cite|tropp_etal2010> and later studied by
  others<nbsp><cite|y_chi_etal_icassp2010|duarte_baraniuk2010>. The MWC model
  sensitivity presented here is new and ultimately derives from the fact that
  multiband signals have infinite duration. The analysis also shows that in
  practice, when only a finite number of samples are acquired, the MWC can at
  best recover an approximation of the input multiband signal instead of
  perfectly reconstructing it.

  <subsection|Sparse multitone signals for the RD><label|subsect:signal>

  In the original formulation of the RD, the input signal was not only
  modeled as a multitone signal on the observation interval, but was also
  assumed to be spectrally sparse<nbsp><cite|tropp_etal2010>. Recall the
  multitone signal model on the observation interval <math|<around|[|0,T|]>>
  (equation<nbsp><eqref|equ:multitone<rsub|m>odel>):

  <\equation*>
    x<around|(|t|)>=<big|sum><rsub|n=-N/2><rsup|N/2-1>X<around|(|n|)>*e<rsup|j*<frac|2*\<pi\>|T>*n*t>,<space|1em>t\<in\><around|[|0,T|]>.
  </equation*>

  A <em|spectrally sparse multitone> signal is then a multitone signal that
  has a small number of nonzero FS coefficients out of the <math|N+1>
  possible. More precisely, letting <math|K> denote the number of nonzero
  coefficients (or equivalently the number of nonzero frequencies), a
  spectrally sparse multitone signal is one that satisfies <math|K\<ll\>N>.

  <with|font-series|bold|Signal reconstruction.> The reconstruction of a
  sparse multitone signal <math|x<around|(|t|)>> from the samples
  <math|y<around|(|k|)>> hinges on the matrix form
  of<nbsp><eqref|equ:rd<rsub|l>inearsystem>,

  <\equation>
    <label|equ:rd><B|y><around|(|k|)>=<rdphi><rdpsi><space|0.17em><B|x><around|(|n|)>
  </equation>

  where <math|<rdphi>> is a <math|M\<times\>N> matrix of the form

  <\equation*>
    <rdphi>=<around*|[|<tabular*|<tformat|<table|<row|<cell|p<rsub|0>>|<cell|\<ldots\>>|<cell|p<rsub|<frac|N|M>-1>>|<cell|0>|<cell|\<ldots\>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|0>|<cell|>|<cell|>|<cell|p<rsub|<frac|N|M>>>|<cell|\<ldots\>>|<cell|p<rsub|<frac|2*N|M>-1>>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|\<vdots\>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|\<ddots\>>|<cell|>|<cell|>|<cell|>>|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|p<rsub|<around|(|M-1|)>*<frac|N|M>>>|<cell|\<ldots\>>|<cell|p<rsub|N-1>>>>>>|]>,
  </equation*>

  and

  <align*|<tformat|<table|<row|<cell|<B|y><around|(|k|)>>|<cell|=<around|[|y<around|(|0|)>,\<ldots\>,y*<around|(|M-1|)>|]><rprime|'>,<space|1em><text|(apostrophe
  denotes transpose)>>>|<row|<cell|<rdpsi><rsub|r,l>>|<cell|=e<rsup|-j<tfrac|2*\<pi\>|N>n<rsub|r>*l>,>>|<row|<cell|x<rsub|r><around|(|n|)>>|<cell|=\<alpha\><rsub|r>*X<around|(|n<rsub|r>|)>,>>|<row|<cell|\<alpha\><rsub|r>>|<cell|=<frac|T|j*2*\<pi\>*n<rsub|r>>*<around*|(|e<rsup|j*<frac|2*\<pi\>|N>*n<rsub|r>>-1|)>,<space|1em>\<alpha\><rsub|0>=<frac|1|W>,>>>>>

  for <math|r=0,\<ldots\>,N-1>, <math|n<rsub|r>=-N/2+r>, and
  <math|l=0,\<ldots\>,N-1>. We explicitly write the arguments <math|k> and
  <math|n> in<nbsp><eqref|equ:rd<rsub|m>atrixform> to indicate the time
  domain and the frequency domain, respectively. The notational distinction
  becomes more important in later sections and is simply made for clarity.

  By construction,<nbsp><eqref|equ:rd<rsub|m>atrixform> is an underdetermined
  linear system of equations (<math|<rdphi><rdpsi>> is <math|M\<times\>N>
  with <math|M\<less\>N>; see Section<nbsp><reference|subsect:sampling>) and
  underdetermined systems do not, in general, have unique solutions. However,
  CS theory has shown that because of the presumed sparsity of
  <math|<B|x><around|(|n|)>>, <nbsp><eqref|equ:rd<rsub|m>atrixform> can be
  solved by a direct application of a number of recently developed recovery
  algorithms, e.g., <math|\<ell\><rsub|1>>
  minimisation<nbsp><cite|candes_romberg_tao2006>, orthogonal matching
  pursuit<nbsp><cite|tropp2007>, or iterative hard
  thresholding<cite|blumensath_davies2008|blumensath_davies2009>. In the CS
  literature, solving<nbsp><eqref|equ:rd<rsub|m>atrixform> is termed the
  <em|single measurement vector> (SMV) problem. Theoretical guarantees
  regarding the successful recovery of <math|<B|x><around|(|n|)>> is provided
  in<nbsp><cite|tropp_etal2010> in terms of the degree of sparsity and the
  number of samples (measurements) collected.

  <with|font-series|bold|RD model sensitivity.> The ability of CS recovery
  algorithms to recover the FS coefficients
  in<nbsp><eqref|equ:rd<rsub|m>atrixform> depends in part on the sparsity of
  <math|<B|x><around|(|n|)>>, or equivalently, on whether
  <math|x<around|(|t|)>> has a sparse FS representation in the observation
  window <math|<around|[|0,T|]>>. A multitone signal that has a sparse FS
  representation on <math|<around|[|0,T|]>> (with fundamental frequency
  <math|1/T>) will not in general have a sparse expansion if the fundamental
  frequency changes slightly. In other words, the FS expansion of a
  nonharmonic tone is generally not spectrally
  sparse<nbsp><cite-detail|mallat1999|p.379-380>. The implication for the RD
  is that in a blind sensing scenario, where the frequencies of the tones are
  not known, there is no guarantee that there will not be a mismatch between
  the fundamental tone (<math|1/T>) and the observation interval, which may
  be slightly larger or smaller than <math|T>. Thus, in practice there is no
  guarantee that the FS representation of <math|x<around|(|t|)>> on
  <math|<around|[|0,T|]>> is sparse. Since successful reconstruction is
  conditioned on the spectral sparsity of <math|x<around|(|t|)>> on
  <math|<around|[|0,T|]>>, a possible mismatch jeopardises reconstruction.
  This sensitivity was acknowledged by Tropp et al.
  in<nbsp><cite|tropp_etal2010>, highlighted
  in<nbsp><cite|mishali_eldar_dcc2010> and studied
  in<nbsp><cite|y_chi_etal_icassp2010|duarte_baraniuk2010>. In particular
  in<nbsp><cite|duarte_baraniuk2010>, Duarte and Baraniuk propose a heuristic
  solution that marries model-based CS<nbsp><cite|baraniuk_etal2010>,
  redundant DFT frames, and standard spectral estimation techniques, but it
  remains an open question whether this method extends to infinite
  dimensional signal classes such as multiband signals.

  <subsection|Sparse multiband signals for MWC><label|subsect:signal>

  Recall that mulitband signals are bandlimited, continuous-time, finite
  energy signals whose spectral support <math|\<cal-F\>> is a union of
  bounded intervals (see<nbsp><eqref|equ:mwc<rsub|s>upport1>
  and<nbsp><eqref|equ:mwc<rsub|s>upport2>). A <em|sparse multiband> signal is
  a multiband signal whose support has Lebesgue measure that is small
  relative to the overall signal bandwidth, i.e.,
  <math|\<lambda\><around|(|\<cal-F\>|)>\<ll\><mwcW>><nbsp><cite|pingfeng_phdthesis1997>.
  If, for instance, all the occupied bands (intervals) have equal bandwidth
  <math|B> Hz and the signal is composed of <math|K> disjoint frequency
  bands, then a sparse multiband signal is one satisfying
  <math|K*B\<ll\><mwcW>>. In the CS literature, signals having this type of
  \Pblock\Q structure have been studied in various settings in which the
  central question is whether the additional signal structure (sparsity plus
  block structure) reduces the minimum number of samples required to
  reconstruct the original signal (see e.g.,<nbsp><cite|stojnic_etal2009|baraniuk_etal2010|eldar_etal2010>).

  <with|font-series|bold|Signal reconstruction and linear approximations.>
  MWC signal reconstruction centres on the matrix form
  of<nbsp><eqref|equ:mwc<rsub|f>reqdomain>,

  <\equation>
    <label|equ:mwc><B|y><around|(|\<omega\>|)>=<B|\<Phi\>><B|\<Psi\>><B|s><around|(|\<omega\>|)>
  </equation>

  where

  <align*|<tformat|<table|<row|<cell|y<rsub|i><around|(|\<omega\>|)>>|<cell|=Y<rsub|i><around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcW>>>|)><indicator|[-<frac|\<pi\><mwcW>|<mwcM>>,<frac|\<pi\><mwcW>|<mwcM>>)>>>|<row|<cell|<B|\<Phi\>><rsub|i,l>>|<cell|=p<rsub|i*l>>>|<row|<cell|<B|\<Psi\>><rsub|l,r>>|<cell|=<frac|<mwcM>|<mwcW>>*e<rsup|-j<tfrac|2*\<pi\>|<mwcL>>l*m<rsub|r>>>>|<row|<cell|s<rsub|r><around|(|\<omega\>|)>>|<cell|=\<beta\><rsub|r><rect|<tfrac|<mwcM>|\<pi\><mwcW>>\<omega\>><space|0.17em>X*<around|(|\<omega\>-m<rsub|r><tfrac|<mwcW>|<mwcL>>|)>>>|<row|<cell|\<beta\><rsub|r>>|<cell|=<frac|1-e<rsup|-j*<frac|2*\<pi\>|<mwcL>>*m<rsub|r>>|j*2*\<pi\>*m<rsub|r>>,<space|1em>\<beta\><rsub|0>=1/<mwcL>,>>>>>

  for <math|i=0,\<ldots\>,<mwcq>-1>, <math|l=0,\<ldots\>,<mwcL>-1>,
  <math|r=0,\<ldots\>,<around*|\<lfloor\>|<frac|<mwcL>|<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>-1>
  and <math|m<rsub|r>=-<around*|\<lfloor\>|<frac|<mwcL>|2<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>+1+r>.
  Note that the scalars <math|\<beta\><rsub|r>> are the complex conjugates of
  <math|\<alpha\><rsub|r>> in<nbsp><eqref|equ:rd<rsub|m>atrixform>.
  Like<nbsp><eqref|equ:rd<rsub|m>atrixform>, this linear system of equations
  is underdetermined since the matrix <math|<B|\<Phi\>><B|\<Psi\>>> has
  dimensions <math|<mwcq>\<times\><tfrac|<mwcL>|<mwcM>><around|(|<mwcM>+1|)>>
  and the assumption <math|<mwcq>\<leq\><mwcL>\<less\><mwcM>> (see
  Section<nbsp><reference|subsect:mwc>) implies
  <math|<mwcq>\<less\><tfrac|<mwcL>|<mwcM>><around|(|<mwcM>+1|)>>. If
  <math|x<around|(|t|)>> is a sparse multiband signal, the vector
  <math|<B|s><around|(|\<omega\>|)>> is sparse in the sense that most of its
  elements (segments of <math|X<around|(|\<omega\>|)>>) do not contain
  occupied frequency bands that comprise <math|x<around|(|t|)>>. This fact is
  important because the CS methods used in the reconstruction process rely on
  a signal's sparsity to recover the support of
  <math|<B|s><around|(|\<omega\>|)>>. Equation<nbsp><eqref|equ:mwc<rsub|m>atrixform>
  can also be derived from the single channel MWC, although one has to first
  extract <math|<mwcq>> lower rate sample sequences from the single higher
  rate output sequence. We refer the reader to<nbsp><cite|mishali_eldar2010>
  for details regarding the extra processing steps.

  We emphasise that in practice the linear system
  in<nbsp><eqref|equ:mwc<rsub|m>atrixform> cannot, in general, be formulated
  because it requires an infinite amount of data. To understand this claim
  and its consequences, we consider the inverse DTFT
  of<nbsp><eqref|equ:mwc<rsub|m>atrixform>. From their definition, it
  immediately follows that the inverse DTFT of the spectra
  <math|y<rsub|i><around|(|\<omega\>|)>=Y<rsub|i><around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcW>>>|)><indicator|[-<frac|\<pi\><mwcW>|<mwcM>>,<frac|\<pi\><mwcW>|<mwcM>>)>>
  (left hand side of<nbsp><eqref|equ:mwc<rsub|m>atrixform>) are the time
  domain sequences <math|<around|{|y<rsub|i><around|(|k|)>,k\<in\>\<bbb-Z\>|}><rsub|i>>.
  To take the inverse DTFT of the right hand side
  of<nbsp><eqref|equ:mwc<rsub|m>atrixform>, one interprets the spectral
  segments <math|s<rsub|r><around|(|\<omega\>|)>=\<beta\><rsub|r><rect|<tfrac|<mwcM>|\<pi\><mwcW>>\<omega\>><space|0.17em>X*<around|(|\<omega\>-m<rsub|r><tfrac|<mwcW>|<mwcL>>|)>>
  as single periods of periodic spectra. By doing so, it follows that their
  inverse DTFT are the sequences <math|<around|{|\<gamma\><rsub|r><around|(|k|)>,k\<in\>\<bbb-Z\>|}><rsub|r>>
  where

  <\equation>
    \<gamma\><rsub|r><around|(|k|)>=<frac|<mwcM>|2*\<pi\><mwcW>>*<big|int><rsub|-\<pi\><mwcW>/<mwcM>><rsup|\<pi\><mwcW>/<mwcM>>s<rsub|r><around|(|\<omega\>|)>*e<rsup|j*<frac|<mwcM>|<mwcW>>*k*\<omega\>><nbsp>d*\<omega\>.
  </equation>

  and

  <\equation>
    <label|equ:spectal>s<rsub|r><around|(|\<omega\>|)>=<big|sum><rsub|k=-\<infty\>><rsup|\<infty\>>\<gamma\><rsub|r><around|(|k|)>*e<rsup|-j<tfrac|<mwcM>|<mwcW>>k*\<omega\>>,<space|1em>\<omega\>\<in\>[-\<pi\><mwcW>/<mwcM>,\<pi\><mwcW>/<mwcM>].
  </equation>

  The transform pair of<nbsp><eqref|equ:mwc<rsub|m>atrixform> is therefore
  the linear system,

  <\equation>
    <label|equ:mwc><B|Y>=<mwcphi><mwcpsi><B|S>
  </equation>

  where <math|<mwcphi>> and <math|<mwcpsi>> are as
  in<nbsp><eqref|equ:mwc<rsub|m>atrixform>, <math|<B|Y>> is an <em|infinite>
  column matrix whose <math|i>th row is the sequence
  <math|y<rsub|i><around|(|k|)>,k\<in\>\<bbb-Z\>>, and <math|<B|S>> is an
  <em|infinite> column matrix whose <math|r>th row equals
  <math|\<gamma\><rsub|r><around|(|k|)>,k\<in\>\<bbb-Z\>>. The matrix
  <math|<B|S>> is described as being <em|jointly sparse> because most of its
  rows are zero since the zero-valued elements of
  <math|<B|s><around|(|\<omega\>|)>> correspond to zero-valued sequences
  <math|\<gamma\><rsub|r><around|(|k|)>> (rows of <math|<B|S>>). A matrix
  <math|<B|Z>> is said to be <math|K> joint sparse if there are at most
  <math|K> rows in <math|<B|Z>> that contain nonzero elements. The recovery
  of <math|<B|S>> from the measurements <math|<B|Y>>
  in<nbsp><eqref|equ:mwc<rsub|i>mv> is called an <em|infinite measurement
  vector> (IMV) problem<nbsp><cite|mishali_eldar2008|eldar2009|mishali_eldar2010>
  in the CS literature because each column of <math|<B|Y>> is viewed as a CS
  measurement (via the measurement matrix <math|<mwcphi><mwcpsi>>) of a
  collection of vectors that share a common sparse support.

  In practice, this IMV problem can never be formulated because we can only
  ever observe <math|x<around|(|t|)>> over a finite duration window, and thus
  can only ever collect a finite number of samples. This practicality in
  effect truncates the rows of <math|<B|Y>> and
  causes<nbsp><eqref|equ:mwc<rsub|i>mv> to become a so-called <em|multiple
  measurement vector> (MMV) problem<nbsp><cite|cotter_etal2005|chen_huo2006|mishali_eldar2008|davies_eldar2010>,
  where the goal is to recover a finite number of the columns of the jointly
  sparse matrix <math|<B|S>> corresponding to the finite number of acquired
  samples in an underdetermined linear system. Using existing CS methods,
  this MMV problem can be solved exactly, or with exceedingly high
  probability, provided the matrix <math|<mwcphi><mwcpsi>> satisfies certain
  conditions and that enough samples are collected. The solution, however,
  only provides a linear approximation<nbsp><cite|mallat1999> to the true
  spectral slices <math|y<rsub|i><around|(|\<omega\>|)>=Y<rsub|i><around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcW>>>|)><indicator|[-<frac|\<pi\><mwcW>|<mwcM>>,<frac|\<pi\><mwcW>|<mwcM>>)>>
  because the solution only recovers a finite number of coefficients
  <math|\<gamma\><rsub|r><around|(|k|)>> in<nbsp><eqref|equ:spectal<rsub|s>lice<rsub|D>TFT>.
  In general, an infinite number of coefficients would need to be recovered
  to perfectly reconstruct a multiband signal, or equivalently, an infinite
  number of samples would need to be acquired. This fact is in contrast to
  the sparse multitone signal model that is parameterised by a finite number
  of parameters and thus only requires a finite number of samples for perfect
  signal reconstruction. It is important to note that even though
  <math|x<around|(|t|)>> can only be approximated in practice, there is an
  advantage in applying CS theory\Vit allows one to recover the same order of
  linear approximation obtained by sampling at the Nyquist rate, but at rates
  significantly below the Nyquist rate.

  In<nbsp><cite|mishali_eldar2010> and<nbsp><cite|mishali_eldar2008>, Mishali
  and Eldar proposed a two step reconstruction process termed the
  \Pcontinuous to finite block\Q that provably recovers
  <math|x<around|(|t|)>> exactly given an infinite amount of data, or in
  other words, recovers <math|x<around|(|t|)>> to an arbitrary precision
  given sufficient data. The first step recovers the joint support of
  <math|<B|S>> by solving an associated MMV problem, and the second step uses
  the found support to reduce the dimension of the measurement matrix
  <math|<mwcphi><mwcpsi>> such that its pseudoinverse can be used to find a
  unique solution to the MMV problem. We stress that even if this two step
  process perfectly solves the MMV problem derived
  from<nbsp><eqref|equ:mwc<rsub|i>mv>, the solution can only, in general,
  approximate <math|x<around|(|t|)>> for a finite number of samples.

  <with|font-series|bold|MWC model sensitivity.> We now discuss a model
  sensitivity of the MWC that is similar to the RD's model sensitivity
  discussed above. Recall that nonharmonic signals on the observation
  interval <math|<around|[|0,T|]>> the signal vector <math|<B|x>>
  in<nbsp><eqref|equ:rd<rsub|m>atrixform> may not be sparse for the RD.
  Similarly, <math|<B|S>> may become non-sparse for short duration multiband
  signals. To be concrete, let <math|x<around|(|t|)>> be a sparse multiband
  signal with a FT <math|X<around|(|\<omega\>|)>> and let
  <math|z<around|(|t|)>> be a windowed version of <math|x<around|(|t|)>>,

  <\equation>
    z<around|(|t|)>=x<around|(|t|)>*w<around|(|t|)>,
  </equation>

  where <math|w<around|(|t|)>> is an indicator function of some sub-interval
  of the observation interval. The signal <math|z<around|(|t|)>> is thus a
  short duration multiband signal that has a spectrum equal to
  <math|X<around|(|\<omega\>|)>> convolved with a sinc
  function<nbsp><cite|roberts_mullisDSP>. As is well-known, this convolution
  spreads the original spectrum <math|X<around|(|\<omega\>|)>>. If it is
  sufficiently spread (or equivalently if <math|w<around|(|t|)>> is
  sufficiently short), <math|<B|s><around|(|\<omega\>|)>> and <math|<B|S>>
  are no longer sparse. This situation violates one of the necessary and
  sufficient conditions for successful reconstruction as outlined by Mishali
  and Eldar in<nbsp><cite-detail|mishali_eldar2010|Theorems 2 and 3,
  Condition 2>. Thus, as with the RD when sampling nonharmonic multitone
  signals, the MWC exhibits a limitation in recovering short duration
  multiband signals because the sparsity of
  <math|<B|s><around|(|\<omega\>|)>> and <math|<B|S>> is potentially lost.
  The following numerical example illustrates the point.

  <with|font-series|bold|Example.> Consider the set of sparse multiband
  signals with maximal frequencies of <math|\<pm\>1000> Hz and a MWC with ten
  channels each sampling at <math|20> Hz with each channel using a waveform
  <math|p<rsub|i><around|(|t|)>> having a period of <math|0.05> seconds
  (<math|<mwcW>=1000> Hz, <math|<mwcq>=10>, <math|<mwcL>=<mwcM>=50>). We
  simulate a multiband signal <math|x<around|(|t|)>> by notch-filtering a
  discrete time white random noise process that has six active bands each
  having bandwidth of <math|20> Hz. In this example, the system average
  sampling rate is <math|200> Hz which is <math|66%> greater than the
  theoretical minimum sampling rate of <math|120> Hz<nbsp><cite|landau1967>.
  The two top panels on the right and left of
  Figure<nbsp><reference|fig:poor> show the reconstruction results when
  <math|x<around|(|t|)>> persists over the entire 1 second observation
  interval. In this case, the MWC correctly recovers the support and yields
  an accurate approximation of <math|x<around|(|t|)>>. However, if the signal
  model is shortened to <math|0.05> seconds while keeping all other
  parameters fixed, the two bottom panels show that the MWC fails to
  correctly recover the signal. This short duration signal represents, in
  some sense, a signal that maximally mismatches the multiband model and the
  MWC's sampling functions because each have infinite support in time.

  <\big-figure>
    <minipage|f|.48tex-text-width| <image|mwc_ex_time_plots.eps|7cm|||>>

    <minipage|f|.48tex-text-width|<image|mwc_ex_freq_plots.eps|7cm|||>>

    <label|fig:poor>
  </big-figure|The plots show the results of an experiment that demonstrates
  the MWC's sensitivity to short duration signals, or equivalently, short
  observation intervals. The top row shows a simulated multiband signal
  bandlimited to <math|500> Hz with three occupied bands (six between
  <math|\<pm\>500> Hz). The left hand column shows time domain signals, the
  right shows the frequency domain. The second row shows the reconstructed
  signal when the input is sampled by a 10 channel MWC with an average
  sampling rate of <math|200> Hz over a one second interval
  (<math|<mwcW>=1000> Hz, <math|<mwcq>=10>, <math|<mwcM><mwcL>=50>). In this
  case, the MWC faithfully reconstructs the input signal, save for the time
  domain delay caused by the digital filter that simulates the ideal analogue
  low pass filter. However, if the input signal is shorten to <math|0.05>
  seconds (third row) and sampled by the same system, the MWC fails to
  correctly recover the multiband signal's support and thus fails to
  reconstruct the signal.>

  <section|Exchanging signal models and sampling continuous-time block-sparse
  signals><label|sect:more>

  We devote this section to a simple exercise that reveals three interesting
  aspects of the RD and the MWC and suggests a new analogue CS sampling
  system. First, the exercise plainly shows that the MWC can successfully
  sample and recover sparse multitone signals without any modification to the
  recovery algorithm originally proposed by Mishali and Eldar
  in<nbsp><cite|mishali_eldar2010>. Second, it leads to a special case in
  which the MWC and the RD produce equivalent SMV problems and that
  underlines the fact that the RD acquires samples sequentially while the MWC
  acquires them in parallel. Third, it highlights a property of the MWC that
  differentiates it from the RD and allows it to successfully sample and
  recover \Pblock\Q sparse signals (e.g. multiband signals). We conclude the
  section by proposing a new CS sampling system that uses this property to
  sample and recover continuous-time block-sparse signals.

  <subsection|MWC with sparse multitone inputs>

  Consider the problem of using a MWC to sample and recover a sparse
  multitone signal instead of sparse multiband signal. Let
  <math|x<around|(|t|)>> be a sparse multitone signal on the observation
  interval <math|<around|[|0,T|]>> with <math|T=<tfrac|N|W>> and let
  <math|p<rsub|i><around|(|t|)>> be as described as in
  Section<nbsp><reference|subsect:mwc>. To make the problem meaningful, we
  assume the observation interval is greater than or equal to the sampling
  period (<math|T\<geq\>T<rsub|s>>) and assume, for ease of exposition, that
  the period of <math|p<rsub|i><around|(|t|)>> equals the sampling period
  (<math|T<rsub|p>=T<rsub|s>>). Equivalently, we assume
  <math|N\<geq\><mwcL>=<mwcM>>, where we recall from
  Section<nbsp><reference|subsect:mwc> that <math|<mwcL>=T<rsub|p>/<mwcW>>
  and <math|<mwcM>=T<rsub|s>/<mwcW>>.

  A parallel analysis to that given in Appendix<nbsp><reference|app:MWC>,
  then yields an expression relating the FS coefficients of
  <math|x<around|(|t|)>> to the DFT coefficients of the output samples,

  <align|<tformat|<table|<row|<cell|Y<rsub|i><around|(|n|)>>|<cell|=<frac|<mwcL>|N>*<big|sum><rsub|m=-<around*|\<lfloor\>|<frac|N|2<mwcL>>*<around|(|<mwcL>+1|)>|\<rfloor\>>+1><rsup|<around*|\<lfloor\>|<frac|N|2<mwcL>>*<around|(|<mwcL>+1|)>|\<rfloor\>>>P<rsub|i><around|(|m|)>*<space|0.17em>X*<around|(|n-<tfrac|N|<mwcL>>m|)>,>>|<row|<cell|>|<cell|=<frac|<mwcL>|N>*<big|sum><rsub|m=-<around*|\<lfloor\>|<frac|N|2<mwcL>>*<around|(|<mwcL>+1|)>|\<rfloor\>>+1><rsup|<around*|\<lfloor\>|<frac|N|2<mwcL>>*<around|(|<mwcL>+1|)>|\<rfloor\>>><big|sum><rsub|l=0><rsup|<mwcL>-1>p<rsub|i*l><nbsp><frac|1-e<rsup|-j*<frac|2*\<pi\>|<mwcL>>*m>|j*2*\<pi\>*m><nbsp>e<rsup|-j*<frac|2*\<pi\>|<mwcL>>*l*m>*<space|0.17em>X*<around|(|n-<tfrac|N|<mwcL>>m|)>,<label|equ:mwc>>>>>>

  for <math|n=-<around*|\<lfloor\>|<frac|N|2<mwcL>>|\<rfloor\>>,\<ldots\>,<around*|\<lfloor\>|<frac|N|2<mwcL>>|\<rfloor\>>-1>.
  This expression is analogous to the frequency domain description of the RD
  given by<nbsp><eqref|equ:rd<rsub|f>reqdomain> and is
  what<nbsp><eqref|equ:mwc<rsub|f>reqdomain> becomes assuming a sparse
  multitone signal model and <math|<mwcL>=<mwcM>>. In matrix
  form,<nbsp><eqref|equ:mwc<rsub|t>one> becomes the MMV problem,

  <\equation>
    <label|equ:mwc><B|Y>=<mwcphi><mwcpsi><B|S>,
  </equation>

  where

  <align*|<tformat|<table|<row|<cell|<B|Y><rsub|i,v>>|<cell|=Y<rsub|i><around|(|n<rsub|v>|)>>>|<row|<cell|<B|\<Phi\>><rsub|i,l>>|<cell|=p<rsub|i*l>>>|<row|<cell|<B|\<Psi\>><rsub|l,r>>|<cell|=<frac|<mwcL>|N>*e<rsup|-j<tfrac|2*\<pi\>|<mwcL>>l*m<rsub|r>>>>|<row|<cell|<B|S><rsub|r,v>>|<cell|=\<alpha\><rsub|r>*X*<around|(|n<rsub|v>-<tfrac|N|<mwcL>>m<rsub|r>|)>>>|<row|<cell|\<alpha\><rsub|r>>|<cell|=<frac|1-e<rsup|-j*<frac|2*\<pi\>|<mwcL>>*m<rsub|r>>|j*2*\<pi\>*m<rsub|r>>,<space|1em>\<alpha\><rsub|0>=1/<mwcL>,>>>>>

  for <math|i=0,\<ldots\>,q-1>, <math|l=0,\<ldots\>,<mwcL>-1>,
  <math|v=0,\<ldots\>,<around*|\<lfloor\>|<tfrac|N|<mwcL>>|\<rfloor\>>-1>,
  <math|n<rsub|v>=-<around*|\<lfloor\>|<tfrac|N|2<mwcL>>|\<rfloor\>>+v>,
  <math|r=0,\<ldots\>,<around*|\<lfloor\>|<frac|N|<mwcL>>*<around|(|<mwcL>+1|)>|\<rfloor\>>-1>
  and <math|m<rsub|r>=-<around*|\<lfloor\>|<frac|N|2<mwcL>>*<around|(|<mwcL>+1|)>|\<rfloor\>>+1+r>.
  In contrast to sampling a sparse multiband signal, this MWC MMV problem
  does not result from truncation, rather its finiteness derives from the
  fact that multitone signals are finitely parameterised. The Fourier
  components of <math|x<around|(|t|)>> can be recovered by
  solving<nbsp><eqref|equ:mwc<rsub|m>ultitone<rsub|m>mv> using several
  existing CS algorithms including greedy
  algorithms<nbsp><cite|greedy_pursuit_tropp_etal2006>, mixed norm
  approaches<nbsp><cite|convex_relax_tropp_etal2006>, MUSIC based recovery
  algorithms<nbsp><cite|davies_eldar2010> and, in particular, the approach
  proposed by Mishali and Eldar in<nbsp><cite|mishali_eldar2010>
  and<nbsp><cite|mishali_eldar2008>. We conclude therefore that the MWC can
  successfully sample and recover sparse multitone signals without any
  modification to Mishali's and Eldar's recovery algorithm.

  <with|font-series|bold|Special case.> Note that when the observation
  interval, the period of <math|p<rsub|i><around|(|t|)>>, and the sampling
  period are equal, i.e. when <math|N=<mwcL>=<mwcM>>,<nbsp><eqref|equ:mwc<rsub|m>ultitone<rsub|m>mv>
  collapses to the SMV problem,

  <\equation>
    <label|equ:mwc><B|y><around|(|n|)>=<mwcphi><mwcpsi><B|x><around|(|n|)>,
  </equation>

  where <math|<B|y><around|(|n|)>=<around|[|Y<rsub|0><around|(|0|)>,\<ldots\>,Y<rsub|q-1><around|(|0|)>|]><rprime|'>>
  and <math|<B|x><around|(|n|)>=X(-m<rsub|r>)>, for
  <math|m<rsub|r>=-<around*|\<lfloor\>|<tfrac|<mwcL>+1|2>|\<rfloor\>>+1+r>,
  <math|r=0,\<ldots\>,<mwcL>>. The FS coefficients <math|<B|x><around|(|n|)>>
  can thus be solved for using standard CS SMV recovery techniques. In this
  special circumstance, the MWC collects a single measurement vector in the
  observation interval and thus each channel samples the product
  <math|x<around|(|t|)>*p<rsub|i><around|(|t|)>> once at the end of the
  observation interval. Comparing<nbsp><eqref|equ:mwc<rsub|m>ultitione<rsub|s>mv>
  to<nbsp><eqref|equ:rd<rsub|m>atrixform>, one sees that in this case the RD
  collects its samples sequentially while the MWC collects them in parallel.
  This special case presents an example where the MWC and the RD produce
  equivalent SMV problems thus provides one way to directly compare the RD
  and the MWC.

  This example highlights a property of the MWC that differentiates it from
  the RD and allows it to successfully sample and recover multitone signals,
  as well as multiband signals. Specifically, the convolution
  in<nbsp><eqref|equ:mwc<rsub|t>one> involves shifts of
  <math|X<around|(|n|)>> by integer multiplies of <math|<tfrac|N|<mwcL>>>
  that, when greater than one, yields a \Pblock convolution\Q. By
  block-convolution, we mean every DFT coefficient
  <math|Y<rsub|i><around|(|n|)>> in<nbsp><eqref|equ:mwc<rsub|t>one> is a
  linear combination of finite segments of <math|X<around|(|n|)>>.
  Block-convolution is also seen in<nbsp><eqref|equ:mwc<rsub|f>reqdomain>
  where the FT of a multiband signal is shifted by integer multiplies of
  <math|<tfrac|<mwcW>|<mwcL>>>. It is, however, in contrast
  to<nbsp><eqref|equ:rd<rsub|f>reqdomain> where the frequency shifts
  describing the RD are by one.

  This aspect of the MWC allows the construction of a linear system of
  equations like<nbsp><eqref|equ:mwc<rsub|m>atrixform>
  and<nbsp><eqref|equ:mwc<rsub|m>ultitone<rsub|m>mv> that describe the
  original spectra in terms of linear combinations of these blocks. The
  blocks themselves represent a partition of the frequency axis that
  effectively discretised the block sparsity of multiband signals. In
  Section<nbsp><reference|subsect:timeblocksparse> below, we incorporate this
  property into a multi-channel random convolution system that samples and
  approximately recovers <em|continuous-time block-sparse signals>, the time
  domain analogue of sparse multiband signals. In the next section, we
  consider the counterpart of this section and examine the case where a
  sparse multiband signal is sampled by a RD. Because the RD formulation does
  not rely on block convolution, we show that the resulting SMV problem can
  become computationally burdensome in certain circumstances.

  <subsection|RD with sparse multiband inputs><label|subsect:rd>

  When a multiband signal is the assumed signal model for the RD, the system
  fails to produce a single measurement vector problem whose solution
  recovers <math|x<around|(|t|)>>. To be more concrete, let
  <math|x<around|(|t|)>> be a sparse multiband signal bandlimited to
  <math|<mwcW>> Hertz and with a fixed spectral occupancy
  <math|\<lambda\><around|(|\<cal-F\>|)>> and consider a RD parameterised by
  <math|M> that samples <math|x<around|(|t|)>> on <math|<around|[|0,T|]>>.
  Let <math|p<around|(|t|)>> be as described in
  Section<nbsp><reference|subsect:sampling>. A similar analysis to that
  contained in Appendix<nbsp><reference|app:RD> then leads to the expression

  <\equation>
    y<around|(|k|)>=<big|sum><rsub|m=0><rsup|N/M-1>p<rsub|k<tfrac|N<rprime|'>|M>+m>*<big|int><rsub|-\<pi\><mwcW>><rsup|\<pi\><mwcW>>X<around|(|\<omega\>|)><space|0.17em><frac|e<rsup|j*<frac|\<omega\>|<mwcW>>>-1|j*\<omega\>>*<space|0.17em>e<rsup|j*\<omega\>*<around*|(|k<tfrac|N<rprime|'>|M>+m|)>><nbsp>d*\<omega\>,
  </equation>

  where here <math|N<rprime|'>> represents the number of Nyquist periods
  within the observation window (<math|N<rprime|'>=<tfrac|T|<mwcW>>>). To
  construct a RD formulation, one could approximate the integral based on
  samples of the integrand:

  <\equation>
    <label|equ:RDmultibandSMV>y<around|(|k|)>\<approx\><big|sum><rsub|m=0><rsup|N<rprime|'>/M-1><big|sum><rsub|i=0><rsup|D-1>p<rsub|k<tfrac|N<rprime|'>|M>+m>*<space|0.17em>X<around|(|\<omega\><rsub|i>|)><frac|e<rsup|j*<frac|\<omega\><rsub|i>|<mwcW>>>-1|j*\<omega\><rsub|i>>*<space|0.17em>e<rsup|j*\<omega\><rsub|i>*<around*|(|k<tfrac|N<rprime|'>|M>+m|)>><nbsp>\<delta\><rsub|\<omega\>>,
  </equation>

  where <math|\<delta\><rsub|\<omega\>>=<tfrac|2*\<pi\>*W|D>> for some
  positive integer <math|D> and <math|\<omega\><rsub|i>=-\<pi\>*W+\<delta\><rsub|\<omega\>>*<around|(|i+1/2|)>>.
  One can then see that in comparison to<nbsp><eqref|equ:rd<rsub|m>atrixform>,
  this expression describes a single measurement vector problem
  <math|<B|y><around|(|k|)>=<rdphi><rdpsi><space|0.17em><B|x><around|(|\<omega\><rsub|i>|)>>
  where the vector <math|<B|x><around|(|\<omega\><rsub|i>|)>> grows
  infinitely long as the integral is more and more closely approximated,
  i.e., as <math|D\<rightarrow\>\<infty\>>. Here, the matrices <math|<rdphi>>
  and <math|<rdpsi>> are as in<nbsp><eqref|equ:rd<rsub|m>atrixform>. Because
  the RD is designed to sample and recover sparse multitone signals, this
  approximation results if one uses a multitone signal as a model for a
  multiband signal, or in essence, uses a FS to approximate a FT. Clearly, in
  cases where one wants a fine resolution approximation, the size of the
  matrices in this SMV problem could grow to become computationally unwieldy.

  <subsection|Sampling continuous-time block-sparse
  signals><label|subsect:timeblocksparse>

  The class of <em|continuous-time block signals>
  <math|\<cal-G\><around|(|\<cal-T\>,t<rsub|0>|)>> is the set of
  continuous-time, complex-valued, finite energy signals whose support is a
  finite union of bounded intervals,

  <align|<tformat|<table|<row|<cell|>|<cell|\<cal-G\><around|(|\<cal-T\>,t<rsub|0>|)>=<around*|{|x<around|(|t|)>\<in\>L<rsup|2><around|(|<around|[|0,t<rsub|0>|]>|)>\<cap\>C<around|(|<around|[|0,t<rsub|0>|]>|)>:x<around|(|t|)>=0,t\<nin\>\<cal-T\>|}><label|def:time><intertext|w*h*e*r*e>>|<cell|\<cal-T\>=<big|cup><rsub|i=1><rsup|K><around|[|a<rsub|i>,b<rsub|i>|)>,<space|1em>0\<leq\>a<rsub|i>,b<rsub|i>\<leq\>t<rsub|0>\<less\>\<infty\>.>>>>>

  A <em|continuous-time block-sparse signal> is a continuous-time block
  signal whose support has Lebesgue measure that is small relative to the
  signal's overall duration, i.e., <math|\<lambda\><around|(|\<cal-T\>|)>\<ll\>t<rsub|0>>.

  The proposed system we present in the following paragraphs combines block
  convolution with the MWC multi-channel architecture and the random
  convolution ideas of Romberg to obtain a sampling system for
  continuous-time block-sparse signals (see
  Figure<nbsp><reference|subfig:timeblock>). The resulting system can also be
  interpreted as the time domain analogue of the MWC.

  Let <math|x<around|(|t|)>> be a continuous block-sparse signal on the
  interval <math|<around|[|0,T|]>> and let
  <math|<around|{|p<rsub|i><around|(|l<tfrac|T|L>|)>|}><rsub|i>> be an
  ensemble of discrete time signals <math|l=1,\<ldots\>,L,<nbsp>L\<in\>\<bbb-Z\><rsup|+>>
  taking values <math|\<pm\>1> with equal probability. The system has
  multiple channels and operates in parallel like the MWC. The <math|i*t*h>
  channel convolves <math|x<around|(|t|)>> with
  <math|p<rsub|i><around|(|l<tfrac|T|L>|)>>, resulting in the continuous-time
  signal <math|g<rsub|i><around|(|t|)>>,

  <\equation>
    <label|equ:block>g<rsub|i><around|(|t|)>=<big|sum><rsub|l=-<around|(|L-1|)>><rsup|L-1>p<rsub|i><around|(|l<tfrac|T|L>|)>*x*<around|(|t-l<tfrac|T|L>|)>.
  </equation>

  By construction, this convolution is a block-convolution. The corresponding
  filter is a standard digital-to-analogue reconstruction
  filter<nbsp><cite|roberts_mullisDSP>, but is used here in the sampling
  process. Restricting the time axis to the interval
  <math|<around|[|0,T/L|]>> and with a change of
  variables,<nbsp><eqref|equ:block<rsub|c>onvolution<rsub|a>> becomes

  <\equation>
    <label|equ:block>g<rsub|i><around|(|t|)><indicator|<around|[|0,T/L|]>>=<big|sum><rsub|l=0><rsup|L-1>p<rsub|i><around|(|l<tfrac|T|L>|)>*x*<around|(|t-l<tfrac|T|L>|)><indicator|<around|[|0,T/L|]>>.
  </equation>

  Representing the segments <math|x*<around|(|t-l<tfrac|T|L>|)><indicator|<around|[|0,T/L|]>>>
  in an appropriate orthogonal basis,<nbsp><eqref|equ:block<rsub|c>onvolution<rsub|a>>
  may be written as

  <\equation>
    <label|equ:block>g<rsub|i><around|(|t|)><indicator|<around|[|0,T/L|]>>=<big|sum><rsub|l=0><rsup|L-1><big|sum><rsub|n=-\<infty\>><rsup|\<infty\>>p<rsub|i><around|(|l<tfrac|T|L>|)>*\<alpha\><rsub|l><around|(|n|)>*\<psi\><rsub|n><around|(|t|)>,
  </equation>

  where <math|\<alpha\><rsub|l><around|(|n|)>=<around*|\<langle\>|x*<around|(|t-l<tfrac|T|L>|)><indicator|<around|[|0,T/L|]>>,\<psi\><rsub|n><around|(|t|)>|\<rangle\>>>.
  The signal <math|g<rsub|i><around|(|t|)>> is then sampled at a rate of
  <math|<tfrac|L*M|T>> Hz over the interval
  <math|<around|[|0,<tfrac|T|L>|]>>,

  <\equation>
    <label|equ:block>y<rsub|i><around|(|k|)>=g<rsub|i><around|(|k<tfrac|T|L*M>|)>=<big|sum><rsub|l=0><rsup|L-1><big|sum><rsub|n=-\<infty\>><rsup|\<infty\>>p<rsub|i><around|(|l<tfrac|T|L>|)>*\<alpha\><rsub|l><around|(|n|)>*\<psi\><rsub|n><around|(|k<tfrac|T|L*M>|)>,<space|1em>k=1,\<ldots\>,M,<nbsp>i=1,\<ldots\>*q.
  </equation>

  Given the samples <math|<around|{|y<rsub|i><around|(|k|)>|}>> one can solve
  for <math|L> linear approximations of the segments
  <math|x*<around|(|t-l<tfrac|T|L>|)><indicator|<around|[|0,T/L|]>>> by
  truncating the summation over <math|n> such that
  <math|<around|\<lvert\>|n|\<rvert\>>\<leq\>D\<less\>\<infty\>> and solving
  the matrix equation

  <\equation>
    <label|equ:block><B|Y><B|\<Psi\>><rsup|\<dagger\>>=<B|\<Phi\>><B|X>
  </equation>

  where

  <align*|<tformat|<table|<row|<cell|>|<cell|<B|Y><rsub|i,k>=y<rsub|i><around|(|k|)>>>|<row|<cell|>|<cell|<B|\<Phi\>><rsub|i,l>=p<rsub|i><around|(|l<tfrac|T|L>|)>>>|<row|<cell|>|<cell|<B|\<Psi\>><rsub|r,k>=\<psi\><rsub|n<rsub|r>><around|(|k<tfrac|T|L*M>|)>>>|<row|<cell|>|<cell|<B|X><rsub|l,k>=x*<around|(|k<tfrac|T|L*M>-l<tfrac|T|L>|)>>>>>>

  for <math|i=1,\<ldots\>,q>, <math|k=1,\<ldots\>,M>,
  <math|r=0,\<ldots\>,2*D>, <math|n<rsub|r>=-D+r> and where <math|\<dagger\>>
  denotes the pseudo-inverse of a matrix. The conditions on whether a unique
  solution can be found to<nbsp><eqref|equ:block<rsub|c>onvolution<rsub|e>>
  depends on the properties of the measurement matrix <math|<B|\<Phi\>>> and
  the degree to which <math|<B|X>> is sparse. (Because <math|x<around|(|t|)>>
  is assumed to be a continuous-time block sparse signal, it follows that
  <math|<B|X>> is a joint sparse matrix.) Notice that in this problem the CS
  measurements are not simply the samples <math|y<rsub|i><around|(|k|)>> as
  they were in<nbsp><eqref|equ:rd<rsub|m>atrixform>
  and<nbsp><eqref|equ:mwc<rsub|i>mv>, but are the elements of the product
  <math|<B|Y><B|\<Psi\>><rsup|\<dagger\>>>. Consequently, the number of CS
  measurements acquired is <em|not> related to the sampling rate
  <math|L*M/T>, but to the number of channels <math|q> and the order of the
  linear approximation <math|D>. The following example, however, shows that a
  good approximation of a continuous-time block sparse signal can be obtained
  with a relatively small number of samples.

  <with|font-series|bold|Example.> Consider the continuous-time block sparse
  signal depicted in the top panel of Figure<nbsp><reference|subfig:timeblock>.
  Samples of the filtered signals <math|g<rsub|i><around|(|t|)>> (middle
  panel) are acquired by a 6 channel system (<math|q=6>) with a sampling rate
  of <math|400> Hz (<math|M=40,L*M/T=400>)where the time axis is partitioned
  into 10 segments (<math|L=10>). Using a Fourier basis,
  <math|\<psi\><rsub|n><around|(|t|)>=e<rsup|j<tfrac|2*\<pi\>|T/L>>>, the
  linear system<nbsp><eqref|equ:block<rsub|c>onvolution<rsub|e>> was solved
  using the simultaneous orthogonal matching pursuit (S-OMP)
  algorithm<nbsp><cite|greedy_pursuit_tropp_etal2006> resulting in <math|L>
  linear approximations (<math|D=41>) of the segments
  <math|x*<around|(|t-l<tfrac|T|L>|)><indicator|<around|[|0,T/L|]>>>. The
  reconstructed signal is shown in the bottom panel of
  Figure<nbsp><reference|subfig:timeblock>. In this case, the reconstructed
  signal is a faithful representation of <math|x<around|(|t|)>>. Clearly, the
  quality of the reconstruction depends on how well the linear approximations
  approximate the segments of <math|x<around|(|t|)>> and also on how well a
  particular CS algorithm solves<nbsp><eqref|equ:block<rsub|c>onvolution<rsub|e>>.
  In any given application, some bases will be more appropriate than others.
  For example if <math|x<around|(|t|)>> contains discontinuities, a wavelet
  basis would provide a better approximation for a fixed <math|D>.

  Strictly speaking continuous-time block sparse signals are not bandlimited,
  but if one examines the spectrum of the test signal in
  Figure<nbsp><reference|subfig:timeblock>, one would discover that the
  signal is \Pessentially\Q bandlimited to about 1000 Hz. Thus, it could be
  argued according to the Shannon-Nyquist sampling theorem that a sampling
  rate of about 2000 Hz would be required to accurately capture this signal.
  Relative to 2000 Hz, 400 Hz represents a five fold savings in sampling
  rate.

  <\big-figure>
    <\subfigure*|>
      <minipage|f|.48tex-text-width| <image|rd_multichannel_blocksparse.eps|4.5cm|||>>

      <label|subfig:timeblock>
    </subfigure*>

    \;

    <\subfigure*|>
      <minipage|f|.48tex-text-width| <image|rd_modified_time_block_sparse.eps|7cm|||>>

      <label|subfig:timeblock>
    </subfigure*>

    \ 
  </big-figure|(a) Schematic diagram of sampling system for continuous-time
  block sparse signals. The system is a generalization of random convolution
  as originally proposed in<nbsp><cite|romberg2009>. Each channel convolves
  <math|x<around|(|t|)>> with a random sequence and then samples the result
  at a low rate. (b) Top panel: Simulated block sparse time domain signal on
  the unit interval. The signal is a modified version of the ``bumps'' test
  signal from the WaveLab toolbox<nbsp><cite|wavelab>. Middle panel: Overlay
  plot of the signals <math|g<rsub|i><around|(|t|)>> resulting from the
  random convolution. Here, <math|x<around|(|t|)>> was sampled with a 6
  channel system. Note that samples of <math|g<rsub|i><around|(|t|)>> are
  acquired on an interval shorter than the observation interval (<math|0.1>
  seconds versus <math|1.0> seconds). Bottom panel: Reconstructed signal
  approximation. Each <math|0.1> second duration segment is a linear
  approximation (Fourier basis) of <math|x<around|(|t|)>> on that segment.>

  <section|Conclusion><label|sect:conclusion>

  In this paper, we showed that the sampling mechanisms of the RD and the MWC
  can both be thought of as being based on the underlying concept of random
  filtering or random convolution. The most substantial difference between
  the systems stems from the specific form of their sampling functions (or
  random filters) and from the assumed signal models. The RD has sampling
  functions that have finite temporal extent but infinite spectral support;
  the MWC employs sampling functions that have finite spectral support but
  infinite temporal support. The randomness in the sampling functions is a
  hallmark of CS theory that is fundamental in guaranteeing the invertibility
  of the underdetermined linear systems that characterise the RD and the MWC.

  Block convolution is also an important property that differentiates the MWC
  from the RD because it is one approach that effectively processes infinite
  dimensional signals that have a block structure. The absence of this
  property is one primary reason the RD cannot, in general, reconstruct
  multiband signals. We incorporated block convolution into a new sampling
  system that samples continuous-time block-sparse signals.

  In this paper, we also offered novel insights into the practical
  reconstruction of sparse multiband signals using the MWC. We showed that
  with a finite amount of data the MWC necessarily produces linear
  approximations of the spectral slices of <math|x<around|(|t|)>>. We also
  showed that the MWC exhibits a sensitivity to short duration signals that
  derives from the fact that multiband signals are modeled as extending
  infinitely in time.

  From the perspective of this paper, one begins to consider generalisations
  to the RD and the MWC that target different signal classes, in particular,
  CS sampling systems that have different time-frequency characterisations.
  For example, a system that \Pcompressively\Q samples radar pulses and
  chirps in an efficient time-frequency manner could possibly offer a means
  to effectively detect and classify these signals while avoiding the
  overhead of sampling several bands simultaneously or reconstructing the
  Nyquist equivalent signal. This paper takes a step towards this goal by
  reconciling some of the core ideas behind these sampling systems.

  <section|Appendices>

  The following analyses yield basic time and frequency domain descriptions
  of the sampling/ measurement strategies. We employ standard Fourier
  transform properties without explicit explanation for the sake of
  conciseness. The notational style is that of<nbsp><cite|roberts_mullisDSP>.
  To denote transform pairs, we use the shorthand notation,

  <\equation*>
    x<around|(|t|)><long-arrow|\<rubber-leftrightarrow\>|<space|7pt><text|FT<space|7pt>>>X<around|(|\<omega\>|)>,
  </equation*>

  and use the abbrevations FT, FS, DTFT, and DFT when referring to the
  Fourier transform, the Fourier series, the discrete time Fourier transform,
  and the discrete Fourier transform, respectively. Also recall the
  definitions: <math|<sinc|<around|(|x|)>>=sin
  <around|(|x|)>/x,<space|0.17em>x\<in\><real>> and

  <\equation*>
    <text|rect><around|(|x|)>=<choice|<tformat|<table|<row|<cell|1<space|1em><text|for<nbsp>>-1\<leq\>x\<leq\>1>>|<row|<cell|0<space|1em><text|otherwise>>>>>>.
  </equation*>

  <subsection|Random Demodulator><label|app:RD>

  <with|font-series|bold|Time domain description.> Let <math|x<around|(|t|)>>
  be a sparse multitone signal on <math|<around|[|0,T|]>> and recall the
  following transform pairs from Section<nbsp><reference|sect:sampling>:

  <align*|<tformat|<table|<row|<cell|x<around|(|t|)>>|<cell|<long-arrow|\<rubber-leftrightarrow\>|<space|5pt><text|FS;1/T<space|5pt>>>X<around|(|n|)>>>|<row|<cell|p<around|(|t|)>>|<cell|<long-arrow|\<rubber-leftrightarrow\>|<space|5pt><text|FS;1/T<space|5pt>>>P<around|(|n|)>>>|<row|<cell|h<around|(|t|)>=<text|rect><around*|(|<tfrac|2*M|T>t-1|)>>|<cell|<long-arrow|\<rubber-leftrightarrow\>|<space|13pt><text|FT<space|13pt>>>H*<around|(|j*\<omega\>|)>=<tfrac|T|M><sinc|<around|(|<tfrac|T|2*M>\<omega\>|)>>e<rsup|-j*\<omega\>>.>>>>>

  By inspection of Figure<nbsp><reference|subfig:rd>, the time domain
  description of the RD is

  <align*|<tformat|<table|<row|<cell|g<around|(|t|)>=x<around|(|t|)>*p<around|(|t|)>\<ast\>h<around|(|t|)>>|<cell|=<big|int><rsub|-\<infty\>><rsup|\<infty\>>x<around|(|\<tau\>|)>*p<around|(|\<tau\>|)>*h*<around|(|t-\<tau\>|)><nbsp>d*\<tau\>>>|<row|<cell|>|<cell|=<big|int><rsub|t-<tfrac|T|M>><rsup|t>x<around|(|\<tau\>|)>*p<around|(|\<tau\>|)><nbsp>d*\<tau\>>>|<row|<cell|>|<cell|=<big|sum><rsub|n=-N/2><rsup|N/2-1>X<around|(|n|)>*<big|int><rsub|t-<tfrac|T|M>><rsup|t>p<around|(|\<tau\>|)>*e<rsup|j*<frac|2*\<pi\>|T>*n*\<tau\>><nbsp>d*\<tau\>,>>>>>

  where <math|\<ast\>> denotes convolution. Sampling at
  <math|t=<around|(|k+1|)><tfrac|T|M>> for <math|k=0,1,\<ldots\>> yields

  <align|<tformat|<table|<row|<cell|y<around|(|k|)>=g<around*|(|<around|(|k+1|)><tfrac|T|M>|)>>|<cell|=<big|sum><rsub|n=-N/2><rsup|N/2-1>X<around|(|n|)>*<big|int><rsub|k<tfrac|T|M>><rsup|<around|(|k+1|)><tfrac|T|M>>p<around|(|\<tau\>|)>*e<rsup|j*<frac|2*\<pi\>|T>*n*\<tau\>><nbsp>d*\<tau\><no-number>>>|<row|<cell|>|<cell|=<big|sum><rsub|n=-N/2><rsup|N/2-1>X<around|(|n|)>*<big|sum><rsub|m=0><rsup|N/M-1><big|int><rsub|k<tfrac|T|M>+<tfrac|m|W>><rsup|k<tfrac|T|M>+<tfrac|m+1|W>>p<around|(|\<tau\>|)>*e<rsup|j*<frac|2*\<pi\>|T>*n*\<tau\>><nbsp>d*\<tau\><no-number>>>|<row|<cell|>|<cell|=<big|sum><rsub|n=-N/2><rsup|N/2-1><big|sum><rsub|m=0><rsup|N/M-1>p<rsub|k<tfrac|N|M>+m>*X<around|(|n|)>*<big|int><rsub|k<tfrac|T|M>+<tfrac|m|W>><rsup|k<tfrac|T|M>+<tfrac|m+1|W>>e<rsup|j*<frac|2*\<pi\>|T>*n*\<tau\>><nbsp>d*\<tau\><no-number>>>|<row|<cell|>|<cell|=<choice|<tformat|<table|<row|<cell|T*<big|sum><rsub|n=-N/2><rsup|N/2-1><big|sum><rsub|m=0><rsup|N/M-1>p<rsub|k<tfrac|N|M>+m>*<space|0.17em>X<around|(|n|)><space|0.17em><frac|e<rsup|j*<frac|2*\<pi\>|N>*n>-1|j*2*\<pi\>*n>*<space|0.17em>e<rsup|j<tfrac|2*\<pi\>|N>n*<around*|(|k<tfrac|N|M>+m|)>>,>|<cell|n\<neq\>0>>|<row|<cell|<frac|1|W>*<big|sum><rsub|n=-N/2><rsup|N/2-1><big|sum><rsub|m=0><rsup|N/M-1>p<rsub|k<tfrac|N|M>+m>*<space|0.17em>X<around|(|n|)>,>|<cell|n=0>>>>><label|equ:rd>>>>>>

  where the first three steps follow from the additivity of the integral and
  the specific nature of <math|p<around|(|t|)>>. Here,
  <math|p<rsub|k<tfrac|N|M>+m>=p*<around|(|k<tfrac|T|M>+<tfrac|m|W>|)>>.
  Letting <math|l=k<tfrac|N|M>+m>,<nbsp><eqref|equ:rd<rsub|a>> may be
  rewritten as

  <\equation>
    <label|equ:rd>y<around|(|k|)>=<frac|N|W>*<big|sum><rsub|n=-N/2><rsup|N/2-1><big|sum><rsub|l=k<tfrac|N|M>><rsup|<around|(|k+1|)><tfrac|N|M>-1>p<rsub|l>*<space|0.17em><frac|e<rsup|j*<frac|2*\<pi\>|N>*n>-1|j*2*\<pi\>*n>*<space|0.17em>e<rsup|j<tfrac|2*\<pi\>|N>n*l>*<space|0.17em>X<around|(|n|)>,<space|1em><text|for<nbsp>>k=0,1,\<ldots\>,
  </equation>

  where this expression should be understood to be consistent
  with<nbsp><eqref|equ:rd<rsub|a>> for <math|n=0> above. For
  <math|k=0,\<ldots\>,M-1>,<nbsp><eqref|equ:rd<rsub|b>> may in turn be
  written in matrix form,

  <\equation>
    <B|y><around|(|k|)>=<rdphi><rdpsi><B|x><around|(|n|)>
  </equation>

  where <math|<B|y><around|(|k|)>>, <math|<rdphi>>, <math|<rdpsi>>, and
  <math|<B|x><around|(|n|)>> are defined in<nbsp><eqref|equ:rd<rsub|m>atrixform>.

  <vspace|7pt><with|font-series|bold|Frequency domain description.> We also
  have the following frequency domain description of the RD.
  <vspace|7pt><no-indent><with|font-series|bold|Multiplication/Convolution:>

  <\equation*>
    x<around|(|t|)>*p<around|(|t|)><long-arrow|\<rubber-leftrightarrow\>|<space|7pt><text|FS;1/T><space|7pt>><big|sum><rsub|m=-<around|\<lfloor\>|n-<frac|N|2>|\<rfloor\>>+1><rsup|<around|\<lfloor\>|n-<frac|N|2>|\<rfloor\>>>P<around|(|m|)>*X*<around|(|n-m|)>
  </equation*>

  <vspace|7pt><no-indent><with|font-series|bold|Convolution
  (filtering)/Multiplication:>

  <align*|<tformat|<table|<row|<cell|g<around|(|t|)>=x<around|(|t|)>*p<around|(|t|)>\<ast\>h<around|(|t|)><long-arrow|\<rubber-leftrightarrow\>|<space|7pt><text|FS;1/T><space|7pt>>G<around|(|n|)>>|<cell|=<big|sum><rsub|m=-<around|\<lfloor\>|n-<frac|N|2>|\<rfloor\>>+1><rsup|<around|\<lfloor\>|n-<frac|N|2>|\<rfloor\>>>P<around|(|m|)>*X*<around|(|n-m|)>*H<around|(|j<tfrac|2*\<pi\>|T>n|)>>>|<row|<cell|>|<cell|=<frac|T|M>*<big|sum><rsub|m=-<around|\<lfloor\>|n-<frac|N|2>|\<rfloor\>>+1><rsup|<around|\<lfloor\>|n-<frac|N|2>|\<rfloor\>>>P<around|(|m|)>*X*<around|(|n-m|)>*e<rsup|-j*<frac|2*\<pi\>|T>*n><sinc|<around|(|<tfrac|\<pi\>|M>n|)>>>>>>>

  <vspace|7pt><no-indent><with|font-series|bold|Sampling/Aliasing:>

  <\equation*>
    y<around|(|k|)>=g<around*|(|<around|(|k+1|)><tfrac|T|M>|)><long-arrow|\<rubber-leftrightarrow\>|<space|7pt><text|DFT;M><space|7pt>>Y<around|(|n|)>=M*<big|sum><rsub|l=-\<infty\>><rsup|\<infty\>>G*<around|(|n-l*M|)>
  </equation*>

  Because <math|Y<around|(|n|)>> is <math|M> periodic, we can, without loss
  of information, restrict it to one period. This means we need only consider
  one term in the summation over <math|l>. Retaining the <math|l=0> term
  yields

  <\equation*>
    Y<around|(|n|)>=T*<big|sum><rsub|m=-\<infty\>><rsup|\<infty\>>P<around|(|m|)>*e<rsup|-j*<frac|2*\<pi\>|T>*n><sinc|<around|(|<tfrac|\<pi\>|M>n|)>><space|0.17em>X*<around|(|n-m|)>,<space|1em>n=0,\<ldots\>,M-1.
  </equation*>

  <subsection|Modulated Wideband Converter><label|app:MWC>

  We have the following frequency domain description for the
  <math|i<rsup|th>> channel, <math|i=0,\<ldots\>,<mwcq>-1> of the MWC.

  <vspace|7pt><no-indent><with|font-series|bold|Multiplication/Convolution:>

  <align|<tformat|<table|<row|<cell|x<around|(|t|)>*p<rsub|i><around|(|t|)><long-arrow|\<rubber-leftrightarrow\>|<space|7pt><text|FT><space|7pt>>>|<cell|<big|sum><rsub|m=-\<infty\>><rsup|\<infty\>>P<rsub|i><around|(|m|)>*X*<around|(|\<omega\>-m*\<omega\><rsub|p>|)>>>|<row|<cell|>|<cell|<space|1em>=<big|sum><rsub|m=<around|\<lceil\>|<around|(|\<omega\>-\<pi\><mwcW>|)>/\<omega\><rsub|p>|\<rceil\>>+1><rsup|<around|\<lfloor\>|<around|(|\<omega\>+\<pi\><mwcW>|)>/\<omega\><rsub|p>|\<rfloor\>>>P<rsub|i><around|(|m|)>*X*<around|(|\<omega\>-m*\<omega\><rsub|p>|)><label|equ:mwc>>>>>>

  where <math|\<omega\><rsub|p>=2*\<pi\><mwcW>/<mwcL>> radians per second.
  The summation limits are finite for a given <math|\<omega\>> because
  <math|x<around|(|t|)>> is assumed to be bandlimited.

  <vspace|7pt><no-indent><with|font-series|bold|Convolution
  (filtering)/Multiplication:>

  <align|<tformat|<table|<row|<cell|g<rsub|i><around|(|t|)>=x<around|(|t|)>*p<rsub|i><around|(|t|)>\<ast\>h<around|(|t|)><long-arrow|\<rubber-leftrightarrow\>|<space|7pt><text|FT><space|7pt>>G<rsub|i><around|(|\<omega\>|)>>|<cell|=<big|sum><rsub|m=<around|\<lceil\>|<around|(|\<omega\>-\<pi\><mwcW>|)>/\<omega\><rsub|p>|\<rceil\>>+1><rsup|<around|\<lfloor\>|<around|(|\<omega\>+\<pi\><mwcW>|)>/\<omega\><rsub|p>|\<rfloor\>>>P<rsub|i><around|(|m|)>*X*<around|(|\<omega\>-m*\<omega\><rsub|p>|)>*H<around|(|\<omega\>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|m=-<around|\<lfloor\>|<frac|1|2*\<omega\><rsub|p>>*<around|(|\<omega\><rsub|s>+2*\<pi\><mwcW>|)>|\<rfloor\>>+1><rsup|<around|\<lfloor\>|<frac|1|2*\<omega\><rsub|p>>*<around|(|\<omega\><rsub|s>+2*\<pi\><mwcW>|)>|\<rfloor\>>>P<rsub|i><around|(|m|)>*X*<around|(|\<omega\>-m*\<omega\><rsub|p>|)><rect|2*\<omega\>/\<omega\><rsub|s>><label|equ:mwc>>>>>>

  where <math|H<around|(|\<omega\>|)>=<rect|2*\<omega\>/\<omega\><rsub|s>>>
  is the transfer function of an ideal low-pass filter with cut-off frequency
  <math|\<omega\><rsub|s>/2>, <math|\<omega\><rsub|s>=2*\<pi\><mwcW>/<mwcM>>.
  Note that the low pass filter windows <math|X<around|(|\<omega\>|)>> and
  its translates (i.e., restricts them to the interval
  <math|[-\<omega\><rsub|s>/2,\<omega\><rsub|s>/2]>) and hence removes the
  dependence on <math|\<omega\>> in the summation limits.

  <vspace|7pt><no-indent><with|font-series|bold|Sampling/Aliasing:>

  <align|<tformat|<table|<row|<cell|>|<cell|y<rsub|i><around|(|k|)>=g<rsub|i>*<around|(|k*T<rsub|s>|)><no-number>>>|<row|<cell|>|<cell|\<updownarrow\><space|7pt><text|<with|font-size|0.71|DTFT>>;\<omega\><rsub|s>*<space|7pt><no-number>>>|<row|<cell|>|<cell|Y<rsub|i><around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcW>>>|)>=<frac|<mwcW>|<mwcM>>*<big|sum><rsub|n=-\<infty\>><rsup|\<infty\>>G<rsub|i>*<around|(|\<omega\>+n*\<omega\><rsub|s>|)><label|equ:mwc>>>|<row|<cell|>|<cell|<space|2em><space|2em>=<frac|<mwcW>|<mwcM>>*<big|sum><rsub|n=-\<infty\>><rsup|\<infty\>><big|sum><rsub|m=-<around|\<lfloor\>|<frac|<mwcL>|2<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>+1><rsup|<around|\<lfloor\>|<frac|<mwcL>|2<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>>P<rsub|i><around|(|m|)>*X*<around|(|\<omega\>-m*\<omega\><rsub|p>+n*\<omega\><rsub|s>|)><rect|2*<around|(|\<omega\>+n*\<omega\><rsub|s>|)>/\<omega\><rsub|s>><label|equ:mwc>>>>>>

  where<nbsp><eqref|equ:mwc<rsub|d>> results from
  substituting<nbsp><eqref|equ:mwc<rsub|b>> into<nbsp><eqref|equ:mwc<rsub|f>>
  and the summation limits were rewritten using the definition of
  <math|\<omega\><rsub|p>> and <math|\<omega\><rsub|s>>. Because
  <math|Y<rsub|i><around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcW>>>|)>> is
  periodic with period <math|\<omega\><rsub|s>=2*\<pi\><mwcW>/<mwcM>>, we
  can, without loss of information, restrict
  <math|Y<rsub|i><around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcW>>>|)>> to
  one period. This means we need only consider one term in the summation over
  <math|n> in<nbsp><eqref|equ:mwc<rsub|d>>. We choose to retain the
  <math|n=0> term and thus have the DTFT pair

  <align*|<tformat|<table|<row|<cell|Y<rsub|i><around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcW>>>|)><indicator|[-<frac|\<pi\><mwcW>|<mwcM>>,<frac|\<pi\><mwcW>|<mwcM>>)>=<frac|<mwcW>|<mwcM>>*<big|sum><rsub|m=-<around|\<lfloor\>|<frac|<mwcL>|2<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>+1><rsup|<around|\<lfloor\>|<frac|<mwcL>|2<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>>P<rsub|i><around|(|m|)>*X*<around|(|\<omega\>-m*\<omega\><rsub|p>|)><rect|2*\<omega\>/\<omega\><rsub|s>>,>>>>>

  where again, <math|<indicator|<around|[|\<cdummy\>|)>>> denotes the
  indicator function. The Fourier series coefficients of
  <math|p<rsub|i><around|(|t|)>> can now be directly computed,

  <align*|<tformat|<table|<row|<cell|P<rsub|i><around|(|m|)>>|<cell|=<frac|1|T<rsub|P>>*<big|int><rsub|0><rsup|T<rsub|p>>p<rsub|i><around|(|t|)><nbsp>e<rsup|-j*<frac|2*\<pi\>|T<rsub|p>>*m*t><nbsp>d*t>>|<row|<cell|>|<cell|=<frac|1|T<rsub|P>>*<big|sum><rsub|l=0><rsup|<mwcL>-1><big|int><rsub|l*<frac|T<rsub|p>|<mwcL>>><rsup|<around|(|l+1|)>*<frac|T<rsub|p>|<mwcL>>>p<rsub|i*l><nbsp>e<rsup|-j*<frac|2*\<pi\>|T<rsub|p>>*m*t><nbsp>d*t>>|<row|<cell|>|<cell|=<choice|<tformat|<table|<row|<cell|<big|sum><rsub|l=0><rsup|<mwcL>-1><frac|p<rsub|i*l>|j*2*\<pi\>*m>*<around*|(|1-e<rsup|-j*<frac|2*\<pi\>|<mwcL>>*m>|)>*e<rsup|-j*<frac|2*\<pi\>|<mwcL>>*m*l>,>|<cell|m\<neq\>0>>|<row|<cell|<tfrac|1|<mwcL>><big|sum><rsub|l=0><rsup|<mwcL>-1>p<rsub|i*l>,>|<cell|m=0,>>>>>>>>>>

  where <math|p<rsub|i*l>=p<rsub|i><around|(|t|)>> for
  <math|t\<in\><around|[|l*T<rsub|p>/<mwcL>,<around|(|l+1|)>*T<rsub|p>/<mwcL>|)>>,
  to obtain

  <\equation*>
    Y<rsub|i><around|(|e<rsup|j*\<omega\>*<frac|<mwcM>|<mwcW>>>|)><indicator|[-<frac|\<pi\><mwcW>|<mwcM>>,<frac|\<pi\><mwcW>|<mwcM>>)>=<frac|<mwcW>|<mwcM>>*<big|sum><rsub|m=-<around|\<lfloor\>|<frac|<mwcL>|2<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>+1><rsup|<around|\<lfloor\>|<frac|<mwcL>|2<mwcM>>*<around|(|<mwcM>+1|)>|\<rfloor\>>><big|sum><rsub|l=0><rsup|<mwcL>-1>p<rsub|i*l>*<frac|1-e<rsup|-j*<frac|2*\<pi\>|<mwcL>>*m>|j*2*\<pi\>*m>*e<rsup|-j*<frac|2*\<pi\>|<mwcL>>*m*l><rect|<tfrac|<mwcM>|\<pi\><mwcW>>\<omega\>>X*<around|(|\<omega\>-m<tfrac|2*\<pi\><mwcW>|<mwcL>>|)>,
  </equation*>

  for <math|i=0,\<ldots\>,<mwcq>-1>, where this expression should be
  understood to be consistent with the expression for
  <math|P<rsub|i><around|(|0|)>> given above.

  We can express these <math|<mwcq>> linear equations in matrix form

  <\equation>
    <label|equ:mwc><B|y><around|(|\<omega\>|)>=<B|\<Phi\>><B|\<Psi\>><B|s><around|(|\<omega\>|)>
  </equation>

  where <math|<B|y><around|(|\<omega\>|)>,<B|\<Phi\>>,<B|\<Psi\>>>, and
  <math|<B|s><around|(|\<omega\>|)>> are as
  in<nbsp><eqref|equ:mwc<rsub|m>atrixform>.

  <\thebibliography|10>
    <bibitem|donoho2006>D.<nbsp>Donoho, <newblock>\PCompressed sensing,\Q
    <newblock><with|font-shape|italic|IEEE Trans. Info. Th.>, vol. 52, no. 4,
    pp. 1289\U1306, Apr 2006.

    <bibitem|candes2006>E.J. Candes, <newblock>\PCompressive sampling,\Q
    <newblock>in <with|font-shape|italic|Proc.<space|0.17em>Int.
    <space|0.17em> Congr. <space|0.17em> Math.>, 2006, vol.<nbsp>3, pp.
    1433\U1452.

    <bibitem|candes_wakin2008>E.J. Candes and M.B. Wakin, <newblock>\PAn
    introduction to compressive sampling,\Q
    <newblock><with|font-shape|italic|IEEE Signal Processing Mag.>, vol. 25,
    no. 2, pp. 21\U30, Mar 2008.

    <bibitem|candes_romberg_tao2006>E.<nbsp>Candes, J.<nbsp>Romberg, and
    T.<nbsp>Tao, <newblock>\PRobust uncertainty principles: Exact signal
    reconstruction from highly incomplete frequency information,\Q
    <newblock><with|font-shape|italic|IEEE Trans. Info. Th.>, vol. 52, no. 2,
    pp. 489\U509, Feb 2006.

    <bibitem|tropp2007>J.<nbsp>Tropp, <newblock>\PSignal recovery from random
    measurements via orthogonal matching pursuit,\Q
    <newblock><with|font-shape|italic|IEEE Trans. Info. Th.>, vol. 53, no.
    12, pp. 4655\U4666, Dec 2007.

    <bibitem|baraniuk_etal2010>R.G. Baraniuk, V.<nbsp>Cevher, M.F. Duarte,
    and C.<nbsp>Hegde, <newblock>\PModel-based compressive sensing,\Q
    <newblock><with|font-shape|italic|Information Theory, IEEE Transactions
    on>, vol. 56, no. 4, pp. 1982 \U2001, Apr. 2010.

    <bibitem|eldar2009>Y.C. Eldar, <newblock>\PCompressed sensing of analog
    signals in shift-invariant spaces,\Q <newblock><with|font-shape|italic|Signal
    Processing, IEEE Transactions on>, vol. 57, no. 8, pp. 2986 \U2997, Aug.
    2009.

    <bibitem|lu_do2008>Y.M. Lu and M.N. Do, <newblock>\PA theory for sampling
    signals from a union of subspaces,\Q <newblock><with|font-shape|italic|Information
    Theory, IEEE Transactions on>, vol. 56, no. 6, pp. 2334\U2345, Jun. 2008.

    <bibitem|romberg2009>Justin Romberg, <newblock>\PCompressive sensing by
    random convolution,\Q <newblock><with|font-shape|italic|SIAM J. Imaging
    Sciences>, vol. 2, no. 4, pp. 1098\U1128, 2009.

    <bibitem|tropp_etal2010>J.A. Tropp, J.N. Laska, M.F. Duarte, J.K.
    Romberg, and R.G. Baraniuk, <newblock>\PBeyond Nyquist: Efficient
    sampling of sparse bandlimited signals,\Q
    <newblock><with|font-shape|italic|IEEE Trans. Info. Th.>, vol. 56, no. 1,
    pp. 520\U544, Jan 2010.

    <bibitem|mishali_eldar2010>M.<nbsp>Mishali and Y.C. Eldar,
    <newblock>\PFrom theory to practice: Sub-nyquist sampling of sparse
    wideband analog signals,\Q <newblock><with|font-shape|italic|Selected
    Topics in Signal Processing, IEEE Journal of>, vol. 4, no. 2, pp. 375
    \U391, Apr 2010.

    <bibitem|duarte_etal2008>Marco Duarte, Mark Davenport, Dharmpal Takhar,
    Jason Laska, Ting Sun, Kevin Kelly, and Richard Baraniuk,
    <newblock>\PSingle-pixel imaging via compressive sampling,\Q
    <newblock><with|font-shape|italic|IEEE Signal Processing Mag.>, vol. 25,
    no. 2, pp. 83\U91, Mar 2008.

    <bibitem|tropp_wakin_etal2006>J.A. Tropp, M.B. Wakin, M.F. Duarte,
    D.<nbsp>Baron, and R.G. Baranuik, <newblock>\PRandom filters for
    compressive sampling and reconstruction,\Q
    <newblock><with|font-shape|italic|Proc. IEEE International Conf. on
    Acoustics, Speech, and Signal Processing>, pp. 872\U875, 2006.

    <bibitem|kirolos_etal2006>S.<nbsp>Kirolos, J.<nbsp>Laska, ,
    M.<nbsp>Wakin, M.<nbsp>Duarte, D.<nbsp>Baron, , T.<nbsp>Ragheb,
    Y.<nbsp>Massoud, and R.<nbsp>Baraniuk, <newblock>\PAnalog to information
    conversion using random demodulation,\Q
    <newblock><with|font-shape|italic|Proc. 2006 IEEE Dallas/CAS Workshop on
    Design, Applications, Integration and Software>, pp. 71\U74, Oct. 2006.

    <bibitem|laska_etal2007>J.<nbsp>Laska, S.<nbsp>Kirolos, M.<nbsp>Duarte,
    T.<nbsp>Ragheb, R.<nbsp>Baraniuk, and Y.<nbsp>Massoud, <newblock>\PTheory
    and implementation of an analog-to-information converter using random
    demodulation,\Q <newblock><with|font-shape|italic|Proc. IEEE Int. Symp.
    Circuits and Systems (ISCAS)>, pp. 1959\U1962, May 2007.

    <bibitem|mishali_eldar_dcc2010>M.<nbsp>Mishali and Y.C. Eldar,
    <newblock>\PXampling: Analog data compression,\Q <newblock>in
    <with|font-shape|italic|Data Compression Conference (DCC), 2010>, Mar.
    2010, pp. 366 \U375.

    <bibitem|chen_etal2010>Yilun Chen, Moshe Mishali, Yonina<nbsp>C. Eldar,
    and Alfred<nbsp>O. Hero, <newblock>\PModulated wideband converter with
    non-ideal lowpass filters,\Q <newblock>in
    <with|font-shape|italic|Acoustics Speech and Signal Processing (ICASSP),
    2010 IEEE International Conference on>, Mar. 2010, pp. 3630 \U3633.

    <bibitem|mishali_elron_eldar_icassp2010>M.<nbsp>Mishali, A.<nbsp>Elron,
    and Y.C. Eldar, <newblock>\PSub-Nyquist processing with the modulated
    wideband converter,\Q <newblock>in <with|font-shape|italic|Acoustics
    Speech and Signal Processing (ICASSP), 2010 IEEE International Conference
    on>, Mar. 2010, pp. 3626 \U3629.

    <bibitem|unser2000>M.<nbsp>Unser, <newblock>\PSampling-50 years after
    Shannon,\Q <newblock><with|font-shape|italic|Proceedings of the IEEE>,
    vol. 88, no. 4, pp. 569 \U587, Apr. 2000.

    <bibitem|bresler2008>Y.<nbsp>Bresler, <newblock>\PSpectrum-blind sampling
    and compressive sensing for continuous-index signals,\Q
    <newblock><with|font-shape|italic|IEEE Info. Th. and Appl. Workshop>, pp.
    547\U554, Jan 2008.

    <bibitem|y_chi_etal_icassp2010>Yuejie Chi, A.<nbsp>Pezeshki,
    L.<nbsp>Scharf, and R.<nbsp>Calderbank, <newblock>\PSensitivity to basis
    mismatch in compressed sensing,\Q <newblock>in
    <with|font-shape|italic|Acoustics Speech and Signal Processing (ICASSP),
    2010 IEEE International Conference on>, Mar. 2010, pp. 3930 \U3933.

    <bibitem|duarte_baraniuk2010>M.<nbsp>Duarte and R.<nbsp>Baraniuk,
    <newblock>\PSpectral compressive sensing,\Q [Online]. Available:
    dsp.rice.edu/cs, Preprint<nbsp>2010.

    <bibitem|blumensath_davies2008>T.<nbsp>Blumensath and M.<nbsp>Davies,
    <newblock>\PInterative thresholding for sparse approximations,\Q
    <newblock><with|font-shape|italic|Jour. of Fourier Anal. and App.>, vol.
    14, no. 5, pp. 629\U654, 2008.

    <bibitem|blumensath_davies2009>T.<nbsp>Blumensath and M.<nbsp>Davies,
    <newblock>\PInterative hard thresholding for compressed sensing,\Q
    <newblock><with|font-shape|italic|Appl. Comput. Harmon. Anal.>, vol. 27,
    no. 3, pp. 265\U274, 2009.

    <bibitem|mallat1999>Stephane Mallat, <newblock><with|font-shape|italic|A
    Wavelet Tour of Signal Processing>, <newblock>Academic Press, 2 edition,
    1999.

    <bibitem|pingfeng_phdthesis1997>Ping Feng,
    <newblock><with|font-shape|italic|Universal Minimum-Rate Sampling and
    Spectrum-Blind Reconstruction for Multiband Signals>, <newblock>Ph.D.,
    University of Illinois at Urbana-Champaign, Urbana-Champaign, IL U.S.A.,
    1997.

    <bibitem|stojnic_etal2009>M.<nbsp>Stojnic, F.<nbsp>Parvaresh, and
    B.<nbsp>Hassibi, <newblock>\POn the reconstruction of block-sparse
    signals with an optimal number of measurements,\Q
    <newblock><with|font-shape|italic|Signal Processing, IEEE Transactions
    on>, vol. 57, no. 8, pp. 3075 \U3085, Aug. 2009.

    <bibitem|eldar_etal2010>Y.C. Eldar, P.<nbsp>Kuppinger, and
    H.<nbsp>Bolcskei, <newblock>\PBlock-sparse signals: Uncertainty relations
    and efficient recovery,\Q <newblock><with|font-shape|italic|Signal
    Processing, IEEE Transactions on>, vol. 58, no. 6, pp. 3042 \U3054, Jun
    2010.

    <bibitem|mishali_eldar2008>M.<nbsp>Mishali and Y.C. Eldar,
    <newblock>\PReduce and boost: Recovering arbitrary sets of jointly sparse
    vectors,\Q <newblock><with|font-shape|italic|IEEE Trans. Signal
    Processing>, vol. 56, no. 10, pp. 4652\U4702, Oct 2008.

    <bibitem|cotter_etal2005>S.F. Cotter, B.D. Rao, Kjersti Engan, and
    K.<nbsp>Kreutz-Delgado, <newblock>\PSparse solutions to linear inverse
    problems with multiple measurement vectors,\Q
    <newblock><with|font-shape|italic|Signal Processing, IEEE Transactions
    on>, vol. 53, no. 7, pp. 2477 \U 2488, Jul. 2005.

    <bibitem|chen_huo2006>Jie Chen and Xiaoming Huo, <newblock>\PTheoretical
    results on sparse representations of multiple-measurement vectors,\Q
    <newblock><with|font-shape|italic|Signal Processing, IEEE Transactions
    on>, vol. 54, no. 12, pp. 4634 \U4643, Dec 2006.

    <bibitem|davies_eldar2010>M.<nbsp>Davies and Y.C. Eldar, <newblock>\PRank
    awareness in joint sparse recovery,\Q [Online]. Available:
    arXiv:1004:4529v1 [cs.IT], Apr 2010.

    <bibitem|roberts_mullisDSP>Richard Roberts and Clifford Mullis,
    <newblock><with|font-shape|italic|Digital Signal Processing>,
    <newblock>Addison-Wesley Publishing Co., Inc., 1987.

    <bibitem|landau1967>H.J. Landau, <newblock>\PNecessary density conditions
    for sampling and interpolation of certain entire functions,\Q
    <newblock><with|font-shape|italic|Acta Math.>, vol. 117, no. 1, pp.
    37\U52, 1967.

    <bibitem|greedy_pursuit_tropp_etal2006>J.A. Tropp, A.C. Gilbert, and M.J.
    Strauss, <newblock>\PAlgorithms for simultaneous sparse approximation.
    Part I: Greedy pursuit,\Q <newblock><with|font-shape|italic|Signal
    Processing>, vol. 86, no. 3, pp. 572\U588, 2006.

    <bibitem|convex_relax_tropp_etal2006>J.A. Tropp, A.C. Gilbert, and M.J.
    Strauss, <newblock>\PAlgorithms for simultaneous sparse approximation.
    Part II: Convex relaxation,\Q <newblock><with|font-shape|italic|Signal
    Processing>, vol. 86, no. 3, pp. 589\U602, 2006.

    <bibitem|wavelab>\PWavelab 850: Wavelet analysis toolbox maintained at
    Stanford University,\Q [Online]. Available:
    <slink|www-stat.stanford.edu/><math|\<sim\>><slink|wavelab>.
  </thebibliography>
</body>