<TeXmacs|1.99.7>

<style|<tuple|ieeetran|std-latex>>

<\body>
  <\hide-preamble>
    <assign|be|<macro|>>

    <assign|ee|<macro|>>

    <assign|bea|<macro|>>

    <assign|eea|<macro|>>

    <new-theorem|thm|Theorem>

    <new-theorem|lem|Lemma>

    <new-theorem|pro|Proposition>

    <new-theorem|corollary|Corollary>

    <new-theorem|defi|Definition>

    <new-theorem|cons|Construction>

    <new-theorem|rem|Remark>

    <new-theorem|Exa|Example>
  </hide-preamble>

  <doc-data|<doc-title|Remarks on the Restricted Isometry Property in
  Orthogonal Matching Pursuit algorithm>|<doc-author|<author-data|<author-name|Qun
  Mo>>>|<doc-author|<author-data|<author-misc|Research supported in part by
  the NSF of China under grant 10971189, the China Postdoctoral Science
  Foundation under grant 20100481430, the Doctoral Program Foundation of
  Ministry of Education of China under grant 20070335176 and Science
  Foundation of Chinese University under grant 2010QNA3018.>|<author-misc|Q.
  Mo is with the Department of Mathematics, Zhejiang University, Hangzhou,
  310027, China (e-mail: moqun@zju.edu.cn ).>|<author-misc|Y. Shen is the
  corresponding author. He is with the Department of Mathematics, Zhejiang
  University, Hangzhou, 310027, China (e-mail:
  sy1133@zju.edu.cn).>|<author-name|Yi Shen>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    This paper demonstrates theoretically that if the restricted isometry
    constant <math|\<delta\><rsub|K>> of the compressed sensing matrix
    satisfies

    <\equation*>
      \<delta\><rsub|K+1>\<less\><frac|1|<sqrt|K>+1>,
    </equation*>

    then a greedy algorithm called Orthogonal Matching Pursuit (OMP) can
    recover a signal with <math|K> nonzero entries in <math|K> iterations. In
    contrast, matrices are also constructed with restricted isometry constant

    <\equation*>
      \<delta\><rsub|K+1>=<frac|1|<sqrt|K>>
    </equation*>

    such that OMP can not recover <math|K>-sparse <math|x> in <math|K>
    iterations. This result shows that the conjecture given by Dai and
    Milenkovic is ture.
  </abstract>|<abstract-keywords| compressed sensing| restricted isometry
  property| orthogonal matching pursuit| sparse signal reconstruction.>>

  <IEEEpeerreviewmaketitle>

  <section|Introduction>

  Compressive sensing is a new type of sampling theory, that predicts that
  sparse signals and images can be reconstructed from what was previously
  believed to be incomplete information <cite|CT>. The key idea is that the
  sparsity helps in isolating the original vector. Let
  <math|x\<in\><math-bf|R><rsup|n>> be a signal, we want to recover it from a
  linear measurement

  <\equation>
    <label|axy>A*x=y,
  </equation>

  where <math|A> is a given <math|m\<times\>n> matrix with <math|m\<less\>n>.
  In general, the solution of (<reference|axy>) is not unique. To recover
  <math|x> uniquely, some additional assumptions on <math|x> and <math|A> are
  necessary. We are concerned with the case that <math|x> is sparse. That is
  <math|<around|\<\|\|\>|x|\<\|\|\>><rsub|0>\<ll\>n>, where
  <math|<around|\<\|\|\>|x|\<\|\|\>><rsub|0>> is the number of nonzero
  entries of <math|x>. We say that a vector <math|x> is <math|K>-sparse when
  <math|<around|\<\|\|\>|x|\<\|\|\>><rsub|0>\<leq\>K>. The natural choice is
  seeking a sparse solution of the <math|l<rsub|0>> problem

  <\equation>
    <label|p0>min<rsub|x><around|\<\|\|\>|x|\<\|\|\>><rsub|0>,<space|1em>s.*t.*<space|1em>A*x=y
  </equation>

  where <math|A> and <math|y> are known. To make sure the <math|K>-sparse
  solution is unique, we would like to using the the <em|restricted isometry
  property> (RIP) which was introduced by Cands and Tao in <cite|CT>. A
  matrix <math|A> satisfies the RIP of order <math|K> with <em|restricted
  isometry constant> <math|\<delta\><rsub|K>> if <math|\<delta\><rsub|K>> is
  the smallest constant such that

  <\equation>
    <label|RIP><around|(|1-\<delta\><rsub|K>|)><around|\<\|\|\>|x|\<\|\|\>><rsub|2><rsup|2>\<leq\><around|\<\|\|\>|A*x|\<\|\|\>><rsub|2><rsup|2>\<leq\><around|(|1+\<delta\><rsub|K>|)><around|\<\|\|\>|x|\<\|\|\>><rsub|2><rsup|2>
  </equation>

  holds for all <math|K>-sparse signal <math|x>. If
  <math|\<delta\><rsub|2*K>\<less\>1>, the <math|l<rsub|0>> problem has a
  unique <math|K>-sparse solution <cite|C>.

  OMP is an effective greedy algorithm for seeking the solution of the
  <math|l<rsub|0>> problem. Basic reference for this method in the signal
  processing literature are <cite|DMA|PRK>. The iterative formula below
  supplies the framework of OMP.

  <\center>
    <\itemize>
      <item*|><with|font-series|bold|Input>: <math|A>, <math|y>

      <item*|><with|font-series|bold|Set>:
      <math|\<Omega\><rsub|0>=\<emptyset\>>, <math|r<rsub|0>=y>, <math|k=1>;

      <item*|><with|font-series|bold|while not converge>

      <\itemize>
        <item><math|\<Omega\><rsub|k>=\<Omega\><rsub|k-1>\<cup\>arg
        max<rsub|i><around|\||<around|\<langle\>|r<rsub|k-1>,A<rsub|i>|\<rangle\>>|\|>>

        <item><math|x<rsub|k>=arg min<rsub|z><around|\<\|\|\>|A<rsub|\<Omega\><rsub|k>>*z-y|\<\|\|\>><rsub|2>>

        <item><math|r<rsub|k>=y-A<rsub|\<Omega\><rsub|k>>*x<rsub|k>>

        <item><math|k=k+1>
      </itemize>

      <item*|><with|font-series|bold|end while>

      <item*|><math|<wide|x|^><rsub|\<Omega\><rsub|k>>=x<rsub|k>>,
      <math|<wide|x|^><rsub|\<Omega\><rsub|k><rsup|C>>=0>

      <item*|><with|font-series|bold|Return> <math|<wide|x|^>>.
    </itemize>
  </center>

  There are several natural stopping criteria for the OMP <cite|T>. In this
  paper, we investigate conditions under which the OMP can reconstruct the
  <math|K>-sparse signals in <math|K> iteration successfully or not. There
  are several results on this subject. For example, Davenport and Wakin have
  proved that <math|\<delta\><rsub|K+1>\<less\><frac|1|3*<sqrt|K>>> is a
  sufficient condition for the successful reconstruction <cite|DW>. Later,
  Liu and Temlyakov have improved the condition to
  <math|\<delta\><rsub|K+1>\<less\><frac|1|<around|(|1+<sqrt|2>|)>*<sqrt|K>>>
  <cite|LT>. An interesting open question raised by Liu and Temlyakov is: can
  we increase the constant <math|1/<around|(|1+<sqrt|2>|)>> to <math|1> ? In
  contrast, Dai and Milenkovic conjectured that there exists a matrix
  satisfying the RIP of order <math|K+1> with
  <math|\<delta\><rsub|K+1>\<leq\>1/<sqrt|K>> for which there exists a
  <math|K>-sparse signal <math|x\<in\><math-bf|R><rsup|n>> that cannot be
  recovered exactly via <math|K> iterations of OMP <cite|DM>. This conjecture
  has been confirmed via experiments in <cite|DW> for the case <math|K=2>.
  The contribution of this paper are twofold.

  <\itemize>
    <item>Improve the sufficient condition for the successful recovered for
    OMP. If

    <\equation*>
      \<delta\><rsub|K+1>\<leq\><frac|1|<sqrt|K>+1>,
    </equation*>

    then for all <math|K>-sparse <math|x>, Orthogonal Matching Pursuit will
    recover <math|x> exactly from <math|y=A*x> in <math|K> iterations.

    <item>Give the positive answer to the conjecture in <cite|DM>. For any
    given <math|K\<geq\>2>, we construct matrix with

    <\equation*>
      \<delta\><rsub|K+1>=<frac|1|<sqrt|K>>
    </equation*>

    where OMP will fail for at least one <math|K>-parse signal.
  </itemize>

  <section|PRELIMINARIES><label|section1>

  Before going further, we introduce some new notations. For the given
  <math|K>-sparse signal <math|x> and matrix <math|A>, we define

  <\equation*>
    S<rsub|k>\<assign\><around|\<langle\>|A*e<rsub|k>,A*x|\<rangle\>>,<space|1em>k=1,\<ldots\>,n.
  </equation*>

  Denote <math|S<rsub|0>\<assign\>max<rsub|k\<in\><around|{|1,\<ldots\>,K|}>><around|\||S<rsub|k>|\|>>.
  The following lemma is useful in our analysis.

  <\lem>
    <label|lem2>For the given <math|K>-sparse signal <math|x> with the
    support on <math|<around|{|1,\<ldots\>,K|}>>, if the restrict isometry
    constant <math|\<delta\><rsub|K+1>> of a matrix <math|A> satisfies

    <\equation>
      <label|delta>\<delta\><rsub|K+1>\<less\><frac|1|<sqrt|K>+1>,
    </equation>

    then <math|S<rsub|0>\<gtr\><around|\||S<rsub|k>|\|>> for
    <math|k\<gtr\>K>.
  </lem>

  <\proof>
    By Lemma 2.1 in <cite|C>, we have

    <\equation>
      <label|eq1><around|\||S<rsub|k>|\|>=<around|\||<around|\<langle\>|A*e<rsub|k>,A*x|\<rangle\>>|\|>\<leq\>\<delta\><rsub|K+1><around|\<\|\|\>|x|\<\|\|\>><rsub|2>,<space|1em>\<forall\>k\<gtr\>K.
    </equation>

    Furthermore, for the given <math|K>-sparse <math|x>, we have

    <eqnarray*|<tformat|<table|<row|<cell|<around|\<langle\>|A*x,A*x|\<rangle\>>>|<cell|=>|<cell|<around*|\<langle\>|A*<big|sum><rsub|k=1><rsup|K>x<rsub|k>*e<rsub|k>,A*x|\<rangle\>>>>|<row|<cell|>|<cell|=>|<cell|<big|sum><rsub|k=1><rsup|K>x<rsub|k>*<around|\<langle\>|A*e<rsub|k>,A*x|\<rangle\>>>>|<row|<cell|>|<cell|=>|<cell|<big|sum><rsub|k=1><rsup|K>x<rsub|k>*S<rsub|k>.>>>>>

    From the definition of RIP, we have

    <eqnarray*|<tformat|<table|<row|<cell|<around|(|1-\<delta\><rsub|K+1>|)><around|\<\|\|\>|x|\<\|\|\>><rsub|2><rsup|2>>|<cell|\<leq\>>|<cell|<around|\<langle\>|A*x,A*x|\<rangle\>>>>|<row|<cell|>|<cell|=>|<cell|<big|sum><rsub|k=1><rsup|K>x<rsub|k>*S<rsub|k>>>|<row|<cell|>|<cell|\<leq\>>|<cell|S<rsub|0><around|\<\|\|\>|x|\<\|\|\>><rsub|1>.>>|<row|<cell|>|<cell|\<leq\>>|<cell|S<rsub|0>*<sqrt|K><around|\<\|\|\>|x|\<\|\|\>><rsub|2>.>>>>>

    This implies that

    <\equation>
      <label|eq2><frac|<around|(|1-\<delta\><rsub|K+1>|)><around|\<\|\|\>|x|\<\|\|\>><rsub|2>|<sqrt|K>>\<leq\>S<rsub|0>.
    </equation>

    Combining (<reference|eq1>) and (<reference|eq2>), we conclude that the
    lemma holds.
  </proof>

  <section|Main Results>

  This section establishes the main result of this paper.

  <\thm>
    <label|thm1>Suppose that <math|A> satisfies the RIP of order <math|K>
    with the restricted isometry constant

    <\equation>
      <label|key>\<delta\><rsub|K+1>\<less\><frac|1|<sqrt|K>+1>.
    </equation>

    Then for all <math|K>-sparse <math|x>, OMP can recover <math|x> exactly
    from <math|y=A*x> in <math|K> iterations.
  </thm>

  <\proof>
    Without loss of generality, we assume that the support of the given
    signal <math|x> is <math|<around|{|1,2,\<ldots\>,K|}>>. Now we can see
    that the sufficient condition for the OMP choosing the index in
    <math|<around|{|1,\<ldots\>,K|}>> at first step is

    <\equation*>
      S<rsub|0>\<gtr\><around|\||S<rsub|k>|\|>,<space|1em>\<forall\>k\<gtr\>K.
    </equation*>

    By Lemma <reference|lem2>, the first step of OMP is successful. Since the
    OMP make an orthogonal projection at each iteration, it can be proved by
    induction that the OMP chooses the right index at each step if
    (<reference|key>) holds.
  </proof>

  <\thm>
    <label|thm2>For any given positive integer <math|K\<geq\>2>, there exist
    a <math|K>-sparse signal <math|x> and a matrix <math|A> with the
    restricted isometry constant

    <\equation*>
      \<delta\><rsub|K+1>=<frac|1|<sqrt|K>>
    </equation*>

    for which OMP can fail in <math|K> iterations.
  </thm>

  <\proof>
    For any given positive integer <math|K\<geq\>2>, let

    <\equation*>
      x=<around|(|1,1,\<ldots\>,1,0|)><rsup|T>\<in\><math-bf|R><rsup|K+1>.
    </equation*>

    Let

    <\equation*>
      A=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|0ln>|<table|<row|<cell|>|<cell|>|<cell|>|<cell|<frac|1|K>>>|<row|<cell|>|<cell|I<rsub|K>>|<cell|>|<cell|\<vdots\>>>|<row|<cell|>|<cell|>|<cell|>|<cell|<frac|1|K>>>|<row|<cell|0>|<cell|\<ldots\>>|<cell|0>|<cell|<sqrt|<tfrac|K-1|K>>>>>>>|)><rsub|<around|(|K+1|)>\<times\><around|(|K+1|)>>.
    </equation*>

    It is easy to see that the eigenvalues
    <math|<around|{|\<lambda\><rsub|k>|}><rsub|k=1><rsup|K+1>> of <math|A>
    are

    <\equation*>
      \<lambda\><rsub|k>=1,<space|1em>k=1,\<ldots\>,K-1,
    </equation*>

    and

    <\equation*>
      \<lambda\><rsub|K>=<sqrt|1-<tfrac|1|<sqrt|K>>>,<space|1em>\<lambda\><rsub|K+1>=<sqrt|1+<tfrac|1|<sqrt|K>>>.
    </equation*>

    Therefore, the restricted isometry constant <math|\<delta\><rsub|K+1>> of
    <math|A> is equal to <math|<tfrac|1|<sqrt|K>>>. By simple calculation, we
    have

    <\equation*>
      A<rsup|T>*A=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|0ln>|<table|<row|<cell|>|<cell|>|<cell|>|<cell|<frac|1|K>>>|<row|<cell|>|<cell|I<rsub|K>>|<cell|>|<cell|\<vdots\>>>|<row|<cell|>|<cell|>|<cell|>|<cell|<frac|1|K>>>|<row|<cell|<frac|1|K>>|<cell|\<ldots\>>|<cell|<frac|1|K>>|<cell|1>>>>>|)><rsub|<around|(|K+1|)>\<times\><around|(|K+1|)>>.
    </equation*>

    It follows that

    <\equation*>
      S<rsub|k>=<around|\<langle\>|A*e<rsub|k>,A*x|\<rangle\>>=<around|\<langle\>|A<rsup|T>*A*e<rsub|k>,x|\<rangle\>>=1<space|1em>\<forall\>k\<in\><around|{|1,\<ldots\>,K+1|}>.
    </equation*>

    This implies that the OMP can fail at first iteration. Since <math|x> is
    <math|K>-sparse, in each step, we can only choose one index. We conclude
    that the OMP can fail in <math|K> iterations for the given matrix
    <math|A> and <math|x>.
  </proof>

  <\rem>
    Achieving very small values for the restricted isometry constant is a
    challenging task. Theorem <reference|thm2> shows the limitation of the
    OMP. Furthermore, if we select multiple columns per iteration, we can
    recover the <math|K>-sparse signal in <math|K> iterations. Actually, this
    technique has been widely used in many related greedy pursuit algorithms,
    such as CoSaMP <cite|NT> and StOMP <cite|DTDS>.
  </rem>

  <\thebibliography|20>
    <bibitem|C>E.J. Cands, The restricted isometry property and its
    implications for compressed sensing. Compte Rendus de l'Academie des
    Sciences, ser. I, 346:589-592, Paris.

    <bibitem|CT>E.J. Cands and T. Tao, Decoding by linear programming. IEEE
    Trans. Inf. Theory, 51 4203-4215, 2005.

    <bibitem|DM>W. Dai and O. Milenkovic, Subspace pursuit for compressive
    sensing signal reconstruction. IEEE Trans. on Info. Theory, 55(5)
    2230-2249, 2009.

    <bibitem|DMA>G. Davis, S. Mallat, and M. Avellaneda, Adaptive greedy
    approximation. J. Constr. Approx., 13 57-98, 1997.

    <bibitem|DW>M.A. Davenport and M.B. Wakin, Analysis of Orthogonal
    Matching Pursuit using the Restricted Isometry Property. IEEE Trans.
    Inform. Theory, 56(9) 4395-4401, 2010.

    <bibitem|D>D. Donoho, Compressed sensing. IEEE Trans. Inform. Theory,
    52(4) 1289-1306, 2006.

    <bibitem|DTDS>D. L. Donoho, Y. Tsaig, I. Drori, and J.-L. Starck,
    \<degree\> Sparse solution of underdetermined linear equations by
    stagewise Orthogonal Matching Pursuit (StOMP),\<pm\> Stanford Univ.,
    Palo Alto, Statistics Dept. Technical Report 2006-02, Mar. 2006.

    <bibitem|LT>E. Liu and V.N. Temlyakov, Orthogonal Super Greedy Algorithm
    and Applications in Compressed Sensing, 2010.
    http://dsp.rice.edu/sites/dsp.rice.edu/files/cs/LiuTemlyakov.pdf

    <bibitem|T>J. Tropp, Greed is good: Algorithmic results for sparse
    approximation. IEEE Trans. on Info. Theory, 50(10) 2231-2242, 2004.

    <bibitem|NT>D. Needell and J. A. Tropp, \<degree\>CoSaMP: Iterative
    signal recovery from incomplete and inaccurate samples,\<pm\> Appl.
    Comp. Harmonic Anal., 26(3) 301-321, 2009.

    <bibitem|PRK>Y. C. Pati, R. Rezaiifar, and P. S. Krishnaprasad,
    Orthogonal Matching Pursuit: Recursive function approximation with
    applications to wavelet decomposition. in Proc. 27th Ann. Asilomar Conf.
    on Signals, Systems and Computers, Nov. 1993.
  </thebibliography>

  <\IEEEbiography|Qun Mo>
    \ received the Ph.D. degree in mathematics from the University of
    Alberta, Canada, in 2003. His research interests include wavelet analysis
    and its applications, wavelet frames and compressed
  </IEEEbiography>

  <\IEEEbiography|Yi Shen>
    \ received the Ph.D. degree in mathematics from the Zhejiang University,
    China, in 2009. His research interests include wavelet analysis and its
    applications, wavelet frames and compressed
  </IEEEbiography>
</body>