<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|thm|Theorem>

    <new-theorem|lem|Lemma>

    <new-theorem|prop|Proposition>

    <new-theorem|cor|Corollary>

    <new-theorem|question|Question>

    <new-theorem|defn|Definition>

    <new-theorem|nota|Notation>

    <new-theorem|rem|Remark>

    <new-theorem|conjecture|Conjecture>

    <new-theorem|exmp|Example>

    <assign|N|<macro|<math-bf|N>>>

    <assign|Q|<macro|<math-bf|Q>>>

    <assign|R|<macro|<math-bf|R>>>

    <assign|Z|<macro|<math-bf|Z>>>

    <assign|P|<macro|<math-bf|P>>>

    <assign|C|<macro|<math-bf|C>>>

    <assign|L|<macro|\<cal-L\>>>

    <assign|O|<macro|\<cal-O\>>>

    <assign|M|<macro|\<cal-M\>>>

    <assign|H|<macro|\<cal-H\>>>

    <assign|E|<macro|\<cal-E\>>>

    <assign|A|<macro|<math-bf|A>>>

    <assign|F|<macro|<math-bf|F>>>

    <assign|isomto|<macro|<above|\<longrightarrow\>|\<sim\>>>>
  </hide-preamble>

  <doc-data|<doc-title|Evaluation Codes from smooth Quadric Surfaces and
  Twisted Segre Varieties>|<doc-author|<author-data|<author-misc|Universit
  Bordeaux I, Institut de Matmatiques de Bordeaux>|<author-misc|University
  of Illinois at Urbana-Champaign, Department of
  Mathematics>|<author-name|Alain Couvreur \ and Iwan Duursma>>>|<doc-date|>>

  <abstract-data|<\abstract>
    We give the parameters of any evaluation code on a smooth quadric
    surface. For hyperbolic quadrics the approach uses elementary results on
    product codes and the parameters of codes on elliptic quadrics are
    obtained by detecting a BCH structure of these codes and using the BCH
    bound. The elliptic quadric is a twist of the surface
    <math|<P><rsup|1>\<times\><P><rsup|1>> and we detect a similar BCH
    structure on twists of the Segre embedding of a product of any <math|d>
    copies of the projective line.
  </abstract>>

  <no-indent><with|font-series|bold|MSC:> 94B27, 11T71, 14G50, 94B15.

  <no-indent><with|font-series|bold|Keywords:> Evaluation codes, Algebraic
  Geometry codes, quadric surfaces, BCH codes, Segre embedding.

  <section*|Introduction>

  The parameters of evaluation codes on quadric surfaces have been studied by
  Aubry (who also considered higher dimensional quadrics) in <cite|aubry> and
  by Edoukou in <cite|fred2>. Most of the results on the topic concern the
  evaluation of forms of degree one or two. The reason of this restriction is
  that the estimate of the minimum distance of such codes by geometric
  methods becomes harder when the degree increases.

  In this article, we give the parameters of all evaluation codes on smooth
  quadric surfaces. The approach is not based on point counting but on the
  detection of a particular structure on the codes. Namely, we prove that
  codes on hyperbolic quadrics are tensor products of two extended
  Reed\USolomon codes and that codes on elliptic quadrics are extensions of
  some BCH codes studied by Pellikaan and the second author in
  <cite|DuursmaPellikaan>. A nice consequence of these results is that they
  solve a point counting problem which was not proved up to now. It should be
  underlined that usually, one tries to estimate the parameters of an
  Algebraic\UGeometry code by solving some equivalent geometric problem. In
  the present paper we proceed in the opposite direction, namely, we are able
  to solve open geometric problems using known coding theoretic results.

  Basically, studying codes on hyperbolic and elliptic quadrics reduces to
  study codes on <math|<P><rsup|1>\<times\><P><rsup|1>> and a twist of it.
  This approach has a natural generalization to products of <math|d\<geq\>2>
  copies of <math|<P><rsup|1>> yielding naturally tensor products of <math|d>
  extended Reed\USolomon codes and their twists yielding extended BCH codes
  of length <math|q<rsup|d>+1>. In particular, this construction gives a
  geometric realization of a large class of BCH codes as evaluation codes and
  without using a subfield subcode operation.

  The paper is organized as follows. The prerequisites on evaluation codes,
  twists and quadric surfaces are given in Section
  <reference|SecPrerequisites>. Evaluation codes on hyperbolic quadric
  surfaces are considered in Section <reference|SecHyper> and codes on
  elliptic quadrics are treated in Section <reference|SecEll>. The higher
  dimensional case is studied in Section <reference|SecHigher>.

  <section|Prerequisites><label|SecPrerequisites>

  <subsection|Evaluation codes>

  Let <math|X\<subset\><P><rsup|r>> be a smooth projective variety over
  <math|<F><rsub|q>>. Let <math|\<cal-F\><rsub|r>\<assign\><F><rsub|q><around|[|x<rsub|0>,\<ldots\>,x<rsub|r>|]>>
  be the graded coordinate ring of <math|<P><rsup|r>> and, for all integer
  <math|s>, denote by <math|\<cal-F\><rsub|r><around|(|s|)>> its subspace of
  homogeneous forms of degree <math|s>. Given
  <math|f\<in\>\<cal-F\><rsub|r><around|(|s|)>> and <math|P> a point of
  <math|<P><rsup|r>>, we define the <em|evaluation> of <math|f> at <math|P>
  as <math|f<around|(|P|)>\<assign\>f<around|(|p<rsub|0>,\<ldots\>,p<rsub|r>|)>>,
  where <math|<around|(|p<rsub|0>:\<ldots\>:p<rsub|r>|)>> is the system of
  homogeneous coordinates of <math|P> such that the first nonzero coordinate
  starting from the left is set to <math|1>, i.e. is of the form
  <math|<around|(|0:\<ldots\>:0:1:p<rsub|i>:\<ldots\>:p<rsub|r>|)>>.

  The evaluation code <math|C<rsub|X><around|(|s|)>> is defined as the image
  of the evaluation map

  <\equation*>
    e*v:<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|\<cal-F\><rsub|r><around|(|s|)>>|<cell|\<rightarrow\>>|<cell|<F><rsub|q><rsup|n>>>|<row|<cell|f>|<cell|\<mapsto\>>|<cell|<around|(|f<around|(|P<rsub|1>|)>,\<ldots\>,f<around|(|P<rsub|n>|)>|)>>>>>>|\<nobracket\>>,
  </equation*>

  where <math|P<rsub|1>,\<ldots\>,P<rsub|n>> are the
  <math|<F><rsub|q>>\Upoints of <math|X>. If we denote by
  <math|I<rsub|X><around|(|s|)>> the degree <math|s> part of the homogeneous
  ideal <math|I<rsub|X>\<subset\>\<cal-F\><rsub|r>> associated to <math|X>,
  then the above map <math|e*v> obviously factors as
  <math|e*v:\<cal-F\><rsub|r><around|(|s|)>/I<rsub|X><around|(|s|)>\<rightarrow\><F><rsub|q><rsup|n>>.

  The codes <math|C<rsub|X><around|(|s|)>> with <math|X=<P><rsup|r>> are the
  projective Reed-Muller codes <math|P*C<rsub|s><around|(|r,q|)>> and their
  parameters were obtained by Srensen <cite-detail|Sor91|Theorem 1>. In this
  paper we first consider the case that <math|X\<subset\><P><rsup|3>> is a
  smooth quadric. The case of a hyperbolic quadric corresponds to the Segre
  embedding of <math|<P><rsup|1>\<times\><P><rsup|1>> in <math|<P><rsup|3>>
  and the case of an elliptic quadric to a twist of such an embedding. We
  will then consider more generally the case that <math|X> is the Segre
  embedding of the product <math|<P><rsup|1>\<times\>\<cdots\>\<times\><P><rsup|1>\<hookrightarrow\><P><rsup|2<rsup|d>-1>>
  of <math|d> copies of the projective line, or a twist of such an embedding.

  <subsection|Twists>

  Given two varieties <math|X> and <math|Y> over a field <math|k>, one says
  that <math|Y> is a twist of <math|X> if the two varieties are not
  isomorphic as <math|k>\Uvarieties but are as <math|K>\Uvarieties, where
  <math|K> is a finite extension of <math|k>. For instance, the plane curves
  over <math|<math-bf|Q>> defined by the homogeneous equations
  <math|x<rsup|2>+y<rsup|2>-z<rsup|2>=0> and
  <math|x<rsup|2>+y<rsup|2>+z<rsup|2>=0> are
  <math|<math-bf|Q><around|(|<sqrt|-1>|)>>\Uisomorphic but not
  <math|<math-bf|Q>>\Uisomorphic.

  <subsection|Quadric surfaces>

  Over a finite field <math|<F><rsub|q>> exist distinct isomorphism classes
  of smooth quadric surfaces, respectively called <em|elliptic quadrics> and
  <em|hyperbolic quadrics> (see <cite|Hirschfeld> for further details).

  <subsubsection|Rational parametrization of quadrics><label|ratparam>

  Elliptic and hyperbolic quadrics are both rational. Here is a
  parametrization of the hyperbolic quadric with equation
  <math|x<rsub|0>*x<rsub|3>-x<rsub|1>*x<rsub|2>=0>.

  <\equation>
    <label|EmbeddingHyper><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<P><rsup|2>>|<cell|<dashrightarrow>>|<cell|<P><rsup|3>>>|<row|<cell|<around|(|x:y:z|)>>|<cell|\<longmapsto\>>|<cell|<around|(|z<rsup|2>:x*z:y*z:x*y|)>>>>>>|\<nobracket\>>.
  </equation>

  Let <math|Q<around|(|x,y|)>> be an irreducible homogeneous polynomial of
  degree two over <math|<F><rsub|q>>, then the following map yields a
  rational parametrization of the elliptic quadric with equation
  <math|x<rsub|0>*x<rsub|3>-Q<around|(|x<rsub|1>,x<rsub|2>|)>=0>

  <\equation>
    <label|EmbeddingEll><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<P><rsup|2>>|<cell|<dashrightarrow>>|<cell|<P><rsup|3>>>|<row|<cell|<around|(|x:y:z|)>>|<cell|\<longmapsto\>>|<cell|<around|(|z<rsup|2>:x*z:y*z:Q<around|(|x,y|)>|)>>>>>>|\<nobracket\>>.
  </equation>

  <\rem>
    From the above descriptions of these quadrics, one can easily prove that
    the elliptic quadric is a twist of the hyperbolic one. Let
    <math|<around|(|x+w*y|)>*<around|(|x+w<rsup|q>*y|)>> be the factorization
    of <math|Q> over <math|<F><rsub|q<rsup|2>>> (with
    <math|w\<in\><F><rsub|q<rsup|2>>\<setminus\><F><rsub|q>>). The
    <math|<F><rsub|q<rsup|2>>>--map <math|<around|(|x<rsub|0>:x<rsub|1>:x<rsub|2>:x<rsub|3>|)>\<mapsto\><around|(|x<rsub|0>:x<rsub|1>+w*x<rsub|2>:x<rsub|1>+w<rsup|q>*x<rsub|2>:x<rsub|3>|)>>
    induces an <math|<F><rsub|q<rsup|2>>>--isomorphism between the elliptic
    and the hyperbolic quadric.
  </rem>

  <\rem>
    <label|ChoiceOfQ>The elliptic quadric is unique up to projective
    equivalence. This entails that, in the above description, if we replace
    <math|Q> by another irreducible degree <math|2> polynomial, we get
    another elliptic quadric which is projectively equivalent to the first
    one.
  </rem>

  <section|Codes on hyperbolic quadrics><label|SecHyper>

  From now on, the hyperbolic quadric is denoted by <math|\<cal-H\>>. It is
  well\Uknown that <math|<H>> is isomorphic to
  <math|<P><rsup|1>\<times\><P><rsup|1>>. Indeed, the quadric <math|<H>> with
  equation <math|x<rsub|0>*x<rsub|3>-x<rsub|1>*x<rsub|2>=0> is the image of
  the Segre embedding (see <cite-detail|fulton|Chapter 4 4>,
  <cite-detail|sch1|Chapter I 5.1> for a definition of the Segre embedding):

  <\equation*>
    \<phi\>:<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<P><rsup|1>\<times\><P><rsup|1>>|<cell|\<rightarrow\>>|<cell|<P><rsup|3>>>|<row|<cell|<around|(|<around|(|u<rsub|0>:v<rsub|0>|)>,<around|(|u<rsub|1>:v<rsub|1>|)>|)>>|<cell|\<mapsto\>>|<cell|<around|(|u<rsub|0>*u<rsub|1>:u<rsub|0>*v<rsub|1>:v<rsub|0>*u<rsub|1>:v<rsub|0>*v<rsub|1>|)>>>>>>|\<nobracket\>>.
  </equation*>

  A homogeneous form <math|f\<in\>\<cal-F\><rsub|3><around|(|s|)>> pulled
  back by <math|\<phi\>> yields the bi-homogeneous form
  <math|f*<around|(|u<rsub|0>*u<rsub|1>,u<rsub|0>*v<rsub|1>,v<rsub|0>*u<rsub|1>,v<rsub|0>*v<rsub|1>|)>>
  of bi-degree <math|<around|(|s,s|)>>. Afterwards, one sees easily that the
  pullback map <math|\<phi\><rsup|\<star\>>> induces an isomorphism
  <math|\<cal-F\><rsub|3><around|(|s|)>/I<rsub|<H>><around|(|s|)><isomto>\<cal-F\><rsub|1><around|(|s|)>\<otimes\>\<cal-F\><rsub|1><around|(|s|)>>,
  where <math|I<rsub|<H>><around|(|s|)>> is the degree <math|s> part of the
  homogeneous ideal associated to <math|<H>>.

  Consequently, the code <math|C<rsub|<H>><around|(|s|)>> is nothing but the
  code <math|C<rsub|<P><rsup|1>><around|(|s|)>\<otimes\>C<rsub|<P><rsup|1>><around|(|s|)>>.
  The code <math|C<rsub|<P><rsup|1>><around|(|s|)>> is an extended
  Reed\USolomon code with parameters <math|<around|[|<around|(|q+1|)>,<around|(|s+1|)>,q-s+1|]>>.
  It is well\Uknown that the minimum distance of a tensor product of two
  codes is the product of the minimum distances. This yields the following
  result.

  <\thm>
    <label|CodeHyper>Let <math|<H>> be a hyperbolic quadric over
    <math|<F><rsub|q>>, let <math|s> be an integer such that
    <math|s\<less\>q>, then the code <math|C<rsub|<H>><around|(|s|)>> has
    parameters <math|<around|[|<around|(|q+1|)><rsup|2>,<around|(|s+1|)><rsup|2>,<around|(|q-s+1|)><rsup|2>|]>>.
  </thm>

  <\rem>
    <label|hansen>The above result is already partially proved by S.H. Hansen
    in <cite-detail|Han01|Example 3.2>, where the author obtains
    <math|<around|(|q-s+1|)><rsup|2>> as a lower bound for the minimum
    distance without proving that it is reached.

    Actually, Hansen considers more general evaluation codes on <math|<H>>:
    the codes obtained by evaluating spaces of forms whose pullback by
    <math|\<phi\>> are of the form <math|\<cal-F\><rsub|1><around|(|a|)>\<otimes\>\<cal-F\><rsub|1><around|(|b|)>>.
    Using the above approach, one proves easily that such codes have
    parameters <math|<around|[|<around|(|q+1|)><rsup|2>,<around|(|a+1|)>*<around|(|b+1|)>,<around|(|q-a+1|)>*<around|(|q-b+1|)>|]>>.
    This proves that the lower bound of Hansen is the actual minimum
    distance.
  </rem>

  <\rem>
    <label|allcodes>Using the structure of the Picard group of <math|<H>>,
    one can prove that any evaluation code on <math|<H>> is equivalent to one
    of the codes described in Remark <reference|hansen>. Therefore, using
    Remark <reference|hansen>, we have the exact parameters of any evaluation
    code on <math|<H>>.
  </rem>

  Theorem <reference|CodeHyper> has the following geometric corollary.

  <\cor>
    [Maximum number of points of a <math|<around|(|s,s|)>> curve] Let
    <math|X> be a curve obtained by the intersection of <math|<H>> with a
    hypersurface of degree <math|s> of <math|<P><rsup|3>> which does not
    contain <math|<H>>. Then the number of rational points of <math|X>
    satisfies

    <\equation*>
      \<sharp\>*X<around|(|<F><rsub|q>|)>\<leq\>2*s*<around|(|q+1|)>-s<rsup|2>
    </equation*>

    and the equality holds if and only if <math|X> is a union of <math|s>
    lines of the form <math|\<phi\>*<around|(|<around|{|a|}>\<times\><P><rsup|1>|)>>
    and <math|s> lines of the form <math|\<phi\>*<around|(|<P><rsup|1>\<times\><around|{|b|}>|)>>.
  </cor>

  <\proof>
    The upper bound comes from Theorem <reference|CodeHyper>. Moreover, it is
    easy to see that the union of <math|s> rational lines of the first ruling
    and <math|s> lines of the other one has
    <math|2*s*<around|(|q+1|)>-s<rsup|2>> rational points.

    Conversely, it is well\Uknown that the minimum weight codewords of a
    tensor product of codes are tensor products of minimum weight codewords.
    Thus, minimum weight codewords of <math|C<rsub|<H>><around|(|s|)>> are
    obtained by the evaluation of forms <math|f> whose pullback
    <math|\<phi\><rsup|\<star\>>*f> equals
    <math|g<around|(|u<rsub|0>,v<rsub|0>|)>*h<around|(|u<rsub|1>,v<rsub|1>|)>>,
    where <math|g,h> both split in products of <math|s> distinct polynomials
    of degree one. Thus, the vanishing locus of <math|f> is a union of lines
    and any <math|f> whose vanishing locus is not such a union has strictly
    less rational points in its vanishing locus on <math|<H>>.
  </proof>

  <section|BCH codes and codes on elliptic quadrics><label|SecEll>

  From now on, the elliptic quadric is denoted by <math|<E>> and <math|s>
  denotes a positive integer. The aim of the this section is to prove that
  the codes <math|C<rsub|<E>><around|(|s|)>> are extended BCH codes. More
  precisely, these codes of length <math|q<rsup|2>+1> (the elliptic quadric
  has <math|q<rsup|2>+1> rational points) punctured at two positions yield a
  BCH code of length <math|q<rsup|2>-1>.

  <subsection|The cyclic structure>

  The cyclic structure of the punctured codes can be explained geometrically.
  Indeed, the automorphism group of <math|<E>> acts 2-transitively on
  rational points and the stabilizer of two points contains a linear
  automorphism permuting cyclically the <math|q<rsup|2>-1> other points.

  Let us describe such an automorphism. Consider the description of
  <math|<E>> given in (<reference|EmbeddingEll>) <reference|ratparam> and
  assume moreover that <math|w> is a primitive element of
  <math|<F><rsub|q<rsup|2>>/<F><rsub|q>>. The multiplication by <math|w> in
  <math|<F><rsub|q<rsup|2>>> provides an automorphism
  <math|\<sigma\><rsub|w>\<in\><math-bf|Aut><rsub|<F><rsub|q>><around|(|<A><rsup|2>|)>>
  which extends to <math|<P><rsup|2>> and, thanks to the parametrization map
  (<reference|EmbeddingEll>), yields an automorphism
  <math|<wide|\<sigma\>|~><rsub|w>\<in\><math-bf|Aut><rsub|<F><rsub|q>><around|(|<E>|)>>.
  The map <math|<wide|\<sigma\>|~><rsub|w>> is the restriction to <math|<E>>
  of a linear automorphism of <math|<P><rsup|3>> described by the matrix

  <\equation*>
    <around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|0ln>|<table|<row|<cell|1>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|-N<around|(|w|)>>|<cell|0>>|<row|<cell|0>|<cell|1>|<cell|T*r<around|(|w|)>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|N<around|(|w|)>>>>>>|)>,
  </equation*>

  where <math|N<around|(|w|)>> and <math|T*r<around|(|w|)>> denote
  respectively the norm <math|N<rsub|<F><rsub|q<rsup|2>>/<F><rsub|q>><around|(|w|)>\<assign\>w<rsup|q+1>>
  and the trace <math|T*r<rsub|<F><rsub|q<rsup|2>>/<F><rsub|q>><around|(|w|)>\<assign\>w+w<rsup|q>>.
  One can check that this automorphism fixes the points
  <math|<around|(|1:0:0:0|)>> and <math|<around|(|0:0:0:1|)>> and permutes
  cyclically the <math|q<rsup|2>-1> other rational points of <math|<E>>.

  <subsection|A class of BCH codes><label|SubSectionBCH>

  <\defn>
    <label|DefBCH>For a given field <math|<F><rsub|q>> and a positive integer
    <math|s\<less\>q>, let <math|B<around|(|s|)>> be the cyclic code defined
    over the extension field <math|<F><rsub|q<rsup|2>>> that is generated by
    the vectors of the form <math|<around|(|\<zeta\><rsup|r>\|\<zeta\>\<in\><F><rsub|q<rsup|2>><rsup|\<times\>>|)>>,
    for <math|r=u+q*v> such that <math|0\<leq\>u,v\<leq\>s>. And let
    <math|B<rsub|0><around|(|s|)>> be the subfield subcode
    <math|B<around|(|s|)><rsub|\|<F><rsub|q>>>.
  </defn>

  This class of codes is studied in <cite|DuursmaPellikaan> and the following
  result is obtained.

  <\prop>
    <label|DuursPell>The code <math|B<rsub|0><around|(|s|)>> has parameters
    <math|<around|[|q<rsup|2>-1,<around|(|s+1|)><rsup|2>,q<rsup|2>-1-s*<around|(|q+1|)>|]>>.
    Moreover it is a BCH code.
  </prop>

  <\proof>
    <cite-detail|DuursmaPellikaan|Proposition 12> .
  </proof>

  <\rem>
    <label|subfield>Observe that the code <math|B<around|(|s|)>> is defined
    over <math|<F><rsub|q>> and there exists a generator matrix defined over
    <math|<F><rsub|q>> that generates <math|B<rsub|0><around|(|s|)>> (with
    coefficients chosen in <math|<F><rsub|q>>) as well as
    <math|B<around|(|s|)>> (with coefficients chosen in
    <math|<F><rsub|q<rsup|2>>>). Thus <math|B<rsub|0><around|(|s|)>> and
    <math|B<around|(|s|)>> have the same parameters. The condition
    <math|0\<leq\>u,v\<leq\>s> differs from the condition
    <math|0\<leq\>u+v\<leq\>s> that is used to describe punctured Reed-Muller
    codes as cyclic codes.
  </rem>

  <subsection|Codes on the elliptic quadric>

  The objective is to determine the parameters and in particular the minimum
  distance of the codes <math|C<rsub|<E>><around|(|s|)>>. Recall that except
  for the case <math|s=1,2> the minimum distance of these codes was unknown
  up to now.

  The point of the following statements is to show that the code
  <math|C<rsub|<E>><around|(|s|)>> punctured at two positions is the BCH code
  <math|B<rsub|0><around|(|s|)>> up to a reordering of the coordinates. Let
  us choose two points which will correspond to the punctured positions.

  <\nota>
    <label|Notation>From now on, we choose an irreducible homogeneous
    polynomial <math|Q<around|(|x<rsub|1>,x<rsub|2>|)>> and define
    <math|<E>\<subset\><P><rsup|3>> by the equation
    <math|x<rsub|0>*x<rsub|3>-Q<around|(|x<rsub|1>,x<rsub|2>|)>=0> as in
    (<reference|EmbeddingEll>). Let <math|P<rsub|0>> and
    <math|P<rsub|\<infty\>>> be the points of <math|<P><rsup|3>> with
    coordinates <math|<around|(|0:0:0:1|)>> and <math|<around|(|1:0:0:0|)>>,
    respectively. Both points are contained in <math|<E>>. We denote by
    <math|C<rsup|\<ast\>><rsub|<E>><around|(|s|)>> the code
    <math|C<rsub|<E>><around|(|s|)>> punctured at the two positions
    corresponding to <math|P<rsub|0>> and <math|P<rsub|\<infty\>>>.
  </nota>

  The following theorem, proved in <reference|Equal> is central in our
  study.

  <\thm>
    <label|Main>For all <math|s\<less\>q>, the code
    <math|C<rsup|\<ast\>><rsub|<E>><around|(|s|)>> defined in Notation
    <reference|Notation> is permutation equivalent to the code
    <math|B<rsub|0><around|(|s|)>> introduced in <reference|SubSectionBCH>.
  </thm>

  <subsubsection|The affine parametrization><label|SectionAffine>

  First, we should notice that <math|P<rsub|\<infty\>>> is the only rational
  point of <math|<E>\<cap\><around|{|x<rsub|0>=0|}>>. Thus, one can work in
  the affine chart <math|\<cal-U\>\<assign\><E>\<cap\><around|{|x<rsub|0>\<neq\>0|}>>.
  Using (<reference|EmbeddingEll>), we get the following affine
  parametrization of <math|\<cal-U\>>

  <\equation>
    <label|AffineParam><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<A><rsup|2>>|<cell|\<rightarrow\>>|<cell|<A><rsup|3>>>|<row|<cell|<around|(|x,y|)>>|<cell|\<mapsto\>>|<cell|<around|(|x,y,Q<around|(|x,y|)>|)>>>>>>|\<nobracket\>>.
  </equation>

  <\rem>
    <label|Correspondence>The image of the origin of <math|<A><rsup|2>> by
    the above map is the point <math|P<rsub|0>>. Thus, there is a
    one--to--one correspondence between the points of
    <math|<A><rsup|2><around|(|<F><rsub|q>|)>\<setminus\><around|{|<around|(|0,0|)>|}>>
    and the points of <math|<E>> supporting the code
    <math|C<rsup|\<ast\>><rsub|<E>><around|(|s|)>>.
  </rem>

  <subsubsection|Equality of codes><label|Equal>

  First, we state an elementary combinatorial lemma.

  <\lem>
    <label|Comb>For all nonnegative integer <math|s>, the sets
    <math|U<rsub|s>\<assign\><around|{|<around|(|i+k,j+k|)>\|i,j,k\<geq\>0*<with|font-family|rm|a*n*d>i+j+k\<leq\>s|}>>
    and <math|V<rsub|s>\<assign\><around|{|<around|(|i<rprime|'>,j<rprime|'>|)>\|0\<leq\>i<rprime|'>,j<rprime|'>\<leq\>s|}>>
    are equal.
  </lem>

  <\proof>
    The inclusion <math|U<rsub|s>\<subset\>V<rsub|s>> is obvious. Conversely,
    let <math|<around|(|i<rprime|'>,j<rprime|'>|)>\<in\>V<rsub|s>>. If
    <math|i<rprime|'>+j<rprime|'>\<leq\>s>, then set <math|k\<assign\>0>,
    else set <math|k\<assign\><around|(|i<rprime|'>+j<rprime|'>|)>-s>. Then,
    for <math|i\<assign\>i<rprime|'>-k> and <math|j\<assign\>j<rprime|'>-k>,
    we get <math|<around|(|i<rprime|'>,j<rprime|'>|)>=<around|(|i+k,j+k|)>\<in\>U<rsub|s>>.
  </proof>

  We can now proceed to the proof of Theorem <reference|Main>.

  <\proof>
    <dueto|Proof of Theorem <reference|Main>>Consider the base field
    extension <math|C<rsup|\<ast\>><rsub|<E>><around|(|s|)>\<otimes\><F><rsub|q<rsup|2>>>.
    From Remark <reference|subfield>, the subfield subcode of this code over
    <math|<F><rsub|q>> is <math|C<rsup|\<ast\>><rsub|<E>><around|(|s|)>>. We
    will prove that <math|C<rsup|\<ast\>><rsub|<E>><around|(|s|)>\<otimes\><F><rsub|q<rsup|2>>=B<around|(|s|)>>,
    and the theorem then follows from Definition <reference|DefBCH> and

    <\equation*>
      C<rsup|\<ast\>><rsub|<E>><around|(|s|)>=C<rsup|\<ast\>><rsub|<E>><around|(|s|)>\<otimes\><F><rsub|q<rsup|2>>\|<rsub|<F><rsub|q>>=B<around|(|s|)>\|<rsub|<F><rsub|q>>=B<rsub|0><around|(|s|)>.
    </equation*>

    We use the affine point of view described in <reference|SectionAffine>
    and denote by <math|<around|(|x,y,z|)>> a system of coordinates of
    <math|<A><rsup|3>>. The code <math|C<rsup|\<ast\>><rsub|<E>><around|(|s|)>\<otimes\><F><rsub|q<rsup|2>>>
    is obtained by evaluating at all the <math|<F><rsub|q>>\Urational points
    of <math|\<cal-U\>\<setminus\><around|{|P<rsub|0>|}>> the functions of
    the space <math|<F><rsub|q<rsup|2>><around|[|x,y,z|]><rsub|\<leq\>s>> of
    polynomials with total degree lower than or equal to <math|s>.

    Let <math|w\<in\><F><rsub|q<rsup|2>>> be the element of
    <math|<F><rsub|q<rsup|2>>\<setminus\><F><rsub|q>> such that
    <math|Q<around|(|x,y|)>=<around|(|x+w*y|)>*<around|(|x+w<rsup|q>*y|)>>
    over <math|<F><rsub|q<rsup|2>>> (without loss of generality, one can
    assume that the coefficient of <math|x<rsup|2>> in <math|Q> is <math|1>).
    Consider the family of polynomials

    <\equation*>
      f<rsub|i,j,k>\<assign\><around|(|x+w*y|)><rsup|i>*<around|(|x+w<rsup|q>*y|)><rsup|j>*z<rsup|k>,<space|1em>i+j+k\<leq\>s.
    </equation*>

    The polynomials <math|f<rsub|i,j,k>> yield an
    <math|<F><rsub|q<rsup|2>>>\Ubasis of <math|<F><rsub|q<rsup|2>><around|[|x,y,z|]><rsub|\<leq\>s>>.
    Pulling back this basis by the map described in
    (<reference|AffineParam>), we get the family of polynomials

    <\equation*>
      f<rsup|\<star\>><rsub|i,j,k>\<assign\><around|(|x+w*y|)><rsup|i>*<around|(|x+w<rsup|q>*y|)><rsup|j>*Q<around|(|x,y|)><rsup|k>=<around|(|x+w*y|)><rsup|i+k>*<around|(|x+w<rsup|q>*y|)><rsup|j+k>,
    </equation*>

    for <math|i+j+k\<leq\>s>. Therefore, using the map
    (<reference|AffineParam>) together with Remark
    <reference|Correspondence>, we see that
    <math|C<rsub|<E>><around|(|s|)><rsup|\<ast\>>\<otimes\><F><rsub|q<rsup|2>>>
    is generated over <math|<F><rsub|q<rsup|2>>> by the words

    <\equation*>
      <around|(|f<rsup|\<star\>><rsub|i,j,k><around|(|x,y|)>\|<around|(|x,y|)>\<in\><F><rsub|q><rsup|2>\<setminus\><around|{|0,0|}>|)>,<space|1em><text|for
      <math|i+j+k\<leq\>s>.>
    </equation*>

    Finally, for <math|\<zeta\>\<in\><F><rsub|q<rsup|2>>>, there exist unique
    <math|a,b\<in\><F><rsub|q>> such that <math|\<zeta\>=a+w*b>, and

    <\equation*>
      f<rsup|\<star\>><rsub|i,j,k><around|(|a,b|)>=\<zeta\><rsup|i+k>*<wide|\<zeta\>|\<bar\>><rsup|<around|(|j+k|)>>,
    </equation*>

    where <math|<wide|\<zeta\>|\<bar\>>> denotes the conjugate of
    <math|\<zeta\>> under the Frobenius action. That is
    <math|<wide|\<zeta\>|\<bar\>>\<assign\>\<zeta\><rsup|q>>. We conclude
    that <math|C<rsup|\<ast\>><rsub|<E>><around|(|s|)>\<otimes\><F><rsub|q<rsup|2>>>
    is generated over <math|<F><rsub|q<rsup|2>>> by the words

    <\equation*>
      <around|(|\<zeta\><rsup|i+k>*\<zeta\><rsup|q*<around|(|j+k|)>>\|\<zeta\>\<in\><F><rsub|q<rsup|2>><rsup|\<times\>>|)>,<space|1em><text|for
      <math|i+j+k\<leq\>s>.>
    </equation*>

    Using Lemma <reference|Comb>, the code is generated by the words

    <\equation*>
      <around|(|\<zeta\><rsup|i<rprime|'>+q*j<rprime|'>>\|\<zeta\>\<in\><F><rsub|q<rsup|2>><rsup|\<times\>>|)>,<space|1em><text|for
      >i<rprime|'>,j<rprime|'>\<leq\>s,
    </equation*>

    and hence this code is nothing but the code <math|B<around|(|s|)>>. This
    yields the result.
  </proof>

  <subsection|The parameters of the codes on the elliptic quadric>

  As a conclusion we have the following result.

  <\thm>
    <label|ParamEll>For all <math|s\<less\>q-1>, the code
    <math|C<rsub|<E>><around|(|s|)>> has parameters
    <math|<around|[|q<rsup|2>+1,<around|(|s+1|)><rsup|2>,q<rsup|2>+1-s*<around|(|q+1|)>|]>>
  </thm>

  <\proof>
    From Theorem <reference|Main> and Proposition <reference|DuursPell>, this
    code punctured at two positions has parameters
    <math|<around|[|q<rsup|2>-1,<around|(|s+1|)><rsup|2>,q<rsup|2>-1-s*<around|(|q+1|)>|]>>.
    Thus, <math|C<rsub|<E>><around|(|s|)>> has dimension at least
    <math|<around|(|s+1|)><rsup|2>> and minimum distance between
    <math|q<rsup|2>-1-s*<around|(|q+1|)>> and
    <math|q<rsup|2>+1-s*<around|(|q+1|)>>.

    Let <math|c> be a minimum weight codeword of
    <math|C<rsub|<E>><around|(|s|)>>. By the previous assertion, the weight
    of <math|c> satisfies <math|w<around|(|c|)>\<geq\>q<rsup|2>-1-s*<around|(|q+1|)>>.
    Moreover, since <math|s> is assumed to be <math|\<less\>q-1>, then
    <math|w<around|(|c|)>\<geq\>q+1\<geq\>3>. This word is obtained by the
    evaluation of <math|f\<in\>\<cal-F\><rsub|3><around|(|s|)>>. Since the
    automorphism group of <math|<E>> acts <math|2>\Utransitively, one can
    assume that <math|f> does not vanish on <math|P<rsub|0>> and
    <math|P<rsub|\<infty\>>> (see Notation <reference|Notation>). Therefore,
    if <math|c<rsup|\<ast\>>\<in\>C<rsub|<E>><around|(|s|)><rsup|\<ast\>>>
    denotes the punctured codeword <math|c>, then
    <math|w<around|(|c<rsup|\<ast\>>|)>=w<around|(|c|)>-2> and hence
    <math|w<around|(|c|)>\<geq\>q<rsup|2>+1-s*<around|(|q+1|)>>.
    Consequently, the code has minimum distance
    <math|q<rsup|2>+1-s*<around|(|q+1|)>>.

    Finally, let us prove that the dimension is
    <math|<around|(|s+1|)><rsup|2>>. Since the minimum distance of
    <math|C<rsub|<E>><around|(|s|)>> is <math|\<gtr\>2>, then no codeword can
    be sent to zero by puncturing. Thus, the puncturing map
    <math|C<rsub|<E>><around|(|s|)>\<rightarrow\>C<rsub|<E>><around|(|s|)><rsup|\<ast\>>>
    is an isomorphism and hence, both codes have the same dimension
  </proof>

  <\rem>
    One can prove using the structure of the Picard group of <math|<E>> that
    any evaluation code on this surface is equivalent to
    <math|C<rsub|<E>><around|(|s|)>> for some <math|s>. Thus, as for the
    hyperbolic quadric, we have here the exact parameters of any evaluation
    code on <math|<E>>.
  </rem>

  Theorem <reference|ParamEll> has a geometric corollary.

  <\cor>
    Let <math|s\<less\>q-1>. Let <math|X\<subset\>\<cal-E\>> be a curve
    obtained by the intersection of <math|<E>> with a hypersurface of degree
    <math|s> which does not contain <math|<E>>. Then,

    <\equation*>
      \<sharp\>*C<around|(|<F><rsub|q>|)>\<leq\>s*<around|(|q+1|)>.
    </equation*>
  </cor>

  <\proof>
    It is a straightforward consequence of Theorem <reference|ParamEll>
  </proof>

  <section|Higher dimensional analogues><label|SecHigher>

  The results in the previous sections give us the actual parameters of
  evaluation codes on smooth quadric surfaces. The case of a hyperbolic
  quadric was proved by establishing a relation with tensored Reed-Solomon
  codes and the case of an elliptic quadric was proved using a correspondence
  with a suitable class of BCH codes. Both approaches generalize and in this
  section we will describe evaluation codes defined on the image
  <math|X\<subset\><P><rsup|2<rsup|d>-1>> of the Segre embedding
  <math|\<phi\>:<P><rsup|1>\<times\>\<cdots\>\<times\><P><rsup|1>\<longrightarrow\><P><rsup|2<rsup|d>-1>>
  of <math|d> copies of <math|<P><rsup|1>>.

  It is well\Uknown that the homogeneous ideal
  <math|I<rsub|X>\<subset\>\<cal-F\><rsub|2<rsup|d>-1>=<F><rsub|q><around|[|x<rsub|0>,\<ldots\>,x<rsub|r>|]>>
  for <math|X> is generated by quadrics. In fact this is true more generally
  for the larger class of Segre embeddings of projective space of any
  dimension (details and further references can be found in <cite|Rub07>).

  The case of the embedding of <math|<P><rsup|1>\<times\><P><rsup|1>\<times\><P><rsup|1>>
  has a rational parametrization

  <\equation>
    <label|EmbeddingHyper><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<P><rsup|3>>|<cell|<dashrightarrow>>|<cell|<P><rsup|7>>>|<row|<cell|<around|(|x:y:z:t|)>>|<cell|\<longmapsto\>>|<cell|<around|(|t<rsup|3>:t<rsup|2>*x:t<rsup|2>*y:t<rsup|2>*z:t*x*y:t*y*z:t*z*x:x*y*z|)>>>>>>|\<nobracket\>>.
  </equation>

  The image is the intersection in <math|<P><rsup|7>> of nine quadrics that
  correspond to the relations <math|<around|(|t<rsup|2>*x|)>*<around|(|t<rsup|2>*y|)>=<around|(|t<rsup|3>|)>*<around|(|t*x*y|)>>,
  <math|<around|(|t<rsup|2>*x|)>*<around|(|t*y*z|)>=<around|(|t<rsup|3>|)>*<around|(|x*y*z|)>>,
  <math|<around|(|t<rsup|2>*x|)>*<around|(|x*y*z|)>=<around|(|t*x*y|)>*<around|(|t*z*x|)>>
  and their cyclic permutations under <math|x\<mapsto\>y\<mapsto\>z\<mapsto\>x>.
  The full resolution, given in <cite|Rub02>, is

  <\equation*>
    0\<longrightarrow\>\<cal-F\><rsub|7>[-6]\<longrightarrow\>\<cal-F\><rsub|7>[-4]<rsup|9>\<longrightarrow\>\<cal-F\><rsub|7>[-3]<rsup|16>\<longrightarrow\>\<cal-F\><rsub|7>[-2]<rsup|9>\<longrightarrow\>\<cal-F\><rsub|7>\<longrightarrow\>\<cal-F\><rsub|7>/I<rsub|X>\<longrightarrow\>0.
  </equation*>

  <subsection|The non-twisted case>

  Without proof, which is similar to the case of smooth quadrics in
  <math|<P><rsup|3>> and which will be available in an extended version, we
  give the parameters of evaluation codes on the embedding
  <math|X=<P><rsup|1>\<times\>\<cdots\>\<times\><P><rsup|1>\<subset\><P><rsup|2<rsup|d>-1>>
  and on twists of <math|X> over <math|<F><rsub|q<rsup|d>>>.

  <\thm>
    <label|CodeHyper2>Let <math|<H>> be the Segre embedding of the product
    <math|<P><rsup|1>\<times\>\<cdots\>\<times\><P><rsup|1>\<hookrightarrow\><P><rsup|2<rsup|d>-1>>
    of <math|d> copies of projective line over <math|<F><rsub|q>>, let
    <math|s> be an integer such that <math|s\<less\>q>, then the code
    <math|C<rsub|<H>><around|(|s|)>> has parameters
    <math|<around|[|<around|(|q+1|)><rsup|d>,<around|(|s+1|)><rsup|d>,<around|(|q-s+1|)><rsup|d>|]>>.
    Moreover, the code is the <math|d>-fold tensor product of an extended
    Reed-Solomon code.
  </thm>

  <subsection|The twisted case>

  <\defn>
    Let <math|d> be a positive integer and
    <math|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|d>> be an
    <math|<F><rsub|q>>--basis of <math|<F><rsub|q<rsup|d>>>. The variety
    <math|<E>> is obtained by twisting <math|<H>> over
    <math|<F><rsub|q<rsup|2>>> by the map

    <\equation*>
      <around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|x<rsub|0><rprime|'>>|<cell|\<assign\>>|<cell|x<rsub|0>>>|<row|<cell|x<rsub|j><rprime|'>>|<cell|\<assign\>>|<cell|\<alpha\><rsub|1><rsup|q<rsup|j-1>>*x<rsub|1>+\<cdots\>+\<alpha\><rsub|d><rsup|q<rsup|j-1>>*x<rsub|d>,<space|1em><with|font-family|rm|f*o*r>*j\<in\><around|{|1,\<ldots\>,d|}>>>>>>|\<nobracket\>>.
    </equation*>
  </defn>

  <\thm>
    <label|ParamEll2>For all <math|s\<less\>q-1>, the code
    <math|C<rsub|<E>><around|(|s|)>> has parameters
    <math|<around|[|q<rsup|d>+1,<around|(|s+1|)><rsup|d>,q<rsup|d>+1-s*<around|(|q<rsup|d>-1|)>/<around|(|q-1|)>|]>>.
    Moreover, the twice punctured code <math|C<rsup|\<ast\>><rsub|<E>><around|(|s|)>>
    is a BCH code.
  </thm>

  We observe that the last theorem has applications in two directions. It
  shows first that the maximum number of <math|<F><rsub|q>>\Urational zeros
  in <math|<E>\<subset\><P><rsup|r>> of a homogeneous form of degree <math|s>
  agrees with the BCH bound, that is to say it can be obtained using fairly
  elementary coding theory and without using geometric tools. On the other
  hand it gives certain BCH codes a geometric interpretation as evaluation
  codes on an algebraic variety.

  <section*|Acknowledgements>

  The first author is supported by the French ANR Defis program under
  contract ANR-08-EMER-003 (COCQ project).

  <surround||<vspace|2fn>|<\bibliography|bib|abbrv|biblio>
    <bib-list|[99]|>
  </bibliography>>

  <no-indent>Alain Couvreur<next-line>Universit Bordeaux
  I<next-line>Institut de Mathmatiques de Bordeaux<next-line>351, cours de
  la Libration<next-line>33405 Talence Cedex,
  France<next-line><slink|couvreur@math.u-bordeaux1.fr>

  <bigbreak>

  <no-indent>Iwan Duursma<next-line>University of Illinois at
  Urbana\UChampaign<next-line>Department of Mathematics<next-line>1409 W.
  Green Street (MC-382)<next-line>Urbana, Illinois
  61801-2975<next-line><slink|duursma@math.uiuc.edu>
</body>