<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|thmetc|Dummy>

    <new-theorem|theorem|Theorem>

    <new-theorem|lemma|Lemma>

    <new-theorem|corollary|Corollary>

    <new-theorem|example|Example>

    <new-theorem|examples|Examples>

    <new-theorem|remark|Remark>

    <new-theorem|algorithm|Algorithm>

    <new-theorem|proof|Proof>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|Q|<macro|\<bbb-Q\>>>

    <assign|GL|<macro|<math-up|GL>>>

    <assign|NN|<macro|<math-up|N>>>

    <assign|a|<macro|\<frak-a\>>>

    <assign|b|<macro|\<frak-b\>>>

    <assign|c|<macro|\<frak-c\>>>

    <assign|d|<macro|\<frak-d\>>>

    <assign|e|<macro|\<frak-e\>>>

    <assign|f|<macro|\<frak-f\>>>

    <assign|g|<macro|\<frak-g\>>>

    <assign||<macro|>>

    <assign|p|<macro|\<frak-p\>>>

    <assign|q|<macro|\<frak-q\>>>

    <assign|r|<macro|\<frak-r\>>>

    <assign|v|<macro|<math-up|v>>>

    <assign|MM|<macro|\<frak-M\>>>

    <assign|QQ|<macro|\<frak-Q\>>>

    <assign|abs|<macro|1|<left|\|><arg|1><right|\|>>>

    <assign|tabs|<macro|1|<math-open|\|><arg|1><math-close|\|>>>

    <assign|disjun|<macro|<wide|\<cup\>|\<dot\>>>>

    <assign|matr|<macro|1|2|3|4|<matrix|<tformat|<table|<row|<cell|<arg|1>>|<cell|<arg|2>>>|<row|<cell|<arg|3>>|<cell|<arg|4>>>>>>>>

    <assign|tmatr|<macro|1|2|3|4|(<matrix*|<tformat|<table|<row|<cell|<arg|1>>|<cell|<arg|2>>>|<row|<cell|<arg|3>>|<cell|<arg|4>>>>>>)>>

    <assign|vect|<macro|1|2|<matrix|<tformat|<table|<row|<cell|<arg|1>>>|<row|<cell|<arg|2>>>>>>>>

    <assign|tvect|<macro|1|2|(<matrix*|<tformat|<table|<row|<cell|<arg|1>>>|<row|<cell|<arg|2>>>>>>)>>

    <assign|divides|<macro|\|>>

    <assign|ndivides|<macro|\<nmid\>>>

    <assign|eps|<macro|\<varepsilon\>>>
  </hide-preamble>

  <doc-data|<doc-title|Counting cosets of unimodular groups over Dedekind
  domains>|<doc-author|<author-data|<author-name|Marc
  Ensenbach<rsup|a><footnote|<with|font-family|tt|ensenbach@mathematik.uni-siegen.de>,
  Telephone: +49<space|0.17em>271<space|0.17em>740<space|0.17em>3518, Fax:
  +49<space|0.17em>271<space|0.17em>740<space|0.17em>3514><next-line><with|font-size|1|<rsup|a>University
  of Siegen, Department of Mathematics, 57068 Siegen,
  Germany>>>>|<doc-date|>>

  <abstract-data|<\abstract>
    In this paper, a formula for the calculation of the number of right
    cosets contained in a double coset with respect to a unimodular group
    over a Dedekind domain is developed, and applications of this formula in
    the theory of congruence subgroups -- an index formula -- and the theory
    of abstract Hecke algebras -- a reduction theorem and an algorithm for
    the explicit calculation of products -- are given.
  </abstract>>

  <em|Keywords:> Unimodular group, Dedekind domain, Congruence subgroup,
  Index formula, Hecke algebra

  <em|2010 MSC:> 20G30, 20H05, 20C08

  <section|Introduction><label|intro>

  Being able to count right cosets contained in a double coset with respect
  to a unimodular group <math|U>, i.<space|0.17em>e. being able to determine
  the cardinality of <math|U\<setminus\>U*A*U> for any given matrix <math|A>
  of appropriate format, is helpful in a multitude of areas.

  The formula presented in this article originally has been studied in the
  field of Hecke algebras. If we want to carry out computational analysis in
  Hecke theory, we need an algorithm that allows us to multiply two elements
  of an abstract Hecke algebra. Since the product can be calculated by a
  multiplication of representatives of right cosets, the task of multiplying
  elements of an abstract Hecke algebra can essentially be reduced to the
  search for decompositions of double cosets into right cosets. Knowing how
  many cosets we have to find allows us to state a randomised algorithm which
  carries out the decomposition. Moreover, there is an application in the
  proof of a theoretical result on abstract Hecke algebras. In the
  \Pclassic\Q Hecke algebra <math|H<rsub|n>> related to the
  <math|<GL><rsub|n><around|(|<Z>|)>>, certain products in <math|H<rsub|n>>
  can be reduced to products in <math|H<rsub|n-1>>. With the presented result
  this reduction theorem can be generalised to Hecke algebras related to
  arbitrary norm-finite Dedekind domains in the case <math|n=2>. Details of
  these two applications to Hecke algebras can be found in section
  <reference|applhecke>.

  Another application is shown in section <reference|applcong>. The set of
  right cosets with respect to <math|U> which are contained in <math|U*A*U>
  can be related to a right transversal of a certain subgroup of <math|U>
  depending on <math|A>. For some special matrices <math|A> these subgroups
  turn out to be congruence subgroups, so we are enabled to calculate indexes
  of certain congruence subgroups of <math|U>.

  The remaining sections of this article are organised as follows: In the
  following section, the notation used in this article is fixed and some
  basic facts which are used throughout this article are assembled. After
  that, the main result \U a formula for the cardinality of
  <math|U\<setminus\>U*A*U> \U is stated and proved in section
  <reference|countright>.

  This article is developed from a talk I gave some time ago in the research
  seminar \PComputational Algebra and Number Theory\Q of Fritz Grunewald,
  whose unexpected death in 2010 means a great loss for the mathematical
  community.

  <section|Preliminaries and Notation><label|prelim>

  Denote by <math|> a norm-finite Dedekind domain, i.<space|0.17em>e. a
  Dedekind domain in which <math|<tabs|/a*>\<less\>\<infty\>> holds for
  every <math|a\<in\>> (where <math|<tabs|M>> is the cardinality of the set
  <math|M>). Furthermore, denote by <math|K> the field of fractions of
  <math|>, and by <math|<rsup|\<ast\>>> the group of unities of <math|>;
  then denote by <math|<v><rsub|<p>><around|(|<a>|)>> the multiplicity of a
  prime ideal <math|<p>> in the ideal <math|<a>> of <math|> (fundamental
  properties of Dedekind domains and multiplicities can be found for example
  in <cite|Froehlich:Algebraic> Chapter II).

  Let <math|I> be the set of (<math|2\<times\>2>) matrices with entries in
  <math|> and non-zero determinant; furthermore, denote by <math|U> the set
  of matrices in <math|I> with determinant in <math|<rsup|\<ast\>>> (in
  other words <math|U=<GL><rsub|2><around|(||)>> and
  <math|I=<GL><rsub|2><around|(|K|)>\<cap\><rsup|2\<times\>2>>). For
  <math|A=<tmatr|a|b|c|d>\<in\><rsup|2\<times\>2>> one defines the first and
  second determinantal divisor of <math|A> by
  <math|<d><rsub|1><around|(|A|)>=a*+b*+c*+d*> and
  <math|<d><rsub|2><around|(|A|)>=<around|(|det A|)>*>, respectively.
  Furthermore, <math|<e><rsub|1><around|(|A|)>\<assign\><d><rsub|1><around|(|A|)>>
  and <math|<e><rsub|2><around|(|A|)>\<assign\><d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1>>
  are called the elementary divisors of <math|A>. Additionally, define the
  fundamental factors <math|<f><rsub|1><around|(|A|)>\<assign\><e><rsub|1><around|(|A|)>=<d><rsub|1><around|(|A|)>>
  and <math|<f><rsub|2><around|(|A|)>\<assign\><e><rsub|2><around|(|A|)><e><rsub|1><around|(|A|)><rsup|-1>=<d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-2>>
  and introduce the notation <math|<g><around|(|A|)>> for the
  g.<space|0.17em>c.<space|0.17em>d. of the first column of <math|A>,
  i.<space|0.17em>e. <math|<g><around|(|A|)>=a*+c*>.

  The relation between determinantal divisors and double cosets of <math|U>
  is given in the following theorem, which goes back to Steinitz
  (<cite|Steinitz:Rechteckige>, see also <cite|Ensenbach:Determinantal>
  Theorem 2.2).

  <\theorem>
    <label|dcequal>Let <math|A,B\<in\><rsup|2\<times\>2>>.

    <\enumerate>
      <item>If <math|A> and <math|B> have rank <math|2> (i.<space|0.17em>e.,
      if <math|A,B\<in\>I>), the following assertions are equivalent:

      <\enumerate|(i)>
        <item><math|U*A*U=U*B*U>,

        <item><math|<d><rsub|1><around|(|A|)>=<d><rsub|1><around|(|B|)>> and
        <math|<d><rsub|2><around|(|A|)>=<d><rsub|2><around|(|B|)>>.
      </enumerate>

      <item>If <math|A> and <math|B> have rank <math|1> and the first columns
      of <math|A> and <math|B> both contain at least one non-zero element,
      the following assertions are equivalent:

      <\enumerate|(i)>
        <item><math|U*A*U=U*B*U>,

        <item><math|<d><rsub|1><around|(|A|)>=<d><rsub|1><around|(|B|)>> and
        <math|<g><around|(|A|)>=<g><around|(|B|)>>.
      </enumerate>
    </enumerate>

    In these assertions, the <math|<d><rsub|i>> can also be replaced by the
    <math|<e><rsub|i>> or the <math|<f><rsub|i>>.
  </theorem>

  This theorem can not only be used to characterise the equality of double
  cosets, but also has an application in the proof of the following corollary
  which allows to state a relation between different generators of the same
  ideal in <math|>.

  <\corollary>
    <label|unimodgen>Let <math|a,b,c,d\<in\>> such that
    <math|a*+b*=c*+d*>. Then there exists an <math|R\<in\>U> satisfying
    <math|R<tvect|a|b>=<tvect|c|d>>.
  </corollary>

  <\proof>
    In the case <math|c=d=0> we also have <math|a=b=0> and can choose
    <math|R=<tmatr|1|0|0|1>>. For the remaining part of the proof assume
    <math|c\<neq\>0> (without loss of generality). Let
    <math|A=<tmatr|a|0|b|0>> and <math|B=<tmatr|c|0|d|0>>. Since <math|A> and
    <math|B> both have rank <math|1> and satisfy
    <math|<d><rsub|1><around|(|A|)>=<d><rsub|1><around|(|B|)>> as well as
    <math|<g><around|(|A|)>=<g><around|(|B|)>>, Theorem <reference|dcequal>
    yields the existence of <math|P,Q\<in\>U> such that <math|P*A*Q=B> and
    thus <math|P*A=B*Q<rsup|-1>>. Writing
    <math|P=<tmatr|p<rsub|1>|p<rsub|2>|p<rsub|3>|p<rsub|4>>> and
    <math|Q<rsup|-1>=<tmatr|q<rsub|1>|q<rsub|2>|q<rsub|3>|q<rsub|4>>> and
    calculating <math|P*A> as well as <math|B*Q<rsup|-1>> we obtain

    <\equation*>
      <matr|p<rsub|1>*a+p<rsub|2>*b|0|p<rsub|3>*a+p<rsub|4>*b|0>=<matr|c*q<rsub|1>|c*q<rsub|2>|d*q<rsub|1>|d*q<rsub|2>>.
    </equation*>

    In particular, we have <math|c*q<rsub|2>=0>, and since <math|c\<neq\>0>,
    this implies <math|q<rsub|2>=0>. Thus <math|det
    Q<rsup|-1>=q<rsub|1>*q<rsub|4>>, which implies
    <math|q<rsub|1>\<in\><rsup|\<ast\>>>. If we define
    <math|R=q<rsub|1><rsup|-1>*P>, we thus have <math|R\<in\>U>. Furthermore,

    <\equation*>
      R<matr|a|0|b|0>=q<rsub|1><rsup|-1>*P*A=q<rsub|1><rsup|-1><matr|p<rsub|1>*a+p<rsub|2>*b|0|p<rsub|3>*a+p<rsub|4>*b|0>=q<rsub|1><rsup|-1><matr|c*q<rsub|1>|0|d*q<rsub|1>|0>=<matr|c|0|d|0>,
    </equation*>

    which proves <math|R<tvect|a|b>=<tvect|c|d>> and completes the proof.
  </proof>

  <\remark>
    Since there exists a version of Theorem <reference|dcequal> for
    <math|A,B\<in\><rsup|n\<times\>n>> for arbitrary <math|n\<in\><N>> (see
    e.<space|0.17em>g. <cite|Ensenbach:Determinantal> Theorem 2.2), Corollary
    <reference|unimodgen> can easily be generalised from two generators to an
    arbitrary number of generators of an ideal, as long as the number of
    generators on both sides of the equation are the same.
  </remark>

  <section|Counting right cosets><label|countright>

  In this section a formula for the number of right cosets in a given double
  coset of <math|U> is derived. To begin with, a short example shows how
  coset counting is carried out in the \Pnice classic case\Q <math|=<Z>>.
  This will serve as a guideline for the subsequent analysis of the general
  case.

  <\example>
    <label|exz>Let <math|=<Z>>. Since <math|> is a principal ideal domain,
    every right coset <math|U*B> for <math|B\<in\>I> has a unique
    representative

    <\equation*>
      B<rprime|'>=<matr|a|b|0|d><space|2em><text|with <math|a,d\<gtr\>0> and
      >0\<leq\>b\<less\>d
    </equation*>

    known as the Hermite normal form of <math|B>. Given this normal form, the
    number of right cosets in a given double coset <math|U*A*U> can be
    obtained by generating all possible normal forms (in a sensible way) and
    deciding whether they belong to <math|U*A*U>. The latter can be carried
    out using Theorem <reference|dcequal> to test for
    <math|U*B<rprime|'>*U=U*A*U>, so it has to be checked whether
    <math|<d><rsub|1><around|(|B<rprime|'>|)>=<d><rsub|1><around|(|A|)>> and
    <math|<d><rsub|2><around|(|B<rprime|'>|)>=<d><rsub|2><around|(|A|)>>
    hold.

    As a concrete example construct every right coset representative
    <math|B<rprime|'>> as above contained in <math|U*A*U> where
    <math|A=<tmatr|1|0|0|4>>. Since <math|<d><rsub|2><around|(|A|)>=<d><rsub|2><around|(|B<rprime|'>|)>>
    is a necessary condition for <math|U*B<rprime|'>*U=U*A*U>, the equation
    <math|<around|(|det A|)><Z>=<around|(|det B<rprime|'>|)><Z>> and thus
    <math|4=a*d> has to be satisfied. So there are three possible cases:

    <\enumerate>
      <item><math|a=4> and <math|d=1>,

      <item><math|a=2> and <math|d=2>, and

      <item><math|a=1> and <math|d=4>.
    </enumerate>

    For these cases determine, for which values of <math|b> the equation
    <math|U*B<rprime|'>*U=U*A*U> is fulfilled. To this end, it suffices to
    test whether <math|<d><rsub|1><around|(|B<rprime|'>|)>=<d><rsub|1><around|(|A|)>>
    holds since <math|a> and <math|d> have already been constructed to
    satisfy <math|<d><rsub|2><around|(|B<rprime|'>|)>=<d><rsub|2><around|(|A|)>>.

    <\enumerate>
      <item>Since <math|d=1> and <math|0\<leq\>b\<less\>d=1>, only the case
      <math|b=0> has to be analysed. Then we have
      <math|<d><rsub|1><around|(|B<rprime|'>|)>=a<Z>+b<Z>+d<Z>=4<Z>+0<Z>+1<Z>=1<Z>=1<Z>+4<Z>=<d><rsub|1><around|(|A|)>>,
      so <math|<tmatr|4|0|0|1>> is a right coset representative in
      <math|U*A*U>.

      <item>Since <math|d=2> and <math|0\<leq\>b\<less\>d=2>, the cases
      <math|b=0> and <math|b=1> have to be considered. For <math|b=0> we have
      <math|<d><rsub|1><around|(|B<rprime|'>|)>=2<Z>\<neq\>1<Z>=<d><rsub|1><around|(|A|)>>,
      so <math|<tmatr|2|0|0|2>> is not an element of <math|U*A*U>. For
      <math|b=1>, however, we have <math|<d><rsub|1><around|(|B<rprime|'>|)>=1<Z>=<d><rsub|1><around|(|A|)>>,
      so <math|<tmatr|2|1|0|2>> belongs to <math|U*A*U>.

      <item>Since <math|d=4> and <math|0\<leq\>b\<less\>d=4>, the cases
      <math|b\<in\><around|{|0,1,2,3|}>> have to be analysed. Due to
      <math|a=1> we have <math|<d><rsub|1><around|(|B<rprime|'>|)>=1<Z>=<d><rsub|1><around|(|A|)>>
      in any of these cases, so <math|<tmatr|1|b|0|4>> belongs to
      <math|U*A*U> for every <math|b\<in\><around|{|0,1,2,3|}>>.
    </enumerate>

    Summarising, in <math|U*A*U> we have found the <math|6> right coset
    representatives <math|<tmatr|4|0|0|1>>, <math|<tmatr|2|1|0|2>>,
    <math|<tmatr|1|0|0|4>>, <math|<tmatr|1|1|0|4>>, <math|<tmatr|1|2|0|4>>,
    and <math|<tmatr|1|3|0|4>>.

    Generalising these considerations, a formula for the number
    <math|\<mu\><around|(|A|)>> of right cosets contained in <math|U*A*U> can
    be stated:

    <\equation*>
      \<mu\><around|(|A|)>=<big|sum><rsub|<stack|<tformat|<table|<row|<cell|d\<in\><N>>>|<row|<cell|d\<divides\>det
      A>>>>>><tabs|<around|{|b\<in\><N><rsub|0><space|0.22em>\|<space|0.22em>b\<less\>d<text|and
      ><tfrac|det A|d><Z>+b<Z>+d<Z>=<d><rsub|1><around|(|A|)>|}>>
    </equation*>

    (where <math|<N>=<around|{|1,2,3,\<ldots\>,|}>> and
    <math|<N><rsub|0>=<around|{|0,1,2,\<ldots\>|}>>). The cardinality of a
    set <math|<around|{|b\<in\><N><rsub|0><space|0.22em>\|<space|0.22em>b\<less\>d*<text|and
    >a<Z>+b<Z>+d<Z>=<d><rsub|1><around|(|A|)>|}>> can be calculated
    explicitly, which finally leads to a product formula for
    <math|\<mu\><around|(|A|)>> (not presented in detail since the same steps
    are to be done for the general case in the following).
  </example>

  The first main ingredient of the approach taken in Example <reference|exz>
  in the classic case was the Hermite normal form. In the general case,
  another normal form can be constructed \U not as \Pnice\Q as in the classic
  case, but nevertheless solving the issue of a uniquely determined
  representative.

  <\lemma>
    <label|normalform>Let <math|<a>> be an ideal in <math|> and
    <math|b\<in\><a>>. Choose an <math|a\<in\><a>> satisfying
    <math|a\<neq\>0> and <math|a*+b*=<a>> (always possible since <math|>
    is a Dedekind domain) and a transversal <math|T> of
    <math|<around|(|\<cap\>a*b<rsup|-1>*|)>/<around|(|b*a<rsup|-1>*\<cap\>a*b<rsup|-1>*|)>>.
    This transversal is finite, and for every <math|A\<in\>I> satisfying
    <math|<g><around|(|A|)>=<a>> and <math|<d><rsub|2><around|(|A|)>=b*>
    there exists a uniquely determined <math|c\<in\>T> such that

    <\equation*>
      U<matr|a|c-1|b|b*a<rsup|-1>*c>=U*A.
    </equation*>
  </lemma>

  <\proof>
    The finiteness of <math|T> follows from the norm-finiteness of <math|>
    since <math|b*a<rsup|-1>*\<cap\>a*b<rsup|-1>*> is an ideal in <math|>.

    To prove the uniqueness of <math|c>, assume

    <\equation*>
      U<matr|a|c-1|b|b*a<rsup|-1>*c>=U<matr|a|d-1|b|b*a<rsup|-1>*d>
    </equation*>

    for <math|c,d\<in\>T>. Since then

    <\equation*>
      <matr|a|d-1|b|b*a<rsup|-1>*d><matr|a|c-1|b|b*a<rsup|-1>*c><rsup|-1>=<matr|c-d+1|a*b<rsup|-1>*<around|(|d-c|)>|b*a<rsup|-1>*<around|(|c-d|)>|1-c+d>
    </equation*>

    has to be an element of <math|U>, we obtain in particular
    <math|a*b<rsup|-1>*<around|(|d-c|)>\<in\>> and
    <math|b*a<rsup|-1>*<around|(|c-d|)>\<in\>>, which yields
    <math|d-c\<in\>b*a<rsup|-1>*\<cap\>a*b<rsup|-1>*>. Since <math|T> is a
    transversal modulo <math|b*a<rsup|-1>*\<cap\>a*b<rsup|-1>*> and
    <math|c,d\<in\>T>, this shows <math|c=d> and thus proves the uniqueness
    of the representative.

    In the remaining part of the proof the existence of the desired
    representative is shown. Let <math|A\<in\>I> satisfying
    <math|<g><around|(|A|)>=<a>> and <math|<d><rsub|2><around|(|A|)>=b*>.
    Since <math|a*+b*=<g><around|(|A|)>>, by Corollary
    <reference|unimodgen> there exists a <math|P<rsub|1>\<in\>U> such that
    <math|P<rsub|1>*A=<tmatr|a|\<ast\>|b|\<ast\>>>. Then let
    <math|<eps>=b<around|(|det <around|(|P<rsub|1>*A|)>|)><rsup|-1>\<in\><rsup|\<ast\>>>
    and <math|P<rsub|2>=<tmatr|<eps>|0|0|1>\<in\>U>, such that <math|det
    <around|(|P<rsub|2>*P<rsub|1>*A|)>=b>. Furthermore, the Chinese Remainder
    Theorem allows us to choose a <math|p\<in\>> satisfying
    <math|p\<in\><around|(|\<cap\>b*a<rsup|-1>*|)>+<eps><rsup|-1>> and
    <math|p\<in\><around|(|\<cap\>a*b<rsup|-1>*|)>+1> since
    <math|\<cap\>b*a<rsup|-1>> and <math|\<cap\>a*b<rsup|-1>*> are
    relatively prime. The matrix

    <\equation*>
      P<rsub|3>=<matr|p|a*b<rsup|-1>*<around|(|1-<eps>p|)>|b*a<rsup|-1>*<around|(|p-1|)>|<eps>+1-<eps>p>
    </equation*>

    then is an element of <math|<rsup|2\<times\>2>> with <math|det
    P<rsub|3>=1>, and we have

    <\equation*>
      P<rsub|3>*P<rsub|2>*P<rsub|1>*A=P<rsub|3>*P<rsub|2><matr|a|\<ast\>|b|\<ast\>>=P<rsub|3><matr|<eps>a|\<ast\>|b|\<ast\>>=<matr|a|\<ast\>|b|\<ast\>>
    </equation*>

    with <math|det <around|(|P<rsub|3>*P<rsub|2>*P<rsub|1>*A|)>=b>, so if the
    second column of <math|P<rsub|3>*P<rsub|2>*P<rsub|1>*A> is denoted by
    <math|<tvect|r|s>>, we have <math|a*s-b*r=b> and thus
    <math|1+r=a*b<rsup|-1>*s\<in\>a*b<rsup|-1>*>. Since furthermore
    <math|1+r\<in\>>, by the choice of <math|T> there exists a
    <math|c\<in\>T> satisfying <math|1+r\<in\>c+<around|(|b*a<rsup|-1>*\<cap\>a*b<rsup|-1>*|)>>.
    Now let

    <\equation*>
      P<rsub|4>=<matr|a*b<rsup|-1>*s-c+1|a*b<rsup|-1>*<around|(|c-r-1|)>|s-b*a<rsup|-1>*c|c-r>.
    </equation*>

    Then <math|P<rsub|4>\<in\><rsup|2\<times\>2>> and <math|det P<rsub|4>=1>
    (since <math|a*b<rsup|-1>*s=1+r> and <math|c-r-1\<in\>b*a<rsup|-1>*\<cap\>a*b<rsup|-1>*>),
    and putting everything together we have
    <math|P<rsub|4>*P<rsub|3>*P<rsub|2>*P<rsub|1>\<in\>U> and

    <\equation*>
      P<rsub|4>*P<rsub|3>*P<rsub|2>*P<rsub|1>*A=P<rsub|4><matr|a|r|b|s>=<matr|a*<around|(|a*b<rsup|-1>*s-r|)>|a*b<rsup|-1>*s*<around|(|c-1|)>-c*r+r|a*s-b*r|b*a<rsup|-1>*c*<around|(|a*b<rsup|-1>*s-r|)>>=<matr|a|c-1|b|b*a<rsup|-1>*c>,
    </equation*>

    which shows the existence of a representative with the desired form and
    thus completes the proof.
  </proof>

  With this normal form, a first elementary formula for the number of right
  cosets with a prescribed g.<space|0.17em>c.<space|0.17em>d. of the first
  column can be given. (All elements of a right coset with respect to
  <math|U> have the same g.<space|0.17em>c.<space|0.17em>d. of the first
  column, so it is possible to talk about the
  g.<space|0.17em>c.<space|0.17em>d. of the first column of a right coset.)

  <\corollary>
    <label|elemmua>Let <math|A\<in\>I> and <math|<a>> an ideal of <math|>
    such that <math|<d><rsub|1><around|(|A|)>\<divides\><a>\<divides\><d><rsub|2><around|(|A|)>>.
    Choose an <math|a\<in\><a>> satisfying
    <math|a*+<d><rsub|2><around|(|A|)>=<a>> (possible since
    <math|<a>\<divides\><d><rsub|2><around|(|A|)>> and <math|> is a Dedekind
    domain), let <math|<q>=<a><rsup|-1>a> as well as
    <math|<b>=<a><rsup|-1><d><rsub|2><around|(|A|)>>, and choose a
    transversal <math|T> of <math|<q>/<q><b>>. Then the number
    <math|\<mu\><rsub|<a>><around|(|A|)>> of right cosets in <math|U*A*U>
    with <math|<a>> as g.<space|0.17em>c.<space|0.17em>d. of the first column
    can be calculated by

    <\equation*>
      \<mu\><rsub|<a>><around|(|A|)>=<tabs|<around|{|c\<in\>T<space|0.22em>\|<space|0.22em><a>+<around|(|c-1|)>*+c<q><rsup|-1><b>=<d><rsub|1><around|(|A|)>|}>>.
    </equation*>
  </corollary>

  <\proof>
    Since <math|<a>=a*+<d><rsub|2><around|(|A|)>=<a><q>+<a><b>>, the ideals
    <math|<q>> and <math|<b>> are relatively prime, which yields
    <math|\<cap\>a<d><rsub|2><around|(|A|)><rsup|-1>=\<cap\><q><b><rsup|-1>=<q>>
    as well as <math|<d><rsub|2><around|(|A|)>*a<rsup|-1>\<cap\>a<d><rsub|2><around|(|A|)><rsup|-1>=<b><q><rsup|-1>\<cap\><q><b><rsup|-1>=<b><q>>.
    Thus <math|T> is a transversal of <math|<around|(|\<cap\>a<d><rsub|2><around|(|A|)><rsup|-1>|)>/<around|(|<d><rsub|2><around|(|A|)>*a<rsup|-1>\<cap\>a<d><rsub|2><around|(|A|)><rsup|-1>|)>>.

    If <math|U*B> for some <math|B\<in\>I> is a right coset in <math|U*A*U>
    satisfying <math|<g><around|(|B|)>=<a>>, then in particular
    <math|<d><rsub|2><around|(|B|)>=<d><rsub|2><around|(|A|)>>, and according
    to Lemma <reference|normalform> there exists a uniquely determined
    representative <math|C> of <math|U*B> of the form described in that Lemma
    (with <math|b=det A> and <math|c\<in\>T>, the latter according to the
    first paragraph of this proof). Thus

    <align*|<tformat|<table|<row|<cell|>|<cell|<around|{|U*B<space|0.22em>\|<space|0.22em>B\<in\>I<text|with
    ><g><around|(|B|)>=<a><text|and >U*B\<subseteq\>U*A*U|}>>>|<row|<cell|>|<cell|=<around*|{|U*B<space|0.22em><mid|\|><space|0.22em>B=<matr|a|c-1|det
    A|<around|(|det A|)>*a<rsup|-1>*c><text|for some >c\<in\>T*<text|and
    >B\<in\>U*A*U|}>,>>>>>

    and since <math|<d><rsub|2><around|(|B|)>=<d><rsub|2><around|(|A|)>> for
    those <math|B>, Theorem <reference|dcequal> and
    <math|a*+<d><rsub|2><around|(|A|)>=<a>> yield

    <align*|<tformat|<table|<row|<cell|\<mu\><rsub|<a>><around|(|A|)>>|<cell|=<abs|<around*|{|c\<in\>T<space|0.22em><mid|\|><space|0.22em><d><rsub|1><around*|(|<matr|a|c-1|det
    A|<around|(|det A|)>*a<rsup|-1>*c>|)>=<d><rsub|1><around|(|A|)>|}>>>>|<row|<cell|>|<cell|=<tabs|<around|{|c\<in\>T<space|0.22em>\|<space|0.22em><a>+<around|(|c-1|)>*+c<q><rsup|-1><b>=<d><rsub|1><around|(|A|)>|}>>.>>>>>
  </proof>

  The formula presented in Corollary <reference|elemmua> is only a first step
  since it is not very far from a mere enumeration of right cosets. The next
  step is the establishment of a product formula for the cardinality on the
  right-hand side. To achieve this, we first need some auxiliary results.

  <\lemma>
    <label|chardiv>In the setting of Corollary <reference|elemmua> the
    following assertions are equivalent:

    <\enumerate>
      <item><math|<c>\<divides\><a>+<around|(|c-1|)>*+c<q><rsup|-1><b>>.

      <item><math|<c>\<divides\><a>> and <math|<a><c>\<divides\><d><rsub|2><around|(|A|)>>
      and <math|<c>\<divides\>c-1>.
    </enumerate>
  </lemma>

  <\proof>
    First assume that (i) is satisfied and show that (ii) is fulfilled. Since
    (i) implies <math|<c>\<divides\><around|(|c-1|)>*+c<q><rsup|-1><b>> and
    <math|c> and <math|c-1> are relatively prime, we have
    <math|<c>\<divides\><q><rsup|-1><b>> and thus
    <math|<a><c>\<divides\><a><q><rsup|-1><b>=a<rsup|-1><a><d><rsub|2><around|(|A|)>>,
    which implies <math|<a><c>\<divides\><d><rsub|2><around|(|A|)>> since
    <math|a\<in\><a>>. The remaining parts of (ii) follow obviously.

    Now assume that (ii) is fulfilled. For the proof of (i) it remains to
    show <math|<c>\<divides\>c<q><rsup|-1><b>>. But this follows from
    <math|<a><c>\<divides\><d><rsub|2><around|(|A|)>> and <math|c\<in\><q>>
    since the latter implies <math|<c>\<divides\><a><rsup|-1><d><rsub|2><around|(|A|)>=<b>>
    and <math|c<q><rsup|-1>\<subseteq\>>, so the proof is complete.
  </proof>

  The second auxiliary result gives an explicit formula for the cardinality
  of a certain subset of <math|T> needed in the calculation of
  <math|\<mu\><rsub|<a>><around|(|A|)>>.

  <\lemma>
    <label|tnorm>In the setting of Corollary <reference|elemmua> we have

    <\equation*>
      <tabs|<around|{|c\<in\>T<space|0.22em>\|<space|0.22em>c-1\<in\><c>|}>>=<NN><around|(|<b>|)><NN><around|(|<c>|)><rsup|-1>
    </equation*>

    for every ideal <math|<c>> of <math|> satisfying
    <math|<c>\<divides\><a>\<divides\><d><rsub|2><around|(|A|)><c><rsup|-1>>.
  </lemma>

  <\proof>
    In the given setting we have <math|<c>\<divides\><b>>, and <math|<b>> and
    <math|<q>> are relatively prime, so <math|<c>> and <math|<q>> are
    relatively prime. By the Chinese Remainder Theorem there exists a
    <math|d\<in\><q>\<cap\><around|(|<c>+1|)>>. Then
    <math|<around|{|c-d<space|0.22em>\|<space|0.22em>c\<in\>T,<space|0.27em>c-1\<in\><c>|}>>
    is a transversal of <math|<c><q>/<b><q>>: All those <math|c-d> are
    elements of <math|<c>\<cap\><q>=<c><q>>, the
    <math|<around|(|c-d|)>+<b><q>> are pairwise different since <math|T> is a
    transversal of <math|<q>/<b><q>>, and for every <math|x\<in\><c><q>>
    there exists a <math|c\<in\>T> satisfying
    <math|x\<in\><around|(|c-d|)>+<b><q>>, namely the one satisfying
    <math|x+d\<in\>c+<b><q>>, which exists in <math|T> since
    <math|x+d\<in\><q>> and is an element of
    <math|<around|{|c\<in\>T<space|0.22em>\|<space|0.22em>c-1\<in\><c>|}>>
    since <math|x+d\<in\>c+<b><q>\<subseteq\>c+<c>> and thus
    <math|c-1\<in\>x+<around|(|d-1|)>+<c>=<c>>. Now the definition and the
    multiplicity of the norm yields <math|<tabs|<around|{|c\<in\>T<space|0.22em>\|<space|0.22em>c-1\<in\><c>|}>>=<tabs|<c><q>/<b><q>>=<NN><around|(|<b>|)><NN><around|(|<c>|)><rsup|-1>>.
  </proof>

  Now we are prepared to prove a product formula for
  <math|\<mu\><rsub|<a>><around|(|A|)>>.

  <\theorem>
    <label|tmua>Let <math|A\<in\>I> and <math|<a>> be an ideal in <math|>.
    If <math|<d><rsub|1><around|(|A|)>\<divides\><a>\<divides\><d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1>>,
    then

    <\equation*>
      \<mu\><rsub|<a>><around|(|A|)>=<frac|<NN><around|(|<d><rsub|2><around|(|A|)>|)>|<NN><around|(|<a>|)><NN><around|(|<d><rsub|1><around|(|A|)>|)>>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<p><text|prime
      ideal>>>|<row|<cell|<p>\<divides\><a><d><rsub|1><around|(|A|)><rsup|-1>+<d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1><a><rsup|-1>>>>>>><around|(|1-<NN><around|(|<p>|)><rsup|-1>|)>,
    </equation*>

    otherwise, <math|\<mu\><rsub|<a>><around|(|A|)>=0> holds.
  </theorem>

  <\proof>
    If <math|\<mu\><rsub|<a>><around|(|A|)>\<gtr\>0>, then there exists a
    <math|B\<in\>U*A*U> having <math|<a>> as
    g.<space|0.17em>c.<space|0.17em>d. of the first column. Then
    <math|<d><rsub|1><around|(|A|)>=<d><rsub|1><around|(|B|)>\<divides\><a>>
    and <math|<a>\<divides\><d><rsub|2><around|(|B|)>=<d><rsub|2><around|(|A|)>>,
    so Corollary <reference|elemmua> is applicable. Thus, using the notation
    introduced in Corollary <reference|elemmua>, there exists a
    <math|c\<in\>T> satisfying <math|<a>+<around|(|c-1|)>*+c<q><rsup|-1><b>=<d><rsub|1><around|(|A|)>>.
    So Lemma <reference|chardiv> implies <math|<a><d><rsub|1><around|(|A|)>\<divides\><d><rsub|2><around|(|A|)>>,
    which shows that <math|<a>\<divides\><d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1>>
    is necessary for <math|\<mu\><rsub|<a>><around|(|A|)>\<gtr\>0>. Thus it
    is proved that <math|\<mu\><rsub|<a>><around|(|A|)>=0> if
    <math|<d><rsub|1><around|(|A|)>\<divides\><a>\<divides\><d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1>>
    does not hold.

    In the following assume <math|<d><rsub|1><around|(|A|)>\<divides\><a>\<divides\><d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1>>.
    Denote by <math|<QQ>> the set of all prime ideals of <math|> dividing
    <math|<d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-2>>, let
    <math|M=<around|{|c\<in\>T<space|0.22em>\|<space|0.22em><a>+<around|(|c-1|)>*+c<q><rsup|-1><b>=<d><rsub|1><around|(|A|)>|}>>
    and <math|M<around|(|<c>|)>=<around|{|c\<in\>T<space|0.22em>\|<space|0.22em><c><text|divides
    ><a>+<around|(|c-1|)>*+c<q><rsup|-1><b>|}>> for all ideals <math|<c>> of
    <math|>. By the inclusion-exclusion principle we then have

    <\equation*>
      <tabs|M>=<big|sum><rsub|<MM>\<subseteq\><QQ>>(-1)<rsup|<tabs|<MM>>><abs|M*<around*|(|<d><rsub|1><around|(|A|)>*<big|prod><rsub|<q>\<in\><MM>><q>|)>>.
    </equation*>

    If for a product <math|<q><rprime|'>> of pairwise distinct prime ideals
    <math|<d><rsub|1><around|(|A|)><q><rprime|'>\<divides\><a>\<divides\><d><rsub|2><around|(|A|)><around|(|<d><rsub|1><around|(|A|)><q><rprime|'>|)><rsup|-1>>
    does not hold, then for <math|<c>=<d><rsub|1><around|(|A|)><q><rprime|'>>
    the first or the second condition in Lemma
    <reference|chardiv><space|0.17em>(ii) is violated, which implies
    <math|<tabs|M<around|(|<c>|)>>=0>. Since
    <math|<d><rsub|1><around|(|A|)><q><rprime|'>\<divides\><a>\<divides\><d><rsub|2><around|(|A|)><around|(|<d><rsub|1><around|(|A|)><q><rprime|'>|)><rsup|-1>>
    is equivalent to <math|<q><rprime|'>\<divides\><a><d><rsub|1><around|(|A|)><rsup|-1>>
    and <math|<q><rprime|'>\<divides\><d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1><a><rsup|-1>>,
    in the above formula <math|<QQ>> can be replaced by <math|<QQ><rprime|'>>
    where <math|<QQ><rprime|'>> denotes the set of all prime ideals of
    <math|> dividing <math|<a><d><rsub|1><around|(|A|)><rsup|-1>+<d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1><a><rsup|-1>>.
    In the case that <math|<q><rprime|'>> is a product of pairwise distinct
    prime ideals in <math|<QQ><rprime|'>>, the condition
    <math|<d><rsub|1><around|(|A|)><q><rprime|'>\<divides\><a>\<divides\><d><rsub|2><around|(|A|)><around|(|<d><rsub|1><around|(|A|)><q><rprime|'>|)><rsup|-1>>
    is satisfied, and Lemma <reference|chardiv> and Lemma <reference|tnorm>
    yield <math|M<around|(|<d><rsub|1><around|(|A|)><q><rprime|'>|)>=<tabs|<around|{|c\<in\>T<space|0.22em>\|<space|0.22em><d><rsub|1><around|(|A|)><q><rprime|'><text|divides
    >c-1|}>>=<NN><around|(|<b>|)><NN><around|(|<d><rsub|1><around|(|A|)><q><rprime|'>|)><rsup|-1>>.
    Plugging this into the above formula and using the multiplicity of the
    norm and the distributive law we obtain

    <align*|<tformat|<table|<row|<cell|<tabs|M>>|<cell|=<frac|<NN><around|(|<b>|)>|<NN><around|(|<d><rsub|1><around|(|A|)>|)>>*<big|sum><rsub|<MM>\<subseteq\><QQ><rprime|'>>(-1)<rsup|<tabs|<MM>>><NN><around*|(|<big|prod><rsub|<q>\<in\><MM>><q>|)><rsup|-1>=<frac|<NN><around|(|<b>|)>|<NN><around|(|<d><rsub|1><around|(|A|)>|)>>*<big|sum><rsub|<MM>\<subseteq\><QQ><rprime|'>><big|prod><rsub|<q>\<in\><MM>>(-<NN><around|(|<q>|)><rsup|-1>)>>|<row|<cell|>|<cell|=<frac|<NN><around|(|<b>|)>|<NN><around|(|<d><rsub|1><around|(|A|)>|)>>*<big|prod><rsub|<q>\<in\><QQ><rprime|'>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>.>>>>>

    Since <math|<tabs|M>=\<mu\><rsub|<a>><around|(|A|)>> according to
    Corollary <reference|elemmua> and <math|<b>=<d><rsub|2><around|(|A|)><a><rsup|-1>>,
    the proof is complete.
  </proof>

  The just proved formula will be applied in the following

  <\example>
    Let <math|=<Z>> and <math|A=<tmatr|1|0|0|4>> as well as <math|<a>=2<Z>>.
    Theorem <reference|tmua> then yields

    <\equation*>
      \<mu\><rsub|<a>><around|(|A|)>=<frac|<NN><around|(|4<Z>|)>|<NN><around|(|2<Z>|)><NN><around|(|<Z>|)>>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<p><text|prime
      ideal>>>|<row|<cell|<p>\<divides\>2<Z>>>>>>><around|(|1-<NN><around|(|<p>|)><rsup|-1>|)>=<frac|4|2\<cdot\>1>*<around*|(|1-<frac|1|2>|)>=1,
    </equation*>

    which corresponds to the results of Example <reference|exz>, where we had
    exactly one representative of type <math|<tmatr|2|\<ast\>|0|\<ast\>>>,
    namely <math|<tmatr|2|1|0|2>>.
  </example>

  Since Theorem <reference|tmua> is just an intermediate result, more
  interesting cases than <math|=<Z>> will not be discussed at this point.

  The formula for <math|\<mu\><rsub|<a>><around|(|A|)>> given in Theorem
  <reference|tmua> has several applications. Later we will see how it can be
  used to prove a reduction theorem in the context of Hecke algebras, but for
  now we will stick to the already announced goal of a formula for the number
  of right cosets contained in a given double coset.

  <\theorem>
    <label|rcindc>Let <math|A\<in\>I>. Then

    <\equation*>
      \<mu\><around|(|A|)>=<NN><around|(|<f><rsub|2><around|(|A|)>|)>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<p><text|prime
      ideal>>>|<row|<cell|<p>\<divides\><f><rsub|2><around|(|A|)>>>>>>><around|(|1+<NN><around|(|<p>|)><rsup|-1>|)>.
    </equation*>
  </theorem>

  <\proof>
    To calculate <math|\<mu\><around|(|A|)>>, we have to sum over all
    <math|\<mu\><rsub|<a>><around|(|A|)>>. Then we use Theorem
    <reference|tmua> and rewrite the obtained sum to use
    <math|<a><rprime|'>=<d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1><a><rsup|-1>>
    as summation index:

    <align*|<tformat|<table|<row|<cell|\<mu\><around|(|A|)>>|<cell|=<big|sum><rsub|<a><text|ideal
    in >>\<mu\><rsub|<a>><around|(|A|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|<d><rsub|1><around|(|A|)>\<divides\><a>\<divides\><d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1>><frac|<NN><around|(|<d><rsub|2><around|(|A|)>|)>|<NN><around|(|<a>|)><NN><around|(|<d><rsub|1><around|(|A|)>|)>>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<p><text|prime
    ideal>>>|<row|<cell|<p>\<divides\><a><d><rsub|1><around|(|A|)><rsup|-1>+<d><rsub|2><around|(|A|)><d><rsub|1><around|(|A|)><rsup|-1><a><rsup|-1>>>>>>><around|(|1-<NN><around|(|<p>|)><rsup|-1>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|\<divides\><a><rprime|'>\<divides\><f><rsub|2><around|(|A|)>><NN><around|(|<a><rprime|'>|)>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<q><text|prime
    ideal>>>|<row|<cell|<q>\<divides\><around|(|<a><rprime|'>|)><rsup|-1><f><rsub|2><around|(|A|)>+<a><rprime|'>>>>>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>.>>>>>

    Using this equality, we can prove the theorem by showing that

    <\equation*>
      S<around|(|<b>|)>\<assign\><big|sum><rsub|\<divides\><a>\<divides\><b>><NN><around|(|<a>|)>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<q><text|prime
      ideal>>>|<row|<cell|<q>\<divides\><a><rsup|-1><b>+<a>>>>>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>=<NN><around|(|<b>|)>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<q><text|prime
      ideal>>>|<row|<cell|<q>\<divides\><b>>>>>>><around|(|1+<NN><around|(|<q>|)><rsup|-1>|)>
    </equation*>

    holds for every ideal <math|<b>> in <math|> (since
    <math|<b>=<f><rsub|2><around|(|A|)>> yields the assertion). We carry out
    an induction on the number of prime ideals dividing <math|<b>>. The
    initial case <math|<b>=> is obvious, so we now assume that there exists
    a prime ideal <math|<p>> which divides <math|<b>>. Write
    <math|<b>=<p><rsup|m><r>> with <math|<p>\<ndivides\><r>>. Analogously
    split up every <math|<a>> as product of a power of <math|<p>> and a rest
    not divided by <math|<p>>. Introducing the set <math|<QQ><rsub|<c>>> of
    prime ideals dividing <math|<c><rsup|-1><b>+<c>>, we then have

    <\equation*>
      S<around|(|<b>|)>=<big|sum><rsub|\<divides\><a>\<divides\><b>><NN><around|(|<a>|)>*<big|prod><rsub|<q>\<in\><QQ><rsub|<a>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>=<big|sum><rsub|k=0><rsup|m><big|sum><rsub|\<divides\><c>\<divides\><r>><NN><around|(|<p><rsup|k><c>|)>*<big|prod><rsub|<q>\<in\><QQ><rsub|<p><rsup|k><c>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>.
    </equation*>

    If <math|<p>\<ndivides\><c>> and <math|<q>> is a prime ideal in <math|>,
    the definition of <math|<QQ><rsub|<p><rsup|k><c>>> yields

    <\equation*>
      <q>\<in\><QQ><rsub|<p><rsup|k><c>><space|1em>\<Leftrightarrow\><space|1em><around|(|<q>=<p><text|and
      >1\<leq\>k\<less\>m|)>*<text|or ><around|(|<q>\<neq\><p><text|and
      ><q>\<in\><QQ><rsub|c>|)>.
    </equation*>

    Using this equivalence in the above expression for
    <math|S<around|(|<b>|)>>, by splitting up the outer sum we obtain

    <align*|<tformat|<table|<row|<cell|S<around|(|<b>|)>=>|<cell|<big|sum><rsub|k=1><rsup|m-1><big|sum><rsub|\<divides\><c>\<divides\><r>><NN><around|(|<p>|)><rsup|k><NN><around|(|<c>|)>*<around|(|1-<NN><around|(|<p>|)><rsup|-1>|)>*<big|prod><rsub|<q>\<in\><QQ><rsub|<c>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>>>|<row|<cell|>|<cell|+<big|sum><rsub|\<divides\><c>\<divides\><r>><NN><around|(|<c>|)>*<big|prod><rsub|<q>\<in\><QQ><rsub|<c>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>+<big|sum><rsub|\<divides\><c>\<divides\><r>><NN><around|(|<p>|)><rsup|m><NN><around|(|<c>|)>*<big|prod><rsub|<q>\<in\><QQ><rsub|<c>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>.>>>>>

    Since the double sum on the right hand side is a telescoping sum, the
    equation simplifies to

    <align*|<tformat|<table|<row|<cell|S<around|(|<b>|)>>|<cell|=<big|sum><rsub|\<divides\><c>\<divides\><r>><NN><around|(|<p>|)><rsup|m-1><NN><around|(|<c>|)>*<big|prod><rsub|<q>\<in\><QQ><rsub|<c>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>+<big|sum><rsub|\<divides\><c>\<divides\><r>><NN><around|(|<p>|)><rsup|m><NN><around|(|<c>|)>*<big|prod><rsub|<q>\<in\><QQ><rsub|<c>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>>>|<row|<cell|>|<cell|=<NN><around|(|<p>|)><rsup|m>*<around|(|1+<NN><around|(|<p>|)><rsup|-1>|)>*<big|sum><rsub|\<divides\><c>\<divides\><r>><NN><around|(|<c>|)>*<big|prod><rsub|<q>\<in\><QQ><rsub|<c>>><around|(|1-<NN><around|(|<q>|)><rsup|-1>|)>>>|<row|<cell|>|<cell|=<NN><around|(|<p>|)><rsup|m>*<around|(|1+<NN><around|(|<p>|)><rsup|-1>|)>*S<around|(|<r>|)>.>>>>>

    Applying the induction hypothesis, we have

    <align*|<tformat|<table|<row|<cell|S<around|(|<b>|)>>|<cell|=<NN><around|(|<p>|)><rsup|m>*<around|(|1+<NN><around|(|<p>|)><rsup|-1>|)>*S<around|(|<r>|)>=<NN><around|(|<p>|)><rsup|m>*<around|(|1+<NN><around|(|<p>|)><rsup|-1>|)><NN><around|(|<r>|)>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<q><text|prime
    ideal>>>|<row|<cell|<q>\<divides\><r>>>>>>><around|(|1+<NN><around|(|<q>|)><rsup|-1>|)>>>|<row|<cell|>|<cell|=<NN><around|(|<b>|)>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<q><text|prime
    ideal>>>|<row|<cell|<q>\<divides\><b>>>>>>><around|(|1+<NN><around|(|<q>|)><rsup|-1>|)>,>>>>>

    which completes the proof.
  </proof>

  In the following examples Theorem <reference|rcindc> is applied in a case
  where <math|> is not a principal ideal domain.

  <\examples>
    <label|exmu>Let <math|=<Z>+<Z>\<omega\>> where
    <math|\<omega\>=<sqrt|-5>> and <math|A=<tmatr|1|0|0|3>>. Since
    <math|3*=<p><rsub|1><p><rsub|2>> with
    <math|<p><rsub|1>=3*+<around|(|\<omega\>+1|)>*> and
    <math|<p><rsub|2>=3*+<around|(|\<omega\>+2|)>*>, where
    <math|<p><rsub|1>> and <math|<p><rsub|2>> are prime ideals of norm
    <math|3> in <math|>, Theorem <reference|rcindc> yields

    <\equation*>
      \<mu\><around|(|A|)>=<NN><around|(|3*|)>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<p><text|prime
      ideal>>>|<row|<cell|<p>\<divides\>3*>>>>>><around|(|1+<NN><around|(|<p>|)><rsup|-1>|)>=9*<around*|(|1+<frac|1|3>|)>*<around*|(|1+<frac|1|3>|)>=16.
    </equation*>

    Since <math|2*> has the prime ideal decomposition
    <math|<around|(|2*+<around|(|\<omega\>+1|)>*|)><rsup|2>>, one similarly
    obtains <math|\<mu\><around|(|<tmatr|1|0|0|2>|)>=6>. Possible choices for
    the six representatives are calculated in Example <reference|exdecomp>.

    The above examples can be generalised: If <math|> is a quadratic number
    field and <math|p> a rational prime, we have
    <math|\<mu\><around|(|<tmatr|1|0|0|p>|)>=<around|(|p+1|)><rsup|2>> if
    <math|p> is split and <math|\<mu\><around|(|<tmatr|1|0|0|p>|)>=p*<around|(|p+1|)>>
    otherwise.
  </examples>

  To complete this section, already existing results similar to Theorem
  <reference|rcindc> are shortly reviewed in the following

  <\remark>
    In the case <math|=<Z>> we have a so called rationality theorem for
    abstract Hecke algebras with respect to unimodular groups (see
    e.<space|0.17em>g. <cite|Krieg:Hecke> Theorem V<space|0.17em>(9.3)). The
    proof of this theorem uses the fact that the double coset
    <math|<GL><rsub|n><around|(|<Z>|)>*P<rsub|j><GL><rsub|n><around|(|<Z>|)>>
    where <math|P<rsub|j>> is a diagonal matrix with <math|j> diagonal
    entries equal to <math|p> (for a fixed rational prime <math|p>) and the
    other diagonal entries equal to <math|1> decomposes into exactly

    <\equation*>
      p<rsup|-<frac|j*<around|(|j+1|)>|2>>*<big|sum><rsub|1\<leq\>v<rsub|1>\<less\>\<cdots\>\<less\>v<rsub|j>\<leq\>n>p<rsup|v<rsub|1>+\<cdots\>+v<rsub|j>>
    </equation*>

    right cosets with respect to <math|<GL><rsub|n><around|(|<Z>|)>>. (One
    easily checks that for <math|n=2> and <math|j\<in\><around|{|0,1,2|}>>
    this yields the same values for <math|\<mu\><around|(|P<rsub|j>|)>> as
    Theorem <reference|rcindc>.)

    Another similar theorem does not count right cosets in double cosets but
    right cosets in the set of all matrices with the same determinant (modulo
    units). According to <cite|Newman:Integral> Theorem II.4, the set
    <math|<around|{|A\<in\><rsup|n\<times\>n><space|0.22em>\|<space|0.22em>det
    A\<in\>d*<rsup|\<ast\>>|}>> decomposes into exactly

    <\equation*>
      <big|prod><rsub|<stack|<tformat|<table|<row|<cell|p\<in\>P>>|<row|<cell|p\<divides\>d>>>>>><big|prod><rsub|j=1><rsup|n-1><frac|<NN><around|(|p|)><rsup|<v><rsub|p*><around|(|d|)>+j>-1|<NN><around|(|p|)><rsup|j>-1>
    </equation*>

    right cosets with respect to <math|<GL><rsub|n><around|(||)>> (where
    <math|P> denotes a system of representatives of prime elements in
    <math|> modulo <math|<rsup|\<ast\>>>).
  </remark>

  <section|Applications to congruence subgroups><label|applcong>

  In this section, an application of Theorem <reference|rcindc> to the
  calculation of indexes of certain congruence subgroups is presented.

  <\corollary>
    <label|congindex>Let <math|m\<in\>> with <math|m\<neq\>0> and
    <math|U<rsup|0><around|[|m|]>=<around|{|<tmatr|a|b|c|d>\<in\>U<space|0.22em>\|<space|0.22em>b\<in\>m*|}>>.
    Then the index of <math|U<rsup|0><around|[|m|]>> in <math|U> can be
    calculated by

    <\equation*>
      <around|[|U:U<rsup|0><around|[|m|]>|]>=<NN><around|(|m*|)>*<big|prod><rsub|<stack|<tformat|<table|<row|<cell|<p><text|prime
      ideal>>>|<row|<cell|<p>\<divides\>m>>>>>><around|(|1+<NN><around|(|<p>|)><rsup|-1>|)>.
    </equation*>
  </corollary>

  <\proof>
    Let <math|A=<tmatr|1|0|0|m>>. A simple calculation using
    <math|A<tmatr|a|b|c|d>A<rsup|-1>=<tmatr|a|m<rsup|-1>*b|m*c|d>> shows that
    <math|U\<cap\>A<rsup|-1>*U*A=U<rsup|0><around|[|m|]>>. Since
    <math|<around|[|U:U\<cap\>A<rsup|-1>*U*A|]>=\<mu\><around|(|A|)>> (see
    e.<space|0.17em>g. <cite|Andrianov:Quadratic> Lemma 3.1.2), the assertion
    immediately follows from Theorem <reference|rcindc>.
  </proof>

  <\remark>
    Corollary <reference|congindex> generalises a similar formula for the
    index of congruence subgroups in <math|<math-up|SL><rsub|2><around|(|<Z>|)>>
    which is of interest in the theory of modular forms (see
    e.<space|0.17em>g. <cite|Diamond:First> Section 1.2). However, such index
    formulae are studied also in other contexts (see e.<space|0.17em>g.
    <cite|Appel:Index>).
  </remark>

  <section|Applications to Hecke algebras><label|applhecke>

  As it has already been mentioned, Theorem <reference|rcindc> has been
  developed with the theory of Hecke algebras in mind. The applications in
  this field will be presented here.

  Denote by <math|H> the complex vector space spanned by
  <math|<around|{|1<rsub|U*A*U><space|0.22em>\|<space|0.22em>A\<in\>I|}>>
  where <math|1<rsub|M>:G\<to\><around|{|0,1|}>> is the characteristic
  function of the set <math|M>. For <math|A,A<rsub|1>,\<ldots\>,A<rsub|k>,B,B<rsub|1>,\<ldots\>,B<rsub|m>\<in\>I>
  with <math|U*A*U=U*A<rsub|1>\<cup\>\<cdots\>\<cup\>U*A<rsub|k>> and
  <math|U*B*U=U*B<rsub|1>\<cup\>\<cdots\>\<cup\>U*B<rsub|m>> where the unions
  are pairwise disjoint define

  <\equation*>
    1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>=<big|sum><rsub|k=1><rsup|k><big|sum><rsub|j=1><rsup|m>1<rsub|U*A<rsub|i>*B<rsub|j>>
  </equation*>

  and extend this operation bilinearly to a (well-defined(!)) operation on
  <math|H>. The obtained algebra is called an (abstract) Hecke algebra; for
  details see e.<space|0.17em>g. <cite|Krieg:Hecke>. The formula

  <\equation*>
    <around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|C|)>=<tabs|<around|{|<around|(|i,j|)><space|0.22em>\|<space|0.22em>A<rsub|i>*B<rsub|j>\<in\>U*C,<space|0.27em>1\<leq\>i\<leq\>k,<space|0.27em>1\<leq\>j\<leq\>m|}>>,
  </equation*>

  which can be found in <cite|Krieg:Hecke> I.4.4, immediately yields an
  algorithm for the calculation of <math|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>>.

  <\algorithm>
    <label|algprod>input: <math|A,B\<in\>I>; output: <math|D\<subseteq\>I>
    and <math|c<rsub|C>\<in\><N>> for every <math|C\<in\>D> such that

    <\equation*>
      1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>=<big|sum><rsub|C\<in\>D>c<rsub|C>*1<rsub|U*C*U>
    </equation*>

    <\enumerate>
      <item>Decompose <math|U*A*U> and <math|U*B*U> into pairwise disjoint
      right cosets <math|U*A<rsub|1>,\<ldots\>,U*A<rsub|k>> and
      <math|U*B<rsub|1>,\<ldots\>,U*B<rsub|m>>, respectively.

      <item>Let <math|D=\<emptyset\>>.

      <item>For every pair <math|<around|(|i,j|)>> with
      <math|1\<leq\>i\<leq\>k> and <math|1\<leq\>j\<leq\>m> test whether
      there exists a <math|C<rprime|'>\<in\>D> with
      <math|U*A<rsub|i>*B<rsub|j>*U=U*C<rprime|'>*U>; if this is not the
      case, add the element <math|A<rsub|i>*B<rsub|j>> to <math|D> and set
      <math|c<rsub|A<rsub|i>*B<rsub|j>>=1>; otherwise, if additionally
      <math|U*C<rprime|'>=U*A<rsub|i>*B<rsub|j>> is fulfilled, increase
      <math|c<rsub|C<rprime|'>>> by <math|1>.
    </enumerate>
  </algorithm>

  For the execution of this algorithm, a right coset decomposition of
  <math|U*A*U> and <math|U*B*U> has to be constructed explicitly in step (1).
  Using Theorem <reference|rcindc> we can give an algorithm that carries out
  this task.

  <\algorithm>
    <label|algdecomp>input: <math|A\<in\>I> and an enumeration
    <math|<around|(|Q<rsub|n>|)><rsub|n\<in\><N>>> of <math|U>; output: right
    transversal <math|R> of <math|U\<setminus\>U*A*U>

    <\enumerate>
      <item>Calculate <math|k=\<mu\><around|(|A|)>> (using Theorem
      <reference|rcindc>).

      <item>Set <math|R=<around|{|A|}>> and <math|n=1>.

      <item><label|loop> If there exists no <math|B\<in\>R> with
      <math|U*A*Q<rsub|n>=U*B>, add the element <math|A*Q<rsub|n>> to
      <math|R>.

      <item>If <math|<tabs|R>\<less\>k>, increase <math|n> by <math|1> and go
      back to (<reference|loop>), otherwise stop.
    </enumerate>
  </algorithm>

  <\remark>
    <label|rrestrict>In order to implement Algorithm <reference|algdecomp>,
    we have to enumerate all elements of <math|U>, which might not be
    feasible. To avoid this problem, one can use random elements instead of
    enumerated elements for <math|Q<rsub|n>>. Then Algorithm
    <reference|algdecomp> is turned into a probabilistic algorithm which
    produces the desired output if it terminates. The remaining problem of
    the generation of random unimodular matrices will not be discussed here
    but is delegated to SAGE (<cite|SAGE>).
  </remark>

  Using Algorithm <reference|algdecomp> and Remark <reference|rrestrict>, we
  can calculate some

  <\examples>
    <label|exdecomp>Let <math|=<Z>+<Z>\<omega\>> for
    <math|\<omega\>=<sqrt|-5>>. For <math|A=<tmatr|1|0|0|2>> the
    probabilistic decomposition algorithm terminates after an average of
    <math|14> loop cycles and yields for example

    <\equation*>
      <around*|{|<matr|1|0|0|2>,<matr|1|1|0|2>,<matr|1|\<omega\>|0|2>,<matr|1|1+\<omega\>|0|2>,<matr|2|0|0|1>,<matr|2|0|1+\<omega\>|1>|}>
    </equation*>

    as a system of representatives of <math|U\<setminus\>U*A*U> (with
    <math|6> elements according to Examples <reference|exmu>). With this
    transversal it is then possible to use Algorithm <reference|algprod> to
    calculate <math|1<rsub|U*A*U>\<ast\>1<rsub|U*A*U>>; one obtains

    <\equation*>
      1<rsub|U*A*U>\<ast\>1<rsub|U*A*U>=1<rsub|U*A<rsub|1>*U>+6\<cdot\>1<rsub|U*A<rsub|2>*U>+1<rsub|U*A<rsub|3>*U>
    </equation*>

    with <math|A<rsub|1>=<tmatr|1|0|0|4>> and
    <math|A<rsub|2>=<tmatr|2|0|0|2>> as well as
    <math|A<rsub|3>=<tmatr|2|1+\<omega\>|0|2>>.

    In order to obtain a feeling for the complexity of the decomposition
    algorithm (a detailed analysis has to take into account the strategy for
    choosing the elements of <math|U> and will not be carried out in this
    paper), we execute this algorithm for some more <math|A> and obtain the
    following table:

    <\equation*>
      <assign|arraystretch|<macro|1.3>><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|r>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|5|5|cell-rborder|0ln>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|8|8|1|-1|cell-bborder|1ln>|<table|<row|<cell|A>|<cell|<d><rsub|1><around|(|A|)>>|<cell|<d><rsub|2><around|(|A|)>>|<cell|\<mu\><around|(|A|)>>|<cell|<text|avg.
      loop cycles>>>|<row|<cell|<tmatr|1|0|0|2>>|<cell|>|<cell|2*>|<cell|6>|<cell|14>>|<row|<cell|<tmatr|1|0|0|1+\<omega\>>>|<cell|>|<cell|<around|(|\<omega\>+1|)>*>|<cell|12>|<cell|39>>|<row|<cell|<tmatr|1|0|0|3>>|<cell|>|<cell|3*>|<cell|16>|<cell|53>>|<row|<cell|<tmatr|2|1|0|2>>|<cell|>|<cell|4*>|<cell|24>|<cell|110>>|<row|<cell|<tmatr|\<omega\>|1|0|\<omega\>>>|<cell|>|<cell|5*>|<cell|30>|<cell|130>>|<row|<cell|<tmatr|\<omega\>|1|1|2>>|<cell|>|<cell|<around|(|1+2*\<omega\>|)>*>|<cell|32>|<cell|124>>|<row|<cell|<tmatr|\<omega\>|0|0|2>>|<cell|>|<cell|2*\<omega\>*>|<cell|36>|<cell|171>>>>>
    </equation*>
  </examples>

  Theorem <reference|rcindc> can not only be used for algorithmic
  calculations in Hecke algebras; it has an application in the proof of a
  theoretical result on abstract Hecke algebras, too. In the \Pclassic\Q
  Hecke algebra <math|H<rsub|n>> related to
  <math|<GL><rsub|n><around|(|<Z>|)>>, certain products in <math|H<rsub|n>>
  can be reduced to products in <math|H<rsub|n-1>> (see e.<space|0.17em>g.
  <cite|Krieg:Hecke> Lemma V<space|0.17em>(8.3)). In the case <math|n=2>, the
  presented result yields a lemma which then leads to a generalisation of
  this reduction theorem to Hecke algebras related to arbitrary norm-finite
  Dedekind domains.

  <\lemma>
    <label|prodmuo>For all <math|f\<in\>H> define
    <math|\<mu\><rsub|><around|(|f|)>=<big|sum><rsub|A\<in\>R>f<around|(|A|)>\<cdot\>\<mu\><rsub|><around|(|A|)>>
    where <math|R> is a system of representatives of <math|U\<setminus\>I/U>.
    Then <math|\<mu\><rsub|>*<around|(|f\<ast\>g|)>=\<mu\><rsub|><around|(|f|)>*\<mu\><rsub|><around|(|g|)>>
    for all <math|f,g\<in\>H>.
  </lemma>

  <\proof>
    By the definition of <math|\<mu\><rsub|>> and <math|\<ast\>> it suffices
    to prove the assertion for <math|f=1<rsub|U*A*U>> and
    <math|g=1<rsub|U*B*U>> where <math|A,B\<in\>I>. For <math|C\<in\>I> with
    <math|<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|C|)>\<neq\>0>
    we have <math|C\<in\>U*A*U*B*U> by the definition of <math|\<ast\>>, and
    <cite|Ensenbach:Determinantal> Theorem 3.1 yields
    <math|<d><rsub|1><around|(|A|)><d><rsub|1><around|(|B|)>\<divides\><d><rsub|1><around|(|C|)>>
    and thus <math|<d><rsub|1><around|(|A|)><d><rsub|1><around|(|B|)>\<divides\><g><around|(|C|)>>.
    This implies that in the case <math|<d><rsub|1><around|(|A|)>\<neq\>> or
    <math|<d><rsub|1><around|(|B|)>\<neq\>> both sides of the equation
    <math|\<mu\><rsub|>*<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)>=\<mu\><rsub|><around|(|1<rsub|U*A*U>|)>*\<mu\><rsub|><around|(|1<rsub|U*B*U>|)>>
    evaluate to zero, so it remains to analyse the case
    <math|<d><rsub|1><around|(|A|)>==<d><rsub|1><around|(|B|)>>. In this
    case let <math|A<rsub|1>,\<ldots\>,A<rsub|k>> and
    <math|B<rsub|1>,\<ldots\>,B<rsub|m>> be systems of representatives of
    <math|U\<setminus\>U*A*U> and <math|U\<setminus\>U*B*U>, respectively,
    where the <math|B<rsub|j>> with <math|<g><around|(|B<rsub|j>|)>=> have
    the form <math|<tmatr|1|\<ast\>|0|\<ast\>>> (without loss of generality
    due to Corollary <reference|unimodgen>). Let <math|1\<leq\>i\<leq\>k> and
    <math|1\<leq\>j\<leq\>m>. If <math|<g><around|(|B<rsub|j>|)>\<neq\>>,
    then <math|<g><around|(|A<rsub|i>*B<rsub|j>|)>\<neq\>> since the first
    column of <math|A<rsub|i>*B<rsub|j>> consists of linear combinations of
    entries of the first column of <math|B<rsub|j>>. If
    <math|<g><around|(|B<rsub|j>|)>=>, then the special structure of
    <math|B<rsub|j>> yields that the first column of
    <math|A<rsub|i>*B<rsub|j>> equals the first column of <math|A<rsub|i>>.
    So we have <math|<g><around|(|A<rsub|i>*B<rsub|j>|)>=> if and only if
    <math|<g><around|(|A<rsub|i>|)>=> and
    <math|<g><around|(|B<rsub|j>|)>=>. Since according to the definition of
    <math|\<mu\><rsub|>> and <math|\<ast\>> we have

    <\equation*>
      \<mu\><rsub|>*<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)>=<tabs|<around|{|<around|(|i,j|)><space|0.22em>\|<space|0.22em><g><around|(|A<rsub|i>*B<rsub|j>|)>=,<space|0.27em>1\<leq\>i\<leq\>k,<space|0.27em>1\<leq\>j\<leq\>m|}>>,
    </equation*>

    the just proved characterisation of <math|<g><around|(|A<rsub|i>*B<rsub|j>|)>=>
    used to split up the right hand side as product of two cardinalities
    yields the assertion.
  </proof>

  Now the desired reduction theorem can be stated and proved.

  <\theorem>
    <label|reduction>Let <math|a,b,c\<in\>> and <math|A=<tmatr|1|0|0|a>>,
    <math|B=<tmatr|1|0|0|b>> as well as <math|C=<tmatr|1|0|0|c>>. Then
    <math|<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|C|)>=1>, if
    <math|c\<in\>a*b*<rsup|\<ast\>>>, and
    <math|<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|C|)>=0>
    otherwise.
  </theorem>

  <\proof>
    With <math|R> as in Lemma <reference|prodmuo> write

    <align*|<tformat|<table|<row|<cell|\<mu\><rsub|>*<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)>>|<cell|=<big|sum><rsub|D\<in\>R><around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|D|)>\<cdot\>\<mu\><rsub|><around|(|D|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|<stack|<tformat|<table|<row|<cell|D\<in\>R>>|<row|<cell|D\<nin\>U*A*B*U>>>>>><around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|D|)>\<cdot\>\<mu\><rsub|><around|(|D|)>+<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)>*<around|(|A*B|)>\<cdot\>\<mu\><rsub|>*<around|(|A*B|)>.>>>>>

    Using Lemma <reference|prodmuo>, Theorem <reference|tmua> and the
    multiplicity of the norm, we have

    <\equation*>
      \<mu\><rsub|>*<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)>=\<mu\><rsub|><around|(|1<rsub|U*A*U>|)>*\<mu\><rsub|><around|(|1<rsub|U*B*U>|)>=<NN><around|(|<d><rsub|2><around|(|A|)>|)><NN><around|(|<d><rsub|2><around|(|B|)>|)>=<NN><around|(|<d><rsub|2><around|(|A*B|)>|)>=\<mu\><rsub|>*<around|(|A*B|)>,
    </equation*>

    so

    <\equation*>
      <big|sum><rsub|<stack|<tformat|<table|<row|<cell|D\<in\>R>>|<row|<cell|D\<nin\>U*A*B*U>>>>>><around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|D|)>\<cdot\>\<mu\><rsub|><around|(|D|)>+<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)>*<around|(|A*B|)>\<cdot\>\<mu\><rsub|>*<around|(|A*B|)>=\<mu\><rsub|>*<around|(|A*B|)>.
    </equation*>

    Since all numbers in this equation are non-negative integers and
    <math|<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)>*<around|(|A*B|)>\<geq\>1>
    by the definition of <math|\<ast\>>, we have
    <math|<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)>*<around|(|A*B|)>=1>
    and <math|<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|D|)>\<cdot\>\<mu\><rsub|><around|(|D|)>=0>
    for all <math|D\<in\>R> with <math|D\<nin\>U*A*B*U>. Since
    <math|\<mu\><rsub|><around|(|C|)>\<geq\>1> as
    <math|<g><around|(|C|)>=>, these equations imply
    <math|<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|C|)>=0> if
    <math|C\<nin\>U*A*B*U> and <math|<around|(|1<rsub|U*A*U>\<ast\>1<rsub|U*B*U>|)><around|(|C|)>=1>
    if <math|C\<in\>U*A*B*U>, where the latter condition is equivalent to
    <math|c\<in\>a*b*<rsup|\<ast\>>>, which proves the assertion.
  </proof>

  <\bibliography|bib|unsrt|countcosets>
    <bib-list|[99]|>
  </bibliography>
</body>

<\initial>
  <\collection>
    <associate|language|british>
  </collection>
</initial>