<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|theorem|Theorem>
  </hide-preamble>

  <doc-data|<doc-title|Sparse binary cyclotomic
  polynomials>|<doc-author|<author-data|<author-name|Bartomiej
  Bzd<c|e>ga>|<author-affiliation|Stryskiego 15A/20<next-line>60-688
  Pozna, Poland>|<author-email|exul@wp.pl>>>>

  <abstract-data|<abstract-keywords|binary cyclotomic polynomial| nonzero
  terms>|<abstract-msc|11B83| 11C08>|<\abstract>
    We derive a lower and an upper bound for the number of binary cyclotomic
    polynomials <math|\<Phi\><rsub|m>> with at most
    <math|m<rsup|1/2+\<varepsilon\>>> nonzero terms.
  </abstract>>

  <section*|Introduction>

  A cyclotomic polynomial <math|\<Phi\><rsub|m>\<in\>\<bbb-Z\><around|[|x|]>>
  is the monic polynomial of minimal degree having all the primitive
  <math|m>th roots of unity as its zeros. We say that the number <math|m> and
  the polynomial <math|\<Phi\><rsub|m>> are <em|binary> if <math|m> is a
  product of two distinct odd primes.

  A. Migotti <cite|Migotti-BinaryBounds> proved that a binary cyclotomic
  polynomial <math|\<Phi\><rsub|m>> has coefficients in <math|{-1,0,1}> only.
  The explicit number <math|\<theta\><rsub|m>> of nonzero terms of
  <math|\<Phi\><rsub|m>> was derived by L. Carlitz
  <cite|Carlitz-BinaryTerms>. He proved that for <math|m=p*q> we have
  <math|\<theta\><rsub|m>=2*p<rprime|'>*q<rprime|'>-1>, where
  <math|q<rprime|'>> denotes the inverse of <math|q> modulo <math|p> and
  similarly <math|p<rprime|'>> is the inverse of <math|p> modulo <math|q>.

  It can be easily proved that for binary <math|m> we have
  <math|m<rsup|1/2>\<less\>\<theta\><rsub|m>\<less\>m/2>. H.W. Lenstra proved
  in <cite|Lenstra-Vanishing> that for every <math|\<varepsilon\>\<gtr\>0>
  there exist infinitely many binary numbers <math|m> such that
  <math|\<theta\><rsub|m>\<less\>m<rsup|8/13+\<varepsilon\>>>. His method is
  based on the result of C. Hooley <cite|Hooley> that for every integer
  <math|a\<neq\>0> and every <math|\<varepsilon\>\<gtr\>0> there exist
  infinitely many primes <math|p> for which
  <math|P*<around|(|p-1|)>\<gtr\>p<rsup|5/8-\<varepsilon\>>>, where
  <math|P<around|(|n|)>> denotes the largest prime factor of <math|n>. The
  constant <math|8/13> is presently the best possible.

  The result of C. Hooley has been improved by several authors. The best
  result to the date is due to R.C. Baker and G. Harman <cite|BakerHarman>,
  who proved that <math|P*<around|(|p-1|)>\<gtr\>p<rsup|0.677>> for
  infinitely many primes <math|p>. It gives nearly <math|0.6> instead of
  <math|8/13>. We cannot improve the result of R.C. Baker and G. Harman, so
  we present a different method to achieve our goals.

  We consider the set <math|A<rsub|\<varepsilon\>><around|(|N|)>> of integers
  <math|n\<less\>N> for which <math|P<around|(|n|)>\<gtr\>n<rsup|1-\<varepsilon\>>>
  and <math|P*<around|(|n+1|)>\<gtr\><around|(|n+1|)><rsup|1-\<varepsilon\>>>.
  By the result of A. Hildebrand <cite|Hildebrand> the set
  <math|A<rsub|\<varepsilon\>>=A<rsub|\<varepsilon\>><around|(|\<infty\>|)>>
  has a positive lower density for every <math|\<varepsilon\>\<gtr\>0>. We
  use this fact to prove the following theorem.

  <\theorem>
    Let <math|B<rsub|\<varepsilon\>><around|(|N|)>> denote the set of binary
    <math|m\<less\>N> for which <math|\<theta\><rsub|m>\<less\>m<rsup|1/2+\<varepsilon\>>>.
    Then we have

    <\equation*>
      B<rsub|\<varepsilon\>><around|(|N|)>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|\<Omega\><around|(|N<rsup|1/2>|)>>|<cell|<text|for
      >0\<less\>\<varepsilon\>\<less\>1/2,>>|<row|<cell|O<around|(|N<rsup|1/2+\<varepsilon\>>|)>>|<cell|<text|for
      >0\<less\>\<varepsilon\>\<less\>1/6,>>|<row|<cell|O*<around|(|N/log<rsup|2>
      N|)>>|<cell|<text|for >0\<less\>\<varepsilon\>\<less\>1/2,>>>>>|\<nobracket\>>
    </equation*>

    where we used the <math|O> and <math|\<Omega\>> asymptotical notation.
  </theorem>

  It is a well known result of Landau that

  <\equation*>
    #<around|{|m\<le\>N:m<text|binary>|}>\<sim\>N*log log N/log N.
  </equation*>

  From this and from the third inequality it follows that for every
  <math|\<varepsilon\>\<in\><around|(|0,1/2|)>> the set
  <math|B<rsub|\<varepsilon\>>=B<rsub|\<varepsilon\>><around|(|\<infty\>|)>>
  has relative density <math|0> in the set of binary <math|m>.

  <section*|Proof of the Theorem>

  <with|font-series|bold|Part I.> For every
  <math|n\<in\>A<rsub|\<varepsilon\>>> put <math|p=P<around|(|n|)>>,
  <math|q=P*<around|(|n+1|)>> and <math|m=p*q>. Then

  <\equation*>
    q<rprime|'>=min <around|{|a\<gtr\>0<space|0.27em>:<space|0.27em>p\<mid\>a*q-1|}>\<le\><around|(|n+1|)>/q.
  </equation*>

  By the definition of <math|A<rsub|\<varepsilon\>>> we have

  <\equation*>
    \<theta\><rsub|m>\<less\>2*q*q<rprime|'>\<le\>2*n+2\<less\>2*m<rsup|1/<around|(|2-2*\<varepsilon\>|)>>+2=2*m<rsup|1/2+\<varepsilon\>/<around|(|2-2*\<varepsilon\>|)>>+2\<less\>m<rsup|1/2+\<varepsilon\>>
  </equation*>

  for <math|m\<gtr\>m<rsub|0>>, where <math|m<rsub|0>> depends only on
  <math|\<varepsilon\>>. Moreover

  <\equation*>
    n\<less\>m<rsup|1/2+\<varepsilon\>>\<less\>m,
  </equation*>

  hence <math|n=p*p<rprime|'>-1> or <math|n=q*q<rprime|'>-1>. If both of them
  are in <math|A<rsub|\<varepsilon\>>>, then

  <\equation*>
    2*m<rsup|1/2+\<varepsilon\>>\<gtr\><around|(|p*p<rprime|'>-1|)>+<around|(|q*q<rprime|'>-1|)>=m-1.
  </equation*>

  So for <math|m\<gtr\>m<rsub|1>> (where <math|m<rsub|1>> also depends only
  on <math|\<varepsilon\>>) we can determine <math|n> uniquely by <math|m>.
  We have <math|m\<gtr\>n>, thus every <math|n\<gtr\>m<rsub|1>> is determined
  uniquely by <math|m>.

  Let <math|M=max <around|{|m<rsub|0>,m<rsub|1>|}>>. By the inequality

  <\equation*>
    m\<le\>n*<around|(|n+1|)>/2\<less\>n<rsup|2>
  </equation*>

  the function

  <\equation*>
    f:A<rsub|\<varepsilon\>><around|(|N<rsup|1/2>|)>\<setminus\><around|[|1,M|]>\<to\>B<rsub|\<varepsilon\>><around|(|N|)>,<space|1em>f<around|(|n|)>=P<around|(|n|)>*P*<around|(|n+1|)>
  </equation*>

  is injective and so

  <\equation*>
    #B<rsub|\<varepsilon\>><around|(|N|)>=\<Omega\><around|(|#A<rsub|\<varepsilon\>><around|(|N<rsup|1/2>|)>|)>=\<Omega\><around|(|N<rsup|1/2>|)>
  </equation*>

  by the result of A. Hildebrand mentioned in the introduction.

  <vspace|1fn><with|font-series|bold|Part II.> For
  <math|m=p*q\<in\>B<rsub|\<varepsilon\>>> put <math|n=min
  <around|{|p*p<rprime|'>,q*q<rprime|'>|}>-1>. The following facts

  <\equation*>
    p*p<rprime|'>+q*q<rprime|'>=m+1,<space|1em><around|(|p*p<rprime|'>|)>*<around|(|q*q<rprime|'>|)>\<less\><around|(|m+1|)>*m<rsup|1/2+\<varepsilon\>>
  </equation*>

  imply that <math|n\<less\>C*m<rsup|1/2+\<varepsilon\>>> for some constant
  <math|C> depending only on <math|\<varepsilon\>>. Also

  <\equation*>
    m<rsup|1/2+\<varepsilon\>>\<gtr\>\<theta\><rsub|m>=2*p<rprime|'>*q<rprime|'>-1\<gtr\>p,q,
  </equation*>

  thus <math|p,q\<gtr\>m<rsup|1/2-\<varepsilon\>>>. We have <math|p\<mid\>n>
  and <math|q\<mid\>n+1> (or inversely). Moreover

  <\equation*>
    <frac|log n|log min <around|{|p,q|}>>\<le\><frac|log
    C+<around|(|1/2+\<varepsilon\>|)>*log
    m|<around|(|1/2-\<varepsilon\>|)>*log
    m>=<frac|1/2+\<varepsilon\>|1/2-\<varepsilon\>>+o<around|(|1|)>.
  </equation*>

  Thus <math|p=P<around|(|n|)>>, <math|q=P*<around|(|n+1|)>> (or inversely)
  for <math|m> large enough, because <math|<around|(|1/2+\<varepsilon\>|)>/<around|(|1/2-\<varepsilon\>|)>\<less\>2>
  for <math|\<varepsilon\>\<less\>1/6>. We define <math|m<rsub|2>> to be the
  smallest number satisfying the following condition:

  <\equation*>
    <text|if >m\<gtr\>m<rsub|2>*<text|then
    >m=P<around|(|n|)>*P*<around|(|n+1|)>.
  </equation*>

  It is obvious that <math|m<rsub|2>> depends only on <math|\<varepsilon\>>.
  Thus the function

  <\equation*>
    g:B<rsub|\<varepsilon\>><around|(|N|)>\<setminus\><around|[|1,m<rsub|2>|]>\<to\>A<rsub|\<varepsilon\>>*<around|(|C*N<rsup|1/2+\<varepsilon\>>|)>,<space|1em>g*<around|(|p*q|)>=min
    <around|{|p*p<rprime|'>,q*q<rprime|'>|}>-1
  </equation*>

  is an injection. Finally

  <\equation*>
    #B<rsub|\<varepsilon\>><around|(|N|)>=O*<around|(|#A<rsub|\<varepsilon\>>*<around|(|C*N<rsup|1/2+\<varepsilon\>>|)>|)>=O<around|(|N<rsup|1/2+\<varepsilon\>>|)>
  </equation*>

  due to the result of A. Hildebrand.

  <vspace|1fn><with|font-series|bold|Part III.> We assume that <math|m=p*q>
  with <math|q\<gtr\>p>. By the inequality <math|\<theta\><rsub|m>\<gtr\>q>,
  if <math|\<theta\><rsub|m>\<less\>m<rsup|1/2+\<varepsilon\>>> then
  <math|q\<less\>p<rsup|<around|(|1/2+\<varepsilon\>|)>/<around|(|1/2-\<varepsilon\>|)>>>.
  Thus

  <eqnarray*|<tformat|<table|<row|<cell|B<rsub|\<varepsilon\>><around|(|N|)>>|<cell|=>|<cell|O<around*|(|<big|sum><rsub|p\<less\>N<rsup|1/2-\<varepsilon\>>><around*|(|\<pi\><around|(|p<rsup|<around|(|1/2+\<varepsilon\>|)>/<around|(|1/2-\<varepsilon\>|)>>|)>-\<pi\><around|(|p|)>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|+<big|sum><rsub|N<rsup|1/2-\<varepsilon\>>\<less\>p\<less\>N<rsup|1/2>><around*|(|\<pi\><around|(|N<rsup|1/2>|)>-\<pi\><around|(|p|)>|)>|)>>>|<row|<cell|>|<cell|=>|<cell|O*<around*|(|\<pi\><around|(|N<rsup|1/2-\<varepsilon\>>|)>*\<pi\><around|(|N<rsup|1/2+\<varepsilon\>>|)>+\<pi\><around|(|N<rsup|1/2>|)><rsup|2>|)>=O*<around|(|N/log<rsup|2>
  N|)>,>>>>>

  which completes the proof. <math|\<Box\>>

  <section*|Acknowledgments>

  The author would like to thank Maciej Radziejewski for helpful discussion
  and Pieter Moree for his remarks.

  <thebibliography|gg|<bibitem|BakerHarman>R.C. Baker and G. Harman,
  <em|Shifted primes without large prime factors>, Acta Arith.
  <with|font-series|bold|83> (1998), 331\U361.<bibitem|Carlitz-BinaryTerms>L.
  Carlitz, <em|The number of terms in the cyclotomic polynomial
  <math|F<rsub|p*q><around|(|x|)>>>, Amer. Math. Monthly
  <with|font-series|bold|73> (1966), 979\U981.<bibitem|Hildebrand>A.
  Hildebrand, <em|On a conjecture of Balog>, Proc. Amer. Math. Soc.
  <with|font-series|bold|95> (1985), 517\U523.<bibitem|Hooley>C. Hooley,
  <em|On the largest prime factor of <math|p+a>>, Mathematica
  <with|font-series|bold|20> (1973), 135\U143.<bibitem|Lenstra-Vanishing>H.W.
  Lenstra,<em|Vanishing sums of roots of unity>, Proceedings, Bicentennial
  Congress Wiskundig Genootschap, Vrije Univ., Amsterdam (1978), Part II
  (1979), 249\U268.<bibitem|Migotti-BinaryBounds>A. Migotti, <em|Aur Theorie
  der Kreisteilungsgleichung>, Z. B. der Math.-Naturwiss, Classe der
  Kaiserlichen Akademie der Wissenschaften, Wien, <with|font-series|bold|87>
  (1883), 7\U14.>
</body>