<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <\hide-preamble>
    <assign|theenumi|<macro|<with|font-series|bold|<number|<enumi-nr>|roman>>>>

    <assign|theenumii|<macro|<with|font-series|bold|<number|<enumii-nr>|roman>>>>

    <assign|theenumiii|<macro|<number|<enumiii-nr>|roman>>>

    <new-theorem|thm|Theorem>

    <new-theorem|lem|Lemma>

    <new-theorem|prop|Proposition>

    <new-theorem|cor|Corollary>

    <new-theorem|conj|Conjecture>

    <new-theorem|claim|Claim>

    <assign|T|<macro|<math-up|T>>>

    <assign|h|<macro|<math-up|ht>>>

    <assign|hti|<macro|<with|math-font-family|rm|ht<rsub|i>>>>

    <assign|g|<macro|<math-up|g>>>

    <assign|R|<macro|\<bbb-R\>>>

    <assign|C|<macro|\<bbb-C\>>>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|Q|<macro|\<bbb-Q\>>>

    <assign|SL|<macro|<math-up|SL>>>

    <assign|GL|<macro|<math-up|GL>>>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|I|<macro|\<cal-I\>>>

    <assign|J|<macro|\<cal-J\>>>

    <assign|Lemma|<macro|<with|font-series|bold|Lemma>>>
  </hide-preamble>

  <doc-data|<doc-title|Entropy and escape of mass for Hilbert modular
  spaces>|<doc-author|<author-data|<author-name|Shirali
  Kadyrov>|<author-note|The author acknowledges support by the SNF
  (200021-127145).>>>>

  <abstract-data|<\abstract>
    We study the relation between metric entropy and escape of mass for the
    Hilbert modular spaces with the action of a diagonal element.
  </abstract>>

  <section|Introduction>

  Many interesting problems are related to equidistribution on homogeneous
  spaces. Often the ambient space is not compact, which leads to the question
  whether the limit measure is still a probability measure. One case of this
  so-called non-escape of mass problem is for a sequence of measures that are
  invariant under one parameter unipotent subgroups. In this case the answer
  is simple: for a sequence of invariant and ergodic measures under unipotent
  subgroups the limit measure is still a probability measure or the zero
  measure <cite|MozSha>. This fact relies on the quantitative non-divergences
  estimates for unipotents due to works of
  S.<nbsp>G.<nbsp>Dani<nbsp><cite|Dani> (further refined by
  G.<nbsp>A.<nbsp>Margulis and D.<nbsp>Kleinbock<nbsp><cite|MarKle>).

  In this paper we are interested in the dynamics of diagonal flows. Consider
  a sequence of probability measures invariant under a particular diagonal
  element of a linear group acting on the homogeneous space. In this case,
  the limit measure of the space could be any value in [0,1]. However, if
  additionally we assume that the measures have high entropy w.r.t. the
  diagonal element then one can show that the limit measure is not 0. This
  has been realized in <cite|TO> where M.<nbsp>Einsiedler,
  E.<nbsp>Lindenstrauss, Ph.<nbsp>Michel, and A.<nbsp>Venkatesh show the
  following.

  <\thm>
    <label|thm:torusorbit>Let <math|X> be the unit tangent bundle to the
    modular surface and <math|T> be the time 1-map for the geodesic flow.
    Then, any sequence of <math|T>-invariant probability measures
    <math|\<mu\><rsub|n>> with entropies <math|h<rsub|\<mu\><rsub|n>><around|(|T|)>\<geq\>c>
    satisfies that any weak<rsup|<math|\<ast\>>> limit
    <math|\<mu\><rsub|\<infty\>>> has at least
    <math|\<mu\><rsub|\<infty\>><around|(|X|)>\<geq\>2*c-1> mass left.
  </thm>

  Here, <math|\<mu\><rsub|\<infty\>>> is a weak<rsup|<math|\<ast\>>> limit of
  the sequence <math|<around|(|\<mu\><rsub|n>|)><rsub|n\<ge\>1>> if for some
  subsequence <math|n<rsub|k>> and for all
  <math|f\<in\>C<rsub|c><around|(|X|)>> we have

  <\equation*>
    lim<rsub|k\<to\>\<infty\>> <big|int><rsub|X>f*d*\<mu\><rsub|n<rsub|k>>\<to\><big|int><rsub|X>f*d*\<mu\><rsub|\<infty\>>.
  </equation*>

  In <cite|EinKad> M.<nbsp>Einsiedler and the author prove a similar theorem
  for the space of three-dimensional lattices. Our main goal in this paper is
  to extend Theorem<nbsp><reference|thm:torusorbit> to the following more
  general setup.

  Let <math|F> be an algebraic number field and let <math|\<cal-O\>> be its
  ring of integers. Let <math|S<rsup|\<infty\>>=<around|{|\<sigma\><rsub|1>,...,\<sigma\><rsub|r+s>|}>>
  be its archimedean places where <math|<around|{|\<sigma\><rsub|1>,...,\<sigma\><rsub|r>|}>>
  are the real places and the rest are complex ones. Define

  <\equation*>
    G\<assign\><big|prod><rsub|n=1><rsup|r><SL><rsub|2><around|(|<R>|)>\<times\><big|prod><rsub|m=1><rsup|s><SL><rsub|2><around|(|<C>|)>*<text|and
    >\<Gamma\>\<assign\><SL><rsub|2><around|(|\<cal-O\>|)>.
  </equation*>

  We have the natural embedding of <math|\<Gamma\>> into <math|G> via

  <\equation*>
    \<Delta\>:\<gamma\>\<to\><around|(|\<sigma\><rsub|1><around|(|\<gamma\>|)>,\<sigma\><rsub|2><around|(|\<gamma\>|)>,\<ldots\>,\<sigma\><rsub|r+s><around|(|\<gamma\>|)>|)>
  </equation*>

  where <math|\<sigma\><rsub|j><around|(|\<gamma\>|)>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|\<sigma\><rsub|j><around|(|a|)>>|<cell|\<sigma\><rsub|j><around|(|b|)>>>|<row|<cell|\<sigma\><rsub|j><around|(|c|)>>|<cell|\<sigma\><rsub|j><around|(|d|)>>>>>>|)>>
  for <math|\<gamma\>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|a>|<cell|b>>|<row|<cell|c>|<cell|d>>>>>|)>\<in\>\<Gamma\>>.
  Then <math|\<Gamma\>> becomes a lattice in <math|G> (cf.
  Lemma<nbsp><reference|lem:mahler>). It is an irreducible lattice and the
  quotient space <math|X\<assign\>\<Gamma\>\<setminus\>G> is non-compact. The
  bi-quotient <math|\<Gamma\>\<setminus\><SL><rsub|2><around|(|<R>|)>\<times\><SL><rsub|2><around|(|<R>|)><slash|<math-up|SO>><around|(|2|)>\<times\><math-up|SO><around|(|2|)>>
  in the case of a real quadratic field <math|F> over <math|<Q>> is known as
  Hilbert modular surface.

  Let <math|a> be any fixed diagonal element of <math|G>. Then there exist
  <math|a<rsub|j>\<in\><R>> and <math|\<theta\><rsub|j>\<in\><around|[|0,2*\<pi\>|]>>
  such that

  <\equation*>
    a=d*i*a*g*<around|(|e<rsup|i*\<theta\><rsub|1>>*e<rsup|a<rsub|1>/2>,e<rsup|-i*\<theta\><rsub|1>>*e<rsup|-a<rsub|1>/2>|)>\<times\>\<cdots\>\<times\>d*i*a*g*<around|(|e<rsup|i*\<theta\><rsub|r+s>>*e<rsup|a<rsub|r+s>/2>,e<rsup|-i*\<theta\><rsub|r+s>>*e<rsup|-a<rsub|r+s>/2>|)>
  </equation*>

  with <math|\<theta\><rsub|1>,\<ldots\>,\<theta\><rsub|r>=0>. Now, we define
  the action of <math|<T>> on <math|X> by
  <math|<T><around|(|x|)>=x\<cdot\>a>.

  In <nbsp><reference|sec:prelim> we define the height function
  <math|<h><around|(|\<cdummy\>|)>> on <math|X>. Now, if we define
  <math|X<rsub|\<less\>M>=<around|{|x\<in\>X<space|0.17em>:<space|0.17em><h><around|(|x|)>\<less\>M|}>>
  then <math|X<rsub|\<less\>M>> becomes pre-compact (cf.
  Lemma<nbsp><reference|lem:mahler>). We similarly define
  <math|X<rsub|\<ge\>M>>. Now, we can state the main result.

  Let <math|<around|\||a<rsub|1>|\|>+\<cdots\>+<around|\||a<rsub|r>|\|>=h<rsub|r>>
  and <math|<around|\||a<rsub|r+1>|\|>+\<cdots\>+<around|\||a<rsub|r+s>|\|>=h<rsub|s>>.
  We note that the maximal metric entropy of <math|<T>> is
  <math|h<rsub|r>+2*h<rsub|s>>, which we denoted by
  <math|h<rsub|max><around|(|<T>|)>>.

  <\thm>
    <label|thm:main>Let <math|M\<gtr\>max
    <around|{|e<rsup|3*h<rsub|max><around|(|<T>|)>>,100|}>> be given.Then,
    there exists a continuous decreasing function
    <math|\<phi\>:<R><rsup|+>\<to\><R>> with <math|lim<rsub|M\<to\>\<infty\>>
    \<phi\><around|(|M|)>=0> such that

    <\equation*>
      \<mu\><around|(|X<rsub|\<less\>M>|)>\<ge\>1-<frac|2|h<rsub|max><around|(|<T>|)>>*<around|(|h<rsub|max><around|(|T|)>-h<rsub|\<mu\>><around|(|T|)>|)>+\<phi\><around|(|M|)>
    </equation*>

    for any <math|<T>>-invariant probability measure <math|\<mu\>> on
    <math|X>. In particular, for a sequence of <math|<T>>-invariant measures
    <math|\<mu\><rsub|n>> with <math|h<rsub|\<mu\><rsub|n>><around|(|<T>|)>\<ge\>h>
    one has that any weak<rsup|<math|\<ast\>>> limit
    <math|\<mu\><rsub|\<infty\>>> has at least
    <math|<frac|2*h|h<rsub|max><around|(|<T>|)>>-1> mass left.
  </thm>

  Whenever <math|h\<in\><around|(|h<rsub|max><around|(|<T>|)>/2,h<rsub|max><around|(|<T>|)>|]>>
  there will be some mass left in the limit. We think that the theorem is
  sharp in the following sense: there should exists a sequence of
  <math|<T>>-invariant probability measures
  <math|<around|(|\<mu\><rsub|n>|)><rsub|n\<ge\>1>> on <math|X> with
  <math|lim<rsub|n\<to\>\<infty\>> h<rsub|\<mu\><rsub|n>><around|(|<T>|)>=h<rsub|max><around|(|<T>|)>/2>
  such that the limit measure is the 0 measure. A similar construction has
  been carried out in <cite|const> for the space
  <math|<SL><rsub|n><around|(|<Z>|)>\<setminus\><SL><rsub|n><around|(|<R>|)>>
  of unimodular lattices. Theorem<nbsp><reference|thm:main> suggests the
  following.

  <\conj>
    Let <math|G<rprime|'>> be a <math|<Q>>-group and
    <math|\<Gamma\><rprime|'>> be an arithmetic lattice of <math|<Q>>-rank
    one. Let <math|T<rprime|'>> be a right multiplication on
    <math|\<Gamma\><rprime|'>\<setminus\>G<rprime|'>> by a diagonalizable
    element in <math|G>. Then, any sequence of <math|T<rprime|'>>-invariant
    probability measures <math|\<mu\><rsub|n>> on
    <math|\<Gamma\><rprime|'>\<setminus\>G<rprime|'>> with entropies
    <math|h<rsub|\<mu\><rsub|n>>\<ge\>c> satisfies that any weak* limit
    <math|\<mu\><rsub|\<infty\>>> has at least

    <\equation*>
      \<mu\><rsub|\<infty\>>*<around|(|\<Gamma\><rprime|'>\<setminus\>G<rprime|'>|)>\<ge\>1-<frac|2|h<rsub|max><around|(|T<rprime|'>|)>>*<around|(|h<rsub|max><around|(|T<rprime|'>|)>-c|)>
    </equation*>

    mass left where <math|h<rsub|max><around|(|T<rprime|'>|)>> is the maximal
    metric entropy of <math|T<rprime|'>>.
  </conj>

  For the <math|<Q>>-rank one case, the conjecture suggests that once the
  entropies of the measures are uniformly greater than <math|1/2> of the
  maximal entropy, there is always some mass left in the limit. For a
  heuristic explanation we refer to Remark<nbsp>5.2 in <cite|TO>.

  Another interesting case studying the limits of a sequence of probability
  measures arises by averaging an arbitrary measure under iterates of some
  element of the ambient group. In this case, the notion of entropy does not
  make sense rather one has to consider the dimension of the measures.

  For any group <math|H> we define <math|B<rsub|\<epsilon\>><rsup|H><around|(|g|)>>
  to be the open ball in <math|H> of radius <math|\<epsilon\>\<gtr\>0>
  centered at <math|g\<in\>H> and we simply write
  <math|B<rsub|\<epsilon\>><rsup|H>> if the ball is centered at the identity
  1. Let us consider the following subgroups of <math|G>

  <\equation*>
    U<rsup|+>=<around|{|g\<in\>G:a<rsup|-n>*g*a<rsup|n>\<to\>1*<text|as
    >n\<to\>-\<infty\>|}>,
  </equation*>

  <\equation*>
    U<rsup|->=<around|{|g\<in\>G:a<rsup|-n>*g*a<rsup|n>\<to\>1*<text|as
    >n\<to\>\<infty\>|}>,
  </equation*>

  <\equation*>
    L=<around|{|g\<in\>G:g*a=a*g|}>.
  </equation*>

  We let <math|D\<assign\>dim U<rsup|+>\<le\>r+2*s>. Let
  <math|d\<in\><around|[|0,D|]>> be given and let us consider a probability
  measure <math|\<nu\>> in <math|X> with the following property. For any
  <math|\<delta\>\<gtr\>0> there exists <math|\<epsilon\><rprime|'>\<gtr\>0>
  such that for any <math|\<epsilon\>\<less\>\<epsilon\><rprime|'>> one has

  <\equation*>
    \<nu\>*<around|(|x*B<rsub|\<epsilon\>><rsup|U<rsup|+>>*B<rsub|\<eta\>><rsup|U<rsup|->*L>|)>\<ll\>\<epsilon\><rsup|d-\<delta\>>*<text|for
    any >\<eta\>\<in\><around|(|0,1|)>*<text|and for any >x\<in\>X.
  </equation*>

  In this case say that <math|\<nu\>> has a <em|dimension at least <math|d>
  in the unstable direction>. Now, we consider the following sequence of
  measures <math|\<mu\><rsub|n>> defined by

  <\equation*>
    \<mu\><rsub|n>=<frac|1|n>*<big|sum><rsub|j=0><rsup|n-1><T><rsup|j><rsub|\<ast\>>\<nu\>
  </equation*>

  where <math|<T><rsup|j><rsub|\<ast\>>\<nu\>> is the push-forward of
  <math|\<nu\>> under <math|<T><rsup|j>>. We have

  <\thm>
    <label|thm:dim>For a fixed <math|d> let <math|\<nu\>> be a probability
    measure of dimension at least <math|d> in the unstable direction with
    respect to <math|a>, and let <math|\<mu\><rsub|n>> be as above. Then the
    sequence of probability measures <math|<around|(|\<mu\><rsub|n>|)><rsub|n\<ge\>1>>
    satisfies that any weak<rsup|<math|\<ast\>>> limit
    <math|\<mu\><rsub|\<infty\>>> has at least
    <math|\<mu\><rsub|\<infty\>><around|(|X|)>\<geq\>1-<frac|2*a<rsub|\<ast\>>*<around|(|D-d|)>|h<rsub|max><around|(|<T>|)>>>
    mass left where <math|a<rsub|\<ast\>>=max
    <around|{|<around|\||a<rsub|i>|\|>:i=1,\<ldots\>,r+s|}>>.
  </thm>

  In particular, if <math|\<nu\>> has full dimension, that is if <math|d=D>,
  then the limit <math|\<mu\><rsub|\<infty\>>> is a probability measure. In
  this case with a minor additional assumption on <math|\<nu\>> one in fact
  obtains the equidistribution result, that is, the limit measure
  <math|\<mu\><rsub|\<infty\>>> is the Haar measure <cite|Shi>. We say that
  an element <math|x\<in\>X> is <with|font-shape|italic|divergent on average
  with respect to> <math|a> if <math|lim<rsub|N\<to\>\<infty\>>
  <frac|1|N>*<around|{|n\<in\><around|[|0,N-1|]>:<T><rsup|n><around|(|x|)>\<in\>K|}>=0>
  for any compact set <math|K> in <math|X>.

  We note that if we have a measure <math|\<nu\>> as above for some <math|d>
  which is supported in the set of points in <math|X> that diverge on average
  then clearly any limit <math|\<mu\><rsub|\<infty\>>>of
  <math|<around|(|\<mu\><rsub|n>|)><rsub|\<ge\>1>> is the zero measure which
  implies that <math|d\<le\>D-<frac|h<rsub|max><around|(|<T>|)>|2*a<rsub|\<ast\>>>>.
  This hints the following.

  <\cor>
    The Hausdorff dimension of the points in <math|X> that are divergent on
    average w.r.t <math|a> is at most <math|dim
    G-<frac|h<rsub|max><around|(|<T>|)>|2*a<rsub|\<ast\>>>>.
  </cor>

  The proof of the corollary is easily obtained from
  Theorem<nbsp><reference|thm:dim> using <cite-detail|Fal|Corollary<nbsp>4.12>
  and is left to the reader (cf. <cite-detail|EinKad|Corollary<nbsp>1.7>).

  In the next section we will consider some basic facts. In
  <nbsp><reference|sec:mainthm> we state the main ingredients and show how
  one deduces Theroem<nbsp><reference|thm:main>. In
  <nbsp><reference|sec:partitions> we introduce the partitions and count the
  number of elements in these partitions. In <nbsp><reference|sec:mainprop>
  we obtain the main proposition and finally, in <nbsp><reference|sec:dim>
  we indicate how one proves Theorem<nbsp><reference|thm:dim>.

  <with|font-series|bold|Acknowledgements:> This work is part of the author's
  doctoral dissertation at The Ohio State University. The author would like
  to thank his adviser M. Einsiedler for useful conversations. He also would
  like to thank the referee for useful comments which in particular helped to
  improve the results of the previous version of the paper.

  <section|Preliminaries><label|sec:prelim>

  We consider the space <math|X> as a subspace of the space of
  <math|\<cal-O\>>-submodules <math|\<Lambda\>> of
  <math|<around|(|<R><rsup|2>|)><rsup|r>\<times\><around|(|<C><rsup|2>|)><rsup|s>>
  with the following properties:

  <\enumerate>
    <item><math|\<Lambda\>> is an <math|\<cal-O\>>-submodule generated by two
    vectors <math|v,w> of <math|<around|(|<R><rsup|2>|)><rsup|r>\<times\><around|(|<C><rsup|2>|)><rsup|s>>,

    <item><math|v=<around|(|v<rsub|1><rprime|'>,v<rsub|1><rprime|''>|)>\<times\><around|(|v<rsub|2><rprime|'>,v<rsub|2><rprime|''>|)>\<times\>\<cdots\>\<times\><around|(|v<rsub|r+s><rprime|'>,v<rsub|r+s><rprime|''>|)>>
    and <math|w=<around|(|w<rsub|1><rprime|'>,w<rsub|1><rprime|''>|)>\<times\><around|(|w<rsub|2><rprime|'>,w<rsub|2><rprime|''>|)>\<times\>\<cdots\>\<times\><around|(|w<rsub|r+s><rprime|'>,w<rsub|r+s><rprime|''>|)>>
    are such that <math|det <around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|v<rsub|j><rprime|'>>|<cell|v<rsub|j><rprime|''>>>|<row|<cell|w<rsub|j><rprime|'>>|<cell|w<rsub|j><rprime|''>>>>>>|)>=1>
    for <math|j=1,...,r+s>.
  </enumerate>

  From now on, we use a standard notation
  <math|v=<around|(|v<rsub|1><rprime|'>,v<rsub|1><rprime|''>|)>\<times\><around|(|v<rsub|2><rprime|'>,v<rsub|2><rprime|''>|)>\<times\>\<cdots\>\<times\><around|(|v<rsub|r+s><rprime|'>,v<rsub|r+s><rprime|''>|)>>
  for a vector <math|v\<in\><around|(|<R><rsup|2>|)><rsup|r>\<times\><around|(|<C><rsup|2>|)><rsup|s>>.
  A similar notation is used for <math|w\<in\><around|(|<R><rsup|2>|)><rsup|r>\<times\><around|(|<C><rsup|2>|)><rsup|s>>.
  The action of <math|\<cal-O\>> on <math|<around|(|<R><rsup|2>|)><rsup|r>\<times\><around|(|<C><rsup|2>|)><rsup|s>>
  is given by <math|\<lambda\>\<cdot\>v=>

  <\equation*>
    <around|(|\<sigma\><rsub|1><around|(|\<lambda\>|)>*v<rsub|1><rprime|'>,\<sigma\><rsub|1><around|(|\<lambda\>|)>*v<rsub|1><rprime|''>|)>\<times\><around|(|\<sigma\><rsub|2><around|(|\<lambda\>|)>*v<rsub|2><rprime|'>,\<sigma\><rsub|2><around|(|\<lambda\>|)>*v<rsub|2><rprime|''>|)>\<times\>\<cdots\>\<times\><around|(|\<sigma\><rsub|r+s><around|(|\<lambda\>|)>*v<rsub|r+s><rprime|'>,\<sigma\><rsub|r+s><around|(|\<lambda\>|)>*v<rsub|r+s><rprime|''>|)>
  </equation*>

  for any <math|\<lambda\>\<in\>\<cal-O\>> and any
  <math|v\<in\><around|(|<R><rsup|2>|)><rsup|r>\<times\><around|(|<C><rsup|2>|)><rsup|s>>.

  Now, we define the <em|height> function <math|<h><around|(|\<cdummy\>|)>>
  from <math|X> to <math|<R><rsup|+>> as follows. On <math|<R>> and on
  <math|<C>> we consider the usual absolute value
  <math|<around|\||\<cdummy\>|\|>> and for any
  <math|<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>> in
  <math|<R><rsup|2>> or in <math|<C><rsup|2>> by the norm
  <math|<around|\||\<cdummy\>|\|>> we mean
  <math|<around|\||<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|\|>=max
  <around|{|<around|\||v<rsub|j><rprime|'>|\|>,<around|\||v<rsub|j><rprime|''>|\|>|}>>.
  For a vector <math|v=<around|(|v<rsub|1><rprime|'>,v<rsub|1><rprime|''>|)>\<times\><around|(|v<rsub|2><rprime|'>,v<rsub|2><rprime|''>|)>\<times\>\<cdots\>\<times\><around|(|v<rsub|r+s><rprime|'>,v<rsub|r+s><rprime|''>|)>>
  in an <math|\<cal-O\>>-submodule <math|\<Lambda\>\<in\>X> we define the
  `norm' by

  <\equation*>
    <around|\<\|\|\>|v|\<\|\|\>>=<big|prod><rsub|j=1><rsup|r+s><around|\||<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|\|><rsup|\<delta\><rsub|j>>
  </equation*>

  where

  <\equation*>
    \<delta\><rsub|j>=<choice|<tformat|<table|<row|<cell|1,>|<cell|<text|if
    >j\<in\><around|{|1,2,\<ldots\>,r|}>>>|<row|<cell|2,>|<cell|<text|if
    >j\<in\><around|{|r+1,r+2,\<ldots\>,r+s|}>>>>>>.
  </equation*>

  Now, we define the height of <math|\<Lambda\>>:

  <\equation*>
    <h><around|(|\<Lambda\>|)>\<assign\>max
    <around|{|<around|\<\|\|\>|v|\<\|\|\>><rsup|-1><space|0.17em>:<space|0.17em>v\<in\>\<Lambda\>-<around|{|0|}>|}>.
  </equation*>

  We note that this is well defined as <math|<around|\<\|\|\>|v|\<\|\|\>>\<neq\>0>
  whenever <math|v\<neq\>0>.<next-line><with|font-series|bold|Definition.> A
  nonzero vector <math|v> in an <math|\<cal-O\>>-submodule <math|\<Lambda\>>
  is said to be <em|primitive> if <math|<around|(|F*v|)>\<cap\>\<Lambda\>=\<cal-O\>*v>.

  <\lem>
    <label|lem:shortvector>Up to multiplication by units, for any element
    <math|\<Lambda\>\<in\>X> there can be at most one primitive (short)
    vector of norm <math|\<less\>1>.
  </lem>

  Having only one short vector is crucial throughout the paper. Obtaining
  similar results as in this paper for spaces that allow more than one
  primitive short vectors requires different techniques (cf. <cite|EinKad>).

  <\proof>
    Assume by contradiction that there are two distinct primitive vectors
    <math|e,f\<in\>\<Lambda\>> such that <math|<around|\<\|\|\>|e|\<\|\|\>>\<less\>1,<around|\<\|\|\>|f|\<\|\|\>>\<less\>1>
    up to multiplication by units. Let <math|e=<around|(|e<rsub|1><rprime|'>,e<rsub|1><rprime|''>|)>\<times\><around|(|e<rsub|2><rprime|'>,e<rsub|2><rprime|''>|)>\<times\>\<cdots\>\<times\><around|(|e<rsub|r+s><rprime|'>,e<rsub|r+s><rprime|''>|)>>
    and <math|f=<around|(|f<rsub|1><rprime|'>,f<rsub|1><rprime|''>|)>\<times\><around|(|f<rsub|2><rprime|'>,f<rsub|2><rprime|''>|)>\<times\>\<cdots\>\<times\><around|(|f<rsub|r+s><rprime|'>,f<rsub|r+s><rprime|''>|)>>.
    We pick <math|v=<around|(|v<rsub|1><rprime|'>,v<rsub|1><rprime|''>|)>\<times\><around|(|v<rsub|2><rprime|'>,v<rsub|2><rprime|''>|)>\<times\>\<cdots\>\<times\><around|(|v<rsub|r+s><rprime|'>,v<rsub|r+s><rprime|''>|)>>
    and <math|w=<around|(|w<rsub|1><rprime|'>,w<rsub|1><rprime|''>|)>\<times\><around|(|w<rsub|2><rprime|'>,w<rsub|2><rprime|''>|)>\<times\>\<cdots\>\<times\><around|(|w<rsub|r+s><rprime|'>,w<rsub|r+s><rprime|''>|)>>
    which generate <math|\<Lambda\>> over <math|\<cal-O\>> as a submodule and
    satisfy the property (ii). There are <math|\<lambda\><rsub|1>,\<lambda\><rsub|2>,\<nu\><rsub|1>,\<nu\><rsub|2>\<in\>\<cal-O\>>
    such that <math|e=\<lambda\><rsub|1>*v+\<lambda\><rsub|2>*w> and
    <math|f=\<nu\><rsub|1>*v+\<nu\><rsub|2>*w>. We have

    <\equation*>
      <big|prod><rsub|j=1><rsup|r+s>det <around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|e<rsub|j><rprime|'>>|<cell|e<rsub|j><rprime|''>>>|<row|<cell|f<rsub|j><rprime|'>>|<cell|f<rsub|j><rprime|''>>>>>>|)><rsup|\<delta\><rsub|j>>=<big|prod><rsub|j=1><rsup|r+s>det
      <around*|(|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|\<sigma\><rsub|j><around|(|\<lambda\><rsub|1>|)>>|<cell|\<sigma\><rsub|j><around|(|\<lambda\><rsub|2>|)>>>|<row|<cell|\<sigma\><rsub|j><around|(|\<nu\><rsub|1>|)>>|<cell|\<sigma\><rsub|j><around|(|\<nu\><rsub|2>|)>>>>>>|)><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|v<rsub|j><rprime|'>>|<cell|v<rsub|j><rprime|''>>>|<row|<cell|w<rsub|j><rprime|'>>|<cell|w<rsub|j><rprime|''>>>>>>|)>|)><rsup|\<delta\><rsub|j>>
    </equation*>

    where <math|<around|{|\<sigma\><rsub|1>,...,\<sigma\><rsub|r+s>|}>=S<rsup|\<infty\>>>.
    Since, <math|det <around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|v<rsub|j><rprime|'>>|<cell|v<rsub|j><rprime|''>>>|<row|<cell|w<rsub|j><rprime|'>>|<cell|w<rsub|j><rprime|''>>>>>>|)>=1>
    for <math|j=1,2,\<ldots\>,r+s> we must have

    <\equation*>
      <big|prod><rsub|j=1><rsup|r+s><around|(|e<rsub|j><rprime|'>*f<rsub|j><rprime|''>-e<rsub|j><rprime|''>*f<rsub|j><rprime|'>|)><rsup|\<delta\><rsub|j>>=<big|prod><rsub|j=1><rsup|r+s>\<sigma\><rsub|j>*<around|(|\<lambda\><rsub|2>*\<nu\><rsub|1>-\<lambda\><rsub|1>*\<nu\><rsub|2>|)><rsup|\<delta\><rsub|j>>.
    </equation*>

    We now claim that <math|\<lambda\><rsub|2>*\<nu\><rsub|1>\<neq\>\<lambda\><rsub|1>*\<nu\><rsub|2>>.
    Otherwise, we see that <math|<frac|\<nu\><rsub|1>|\<lambda\><rsub|1>>*e=\<nu\><rsub|1>*v+<frac|\<nu\><rsub|1>*\<lambda\><rsub|2>|\<lambda\><rsub|1>>*w=f>
    where without loss of generality we assumed that
    <math|\<lambda\><rsub|1>\<neq\>0>. Then, we have
    <math|f\<in\><around|(|F*e|)>\<cap\>\<Lambda\>=\<cal-O\>*e> and
    <math|e\<in\><around|(|F*f|)>\<cap\>\<Lambda\>=\<cal-O\>*f> which imply,
    upto multiplication by units, that <math|e> and <math|f> are the same
    which is a contradiction.

    Since <math|\<lambda\><rsub|1>,\<lambda\><rsub|2>,\<nu\><rsub|1>,\<nu\><rsub|2>\<in\>\<cal-O\>>,
    from the above claim we obtain that

    <\equation*>
      <big|prod><rsub|j=1><rsup|r+s>\<sigma\><rsub|j>*<around|(|\<lambda\><rsub|2>*\<nu\><rsub|1>-\<lambda\><rsub|1>*\<nu\><rsub|2>|)><rsup|\<delta\><rsub|j>>=N*<around|(|\<lambda\><rsub|2>*\<nu\><rsub|1>-\<lambda\><rsub|1>*\<nu\><rsub|2>|)>\<ge\>1
    </equation*>

    where <math|N<around|(|\<cdummy\>|)>> is the number theoretic norm. It
    follows that

    <\equation>
      <label|eqn:prod><big|prod><rsub|j=1><rsup|r+s><around|(|e<rsub|j><rprime|'>*f<rsub|j><rprime|''>-e<rsub|j><rprime|''>*f<rsub|j><rprime|'>|)><rsup|\<delta\><rsub|j>>\<ge\>1.
    </equation>

    From Cauchy-Schwartz inequality we see that

    <\equation*>
      <around|\||<around|(|e<rsub|j><rprime|'>*f<rsub|j><rprime|''>-e<rsub|j><rprime|''>*f<rsub|j><rprime|'>|)>|\|>\<le\><around|\||<around|(|e<rsub|j><rprime|'>,e<rsub|j><rprime|''>|)>|\|>\<cdot\><around|\||<around|(|f<rsub|j><rprime|'>,f<rsub|j><rprime|''>|)>|\|>.
    </equation*>

    Hence,

    <\equation*>
      <around|\||<big|prod><rsub|j=1><rsup|r+s><around|(|e<rsub|j><rprime|'>*f<rsub|j><rprime|''>-e<rsub|j><rprime|''>*f<rsub|j><rprime|'>|)><rsup|\<delta\><rsub|j>>|\|>\<le\><big|prod><rsub|j=1><rsup|r+s><around|\||<around|(|e<rsub|j><rprime|'>,e<rsub|j><rprime|''>|)><rsup|\<delta\><rsub|j>>|\|>\<cdot\><big|prod><rsub|j=1><rsup|r+s><around|\||<around|(|f<rsub|j><rprime|'>,f<rsub|j><rprime|''>|)><rsup|\<delta\><rsub|j>>|\|>=<around|\<\|\|\>|e|\<\|\|\>><around|\<\|\|\>|f|\<\|\|\>>\<less\>1.
    </equation*>

    Thus, we obtain a contradiction to (<reference|eqn:prod>). Therefore, up
    to multiplication by units, there can be at most one primitive short
    vector of norm <math|\<less\>1>.
  </proof>

  We will need the following well known fact (see for example <cite|Sel>).

  <\lem>
    <label|lem:mahler><math|\<Gamma\>> is a lattice in <math|G> and
    <math|X<rsub|\<less\>M>> is pre-compact.
  </lem>

  The idea of the proof is to embed <math|G> as a <math|<Q>>-group in
  <math|<SL><rsub|2*<around|(|r+2*s|)>><around|(|<R>|)>>. This identification
  goes deeper namely that the points of the module are identified with the
  points of the lattice and the <math|<around|\<\|\|\>|\<cdummy\>|\<\|\|\>>>
  function we considered above is just the Euclidean norm on
  <math|<R><rsup|2*<around|(|r+2*s|)>>>. This gives that <math|\<Gamma\>> is
  a lattice in <math|G> and moreover using Mahler's compactness criterion we
  obtain that <math|X<rsub|\<less\>M>> is pre-compact.

  <section|Main Ingredients and the Proof of
  Theorem<nbsp><reference|thm:main>><label|sec:mainthm>

  In this section we will state Lemma<nbsp><reference|lem:Q> and
  Proposition<nbsp><reference|prop:mainn> without proofs and show how they
  can be used to deduce Theorem<nbsp><reference|thm:main>. To make use of
  both Lemma<nbsp><reference|lem:Q> and Proposition<nbsp><reference|prop:mainn>
  we need the following lemma which gives an upper bound for entropy in terms
  of covers by Bowen balls.

  Define a (forward) Bowen <math|N>-ball (of radius <math|\<eta\>>) to be the
  translate <math|x*B<rsub|N>> for some <math|x\<in\>X> of

  <\equation*>
    B<rsub|N>=<big|cap><rsub|n=0><rsup|N-1>a<rsup|n>*B<rsub|\<eta\>><rsup|G>*a<rsup|-n>
  </equation*>

  where <math|\<eta\>\<gtr\>0> is fixed such that the <math|log> map from
  <math|B<rsub|\<eta\>><rsup|G>> to the Lie algebra of <math|G> is injective.

  <\lem>
    <label|lem:entropy>Let <math|\<mu\>> be a <math|<T>>-invariant ergodic
    probability measure on <math|X>. For any <math|N\<geq\>1> and
    <math|\<epsilon\>\<gtr\>0> let <math|B*C<around|(|N,\<epsilon\>|)>> be
    the minimal number of (forward) Bowen <math|N>-balls needed to cover any
    particular subset of <math|X> of measure bigger than <math|\<epsilon\>>.
    Then

    <\equation*>
      h<rsub|\<mu\>><around|(|<T>|)>\<leq\>liminf<rsub|N\<to\>\<infty\>>
      <frac|log B*C<around|(|N,\<epsilon\>|)>|N>.
    </equation*>
  </lem>

  To prove the lemma one roughly uses the trivial entropy bound, namely

  <\equation*>
    H<around|(|\<xi\>|)>\<le\>log <around|\||\<xi\>|\|>
  </equation*>

  where <math|<around|\||\<xi\>|\|>> is the number of elements of the
  partition <math|\<xi\>> and the existence of fine partitions with thin
  boundary. The proof is left to the reader which is very similar to
  <cite-detail|TO|Lemma<nbsp>B.2>.

  For <math|M,N\<ge\>1> given we define a partition

  <\equation*>
    Q<rsub|M,N>\<assign\><big|vee><rsub|n=0><rsup|N-1><T><rsup|-n><around|{|X<rsub|\<less\>M>,X<rsub|\<ge\>M>|}>.
  </equation*>

  <\lem>
    <label|lem:Q>The partition <math|Q<rsub|M,N>> has
    <math|\<ll\>e<rsup|O<around|(|<frac|log log M|log M>|)>*N>> elements for
    any <math|M\<ge\>e<rsup|h<rsub|max><around|(|<T>|)>>> and
    <math|N\<in\><N>> where implied constants do not depend on <math|M,N>.
  </lem>

  Here <math|X\<ll\>Z> means that there exists a positive constant <math|c>
  such that <math|X\<le\>c*Z>. Also, <math|X\<ll\><rsub|d>Z> means that the
  constant <math|c> depends on <math|d>. The proof of
  Lemma<nbsp><reference|lem:Q> is given in
  <nbsp><reference|sec:proofoflemma>.

  The partition elements of <math|Q<rsub|M,N>> can be described by the
  suitable subsets of <math|<around|[|0,N-1|]>> in the sense that for any
  <math|Q\<in\>Q<rsub|M,N>> there exists <math|\<cal-V\>\<subset\><around|[|0,N-1|]>>
  with integer end points such that

  <\equation*>
    Q=<around|{|x\<in\>X:\<forall\>n\<in\><around|[|0,N-1|]>,<T><rsup|n><around|(|x|)>\<in\>X<rsub|\<ge\>M>*<text|if
    and only if >n\<in\>\<cal-V\>|}>.
  </equation*>

  In this case, we denote <math|Q> by <math|Q<around|(|\<cal-V\>|)>>.

  <\prop>
    <label|prop:mainn>For any <math|M\<gtr\>e<rsup|3*h<rsub|max><around|(|<T>|)>>>
    the partition element <math|Q<around|(|\<cal-V\>|)>\<in\>Q<rsub|M,N>>
    with <math|Q<around|(|\<cal-V\>|)>\<subset\>X<rsub|\<less\>M>> can be
    covered by

    <\equation*>
      \<ll\><rsub|M>e<rsup|O<around|(|<frac|log log M|log
      M>|)>*N>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|N-<frac|<around|\||\<cal-V\>|\|>|2>|)>>
    </equation*>

    Bowen <math|N>-balls for any <math|N\<in\><N>> where the implied constant
    in <math|O<around|(|\<cdummy\>|)>> is independent of <math|M,N>.
  </prop>

  The proof of Proposition<nbsp><reference|prop:mainn> easily follows from
  Proposition<nbsp><reference|prop:main> together with
  Lemma<nbsp><reference|lem:P> and it is given after the statement of
  Proposition<nbsp><reference|prop:main>.

  <\proof>
    <dueto|Proof of the Theorem<nbsp><reference|thm:main>>Note first that it
    suffices to consider ergodic measures. For if <math|\<mu\>> is not
    ergodic, we can write <math|\<mu\>> as an integral of its ergodic
    components <math|\<mu\>=<big|int>\<mu\><rsub|t>*d*\<tau\><around|(|t|)>>
    for some probability space <math|<around|(|E,\<tau\>|)>>, see for example
    <cite-detail|EinWar|Theorem 6.2>. Therefore, we have
    <math|\<mu\><around|(|X<rsub|\<ge\>M>|)>=<big|int>\<mu\><rsub|t><around|(|X<rsub|\<ge\>M>|)>*d*\<tau\><around|(|t|)>>,
    but also <math|h<rsub|\<mu\>><around|(|<T>|)>=<big|int>h<rsub|\<mu\><rsub|t>><around|(|<T>|)>*d*\<tau\><around|(|t|)>>,
    see for example <cite-detail|WB|Thm.<nbsp>8.4>, so that desired estimate
    follows from the ergodic case.

    Suppose that <math|\<mu\>> is ergodic. Let
    <math|M\<gtr\>e<rsup|3*h<rsub|max><around|(|<T>|)>>> be such that
    <math|\<mu\><around|(|X<rsub|\<less\>M>|)>\<gtr\>0>. Later in the proof
    we will show how one may choose <math|M> independent of <math|\<mu\>>
    which is crucial in obtaining the last part of the theorem. We would like
    to apply Lemma<nbsp><reference|lem:entropy>. For this we need to find an
    upper bound for covering a subset of <math|X> of measure
    <math|\<epsilon\>> by Bowen <math|N>-balls. Let us fix
    <math|\<epsilon\>\<gtr\>0> such that <math|\<mu\><around|(|X<rsub|\<less\>M>|)>\<gtr\>2*\<epsilon\>>.
    The pointwise ergodic theorem implies

    <\equation*>
      <frac|1|N>*<big|sum><rsub|n=0><rsup|N-1>1<rsub|X\<geq\>M><around|(|<T><rsup|n><around|(|x|)>|)>\<to\>\<mu\><around|(|X<rsub|\<geq\>M>|)>
    </equation*>

    as <math|N\<to\>\<infty\>> for a.e. <math|x\<in\>X>. Thus, there is
    <math|N<rsub|0>> such that for <math|N\<gtr\>N<rsub|0>> the average on
    the left will be bigger than <math|\<mu\><around|(|X<rsub|\<geq\>M>|)>-\<epsilon\>>
    for any <math|x\<in\>X<rsub|1>> for some <math|X<rsub|1>\<subset\>X> with
    measure <math|\<mu\><around|(|X<rsub|1>|)>\<gtr\>1-\<epsilon\>>. Clearly,
    for any <math|N\<gtr\>N<rsub|0>> we have
    <math|\<mu\><around|(|Z|)>\<gtr\>\<epsilon\>> where

    <\equation*>
      Z=X<rsub|1>\<cap\>X<rsub|\<less\>M>.
    </equation*>

    Now, we would like to find an upper bound for the number of Bowen
    <math|N>-balls needed to cover the set <math|Z>. Here
    <math|N\<rightarrow\>\<infty\>> while <math|\<epsilon\>> is fixed. We now
    split <math|Z> into the sets <math|P<around|(|\<cal-V\>|)>> as in
    Proposition<nbsp><reference|prop:mainn>. By Lemma<nbsp><reference|lem:Q>
    we know that we need <math|\<ll\><rsub|M>e<rsup|O<around|(|<frac|log log
    M|log M>|)>*N>> many of these. Moreover, by our assumption on
    <math|X<rsub|1>> we only need to look at sets
    <math|\<cal-V\>\<subset\><around|[|0,N-1|]>> with
    <math|<around|\||\<cal-V\>|\|>\<geq\><around|(|\<mu\><around|(|X<rsub|\<geq\>M>|)>-\<epsilon\>|)>*N>.
    On the other hand, Proposition<nbsp><reference|prop:mainn> gives that
    each of those sets <math|Q<around|(|\<cal-V\>|)>> can be covered by
    <math|\<ll\><rsub|M>e<rsup|O<around|(|<frac|log log M|log
    M>|)>*N>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|N-<frac|1|2><around|\||\<cal-V\>|\|>|)>>>
    Bowen <math|N>-balls. Together we see that <math|Z> can be covered by

    <\equation*>
      \<ll\><rsub|M>e<rsup|O<around|(|<frac|log log M|log
      M>|)>*N>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|N-<frac|1|2><around|\||\<cal-V\>|\|>|)>>
    </equation*>

    Bowen <math|N>-balls. Applying Lemma<nbsp><reference|lem:entropy> we
    arrive at

    <eqnarray*|<tformat|<table|<row|<cell|h<rsub|\<mu\>><around|(|<T>|)>>|<cell|\<leq\>>|<cell|liminf<rsub|N\<to\>\<infty\>>
    <frac|log B*C<around|(|N,\<epsilon\>|)>|N>>>|<row|<cell|>|<cell|\<le\>>|<cell|h<rsub|max><around|(|<T>|)>*<around*|(|1-<frac|<around|(|\<mu\><around|(|X<rsub|\<geq\>M>|)>-\<epsilon\>|)>|2>|)>+O<around*|(|<frac|log
    log M|log M>|)>.>>>>>

    Since <math|\<epsilon\>\<gtr\>0> was arbitrary, we get that

    <\equation>
      <label|eqn:mainthm>h<rsub|\<mu\>><around|(|<T>|)>\<leq\>h<rsub|max><around|(|<T>|)>*<around*|(|1-<frac|\<mu\><around|(|X<rsub|\<geq\>M>|)>|2>|)>+O<around*|(|<frac|log
      log M|log M>|)>
    </equation>

    which can be rewritten as

    <\equation*>
      \<mu\><around|(|X<rsub|\<less\>M>|)>\<ge\>1-<frac|2|h<rsub|max><around|(|<T>|)>>*<around|(|h<rsub|max><around|(|T|)>-h<rsub|\<mu\>><around|(|T|)>|)>+\<phi\><around|(|M|)>
    </equation*>

    where <math|\<phi\><around|(|M|)>=O<around*|(|<frac|log log M|log M>|)>>.

    In the next we will show that the theorem holds for any
    <math|M\<gtr\>M<rsub|0>\<assign\>max <around|{|e<rsup|3*h<rsub|max><around|(|<T>|)>>,100|}>>.
    Clearly the theorem holds if <math|\<mu\><around|(|X<rsub|\<less\>M<rsub|0>>|)>\<gtr\>0>
    so that we may assume <math|\<mu\><around|(|X<rsub|\<less\>M<rsub|0>>|)>=0>.
    Let us define the number <math|M<rsub|\<mu\>>> by

    <\equation*>
      M<rsub|\<mu\>>\<assign\>inf <around|{|M\<gtr\>M<rsub|0>:\<mu\><around|(|X<rsub|\<less\>M>|)>\<gtr\>0|}>.
    </equation*>

    The above argument implies that <eqref|eqn:mainthm> holds for any
    <math|M\<gtr\>M<rsub|\<mu\>>>. If <math|\<mu\><around|(|X<rsub|\<less\>M<rsub|\<mu\>>>|)>\<gtr\>0>
    then <eqref|eqn:mainthm> also holds for <math|M=M<rsub|\<mu\>>>.
    Otherwise if <math|\<mu\><around|(|X<rsub|\<less\>M<rsub|\<mu\>>>|)>=0>
    then

    <\equation*>
      lim<rsub|n\<to\>\<infty\>> \<mu\><around|(|X<rsub|\<ge\>M<rsub|\<mu\>>+<frac|1|n>>|)>=\<mu\><around|(|X<rsub|\<gtr\>M<rsub|\<mu\>>>|)>=\<mu\><around|(|X<rsub|\<ge\>M<rsub|\<mu\>>>|)>=1.
    </equation*>

    Now, using <eqref|eqn:mainthm> for <math|M+1/n> instead of <math|M> and
    taking the limit as <math|n\<to\>\<infty\>> we get <eqref|eqn:mainthm>
    for <math|M=M<rsub|\<mu\>>>. For any <math|M\<in\><around|[|M<rsub|0>,M<rsub|\<mu\>>|)>>
    we need to prove that <eqref|eqn:mainthm> holds. Since
    <math|\<mu\><around|(|X<rsub|\<ge\>M>|)>=1> for
    <math|M\<le\>M<rsub|\<mu\>>> we see that <eqref|eqn:mainthm> simplifies
    to

    <\equation*>
      h<rsub|\<mu\>><around|(|<T>|)>\<leq\><frac|h<rsub|max><around|(|<T>|)>|2>+O<around*|(|<frac|log
      log M|log M>|)>.
    </equation*>

    Since <math|<frac|log log M|log M>> is decreasing for <math|M\<ge\>100>
    and since the above equation holds for <math|M=M<rsub|\<mu\>>> it clearly
    holds for any <math|M\<in\><around|[|M<rsub|0>,M<rsub|\<mu\>>|)>>.

    For any <math|M\<gtr\>max <around|{|e<rsup|3*h<rsub|max><around|(|<T>|)>>,100|}>>,
    one can approximate the characteristic function of
    <math|X<rsub|\<less\>M>> by continuous functions with compact support and
    use <eqref|eqn:mainthm> to obtain the last part of the theorem.
  </proof>

  <section|Partitions><label|sec:partitions>

  For given <math|M,N\<ge\>1> we recall the partition
  <math|Q<rsub|M,N>\<assign\><big|vee><rsub|n=0><rsup|N-1><T><rsup|-n><around|{|X<rsub|\<less\>M>,X<rsub|\<ge\>M>|}>>.
  In this section we estimate the upper bound for the cardinality of
  <math|Q<rsub|M,N>> to prove Lemma<nbsp><reference|lem:Q>. Later we consider
  the refinement <math|P<rsub|M,N>> of the original partition
  <math|Q<rsub|M,N>> which is crucial in obtaining
  Proposition<nbsp><reference|prop:main>.

  From now on, for simplicity, we assume that <math|a<rsub|j>\<ge\>0> for any
  <math|j\<in\><around|[|1,r+s|]>>. This in particular implies that the
  unstable subgroup <math|U<rsup|+>> is a subgroup of
  <with|font-shape|italic|lower> unipotent matrices in <math|G>. Also, with
  this assumption a component vector <math|<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>>
  under the iterations of <math|<T>> is getting short, that is
  <math|<around|\||<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|\|>\<gtr\><around|\||<around|(|v<rsub|j><rprime|'>*e<rsup|a<rsub|j>/2>,v<rsub|j><rprime|''>*e<rsup|-a<rsub|j>/2>|)>|\|>>,
  means that <math|<around|\||v<rsub|j><rprime|'>|\|>\<gtr\><around|\||v<rsub|j><rprime|''>|\|>*e<rsup|a<rsub|j>/2>>
  as otherwise if <math|a<rsub|j>\<less\>0> then we would get
  <math|<around|\||v<rsub|j><rprime|''>|\|>\<gtr\><around|\||v<rsub|j><rprime|'>|\|>*e<rsup|a<rsub|j>/2>>.
  Hence, the assumption <math|a<rsub|j>\<ge\>0> is simply a matter of
  ordering the coordinates of component vectors.

  <subsection|Proof of Lemma<nbsp><reference|lem:Q>><label|sec:proofoflemma>

  For any <math|x>, the partition element of <math|Q<rsub|M,N>> containing
  <math|x> describes the time moments in <math|<around|[|0,N-1|]>> for which
  <math|x> stays above height <math|M> (and hence when it is below height
  <math|M>) under the action of <math|<T>>. So, we need to calculate the
  possible configurations of times in <math|<around|[|0,N-1|]>>. Our main
  tool to calculate the upper bound for the possible configurations is
  Lemma<nbsp><reference|lem:shortvector>. If there is a time when a point
  <math|x> (under the action of <math|<T>>) is above height <math|M> then
  there is a considerable gap until the next time (if any) when <math|x>
  reaches height <math|M> again. This is because the vectors in <math|x> can
  get short (under the action of <math|<T>>) at most once and for another
  vector in <math|x> to become short the earlier vector has to become of norm
  1 at least. Now, we explicate the above discussion. Assume that for a
  vector <math|v\<in\><around|(|<R><rsup|2>|)><rsup|r>\<times\><around|(|<C><rsup|2>|)><rsup|s>>
  we have <math|<around|\<\|\|\>|v|\<\|\|\>>=<big|prod><rsub|j=1><rsup|r+s><around|\||<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|\|><rsup|\<delta\><rsub|j>>\<gtr\>1>.
  We would like to know an estimate for the smallest possible time <math|n>
  for which the vector <math|v> reaches the norm <math|\<le\>1/M> under the
  action of <math|<T>>. It is easy to see that the best possible <math|n>
  occurs for example when <math|v<rsub|j><rprime|'>=0> for
  <math|j=1,...,r+s>. In this case, at time <math|n> we must have

  <\equation*>
    <big|prod><rsub|j=1><rsup|r+s><around|\||<around|(|0,v<rsub|j><rprime|''>*e<rsup|-<around|(|i*\<theta\><rsub|j>+a<rsub|j>/2|)>*n>|)>|\|><rsup|\<delta\><rsub|j>>\<le\><frac|1|M>.
  </equation*>

  Since <math|<around|\<\|\|\>|v|\<\|\|\>>\<gtr\>1>, we must have
  <math|e<rsup|-<frac|n|2>*<big|sum><rsub|j=1><rsup|r+s>a<rsub|j>*\<delta\><rsub|j>>\<less\>1/M>which
  gives

  <\equation*>
    n\<ge\><frac|2*log M|h<rsub|r>+2*h<rsub|s>>.
  </equation*>

  Similarly, for a vector of norm at most <math|1/M>, under the action of
  <math|<T>>, the smallest possible time moment when the norm becomes greater
  than <math|1> is again <math|\<ge\><frac|2*log M|h<rsub|r>+2*h<rsub|s>>>.
  We also note that for any vector <math|v> in <math|x> if the sequence
  <math|<around|(|<around|\<\|\|\>|<T><rsup|n><around|(|v|)>|\<\|\|\>>|)><rsub|n\<ge\>0>>
  gets increased at some time then it becomes monotone increasing from that
  time moment. Thus, in a time interval of length
  <math|2<around|\<lfloor\>|<frac|2*log M|h<rsub|r>+2*h<rsub|s>>|\<rfloor\>>>,
  for any point <math|x> in <math|X> there can be at most one time interval
  on which <math|x> stays above height <math|M>. Hence,
  <math|Q<rsub|M,<around|\<lfloor\>|<frac|2*log
  M|h<rsub|r>+2*h<rsub|s>>|\<rfloor\>>>> has at most
  <math|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|2<around|\<lfloor\>|<frac|2*log
  M|h<rsub|r>+2*h<rsub|s>>|\<rfloor\>>>>|<row|<cell|2>>>>>|)>\<ll\>log<rsup|2>
  M> many elements. On the other hand, to obtain <math|Q<rsub|M,N>> we need
  to take refinements of <math|<around|\<lfloor\>|<frac|N|2<around|\<lfloor\>|<frac|2*log
  M|h<rsub|r>+2*h<rsub|s>>|\<rfloor\>>-1>|\<rfloor\>>> many pre-images of
  <math|Q<rsub|M,<around|\<lfloor\>|<frac|2*log
  M|h<rsub|r>+2*h<rsub|s>>|\<rfloor\>>>> and at most
  <math|2<around|\<lfloor\>|<frac|2*log M|h<rsub|r>+2*h<rsub|s>>|\<rfloor\>>-1>
  many of <math|<around|{|X<rsub|\<less\>M>,X<rsub|\<ge\>M>|}>>. For
  <math|M\<ge\>e<rsup|h<rsub|r>+2*h<rsub|s>>> we have

  <\equation*>
    <around*|\<lfloor\>|<frac|N|2<around|\<lfloor\>|<frac|2*log
    M|h<rsub|r>+2*h<rsub|s>>|\<rfloor\>>-1>|\<rfloor\>>\<less\><frac|N|<frac|4*log
    M|h<rsub|r>+2*h<rsub|s>>-3>\<le\><frac|N*<around|(|h<rsub|r>+2*h<rsub|s>|)>|log
    M>
  </equation*>

  Hence, we obtain that the cardinality of <math|Q<rsub|M,N>> is

  <\equation*>
    \<ll\><around|(|log<rsup|2> M|)><rsup|<frac|N*<around|(|h<rsub|r>+2*h<rsub|s>|)>|log
    M>>\<le\>e<rsup|<frac|2*<around|(|h<rsub|r>+2*h<rsub|s>|)>*log log M|log
    M>*N>.
  </equation*>

  <math|\<Box\>>

  <subsection|The refined partition <math|P<rsub|M,N>>>

  We now consider the refinement <math|P<rsub|M,N>> of <math|Q<rsub|M,N>>. It
  is a bit technical and the reason why this refinement is needed comes from
  the product structure of the space <math|G> and in particular the way we
  define the height function <math|<h><around|(|\<cdummy\>|)>>. The partition
  elements of <math|Q<rsub|M,N>> give information as when the trajectory of a
  point under <math|<T>> goes into the cusp and when it comes back. Due to
  the way the height <math|<h><around|(|\<cdummy\>|)>> is defined this does
  not provide much information on individual components
  <math|<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>> of the short
  vectors <math|v\<in\><around|(|<R><rsup|2>|)><rsup|r>\<times\><around|(|<C><rsup|2>|)><rsup|s>>
  even if we know that <math|<around|\<\|\|\>|<T><rsup|n>v|\<\|\|\>>> is
  decreasing on some time interval in <math|<around|[|0,N-1|]>>. Thus, what
  we really need is a partitioning of the space <math|X> which describes
  whether components of short vectors under iterates of <math|<T>> decreases
  or increases. On the other hand, if a component vector gets shorter in
  <math|n> iterates under <math|<T>>, that is, if
  <math|<around|\||<T><rsup|n><around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|\|>=<around|\||<around|(|v<rsub|j><rprime|'>*e<rsup|n*a<rsub|j>/2>,v<rsub|j><rprime|''>*e<rsup|-n*a<rsub|j>/2>|)>|\|>\<le\><around|\||<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|\|>>,
  then it is easy to see that we must have
  <math|<around|\||v<rsub|j><rprime|'>|\|>*e<rsup|n*a<rsub|j>/2>\<le\><around|\||v<rsub|j><rprime|''>|\|>>.
  This simple observation hints the importance of knowing the ratios
  <math|<frac|<around|\||v<rsub|j><rprime|'>|\|>|<around|\||v<rsub|j><rprime|''>|\|>>>
  of component vectors. Thus, elements of our new partition
  <math|P<rsub|M,N>> should describe these ratios (cf.
  <eqref|eqn:Q(J<rsub|m>)>) of component vectors of short vectors as we
  define now.

  Our goal is to refine the partition <math|Q<rsub|M,N>> further by
  partitioning most of its elements. Let <math|Q> be one of its elements.
  Then there exists <math|\<cal-V\>\<subset\><around|[|0,N-1|]>> such that

  <multline|<tformat|<table|<row|<cell|<label|eqn:Q(V)>Q\<assign\>Q<around|(|\<cal-V\>|)>>>|<row|<cell|=<around|{|x\<in\>X:<text|for
  all >n\<in\><around|[|0,N-1|]>,<T><rsup|n><around|(|x|)>\<in\>X<rsub|\<ge\>M>*<text|if
  and only if >n\<in\>\<cal-V\>|}>.>>>>>

  We split <math|\<cal-V\>> into maximal intervals
  <math|V<rsup|\<cal-V\>><rsub|1>,\<ldots\>,V<rsup|\<cal-V\>><rsub|k>> for
  some <math|k\<in\><N>>. For <math|m=1,2,\<ldots\>,k> we write
  <math|V<rsup|\<cal-V\>><rsub|m>=<around|[|b<rsup|\<cal-V\>><rsub|m>,b<rsup|\<cal-V\>><rsub|m>+\<ell\><rsup|\<cal-V\>><rsub|m>|]>>.

  For any <math|j\<in\><around|[|1,r+s|]>> recall the fixed number
  <math|a<rsub|j>> appeared in the definition of <math|<T>>. For each
  <math|j\<in\><around|[|1,r+s|]>> and <math|m\<in\><around|{|1,2,\<ldots\>,k|}>>
  let us decompose the extended reals into the following
  <math|\<ell\><rsub|m><rsup|\<cal-V\>>+2> subintervals:

  <align|<tformat|<table|<row|<cell|<label|eqn:I>I<rsub|0,j><around|(|V<rsup|\<cal-V\>><rsub|m>|)>>|<cell|=[-\<infty\>,b<rsub|m><rsup|\<cal-V\>>],<space|0.17em>I<rsub|\<ell\><rsub|m><rsup|\<cal-V\>>+1,j><around|(|V<rsup|\<cal-V\>><rsub|m>|)>=<around|(|b<rsub|m><rsup|\<cal-V\>>+\<ell\><rsub|m><rsup|\<cal-V\>>*a<rsub|j>,\<infty\>|]>,>>|<row|<cell|I<rsub|n,j><around|(|V<rsup|\<cal-V\>><rsub|m>|)>>|<cell|=<around|(|b<rsub|m><rsup|\<cal-V\>>+<around|(|n-1|)>*a<rsub|j>,b<rsub|m><rsup|\<cal-V\>>+n*a<rsub|j>|]>*<text|for
  >n\<in\><around|[|1,\<ell\><rsub|m><rsup|\<cal-V\>>|]>.>>>>>

  We write

  <\equation*>
    \<cal-I\><rsub|j><around|(|V<rsup|\<cal-V\>><rsub|m>|)>=<around|{|I<rsub|n,j><around|(|V<rsup|\<cal-V\>><rsub|m>|)>:n\<in\><around|[|0,\<ell\><rsub|m><rsup|\<cal-V\>>+1|]>|}>*<text|for
    >m\<in\><around|{|1,2,\<ldots\>,k|}>*<text|and
    >j\<in\><around|[|1,r+s|]>.
  </equation*>

  We first note that for any <math|x\<in\>Q> there exists a unique primitive
  vector <math|v\<in\><T><rsup|b<rsub|m><rsup|\<cal-V\>>-1><around|(|x|)>>
  such that

  <\equation>
    <label|eqn:vm><around|\<\|\|\>|<T><rsup|n><around|(|v|)>|\<\|\|\>>\<le\><frac|1|M>*<text|for
    >n\<in\><around|[|1,\<ell\><rsub|m><rsup|\<cal-V\>>+1|]>.
  </equation>

  We fix <math|m\<in\><around|{|1,2,\<ldots\>,k|}>> and for each
  <math|j\<in\><around|[|1,r+s|]>> we pick one interval
  <math|J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>> from the set
  <math|\<cal-I\><rsub|j><around|(|V<rsup|\<cal-V\>><rsub|m>|)>> and consider
  the product set

  <\equation>
    <label|eqn:J>J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>=J<rsub|1><around|(|V<rsub|m><rsup|\<cal-V\>>|)>\<times\>\<cdots\>\<times\>J<rsub|r+s><around|(|V<rsub|m><rsup|\<cal-V\>>|)>.
  </equation>

  Now, for any such product set <math|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>>
  we associate a partition element, which could be empty, in <math|Q> given
  by

  <multline|<tformat|<table|<row|<cell|<label|eqn:Q(J>Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>\<assign\>{x\<in\>Q:\<exists\>v\<in\><T><rsup|b<rsub|m><rsup|\<cal-V\>>-1><around|(|x|)><text|such
  that ><eqref|e*q*n:v*m><text|holds and >>>|<row|<cell|<around|\||v<rsub|j><rprime|''>|\|>=<around|\||v<rsub|j><rprime|'>|\|>*e<rsup|s<rsub|j>>*<text|for
  some >s<rsub|j>\<in\>J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>-b<rsub|m><rsup|\<cal-V\>>}.>>>>>

  For any <math|m\<in\><around|{|1,2,\<ldots\>,k|}>> we fix one partition
  element <math|Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>> as in
  <eqref|eqn:Q(J<rsub|m>)> and define the following further refined partition
  element

  <\equation>
    <label|eqn:P(V)>P<around|(|\<cal-V\>|)>=<big|cap><rsub|m=1><rsup|k>Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>.
  </equation>

  In this way, for any choice of <math|Q\<in\>Q<rsub|M,N>> and any choice of
  <math|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>> as in <eqref|eqn:J<rsub|m>>
  we obtain one partition element which is contained in <math|Q>. The
  collection of all possible <math|P<around|(|\<cal-V\>|)>> as in
  <eqref|eqn:P(V)> gives a refined partition <math|P<rsub|M,N>> of
  <math|Q<rsub|M,N>>.

  For further motivation why the partition <math|P<rsub|M,N>> is crucial we
  refer to <nbsp><reference|sec:res>, in particular see
  Lemma<nbsp><reference|lem:res>.

  <\lem>
    <label|lem:P>For <math|M\<gtr\>e<rsup|3*h<rsub|max><around|(|<T>|)>>> and
    <math|N\<in\><N>> the cardinality of the partition <math|P<rsub|M,N>>
    constructed above is <math|\<ll\>e<rsup|O<around|(|<frac|log log M|log
    M>|)>*N>> where the implied constants are independent of <math|M,N>.
  </lem>

  <\proof>
    Consider a partition element <math|Q<around|(|\<cal-V\>|)>> of
    <math|Q<rsub|M,N>> as in <eqref|eqn:Q(V)>. Let
    <math|Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>> be as in
    <eqref|eqn:Q(J<rsub|m>)> and <math|P<around|(|\<cal-V\>|)>> be as in
    <eqref|eqn:P(V)>. There are at most <math|<around|(|<around|\||V<rsub|m><rsup|\<cal-V\>>|\|>+2|)><rsup|r+s>>
    possible ways to choose <math|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>>
    and hence <math|<around|(|<around|\||V<rsub|m><rsup|\<cal-V\>>|\|>+2|)><rsup|r+s>>
    possible ways to choose <math|Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>>
    for a fixed <math|m\<in\><around|[|1,k|]>>. Thus, the number of partition
    elements of <math|P<rsub|M,N>> contained in
    <math|Q<around|(|\<cal-V\>|)>> is

    <multline*|<tformat|<table|<row|<cell|<around|(|<around|\||V<rsub|1><rsup|\<cal-V\>>|\|>+2|)><rsup|r+s>*<around|(|<around|\||V<rsub|2><rsup|\<cal-V\>>|\|>+2|)><rsup|r+s>*\<cdots\>*<around|(|<around|\||V<rsub|k><rsup|\<cal-V\>>|\|>+2|)><rsup|r+s>>>|<row|<cell|=exp
    <around*|(|<around|(|r+s|)>*<around|[|log
    <around|(|<around|\||V<rsub|1><rsup|\<cal-V\>>|\|>+2|)>+log
    <around|(|<around|\||V<rsub|2><rsup|\<cal-V\>>|\|>+2|)>+\<cdots\>+log
    <around|(|<around|\||V<rsub|k><rsup|\<cal-V\>>|\|>+2|)>|]>|)>.>>>>>

    This is

    <\equation*>
      \<ll\>exp <around|(|<around|(|r+s|)>*log
      <around|(|<around|\||V<rsub|1><rsup|\<cal-V\>>|\|><around|\||V<rsub|2><rsup|\<cal-V\>>|\|>...<around|\||V<rsub|k><rsup|\<cal-V\>>|\|>|)>|)>.
    </equation*>

    We have

    <\equation*>
      <around|\||V<rsub|1><rsup|\<cal-V\>>|\|><around|\||V<rsub|2><rsup|\<cal-V\>>|\|>...<around|\||V<rsub|k><rsup|\<cal-V\>>|\|>\<le\><around*|(|<frac|<around|\||V<rsub|1><rsup|\<cal-V\>>|\|>+<around|\||V<rsub|2><rsup|\<cal-V\>>|\|>+...+<around|\||V<rsub|k><rsup|\<cal-V\>>|\|>|k>|)><rsup|k>\<le\><around*|(|<frac|N|k>|)><rsup|k>.
    </equation*>

    Also, note that for the function <math|f<around|(|x|)>=<around|(|<frac|N|x>|)><rsup|x>=<around|(|N|)><rsup|x>*e<rsup|-x*log
    x>> its derivative

    <align*|<tformat|<table|<row|<cell|f<rprime|'><around|(|x|)>>|<cell|=<around|(|N|)><rsup|x>*log
    <around|(|N|)>*e<rsup|-x*log x>+<around|(|N|)><rsup|x>*e<rsup|-x*log
    x>(-log x-1)>>|<row|<cell|>|<cell|=<around|(|N|)><rsup|x>*e<rsup|-x*log
    x>*<around|(|log <around|(|N|)>-log x-1|)>.>>>>>

    Hence <math|f<around|(|x|)>=<around|(|<frac|N|x>|)><rsup|x>> is
    increasing on <math|<around|[|1,<frac|N|e>|]>>. On the other hand, from
    the proof of Lemma<nbsp><reference|lem:Q> we know that

    <\equation*>
      k\<le\><around*|\<lceil\>|<frac|N|2<around|\<lfloor\>|<frac|2*log
      M|h<rsub|r>+2*h<rsub|s>>|\<rfloor\>>>|\<rceil\>>\<le\><around*|\<lceil\>|<frac|<around|(|h<rsub|r>+2*h<rsub|s>|)>*N|2*log
      M>|\<rceil\>>\<le\>max <around*|{|1,<frac|<around|(|h<rsub|r>+2*h<rsub|s>|)>*N|log
      M>|}>.
    </equation*>

    If <math|k=1> then <math|<around|(|<frac|N|k>|)><rsup|k>=N>. Otherwise,
    <math|k\<le\><frac|<around|(|h<rsub|r>+2*h<rsub|s>|)>*N|log M>> and for
    <math|M\<ge\>e<rsup|e*<around|(|h<rsub|r>+2*h<rsub|s>|)>>> we have

    <\equation*>
      <around*|(|<frac|N|k>|)><rsup|k>\<le\><around*|(|<frac|N|<frac|<around|(|h<rsub|r>+2*h<rsub|s>|)>*N|log
      M>>|)><rsup|\<nosymbol\>>*<around|(|h<rsub|r>+2*h<rsub|s>|)>*Nlog
      M=<around*|(|<frac|log M|h<rsub|r>+2*h<rsub|s>>|)><rsup|\<nosymbol\>>*<around|(|h<rsub|r>+2*h<rsub|s>|)>*Nlog
      M.
    </equation*>

    Hence, the number of partition elements of <math|P<rsub|M,N>> contained
    in <math|Q<around|(|\<cal-V\>|)>> is <math|\<ll\>e<rsup|<around|(|r+s|)>*log
    <around|(|N|)>>> if <math|k=1> and otherwise it is

    <\equation*>
      \<ll\>exp <around*|(|<around|(|r+s|)>*log
      <around*|(|<around*|(|<frac|log M|r+s>|)><rsup|\<nosymbol\>>*<around|(|h<rsub|r>+2*h<rsub|s>|)>*Nlog
      M|)>|)>\<ll\>e<rsup|O<around|(|<frac|log log M|log M>|)>*N>.
    </equation*>

    In either case, the number of partition elements of <math|P<rsub|M,N>>
    contained in <math|Q<around|(|\<cal-V\>|)>> is
    <math|\<ll\>e<rsup|O<around|(|<frac|log log M|log M>|)>*N>>. Thus,
    together with Lemma<nbsp><reference|lem:Q> we deduce that
    <math|P<rsub|M,N>> has <math|\<ll\>e<rsup|O<around|(|<frac|log log M|log
    M>|)>*N>> elements for <math|M\<gtr\>e<rsup|3*h<rsub|max><around|(|<T>|)>>>.
  </proof>

  <section|Main proposition><label|sec:mainprop>

  In this section we calculate the number of Bowen <math|N>-balls needed to
  cover each partition element of <math|P<rsub|M,N>>. We recall that a Bowen
  <math|N>-ball is a translate of <math|B<rsub|N>=<big|cap><rsub|n=0><rsup|N-1>a<rsup|n>*B<rsub|\<eta\>><rsup|G>*a<rsup|-n>>
  in <math|X>. We note that the Bowen balls are balls in a different metric
  that induces the same topology.

  Let <math|M,N\<ge\>1> be given. Let <math|P<around|(|\<cal-V\>|)>> be a
  partition element of <math|P<rsub|M,N>> as in <eqref|eqn:P(V)> such that
  <math|P<around|(|\<cal-V\>|)>\<subset\>X<rsub|\<less\>M>>. We recall that
  by definition <math|\<cal-V\>> is a subset of <math|<around|[|0,N-1|]>> and
  for all <math|n\<in\><around|[|0,N-1|]>> we have that
  <math|<T><rsup|n><around|(|x|)>\<in\>X<rsub|\<ge\>M>> if and only if
  <math|n\<in\>\<cal-V\>>. In particular, the additional restrictive
  assumption above is equivalent to <math|\<cal-V\>> being in
  <math|<around|(|0,N-1|]>>.

  <\prop>
    <label|prop:main>The partition element
    <math|P<around|(|\<cal-V\>|)>\<in\>P<rsub|M,N>> with
    <math|P<around|(|\<cal-V\>|)>\<subset\>X<rsub|\<less\>M>> can be covered
    by

    <\equation*>
      \<ll\><rsub|M>c<rsub|0><rsup|<frac|h<rsub|max><around|(|<T>|)>|log
      M>*N>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|N-<frac|<around|\||\<cal-V\>|\|>|2>|)>>
    </equation*>

    Bowen <math|N>-balls for some universal constant <math|c<rsub|0>\<ge\>1>.
  </prop>

  <\proof>
    <dueto|Proof of Proposition<nbsp><reference|prop:mainn>>We note that we
    partitioned any element <math|Q<around|(|\<cal-V\>|)>\<in\>Q<rsub|M,N>>
    into elements <math|P<around|(|\<cal-V\>|)>> of <math|P<rsub|M,N>>. From
    Lemma<nbsp><reference|lem:P> we know that there are at most
    <math|\<ll\>e<rsup|O<around|(|<frac|log log M|log M>|)>*N>> such elements
    of <math|P<rsub|M,N>> for <math|M\<gtr\>e<rsup|3*h<rsub|max><around|(|<T>|)>>>.
    On the other hand, using Proposition<nbsp><reference|prop:main> we deduce
    that each such element <math|P<around|(|\<cal-V\>|)>> can be covered by
    <math|\<ll\><rsub|M>c<rsub|0><rsup|<frac|h<rsub|max><around|(|<T>|)>|log
    M>*N>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|N-<frac|<around|\||\<cal-V\>|\|>|2>|)>>>
    Bowen <math|N>-balls. By enlarging the implicit constant in
    <math|O<around|(|\<cdummy\>|)>> we may assume that
    <math|c<rsub|0><rsup|<frac|h<rsub|max><around|(|<T>|)>|log
    M>*N>\<le\>e<rsup|O<around|(|<frac|log log M|log M>|)>*N>>. Thus, we
    conclude that any partition element <math|Q<around|(|\<cal-V\>|)>> with
    <math|\<cal-V\>\<in\><around|(|0,N-1|]>> can be covered by
    <math|\<ll\><rsub|M>e<rsup|O<around|(|<frac|log log M|log
    M>|)>*N>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|N-<frac|<around|\||\<cal-V\>|\|>|2>|)>>>
    Bowen <math|N>-balls which completes the proof.
  </proof>

  We now return to the statement of Proposition<nbsp><reference|prop:main>.
  Roughly, we note that since the number of elements of <math|P<rsub|M,N>> is
  slow exponential as <math|N\<to\>\<infty\>>, to calculate the entropy it is
  sufficient to consider the covers of each partition element
  <math|P<rsub|M,N>> by Bowen balls. Since we only need to count the number
  of covers of most of the space <math|X> (cf.
  Lemma<nbsp><reference|lem:entropy>) it is reasonable to consider only the
  partitions <math|P<around|(|\<cal-V\>|)>\<in\>P<rsub|M,N>> with
  <math|P<around|(|\<cal-V\>|)>\<subset\>X<rsub|\<less\>M>>. It is not hard
  to show that each such partition element <math|P<around|(|\<cal-V\>|)>> can
  be covered by <math|\<ll\>e<rsup|h<rsub|max><around|(|<T>|)>*N>> Bowen
  <math|N>-balls. Thus, the significant factor in
  Proposition<nbsp><reference|prop:main> is
  <math|e<rsup|-<frac|h<rsub|max><around|(|<T>|)>|2><around|\||\<cal-V\>|\|>>>.
  Before we start proving Proposition<nbsp><reference|prop:main> we need some
  preliminary preparations.

  <subsection|Restrictions of perturbations><label|sec:res>

  If there are two points in <math|X<rsub|\<less\>M>> which are
  <math|\<eta\>>-close to each other such that they both stay above height
  <math|M> for some time interval, then we would like to say that these
  points must be even closer to each other in the unstable direction
  <math|U<rsup|+>>. This is not true in general. However, if additionally we
  know that they are in the same partition element of <math|P<rsub|M,N>> then
  we will show that this is indeed the case.

  As before let <math|U<rsup|+>,<space|0.17em>U<rsup|->,<space|0.17em>L> be
  the unstable, stable, and centralizer subgroups of <math|G> w.r.t. <math|a>
  respectively. We naturally embed <math|U<rsup|+>> into
  <math|<R><rsup|r>\<times\><C><rsup|s>>. We let
  <math|u<rsup|+><around|(|<with|font-series|bold|t>|)>\<in\>U<rsup|+>> be
  the element that corresponds to <math|<with|font-series|bold|t>=<around|(|t<rsub|1>,t<rsub|2>,\<ldots\>,t<rsub|r+s>|)>\<in\><R><rsup|r>\<times\><C><rsup|s>>.
  For the rest of the section we fix one <math|P<around|(|\<cal-V\>|)>\<in\>P<rsub|M,N>>
  as in <eqref|eqn:P(V)>. Recall that <math|V<rsub|m><rsup|\<cal-V\>>=<around|[|b<rsub|m><rsup|\<cal-V\>>,b<rsub|m><rsup|\<cal-V\>>+\<ell\><rsub|m><rsup|\<cal-V\>>|]>,m=1,2,\<ldots\>,k>
  are the maximal intervals such that <math|\<cal-V\>=\<cup\><rsub|m=1><rsup|k>V<rsub|m><rsup|\<cal-V\>>>.
  We fix <math|V<rsub|m><rsup|\<cal-V\>>> for some <math|m=1,\<ldots\>,k> and
  for simplicity we denote <math|V<rsub|m><rsup|\<cal-V\>>=<around|[|b,b+\<ell\>|]>>.
  From <eqref|eqn:P(V)> we know that <math|P<around|(|\<cal-V\>|)>=<big|cap><rsub|m=1><rsup|k>Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>>
  for some <math|Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>> as in
  <eqref|eqn:Q(J<rsub|m>)>, namely

  <multline|<tformat|<table|<row|<cell|<label|eqn:Q(J>Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>\<assign\>{x\<in\>Q:\<exists\>v\<in\><T><rsup|b-1><around|(|x|)><text|such
  that ><eqref|e*q*n:v*m><text|holds and >>>|<row|<cell|<around|\||v<rsub|j><rprime|''>|\|>=<around|\||v<rsub|j><rprime|'>|\|>*e<rsup|s<rsub|j>>*<text|for
  some >s<rsub|j>\<in\>J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>-b}.>>>>>

  <\lem>
    <label|lem:res>Let <math|x,y\<in\>P<around|(|\<cal-V\>|)>\<cap\><T><rsup|N-1><around|(|X<rsub|\<less\>M>|)>>
    with <math|<T><rsup|b-1><around|(|y|)>=<T><rsup|b-1><around|(|x|)>*u<rsup|+><around|(|<with|font-series|bold|t>|)>*g>
    for some <math|u<rsup|+><around|(|<with|font-series|bold|t>|)>\<in\>B<rsub|\<eta\>/2><rsup|U<rsup|+>>>
    and <math|g\<in\>B<rsub|\<eta\>/2><rsup|U<rsup|->*L>>. Then for any
    <math|j\<in\><around|{|1,2,\<ldots\>,r+s|}>> we have
    <math|<around|\||t<rsub|j>|\|>\<ll\>e<rsup|b-n<rsub|j>>> where
    <math|n<rsub|j>> is the left end point of the interval
    <math|J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>>.
  </lem>

  <\proof>
    If <math|J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>=[-\<infty\>,b]=I<rsub|0,j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>>
    then <math|n<rsub|j>=-\<infty\>> and in this case the lemma is trivial.
    So, we may assume <math|J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>\<neq\>I<rsub|0,j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>>
    so that <math|n<rsub|j>\<ge\>b>.

    By maximality of <math|V<rsub|m><rsup|\<cal-V\>>> and the fact that
    <math|\<cal-V\>\<subset\><around|(|0,N-1|]>> we know that

    <align*|<tformat|<table|<row|<cell|<T><rsup|b-1><around|(|x|)>,<T><rsup|b-1><around|(|y|)>>|<cell|\<in\>X<rsub|\<less\>M><text|and
    >>>|<row|<cell|<T><rsup|n><around|(|<T><rsup|b-1><around|(|x|)>|)>,<T><rsup|n><around|(|<T><rsup|b-1><around|(|y|)>|)>>|<cell|\<in\>X<rsub|\<ge\>M>*<text|for
    any >n\<in\><around|[|1,l+1|]>.>>>>>

    Thus there exist vectors <math|v\<in\><T><rsup|b-1><around|(|x|)>> and
    <math|w\<in\><T><rsup|b-1><around|(|y|)>> such that <eqref|eqn:vm> holds,
    that is

    <\equation>
      <label|eqn:vmw><around|\<\|\|\>|<T><rsup|n><around|(|v|)>|\<\|\|\>>,<around|\<\|\|\>|<T><rsup|n><around|(|w|)>|\<\|\|\>>\<le\>1/M*<text|for
      >n\<in\><around|[|1,\<ell\>+1|]>.
    </equation>

    On the other hand, from <eqref|eqn:Q(J<rsub|m>)'> for <math|v,w> in the
    standard notation we know that

    <\equation*>
      <around|\||v<rsub|j><rprime|''>|\|>=<around|\||v<rsub|j><rprime|'>|\|>*e<rsup|s<rsub|j>><text|and
      ><around|\||w<rsub|j><rprime|''>|\|>=<around|\||w<rsub|j><rprime|'>|\|>*e<rsup|r<rsub|j>>*<text|for
      some >s<rsub|j>,r<rsub|j>\<in\>J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>-b.
    </equation*>

    We note that <math|v<rsub|j><rprime|''>\<neq\>0\<neq\>w<rsub|j><rprime|''>>
    since <math|<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>,<around|(|w<rsub|j><rprime|'>,w<rsub|j><rprime|''>|)>\<neq\><around|(|0,0|)>>
    (they are rows of matrices of determinant equal to 1) and
    <math|s<rsub|j>,r<rsub|j>\<ge\>0>. In particular, if <math|n<rsub|j>> is
    the left end point of the interval <math|J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>>
    then we have

    <\equation>
      <label|eqn:vw><frac|<around|\||v<rsub|j><rprime|'>|\|>|<around|\||v<rsub|j><rprime|''>|\|>>\<le\>e<rsup|b-n<rsub|j>>*<text|and
      ><frac|<around|\||w<rsub|j><rprime|'>|\|>|<around|\||w<rsub|j><rprime|''>|\|>>\<le\>e<rsup|b-n<rsub|j>>.
    </equation>

    Also, we know that <math|w=v*u<rsup|+><around|(|<with|font-series|bold|t>|)>*g>.
    So, for <math|g=<around|(|g<rsub|1>,\<ldots\>,g<rsub|r+s>|)>> we have
    <math|<around|(|w<rsub|j><rprime|'>,w<rsub|j><rprime|''>|)>=<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|1>|<cell|0>>|<row|<cell|t<rsub|j>>|<cell|1>>>>>|)>*g<rsub|j>=<around|(|v<rsub|j><rprime|'>+t<rsub|j>*v<rsub|j><rprime|''>,v<rsub|j><rprime|''>|)>*g<rsub|j>>
    (under the assumption that <math|a<rsub|j>\<ge\>0> where <math|a<rsub|j>>
    is as in the definition of <math|a>). For
    <math|g<rsub|j>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|d>|<cell|u>>|<row|<cell|0>|<cell|1/d>>>>>|)>>
    we obtain that

    <\equation*>
      <around|(|w<rsub|j><rprime|'>,w<rsub|j><rprime|''>|)>=<around|(|d*<around|(|v<rsub|j><rprime|'>+t<rsub|j>*v<rsub|j><rprime|''>|)>,u*<around|(|v<rsub|j><rprime|'>+t<rsub|j>*v<rsub|j><rprime|''>|)>+v<rsub|j><rprime|''>/d|)>.
    </equation*>

    Now from <eqref|eqn:vw> we get

    <\equation*>
      e<rsup|b-n<rsub|j>>\<ge\><frac|<around|\||w<rsub|j><rprime|'>|\|>|<around|\||w<rsub|j><rprime|''>|\|>>=<frac|<around|\||d*<around|(|v<rsub|j><rprime|'>+t<rsub|j>*v<rsub|j><rprime|''>|)>|\|>|<around|\||u*<around|(|v<rsub|j><rprime|'>+t<rsub|j>*v<rsub|j><rprime|''>|)>+v<rsub|j><rprime|''>/d|\|>>\<gg\><frac|<around|\||v<rsub|j><rprime|'>+t<rsub|j>*v<rsub|j><rprime|''>|\|>|<around|\||v<rsub|j><rprime|''>|\|>>=<around*|\||<frac|v<rsub|j><rprime|'>|v<rsub|j><rprime|''>>+t<rsub|j>|\|>
    </equation*>

    since <math|d> is close to <math|1> and <math|u> is close to <math|0>.
    Together with <eqref|eqn:vw> we deduce that

    <\equation*>
      <around|\||t<rsub|j>|\|>\<ll\>e<rsup|b-n<rsub|j>>.
    </equation*>
  </proof>

  Lemma<nbsp><reference|lem:res> alone does not tell us if <math|x,y> should
  be even closer to each other in the unstable direction since for example
  <math|n<rsub|j>> could be equal to <math|b>. Even if
  <math|n<rsub|j>\<gtr\>b> we still do not know an effective lower bound for
  <math|n<rsub|j>>. This is because we have only considered one part of the
  defining properties of <math|Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>>.
  We have not considered the fact that <math|x,y> stay above height <math|M>
  in <math|<around|[|1,\<ell\>+1|]>>. In the next lemma we use this fact to
  obtain the relation among the intervals
  <math|J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>>.

  <\lem>
    <label|lem:relation>Let <math|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>> be
    as in <eqref|eqn:J<rsub|m>> and consider
    <math|x\<in\>Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>> with
    <math|v\<in\><T><rsup|b-1><around|(|x|)>> as in
    <eqref|eqn:Q(J<rsub|m>)'>. Let <math|S=<around|{|s<rsub|1>,...,s<rsub|r+s>|}>>
    and <math|<around|{|i<rsub|1>,...,i<rsub|L>|}>> be the subset of <math|S>
    which are <math|\<le\>0>, let <math|j<rsub|1>,...,j<rsub|C>> be the
    subset of <math|S> such that <math|s<rsub|j<rsub|i>>\<in\><around|(|0,<around|(|\<ell\>+1|)>*a<rsub|j<rsub|i>>|)>>,
    and let <math|k<rsub|1>,...,k<rsub|R>> be the subset of <math|S> such
    that <math|s<rsub|k<rsub|i>>\<gtr\><around|(|\<ell\>+1|)>*a<rsub|k<rsub|i>>>.
    In particular, <math|L+C+R=r+s>. Then

    <\equation*>
      <around|(|\<ell\>+1|)>*<around*|(|<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<big|sum><rsub|n=1><rsup|C><around|(|a<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>-<big|sum><rsub|n=1><rsup|R><around|(|a<rsub|k<rsub|n>>*k<rsub|k<rsub|n>>|)>|)>\<less\>2*<big|sum><rsub|n=1><rsup|C><around|(|s<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>.
    </equation*>
  </lem>

  <\proof>
    Let us consider the <math|j>-th component vector
    <math|<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>> of <math|v>.
    <math|<T>> acts on <math|v> and hence it acts on each of its components
    and we have

    <\equation*>
      <T><rsup|n><around|(|<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|)>=<around|(|v<rsub|j><rprime|'>*e<rsup|i*n*\<theta\><rsub|j>>*e<rsup|n*a<rsub|j>/2>,v<rsub|j><rprime|''>*e<rsup|-i*n*\<theta\><rsub|j>>*e<rsup|-n*a<rsub|j>/2>|)>
    </equation*>

    where as before <math|\<theta\><rsub|j>=0> if <math|j\<le\>r>, and
    <math|a<rsub|j>\<ge\>0> for any <math|j\<in\><around|[|1,r+s|]>>.Thus,

    <\equation*>
      <around|\||<T><rsup|n><around|(|<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|)>|\|>=max
      <around|{|<around|\||v<rsub|j><rprime|'>*e<rsup|n*a<rsub|j>/2>|\|>,<around|\||v<rsub|j><rprime|''>*e<rsup|-n*a<rsub|j>/2>|\|>|}>=<choice|<tformat|<table|<row|<cell|<around|\||v<rsub|j><rprime|''>|\|>*e<rsup|-n*a<rsub|j>/2>>|<cell|<text|if
      >n*a<rsub|j>\<less\>s<rsub|j>>>|<row|<cell|<around|\||v<rsub|j><rprime|'>|\|>*e<rsup|n*a<rsub|j>/2>>|<cell|<text|if
      >n*a<rsub|j>\<ge\>s<rsub|j>>>>>>
    </equation*>

    since <math|<around|\||v<rsub|j><rprime|'>|\|>*e<rsup|s<rsub|j>/2>=<around|\||v<rsub|j><rprime|''>|\|>*e<rsup|-s<rsub|j>/2>>.
    We also note that

    <\equation*>
      <around|\||<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|\|>=<choice|<tformat|<table|<row|<cell|<around|\||v<rsub|j><rprime|'>|\|>>|<cell|<text|if
      >s<rsub|j>\<le\>0>>|<row|<cell|<around|\||v<rsub|j><rprime|''>|\|>>|<cell|<text|if
      >s<rsub|j>\<gtr\>0>>>>>.
    </equation*>

    Together we get

    <\equation>
      <label|eqn:T><frac|<around|\||<T><rsup|\<ell\>+1><around|(|<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|)>|\|>|<around|\||<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|\|>>=<choice|<tformat|<table|<row|<cell|e<rsup|<frac|<around|(|\<ell\>+1|)>*a<rsub|j>|2>>>|<cell|<text|if
      >s<rsub|j>\<le\>0>>|<row|<cell|e<rsup|<frac|<around|(|\<ell\>+1|)>*a<rsub|j>|2>-s<rsub|j>>>|<cell|<text|if
      >s<rsub|j>\<in\><around|(|0,<around|(|\<ell\>+1|)>*a<rsub|j>|]>>>|<row|<cell|e<rsup|-<frac|<around|(|\<ell\>+1|)>*a<rsub|j>|2>>>|<cell|<text|if
      >s<rsub|j>\<gtr\><around|(|\<ell\>+1|)>*a<rsub|j>.>>>>>
    </equation>

    By the assumption <eqref|eqn:vm> on the vector
    <math|v\<in\><around|(|<R><rsup|2>|)><rsup|r>\<times\><around|(|<C><rsup|2>|)><rsup|s>>
    we have

    <\equation*>
      <around|\<\|\|\>|v|\<\|\|\>>\<gtr\><frac|1|M><text|and
      ><around|\<\|\|\>|<T><rsup|n><around|(|v|)>|\<\|\|\>>\<le\><frac|1|M>*<text|for
      >n\<in\><around|[|1,\<ell\>+1|]>.
    </equation*>

    In particular, this gives

    <\equation>
      <label|eqn:res><frac|<around|\<\|\|\>|<T><rsup|\<ell\>+1><around|(|v|)>|\<\|\|\>>|<around|\<\|\|\>|v|\<\|\|\>>>\<less\>1.
    </equation>

    Now, from <eqref|eqn:T<rsup|n>> and <eqref|eqn:res> we get

    <multline*|<tformat|<table|<row|<cell|<frac|<big|prod><rsub|j=1><rsup|r+s><around|\||<T><rsup|\<ell\>+1><around|(|<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|)>|\|><rsup|\<delta\><rsub|j>>|<big|prod><rsub|j=1><rsup|r+s><around|\||<around|(|v<rsub|j><rprime|'>,v<rsub|j><rprime|''>|)>|\|><rsup|\<delta\><rsub|j>>>>>|<row|<cell|=exp
    <around*|(|<frac|\<ell\>+1|2>*<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<frac|\<ell\>+1|2>*<big|sum><rsub|n=1><rsup|C><around|(|a<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>-<big|sum><rsub|n=1><rsup|C><around|(|s<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>-<frac|\<ell\>+1|2>*<big|sum><rsub|n=1><rsup|R><around|(|a<rsub|k<rsub|n>>*k<rsub|k<rsub|n>>|)>|)>\<less\>1.>>>>>

    The exponent simplifies to

    <\equation*>
      <around|(|\<ell\>+1|)>*<around*|(|<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<big|sum><rsub|n=1><rsup|C><around|(|a<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>-<big|sum><rsub|n=1><rsup|R><around|(|a<rsub|k<rsub|n>>*k<rsub|k<rsub|n>>|)>|)>\<less\>2*<big|sum><rsub|n=1><rsup|C><around|(|s<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>.
    </equation*>
  </proof>

  The next lemma shows how we apply the above two lemmas. The reader can skip
  the lemma and come back when it is mentioned in the proof of
  Proposition<nbsp><reference|prop:main>. Recall the embedding of
  <math|U<rsup|+>> into <math|<R><rsup|r>\<times\><C><rsup|s>>.

  <\lem>
    <label|lem:vol>Let <math|V<rsub|m><rsup|\<cal-V\>>=<around|[|b,b+\<ell\>|]>>
    and <math|Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>> be as
    before and let <math|B<rprime|'>,B<rprime|''>> be given positive
    constants. Let us consider the set <math|D\<assign\><around|{|u<around|(|<with|font-series|bold|t>|)>\<in\>U<rsup|+>:<around|\||t<rsub|j>|\|>\<less\>B<rprime|'>*min
    <around|{|\<eta\>,e<rsup|b-n<rsub|j>>|}>,j=1,\<ldots\>,r+s|}>> where
    <math|n<rsub|j>> is the left end point of the interval
    <math|J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>>. Then the set
    <math|D> can be decomposed into

    <\equation*>
      \<ll\>e<rsup|<frac|h<rsub|max><around|(|<T>|)>|2>*\<ell\>>
    </equation*>

    disjoint sets of the form <math|E\<assign\><around|{|u<around|(|<with|font-series|bold|t>|)>\<in\>U<rsup|+>:<around|\||t<rsub|j>|\|>\<less\>B<rprime|''>*\<eta\>*e<rsup|-\<ell\>*a<rsub|j>>,j=1,\<ldots\>,r+s|}>>.
  </lem>

  It is easy to see that the set <math|E> is roughly the unstable part of a
  Bowen <math|\<ell\>>-ball which hints the relation to
  Proposition<nbsp><reference|prop:main>. One can see that a unit ball in
  <math|U<rsup|+>> can be covered by <math|\<ll\>e<rsup|h<rsub|max><around|(|<T>|)>*\<ell\>>>
  translates of the set <math|E>. However, from the lemma above we see that
  if we consider a subset of a unit ball in <math|U<rsup|+>> whose elements
  stay above height <math|M> under <math|<T>> on
  <math|<around|[|b,b+\<ell\>|]>> and moreover if the elements of this subset
  behave similarly, that is, if the set is in the partition
  <math|Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>> then we have
  save <math|h<rsub|max><around|(|<T>|)>*\<ell\>/2> in the exponent.

  <\proof>
    For any <math|j=1,2,\<ldots\>,r+s> let us consider the ball around 0 of
    radius <math|B<rprime|'>*min <around|{|\<eta\>,e<rsup|b-n<rsub|j>>|}>> in
    <math|<R>> or in <math|<C>> depending whether <math|j\<le\>r> or not and
    decompose it into the small balls of radius
    <math|B<rprime|''>*\<eta\>*e<rsup|-\<ell\>>>. If
    <math|n<rsub|j>\<less\>b> (in which case <math|n<rsub|j>=-\<infty\>>)
    then there are <math|\<ll\>e<rsup|\<ell\>*a<rsub|j>>> small subintervals
    if <math|j\<le\>r> and there are <math|\<ll\>e<rsup|2*\<ell\>*a<rsub|j>>>
    small balls if <math|j\<gtr\>r>. Suppose <math|n<rsub|j>\<ge\>b>. If
    <math|j\<le\>r> then there are <math|\<ll\>e<rsup|\<ell\>*a<rsub|j>+b-n<rsub|j>>>
    small subintervals and if <math|j\<gtr\>r> then there are
    <math|\<ll\>e<rsup|2*<around|(|\<ell\>*a<rsub|j>+b-n<rsub|j>|)>>> small
    balls. We note that if <math|n<rsub|j>\<ge\>b+\<ell\>*a<rsub|j>> (in
    which case <math|n<rsub|j>=b+\<ell\>*a<rsub|j>>) then there are
    <math|\<ll\>1> small subintervals or <math|\<ll\>1> small balls depending
    on <math|j>. We have <math|i<rsub|1>,...,i<rsub|L>,j<rsub|1>,...,j<rsub|C>,k<rsub|1>,...,k<rsub|R>>
    as in Lemma<nbsp><reference|lem:relation>. Now, let
    <math|i<rsub|1><rprime|'>,...,i<rsub|L<rprime|'>><rprime|'>> be the
    subset of <math|<around|{|i<rsub|1>,...,i<rsub|L>|}>> which are
    <math|\<le\>r> and <math|i<rsub|1><rprime|''>,...,i<rsub|L<rprime|''>><rprime|''>>
    be the rest. Similarly, we consider the subsets
    <math|j<rsub|1><rprime|'>,...,j<rsub|C<rprime|'>><rprime|'>> and
    <math|j<rsub|1><rprime|''>,...,j<rsub|C<rprime|''>><rprime|''>> of
    <math|j<rsub|1>,...,j<rsub|C>>.

    Therefore, the set <math|D> contains at most

    <align*|<tformat|<table|<row|<cell|\<ll\>>|<cell|1<rsup|R>*exp
    <around*|(|\<ell\>*<big|sum><rsub|n=1><rsup|L<rprime|'>>a<rsub|i<rsub|n><rprime|'>>+2*\<ell\>*<big|sum><rsub|n=1><rsup|L<rprime|''>>a<rsub|i<rsub|n><rprime|''>>+\<ell\>*<big|sum><rsub|n=1><rsup|C<rprime|'>>a<rsub|j<rsub|n><rprime|'>>+b*C<rprime|'>-<big|sum><rsub|n=1><rsup|C<rprime|'>>n<rsub|j<rsub|n><rprime|'>>+2*<around|(|\<ell\>*<big|sum><rsub|n=1><rsup|C<rprime|''>>a<rsub|j<rsub|n><rprime|''>>+b*C<rprime|''>-<big|sum><rsub|n=1><rsup|C<rprime|''>>n<rsub|j<rsub|n><rprime|''>>|)>|)>>>|<row|<cell|=>|<cell|<around*|\<nobracket\>|exp
    <around*|(|\<ell\>*<around*|(|<big|sum><rsub|n=1><rsup|L<rprime|'>>a<rsub|i<rsub|n><rprime|'>>+2*<big|sum><rsub|n=1><rsup|L<rprime|''>>a<rsub|i<rsub|n><rprime|''>>+<big|sum><rsub|n=1><rsup|C<rprime|'>>a<rsub|j<rsub|n><rprime|'>>+2*<big|sum><rsub|n=1><rsup|C<rprime|''>>a<rsub|j<rsub|n><rprime|''>>|)>+b*<around|(|C<rprime|'>+2*C<rprime|''>|)>-<big|sum><rsub|n=1><rsup|C<rprime|'>>n<rsub|j<rsub|n><rprime|'>>-2*<big|sum><rsub|n=1><rsup|C<rprime|''>>n<rsub|j<rsub|n><rprime|''>>|)>|)>>>|<row|<cell|=>|<cell|<around*|\<nobracket\>|exp
    <around*|(|\<ell\>*<around*|(|<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<big|sum><rsub|n=1><rsup|C><around|(|a<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>|)>+b*<big|sum><rsub|n=1><rsup|C>k<rsub|j<rsub|n>>-<big|sum><rsub|n=1><rsup|C><around|(|n<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>|)>|)>>>>>>

    many disjoint sets of the form <math|E>.

    On the other hand, Lemma<nbsp><reference|lem:relation> gives

    <\equation*>
      <around|(|\<ell\>+1|)>*<around*|(|<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<big|sum><rsub|n=1><rsup|C><around|(|a<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>-<big|sum><rsub|n=1><rsup|R><around|(|a<rsub|k<rsub|n>>*k<rsub|k<rsub|n>>|)>|)>\<less\>2*<big|sum><rsub|n=1><rsup|C><around|(|s<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>
    </equation*>

    where <math|s<rsub|j<rsub|k>>\<in\>J<rsub|j<rsub|k>><around|(|V<rsub|m><rsup|\<cal-V\>>|)>-b=<around|(|n<rsub|j<rsub|k>>-b,n<rsub|j<rsub|k>>+a<rsub|j<rsub|k>>-b|]>>.
    Thus,

    <\equation*>
      <around|(|\<ell\>+1|)>*<around*|(|<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<big|sum><rsub|n=1><rsup|C><around|(|a<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>-<big|sum><rsub|n=1><rsup|R><around|(|a<rsub|k<rsub|n>>*k<rsub|k<rsub|n>>|)>|)>\<less\>2*<big|sum><rsub|n=1><rsup|C><around|(|<around|(|n<rsub|j<rsub|n>>+a<rsub|j<rsub|n>>-b|)>*k<rsub|j<rsub|n>>|)>
    </equation*>

    and since <math|<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<big|sum><rsub|n=1><rsup|C><around|(|a<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>+<big|sum><rsub|n=1><rsup|R><around|(|a<rsub|k<rsub|n>>*k<rsub|k<rsub|n>>|)>=h<rsub|r>+2*h<rsub|s>=h<rsub|max><around|(|<T>|)>>
    we obtain

    <\equation*>
      <around|(|\<ell\>+1|)>*<around*|(|2*<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+2*<big|sum><rsub|n=1><rsup|C><around|(|a<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>-h<rsub|max><around|(|<T>|)>|)>\<less\>2*<big|sum><rsub|n=1><rsup|C><around|(|<around|(|n<rsub|j<rsub|n>>+a<rsub|j<rsub|n>>-b|)>*k<rsub|j<rsub|n>>|)>.
    </equation*>

    Dividing both sides by <math|2> and simplifying the expression we get

    <multline*|<tformat|<table|<row|<cell|\<ell\>*<around*|(|<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<big|sum><rsub|n=1><rsup|C><around|(|a<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>|)>+b*<big|sum><rsub|n=1><rsup|C>k<rsub|j<rsub|n>>-<big|sum><rsub|n=1><rsup|C><around|(|n<rsub|j<rsub|n>>*k<rsub|j<rsub|n>>|)>>>|<row|<cell|\<less\>-<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<frac|<around|(|\<ell\>+1|)>*h<rsub|max><around|(|<T>|)>|2>.>>>>>

    Hence, the set <math|D> can be decomposed into

    <align*|<tformat|<table|<row|<cell|>|<cell|\<ll\>exp
    <around*|(|-<big|sum><rsub|n=1><rsup|L><around|(|a<rsub|i<rsub|n>>*k<rsub|i<rsub|n>>|)>+<frac|<around|(|\<ell\>+1|)>*h<rsub|max><around|(|<T>|)>|2>|)>\<ll\>exp
    <around*|(|<frac|h<rsub|max><around|(|<T>|)>|2>*\<ell\>|)>>>>>>

    disjoint sets of the form <math|E>.
  </proof>

  <subsection|The proof of Proposition<nbsp><reference|prop:main>>

  Let <math|P<around|(|\<cal-V\>|)>\<in\>P<rsub|M,N>> be given. Since
  <math|X<rsub|\<less\>M>> is pre-compact it suffices to restrict ourselves
  to a neighborhood <math|\<cal-O\>> of some
  <math|x<rsub|0>\<in\>X<rsub|\<less\>M>\<cap\>P<around|(|\<cal-V\>|)>>. We
  let <math|\<cal-O\>=x<rsub|0>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>>
  be a neighborhood of such <math|x<rsub|0>\<in\>X<rsub|\<less\>M>> and
  define the set <math|P<rsub|\<cal-O\>><around|(|\<cal-V\>|)>> by

  <\equation*>
    P<rsub|\<cal-O\>><around|(|\<cal-V\>|)>=\<cal-O\>\<cap\>P<around|(|\<cal-V\>|)>.
  </equation*>

  It suffices to prove that the set <math|P<rsub|\<cal-O\>><around|(|\<cal-V\>|)>>
  can be covered by <math|\<ll\>c<rsub|0><rsup|<frac|h<rsub|max><around|(|<T>|)>*N|log
  M>>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|N-<frac|1|2><around|\||\<cal-V\>|\|>|)>>>
  Bowen <math|N>-balls for some universal constant <math|c<rsub|0>\<ge\>1>.

  Let us make some observations. If we consider the image of <math|\<cal-O\>>
  under <math|<T><rsup|n>> we obtain the set

  <\equation*>
    <T><rsup|n><around|(|\<cal-O\>|)>=<T><rsup|n><around|(|x<rsub|0>|)>*<around|(|a<rsup|-n>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|n>|)>*a<rsup|-n>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>*a<rsup|n>.
  </equation*>

  We see that the <math|j>th component of the <math|U<rsup|+>>-part gets
  stretched by the factor <math|e<rsup|n*a<rsub|j>>>. Here again we naturally
  embed <math|U<rsup|+>> into <math|<R><rsup|r>\<times\><C><rsup|s>>. Under
  this identification, dividing <math|<around|(|a<rsup|-n>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|n>|)>>
  into <math|<big|prod><rsub|j=1><rsup|r+s><around|\<lceil\>|e<rsup|n*a<rsub|j>>|\<rceil\>><rsup|\<delta\><rsub|j>>>
  many small parts we obtain the sets of the form

  <\equation*>
    <T><rsup|n><around|(|x<rsub|0>|)>*u<rsup|+>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|-n>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>*a<rsup|n>
  </equation*>

  for some <math|u<rsup|+>\<in\>U<rsup|+>>. Now, if we take the pre-image
  under <math|<T><rsup|n>> of these sets then we obtain the similar sets

  <\equation*>
    <T><rsup|-n><around|(|<T><rsup|n><around|(|x<rsub|0>|)>*u<rsup|+>|)>*a<rsup|n>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|-n>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>
  </equation*>

  as before. It is not hard to see that the set
  <math|<T><rsup|-n><around|(|<T><rsup|n><around|(|x<rsub|0>|)>*u<rsup|+>|)>*a<rsup|n>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|-n>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>>
  is contained in the forward Bowen <math|n>-ball
  <math|<T><rsup|-n><around|(|<T><rsup|n><around|(|x<rsub|0>|)>*u<rsup|+>|)>*B<rsub|n><rsup|+>>.
  This in particular shows that <math|\<cal-O\>> can be covered by
  <math|\<ll\>e<rsup|<around|(|h<rsub|r>+2*h<rsub|s>|)>*n>> many forward
  Bowen <math|n>-balls which is the reason why the maximal entropy
  <math|h<rsub|max><around|(|<T>|)>> is <math|h<rsub|r>+2*h<rsub|s>>.
  However, using Lemma<nbsp><reference|lem:vol> we will show that we in fact
  need fewer Bowen balls to cover the set <math|\<cal-O\>>.

  Let us recall that we decompose <math|\<cal-V\>> into ordered maximal
  subintervals <math|V<rsub|m><rsup|\<cal-V\>>> so that we have

  <\equation*>
    \<cal-V\>=V<rsub|1><rsup|\<cal-V\>>\<cup\>V<rsub|2><rsup|\<cal-V\>>\<cup\>...\<cup\>V<rsub|k><rsup|\<cal-V\>>.
  </equation*>

  Now we let <math|<around|[|0,N-1|]>\<setminus\>\<cal-V\>=W<rsub|1>\<cup\>W<rsub|2>\<cup\>...\<cup\>W<rsub|k<rprime|'>>>
  where <math|W<rsub|m>> are again ordered maximal intervals. We inductively
  prove the following:

  If <math|<around|[|0,b-1|]>=V<rsub|1><rsup|\<cal-V\>>\<cup\>V<rsub|2><rsup|\<cal-V\>>\<cup\>...\<cup\>V<rsub|m-1><rsup|\<cal-V\>>\<cup\>W<rsub|1>\<cup\>W<rsub|2>\<cup\>...\<cup\>W<rsub|n<rprime|'>>>
  then for some constant <math|c<rsub|0>> the set
  <math|P<rsub|\<cal-O\>><around|(|\<cal-V\>|)>> can be covered by

  <\equation*>
    \<le\>c<rsub|0><rsup|m-1+n<rprime|'>>*exp
    <around*|(|h<rsub|max><around|(|<T>|)>*<around*|[|<around|(|b-1|)>-<frac|<around|(|<around|\||V<rsub|1><rsup|\<cal-V\>>|\|>+\<cdots\>+<around|\||V<rsub|m-1><rsup|\<cal-V\>>|\|>|)>|2>|]>|)>
  </equation*>

  pre-images under <math|<T><rsup|b-1>> of sets of the form

  <\equation>
    <label|eqn:earlier><T><rsup|b-1><around|(|x<rsub|0>|)>*u<rsup|+>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|-b+1>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>*a<rsup|b-1>.
  </equation>

  For the interval <math|<around|[|0,0|]>> the claim is obvious. Now, assume
  that the claim is true for the interval <math|<around|[|0,b-1|]>> as above.
  In the inductive step, if the next interval is <math|W<rsub|n<rprime|'>+1>>
  then once we divide each set obtained earlier into

  <\equation*>
    <big|prod><rsub|j=1><rsup|r+s><around|\<lceil\>|e<rsup|<around|\||W<rsub|n<rprime|'>+1>|\|>*a<rsub|j>>|\<rceil\>><rsup|\<delta\><rsub|j>>\<le\>c<rsub|0>*e<rsup|h<rsub|max><around|(|<T>|)><around|(|<around|\||W<rsub|n<rprime|'>+1>|\|>|)>>
  </equation*>

  small ones for some constant <math|c<rsub|0>>, we just keep all of them.
  So, assume that the next interval is <math|V<rsub|m><rsup|\<cal-V\>>=<around|[|b,b+\<ell\>|]>>.
  Let <math|Y> be one of the sets <eqref|eqn:earlier> obtained in the earlier
  step. We would like to estimate the upper bound to cover <math|Y> by
  pre-images under <math|<T><rsup|\<ell\>>> of sets of the form

  <\equation>
    <label|eqn:smallsets><T><rsup|b-1+\<ell\>><around|(|x<rsub|0>|)>*u<rsup|+><around|(|<with|font-series|bold|t>|)>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|-b+1-\<ell\>>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>*a<rsup|b-1+\<ell\>>.
  </equation>

  We are interested in the points <math|x\<in\>Y> for which
  <math|<T><rsup|-b+1><around|(|x|)>> is in
  <math|Q<around|(|J<around|(|V<rsub|m><rsup|\<cal-V\>>|)>|)>>. We know by
  assumption that <math|x<rsub|0>> is one of them. If <math|x\<in\>Y> is
  another one then by Lemma<nbsp><reference|lem:res> there exists
  <math|<with|font-series|bold|t>\<in\>B<rsub|\<eta\>/2><rsup|<R><rsup|r>\<times\><C><rsup|s>>>
  such that <math|x=x<rsub|0>*u<rsup|+><around|(|<with|font-series|bold|t>|)>*g>
  for some <math|g\<in\>B<rsub|\<eta\>/2><rsup|U<rsup|->*L>> and for
  <math|j\<in\><around|[|1,r+s|]>>, <math|<around|\||t<rsub|j>|\|>\<ll\>e<rsup|b-n<rsub|j>>>
  where <math|n<rsub|j>> is the left end point of the interval
  <math|J<rsub|j><around|(|V<rsub|m><rsup|\<cal-V\>>|)>>. Hence the set we
  are interested in corresponds to the set <math|D> in
  Lemma<nbsp><reference|lem:vol> and each set as in <eqref|eqn:smallsets>
  corresponds to the set <math|E> as in Lemma<nbsp><reference|lem:vol>. Thus,
  if necessary enlarging the constant <math|c<rsub|0>> appeared earlier,
  using Lemma<nbsp><reference|lem:vol> we see that once we divide <math|Y>
  into the sets of the form as in <eqref|eqn:smallsets> we only need to keep

  <\equation*>
    \<le\>c<rsub|0>*e<rsup|<frac|h<rsub|max><around|(|<T>|)>|2>*\<ell\>>=c<rsub|0>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|\<ell\>-<frac|<around|\||V<rsub|m><rsup|\<cal-V\>>|\|>|2>|)>>
  </equation*>

  many of them. Hence, we conclude that the set
  <math|P<rsub|\<cal-O\>><around|(|\<cal-V\>|)>> can be covered by

  <\equation*>
    \<le\>c<rsub|0><rsup|m+n<rprime|'>>*exp
    <around*|(|h<rsub|max><around|(|<T>|)>*<around*|[|<around|(|b-1+\<ell\>|)>-<frac|<around|(|<around|\||V<rsub|1><rsup|\<cal-V\>>|\|>+\<cdots\>+<around|\||V<rsub|m><rsup|\<cal-V\>>|\|>|)>|2>|]>|)>
  </equation*>

  pre-images under <math|<T><rsup|b+\<ell\>-1>> of the sets of the form

  <\equation*>
    <T><rsup|b+\<ell\>-1><around|(|x<rsub|0>|)>*u<rsup|+><around|(|t|)>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|-b-\<ell\>+1>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>*a<rsup|b+\<ell\>-1>.
  </equation*>

  Now, we let <math|b=N> to obtain that the set
  <math|P<rsub|\<cal-O\>><around|(|\<cal-V\>|)>> can be covered by

  <\equation*>
    \<le\>c<rsub|0><rsup|k+k<rprime|'>>*exp
    <around*|(|h<rsub|max><around|(|<T>|)>*<around*|[|N-<frac|<around|(|<around|\||V<rsub|1><rsup|\<cal-V\>>|\|>+\<cdots\>+<around|\||V<rsub|k><rsup|\<cal-V\>>|\|>|)>|2>|]>|)>
  </equation*>

  many Bowen <math|N>-balls. On the other hand, the proof of
  Lemma<nbsp><reference|lem:Q> suggests that <math|k> and hence
  <math|k<rprime|'>> are bounded above by

  <\equation*>
    <frac|N|2<around|\<lfloor\>|<frac|2*log
    M|h<rsub|r>+h<rsub|s>>|\<rfloor\>>>+1.
  </equation*>

  Thus, the set <math|P<rsub|\<cal-O\>><around|(|\<cal-V\>|)>> can be covered
  by

  <\equation*>
    \<ll\>c<rsub|0><rsup|<frac|h<rsub|max><around|(|<T>|)>*N|log
    M>>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|N-<frac|<around|\||\<cal-V\>|\|>|2>|)>>
  </equation*>

  translates of Bowen <math|N>-balls, which completes the proof.
  <math|\<Box\>>

  <section|Proof of Theorem<nbsp><reference|thm:dim>><label|sec:dim>

  We recall that <math|a<rsub|\<ast\>>=max
  <around|{|a<rsub|1>,a<rsub|2>,\<ldots\>,a<rsub|r+s>|}>> and <math|D=dim
  U<rsup|+>>. One can easily obtain the following lemma.

  <\lem>
    <label|lem:balls>For any <math|N\<in\><N>>, the set
    <math|a<rsup|N>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|-N>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>>
    can be covered by <math|\<ll\>e<rsup|<around|[|D*a<rsub|\<ast\>>-h<rsub|max><around|(|<T>|)>|]>*N>>
    translates of <math|B<rsub|<frac|\<eta\>|2>*e<rsup|-a<rsub|\<ast\>>*N>><rsup|U<rsup|+>>*B<rsub|<frac|\<eta\>|2>><rsup|U<rsup|->*L>>.
  </lem>

  The proof of Proposition<nbsp><reference|prop:main> together with
  Lemma<nbsp><reference|lem:balls> at once give

  <\prop>
    <label|prop:dimmain>The set <math|P<around|(|\<cal-V\>|)>> can be covered
    by

    <\equation*>
      \<ll\><rsub|M>c<rsub|0><rsup|<frac|h<rsub|max><around|(|<T>|)>|log
      M>*N>*e<rsup|<around|(|D*N*a<rsub|\<ast\>>-<frac|h<rsub|max><around|(|<T>|)><around|\||\<cal-V\>|\|>|2>|)>>
    </equation*>

    translates of <math|B<rsub|<frac|\<eta\>|2>*e<rsup|-a<rsub|\<ast\>>*N>><rsup|U<rsup|+>>*B<rsub|<frac|\<eta\>|2>><rsup|U<rsup|->*L>>
    in <math|X> for some universal constant <math|c<rsub|0>\<ge\>1>.
  </prop>

  <\proof>
    From the proof of Proposition<nbsp><reference|prop:main> we know that the
    set <math|P<around|(|\<cal-V\>|)>> can be covered by

    <\equation*>
      \<ll\><rsub|M>c<rsub|0><rsup|<frac|h<rsub|max><around|(|<T>|)>|log
      M>*N>*e<rsup|h<rsub|max><around|(|<T>|)>*<around|(|N-<frac|<around|\||\<cal-V\>|\|>|2>|)>>
    </equation*>

    translates of <math|a<rsup|N>*B<rsub|\<eta\>/2><rsup|U<rsup|+>>*a<rsup|-N>*B<rsub|\<eta\>/2><rsup|U<rsup|->*L>>
    in <math|X>. Thus, Lemma<nbsp><reference|lem:balls> finishes the proof.
  </proof>

  For any fixed <math|N\<in\><N>> and for any <math|x\<in\>X> we associate
  <math|\<cal-V\><rsub|x>\<subset\><around|[|0,N-1|]>> such that for any
  <math|n\<in\><around|[|0,N-1|]>>

  <\equation*>
    <T><rsup|n><around|(|x|)>\<in\>X<rsub|\<ge\>M>*<text|if and only if
    >n\<in\>\<cal-V\><rsub|x>.
  </equation*>

  As in the introduction, let <math|\<nu\>> be a measure on <math|X> of
  dimension <math|d> in the unstable direction. For any
  <math|\<delta\>\<gtr\>0> we note that <math|\<nu\>*<around|(|B<rsub|<frac|\<eta\>|2>*e<rsup|-a<rsub|\<ast\>>*N>><rsup|U<rsup|+>>*B<rsub|<frac|\<eta\>|2>><rsup|U<rsup|->*L>|)>\<ll\>e<rsup|-a<rsub|\<ast\>>*<around|(|d-\<delta\>|)>*N>>.
  Using Proposition<nbsp><reference|prop:main> together with
  Lemma<nbsp><reference|lem:P> and Lemma<nbsp><reference|lem:Q> it is easy to
  obtain the following (cf. <cite-detail|EinKad|Lemma<nbsp>6.2>).

  <\lem>
    <label|lem:kappa>For any <math|\<delta\>\<gtr\>0,\<kappa\>\<in\><around|[|0,1|]>>
    and for any <math|N,M\<ge\>1> large, we have

    <multline*|<tformat|<table|<row|<cell|\<nu\>*<around|(|x\<in\>X<rsub|\<less\>M>:<around|\||\<cal-V\><rsub|x>|\|>\<gtr\>\<kappa\>*N|)>>>|<row|<cell|\<ll\><rsub|M,\<delta\>>exp
    <around*|(|<around*|[|D*a<rsub|\<ast\>>-<frac|h<rsub|max><around|(|<T>|)>|2>*\<kappa\>-<around|(|d-\<delta\>|)>*a<rsub|\<ast\>>+O<around*|(|<frac|log
    log M|log M>|)>|]>*N|)>.>>>>>
  </lem>

  <\proof>
    <dueto|Proof of Theorem<nbsp><reference|thm:dim>>We follow the proof of
    <cite-detail|EinKad|Theorem<nbsp>1.6>. The conclusion of the theorem is
    trivial when <math|d\<le\>D-<frac|h<rsub|max><around|(|<T>|)>|2*a<rsub|\<ast\>>>>
    so that we may assume <math|d\<gtr\>D-<frac|h<rsub|max><around|(|<T>|)>|2*a<rsub|\<ast\>>>>.
    We first estimate an upper bound for <math|\<mu\><rsub|N><around|(|X<rsub|\<ge\>M>|)>>
    when <math|M,N\<ge\>1> large. We have

    <align*|<tformat|<table|<row|<cell|\<mu\><rsub|N><around|(|X<rsub|\<geq\>M>|)>>|<cell|=<frac|1|N>*<big|sum><rsub|n=0><rsup|N-1>\<nu\><around|(|<T><rsup|-n><around|(|X<rsub|\<geq\>M>|)>|)>>>|<row|<cell|>|<cell|=<frac|1|N>*<big|sum><rsub|n=0><rsup|N-1>\<nu\>*<around|(|X<rsub|\<less\>M>\<cap\><T><rsup|-n><around|(|X<rsub|\<geq\>M>|)>|)>+<frac|1|N>*<big|sum><rsub|n=0><rsup|N-1>\<nu\>*<around|(|X<rsub|\<gtr\>M>\<cap\><T><rsup|-n><around|(|X<rsub|\<geq\>M>|)>|)>>>|<row|<cell|>|<cell|\<le\><frac|1|N>*<big|sum><rsub|n=0><rsup|N-1>\<nu\>*<around|(|X<rsub|\<less\>M>\<cap\><T><rsup|-n><around|(|X<rsub|\<geq\>M>|)>|)>+\<nu\><around|(|X<rsub|\<ge\>M>|)>.>>>>>

    It suffices to estimate is <math|<frac|1|N>*<big|sum><rsub|n=0><rsup|N-1>\<nu\>*<around|(|X<rsub|\<less\>M>\<cap\><T><rsup|-n><around|(|X<rsub|\<geq\>M>|)>|)>>.
    For this, we note that

    <multline*|<tformat|<table|<row|<cell|<frac|1|N>*<big|sum><rsub|n=0><rsup|N-1>\<nu\>*<around|(|X<rsub|\<le\>M>\<cap\><T><rsup|-n><around|(|X<rsub|\<geq\>M>|)>|)>>>|<row|<cell|=<frac|1|N>*<big|sum><rsub|n=0><rsup|N-1><big|sum><rsub|W\<subset\><around|[|0,N|]>>\<nu\>*<around|(|<around|{|x\<in\>X<rsub|\<less\>M>:V<rsub|x>=W|}>\<cap\><T><rsup|-n><around|(|X<rsub|\<ge\>M>|)>|)>,>>>>>

    where the term <math|\<nu\>*<around|(|<around|{|x\<in\>X<rsub|\<less\>M>:V<rsub|x>=W|}>\<cap\><T><rsup|-n><around|(|X<rsub|\<ge\>M>|)>|)>>
    is either 0 or is equal to <math|\<nu\><around|(|<around|{|x\<in\>X<rsub|\<less\>M>:V<rsub|x>=W|}>|)>>.
    Switching the order of summation yields

    <align*|<tformat|<table|<row|<cell|>|<cell|=<frac|1|N>*<big|sum><rsub|W\<subset\><around|[|0,N-1|]>><around|\||W|\|>*\<nu\><around|(|<around|{|x\<in\>X<rsub|\<less\>M>:V<rsub|x>=W|}>|)>>>|<row|<cell|>|<cell|=<frac|1|N>*<big|sum><rsub|i=1><rsup|N>i*\<nu\><around|(|<around|{|x\<in\>X<rsub|\<less\>M>:<around|\||V<rsub|x>|\|>=i|}>|)>>>|<row|<cell|>|<cell|=<frac|1|N>*<big|sum><rsub|i=1><rsup|<around|\<lfloor\>|\<kappa\>*N|\<rfloor\>>>i*\<nu\><around|(|<around|{|x\<in\>X<rsub|\<less\>M>:<around|\||V<rsub|x>|\|>=i|}>|)>+<frac|1|N>*<big|sum><rsub|i=<around|\<lceil\>|\<kappa\>*N|\<rceil\>>><rsup|N>i*\<nu\><around|(|<around|{|x\<in\>X<rsub|\<less\>M>:<around|\||V<rsub|x>|\|>=i|}>|)>>>|<row|<cell|>|<cell|\<le\><frac|1|N>*<around|\<lfloor\>|\<kappa\>*N|\<rfloor\>>*\<nu\><around|(|X<rsub|\<less\>M>|)>+<frac|1|N>*N*\<nu\><around|(|<around|{|x\<in\>X<rsub|\<less\>M>:<around|\||V<rsub|x>|\|>\<gtr\>\<kappa\>*N|}>|)>>>>>>

    Let <math|K<around|(|M,\<delta\>|)>\<gtr\>0> be the implicit constant
    appeared in Lemma<nbsp><reference|lem:kappa>. Then we obtain

    <\equation*>
      <frac|1|N>*<big|sum><rsub|n=0><rsup|N-1>\<nu\>*<around|(|X<rsub|\<less\>M>\<cap\><T><rsup|-n><around|(|X<rsub|\<geq\>M>|)>|)>\<le\>\<kappa\>+K<around|(|M,\<delta\>|)>*e<rsup|<around*|(|D*a<rsub|\<ast\>>-<frac|h<rsub|max><around|(|<T>|)>|2>*\<kappa\>-<around|(|d-\<delta\>|)>*a<rsub|\<ast\>>+O<around*|(|<frac|log
      log M|log M>|)>|)>*N>.
    </equation*>

    Therefore we get that

    <\equation>
      \<mu\><rsub|N><around|(|X<rsub|\<ge\>M>|)>\<le\>\<epsilon\><around|(|M|)>+\<kappa\>+K<around|(|M,\<delta\>|)>*e<rsup|<around*|(|D*a<rsub|\<ast\>>-<frac|h<rsub|max><around|(|<T>|)>|2>*\<kappa\>-<around|(|d-\<delta\>|)>*a<rsub|\<ast\>>+O<around*|(|<frac|log
      log M|log M>|)>|)>*N>.
    </equation>

    By assumption we have <math|d\<gtr\>D-<frac|h<rsub|max><around|(|<T>|)>|2*a<rsub|\<ast\>>>>
    so that <math|2*a<rsub|\<ast\>>*<around|(|D-d|)>/<around|(|h<rsub|max><around|(|<T>|)>|)>\<less\>1>.
    Now, for any <math|\<kappa\>\<in\><around|(|2*a<rsub|\<ast\>>*<around|(|D-d|)>/<around|(|h<rsub|max><around|(|<T>|)>|)>,1|]>>
    we may pick <math|\<delta\>\<gtr\>0> small enough so that

    <\equation*>
      D*a<rsub|\<ast\>>-<frac|h<rsub|max><around|(|<T>|)>|2>*\<kappa\>-<around|(|d-\<delta\>|)>*a<rsub|\<ast\>>+O<around*|(|<frac|log
      log M|log M>|)>\<less\>0
    </equation*>

    for sufficiently large <math|M>. Thus, for any <math|\<epsilon\>\<gtr\>0>
    we may choose <math|M> sufficiently large so that

    <\equation*>
      \<mu\><rsub|N><around|(|X<rsub|\<ge\>M>|)>\<le\>\<kappa\>+\<epsilon\>
    </equation*>

    which gives in the limit that <math|\<mu\><around|(|X|)>\<gtr\>1-\<kappa\>>.
    This holds for any <math|\<kappa\>\<gtr\>2*a<rsub|\<ast\>>*<around|(|D-d|)>/<around|(|h<rsub|max><around|(|<T>|)>|)>>.
    Thus,

    <\equation*>
      \<mu\><around|(|X|)>\<ge\>1-<frac|2*a<rsub|\<ast\>>*<around|(|D-d|)>|h<rsub|max><around|(|<T>|)>>.
    </equation*>
  </proof>

  <\bibliography|bib|plain|mybib>
    <bib-list|[99]|>
  </bibliography>
</body>