<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <\hide-preamble>
    <assign|lyxdot|<macro|.>>

    <new-theorem|thm|>

    <new-theorem|rem|>

    <new-theorem|defn|>

    <new-theorem|prop|>

    <new-theorem|acknowledgement*|>

    <new-theorem|lem|>

    <new-theorem|cor|>

    <assign|acknowledgementname|<macro|Acknowledgement>>

    <assign|corollaryname|<macro|Corollary>>

    <assign|definitionname|<macro|Definition>>

    <assign|lemmaname|<macro|Lemma>>

    <assign|propositionname|<macro|Proposition>>

    <assign|remarkname|<macro|Remark>>

    <assign|theorem-name|<macro|Theorem>>
  </hide-preamble>

  <doc-data|<doc-title|On the growth rate of leaf-wise
  intersections>|<doc-author|<author-data|<author-name|Leonardo Macarini,
  Will J. Merry, and Gabriel P. Paternain>|<author-affiliation|(L. Macarini)
  Universidade Federal do Rio de Janeiro, Instituto de Matemtica, Cidade
  Universitria, CEP 21941-999, Rio de Janeiro,
  Brazil>|<author-email|leonardo@impa.br>|<author-affiliation|(W. J. Merry)
  Department of Pure Mathematics and Mathematical Statistics, University of
  Cambridge, Cambridge CB3 0WB, England>|<author-email|w.merry@dpmms.cam.ac.uk>|<author-affiliation|(G.
  P. Paternain) Department of Pure Mathematics and Mathematical Statistics,
  University of Cambridge, Cambridge CB3 0WB,
  England>|<author-email|g.p.paternain@dpmms.cam.ac.uk>>>>

  <abstract-data|<\abstract>
    We define a new variant of Rabinowitz Floer homology that is particularly
    well suited to studying the growth rate of leaf-wise intersections. We
    prove that for closed manifolds <math|M> whose loop space
    <math|\<Lambda\>*M> is ``complicated'', if
    <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M> is a non-degenerate
    fibrewise starshaped hypersurface and
    <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>
    is a generic Hamiltonian diffeomorphism then the number of leaf-wise
    intersection points of <math|\<varphi\>> in <math|\<Sigma\>> grows
    exponentially in time. Concrete examples of such manifolds are
    <math|<around|(|S<rsup|2>\<times\>S<rsup|2>|)>#<around|(|S<rsup|2>\<times\>S<rsup|2>|)>>,
    <math|\<bbb-T\><rsup|4>#\<bbb-C\>*P<rsup|2>>, or any surface of genus
    greater than one.
  </abstract>>

  <section|Introduction>

  Let <math|M> denote a closed connected orientable <math|n>-dimensional
  manifold with cotangent bundle <math|\<pi\>:T<rsup|\<ast\>>*M\<rightarrow\>M>.
  Let <math|\<lambda\>=p*d*q> and <math|Y=p*\<partial\><rsub|p>> denote the
  Liouville <math|1>-form and Liouville vector field on
  <math|T<rsup|\<ast\>>*M> respectively, and let
  <math|\<omega\>=d*\<lambda\>> denote the canonical symplectic structure.
  Note that <math|i<rsub|Y>*\<omega\>=\<lambda\>>. Let
  Ham<math|<rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>> denote the group
  of compactly supported Hamiltonian diffeomorphisms of
  <math|T<rsup|\<ast\>>*M>.

  Recall that a <with|font-series|bold|fibrewise starshaped>
  <with|font-series|bold|hypersurface> <math|\<Sigma\>>is a closed connected
  separating hypersurface in <math|T<rsup|\<ast\>>*M> such that <math|Y> is
  transverse to <math|\<Sigma\>> and points in the outwards direction. This
  is equivalent to requiring that <math|\<lambda\><rsub|\<Sigma\>>\<assign\>\<lambda\>\|<rsub|\<Sigma\>>>
  is a positive contact form on <math|\<Sigma\>>. Given a fibrewise
  starshaped hypersurface <math|\<Sigma\>>, let <math|R<rsub|\<Sigma\>>>
  denote the Reeb vector fieldassociated to the contact <math|1>-form
  <math|\<lambda\><rsub|\<Sigma\>>>. Let <math|\<phi\><rsub|t><rsup|\<Sigma\>>:\<Sigma\>\<rightarrow\>\<Sigma\>>
  denote the flow of <math|R<rsub|\<Sigma\>>>. We say that <math|\<Sigma\>>
  is a <with|font-series|bold|non-degenerate >hypersurface if all the closed
  orbits of <math|R<rsub|\<Sigma\>>> are transversely non-degenerate (see
  Definition <reference|def:non degen> below). Given <math|p\<in\>\<Sigma\>>,
  let <math|\<cal-L\><rsub|p>> denote the leaf of the characteristic
  foliation of <math|\<Sigma\>> running through <math|p>. We can parametrize
  <math|\<cal-L\><rsub|p>> via <math|\<cal-L\><rsub|p>\<assign\><around|{|\<phi\><rsub|t><rsup|\<Sigma\>><around|(|p|)><space|0.17em>:<space|0.17em>t\<in\>\<bbb-R\>|}>>.
  A <with|font-series|bold|defining Hamiltonian >for <math|\<Sigma\>> is an
  autonomous Hamiltonian <math|F\<in\>C<rsup|\<infty\>>*<around|(|T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
  such that <math|\<Sigma\>=F<rsup|-1><around|(|0|)>> and such that the
  Hamiltonian vector field <math|X<rsub|F>> is compactly supported and
  satisfies <math|X<rsub|F>\|<rsub|\<Sigma\>>=R<rsub|\<Sigma\>>>.

  Given <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>,
  we say that a point <math|p\<in\>\<Sigma\>> is a
  <with|font-series|bold|leaf-wise intersection point >for <math|\<varphi\>>
  if there exists a real number <math|\<eta\>\<in\>\<bbb-R\>> such that

  <\equation>
    \<varphi\><around|(|\<phi\><rsub|\<eta\>><rsup|\<Sigma\>><around|(|p|)>|)>=p.<label|eq:lwp>
  </equation>

  We say that <math|p> is a <with|font-series|bold|periodic >leaf-wise
  intersection pointif <math|\<cal-L\><rsub|p>> is a closed leaf. In this
  paper we will only be interested in leaf-wise intersection points that are
  <with|font-series|bold|not> periodic. This is not a major restriction, as
  Albers and Frauenfelder (see <cite-detail|AlbersFrauenfelder2008|Theorem
  3.3> or Proposition <reference|prop:-generically no plwip> below) show that
  if <math|n=dim <space|0.17em>M\<geq\>2> and
  <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M> is a non-degenerate fibrewise
  starshaped hypersurface then a generic Hamiltonian diffeomorphism has no
  periodic leaf-wise intersection points in <math|\<Sigma\>>. Thus for
  simplicity the term \Pleaf-wise interection point\Q should be understood as
  \Pnon-periodic leaf-wise intersection point\Q, unless explicitly stated
  otherwise. With this convention in mind, the
  <with|font-series|bold|time-shift ><math|\<eta\>\<in\>\<bbb-R\>> of a
  leaf-wise intersection point <math|p> is the unqiue<footnote|Of course,
  without the implicit ``non-periodic'' in front of the term ``leaf-wise
  intersection point'' <math|\<eta\>> is not unique: if
  <math|\<phi\><rsub|T><rsup|\<Sigma\>><around|(|p|)>=p> then
  <math|\<varphi\><around|(|\<phi\><rsub|\<eta\>+k*T><rsup|\<Sigma\>><around|(|p|)>|)>=p>
  for all <math|k\<in\>\<bbb-Z\>>.> real number <math|\<eta\>> such that
  <eqref|eq:lwp> is satisfied. real number <math|\<eta\>\<in\>\<bbb-R\>> such
  that

  <\equation*>
    \<varphi\><around|(|\<phi\><rsub|\<eta\>><rsup|\<Sigma\>><around|(|p|)>|)>=p.
  </equation*>

  A leaf-wise intersection point has zero time-shift if and only if it is a
  fixed point of <math|\<varphi\>>. A leaf-wise intersection point is called
  <with|font-series|bold|positive >if its time-shift <math|\<eta\>> is
  strictly positive, and <with|font-series|bold|negative >if its time-shift
  is strictly negative. In this paper we will only be interested in positive
  leaf-wise intersection points. This is no great loss, as the negative
  leaf-wise intersection points of <math|\<varphi\>> are precisely the
  positive leaf-wise intersection points of <math|\<varphi\><rsup|-1>>.

  <\rem>
    Our definition of a leaf-wise intersection point is slightly different to
    the standard one, where rather than referring to <math|p> as the
    leaf-wise intersection point, instead the point
    <math|<wide|p|\<bar\>>\<assign\>\<phi\><rsub|\<eta\>><rsup|\<Sigma\>><around|(|p|)>>
    is called ``the leaf-wise intersection point''. With this convention a
    point <math|<wide|p|\<bar\>>> is a leaf-wise intersection point if
    <math|\<varphi\><around|(|<wide|p|\<bar\>>|)>\<in\>\<cal-L\><rsub|<wide|p|\<bar\>>>>,
    which is perhaps a more natural definition. However using the standard
    convention it would seem natural (see
    <cite-detail|AlbersFrauenfelder2010|p1>) to define the ``time-shift'' of
    <math|<wide|p|\<bar\>>> to be <math|-\<eta\>> rather then <math|\<eta\>>,
    and as a result with the standard definition we would end up counting
    negative leaf-wise intersection points, which is somehow less
    aesthetically pleasing (see the statement of Theorem A below).
  </rem>

  The leaf-wise intersection problem asks whether a given Hamiltonian
  diffeomorphism always has a leaf-wise intersection point in a given
  fibrewise starshaped hypersurface, and if so, whether one can obtain a
  lower bound on the number of such leaf-wise intersections. This problem was
  introduced by Moser in <cite|Moser1978>, and since then has been studied by
  a number of different authors <cite|Bangaya1980|EkelandHofer1989|Hofer1990|Ginzburg2007|Dragnev2008|Gurel2010|Ziltener2010|AlbersFrauenfelder2010|AlbersFrauenfelder2008|AlbersFrauenfelder2010a|AlbersFrauenfelder2010b|Kang2009|Kang2010|Kang2010b|Merry2010a>.
  We refer to <cite|AlbersFrauenfelder2010c> for a brief history of the
  problem and a discussion of the progress made so far. Here we mention only
  one result that is particularly relevant to our paper: in
  <cite|AlbersFrauenfelder2008> Albers and Frauenfelder establish that if the
  homology of the free loop space is infinite dimensional, then given a
  non-degenerate fibrewise starshaped hypersurface <math|\<Sigma\>>, a
  generic Hamiltonian diffeomorphism has infinitely many leaf-wise
  intersection points in <math|\<Sigma\>>. This appears to have been the
  first result which asserts the existence of
  <with|font-series|bold|infinitely> many leaf-wise intersection points,
  instead of just a finite lower bound. In this paper we extend this result
  to show that if the base manifold <math|M> satisfies a certain topological
  condition (roughly that its loop space homology is sufficiently
  \Pcomplicated\Q - concrete examples of such manifolds are
  <math|<around|(|S<rsup|2>\<times\>S<rsup|2>|)>#<around|(|S<rsup|2>\<times\>S<rsup|2>|)>>,
  <math|\<bbb-T\><rsup|4>#\<bbb-C\>*P<rsup|2>> or any surface of genus
  greater than one), then not only do generic Hamiltonian diffeomorphisms
  have infinitely many leaf-wise intersection points in any non-degenerate
  fibrewise starshaped hypersurface, but the number of such leaf-wise
  intersection points \Pgrows\Q exponentially with time. The precise
  statements are given below in Theorem A and Corollaries B and C. To the
  best of our knowledge this is the first result which establishes the
  existence of \Pmore\Q than just infinitely many leaf-wise intersection
  points.

  Let us fix <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>.
  Suppose <math|H\<in\>C<rsub|c><rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
  is any Hamiltonian that <with|font-series|bold|generates
  ><math|\<varphi\>>, i.e. <math|\<phi\><rsub|1><rsup|H>=\<varphi\>>. If
  <math|p> is a positive leaf-wise intersection point of <math|\<varphi\>>
  with time-shift <math|\<eta\>> then consider the (not necessarily smooth)
  loop <math|x\<in\>C<rsup|0>*<around|(|S<rsup|1>,T<rsup|\<ast\>>*M|)>>
  defined by

  <\equation*>
    x<around|(|t|)>\<assign\><choice|<tformat|<table|<row|<cell|\<phi\><rsub|2*t*\<eta\>><rsup|\<Sigma\>><around|(|p|)>,>|<cell|0\<leq\>t\<leq\>1/2,>>|<row|<cell|\<phi\><rsub|2*t-2><rsup|H><around|(|p|)>,>|<cell|1/2\<leq\>t\<leq\>1.>>>>>
  </equation*>

  Obviously the curve <math|x> depends on the choice of Hamiltonian <math|H>
  generating <math|\<varphi\>>, but asking which free homotopy class
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>> the projection
  <math|\<pi\>\<circ\>x> belongs to is independent of <math|H> (see Lemma
  <reference|lem:Independence lemma> below). Thus it makes sense to speak
  ofleaf-wise intersection points <with|font-series|bold|belonging>
  to<with|font-series|bold|mode|math|\<alpha\>>. Given <math|T\<gtr\>0>
  denote by by <math|n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,T|)>>
  the number of positive leaf-wise intersection points that belong to
  <math|\<alpha\>> with time-shift <math|0\<less\>\<eta\>\<less\>T>. As
  indicated above, in this paper we study the <with|font-series|bold|growth
  rate> of the function <math|n<rsub|\<Sigma\>,\<alpha\>>*<around|(|\<varphi\>,\<cdot\>|)>>
  for a given <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>.
  In order to state our results we first need to introduce several
  definitions. Denote by <math|\<Lambda\>*T<rsup|\<ast\>>*M> the free loop
  space of <math|T<rsup|\<ast\>>*M>. Given
  <math|H\<in\>C<rsub|c><rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>>,
  denote by <math|A<rsup|H>:\<Lambda\>*T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>>
  the standard Hamiltonian action functional

  <\equation>
    A<rsup|H><around|(|x|)>\<assign\><big|int>x<rsup|\<ast\>>*\<lambda\>-<big|int><rsub|0><rsup|1>H<around|(|t,x|)>*d*t.<label|eq:standard
    action functional>
  </equation>

  Denote by <math|\<cal-A\><around|(|A<rsup|H>|)>> the
  <with|font-series|bold|action spectrum >of <math|A<rsup|H>>:

  <\equation*>
    \<cal-A\><around|(|A<rsup|H>|)>\<assign\><around*|{|A<rsup|H><around|(|x|)><space|0.17em>:<space|0.17em>x*<text|is
    a critical point of >A<rsup|H>|}>.
  </equation*>

  Now suppose <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>.
  A theorem of Frauenfelder and Schlenk <cite-detail|FrauenfelderSchlenk2007|Corollary
  6.2> says that if <math|H,K\<in\>C<rsub|c><rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
  both <with|font-series|bold|generate> <math|\<varphi\>>
  then<footnote|Strictly speaking their result pertains only to the subset of
  the action spectrum generated by <with|font-series|bold|contractible
  >periodic points. But they work only with a <with|font-series|bold|weakly
  exact >symplectic manifold. In our case the symplectic form is exact
  (instead of just being weakly exact), and thus the same proof carries
  through for the entire action spectrum. We also remark that the same result
  is also true for <with|font-series|bold|closed >symplectically aspherical
  manifolds (see <cite-detail|Schwarz2000|Theorem 1.1>, which builds on
  Seidel <cite|Seidel1997>), although this is considerably deeper.>

  <\equation*>
    \<cal-A\><around|(|A<rsup|H>|)>=\<cal-A\><around|(|A<rsup|K>|)>.
  </equation*>

  Thus we may define the action spectrum <math|\<cal-A\><around|(|\<varphi\>|)>>
  of <math|\<varphi\>> to be <math|\<cal-A\><around|(|A<rsup|H>|)>> for any
  <math|H\<in\>C<rsub|c><rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
  generating <math|\<varphi\>>. Now define

  <\equation*>
    \<kappa\>:<text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>\<rightarrow\><around|[|0,\<infty\>|)>
  </equation*>

  by

  <\equation>
    \<kappa\><around|(|\<varphi\>|)>\<assign\>sup
    <around*|{|<around*|\||\<eta\>|\|><space|0.17em>:<space|0.17em>\<eta\>\<in\>\<cal-A\><around|(|\<varphi\>|)>|}>.<label|eq:kappaphi>
  </equation>

  Another way of measuring the \Psize\Q of an element
  <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>
  is given by the <with|font-series|bold|Hofer norm>. We recall the
  definition: given <math|H\<in\>C<rsub|c><rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>>,
  define

  <\equation*>
    <around*|\<\|\|\>|H|\<\|\|\>><rsub|+>\<assign\><big|int><rsub|0><rsup|1>max<rsub|<around|(|q,p|)>\<in\>T<rsup|\<ast\>>*M>
    H<around|(|t,q,p|)>*d*t,<around*|\<\|\|\>|H|\<\|\|\>><rsub|->\<assign\>-<big|int><rsub|0><rsup|1>min<rsub|<around|(|q,p|)>\<in\>T<rsup|\<ast\>>*M>
    H<around|(|t,q,p|)>*d*t;
  </equation*>

  <\equation*>
    <around*|\<\|\|\>|H|\<\|\|\>>\<assign\><around*|\<\|\|\>|H|\<\|\|\>><rsub|+>+<around*|\<\|\|\>|H|\<\|\|\>><rsub|->.
  </equation*>

  For <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>,
  the Hofer norm of <math|\<varphi\>> is defined to be:

  <\equation>
    <around*|\<\|\|\>|\<varphi\>|\<\|\|\>>\<assign\>inf
    <around*|{|<around*|\<\|\|\>|H|\<\|\|\>><space|0.17em>:<space|0.17em>H*<text|generates
    >\<varphi\>|}>.<label|eq:hofer norm>
  </equation>

  Let us combine these two measures together and define

  <\equation>
    \<mu\><around|(|\<varphi\>|)>\<assign\>2*\<kappa\><around|(|\<varphi\>|)>+6<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>.<label|eq:mu
    phi>
  </equation>

  Write <math|\<Lambda\>*M> for the free loop space of <math|M> and
  <math|\<Lambda\><rsub|\<alpha\>>*M> the subspace of loops belonging to the
  free homotopy class <math|\<alpha\>>. Given a metric <math|g> on <math|M>
  define the energy functional

  <\equation*>
    \<cal-E\><rsub|g>:\<Lambda\>*M\<rightarrow\>\<bbb-R\>;
  </equation*>

  <\equation*>
    \<cal-E\><rsub|g><around|(|q|)>\<assign\><big|int><rsub|0><rsup|1><frac|1|2><around*|\||<wide|q|\<dot\>>|\|><rsup|2>*d*t.
  </equation*>

  Given <math|0\<less\>a\<less\>\<infty\>> and
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>, denote by

  <\equation*>
    \<Lambda\><rsub|\<alpha\>><rsup|a><around|(|M,g|)>\<assign\><around*|{|q\<in\>\<Lambda\><rsub|\<alpha\>>*M<space|0.17em>:<space|0.17em>\<cal-E\><rsub|g><around|(|q|)>\<leq\><frac|1|2>*a<rsup|2>|}>.
  </equation*>

  We will prove the following theorem.

  <with|font-series|bold|Theorem A. >

  <\em>
    Let <math|M> be a closed connected orientable manifold of dimension
    <math|n\<geq\>2>. Let <math|\<Sigma\>> be a non-degenerate fibrewise
    starshaped hypersurface. Let <math|g> be a bumpy Riemannian metric on
    <math|M> with <math|S<rsub|g><rsup|\<ast\>>*M> contained in the interior
    of the compact region bounded by <math|\<Sigma\>>. There exists a
    constant <math|c=c<around|(|\<Sigma\>,g|)>\<gtr\>0> such that the
    following property holds: Suppose <math|\<varphi\>\<in\><text|<em|Ham>><rsub|c><around|(|T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
    is a generic Hamiltonian diffeomorphism (see Remark <reference|allowing
    plwip> for the precise meaning of the word \Pgeneric\Q in this context).
    Then for all <math|T\<gtr\>0> sufficiently large, it holds that

    <\equation>
      n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,T|)>\<geq\><choice|<tformat|<table|<row|<cell|<text|<em|rank>><around*|{|\<iota\>:H<around|(|\<Lambda\><rsub|\<alpha\>><rsup|c*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>><around|(|M,g|)>;\<bbb-Z\><rsub|2>|)>\<rightarrow\>H*<around|(|\<Lambda\><rsub|\<alpha\>>*M,\<Lambda\><rsub|\<alpha\>><rsup|4*\<mu\><around|(|\<varphi\>|)>><around|(|M,g|)>;\<bbb-Z\><rsub|2>|)>|}>,>|<cell|\<alpha\>\<ne\>0,>>|<row|<cell|<text|<em|rank>><around*|{|\<iota\>:H<around|(|\<Lambda\><rsub|0><rsup|c*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>><around|(|M,g|)>,M;\<bbb-Z\><rsub|2>|)>\<rightarrow\>H*<around|(|\<Lambda\><rsub|0>*M,\<Lambda\><rsub|0><rsup|4*\<mu\><around|(|\<varphi\>|)>><around|(|M,g|)>;\<bbb-Z\><rsub|2>|)>|}>,>|<cell|\<alpha\>=0.>>>>><label|eq:theorem
      A>
    </equation>
  </em>

  \;

  <\rem>
    Theorem A is proved only for <math|\<bbb-Z\><rsub|2>> coefficients. This
    is because so far there is no treatment of coherent orientations for
    Rabinowitz Floer homology, but we certainly expect the theorem to hold
    with any field of coefficients. Because of this however, for the
    remainder of this paper the notation <math|H<around|(|X,A|)>> for the
    singular homology of a pair <math|<around|(|X,A|)>> should always be
    understood as shorthand for <math|H<around|(|X,A;\<bbb-Z\><rsub|2>|)>>.
  </rem>

  <\rem>
    <label|allowing plwip>As mentioned above, a generic Hamiltonian
    diffeomorphism has no periodic leaf-wise intersection points, and hence
    it is sufficient to prove Theorem A for Hamiltonian diffeomorphisms with
    no periodic leaf-wise intersection points. In fact, we prove Theorem A
    for Hamiltonian diffeomorphisms that (a) have no periodic leaf-wise
    intersection points and (b) are generated by Hamiltonians for which the
    corresponding Rabinowitz action functional is Morse (this condition is
    also generic - again due to Albers and Frauenfelder
    <cite-detail|AlbersFrauenfelder2010|Proposition 3.9>). The precise
    definition for the subset of Hamiltonian diffeomorphisms for which we
    prove Theorem A is given in Definition <reference|what we prove theorem a
    for> below.
  </rem>

  <\rem>
    <label|finite dim>A well known result which is essentially due to Morse
    <cite|Morse1932> says that for any Riemannian manifold
    <math|<around|(|M,g|)>> and for any <math|a\<gtr\>0> the space
    <math|\<Lambda\><rsup|a><around|(|M,g|)>> is finite-dimensional. For the
    case of based loops a proof of this can be found in Milnor's book
    <cite|Milnor1963>. A complete proof for the free loop space is given in
    <cite|GoreskyHingston2009>. Thus the growth rate of
    <math|n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,T|)>> is also
    bounded from below by the growth rate of the function

    <\equation*>
      T\<mapsto\><text|rank><around*|{|\<iota\>:H<around|(|\<Lambda\><rsub|\<alpha\>><rsup|c*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>><around|(|M,g|)>|)>\<rightarrow\>H*<around|(|\<Lambda\><rsub|\<alpha\>>*M|)>|}>.
    </equation*>
  </rem>

  Under certain topological assumptions on <math|M>, the number on the
  right-hand side of <eqref|eq:theorem A> grows exponentially with <math|T>.
  For instance, if <math|M> is simply connected then a classical theorem of
  Gromov <cite|Gromov1978> implies that whenever the Betti numbers
  <math|<around|(|b<rsub|i>*<around|(|\<Lambda\><rsub|\<alpha\>>*M|)>|)><rsub|i\<in\>\<bbb-Z\>>>
  grow exponentially with <math|i>, the right-hand side of <eqref|eq:theorem
  A> grows exponentially with <math|T>. In the simply connected case, various
  results giving exponential growth of the Betti numbers
  <math|<around|(|b<rsub|i>*<around|(|\<Lambda\><rsub|0>*M|)>|)><rsub|i\<in\>\<bbb-Z\>>>
  have been obtained by Lambrechts <cite|Lambrechts2001a|Lambrechts2001>; a
  concrete example is <math|<around|(|S<rsup|2>\<times\>S<rsup|2>|)>#<around|(|S<rsup|2>\<times\>S<rsup|2>|)>>.
  In the non-simply connected case there are also plenty of examples where
  the right-hand side of <eqref|eq:theorem A> with <math|\<alpha\>=0> still
  grows exponentially with <math|T>; see for instance
  <cite|PaternainPetean2005>. To encapsulate the situation where Theorem A
  gives exponential growth, following <cite|FrauenfelderSchlenk2006> we make
  the following definition.

  <\defn>
    <label|energy hyp>Given a closed Riemannian manifold
    <math|<around|(|M,g|)>> and <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>
    we define

    <\equation*>
      C<rsub|\<Lambda\>,\<alpha\>><around|(|M,g|)>\<assign\>liminf<rsub|a\<rightarrow\>\<infty\>>
      <frac|log <space|0.17em><text|rank><around*|{|\<iota\>:H<around|(|\<Lambda\><rsub|\<alpha\>><rsup|a><around|(|M,g|)>|)>\<rightarrow\>H*<around|(|\<Lambda\><rsub|\<alpha\>>*M|)>|}>|a>\<in\><around|[|0,\<infty\>|]>.
    </equation*>

    Whilst the constant <math|C<rsub|\<Lambda\>,\<alpha\>><around|(|M,g|)>>
    depends on <math|g>, asking whether <math|C<rsub|\<Lambda\>,\<alpha\>><around|(|M,g|)>>
    is positive or not is a purely topological question. Thus we say that
    <math|M> is <with|font-series|bold|<math|<around|(|\<Lambda\>,\<alpha\>|)>>-energy
    hyperbolic >if <math|C<rsub|\<Lambda\>,\<alpha\>><around|(|M,g|)>\<gtr\>0>
    for some (and hence any) Riemannian metric <math|g> on <math|M>.
  </defn>

  The following result can be proved in exactly the same way as
  <cite-detail|PaternainPetean2005|Theorem B>, and gives a wide class of
  Riemannian manifolds <math|M> which are
  <math|<around|(|\<Lambda\>,0|)>>-energy hyperbolic.

  <\prop>
    <label|prop:PPresult>Let <math|M> be a closed manifold of dimension
    <math|n\<geq\>3>. Suppose that <math|M> can be decomposed as
    <math|N<rsub|1>#N<rsub|2>>, where <math|\<pi\><rsub|1><around|(|N<rsub|1>|)>>
    has a subgroup of finite index <math|\<geq\>3>, and <math|N<rsub|2>> is a
    simply connected manifold that is not a homology
    <math|\<bbb-Z\><rsub|2>>-sphere. Then <math|M> is
    <math|<around|(|\<Lambda\>,0|)>>-energy hyperbolic<em|. >
  </prop>

  Note that <math|M=\<bbb-T\><rsup|4>#\<bbb-C\>*P<rsup|2>> satisfies the
  hypotheses of Proposition <reference|prop:PPresult>. An immediate corollary
  of Remark <reference|finite dim> and Theorem A is the following result,
  which, as far as we are aware, is new even in the case
  <math|\<Sigma\>=S<rsub|g><rsup|\<ast\>>*M>.

  <with|font-series|bold|Corollary B. ><em|Let <math|M> be a closed connected
  orientable manifold of dimension <math|n\<geq\>2> and fix
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. Assume <math|M> is
  <math|<around|(|\<Lambda\>,\<alpha\>|)>>-energy hyperbolic. Let
  <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M> be a non-degenerate fibrewise
  starshaped hypersurface. If <math|\<varphi\>\<in\><text|<em|Ham>><rsub|c><around|(|T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
  is a generic Hamiltonian diffeomorphism then
  <math|n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,T|)>> grows
  exponentially with <math|T>.>

  If we don't fix the free homotopy class
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>> then another source of
  examples for which we obtain an exponential growth rate of leaf-wise
  intersections occurs when the fundamental group modulo conjugacy of
  <math|M> has exponential growth. In order to explain this more precisely,
  let us first say that a smooth manifold <math|M> is
  <with|font-series|bold|<math|\<Lambda\>>-energy hyperbolic >if

  <\equation*>
    C<rsub|\<Lambda\>><around|(|M,g|)>\<assign\>liminf<rsub|a\<rightarrow\>\<infty\>>
    <frac|log <space|0.17em><text|rank><around*|{|\<iota\>:H<around|(|\<Lambda\><rsup|a><around|(|M,g|)>|)>\<rightarrow\>H*<around|(|\<Lambda\>*M|)>|}>|a>\<gtr\>0
  </equation*>

  for some (and hence any) Riemannian metric <math|g> on <math|M>. Next, note
  that the fundamental group of <math|M> is necessarily finitely generated.
  Denote by <math|<wide|\<pi\>|~><rsub|1><around|(|M|)>\<cong\><around|[|S<rsup|1>,M|]>>
  the fundamental group of <math|M> modulo conjugacy classes. Given
  <math|s\<in\>\<pi\><rsub|1><around|(|M|)>>, denote by
  <math|<wide|s|\<bar\>>> the image of <math|s> in
  <math|<wide|\<pi\>|~><rsub|1><around|(|M|)>>. Given a finite set of
  generators <math|S\<subseteq\>\<pi\><rsub|1><around|(|M|)>>, let
  <math|\<gamma\><rsub|S>:\<bbb-N\>\<rightarrow\>\<bbb-N\>> denote the
  <with|font-series|bold|growth function >of <math|S>, defined by

  <\equation*>
    \<gamma\><rsub|S><around|(|k|)>\<assign\>#<around*|{|\<alpha\>\<in\><wide|\<pi\>|~><rsub|1><around|(|M|)><space|0.17em>:\<exists\><space|0.17em>s<rsub|1>,\<ldots\>,s<rsub|k>\<in\>S\<cup\>S<rsup|-1>,\<alpha\>=<wide|s<rsub|1>*s<rsub|2>*\<ldots\>*s<rsub|k>|\<bar\>>|}>.
  </equation*>

  We define the <with|font-series|bold|growth rate
  ><math|\<nu\><around|(|S|)>> of <math|S>to be the number

  <\equation*>
    \<nu\><around|(|S|)>\<assign\>lim<rsub|k\<rightarrow\>\<infty\>>
    <frac|log \<gamma\><rsub|S><around|(|k|)>|k>\<in\><around|[|0,\<infty\>|)>.
  </equation*>

  We say that <math|<wide|\<pi\>|~><rsub|1><around|(|M|)>> as
  <with|font-series|bold|exponential growth >if
  <math|\<nu\><around|(|S|)>\<gtr\>0> for some (and hence any) finite set of
  generators <math|S>. There are many examples of manifolds <math|M> for
  which <math|<wide|\<pi\>|~><rsub|1><around|(|M|)>> has exponential growth;
  for example any surface of genus greater than one. One can show (see for
  instance <cite-detail|McLean2010|Lemma 4.15>) that if
  <math|<wide|\<pi\>|~><rsub|1><around|(|M|)>> has exponential growth then
  <math|M> is <math|\<Lambda\>>-energy hyperbolic. Define

  <\equation*>
    n<rsub|\<Sigma\>><around|(|\<varphi\>,T|)>\<assign\><big|sum><rsub|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,T|)>.
  </equation*>

  Then we have:

  <with|font-series|bold|Corollary C. ><em|Let <math|M> be a closed connected
  orientable manifold of dimension <math|n\<geq\>2>. Assume
  <math|<wide|\<pi\>|~><rsub|1><around|(|M|)>> has exponential growth. Let
  <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M> be a non-degenerate fibrewise
  starshaped hypersurface. If <math|\<varphi\>\<in\><text|<em|Ham>><rsub|c><around|(|T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
  is a generic Hamiltonian diffeomorphism then
  <math|n<rsub|\<Sigma\>><around|(|\<varphi\>,T|)>> grows exponentially with
  <math|T>.>

  As with Corollary B, we believe this result is also new even in the case
  <math|\<Sigma\>=S<rsub|g><rsup|\<ast\>>*M>.

  <\rem>
    Whilst in general our results are only valid for a generic Hamiltonian
    diffeomorphism <math|\<varphi\>>, it will be apparent in the proof below
    that the case <math|\<varphi\>\<equiv\><with|math-font|Bbb|1>>
    <with|font-series|bold|is >included<footnote|Indeed, we will consider the
    general case only after first proving the special case
    <math|\<varphi\>\<equiv\><with|math-font|Bbb|1>>>. Thus as a special case
    of our results we obtain the following fact: for a non-degenerate
    fibrewise starshaped hypersurface <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M>,
    where <math|M> is a <math|<around|(|\<Lambda\>,\<alpha\>|)>>-energy
    hyperbolic manifold, the number of closed Reeb orbits belonging to the
    free homotopy class <math|\<alpha\>> grows exponentially with time. In
    fact, this even shows that the number of
    <with|font-series|bold|geometrically distinct >closed Reeb orbits grows
    exponentially with time. This result however is not new; it follows from
    an observation of Seidel <cite-detail|Seidel2006|Section 4a> that the
    <with|font-series|bold|growth rate >of <with|font-series|bold|symplectic
    homology >is invariant under <with|font-series|bold|Liouville
    isomorphism>. We refer to <cite|Seidel2006> for a definition of these
    terms, and for an explanation as to why this yields a proof of the fact
    above. We emphasize however that whilst the case
    <math|\<varphi\>\<equiv\><with|math-font|Bbb|1>> can be proved much more
    easily using symplectic homology, it does not appear possible to attack
    the leaf-wise intersection problem with symplectic homology; at the
    moment Rabinowitz Floer homology seems to be the most effective way of
    dealing with these types of problems.
  </rem>

  \ We are grateful to Peter Albers, Urs Frauenfelder and Alex Ritter for
  several helpful discussions and suggestions. We are also grateful to Irida
  Altman for help with constructing Figure <reference|fig:The-function>.

  <section|Preliminaries>

  <subsection|Sign conventions>

  <vspace|6 pt>

  For the convenience of the reader we begin by gathering together the
  various sign conventions we use. Let <math|M> denote a closed connected
  orientable <math|n>-dimensional manifold. Let
  <math|\<pi\>:T<rsup|\<ast\>>*M\<rightarrow\>M> denote the foot point map.

  <\itemize>
    <item>We use the symplectic form <math|\<omega\>=d*\<lambda\>> on
    <math|T<rsup|\<ast\>>*M>, where <math|\<lambda\>=p*d*q> is the
    <with|font-series|bold|Liouville <math|1>-form>. We will denote by
    <math|Y=p*\<partial\><rsub|p>> the <with|font-series|bold|Liouville
    vector field>, which is the unique vector field satisfying
    <math|i<rsub|Y>*\<omega\>=\<lambda\>>.

    <item>We denote by <math|\<Lambda\>*M> and
    <math|\<Lambda\>*T<rsup|\<ast\>>*M> the <with|font-series|bold|free loop
    spaces >on <math|M> and <math|T<rsup|\<ast\>>*M> respectively:

    <\equation*>
      \<Lambda\>*M\<assign\>C<rsup|\<infty\>><around|(|S<rsup|1>,M|)>,\<Lambda\>*T<rsup|\<ast\>>*M\<assign\>C<rsup|\<infty\>>*<around|(|S<rsup|1>,T<rsup|\<ast\>>*M|)>.
    </equation*>

    We denote by <math|<wide|\<Lambda\>|~>*M> and
    <math|<wide|\<Lambda\>|~>*T<rsup|\<ast\>>*M> the completions of these
    spaces with respect to the Sobolev <math|W<rsup|1,2>> norm. Given
    <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>, we denote by

    <\equation*>
      \<Lambda\><rsub|\<alpha\>>*M\<assign\><around*|{|q\<in\>\<Lambda\>*M<space|0.17em>:<space|0.17em><around|[|q|]>=\<alpha\>|}>;
    </equation*>

    <\equation*>
      \<Lambda\><rsub|\<alpha\>>*T<rsup|\<ast\>>*M\<assign\><around*|{|x\<in\>\<Lambda\>*T<rsup|\<ast\>>*M<space|0.17em>:<space|0.17em><around|[|\<pi\>\<circ\>x|]>=\<alpha\>|}>.
    </equation*>

    <item>An almost complex structure <math|J> on <math|T<rsup|\<ast\>>*M> is
    <with|font-series|bold|compatible>with <math|\<omega\>> if
    <math|\<omega\>*<around|(|J\<cdot\>,\<cdot\>|)>> defines a Riemannian
    metric on <math|T<rsup|\<ast\>>*M>. We denote by <math|\<cal-J\>> the set
    of time-dependent almost complex structures
    <math|J=<around|(|J<rsub|t>|)><rsub|t\<in\>S<rsup|1>>> such that each
    <math|J<rsub|t>> is compatible with <math|\<omega\>>.

    <item>Given <math|J\<in\>\<cal-J\>> we denote by
    <math|<around*|\<langle\>|<around*|\<langle\>|\<cdot\>,\<cdot\>|\<rangle\>>|\<rangle\>><rsub|J>>
    the <math|L<rsup|2>> inner product on
    <math|\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>> defined by

    <\equation>
      <around*|\<langle\>|<around*|\<langle\>|<around|(|\<xi\>,b|)>,<around|(|\<xi\><rprime|'>,b<rprime|'>|)>|\<rangle\>>|\<rangle\>><rsub|J>\<assign\><big|int><rsub|0><rsup|1>\<omega\>*<around|(|J*\<xi\>,\<xi\><rprime|'>|)>*d*t+b*b<rprime|'>.<label|eq:metric
      Jg>
    </equation>

    <item>Given a Riemannian metric <math|g> on <math|M> we denote by
    <math|<around*|\<langle\>|<around*|\<langle\>|\<cdot\>,\<cdot\>|\<rangle\>>|\<rangle\>><rsub|g>>
    the <math|W<rsup|1,2>> metric on <math|<wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>>
    defined by

    <\equation*>
      <around*|\<langle\>|<around*|\<langle\>|<around|(|\<zeta\>,b|)>,<around|(|\<zeta\><rprime|'>,b<rprime|'>|)>|\<rangle\>>|\<rangle\>><rsub|g>\<assign\><around*|\<langle\>|\<zeta\><around|(|0|)>,\<zeta\><rprime|'><around|(|0|)>|\<rangle\>>+<big|int><rsub|0><rsup|1><around*|\<langle\>|\<nabla\><rsub|t>*\<zeta\>,\<nabla\><rsub|t>*\<zeta\><rprime|'>|\<rangle\>>*d*t+b*b<rprime|'>.
    </equation*>

    <item>In this paper <math|F> will always denote an
    <with|font-series|bold|autonomous >Hamiltonian
    <math|F:T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>>, whereas <math|H> will
    always denote a <with|font-series|bold|time-dependent >Hamiltonian
    <math|H:S<rsup|1>\<times\>T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>>.

    <item>The symplectic gradient <math|X<rsub|F>> of a smooth function
    <math|F:T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>> is defined by
    <math|i<rsub|X<rsub|F>>*\<omega\>=-d*F>.

    <item>Floer homology is defined using
    <with|font-series|bold|negative>gradient flow lines of the Rabinowitz
    action functional <math|A<rsub|\<frak-f\>>>.

    <item>The notation <math|H<around|(|X,A|)>> for the singular homology of
    a pair <math|<around|(|X,A|)>> should always be understood as shorthand
    for <math|H<around|(|X,A;\<bbb-Z\><rsub|2>|)>>.

    <item>We denote by <math|\<bbb-R\><rsup|+>\<assign\><around*|{|\<eta\>\<in\>\<bbb-R\><space|0.17em>:<space|0.17em>\<eta\>\<gtr\>0|}>>.

    <item><with|font-series|bold|All sign conventions in this paper agree
    with the ones in <cite|AbbondandoloSchwarz2009>.>
  </itemize>

  <subsection|Preliminaries on fibrewise starshaped hypersurfaces>

  <vspace|6 pt>

  We begin by defining our central objects of interest.

  <defn|A submanifold <math|\<Sigma\><rsup|2*n-1>\<subseteq\>T<rsup|\<ast\>>*M>
  is called a <with|font-series|bold|fibrewise starshaped hypersurface >if
  <math|\<Sigma\>> is a closed connected separating hypersurface with the
  property that the Liouville vector field <math|Y> is transverse to
  <math|\<Sigma\>> and points in the outward direction. This is equivalent to
  asking that <math|\<lambda\><rsub|\<Sigma\>>\<assign\>\<lambda\>\|<rsub|\<Sigma\>>>
  is a positive contact form on <math|\<Sigma\>>. Given a fibrewise
  starshaped hypersurface <math|\<Sigma\>>, we denote by
  <math|R<rsub|\<Sigma\>>> the <with|font-series|bold|Reeb vector field>of
  the contact <math|1>-form <math|\<lambda\><rsub|\<Sigma\>>>, that is, the
  unique vector field on <math|\<Sigma\>> defined by the equations
  <math|\<lambda\><rsub|\<Sigma\>><around|(|R<rsub|\<Sigma\>>|)>=1> and
  <math|i<rsub|R<rsub|\<Sigma\>>>*d*\<lambda\><rsub|\<Sigma\>>=0>. Denote by
  <math|D<around|(|\<Sigma\>|)>> the compact region of
  <math|T<rsup|\<ast\>>*M> bounded by <math|\<Sigma\>>, and
  <math|D<rsup|\<circ\>><around|(|\<Sigma\>|)>\<assign\><text|int><around|(|D<around|(|\<Sigma\>|)>|)>>.>

  Another way to think about such hypersurfaces is the following. Fix a
  metric <math|g> on <math|M>, and denote by <math|S<rsub|g><rsup|\<ast\>>*M>
  the unit cotangent bundle of <math|<around|(|M,g|)>>. Then a hypersurface
  <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M> is fibrewise starshaped if
  and only if there exists a smooth function
  <math|\<sigma\>:S<rsub|g><rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\><rsup|+>>
  such that

  <\equation>
    \<Sigma\>=<text|graph><around|(|\<sigma\>|)>=<around*|{|<around|(|q,\<sigma\><around|(|q,p|)>|)><space|0.17em>:<space|0.17em><around|(|q,p|)>\<in\>S<rsub|g><rsup|\<ast\>>*M|}>.<label|eq:s
    star m sigma>
  </equation>

  <\defn>
    Given a fibrewise starshaped hypersurface
    <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M>, let
    <math|\<cal-D\><around|(|\<Sigma\>|)>\<subseteq\>C<rsup|\<infty\>>*<around|(|T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
    denote the set of all autonomous Hamiltonians
    <math|F:T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>> such that
    <math|F<rsup|-1><around|(|0|)>=\<Sigma\>>, <math|X<rsub|F>> is compactly
    supported, and such that <math|X<rsub|F>\|<rsub|\<Sigma\>>=R<rsub|\<Sigma\>>>.
    We call such Hamiltonians <with|font-series|bold|defining
    Hamiltonians>for <math|\<Sigma\>>. Let

    <\equation*>
      \<cal-D\>\<assign\><big|cup><rsub|\<Sigma\>>\<cal-D\><around|(|\<Sigma\>|)>,
    </equation*>

    where the union is over all fibrewise starshaped hypersurfaces
    <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M>.
  </defn>

  Given a fibrewise starshaped hypersurface
  <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M>, denote by
  <math|\<cal-P\><around|(|\<Sigma\>|)>> the set of
  <with|font-series|bold|Reeb orbits>of <math|R<rsub|\<Sigma\>>>:

  <\equation*>
    \<cal-P\><around|(|\<Sigma\>|)>\<assign\><around*|{|<around|(|x,T|)>\<in\>\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\><rsup|+><space|0.17em>:<space|0.17em>x<around|(|S<rsup|1>|)>\<subseteq\>\<Sigma\>,<space|0.17em><wide|x|\<dot\>>=T*R<rsub|\<Sigma\>><around|(|x|)>|}>.
  </equation*>

  Given <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>> let

  <\equation*>
    \<cal-P\><around|(|\<Sigma\>,\<alpha\>|)>\<assign\><around*|{|<around|(|x,T|)>\<in\>\<cal-P\><around|(|\<Sigma\>|)><space|0.17em>:<space|0.17em><around|[|\<pi\>\<circ\>x|]>=\<alpha\>|}>.
  </equation*>

  Denote by <math|\<cal-A\><around|(|\<Sigma\>|)>> the
  <with|font-series|bold|action spectrum>of <math|\<Sigma\>>:

  <\equation*>
    \<cal-A\><around|(|\<Sigma\>|)>\<assign\><around*|{|T\<in\>\<bbb-R\><rsup|+><space|0.17em>:<space|0.17em>\<exists\><space|0.17em><around|(|x,T|)>\<in\>\<cal-P\><around|(|\<Sigma\>|)>|}>;
  </equation*>

  <\equation*>
    \<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>\<assign\><around*|{|T\<in\>\<bbb-R\><rsup|+><space|0.17em>:<space|0.17em>\<exists\><space|0.17em><around|(|x,T|)>\<in\>\<cal-P\><around|(|\<Sigma\>,\<alpha\>|)>|}>,
  </equation*>

  and set

  <\equation*>
    \<ell\><around|(|\<Sigma\>|)>\<assign\>inf
    <space|0.17em>\<cal-A\><around|(|\<Sigma\>|)>,\<ell\><around|(|\<Sigma\>,\<alpha\>|)>\<assign\>inf
    <space|0.17em>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>.
  </equation*>

  Note that <math|\<ell\><around|(|\<Sigma\>|)>\<gtr\>0> for any fibrewise
  starshaped hypersurface.

  <rem|<label|rem:The-action-spectru>The action spectrum is a closed nowhere
  dense subset of <math|\<bbb-R\>> <cite-detail|Schwarz2000|Proposition 3.7>.
  Moreover it varies ``lower-semicontinuously'' with respect to
  <math|\<Sigma\>> in the following sense. Suppose <math|\<Sigma\>> is given
  by the graph of a smooth function <math|\<sigma\>:S<rsub|g><rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\><rsup|+>>,
  where <math|S<rsub|g><rsup|\<ast\>>*M> is the unit cotangent bundle of
  <math|M> with respect to some metric <math|g> on <math|M> (see <eqref|eq:s
  star m sigma>). Then given any neighborhood
  <math|\<cal-V\>\<subseteq\>\<bbb-R\>> of
  <math|\<cal-A\><around|(|\<Sigma\>|)>> there exists a neighborhood
  <math|\<cal-U\>\<subseteq\>C<rsup|\<infty\>>*<around|(|S<rsub|g><rsup|\<ast\>>*M,\<bbb-R\><rsup|+>|)>>
  of <math|\<sigma\>> (where the later space is equipped with the strong
  Whitney <math|C<rsup|\<infty\>>>-topology) such that if
  <math|<wide|\<sigma\>|~>\<in\>\<cal-U\>> then the fibrewise starshaped
  hypersurface <math|<wide|\<Sigma\>|~>> defined as the graph of
  <math|<wide|\<sigma\>|~>> satisfies <math|\<cal-A\><around|(|<wide|\<Sigma\>|~>|)>\<subseteq\>\<cal-V\>>.
  See <cite-detail|CieliebakGinzburgKerman2004|Lemma 3.1>.>

  The non-degeneracy assumption we will make is the following:

  <defn|<label|def:non degen>We say a pair
  <math|<around|(|x,T|)>\<in\>\<cal-P\><around|(|\<Sigma\>|)>> is
  <with|font-series|bold|transversely non-degenerate>if <math|1> is not an
  eigenvalue of the restriction of <math|d<rsub|x<around|(|0|)>>*\<phi\><rsub|T><rsup|R<rsub|\<Sigma\>>>>
  to the contact hyperplane <math|ker <around|(|\<lambda\><rsub|\<Sigma\>><around|(|x<around|(|0|)>|)>|)>\<subseteq\>T<rsub|x<around|(|0|)>>*\<Sigma\>>.
  We say that <math|\<Sigma\>> is <with|font-series|bold|non-degenerate> if
  every element of <math|\<cal-P\><around|(|\<Sigma\>|)>> is transversely
  non-degenerate.>

  Non-degeneracy is a generic property, in the following sense.

  <thm|<label|thm:nondeg is generic>Fix a metric <math|g> on <math|M>, and
  let <math|S<rsub|g><rsup|\<ast\>>*M> denote the unit cotangent bundle of
  <math|<around|(|M,g|)>>. The subset of <math|C<rsup|\<infty\>>*<around|(|S<rsub|g><rsup|\<ast\>>*M,\<bbb-R\><rsup|+>|)>>
  consisting of those smooth functions <math|\<sigma\>:S<rsub|g><rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\><rsup|+>>
  with the property that the corresponding fibrewise starshaped hypersurface
  <math|\<Sigma\>> defined by the graph of <math|\<sigma\>> (see <eqref|eq:s
  star m sigma>) is non-degenerate, is residual in
  <math|C<rsup|\<infty\>>*<around|(|S<rsub|g><rsup|\<ast\>>*M,\<bbb-R\><rsup|+>|)>>.>

  See <cite-detail|HoferWysockiZehnder1998|Proposition 6.1>,
  <cite-detail|Bourgeois2009|Lemma 2.1> or
  <cite-detail|CieliebakFrauenfelder2009|Appendix B> for a proof of Theorem
  <reference|thm:nondeg is generic>.

  <section|<math|\<cal-F\>>-Rabinowitz Floer homology>

  <subsection|The Rabinowitz action functional>

  <vspace|6 pt>

  We now define the (variant of the) Rabinowitz action functional that we
  will use. Before doing so, we introduce the following convention. Given an
  autonomous Hamiltonian <math|F\<in\>C<rsup|\<infty\>>*<around|(|T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
  and a function <math|\<chi\>\<in\>C<rsup|\<infty\>><around|(|S<rsup|1>,<around|[|0,1|]>|)>>,
  we define <math|F<rsup|\<chi\>>:S<rsup|1>\<times\>T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>>
  by

  <\equation*>
    F<rsup|\<chi\>><around|(|t,x|)>\<assign\>\<chi\><around|(|t|)>*F<around|(|x|)>.
  </equation*>

  <\defn>
    Fix <math|F\<in\>C<rsup|\<infty\>>*<around|(|T<rsup|\<ast\>>*M,\<bbb-R\>|)>>,
    <math|f\<in\>C<rsup|\<infty\>><around|(|\<bbb-R\>,\<bbb-R\>|)>> and
    <math|\<chi\>\<in\>C<rsup|\<infty\>><around|(|S<rsup|1>,<around|[|0,\<infty\>|)>|)>>.
    The <with|font-series|bold|Rabinowitz action functional >associated to
    the triple <math|<around|(|F,f,\<chi\>|)>> is the functional

    <\equation*>
      A<rsub|F<rsup|\<chi\>>,f>:\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>\<rightarrow\>\<bbb-R\>
    </equation*>

    defined by

    <\equation*>
      A<rsub|F<rsup|\<chi\>>,f><around|(|x,\<eta\>|)>\<assign\><big|int>x<rsup|\<ast\>>*\<lambda\>-f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>F<rsup|\<chi\>><around|(|t,x|)>*d*t.
    </equation*>

    Suppose now <math|H\<in\>C<rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>>.
    The <with|font-series|bold|perturbed Rabinowitz action functional
    >associated to the quadruple <math|<around|(|F,f,\<chi\>,H|)>> is the
    functional

    <\equation*>
      A<rsub|F<rsup|\<chi\>>,f><rsup|H>:\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>\<rightarrow\>\<bbb-R\>
    </equation*>

    defined by

    <\equation*>
      A<rsub|F<rsup|\<chi\>>,f><rsup|H><around|(|x,\<eta\>|)>\<assign\><big|int>x<rsup|\<ast\>>*\<lambda\>-f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>F<rsup|\<chi\>><around|(|t,x|)>*d*t-<big|int><rsub|0><rsup|1>H<around|(|t,x|)>*d*t.
    </equation*>

    Thus <math|A<rsub|F<rsup|\<chi\>>,f>> corresponds to the trivial
    perturbation <math|H=0>.
  </defn>

  Although in principle we could use any functions <math|F,f,\<chi\>,H> in
  the definition above, the definition only becomes interesting when we
  restrict the class of functions we consider. Firstly, we will only ever use
  functions <math|F\<in\>\<cal-D\>>; in particular they will always be
  constant outside a compact set<footnote|At least until Section
  <reference|sec:The-convex-case>, that is.>. Here is the definition of the
  class of functions <math|f> we will study.

  <defn|Let <math|\<cal-F\>\<subseteq\>C<rsup|\<infty\>><around|(|\<bbb-R\>,\<bbb-R\><rsup|+>|)>>
  denote the set of smooth strictly positive functions
  <math|f:\<bbb-R\>\<rightarrow\>\<bbb-R\><rsup|+>> that are strictly
  increasing, satisfy <math|lim<rsub|\<eta\>\<rightarrow\>-\<infty\>>
  f<around|(|\<eta\>|)>=0>, and are such that the derivative
  <math|f<rprime|'>> satisfies <math|0\<less\>f<rprime|'><around|(|\<eta\>|)>\<leq\>1>
  for all <math|\<eta\>\<in\>\<bbb-R\>>.>

  <\rem>
    The reason for considering functions <math|f> of the following form is to
    be able to define continuation maps in Rabinowitz Floer homology for
    monotone homotopies. This will be explained in Section
    <reference|sub:Monotone-homotopies-and>, see Remark
    <reference|The-innocent-looking> in particular. The idea of perturbing
    the Rabinowitz action functional with such an auxiliary function is not
    new. For instance, in <cite|CieliebakFrauenfelderOancea2010> a similar
    idea was used; there however they used functions
    <math|f\<in\>C<rsup|\<infty\>><around|(|\<bbb-R\>,\<bbb-R\>|)>> that were
    of the form

    <\equation*>
      f<around|(|\<eta\>|)>=<choice|<tformat|<table|<row|<cell|\<eta\>>|<cell|<around*|\||\<eta\>|\|>\<leq\>R-\<varepsilon\>>>|<row|<cell|R>|<cell|<around*|\||\<eta\>|\|>\<geq\>R>>>>>
    </equation*>

    for some <math|R\<gtr\>\<varepsilon\>\<gtr\>0>. They used these (and
    other more general) perturbations in order to find the link between
    Rabinowitz Floer homology and symplectic homology.
  </rem>

  Next, we will only ever take <math|\<chi\>> to lie in a certain subset
  <math|\<cal-X\>> of <math|C<rsup|\<infty\>><around|(|S<rsup|1>,<around|[|0,\<infty\>|)>|)>>.
  In order to define <math|\<cal-X\>>, let us first associate to any element
  <math|\<chi\>\<in\>C<rsup|\<infty\>><around|(|S<rsup|1>,<around|[|0,\<infty\>|)>|)>>
  the function <math|<wide|\<chi\>|\<bar\>>:<around|[|0,1|]>\<rightarrow\><around|[|0,\<infty\>|)>>
  defined by

  <\equation*>
    <wide|\<chi\>|\<bar\>><around|(|t|)>\<assign\><big|int><rsub|0><rsup|t>\<chi\><around|(|\<tau\>|)>*d*\<tau\>.
  </equation*>

  Let <math|\<cal-X\>\<subseteq\>C<around|(|S<rsup|1>,<around|[|0,\<infty\>|)>|)>>
  denote those functions <math|\<chi\>> whose associated function
  <math|<wide|\<chi\>|\<bar\>>> satisfies the following conditions:

  <\enumerate>
    <item>There exists <math|t<rsub|0>=t<rsub|0><around|(|\<chi\>|)>\<in\><around|(|0,1|]>>
    such that <math|<wide|\<chi\>|\<bar\>><around|(|t|)>\<equiv\>1> on
    <math|<around|[|t<rsub|0>,1|]>>;

    <item>On <math|<around|[|0,t<rsub|0>|]>> the function
    <math|<wide|\<chi\>|\<bar\>>> is strictly increasing.
  </enumerate>

  Note that the function <math|\<chi\>\<equiv\>1> is an element of
  <math|\<cal-X\>>. It will sometimes be useful to restrict to the following
  subset <math|\<cal-X\><rsub|0>\<subseteq\>\<cal-X\>>:

  <\equation*>
    \<cal-X\><rsub|0>\<assign\><around*|{|\<chi\>\<in\>\<cal-X\><space|0.17em>:<space|0.17em>t<rsub|0><around|(|\<chi\>|)>\<less\>1/2|}>.
  </equation*>

  <\rem>
    <label|nu>Note that if <math|\<chi\>\<in\>\<cal-X\>> then there is a
    unique function <math|\<nu\>:<around|[|0,1|)>\<rightarrow\><around|[|0,t<rsub|0>|)>>
    such that

    <\equation*>
      <wide|\<chi\>|\<bar\>><around|(|\<nu\><around|(|t|)>|)>=t*<text|for all
      >t\<in\><around|[|0,1|)>.
    </equation*>

    One can extend <math|\<nu\>> to a continuous function
    <math|\<nu\>:<around|[|0,1|]>\<rightarrow\><around|[|0,t<rsub|0>|]>> by
    setting <math|\<nu\><around|(|1|)>\<assign\>t<rsub|0>>.
  </rem>

  Finally, here is the definition of the class of functions <math|H> we will
  use.

  <defn|Let <math|\<cal-H\>> denote the set of compactly supported
  time-dependent Hamiltonians <math|H\<in\>C<rsub|c><rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
  which have the additional property that
  <math|H*<around|(|t,\<cdot\>|)>\<equiv\>0> for
  <math|t\<in\><around|[|0,1/2|]>>.>

  It is easy to see that given any <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>
  we can find <math|H\<in\>\<cal-H\>> such that
  <math|\<varphi\>=\<phi\><rsub|1><rsup|H>>
  <cite-detail|AlbersFrauenfelder2010c|Lemma 2.3>. Note that the function
  <math|H\<equiv\>0> is in <math|\<cal-H\>>.

  In order to ease the notation, let us write

  <\equation*>
    \<frak-F\>\<assign\>\<cal-D\>\<times\>\<cal-F\>\<times\>\<cal-X\>\<times\>\<cal-H\>,
  </equation*>

  and refer to elements of <math|\<frak-F\>> by the single letter
  <math|\<frak-f\>>. Given <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\>>,
  we will often (but not always) write <math|A<rsub|\<frak-f\>>> as shorthand
  for the perturbed Rabinowitz action functional
  <math|A<rsub|F<rsup|\<chi\>>,f><rsup|H>>. In fact, most of the time we will
  work only with a subset <math|\<frak-F\><rsub|0>\<subseteq\>\<frak-F\>>.
  Let

  <\equation*>
    \<frak-F\><rsub|0><rprime|'>\<assign\>\<cal-D\>\<times\>\<cal-F\>\<times\>\<cal-X\>\<times\><around|{|0|}>;
  </equation*>

  <\equation*>
    \<frak-F\><rsub|0><rprime|''>\<assign\>\<cal-D\>\<times\>\<cal-F\>\<times\>\<cal-X\><rsub|0>\<times\>\<cal-H\>;
  </equation*>

  <\equation*>
    \<frak-F\><rsub|0>\<assign\>\<frak-F\><rsub|0><rprime|'>\<cup\>\<frak-F\><rsub|0><rprime|''>.
  </equation*>

  In other words, an element <math|\<frak-f\>\<in\>\<frak-F\>> lies in
  <math|\<frak-F\><rsub|0>> if and only if either <math|H=0> or
  <math|\<chi\>\<in\>\<cal-X\><rsub|0>>.

  Let <math|\<frak-f\>\<in\>\<frak-F\>>. One readily checks that a pair
  <math|<around|(|x,\<eta\>|)>\<in\>\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
  is a critical point of <math|A<rsub|\<frak-f\>>> if and only if

  <\equation>
    <choice|<tformat|<table|<row|<cell|<wide|x|\<dot\>>=f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>+X<rsub|H><around|(|t,x|)>,>>|<row|<cell|f<rprime|'><around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*F<around|(|x|)>*d*t=0.>>>>><label|eq:first
    eq>
  </equation>

  Since <math|f<rprime|'>\<gtr\>0> everywhere, these equations are equivalent
  to

  <\equation>
    <choice|<tformat|<table|<row|<cell|<wide|x|\<dot\>>=f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>+X<rsub|H><around|(|t,x|)>,>>|<row|<cell|<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*F<around|(|x|)>*d*t=0.>>>>><label|eq:sec
    eq>
  </equation>

  In particular, if <math|H=0> then since <math|F> is autonomous, these
  equations become:

  <\equation>
    <choice|<tformat|<table|<row|<cell|<wide|x|\<dot\>>=f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*R<rsub|\<Sigma\>><around|(|x|)>,>>|<row|<cell|x<around|(|S<rsup|1>|)>\<subseteq\>\<Sigma\>,>>>>><label|eq:third
    eq>
  </equation>

  where <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>>. Given
  <math|-\<infty\>\<leq\>a\<leq\>b\<leq\>\<infty\>>, denote by
  Crit<math|<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>|)>> the set
  of critical points <math|<around|(|x,\<eta\>|)>\<in\>\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
  with <math|A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>\<in\><around|(|a,b|)>>.
  Write simply Crit<math|<around|(|A<rsub|\<frak-f\>>|)>> instead of
  Crit<math|<rsup|(-\<infty\>,\<infty\>)><around|(|A<rsub|\<frak-f\>>|)>>.
  Similarly denote by <math|\<cal-A\><around|(|A<rsub|\<frak-f\>>|)>\<assign\>A<rsub|\<frak-f\>><around|(|<text|Crit><around|(|A<rsub|\<frak-f\>>|)>|)>>
  the<with|font-series|bold|action spectrum>of <math|A<rsub|\<frak-f\>>>.
  Given <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>, let
  Crit<math|<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>\<assign\><text|Crit><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>|)>\<cap\><around|(|\<Lambda\><rsub|\<alpha\>>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>|)>>
  and <math|\<cal-A\><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>\<assign\>A<rsub|\<frak-f\>><around|(|<text|Crit><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>|)>>.

  Given <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>
  and a fibrewise starshaped hypersurface <math|\<Sigma\>>, let

  <\equation*>
    <text|LW><rsub|+><around|(|\<Sigma\>,\<varphi\>|)>\<assign\><around*|{|p\<in\>\<Sigma\><space|0.17em>:<space|0.17em>p*<text|is
    a positive leaf-wise intersection point for >\<varphi\>|}>.
  </equation*>

  The following lemma explains the advantage of choosing
  <math|\<frak-f\>\<in\>\<frak-F\><rsub|0>>.

  <\lem>
    <label|lem:key lemma><cite|CieliebakFrauenfelder2009|AlbersFrauenfelder2008>

    <\enumerate>
      <item>Suppose <math|\<frak-f\>=<around|(|F,f,\<chi\>,0|)>\<in\>\<frak-F\><rsub|0><rprime|'>>,
      with <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>>. Let
      <math|\<nu\>:<around|[|0,1|]>\<rightarrow\><around|[|0,t<rsub|0>|]>>
      denote the function defined in Remark <reference|nu>. Then
      <math|<around|(|x,\<eta\>|)>\<in\><text|<em|Crit>><around|(|A<rsub|\<frak-f\>>|)>>
      if and only if <math|<around|(|x\<circ\>\<nu\>,f<around|(|\<eta\>|)>|)>\<in\>\<cal-P\><around|(|\<Sigma\>|)>>.
      Moreover in this case

      <\equation*>
        A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>=f<around|(|\<eta\>|)>\<gtr\>0.
      </equation*>

      <item>Now suppose <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0><rprime|''>>
      with <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>>. Let
      <math|\<varphi\>\<assign\>\<phi\><rsub|1><rsup|H>>. Then there is a
      surjective map

      <\equation*>
        e<rsub|\<frak-f\>>:<text|<em|Crit>><around|(|A<rsub|\<frak-f\>>|)>\<rightarrow\><text|<em|LW>><rsub|+><around|(|\<Sigma\>,\<varphi\>|)>
      </equation*>

      given by

      <\equation*>
        e<rsub|\<frak-f\>><around|(|x,\<eta\>|)>\<assign\>x<around|(|0|)>.
      </equation*>

      If the leaf <math|\<cal-L\><rsub|x<around|(|0|)>>> is not closed then
      <math|x<around|(|0|)>> has time-shift <math|f<around|(|\<eta\>|)>>. If
      there are no periodic leaf-wise intersection points then
      <math|e<rsub|\<frak-f\>>> is injective. Moreover if
      <math|<around|(|x,\<eta\>|)>\<in\><text|<em|Crit>><around|(|A<rsub|\<frak-f\>>|)>>
      then:

      <\equation>
        A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>=f<around|(|\<eta\>|)>-<big|int><rsub|0><rsup|1><around|{|\<lambda\><around|(|X<rsub|H><around|(|t,x|)>|)>-H<around|(|t,x|)>|}>*d*t.<label|eq:value
        of perturbed functional at crit>
      </equation>
    </enumerate>
  </lem>

  Let <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>> be as in part (2) of the
  previous lemma. As stated in the Introduction, we want to be able to
  associate to a leaf-wise intersection point
  <math|p\<in\><text|LW><rsub|+><around|(|\<Sigma\>,\<varphi\>|)>> a free
  homotopy class <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. It is
  natural to define

  <\equation*>
    <text|LW><rsub|+><around|(|\<Sigma\>,\<varphi\>,\<alpha\>|)>\<assign\>e<rsub|\<frak-f\>><around|(|<text|Crit><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>|)>.
  </equation*>

  The following lemma, based on a well known argument (see for example
  <cite-detail|Schwarz2000|Proposition 3.1>) implies that
  LW<math|<rsub|+><around|(|\<Sigma\>,\<varphi\>,\<alpha\>|)>> is well
  defined.

  <lem|<label|lem:Independence lemma>Suppose <math|\<Sigma\>> is a fibrewise
  starshaped hypersurface and <math|\<varphi\>\<in\><text|<em|Ham>><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>.
  Suppose <math|H<rsub|0>,H<rsub|1>\<in\>\<cal-H\>> both generate
  <math|\<varphi\>>. Let <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>>,
  <math|f\<in\>\<cal-F\>> and <math|\<chi\>\<in\>\<cal-X\><rsub|0>>. Set
  <math|\<frak-f\><rsub|i>\<assign\><around|(|F,f,\<chi\>,H<rsub|i>|)>\<in\>\<frak-F\><rsub|0><rprime|''>>
  for <math|i=0,1>. Fix <math|p\<in\><text|<em|LW>><rsub|+><around|(|\<Sigma\>,\<varphi\>|)>>
  and <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. Then there exists
  <math|<around|(|x<rsub|0>,\<eta\><rsub|0>|)>\<in\><text|<em|Crit>><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>>
  such that <math|e<rsub|\<frak-f\><rsub|0>><around|(|x<rsub|0>,\<eta\><rsub|0>|)>=p>
  if and only if there exists <math|<around|(|x<rsub|1>,\<eta\><rsub|1>|)>\<in\><text|<em|Crit>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>>
  such that <math|e<rsub|\<frak-f\><rsub|1>><around|(|x<rsub|1>,\<eta\><rsub|1>|)>=p>.>

  <\proof>
    Suppose <math|p\<in\><text|LW><rsub|+><around|(|\<Sigma\>,\<varphi\>|)>>.
    Thus there exists <math|\<eta\>\<in\>\<bbb-R\>> such that
    <math|\<varphi\><around|(|\<phi\><rsub|f<around|(|\<eta\>|)>><rsup|F><around|(|p|)>|)>=<around|(|p|)>>.
    Set <math|K<rsub|i>\<assign\>H<rsub|i>+f<around|(|\<eta\>|)>*F<rsup|\<chi\>>>
    for <math|i=0,1>. Then <math|p> is a fixed point of
    <math|\<phi\><rsub|1><rsup|K<rsub|0>>> and
    <math|\<phi\><rsub|1><rsup|K<rsub|1>>>, and if
    <math|x<rsub|i><around|(|t|)>\<assign\>\<phi\><rsub|t><rsup|K<rsub|i>><around|(|p|)>>
    then <math|<around|(|x<rsub|i>,\<eta\>|)>\<in\><text|Crit><around|(|A<rsub|\<frak-f\><rsub|i>>|)>>.
    Note that by construction <math|K<rsub|0>*<around|(|1,\<cdot\>|)>\<equiv\>0\<equiv\>K<rsub|1>*<around|(|1,\<cdot\>|)>>.
    Thus we may define a loop <math|<around|(|\<varphi\><rsub|t>|)><rsub|t\<in\>S<rsup|1>>\<subseteq\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>
    by

    <\equation*>
      \<varphi\><rsub|t>\<assign\><choice|<tformat|<table|<row|<cell|\<phi\><rsub|2*t><rsup|K<rsub|0>>,>|<cell|0\<leq\>t\<leq\>1/2,>>|<row|<cell|\<phi\><rsub|1-2*t><rsup|K<rsub|1>>,>|<cell|1/2\<leq\>t\<leq\>1.>>>>>
    </equation*>

    The flow <math|\<varphi\><rsub|t>> is the flow associated to the
    Hamiltonian <math|G\<in\>C<rsub|c><rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>>
    defined by

    <\equation*>
      G*<around|(|t,\<cdot\>|)>\<assign\><choice|<tformat|<table|<row|<cell|K<rsub|0>*<around|(|2*t,\<cdot\>|)>,>|<cell|0\<leq\>t\<leq\>1/2,>>|<row|<cell|-K<rsub|1>*<around|(|1-2*t,\<cdot\>|)>,>|<cell|1/2\<leq\>t\<leq\>1.>>>>>
    </equation*>

    Now consider the map <math|e<rsub|\<varphi\>>:T<rsup|\<ast\>>*M\<rightarrow\>\<Lambda\>*T<rsup|\<ast\>>*M>
    which sends a point in <math|T<rsup|\<ast\>>*M> to its orbit under
    <math|<around|(|\<varphi\><rsub|t>|)>>. Then
    im<math|<around|(|e<rsub|\<varphi\>>|)>> is contained in a connected
    component of <math|\<Lambda\>*T<rsup|\<ast\>>*M> (as <math|M> is
    connected). But from the proof of the Arnold conjecture for cotangent
    bundles we know that for any 1-periodic compactly supported Hamiltonian
    function there exists at least one contractible 1-periodic solution of
    the associated Hamiltonian system. Thus
    im<math|<around|(|e<rsub|\<varphi\>>|)>\<cap\>\<Lambda\><rsub|0>*T<rsup|\<ast\>>*M\<ne\>\<emptyset\>>,
    and hence every loop in the image of <math|e<rsub|\<varphi\>>> is
    contractible; in particular the loop <math|e<rsub|\<varphi\>><around|(|p|)>>
    is contractible. But <math|e<rsub|\<varphi\>><around|(|p|)>> is a
    reparametrization of the loop <math|x<rsub|0>\<ast\>x<rsub|1><rsup|-1>>.
    Thus necessarily <math|x<rsub|0>> and <math|x<rsub|1>> belong to the same
    component <math|\<Lambda\><rsub|\<alpha\>>*T<rsup|\<ast\>>*M> of
    <math|\<Lambda\>*T<rsup|\<ast\>>*M>.
  </proof>

  Next, we quote the following result due to Albers and Frauenfelder.

  <\prop>
    <label|prop:-generically no plwip><cite-detail|AlbersFrauenfelder2008|Theorem
    3.3> Suppose <math|dim <space|0.17em>M\<geq\>2>. Then if <math|\<Sigma\>>
    is a non-degenerate fibrewise starshaped hypersurface then there exists a
    generic set <math|\<cal-G\><around|(|\<Sigma\>|)>\<subseteq\><text|<em|Ham>><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>
    such that if <math|\<varphi\>\<in\>\<cal-G\><around|(|\<Sigma\>|)>> then
    there are no periodic leaf-wise intersection points:

    <\equation*>
      <text|<em|LW>><rsub|+><around|(|\<Sigma\>,\<varphi\>|)>\<cap\><around*|{|x<around|(|t|)><space|0.17em>:<space|0.17em><around|(|x,T|)>\<in\>\<cal-P\><around|(|\<Sigma\>|)>,<space|0.17em>t\<in\>S<rsup|1>|}>=\<emptyset\>.
    </equation*>
  </prop>

  It will be important to be able to control the size of
  <math|<around*|\||A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\|>> in terms of
  the size of <math|<around*|\||\<eta\>|\|>> and vice versa for
  <math|<around|(|x,\<eta\>|)>\<in\><text|Crit><around|(|A<rsub|\<frak-f\>>|)>>.
  This leads to the following definition.

  <\defn>
    <label|Define-a-semi-norm>Define a semi-norm
    <math|\<kappa\>:C<rsub|c><rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>\<rightarrow\><around|[|0,\<infty\>|)>>
    by

    <\equation*>
      \<kappa\><around|(|H|)>\<assign\>sup<rsub|<around|(|t,x|)>\<in\>S<rsup|1>\<times\>\<Lambda\>*T<rsup|\<ast\>>*M><around*|\||<big|int><rsub|0><rsup|1>\<lambda\><around|(|X<rsub|H><around|(|t,x|)>|)>-H<around|(|t,x|)>*d*t|\|>.
    </equation*>

    Note that

    <\equation*>
      \<kappa\><around|(|H|)>=sup <around*|{|<around*|\||\<eta\>|\|><space|0.17em>:<space|0.17em>\<eta\>\<in\>\<cal-A\><around|(|A<rsup|H>|)>|}>,
    </equation*>

    where <math|A<rsup|H>> is the standard action functional
    <eqref|eq:standard action functional>. As remarked in the introduction,
    since <math|\<cal-A\><around|(|A<rsup|H>|)>> depends only on the element
    <math|\<phi\><rsub|1><rsup|H>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>,
    we may regard <math|\<kappa\>> as being defined on
    <text|Ham><math|<rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>. Given
    <math|a\<geq\>0> let <math|\<cal-H\><around|(|a|)>\<subseteq\>\<cal-H\>>
    denote the subset of elements <math|H\<in\>\<cal-H\>> with
    <math|\<kappa\><around|(|H|)>\<leq\>a>.
  </defn>

  The following lemma is immediate from <eqref|eq:value of perturbed
  functional at crit>.

  <\lem>
    <label|lem:action bounds lemma>Suppose
    <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0>> with
    <math|H\<in\>\<cal-H\><around|(|c|)>> for some <math|c\<gtr\>0>. Then if
    <math|<around|(|x,\<eta\>|)>\<in\><text|<em|Crit>><around|(|A<rsub|\<frak-f\>>|)>>
    and <math|-\<infty\>\<less\>a\<less\>b\<less\>\<infty\>>,

    <\equation*>
      \<eta\>\<in\><around|(|a,b|)>\<Rightarrow\>f<around|(|a|)>-c\<less\>A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>\<less\>f<around|(|b|)>+c.
    </equation*>

    Now suppose that <math|a-c\<gtr\>0>. Then

    <\equation*>
      A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>\<in\><around|(|a,b|)>\<Rightarrow\>f<rsup|-1>*<around|(|a-c|)>\<less\>\<eta\>\<less\>f<rsup|-1>*<around|(|b+c|)>.
    </equation*>
  </lem>

  <cor|<label|cor:cptness of critical set>Fix
  <math|0\<less\>c\<less\>a\<less\>b\<less\>\<infty\>>. Suppose
  <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0>> with
  <math|H\<in\>\<cal-H\><around|(|c|)>>. Then the set
  <text|<em|Crit>><math|<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>|)>>
  is compact.>

  <\proof>
    Arguing similarly to Lemma <reference|lem:action bounds lemma>, we see
    that if <math|<around|(|x,\<eta\>|)>\<in\><text|Crit><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>|)>>
    then <math|\<eta\>\<in\><around|(|f<rsup|-1>*<around|(|a-c|)>,f<rsup|-1>*<around|(|b+c|)>|)>>.
    In particular, <math|<around*|\||\<eta\>|\|>> is bounded. Since <math|F>
    and <math|H> are compactly supported and <math|0> is a regular value of
    <math|F>, there exists a compact set <math|V\<subseteq\>T<rsup|\<ast\>>*M>
    such that <math|x<around|(|S<rsup|1>|)>\<subseteq\>V> for all
    <math|<around|(|x,\<eta\>|)>\<in\><text|Crit><around|(|A<rsub|\<frak-f\>>|)>>.
    Since <math|<around*|\||\<eta\>|\|>> is bounded, the Arzela-Ascoli
    theorem together with the first equation in <eqref|eq:sec eq> then imply
    that Crit<math|<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>|)>> is
    precompact, and hence compact.
  </proof>

  In fact, it will be most convenient to actually require
  <math|f<around|(|\<eta\>|)>=\<eta\>> in the action interval we work with.

  <defn|Given <math|a\<gtr\>0> denote by <math|\<cal-F\><around|(|a|)>\<subseteq\>\<cal-F\>>
  the subset of functions <math|f\<in\>\<cal-F\>> that satisfy
  <math|f<around|(|\<eta\>|)>=\<eta\>> for all
  <math|\<eta\>\<in\><around|[|a,\<infty\>|)>>.>

  We next address the non-degeneracy issue.

  <\defn>
    <label|def:non degen for H>An element
    <math|\<frak-f\>\<in\>\<frak-F\><rsub|0><rprime|'>> is called
    <with|font-series|bold|regular >if <math|A<rsub|\<frak-f\>>> is a
    <with|font-series|bold|Morse-Bott >function, and
    <text|Crit><math|<around|(|A<rsub|\<frak-f\>>|)>> is a discrete union of
    circles. If <math|\<frak-f\>=<around|(|F,f,\<chi\>,0|)>> with
    <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>> then <math|\<frak-f\>> is
    regular if and only if <math|\<Sigma\>> is non-degenerate in the sense of
    Definition <reference|def:non degen>. In particular, a generic element of
    <math|\<frak-F\><rsub|0><rprime|'>> is regular (cf. Theorem
    <reference|thm:nondeg is generic>). An element
    <math|\<frak-f\>\<in\>\<frak-F\><rsub|0><rprime|''>> is called
    <with|font-series|bold|regular >if <math|A<rsub|\<frak-f\>>> is a
    <with|font-series|bold|Morse >function. Given a fibrewise starshaped
    hypersurface <math|\<Sigma\>>, there is a residual subset
    <math|\<cal-R\><around|(|\<Sigma\>|)>\<subseteq\>\<cal-H\>> such that if
    <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>> and
    <math|H\<in\>\<cal-R\><around|(|\<Sigma\>|)>> then for any
    <math|f\<in\>\<cal-F\>> and <math|\<chi\>\<in\>\<cal-X\><rsub|0>> the
    quadruple <math|<around|(|F,f,\<chi\>,H|)>> is regular. See
    <cite-detail|AlbersFrauenfelder2010|Proposition 3.9>. We denote by

    <\equation*>
      \<frak-F\><rsub|0,<with|font-family|rm|r*e*g>>=\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>><rprime|'>\<cup\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>><rprime|''>
    </equation*>

    the set of regular elements of <math|\<frak-F\><rsub|0>>.
  </defn>

  Given <math|J\<in\>\<cal-J\>> we denote by
  <math|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>> the gradient of
  <math|A<rsub|\<frak-f\>>> with respect to the inner product
  <math|<around*|\<langle\>|<around*|\<langle\>|\<cdot\>,\<cdot\>|\<rangle\>>|\<rangle\>><rsub|J>>
  (see <eqref|eq:metric Jg>). A quick computation tells us

  <\equation*>
    \<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>=<around*|(|J<rsub|t><around|(|x|)>*<around|(|<wide|x|\<dot\>>-f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>-X<rsub|H><around|(|t,x|)>|)>,-f<rprime|'><around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*F<around|(|x|)>*d*t|)>.
  </equation*>

  <\defn>
    A <with|font-series|bold|gradient flow line>of <math|A<rsub|\<frak-f\>>>
    (with respect to <math|J\<in\>\<cal-J\>>) is a map
    <math|u:\<bbb-R\>\<rightarrow\>\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
    such that

    <\equation>
      \<partial\><rsub|s>*u+\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|u|)>=0.<label|eq:rf
      eq>
    </equation>

    In components <math|u=<around|(|x,\<eta\>|)>> this reads:

    <\equation*>
      \<partial\><rsub|s>*x+J<rsub|t><around|(|x|)>*<around|(|\<partial\><rsub|t>*x-f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>-X<rsub|H><around|(|t,x|)>|)>=0;
    </equation*>

    <\equation*>
      \<partial\><rsub|s>*\<eta\>-f<rprime|'><around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*F<around|(|x|)>*d*t=0.
    </equation*>

    Given <math|0\<less\>a\<less\>b\<less\>\<infty\>>, denote by
    <math|\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>|)>>
    the set of gradient flow lines <math|u:\<bbb-R\>\<rightarrow\>\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
    of <math|A<rsub|\<frak-f\>>> that satisfy
    <math|a\<less\>A<rsub|\<frak-f\>><around|(|u<around|(|s|)>|)>\<less\>b>
    for all <math|s\<in\>\<bbb-R\>>. Given
    <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>, let
    <math|\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>,\<alpha\>|)>>
    denote the subset of <math|\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>|)>>
    consisting of those flow lines <math|u=<around|(|x,\<eta\>|)>> that
    satisfy <math|[\<pi\>\<circ\>x(s,\<cdot\><around|)||]>=\<alpha\>> for all
    <math|s\<in\>\<bbb-R\>>.
  </defn>

  Fix <math|\<frak-f\>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>>>.
  It is well known that the non-degeneracy assumption that
  <math|A<rsub|\<frak-f\>>> is Morse(-Bott) implies that every element
  <math|u\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>|)>>
  is asymptotically convergent at each end to elements of
  Crit<math|<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>|)>>. That is,
  the limits

  <\equation*>
    lim<rsub|s\<rightarrow\>\<pm\>\<infty\>>
    u<around|(|s,t|)>=:<around|(|x<rsub|\<pm\>><around|(|t|)>,\<eta\><rsub|\<pm\>>|)>,lim<rsub|s\<rightarrow\>\<infty\>>
    \<partial\><rsub|t>*u<around|(|s,t|)>=0,
  </equation*>

  exist, and the convergence is uniform in <math|t>, and the limits
  <math|<around|(|x<rsub|\<pm\>>,\<eta\><rsub|\<pm\>>|)>> belong to
  Crit<math|<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>|)>> (see for
  instance <cite|Salamon1999>). Moreover, if <math|E<around|(|u|)>> denotes
  the <with|font-series|bold|energy>of a gradient flow line:

  <\equation*>
    E<around|(|u|)>\<assign\><big|int><rsub|-\<infty\>><rsup|\<infty\>><around*|\<\|\|\>|\<partial\><rsub|s>*u<around|(|s|)>|\<\|\|\>><rsub|J><rsup|2>*d*s,
  </equation*>

  then if <math|u\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>|)>>
  is asymptotically convergent to <math|<around|(|x<rsub|\<pm\>>,\<eta\><rsub|\<pm\>>|)>\<in\><text|Crit><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>|)>>
  it holds that

  <\equation*>
    A<rsub|\<frak-f\>><around|(|x<rsub|->,\<eta\><rsub|->|)>-A<rsub|\<frak-f\>><around|(|x<rsub|+>,\<eta\><rsub|+>|)>=E<around|(|u|)>\<gtr\>0.
  </equation*>

  Given <math|u\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>|)>>,
  the linearization of the gradient flow equation gives rise to a Fredholm
  operator <math|D<rsub|u>>. There exists a residual subset
  <math|\<cal-J\><rsub|<with|font-family|rm|r*e*g>><around|(|\<frak-f\>|)>>
  such that if <math|J\<in\>\<cal-J\><rsub|<with|font-family|rm|r*e*g>><around|(|\<frak-f\>|)>>
  then for every <math|0\<less\>a\<less\>b\<less\>\<infty\>> and every
  <math|u\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>|)>>
  the operator <math|D<rsub|u>> is surjective.

  <\defn>
    <label|def:acs def>Suppose <math|S> is a fibrewise starshaped
    hypersurface. An <math|\<omega\>>-compatible almost complex structure
    <math|J> on <math|T<rsup|\<ast\>>*M> is called
    <with|font-series|bold|convex >on <math|T<rsup|\<ast\>>*M\<setminus\>D<rsup|\<circ\>><around|(|S|)>>
    if the following three conditions hold:

    <\equation*>
      J<around|(|\<xi\><rsub|S>|)>=\<xi\><rsub|S>,\<omega\>*<around|(|J<around|(|p|)>*Y<around|(|p|)>,Y<around|(|p|)>|)>=1,d<rsub|p>*\<phi\><rsub|t><rsup|Y>\<circ\>J<around|(|p|)>=J<around|(|p|)>\<circ\>d<rsub|p>*\<phi\><rsub|t><rsup|Y>*<text|for
      all >p\<in\>S.
    </equation*>

    Here <math|\<phi\><rsub|t><rsup|Y>> is the semi-flow of <math|Y> on
    <math|T<rsup|\<ast\>>*M\<setminus\>D<rsup|\<circ\>><around|(|S|)>>.
    Denote by <math|\<cal-J\><around|(|S|)>\<subseteq\>\<cal-J\>> the set of
    all time dependent almost complex structures
    <math|J=<around|(|J<rsub|t>|)><rsub|t\<in\>S<rsup|1>>> such that each
    <math|J<rsub|t>> is convex and independent of <math|t> on
    <math|T<rsup|\<ast\>>*M\<setminus\>D<rsup|\<circ\>><around|(|S|)>>.
  </defn>

  Our motivation for studying such almost complex structures is the following
  lemma, which is based on a well known argument using the maximum principle.

  <lem|<label|lem:why convex good>Suppose <math|\<Sigma\>,S> are fibrewise
  starshaped hypersurfaces with <math|D<around|(|\<Sigma\>|)>\<subseteq\>D<rsup|\<circ\>><around|(|S|)>>.
  Suppose <math|\<frak-f\>=<around|(|F,f,H,\<chi\>|)>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|<em|r*e*g>>>>,
  where <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>> is such that
  <text|<em|supp>><math|<around|(|X<rsub|F>|)>\<subseteq\>D<rsup|\<circ\>><around|(|S|)>>.
  Fix <math|J\<in\>\<cal-J\><around|(|S|)>>. Then for any
  <math|0\<less\>a\<less\>b\<less\>\<infty\>> and any
  <math|u\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>|)>>
  we have <text|<em|im>><math|<around|(|u|)>\<subseteq\>D<around|(|S|)>>.>

  <subsection|Floer homology of the Rabinowitz action
  functional><label|sub:Floer-homology-of>

  <vspace|6 pt>

  We now define the Rabinowitz Floer chain complex associated to the action
  functional <math|A<rsub|\<frak-f\>>> for
  <math|\<frak-f\>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>>>. The
  construction is slightly different depending as to whether
  <math|\<frak-f\>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>><rprime|'>>
  or <math|\<frak-f\>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>><rprime|''>>.
  We begin with the latter case, since this is somewhat easier.

  Fix <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>><rprime|''>>,
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>> and
  <math|0\<less\>a\<less\>b\<less\>\<infty\>>. Suppose
  <math|v\<assign\><around|(|x,\<eta\>|)>> is a critical point of
  <math|A<rsub|\<frak-f\>>>. Then <math|x> is a 1-periodic orbit of the
  time-dependent Hamiltonian <math|G\<assign\>f<around|(|\<eta\>|)>*F<rsup|\<chi\>>+H>.
  Since <math|A<rsub|\<frak-f\>>> is Morse, <math|x> is a non-degenerate
  orbit, and hence the <with|font-series|bold|Conley-Zehnder index
  ><math|\<mu\><rsub|<with|font-family|rm|C*Z>><around|(|x;G|)>> of <math|x>
  as an orbit of <math|G> is a well defined integer. See for instance
  <cite|SalamonZehnder1992> or <cite|AbbondandoloSchwarz2006> (the latter in
  particular for non-contractible loops) for the definition of the
  Conley-Zehnder index, although note that our sign conventions match
  <cite|AbbondandoloPortaluriSchwarz2008> not <cite|SalamonZehnder1992> or
  <cite|AbbondandoloSchwarz2006>. We define
  <math|\<mu\><around|(|v|)>\<assign\>\<mu\><rsub|<with|font-family|rm|C*Z>><around|(|x;G|)>>.
  Let Crit<math|<rsub|k><around|(|A<rsub|\<frak-f\>>|)>> denote those
  critical points <math|v> with index <math|\<mu\><around|(|v|)>=k>. Denote
  by <math|C*F<rsub|k><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>
  the <math|\<bbb-Z\><rsub|2>>-vector space

  <\equation*>
    C*F<rsub|k><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>\<assign\><text|Crit><rsub|k><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>\<otimes\>\<bbb-Z\><rsub|2>.
  </equation*>

  Choose <math|J\<in\>\<cal-J\><rsub|<with|font-family|rm|r*e*g>><around|(|\<frak-f\>|)>>.
  Given <math|v<rsub|\<pm\>>\<in\><text|Crit><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>
  denote by <math|\<cal-M\><around|(|v<rsub|->,v<rsub|+>|)>> the moduli space
  of maps <math|u\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>,\<alpha\>|)>>
  that are asymptotically convergent to <math|v<rsub|\<pm\>>>, divided out by
  the translation <math|\<bbb-R\>>-action. Then
  <math|\<cal-M\><around|(|v<rsub|->,v<rsub|+>|)>> carries the structure of a
  smooth manifold of dimension <math|\<mu\><around|(|v<rsub|->|)>-\<mu\><around|(|v<rsub|+>|)>-1>.
  Under certain conditions (see Theorem <reference|thm:main theorem of rfh>
  below) the manifolds <math|\<cal-M\><around|(|v<rsub|->,v<rsub|+>|)>> are
  compact up to breaking. Assuming this is the case, the boundary operator
  <math|\<partial\>> on <math|C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>
  is defined via:

  <\equation*>
    \<partial\>*v\<assign\><big|sum><rsub|w\<in\><with|font-family|rm|C*r*i*t><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>#<rsub|2>\<cal-M\><rsub|0><around|(|v,w|)>*w,
  </equation*>

  where <math|\<cal-M\><rsub|0><around|(|v,w|)>> denotes the possibly empty
  zero-dimensional component of <math|\<cal-M\><around|(|v,w|)>>, and
  <math|#<rsub|2>> denotes the cardinality taken modulo <math|2>. It turns
  out that <math|\<partial\>> has degree <math|-1> with respect to the
  grading <math|\<mu\>>. We denote by <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>
  the resulting homology, which is independent of the choice of almost
  complex structure <math|J\<in\>\<cal-J\><rsub|<with|font-family|rm|r*e*g>><around|(|\<frak-f\>|)>>
  we chose.

  Now let us consider the case <math|\<frak-f\>=<around|(|F,f,\<chi\>,0|)>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>><rprime|'>>.
  Suppose <math|v\<assign\><around|(|x,\<eta\>|)>> is a critical point of
  <math|A<rsub|\<frak-f\>>>. Then <math|x> is a 1-periodic orbit of the
  time-dependent Hamiltonian <math|G\<assign\>f<around|(|\<eta\>|)>*F<rsup|\<chi\>>>.
  Since <math|A<rsub|\<frak-f\>>> is Morse-Bott, <math|x> is a transversely
  non-degenerate orbit, and hence the <with|font-series|bold|transverse
  Conley-Zehnder index ><math|\<mu\><rsub|<with|font-family|rm|C*Z>><rsup|\<tau\>><around|(|x;G|)>>
  of <math|x> as an orbit of <math|X<rsub|G>> is a well defined integer (see
  for instance <cite-detail|AbbondandoloSchwarz2009|Section 3> for the
  definition of the transverse Conley-Zehnder index).

  Pick a Morse function <math|h:<text|Crit><around|(|A<rsub|\<frak-f\>>|)>\<rightarrow\>\<bbb-R\>>,
  and denote by Crit<math|<around|(|h|)>\<subseteq\><text|Crit><around|(|A<rsub|\<frak-f\>>|)>>
  the set of critical points of <math|h>. Define an augmented grading
  <math|\<mu\>:<text|Crit><around|(|h|)>\<rightarrow\>\<bbb-Z\>> by

  <\equation*>
    \<mu\><around|(|v|)>\<assign\>\<mu\><rsub|<with|font-family|rm|C*Z>><rsup|\<tau\>><around|(|x;G|)>+i<rsub|h><around|(|v|)>,v=<around|(|x,\<eta\>|)>,
  </equation*>

  where <math|i<rsub|h><around|(|v|)>\<in\><around|{|0,1|}>> is the Morse
  index of <math|v>. Let Crit<math|<rsub|k><rsup|<around|(|a,b|)>><around|(|h,\<alpha\>|)>\<assign\><around|{|v\<in\><text|Crit><around|(|h|)>\<cap\><text|Crit><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)><space|0.17em>:<space|0.17em>\<mu\><around|(|v|)>=k|}>>.
  Given <math|k\<in\>\<bbb-Z\>>, define

  <\equation*>
    C*F<rsub|k><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>\<assign\><text|Crit><rsub|k><rsup|<around|(|a,b|)>><around|(|h,\<alpha\>|)>\<otimes\>\<bbb-Z\><rsub|2>.
  </equation*>

  One now defines the boundary operator in much the same way as before, only
  this time one must take <math|\<cal-M\><around|(|v<rsub|->,v<rsub|+>|)>> to
  be the moduli space of <with|font-series|bold|gradient flow lines with
  cascades> of <math|h>. We refer the reader to
  <cite-detail|Frauenfelder2004|Appendix A> for more information. We
  emphasize once again that in order to be able to define the Floer homology
  we need the manifolds <math|\<cal-M\><around|(|v<rsub|->,v<rsub|+>|)>> to
  be compact up to breaking, which is <with|font-series|bold|not> always the
  case.

  <subsection|Admissible quadruples>

  <vspace|6 pt>

  <\defn>
    <label|Fix-.-Ad>Fix <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. A
    quadruple <math|\<frak-q\>=<around|(|\<frak-f\>,a,b,J|)>> consisting of
    <math|\<frak-f\>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>>>,
    <math|J\<in\><with|math-font|cal|J<rsub|<with|font-family|rm|r*e*g>>><around|(|\<frak-f\>|)>>
    and <math|0\<less\>a\<less\>b\<less\>\<infty\>> is called
    <with|font-series|bold|<math|\<alpha\>>-admissible >if the following
    conditions are satisfied:

    <\enumerate>
      <item><math|\<cal-A\><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>\<cap\><around|{|a,b|}>=\<emptyset\>>;

      <item>The set <text|Crit><math|<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>
      is compact;

      <item>There exist constants <math|C<rsub|<with|font-family|rm|l*o*o*p>>,C<rsub|<with|font-family|rm|m*u*l*t>>\<gtr\>0>
      such that for all <math|u=<around|(|x,\<eta\>|)>\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>,\<alpha\>|)>>
      it holds that <math|<around*|\<\|\|\>|x|\<\|\|\>><rsub|L<rsup|\<infty\>>>\<less\>C<rsub|<with|font-family|rm|l*o*o*p>>>
      and <math|<around*|\<\|\|\>|\<eta\>|\<\|\|\>><rsub|L<rsup|\<infty\>>>\<less\>C<rsub|<with|font-family|rm|m*u*l*t>>>.
    </enumerate>

    A quadruple <math|\<frak-q\>> is simply called
    <with|font-series|bold|admissible >if it is <math|\<alpha\>>-admissible
    for all <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>.
  </defn>

  The next result follows by standard arguments in Floer homology, see for
  instance <cite|Salamon1990>.

  <thm|<label|thm:main theorem of rfh>Fix
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. If
  <math|\<frak-q\>=<around|(|\<frak-f\>,a,b,J|)>> is an
  <math|\<alpha\>>-admissible quadruple, then the Floer homology
  <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>
  is well defined (that is, the manifolds
  <math|\<cal-M\><around|(|v<rsub|->,v<rsub|+>|)>> are compact up to
  breaking, see above).>

  We will now find conditions under which a quadruple
  <math|\<frak-q\>=<around|(|\<frak-f\>,a,b,J|)>> is admissible. The first
  step is the following two preliminary lemmas, which are minor modifications
  of the argument of <cite-detail|AlbersFrauenfelder2010c|Lemma 2.11>.

  <\lem>
    <label|lem:1>Suppose <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0>>
    and <math|J\<in\>\<cal-J\>>. There exist constants <math|k,T\<gtr\>0>
    depending only on <math|F> such that if
    <math|x\<in\>\<Lambda\>*T<rsup|\<ast\>>*M> satisfies

    <\equation*>
      x<around|(|<text|<em|supp>><around|(|\<chi\>|)>|)>\<subseteq\>U<rsub|k><around|(|F|)>\<assign\>F<rsup|-1>(-k,k)
    </equation*>

    then it holds that

    <\equation*>
      <frac|2|3>*<around*|(|A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>-T*<around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>-\<kappa\><around|(|H|)>|)>\<leq\>f<around|(|\<eta\>|)>\<leq\>2*<around*|(|A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>+T*<around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>+\<kappa\><around|(|H|)>|)>.
    </equation*>
  </lem>

  <\proof>
    In this proof and the next we denote by
    <math|<around*|\<\|\|\>|\<cdot\>|\<\|\|\>><rsub|2>> the norm

    <\equation*>
      <around*|\<\|\|\>|\<xi\>|\<\|\|\>><rsub|2>\<assign\><big|int><rsub|0><rsup|1>\<omega\>*<around|(|J*\<xi\>,\<xi\>|)>*d*t,
    </equation*>

    so that

    <\equation*>
      <around*|\<\|\|\>|<around|(|\<xi\>,b|)>|\<\|\|\>><rsub|J>=<sqrt|<around*|\<\|\|\>|\<xi\>|\<\|\|\>><rsub|2><rsup|2>+b<rsup|2>>.
    </equation*>

    There exists <math|k\<gtr\>0> such that

    <\equation*>
      <frac|1|2>+k\<leq\>\<lambda\><around|(|X<rsub|F><around|(|p|)>|)>\<leq\><frac|3|2>-k*<text|for
      all >p\<in\>U<rsub|k><around|(|F|)>.
    </equation*>

    Set

    <\equation*>
      T=T<around|(|F|)>\<assign\><around*|\<\|\|\>|\<lambda\>\|<rsub|U<rsub|k><around|(|F|)>>|\<\|\|\>><rsub|\<infty\>>.
    </equation*>

    For any <math|<around|(|x,\<eta\>|)>\<in\>\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
    with <math|x<around|(|<text|supp><around|(|\<chi\>|)>|)>\<subseteq\>U<rsub|k><around|(|F|)>>,
    we have

    <align*|<tformat|<table|<row|<cell|A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>>|<cell|=<big|int><rsub|0><rsup|1>\<lambda\><around|(|<wide|x|\<dot\>>|)>*d*t-f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>F<rsup|\<chi\>><around|(|t,x|)>*d*t-<big|int><rsub|0><rsup|1>H<around|(|t,x|)>*d*t>>|<row|<cell|>|<cell|=f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<lambda\>*<around|(|\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>|)>*d*t+<big|int><rsub|0><rsup|1>\<lambda\>*<around|(|<wide|x|\<dot\>>-f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>|)>*d*t>>|<row|<cell|>|<cell|-f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*F<around|(|x|)>*d*t-<big|int><rsub|0><rsup|1>H<around|(|t,x|)>*d*t>>|<row|<cell|>|<cell|\<geq\>f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*\<lambda\><around|(|X<rsub|F><around|(|x|)>|)>*d*t-<around*|\||<big|int><rsub|0><rsup|1>\<lambda\>*<around|(|<wide|x|\<dot\>>-f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>-X<rsub|H><around|(|t,x|)>|)>*d*t|\|>>>|<row|<cell|>|<cell|-f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*F<around|(|x|)>*d*t-\<kappa\><around|(|H|)>>>|<row|<cell|>|<cell|\<geq\><around*|(|<frac|1|2>+k|)>*f<around|(|\<eta\>|)>-T*<around*|\<\|\|\>|<wide|x|\<dot\>>-f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>-X<rsub|H><around|(|t,x|)>|\<\|\|\>><rsub|2>-f<around|(|\<eta\>|)>*k-\<kappa\><around|(|H|)>>>|<row|<cell|>|<cell|\<geq\><frac|1|2>*f<around|(|\<eta\>|)>-T*<around*|\<\|\|\>|<wide|x|\<dot\>>-f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>-X<rsub|H><around|(|t,x|)>|\<\|\|\>><rsub|2>-\<kappa\><around|(|H|)>>>|<row|<cell|>|<cell|\<geq\><frac|1|2>*f<around|(|\<eta\>|)>-T*<around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>-\<kappa\><around|(|H|)>,>>>>>

    and similarly

    <align*|<tformat|<table|<row|<cell|A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>>|<cell|=<big|int><rsub|0><rsup|1>\<lambda\><around|(|<wide|x|\<dot\>>|)>*d*t-f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>F<rsup|\<chi\>><around|(|t,x|)>*d*t-<big|int><rsub|0><rsup|1>H<around|(|t,x|)>*d*t>>|<row|<cell|>|<cell|=f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<lambda\>*<around|(|\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>|)>*d*t+<big|int><rsub|0><rsup|1>\<lambda\>*<around|(|<wide|x|\<dot\>>-f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|t,x|)>|)>*d*t>>|<row|<cell|>|<cell|-f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*F<around|(|x|)>*d*t-<big|int><rsub|0><rsup|1>H<around|(|t,x|)>*d*t>>|<row|<cell|>|<cell|\<leq\>f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*\<lambda\><around|(|X<rsub|F><around|(|x|)>|)>*d*t+<around*|\||<big|int><rsub|0><rsup|1>\<lambda\>*<around|(|<wide|x|\<dot\>>-f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>-X<rsub|H><around|(|t,x|)>|)>*d*t|\|>>>|<row|<cell|>|<cell|-f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*F<around|(|x|)>*d*t+\<kappa\><around|(|H|)>>>|<row|<cell|>|<cell|\<leq\><around*|(|<frac|3|2>-k|)>*f<around|(|\<eta\>|)>+T*<around*|\<\|\|\>|<wide|x|\<dot\>>-f<around|(|\<eta\>|)>*\<chi\><around|(|t|)>*X<rsub|F><around|(|x|)>-X<rsub|H><around|(|t,x|)>|\<\|\|\>><rsub|2>+f<around|(|\<eta\>|)>*k+\<kappa\><around|(|H|)>>>|<row|<cell|>|<cell|\<leq\><frac|3|2>*f<around|(|\<eta\>|)>+T*<around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>+\<kappa\><around|(|H|)>.>>>>>
  </proof>

  <\lem>
    <label|lem:lemma 2>Suppose <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0>>
    and <math|J\<in\>\<cal-J\>>. For every <math|k\<gtr\>0> there exists
    <math|\<rho\>=\<rho\><around|(|k,F|)>\<gtr\>0> such that if
    <math|<around|(|x,\<eta\>|)>\<in\>\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
    satisfies:

    <\equation*>
      <around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>\<leq\>\<rho\>*f<rprime|'><around|(|\<eta\>|)>,
    </equation*>

    then <math|x<around|(|<text|<em|supp>><around|(|\<chi\>|)>|)>\<subseteq\>U<rsub|k><around|(|F|)>>.
  </lem>

  <\proof>
    To begin with, arguing exactly as in <cite-detail|AlbersFrauenfelder2010c|Lemma
    2.11, Claim 2> (which only uses the loop component of the
    <math|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>>), one
    sees that if <math|x<around|(|<text|supp><around|(|\<chi\>|)>|)>\<cap\><around|(|T<rsup|\<ast\>>*M\<setminus\>U<rsub|k><around|(|F|)>|)>\<ne\>\<emptyset\>>
    and<math|x<around|(|<text|supp><around|(|\<chi\>|)>|)>\<cap\>U<rsub|k/2><around|(|F|)>\<ne\>\<emptyset\>>
    then

    <\equation*>
      <around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>\<geq\><frac|k|2*<around*|\<\|\|\>|\<nabla\>*F|\<\|\|\>><rsub|\<infty\>>>.
    </equation*>

    Next, if <math|x<around|(|<text|supp><around|(|\<chi\>|)>|)>\<subseteq\>T<rsup|\<ast\>>*M\<setminus\>U<rsub|k/2><around|(|F|)>>
    then looking at the second component of the gradient equation,

    <\equation*>
      <around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>\<geq\><around*|\||f<rprime|'><around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>\<chi\><around|(|t|)>*F<around|(|x|)>*d*t|\|>\<geq\>f<rprime|'><around|(|\<eta\>|)><frac|k|2>.
    </equation*>

    Thus if

    <\equation*>
      \<rho\>\<assign\>\<rho\><around|(|k,F|)>\<assign\>min
      <around*|{|<frac|k|2>,<frac|k|2*<around*|\<\|\|\>|\<nabla\>*F|\<\|\|\>><rsub|L<rsup|\<infty\>>>>|}>,
    </equation*>

    then using the fact that <math|f<rprime|'><around|(|\<eta\>|)>\<leq\>1>
    for all <math|\<eta\>\<in\>\<bbb-R\>> as <math|f\<in\>\<cal-F\>>, we see
    that if <math|<around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>\<leq\>\<rho\>*f<rprime|'><around|(|\<eta\>|)>>
    then both of the two previous options cannot happen, and hence we must
    have <math|x<around|(|<text|supp><around|(|\<chi\>|)>|)>\<subseteq\>U<rsub|k><around|(|F|)>>.
  </proof>

  Putting these two results together we deduce:

  <\cor>
    <label|cor:the linfty cor>Suppose <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0>>
    and <math|J\<in\>\<cal-J\>>. There exist constants
    <math|\<rho\>,T\<gtr\>0> depending only on <math|F> such that if
    <math|<around|(|x,\<eta\>|)>\<in\>\<Lambda\>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
    satisfies

    <\equation*>
      <around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>\<less\>\<rho\>*f<rprime|'><around|(|\<eta\>|)>
    </equation*>

    then

    <\equation*>
      <frac|2|3>*<around*|(|A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>-T*<around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>-\<kappa\><around|(|H|)>|)>\<leq\>f<around|(|\<eta\>|)>\<leq\>2*<around*|(|A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>+T*<around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|x,\<eta\>|)>|\<\|\|\>><rsub|J>+\<kappa\><around|(|H|)>|)>.
    </equation*>
  </cor>

  <rem|<label|rem:Observe-the constants>The constants
  <math|\<rho\><around|(|F|)>> and <math|T<around|(|F|)>> depend continuously
  on <math|F>, and depend only on the behavior of <math|F> close to
  <math|F<rsup|-1><around|(|0|)>>.>

  We now further refine the class of functions <math|f> that we consider.

  <\defn>
    <label|def:strange def>Given <math|a,r\<gtr\>0> let
    <math|\<cal-F\><around|(|a,r|)>\<subseteq\>\<cal-F\><around|(|a|)>>
    denote those functions that satisfy the additional condition:

    <\itemize>
      <item>There exists <math|A\<gtr\>0> such that

      <\equation>
        A*f<rprime|'>(-A)\<gtr\>r.<label|eq:the constant A>
      </equation>
    </itemize>
  </defn>

  <\rem>
    <label|messy f>Given <math|a\<gtr\>0> it is possible to construct a
    function <math|f\<in\><big|cap><rsub|r\<gtr\>0>\<cal-F\><around|(|a,r|)>>.
    To do this one first considers a function
    <math|f<rsub|1>\<in\>\<cal-F\><around|(|a|)>> such that
    <math|f<rsub|1><around|(|\<eta\>|)>=e<rsup|\<eta\>>> for
    <math|\<eta\>\<leq\>log <space|0.17em>a/2>. Then for each
    <math|n\<in\>\<bbb-N\>>, <math|n\<geq\>log <space|0.17em>a/2> one can
    choose <math|\<varepsilon\><rsub|n>\<gtr\>0> with
    <math|\<varepsilon\><rsub|n>\<rightarrow\>0> such that <math|f<rsub|1>>
    can be modified on each interval (<math|-n-1/2,-n+1/2>) to a new function
    <math|f\<in\>\<cal-F\><around|(|a|)>> with the property that
    <math|f<rprime|'><around|(|\<eta\>|)>=1> for
    <math|\<eta\>\<in\>(-n-\<varepsilon\><rsub|n>,-n+\<varepsilon\><rsub|n>>).

    A rough construction of this is as follows: given <math|n\<gtr\>log
    <space|0.17em>a/2> let

    <\equation*>
      \<delta\><rsub|n>\<assign\><frac|1|2>*<around*|(|e<rsup|-n+1/2>-e<rsup|-n-1/2>|)>.
    </equation*>

    Let <math|f<rsub|2>> denote the (non-smooth) function such that
    <math|f<rsub|2>=f<rsub|1>> on <math|<around*|\<nobracket\>|\<bbb-R\>\<setminus\><around*|(|<big|cup><rsub|n\<geq\>log
    <space|0.17em>a/2>|(>-n-1/2,-n+1/2)|)>> and on each interval
    (<math|-n-1/2,-n+1/2>) is the piecewise linear function

    <\equation*>
      f<rsub|2><around|(|\<eta\>|)>=<choice|<tformat|<table|<row|<cell|e<rsup|-n-1/2>,>|<cell|-n-1/2\<less\>\<eta\>\<leq\>-n-\<delta\><rsub|n>,>>|<row|<cell|\<eta\>+e<rsup|-n-1/2>+n+\<delta\><rsub|n>,>|<cell|-n-\<delta\><rsub|n>\<leq\>\<eta\>\<leq\>-n+\<delta\><rsub|n>,>>|<row|<cell|e<rsup|-n+1/2>,>|<cell|-n+\<delta\><rsub|n>\<leq\>\<eta\>\<less\>-n+1/2.>>>>>
    </equation*>

    Note that <math|f<rsub|2>> is continuous by the choice of
    <math|\<delta\><rsub|n>>. Now set <math|\<varepsilon\><rsub|n>\<assign\><frac|1|2>*\<delta\><rsub|n>>.
    Then one can construct a smooth function
    <math|f\<in\>\<cal-F\><around|(|a|)>> such that <math|f=f<rsub|2>> on
    <math|<around*|\<nobracket\>|\<bbb-R\>\<setminus\><around*|(|<big|cup><rsub|n\<geq\>log
    <space|0.17em>a/2>|(>-n-1/2,-n-\<varepsilon\><rsub|n>)\<cup\>(-n+\<varepsilon\><rsub|n>,-n+<frac|1|2>)|)>>.
    See Figure <reference|fig:The-function> below. By construction
    <math|f<rprime|'>(-n)=1> for each <math|n\<geq\>log <space|0.17em>a/2>,
    and hence <math|f\<in\><big|cap><rsub|r\<gtr\>0>\<cal-F\><around|(|a,r|)>>.

    <\big-figure>
      <image|figure||||>
    </big-figure|<label|fig:The-function>The function <math|f>>
  </rem>

  The following lemma is elementary, but for the convenience of the reader we
  include a proof.

  <lem|<label|lem:about the set F>For any <math|a,r\<gtr\>0> the set
  <math|\<cal-F\><around|(|a,r|)>> is non-empty and path-connected. If
  <math|a<rprime|'>\<leq\>a> and <math|r<rprime|'>\<geq\>r> then
  <math|\<cal-F\><around|(|a<rprime|'>,r<rprime|'>|)>\<subseteq\>\<cal-F\><around|(|a,r|)>>.>

  <\proof>
    We have already proved that <math|\<cal-F\><around|(|a,r|)>> is non-empty
    (see Remark <reference|messy f> above). To show that
    <math|\<cal-F\><around|(|a,r|)>> is path-connected, first observe that if
    <math|f<rsub|0>,f<rsub|1>\<in\>\<cal-F\><around|(|a,r|)>> both satisfy
    <eqref|eq:the constant A> with the <with|font-series|bold|same>constant
    <math|A\<gtr\>0> then the linear homotopy
    <math|f<rsub|s>\<assign\>s*f<rsub|1>+<around|(|1-s|)>*f<rsub|0>> is
    contained in <math|\<cal-F\><around|(|a,r|)>> for all
    <math|s\<in\><around|[|0,1|]>>. It therefore suffices to show that if
    <math|f\<in\>\<cal-F\><around|(|a,r|)>> satisfies <eqref|eq:the constant
    A> with respect to some <math|A\<gtr\>0>, then given any <math|B\<gtr\>A>
    we can find a new function <math|f<rsub|1>\<in\>\<cal-F\><around|(|a,r|)>>
    that satisfies <eqref|eq:the constant A> with respect to <math|B>, and
    such that we may find a homotopy <math|<around|(|f<rsub|s>|)><rsub|s\<in\><around|[|0,1|]>>\<subseteq\>\<cal-F\><around|(|a,r|)>>
    with <math|f<rsub|0>=f>.

    In order to do this, let <math|<around|(|\<lambda\><rsub|s>|)><rsub|s\<in\><around|[|0,1|]>>>
    denote a family of smooth functions <math|\<lambda\><rsub|s>:\<bbb-R\>\<rightarrow\>\<bbb-R\>>
    such that::

    <\equation*>
      \<lambda\><rsub|s><around|(|\<eta\>|)>=<choice|<tformat|<table|<row|<cell|\<eta\>,>|<cell|0\<leq\>\<eta\>\<less\>\<infty\>,>>|<row|<cell|\<eta\>+s*<around|(|B-A|)>,>|<cell|-\<infty\>\<leq\>\<eta\>\<leq\>-s*B;>>>>>0\<less\>\<lambda\><rsub|s><rprime|'>\<leq\>1
    </equation*>

    (such functions <math|\<lambda\><rsub|s>> exist as <math|A\<less\>B>).
    Set <math|f<rsub|s>\<assign\>f\<circ\>\<lambda\><rsub|s>>. We claim that
    <math|f<rsub|s>\<in\>\<cal-F\><around|(|a,r|)>> for each
    <math|s\<in\><around|[|0,1|]>>. It is clear that
    <math|f<rsub|s>\<in\>\<cal-F\><around|(|a|)>> for each
    <math|s\<in\><around|[|0,1|]>>. Moreover,

    <\equation*>
      <around|(|A+s*<around|(|B-A|)>|)>*f<rsub|s><rprime|'>(-A-s*<around|(|B-A|)>)=<around|(|A+s*<around|(|B-A|)>|)>*f<rprime|'>(-A)\<geq\>A*f<rprime|'>(-A)\<gtr\>r.
    </equation*>

    Thus <math|f<rsub|s>> satisfies <eqref|eq:the constant A> with respect to
    <math|A+s*<around|(|B-A|)>> for each <math|s\<in\><around|[|0,1|]>>. The
    last statement of the lemma is immediate, and hence this completes the
    proof.
  </proof>

  The next result uses the same idea as <cite-detail|CieliebakFrauenfelderOancea2010|Proposition
  5.5>, and shows that for a suitable choice of <math|f\<in\>\<cal-F\>> one
  can bound the <math|\<eta\>> component of gradient flow lines with action
  in a fixed interval.

  <prop|<label|pro:useful dichotomy>Fix <math|F\<in\>\<cal-D\>> and
  <math|0\<less\>a\<less\>b\<less\>\<infty\>>. Let <math|\<rho\>,T\<gtr\>0>
  be the constants associated to <math|F> from Corollary <reference|cor:the
  linfty cor>. Let <math|f\<in\>\<cal-F\><around*|(|<frac|a|6>,<frac|b-a|min
  <around|{|\<rho\>,a/4*T|}>>|)>> and <math|H\<in\>\<cal-H\>*<around|(|a/2|)>>.
  Choose <math|\<chi\>> such that <math|\<frak-f\>\<assign\><around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0>>
  and choose <math|J\<in\>\<cal-J\>>. There exists a constant
  <math|C<rsub|<with|font-family|rm|<em|m*u*l*t>>>\<gtr\>0> depending only on
  <math|a,b,F> and <math|f>, such that if
  <math|u=<around|(|x,\<eta\>|)>\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>|)>>,
  then <math|<around*|\<\|\|\>|\<eta\>|\<\|\|\>><rsub|L<rsup|\<infty\>>>\<leq\>C<rsub|<with|font-family|rm|<em|m*u*l*t>>>>.>

  <\proof>
    First note that

    <\equation>
      lim<rsub|s\<rightarrow\>\<pm\>\<infty\>>
      \<eta\><around|(|s|)>\<geq\><frac|a|2>.<label|eq:limpos>
    </equation>

    Indeed, this follows from the fact that by <eqref|eq:value of perturbed
    functional at crit>,

    <\equation*>
      A<rsub|\<frak-f\>><around|(|x<rsub|\<pm\>>,\<eta\><rsub|\<pm\>>|)>=f<around|(|\<eta\><rsub|\<pm\>>|)>-<big|int><rsub|0><rsup|1><around|{|\<lambda\><around|(|X<rsub|H><around|(|t,x<rsub|\<pm\>>|)>|)>-H<around|(|t,x<rsub|\<pm\>>|)>|}>*d*t,
    </equation*>

    and hence

    <\equation*>
      f<around|(|\<eta\><rsub|\<pm\>>|)>\<geq\>A<rsub|\<frak-f\>><around|(|x<rsub|\<pm\>>,\<eta\><rsub|\<pm\>>|)>-\<kappa\><around|(|H|)>\<geq\><frac|a|2>.
    </equation*>

    Since <math|f\<in\>\<cal-F\>*<around|(|a/6|)>> one therefore has
    <math|\<eta\><rsub|\<pm\>>\<geq\>a/2>.

    It will be convenient to define

    <\equation*>
      \<rho\><rsub|1>\<assign\>min <around*|{|\<rho\>,<frac|a|4*T>|}>,
    </equation*>

    so that <math|f\<in\>\<cal-F\><around*|(|<frac|a|6>,<frac|b-a|\<rho\><rsub|1>>|)>>.
    By definition of the set <math|\<cal-F\><around*|(|<frac|a|6>,<frac|b-a|\<rho\><rsub|1>>|)>>,
    there exists <with|font-series|bold|mode|math|A\<gtr\>0> such that

    <\equation>
      f<rprime|'>(-A)A\<gtr\><frac|b-a|\<rho\><rsub|1>>.<label|eq:B ass>
    </equation>

    Fix <math|u\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>|)>>.
    Define a function <math|\<sigma\><rsub|u>:\<bbb-R\>\<rightarrow\><around|[|0,\<infty\>|)>>
    by

    <\equation>
      \<sigma\><rsub|u><around|(|s|)>\<assign\>inf
      <around*|{|\<sigma\>\<geq\>0<space|0.17em>:<space|0.17em><around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>*<around|(|u*<around|(|s+\<sigma\>|)>|)>|\<\|\|\>><rsub|J>\<leq\>\<rho\><rsub|1>*f<rprime|'>*<around|(|\<eta\>*<around|(|s+\<sigma\>|)>|)>|}>;<label|eq:sigma
      u of s>
    </equation>

    <math|\<sigma\><rsub|u>> is well defined as
    <math|lim<rsub|s\<rightarrow\>\<infty\>>
    f<rprime|'><around|(|\<eta\><around|(|s|)>|)>=1> (from <eqref|eq:limpos>
    and the fact that <math|f\<in\>\<cal-F\>*<around|(|a/6|)>>), and
    <math|lim<rsub|s\<rightarrow\>\<infty\>><around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|u<around|(|s|)>|)>|\<\|\|\>><rsub|J>=0>.
    Next define

    <\equation*>
      i<rsub|u><around|(|s|)>\<assign\>inf<rsub|s\<leq\>r\<leq\>s+\<sigma\><rsub|u><around|(|s|)>>
      f<rprime|'><around|(|\<eta\><around|(|r|)>|)>.
    </equation*>

    Note that

    <\equation*>
      E<around|(|u|)>=<big|int><rsub|-\<infty\>><rsup|\<infty\>><around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|u<around|(|s|)>|)>|\<\|\|\>><rsub|J><rsup|2>*d*s=lim<rsub|s\<rightarrow\>-\<infty\>>
      A<rsub|\<frak-f\>><around|(|u<around|(|s|)>|)>-lim<rsub|s\<rightarrow\>\<infty\>>
      A<rsub|\<frak-f\>><around|(|u<around|(|s|)>|)>\<leq\>b-a.
    </equation*>

    Next,

    <align*|<tformat|<table|<row|<cell|E<around|(|u|)>>|<cell|\<geq\><big|int><rsub|s><rsup|s+\<sigma\><rsub|u><around|(|s|)>><around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|u<around|(|r|)>|)>|\<\|\|\>><rsub|J><rsup|2>*d*r>>|<row|<cell|>|<cell|\<geq\><big|int><rsub|s><rsup|s+\<sigma\><rsub|u><around|(|s|)>>\<rho\><rsub|1><rsup|2>*f<rprime|'><around|(|\<eta\><around|(|r|)>|)><rsup|2>*d*r>>|<row|<cell|>|<cell|\<geq\>\<rho\><rsub|1><rsup|2>*i<rsub|u><around|(|s|)><rsup|2>*\<sigma\><rsub|u><around|(|s|)>,>>>>>

    and hence

    <\equation>
      \<sigma\><rsub|u><around|(|s|)>\<leq\><frac|b-a|\<rho\><rsub|1><rsup|2>*i<rsub|u><around|(|s|)><rsup|2>>.<label|eq:sigma
      u>
    </equation>

    Now observe that

    <align*|<tformat|<table|<row|<cell|<around*|\||\<eta\><around|(|s|)>-\<eta\>*<around|(|s+\<sigma\><rsub|u><around|(|s|)>|)>|\|>>|<cell|\<leq\><big|int><rsub|s><rsup|s+\<sigma\><rsub|u><around|(|s|)>><around*|\||\<partial\><rsub|r>*\<eta\><around|(|r|)>|\|>*d*r>>|<row|<cell|>|<cell|\<leq\><around*|(|\<sigma\><rsub|u><around|(|s|)>*<big|int><rsub|s><rsup|s+\<sigma\><rsub|u><around|(|s|)>><around*|\||\<partial\><rsub|r>*\<eta\><around|(|r|)>|\|><rsup|2>*d*r|)><rsup|1/2>>>|<row|<cell|>|<cell|\<leq\><around*|(|\<sigma\><rsub|u><around|(|s|)>*<big|int><rsub|s><rsup|s+\<sigma\><rsub|u><around|(|s|)>><around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>><around|(|u<around|(|r|)>|)>|\<\|\|\>><rsub|J><rsup|2>*d*r|)><rsup|1/2>>>|<row|<cell|>|<cell|\<leq\><around|(|\<sigma\><rsub|u><around|(|s|)>*E<around|(|u|)>|)><rsup|1/2>>>|<row|<cell|>|<cell|\<leq\><frac|b-a|\<rho\><rsub|1>*i<rsub|u><around|(|s|)>>,>>>>>

    where the last line used <eqref|eq:sigma u>. Next, Corollary
    <reference|cor:the linfty cor> implies that for any
    <math|s\<in\>\<bbb-R\>>,

    <align*|<tformat|<table|<row|<cell|f(\<eta\>*<around|(|s+\<sigma\><rsub|u><around|(|s|)>|)>>|<cell|\<geq\><frac|2|3>*<around*|(|A<rsub|\<frak-f\>>*<around|(|u*<around|(|s+\<sigma\><rsub|u><around|(|s|)>|)>|)>-T*<around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>*<around|(|u*<around|(|s+\<sigma\><rsub|u><around|(|s|)>|)>|)>|\<\|\|\>><rsub|J>-\<kappa\><around|(|H|)>|)>>>|<row|<cell|>|<cell|\<geq\><frac|2|3>*<around*|(|a-T*\<rho\><rsub|1>*f<rprime|'>*<around|(|\<eta\>*<around|(|s+\<sigma\><rsub|u><around|(|s|)>|)>|)>-<frac|a|2>|)>.>>>>>

    Since <math|\<rho\><rsub|1>\<leq\>a/4*T> and <math|f<rprime|'>\<leq\>1>,
    we deduce that

    <\equation*>
      f(\<eta\>*<around|(|s+\<sigma\><rsub|u><around|(|s|)>|)>\<geq\><frac|a|6>.
    </equation*>

    Since <math|f\<in\>\<cal-F\>*<around|(|a/6|)>> we see that

    <\equation*>
      \<eta\>*<around|(|s+\<sigma\><rsub|u><around|(|s|)>|)>\<geq\><frac|a|6>\<gtr\>0,
    </equation*>

    and thus

    <\equation*>
      \<eta\><around|(|s|)>\<geq\><frac|a|6>-<frac|b-a|\<rho\><rsub|1>*i<rsub|u><around|(|s|)>>\<gtr\>-<frac|b-a|\<rho\><rsub|1>*i<rsub|u><around|(|s|)>>.
    </equation*>

    In particular,

    <\equation*>
      f<rprime|'><around|(|\<eta\><around|(|s|)>|)>*\<eta\><around|(|s|)>\<geq\>i<rsub|u><around|(|s|)>*\<eta\><around|(|s|)>\<gtr\>-<frac|<around|(|b-a|)>|\<rho\><rsub|1>>.
    </equation*>

    Using <eqref|eq:limpos>, if there exists some
    <math|s<rsub|0>\<in\>\<bbb-R\>> such that
    <math|\<eta\><around|(|s<rsub|0>|)>\<less\>-A> then by continuity there
    exists <math|s<rsub|1>\<in\>\<bbb-R\>> such that
    <math|\<eta\><around|(|s<rsub|1>|)>=-A>. But then we obtain a
    contradiction via <eqref|eq:B ass>

    <\equation*>
      -<frac|b-a|\<rho\><rsub|1>>\<gtr\>-f<rprime|'>(-A)A=f<rprime|'><around|(|\<eta\><around|(|s<rsub|1>|)>|)>*\<eta\><around|(|s<rsub|1>|)>\<gtr\>-<frac|b-a|\<rho\><rsub|1>>.
    </equation*>

    It follows that <math|\<eta\><around|(|s|)>\<gtr\>-A> for all
    <math|s\<in\>\<bbb-R\>>.

    Now we address the upper bound. Define a new function
    <math|<wide|\<sigma\>|~><rsub|u>:\<bbb-R\>\<rightarrow\><around|[|0,\<infty\>|)>>
    by

    <\equation>
      <around*|\<nobracket\>|<wide|\<sigma\>|~><rsub|u><around|(|s|)>\<assign\>inf
      <around*|{|\<sigma\>\<geq\>0<space|0.17em>:<space|0.17em><around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>*<around|(|u*<around|(|s+\<sigma\>|)>|)>|\<\|\|\>><rsub|J>\<leq\>\<rho\><rsub|1>*f<rprime|'>|(>-A)|}>.<label|eq:new
      sigma>
    </equation>

    Arguing as above we see that for any <math|s\<in\>\<bbb-R\>>,

    <\equation*>
      <wide|\<sigma\>|~><rsub|u><around|(|s|)>\<leq\><frac|b-a|\<rho\><rsub|1><rsup|2>*f<rprime|'>(-A)<rsup|2>>,
    </equation*>

    and hence

    <\equation>
      <around*|\||\<eta\><around|(|s|)>-\<eta\>*<around|(|s+<wide|\<sigma\>|~><rsub|u><around|(|s|)>|)>|\|>\<leq\><frac|b-a|\<rho\><rsub|1>*f<rprime|'>(-A)>\<less\>A,<label|eq:sigma
      twiddle>
    </equation>

    where the last inequality used <eqref|eq:B ass> again. Then by Corollary
    <reference|cor:the linfty cor> we see that for any
    <math|s\<in\>\<bbb-R\>>,

    <align*|<tformat|<table|<row|<cell|f(\<eta\>*<around|(|s+<wide|\<sigma\>|~><rsub|u><around|(|s|)>|)>>|<cell|\<leq\>2*<around*|(|A<rsub|\<frak-f\>>*<around|(|u*<around|(|s+<wide|\<sigma\>|~><rsub|u><around|(|s|)>|)>|)>+T*<around*|\<\|\|\>|\<nabla\><rsub|J>*A<rsub|\<frak-f\>>*<around|(|u*<around|(|s+<wide|\<sigma\>|~><rsub|u><around|(|s|)>|)>|)>|\<\|\|\>><rsub|J>+\<kappa\><around|(|H|)>|)>>>|<row|<cell|>|<cell|\<leq\>2*<around|(|b+T*\<rho\><rsub|1>*f<rprime|'>|(>-A)+a/2)\<leq\>2*a+2*b,>>>>>

    and hence <math|\<eta\>*<around|(|s+<wide|\<sigma\>|~><rsub|u><around|(|s|)>|)>\<leq\>2*a+2*b>.
    Thus by <eqref|eq:sigma twiddle>,

    <\equation*>
      \<eta\><around|(|s|)>\<less\>2*a+2*b+A.
    </equation*>

    We conclude that

    <\equation*>
      sup<rsub|s\<in\>\<bbb-R\>><around*|\||\<eta\><around|(|s|)>|\|>\<less\>C<rsub|<with|font-family|rm|m*u*l*t>>=C<rsub|<with|font-family|rm|m*u*l*t>><around|(|a,b,f|)>\<assign\>2*a+2*b+A.
    </equation*>
  </proof>

  Proposition <reference|pro:useful dichotomy> prompts the following
  definition.

  <\defn>
    <label|def:strange def 2>Given <math|F\<in\>\<cal-D\>> and
    <math|0\<less\>a\<less\>b\<less\>\<infty\>>, let

    <\equation*>
      \<cal-F\><around|(|F,a,b|)>\<assign\>\<cal-F\><around*|(|<frac|a|6>,<frac|b-a|\<rho\><rsub|1>>|)>,
    </equation*>

    where <math|\<rho\><rsub|1>=min <around|{|\<rho\>,a/4*T|}>> and
    <math|\<rho\>=\<rho\><around|(|F|)>> and <math|T=T<around|(|F|)>> are the
    constants from Corollary <reference|cor:the linfty cor>.
  </defn>

  The following result is the main one of this section.

  <thm|<label|thm:admissable yes>Fix <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>.
  Suppose <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|<em|r*e*g>>>>
  and <math|0\<less\>a\<less\>b\<less\>\<infty\>> are such that
  <math|a,b\<nin\>\<cal-A\><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>.
  Suppose also that <math|f\<in\>\<cal-F\><around|(|F,a,b|)>> where
  <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>>, and
  <math|H\<in\>\<cal-H\>*<around|(|a/2|)>>. Let <math|S> denote a fibrewise
  starshaped hypersurface such that <math|D<around|(|\<Sigma\>|)>\<subseteq\>D<rsup|\<circ\>><around|(|S|)>>
  and such that <text|<em|supp>><math|<around|(|X<rsub|F>|)>\<subseteq\>D<rsup|\<circ\>><around|(|S|)>>.
  Choose <math|J\<in\>\<cal-J\><rsub|<with|font-family|rm|<em|r*e*g>>><around|(|\<frak-f\>|)>\<cap\>\<cal-J\><around|(|S|)>>.
  Then the quadruple <math|\<frak-q\>\<assign\><around|(|\<frak-f\>,a,b,J|)>>
  is <math|\<alpha\>>-admissible.>

  <\proof>
    Immediate from Corollary <reference|cor:cptness of critical set>, Lemma
    <reference|lem:why convex good> and Proposition <reference|pro:useful
    dichotomy>.
  </proof>

  <rem|<label|independent of f>In fact, one can show using an argument based
  on Floer's <with|font-series|bold|bifurcation method >(see
  <cite-detail|CieliebakFrauenfelderOancea2010|Proposition 4.11>) that in the
  situation above, <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F<rsup|\<chi\>>,f><rsup|H>,\<alpha\>|)>>
  is actually <with|font-series|bold|independent >of the choice of
  <math|f\<in\>\<cal-F\><around|(|F,a,b|)>>. Nevertheless, for the purposes
  of the present paper we do not need this observation, and we will make no
  use of it.>

  <subsection|Truncating the function <math|f>><label|sub:Truncating-the-function>

  <vspace|6 pt>

  <with|font-series|bold|A posteriori>, we discover that one can truncate the
  function <math|f> at infinity without affecting the Floer homology. Indeed,
  fix <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>> and a non-degenerate
  fibrewise starshaped hypersurface <math|\<Sigma\>> and
  <math|0\<less\>a\<less\>b\<less\>\<infty\>> such that
  <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>>. Choose
  <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>>,
  <math|f\<in\>\<cal-F\><around|(|F,a,b|)>> and
  <math|\<chi\>\<in\>\<cal-X\>>. Set <math|\<frak-f\>\<assign\><around|(|F,f,\<chi\>,0|)>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>><rprime|'>>.
  Suppose <math|R\<gtr\>2*a+2*b+A+1>, where <math|A\<gtr\>0> is the constant
  associated to <math|f> from <eqref|eq:the constant A>. Let
  <math|<wide|f|\<bar\>>:\<bbb-R\>\<rightarrow\>\<bbb-R\><rsup|+>> denote a
  smooth function such that <math|<wide|f|\<bar\>>\<equiv\>f> on
  (<math|-\<infty\>,R-1]> and such that <math|<wide|f|\<bar\>><around|(|\<eta\>|)>=R>
  for <math|\<eta\>\<in\><around|[|R+1,\<infty\>|)>>, with
  <math|0\<leq\><wide|f|\<bar\>><rprime|'><around|(|\<eta\>|)>\<leq\>1> on
  all of <math|\<bbb-R\>>. We will call such a function
  <math|<wide|f|\<bar\>>> an <with|font-series|bold|<math|R>-truncation>of
  <math|f>. Let <math|<wide|\<frak-f\>|\<bar\>>\<assign\><around|(|F,<wide|f|\<bar\>>,\<chi\>,0|)>>.

  Consider the Rabinowitz action functional
  <math|A<rsub|<wide|\<frak-f\>|\<bar\>>>>. This functional will have many
  more critical points than <math|A<rsub|\<frak-f\>>>, as
  <math|<wide|f|\<bar\>><rprime|'>> is no longer strictly positive everywhere
  (i.e. one can no longer deduce <eqref|eq:sec eq> from <eqref|eq:first eq>).
  However if <math|<around|(|x,\<eta\>|)>> is a critical point of
  <math|A<rsub|<wide|\<frak-f\>|\<bar\>>>> with
  <math|<wide|f|\<bar\>><rprime|'><around|(|\<eta\>|)>=0> then we necessarily
  have <math|\<eta\>\<geq\>R-1>, and hence
  <math|A<rsub|<wide|\<frak-f\>|\<bar\>>><around|(|x,\<eta\>|)>=<wide|f|\<bar\>><around|(|\<eta\>|)>\<geq\>R-1>
  by Lemma <reference|lem:key lemma>.1. In particular,
  <math|<around|(|x,\<eta\>|)>\<nin\><text|Crit><rsup|<around|(|a,b|)>><around|(|A<rsub|<wide|\<frak-f\>|\<bar\>>>|)>>.
  We conclude that

  <\equation*>
    <text|Crit><rsup|<around|(|a,b|)>><around|(|A<rsub|<wide|\<frak-f\>|\<bar\>>>,\<alpha\>|)>=<text|Crit><rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>.
  </equation*>

  In particular, this implies the Rabinowitz Floer complexes
  <math|C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|<wide|\<frak-f\>|\<bar\>>>,\<alpha\>|)>>
  and <math|C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>
  coincide as <with|font-series|bold|groups>.Moreover the proof of
  Proposition <reference|pro:useful dichotomy> shows that the
  <math|\<eta\>>-component of a gradient flow line
  <math|u=<around|(|x,\<eta\>|)>\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|<wide|\<frak-f\>|\<bar\>>>|)>>
  never escapes the interval (<math|-A,2*a+2*b+A]> (for any
  <math|J\<in\>\<cal-J\>>). In particular, <math|\<eta\>> never escapes
  (<math|-\<infty\>,R-1>). Since <math|f\<equiv\><wide|f|\<bar\>>> on
  (<math|-\<infty\>,R-1]>, it follows that the differential of the two Floer
  complexes (with respect to a suitably chosen almost complex structure) is
  also the same, whence it follows that

  <\equation*>
    H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|<wide|\<frak-f\>|\<bar\>>>,\<alpha\>|)>\<cong\>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>.
  </equation*>

  We will use this observation in the proof of Lemma <reference|lem:its an
  iso> below.

  <subsection|Inclusion/Quotient maps><label|sub:Inclusion/Quotient-maps>

  <vspace|6 pt>

  Let us make the following observation. Suppose we are given
  <math|a,b,c,d\<gtr\>0> such that <math|a\<less\>min <around|{|b,c|}>> and
  <math|d\<gtr\>max <around|{|b,c|}>>. Fix
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. Suppose <math|\<Sigma\>> is
  a non-degenerate fibrewise starshaped hypersurface and
  <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>>, and suppose that
  <math|a,b,c,d\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>> and
  <math|f\<in\>\<cal-F\><around|(|F,a,d|)>>. Choose
  <math|\<chi\>\<in\>\<cal-X\>> and <math|H\<in\>\<cal-H\>*<around|(|a/2|)>>
  such that <math|\<frak-f\>=<around|(|F,f,\<chi\>,H|)>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>>>.
  Fix an almost complex structure <math|J\<in\>\<cal-J\><rsub|<with|font-family|rm|r*e*f>><around|(|\<frak-f\>|)>\<cap\>\<cal-J\><around|(|S|)>>,
  where <math|S> is a fibrewise starshaped hypersurface such that
  <math|D<around|(|\<Sigma\>|)>\<subseteq\>D<rsup|\<circ\>><around|(|S|)>>.
  Our hypotheses imply that the three Floer homology groups

  <\equation*>
    H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>,H*F<rsup|<around|(|a,d|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>*<text|and
    >H*F<rsup|<around|(|c,d|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>
  </equation*>

  are all well defined. There are natural chain maps between the three groups
  given by

  <\equation*>
    C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|i>>,\<alpha\>|)><above|\<rightarrow\>|<with|font-family|rm|i*n*c*l*u*s*i*o*n>>C*F<rsup|<around|(|a,d|)>><around|(|A<rsub|\<frak-f\><rsub|i>>,\<alpha\>|)>
  </equation*>

  and

  <\equation*>
    C*F<rsup|<around|(|a,d|)>><around|(|A<rsub|\<frak-f\><rsub|i>>,\<alpha\>|)><above|\<rightarrow\>|<with|font-family|rm|q*u*o*t*i*e*n*t>>C*F<rsup|<around|(|a,d|)>><around|(|A<rsub|\<frak-f\><rsub|i>>,\<alpha\>|)>/C*F<rsup|<around|(|a,c|)>><around|(|A<rsub|\<frak-f\><rsub|i>>,\<alpha\>|)>=C*F<rsup|<around|(|c,d|)>><around|(|A<rsub|\<frak-f\><rsub|i>>,\<alpha\>|)>.
  </equation*>

  We denote by

  <\equation>
    i:H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|c,d|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)><label|eq:inclusionquotientmap>
  </equation>

  the induced map on homology given by the composition of these two maps. It
  is clear that if

  <\equation*>
    \<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>\<cap\><around|[|a,c|]>=\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>\<cap\><around|[|b,d|]>=\<emptyset\>
  </equation*>

  then <math|i> is an isomorphism.

  <subsection|The Floer homology groups <math|H*F<rsup|<around|(|a,\<infty\>|)>><around|(|A<rsub|F,f>,\<alpha\>|)>>><label|sub:The-Floer-homology>

  <vspace|6 pt>

  In this section we extend the definition of
  <math|H*F<rsup|<around|(|a,b|)>>> to cover the case <math|b=\<infty\>>.
  Suppose <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M> is a non-degenerate
  fibrewise starshaped hypersurface. From this moment on it will be
  convenient to work with just <with|font-series|bold|one> function <math|f>,
  instead of picking a function <math|f> for each action interval
  <math|<around|(|a,b|)>>. For this purpose, set
  <math|\<ell\>\<assign\>\<ell\><around|(|\<Sigma\>|)>> and choose

  <\equation>
    f\<in\><big|cap><rsub|r\<gtr\>0>\<cal-F\>*<around|(|\<ell\>/12,r|)><label|eq:one
    f choice>
  </equation>

  (such functions exist by Remark <reference|messy f>). This function
  <math|f> has the desirable property<footnote|As a result, from now on we
  will abandon the notation <math|\<cal-F\><around|(|F,a,b|)>> and solely
  work with functions <math|f> satisfying <eqref|eq:one f choice> instead.>
  that given any <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>> and any
  <math|\<ell\>/2\<less\>a\<less\>b\<less\>\<infty\>> we have
  <math|f\<in\>\<cal-F\><around|(|F,a,b|)>>.

  Fix <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>> and
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. Then for any
  <math|\<ell\>/2\<less\>a\<less\>b\<less\>\<infty\>> such that
  <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>>, the Floer
  homology <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>>
  is defined. Moreover if <math|c\<gtr\>b> also satisfies
  <math|c\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>>, then from Section
  <reference|sub:Inclusion/Quotient-maps> there is a natural map
  <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a,c|)>><around|(|A<rsub|F,f>,\<alpha\>|)>>.
  These maps form a directed system, and hence we can define

  <\equation*>
    H*F<rsup|<around|(|a,\<infty\>|)>><around|(|A<rsub|F,f>,\<alpha\>|)>\<assign\><below|<wide*|lim|\<wide-varrightarrow\>>|b\<rightarrow\>\<infty\>>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>.
  </equation*>

  We denote by

  <\equation>
    \<iota\><rsub|a><rsup|b>:H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a,\<infty\>|)>><around|(|A<rsub|F,f>,\<alpha\>|)><label|eq:iota>
  </equation>

  the induced map. Since we also have natural maps
  <math|H*F<rsup|<around|(|a,c|)>><around|(|A<rsub|F,f>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|b,c|)>><around|(|A<rsub|F,f>,\<alpha\>|)>>,
  there is an induced map

  <\equation*>
    \<pi\><rsub|a><rsup|b>:H*F<rsup|<around|(|a,\<infty\>|)>><around|(|A<rsub|F,f>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>.
  </equation*>

  For future use, given <math|3*\<ell\>/4\<less\>a\<less\>b\<less\>\<infty\>>
  with <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>> let us
  denote by

  <\equation*>
    Z<around|(|a,b|)>\<assign\>\<pi\><rsub|3*\<ell\>/4><rsup|b>\<circ\>\<iota\><rsub|3*\<ell\>/4><rsup|a>,
  </equation*>

  so that <math|Z<around|(|a,b|)>> is a map

  <\equation>
    Z<around|(|a,b|)>:H*F<rsup|<around|(|3*\<ell\>/4,a|)>><around|(|A<rsub|F,f>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|b,\<infty\>|)>><around|(|A<rsub|F,f>,\<alpha\>|)>.<label|eq:the
    map Z-1>
  </equation>

  Note that <math|Z<around|(|a,b|)>=0> if <math|a\<less\>b>.

  <section|Continuation homomorphisms><label|sec:Continuation-homomorphisms>

  In this section we develop the theory of
  <with|font-series|bold|continuation homomorphisms >for the Rabinowitz
  action functional <math|A<rsub|\<frak-f\>>>. Continuation homomorphisms in
  Floer theory were introduced originally by Floer in <cite|Floer1989>, and
  are a powerful tool for proving invariance results for Floer homology. The
  main reason for introducing the function <math|f> is that, as we will see
  below, these Floer homology groups behave well with respect to monotone
  homotopies. This is in contrast to the usual Rabinowitz Floer homology
  groups (see for instance <cite|CieliebakFrauenfelder2009>), for which it is
  not known whether they behave well with respect to monotone homotopies, see
  Remark <reference|The-innocent-looking> below.

  <subsection|Continuation maps>

  <vspace|6 pt>

  We begin with a discussion of continuation maps in the most general form
  that we will need. From now on we will be somewhat sloppy in our treatment
  of almost complex structures; wherever possible we will suppress them from
  the notation and from our discussion. Sometimes however we will be forced
  to include them in our notation (see for instance <eqref|continuation eq-1>
  below). In general the reader should think of
  <math|<around|(|J<rsub|s>|)><rsub|s\<in\><around|[|0,1|]>>> as a
  generically chosen family of almost complex structures that all lie in
  <math|\<cal-J\><around|(|S|)>> for some fixed large fibrewise starshaped
  hypersurface <math|S>. We will not specify precisely what conditions
  <math|<around|(|J<rsub|s>|)>> must satisfy, and will content ourselves with
  merely stating that these conditions are generically satisfied. In keeping
  with our new policy of supressing the mention of <math|J>, from now on we
  will refer to a triple <math|<around|(|\<frak-f\>,a,b|)>> as being
  <with|font-series|bold|admissible> if <math|<around|(|\<frak-f\>,a,b,J|)>>
  is admissible (in the sense of Definition <reference|Fix-.-Ad>).

  Suppose we are given a smooth family <math|\<frak-f\><rsub|s>=<around|(|F<rsub|s>,f<rsub|s>,\<chi\><rsub|s>,H<rsub|s>|)>\<subseteq\>\<frak-F\><rsub|0>>
  for <math|s\<in\><around|[|0,1|]>>. Assume that <math|\<frak-f\><rsub|0>>
  and <math|\<frak-f\><rsub|1>> lie in <math|\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>>>.
  Let us fix once and for all a smooth cut-off function
  <math|\<beta\>:\<bbb-R\>\<rightarrow\><around|[|0,1|]>> such that
  <math|\<beta\><around|(|s|)>=0> for <math|s\<leq\>0> and
  <math|\<beta\><around|(|s|)>=1> for <math|s\<geq\>1>, and
  <math|0\<leq\>\<beta\><rprime|'><around|(|s|)>\<leq\>2> for all
  <math|s\<in\>\<bbb-R\>>. Let <math|\<cal-N\>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
  denote the set of maps <math|u=<around|(|x,\<eta\>|)>:\<bbb-R\>\<rightarrow\>\<Lambda\><rsub|\<alpha\>>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
  that satisfy

  <\equation*>
    \<partial\><rsub|s>*u+\<nabla\><rsub|J<rsub|\<beta\><around|(|s|)>>>*A<rsub|\<frak-f\><rsub|\<beta\><around|(|s|)>>><around|(|u|)>=0.
  </equation*>

  It would be more accurate to write <math|\<cal-N\>*<around|(|\<nabla\><rsub|J<rsub|\<beta\><around|(|s|)>>>*A<rsub|\<frak-f\><rsub|\<beta\><around|(|s|)>>>,\<alpha\>|)>>,
  but we omit the \P<math|J<rsub|s>>\Q and the \P<math|\<beta\>>\Q in order
  to make the notation slightly less cumbersome. Thus
  <math|\<cal-N\>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
  is the set of maps <math|u=<around|(|x,\<eta\>|)>:\<bbb-R\>\<rightarrow\>\<Lambda\><rsub|\<alpha\>>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
  that satisfy:

  <\equation>
    <choice|<tformat|<table|<row|<cell|\<partial\><rsub|s>*x+J<rsub|\<beta\><around|(|s|)>,t><around|(|x|)>*<around|(|\<partial\><rsub|t>*x-f<rsub|\<beta\><around|(|s|)>><around|(|\<eta\>|)>*\<chi\><rsub|\<beta\><around|(|s|)>><around|(|t|)>*X<rsub|F<rsub|\<beta\><around|(|s|)>>><around|(|x|)>+X<rsub|H<rsub|\<beta\><around|(|s|)>>><around|(|t,x|)>|)>=0>>|<row|<cell|\<partial\><rsub|s>*\<eta\>-f<rsub|\<beta\><around|(|s|)>><rprime|'><around|(|\<eta\><around|(|s|)>|)>*<big|int><rsub|0><rsup|1>F<rsub|\<beta\><around|(|s|)>><around|(|x|)>*d*t=0.>>>>><label|continuation
    eq-1>
  </equation>

  If <math|u=<around|(|x,\<eta\>|)>> satisfies <eqref|continuation eq-1> and
  has finite energy <math|E<around|(|u|)>\<less\>\<infty\>> then as before
  the limits

  <\equation>
    lim<rsub|s\<rightarrow\>\<pm\>\<infty\>>
    u<around|(|s,t|)>=:v<rsub|\<pm\>><around|(|t|)>=<around|(|x<rsub|\<pm\>><around|(|t|)>,\<eta\><rsub|\<pm\>>|)>,lim<rsub|s\<rightarrow\>\<pm\>\<infty\>>
    \<partial\><rsub|s>*u<around|(|s,t|)>=0<label|cont 2 eq-1>
  </equation>

  exist and are uniform in the <math|t>-variable. Moreover
  <math|v<rsub|->\<in\><text|Crit><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>>
  and <math|v<rsub|+>\<in\><text|Crit><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>>.

  Given <math|u\<in\>\<cal-N\>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
  and <math|-\<infty\>\<leq\>s<rsub|0>\<leq\>s<rsub|1>\<leq\>\<infty\>>, set

  <\equation*>
    \<Delta\><rsub|s<rsub|0>><rsup|s<rsub|1>><around|(|u|)>\<assign\><big|int><rsub|s<rsub|0>><rsup|s<rsub|1>><around*|(|<frac|\<partial\>|\<partial\>*s>*A<rsub|\<frak-f\><rsub|\<beta\><around|(|s|)>>>|)><around|(|u<around|(|s|)>|)>*d*s.
  </equation*>

  Write <math|\<Delta\><around|(|u|)>\<assign\>\<Delta\><rsub|-\<infty\>><rsup|\<infty\>><around|(|u|)>>.
  Following Ginzburg <cite|Ginzburg2007>, given <math|C\<geq\>0> let us say
  the family <math|<around|(|\<frak-f\><rsub|s>|)>>
  is<with|font-series|bold|<math|C>-bounded >if for every
  <math|u\<in\>\<cal-N\>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
  and every <math|-\<infty\>\<leq\>s<rsub|0>\<leq\>s<rsub|1>\<leq\>\<infty\>>
  it holds that

  <\equation*>
    \<Delta\><rsub|s<rsub|0>><rsup|s<rsub|1>><around|(|u|)>\<leq\>C.
  </equation*>

  In order to explain the relevance of the term
  <math|\<Delta\><rsub|s<rsub|0>><rsup|s<rsub|1>><around|(|u|)>>, given
  <math|a,b\<gtr\>0> denote by <math|\<cal-N\><rsub|a><rsup|b>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
  the subset of <math|\<cal-N\>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
  consisting of those maps <math|u> that satisfy

  <\equation*>
    lim<rsub|s\<rightarrow\>-\<infty\>> A<rsub|\<frak-f\><rsub|\<beta\><around|(|s|)>>><around|(|u<around|(|s|)>|)>\<leq\>b,lim<rsub|s\<rightarrow\>\<infty\>>
    A<rsub|\<frak-f\><rsub|\<beta\><around|(|s|)>>><around|(|u<around|(|s|)>|)>\<geq\>a.
  </equation*>

  Then if <math|u\<in\>\<cal-N\><rsub|a><rsup|b>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
  one readily checks that

  <\equation>
    E<around|(|u|)>\<leq\>b-a+\<Delta\><around|(|u|)>;<label|eq:en eq>
  </equation>

  <\equation>
    sup<rsub|s\<in\>\<bbb-R\>> A<rsub|\<frak-f\><rsub|\<beta\><around|(|s|)>>><around|(|u<around|(|s|)>|)>\<leq\>b+sup<rsub|s\<in\>\<bbb-R\>>
    \<Delta\><rsub|-\<infty\>><rsup|s><around|(|u|)>;<label|eq:sup eq>
  </equation>

  <\equation>
    inf<rsub|s\<in\>\<bbb-R\>> A<rsub|\<frak-f\><rsub|\<beta\><around|(|s|)>>><around|(|u<around|(|s|)>|)>\<geq\>a-sup<rsub|s\<in\>\<bbb-R\>>
    \<Delta\><rsub|s><rsup|\<infty\>><around|(|u|)>.<label|eq:inf eq>
  </equation>

  In particular,

  <\equation*>
    lim<rsub|s\<rightarrow\>\<infty\>> A<rsub|\<frak-f\><rsub|\<beta\><around|(|s|)>>><around|(|u<around|(|s|)>|)>\<leq\>b+\<Delta\><around|(|u|)>;
  </equation*>

  <\equation*>
    lim<rsub|s\<rightarrow\>\<infty\>> A<rsub|\<frak-f\><rsub|\<beta\><around|(|s|)>)>><around|(|u<around|(|s|)>|)>\<geq\>a-\<Delta\><around|(|u|)>.
  </equation*>

  <\defn>
    <label|def:admissible families>Fix a family
    <math|<around|(|\<frak-f\><rsub|s>|)><rsub|s\<in\><around|[|0,1|]>>> as
    above, and fix <math|a,b\<gtr\>0> and <math|C\<geq\>0>. We say that
    <math|<around|{|<around|(|\<frak-f\><rsub|s>|)>,a,b,C|}>> is an
    <with|font-series|bold|<math|\<alpha\>>-admissible family >if

    <\enumerate>
      <item>The triples <math|<around|(|\<frak-f\><rsub|0>,a,b|)>> and
      <math|<around|(|\<frak-f\><rsub|1>,a+C,b+C|)>> are
      <math|\<alpha\>>-admissible. Thus <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>>
      and <math|H*F<rsup|<around|(|a+C,b+C|)>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>>
      are well defined.

      <item>The family <math|<around|(|\<frak-f\><rsub|s>|)>> is
      <math|C>-bounded.

      <item>There exist constants <math|C<rsub|<with|font-family|rm|l*o*o*p>>,C<rsub|<with|font-family|rm|m*u*l*t>>\<gtr\>0>
      such that if <math|u=<around|(|x,\<eta\>|)>\<in\>\<cal-N\><rsub|a><rsup|b>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
      then it holds that <math|<around*|\<\|\|\>|x|\<\|\|\>><rsub|L<rsup|\<infty\>>>\<less\>C<rsub|<with|font-family|rm|l*o*o*p>>>
      and <math|<around*|\<\|\|\>|\<eta\>|\<\|\|\>><rsub|L<rsup|\<infty\>>>\<less\>C<rsub|<with|font-family|rm|m*u*l*t>>>.
    </enumerate>
  </defn>

  The following basic theorem follows from standard Floer homological
  methods; see for instance <cite-detail|BiranPolterovichSalamon2003|Section
  4.4> or <cite-detail|Ginzburg2007|Section 3.2.3>.

  <\thm>
    <with|font-series|bold|<em|<label|thm:(Continuity-property-of>(Continuity
    properties of filtered Floer homology)>>

    <\enumerate>
      <item>Suppose <math|<around|{|<around|(|\<frak-f\><rsub|s>|)>,a,b,C|}>>
      is an <math|\<alpha\>>-admissible family. Then there exists a chain map

      <\equation*>
        \<Psi\>:C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>\<rightarrow\>C*F<rsup|<around|(|a+C,b+C|)>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>
      </equation*>

      which induces a homomorphism

      <\equation*>
        \<psi\>:H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a+C,b+C|)>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>.
      </equation*>

      <item>Suppose <math|c,d\<gtr\>0> are such that <math|a\<leq\>c> and
      <math|b\<leq\>d>. Suppose in addition that
      <math|<around|{|<around|(|\<frak-f\><rsub|s>|)>,c,d,C|}>> is
      <math|\<alpha\>>-admissible. Then the following diagram commutes:

      <\equation*>
        <\latex_preview|xymatrix>
          <\text>
            \\xymatrix{HF^{(a,b)}(A_{\\mathfrak{f}_{0}},\\alpha)\\ar[r]^{\\psi}\\ar[d]_{i}
            & HF^{(a+C,b+C)}(A_{\\mathfrak{f}_{1}},\\alpha)\\ar[d]^{i}\\\\

            HF^{(c,d)}(A_{\\mathfrak{f}_{0}},\\alpha)\\ar[r]_{\\psi} &
            HF^{(c+C,d+C)}(A_{\\mathfrak{f}_{1}},\\alpha)

            }
          </text>
        </latex_preview>
      </equation*>

      Here the vertical maps are the maps from
      <eqref|eq:inclusionquotientmap>.
    </enumerate>
  </thm>

  <subsection|Monotone homotopies><label|sub:Monotone-homotopies-and>

  <vspace|6 pt>

  In this section we suppose we are given two non-degenerate fibrewise
  starshaped hypersurfaces <math|\<Sigma\>> and <math|\<Sigma\><rprime|'>>
  with the property that

  <\equation*>
    D<around|(|\<Sigma\><rprime|'>|)>\<subseteq\>D<around|(|\<Sigma\>|)>.
  </equation*>

  Let us first fix a smooth family <math|<around|(|\<Sigma\><rsub|s>|)><rsub|s\<in\><around|[|0,1|]>>>
  of fibrewise starshaped hypersurfaces such that:

  <\enumerate>
    <item><math|\<Sigma\><rsub|0>=\<Sigma\>> and
    <math|\<Sigma\><rsub|1>=\<Sigma\><rprime|'>>;

    <item>For generic <math|s\<in\><around|[|0,1|]>>,
    <math|\<Sigma\><rsub|s>> is non-degenerate;

    <item>for any <math|0\<leq\>s<rsub|0>\<leq\>s<rsub|1>\<leq\>1> one has
    <math|D<around|(|\<Sigma\><rsub|s<rsub|1>>|)>\<subseteq\>D<around|(|\<Sigma\><rsub|s<rsub|0>>|)>>.
  </enumerate>

  We will call such a family a <with|font-series|bold|concentric >family of
  fibrewise starshaped hypersurfaces. Given such a family
  <math|<around|(|\<Sigma\><rsub|s>|)>> it is possible<footnote|For example,
  one could first let <math|<wide|F|~><rsub|s>> denote the Hamiltonian
  constructed at the start of Section <reference|sub:-estimates-for> (see
  <eqref|eq:nice H>) below for <math|\<Sigma\>=\<Sigma\><rsub|s>>, and then
  set <math|F<rsub|s>\<assign\><around|(|<wide|F|~><rsub|s>|)><rsub|R>> as in
  Section <reference|sub:-estimates-for> for some <math|R\<gtr\>1>.> to
  choose a smooth family <math|<around|(|F<rsub|s>|)><rsub|s\<in\><around|[|0,1|]>>\<subseteq\>\<cal-D\>>
  of Hamiltonians such that <math|F<rsub|s>\<in\>\<cal-D\><around|(|\<Sigma\><rsub|s>|)>>
  and such that <math|\<partial\><rsub|s>*F<rsub|s><around|(|q,p|)>\<geq\>0>
  for all <math|<around|(|q,p|)>\<in\>T<rsup|\<ast\>>*M>. For the remainder
  of this section we fix such a family <math|<around|(|F<rsub|s>|)>>.

  Set

  <\equation*>
    \<ell\>\<assign\>min<rsub|s\<in\><around|[|0,1|]>>
    \<ell\><around|(|\<Sigma\><rsub|s>|)>\<gtr\>0,
  </equation*>

  and fix once and for all a function <math|f\<in\><big|cap><rsub|r\<gtr\>0>\<cal-F\>*<around*|(|\<ell\>/12,r|)>>.
  By construction, given any <math|s\<in\><around|[|0,1|]>> such that
  <math|\<Sigma\><rsub|s>> is non-degenerate, and any
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>,
  <math|\<chi\>\<in\>\<cal-X\>>, and <math|\<ell\>/2\<less\>a\<less\>b\<less\>\<infty\>>
  such that <math|\<cal-A\><around|(|\<Sigma\><rsub|s>,\<alpha\>|)>\<cap\><around|{|a,b|}>=\<emptyset\>>,
  the Floer homology <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F<rsub|s><rsup|\<chi\>>,f>,\<alpha\>|)>>
  is well defined. In this section we will only ever use
  <math|\<chi\>\<equiv\>1>, so let us set

  <\equation*>
    \<frak-f\><rsub|s>\<assign\><around|(|F<rsub|s>,f,1,0|)>.
  </equation*>

  Now let us fix <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. Suppose we
  are given <math|\<ell\>/2\<less\>a\<less\>b\<less\>\<infty\>> such that
  <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>\<cup\>\<cal-A\><around|(|\<Sigma\><rprime|'>,\<alpha\>|)>>.
  Then we claim there exists a chain map

  <\equation*>
    \<Psi\><rsub|0><rsup|1>:C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>\<rightarrow\>C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>
  </equation*>

  inducing a homomorphism

  <\equation*>
    \<psi\><rsub|0><rsup|1>:H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>.
  </equation*>

  This follows readily from our discussion above. Indeed, we claim that
  <math|<around|{|<around|(|\<frak-f\><rsub|s>|)>,a,b,0|}>> is an
  <math|\<alpha\>>-admissible family. Condition (1) of Definition
  <reference|def:admissible families> is satisfied by assumption, and since
  <math|\<partial\><rsub|s>*F<rsub|s>\<geq\>0> we have
  <math|\<Delta\><rsub|s<rsub|0>><rsup|s<rsub|1>><around|(|u|)>\<leq\>0> for
  all <math|u\<in\>\<cal-N\>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
  and <math|-\<infty\>\<leq\>s<rsub|0>\<leq\>s<rsub|1>\<leq\>\<infty\>>,
  which shows Condition (2) is satisfied.

  <rem|<label|The-innocent-looking>The innocent looking fact that
  <math|\<partial\><rsub|s>*F<rsub|s>\<geq\>0> implies
  <math|\<Delta\><rsub|s<rsub|0>><rsup|s<rsub|1>><around|(|u|)>\<leq\>0> is
  in fact the key point of the present paper, and the whole point of
  perturbing the Rabinowitz action functional with a
  <with|font-series|bold|positive >function <math|f>. In the setting of
  'standard' Rabinowitz Floer homology, the corresponding expression for
  <math|\<Delta\><rsub|s<rsub|0>><rsup|s<rsub|1>><around|(|u|)>> is given by
  <math|-<big|int><rsub|s<rsub|0>><rsup|s<rsub|1>>\<eta\><around|(|s|)>*<big|int><rsub|0><rsup|1>\<partial\><rsub|s>*F<rsub|\<beta\><around|(|s|)>><around|(|x<around|(|s|)>|)>*d*s>
  instead of <math|-<big|int><rsub|s<rsub|0>><rsup|s<rsub|1>>f<around|(|\<eta\><around|(|s|)>|)>*<big|int><rsub|0><rsup|1>\<partial\><rsub|s>*F<rsub|\<beta\><around|(|s|)>><around|(|x<around|(|s|)>|)>*d*s>.
  Since the Lagrange multiplier <math|\<eta\><around|(|s|)>> could very well
  become negative, one cannot conclude from
  <math|\<partial\><rsub|s>*F<rsub|s>\<geq\>0> that
  <math|\<Delta\><rsub|s<rsub|0>><rsup|s<rsub|1>><around|(|u|)>\<leq\>0> in
  the standard case.>

  The existence of a constant <math|C<rsub|<with|font-family|rm|l*o*o*p>>\<gtr\>0>
  satisfying the requirements of Condition (3) follows from the choice of a
  correct almost complex structure, and we will say nothing about this (see
  the opening paragraph of Section <reference|sec:Continuation-homomorphisms>).
  Equations <eqref|eq:en eq>, <eqref|eq:sup eq> and <eqref|eq:inf eq> show
  that the proof of Proposition <reference|pro:useful dichotomy> goes through
  without change to establish the existence of a constant
  <math|C<rsub|<with|font-family|rm|m*u*l*t>>\<gtr\>0> such that Condition
  (3) of Definition <reference|def:admissible families> is satisfied. Thus
  theorem <reference|thm:(Continuity-property-of> proves the claim.

  Note that there is nothing special about <math|s=0> and <math|s=1>; in
  general given any <math|0\<leq\>s<rsub|0>\<leq\>s<rsub|1>\<leq\>1> such
  that <math|\<Sigma\><rsub|s<rsub|0>>> and <math|\<Sigma\><rsub|s<rsub|1>>>
  are non-degenerate and <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\><rsub|s<rsub|0>>,\<alpha\>|)>\<cup\>\<cal-A\><around|(|\<Sigma\><rsub|s<rsub|1>>,\<alpha\>|)>>,
  this construction gives a map

  <\equation*>
    \<Psi\><rsub|s<rsub|0>><rsup|s<rsub|1>>:C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|s<rsub|0>>>,\<alpha\>|)>\<rightarrow\>C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|s<rsub|1>>>,\<alpha\>|)>
  </equation*>

  inducing a map

  <\equation*>
    \<psi\><rsub|s<rsub|0>><rsup|s<rsub|1>>:H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|s<rsub|0>>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|s<rsub|1>>>,\<alpha\>|)>
  </equation*>

  In fact, we can say rather more about the homomorphisms
  <math|<around|(|\<psi\><rsub|s<rsub|0>><rsup|s<rsub|1>>|)>>. As with
  Theorem <reference|thm:(Continuity-property-of> itself, these two
  properties follow from standard Floer homological methods. See for instance
  <cite-detail|BiranPolterovichSalamon2003|Section 4.4> or
  <cite-detail|Ginzburg2007|Section 3.2.3>.

  <\enumerate>
    <item>Firstly, the maps <math|<around|(|\<psi\><rsub|s<rsub|0>><rsup|s<rsub|1>>|)>>
    are actually <with|font-series|bold|independent> of choice of
    <math|<around|(|\<Sigma\><rsub|s>|)>> in the following sense. Suppose
    <math|<around|(|<wide|\<Sigma\>|~><rsub|s>|)><rsub|s\<in\><around|[|0,1|]>>>
    is another family of fibrewise starshaped hypersurfaces satisfying the
    three conditions above, with corresponding definining Hamiltonians
    <math|<around|(|<wide|F|~><rsub|s>|)>>. Let

    <\equation*>
      <wide|\<ell\>|~>\<assign\>min<rsub|s\<in\><around|[|0,1|]>>
      \<ell\><around|(|<wide|\<Sigma\>|~><rsub|s>|)>.
    </equation*>

    Suppose that<footnote|This caveat is added solely to ensure that the
    relevant homology groups are well defined.>
    <math|f\<in\><big|cap><rsub|r\<gtr\>0>\<cal-F\>*<around|(|<wide|\<ell\>|~>/12,r|)>>.
    Set <math|<wide|\<frak-f\>|~><rsub|s>\<assign\><around|(|<wide|F|~><rsub|s>,f,1,0|)>>.
    Then <math|<around|{|<around|(|<wide|\<frak-f\>|~><rsub|s>|)>,a,b,0|}>>
    is also an <math|\<alpha\>>-admissible family, and hence gives rise to
    another family of chain maps <math|<around|(|<wide|\<Psi\>|~><rsub|s<rsub|0>><rsup|s<rsub|1>>|)>>.
    These chain maps are chain homotopic to the original chain maps, and
    hence they induce the same map on homology.

    <item>The induced maps <math|<around|(|\<psi\><rsub|s<rsub|0>><rsup|s<rsub|1>>|)>>
    enjoy the following <with|font-series|bold|functorial properties>
    whenever they are defined:

    <\equation*>
      \<psi\><rsub|s<rsub|0>><rsup|s<rsub|2>>=\<psi\><rsub|s<rsub|1>><rsup|s<rsub|2>>\<circ\>\<psi\><rsub|s<rsub|0>><rsup|s<rsub|1>>*<text|whenever>0\<leq\>s<rsub|0>\<leq\>s<rsub|1>\<leq\>s<rsub|2>\<leq\>1;
    </equation*>

    <\equation*>
      \<psi\><rsub|s<rsub|0>><rsup|s<rsub|0>>=<with|math-font|Bbb|1>.
    </equation*>
  </enumerate>

  The proof of the next lemma requires a little more work, but is by now
  standard.

  <lem|<label|lem:its an iso>Suppose in addition that
  <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\><rsub|s>,\<alpha\>|)>> for
  <with|font-series|bold|<em|all>> <math|s\<in\><around|[|0,1|]>>. Then the
  homomorphism <math|\<psi\><rsub|0><rsup|1>> is actually an isomorphism.>

  <\proof>
    Let <math|\<rho\><rsub|s>,T<rsub|s>\<gtr\>0> be the constants for
    <math|F<rsub|s>> from Corollary <reference|cor:the linfty cor> (note
    <math|\<rho\><rsub|s>> and <math|T<rsub|s>> depend continuously on
    <math|s>, cf. Remark <reference|rem:Observe-the constants>). Let

    <\equation*>
      \<rho\><rsub|1>\<assign\>min <around*|{|min<rsub|s>
      \<rho\><rsub|s>,<frac|a|4*max<rsub|s> T<rsub|s>>|}>.
    </equation*>

    Our choice of <math|f> guarantees that there exists
    <math|0\<less\>\<varepsilon\>\<less\>a/4> and <math|A\<gtr\>0> such that

    <\equation>
      f<around|(|\<eta\>|)>=\<eta\>*<text|for all
      >\<eta\>\<geq\><frac|a-4*\<varepsilon\>|6>;<label|eq:ass 1>
    </equation>

    <\equation>
      A*f<rprime|'>(-A)\<gtr\><frac|b-a+\<varepsilon\>|\<rho\><rsub|1>>.<label|eq:ass
      2>
    </equation>

    Shrinking <math|\<varepsilon\>> if necessary, we may assume in addition
    that

    <\equation>
      \<cal-A\><around|(|\<Sigma\><rsub|s>,\<alpha\>|)>\<cap\><around|[|a,a+\<varepsilon\>|]>=\<cal-A\><around|(|\<Sigma\><rsub|s>,\<alpha\>|)>\<cap\><around|[|b,b+\<varepsilon\>|]>=\<emptyset\><label|eq:spectrum>
    </equation>

    for all <math|s\<in\><around|[|0,1|]>>. Now choose
    <math|R\<gtr\>2*a+2*b+A+1> and let <math|<wide|f|\<bar\>>> denote an
    <math|R>-truncation of <math|f> (see Section
    <reference|sub:Truncating-the-function>). Set
    <math|\<frak-g\><rsub|s>\<assign\><around|(|F<rsub|1-s>,<wide|f|\<bar\>>,1,0|)>>.
    Our choice of <math|R> implies that for every
    <math|s\<in\><around|[|0,1|]>> such that <math|\<Sigma\><rsub|s>> is
    non-degenerate, the Floer homology <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-g\><rsub|s>>,\<alpha\>|)>>
    is well defined, and moreover

    <\equation*>
      H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>\<cong\>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-g\><rsub|1>>,\<alpha\>|)>;
    </equation*>

    <\equation*>
      H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>\<cong\>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-g\><rsub|0>>,\<alpha\>|)>.
    </equation*>

    Now we compute that for <math|u\<in\>\<cal-N\>*<around|(|\<nabla\>*A<rsub|\<frak-g\><rsub|s>>,\<alpha\>|)>>
    and <math|-\<infty\>\<leq\>s<rsub|0>\<leq\>s<rsub|1>\<leq\>\<infty\>>,

    <align*|<tformat|<table|<row|<cell|\<Delta\><rsub|s<rsub|0>><rsup|s<rsub|1>><around|(|u|)>=>|<cell|-<big|int><rsub|s<rsub|0>><rsup|s<rsub|1>><wide|f|\<bar\>><around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1><around*|(|\<partial\><rsub|s>*F<rsub|\<beta\>*<around|(|1-s|)>><around|(|x|)>|)>*d*t*d*s>>|<row|<cell|>|<cell|\<leq\>2*R*sup<rsub|s\<in\><around|[|0,1|]>><around*|\<\|\|\>|\<partial\><rsub|s>*F<rsub|s>|\<\|\|\>><rsub|\<infty\>>.>>>>>

    Choose <math|N\<in\>\<bbb-N\>> and a subdivision
    <math|0\<less\>i<rsub|0>\<less\>i<rsub|1>\<less\>\<ldots\>\<less\>i<rsub|N>=1>
    such that

    <\equation>
      max<rsub|0\<leq\>p\<leq\>N-1><around*|\||i<rsub|p+1>-i<rsub|p>|\|>\<leq\><frac|\<varepsilon\>|2*R*sup<rsub|s\<in\><around|[|0,1|]>><around*|\<\|\|\>|\<partial\><rsub|s>*F<rsub|s>|\<\|\|\>><rsub|\<infty\>>>,<label|eq:choice
      of subdivision>
    </equation>

    and such that <math|\<Sigma\><rsub|i<rsub|p>>> is non-degenerate for each
    <math|p=0,1,\<ldots\>,N>. Now set

    <\equation*>
      \<frak-g\><rsub|s><rsup|p>\<assign\><around*|(|F<rsub|<around|(|1-s|)>*i<rsub|p+1>-s*i<rsub|p>>,<wide|f|\<bar\>>,1,0|)>.
    </equation*>

    We claim that <math|<around|{|<around|(|\<frak-g\><rsub|s><rsup|p>|)>,a,b,\<varepsilon\>|}>>
    is an <math|\<alpha\>>-admissible family for each
    <math|p=0,1,\<ldots\>,N-1>. Indeed, Condition (1) of Definition
    <reference|def:admissible families> is obviously satisfied, and Condition
    (2) is satisfied by <eqref|eq:choice of subdivision>. Finally, the reader
    is invited to check that our two assumptions <eqref|eq:ass 1> and
    <eqref|eq:ass 2> together with the equations <eqref|eq:en eq>,
    <eqref|eq:sup eq> and <eqref|eq:inf eq> mean that the proof of
    Proposition <reference|pro:useful dichotomy> goes through to ensure that
    Condition (3) is satisfied for each <math|p=0,1,\<ldots\>,N-1>.

    As a result, Theorem <reference|thm:(Continuity-property-of> implies that
    for each <math|p=0,1,\<ldots\>,N-1> there exists a chain map

    <\equation*>
      \<Phi\><rsub|i<rsub|p+1>><rsup|i<rsub|p>>:C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|i<rsub|p+1>>>,\<alpha\>|)>\<rightarrow\>C*F<rsup|<around|(|a+\<varepsilon\>,b+\<varepsilon\>|)>><around|(|A<rsub|\<frak-f\><rsub|i<rsub|p>>>,\<alpha\>|)>
    </equation*>

    inducing a homomorphism

    <\equation*>
      \<phi\><rsub|i<rsub|p+1>><rsup|i<rsub|p>>:H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|i<rsub|p+1>>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a+\<varepsilon\>,b+\<varepsilon\>|)>><around|(|A<rsub|\<frak-f\><rsub|i<rsub|p>>>,\<alpha\>|)>.
    </equation*>

    Next, note that <eqref|eq:spectrum> and <eqref|eq:inclusionquotientmap>
    imply that

    <\equation*>
      i:H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|i<rsub|p>>>,\<alpha\>|)>\<cong\>H*F<rsup|<around|(|a+\<varepsilon\>,b+\<varepsilon\>|)>><around|(|A<rsub|\<frak-f\><rsub|i<rsub|p>>>,\<alpha\>|)>*<text|for
      all >p=0,1,\<ldots\>,N,
    </equation*>

    and consequently we may think of <math|\<phi\><rsub|i<rsub|p+1>><rsup|i<rsub|p>>>
    as a map

    <\equation*>
      \<phi\><rsub|i<rsub|p+1>><rsup|i<rsub|p>>:H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|i<rsub|p+1>>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\><rsub|i<rsub|p>>>,\<alpha\>|)>.
    </equation*>

    It is now easy to see from the two properties about the continuation maps
    given just before the statement of the lemma that
    <math|\<phi\><rsub|i<rsub|p+1>><rsup|i<rsub|p>>> is an isomorphism with
    inverse given by <math|\<psi\><rsub|i<rsub|p>><rsup|i<rsub|p+1>>>. It
    thus follows that if

    <\equation*>
      \<phi\><rsub|1><rsup|0>\<assign\>\<phi\><rsub|i<rsub|N>><rsup|i<rsub|N-1>>\<circ\>\<ldots\>\<circ\>\<phi\><rsub|i<rsub|2>><rsup|i<rsub|1>>\<circ\>\<phi\><rsub|i<rsub|1>><rsup|i<rsub|0>>,
    </equation*>

    then <math|\<phi\><rsub|1><rsup|0>> is the desired inverse to
    <math|\<psi\><rsub|0><rsup|1>>.
  </proof>

  We will be interested in a slight generalization of this.

  <\prop>
    <label|prop:staircase>Suppose we are given two smooth strictly decreasing
    families <math|<around|(|a<rsub|s>|)><rsub|s\<in\><around|[|0,1|]>>> and
    <math|<around|(|b<rsub|s>|)><rsub|s\<in\><around|[|0,1|]>>> such that
    <math|\<ell\>/2\<less\>a<rsub|s>\<less\>b<rsub|s>\<less\>\<infty\>> for
    all <math|s\<in\><around|[|0,1|]>> and such that
    <math|a<rsub|s>,b<rsub|s>\<nin\>\<cal-A\><around|(|\<Sigma\><rsub|s>,\<alpha\>|)>>
    for all <math|s\<in\><around|[|0,1|]>>. Then there exists a chain map

    <\equation*>
      \<Theta\><rsub|0><rsup|1>:C*F<rsup|<around|(|a<rsub|0>,b<rsub|0>|)>><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>\<rightarrow\>C*F<rsup|<around|(|a<rsub|1>,b<rsub|1>|)>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>
    </equation*>

    inducing an isomorphism

    <\equation*>
      \<theta\><rsub|0><rsup|1>:H*F<rsup|<around|(|a<rsub|0>,b<rsub|0>|)>><around|(|A<rsub|\<frak-f\><rsub|0>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a<rsub|1>,b<rsub|1>|)>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>.
    </equation*>

    Moreover the following diagram commutes:

    <\equation*>
      <\latex_preview|xymatrix>
        <\text>
          \\xymatrix{HF^{(a_{0},b_{0})}(A_{\\mathfrak{f}_{0}},\\alpha)\\ar[rr]^{\\psi_{0}^{1}}\\ar[dr]_{\\theta_{0}^{1}}
          & \ & HF^{(a_{0},b_{0})}(A_{\\mathfrak{f}_{1}},\\alpha)\\\\

          \ & HF^{(a_{1},b_{1})}(A_{\\mathfrak{f}_{1}},\\alpha)\\ar[ur]_{i}

          }
        </text>
      </latex_preview>
    </equation*>

    where

    <\equation*>
      i:H*F<rsup|<around|(|a<rsub|1>,b<rsub|1>|)>><around|(|A<rsub|\<frak-f\><rsub|1>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a<rsub|0>,b<rsub|0>|)>><around|(|A<rsub|\<frak-f\><rsub|`>>,\<alpha\>|)>
    </equation*>

    is the map from <eqref|eq:inclusionquotientmap>.
  </prop>

  <\proof>
    The trick here is to use a \Pstaircase\Q method to deal with the fact
    that the endpoints are changing. This is explained in detail in
    <cite-detail|MacariniSchlenk2010|p18>, but the general idea is the
    following. There exists <math|N\<in\>\<bbb-N\>> and sequences

    <\equation*>
      0=i<rsub|0>\<less\>i<rsub|1>\<less\>\<ldots\>\<less\>i<rsub|N>=1;
    </equation*>

    <\equation*>
      0=j<rsub|0>\<less\>j<rsub|1>\<less\>\<ldots\>\<less\>j<rsub|N>=1;
    </equation*>

    <\equation*>
      0=k<rsub|0>\<less\>k<rsub|1>\<less\>\<ldots\>\<less\>k<rsub|N>=1
    </equation*>

    such that for all <math|p\<in\><around|{|0,1,\<ldots\>,N-1|}>>,
    <math|\<Sigma\><rsub|k<rsub|p>>> is non-degenerate and

    <\equation>
      \<cal-A\><around|(|\<Sigma\><rsub|s>,\<alpha\>|)>\<cap\><around|[|a<rsub|i<rsub|p+1>>,a<rsub|i<rsub|p>>|]>=\<cal-A\><around|(|\<Sigma\><rsub|s>,\<alpha\>|)>\<cap\><around|[|b<rsub|j<rsub|p+1>>,b<rsub|j<rsub|p>>|]>=\<emptyset\>*<text|for
      all >s\<in\><around|[|k<rsub|p>,k<rsub|p+1>|]>.<label|eq:staircase>
    </equation>

    We already know from the previous lemma how to build isomorphisms

    <\equation*>
      \<psi\><rsub|p>:H*F<rsup|<around|(|a<rsub|i<rsub|p>>,b<rsub|j<rsub|p>>|)>><around|(|\<Sigma\><rsub|k<rsub|p>>,\<alpha\>|)>\<rightarrow\>H*F<rsub|\<nosymbol\>><rsup|<around|(|a<rsub|i<rsub|p>>,b<rsub|j<rsub|p>>|)>><around|(|\<Sigma\><rsub|k<rsub|p+1>>,\<alpha\>|)>,
    </equation*>

    and <eqref|eq:staircase> implies that

    <\equation*>
      H*F<rsup|<around|(|a<rsub|i<rsub|p>>,b<rsub|i<rsub|p>>|)>><around|(|\<Sigma\><rsub|k<rsub|p+1>>,\<alpha\>|)>\<cong\>H*F<rsub|\<nosymbol\>><rsup|<around|(|a<rsub|i<rsub|p+1>>,b<rsub|j<rsub|p+1>>|)>><around|(|\<Sigma\><rsub|k<rsub|p+1>>,\<alpha\>|)>.
    </equation*>

    Thus we obtain isomorphisms

    <\equation*>
      \<theta\><rsub|p>:H*F<rsub|\<nosymbol\>><rsup|<around|(|a<rsub|i<rsub|p>>,b<rsub|j<rsub|p>>|)>><around|(|\<Sigma\><rsub|k<rsub|p>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a<rsub|i<rsub|p+1>>,b<rsub|j<rsub|p+1>>|)>><around|(|\<Sigma\><rsub|k<rsub|p+1>>,\<alpha\>|)>,
    </equation*>

    and the proposition follows with

    <\equation*>
      \<theta\><rsub|0><rsup|1>\<assign\>\<theta\><rsub|N-1>\<circ\>\<ldots\>\<circ\>\<theta\><rsub|1>\<circ\>\<theta\><rsub|0>.
    </equation*>
  </proof>

  <subsection|Leaf-wise intersections >

  <vspace|6 pt>

  In this section we start with a single non-degenerate fibrewise starshaped
  hypersurface <math|\<Sigma\>>. As before, set
  <math|\<ell\>\<assign\>\<ell\><around|(|\<Sigma\>|)>> and fix once and for
  all a function <math|f\<in\><big|cap><rsub|r\<gtr\>0>\<cal-F\>*<around*|(|\<ell\>/12,r|)>>
  and a defining Hamiltonian <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>>.
  Given a class <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>> and a map
  <math|\<varphi\>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>,
  let us denote by <math|n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,<around|(|a,b|)>|)>>
  the number of positive leaf-wise intersections points of <math|\<varphi\>>
  in <math|\<Sigma\>> that belong to <math|\<alpha\>> and have time-shift
  <math|T\<in\><around|(|a,b|)>>. The following lemma explains the link
  between the Floer homology of a suitable perturbed Rabinowitz action
  functional <math|A<rsub|F<rsup|\<chi\>>,f><rsup|H>> and the number of
  positive leaf-wise intersections of <math|\<varphi\>>. The proof is
  immediate from Lemma <reference|lem:key lemma>.2 and Theorem
  <reference|thm:admissable yes>.

  <\lem>
    <label|lem:lw intersections and frfh>Suppose
    <math|\<varphi\>\<in\><text|<em|Ham>><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>
    is generated by <math|H\<in\>\<cal-H\>>. Choose
    <math|\<chi\>\<in\>\<cal-X\><rsub|0>> and set
    <math|\<frak-f\>\<assign\><around|(|F,f,\<chi\>,H|)>>. Fix
    <math|\<ell\>/2\<less\>a\<less\>b\<less\>\<infty\>> such that
    <math|H\<in\>\<cal-H\>*<around|(|a/2|)>> and
    <math|a,b\<nin\>\<cal-A\><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>. If
    <math|\<frak-f\>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|<em|r*e*g>>><rprime|''>>
    (which we can assume is the case for a generic <math|\<varphi\>>) then
    <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>>
    is well defined. Moreover, provided <math|\<varphi\>> has no periodic
    leaf-wise intersection points (which again, we may assume is the case for
    a generic <math|\<varphi\>> by Proposition <reference|prop:-generically
    no plwip>) one has

    <\equation*>
      n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,<around|(|a,b|)>|)>\<geq\>dim
      <space|0.17em>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>.
    </equation*>
  </lem>

  Now set <math|\<frak-g\>\<assign\><around|(|F,f,\<chi\>,0|)>>, and note
  that <math|\<frak-g\>\<in\>\<frak-F\><rsub|0,<with|font-family|rm|r*e*g>><rprime|'>>.
  Our next application of continuation homomorphisms is to interpolate
  between the Floer homology of the perturbed Rabinowitz action functional
  <math|A<rsub|\<frak-f\>>> and the non-perturbed one
  <math|A<rsub|\<frak-g\>>>. This lemma is a simple consequence of Theorem
  <reference|thm:(Continuity-property-of>.

  <\lem>
    <label|lem:continutations with H>Assume in addition that

    <\equation*>
      a-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->,a+<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>,b-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->,b+<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>,
    </equation*>

    Thus both <math|H*F<rsup|<around|(|a-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->,b-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->|)>><around|(|A<rsub|\<frak-g\>>,\<alpha\>|)>>
    and <math|H*F<rsup|<around|(|a+<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>,b+<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>|)>><around|(|A<rsub|\<frak-g\>>,\<alpha\>|)>>
    are well defined. Assume moreover that not only is
    <math|H\<in\>\<cal-H\>*<around|(|a/2|)>> but actually

    <\equation>
      2<around*|\<\|\|\>|H|\<\|\|\>>+\<kappa\><around|(|H|)>\<leq\><frac|a|2>.<label|eq:assumption>
    </equation>

    Then there exists a commutative diagram

    <\equation*>
      <\latex_preview|xymatrix>
        <\text>
          \\xymatrix{HF^{(a-\\left\\Vert H\\right\\Vert _{-},b-\\left\\Vert
          H\\right\\Vert _{-})}(A_{\\mathfrak{g}},\\alpha)\\ar[rr]\\ar[dr] &
          \ & HF^{(a+\\left\\Vert H\\right\\Vert _{+},b+\\left\\Vert
          H\\right\\Vert _{+})}(A_{\\mathfrak{g}},\\alpha)\\\\

          \ & HF^{(a,b)}(A_{\\mathfrak{f}},\\alpha)\\ar[ur]

          }
        </text>
      </latex_preview>
    </equation*>
  </lem>

  <\proof>
    Let us first build the continuation map

    <\equation>
      H*F<rsup|<around|(|a-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->,b-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->|)>><around|(|A<rsub|\<frak-g\>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-f\>>,\<alpha\>|)>.<label|eq:going
      one way>
    </equation>

    Set

    <\equation*>
      \<frak-f\><rsub|s>\<assign\><around|(|F,f,\<chi\>,s*H|)>*<text|for
      >s\<in\><around|[|0,1|]>.
    </equation*>

    We will verify that <math|<around|{|<around|(|\<frak-f\><rsub|s>|)>,a-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->,b-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->,<around*|\<\|\|\>|H|\<\|\|\>><rsub|->|}>>
    forms an <math|\<alpha\>>-admissible family in the sense of Definition
    <reference|def:admissible families>. Condition (1) is satisfied by
    assumption. Suppose <math|u\<in\>\<cal-N\>*<around|(|\<nabla\>*A<rsub|\<frak-f\><rsub|s>>,\<alpha\>|)>>
    and <math|-\<infty\>\<leq\>s<rsub|0>\<leq\>s<rsub|1>\<leq\>\<infty\>>.
    This time we have

    <align*|<tformat|<table|<row|<cell|\<Delta\><rsub|s<rsub|0>><rsup|s<rsub|1>><around|(|u|)>>|<cell|=-<big|int><rsub|s<rsub|0>><rsup|s<rsub|1>>\<beta\><rprime|'><around|(|s|)>*<big|int><rsub|0><rsup|1>H<around|(|t,x|)>*d*t*d*s>>|<row|<cell|>|<cell|\<leq\><big|int><rsub|0><rsup|1>\<beta\><rprime|'><around|(|s|)><around*|\<\|\|\>|H|\<\|\|\>><rsub|->*d*s>>|<row|<cell|>|<cell|=<around*|\<\|\|\>|H|\<\|\|\>><rsub|->.>>>>>

    Thus Condition (2) is satisfied. The reader may check that the stronger
    assumption <eqref|eq:assumption> implies that the proof of Proposition
    <reference|pro:useful dichotomy> goes through to provide the necessary
    constant <math|C<rsub|<with|font-family|rm|m*u*l*t>>\<gtr\>0> to satisfy
    Condition (3). The existence of the map <eqref|eq:going one way> now
    follows from Theorem <reference|thm:(Continuity-property-of>. The second
    map is defined similarly.
  </proof>

  Now set <math|\<frak-h\>\<assign\><around|(|F,f,1,0|)>>. We now want to
  interpolate between the Floer homology of <math|A<rsub|\<frak-g\>>> and the
  Floer homology of <math|A<rsub|\<frak-h\>>>.

  <\lem>
    <label|lem:chi>Suppose <math|\<ell\>/2\<less\>a\<less\>b\<less\>\<infty\>>
    satisfy <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>>. Then
    there exists an isomorphsim

    <\equation*>
      H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-g\>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|\<frak-h\>>,\<alpha\>|)>.
    </equation*>
  </lem>

  This lemma is proved in a similar fashion (in fact it's slightly easier) to
  the proof of Lemma <reference|lem:its an iso>, and as such we omit the
  proof. Putting the results of this section together we deduce:

  <\cor>
    <label|cor:lw bound>Assume the hypotheses of Lemma
    <reference|lem:continutations with H>. Then

    <\equation*>
      n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,<around|(|a,b|)>|)>\<geq\><text|<em|rank>><around*|{|i:H*F<rsup|<around|(|a-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->,b-<around*|\<\|\|\>|H|\<\|\|\>><rsub|->|)>><around|(|A<rsub|\<frak-h\>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|a+<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>,b+<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>|)>><around|(|A<rsub|\<frak-h\>>,\<alpha\>|)>|}>.
    </equation*>
  </cor>

  <section|The convex case><label|sec:The-convex-case>

  <subsection|<math|L<rsup|\<infty\>>> estimates for Hamiltonians that are
  not constant outside a compact set><label|sub:-estimates-for>

  <vspace|6 pt>

  Throughout this section, assume <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M>
  is a<with|font-series|bold|strictly fibrewise convex >non-degenerate
  fibrewise starshaped hypersurface. By this we mean a fibrewise starshaped
  hypersurface with the additional property that for each <math|q\<in\>M> the
  hypersurface <math|\<Sigma\>\<cap\>T<rsub|q><rsup|\<ast\>>*M> in
  <math|T<rsub|q><rsup|\<ast\>>*M> has a positive definite second fundamental
  form. Let <math|\<ell\>\<assign\>\<ell\><around|(|\<Sigma\>|)>>, and fix
  once and for all a function <math|f\<in\><big|cap><rsub|r\<gtr\>0>\<cal-F\>*<around|(|\<ell\>/12,r|)>>.

  For each <math|q\<in\>M>, let <math|r<rsub|q>:T<rsub|q><rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>>
  denote the function that is homogeneous of degree <math|2> and satisfies
  <math|r<rsub|q>\|<rsub|\<Sigma\>\<cap\>T<rsub|q><rsup|\<ast\>>*M>\<equiv\>1>.
  The function <math|<around|(|q,p|)>\<mapsto\>r<rsub|q><around|(|p|)>> is
  <math|C<rsup|1>> on all of <math|T<rsup|\<ast\>>*M>, but not necessarily
  smooth at the zero section. In order to correct this, let
  <math|\<rho\>:\<bbb-R\>\<rightarrow\>\<bbb-R\>> denote a smooth function
  such that <math|\<rho\><around|(|s|)>=0> for <math|s\<leq\>\<varepsilon\>>,
  and <math|\<rho\><rprime|'><around|(|s|)>\<gtr\>0> for
  <math|s\<gtr\>\<varepsilon\>>, and <math|\<rho\><around|(|s|)>=s> for
  <math|s\<geq\>2*\<varepsilon\>>, where <math|\<varepsilon\>> is some
  sufficiently small positive number. Then define
  <math|F:T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>> by

  <\equation>
    F<around|(|q,p|)>\<assign\><frac|1|2>*<around|(|\<rho\><around|(|r<rsub|q><around|(|p|)>|)>-1|)>.<label|eq:nice
    H>
  </equation>

  If <math|<around|(|q,p|)>\<in\>\<Sigma\>> then

  <\equation*>
    \<lambda\><around|(|X<rsub|F><around|(|q,p|)>|)>=\<omega\><around|(|Y<around|(|q,p|)>,X<rsub|F><around|(|q,p|)>|)>=d<rsub|<around|(|q,p|)>>*F<around|(|Y<around|(|q,p|)>|)>=r<rsub|q><around|(|p|)>=1.
  </equation*>

  Of course, the function <math|F> is not compactly supported, and thus
  <math|F\<nin\>\<cal-D\><around|(|\<Sigma\>|)>>, and hence <math|F> cannot a
  priori be used to compute the <math|\<cal-F\>>-Rabinowitz Floer homology of
  <math|\<Sigma\>>. In order to make it compactly supported, we truncate it
  at infinity. Given <math|R\<gtr\>1>, let
  <math|F<rsub|R>:T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>> denote a function
  such that <math|F<rsub|R><around|(|q,p|)>=F<around|(|q,p|)>> on
  <math|<around|{|F\<leq\>R-1|}>> and such that
  <math|F<rsub|R><around|(|q,p|)>=R> on <math|<around|{|F\<geq\>R+1|}>>. Then
  <math|F<rsub|R>\<in\>\<cal-D\><around|(|\<Sigma\>|)>>, and the aim of this
  section is to compute <math|H*F<rsup|<around|(|3*\<ell\>/4,\<infty\>|)>><around|(|A<rsub|F<rsub|R>,f>,\<alpha\>|)>>
  for each <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>.

  The following result is highly non-trivial, and is taken from
  <cite-detail|AbbondandoloSchwarz2009|Section 3> (the function <math|f>
  makes no difference here, given that we know a priorithat the
  <math|\<eta\>>-component of elements <math|u\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|F<rsub|R<rsub|1>>,f>|)>>
  are uniformly bounded).

  <thm|<label|thm:quadratic is compact>Let <math|S> denote a fibrewise
  starshaped hypersurface such that <math|D<around|(|\<Sigma\>|)>\<subseteq\>D<rsup|\<circ\>><around|(|S|)>>
  and such that <text|<em|supp>><math|<around|(|X<rsub|F>|)>\<subseteq\>D<rsup|\<circ\>><around|(|S|)>>.
  Choose <math|J\<in\>\<cal-J\><around|(|S|)>>. Choose
  <math|0\<less\>a\<less\>b\<less\>\<infty\>> such that
  <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>>. Then there
  exists <math|R<rsub|1>,R<rsub|0>\<gtr\>1> with
  <math|R<rsub|1>\<gtr\>R<rsub|0>+1> such that if
  <math|u=<around|(|x,\<eta\>|)>\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|F<rsub|R<rsub|1>>,f>|)>>
  then <math|x*<around|(|\<bbb-R\>\<times\>S<rsup|1>|)>\<subseteq\><around|{|F\<leq\>R<rsub|0>|}>>.>

  In other words, as far as the gradient flow lines
  <math|u\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|F,f>|)>>
  are concerned, we might as well not have truncated <math|F> at all. This
  result is not obvious; although Lemma <reference|lem:why convex good>
  implies that there certainly exists <math|R<rsub|2>\<gtr\>0> such that if
  <math|u=<around|(|x,\<eta\>|)>\<in\>\<cal-M\><rsup|<around|(|a,b|)>>*<around|(|\<nabla\><rsub|J>*A<rsub|F<rsub|R<rsub|1>>,f>|)>>
  then <math|x*<around|(|\<bbb-R\>\<times\>S<rsup|1>|)>\<subseteq\><around|{|F\<leq\>R<rsub|2>|}>>,
  there is absolutely no reason at all why we should have
  <math|R<rsub|1>\<gtr\>R<rsub|2>+1>. In order to prove this result, one must
  first show that one can obtain <math|L<rsup|\<infty\>>> bounds for the
  Hamiltonian <math|F> <with|font-series|bold|without>first truncating it at
  infinity, and then show that these bounds are unaffected if we then
  subsequently truncate <math|F> at some sufficiently large <math|R\<gtr\>0>.
  This last statement is only true because we restrict to the action interval
  <math|<around|(|a,b|)>>. In other words, this proves the Floer homology
  <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>> is well
  defined if we use the Hamiltonian <math|F>, and moreover with a little more
  work this shows that the Floer homology
  <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>> is
  isomorphic to Floer homology <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F<rsub|R>,f>,\<alpha\>|)>>.
  An alternative proof of Theorem <reference|thm:quadratic is compact> is
  given in <cite-detail|Merry2010a|Section 6>. Anyway, because of Theorem
  <reference|thm:quadratic is compact>, we may as well work directly with the
  Hamiltonian <math|F>, rather than truncating it at infinity. This is
  crucial for Theorem <reference|thm:precise version of theorem e> below.

  <subsection|The <math|f>-free time action functional>

  <vspace|6 pt>

  The Hamiltonian <math|F> has positive definite fibrewise second
  differential, and thus the <with|font-series|bold|Fenchel transform>
  <math|L:T*M\<rightarrow\>\<bbb-R\>> is well defined. Explicitly, <math|L>
  is the unique Lagrangian on <math|T*M> defined by

  <\equation*>
    L<around|(|q,v|)>\<assign\>max<rsub|p\<in\>T<rsub|q>*M><around*|{|p<around|(|v|)>-F<around|(|q,p|)>|}>.
  </equation*>

  The <with|font-series|bold|Legendre transformation> associated to <math|L>
  is the diffeomorphism <math|T*M\<cong\>T<rsup|\<ast\>>*M> given by
  <math|<around|(|q,v|)>\<mapsto\><around*|(|q,<frac|\<partial\>*L|\<partial\>*v><around|(|q,v|)>|)>>.
  One can recover <math|F> from <math|L> via

  <\equation*>
    F<around|(|q,p|)>=<frac|\<partial\>*L|\<partial\>*v><around|(|q,v|)><around|(|v|)>-L<around|(|q,v|)><text|where
    ><frac|\<partial\>*L|\<partial\>*v><around|(|q,v|)>=p.
  </equation*>

  Fix a Riemannian metric <math|g> on <math|M> for the remainder of this
  section. There exist constants <math|c<rsub|0>,c<rsub|1>\<gtr\>0> such that
  for all <math|<around|(|q,v|)>\<in\>T*M>,

  <\equation>
    d<rsub|v><rsup|2><around|(|L\|<rsub|T<rsub|q>*M>|)>\<geq\>c<rsub|0>*<with|math-font|Bbb|1>;<label|eq:aseq1>
  </equation>

  <\equation>
    <around*|\||\<nabla\><rsub|v*v>*L<around|(|q,v|)>|\|>\<leq\>c<rsub|1>,<around*|\||\<nabla\><rsub|v*q>*L<around|(|q,v|)>|\|>\<leq\>c<rsub|1>*<around|(|1+<around*|\||v|\|>|)>,<around*|\||\<nabla\><rsub|q*q>*L<around|(|q,v|)>|\|>\<leq\>c<rsub|1>*<around|(|1+<around*|\||v|\|><rsup|2>|)>,<label|eq:aseq2>
  </equation>

  where <math|\<nabla\><rsub|v*v>>, <math|\<nabla\><rsub|v*q>> and
  <math|\<nabla\><rsub|q*q>> denote the components of the Hessian of <math|L>
  associated to the horizontal-vertical splitting of <math|T*T*M> induced by
  <math|g>. See <cite-detail|AbbondandoloSchwarz2009|Section 10>.

  Define the <with|font-series|bold|<math|f>-free time action functional>
  <math|S<rsub|L,f>:\<Lambda\>*M\<times\>\<bbb-R\>\<rightarrow\>\<bbb-R\>> by

  <\equation*>
    S<rsub|L,f><around|(|q,\<eta\>|)>\<assign\>f<around|(|\<eta\>|)>*<big|int><rsub|0><rsup|1>L<around*|(|q,<frac|<wide|q|\<dot\>>|f<around|(|\<eta\>|)>>|)>*d*t.
  </equation*>

  Denote by Crit<math|<around|(|S<rsub|L,f>|)>> the set of critical points of
  <math|S<rsub|L,f>>. We wish to do Morse theory with <math|S<rsub|L,f>>, and
  as such we will work with the completion <math|<wide|\<Lambda\>|~>*M> of
  <math|\<Lambda\>*M> in the Sobolev <math|W<rsup|1,2>>-norm. Given
  <math|a\<gtr\>0> and <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>> let us
  abbreviate

  <\equation>
    \<bbb-S\><rsub|\<alpha\>><rsup|a>\<assign\><around|{|<around|(|q,\<eta\>|)>\<in\><wide|\<Lambda\>|~><rsub|\<alpha\>>*M\<times\>\<bbb-R\><space|0.17em>:<space|0.17em>S<rsub|L,f><around|(|q,\<eta\>|)>\<less\>a|}>.<label|eq:Saalpha>
  </equation>

  It is convenient to define

  <\equation*>
    E<rsub|L><around|(|q,v|)>\<assign\><frac|\<partial\>*L|\<partial\>*v><around|(|q,v|)><around|(|v|)>-L<around|(|q,v|)>;
  </equation*>

  one calls <math|E<rsub|L>> the <with|font-series|bold|energy> of <math|L>.
  If <math|<frac|\<partial\>*L|\<partial\>*v><around|(|q,v|)>=p> then
  <math|F<around|(|q,p|)>=E<rsub|L><around|(|q,v|)>>.

  Here is another way to interpret the elements of
  Crit<math|<around|(|S<rsub|L,f>|)>>. Given
  <math|<around|(|q,\<eta\>|)>\<in\>\<Lambda\>*M\<times\>\<bbb-R\>>, let
  <math|\<gamma\>:\<bbb-R\>/f<around|(|\<eta\>|)>*\<bbb-Z\>\<rightarrow\>M>
  denote the curve

  <\equation*>
    \<gamma\><around|(|t|)>\<assign\>q*<around|(|t/f<around|(|\<eta\>|)>|)>.
  </equation*>

  Then <math|<around|(|q,\<eta\>|)>\<in\><text|Crit><around|(|S<rsub|L,f>|)>>
  if and only if <math|\<gamma\>> satisfies the
  <with|font-series|bold|Euler-Lagrange equations>for <math|L>:

  <\equation>
    <frac|d|d*t>*<frac|\<partial\>*L|\<partial\>*v><around|(|\<gamma\><around|(|t|)>,<wide|\<gamma\>|\<dot\>><around|(|t|)>|)>=<frac|\<partial\>*L|\<partial\>*q><around|(|\<gamma\><around|(|t|)>,<wide|\<gamma\>|\<dot\>><around|(|t|)>|)>,<label|eq:EL
    eq>
  </equation>

  and has energy equal to 0:

  <\equation*>
    E<rsub|L><around|(|\<gamma\><around|(|t|)>,<wide|\<gamma\>|\<dot\>><around|(|t|)>|)>\<equiv\>0.
  </equation*>

  The condition that <math|\<Sigma\>> is non-degenerate translates to the
  following statement about the critical points of <math|S<rsub|L.*f>>:

  <lem|Every critical point <math|<around|(|q,\<eta\>|)>> of
  <math|S<rsub|L,f>> is <with|font-series|bold|<em|non-degenerate>>in the
  sense that the space of non-zero Jacobi vector fields along the
  corresponding solution <math|\<gamma\>> of <eqref|eq:EL eq> is one
  dimensional, spanned by <math|<around|(|<wide|\<gamma\>|\<dot\>>,0|)>>.>

  Let us denote by <math|i<rsub|S<rsub|L,f>><around|(|q,\<eta\>|)>> the
  <with|font-series|bold|Morse index> of a critical point
  <math|<around|(|q,\<eta\>|)>> of <math|S<rsub|L,f>>. Since <math|L> is a
  fibrewise strictly convex superlinear Lagrangian, the Morse index
  <math|i<rsub|S<rsub|L.*f>><around|(|q,\<eta\>|)>> is finite for every
  <math|<around|(|q,\<eta\>|)>\<in\><text|Crit><around|(|S<rsub|L,f>|)>>
  <cite|Duistermaat1976>. The following lemma clarifies the relationship
  between the functionals <math|S<rsub|L,f>> and <math|A<rsub|F,f>>.

  <\lem>
    <label|lem:key lemma-1>There exists a map
    <math|\<cal-Z\>=\<cal-Z\><around|(|L,f|)>:<wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>\<rightarrow\><wide|\<Lambda\>|~>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
    such that <math|<around|(|\<pi\><rsub|\<ast\>>\<times\><with|math-font|Bbb|1>|)>\<circ\>\<cal-Z\>=<with|math-font|Bbb|1>>
    (where <math|\<pi\><rsub|\<ast\>>:<wide|\<Lambda\>|~>*T<rsup|\<ast\>>*M\<rightarrow\><wide|\<Lambda\>|~>*M>
    is the induced map <math|<around|(|\<pi\><rsub|\<ast\>><around|(|x|)>|)><around|(|t|)>\<assign\>\<pi\><around|(|x<around|(|t|)>|)>>),
    and such that <math|\<cal-Z\>> restricts to define a bijection
    <text|<em|Crit>><math|<around|(|S<rsub|L.*f>|)>\<rightarrow\><text|<em|Crit>><around|(|A<rsub|F,f>|)>>.
    Moreover, given any <math|<around|(|x,\<eta\>|)>\<in\><wide|\<Lambda\>|~>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>,
    we have

    <\equation*>
      A<rsub|F,f><around|(|x,\<eta\>|)>\<leq\>S<rsub|L,f>*<around|(|\<pi\>\<circ\>x,\<eta\>|)>)
    </equation*>

    with equality if and only if <math|<around|(|x,\<eta\>|)>=\<cal-Z\>*<around|(|\<pi\>\<circ\>x,\<eta\>|)>>.

    Finally, the map <math|\<cal-Z\>> preserves the grading: for any
    <math|<around|(|q,\<eta\>|)>\<in\><text|<em|Crit>><around|(|S<rsub|L,f>|)>>,
    if <math|\<cal-Z\><around|(|q,\<eta\>|)>=:<around|(|x,\<eta\>|)>> then

    <\equation*>
      i<rsub|S<rsub|L,f>><around|(|q,\<eta\>|)>=\<mu\><rsub|<with|font-family|rm|<em|C*Z>>><rsup|\<tau\>>*<around|(|x;f<around|(|\<eta\>|)>*F|)>.
    </equation*>
  </lem>

  <\proof>
    The map <math|\<cal-Z\>> is defined by

    <\equation*>
      \<cal-Z\><around|(|q,\<eta\>|)>\<assign\><around*|(|<around*|(|q,<frac|\<partial\>*L|\<partial\>*v><around*|(|q,<wide|q|\<dot\>>|)>|)>,\<eta\>|)>.
    </equation*>

    See <cite-detail|AbbondandoloSchwarz2009|Lemma 5.1> or
    <cite-detail|Merry2010a|Lemma 4.1>. The last statement follows from
    <cite-detail|MerryPaternain2010|Section 1.3>. The key ingredient is
    Duistermaat's <with|font-series|bold|Morse index theorem>
    <cite|Duistermaat1976>.
  </proof>

  As mentioned above, one would like to do Morse theory with
  <math|S<rsub|L,f>>. There are two issues that need to be sorted before we
  can proceed. The first problem is that in general the functional
  <math|S<rsub|L,f>> is <with|font-series|bold|not>of class <math|C<rsup|2>>
  on <math|<wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>>. Nevertheless, one has
  the following result, which is due to Abbondandolo and Schwarz
  <cite-detail|AbbondandoloSchwarz2009a|Theorem 4.1> (see also the discussion
  before Proposition <math|11.2> in <cite|AbbondandoloSchwarz2009>).

  <\prop>
    Let <math|f\<in\>\<cal-F\>>. Then there exists a
    <with|font-series|bold|<em|smooth pseudo-gradient>>for <math|S<rsub|L,f>>
    on <math|<wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>>. In other words, there
    exists a smooth vector field <math|V> on
    <math|<wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>> such that:

    <\enumerate>
      <item><math|V> is bounded;

      <item><math|d<rsub|<around|(|q,\<eta\>|)>>*S<rsub|L,f><around|(|V<around|(|q,\<eta\>|)>|)>\<geq\><frac|1|2>*min
      <around*|{|1,<around*|\<\|\|\>|d<rsub|<around|(|q,\<eta\>|)>>*S<rsub|L,f>|\<\|\|\>><rsub|g>|}>>
      for all <math|<around|(|q,\<eta\>|)>\<in\><wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>>;

      <item>the set <text|<em|Crit>><math|<around|(|V|)>> of zeros of
      <math|V> coincides with <text|<em|Crit>><math|<around|(|S<rsub|L,f>|)>>,
      and the linearization of <math|V> at a rest point
      <math|<around|(|q,\<eta\>|)>> of <math|V> agrees with the Hessian of
      <math|S<rsub|L,f>> at <math|<around|(|q,\<eta\>|)>>.
    </enumerate>
  </prop>

  Secondly, we need to verify that we can choose a pseudo-gradient <math|V>
  such that the pair <math|<around|(|S<rsub|L,f>,V|)>> satisfies the
  <with|font-series|bold|Palais-Smale condition>. Recall that we say that the
  pair <math|<around|(|S<rsub|L,f>,V|)>> satisfies the Palais-Smale condition
  at the level <em|<math|T\<in\>\<bbb-R\>> >if every sequence
  <math|<around|(|q<rsub|i>,\<eta\><rsub|i>|)>\<subseteq\><wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>>
  such that <math|S<rsub|L,f><around|(|q<rsub|i>,\<eta\><rsub|i>|)>\<rightarrow\>T>
  and <math|d<rsub|<around|(|q<rsub|i>,\<eta\><rsub|i>|)>>*S<rsub|L,f><around|(|V<around|(|q<rsub|i>,\<eta\><rsub|i>|)>|)>\<rightarrow\>0>
  admits a convergent subsequence. The fact that
  <math|<around|(|S<rsub|L,f>,V|)>> satisfies the Palais-Smale condition at
  any <math|T\<gtr\>0> is essentially a consequence of the fact that the
  <with|font-series|bold|Ma critical value><math|c<around|(|L|)>> of
  <math|L> is negative. Let us first recall the definition of the Ma
  critical value.

  <\defn>
    Let <math|K:T*N\<rightarrow\>\<bbb-R\>> denote a fibrewise strictly
    convex and superlinear Lagrangian. Define the
    <with|font-series|bold|action><math|\<bbb-A\><rsub|K>> of <math|K> to be
    the functional

    <\equation*>
      \<bbb-A\><rsub|K>:<around*|{|\<gamma\>:<around|[|0,T|]>\<rightarrow\>N,\<gamma\>*<text|absolutely
      continuous,><space|0.17em>T\<gtr\>0|}>\<rightarrow\>\<bbb-R\>;
    </equation*>

    <\equation*>
      \<bbb-A\><rsub|K><around|(|\<gamma\>|)>\<assign\><big|int><rsub|0><rsup|T>K<around|(|\<gamma\><around|(|t|)>,<wide|\<gamma\>|\<dot\>><around|(|t|)>|)>*d*t.
    </equation*>

    The<with|font-series|bold|Ma critical value><math|c<around|(|K|)>> of
    <math|K> is the real number defined by

    <\equation*>
      c<around|(|K|)>\<assign\>inf <around*|{|k\<in\>\<bbb-R\><space|0.17em>:<space|0.17em>\<bbb-A\><rsub|K+k><around|(|\<gamma\>|)>\<geq\>0\<forall\><space|0.17em><text|a.c.
      closed curves >\<gamma\><text|defined on
      ><around|[|0,T|]>,\<forall\><space|0.17em>T\<gtr\>0|}>.
    </equation*>
  </defn>

  The next lemma follows straight from the definition.

  <\lem>
    <label|lem:bounded below>Suppose <math|c<around|(|K|)>\<leq\>0>. Then for
    any <math|f\<in\>\<cal-F\>> it holds that

    <\equation*>
      inf<rsub|<around|(|q,\<eta\>|)>\<in\><wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>>
      S<rsub|K,f><around|(|q,\<eta\>|)>\<gtr\>-\<infty\>.
    </equation*>
  </lem>

  In our case, the Ma critical value is strictly negative.

  <lem|The Ma critical value of <math|L> is strictly negative.>

  <\proof>
    The proof is based on the following alternative characterization of the
    critical value, which is due to Contreras, Iturriaga, Paternain and
    Paternain <cite|ContrerasIturriagaPaternainPaternain1998>. Suppose
    <math|K:T*M\<rightarrow\>\<bbb-R\>> is a fibrewise strictly convex
    superlinear Lagrangian. Then <math|K> is the Fenchel transform of a
    unique Hamiltonian <math|P:T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>>.
    Then

    <\equation*>
      c<around|(|K|)>=inf<rsub|u\<in\>C<rsup|\<infty\>><around|(|M|)>>
      sup<rsub|q\<in\>M> P*<around|(|q,d<rsub|q>*u|)>.
    </equation*>

    In our case since <math|D<around|(|\<Sigma\>|)>=D<around|(|F<rsup|-1><around|(|0|)>|)>>
    contains the zero section, taking <math|u> to be a constant function we
    have

    <\equation*>
      c<around|(|L|)>\<leq\>inf<rsub|u\<in\>C<rsup|\<infty\>><around|(|M|)>>
      sup<rsub|q\<in\>M> F*<around|(|q,d<rsub|q>*u|)>\<leq\>sup<rsub|q\<in\>M>
      F<around|(|q,0<rsub|q>|)>\<less\>0.
    </equation*>
  </proof>

  The following theorem is essentially taken from
  <cite|ContrerasIturriagaPaternainPaternain2000|Contreras2006> (Proposition
  3.8 and 3.12); see also <cite|Benci1986>.

  <thm|<label|thm:Let--forPS>Let <math|V> denote a smooth pseudo-gradient for
  <math|S<rsub|L,f>>. Then the pair <math|<around|(|S<rsub|L,f>,V|)>>
  satisfies the Palais-Smale condition at the level <math|T> on
  <math|<wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>> for any <math|T\<gtr\>0>.>

  <rem|In fact, if <math|\<alpha\>\<ne\>0> then the pair
  <math|<around|(|S<rsub|L,f>,V|)>> satisfies the Palais-Smale condition on
  <math|<wide|\<Lambda\>|~><rsub|\<alpha\>>*M\<times\>\<bbb-R\>> even at the
  level <math|T=0>.>

  <\proof>
    <em|(of Theorem <reference|thm:Let--forPS>)>

    Suppose we are given a sequence <math|<around|(|q<rsub|i>,\<eta\><rsub|i>|)>\<subseteq\><wide|\<Lambda\>|~>*M\<times\>\<bbb-R\>>
    such that <math|S<rsub|L,f><around|(|q<rsub|i>,\<eta\><rsub|i>|)>\<rightarrow\>T>
    for some <math|T\<gtr\>0> and <math|d<rsub|<around|(|q<rsub|i>,\<eta\><rsub|i>|)>>*S<rsub|L,f><around|(|V<around|(|q<rsub|i>,\<eta\><rsub|i>|)>|)>\<rightarrow\>0>.
    Passing to a subsequence we may assume that

    <\equation>
      0\<leq\>S<rsub|L,f><around|(|q<rsub|i>,\<eta\><rsub|i>|)>\<leq\>C,<around*|\<\|\|\>|d<rsub|<around|(|q<rsub|i>,\<eta\><rsub|i>|)>>*S<rsub|L,f>|\<\|\|\>><rsub|g>\<leq\><frac|1|i>*<text|for
      all >i\<in\>\<bbb-N\>,<label|eq:ass>
    </equation>

    where <math|C> is some positive constant. We first check that
    <math|<around|(|\<eta\><rsub|i>|)>> is uniformly bounded below. Equations
    <eqref|eq:aseq1> and <eqref|eq:aseq2> imply that there exist constants
    <math|d<rsub|0>,d<rsub|1>,d<rsub|2>,d<rsub|3>\<gtr\>0> such that

    <\equation*>
      d<rsub|0><around*|\||v|\|><rsup|2>-d<rsub|1>\<leq\>L<around|(|q,v|)>\<leq\>d<rsub|2><around*|\||v|\|><rsup|2>+d<rsub|3><text|for
      all ><around|(|q,v|)>\<in\>T*M.
    </equation*>

    Compactness of <math|M> implies, up to passing to a subsequence, that
    <math|lim<rsub|i> q<rsub|i><around|(|0|)>=q<rsub|0>> for some
    <math|q<rsub|0>\<in\>M>. Write <math|\<gamma\><rsub|i><around|(|t|)>\<assign\>q<rsub|i>*<around|(|t/f<around|(|\<eta\><rsub|i>|)>|)>>,
    so that <math|\<gamma\><rsub|i>:\<bbb-R\>/f<around|(|\<eta\><rsub|i>|)>*\<bbb-Z\>\<rightarrow\>M>.
    We will write <math|l<rsub|i>> and <math|e<rsub|i>> for the
    <with|font-series|bold|length >and <with|font-series|bold|energy >of the
    curves <math|\<gamma\><rsub|i>>, given by

    <\equation*>
      l<rsub|i>\<assign\><big|int><rsub|0><rsup|f<around|(|\<eta\><rsub|i>|)>><around*|\||<wide|\<gamma\>|\<dot\>><rsub|i><around|(|t|)>|\|>*d*t,e<rsub|i>\<assign\><big|int><rsub|0><rsup|f<around|(|\<eta\><rsub|i>|)>><frac|1|2><around*|\||<wide|\<gamma\>|\<dot\>><rsub|i><around|(|t|)>|\|><rsup|2>*d*t.
    </equation*>

    The Cauchy-Schwarz inequality implies that

    <\equation>
      l<rsub|i><rsup|2>\<leq\>2*f<around|(|\<eta\><rsub|i>|)>*e<rsub|i>.<label|eq:CS>
    </equation>

    Note that

    <\equation>
      2*d<rsub|2>*e<rsub|i>+d<rsub|3>*f<around|(|\<eta\><rsub|i>|)>\<geq\>S<rsub|L,f><around|(|q<rsub|i>,\<eta\><rsub|i>|)>=<big|int><rsub|0><rsup|f<around|(|\<eta\><rsub|i>|)>>L<around|(|\<gamma\><rsub|i>,<wide|\<gamma\>|\<dot\>><rsub|i>|)>*d*t\<geq\>2*d<rsub|0>*e<rsub|i>-d<rsub|1>*f<around|(|\<eta\><rsub|i>|)>.<label|eq:sandwich>
    </equation>

    Assume for contradiction that <math|<around|(|\<eta\><rsub|i>|)>> is not
    uniformly bounded below. Up to passing to a subsequence, we may assume
    that <math|\<eta\><rsub|i>\<rightarrow\>-\<infty\>>. We will now prove
    that after passing to a further subsequence if necessary,
    <math|e<rsub|i>\<rightarrow\>0>. Then <eqref|eq:sandwich> implies that
    <math|S<rsub|L,f><around|(|q<rsub|i>,\<eta\><rsub|i>|)>\<rightarrow\>0>,
    which contradicts the fact that <math|T\<gtr\>0>.

    To see this we argue as follows. Firstly, <eqref|eq:ass> implies that
    <math|<around|(|e<rsub|i>|)>> is bounded. Since
    <math|<around|(|e<rsub|i>|)>> is bounded, <eqref|eq:CS> implies that
    <math|l<rsub|i>\<rightarrow\>0>, and thus up to passing to a subsequence,
    we may assume that <math|q<rsub|i><around|(|S<rsup|1>|)>\<subseteq\>U\<cong\>\<bbb-R\><rsup|n>>
    (where <math|n=dim <space|0.17em>M>) for all <math|i>. Thus for the
    remainder of the proof we work on <math|\<bbb-R\><rsup|n>>. We can
    therefore speak of the partial derivatives
    <math|L<rsub|q>=<frac|\<partial\>*L|\<partial\>*q>> and
    <math|L<rsub|v>=<frac|\<partial\>*L|\<partial\>*v>>. The assumptions
    <eqref|eq:aseq1> and<eqref|eq:aseq2> imply that there exist constants
    <math|c<rsub|2>,c<rsub|3>,c<rsub|4>\<gtr\>0> such that in the coordinates
    on <math|U>,

    <\equation>
      c<rsub|2>\<assign\>sup<rsub|q\<in\>U,v\<in\>T<rsub|q>*M>
      <frac|<around*|\||L<rsub|q><around|(|q,v|)>|\|>|1+<around*|\||v|\|><rsup|2>>\<less\>\<infty\>;<label|eq:b3>
    </equation>

    <\equation*>
      c<rsub|3>\<assign\>sup<rsub|q\<in\>U,v\<in\>T<rsub|q>*M>
      <frac|<around*|\||L<rsub|v*q><around|(|q,v|)>|\|>|1+<around*|\||v|\|><rsup|2>>\<less\>\<infty\>;
    </equation*>

    <\equation*>
      c<rsub|4>\<assign\>inf<rsub|q\<in\>U,v\<in\>T<rsub|q>*M>
      <frac|v\<cdot\>L<rsub|v*v><around|(|q,v|)>\<cdot\>v|<around*|\||v|\|><rsup|2>>\<gtr\>0.
    </equation*>

    Arguing as in <cite-detail|Contreras2006|Lemma 3.2(ii)>, we have for any
    two points <math|q,q<rprime|'>\<in\>U> and any <math|v\<in\>T<rsub|q>*M>
    that

    <\equation>
      L<rsub|v><around|(|q,v|)>\<cdot\>v\<geq\>L<rsub|v><around|(|q<rprime|'>,0|)>\<cdot\>v-c<rsub|3><around*|\||v|\|>*<around*|\||q-q<rprime|'>|\|>-c<rsub|3><around*|\||v|\|><rsup|2>*<around*|\||q-q<rprime|'>|\|>+c<rsub|4><around*|\||v|\|><rsup|2>.<label|eq:gonzalo>
    </equation>

    Let <math|\<xi\><rsub|i><around|(|t|)>\<assign\>q<rsub|i><around|(|t|)>-q<rsub|i><around|(|0|)>>,
    so that <math|<around|(|\<xi\><rsub|i>,0|)>\<in\>T<rsub|<around|(|q<rsub|i>,\<eta\><rsub|i>|)>>*<around|(|<wide|\<Lambda\>|~>*\<bbb-R\><rsup|n>\<times\>\<bbb-R\>|)>>.
    Put <math|\<zeta\><rsub|i><around|(|t|)>\<assign\>\<xi\><rsub|i>*<around|(|t/f<around|(|\<eta\><rsub|i>|)>|)>>,
    so that <math|<wide|\<zeta\>|\<dot\>><rsub|i><around|(|t|)>=<wide|\<gamma\>|\<dot\>><rsub|i><around|(|t|)>>.
    Then <eqref|eq:ass> implies that

    <\equation>
      <around*|\||d<rsub|<around|(|q<rsub|i>,\<eta\><rsub|i>|)>>*S<rsub|L,f><around|(|\<xi\><rsub|i>,0|)>|\|>\<leq\><frac|1|i><around*|\<\|\|\>|<around|(|\<xi\><rsub|i>,0|)>|\<\|\|\>><rsub|g>\<leq\><frac|1|i>*<sqrt|2*f<around|(|\<eta\><rsub|i>|)>*e<rsub|i>>.<label|eq:bound
      above>
    </equation>

    Next, a straightforward computation (see
    <cite-detail|Contreras2006|p331>) tells us that

    <\equation*>
      d<rsub|<around|(|q<rsub|i>,\<eta\><rsub|i>|)>>*S<rsub|L,f><around|(|\<xi\><rsub|i>,0|)>=<big|int><rsub|0><rsup|f<around|(|\<eta\><rsub|i>|)>><around*|(|L<rsub|q><around|(|\<gamma\><rsub|i>,<wide|\<gamma\>|\<dot\>><rsub|i>|)>*\<zeta\><rsub|i>+L<rsub|v><around|(|\<gamma\><rsub|i>,<wide|\<gamma\>|\<dot\>><rsub|i>|)>*<wide|\<zeta\>|\<dot\>><rsub|i>|)>*d*t.
    </equation*>

    We apply <eqref|eq:b3> and <eqref|eq:gonzalo> with
    <math|<around|(|q,v|)>=<around|(|\<gamma\><rsub|i>,<wide|\<gamma\>|\<dot\>><rsub|i>|)>>
    and <math|q<rprime|'>=\<gamma\><rsub|i><around|(|0|)>> to obtain:

    <align*|<tformat|<table|<row|<cell|d<rsub|<around|(|q<rsub|i>,\<eta\><rsub|i>|)>>*S<rsub|L,f><around|(|\<xi\><rsub|i>,0|)>>|<cell|\<geq\>-c<rsub|2>*<big|int><rsub|0><rsup|f<around|(|\<eta\><rsub|i>|)>><around*|(|1+<around*|\||<wide|\<gamma\>|\<dot\>><rsub|i>|\|><rsup|2>|)>*<around*|\||\<gamma\><rsub|i>-\<gamma\><rsub|i><around|(|0|)>|\|>*d*t+<around*|(|<big|int><rsub|0><rsup|f<around|(|\<eta\><rsub|i>|)>>L<rsub|q><around|(|\<gamma\><rsub|i><around|(|0|)>,0|)>\<cdot\><wide|\<gamma\>|\<dot\>><rsub|i>*d*t|)>>>|<row|<cell|>|<cell|-c<rsub|3>*<big|int><rsub|0><rsup|f<around|(|\<eta\><rsub|i>|)>><around*|\||<wide|\<gamma\>|\<dot\>><rsub|i>|\|>*<around*|\||\<gamma\><rsub|i>-\<gamma\><rsub|i><around|(|0|)>|\|>*d*t-c<rsub|3>*<big|int><rsub|0><rsup|f<around|(|\<eta\><rsub|i>|)>><around*|\||<wide|\<gamma\>|\<dot\>><rsub|i>|\|><rsup|2>*<around*|\||\<gamma\><rsub|i>-\<gamma\><rsub|i><around|(|0|)>|\|>*d*t+2*c<rsub|4>*e<rsub|i>>>|<row|<cell|>|<cell|\<geq\>-c<rsub|2>*l<rsub|i>*f<around|(|\<eta\><rsub|i>|)>+0-c<rsub|3>*l<rsub|i><rsup|2>-2*<around|(|c<rsub|2>+c<rsub|3>|)>*l<rsub|i>*e<rsub|i>+2*c<rsub|4>*e<rsub|i>.>>>>>

    Combining this last equation with <eqref|eq:bound above> and dividing
    through by <math|<sqrt|f<around|(|\<eta\><rsub|i>|)>>>, we see that

    <\equation*>
      -c<rsub|2>*l<rsub|i>*<sqrt|f<around|(|\<eta\><rsub|i>|)>>-c<rsub|3>*<frac|l<rsub|i><rsup|2>|<sqrt|f<around|(|\<eta\><rsub|i>|)>>>-2*<around|(|c<rsub|2>+c<rsub|3>|)>*<frac|l<rsub|i>*e<rsub|i>|<sqrt|f<around|(|\<eta\><rsub|i>|)>>>+2*c<rsub|4>*<frac|e<rsub|i>|<sqrt|f<around|(|\<eta\><rsub|i>|)>>>\<leq\><frac|1|i>*<sqrt|2*e<rsub|i>>.
    </equation*>

    Equation <eqref|eq:CS> implies the first three terms on the left-hand
    side are bounded. Since the right-hand side is also bounded, we see that

    <\equation*>
      <frac|e<rsub|i>|<sqrt|f<around|(|\<eta\><rsub|i>|)>>>
    </equation*>

    is bounded, and thus <math|e<rsub|i>\<rightarrow\>0> as claimed.

    We have now proved that <math|<around|(|\<eta\><rsub|i>|)>> is bounded
    below. Next, we check that <math|<around|(|\<eta\><rsub|i>|)>> is bounded
    above. Indeed, we have

    <\equation*>
      S<rsub|L,f><around|(|q<rsub|i>,\<eta\><rsub|i>|)>=S<rsub|L+c<around|(|L|)>,f><around|(|q<rsub|i>,\<eta\><rsub|i>|)>-c<around|(|L|)>*f<around|(|\<eta\><rsub|i>|)>.
    </equation*>

    Since <math|f<around|(|\<eta\>|)>\<equiv\>\<eta\>> on
    <math|<around|[|a,\<infty\>|)>>, and since
    <math|S<rsub|L+c<around|(|L|)>,f>> is bounded below (Lemma
    <reference|lem:bounded below>) and <math|c<around|(|L|)>\<less\>0>, we
    must have <math|<around|(|\<eta\><rsub|i>|)>> bounded above.

    Thus <math|<around|(|\<eta\><rsub|i>|)>> is a bounded sequence, and thus
    up to passing to a subsequence, we may assume that
    <math|\<eta\><rsub|i>\<rightarrow\>\<eta\>> for some
    <math|\<eta\>\<in\>\<bbb-R\>>. From this point on the proof is
    essentially identical to <cite-detail|Contreras2006|Proposition 3.12>,
    and thus we will omit further details.
  </proof>

  Note that Lemma <reference|lem:key lemma-1> implies that
  Crit<math|<around|(|S<rsub|L,f>,\<alpha\>|)>\<cap\>\<bbb-S\><rsub|\<alpha\>><rsup|3*\<ell\>/4>=\<emptyset\>>.
  Using this observation together with Theorem <reference|thm:Let--forPS>,
  and arguing as in <cite-detail|AbbondandoloSchwarz2009|Proposition 11.3> we
  conclude:

  <cor|<label|cor:def retract>The pair <math|<around|(|<wide|\<Lambda\>|~><rsub|\<alpha\>>*M\<times\>\<bbb-R\>,\<bbb-S\><rsub|\<alpha\>><rsup|3*\<ell\>/4>|)>>
  is homotopy equivalent to <math|<around|(|\<Lambda\><rsub|\<alpha\>>*M,\<emptyset\>|)>>
  if <math|\<alpha\>\<ne\>0>, and to <math|<around|(|\<Lambda\><rsub|0>*M,M|)>>
  if <math|\<alpha\>=0>, where we view <math|M\<subseteq\>\<Lambda\><rsub|0>*M>
  as the constant loops.>

  We are now in a position of being able to define the Morse homology of
  <math|S<rsub|L,f>>. Suppose <math|\<ell\>/2\<less\>a\<less\>b\<less\>\<infty\>>
  and <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. The
  <with|font-series|bold|relative Morse homology >of
  <math|<around|(|S<rsub|L,f>,\<alpha\>|)>> on the action interval
  <math|<around|(|a,b|)>> will be well defined whenever
  <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>>. Fix a smooth
  pseudo-gradient <math|V> of <math|S<rsub|L,f>>. Pick a Morse function
  <math|m:<text|Crit><around|(|S<rsub|L,f>|)>\<rightarrow\>\<bbb-R\>>, and
  denote by Crit<math|<around|(|m|)>\<subseteq\><text|Crit><around|(|S<rsub|L,f>|)>>
  the set of critical points of <math|m>. Define an augmented grading
  <math|i:<text|Crit><around|(|m|)>\<rightarrow\>\<bbb-Z\>> by

  <\equation*>
    i<around|(|w|)>\<assign\>i<rsub|S<rsub|L,f>><around|(|w|)>+i<rsub|m><around|(|w|)>,w=<around|(|q,\<eta\>|)>,
  </equation*>

  where <math|i<rsub|m><around|(|w|)>\<in\><around|{|0,1|}>> is the Morse
  index of <math|w>, seen as a critical point of <math|m>. Let
  Crit<math|<rsub|k><rsup|<around|(|a,b|)>><around|(|m,\<alpha\>|)>\<assign\><around|{|w\<in\><text|Crit><around|(|m|)>\<cap\><text|Crit><rsup|<around|(|a,b|)>><around|(|S<rsub|L,f>,\<alpha\>|)><space|0.17em>:<space|0.17em>i<around|(|w|)>=k|}>>.
  Given <math|k\<in\>\<bbb-Z\>>, let

  <\equation*>
    C*M<rsub|k><rsup|<around|(|a,b|)>><around|(|S<rsub|L,f>,\<alpha\>|)>\<assign\><text|Crit><rsub|k><rsup|<around|(|a,b|)>><around|(|m,\<alpha\>|)>\<otimes\>\<bbb-Z\><rsub|2>.
  </equation*>

  Fix a Riemannian metric <math|g<rsub|0>> on Crit<math|<around|(|\<ell\>|)>>
  for which the negative gradient flow <math|\<phi\><rsub|t><rsup|-\<nabla\>*m>>
  of <math|m> is Morse-Smale. Then up to a perturbation of the
  pseudo-gradient vector field <math|V> and the metric <math|g<rsub|0>>, we
  obtain a boundary operator

  <\equation*>
    \<partial\>:C*M<rsub|k><rsup|<around|(|a,b|)>><around|(|S<rsub|L,f>,\<alpha\>|)>\<rightarrow\>C*M<rsub|k-1><rsup|<around|(|a,b|)>><around|(|S<rsub|L,f>,\<alpha\>|)>
  </equation*>

  satisfying <math|\<partial\><rsup|2>=0>. We denote by
  <math|H*M<rsup|<around|(|a,b|)>><around|(|S<rsub|L,f>,\<alpha\>|)>> the
  homology of this chain complex. As our notation suggests, the homology is
  independent of the auxiliary choices we made when defining the chain
  complex and its boundary operator. The <with|font-series|bold|Morse
  homology theorem> tells us that there exists an isomorphism

  <\equation>
    \<theta\><rsup|<around|(|a,b|)>>:H*M<rsup|<around|(|a,b|)>><around|(|S<rsub|L,f>,\<alpha\>|)>\<rightarrow\>H<around|(|\<bbb-S\><rsub|\<alpha\>><rsup|b>,\<bbb-S\><rsub|\<alpha\>><rsup|a>|)>.<label|eq:morse
    homology iso>
  </equation>

  See <cite|AbbondandoloMajer2006|AbbondandoloSchwarz2009> for more details.

  <subsection|The Abbondandolo-Schwarz isomorphism>

  <vspace|6 pt>

  Fix <math|\<ell\>/2\<less\>a\<less\>b\<less\>\<infty\>> and
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>> such that
  <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>>. Both the Morse
  homology <math|H*M<rsup|<around|(|a,b|)>><around|(|S<rsub|L,f>,\<alpha\>|)>>
  and the Floer homology <math|H*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>>
  are defined. We now relate the two chain complexes via an
  \PAbbondandolo-Schwarz\Q chain map<footnote|The reader may wonder why we
  defy the standard alphabetical ordering naming convention here. This chain
  map is called ``<math|\<Phi\><rsub|<with|font-family|rm|S*A>>>'' because it
  goes from the chain complex of the ``<math|S>'' functional to the chain
  complex of the ``<math|A>'' functional. There is another chain map that
  goes the other way round; this one is denoted by
  ``<math|\<Phi\><rsub|<with|font-family|rm|A*S>>>'' See
  <cite-detail|AbbondandoloSchwarz2009|Section 7> or
  <cite-detail|Merry2010a|Theorem 5.1>. The chain map
  <math|\<Phi\><rsub|<with|font-family|rm|A*S>>> is not used in the present
  paper however. > <math|\<Phi\><rsub|<with|font-family|rm|S*A>><rsup|<around|(|a,b|)>>:C*M<rsup|<around|(|a,b|)>><around|(|S<rsub|L,f>,\<alpha\>|)>\<rightarrow\>C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>>.

  <\rem>
    In the discussion that follows for simplicity we will suppress the fact
    that we are in a Morse-Bott situation. In reality we need to consider
    flow lines with cascades in the construction below, and we need to choose
    the Morse functions <math|m> on <text|Crit><math|<around|(|S<rsub|L,f>|)>>
    and <math|h> on <text|Crit><math|<around|(|A<rsub|F,f>|)>> to satisfy
    certain compatibility conditions. This extra subtlety is dealt with fully
    in <cite|AbbondandoloSchwarz2009>, and there are no changes whatsoever in
    the present situation.

    This chain map <math|\<Phi\><rsub|<with|font-family|rm|S*A>><rsup|<around|(|a,b|)>>>
    is defined by counting solutions of the following mixed problem: Given a
    critical point <math|w> of <math|\<ell\>> and a critical point <math|v>
    of <math|h>, we consider the moduli space of maps
    <math|u=<around|(|x,\<eta\>|)>:<around|[|0,\<infty\>|)>\<rightarrow\><wide|\<Lambda\>|~>*T<rsup|\<ast\>>*M\<times\>\<bbb-R\>>
    that solve the Rabinowitz Floer equation
    <math|\<partial\><rsub|s>*u+\<nabla\>*A<rsub|F,f><around|(|u|)>=0> on
    <math|<around|(|0,\<infty\>|)>> and satisfy the boundary conditions (a)
    <math|lim<rsub|s\<rightarrow\>\<infty\>> u<around|(|s|)>=v> and (b)
    <math|<around|(|\<pi\>\<circ\>x<around|(|0|)>,\<eta\><around|(|0|)>|)>\<in\>W<rsup|u>*<around|(|w;-V|)>>.
    Lemma <reference|lem:key lemma-1>, together with its differential version
    allows one to prove the necessary compactness for such solutions. This
    method was invented by Abbondandolo and Schwarz in
    <cite|AbbondandoloSchwarz2006>, and extended to Rabinowitz Floer homology
    by the same authors in <cite|AbbondandoloSchwarz2009>. The upshot is the
    following theorem, whose proof involves no ideas not already present in
    either of the two aforementioned references, and thus will be omitted.
  </rem>

  <\thm>
    <label|thm:precise version of theorem e>There exists a chain complex
    isomorphism

    <\equation*>
      \<Phi\><rsub|<with|font-family|rm|<em|S*A>>><rsup|<around|(|a,b|)>>:C*M<rsup|<around|(|a,b|)>><around|(|S<rsub|L,f>,\<alpha\>|)>\<rightarrow\>C*F<rsup|<around|(|a,b|)>><around|(|A<rsub|F,f>,\<alpha\>|)>
    </equation*>

    of the form

    <\equation*>
      \<Phi\><rsub|<with|font-family|rm|<em|S*A>>><rsup|<around|(|a,b|)>>*w=<big|sum><rsub|v\<in\><with|font-family|rm|<em|C*r*i*t>><rsup|<around|(|a,b|)>><around|(|h,\<alpha\>|)>>n<rsub|<with|font-family|rm|<em|S*A>>><around|(|w,v|)>*v\<forall\>v\<in\><text|<em|Crit>><rsup|<around|(|a,b|)>><around|(|h,\<alpha\>|)>,
    </equation*>

    where <math|n<rsub|<with|font-family|rm|<em|S*A>>><around|(|w,v|)>\<in\>\<bbb-Z\><rsub|2>>
    is zero if <math|i<around|(|w|)>\<ne\>\<mu\><around|(|v|)>> or if
    <math|S<rsub|L,f><around|(|w|)>\<leq\>A<rsub|F,f><around|(|v|)>>, unless
    <math|v=\<cal-Z\><around|(|w|)>>, in which case
    <math|n<rsub|<with|font-family|rm|<em|S*A>>><around|(|w,\<cal-Z\><around|(|w|)>|)>=1>.
  </thm>

  Denote by <math|\<phi\><rsub|<with|font-family|rm|S*A>><rsup|<around|(|a,b|)>>=<around|[|\<Phi\><rsub|<with|font-family|rm|S*A>><rsup|<around|(|a,b|)>>|]>>
  the induced map on homology. The Abbondandolo-Schwarz map is functorial in
  the following sense. Fix <math|\<ell\>/2\<less\>a\<less\>b\<less\>\<infty\>>
  and <math|\<ell\>/2\<less\>c\<less\>d\<less\>\<infty\>>, such that
  <math|a\<leq\>c>, <math|b\<leq\>d>, and
  <math|a,b,c,d\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>>. Then the
  following diagram commutes, where the horizontal maps are all induced by
  inclusion, and <math|\<theta\><rsup|<around|(|a,b|)>>> denotes the
  isomorphism <eqref|eq:morse homology iso>,

  <\equation*>
    <\latex_preview|xymatrix>
      <\text>
        \\xymatrix{HF{}^{(a,b)}(A_{F,f},\\alpha)\\ar[r] &
        HF^{(c,d)}(A_{F,f},\\alpha)\\\\

        HM^{(a,b)}(S_{L,f},\\alpha)\\ar[r]\\ar[d]_{\\theta^{(a,b)}}\\ar[u]^{\\phi_{\\textrm{SA}}^{(a,b)}}
        & HM^{(c,d)}(S_{L,f},\\alpha)\\ar[d]^{\\theta^{(c,d)}}\\ar[u]_{\\phi_{\\textrm{SA}}^{(c,d)}}\\\\

        H(\\mathbb{S}_{\\alpha}^{b},\\mathbb{S}_{\\alpha}^{a})\\ar[r] &
        H(\\mathbb{S}_{\\alpha}^{d},\\mathbb{S}_{\\alpha}^{c})

        }
      </text>
    </latex_preview>
  </equation*>

  In order to fit in with our earlier notation <eqref|eq:the map Z-1>, let us
  denote by

  <\equation>
    <wide|Z|~><around|(|a,b|)>:H<around|(|\<bbb-S\><rsub|\<alpha\>><rsup|a>,\<bbb-S\><rsub|\<alpha\>><rsup|3*\<ell\>/4>|)>\<rightarrow\>H*<around|(|\<Lambda\><rsub|\<alpha\>>*M\<times\>\<bbb-R\>,\<bbb-S\><rsub|\<alpha\>><rsup|b>|)>,<label|eq:the
    map Z>
  </equation>

  the map on singular homology induced from inclusion. As before
  <math|<wide|Z|~><around|(|a,b|)>=0> if <math|a\<less\>b>.

  Anyway, passing to the direct limit, we conclude the following result,
  which is the main one of this section.

  <\thm>
    <label|thm:computation in the convex case>In the situation above one has:

    <\enumerate>
      <item><math|H*F<rsup|<around|(|3*\<ell\>/4,\<infty\>|)>><around|(|A<rsub|F,f>,\<alpha\>|)>\<cong\><choice|<tformat|<table|<row|<cell|H*<around|(|\<Lambda\><rsub|\<alpha\>>*M|)>>|<cell|\<alpha\>\<ne\>0,>>|<row|<cell|H*<around|(|\<Lambda\><rsub|0>*M,M|)>>|<cell|\<alpha\>=0.>>>>>>

      <item>Suppose <math|a,b\<gtr\>3*\<ell\>/4> with
      <math|a,b\<nin\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>>. Then it
      holds that

      <multline*|<tformat|<table|<row|<cell|<text|<em|rank>><around*|{|Z<around|(|a,b|)>:H*F<rsup|<around|(|3*\<ell\>/4,a|)>><around|(|A<rsub|F,f>,\<alpha\>|)>\<rightarrow\>H*F<rsub|\<nosymbol\>><rsup|<around|(|b,\<infty\>|)>><around|(|A<rsub|F,f>,\<alpha\>|)>|}>=>>|<row|<cell|<text|<em|rank>><around*|{|<wide|Z|~><around|(|a,b|)>:H<around|(|\<bbb-S\><rsub|\<alpha\>><rsup|a>,\<bbb-S\><rsub|\<alpha\>><rsup|3*\<ell\>/4>|)>\<rightarrow\>H*<around|(|\<Lambda\><rsub|\<alpha\>>*M\<times\>\<bbb-R\>,\<bbb-S\><rsub|\<alpha\>><rsup|b>|)>|}>.>>>>>
    </enumerate>
  </thm>

  <section|Proof of Theorem A><label|sec:Proof-of-Theorem A>

  In this section we complete the proof of Theorem A from the Introduction.
  To begin with however we introduce the following definition.

  <\defn>
    Given a starshaped hypersurface <math|\<Sigma\>\<subseteq\>T<rsup|\<ast\>>*M>,
    <math|T\<gtr\>0> and <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>,
    define

    <\equation*>
      \<delta\><around|(|\<Sigma\>,T,\<alpha\>|)>\<assign\>inf
      <around*|{|<around*|\||T<rprime|'>-T<rprime|''>|\|><space|0.17em>:<space|0.17em>T<rprime|'>\<ne\>T<rprime|''>,T<rprime|'>,T<rprime|''>\<in\>\<cal-A\><around|(|\<Sigma\>,\<alpha\>|)>\<cap\><around|[|0,T|]>|}>.
    </equation*>

    If <math|\<Sigma\>> is non-degenerate then
    <math|\<delta\><around|(|\<Sigma\>,T,\<alpha\>|)>\<gtr\>0> for every
    (finite) <math|T\<gtr\>0> and <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>.
  </defn>

  We now proceed with the proof of Theorem A. Let <math|\<Sigma\>> denote a
  non-degenerate fibrewise starshaped hypersurface. Let <math|g> denote a
  <with|font-series|bold|bumpy >Riemannian metric on <math|M> such that the
  unit disc bundle <math|D*<around|(|S<rsub|g><rsup|\<ast\>>*M|)>> is
  contained in <math|D<rsup|\<circ\>><around|(|\<Sigma\>|)>>, and let us
  denote by <math|F<rsub|g>:T<rsup|\<ast\>>*M\<rightarrow\>\<bbb-R\>> the
  Hamiltonian

  <\equation>
    F<rsub|g><around|(|q,p|)>\<assign\><frac|1|2>*<around*|(|<around*|\||p|\|><rsub|g><rsup|2>-1|)>.<label|eq:the
    ham fg>
  </equation>

  Asking <math|g> to be bumpy is equivalent to asking that
  <math|S<rsub|g><rsup|\<ast\>>*M=F<rsub|g><rsup|-1><around|(|0|)>> is
  non-degenerate in the sense of Definition <reference|def:non degen>. A
  theorem of Abraham <cite|Abraham1970> (first properly proved by Anosov in
  <cite|Anosov1982>) states that the set <math|\<cal-R\><rsub|<with|font-family|rm|b*u*m*p*y>><around|(|M|)>>
  of all bumpy Riemannian metrics on <math|M> is a residual subset of the set
  <math|\<cal-R\><around|(|M|)>> of all Riemannian metrics on <math|M>, so
  such metrics certainly exist<footnote|Note that this result does
  <with|font-series|bold|not >follow from Theorem <reference|thm:nondeg is
  generic> stated above.>.

  <rem|The point of choosing such a metric <math|g> comes down to the fact
  that we can compute the Floer homology <math|H*F<rsup|<around|(|a,\<infty\>|)>><around|(|A<rsub|F<rsub|g>,f>,\<alpha\>|)>>
  (see Theorem <reference|thm:computation in the convex case> above). Since
  we proved Theorem <reference|thm:computation in the convex case> for any
  strictly fibrewise convexnon-degenerate fibrewise starshaped hypersurface
  <math|S>, we could equally well work with such any such hypersurface
  <math|S> satisfying <math|D<around|(|S|)>\<subseteq\>D<rsup|\<circ\>><around|(|\<Sigma\>|)>>
  rather than a unit cotangent bundle. However for aesthetic reasons we
  prefer to work with a unit contangent bundle, even if it means quoting the
  bumpy metric theorem.>

  Recall that <math|\<cal-G\><around|(|\<Sigma\>|)>\<subseteq\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>
  denotes the generic subset of Hamiltonian diffeomorphisms <math|\<varphi\>>
  with no periodic leaf-wise intersection points (cf. Proposition
  <reference|prop:-generically no plwip>).

  <defn|<label|what we prove theorem a for>Let
  <math|\<cal-O\><around|(|\<Sigma\>|)>\<subseteq\>\<cal-G\><around|(|\<Sigma\>|)>>
  denote the set of Hamiltonian diffeomorphisms
  <math|\<varphi\>\<ne\><with|math-font|Bbb|1>> such that there exists
  <math|H\<in\>\<cal-R\><around|(|\<Sigma\>|)>\<subseteq\>\<cal-H\>> (cf.
  Definition <reference|def:non degen for H>) that generates
  <math|\<varphi\>>. Since <math|\<cal-G\><around|(|\<Sigma\>|)>> is a
  generic subset of <text|Ham><math|<rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>
  and <math|\<cal-R\><around|(|\<Sigma\>|)>> is a generic subset of
  <math|\<cal-H\>>, <math|\<cal-O\><around|(|\<Sigma\>|)>> is a generic
  subset of <text|Ham><math|<rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>.>

  We will prove Theorem A for Hamiltonian diffeomorphisms
  <math|\<varphi\>\<in\>\<cal-O\><around|(|\<Sigma\>|)>>.

  <subsubsection*|Proof of Theorem A>

  <vspace|6 pt>

  Let <math|\<phi\><rsub|t><rsup|Y>> denote the flow of the Liouville vector
  field <math|Y>. Given <math|t\<gtr\>0> let
  <math|<around|(|S<rsub|g><rsup|\<ast\>>*M|)><rsub|t>\<assign\>\<phi\><rsub|t><rsup|Y>*<around|(|S<rsub|g><rsup|\<ast\>>*M|)>>,
  so that <math|<around|(|<around|(|S<rsub|g><rsup|\<ast\>>*M|)><rsub|t>|)><rsub|t\<geq\>0>>
  forms<footnote|Technically speaking this not quite the same as a concentric
  family as defined in Section <reference|sub:Monotone-homotopies-and>, as
  the hypersurfaces get larger as <math|t> increases, not smaller.> a
  concentric family in the language of Section
  <reference|sub:Monotone-homotopies-and>. Note that if

  <\equation*>
    F<rsub|g><rsup|t><around|(|q,p|)>\<assign\><frac|1|2>*<around*|(|<around*|\||p|\|><rsup|2>-e<rsup|2*t>|)>,
  </equation*>

  then <math|F<rsub|g><rsup|t>\<in\>\<cal-D\><around|(|<around|(|S<rsub|g><rsup|\<ast\>>*M|)><rsub|t>|)>>,
  and <math|<around|(|F<rsub|g><rsup|t>|)><rsub|t\<geq\>0>> satisfies
  <math|\<partial\><rsub|t>*F<rsub|g><rsup|t>\<leq\>0>.

  Let us now fix <math|\<varphi\>\<in\>\<cal-O\><around|(|\<Sigma\>|)>> and
  <math|\<alpha\>\<in\><around|[|S<rsup|1>,M|]>>. Choose <math|s\<gtr\>0>
  such that <math|D<around|(|\<Sigma\>|)>\<subseteq\>D<rsup|\<circ\>><around|(|<around|(|S<rsub|g><rsup|\<ast\>>*M|)><rsub|s>|)>>
  and such that

  <\equation*>
    0\<less\>e<rsup|-s>*<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>\<less\><frac|1|2>*\<ell\>*<around|(|S<rsub|g><rsup|\<ast\>>*M,\<alpha\>|)>.
  </equation*>

  Recall we defined the quantity <math|\<mu\><around|(|\<varphi\>|)>=2*\<kappa\><around|(|\<varphi\>|)>+6<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>>
  in <eqref|eq:mu phi>, where <math|\<kappa\><around|(|\<varphi\>|)>> was
  defined in <eqref|eq:kappaphi>, and the Hofer norm
  <math|<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>> was defined in
  <eqref|eq:hofer norm>. Recall also from the Introduction that for any
  <math|H\<in\>C<rsub|c><rsup|\<infty\>>*<around|(|S<rsup|1>\<times\>T<rsup|\<ast\>>*M,\<bbb-R\>|)>>,
  the value of <math|\<kappa\><around|(|H|)>> (cf. Definition
  <reference|Define-a-semi-norm>) depends only on
  <math|\<phi\><rsub|1><rsup|H>\<in\><text|Ham><rsub|c><around|(|T<rsup|\<ast\>>*M,\<omega\>|)>>.

  Now fix <math|T\<gtr\>0> such that

  <\equation*>
    e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>\<gtr\>2*\<mu\><around|(|\<varphi\>|)>.
  </equation*>

  Next we will some choose <math|H\<in\>\<cal-R\><around|(|\<Sigma\>|)>>
  generating <math|\<varphi\>> with <math|<around*|\<\|\|\>|H|\<\|\|\>>-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>>
  sufficiently small. More precisely, we first ask that
  <math|<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>\<geq\><frac|5|6><around*|\<\|\|\>|H|\<\|\|\>>>,
  and then in addition that

  <\equation>
    0\<leq\>e<rsup|-s>*<around|(|<around*|\<\|\|\>|H|\<\|\|\>>-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>\<leq\>min
    <around*|{|<frac|1|2>*\<ell\>*<around|(|S<rsub|g><rsup|\<ast\>>*M,\<alpha\>|)>,\<delta\>*<around|(|S<rsub|g><rsup|\<ast\>>*M,\<alpha\>,e<rsup|-s>*T|)>,\<mu\><around|(|\<varphi\>|)>|}>.<label|eq:smallness
    condition>
  </equation>

  Set

  <\equation*>
    \<ell\>\<assign\>min <around*|{|\<ell\><around|(|\<Sigma\>|)>,e<rsup|-s>*\<ell\>*<around|(|S<rsub|g><rsup|\<ast\>>*M|)>|}>
  </equation*>

  and choose

  <\equation*>
    f\<in\><big|cap><rsub|r\<gtr\>0>\<cal-F\><around*|(|<frac|\<ell\>|12>,r|)>.
  </equation*>

  Finally choose <math|F\<in\>\<cal-D\><around|(|\<Sigma\>|)>> and
  <math|\<chi\>\<in\>\<cal-X\><rsub|0>>. Set

  <\equation*>
    \<frak-f\>\<assign\><around|(|F,f,\<chi\>,H|)>,\<frak-g\>\<assign\><around|(|F,f,\<chi\>,0|)>,\<frak-h\>\<assign\><around|(|F,f,1,0|)>,
  </equation*>

  <\equation*>
    \<frak-i\>\<assign\><around|(|F<rsub|g>,f,1,0|)>,\<frak-j\>\<assign\><around|(|F<rsub|g><rsup|s>,f,1,0|)>.
  </equation*>

  We will tacitly assume that all the action values
  <math|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>,T-<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>,\<mu\><around|(|\<varphi\>|)>,T>
  that appear in the diagram below do not lie in the relevant action
  spectrums, so that all the Floer homology groups are well defined. We now
  splice together the various commutative diagrams from Section
  <reference|sec:Continuation-homomorphisms> to create one big commutative
  diagram (we omit all the <math|\<alpha\>>'s for clarity):

  <\equation*>
    <tformat|<table|<row|<cell|<xymatrix@C>=6*p*t>|<cell|>|<cell|H*F<rsup|<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>,T-<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>|)>><around|(|A<rsub|\<frak-f\>>|)><ar*|d>>>|<row|<cell|>|<cell|H*F<rsub|\<nosymbol\>><rsup|<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>>,T-<around*|\<\|\|\>|H|\<\|\|\>>|)>><around|(|A<rsub|\<frak-g\>>|)><ar*|r><ar*|u*r><ar*|d><rsub|\<cong\>>>|<cell|H*F<rsup|<around|(|\<mu\><around|(|\<varphi\>|)>,T|)>><around|(|A<rsub|\<frak-g\>>|)><ar*|d><rsup|\<cong\>>>>|<row|<cell|H*F<rsup|<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>>,\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>>|)>><around|(|A<rsub|\<frak-j\>>|)><ar*|r><ar*|d><rsub|\<theta\>>>|<cell|H*F<rsub|\<nosymbol\>><rsup|<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>>,T-<around*|\<\|\|\>|H|\<\|\|\>>|)>><around|(|A<rsub|\<frak-h\>>|)><ar*|r><ar*|d>>|<cell|H*F<rsup|<around|(|\<mu\><around|(|\<varphi\>|)>,T|)>><around|(|A<rsub|\<frak-h\>>|)><ar*|d>>>|<row|<cell|H*F<rsup|<around|(|e<rsup|-s>*<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>>|)>,e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|H|\<\|\|\>>|)>|)>><around|(|A<rsub|\<frak-i\>>|)><ar*|r><ar*|d*r*r><rsub|Z>>|<cell|H*F<rsup|<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>>,T-<around*|\<\|\|\>|H|\<\|\|\>>|)>><around|(|A<rsub|\<frak-i\>>|)><ar*|r>>|<cell|H*F<rsub|\<nosymbol\>><rsup|<around|(|\<mu\><around|(|\<varphi\>|)>,T|)>><around|(|A<rsub|\<frak-i\>>|)><ar*|d><rsup|\<iota\>>>>|<row|<cell|>|<cell|>|<cell|H*F<rsub|\<nosymbol\>><rsup|<around|(|\<mu\><around|(|\<varphi\>|)>,\<infty\>|)>><around|(|A<rsub|\<frak-i\>>|)>>>>>
  </equation*>

  <no-indent>

  <\left-aligned>
    Here the top right-hand triangle is the commutative diagram from Lemma
    <reference|lem:continutations with H>. For this to be well defined recall
    we needed

    <\equation*>
      2<around*|\<\|\|\>|H|\<\|\|\>>+\<kappa\><around|(|H|)>\<leq\>\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>,
    </equation*>

    and this is guaranteed by our requirement that
    <math|<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>\<geq\><frac|5|6><around*|\<\|\|\>|H|\<\|\|\>>>.
    The square below comes from Lemma <reference|lem:chi>; the vertical maps
    are isomorphisms. The map <math|\<theta\>> on the left-hand side is the
    map from Proposition <reference|prop:staircase>; thus <math|\<theta\>> is
    an isomorphism. The map <math|\<iota\>> in the bottom right is the map
    <eqref|eq:iota>. Note that by <eqref|eq:smallness condition> one has

    <align*|<tformat|<table|<row|<cell|H*F<rsup|<around|(|e<rsup|-s>*<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>>|)>,e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|H|\<\|\|\>>|)>|)>><around|(|A<rsub|\<frak-i\>>,\<alpha\>|)>>|<cell|\<cong\>H*F<rsup|<around|(|3*\<ell\>/4,e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|H|\<\|\|\>>|)>|)>><around|(|A<rsub|\<frak-i\>>,\<alpha\>|)>>>|<row|<cell|>|<cell|\<cong\>H*F<rsub|\<nosymbol\>><rsup|<around|(|3*\<ell\>/4,e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>|)>><around|(|A<rsub|\<frak-i\>>,\<alpha\>|)>.>>>>>

    Thus the diagonal map <math|Z> at the bottom of the diagram is the map

    <\equation*>
      Z*<around|(|e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>,\<mu\><around|(|\<varphi\>|)>|)>:H*F<rsub|\<nosymbol\>><rsup|<around|(|3*\<ell\>/4,e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>|)>><around|(|A<rsub|\<frak-i\>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|\<mu\><around|(|\<varphi\>|)>,\<infty\>|)>><around|(|A<rsub|\<frak-i\>>,\<alpha\>|)>
    </equation*>

    from <eqref|eq:the map Z-1>. Since <math|\<theta\>> and the two vertical
    maps in the top-most square are isomorphisms, we can read off from the
    diagram (see Corollary <reference|cor:lw bound>) that

    <align*|<tformat|<table|<row|<cell|n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,T|)>>|<cell|\<geq\>n<rsub|\<Sigma\>,\<alpha\>><around|(|\<varphi\>,<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>,T-<around*|\<\|\|\>|H|\<\|\|\>><rsub|+>|)>|)>>>|<row|<cell|>|<cell|\<geq\><text|rank><around*|{|H*F<rsub|\<nosymbol\>><rsup|<around|(|\<mu\><around|(|\<varphi\>|)>-<around*|\<\|\|\>|H|\<\|\|\>>,T-<around*|\<\|\|\>|H|\<\|\|\>>|)>><around|(|A<rsub|\<frak-g\>>,\<alpha\>|)>\<rightarrow\>H*F<rsup|<around|(|\<mu\><around|(|\<varphi\>|)>,T|)>><around|(|A<rsub|\<frak-g\>>,\<alpha\>|)>|}>>>|<row|<cell|>|<cell|\<geq\><text|rank><space|0.17em>Z*<around|(|e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>,\<mu\><around|(|\<varphi\>|)>|)>.>>>>>

    By Theorem <reference|thm:computation in the convex case>, we have

    <\equation*>
      <text|rank><space|0.17em>Z*<around|(|e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>,\<mu\><around|(|\<varphi\>|)>|)>=<text|rank><space|0.17em><wide|Z|~><around|(|e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>,\<mu\><around|(|\<varphi\>|)>|)>,
    </equation*>

    where <math|<wide|Z|~><around|(|e<rsup|-s>*<around|(|T-<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>|)>,\<mu\><around|(|\<varphi\>|)>|)>>
    is the map <eqref|eq:the map Z>. Here the relevant free time action
    functional is defined using the Lagrangian
    <math|L<rsub|g>:T*M\<rightarrow\>\<bbb-R\>>, which by definition is the
    Fenchel transform of the Hamiltonian <math|F<rsub|g>> from <eqref|eq:the
    ham fg>, and is given by <math|L<rsub|g><around|(|q,v|)>\<assign\><frac|1|2>*<around*|(|<around*|\||v|\|><rsub|g><rsup|2>+1|)>>.
  </left-aligned>

  <no-indent>

  <\left-aligned>
    Recall we denote by <math|\<cal-E\><rsub|g>:\<Lambda\>*M\<rightarrow\>\<bbb-R\>>
    the functional <math|\<cal-E\><rsub|g><around|(|q|)>\<assign\><big|int><rsub|0><rsup|1><frac|1|2><around*|\||<wide|q|\<dot\>>|\|><rsub|g><rsup|2>*d*t>,
    and that we use the special notation

    <\equation*>
      \<Lambda\><rsub|\<alpha\>><rsup|a><around|(|M,g|)>\<assign\><around*|{|q\<in\>\<Lambda\><rsub|\<alpha\>>*M<space|0.17em>:<space|0.17em>\<cal-E\><rsub|g><around|(|q|)>\<leq\><frac|1|2>*a<rsup|2>|}>.
    </equation*>

    Denote by <text|pr><math|<rsub|1>:\<Lambda\>*M\<times\>\<bbb-R\>\<rightarrow\>\<Lambda\>*M>
    the first projection, and given <math|a\<in\>\<bbb-R\>> denote by
    <math|i<rsub|a>:\<Lambda\>*M\<rightarrow\>\<Lambda\>*M\<times\>\<bbb-R\>>
    the map <math|i<rsub|a><around|(|q|)>\<assign\><around|(|q,a|)>>. We
    complete the proof of Theorem A with the following elementary
    observation.
  </left-aligned>

  <\lem>
    <no-indent>

    <\left-aligned>
      Suppose <math|a,b\<gtr\>3*\<ell\>/4>. <with|font-shape|right|<em|Then
      if <math|<wide|Z|~><around|(|a,b|)>> denotes the map <eqref|eq:the map
      Z> then it holds that >>

      <multline*|<tformat|<table|<row|<cell|<text|<em|rank>><around*|{|<wide|Z|~><around|(|a,b|)>:H<around|(|\<bbb-S\><rsub|\<alpha\>><rsup|a>,\<bbb-S\><rsub|\<alpha\>><rsup|3*\<ell\>/4>|)>\<rightarrow\>H*<around|(|\<Lambda\><rsub|\<alpha\>>*M\<times\>\<bbb-R\>,\<bbb-S\><rsub|\<alpha\>><rsup|b>|)>|}>\<geq\>>>|<row|<cell|<text|<em|rank>><around*|{|\<iota\>:H<around|(|\<Lambda\><rsub|\<alpha\>><rsup|a><around|(|M,g|)>,\<Lambda\><rsub|\<alpha\>><rsup|3*\<ell\>/4><around|(|M,g|)>|)>\<rightarrow\>H*<around|(|\<Lambda\><rsub|\<alpha\>>*M,\<Lambda\><rsub|\<alpha\>><rsup|2*b><around|(|M,g|)>|)>|}>.>>>>>
    </left-aligned>
  </lem>

  <\proof>
    <no-indent>

    <\left-aligned>
      We first show that for any <math|c\<geq\>3*\<ell\>/4> (we will apply
      this with <math|c=3*\<ell\>/4> and <math|c=a>) we have

      <\equation*>
        i<rsub|c><around*|(|\<Lambda\><rsub|g><rsup|c><around|(|M,g|)>|)>\<subseteq\>\<bbb-S\><rsub|\<alpha\>><rsup|c>.
      </equation*>

      Indeed, for any <math|\<eta\>\<geq\>c> one has

      <\equation*>
        S<rsub|L<rsub|g>,f><around|(|q,\<eta\>|)>=<frac|1|\<eta\>>*\<cal-E\><rsub|g><around|(|q|)>+<frac|\<eta\>|2>,
      </equation*>

      and hence

      <\equation*>
        S<rsub|L<rsub|g>,f><around|(|i<rsub|c><around|(|q|)>|)>=<frac|1|c>*\<cal-E\><rsub|g><around|(|q|)>+<frac|c|2>\<leq\><frac|1|c>\<cdot\><frac|1|2>*c<rsup|2>+<frac|c|2>=c.
      </equation*>

      Secondly we claim that

      <\equation*>
        <text|pr><rsub|1><around*|(|\<bbb-S\><rsub|\<alpha\>><rsup|a>|)>\<subseteq\>\<Lambda\><rsub|\<alpha\>><rsup|2*a><around|(|M,g|)>.
      </equation*>

      To see this, note that in general <math|S<rsub|L<rsub|g>,f><around|(|q,\<eta\>|)>=<frac|1|f<around|(|\<eta\>|)>>*\<cal-E\><rsub|g><around|(|q|)>+<frac|f<around|(|\<eta\>|)>|2>>,
      and thus if <math|S<rsub|L<rsub|g>,f><around|(|q,\<eta\>|)>\<leq\>a>
      then as <math|<frac|1|f<around|(|\<eta\>|)>>*\<cal-E\><rsub|g><around|(|q|)>\<geq\>0>
      we have <math|f<around|(|\<eta\>|)>\<leq\>2*a>, and hence

      <\equation*>
        \<cal-E\><rsub|g><around|(|q|)>=f<around|(|\<eta\>|)>*<around*|(|S<rsub|L<rsub|g>,f><around|(|q,\<eta\>|)>-<frac|f<around|(|\<eta\>|)>|2>|)>\<leq\>2*a*<around|(|a-0|)>=2*a<rsup|2>.
      </equation*>

      The result now follows from the observation that

      <\equation*>
        <text|rank><space|0.17em><wide|Z|~><around|(|a,b|)>\<geq\><text|rank><space|0.17em><around|(|<around|(|<text|pr><rsub|1>|)><rsub|\<ast\>>\<circ\><wide|Z|~><around|(|a,b|)>\<circ\><around|(|i<rsub|a>|)><rsub|\<ast\>>|)>.
      </equation*>
    </left-aligned>
  </proof>

  <\bibliography|bib|amsplain|C:/Users/Will/Desktop/willbibtex>
    <bib-list|[99]|>
  </bibliography>
</body>