<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <\hide-preamble>
    <assign|R|<macro|\<bbb-R\>>>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|Q|<macro|\<bbb-Q\>>>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|T|<macro|\<bbb-T\>>>

    <assign|cT|<macro|\<bbb-T\>>>

    <assign|bA|<macro|<math-bf|A>>>

    <assign|bP|<macro|<math-bf|P>>>

    <assign|bQ|<macro|<math-bf|Q>>>

    <assign|bT|<macro|<math-bf|T>>>

    <assign|bX|<macro|<math-bf|X>>>

    <assign|W|<macro|\<cal-W\>>>

    <assign|A|<macro|\<cal-A\>>>

    <assign|B|<macro|\<cal-B\>>>

    <assign|C|<macro|\<cal-C\>>>

    <assign|cL|<macro|\<cal-L\>>>

    <assign|M|<macro|\<cal-M\>>>

    <assign|cH|<macro|\<cal-H\>>>

    <assign|cP|<macro|\<cal-P\>>>

    <assign|cS|<macro|\<cal-S\>>>

    <assign|V|<macro|\<cal-V\>>>

    <assign|F|<macro|\<cal-F\>>>

    <assign|G|<macro|\<cal-G\>>>

    <assign|Cech|<macro|ech >>

    <assign|vp|<macro|\<varphi\>>>

    <assign|tv|<macro|<wide|\<varphi\>|~>>>

    <assign|tA|<macro|<wide|<A>|~>>>

    <assign|tT|<macro|<wide|T|~>>>

    <assign|torus|<macro|<wide|<T>|^><rsup|d>>>

    <assign|tf|<macro|<wide|f|~>>>

    <assign|hf|<macro|<wide|f|^>>>

    <assign|td|<macro|1|<wide|<arg|1>|~>>>

    <assign|ov|<macro|1|<wide|<arg|1>|\<bar\>>>>

    <assign|Lim|<macro|<varprojlim>>>

    <assign|dlim|<macro|<varinjlim>>>

    <assign|OP|<macro|\<Omega\><rsub|\<Phi\>>>>

    <assign|larr|<macro|<left|(> <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|>>>>>>>

    <\assign|rarr>
      <\macro>
        <right|)>
      </macro>
    </assign>

    <assign|AA|<macro|p'(\<lambda\>)>>

    <assign|ie|<macro|<with|font-shape|italic|i.e.,> >>

    <assign|eg|<macro|<with|font-shape|italic|e.g.> >>

    <assign|lsqarr|<macro|<left|[> <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|>>>>>>>

    <\assign|rsqarr>
      <\macro>
        <right|]>
      </macro>
    </assign>

    <assign|seabox|<macro|<frame|<math|\<searrow\>>>>>

    <assign|neabox|<macro|<frame|<math|\<nearrow\>>>>>

    <assign|swabox|<macro|<frame|<math|\<swarrow\>>>>>

    <assign|nwabox|<macro|<frame|<math|\<nwarrow\>>>>>

    <assign|arrow|<macro|\<rightarrow\>>>

    <assign|larrow|<macro|\<leftarrow\>>>

    <assign|inv|<macro|<varprojlim>>>

    <assign|dir|<macro|<varinjlim>>>

    <assign|coker|<macro|<with|font-family|rm|coker>>>

    <assign|rank|<macro|<with|font-family|rm|rank>>>

    <assign|vert|<macro|<with|font-family|rm|vert>>>

    <assign|proj|<macro|<with|font-family|rm|proj>>>

    <new-theorem|theorem|Theorem>

    <new-theorem|definition|Definition>

    <new-theorem|lemma|Lemma>

    <new-theorem|corollary|Corollary>

    <new-theorem|proposition|Proposition>

    <new-theorem|theorem|Theorem>

    <new-theorem|Theorem|Theorem>

    <new-theorem|cor|Corollary>

    <new-theorem|definition|Definition>

    <new-theorem|corollary|Corollary>

    <new-theorem|lemma|Lemma>

    <new-theorem|prop|Proposition>

    <new-theorem|example|Example>

    <assign|proofof|<macro|1|body|<\surround|<vspace|1fn><no-indent><with|font-shape|italic|Proof
    of <arg|1>>.|<htab|0pt><math|\<Box\>><next-line>>
      <arg|body>
    </surround>>>
  </hide-preamble>

  <doc-data|<doc-title|Asymptotic structure in substitution tiling
  spaces>|<doc-author|<author-data|<author-name|Marcy<nbsp>Barge and Carl
  Olimb>>>>

  <abstract-data|<abstract-msc|Primary: 37B50| 54H20| Secondary: 11R06|
  37B10| 55N05| 55N35| 52C23.>|<abstract-keywords|tiling space| Pisot
  substitution| expansive action>|<\abstract>
    Every sufficiently regular space of tilings of <math|<R><rsup|d>> has at
    least one pair of distinct tilings that are asymptotic under translation
    in all the directions of some open <math|(d-1)>-dimensional hemisphere.
    If the tiling space comes from a substitution, there is a way of defining
    a location on such tilings at which asymptoticity `starts'. This leads to
    the definition of the <with|font-shape|italic|branch locus> of the tiling
    space: this is a subspace of the tiling space, of dimension at most
    <math|d-1>, that summarizes the `asymptotic in at least a half-space'
    behavior in the tiling space. We prove that if a <math|d>-dimensional
    self-similar substitution tiling space has a pair of distinct tilings
    that are asymptotic in a set of directions that contains a closed
    <math|(d-1)>-hemisphere in its interior, then the branch locus is a
    topological invariant of the tiling space. If the tiling space is a
    2-dimensional self-similar Pisot substitution tiling space, the branch
    locus has a description as an inverse limit of an expanding Markov map on
    a 1-dimensional simplicial complex.
  </abstract>>

  <section|Introduction><label|sec:intro>

  Tilings of <math|<R><rsup|d>>, and the tiling spaces associated with them,
  play a fundamental role in recent investigations in number theory, physics,
  logic, computer science, and dynamical systems. For a given tiling <math|T>
  of <math|<R><rsup|d>>, one would like to understand the recurrence
  properties of the various patterns made by the tiles of <math|T>. These
  properties are encoded in the topology of the tiling space <math|\<Omega\>>
  associated with <math|T> and in the dynamics of the action of
  <math|<R><rsup|d>> by translation on <math|\<Omega\>>. Under standard
  assumptions on the nature of <math|T>, the space <math|\<Omega\>> is
  locally homeomorphic with a product of a <math|d>-dimensional disk and a
  Cantor set, the arc-components of <math|\<Omega\>> coincide with the orbits
  of the <math|<R><rsup|d>>-action, and recurrences of patterns in a tiling
  correspond to returns under the <math|<R><rsup|d>>-action to local
  neighborhoods.

  We are interested here in the <with|font-shape|italic|asymptotics> of the
  translation action on tiling spaces. We will put sufficient conditions on
  the tilings we consider so that the associated tiling spaces are compact
  metric spaces: under the metric, <math|d>, two tilings are close if a small
  translate of one agrees with the other in a large neighborhood of the
  origin. Tilings <math|T,T<rprime|'>\<in\>\<Omega\>> are then asymptotic in
  direction <math|v\<in\>\<bbb-S\><rsup|d-1>> if
  <math|d*<around|(|T-t*v,T<rprime|'>-t*v|)>\<to\>0> as
  <math|t\<to\>\<infty\>>. We prove under rather general hypotheses that
  there are <math|T\<ne\>T<rprime|'>\<in\>\<Omega\>> that are asymptotic in
  an entire open hemisphere's worth of directions. To say more, we must
  restrict a bit.

  There are three common procedures for constructing tilings of
  <math|<R><rsup|d>>: cut-and-project; matching rules; and substitutions.
  With the cut-and-project method, the asymptotic tilings and directions can
  be immediately deduced from the geometry of the boundary of the defining
  window (see, for example, <cite|FHK>). Global properties of matching rule
  tilings are, on the other hand, very difficult to ascertain - unless the
  rules enforce the sort of hierarchical structure enjoyed by substitution
  tilings (see <cite|M>, <cite|G-S>). We are thus led to consider
  substitutions <math|\<Phi\>> and their associated tiling spaces
  <math|<OP>>.

  A substitution <math|\<Phi\>> induces a self-map, also denoted by
  <math|\<Phi\>>, of <math|<OP>>. This will, among other things, provide a
  way of pinning down a specific location for the start of asymptoticity. For
  example, in the one-dimensional (<math|d=1>) case, there are a finite and
  non-zero number of asymptotic <math|<R>>-orbits (at most <math|n<rsup|2>>
  if there are <math|n> distinct tiles - see <cite|BDH>). Each of these
  orbits contains a unique tiling that is periodic under <math|\<Phi\>> and
  we may reasonably designate these <math|\<Phi\>>-periodic,
  <math|<R>>-asymptotic, orbits as the exact locations on their
  arc-components where asymptoticity starts. Let us say this more precisely.
  If <math|T\<ne\>T<rprime|'>\<in\>\<Omega\>> are such that
  <math|d*<around|(|T-t,T<rprime|'>-t|)>\<to\>0> as <math|t\<to\>\<infty\>>
  (or as <math|t\<to\>-\<infty\>>), then there is a unique
  <math|t<rsub|0>\<in\><R>> so that, if <math|T<rsub|0>\<assign\>T-t<rsub|0>>
  and <math|T<rprime|'><rsub|0>\<assign\>T<rprime|'>-t<rsub|0>>, then
  <math|T<rsub|0>> and <math|T<rprime|'><rsub|0>> are
  <math|\<Phi\>>-periodic. Moreover, <math|T<rsub|0>\<nin\>W<rsup|s><around|(|T<rprime|'><rsub|0>|)>>
  and <math|T<rsub|0>-t\<in\>W<rsup|s>*<around|(|T<rprime|'><rsub|0>-t|)>>
  for all <math|t\<gtr\>0> (resp., <math|t\<less\>0>), where <math|W<rsup|s>>
  denotes the <math|\<Phi\>>-stable `manifold'. This choice for initial point
  of asymptoticity is made less arbitrary by the rigidity result of
  <cite|BS>: if <math|<OP>> and <math|\<Omega\><rsub|\<Psi\>>> are
  homeomorphic one-dimensional substitution tiling spaces, then there is a
  homeomorphism of <math|<OP>> with <math|\<Omega\><rsub|\<Psi\>>> that not
  only conjugates the <math|<R>>-actions (perhaps with rescaling), but also
  conjugates some power of <math|\<Phi\>> with a power of <math|\<Psi\>> and
  hence takes <math|\<Phi\>>-periodic orbits to <math|\<Psi\>>-periodic
  orbits. Thus, the finite collection of <with|font-shape|italic|asymptotic
  pairs> <math|<around|{|<around|(|T<rsub|0>,T<rsub|0><rprime|'>|)>|}>>, as
  above, is a topological invariant for <math|<OP>>. (A complete topological
  invariant for one-dimensional substitution tiling spaces is derived from
  asymptotic pairs in <cite|BD1> and their connection with the Matsumoto
  <math|K<rsub|0>>-group is explored in <cite|BDS>.)

  In this article we extend the one-dimensional results to higher dimensional
  substitution tiling spaces. We will call a pair of tilings
  <math|<around|(|T,T<rprime|'>|)>\<in\><OP>\<times\><OP>> a
  <with|font-shape|italic|branch pair> if
  <math|T\<nin\>W<rsup|s><around|(|T<rprime|'>|)>> and there is an open
  hemisphere <math|H\<subset\>\<bbb-S\><rsup|d-1>> so that
  <math|T-t*v\<in\>W<rsup|s>*<around|(|T<rprime|'>-t*v|)>> for all
  <math|v\<in\>H> and all <math|t\<gtr\>0>. We will see that such a pair is
  asymptotic in the directions <math|H>. (The terminology `branch pair' is
  inspired by the fact that, if the tiles are polyhedral, then the space
  <math|<OP>> is obtained as an inverse limit of a map on a branched
  manifold. The asymptotic-in-a-half-space pairs are then a ghostly remnant
  of the branching in the approximating branched manifolds.) The general
  situation is quite complicated when <math|d\<gtr\>1>. Members of branch
  pairs are not necessarily periodic under the substitution and there are
  typically infinitely many branch pairs. However, there are at most finitely
  many branch pairs that are asymptotic in a set of directions that contains
  a given closed hemisphere in its interior, and they are all
  substitution-periodic (Proposition <reference|periodic branch pairs
  exist>). To capture the asymptotic structure of a substitution tiling
  space, we define the <with|font-shape|italic|branch locus> (essentially,
  this consists of all the members of branch pairs, together with all the
  tilings obtained by translating these members in directions in the boundary
  of their maximal asymptotic sectors, and all tilings accumulated on by
  such). We prove (Theorem <reference|topological invariance 1>) that if a
  self-similar substitution tiling space has a branch pair whose set of
  asymptotic directions contains a closed hemisphere in its interior, then
  the branch locus is a topological invariant.

  If we restrict further to <math|2>-dimensional self-similar substitution
  tiling spaces, the structure of the branch locus becomes manageable: there
  are only finitely many lines along which branching occurs (Theorem
  <reference|finitely many sectors>) and if the substitution is also Pisot,
  then the branch locus is the inverse limit of an expanding Markov map on a
  compact <math|1>-dimensional simplicial complex. In the latter case, it
  follows from the rigidity result of Kwapisz (<cite|Kwapisz>) that the
  branch locus is also a topological invariant (Theorem
  <reference|topological invariance 2>).

  It frequently occurs that asymptotic structure in a tiling space can be
  held responsible for the appearance of certain subgroups in the cohomology
  of the space. For example, in the <math|1>-dimensional period doubling
  tiling space (<math|a\<mapsto\>a*b,b\<mapsto\>a*a>), there is a branch pair
  <math|<around|(|T,T<rprime|'>|)>> with <math|d*<around|(|T-t,T<rprime|'>-t|)>\<to\>0>
  as <math|t\<to\>\<pm\>\<infty\>>: this pair contributes a <math|<Z>> in
  <math|H<rsup|1>>. Similarly, the branch locus of the <math|2>-dimensional
  half-hex tiling space (see Example 1) consists of three tilings, each
  asymptotic to the other two in all directions: this contributes
  <math|<Z><rsup|2>> to <math|H<rsup|2>>. For the chair tiling (Example 2),
  there are two \Ptubes" made each of <math|<R><rsup|2>> orbits of four
  <math|2>-addic solenoids in the branch locus that contribute
  <math|<Z><around|[|1/2|]><rsup|2>> to <math|H<rsup|2>> (the asymptotic
  structure also is responsible for a <math|<Z>/3<Z>> that, while it doesn't
  show up in <math|H<rsup|2>> of the full tiling space, is, none-the-less, a
  topological invariant - see <cite|BDHS>). Calculations along these lines
  can be found in the dissertation, <cite|O>, of the second author, as can
  preliminary versions of many of the results contained in this article.

  The existence of tilings that are asymptotic in a hemisphere's worth of
  directions is closely related to lack of expansiveness of translation
  subdynamics. In <cite|BL>, Boyle and Lind consider subdynamics of expansive
  <math|<Z><rsup|d>> actions on compact metric spaces. In particular, they
  show that (for <math|d\<gtr\>1>) there is always a <math|d-1>-dimensional
  subspace of <math|<R><rsup|d>> so that the restriction of the
  <math|<Z><rsup|d>> action to directions within a bounded distance of the
  subspace is not expansive. The corresponding notion of expansiveness for
  the translation action of <math|<R><rsup|d>> on a <math|d>-dimensional
  tiling space <math|\<Omega\>> would be: the action is
  <with|font-shape|italic|transversely expansive> provided there is an
  <math|\<alpha\>\<gtr\>0> so that if <math|T\<ne\>T<rprime|'>\<in\>\<Omega\>>
  are any two tilings that share a tile, then there is a
  <math|v\<in\><R><rsup|d>> with <math|d*<around|(|T-v,T<rprime|'>-v|)>\<ge\>\<alpha\>>.
  Under the assumption of finite local complexity (see Section
  <reference|sec:background>), the translation action is transversely
  expansive. Under additional (very mild) hypotheses, Proposition
  <reference|agree in half-space> implies that there is always a <math|d-1>
  dimensional subspace of <math|<R><rsup|d>> restricted to which the
  translation action on <math|\<Omega\>> is not transversely expansive. If
  <math|d=2> and <math|\<Omega\>> is a self-similar substitution tiling
  space, it is a consequence of Theorem <reference|two sectors> that there
  are at least two independent directions in which translation is not
  transversely expansive.

  In Section <reference|sec:background> we review basic definitions and facts
  about tiling spaces. Section <reference|sec:definitions> introduces the
  terminology related to asymptotic structures and establishes some general
  results. In Section <reference|2-d> we restrict to the case of
  <math|2>-dimensional self-similar substitution tiling spaces.

  <section|Background><label|sec:background>

  By a <with|font-shape|italic|tile> <math|\<tau\>> in <math|<R><rsup|d>> we
  mean an ordered pair <math|\<tau\>=<around|(|s*p*t<around|(|\<tau\>|)>,m|)>>
  where <math|s*p*t<around|(|\<tau\>|)>>, the
  <with|font-shape|italic|support> of <math|\<tau\>>, is a compact subset of
  <math|<R><rsup|d>> and <math|m> is a <with|font-shape|italic|mark> taken
  from some finite set of marks. A tile <math|\<tau\>> is
  <with|font-shape|italic|topologically regular> if
  <math|c*l*<around|(|i*n*t*<around|(|s*p*t<around|(|\<tau\>|)>|)>|)>=s*p*t<around|(|\<tau\>|)>>
  and tiles <math|\<tau\>=<around|(|s*p*t<around|(|\<tau\>|)>,m|)>> and
  <math|\<sigma\>> are <with|font-shape|italic|translationally equivalent> if
  there is a <math|v\<in\><R><rsup|d>> with
  <math|\<tau\>+v\<assign\>(<around|(|s*p*t<around|(|\<tau\>|)>+v,m|)>=\<sigma\>>.
  In this article all tiles will be assumed to be topologically regular. By
  the <with|font-shape|italic|interior of a tile> we will mean the interior
  of its support: <math|<wide|\<tau\>|\<abovering\>>\<assign\>i*n*t*<around|(|s*p*t<around|(|\<tau\>|)>|)>>.

  A <with|font-shape|italic|patch> is a collection of tiles with pairwise
  disjoint interiors, the <with|font-shape|italic|support> of a patch
  <math|P>, <math|s*p*t<around|(|P|)>>, is the union of the supports of its
  constituent tiles, the <with|font-shape|italic|diameter> of <math|P>,
  <math|d*i*a*m<around|(|P|)>>, is the diameter of its support, and a
  <with|font-shape|italic|tiling> of <math|<R><rsup|d>> is a patch with
  support <math|<R><rsup|d>>. A collection <math|\<Omega\>> of tilings of
  <math|<R><rsup|d>> has <with|font-shape|italic|translationally finite local
  complexity> (FLC) if it is the case that for each <math|R> there are only
  finitely many translational equivalence classes of patches
  <math|P\<subset\>T\<in\>\<Omega\>> with
  <math|d*i*a*m<around|(|P|)>\<le\>R>. Given a tiling <math|T>, let
  <math|B<rsub|0><around|[|T|]>\<assign\><around|{|\<tau\>\<in\>T:0\<in\>s*p*t<around|(|\<tau\>|)>|}>>,
  and, for <math|R\<gtr\>0>, <math|B<rsub|R><around|[|T|]>\<assign\><around|{|\<tau\>\<in\>T:B<rsub|R><around|(|0|)>\<cap\>s*p*t<around|(|\<tau\>|)>\<ne\>\<emptyset\>|}>>.
  If <math|\<Omega\>> is a collection of tilings of <math|<R><rsup|d>> with
  FLC, there is a metric <math|d> on <math|\<Omega\>> with the property:
  <math|d<around|(|T,T<rprime|'>|)>\<less\>\<epsilon\>> if there are
  <math|v,v<rprime|'>\<in\><R><rsup|n>> with
  <math|<around|\||v|\|>,<around|\||v<rprime|'>|\|>\<less\>\<epsilon\>/2> so
  that <math|B<rsub|1/\<epsilon\>>*<around|[|T<rprime|'>-v<rprime|'>|]>=B<rsub|1/\<epsilon\>>*<around|[|T-v|]>>.
  In other words, in this metric two tilings are close if a small translate
  of one agrees with the other in a large neighborhood of the origin. (See
  <cite|AP> for details.) We will call a collection <math|\<Omega\>> of
  tilings of <math|<R><rsup|d>> a <with|font-shape|italic|d-dimensional
  tiling space> if <math|\<Omega\>> has FLC, is closed under translation
  (<math|T\<in\>\<Omega\>> and <math|v\<in\><R><rsup|d>\<Rightarrow\>T-v\<in\>\<Omega\>>),
  and is compact in the metric <math|d>. (All tiling spaces in this article
  are assumed to have FLC, but we will occasionally include the FLC
  hypothesis for emphasis.) For example, if <math|T> is an FLC tiling of
  <math|<R><rsup|d>>, then <math|\<Omega\>={T<rprime|'>:T<rprime|'>> is a
  tiling of <math|<R><rsup|d>> and every patch of <math|T<rprime|'>> is a
  translate of a patch of <math|T}> is a <math|d>-dimensional tiling space,
  called the <with|font-shape|italic|hull> of <math|T> (<cite|AP>).

  Suppose that <math|\<cal-A\>=<around|{|\<rho\><rsub|1>,\<ldots\>,\<rho\><rsub|k>|}>>
  is a set of translationally inequivalent tiles (called
  <with|font-shape|italic|prototiles>) in <math|<R><rsup|d>> and
  <math|\<Lambda\>> is an expanding linear isomorphism of <math|<R><rsup|d>>.
  A <with|font-shape|italic|substitution> on <math|\<cal-A\>> with expansion
  <math|\<Lambda\>> is a function <math|\<Phi\>:\<cal-A\>\<to\>{P:P> is a
  patch in <math|<R><rsup|d>}> with the properties that, for each
  <math|i\<in\><around|{|1,\<ldots\>,k|}>>, every tile in
  <math|\<Phi\><around|(|\<rho\><rsub|i>|)>> is a translate of an element of
  <math|\<cal-A\>>, and <math|s*p*t<around|(|\<Phi\><around|(|\<rho\><rsub|i>|)>|)>=\<Lambda\>*<around|(|s*p*t<around|(|\<rho\><rsub|i>|)>|)>>.
  Such a substitution naturally extends to patches whose elements are
  translates of prototiles by <math|\<Phi\><around|(|<around|{|\<rho\><rsub|i<around|(|j|)>>+v<rsub|j>:j\<in\>J|}>|)>\<assign\>\<cup\><rsub|j\<in\>J><around|(|\<Phi\><around|(|\<rho\><rsub|i<around|(|j|)>>|)>+\<Lambda\>*v<rsub|j>|)>>.
  A patch <math|P> is <with|font-shape|italic|allowed> for <math|\<Phi\>> if
  there is an <math|m\<ge\>1>, an <math|i\<in\><around|{|1,\<ldots\>,k|}>>,
  and a <math|v\<in\><R><rsup|d>>, with <math|P\<subset\>\<Phi\><rsup|m><around|(|\<rho\><rsub|i>|)>-v>.
  The <with|font-shape|italic|substitution tiling space> associated with
  <math|\<Phi\>> is the collection <math|<OP>\<assign\>{T:T> is a tiling of
  <math|<R><rsup|d>> and every finite patch in <math|T> is allowed for
  <math|\<Phi\>}>. If <math|\<Lambda\>> is multiplication by the scalar
  <math|\<lambda\>\<gtr\>1>, <math|<OP>> is called
  <with|font-shape|italic|self-similar>.

  A <math|d>-dimensional tiling space <math|\<Omega\>> is
  <with|font-shape|italic|repetitive> if for each patch <math|P> with compact
  support that occurs in some tiling in <math|\<Omega\>> there is an <math|R>
  so that for all <math|T\<in\>\<Omega\>> and all <math|x\<in\><R><rsup|d>>,
  there is a <math|v\<in\><R><rsup|d>> so that
  <math|P-v\<subset\>B<rsub|R>*<around|[|T-x|]>>. It is clear that if
  <math|\<Omega\>> is repetitive, then the action of <math|<R><rsup|d>> on
  <math|\<Omega\>> by translation is minimal. The substitution <math|\<Phi\>>
  is <with|font-shape|italic|primitive> if for each pair
  <math|<around|{|\<rho\><rsub|i>,\<rho\><rsub|j>|}>> of prototiles there is
  an <math|n\<in\><N>> so that a translate of <math|\<rho\><rsub|i>> occurs
  in <math|\<Phi\><rsup|n><around|(|\<rho\><rsub|j>|)>>. If <math|\<Phi\>> is
  primitive then <math|<OP>> is repetitive.

  If the translation action on <math|\<Omega\>> is free (i.e.,
  <math|T-v=T\<Rightarrow\>v=0>), <math|\<Omega\>> is said to be
  <with|font-shape|italic|non-periodic>. If <math|\<Phi\>> is primitive and
  <math|<OP>> is FLC and non-periodic then <math|<OP>> is compact in the
  metric described above, <math|\<Phi\>:<OP>\<to\><OP>> is a homeomorphism,
  and the translation action on <math|<OP>> is minimal and uniquely ergodic (
  <cite|AP>, <cite|Solo>, <cite|sol>).

  A real number <math|\<lambda\>> is a <with|font-shape|italic|Pisot number>
  if it is an algebraic integer and all of its algebraic conjugates lie
  strictly inside the unit circle. That is, there is a monic integer
  polynomial <math|p>, the <with|font-shape|italic|minimal polynomial> of
  <math|\<lambda\>>, that is irreducible over <math|<Q>>, has
  <math|\<lambda\>> as a root, and all other roots of <math|p> have absolute
  value less than 1. The <with|font-shape|italic|degree> of <math|\<lambda\>>
  is the degree of <math|p>. A self-similar substitution is a
  <with|font-shape|italic|Pisot substitution> if the expansion
  <math|\<lambda\>> for <math|\<Phi\>> is a Pisot number.

  <section|Definitions and preliminary results><label|sec:definitions>

  Suppose that <math|\<Omega\>> is a <math|d>-dimensional tiling space and
  <math|v\<in\>\<bbb-S\><rsup|d-1>>. Tilings
  <math|T,T<rprime|'>\<in\>\<Omega\>> are <with|font-shape|italic|asymptotic
  in direction <math|v>> provided <math|d*<around|(|T-t*v,T<rprime|'>-t*v|)>\<to\>0>
  as <math|t\<to\>\<infty\>>. Given <math|S\<subset\>\<bbb-S\><rsup|d-1>>,
  <math|T> and <math|T<rprime|'>> are <with|font-shape|italic|uniformly
  asymptotic in directions <math|S>> provided for each
  <math|\<epsilon\>\<gtr\>0> there is an <math|R> so that
  <math|d*<around|(|T-t*v,T<rprime|'>-t*v|)>\<less\>\<epsilon\>> for all
  <math|v\<in\>S> and all <math|t\<ge\>R>. We'll say that <math|T> and
  <math|T<rprime|'>> <with|font-shape|italic|agree on
  <math|X\<subset\>\<bbb-R\><rsup|d>>> provided
  <math|B<rsub|0>*<around|[|T-v|]>=B<rsub|0>*<around|[|T<rprime|'>-v|]>> for
  all <math|v\<in\>X>.

  <\proposition>
    <label|agree in half-space>If <math|\<Omega\>> is a non-periodic,
    repetitive, FLC tiling space then there are tilings
    <math|<wide|T|\<bar\>>\<ne\><wide|T|\<bar\>><rprime|'>> in
    <math|\<Omega\>> that agree on an open half-space.
  </proposition>

  <\proof>
    Let <math|T> be any tiling in <math|\<Omega\>>. By repetitivity, there
    are <math|x<rsub|n>\<ne\>0> with <math|<around|\||x<rsub|n>|\|>\<to\>\<infty\>>
    so that <math|B<rsub|n>*<around|[|T-x<rsub|n>|]>=B<rsub|n><around|[|T|]>>.
    By non-periodicity, <math|T-x<rsub|n>\<ne\>T> so
    <math|r<rsub|n>\<assign\>s*u*p*<around|{|r:B<rsub|r>*<around|[|T-x<rsub|n>|]>=B<rsub|r><around|[|T|]>|}>\<less\>\<infty\>>.
    Pick <math|y<rsub|n>\<in\>B<rsub|r<rsub|n>><around|(|0|)>> with
    <math|B<rsub|1>*<around|[|T-x<rsub|n>-y<rsub|n>|]>\<ne\>B<rsub|1>*<around|[|T-y<rsub|n>|]>>.
    Since <math|B<rsub|1>*<around|[|T-x<rsub|n>-y<rsub|n>|]>\<cap\>B<rsub|1>*<around|[|T-y<rsub|n>|]>\<ne\>\<emptyset\>>,
    finite local complexity insures that, up to translation, there are only
    finitely many pairs <math|<around|(|B<rsub|1>*<around|[|T-x<rsub|n>-y<rsub|n>|]>,B<rsub|1>*<around|[|T-y<rsub|n>|]>|)>>.
    Passing to a subsequence we may assume that
    <math|<around|(|B<rsub|1>*<around|[|T-x<rsub|n>-y<rsub|n>|]>,B<rsub|1>*<around|[|T-y<rsub|n>|]>|)>=<around|(|P<rprime|'>-z<rsub|n>,P-z<rsub|n>|)>>,
    with <math|z<rsub|n>\<to\>0>, for some pair of distinct patches
    <math|<around|(|P<rprime|'>,P|)>>. By compactness, there is a subsequence
    <math|n<rsub|i>>, tilings <math|<wide|T|\<bar\>><rprime|'>,<wide|T|\<bar\>>\<in\>\<Omega\>>,
    and <math|u>, so that <math|T-x<rsub|n<rsub|i>>-y<rsub|n<rsub|i>>\<to\><wide|T|\<bar\>><rprime|'>>,
    <math|T-y<rsub|n<rsub|i>>\<to\><wide|T|\<bar\>>>, and
    <math|y<rsub|n<rsub|i>>/<around|\||y<rsub|n<rsub|i>>|\|>\<to\>u>. Then
    <math|<wide|T|\<bar\>>\<ne\><wide|T|\<bar\>><rprime|'>> (since
    <math|<wide|T|\<bar\>><rprime|'>\<supset\>P<rprime|'>,<wide|T|\<bar\>>\<supset\>P>)
    and <math|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>> agree on the
    half-space <math|<around|{|v:<around|\<langle\>|v,u|\<rangle\>>\<less\>0|}>>.
  </proof>

  The translation action on a tiling space is not expansive: if
  <math|<around|\||w|\|>> is small, then <math|d*<around|(|T-v,T-w-v|)>>
  remains small for all <math|v>. But, assuming FLC, the
  <math|<R><rsup|d>>-action on a <math|d>-dimensional tiling space is
  <with|font-shape|italic|transversely expansive> in the following sense:
  there is an <math|\<alpha\>\<gtr\>0> so that if
  <math|T\<ne\>T<rprime|'>\<in\>\<Omega\>> and
  <math|T\<cap\>T<rprime|'>\<ne\>\<emptyset\>> then there is a
  <math|v\<in\><R><rsup|d>> so that <math|d*<around|(|T-v,T<rprime|'>-v|)>\<ge\>\<alpha\>>.
  This notion of transversely expansive is the natural way of transferring
  expansivity of a <math|<Z><rsup|d>>-action to \Pexpansivity" of the
  <math|<R><rsup|d>>-action obtained by suspension. More generally, if
  <math|V> is a subspace of <math|<R><rsup|d>>, then the translation action
  on <math|\<Omega\>> is <with|font-shape|italic|transversely expansive in
  the direction of V> if, in the definition of transversely expansive, the
  <math|v> can be taken from <math|V>. The following is analogous to a result
  of Boyle and Lind (<cite|BL>) for expansive <math|<Z><rsup|d>>-actions.

  <\corollary>
    <label|transversely expansive>If <math|\<Omega\>> is a
    <math|d>-dimensional, non-periodic, repetitive, FLC tiling space then
    there is a <math|d-1>-dimensional subspace <math|V> of <math|<R><rsup|d>>
    so that the translation action is not transversely expansive in the
    direction of <math|V>. Moreover, if <math|V> is such a subspace, then
    there are tilings <math|<wide|T|\<bar\>>\<ne\><wide|T|\<bar\>><rprime|'>\<in\>\<Omega\>>
    that agree on one of the components of <math|<R><rsup|d>\<setminus\>V>.
  </corollary>

  <\proof>
    By Proposition <reference|agree in half-space> there is a <math|w\<ne\>0>
    and tilings <math|<wide|T|\<bar\>>\<ne\><wide|T|\<bar\>><rprime|'>\<in\>\<Omega\>>
    so that <math|<wide|T|\<bar\>>> and <math|<wide|T|\<bar\>><rprime|'>>
    agree on <math|<around|{|x:<around|\<langle\>|x,w|\<rangle\>>\<gtr\>0|}>>.
    Let <math|V\<assign\><around|{|w|}><rsup|\<perp\>>>. Then, for any
    <math|\<alpha\>\<gtr\>0>, there is a <math|t\<gtr\>0> so that, if
    <math|T\<assign\><wide|T|\<bar\>>-t*w> and
    <math|T<rprime|'>\<assign\><wide|T|\<bar\>><rprime|'>-t*w>,
    <math|s*u*p*<around|{|d*<around|(|T-v,T<rprime|'>-v|)>:v\<in\>V|}>\<less\>\<alpha\>>.

    Suppose now that <math|V> is a <math|d-1>-dimensional subspace of
    <math|<R><rsup|d>> so that the translation action on <math|\<Omega\>> is
    not transversely expansive in the direction of <math|V>. There are then
    <math|T<rsub|n>\<ne\>T<rsub|n><rprime|'>\<in\>\<Omega\>> so that
    <math|T<rsub|n>\<cap\>T<rsub|n><rprime|'>\<ne\>\<emptyset\>> and
    <math|d*<around|(|T<rsub|n>-v,T<rsub|n><rprime|'>-v|)>\<less\>1/n> for
    each <math|n\<in\><N>> and all <math|v\<in\>V>. There are then
    <math|x<rsub|n>\<to\>0> so that <math|B<rsub|0>*<around|[|T<rsub|n>-x<rsub|n>|]>=B<rsub|0><around|[|T<rsub|n><rprime|'>|]>>
    for all <math|n\<in\><N>>. It follows that there are
    <math|t<rsub|n>\<to\>\<infty\>> so that <math|T<rsub|n>-x<rsub|n>-v>
    agrees with <math|T<rsub|n><rprime|'>-v> on the strip
    <math|V+<around|{|t*w:<around|\||t|\|>\<le\>t<rsub|n>|}>>, where
    <math|w\<in\>\<bbb-S\><rsup|d-1>> is perpendicular to <math|V>. Notice
    that since <math|T<rsub|n>\<cap\>T<rsub|n><rprime|'>\<ne\>\<emptyset\>>,
    <math|T<rsub|n>-x<rsub|n>\<ne\>T<rsub|n><rprime|'>> for large <math|n>.
    By appropriately translating <math|T<rsub|n>-x<rsub|n>> and
    <math|T<rsub|n><rprime|'>> we obtain tilings
    <math|S<rsub|n>\<ne\>S<rsub|n><rprime|'>\<in\>\<Omega\>> with the
    properties: <math|B<rsub|1><around|[|S<rsub|n>|]>\<ne\>B<rsub|1><around|[|S<rsub|n><rprime|'>|]>>
    and <math|S<rsub|n>> and <math|S<rsub|n><rprime|'>> agree on
    <math|V+<around|{|t*w:0\<le\>t\<le\>2*t<rsub|n>|}>> or on
    <math|V-<around|{|t*w:0\<le\>t\<le\>2*t<rsub|n>|}>>. Let
    <math|n<rsub|i>\<to\>\<infty\>> be such that
    <math|S<rsub|n<rsub|i>>\<to\><wide|T|\<bar\>>\<in\>\<Omega\>> and
    <math|S<rsub|n<rsub|i>><rprime|'>\<to\><wide|T|\<bar\>><rprime|'>\<in\>\<Omega\>>.
    Then <math|<wide|T|\<bar\>>\<ne\><wide|T<rprime|'>|\<bar\>>> and
    <math|<wide|T|\<bar\>>> and <math|<wide|T|\<bar\>><rprime|'>> agree on
    one of the components of <math|<R><rsup|d>\<setminus\>V>.
  </proof>

  It is clear that if tilings <math|T> and <math|T<rprime|'>> agree on the
  open half-space <math|<around|{|v\<in\>\<bbb-R\><rsup|d>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>0|}>>,
  some <math|u\<in\>\<bbb-S\><rsup|d-1>>, then <math|T> and
  <math|T<rprime|'>> are uniformly asymptotic in directions
  <math|<around|{|v\<in\>\<bbb-S\><rsup|d-1>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>\<epsilon\>|}>>
  for each <math|\<epsilon\>\<gtr\>0>.

  <\lemma>
    <label|asymptotic direction>If <math|\<Omega\>> is a <math|d>-dimensional
    FLC tiling space and <math|T,T<rprime|'>\<in\>\<Omega\>> are asymptotic
    in direction <math|v\<in\>\<bbb-S\><rsup|d-1>> then there is <math|R> so
    that <math|T> and <math|T<rprime|'>> agree on
    <math|<around|{|t*v:t\<ge\>R|}>>.
  </lemma>

  <\proof>
    As a consequence of finite local complexity, there is
    <math|\<epsilon\>\<gtr\>0> so that: (1) if
    <math|T<rsub|1>,T<rsub|2>\<in\>\<Omega\>> satisfy
    <math|B<rsub|1><around|[|T<rsub|1>|]>=B<rsub|1><around|[|T<rsub|2>|]>>
    and <math|<around|\||x|\|>\<less\>\<epsilon\>>, then
    <math|B<rsub|0>*<around|[|T<rsub|1>-x|]>=B<rsub|0>*<around|[|T<rsub|2>-x|]>>;
    and (2) if <math|B<rsub|0><around|[|T<rsub|1>|]>=B<rsub|0>*<around|[|T<rsub|1>-x|]>>
    for some <math|T<rsub|1>\<in\>\<Omega\>> and <math|x> with
    <math|<around|\||x|\|>\<less\>\<epsilon\>>, then <math|x=0>. Now if
    <math|T> and <math|T<rprime|'>> are asymptotic in direction <math|v>,
    there is <math|x<around|(|t|)>> so that
    <math|B<rsub|1>*<around|[|T-t*v|]>=B<rsub|1>*<around|[|T<rprime|'>-t*v-x<around|(|t|)>|]>>
    and <math|x<around|(|t|)>\<to\>0> as <math|t\<to\>\<infty\>>. Let
    <math|R> be large enough so that <math|<around|\||x<around|(|t|)>|\|>\<less\>\<epsilon\>/2>
    for <math|t\<ge\>R>. For <math|t<rsub|0>\<gtr\>R> we have
    <math|B<rsub|1>*<around|[|T-t<rsub|0>*v|]>=B<rsub|1>*<around|[|T<rprime|'>-t<rsub|0>*v-x<around|(|t<rsub|0>|)>|]>>
    so <math|B<rsub|0>*<around|[|T-t*v|]>=B<rsub|0>*<around|[|T<rprime|'>-t*v-x<around|(|t<rsub|0>|)>|]>>
    for all <math|t> with <math|<around|\||t-t<rsub|0>|\|>\<less\>\<epsilon\>>,
    by (1). Also, <math|B<rsub|0>*<around|[|T-t*v|]>=B<rsub|0>*<around|[|T<rprime|'>-t*v-x<around|(|t|)>|]>>.
    Thus, if <math|<around|\||t-t<rsub|0>|\|>\<less\>\<epsilon\>> and
    <math|t,t<rsub|0>\<ge\>R>, we have <math|B<rsub|0>*<around|[|T<rprime|'>-t*v-x<around|(|t<rsub|0>|)>|]>=B<rsub|0>*<around|[|T<rprime|'>-t*v-x<around|(|t|)>|]>>
    and <math|<around|\||x<around|(|t|)>-x<around|(|t<rsub|0>|)>|\|>\<less\>\<epsilon\>>,
    so that <math|x<around|(|t|)>=x<around|(|t<rsub|0>|)>>, by (2). That is,
    <math|x<around|(|t|)>> is constant for <math|t\<ge\>R>, and hence
    <math|x<around|(|t|)>=0> for <math|t\<ge\>R>.
  </proof>

  <\lemma>
    <label|asymptotic directions>If <math|\<Omega\>> is a
    <math|d>-dimensional FLC tiling space and
    <math|T,T<rprime|'>\<in\>\<Omega\>> are uniformly asymptotic in
    directions <math|S\<subset\>\<bbb-S\><rsup|d-1>> then there is <math|R>
    so that <math|T> and <math|T<rprime|'>> agree on
    <math|<around|{|t*v:v\<in\>S,t\<ge\>R|}>>.
  </lemma>

  <\proof>
    Let <math|\<epsilon\>> be as in the proof of Lemma <reference|asymptotic
    direction>. Then, for each <math|v\<in\>S> there is an <math|R> and
    <math|x<around|(|t,v|)>> with <math|<around|\||x<around|(|t,v|)>|\|>\<less\>\<epsilon\>/2>
    for <math|t\<ge\>R> so that <math|B<rsub|1>*<around|[|T-t*v|]>=B<rsub|1>*<around|[|T<rprime|'>-t*v-x<around|(|t,v|)>|]>>.
    As in the proof of Lemma <reference|asymptotic direction>, this implies
    that <math|x<around|(|t,v|)>=0> for all <math|v\<in\>S> and
    <math|t\<ge\>R>. Thus <math|T> and <math|T<rprime|'>> agree on
    <math|<around|{|t*v:v\<in\>S,t\<ge\>R|}>>.
  </proof>

  If <math|\<Phi\>> is the induced homeomorphism on a substitution tiling
  space <math|<OP>> and <math|T\<in\><OP>>, the
  <with|font-shape|italic|stable manifold> of <math|T> is the set
  <math|W<rsup|s><around|(|T|)>\<assign\>{T<rprime|'>\<in\><OP>:d<around|(|\<Phi\><rsup|n><around|(|T<rprime|'>|)>,\<Phi\><rsup|n><around|(|T|)>|)>\<to\>0>
  as <math|n\<to\>\<infty\>}>.

  <\lemma>
    <label|stable mfd>Suppose that <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>>
    is an FLC substitution tiling space and <math|T\<in\>\<Omega\>>. Then
    <math|W<rsup|s><around|(|T|)>={T<rprime|'>\<in\>\<Omega\>:\<forall\>r,\<exists\>n>
    such that <math|B<rsub|r><around|[|\<Phi\><rsup|n><around|(|T<rprime|'>|)>|]>=B<rsub|r><around|[|\<Phi\><rsup|n><around|(|T|)>|]>}={T<rprime|'>\<in\>\<Omega\>:B<rsub|0><around|[|\<Phi\><rsup|n><around|(|T<rprime|'>|)>|]>=B<rsub|0><around|[|\<Phi\><rsup|n><around|(|T|)>|]>>
    for some <math|n}>.
  </lemma>

  <\proof>
    The equality of the last two sets, and their containment in
    <math|W<rsup|s><around|(|T|)>>, is clear. For the opposite containment,
    note that, by finite local complexity, there is
    <math|\<epsilon\><rsub|1>\<gtr\>0> so that, for all
    <math|\<epsilon\><rsub|2>>, with <math|0\<less\>\<epsilon\><rsub|2>\<le\>\<epsilon\><rsub|1>>,
    <math|i*n*f*<around|{|d*<around|(|T<rsub|1>,T<rsub|2>-x|)>:T<rsub|1>,T<rsub|2>\<in\>\<Omega\>,B<rsub|1><around|[|T<rsub|1>|]>=B<rsub|1><around|[|T<rsub|2>|]>,\<epsilon\><rsub|2>\<le\><around|\||x|\|>\<le\>\<epsilon\><rsub|1>|}>=:\<delta\><around|(|\<epsilon\><rsub|2>|)>\<gtr\>0>.
    Choose <math|\<epsilon\><rsub|1>\<gtr\>0> also small enough so that if
    <math|T<rsub|1>> and <math|T<rsub|2>> are any two tilings in
    <math|\<Omega\>> with <math|B<rsub|1><around|[|T<rsub|1>|]>=B<rsub|1><around|[|T<rsub|2>|]>>,
    then <math|B<rsub|1>*<around|[|T<rsub|1>-x|]>=B<rsub|1>*<around|[|T<rsub|2>-y|]>>
    and <math|<around|\||x|\|>,<around|\||y|\|>\<le\>\<epsilon\><rsub|1>>
    implies that <math|x=y>. Set <math|\<epsilon\><rsub|2>=\<epsilon\><rsub|1>/<around|\||\<Lambda\>|\|><rsub|m*a*x>>,
    where <math|<around|\||\<Lambda\>|\|><rsub|m*a*x>\<assign\>m*a*x*<around|{|<around|\||\<Lambda\>*v|\|>:<around|\||v|\|>=1|}>>
    and <math|\<Lambda\>> is the inflation matrix for <math|\<Phi\>>. Now if
    <math|T<rprime|'>\<in\>W<rsup|s><around|(|T|)>>, there are <math|N> and
    <math|x<rsub|n>> with <math|<around|\||x<rsub|n>|\|>\<less\>\<epsilon\><rsub|2>>,
    so that <math|B<rsub|1><around|[|\<Phi\><rsup|n><around|(|T<rprime|'>|)>|]>=B<rsub|1>*<around|[|\<Phi\><rsup|n><around|(|T|)>-x<rsub|n>|]>>
    and <math|d<around|(|\<Phi\><rsup|n><around|(|T<rprime|'>|)>,\<Phi\><rsup|n><around|(|T|)>|)>\<less\>\<delta\><around|(|\<epsilon\><rsub|2>|)>>
    for all <math|n\<ge\>N>. If <math|x<rsub|N>\<ne\>0>, there is
    <math|k\<gtr\>0> so that <math|\<epsilon\><rsub|2>\<le\><around|\||\<Lambda\><rsup|k>*x<rsub|N>|\|>\<le\>\<epsilon\><rsub|1>>.
    We would have <math|B<rsub|1>*<around|[|\<Phi\><rsup|N+k><around|(|T|)>-x<rsub|N+k>|]>=B<rsub|1><around|[|\<Phi\><rsup|N+k><around|(|T<rprime|'>|)>|]>=B<rsub|1>*<around|[|\<Phi\><rsup|k>*<around|(|\<Phi\><rsup|N><around|(|T|)>-x<rsub|N>|)>|]>=B<rsub|1>*<around|[|\<Phi\><rsup|N+k><around|(|T|)>-\<Lambda\><rsup|k>*x<rsub|N>|]>>
    so that <math|x<rsub|N+k>=\<Lambda\><rsup|k>*x<rsub|N>>, from which it
    would follow that <math|d<around|(|\<Phi\><rsup|N+k><around|(|T<rprime|'>|)>,\<Phi\><rsup|N+k><around|(|T|)>|)>\<ge\>\<delta\><around|(|\<epsilon\><rsub|2>|)>>,
    in contradiction to the choice of <math|N>. Thus
    <math|B<rsub|1><around|[|\<Phi\><rsup|N><around|(|T<rprime|'>|)>|]>=B<rsub|1><around|[|\<Phi\><rsup|N><around|(|T|)>|]>>.
  </proof>

  If <math|\<Omega\>=<OP>> is a <math|d>-dimensional substitution tiling
  space with <math|T,T<rprime|'>\<in\>\<Omega\>> and
  <math|T\<in\>W<rsup|s><around|(|T<rprime|'>|)>> we will say that <math|T>
  and <math|T<rprime|'>> are <with|font-shape|italic|stably equivalent> and
  write <math|T\<sim\><rsub|s>T<rprime|'>>. Note that as a consequence of
  Lemma <reference|stable mfd> the relation <math|\<nsim\><rsub|s>>, the
  negation of <math|\<sim\><rsub|s>>, has the property:
  <math|T-x<rsub|n>\<nsim\><rsub|s>T<rprime|'>-x<rsub|n>> and
  <math|x<rsub|n>\<to\>x> <math|\<Longrightarrow\>>
  <math|T-x\<nsim\><rsub|s>T<rprime|'>-x> . The tiling
  <math|T\<in\>\<Omega\>> will be called a <with|font-shape|italic|branch
  point> if there is a tiling <math|T<rprime|'>\<in\>\<Omega\>> and an open
  half space <math|H> so that <math|T\<nsim\><rsub|s>T<rprime|'>> and
  <math|T-x\<sim\><rsub|s>T<rprime|'>-x> for all <math|x\<in\>H>. In this
  case, <math|<around|(|T,T<rprime|'>|)>> will be called a
  <with|font-shape|italic|branch pair>; the connected component of
  <math|<around|{|v\<in\>\<bbb-S\><rsup|d-1>:T-t*v\<sim\><rsub|s>T<rprime|'>-t*v,<space|0.17em>\<forall\>t\<gtr\>0|}>>
  containing <math|H\<cap\>\<bbb-S\><rsup|d-1>> will be called the
  <with|font-shape|italic|asymptotic sector> of
  <math|<around|(|T,T<rprime|'>|)>> and denoted by
  <math|S<around|(|T,T<rprime|'>|)>>. We will denote the collection of all
  branch pairs of <math|<OP>> by <math|<with|math-font|cal|B*P><around|(|\<Phi\>|)>>.
  (It may occur that a branch pair has two different asymptotic sectors,
  <math|H\<cap\>\<bbb-S\><rsup|d-1>> and <math|-H\<cap\>\<bbb-S\><rsup|d-1>>
  for some open half-space <math|H>, but this ambiguity will be harmless.)

  For a given substitution tiling space <math|\<Omega\>>, patches
  <math|P,P<rprime|'>>, and <math|X\<subset\>i*n*t*<around|(|s*p*t<around|(|P|)>\<cap\>s*p*t<around|(|P<rprime|'>|)>|)>>,
  we'll say that <math|P> and <math|P<rprime|'>> are
  <with|font-shape|italic|stably related on <math|X>> provided, whenever
  <math|T,T<rprime|'>\<in\>\<Omega\>> are such that
  <math|P\<subset\>T,P<rprime|'>\<subset\>T<rprime|'>>, it is the case that
  <math|T-x\<sim\><rsub|s>T<rprime|'>-x> for all <math|x\<in\>X>. If <math|P>
  and <math|P<rprime|'>> are stably related on
  <math|X=i*n*t*<around|(|s*p*t<around|(|P|)>\<cap\>s*p*t<around|(|P<rprime|'>|)>|)>\<ne\>\<emptyset\>>,
  we'll say that <math|P> and <math|P<rprime|'>> are
  <with|font-shape|italic|stably related on overlap>. The following is an
  adaptation of a lemma in <cite|sol>.

  <\lemma>
    <label|no slip>If <math|P> and <math|P<rprime|'>> are patches for a
    non-periodic, FLC, self-similar substitution tiling space and <math|P>
    and <math|P<rprime|'>> are stably related on overlap, there is an
    <math|\<epsilon\>\<gtr\>0> so that if
    <math|0\<less\><around|\||x|\|>\<less\>\<epsilon\>> then <math|P-x> and
    <math|P<rprime|'>> are not stably related on overlap.
  </lemma>

  <\proof>
    We prove the result in case <math|P=P<rprime|'>=<around|{|\<tau\>|}>> for
    some tile <math|\<tau\>>, from which the general result follows easily.
    Let <math|\<lambda\>> be the expansion factor for <math|\<Phi\>>. Pick
    <math|y\<in\>i*n*t<around|(|\<tau\>|)>> and let <math|r\<gtr\>0> be small
    enough so that <math|c*l<around|(|B<rsub|2*r><around|(|y|)>|)>\<subset\>i*n*t<around|(|\<tau\>|)>>.
    By Lemma 2.4 of <cite|sol>, there is an <math|N\<gtr\>1> so that if
    <math|Q> and <math|Q-x<rsub|1>> are both patches in some tiling
    <math|T\<in\>\<Omega\>>, <math|B<rsub|r<rsub|1>><around|(|y|)>\<subset\>s*p*t<around|(|Q|)>>,
    and <math|<around|\||x<rsub|1>|\|>\<less\>r<rsub|1>/N>, then
    <math|x<rsub|1>=0>. Let <math|\<epsilon\>\<assign\>r/N>, let
    <math|<around|\||x|\|>\<less\>\<epsilon\>>, and suppose that
    <math|<around|{|\<tau\>|}>> and <math|<around|{|\<tau\>|}>-x> are stably
    related on overlap. Since the compact ball
    <math|c*l<around|(|B<rsub|r><around|(|y|)>|)>> is contained in
    <math|i*n*t*<around|(|\<tau\>\<cap\><around|(|\<tau\>-x|)>|)>>, there is
    an <math|M> so that <math|B<rsub|0>*<around|[|\<Phi\><rsup|M>*<around|(|<around|{|\<tau\>|}>-z|)>|]>=B<rsub|0>*<around|[|\<Phi\><rsup|M>*<around|(|<around|{|\<tau\>|}>-x-z|)>|]>>
    for all <math|z\<in\>c*l<around|(|B<rsub|r><around|(|y|)>|)>> (Lemma
    <reference|stable mfd>). That is, both the patch
    <math|Q\<assign\>B<rsub|\<lambda\><rsup|M>*r><around|[|\<Phi\><rsup|M><around|(|<around|{|\<tau\>|}>|)>|]>>
    and the patch <math|Q-\<lambda\><rsup|M>*x=B<rsub|\<lambda\><rsup|M>*r>*<around|[|\<Phi\><rsup|M>*<around|(|<around|{|\<tau\>|}>-x|)>|]>>
    occur in the patch <math|\<Phi\><rsup|M><around|(|<around|{|\<tau\>|}>|)>>.
    Moreover, letting <math|x<rsub|1>=\<lambda\><rsup|M>*x> and
    <math|r<rsub|1>=\<lambda\><rsup|M>*r>, we have
    <math|B<rsub|r<rsub|1>><around|(|y|)>\<subset\>s*p*t<around|(|Q|)>> and
    <math|<around|\||x<rsub|1>|\|>\<less\>r<rsub|1>/N>. Thus
    <math|x<rsub|1>=0> and hence <math|x=0>.
  </proof>

  <\lemma>
    <label|T=T'>If <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>> is a
    <math|d>-dimensional non-periodic, FLC, self-similar substitution tiling
    space and <math|T,T<rprime|'>\<in\>\<Omega\>> are such that
    <math|T-x\<sim\><rsub|s>T<rprime|'>-x> for all
    <math|x\<in\>\<bbb-R\><rsup|d>>, then <math|T=T<rprime|'>>.
  </lemma>

  <\proof>
    Let <math|\<Delta\>\<assign\>m*a*x{d*i*a*m<around|(|\<rho\>|)>:\<rho\>>
    is a prototile for <math|\<Omega\>}>. Then for all
    <math|<wide|T|\<bar\>>\<in\>\<Omega\>>,
    <math|s*p*t<around|(|B<rsub|0><around|[|<wide|T|\<bar\>>|]>|)>\<subset\>i*n*t*<around|(|s*p*t<around|(|B<rsub|\<Delta\>+1><around|[|<wide|T|\<bar\>>|]>|)>|)>>,
    and there are, up to translation, just finitely many pairs of the form
    <math|<around|(|B<rsub|0><around|[|<wide|T|\<bar\>>|]>,B<rsub|\<Delta\>+1><around|[|<wide|T|\<bar\>>|]>|)>>.
    It follows from Lemma <reference|no slip> that, up to translation, there
    are only finitely many pairs of pairs of the form
    <math|<around|(|<around|(|B<rsub|0>*<around|[|T-x|]>,B<rsub|\<Delta\>+1>*<around|[|T-x|]>|)>,<around|(|B<rsub|0>*<around|[|T<rprime|'>-x|]>,B<rsub|\<Delta\>+1>*<around|[|T<rprime|'>-x|]>|)>|)>>,
    say for each <math|x> there is an <math|i\<in\><around|{|1,\<ldots\>,n|}>>
    and a <math|y=y<around|(|x|)>> with <math|<around|(|<around|(|B<rsub|0>*<around|[|T-x|]>,B<rsub|\<Delta\>+1>*<around|[|T-x|]>|)>,<around|(|B<rsub|0>*<around|[|T<rprime|'>-x|]>,B<rsub|\<Delta\>+1>*<around|[|T<rprime|'>-x|]>|)>|)>=<around|(|<around|(|P<rsub|i>-y,Q<rsub|i>-y|)>,<around|(|P<rprime|'><rsub|i>-y,Q<rprime|'><rsub|i>-y|)>|)>>.
    Let <math|x,y,i> be as in the last sentence. For each
    <math|z\<in\>s*p*t<around|(|P<rsub|i>|)>\<cap\>s*p*t<around|(|P<rprime|'><rsub|i>|)>>,
    there is an <math|m=m<around|(|x,y,z|)>> so that
    <math|B<rsub|1>*<around|[|\<Phi\><rsup|m>*<around|(|T-x+y-z|)>|]>=B<rsub|1>*<around|[|\<Phi\><rsup|m>*<around|(|T<rprime|'>-x+y-z|)>|]>>,
    by Lemma <reference|stable mfd>, and in fact we can choose this <math|m>
    to depend only on <math|z> (and <math|i>), since if
    <math|x<rprime|'>,y<rprime|'>,i> are also such that
    <math|<around|(|<around|(|B<rsub|0>*<around|[|T-x<rprime|'>|]>,B<rsub|\<Delta\>+1>*<around|[|T-x<rprime|'>|]>|)>,<around|(|B<rsub|0>*<around|[|T<rprime|'>-x<rprime|'>|]>,B<rsub|\<Delta\>+1>*<around|[|T<rprime|'>-x<rprime|'>|]>|)>|)>=<around|(|<around|(|P<rsub|i>-y<rprime|'>,Q<rsub|i>-y<rprime|'>|)>,<around|(|P<rprime|'><rsub|i>-y<rprime|'>,Q<rprime|'><rsub|i>-y<rprime|'>|)>|)>>,
    then <math|<around|(|B<rsub|0>*<around|[|T-x<rprime|'>+y<rprime|'>-z|]>,B<rsub|0>*<around|[|T<rprime|'>-x<rprime|'>+y<rprime|'>-z|]>|)>=<around|(|B<rsub|0>*<around|[|T-x+y-z|]>,B<rsub|0>*<around|[|T<rprime|'>-x+y-z|]>|)>>)
    (this is because <math|s*p*t<around|(|P<rsub|i>|)>\<cap\>s*p*t<around|(|P<rprime|'><rsub|i>|)>\<subset\>i*n*t*<around|(|s*p*t<around|(|Q<rsub|i>|)>\<cap\>s*p*t<around|(|Q<rprime|'><rsub|i>|)>|)>>).
    Now if <math|z<rprime|'>> is sufficiently close to <math|z>, then
    <math|B<rsub|0>*<around|[|\<Phi\><rsup|m>*<around|(|T-x+y-z<rprime|'>|)>|]>=B<rsub|0>*<around|[|\<Phi\><rsup|m>*<around|(|T<rprime|'>-x+y-z<rprime|'>|)>|]>>.
    Thus, by compactness of <math|s*p*t<around|(|P<rsub|i>|)>\<cap\>s*p*t<around|(|P<rprime|'><rsub|i>|)>>,
    there is an <math|M=M<around|(|i|)>> so that
    <math|B<rsub|0>*<around|[|\<Phi\><rsup|M>*<around|(|T-x+y-z|)>|]>=B<rsub|0>*<around|[|\<Phi\><rsup|M>*<around|(|T<rprime|'>-x+y-z|)>|]>>
    for all <math|z\<in\>s*p*t<around|(|P<rsub|i>|)>\<cap\>s*p*t<around|(|P<rprime|'><rsub|i>|)>>
    and <math|x,y> so that <math|<around|(|<around|(|B<rsub|0>*<around|[|T-x|]>,B<rsub|\<Delta\>+1>*<around|[|T-x|]>|)>,<around|(|B<rsub|0>*<around|[|T<rprime|'>-x|]>,B<rsub|\<Delta\>+1>*<around|[|T<rprime|'>-x|]>|)>|)>=<around|(|<around|(|P<rsub|i>-y,Q<rsub|i>-y|)>,<around|(|P<rprime|'><rsub|i>-y,Q<rprime|'><rsub|i>-y|)>|)>>
    Let <math|K=m*a*x<around|{|M<around|(|1|)>,\<ldots\>,M<around|(|n|)>|}>>.
    Then <math|B<rsub|0>*<around|[|\<Phi\><rsup|K>*<around|(|T-x+y-z|)>|]>=B<rsub|0>*<around|[|\<Phi\><rsup|K>*<around|(|T<rprime|'>-x+y-z|)>|]>>
    for all appropriate <math|x,y,z>: that is,
    <math|\<Phi\><rsup|K><around|(|T|)>=\<Phi\><rsup|K><around|(|T<rprime|'>|)>>,
    and since <math|\<Phi\>> is a homeomorphism, <math|T=T<rprime|'>>.
  </proof>

  <\lemma>
    <label|existence of R>If <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>> is a
    <math|d>-dimensional non-periodic, FLC, self-similar substitution tiling
    space, there is an <math|R> so that if
    <math|T,T<rprime|'>\<in\>\<Omega\>> are such that
    <math|T-x\<sim\><rsub|s>T<rprime|'>-x> for all
    <math|x\<in\>\<bbb-R\><rsup|d>> with <math|<around|\||x|\|>\<le\>R>, then
    <math|B<rsub|0><around|[|T|]>=B<rsub|0><around|[|T<rprime|'>|]>>.
  </lemma>

  <\proof>
    Otherwise, for each <math|n\<in\><N>>, there are
    <math|T<rsub|n>,T<rprime|'><rsub|n>\<in\>\<Omega\>> with
    <math|T<rsub|n>-x\<sim\><rsub|s>T<rprime|'><rsub|n>-x> for all <math|x>
    with <math|<around|\||x|\|>\<le\>n> and
    <math|B<rsub|0><around|[|T<rsub|n>|]>\<ne\>B<rsub|0><around|[|T<rprime|'><rsub|n>|]>>.
    There is a smallest <math|m<rsub|n>> so that
    <math|B<rsub|0><around|[|\<Phi\><rsup|m<rsub|n>><around|(|T<rsub|n>|)>|]>=B<rsub|0><around|[|\<Phi\><rsup|m<rsub|n>><around|(|T<rprime|'><rsub|n>|)>|]>>:
    replace <math|T<rsub|n>> by <math|\<Phi\><rsup|m<rsub|n>-1><around|(|T<rsub|n>|)>>
    and <math|T<rprime|'><rsub|n>> by <math|\<Phi\><rsup|m<rsub|n>-1><around|(|T<rprime|'><rsub|n>|)>>.
    By finite local complexity, there are only finitely many pairs
    <math|<around|(|B<rsub|0><around|[|T<rsub|n>|]>,B<rsub|0><around|[|T<rprime|'><rsub|n>|]>|)>>,
    up to translation: say <math|<around|(|B<rsub|0><around|[|T<rsub|n<rsub|i>>|]>,B<rsub|0><around|[|T<rprime|'><rsub|n<rsub|i>>|]>|)>=<around|(|P-x<rsub|i>,P<rprime|'>-x<rsub|i>|)>>
    with <math|x<rsub|i>\<to\>0>, <math|T<rsub|n<rsub|i>>\<to\>T\<in\>\<Omega\>>,
    and <math|T<rprime|'><rsub|n<rsub|i>>\<to\>T<rprime|'>\<in\>\<Omega\>>.
    Since <math|P\<subset\>T> and <math|P<rprime|'>\<subset\>T<rprime|'>>,
    <math|T\<ne\>T<rprime|'>>. Fix <math|r\<gtr\>0>. Since the tilings
    <math|T<rsub|n<rsub|i>>+x<rsub|i>> all share the patch <math|P> and the
    tilings <math|T<rprime|'><rsub|n<rsub|i>>+x<rsub|i>> all share the patch
    <math|P<rprime|'>>, finite local complexity guarantees that there are
    just finitely many pairs <math|<around|(|B<rsub|r>*<around|[|T<rsub|n<rsub|i>>+x<rsub|i>|]>,B<rsub|r>*<around|[|T<rprime|'><rsub|n<rsub|i>>+x<rsub|i>|]>|)>>.
    It follows that <math|B<rsub|r>*<around|[|T<rsub|n<rsub|i>>+x<rsub|i>|]>\<subset\>T>
    and <math|B<rsub|r>*<around|[|T<rprime|'><rsub|n<rsub|i>>+x<rsub|i>|]>\<subset\>T<rprime|'>>
    for large <math|i>. If <math|i> is also large enough so that
    <math|n<rsub|i>+<around|\||x<rsub|i>|\|>\<gtr\>r>, then
    <math|T<rsub|n<rsub|i>>+x<rsub|i>-y\<sim\><rsub|s>T<rprime|'><rsub|n<rsub|i>>+x<rsub|i>-y>
    for all <math|y\<in\>B<rsub|r><around|(|0|)>> and hence
    <math|T-y\<sim\><rsub|s>T<rprime|'>-y> for all
    <math|y\<in\>B<rsub|r><around|(|0|)>>. Thus
    <math|T-y\<sim\><rsub|s>T<rprime|'>-y> for all <math|y> and by Lemma
    <reference|T=T'> we arrive at the contradiction <math|T=T<rprime|'>>.
  </proof>

  <\lemma>
    <label|finitely many patch pairs>If <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>>
    is a <math|d>-dimensional, non-periodic, FLC, self-similar substitution
    tiling space, then given <math|r> and <math|\<epsilon\>\<gtr\>0>, there
    are, up to translation, only finitely many pairs of (allowed) patches
    <math|<around|(|P,P<rprime|'>|)>> with the properties:
    <math|d*i*a*m<around|(|P|)>,d*i*a*m<around|(|P<rprime|'>|)>\<le\>r>;
    <math|P> and <math|P<rprime|'>> are stably related on
    <math|B<rsub|\<epsilon\>><around|(|0|)>>.
  </lemma>

  <\proof>
    First, there is a <math|k=k<around|(|\<epsilon\>|)>> so that for any such
    <math|<around|(|P,P<rprime|'>|)>>, <math|\<Phi\><rsup|k><around|(|P|)>\<cap\>\<Phi\><rsup|k><around|(|P<rprime|'>|)>\<ne\>\<emptyset\>>.
    Otherwise, there are <math|<around|(|P<rsub|k>,P<rprime|'><rsub|k>|)>>
    and tilings <math|T<rsub|k>\<supset\>\<Phi\><rsup|k><around|(|P<rsub|k>|)>,T<rprime|'><rsub|k>\<supset\>\<Phi\><rsup|k><around|(|P<rprime|'><rsub|k>|)>>
    with <math|T<rsub|k>-x\<sim\><rsub|s>T<rprime|'><rsub|k>-x> for all
    <math|x\<in\>B<rsub|\<lambda\><rsup|k>*\<epsilon\>><around|(|0|)>> and
    with <math|B<rsub|0><around|[|T<rsub|k>|]>\<ne\>B<rsub|0><around|[|T<rprime|'><rsub|k>|]>>.
    This violates Lemma <reference|existence of R>. Now, for this <math|k>
    and for all such pairs <math|<around|(|P,P<rprime|'>|)>>, the elements of
    the pairs <math|<around|(|\<Phi\><rsup|k><around|(|P|)>,\<Phi\><rsup|k><around|(|P<rprime|'>|)>|)>>
    share a tile and have diameters bounded by <math|\<lambda\><rsup|k>*r>.
    By finite local complexity, there are, up to translation, only finitely
    many such <math|<around|(|\<Phi\><rsup|k><around|(|P|)>,\<Phi\><rsup|k><around|(|P<rprime|'>|)>|)>>
    and hence, only finitely many <math|<around|(|P,P<rprime|'>|)>>.
  </proof>

  <\proposition>
    <label|finitely many asymptotic partners>If <math|\<Omega\>> is a
    non-periodic, FLC, self-similar substitution tiling space and
    <math|T\<in\>\<Omega\>> is a branch point then there are finitely many
    <math|T<rprime|'>\<in\>\<Omega\>> such that
    <math|<around|(|T,T<rprime|'>|)>> is a branch pair.
  </proposition>

  <\proof>
    Let <math|\<Phi\>> be the substitution with associated inflation
    <math|\<lambda\>>. Suppose <math|<around|(|T,T<rsub|k><rprime|'>|)>>,
    <math|k\<in\>\<bbb-N\>> are branch pairs. It follows from Lemma
    <reference|existence of R> and finite local complexity that there is a
    subsequence <math|<around|{|T<rprime|'><rsub|k<rsub|i>>|}>> and an
    <math|R> so that, for each <math|m\<in\>\<bbb-N\>>, the
    <math|B<rsub|R><around|[|\<Phi\><rsup|-m><around|(|T<rprime|'><rsub|k<rsub|i>>|)>|]>>
    all share a tile. There is <math|M> so that if
    <math|<around|{|T<rsub|1>,\<ldots\>,T<rsub|M>|}>> are any <math|M>
    tilings that satisfy <math|\<cap\><rsub|i+1><rsup|M>B<rsub|R><around|[|T<rsub|i>|]>\<ne\>\<emptyset\>>,
    then <math|B<rsub|1><around|[|T<rsub|i>|]>=B<rsub|1><around|[|T<rsub|j>|]>>
    for some <math|i\<ne\>j\<in\><around|{|1,\<ldots\>,M|}>>. If the
    <math|T<rprime|'><rsub|k<rsub|i>>>, <math|i=1,\<ldots\>,M>, are all
    distinct, then there is <math|r> so that the patches
    <math|B<rsub|r><around|[|T<rprime|'><rsub|k<rsub|i>>|]>>,
    <math|i=1,\<ldots\>,M> are all distinct. Let <math|m\<in\>\<bbb-N\>> be
    large enough so that <math|\<lambda\><rsup|m>\<gtr\>r>. There are then
    <math|i\<ne\>j\<in\><around|{|1,\<ldots\>,M|}>> so that
    <math|B<rsub|1><around|[|\<Phi\><rsup|-m><around|(|T<rprime|'><rsub|k<rsub|i>>|)>|]>=B<rsub|1><around|[|\<Phi\><rsup|-m><around|(|T<rprime|'><rsub|k<rsub|j>>|)>|]>>.
    But then <math|B<rsub|r><around|[|T<rprime|'><rsub|k<rsub|i>>|]>=B<rsub|r><around|[|T<rprime|'><rsub|k<rsub|j>>|]>>,
    contradicting the choice of <math|r>.
  </proof>

  <\corollary>
    <label|periodic branch points>If <math|<around|(|T,T<rprime|'>|)>> is a
    branch pair and <math|T> is <math|\<Phi\>>-periodic, then so is
    <math|T<rprime|'>>.
  </corollary>

  In case <math|T> is a branch point and <math|T> is <math|\<Phi\>>-periodic,
  <math|T> will be called a <with|font-shape|italic|periodic branch point>, a
  branch pair <math|<around|(|T,T<rprime|'>|)>> will be called a
  <with|font-shape|italic|periodic branch pair> and we'll denote the
  collection of all periodic branch pairs by
  <math|<with|math-font|cal|P*B*P><around|(|\<Phi\>|)>>.

  <\lemma>
    <label|sector open>Suppose that <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>>
    is a <math|d>-dimensional, non-periodic, FLC, self-similar substitution
    tiling space. If <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|P*B*P><around|(|\<Phi\>|)>>
    is a periodic branch pair then <math|S<around|(|T,T<rprime|'>|)>> is open
    in <math|\<bbb-S\><rsup|d-1>>.
  </lemma>

  <\proof>
    With no loss of generality, we may assume that <math|T> and
    <math|T<rprime|'>> are fixed by <math|\<Phi\>>. Let <math|\<lambda\>> be
    the expansion factor for <math|\<Phi\>>. Given
    <math|v\<in\>S<around|(|T,T<rprime|'>|)>> and
    <math|t\<in\><around|[|1,\<lambda\>|]>> there is
    <math|\<epsilon\><around|(|t|)>\<gtr\>0> so that
    <math|T-t*v-x\<sim\><rsub|s>T<rprime|'>-t*v-x> for all
    <math|x\<in\>B<rsub|\<epsilon\><around|(|t|)>><around|(|0|)>> (Lemma
    <reference|stable mfd>). From compactness of
    <math|<around|[|1,\<lambda\>|]>>, there is <math|\<epsilon\>\<gtr\>0> so
    that if <math|w\<in\>\<bbb-S\><rsup|d-1>\<cap\>B<rsub|\<epsilon\>><around|(|v|)>>
    then <math|T-t*w\<sim\><rsub|s>T<rprime|'>-t*w> for all
    <math|t\<in\><around|[|1,\<lambda\>|]>>. For such <math|w>, any
    <math|n\<in\><Z>>, and <math|t\<in\><around|[|1,\<lambda\>|]>>,
    <math|T-\<lambda\><rsup|n>*t*w=\<Phi\><rsup|n>*<around|(|T-t*w|)>\<sim\><rsub|s>\<Phi\><rsup|n>*<around|(|T<rprime|'>-t*w|)>=T<rprime|'>-\<lambda\><rsup|n>*t*w>.
    Thus <math|T-t*w\<sim\><rsub|s>T<rprime|'>-t*w> for all
    <math|t\<in\>\<cup\><rsub|n\<in\><Z>>\<lambda\><rsup|n><around|[|1,\<lambda\>|]>=<R><rsup|+>>.
    That is, <math|\<bbb-S\><rsup|d-1>\<cap\>B<rsub|\<epsilon\>><around|(|v|)>\<subset\>S<around|(|T,T<rprime|'>|)>>.
  </proof>

  <\lemma>
    <label|finitely many patches>Suppose that
    <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>> is a non-periodic, FLC,
    self-similar substitution tiling space. Then for each <math|r> there are,
    up to translation, only finitely many pairs of patches of the form
    <math|<around|(|B<rsub|r><around|[|T|]>,B<rsub|r><around|[|T<rprime|'>|]>|)>>
    with <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>.
    Furthermore, if <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    and <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<to\><around|(|T,T<rprime|'>|)>>
    in <math|\<Omega\>\<times\>\<Omega\>>, then, for sufficiently large
    <math|n>, there are <math|x<rsub|n>\<to\>0> so that
    <math|<around|(|B<rsub|r><around|[|T<rsub|n>|]>,B<rsub|r><around|[|T<rprime|'><rsub|n>|]>|)>=<around|(|B<rsub|r>*<around|[|T-x<rsub|n>|]>,B<rsub|r>*<around|[|T<rprime|'>-x<rsub|n>|]>|)>>.
  </lemma>

  <\proof>
    The first statement follows immediately from Lemma <reference|finitely
    many patch pairs>.

    Suppose that <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    and <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<to\><around|(|T,T<rprime|'>|)>>
    in <math|\<Omega\>\<times\>\<Omega\>> and let <math|r> be given. There
    are then <math|x<rsub|n>> and <math|y<rsub|n>> so that
    <math|B<rsub|r><around|[|T<rsub|n>|]>=B<rsub|r>*<around|[|T-x<rsub|n>|]>>
    and <math|B<rsub|r><around|[|T<rprime|'><rsub|n>|]>=B<rsub|r>*<around|[|T<rprime|'>-y<rsub|n>|]>>
    for all sufficiently large <math|n>, with
    <math|x<rsub|n>,y<rsub|n>\<to\>0>. If <math|x<rsub|n>-y<rsub|n>\<to\>0>
    takes on infinitely many different values, we would have infinitely many
    translationally independent pairs <math|<around|(|B<rsub|r><around|[|T<rsub|n>|]>,B<rsub|r><around|[|T<rprime|'><rsub|n>|]>|)>>.
    Thus <math|x<rsub|n>=y<rsub|n>> for sufficiently large <math|n>.
  </proof>

  <\lemma>
    <label|periodic tilings>Suppose that <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>>
    is a non-periodic, FLC, self-similar substitution tiling space and
    <math|T\<in\>\<Omega\>> has the property that
    <math|B<rsub|r><around|[|\<Phi\><rsup|-n><around|(|T|)>|]>=B<rsub|r><around|[|\<Phi\><rsup|-n<rsub|1>><around|(|T|)>|]>>
    for some <math|r\<ge\>0>, <math|n<rsub|1>\<in\><N>>, and for infinitely
    many <math|n\<in\><N>>. Then <math|T> is <math|\<Phi\>>-periodic.
  </lemma>

  <\proof>
    Say <math|B<rsub|r><around|[|\<Phi\><rsup|-n<rsub|i>><around|(|T|)>|]>=B<rsub|r><around|[|\<Phi\><rsup|-n<rsub|1>><around|(|T|)>|]>=:P>
    for <math|i\<in\><N>>. Let <math|m=m*i*n*<around|{|n\<in\><N>:P\<subset\>\<Phi\><around|(|P|)>|}>>.
    Since <math|\<Phi\><around|(|B<rsub|r><around|[|T<rprime|'>|]>|)>\<supset\>B<rsub|\<lambda\>*r<rprime|'>><around|[|\<Phi\><around|(|T<rprime|'>|)>|]>\<supset\>B<rsub|r><around|[|\<Phi\><around|(|T<rprime|'>|)>|]>>
    for any <math|T<rprime|'>\<in\>\<Omega\>>, where <math|\<lambda\>> is the
    expansion factor of <math|\<Phi\>> and <math|r<rprime|'>=r> if
    <math|r\<gtr\>0> and, if <math|r=0> then <math|r<rprime|'>\<gtr\>0> is
    such that <math|B<rsub|r<rprime|'>><around|(|0|)>\<subset\>s*p*t<around|(|B<rsub|0><around|[|T<rprime|'>|]>|)>>,
    we see that <math|m> divides <math|n<rsub|i>-n<rsub|1>> for all <math|i>.
    Say <math|n<rsub|i>=n<rsub|1>+m*k<rsub|i>> and let
    <math|<wide|T|\<bar\>>\<in\>\<Omega\>> be defined by
    <math|<wide|T|\<bar\>>\<assign\>\<Phi\><rsup|n<rsub|1>>(\<cup\><rsub|k\<in\><N>>\<Phi\><rsup|m*k><around|(|B<rsub|r><around|[|\<Phi\><rsup|-n<rsub|1>><around|[|T|]>|)>|)>=\<cup\><rsub|k\<in\><N>>\<Phi\><rsup|m*k><around|(|B<rsub|r><around|[|T|]>|)>>.
    Then <math|\<Phi\><rsup|m><around|(|<wide|T|\<bar\>>|)>=<wide|T|\<bar\>>>.
    Since the union in the definition of <math|<wide|T|\<bar\>>> is nested
    and <math|k<rsub|i>\<to\>\<infty\>>, <math|<wide|T|\<bar\>>=\<Phi\><rsup|n<rsub|1>>(\<cup\><rsub|i\<in\><N>>\<Phi\><rsup|m*k<rsub|i>><around|(|B<rsub|r><around|[|\<Phi\><rsup|-n<rsub|1>><around|(|T|)>|]>|)>)=\<Phi\><rsup|n<rsub|1>>(\<cup\><rsub|i\<in\><N>>\<Phi\><rsup|m*k<rsub|i>><around|(|B<rsub|r><around|[|\<Phi\><rsup|-n<rsub|1>-m*k<rsub|i>><around|(|T|)>|]>|)>)\<subset\>\<Phi\><rsup|n<rsub|1>>(\<cup\><rsub|i\<in\><N>>B<rsub|\<lambda\><rsup|m*k<rsub|i>>*r<rprime|'>><around|[|\<Phi\><rsup|-n<rsub|1>><around|(|T|)>|]>)\<subset\>\<Phi\><rsup|n<rsub|1>><around|(|\<Phi\><rsup|-n<rsub|1>><around|(|T|)>|)>=T>.
    Thus <math|T=<wide|T|\<bar\>>> is periodic.
  </proof>

  <\proposition>
    <label|periodic branch pairs exist>Suppose that
    <math|\<Omega\>=\<Omega\><around|(|\<Phi\>|)>> is a <math|d>-dimensional,
    non-periodic, FLC, self-similar substitution tiling space and
    <math|S\<subset\>\<bbb-S\><rsup|d-1>> contains a closed hemisphere in its
    interior, then any branch pair <math|<around|(|T,T<rprime|'>|)>> with
    <math|S\<subset\>S<around|(|T,T<rprime|'>|)>> is periodic and there are
    at most finitely many such.
  </proposition>

  <\proof>
    Let <math|u\<in\>\<bbb-S\><rsup|d-1>> be such that
    <math|<around|{|v\<in\>\<bbb-S\><rsup|d-1>:<around|\<langle\>|v,u|\<rangle\>>\<ge\>0|}>\<subset\>S>,
    and let <math|<wide|H|\<bar\>>=<around|{|x\<in\><R><rsup|d>:<around|\<langle\>|x,u|\<rangle\>>\<ge\>0|}>>.
    Suppose that <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>> are branch
    pairs with <math|S\<subset\>S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>>
    for <math|n\<in\><N>>. By Lemma <reference|finitely many patches>, there
    are, up to translation, only finitely many pairs
    <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|k><around|(|T<rsub|n>|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|k><around|(|T<rprime|'><rsub|n>|)>|]>|)>>
    for <math|n\<in\><N>> and <math|k\<in\><Z>>. Suppose that
    <math|n<rsub|1>,n<rsub|2>,k<rsub|1>,k<rsub|2>> and <math|x> are such that
    <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|k<rsub|1>><around|(|T<rsub|n<rsub|1>>|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|k<rsub|1>><around|(|T<rprime|'><rsub|n<rsub|1>>|)>|]>|)>=<around|(|B<rsub|1><around|[|\<Phi\><rsup|k<rsub|2>><around|(|T<rsub|n<rsub|2>>|)>|]>-x,B<rsub|1><around|[|\<Phi\><rsup|k<rsub|2>><around|(|T<rprime|'><rsub|n<rsub|2>>|)>|]>-x|)>>.
    The fact that <math|B<rsub|1><around|[|\<Phi\><rsup|k<rsub|1>><around|(|T<rsub|n<rsub|1>>|)>|]>>
    is stably related to <math|B<rsub|1><around|[|\<Phi\><rsup|k<rsub|1>><around|(|T<rprime|'><rsub|n<rsub|1>>|)>|]>>
    on <math|i*n*t*<around|(|s*p*t<around|(|B<rsub|1><around|[|\<Phi\><rsup|k<rsub|1>><around|(|T<rsub|n<rsub|1>>|)>|]>|)>|)>\<cap\>i*n*t*<around|(|s*p*t<around|(|B<rsub|1><around|[|\<Phi\><rsup|k<rsub|1>><around|(|T<rprime|'><rsub|n<rsub|1>>|)>|]>|)>|)>\<cap\><around|(|<wide|H|\<bar\>>\<setminus\><around|{|0|}>|)>>
    while <math|B<rsub|1><around|[|\<Phi\><rsup|k<rsub|2>><around|(|T<rsub|n<rsub|2>>|)>|]>-x>
    is not stably related to <math|B<rsub|1><around|[|\<Phi\><rsup|k<rsub|2>><around|(|T<rprime|'><rsub|n<rsub|2>>|)>|]>-x>
    on <math|<around|{|x|}>> means that <math|x\<nin\><wide|H|\<bar\>>\<setminus\><around|{|0|}>>.
    The preceding statement remains valid if <math|n<rsub|1>> and
    <math|n<rsub|2>> are switched, <math|k<rsub|1>> and <math|k<rsub|2>> are
    switched, and <math|x> is replaced by <math|-x>. We have that
    <math|x\<nin\><wide|H|\<bar\>>\<setminus\><around|{|0|}>> and
    <math|-x\<nin\><wide|H|\<bar\>>\<setminus\><around|{|0|}>>; hence
    <math|x=0>.

    Now fix <math|n>. There must be <math|m\<gtr\>0> and
    <math|l<rsub|i>\<to\>-\<infty\>> so that
    <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|l<rsub|i>><around|(|T<rsub|n>|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|l<rsub|i>><around|(|T<rprime|'><rsub|n>|)>|]>|)>>
    and <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|l<rsub|i>+m><around|(|T<rsub|n>|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|l<rsub|i>+m><around|(|T<rprime|'><rsub|n>|)>|]>|)>>
    are the same up to translation for each <math|i>. From the above,
    <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|l<rsub|i>><around|(|T<rsub|n>|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|l<rsub|i>><around|(|T<rprime|'><rsub|n>|)>|]>|)>=<around|(|B<rsub|1><around|[|\<Phi\><rsup|l<rsub|i>+m><around|(|T<rsub|n>|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|l<rsub|i>+m><around|(|T<rprime|'><rsub|n>|)>|]>|)>>
    for each <math|i>. By Lemma <reference|periodic tilings>,
    <math|T<rsub|n>> and <math|T<rprime|'><rsub|n>> are periodic.

    Since we have only finitely many distinct pairs
    <math|<around|(|B<rsub|1><around|[|T<rsub|n>|]>,B<rsub|1><around|[|T<rprime|'><rsub|n>|]>|)>>
    and since <math|B<rsub|1><around|[|T<rsub|n>|]>=B<rsub|1><around|[|T<rsub|m>|]>>
    and <math|T<rsub|n>,T<rsub|m>> periodic implies that
    <math|T<rsub|n>=T<rsub|m>>, we have only finitely many branch pairs with
    asymptotic sector containing <math|S>, all of which are periodic.
  </proof>

  <\proposition>
    <label|branch points>If <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>> is a
    <math|d>-dimensional, non-periodic, FLC, self-similar substitution tiling
    space and <math|T\<ne\>T<rprime|'>\<in\>\<Omega\>> agree on a set
    <math|X=<around|{|v\<in\>\<bbb-S\><rsup|d-1>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>\<alpha\>|}>>
    for some <math|u\<in\>\<bbb-S\><rsup|d-1>> and <math|\<alpha\>\<le\>0>,
    then there is a branch pair <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    with <math|X\<cap\>\<bbb-S\><rsup|d-1>\<subset\>S<around|(|<wide|T|\<bar\>>,<wide|T<rprime|'>|\<bar\>>|)>>.
    Moreover, if <math|\<alpha\>\<less\>0>, we may take
    <math|<wide|T|\<bar\>>=T-z> and <math|<wide|T|\<bar\>><rprime|'>=T-z> for
    some <math|z\<in\><R><rsup|d>>.
  </proposition>

  <\proof>
    Let <math|\<lambda\>> be the expansion factor for <math|\<Phi\>>. For
    each <math|n\<in\>\<bbb-N\>>, let <math|T<rsub|n>\<assign\>\<Phi\><rsup|-n><around|(|T|)>>
    and <math|T<rprime|'><rsub|n>\<assign\>\<Phi\><rsup|-n><around|(|T<rprime|'>|)>>.
    Then <math|T<rsub|n>-x\<sim\><rsub|s>T<rprime|'><rsub|n>-x> for all
    <math|x\<in\>X> and all <math|n\<in\>\<bbb-N\>>. It follows from Lemma
    <reference|existence of R> that there is an <math|R\<gtr\>0> so that
    <math|T<rsub|n>> and <math|T<rprime|'><rsub|n>> agree on
    <math|<around|{|R*u|}>> for all n. Just as in the proof of Lemma
    <reference|finitely many patches> there are, up to translation, only
    finitely many pairs of patches <math|<around|(|B<rsub|r><around|[|T<rsub|n>|]>,B<rsub|r><around|[|T<rprime|'><rsub|n>|]>|)>>
    for any particular <math|r>. Choose a subsequence
    <math|<around|{|n<rsub|i>|}>> so that
    <math|T<rsub|n<rsub|i>>\<to\><wide|T|\<bar\>>\<in\>\<Omega\>> and
    <math|T<rprime|'><rsub|n<rsub|i>>\<to\><wide|T|\<bar\>><rprime|'>\<in\>\<Omega\>>
    as <math|i\<to\>\<infty\>>. By Lemma <reference|T=T'>, there is a
    <math|y> so that <math|T-y\<nsim\><rsub|s>T<rprime|'>-y>. Then
    <math|T<rsub|n<rsub|i>>-y<rsub|n<rsub|i>>\<nsim\><rsub|s>T<rprime|'><rsub|n<rsub|i>>-y<rsub|n<rsub|i>>>
    for all <math|i> where <math|y<rsub|k>\<assign\>\<lambda\><rsup|-k>*y>,
    since <math|T<rsub|n<rsub|i>>-y<rsub|n<rsub|i>>\<to\><wide|T|\<bar\>>>
    and <math|T<rprime|'><rsub|n<rsub|i>>-y<rsub|n<rsub|i>>\<to\><wide|T|\<bar\>><rprime|'>>,
    <math|<wide|T|\<bar\>>\<nsim\><rsub|s><wide|T|\<bar\>><rprime|'>>.
    Suppose that <math|v> is such that <math|<wide|T|\<bar\>>-v\<nsim\><rsub|s><wide|T|\<bar\>><rprime|'>-v>.
    Let <math|r=<around|\||v|\|>+1>. For large enough <math|i> there are
    <math|x<rsub|n<rsub|i>>> and <math|x<rprime|'><rsub|n<rsub|i>>>, with
    <math|<around|\||x<rsub|n<rsub|i>>|\|>\<less\>1>,
    <math|<around|\||x<rprime|'><rsub|n<rsub|i>>|\|>\<less\>1>,
    <math|x<rsub|n<rsub|i>>\<to\>0> and <math|x<rprime|'><rsub|n<rsub|i>>\<to\>0>,
    so that <math|B<rsub|r><around|[|T<rsub|n<rsub|i>>|]>\<subset\>B<rsub|r+1><around|[|<wide|T|\<bar\>>|]>-x<rsub|n<rsub|i>>>
    and <math|B<rsub|r><around|[|T<rprime|'><rsub|n<rsub|i>>|]>\<subset\>B<rsub|r+1><around|[|<wide|T|\<bar\>><rprime|'>|]>-x<rprime|'><rsub|n<rsub|i>>>.
    Since there are only finitely many pairs
    <math|<around|(|B<rsub|r><around|[|T<rsub|n<rsub|i>>|]>,B<rsub|r><around|[|T<rprime|'><rsub|n<rsub|i>>|]>|)>>,
    up to translation, there are arbitrarily large <math|i> for which
    <math|x<rsub|n<rsub|i>>=x<rprime|'><rsub|n<rsub|i>>>. For such <math|i>,
    <math|v-x<rsub|n<rsub|i>>\<in\>i*n*t*<around|(|s*p*t<around|(|B<rsub|r><around|[|T<rsub|n<rsub|i>>|]>|)>|)>\<cap\>i*n*t*<around|(|s*p*t<around|(|B<rsub|r><around|[|T<rprime|'><rsub|n<rsub|i>>|]>|)>|)>>
    so that <math|T<rsub|n<rsub|i>>-<around|(|v-x<rsub|n<rsub|i>>|)>\<sim\><rsub|s>T<rprime|'><rsub|n<rsub|i>>-<around|(|v-x<rsub|n<rsub|i>>|)>>
    if and only if <math|<wide|T|\<bar\>>-v\<sim\><rsub|s><wide|T|\<bar\>><rprime|'>-v>.
    Since <math|<wide|T|\<bar\>>-v\<nsim\><rsub|s><wide|T|\<bar\>><rprime|'>-v>,
    <math|T<rsub|n<rsub|i>>-<around|(|v-x<rsub|n<rsub|i>>|)>\<nsim\><rsub|s>T<rprime|'><rsub|n<rsub|i>>-<around|(|v-x<rsub|N<rsub|i>>|)>>,
    and hence <math|<around|\<langle\>|v-x<rsub|n<rsub|i>>,u|\<rangle\>>\<le\>\<alpha\>>.
    Since <math|x<rsub|n<rsub|i>>\<to\>0>,
    <math|<around|\<langle\>|v,u|\<rangle\>>\<le\>\<alpha\>>. In other words,
    <math|<wide|T|\<bar\>>-x\<sim\><rsub|s><wide|T|\<bar\>><rprime|'>-x> for
    all <math|x\<in\>X>.

    Suppose now that <math|\<alpha\>\<less\>0>. If
    <math|j<rsub|i>\<to\>\<infty\>> is any sequence so that
    <math|T<rsub|j<rsub|i>>\<to\><wide|T|\<bar\>><rsub|j>> and
    <math|T<rsub|j<rsub|i>>\<to\><wide|T|\<bar\>><rprime|'><rsub|j>>, the
    forgoing argument shows that <math|<around|(|<wide|T|\<bar\>><rsub|j>,<wide|T|\<bar\>><rprime|'><rsub|j>|)>>
    is a branch pair with <math|X\<cap\>\<bbb-S\><rsup|d-1>\<subset\>S<around|(|<wide|T|\<bar\>><rsub|j>,<wide|T|\<bar\>><rprime|'><rsub|j>|)>>.
    By Proposition <reference|periodic branch pairs exist>, there are only
    finitely many such branch pairs and they are all periodic. It must be the
    case that all these branch pairs are on the same periodic orbit under
    <math|\<Phi\>\<times\>\<Phi\>> (in general, if an <math|\<alpha\>>-limit
    set is finite it must be a single periodic orbit). Say this periodic
    orbit is <math|<around|{|<around|(|\<Phi\><rsup|k><around|(|<wide|T|\<bar\>>|)>,\<Phi\><rsup|k><around|(|<wide|T|\<bar\>><rprime|'>|)>|)>:k=1,\<ldots\>,m|}>>.
    There are then an <math|l> and <math|x<rsub|n>\<to\>0> so that
    <math|<around|(|B<rsub|1><around|[|T<rsub|n>|]>,B<rsub|1><around|[|T<rprime|'><rsub|n>|]>|)>=<around|(|B<rsub|1>*<around|[|\<Phi\><rsup|-n+l><around|(|<wide|T|\<bar\>>|)>+x<rsub|n>|]>,B<rsub|1>*<around|[|\<Phi\><rsup|-n+l><around|(|<wide|T|\<bar\>><rprime|'>|)>+x<rsub|n>|]>|)>>
    for large <math|n>. From this we see that
    <math|x<rsub|n>=\<lambda\>*x<rsub|n+1>> for sufficiently large <math|n>,
    say, for <math|n\<ge\>N>. We have <math|T<rsub|N>\<supset\>\<Phi\><rsup|k><around|(|B<rsub|1><around|[|T<rsub|N+k>|]>|)>=\<Phi\><rsup|k>*<around|(|B<rsub|1>*<around|[|\<Phi\><rsup|-N-k+l><around|(|<wide|T|\<bar\>>|)>+x<rsub|N+k>|]>|)>\<supset\>B<rsub|\<lambda\><rsup|k>>*<around|[|\<Phi\><rsup|-N+l><around|(|<wide|T|\<bar\>>|)>+x<rsub|N>|]>>
    for all <math|k\<in\><N>>. That is, <math|T<rsub|N>=\<Phi\><rsup|-N+l><around|(|<wide|T|\<bar\>>|)>+x<rsub|N>>.
    Similarly, <math|T<rprime|'><rsub|N>=\<Phi\><rsup|-N+l><around|(|<wide|T<rprime|'>|\<bar\>>|)>+x<rsub|n>>.
    Thus <math|<around|(|T-z,T<rprime|'>-z|)>=<around|(|\<Phi\><rsup|l><around|(|<wide|T|\<bar\>>|)>,\<Phi\><rsup|l><around|(|<wide|T|\<bar\>><rprime|'>|)>|)>>
    for <math|z=\<lambda\><rsup|N>*x<rsub|N>>.
  </proof>

  <\lemma>
    <label|branch points with direction>Suppose that
    <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>> is a <math|d>-dimensional,
    non-periodic, FLC, self-similar substitution tiling space and suppose
    that there are <math|T,T<rprime|'>\<in\>\<Omega\><rsub|\<Phi\>>>,
    <math|r\<gtr\>0>, and <math|u\<in\>\<bbb-S\><rsup|d-1>> so that
    <math|T-x\<sim\><rsub|s>T<rprime|'>-x> for all
    <math|x\<in\>B<rsub|r><around|(|0|)>> and
    <math|T-r*u\<nsim\><rsub|s>T<rprime|'>-r*u>. Then there is a pair
    <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    with <math|<around|{|v\<in\>\<bbb-S\><rsup|d-1>:<around|\<langle\>|v,-u|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>>.
  </lemma>

  <\proof>
    For <math|n\<in\><N>>, let <math|T<rsub|n>=\<Phi\><rsup|n>*<around|(|T-r*u|)>>
    and <math|T<rprime|'><rsub|n>=\<Phi\><rsup|n>*<around|(|T<rprime|'>-r*u|)>>.
    By Lemma <reference|existence of R>, there is an <math|R> so that
    <math|B<rsub|0>*<around|[|T<rsub|n>-y|]>=B<rsub|0>*<around|[|T<rprime|'><rsub|n>-y|]>>
    for all <math|y\<in\>B<rsub|\<lambda\><rsup|n>*r-R>*<around|(|\<lambda\><rsup|n>*r*u|)>>
    for each <math|n>. Let <math|<around|{|n<rsub|i>|}>> be a subsequence so
    that <math|T<rsub|n<rsub|i>>\<to\><wide|T|~>> and
    <math|T<rprime|'><rsub|n<rsub|i>>\<to\><wide|T<rprime|'>|~>>. Since
    <math|B<rsub|R+1><around|[|T<rsub|n>|]>> and
    <math|B<rsub|R+1><around|[|T<rprime|'><rsub|n>|]>> share a tile, finite
    local complexity insures that there are only finitely many pairs of
    patches <math|<around|(|B<rsub|R+1><around|[|T<rsub|n>|]>,B<rsub|R+1><around|[|T<rprime|'><rsub|n>|]>|)>>,
    up to translation. It follows that from
    <math|T<rsub|n<rsub|i>>\<nsim\><rsub|s>T<rprime|'><rsub|n<rsub|i>>>, that
    <math|<wide|T|~>\<ne\><wide|T|~><rprime|'>>. Now
    <math|<wide|T|~>+<around|(|R+1|)>*u\<ne\><wide|T|~><rprime|'>+<around|(|R+1|)>*u>
    and <math|B<rsub|0>*<around|[|<wide|T|~>+<around|(|R+1|)>*u-y|]>=B<rsub|0>*<around|[|<wide|T|~><rprime|'>+<around|(|R+1|)>*u-y|]>>
    for all <math|y\<in\><R><rsup|d>> with
    <math|<around|\<langle\>|y,-u|\<rangle\>><space|0.17em>\<gtr\>0>. The
    desired <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>>
    exists by Proposition <reference|branch points>.
  </proof>

  Let <math|\<Phi\>> be a substitution with branch pairs
  <math|<with|math-font|cal|B*P>=<with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  and periodic branch pairs <math|<with|math-font|cal|P*B*P>=<with|math-font|cal|P*B*P><around|(|\<Phi\>|)>>.
  Given <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P>>, let
  <math|<wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>\<assign\>{v\<in\>\<partial\>*S<around|(|T,T<rprime|'>|)>:\<exists\>t<rsub|i>\<to\>\<infty\>>
  such that <math|T-t<rsub|i>*v\<nsim\><rsub|s>T<rprime|'>-t<rsub|i>*v}>. The
  <with|font-shape|italic|branch locus> of <math|\<Omega\><rsub|\<Phi\>>> is
  the set

  <\equation*>
    <with|math-font|cal|B*L><around|(|\<Phi\>|)>\<assign\>\<cup\><rsub|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P>>c*l(\<cup\><rsub|t\<ge\>0,v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>><around|{|T-t*v|}>)
  </equation*>

  and the <with|font-shape|italic|periodic branch locus> is the set

  <\equation*>
    <with|math-font|cal|P*B*L><around|(|\<Phi\>|)>\<assign\>\<cup\><rsub|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|P*B*P>>c*l(\<cup\><rsub|t\<ge\>0,v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>><around|{|T-t*v|}>).
  </equation*>

  It follows from Propositions <reference|agree in half-space> and
  <reference|branch points> that <math|<with|math-font|cal|B*L><around|(|\<Phi\>|)>\<ne\>\<emptyset\>>
  for a non-periodic, FLC, self-similar substitution tiling space
  <math|\<Omega\><rsub|\<Phi\>>>.

  <\lemma>
    <label|branch pairs closed>If <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>> is
    a <math|d>-dimensional, non-periodic, FLC, self-similar substitution
    tiling space, then <math|<with|math-font|cal|B*P><around|(|\<Phi\>|)>> is
    closed in <math|\<Omega\>\<times\>\<Omega\>>. If
    <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    and <math|u<rsub|n>\<in\>\<bbb-S\><rsup|d-1>>, <math|n\<in\><N>>, are
    such that <math|<around|{|v\<in\>\<bbb-S\><rsup|d-1>:<around|\<langle\>|v,u<rsub|n>|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>>;
    <math|u> is an accumulation point of <math|<around|{|u<rsub|n>:n\<in\><N>|}>>;
    and <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<to\><around|(|T,T<rprime|'>|)>>;
    then <math|<around|{|v\<in\>\<bbb-S\><rsup|d-1>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T,T<rprime|'>|)>>.
  </lemma>

  <\proof>
    Suppose <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    with <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<to\><around|(|T,T<rprime|'>|)>\<in\>\<Omega\>\<times\>\<Omega\>>.
    Let <math|u<rsub|n>\<in\>\<bbb-S\><rsup|d-1>> be such that
    <math|<around|{|v\<in\>\<bbb-S\><rsup|d-1>:<around|\<langle\>|v,u<rsub|n>|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>>.
    By passing to a subsequence, we may assume that <math|u<rsub|n>\<to\>u>
    as <math|n\<to\>\<infty\>>. As in the proof of Proposition
    <reference|branch points>, there are <math|x<rsub|n>\<to\>0> so that
    <math|<around|(|B<rsub|1><around|[|T<rsub|n>|]>,B<rsub|1><around|[|T<rprime|'><rsub|n>|]>|)>=<around|(|B<rsub|1>*<around|[|T-x<rsub|n>|]>,B<rsub|1>*<around|[|T<rprime|'>-x<rsub|n>|]>|)>>
    for all sufficiently large <math|n>. If <math|B<rsub|1><around|[|T|]>>
    and <math|B<rsub|1><around|[|T<rprime|'>|]>> are stably related on
    <math|<around|{|0|}>> then they are stably related on
    <math|B<rsub|\<epsilon\>><around|(|0|)>> for some
    <math|\<epsilon\>\<gtr\>0> (Lemma <reference|stable mfd>). But then
    <math|B<rsub|1><around|[|T<rsub|n>|]>> would be stably related to
    <math|B<rsub|1><around|[|T<rprime|'><rsub|n>|]>> for <math|n> large
    enough so that <math|<around|\||x<rsub|n>|\|>\<less\>\<epsilon\>>,
    contrdicting <math|T<rsub|n>\<nsim\><rsub|s>T<rprime|'><rsub|n>>. Thus
    <math|T\<nsim\><rsub|s>T<rprime|'>>.

    Let <math|z\<in\><R><rsup|n>> be such that
    <math|<around|\<langle\>|z,u|\<rangle\>><space|0.17em>\<gtr\>0> and let
    <math|r=<around|\||z|\|>+1>. For sufficiently large <math|n>,
    <math|<around|(|B<rsub|r><around|[|T<rsub|n>|]>,B<rsub|r><around|[|T<rprime|'><rsub|n>|]>|)>=<around|(|B<rsub|r>*<around|[|T-x<rsub|n>|]>,B<rsub|r>*<around|[|T<rprime|'>-x<rsub|n>|]>|)>>.
    Then <math|B<rsub|r><around|[|T|]>> is stably related to
    <math|B<rsub|r><around|[|T<rprime|'>|]>> on <math|<around|{|z|}>> if and
    only if <math|B<rsub|r><around|[|T<rsub|n>|]>> is stably related to
    <math|B<rsub|r><around|[|T<rprime|'><rsub|n>|]>> on
    <math|<around|{|z-x<rsub|n>|}>> (for large <math|n>). Since
    <math|u<rsub|n>\<to\>u>, <math|x<rsub|n>\<to\>0>, and
    <math|<around|\<langle\>|z,u|\<rangle\>><space|0.17em>\<gtr\>0>,
    <math|<around|\<langle\>|z-x<rsub|n>,u<rsub|n>|\<rangle\>><space|0.17em>\<gtr\>0>
    for sufficiently large <math|n>. For such <math|n>,
    <math|<around|(|z-x<rsub|n>|)>/<around|\||z-x<rsub|n>|\|>\<in\>S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>>
    so <math|T<rsub|n>-<around|(|z-x<rsub|n>|)>\<sim\><rsub|s>T<rprime|'>-<around|(|z-x<rsub|n>|)>>;
    hence <math|B<rsub|r><around|[|T<rsub|n>|]>> is stably related to
    <math|B<rsub|r><around|[|T<rprime|'><rsub|n>|]>> on
    <math|<around|{|z-x<rsub|n>|}>>, <math|B<rsub|r><around|[|T|]>> is stably
    related to <math|B<rsub|r><around|[|T<rprime|'>|]>> on
    <math|<around|{|z|}>>, and <math|T-z\<sim\><rsub|s>T<rprime|'>-z>. So
    <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    with <math|<around|{|v\<in\>\<bbb-S\><rsup|d-1>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T,T<rprime|'>|)>>.
  </proof>

  <\theorem>
    <label|topological invariance 1>Suppose that
    <math|\<Omega\><rsub|\<Phi\>>> and <math|\<Omega\><rsub|\<Psi\>>> are
    homeomorphic <math|d>-dimensional, non-periodic, FLC, self-similar
    substitution tiling spaces and suppose that there are distinct tilings
    <math|T<rsub|0>,T<rsub|0><rprime|'>\<in\>\<Omega\><rsub|\<Phi\>>> for
    which there is <math|S\<subset\>\<bbb-S\><rsup|d-1>> that contains a
    closed hemisphere in its interior such that <math|T<rsub|0>> and
    <math|T<rsub|0><rprime|'>> are uniformly asymptotic in directions
    <math|S>. Then there is a homeomorphism from
    <math|\<Omega\><rsub|\<Phi\>>> onto <math|\<Omega\><rsub|\<Psi\>>> that
    takes <math|<with|math-font|cal|B*L><around|(|\<Phi\>|)>> onto
    <math|<with|math-font|cal|B*L><around|(|\<Psi\>|)>> and
    <math|<with|math-font|cal|P*B*L><around|(|\<Phi\>|)>> onto
    <math|<with|math-font|cal|P*B*L><around|(|\<Psi\>|)>>.
  </theorem>

  <\proof>
    By Theorem 1.1 of <cite|Kwapisz>, there is a homeomorphism
    <math|h<rsub|0>:\<Omega\><rsub|\<Phi\>>\<to\>\<Omega\><rsub|\<Psi\>>> and
    a linear isomorphism <math|L> of <math|\<bbb-R\><rsup|d>> with
    <math|h<rsub|0>*<around|(|T-x|)>=h<rsub|0><around|(|T|)>-L*x> for all
    <math|T\<in\>\<Omega\><rsub|\<Phi\>>> and all
    <math|x\<in\>\<bbb-R\><rsup|d>>. Let <math|u\<in\>\<bbb-S\><rsup|d-1>>
    and <math|\<alpha\>\<less\>0> be such that
    <math|<around|{|v\<in\>\<bbb-S\><rsup|d-1>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>\<alpha\>|}>\<subset\>S>.
    By Lemma <reference|asymptotic directions> and Propositions
    <reference|periodic branch pairs exist> and <reference|branch points>,
    there is <math|x<rsub|0>> so that <math|T<rsub|0>-x<rsub|0>> and
    <math|T<rprime|'><rsub|0>-x<rsub|0>> are <math|\<Phi\>>-periodic. Since
    <math|T<rsub|0>-x<rsub|0>> and <math|T<rprime|'><rsub|0>-x<rsub|0>> are
    uniformly asymptotic in directions <math|S>, it follows (from the
    \Plinear" nature of <math|h<rsub|0>>) that
    <math|h<rsub|0>*<around|(|T<rsub|0>-x<rsub|0>|)>> and
    <math|h<rsub|0>*<around|(|T<rprime|'><rsub|0>-x<rsub|0>|)>> are uniformly
    asymptotic in directions <math|S<rprime|'>\<assign\><around|{|L*v/<around|\||L*v|\|>:v\<in\>S|}>>.
    The set of directions <math|S<rprime|'>> must also contain a closed
    hemisphere in its interior, so, again by Lemma <reference|asymptotic
    directions> and Propositions <reference|periodic branch pairs exist> and
    <reference|branch points>, there is <math|y<rsub|0>> so that
    <math|h<rsub|0>*<around|(|T<rsub|0>-x<rsub|0>|)>-y<rsub|0>> and
    <math|h<rsub|0>*<around|(|T<rprime|'><rsub|0>-x<rsub|0>|)>-y<rsub|0>> are
    <math|\<Psi\>>-periodic. Let <math|h<rsub|1>:\<Omega\><rsub|\<Phi\>>\<to\>\<Omega\><rsub|\<Psi\>>>
    be defined by <math|h<rsub|1><around|(|T|)>\<assign\>h*<around|(|T-x<rsub|0>|)>-y<rsub|0>>.
    Since the homeomorphism <math|h<rsub|1>> is now \Ppinned down" in that it
    takes a particular <math|\<Phi\>>-periodic point to a
    <math|\<Psi\>>-periodic point, Corollary 1.5 of <cite|Kwapisz> guarantees
    that there is a homeomorphism <math|h:\<Omega\><rsub|\<Phi\>>\<to\>\<Omega\><rsub|\<Psi\>>>
    together with positive integers <math|m,n> so that
    <math|h\<circ\>\<Phi\><rsup|m>=\<Psi\><rsup|n>\<circ\>h>. Such an
    <math|h> necessarily takes <math|\<Phi\>>-periodic points to
    <math|\<Psi\>>-periodic points and <math|\<Phi\>>-stable manifolds to
    <math|\<Psi\>>-stable manifolds and it follows that
    <math|h<around|(|<with|math-font|cal|B*L><around|(|\<Phi\>|)>|)>=<with|math-font|cal|B*L><around|(|\<Psi\>|)>>
    and <math|h<around|(|<with|math-font|cal|P*B*L><around|(|\<Phi\>|)>|)>=<with|math-font|cal|P*B*L><around|(|\<Psi\>|)>>
  </proof>

  The branch locus may be rather difficult to describe in general. But in
  dimension two (as in dimension one) we will see that there are only
  finitely many sectors <math|S<around|(|T,T<rprime|'>|)>> for a given
  <math|\<Phi\>>, which considerably simplifies the situation. We turn to
  that case now.

  <section|Two-dimensional tilings><label|2-d>

  All 2-dimensional substitution tiling spaces in this section will be
  assumed to be non-periodic, primitive, self-similar, and have finite
  translational local complexity. For the sake of convenience, we will also
  assume all tiles have convex polygonal support.

  <\lemma>
    <label|all sectors open>If <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>> is a
    <math|2>-dimensional, non-periodic, FLC, self-similar substitution tiling
    space and <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    then <math|S<around|(|T,T<rprime|'>|)>> is open.
  </lemma>

  <\proof>
    Given <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>,
    if <math|S<around|(|T,T<rprime|'>|)>> contains a closed half-space in its
    interior, then <math|<around|(|T,T<rprime|'>|)>> is periodic and
    <math|S<around|(|T,T<rprime|'>|)>> is open by Lemma <reference|sector
    open>. So we may suppose that <math|\<partial\>*S<around|(|T,T<rprime|'>|)>=<around|{|v,-v|}>>
    for some <math|v\<in\>\<bbb-S\><rsup|1>>. Let
    <math|u\<in\>\<bbb-S\><rsup|1>> be such that
    <math|<around|{|v\<in\>\<bbb-S\><rsup|1>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T,T<rprime|'>|)>>.
    For <math|n\<in\><Z>>, let <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<assign\><around|(|\<Phi\><rsup|-n><around|(|T|)>,\<Phi\><rsup|-n><around|(|T<rprime|'>|)>|)>>.
    Choose a subsequence <math|n<rsub|i>> so that
    <math|<around|(|T<rsub|n<rsub|i>>,T<rprime|'><rsub|n<rsub|i>>|)>\<to\><around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>>
    as <math|i\<to\>\<infty\>>. Then <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>,
    <math|<around|{|v\<in\>\<bbb-S\><rsup|1>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>>,
    and there are <math|x<rsub|i>\<to\>0> so that
    <math|<around|(|B<rsub|1><around|[|T<rsub|n<rsub|i>>|]>,B<rsub|1><around|[|T<rprime|'><rsub|n<rsub|i>>|]>|)>=<around|(|B<rsub|1>*<around|[|<wide|T|\<bar\>>-x<rsub|i>|]>,B<rsub|1>*<around|[|<wide|T|\<bar\>><rprime|'>-x<rsub|i>|]>|)>>
    for sufficiently large <math|i> (Lemmas <reference|branch pairs closed>
    and <reference|finitely many patches>).

    Let <math|<math-bf|l>> be the line <math|<math-bf|l>\<assign\><around|{|t*v:t\<in\><R>|}>>
    and let <math|D<rsup|+>> be the component of
    <math|B<rsub|1><around|(|0|)>\<setminus\><math-bf|l>> that contains
    <math|1/2*u>. Then <math|B<rsub|1><around|[|<wide|T|\<bar\>>|]>> is
    stably related to <math|B<rsub|1><around|[|<wide|T|\<bar\>><rprime|'>|]>>
    on <math|D<rsup|+>> so it must be the case that
    <math|x<rsub|i>\<nin\>D<rsup|+>>. Now, if
    <math|x<rsub|i>\<nin\><math-bf|l>>, then
    <math|\<langle\>-x<rsub|i>,u\<rangle\><space|0.17em>\<gtr\>0> so
    <math|T<rsub|n<rsub|i>>\<sim\><rsub|s>T<rprime|'><rsub|n<rsub|i>>>. But
    then <math|<wide|T|\<bar\>>\<sim\><rsub|s><wide|T|\<bar\>><rprime|'>>,
    which is not the case. Thus <math|x<rsub|i>\<in\><math-bf|l>> for all
    large <math|i>. If <math|x<rsub|i>=0> for infinitely many <math|i>, then
    <math|<around|(|T,T<rprime|'>|)>> is <math|\<Phi\>>-periodic by Lemma
    <reference|periodic tilings> and <math|S<around|(|T,T<rprime|'>|)>> is
    open by Lemma <reference|sector open>. Otherwise, there are
    <math|i<rsub|1>,i<rsub|2>,i<rsub|3>> with <math|x<rsub|i<rsub|2>>>
    between <math|x<rsub|1<rsub|i>>> and <math|x<rsub|i<rsub|3>>> on
    <math|<math-bf|l>>, say <math|x<rsub|i<rsub|1>>=x<rsub|i<rsub|2>>-t<rsub|1>*v>
    and <math|x<rsub|i<rsub|3>>=x<rsub|i<rsub|2>>+t<rsub|3>*v> with
    <math|t<rsub|1>,t<rsub|3>\<gtr\>0>. Then
    <math|T-\<lambda\><rsup|n<rsub|i<rsub|2>>>*t<rsub|1>*v\<nsim\><rsub|s>T<rprime|'>-\<lambda\><rsup|n<rsub|i<rsub|2>>>*t<rsub|1>*v>
    and <math|T-\<lambda\><rsup|n<rsub|i<rsub|2>>>*t<rsub|3>(-v)\<nsim\><rsub|s>T<rprime|'>-\<lambda\><rsup|n<rsub|i<rsub|2>>>*t<rsub|3>(-v>),
    so <math|v\<nin\>S<around|(|T,T<rprime|'>|)>>,
    <math|-v\<nin\>S<around|(|T,T<rprime|'>|)>>, and
    <math|S<around|(|T,T<rprime|'>|)>> is open.
  </proof>

  <math|<with|math-font-family|bf|N.B.>> The above proof in fact shows that
  if <math|\<Phi\>> is 2-dimensional, <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  and <math|v\<in\>\<partial\>*S<around|(|T,T<rprime|'>|)>>, then there are
  <math|t<rsub|n>\<to\>\<infty\>> or <math|t<rsub|n>\<to\>-\<infty\>> so that
  <math|T-t<rsub|n>*v\<nsim\><rsub|s>T<rprime|'>-t<rsub|n>*v>.

  <\theorem>
    <label|finitely many sectors>If <math|\<Omega\>=\<Omega\><around|(|\<Phi\>|)>>
    is a 2-dimensional, non-periodic, FLC, self-similar substitution tiling
    space, then the collection <math|<around|{|S<around|(|T,T<rprime|'>|)>:<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>|}>>
    is finite.
  </theorem>

  <\proof>
    Suppose instead that there are <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>,
    <math|n\<in\><N>>, so that <math|\<partial\>*S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>=<around|{|v<rsub|n>,w<rsub|n>|}>>
    and <math|<around|{|v<rsub|i>,w<rsub|i>|}>\<ne\><around|{|v<rsub|j>,w<rsub|j>|}>>
    for all <math|i\<ne\>j>. Passing to a subsequence, we may assume that
    <math|v<rsub|n>\<to\>v> and <math|w<rsub|n>\<to\>w> as
    <math|n\<to\>\<infty\>>. Since <math|v<rsub|n>\<nin\>S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>>
    (Lemma <reference|all sectors open>) there are
    <math|s<rsub|n>\<in\><R><rsup|+>> so that
    <math|T<rsub|n>-s<rsub|n>*v<rsub|n>\<nsim\><rsub|s>T<rprime|'><rsub|n>-s<rsub|n>*v<rsub|n>>.
    Let <math|k<rsub|n>\<in\><Z>> be so that
    <math|\<lambda\><rsup|k<rsub|n>>*s<rsub|n>\<in\><around|[|\<lambda\><rsup|-2>,\<lambda\><rsup|-1>|)>>.
    Replace <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>> by
    <math|<around|(|\<Phi\><rsup|k<rsub|n>><around|(|T<rsub|n>|)>,\<Phi\><rsup|k<rsub|n>><around|(|T<rprime|'><rsub|n>|)>|)>>
    and <math|s<rsub|n>> by <math|\<lambda\><rsup|k<rsub|n>>*s<rsub|n>>. We
    still have <math|\<partial\>*S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>=<around|{|v<rsub|n>,w<rsub|n>|}>>
    since <math|\<Phi\>> is self-similar. Let
    <math|u<rsub|n>\<in\>\<bbb-S\><rsup|1>> be such that
    <math|<around|\<langle\>|u<rsub|n>,v<rsub|n>|\<rangle\>>=0> and
    <math|<around|{|v\<in\>\<bbb-S\><rsup|1>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>>.
    By passing to a subsequence, we may assume that
    <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<to\><around|(|T,T<rprime|'>|)>\<in\>\<Omega\>\<times\>\<Omega\>>,
    <math|s<rsub|n>\<to\>s\<in\><around|[|\<lambda\><rsup|-2>,\<lambda\><rsup|-1>|]>>,
    and <math|u<rsub|n>\<to\>u\<in\>\<bbb-S\><rsup|1>>. From Lemma
    <reference|branch pairs closed> we have
    <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>,
    <math|<around|{|v\<in\>\<cal-S\><rsup|1>:<around|\<langle\>|v,u|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T,T<rprime|'>|)>>,
    and <math|T-s*v\<nsim\><rsub|s>T<rprime|'>-s*v> (the latter because
    <math|<around|(|T<rsub|n>-s<rsub|n>*v<rsub|n>,T<rprime|'><rsub|n>-s<rsub|n>*v<rsub|n>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    and <math|<around|(|T<rsub|n>-s<rsub|n>*v<rsub|n>,T<rprime|'><rsub|n>-s<rsub|n>*v<rsub|n>|)>\<to\><around|(|T-s*v,T<rprime|'>-s*v|)>>).
    By Lemma <reference|finitely many patches> there is an <math|N> and there
    are <math|x<rsub|n>\<to\>0> so that <math|<around|(|B<rsub|1><around|[|T<rsub|n>|]>,B<rsub|1><around|[|T<rprime|'><rsub|n>|]>|)>=<around|(|B<rsub|1>*<around|[|T-x<rsub|n>|]>,B<rsub|1>*<around|[|T<rprime|'>-x<rsub|n>|]>|)>>
    for all <math|n\<ge\>N>. By taking <math|N> large enough we can assure
    that <math|<around|\||x<rsub|n>|\|>\<less\>\<epsilon\>> and
    <math|<around|\||x<rsub|n>+s<rsub|n>*v<rsub|n>-s*v|\|>\<less\>\<epsilon\>>
    for all <math|n\<ge\>N>, where <math|\<epsilon\>\<gtr\>0> is small enough
    so that the <math|\<epsilon\>> balls centered at <math|s*v> and <math|0>
    are disjoint and contained in <math|B<rsub|1><around|(|0|)>>. Let
    <math|<math-bf|l>> and <math|<math-bf|l><rsub|n>> be the lines
    <math|<around|{|t*v:t\<in\><R>|}>> and
    <math|<around|{|t*v<rsub|n>+x<rsub|n>:t\<in\><R>|}>>, resp.. Let
    <math|D<rsup|\<pm\>>> and <math|D<rsub|n><rsup|\<pm\>>> be the components
    of <math|B<rsub|1><around|(|0|)>\<setminus\><math-bf|l>> and
    <math|B<rsub|1><around|(|0|)>\<setminus\><math-bf|l><rsub|n>>, resp.,
    with <math|1/2*u\<in\>D<rsup|+>> and <math|1/2*u<rsub|n>+x<rsub|n>\<in\>D<rsub|n><rsup|+>>.
    Then <math|B<rsub|1><around|[|T|]>> is stably related to
    <math|B<rsub|1><around|[|T<rprime|'>|]>> on <math|D<rsup|+>>. Pick
    <math|n\<ge\>N>. Since <math|<around|(|B<rsub|1><around|[|T<rsub|n>|]>,B<rsub|1><around|[|T<rprime|'><rsub|n>|]>|)>=<around|(|B<rsub|1>*<around|[|T-x<rsub|n>|]>,B<rsub|1>*<around|[|T<rprime|'>-x<rsub|n>|]>|)>>
    and <math|T<rsub|n>\<nsim\><rsub|s>T<rprime|'><rsub|n>>,
    <math|B<rsub|1><around|[|T|]>> and <math|B<rsub|1><around|[|T<rprime|'>|]>>
    are not stably related on <math|<around|{|x<rsub|n>|}>>; that is
    <math|x<rsub|n>\<nin\>D<rsup|+>>. Similarly,
    <math|x<rsub|n>+s<rsub|n>*v<rsub|n>\<nin\>D<rsup|+>>. Suppose that
    <math|v<rsub|n>\<ne\>v>. Then the lines <math|<math-bf|l><rsub|n>> and
    <math|<math-bf|l>> intersect in a single point <math|<around|{|p=t*v|}>>.
    If <math|t\<ge\>s>, then <math|0\<in\>D<rsub|n><rsup|+>>; if
    <math|t\<le\>0>, then <math|s*v\<in\>D<rsub|n><rsup|+>>; and if
    <math|0\<less\>t\<less\>s> then exactly one of <math|0,s*v> is in
    <math|D<rsub|n><rsup|+>>. So if <math|v<rsub|n>\<ne\>v>,
    <math|<around|{|0,s*v|}>\<cap\>D<rsub|n><rsup|+>\<ne\>\<emptyset\>>. If
    <math|0\<in\>D<rsub|n><rsup|+>> then <math|<around|\<langle\>|u<rsub|n>,-x<rsub|n>|\<rangle\>><space|0.17em>\<gtr\>0>
    so <math|T<rsub|n>+x<rsub|n>\<sim\><rsub|s>T<rprime|'>+x<rsub|n>>. But
    then <math|T\<sim\><rsub|s>T<rprime|'>>, which is not the case.
    Similarly, if <math|s*v\<in\>D<rsub|n><rsup|+>> then
    <math|<around|\<langle\>|u<rsub|n>,s*v-x<rsub|n>|\<rangle\>><space|0.17em>\<gtr\>0>
    so that <math|T<rsub|n>-<around|(|s*v-x<rsub|n>|)>\<sim\><rsub|s>T<rprime|'>-<around|(|s*v-x<rsub|n>|)>>.
    But then <math|T-s*v\<sim\><rsub|s>T<rprime|'>-s*v>, which is also not
    the case. Thus it must be that <math|v<rsub|n>=v> for all
    <math|n\<ge\>N>.

    Now, for each <math|n\<ge\>N> there are <math|t<rsub|n>\<gtr\>0> so that
    <math|T<rsub|n>-t<rsub|n>*w<rsub|n>\<nsim\><rsub|s>T<rprime|'><rsub|n>-t<rsub|n>*w<rsub|n>>.
    Let <math|m<rsub|n>\<in\><Z>> be such that
    <math|\<lambda\><rsup|m<rsub|n>>*t<rsub|n>\<in\><around|[|\<lambda\><rsup|-2>,\<lambda\><rsup|-1>|)>>:
    replace <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>> by
    <math|<around|(|\<Phi\><rsup|m<rsub|n>><around|(|T<rsub|n>|)>,\<Phi\><rsup|m<rsub|n>><around|(|T<rprime|'><rsub|n>|)>|)>>
    and <math|t<rsub|n>> by <math|\<lambda\><rsup|m<rsub|n>>*t<rsub|n>>. Let
    <math|<wide|u|\<bar\>><rsub|n>\<in\>\<bbb-S\><rsup|1>> be such that
    <math|<around|{|v\<in\>\<bbb-S\><rsup|1>:<around|\<langle\>|v,<wide|u|\<bar\>><rsub|n>|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>>
    for <math|n\<ge\>N>. Passing to a subsequence, we may assume that
    <math|<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>\<to\><around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>\<in\>\<Omega\>\<times\>\<Omega\>>,
    <math|t<rsub|n>\<to\><wide|t|\<bar\>>>, and
    <math|<wide|u|\<bar\>><rsub|n>\<to\><wide|u|\<bar\>>> as
    <math|n\<to\>\<infty\>>. Note that for the new
    <math|T<rsub|n>,T<rprime|'><rsub|n>>, it's still the case that
    <math|\<partial\>*S<around|(|T<rsub|n>,T<rprime|'><rsub|n>|)>=<around|{|v,w<rsub|n>|}>>
    for <math|n\<ge\>N>, with <math|w<rsub|i>\<ne\>w<rsub|j>> for
    <math|i\<ne\>j>. Proceeding just as above, we may conclude that
    <math|w<rsub|n>\<equiv\>w> for all sufficiently large <math|n>. That is,
    there could only have been finitely many asymptotic sectors to begin
    with.
  </proof>

  We will say that <math|<with|math-font|cal|B*P><around|(|\<Phi\>|)>> is
  <with|font-shape|italic|non-collapsing> if, whenever
  <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>,
  <math|v\<in\>\<partial\>*S<around|(|T,T<rprime|'>|)>>, and
  <math|0\<le\>t<rsub|0>\<less\>t<rsub|1>> are such that
  <math|T-t<rsub|0>*v\<nsim\><rsub|s>T<rprime|'>-t<rsub|0>*v> and
  <math|T-t<rsub|1>*v\<nsim\><rsub|s>T<rprime|'>-t<rsub|1>*v>, then
  <math|T-t*v\<nsim\><rsub|s>T<rprime|'>-t*v> for all
  <math|t\<in\><around|[|t<rsub|0>,t<rsub|1>|]>>. It is clear from Lemma
  <reference|branch pairs closed> that the branch locus is non-collapsing if
  and only if the branch locus coincides with the collection of branch pairs.

  If <math|<around|(|T,T<rprime|'>|)>> is a branch pair in the 2-dimensional
  substitution tiling space <math|\<Omega\>>, we'll call
  <math|<around|(|T,T<rprime|'>|)>>

  <\itemize>
    <item>an <with|font-shape|italic|isolated pair> if
    <math|S<around|(|T,T<rprime|'>|)>=\<bbb-S\><rsup|1>>;

    <item>a <with|font-shape|italic|corner pair> if
    <math|S<around|(|T,T<rprime|'>|)>> is proper in <math|\<bbb-S\><rsup|1>>
    but contains a closed semicircle in its interior;

    <item>a <with|font-shape|italic|line pair> if
    <math|S<around|(|T,T<rprime|'>|)>> is an open semicircle.
  </itemize>

  Every branch pair is of one of the above types. Furthermore, there are only
  finitely many isolated and corner pairs and they are all periodic (Lemma
  <reference|all sectors open> and Theorem <reference|finitely many
  sectors>).

  <\proposition>
    <label|PBL=BL>If <math|<with|math-font|cal|B*P>> is non-collapsing then
    <math|<with|math-font|cal|P*B*L><around|(|\<Phi\>|)>=<with|math-font|cal|B*L><around|(|\<Phi\>|)>>.
  </proposition>

  <\proof>
    Pick <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>.
    Suppose there are <math|v\<in\>\<partial\>*S<around|(|T,T<rprime|'>|)>>
    and <math|t\<gtr\>0> with <math|T-t*v\<sim\><rsub|s>T<rprime|'>-t*v>. Let
    <math|t<rsub|0>\<assign\>i*n*f*<around|{|t\<gtr\>0:T-t*v\<sim\><rsub|s>T<rprime|'>-t*v|}>>.
    Then <math|<around|(|T-t<rsub|0>*v,T<rprime|'>-t<rsub|0>*v|)>> is either
    an isolated or a corner pair and hence is periodic. If
    <math|t<rsub|0>\<ne\>0>, then <math|<wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>={-v}\<subset\><wide|\<partial\>|~>S*<around|(|T-t<rsub|0>*v,T<rprime|'>-t<rsub|0>*v|)>>
    and <math|\<cup\><rsub|t\<ge\>0><around|{|T-t|(>-v)}\<subset\>\<cup\><rsub|t\<ge\>0><around|{|<around|(|T-t<rsub|0>*v|)>-t|(>-v)}>.
    If there are not such <math|v> and <math|t>, then either
    <math|<around|(|T,T<rprime|'>|)>> is an isolated pair, and hence in
    <math|<with|math-font|cal|P*B*P>>, or <math|<around|(|T,T<rprime|'>|)>>
    is a line pair with <math|<wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>={\<pm\>v}>
    for some <math|v\<in\>\<bbb-S\><rsup|1>>. In the latter case, and using
    Lemma <reference|finitely many patches>, there is a <math|k\<in\><N>> and
    a sequence <math|n<rsub|i>\<to\>\<infty\>> so that all of the pairs of
    patches <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>><around|(|T|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>><around|(|T<rprime|'>|)>|]>|)>>
    and <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>-k><around|(|T|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>-k><around|(|T<rprime|'>|)>|]>|)>>
    are translates of the same pair of patches
    <math|<around|(|P,P<rprime|'>|)>>. Moreover, we may take
    <math|n<rsub|i>\<equiv\>n<rsub|j>> mod(<math|k>), and, without loss of
    generality <math|n<rsub|i>\<equiv\>0> mod(<math|k>). As in the proof of
    Proposition <reference|periodic branch pairs exist>, the vectors
    translating the pairs of patches <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>><around|(|T|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>><around|(|T<rprime|'>|)>|]>|)>>
    to the pairs of patches <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>-k><around|(|T|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>-k><around|(|T<rprime|'>|)>|]>|)>>
    are all parallel with <math|v>. Passing to a subsequence, we may assume
    that <math|<around|(|B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>-k><around|(|T|)>|]>,B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>-k><around|(|T<rprime|'>|)>|]>|)>\<to\><around|(|Q,Q<rprime|'>|)>>.
    We have that <math|\<Phi\><rsup|k><around|(|Q|)>\<supset\>Q-s*v> and
    <math|\<Phi\><rsup|k><around|(|Q<rprime|'>|)>\<supset\>Q<rprime|'>-s*v>
    for some <math|s>. Then <math|\<Phi\><rsup|k>*<around|(|Q-<around|(|<frac|s|1-\<lambda\><rsup|k>>|)>*v|)>\<supset\>Q-<around|(|<frac|s|1-\<lambda\><rsup|k>>|)>*v>
    and <math|\<Phi\><rsup|k>*<around|(|Q<rprime|'>-<around|(|<frac|s|1-\<lambda\><rsup|k>>|)>*v|)>\<supset\>Q<rprime|'>-<around|(|<frac|s|1-\<lambda\><rsup|k>>|)>*v>.
    Let <math|<wide|T|\<bar\>>\<assign\>\<cup\><rsub|n\<ge\>0>\<Phi\><rsup|n*k>*<around|(|Q-<around|(|<frac|s|1-\<lambda\><rsup|k>>|)>*v|)>>
    and <math|<wide|T|\<bar\>><rprime|'>\<assign\>\<cup\><rsub|n\<ge\>0>\<Phi\><rsup|n*k>*<around|(|Q<rprime|'>-<around|(|<frac|s|1-\<lambda\><rsup|k>>|)>*v|)>>.
    Then <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>> is
    <math|\<Phi\>>-periodic of period <math|k> and is a line branch pair with
    <math|<wide|\<partial\>|~>S<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>={\<pm\>v}>
    by the non-collapsing assumption. Moreover, there are bounded
    <math|s<rsub|i>> so that <math|B<rsub|1><around|[|\<Phi\><rsup|-n<rsub|i>><around|(|T|)>|]>=B<rsub|1>*<around|[|<wide|T|\<bar\>>-s<rsub|i>*v|]>>.
    Let <math|n<rsub|i>=m<rsub|i>*k>. Then, for any <math|t\<in\><R>>,
    <math|B<rsub|\<lambda\><rsup|m<rsub|i>*k>>*<around|[|T-t*v|]>=B<rsub|\<lambda\><rsup|m<rsub|i>*k>>*<around|[|<wide|T|\<bar\>>-<around|(|\<lambda\><rsup|m<rsub|i>*k>*s<rsub|i>-t|)>*v|]>>
    for all <math|i> so that <math|<wide|T|\<bar\>>-<around|(|\<lambda\><rsup|m<rsub|i>*k>*s<rsub|i>-t|)>*v\<to\>T-t*v>
    as <math|i\<to\>\<infty\>>. Thus <math|T-t*v\<in\><with|math-font|cal|P*B*L>>
    so that <math|<with|math-font|cal|B*L>=<with|math-font|cal|P*B*L>>.
  </proof>

  <vspace|0.5fn>

  <no-indent><with|font-series|bold|Example 1: The half-hex.> <vspace|0.5fn>

  This is a self-similar Pisot substitution tiling space with
  <math|\<lambda\>=2> and substitution rule shown in Figure
  <reference|fig:half hex substitution>. There are six prototiles, consisting
  of a half hexagon tile and its rotations through multiples of
  <math|\<pi\>/6>.

  <\big-figure>
    <image|fig1.eps|3in|.8in||>

    <label|fig:half hex substitution>
  </big-figure|Half-hex substitution rule.>

  Six branch pairs are created from three distinct tilings, <math|T<rsub|1>>,
  <math|T<rsub|2>>, and <math|T<rsub|3>>, with patches at the origin shown in
  Figure <reference|fig:half hex patterns>. These tilings are fixed by the
  substitution and are identical off the support of the pictured patches;
  hence <math|S<around|(|T<rsub|i>,T<rsub|j>|)>=\<bbb-S\><rsup|1>,i,j\<in\><around|{|1,2,3|}>>,
  <math|i\<neq\>j>. That is, these are isolated pairs. There are no other
  branch pairs so the branch locus is <math|<with|math-font|cal|B*L>=<around|{|T<rsub|1>,T<rsub|2>,T<rsub|3>|}>>.

  <\big-figure>
    <image|fig2.eps|3in|1in||>

    <label|fig:half hex patterns>
  </big-figure|The 1-patches of the three elements of the half-hex branch
  locus. >

  <vspace|0.5fn>

  <no-indent><with|font-series|bold|Example 2: The chair.> <vspace|0.5fn>

  This is also a self-similar Pisot substitution tiling space with
  <math|\<lambda\>=2>. There are four square prototiles for the chair
  substitution <math|\<Phi\><rsub|C>>. (We will describe the \Psquare chair"
  - see <cite|Sa> for it's equivalence with the more familiar substitution
  with chair-shaped tiles.) Let <math|\<rho\><rsub|0>> be the unit square
  tile with the origin at the center and marked with a northeast pointing
  arrow, and let <math|\<rho\><rsub|i>\<assign\>r<rsup|i><around|(|\<rho\><rsub|0>|)>>,
  where <math|r> denotes rotation through <math|\<pi\>/2>. By this we mean,
  for example, that <math|\<rho\><rsub|1>> has the same support as
  <math|\<rho\><rsub|0>> but is marked with a northwest pointing arrow. The
  substitution on <math|\<rho\><rsub|0>> inflates by a factor of <math|2> and
  fills in the <math|2\<times\>2> square with translates of the
  <math|\<rho\><rsub|i>> as pictured.

  <vspace|0.5fn>

  <\equation*>
    <neabox>\<to\><tabular*|<tformat|<table|<row|<cell|<seabox><neabox>>>|<row|<cell|<neabox><nwabox>>>>>>
  </equation*>

  <vspace|0.5fn>

  Let <math|\<Phi\><rsub|C><around|(|\<rho\><rsub|i>|)>\<assign\>r<rsup|i><around|(|\<Phi\><rsub|C><around|(|\<rho\><rsub|0>|)>|)>>.
  The tilings <math|T<rsub|i>\<assign\>\<cup\><rsub|n\<ge\>1>\<Phi\><rsub|C><rsup|n><around|(|\<rho\><rsub|i>|)>>
  are fixed by <math|\<Phi\><rsub|C>> and are members of corner pairs:
  <math|S<around|(|T<rsub|i>,T<rsub|i+1>|)>=r<rsup|i><around|(|<around|{|v\<in\>\<bbb-S\><rsup|1>:<around|\<langle\>|v,<around|(|0,-1|)>|\<rangle\>>\<gtr\>-<sqrt|2>/2|}>|)>>,
  with the subscripts on the <math|T>'s taken mod(4). These are all the
  corner pairs, there are no isolated pairs, and all members of line pairs
  have zero-patch equal to: a translate of <math|\<rho\><rsub|0>> or
  <math|\<rho\><rsub|2>> in a northeast-southwest direction; a translate of
  <math|\<rho\><rsub|1>> or <math|\<rho\><rsub|3>> in a northwest-southeast
  direction; or a collection of four prototiles with all arrows pointing
  towards, or away from, the origin. There are five zero-patches of the
  latter form: <math|B<rsub|0><around|[|T<rsub|i>|]>,i=0,\<ldots\>,3>, and
  the patch <math|P> pictured below.

  <vspace|0.5fn>

  <\equation*>
    P=<tabular*|<tformat|<table|<row|<cell|<nwabox><neabox>>>|<row|<cell|<swabox><seabox>>>>>>
  </equation*>

  <vspace|0.5fn>

  Let <math|T<rsup|\<ast\>>\<assign\>\<cup\><rsub|n\<in\><N>>\<Phi\><rsub|C><rsup|n><around|(|P|)>>
  be the tiling, fixed under <math|\<Phi\><rsub|C>> with
  <math|B<rsub|0><around|[|T<rsup|\<ast\>>|]>=P>. The branch locus of
  <math|\<Phi\><rsub|C>> then consists of the disjoint union of four dyadic
  solenoids, <math|S<rsub|i>\<assign\>c*l<around|(|<around|{|T<rsub|i>-t*r<rsup|i><around|(|<around|(|<sqrt|2>/2,<sqrt|2>/2|)>|)>:t\<in\><R>|}>|)>,i=0,\<ldots\>,3>,
  together with four rays, <math|R<rsub|i>\<assign\><around|{|T<rsup|\<ast\>>-t*r<rsup|i><around|(|<around|(|<sqrt|2>/2,<sqrt|2>/2|)>|)>:t\<ge\>0|}>,i=0,\<ldots\>,3>,
  joined at their common endpoint <math|T<rsup|\<ast\>>>. Each ray
  <math|R<rsub|i>> winds densely on <math|S<rsub|i>>.
  <math|<with|math-font|cal|B*P><around|(|\<Phi\><rsub|C>|)>> is
  non-collapsing, so <math|<with|math-font|cal|P*B*L><around|(|\<Phi\><rsub|C>|)>=<with|math-font|cal|B*L><around|(|\<Phi\><rsub|C>|)>>.

  The branch locus for the chair tiling can be described as an inverse limit
  of an expanding Markov map (see Theorem <reference|structure of branch
  locus> below) as follows. Let <math|X\<assign\><T>\<cup\><around|[|1,3|]>>
  be the \Pcircle with sticker" in the complex plane consisting of the union
  of the unit circle <math|<T>> and the interval on the real axis from 1 to
  3, and let <math|f<rsub|0>:X\<to\>X> by:

  <\equation*>
    f<rsub|0><around|(|z|)>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|z<rsup|2>>|<cell|<text|if
    >z\<in\><T>,>>|<row|<cell|e*x*p*<around|(|2*\<pi\>*z*i|)>>|<cell|<text|if
    >z\<in\><around|[|1,2|]>,>>|<row|<cell|2*z-3>|<cell|<text|if
    >z\<in\><around|[|2,3|]>.>>>>>|\<nobracket\>>
  </equation*>

  Now let <math|K\<assign\>\<cup\><rsub|i=0,\<ldots\>,3>r<rsup|i>*<around|(|X-3|)>>
  be the union of four copies of <math|X>, joined at their endpoints, and let
  <math|f:K\<to\>K> be given by <math|f<around|(|z|)>\<assign\>r<rsup|i>*<around|(|f<rsub|0>*<around|(|r<rsup|-i><around|(|z|)>+3|)>-3|)>>
  for <math|z\<in\>r<rsup|i>*<around|(|X-3|)>>. Then <math|<inv>f> is
  homeomorphic with <math|<with|math-font|cal|B*L><around|(|\<Phi\><rsub|C>|)>>
  by a homeomorphism that conjugates <math|<wide|f|^>> with
  <math|\<Phi\><rsub|C>\|<rsub|<with|math-font|cal|B*L><around|(|\<Phi\><rsub|C>|)>>>.
  <vspace|0.5fn>

  <vspace|0.5fn><no-indent><with|font-series|bold|Example 3: The octagonal
  tiling.> <vspace|0.5fn>

  The (undecorated) octagonal tiling space is a self-similar Pisot
  substitution tiling space with <math|\<lambda\>=1+<sqrt|2>>. There are 20
  prototiles: four unmarked rhombi, <math|\<rho\><rsub|i>=r<rsup|i><around|(|\<rho\><rsub|0>|)>>,
  <math|i=0,\<ldots\>*3>, with <math|r<rsup|4><around|(|\<rho\><rsub|0>|)>=\<rho\><rsub|0>>,
  <math|r> being rotation through <math|\<pi\>/4>, with the origin at their
  centers; and sixteen marked isosceles right triangles
  <math|\<tau\><rsub|i>=r<rsup|i><around|(|\<tau\><rsub|0>|)>,\<tau\><rprime|'><rsub|i>=r<rsup|i><around|(|\<tau\><rprime|'><rsub|0>|)>>,
  <math|i=0,\<ldots\>,7>, with <math|\<tau\><rsub|i>> and
  <math|\<tau\><rprime|'><rsub|i>> having the same support but bearing
  different marks. The origin is at the midpoint of the hypotenuse of the
  triangular prototiles. The octagonal substitution, <math|\<Phi\><rsub|O>>,
  is described in the following figure.

  <\big-figure>
    <image|fig3.eps|3in|3in||>

    <label|fig:Oct substitution>
  </big-figure|Octagonal substitution rule.>

  If <math|\<rho\><rprime|'><rsub|0>> denotes the translate of
  <math|\<rho\><rsub|0>> with the origin slightly off-center (see Figure
  <reference|fig:Oct one patches>), then <math|\<rho\><rprime|'><rsub|0>\<in\>\<Phi\><rsub|O><rsup|2><around|(|\<rho\><rprime|'><rsub|0>|)>>
  so that the tilings <math|T<rsub|1,i>\<assign\>\<cup\><rsub|n\<in\><N>>\<Phi\><rsub|O><rsup|2*n><around|(|r<rsup|i><around|(|\<rho\><rprime|'><rsub|0>|)>|)>>,
  <math|i=0,\<ldots\>,7>, are fixed by <math|\<Phi\><rsub|O><rsup|2>>. Also,
  <math|\<tau\><rsub|i>\<in\>\<Phi\><rsub|O><rsup|2><around|(|\<tau\><rsub|i>|)>>
  and <math|\<tau\><rprime|'><rsub|i>\<in\>\<Phi\><rsub|O><rsup|2><around|(|\<tau\><rprime|'><rsub|i>|)>>,
  so the tilings <math|T<rsub|2,i>\<assign\>\<cup\><rsub|n\<in\><N>>\<Phi\><rsub|O><rsup|2*n><around|(|<around|{|\<tau\><rsub|i>,\<tau\><rprime|'><rsub|i+4>|}>|)>>,
  <math|i=0,\<ldots\>,7> and <math|i+4> taken mod(8), are fixed by
  <math|\<Phi\><rsub|O><rsup|2>>. Note that
  <math|\<Phi\><rsub|O><around|(|T<rsub|j,i>|)>=T<rsub|j,i+4>>, for
  <math|j=1,2> and <math|i=0,\<ldots\>,7>, with subscripts taken mod(8).

  <\big-figure>
    <image|fig4.eps|3in|1.5in||>

    <label|fig:Oct one patches>
  </big-figure|1-patches of the tilings <math|T<rsub|1,0>> and
  <math|T<rsub|2,0>>. Black dots indicate the placement of the origin. >

  The tilings <math|T<rsub|1,i>> and <math|T<rsub|1,i+3>> are members of a
  branch line pair, as are <math|T<rsub|1,i>> and <math|T<rsub|1,i+5>>
  (subscripts taken mod(8)), and the corresponding sectors have boundaries:
  <math|\<partial\>*S<around|(|T<rsub|1,i>,T<rsub|1,i+3>|)>={\<pm\>r<rsup|i><around|(|<around|(|<sqrt|2>/2,<sqrt|2>/2|)>|)>}>;
  and <math|\<partial\>*S<around|(|T<rsub|1,i>,T<rsub|1,i+5>|)>={\<pm\>r<rsup|i><around|(|<around|(|0,1|)>|)>}>.
  Let <math|\<Omega\><rsub|i>\<assign\>c*l<around|(|<around|{|T<rsub|1,i>-t*r<rsup|i><around|(|<around|(|<sqrt|2>/2,<sqrt|2>/2|)>|)>:t\<in\><R>|}>|)>>.
  <math|<with|math-font|cal|B*P><around|(|\<Phi\><rsub|O>|)>> is
  non-collapsing, and the branch locus of the octagonal tiling is
  <math|<with|math-font|cal|B*L><around|(|\<Phi\><rsub|O>|)>=<with|math-font|cal|P*B*L><around|(|\<Phi\><rsub|O>|)>=\<cup\><rsub|i=0><rsup|7>\<Omega\><rsub|i>>
  with the <math|\<Omega\><rsub|i>> intersecting as follows:

  <\equation*>
    \<Omega\><rsub|0>\<cap\>\<Omega\><rsub|j>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<around|{|T<rsub|1,0>|}>,>|<cell|j=1>>|<row|<cell|<around|{|T<rsub|2,0>|}>,>|<cell|j=2>>|<row|<cell|\<emptyset\>,>|<cell|j=3>>|<row|<cell|\<emptyset\>,>|<cell|j=4>>|<row|<cell|\<emptyset\>,>|<cell|j=5>>|<row|<cell|<around|{|T<rsub|2,6>|}>,>|<cell|j=6>>|<row|<cell|<around|{|T<rsub|1,7>|}>,>|<cell|j=7.>>>>>|\<nobracket\>>
  </equation*>

  Note that <math|r> determines a homeomorphism of <math|\<Omega\><rsub|O>>
  by <math|r<around|(|<around|{|\<sigma\><rsub|i>+v<rsub|i>|}>|)>\<assign\><around|{|r<around|(|\<sigma\><rsub|i>|)>+r<around|(|v<rsub|i>|)>|}>>
  for <math|v<rsub|i>\<in\><R><rsup|2>> and prototiles
  <math|\<sigma\><rsub|i>>. Then <math|\<Omega\><rsub|i>=r<rsup|i><around|(|\<Omega\><rsub|0>|)>>
  and the intersections of <math|\<Omega\><rsub|i>> with the various
  <math|\<Omega\><rsub|j>> are obtained by applying <math|r<rsub|i>> to the
  above. <math|\<Omega\><rsub|0>> is itself (homeomorphic with) a
  one-dimensional substitution tiling space which can be described as
  follows. Let <math|X> be a wedge of three circles, labeled by <math|1,2>
  and <math|3>, and let <math|f:X\<to\>X> be the Markov map that maps these
  circles according to the pattern of the substitution <math|\<phi\>>:

  <\equation*>
    1\<mapsto\>23131
  </equation*>

  <\equation*>
    2\<mapsto\>23231
  </equation*>

  <\equation*>
    3\<mapsto\>2323131.
  </equation*>

  Then <math|\<Phi\><rsub|O><rsup|2>\|<rsub|\<Omega\><rsub|0>>> is conjugate
  with the shift <math|<wide|f|^>> on <math|\<Omega\><rsub|\<phi\>>\<simeq\><inv>f\<simeq\>\<Omega\><rsub|0>>.
  To describe all of <math|<with|math-font|cal|B*L><around|(|\<Phi\><rsub|O>|)>>,
  let <math|x<rsub|0>,x<rsub|1>,x<rsub|2>>, and <math|x<rsub|3>> be the fixed
  points of <math|<wide|f|^>> corresponding to the last occurrence of 3 in
  <math|\<phi\><around|(|3|)>>, the first occurrence of 3 in
  <math|\<phi\><around|(|3|)>>, the first occurrence of 1 in
  <math|\<phi\><around|(|1|)>>, and the second occurrence of 2 in
  <math|\<phi\><around|(|2|)>>, resp. (These points correspond to
  <math|T<rsub|1,0>,T<rsub|1,7>,T<rsub|2,0>>, and <math|T<rsub|2,6>>, resp.)
  Let <math|B\<assign\>(\<cup\><rsub|i=0><rsup|7><inv>f\<times\><around|{|i|}>)/\<sim\>>,
  in which <math|\<sim\>> identifies points as follows:
  <math|<around|(|x<rsub|0>,i|)>\<sim\><around|(|x<rsub|1>,i+1|)>,<around|(|x<rsub|1>,i|)>\<sim\><around|(|x<rsub|0>,i+7|)>,<around|(|x<rsub|2>,i|)>\<sim\><around|(|x<rsub|3>,i+2|)>>,
  and <math|<around|(|x<rsub|3>,i|)>\<sim\><around|(|x<rsub|2>,i+6|)>>.
  <math|\<Phi\><rsub|O><rsup|2>\|<rsub|<with|math-font|cal|B*L><around|(|\<Phi\><rsub|O>|)>>>
  is then conjugate with <math|F:B\<to\>B>, where
  <math|F<around|(|<around|[|<around|(|x,i|)>|]>|)>\<assign\><around|[|<around|(|<wide|f|^><around|(|x|)>,i|)>|]>>.

  <\big-figure>
    <image|fig5.eps|2in|2in||>

    <label|fig:Oct branch locus>
  </big-figure|Schematic of the branch locus of the octagonal tiling space.>

  The octagon tilings can also be obtained from a cut-and-project scheme (see
  <cite|FHK>) in which the \Pwindow" is an octagon. In this presentation, the
  ambiguity introduced by each of the eight boundary segments of the octagon
  is responsible for each of the eight pieces <math|\<Omega\><rsub|i>> of the
  branch locus.

  <vspace|2fn>The following Theorem guarantees that, unless the branch locus
  consists of just a finite number of points (as for the half-hex), the
  branch locus is rather complicated.

  <\theorem>
    <label|two sectors>If <math|\<Omega\>> is a 2-dimensional, non-periodic,
    FLC, self-similar substitution tiling space that has no isolated branch
    pairs, then there are branch pairs <math|<around|(|T<rsub|1>,T<rprime|'><rsub|1>|)>,<around|(|T<rsub|2>,T<rprime|'><rsub|2>|)>\<in\>\<Omega\>\<times\>\<Omega\>>
    with <math|\<partial\>*S<around|(|T<rsub|1>,T<rprime|'><rsub|1>|)>\<ne\>\<partial\>*S<around|(|T<rsub|2>,T<rprime|'><rsub|2>|)>>.
    Moreover, if <math|\<Omega\>> also has no corner branch pairs, then all
    line branch pairs <math|<around|(|T,T<rprime|'>|)>> are non-collapsing in
    the sense that <math|T-t*v\<nsim\><rsub|s>T<rprime|'>-t*v> for all
    <math|t\<in\><R>,v\<in\>\<partial\>*S<around|(|T,T<rprime|'>|)>>.
  </theorem>

  <with|font-shape|italic|Sketch of proof:> We will see rather easily that if
  <math|\<Omega\>> has a corner pair then <math|\<Omega\>> also has a line
  pair. With a bit more work we will show that if <math|\<Omega\>> has only
  line pairs with parallel directions, then <math|\<Omega\>> has a nonzero
  translational period. The detailed proof is deferred to the next
  section.<next-line><next-line>We'll say that a continuous map
  <math|f:K\<to\>K> on a finite 1-dimensional simplicial complex <math|K>
  with vertices <math|V> is an <with|font-shape|italic|expanding Markov> map
  provided <math|f<around|(|V|)>\<subset\>V>, <math|f<rsup|-1><around|(|V|)>>
  is finite, and <math|f> is one-to-one and stretches length by a factor of
  at least <math|\<lambda\>>, for some <math|\<lambda\>\<gtr\>1>, on each
  component of <math|K\<setminus\><around|(|V\<cup\>f<rsup|-1><around|(|V|)>|)>>.
  Such maps are quite similar to the Williams presentations of 1-dimensional
  hyperbolic attractors (<cite|W>). In particular, at all but finitely many
  points, the inverse limit space <math|<Lim>f> is homeomorphic with the
  product of a 0-dimensional set with an arc.

  <\theorem>
    <label|structure of branch locus>If <math|\<Omega\><rsub|\<Phi\>>> is a
    2-dimensional, non-periodic, FLC, self-similar substitution tiling space
    and either <math|<with|math-font|cal|B*P><around|(|\<Phi\>|)>> is
    non-collapsing or <math|\<Phi\>> is Pisot, then there is a finite
    1-dimensional simplicial complex <math|K> and an expanding Markov map
    <math|f:K\<to\>K> so that <math|\<Phi\>\|<rsub|<with|math-font|cal|P*B*L><around|(|\<Phi\>|)>>>
    is topologically conjugate with <math|<wide|f|^>> on <math|<Lim>f>.
  </theorem>

  <with|font-shape|italic|Sketch of proof:> Let <math|X> be the 1-collared
  Anderson-Putnam complex for <math|\<Omega\>> with
  <math|\<pi\>:\<Omega\>\<to\>X> and <math|F:X\<to\>X> so that
  <math|\<pi\>\<circ\>\<Phi\>=F\<circ\>\<pi\>>. Then
  <math|<wide|\<pi\>|^>:\<Omega\>\<to\><wide|X|^>\<assign\><inv>F> is a
  homeomorphism that conjugates <math|\<Phi\>> with <math|<wide|F|^>> (see
  <cite|AP>). We will prove in the next section that, under the hypotheses of
  Theorem <reference|structure of branch locus>, the collection
  <math|<around|{|<around|(|\<tau\>,l|)>|}>> consisting of all pairs with
  <math|\<tau\>\<in\>T> and <math|\<tau\>\<cap\>l\<ne\>\<emptyset\>>, where
  either <math|<around|(|T,T<rprime|'>|)>> is a periodic line pair for which
  <math|<wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>=\<partial\>*S<around|(|T,T<rprime|'>|)>={\<pm\>v}>
  and <math|l=<around|{|t*v:t\<in\><R>|}>>, or
  <math|<around|(|T,T<rprime|'>|)>> is a corner pair with
  <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>> and
  <math|l=<around|{|t*v:t\<ge\>0|}>>, is finite, up to translation. From this
  it will follow that the set <math|K\<assign\>\<pi\><around|(|<with|math-font|cal|P*B*L><around|(|\<Phi\>|)>|)>\<subset\>X>
  is a finite 1-dimensional simplicial complex invariant under <math|F>. Then
  <math|f=F\|<rsub|K>> is expanding Markov and
  <math|\<Phi\>\|<rsub|<with|math-font|cal|P*B*L><around|(|\<Phi\>|)>>> is
  topologically conjugate with <math|<wide|f|^>> on <math|<Lim>f>. A complete
  proof appears in the next section.

  <\theorem>
    <label|topological invariance 2>Suppose that <math|\<Omega\>> and
    <math|\<Omega\><rprime|'>> are homeomorphic 2-dimensional, non-periodic,
    FLC, self-similar substitution tiling spaces and at least one of the
    following conditions is met:

    <\itemize>
      <item><math|\<Omega\>> has an isolated or a corner branch pair;

      <item><math|\<Omega\>> has line pairs
      <math|<around|(|T<rsub|1>,T<rsub|2>|)>> and
      <math|<around|(|T<rsub|2>,T<rsub|3>|)>> with
      <math|\<partial\>*S<around|(|T<rsub|1>,T<rsub|2>|)>\<ne\>\<partial\>*S<around|(|T<rsub|2>,T<rsub|3>|)>>;

      <item><math|\<Omega\>> is Pisot.
    </itemize>

    Then there is a homeomorphism from <math|\<Omega\>> to
    <math|\<Omega\><rprime|'>> that takes branch pairs to branch pairs,
    preserving type, and that restricts to a homeomorphism of the branch loci
    and of the periodic branch loci.
  </theorem>

  <with|font-shape|italic|Sketch of proof:> As was the case for the proof of
  Theorem <reference|topological invariance 1>, the rigidity results of
  <cite|Kwapisz> will provide the key to the proof of Theorem
  <reference|topological invariance 2>. First, we may replace an arbitrary
  homeomorphism of <math|\<Omega\>> and <math|\<Omega\><rprime|'>> by a
  `linear' homeomorphism that preserves asymptoticity. To further improve the
  linear homeomorphism to a conjugacy (between some powers of the
  substitution maps) it is necessary to show that the linear homeomorphism
  can be made to be `pointed', that is, to take some self-similar (i.e.,
  periodic under substitution) tiling to a self-similar tiling. This is
  accomplished by establishing the existence of tilings with such special
  asymptotic properties, that any tiling with these properties must be
  self-similar (at least up to translation). This existence is established by
  fiat in the first two of the alternative hypotheses of Theorem
  <reference|topological invariance 2>. From Theorem <reference|two sectors>
  it follows that if <math|\<Omega\>> has neither isolated nor corner branch
  pairs, then <math|\<Omega\>> has non-parallel line branch pairs.
  Intersection of the corresponding lines would yield the second of the
  alternative hypotheses. In case <math|\<Omega\>> is Pisot we will see that
  these lines have a virtual intersection when viewed in the maximal
  equicontinuous factor of <math|\<Omega\>>. This virtual intersection will
  prove sufficient to pin down a linear homeomorphism of <math|\<Omega\>> and
  <math|\<Omega\><rprime|'>> to a pointed homeomorphism. Once powers of the
  substitutions on <math|\<Omega\>> and <math|\<Omega\><rprime|'>> are
  conjugated, Theorem <reference|topological invariance 2> will follow
  easily.

  <section|Proofs of the main theorems><label|proofs>

  Throughout this section <math|\<Omega\><rsub|\<Phi\>>> will always be a
  2-dimensional non-periodic, minimal, self-similar tiling space with
  translationally finite local complexity.

  Given <math|\<epsilon\>\<gtr\>0> and <math|T\<in\>\<Omega\><rsub|\<Phi\>>>,
  a line <math|l> with direction vector <math|v\<in\>\<bbb-S\><rsup|1>> will
  be called an <with|font-shape|italic|<math|\<epsilon\>>-characteristic> for
  <math|T> provided there is a <math|w\<in\><R><rsup|2>> and a
  <math|v<rsup|\<perp\>>\<in\>\<bbb-S\><rsup|1>>, with
  <math|\<less\>v,v<rsup|\<perp\>>\<gtr\>=0>, so that for all <math|y\<in\>l>
  and <math|s\<in\><around|(|0,\<epsilon\>|]>>:
  <math|T-y\<nsim\><rsub|s>T-w-y>; and <math|T-y-s*v<rsup|\<perp\>>\<sim\><rsub|s>T-w-y-s*v<rsup|\<perp\>>>.

  Let <math|<around|[||(>\<ast\>,\<ast\><around|)||]>> denote the translation
  equivalence class of <math|(\<ast\>,\<ast\>)>.

  <\lemma>
    <label|finitely many cuts>Fix <math|\<epsilon\>\<gtr\>0> and
    <math|T\<in\>\<Omega\><rsub|\<Phi\>>>. Then
    <math|{<around|[|<around|(|\<tau\>,\<tau\>\<cap\>l|)>|]>:l> is an
    <math|\<epsilon\>>-characteristic for <math|T> and <math|\<tau\>\<in\>T}>
    is finite.
  </lemma>

  <\proof>
    For each <math|\<epsilon\>>-characteristic <math|l> there is a line pair
    <math|<around|(|T<rprime|'>,T<rprime|''>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    with <math|\<partial\>*S<around|(|T<rprime|'>,T<rprime|''>|)>={\<pm\>v}>
    (let <math|<around|(|T<rprime|'>,T<rprime|''>|)>> be any subsequential
    limit of <math|<around|(|\<Phi\><rsup|k>*<around|(|T-y|)>,\<Phi\><rsup|k>*<around|(|T-y-w|)>|)>>,
    <math|k\<in\><Z>,n\<in\><N>,y\<in\>l>), so there are only finitely many
    directions of <math|\<epsilon\>>-characteristics by Theorem
    <reference|finitely many sectors>. It follows that there are only
    finitely many pairs <math|<around|[|<around|(|\<tau\>,\<tau\>\<cap\>l|)>|]>>
    with <math|<wide|\<tau\>|\<abovering\>>\<cap\>l=\<emptyset\>> (tiles are
    connected). Thus, if there are infinitely many distinct
    <math|<around|[|<around|(|\<tau\>,\<tau\>\<cap\>l|)>|]>>, there is a
    prototile <math|\<rho\>>, vectors <math|x<rsub|n>> with
    <math|\<rho\>-x<rsub|n>\<in\>T>, and <math|\<epsilon\>>-characteristics
    <math|l<rsub|n>> with <math|v<rsup|\<perp\>><around|(|l<rsub|n>|)>\<equiv\>v<rsup|\<perp\>>>
    so that <math|<around|[|<around|(|\<rho\>+x<rsub|n>,<around|(|\<rho\>+x<rsub|n>|)>\<cap\>l<rsub|n>|)>|]>>
    are all distinct and <math|<around|(|<wide|\<rho\>|\<abovering\>>+x<rsub|n>|)>\<cap\>l<rsub|n>\<ne\>\<emptyset\>>
    for all <math|n\<in\><N>>. Pick <math|y<rsub|n>\<in\><around|(|<wide|\<rho\>|\<abovering\>>+x<rsub|n>|)>\<cap\>l<rsub|n>>
    and let <math|w<rsub|n>=w<around|(|l<rsub|n>|)>> be as in the definition
    of <math|\<epsilon\>>-characteristic. We may assume that the
    <math|B<rsub|1>*<around|[|T-y<rsub|n>|]>> are all of the same type, say
    <math|B<rsub|1>*<around|[|T-y<rsub|n>|]>=B-z<rsub|n>>, and that the
    <math|B<rsub|1>*<around|[|T-w<rsub|n>-y<rsub|n>|]>> are all of the same
    type, say <math|B<rsub|1>*<around|[|T-w<rsub|n>-y<rsub|n>|]>=B<rprime|'>-z<rsub|n><rprime|'>>,
    with <math|z<rsub|n>\<to\>0> and <math|z<rsub|n><rprime|'>\<to\>0>. Note
    that since the <math|<around|[|<around|(|\<rho\>+x<rsub|n>,<around|(|\<rho\>+x<rsub|n>|)>\<cap\>l<rsub|n>|)>|]>>
    are all distinct, <math|<around|\<langle\>|z<rsub|n>-z<rsub|m>,v<rsup|\<perp\>>|\<rangle\>>\<ne\>0>
    for <math|n\<ne\>m>.

    Now <math|B-z<rsub|n>> is stably related with
    <math|B<rprime|'>-z<rsub|n><rprime|'>> on
    <math|{x:<around|\||x|\|>\<less\>\<epsilon\>> and
    <math|<around|\<langle\>|x,v<rsup|\<perp\>>|\<rangle\>>\<gtr\>0}>. It is
    a consequence of Lemma <reference|finitely many patch pairs> that
    <math|<around|{|z<rsub|n><rprime|'>-z<rsub|n>|}>> is finite. Pick a large
    <math|n> and a <math|k\<gtr\>0> with <math|<around|\||z<rsub|n+k>-z<rsub|n>|\|>\<less\>\<epsilon\>>
    and <math|z<rprime|'><rsub|n+k>-z<rsub|n+k>=z<rprime|'><rsub|n>-z<rsub|n>>.
    Suppose <math|<around|\<langle\>|z<rsub|n+k>-z<rsub|n>,v<rsup|\<perp\>>|\<rangle\>>\<less\>0>.
    We have <math|B-z<rsub|n+k>\<nsim\><rsub|s>B<rprime|'>-z<rprime|'><rsub|n+k>>
    and <math|B-z<rsub|n+k>+<around|(|z<rsub|n+k>-z<rsub|n>|)>\<sim\><rsub|s>B<rprime|'>-z<rprime|'><rsub|n+k>+<around|(|z<rsub|n+k>-z<rsub|n>|)>>.
    But <math|z<rsub|n+k>-z<rsub|n>=z<rprime|'><rsub|n+k>-z<rprime|'><rsub|n>>,
    so we have <math|B-z<rsub|n>\<sim\><rsub|s>B<rprime|'>-z<rprime|'><rsub|n>>,
    that is, <math|T-y<rsub|n>\<sim\>T-w<rsub|n>-y<rsub|n>>, contradicting
    the assumption that <math|l<rsub|n>> is an
    <math|\<epsilon\>>-characteristic for <math|T>. A similar contradiction
    is reached if <math|<around|\<langle\>|z<rsub|n+k>-z<rsub|n>,v<rsup|\<perp\>>|\<rangle\>>\<gtr\>0>,
    hence there can be only finitely many
    <math|<around|[|<around|(|\<tau\>,\<tau\>\<cap\>l|)>|]>>.
  </proof>

  It follows from the above that there is a
  <math|\<delta\>=\<delta\><around|(|\<epsilon\>|)>\<gtr\>0> so that if
  <math|l> and <math|l<rprime|'>> are two distinct, parallel
  <math|\<epsilon\>>-characteristics for <math|T>, then the distance between
  <math|l> and <math|l<rprime|'>> is at least <math|\<delta\>>.

  <\lemma>
    <label|strips>Suppose that <math|T\<in\>\<Omega\><rsub|\<Phi\>>> is fixed
    by <math|\<Phi\>> and that <math|<around|{|l<rsub|n>|}><rsub|n\<in\><Z>>>
    is a family of parallel lines so that <math|l<rsub|n>> separates
    <math|l<rsub|n-1>> from <math|l<rsub|n+1>> for all <math|n> and
    <math|<R><rsup|2>=\<cup\><rsub|n\<in\><Z>>S<rsub|n>> where
    <math|S<rsub|n>> is the open strip between <math|l<rsub|n-1>> and
    <math|l<rsub|n+1>>. Suppose further that
    <math|\<lambda\><around|{|l<rsub|n>|}><rsub|n\<in\><Z>>\<subset\><around|{|l<rsub|n>|}><rsub|n\<in\><Z>>>
    and there are nonzero <math|w<rsub|n>> parallel to the <math|l<rsub|n>>,
    so that <math|T-y\<sim\><rsub|s>T-w<rsub|n>-y> for all
    <math|y\<in\>S<rsub|n>>. Then <math|<around|{|w<rsub|n>|}>> is infinite.
  </lemma>

  <\proof>
    Suppose otherwise. Say <math|0\<in\>S<rsub|0>>. There is then <math|N>
    large enough so that <math|\<lambda\><rsup|N><around|{|l<rsub|-1>,l<rsub|1>|}>=<around|{|l<rsub|-n<rsub|1>-1>,l<rsub|n<rsub|2>+1>|}>>
    with <math|<around|{|w<rsub|n>|}><rsub|n\<in\><Z>>=<around|{|w<rsub|j>|}><rsub|j=-n<rsub|1>*\<ldots\>,n<rsub|2>>>.
    For <math|j\<in\>{-n<rsub|1>,\<ldots\>,n<rsub|2>}> and
    <math|y\<in\>S<rsub|j>> we have <math|T-y\<sim\><rsub|s>T-w<rsub|j>-y>
    and <math|T-y\<sim\><rsub|s>T-\<lambda\><rsup|N>*w<rsub|0>>. Let
    <math|M<rsub|j>\<assign\>{t\<in\><R>:T-y\<sim\><rsub|s>T-t*w<rsub|j>-y>
    for all <math|y\<in\>S<rsub|j>}>. Then <math|M<rsub|j>> is a
    <math|<Z>>-module. By Lemma <reference|no slip>, <math|M<rsub|j>> must
    have a smallest positive element, so <math|M<rsub|j>> is isomorphic with
    <math|<Z>>. Thus, since <math|<around|\||\<lambda\><rsup|N>*w<rsub|0>|\|>/<around|\||w<rsub|j>|\|>\<in\>M<rsub|j>>
    for <math|j\<in\>{-n<rsub|1>,\<ldots\>,n<rsub|2>}>, there must be nonzero
    <math|k<rsub|j>,m<rsub|j>\<in\><Z>> with
    <math|k<rsub|j>*w<rsub|j>=m<rsub|j>*\<lambda\><rsup|N>*w<rsub|0>>. Then
    <math|T-y\<sim\><rsub|s>T-m*w<rsub|0>-y> for all
    <math|y\<in\><R><rsup|2>> where <math|m=\<lambda\><rsup|N>*<big|prod><rsub|j=-n<rsub|1>><rsup|n<rsub|2>>m<rsub|j>>.
    It follows from Lemma <reference|T=T'> that <math|T-m*w<rsub|0>=T>,
    contradicting the non-periodicity of <math|\<Omega\><rsub|\<Phi\>>>.
  </proof>

  <\lemma>
    <label|corner>Suppose that <math|T,T<rprime|'>\<in\>\<Omega\><rsub|\<Phi\>>>,
    <math|u\<in\>\<bbb-S\><rsup|1>>, and <math|\<delta\>\<gtr\>0> are such
    that <math|T-y\<sim\><rsub|s>T<rprime|'>-y> for all <math|y> with
    <math|0\<less\><around|\<langle\>|y,u|\<rangle\>>\<less\>\<delta\>>.
    Suppose also that <math|T\<nsim\><rsub|s>T<rprime|'>> and there is
    <math|y<rsub|0>> with <math|<around|\<langle\>|y<rsub|0>,u|\<rangle\>>=0>
    so that <math|T-y<rsub|0>\<sim\><rsub|s>T<rprime|'>-y<rsub|0>>. There is
    then a pair <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
    and a vector <math|w> not parallel with <math|u> so that
    <math|<around|{|v\<in\>\<bbb-S\><rsup|1>:<around|\<langle\>|v,w|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>>.
  </lemma>

  <\proof>
    There is <math|\<epsilon\>\<gtr\>0> so that
    <math|T-y\<sim\><rsub|s>T<rprime|'>-y> for all
    <math|y\<in\>c*l<around|(|B<rsub|\<epsilon\>><around|(|y<rsub|0>|)>|)>>.
    Consider the curves <math|c<rsub|s>:[-\<epsilon\>,\<epsilon\>]\<to\><R><rsup|2>>
    given by <math|c<rsub|s><around|(|t|)>=t<around|(|<frac|v|<around|\||v|\|>>|)>+<around|{|<around|(|<frac|\<epsilon\>*<around|(|1-s|)>+s<around|\||y<rsub|0>|\|>|\<epsilon\><rsup|2>>|)>*t<rsup|2>-<around|(|1-s|)>*\<epsilon\>-s<around|\||y<rsub|0>|\|><frac|y<rsub|0>|<around|\||y<rsub|0>|\|>>|}>+y>.
    For each <math|s>, the image of <math|c<rsub|s>> is an arc of a parabola
    from <math|y<rsub|0>-\<epsilon\><frac|v|<around|\||v|\|>>> to
    <math|y<rsub|0>+\<epsilon\><frac|v|<around|\||v|\|>>> with vertex at
    <math|y<rsub|0>-<around|[|<around|(|1-s|)>*\<epsilon\>+s<around|\||y<rsub|0>|\|>|]>*<frac|y<rsub|0>|<around|\||y<rsub|0>|\|>>>.
    When <math|s=0> this curve lies entirely in
    <math|c*l<around|(|B<rsub|\<epsilon\>><around|(|y<rsub|0>|)>|)>> and when
    <math|s=1> the vertex is at <math|0>. Let <math|s<rsub|0>> be the infimum
    of those <math|s\<gtr\>0> for which there is
    <math|t\<in\>[-\<epsilon\>,\<epsilon\>]> with
    <math|T-c<rsub|s><around|(|t|)>\<nsim\><rsub|s>T<rprime|'>-c<rsub|s><around|(|t|)>>.
    Then there is <math|t<rsub|0>\<in\>(-\<epsilon\>,0]> with
    <math|T-c<rsub|s<rsub|0>><around|(|t<rsub|o>|)>\<nsim\><rsub|s>T<rprime|'>-c<rsub|s<rsub|0>><around|(|t<rsub|0>|)>>.
    Let <math|w> be the unit normal to the curve <math|c<rsub|s<rsub|0>>> at
    <math|c<rsub|s<rsub|0>><around|(|t<rsub|0>|)>> with
    <math|<around|\<langle\>|w,y<rsub|0>|\<rangle\>>\<gtr\>0>. For
    sufficiently small <math|r\<gtr\>0> we have:
    <math|<around|(|T-c<rsub|s<rsub|0>><around|(|t<rsub|0>|)>-r*w|)>-y\<sim\><rsub|s><around|(|T<rprime|'>-c<rsub|s<rsub|0>><around|(|t<rsub|0>|)>-r*w|)>-y>
    for all <math|y\<in\>B<rsub|r><around|(|0|)>)> and
    <math|<around|(|T-c<rsub|s<rsub|0>><around|(|t<rsub|0>|)>-r*w|)>+r*w\<nsim\><rsub|s><around|(|T<rprime|'>-c<rsub|s<rsub|0>><around|(|t<rsub|0>|)>-r*w|)>+r*w>.
    By Lemma <reference|branch points with direction> there is a branch pair
    <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>> as
    desired.
  </proof>

  <no-indent><with|font-shape|italic|Proof of Theorem <reference|two
  sectors>>. For the first part, we prove the equivalent statement: If
  <math|\<Omega\><rsub|\<Phi\>>> is a 2-dimensional FLC self-similar
  substitution tiling space with connected tiles, then there are
  <math|<around|(|T<rsub|1>,T<rprime|'><rsub|1>|)>,<around|(|T<rsub|2>,T<rprime|'><rsub|2>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  and non-parallel vectors <math|u<rsub|1>,u<rsub|2>> so that
  <math|<around|{|v\<in\>\<bbb-S\><rsup|1>:<around|\<langle\>|v,u<rsub|i>|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T<rsub|i>,T<rprime|'><rsub|i>|)>>
  for <math|i=1,2>.

  Let <math|T\<in\>\<Omega\>> be fixed by <math|\<Phi\>>. Let
  <math|\<tau\>\<in\>T> and <math|x\<ne\>0> be such that
  <math|\<tau\>-x\<in\>T>. For <math|x<rsub|0>\<in\><wide|\<tau\>|\<abovering\>>>
  let <math|r\<gtr\>0> be such that <math|T-x<rsub|0>-y\<sim\><rsub|s>T-x-x<rsub|0>-y>
  for all <math|y\<in\>B<rsub|r><around|(|0|)>> and
  <math|T-x<rsub|0>-y<rsub|0>\<nsim\><rsub|s>T-x-x<rsub|0>-y<rsub|0>> for
  some <math|y<rsub|0>> with <math|<around|\||y<rsub|0>|\|>=r>. Then by Lemma
  <reference|branch points with direction> there is a branch pair, asymptotic
  in the positive half-plane determined by
  <math|z=z<around|(|\<tau\>,x,x<rsub|0>|)>\<assign\>-y<rsub|0>>. Hence we
  are done, unless all such <math|\<tau\>,x,x<rsub|0>> produce parallel
  <math|z<rprime|'>*s>. For such <math|\<tau\>,x,x<rsub|0>,r>, and
  <math|y<rsub|0>>, let <math|r<rsub|M>=s*u*p{r<rprime|'>:T-<around|(|x<rsub|0>+<around|(|1-r<rprime|'>/r|)>*y<rsub|0>|)>-y\<sim\><rsub|s>T-x-<around|(|x<rsub|0>+<around|(|1-r<rprime|'>/r|)>*y<rsub|0>|)>-y>
  for all <math|y\<in\>B<rsub|r<rprime|'>><around|(|0|)>}>. It is easily
  checked that <math|r\<le\>r<rprime|'>>. If <math|r<rprime|'>=\<infty\>>,
  then <math|<around|(|T-x<rsub|0>-y<rsub|0>|)>-v\<sim\><rsub|s><around|(|T-x<rsub|0>-y<rsub|0>|)>-x-v>
  for all <math|v> with <math|<around|\<langle\>|v,-y<rsub|0>|\<rangle\>><space|0.17em>\<gtr\>0>.
  By Lemma <reference|existence of R>, <math|<around|(|T-x<rsub|0>-y<rsub|0>|)>>
  and <math|<around|(|T-x<rsub|0>-y<rsub|0>|)>-x> would agree on
  <math|<around|{|v:<around|\<langle\>|v,-y<rsub|0>|\<rangle\>>\<ge\>R|}>>
  for some <math|R>. Pick <math|v<rsub|n>> with
  <math|<around|\<langle\>|v<rsub|n>,-y<rsub|0>|\<rangle\>>\<to\>\<infty\>>
  and <math|<around|(|T-x<rsub|0>-y<rsub|0>|)>-v<rsub|n>\<to\>T<rprime|'>\<in\>\<Omega\>>.
  Then <math|<around|(|T-x<rsub|0>-y<rsub|0>|)>-x-v<rsub|n>\<to\>T<rprime|'>-x>
  and <math|T<rprime|'>-x=T<rprime|'>>, contradicting non-periodicity of
  <math|\<Omega\>>. Thus <math|r\<le\>r<rprime|'>\<less\>\<infty\>>.

  If it is not the case that <math|T-<around|(|x<rsub|0>+<around|(|1-r<rsub|M>/r|)>*y<rsub|0>|)>-y\<sim\><rsub|s>T-x-<around|(|x<rsub|0>+<around|(|1-r<rsub|M>/r|)>*y<rsub|0>|)>-y>
  for all <math|y\<in\>c*l<around|(|B<rsub|r<rsub|M>><around|(|0|)>|)>\<setminus\>{\<pm\><around|(|<frac|r<rsub|M>|r>|)>*y<rsub|0>}>,
  we are done, by Lemma <reference|branch points with direction>. Also, by
  maximality of <math|r<rsub|M>>, <math|T-<around|(|x<rsub|0>+<around|(|1-r<rsub|M>/r|)>*y<rsub|0>|)>-y\<nsim\><rsub|s>T-x-<around|(|x<rsub|0>+<around|(|1-r<rsub|M>/r|)>*y<rsub|0>|)>-y>
  for <math|y=\<pm\><around|(|<frac|r<rsub|M>|r>|)>*y<rsub|0>>.

  Let us suppose that all the <math|z<around|(|\<tau\>,x,x<rsub|0>|)>> are
  parallel. Choose a unit vector <math|z> parallel to all these, and let
  <math|z<rsup|\<perp\>>> be a unit vector perpendicular to <math|z>. Let
  <math|S=S<around|(|\<tau\>,x,x<rsub|0>|)>> be the infinite open strip
  <math|S\<assign\><around|{|s*z<rsup|\<perp\>>+x<rsub|0>+<around|(|1-t|)>*y<rsub|0>+t<around|(|<frac|r-2*r<rsub|M>|r>|)>*y<rsub|0>:s\<in\><R>,0\<less\>t\<less\>1|}>>.
  We claim that <math|T-y\<sim\><rsub|s>T-x-y> for all <math|y\<in\>S>. For
  if this were not so, we could push parabolic curves out along <math|S>, as
  in the proof of Lemma <reference|corner>, until there occurs a first
  tangency with the set of those <math|y>'s such that
  <math|T-y\<nsim\><rsub|s>T<rprime|'>-x-y>. The normal to the parabola at
  that point of tangency would not be parallel to <math|z>, leading to a
  <math|z<around|(|\<tau\><rprime|'>,x,x<rprime|'><rsub|0>|)>> not parallel
  with <math|z>. Furthermore, each boundary component of
  <math|c*l<around|(|S|)>> contains a point <math|y> at which
  <math|T-y\<nsim\><rsub|s>T<rprime|'>-x-y> (take <math|s=0> and
  <math|t\<in\><around|{|0,1|}>> in the definition of <math|S>). If not all
  points of <math|\<partial\>*S> have this property, we are done by Lemma
  <reference|corner>. For any <math|x<rsub|0>,x<rprime|'><rsub|0>\<in\><wide|\<tau\>|\<abovering\>>>,
  <math|S<around|(|\<tau\>,x,x<rsub|0>|)>> and
  <math|S<around|(|\<tau\>,x,x<rprime|'><rsub|0>|)>> are either disjoint or
  equal; since tile interiors are connected, they must be equal. Hence
  <math|<wide|\<tau\>|\<abovering\>>\<subset\>S<around|(|\<tau\>,x,x<rsub|0>|)>>
  and the boundary components of all the strips
  <math|S<rsub|\<tau\>,x>\<assign\>S<around|(|\<tau\>,x,x<rsub|0>|)>> are
  <math|\<epsilon\>>-characteristics for <math|T> for any <math|\<epsilon\>>
  so that each tile contains an <math|\<epsilon\>/2>-ball. Fix such an
  <math|\<epsilon\>\<gtr\>0>.

  For any fixed <math|x\<ne\>0>, the widths of the strips
  <math|S<rsub|\<tau\>,x>> are uniformly bounded: otherwise, we could find
  <math|x<rsub|n>> so that <math|T-x<rsub|n>-y\<sim\><rsub|s>T-x-x<rsub|n>-y>
  for <math|y\<in\>B<rsub|n><around|(|0|)>>,
  <math|T-x<rsub|n>\<to\><wide|T|\<bar\>>>, and
  <math|T-x-x<rsub|n>\<to\><wide|T|\<bar\>>-x>, and we would have
  <math|<wide|T|\<bar\>>-y\<sim\><rsub|s><wide|T|\<bar\>>-x-y> for all
  <math|y> so that <math|<wide|T|\<bar\>>=<wide|T|\<bar\>>-x>, by Lemma
  <reference|T=T'>, in contradiction to the non-periodicity of
  <math|\<Omega\>>. It follows that there must be an <math|r> so that any
  strip of the form <math|S=<around|{|s*z+x<rsub|o>-<around|(|1-t|)>*r*z<rsup|\<perp\>>+t*r*z<rsup|\<perp\>>:s\<in\><R>,0\<less\>t\<less\>1|}>>
  contains a component of <math|\<partial\>*S<rsub|\<tau\>,x>> for some
  <math|\<tau\>> and <math|x\<ne\>0>. Indeed, let <math|P> be a patch of
  <math|T> that contains tiles <math|\<tau\>> and <math|\<tau\>+x> for some
  <math|x\<ne\>0>. Then for each <math|w> so that <math|P+w\<subset\>T>,
  there is a strip <math|S<rsub|\<tau\>+w,x>> that intersects <math|P+w>.
  Since the strips <math|S<rsub|\<tau\>+w,x>> have uniformly bounded widths
  and since there is an <math|R> so that for every <math|y\<in\><R><rsup|2>>
  there is a <math|w> with <math|s*p*t*<around|(|P+w|)>\<subset\>B<rsub|R><around|(|y|)>>,
  we must have <math|r> as desired.

  Let <math|r> be as above. It follows from Lemma <reference|finitely many
  cuts> (together with FLC) that <math|{B<rsub|2*r>*<around|[|T-y|]>:y\<in\>\<partial\>*S<rsub|\<tau\>,x>>
  for some <math|\<tau\>\<in\>T> and <math|x\<ne\>0> with
  <math|\<tau\>\<in\>T-x}> is finite up to translation in the <math|z>
  direction. Thus, for each boundary component <math|l> of a strip
  <math|S<rsub|\<tau\>,x>> there is a <math|y\<in\>l> and
  <math|w=w<around|(|l|)>\<ne\>0> parallel with <math|z> so that
  <math|B<rsub|2*r>*<around|[|T-y|]>=B<rsub|2*r>*<around|[|T-y+w|]>>.
  Furthermore, we can choose the <math|w<around|(|l|)>> to have uniformly
  bounded lengths (if <math|{B<rsub|2*r>*<around|[|T-y|]>:y\<in\>\<partial\>*S<rsub|\<tau\>,x>>
  for some <math|\<tau\>\<in\>T> and <math|x\<ne\>0> with
  <math|\<tau\>\<in\>T-x}> has <math|m> elements, up to translation in the
  <math|z>-direction, and the diameters of these patches are all less than d,
  then we can take <math|<around|\||w<around|(|l|)>|\|>\<le\>m*d>). It is
  then a consequence of finite local complexity that
  <math|{w<around|(|l|)>:l> a component of
  <math|\<partial\>*S<rsub|\<tau\>,x>,\<tau\>\<in\>T,\<tau\>+x\<in\>T,x\<ne\>0}>
  is finite.

  Now let <math|l<rsub|0>> be a boundary component of some
  <math|S<rsub|\<tau\>,x>>, let <math|y<rsub|0>\<in\>l<rsub|0>> be such that
  <math|B<rsub|2*r>*<around|[|T-y<rsub|0>|]>=B<rsub|2*r>*<around|[|T-y<rsub|0>+w<around|(|l<rsub|0>|)>|]>>
  and let <math|P<rsub|0>\<assign\>B<rsub|2*r>*<around|[|T-y<rsub|0>|]>+y<rsub|0>>.
  Then <math|P<rsub|0>> and <math|P<rsub|0>+w<around|(|l<rsub|0>|)>> are
  patches in <math|T> and, as above for <math|\<tau\>,x>, there is a strip
  <math|S<rprime|'><rsub|0>\<assign\>S<rsub|P<rsub|0>,w<around|(|l<rsub|0>|)>>>
  so that <math|T-y\<sim\><rsub|s>T-w<around|(|l<rsub|0>|)>-y> for all
  <math|y\<in\>S<rprime|'><rsub|0>>. Also,
  <math|<around|{|y:d<around|(|y,l<rsub|0>|)>\<less\>2*r|}>\<subset\>S<rprime|'><rsub|0>>.
  Now let <math|l<rsub|1>> be a boundary component of some
  <math|S<rsub|\<tau\>,x>> with <math|y<rsub|1>\<in\>l<rsub|1>>,
  <math|r\<less\><around|\<langle\>|y<rsub|1>,z<rsup|\<perp\>>|\<rangle\>>\<less\>2*r>,
  and with <math|B<rsub|2*r>*<around|[|T-y<rsub|1>|]>=B<rsub|2*r>*<around|[|T-y<rsub|1>+w<around|(|l<rsub|1>|)>|]>>.
  Let <math|P<rsub|1>\<assign\>B<rsub|2*r>*<around|[|T-y<rsub|1>|]>+y<rsub|1>>
  and let <math|S<rprime|'><rsub|1>\<assign\>S<rsub|P<rsub|1>,w<around|(|l<rsub|1>|)>>>.
  Continuing in this manner, we construct lines <math|l<rsub|n>> and strips
  <math|S<rprime|'><rsub|n>>, <math|n\<in\><Z>>. Letting <math|S<rsub|n>> be
  the intersection of <math|S<rprime|'><rsub|n>> and the strip between
  <math|l<rsub|n-1>> and <math|l<rsub|n+1>>, and
  <math|w<rsub|n>=w<around|(|l<rsub|n>|)>>, the hypotheses of Lemma
  <reference|strips> are satisfied, but the conclusion of that lemma is
  contradicted, as <math|<around|{|w<rsub|n>|}>> finite.

  Now suppose <math|\<Omega\>> has only branch line pairs and suppose that
  <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>,
  <math|v\<in\>\<partial\>*S<around|(|T,T<rprime|'>|)>>,
  <math|t<rsub|0>\<in\><R><rsup|+>>, and <math|\<epsilon\>\<gtr\>0> are such
  that <math|T-t<rsub|0>*v\<nsim\><rsub|s>T<rprime|'>-t<rsub|0>*v> and
  <math|T-t*v\<sim\><rsub|s>T<rprime|'>-t*v> for
  <math|t<rsub|0>\<less\>t\<less\>t<rsub|0>+\<epsilon\>>. There is a
  <math|k\<gtr\>0> so that there are arbitrarily large <math|n> such that
  <math|<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T-t<rsub|0>*v|)>|]>,B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T-t<rsub|0>*v|)>|]>|)>>
  and <math|<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T-t<rsub|0>*v|)>|]>,B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T-t<rsub|0>*v|)>|]>|)>>
  are the same up to translation. As in previous arguments, this translation
  must be parallel to <math|v> and, as soon as
  <math|\<lambda\><rsup|n>*\<epsilon\>> is greater than the diameter of any
  tile, this translation must be zero. Fix such an <math|n> and let
  <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>\<assign\>(\<cup\><rsub|m\<ge\>0>\<Phi\><rsup|m*k>(B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T-t<rsub|0>*v|)>|]>,\<cup\><rsub|m\<ge\>0>\<Phi\><rsup|m*k>*<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rprime|'>-t<rsub|0>*v|)>|]>|)>>.
  Then <math|<around|(|<wide|T|\<bar\>>,<wide|T<rprime|'>|\<bar\>>|)>> is a
  periodic branch pair with <math|S<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>\<supset\>S<around|(|T,T<rprime|'>|)>>.
  But <math|<wide|T|\<bar\>>-t*v\<sim\><rsub|s><wide|T|\<bar\>><rprime|'>-t*v>
  for <math|0\<less\>t\<less\>\<epsilon\>>. It follows from the periodicity
  of <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>> that
  <math|<wide|T|\<bar\>>-t*v\<sim\><rsub|s><wide|T|\<bar\>><rprime|'>-t*v>
  for all <math|t\<gtr\>0>. Thus <math|v\<in\>S<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>>
  so that <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>> is
  an isolated or corner pair. <space|stretch><math|\<square\>><next-line><next-line><no-indent><with|font-shape|italic|Proof
  of Theorem <reference|structure of branch locus>>. Let us first suppose
  that the branch locus of <math|\<Phi\>> is non-collapsing. In this case
  <math|<with|math-font|cal|P*B*L><around|(|\<Phi\>|)>=<with|math-font|cal|B*L><around|(|\<Phi\>|)>>
  (Proposition <reference|PBL=BL>) and, if
  <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  and <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>>, then
  <math|<around|(|T-t*v,T<rprime|'>-t*v|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  for all <math|t\<ge\>0>. Since <math|<with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  is closed (Lemma <reference|branch pairs closed>), we see that
  <math|<with|math-font|cal|B*L><around|(|\<Phi\>|)>=<around|{|T:<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>|}>>
  and <math|<with|math-font|cal|B*L><around|(|\<Phi\>|)>> is also closed. Fix
  <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>> and
  <math|u\<in\>\<bbb-S\><rsup|1>> with <math|<around|{|y\<in\>\<bbb-S\><rsup|1>:<around|\<langle\>|y,u|\<rangle\>><space|0.17em>\<gtr\>0|}>\<subset\>S<around|(|T,T<rprime|'>|)>>
  for some <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<phi\>|)>>.
  Suppose that <math|\<tau\><rsub|1>,\<tau\><rsub|2>\<in\>T>,
  <math|t<rsub|1>,t<rsub|2>\<in\><R><rsup|+>>, and <math|x\<in\><R><rsup|2>>
  are such that <math|t<rsub|i>*v\<in\>i*n*t<around|(|\<tau\><rsub|i>|)>> for
  <math|i=1,2>, <math|\<tau\><rsub|1>+x=\<tau\><rsub|2>>, and
  <math|B<rsub|0>*<around|[|T<rprime|'>-t<rsub|1>*v|]>+x=B<rsub|0>*<around|[|T<rprime|'>-t<rsub|2>*v|]>>.
  Since <math|B<rsub|0>*<around|[|T-t<rsub|i>*v|]>> is stably related to
  <math|B<rsub|0>*<around|[|T<rprime|'>-t<rsub|i>*v|]>> on
  <math|i*n*t*<around|(|s*p*t*<around|(|B<rsub|0>*<around|[|T-t<rsub|i>*v|]>|)>\<cap\>s*p*t*<around|(|B<rsub|0>*<around|[|T<rprime|'>-t<rsub|i>*v|]>|)>|)>\<cap\><around|{|y\<in\><R><rsup|2>:<around|\<langle\>|y,u|\<rangle\>><space|0.17em>\<gtr\>0|}>>,
  while <math|B<rsub|0>*<around|[|T-t<rsub|i>*v|]>> is not stably related to
  <math|B<rsub|0>*<around|[|T<rprime|'>-t<rsub|i>*v|]>> on
  <math|<around|{|t<rsub|i>*v|}>> for <math|i=1,2>, it must be the case that
  <math|x> is parallel with <math|v>. That is, the pairs
  <math|<around|(|\<tau\><rsub|1>,l\<cap\>\<tau\><rsub|1>|)>> and
  <math|<around|(|\<tau\><rsub|2>,l\<cap\>\<tau\><rsub|2>|)>> are the same up
  to translation, where <math|l=l<rsub|v>\<assign\><around|{|t*v:t\<in\><R>|}>>.
  Since there are only finitely many translationally inequivalent pairs of
  patches of the form <math|<around|(|B<rsub|0><around|[|<wide|T|\<bar\>>|]>,B<rsub|0><around|[|<wide|T|\<bar\>><rprime|'>|]>|)>>
  with <math|<around|(|<wide|T|\<bar\>>,<wide|T|\<bar\>><rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  (Lemma <reference|finitely many patches> - note that, in the above,
  <math|<around|(|T-t<rsub|i>*v,T<rprime|'>-t<rsub|i>*v|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  from the non-collapsing assumption), and since the set
  <math|<around|{|v:v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>,<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>|}>>
  is finite (Theorem <reference|finitely many sectors>), the collection
  <math|<around|{|<around|[|<around|(|\<tau\>,\<tau\>\<cap\>l|)>|]>|}>> of
  translation equivalence classes of pairs
  <math|<around|(|\<tau\>,\<tau\>\<cap\>l|)>>, where
  <math|0\<in\>\<tau\>\<in\>T> and <math|l=l<rsub|v>> for some <math|T> with
  <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  and <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>>, is
  finite. By first collaring tiles if necessary, we may assume that
  <math|\<Phi\>> forces the border so that the map
  <math|<wide|\<pi\>|^>:\<Omega\><rsub|\<Phi\>>\<to\><wide|X|^><rsub|\<Phi\>>\<assign\><inv>F<rsub|\<Phi\>>>
  onto the inverse limit of the substitution map <math|F<rsub|\<Phi\>>> on
  the Anderson-Putnam complex <math|X<rsub|\<Phi\>>>, is a homeomorphism
  (<cite|AP>). The 2-dimensional CW-complex <math|X<rsub|\<Phi\>>> is the
  quotient of <math|<R><rsup|2>> formed from
  <math|T\<in\>\<Omega\><rsub|\<Phi\>>> by identifying <math|x<rsub|1>> and
  <math|x<rsub|2>> if there are <math|\<tau\><rsub|1>> and
  <math|\<tau\><rsub|2>> in <math|T> with
  <math|x<rsub|i>\<in\>\<tau\><rsub|i>> and
  <math|\<tau\><rsub|2>=\<tau\><rsub|1>+<around|(|x<rsub|2>-x<rsub|1>|)>>.
  Equivalently, <math|X<rsub|\<Phi\>>\<assign\><around|{|<around|[|<around|(|\<tau\>,x|)>|]>:x\<in\>\<tau\>,\<tau\>\<in\>T,T\<in\>\<Omega\><rsub|\<Phi\>>|}>/\<sim\>>,
  with <math|\<sim\>> the transitive closure of the relation defined by
  <math|<around|[|<around|(|\<tau\><rsub|1>,x<rsub|1>|)>|]>\<sim\><around|[|<around|(|\<tau\><rsub|2>,x<rsub|2>|)>|]>>
  if there are <math|T\<in\>\<Omega\><rsub|\<Phi\>>>,
  <math|<wide|\<tau\>|\<bar\>><rsub|1>,<wide|\<tau\>|\<bar\>><rsub|2>\<in\>T>,
  and <math|y<rsub|1>,y<rsub|2>> so that <math|<wide|\<tau\>|\<bar\>><rsub|i>=\<tau\><rsub|i>+y<rsub|i>>,
  <math|i=1,2>, and <math|x<rsub|1>+y<rsub|1>=x<rsub|2>+y<rsub|2>>. With this
  description of <math|X<rsub|\<Phi\>>>, <math|\<pi\>:\<Omega\><rsub|\<phi\>>\<to\>X<rsub|\<Phi\>>>
  is given by <math|\<pi\><around|(|T|)>\<assign\><around|[|<around|[|<around|(|\<tau\>,0|)>|]>|]>>,
  where <math|0\<in\>\<tau\>\<in\>T> and <math|<around|[|<around|[||(>\<ast\>,\<ast\><around|)||]>|]>>
  denotes the <math|\<sim\>>-equivalence class of the translational
  equivalence class of (<math|\<ast\>,\<ast\>>). We see that
  <math|K\<assign\>\<pi\><around|(|<with|math-font|cal|B*L><around|(|\<Phi\>|)>|)>>
  is a 1-dimensional simplicial complex contained in the finite union of line
  segments <math|<around|{|<around|[|<around|[|<around|(|\<tau\>,x|)>|]>|]>:x\<in\>\<tau\>\<cap\>l<rsub|v>|}>>,
  with <math|0\<in\>\<tau\>\<in\>T>, <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>,
  and <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>>. With
  <math|f\<assign\>F<rsub|\<Phi\>>\<mid\><rsub|K>>, we have that
  <math|<wide|\<pi\>|^>\<mid\><rsub|<with|math-font|cal|B*L><around|(|\<Phi\>|)>>>
  maps <math|<with|math-font|cal|B*L><around|(|\<Phi\>|)>> is
  homeomorphically onto <math|<inv>f>, conjugating
  <math|\<Phi\>\<mid\><rsub|<with|math-font|cal|B*L><around|(|\<Phi\>|)>>>
  with <math|<wide|f|^>>. The set <math|V> of vertices of <math|K> is defined
  as follows. Let <math|V<rsub|1>\<assign\>{\<pi\><around|(|T|)>:<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>
  is an isolated or corner pair<math|}>: <math|V<rsub|1>> is finite by
  Theorem <reference|finitely many sectors>. Let
  <math|V<rsub|2>\<assign\>{<around|[|<around|[|<around|(|\<tau\>,0|)>|]>|]>\<in\>K:0>
  is a vertex of <math|\<tau\>}>: <math|V<rsub|2>> is finite under the
  assumption that all tiles are polygons. Let
  <math|V<rsub|3>\<assign\>{<around|[|<around|[|<around|(|\<tau\>,0|)>|]>|]>:0>
  is in the interior of an edge <math|\<eta\>> of <math|\<tau\>>,
  <math|\<tau\>\<in\>T,<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|B*P><around|(|\<Phi\>|)>>,
  and there is <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>>
  with <math|v> not parallel with <math|\<eta\>}>: <math|V<rsub|3>> is the
  set of points where the finitely many line segments in <math|K> meet an
  edge of a polygonal face of <math|X<rsub|\<Phi\>>> transversely, so
  <math|V<rsub|3>> is finite. Then <math|V\<assign\>V<rsub|1>\<cup\>V<rsub|2>\<cup\>V<rsub|3>>
  is finite and forward invariant under <math|f>. The conditions for
  <math|f:K\<to\>K> to be expanding Markov are easy to check.

  Now assume that <math|\<Phi\>> is self-similar Pisot. We will argue that if
  <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|P*B*P><around|(|\<Phi\>|)>>
  and <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>>, then the
  ray <math|<around|{|t*v:t\<ge\>0|}>> crosses the tiles of <math|T> in only
  finitely many ways. The result then follows as above. Let
  <math|g:\<Omega\><rsub|\<Phi\>>\<to\><wide|<T>|^><rsub|A>> be geometric
  realization onto the maximal equi-continuous factor and let
  <math|<wide|F|^><rsub|A>:<wide|<T>|^><rsub|A>\<to\><wide|<T>|^><rsub|A>> be
  the hyperbolic automorphism with <math|g\<circ\>\<Phi\>=<wide|F|^><rsub|A>\<circ\>g>.
  (Here <math|A> is the <math|2*d\<times\>2*d> block diagonal matrix whose
  blocks are the companion matrix of the Pisot inflation factor
  <math|\<lambda\>>, <math|d=d*e*g<around|(|\<lambda\>|)>>, <math|F<rsub|A>>
  is the associated hyperbolic toral endomorphism, and
  <math|<wide|F|^><rsub|A>> is the shift on the inverse limit
  <math|<wide|<T>|^><rsub|A>\<assign\><inv>F<rsub|A>>.) The map <math|g> also
  semiconjugates translation in <math|\<Omega\><rsub|\<Phi\>>> with an
  <math|<R><rsup|2>> action on <math|<wide|<T>|^><rsub|A>> that consists of
  translation along the 2-dimensional unstable (under
  <math|<wide|F|^><rsub|A>>) leaves in <math|<wide|<T>|^><rsub|A>>: we will
  use the notation <math|g<around|(|T|)>-x\<assign\>g*<around|(|T-x|)>> for
  this action. More explicitly in coordinates, the <math|<R><rsup|2>> action
  on <math|<wide|<T>|^><rsub|A>> is given by
  <math|<around|(|z<rsub|0>,\<ldots\>,z<rsub|n>,\<ldots\>|)>-x=<around|(|z<rsub|0>-<wide|x|~>,\<ldots\>,z<rsub|n>-\<lambda\><rsup|-n>*<wide|x|~>,\<ldots\>|)>>,
  where <math|x\<mapsto\><wide|x|~>> is an isomorphism of <math|<R><rsup|2>>
  with the unstable space <math|W<rsup|u><rsub|A>> of <math|F<rsub|A>>. We
  will also use the key fact that <math|g> is boundedly finite-to-one
  (<cite|BKS>).

  Given <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|P*B*P><around|(|\<Phi\>|)>>
  and <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>>, we claim
  there is <math|t<rsub|0>\<gtr\>0> and <math|<wide|T|\<bar\>>\<in\>\<Omega\><rsub|\<Phi\>>>,
  with <math|<wide|T|\<bar\>>> <math|\<Phi\>>-periodic, so that
  <math|T-t<rsub|0>*v\<in\>W<rsup|s><around|(|<wide|T|\<bar\>>|)>>. Indeed,
  if there is <math|t<rsub|1>\<gtr\>0> so that
  <math|T-t<rsub|1>*v\<sim\><rsub|s>T<rprime|'>-t<rsub|1>*v>, then let
  <math|t<rsub|0>\<assign\>i*n*f*<around|{|a:T-t*v\<sim\><rsub|s>T<rprime|'>-t*v<space|0.17em>\<forall\>t\<in\><around|[|a,t<rsub|1>|]>|}>>.
  Then <math|t<rsub|0>\<gtr\>0> and <math|T-t<rsub|0>*v\<nsim\><rsub|s>T<rprime|'>-t<rsub|0>*v>.
  Let <math|n\<in\><N>> be large and <math|k\<in\><N>> be such that
  <math|<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T-t<rsub|0>*v|)>|]>,B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T<rprime|'>-t<rsub|0>*v|)>|]>|)>>
  is the same as <math|<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T-t<rsub|0>*v|)>|]>,B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rprime|'>-t<rsub|0>*v|)>|]>|)>>,
  up to translation. Such translation must be parallel with <math|v> (as, for
  example, in the proof of Proposition <reference|periodic branch pairs
  exist>) and then must be 0, since <math|B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T-t<rsub|0>*v|)>|]>>
  and <math|B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T<rprime|'>-t<rsub|0>*v|)>|]>>
  as well as <math|B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T-t<rsub|0>*v|)>|]>>
  and <math|B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rprime|'>-t<rsub|0>*v|)>|]>>,
  are stably related on <math|<around|{|t*v:t\<ge\>0|}>> intersected with the
  supports of the appropriate patches. That is,
  <math|<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T-t<rsub|0>*v|)>|]>,B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T<rprime|'>-t<rsub|0>*v|)>|]>|)>=<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T-t<rsub|0>*v|)>|]>,B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rprime|'>-t<rsub|0>*v|)>|]>|)>>
  and <math|T-t<rsub|0>*v\<in\>W<rsup|s><around|(|<wide|T|\<bar\>>|)>>, with
  <math|<wide|T|\<bar\>>\<assign\>\<cup\><rsub|n\<ge\>0>\<Phi\><rsup|n*k>*<around|(|B<rsub|0>*<around|[|T-t<rsub|0>*v|]>|)>>
  <math|\<Phi\>>-periodic of period <math|k>. If, instead,
  <math|T-t*v\<nsim\><rsub|s>T<rprime|'>-t*v> for all <math|t\<ge\>0>, there
  are only finitely many patches of the form
  <math|B<rsub|0>*<around|[|T-t*v|]>> for <math|t\<ge\>0>, up to translation
  parallel to <math|v> (as argued in the non-collapsing case above). Let
  <math|n> be the <math|\<Phi\>>-period of <math|T>. There then are
  arbitrarily large <math|t<rsub|1>> and <math|s\<in\><R><rsup|+>>,
  <math|m\<in\><N>> with <math|B<rsub|0>*<around|[|T-t<rsub|1>*v|]>+s*v\<subset\>\<Phi\><rsup|m*n>*<around|(|B<rsub|0>*<around|[|T-t<rsub|1>*v|]>|)>>.
  Let <math|t<rsub|0>\<assign\>t<rsub|1>+<frac|s|\<lambda\><rsup|m*n>-1>> and
  let <math|<wide|T|\<bar\>>\<assign\>\<cup\><rsub|l\<ge\>0>\<Phi\><rsup|l*m*n>*<around|(|B<rsub|0>*<around|[|T-t<rsub|0>*v|]>|)>>.
  Then <math|<wide|T|\<bar\>>> is <math|\<Phi\>>-periodic and
  <math|T-t<rsub|0>*v\<in\>W<rsup|s><around|(|<wide|T|\<bar\>>|)>>.

  To simplify notation, assume that <math|T> is fixed by <math|\<Phi\>>. Let
  <math|t<rsub|0>> and <math|<wide|T|\<bar\>>> be as above with
  <math|<wide|T|\<bar\>>> periodic of period <math|k> under <math|\<Phi\>>.
  Let <math|L<rsub|v>=L<rsub|v><around|(|T|)>> denote the ray
  <math|L<rsub|v>\<assign\><around|{|g*<around|(|T-t*v|)>:t\<ge\>0|}>=<around|{|g<around|(|T|)>-t*v:t\<ge\>0|}>>
  in <math|<wide|<T>|^><rsub|A>>. Note that
  <math|g*<around|(|T-\<lambda\><rsup|n*k>*t<rsub|0>*v|)>=g*<around|(|\<Phi\><rsup|n*k>*<around|(|T-t<rsub|0>*v|)>|)>=<wide|F|^><rsub|A><rsup|n*k>*<around|(|g*<around|(|T-t<rsub|0>*v|)>|)>\<to\>g<around|(|<wide|T|\<bar\>>|)>>
  as <math|n\<to\>\<infty\>> so that <math|g<around|(|<wide|T|\<bar\>>|)>\<in\>c*l<around|(|L<rsub|v>|)>>
  and <math|L<rsub|v>> meets the <math|\<epsilon\>>-stable manifold
  <math|W<rsup|s><rsub|\<epsilon\>><around|(|g<around|(|<wide|T|\<bar\>>|)>|)>\<assign\><around|{|z\<in\><wide|<T>|^>:d<around|(|<wide|F|^><rsub|A><rsup|n><around|(|z|)>,<wide|F|^><rsub|A><rsup|n><around|(|g<around|(|<wide|T|\<bar\>>|)>|)>|)>\<le\>\<epsilon\><space|0.17em>\<forall\>n\<ge\>0|}>>
  for each <math|\<epsilon\>\<gtr\>0>. For each <math|n\<in\><N>>, let
  <math|\<pi\><rsub|n>:<wide|<T>|^>\<to\><T><rsup|2*d>=<R><rsup|2*d>/<Z><rsup|2*d>>
  be the projection of <math|<wide|T|^><rsub|A>=<inv>F<rsub|A>> onto the
  <math|n>-th coordinate space. We will prove now that
  <math|\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>> is a sub-torus
  of <math|<T><rsup|2*d>> of dimension at most <math|d>. (In fact the
  dimension of <math|\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>>
  must then be exactly <math|d>, but we won't need that here.)

  To see that this is the case, first note that the stable
  (<math|W<rsup|s><rsub|A>>) and unstable (<math|W<rsup|u><rsub|A>>) spaces
  of <math|A:<R><rsup|2*d>\<to\><R><rsup|2*d>>, at 0, have bases consisting
  of vectors with entries in the field <math|<Q><around|(|\<lambda\>|)>>.
  (<math|W<rsup|u><rsub|A>> is spanned by a pair of eigenvectors for <math|A>
  with eigenvalue <math|\<lambda\>>, while <math|W<rsup|s><rsub|A>> is the
  space orthogonal to a space spanned by a pair of eigenvectors for
  <math|A<rsup|T>> with eigenvalue <math|\<lambda\>>.) Now,
  <math|g<around|(|T|)>-t<rsub|0>*v,g<around|(|T|)>-\<lambda\><rsup|k>*t<rsub|0>*v\<in\>W<rsup|s><around|(|g<around|(|<wide|T|\<bar\>>|)>|)>>
  means that the vector <math|w\<assign\><around|(|\<lambda\><rsup|k>-1|)>*t<rsub|0>*<wide|v|~>>
  satisfies: (1) <math|w-p\<in\>W<rsup|s><rsub|A>> for some
  <math|p\<in\><Z><rsup|2*d>>. Also, since
  <math|<wide|v|~>\<in\>W<rsup|u><rsub|A>>: (2)
  <math|w\<in\>W<rsup|u><rsub|A>>. Conditions (1) and (2) can be expressed as
  a system linear equations with coefficients in
  <math|<Q><around|(|\<lambda\>|)>>; the unique solution
  <math|w=<around|(|w<rsub|1>,\<ldots\>,w<rsub|2*d>|)>> thus has all of its
  entries in <math|<Q><around|(|\<lambda\>|)>>. The dimension of
  <math|\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>=c*l<around|(|<around|{|t*w+<Z><rsup|2*d>:t\<in\><R>|}>|)>>
  equals the dimension over <math|<Q>> of the rational span of
  <math|<around|{|w<rsub|1>,\<ldots\>,w<rsub|2*d>|}>>. Since the dimension of
  <math|<Q><around|(|\<lambda\>|)>> over <math|<Q>> is <math|d>, the
  dimension of <math|\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>>
  is at most <math|d>. The same argument clearly works for
  <math|\<pi\><rsub|n>*<around|(|c*l<around|(|L<rsub|v>|)>|)>> for all
  <math|n\<ge\>0>, so <math|c*l<around|(|L<rsub|v>|)>> is a
  <math|d<rprime|'>>-dimensional solenoid for some <math|d<rprime|'>\<le\>d>.

  We are going to show that, for small <math|\<epsilon\>\<gtr\>0>,
  <math|W<rsup|s><rsub|\<epsilon\>><around|(|g<around|(|<wide|T|\<bar\>>|)>|)>\<cap\>c*l<around|(|L<rsub|v>|)>>
  is a <math|d<rprime|'>-1>-dimensional cross-section to the
  <math|<R>>-action <math|x\<mapsto\>x-t*v> on the solenoid
  <math|c*l<around|(|L<rsub|v>|)>>, to which orbits must return with bounded
  gap. From this it will follow that there are <math|t<rprime|'><rsub|i>>
  with <math|t<rprime|'><rsub|i+1>-t<rprime|'><rsub|i>> bounded and with
  <math|t<rprime|'><rsub|i>\<to\>\<pm\>\<infty\>> as
  <math|i\<to\>\<pm\>\<infty\>> so that <math|<around|{|B<rsub|0>*<around|[|T-t<rprime|'><rsub|i>*v|]>|}>>
  is finite. An immediate consequence is that
  <math|<around|{|t*v:t\<in\><R>|}>> intersects the tiles of <math|T> in only
  finitely many ways.

  There is <math|\<delta\>=\<delta\><around|(|v|)>\<gtr\>0> so that if
  <math|x+<Z><rsup|2*d>,y+<Z><rsup|2*d>\<in\>\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>>
  and <math|<around|\||x-y|\|>\<less\>\<delta\>>, then
  <math|s*x+<around|(|1-s|)>*y+<Z><rsup|2*d>\<in\>\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>>
  for all <math|s\<in\><R>>. We claim that for
  <math|\<epsilon\>\<less\>\<delta\>>, <math|B<rsub|\<epsilon\>/2><around|(|\<pi\><rsub|0><around|(|g<around|(|<wide|T|\<bar\>>|)>|)>|)>\<cap\>\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>\<subset\>\<pi\><rsub|0>(W<rsup|s><rsub|\<epsilon\>><around|(|g<around|(|<wide|T|\<bar\>>|)>|)>>.
  If this were not the case, then, by the choice of <math|\<delta\>>,
  <math|W<rsup|u><rsub|\<epsilon\>/2><around|(|\<pi\><rsub|0><around|(|g<around|(|<wide|T|\<bar\>>|)>|)>|)>\<subset\>\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>>
  and then <math|W<rsup|s><around|(|\<pi\><rsub|0><around|(|g<around|(|<wide|T|\<bar\>>|)>|)>|)>\<subset\>\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>>.
  But <math|W<rsup|s><around|(|\<pi\><rsub|0><around|(|g<around|(|<wide|T|\<bar\>>|)>|)>|)>>
  is dense in <math|<T><rsup|2*d>> and <math|\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>>
  is a proper closed subset of <math|<T><rsup|2*d>>. Clearly, this
  <math|\<delta\>> works for the corresponding statement in all coordinate
  projections <math|\<pi\><rsub|n>> simultaneously.

  Let <math|\<Delta\><rsub|n><around|(|\<epsilon\>|)>> denote the local
  <math|\<epsilon\>> stable manifold at the point
  <math|\<pi\><rsub|n><around|(|g<around|(|\<Phi\><rsup|-n><around|(|<wide|T|\<bar\>>|)>|)>|)>>
  for the restriction of <math|F<rsub|A>> to the torus
  <math|<T>\<assign\>\<pi\><rsub|0>*<around|(|c*l<around|(|L<rsub|v>|)>|)>=\<pi\><rsub|n>*<around|(|c*l<around|(|L<rsub|v>|)>|)>>.
  Then <math|\<Delta\><rsub|n>*<around|(|\<epsilon\>/2|)>> is contained in
  <math|W<rsup|s><rsub|\<epsilon\>><around|(|\<pi\><rsub|n><around|(|g<around|(|\<Phi\><rsup|-n><around|(|<wide|T|\<bar\>>|)>|)>|)>|)>>
  for <math|\<epsilon\>\<less\>\<delta\>> with <math|\<delta\>> depending
  only on <math|v> (and not on <math|T>, <math|<wide|T|\<bar\>>> or
  <math|n>). We saw above that the local unstable manifold
  <math|W<rsup|u><rsub|\<epsilon\>/2><around|(|\<pi\><rsub|n><around|(|g<around|(|\<Phi\><rsup|-n><around|(|<wide|T|\<bar\>>|)>|)>|)>|)>>
  of <math|F<rsub|A>> meets <math|<T>> only along the arc
  <math|\<pi\><rsub|n><around|(|g<around|(|\<Phi\><rsup|-n><around|(|<wide|T|\<bar\>>|)>|)>|)>-t*<wide|v|~>>,
  <math|<around|\||t|\|>\<less\>\<epsilon\>/2>, and it follows that
  <math|\<Delta\><rsub|n><around|(|\<epsilon\>|)>> is a co-dimension one disk
  in <math|<T>> transverse to the <math|<R>>-action in the direction of
  <math|<wide|v|~>>. Hence, orbits of the <math|<R>>-action on <math|<T>>
  return to <math|\<Delta\><rsub|n>*<around|(|\<epsilon\>/2|)>> with bounded
  gap. (We really have a different <math|<R>>-action on
  <math|<T>=\<pi\><rsub|n>*<around|(|c*l<around|(|L<rsub|v>|)>|)>> for each
  <math|n>, namely <math|<around|(|y,t|)>\<mapsto\>y-\<lambda\><rsup|-n>*t*<wide|v|~>>.
  We will take this into account.)

  Now choose <math|\<epsilon\><rprime|'>> small enough so that if
  <math|S,S<rprime|'>\<in\>\<Omega\><rsub|\<Phi\>>>,
  <math|g<rsup|-1><around|(|<around|{|g<around|(|S|)>|}>|)>=<around|{|S<rsub|1>,\<ldots\>,S<rsub|m>|}>>,
  and <math|g<around|(|S<rprime|'>|)>\<in\>W<rsup|s><rsub|\<epsilon\><rprime|'>><around|(|g<around|(|S|)>|)>>
  then <math|B<rsub|0><around|[|S<rprime|'>|]>=B<rsub|0><around|[|S<rsub|i>|]>>
  for some <math|i\<in\><around|{|1,\<ldots\>,m|}>>. Let <math|n> be large
  enough so that if <math|z,z<rprime|'>\<in\><wide|<T>|^><rsub|A>> are such
  that <math|\<pi\><rsub|n><around|(|z|)>=\<pi\><rsub|n><around|(|z<rprime|'>|)>>
  then <math|d<around|(|z,z<rprime|'>|)>\<less\>\<epsilon\><rprime|'>/2> and
  let <math|\<epsilon\>\<gtr\>0> be less that the <math|\<delta\>> above and
  also small enough so that if <math|d<around|(|\<pi\><rsub|n><around|(|z|)>,\<pi\><rsub|n><around|(|z<rprime|'>|)>|)>\<less\>\<epsilon\>>
  then <math|d<around|(|z,z<rprime|'>|)>\<less\>\<epsilon\><rprime|'>>. There
  is then a <math|b>, depending only on <math|\<epsilon\>> and <math|v>, and
  <math|<around|{|t<rsub|i><rprime|'>:i\<in\><Z>|}>> with
  <math|t<rprime|'><rsub|i>\<to\>\<pm\>\<infty\>> as
  <math|i\<to\>\<pm\>\<infty\>> and <math|0\<less\>t<rprime|'><rsub|i+1>-t<rprime|'><rsub|i>\<le\>b>
  for all <math|i\<in\><Z>>, so that <math|\<pi\><rsub|n>*<around|(|g*<around|(|T-t<rprime|'><rsub|i>*v|)>|)>=\<pi\><rsub|n><around|(|g<around|(|T|)>|)>-t<rprime|'><rsub|i>*\<lambda\><rsup|-n>*<wide|v|~>\<in\>\<Delta\><rsub|n>*<around|(|\<epsilon\>/2|)>>
  for all <math|i\<in\><Z>>. Let <math|g<rsup|-1><around|(|<around|{|g<around|(|<wide|T|\<bar\>>|)>|}>|)>=<around|{|<wide|T|\<bar\>><rsub|1>,\<ldots\>,<wide|T|\<bar\>><rsub|m>|}>>.
  We have that <math|B<rsub|0>*<around|[|T-t<rprime|'><rsub|i>*v|]>\<in\><around|{|B<rsub|0><around|[|<wide|T|\<bar\>><rsub|1>|]>,\<ldots\>,B<rsub|0><around|[|<wide|T|\<bar\>><rsub|m>|]>|}>>
  for all <math|i\<in\><Z>>.

  With <math|b> as above, let <math|B> be the maximum of the cardinalities of
  the collections <math|{B<rsub|b><around|[|S<rprime|'>|]>:S<rprime|'>\<in\>\<Omega\><rsub|\<Phi\>>>
  and <math|B<rsub|0><around|[|S<rprime|'>|]>=B<rsub|0><around|[|S|]>}> over
  all <math|S\<in\>\<Omega\><rsub|\<Phi\>>>. Finite local complexity insures
  that <math|B\<less\>\<infty\>>. Let <math|M> be the maximal cardinality of
  a fiber <math|g<rsup|-1><around|(|<around|{|g<around|(|S|)>|}>|)>> over all
  <math|S\<in\>\<Omega\><rsub|\<Phi\>>>: <math|M\<less\>\<infty\>> by
  <cite|BKS>. The number of distinct translation equivalence classes of pairs
  <math|<around|(|\<tau\>,\<tau\>\<cap\>l|)>> with <math|\<tau\>\<in\>T>,
  <math|l=<around|{|t*v:t\<in\><R>|}>>, and
  <math|l\<cap\>\<tau\>\<ne\>\<emptyset\>>, is bounded by <math|M*B> and this
  bound depends only on <math|v> and not on <math|T> (provided, of course,
  that there is <math|T<rprime|'>> with <math|<around|(|T,T<rprime|'>|)>\<in\><with|math-font|cal|P*B*P><around|(|\<Phi\>|)>>
  and <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>>).

  We prove now that for a given <math|v\<in\>\<bbb-S\><rsup|1>> there are
  only finitely many distinct sets <math|c*l*<around|{|T-t*v:t\<in\><R>|}>>
  where <math|T> varies over all members of periodic line pairs
  <math|<around|(|T,T<rprime|'>|)>> with <math|v\<in\>\<partial\>*S<around|(|T,T<rprime|'>|)>>.
  Indeed, there is a finite collection of pairs of patches
  <math|<around|{|<around|(|P<rsub|1>,P<rsub|1><rprime|'>|)>,\<ldots\>,<around|(|P<rsub|n>,P<rprime|'><rsub|n>|)>|}>>
  so that if <math|<around|(|T,T<rprime|'>|)>> is any line pair with
  <math|v\<in\>\<partial\>*S<around|(|T,T<rprime|'>|)>> then
  <math|<around|(|B<rsub|0><around|[|T|]>,B<rsub|0><around|[|T<rprime|'>|]>|)>=<around|(|P<rsub|i>-t*v,P<rprime|'><rsub|i>-t*v|)>>
  for some <math|i\<in\><around|{|1,\<ldots\>,n|}>,t\<in\><R>>. Suppose that
  <math|<around|(|T<rsub|1>,T<rprime|'><rsub|1>|)>> and
  <math|<around|(|T<rsub|2>,T<rprime|'><rsub|2>|)>> are periodic line pairs
  with <math|v\<in\>\<partial\>*S<around|(|T<rsub|i>,T<rprime|'><rsub|i>|)>,i=1,2>
  and <math|<around|(|B<rsub|0><around|[|T<rsub|1>|]>,B<rsub|0><around|[|T<rprime|'><rsub|1>|]>|)>=<around|(|B<rsub|0><around|[|T<rsub|2>|]>-s*v,B<rsub|0><around|[|T<rprime|'><rsub|2>|]>-s*v|)>>
  for some <math|s\<in\><R>>. Let <math|m> be a common <math|\<Phi\>>-period
  for <math|T<rsub|1>> and <math|T<rsub|2>>. Then
  <math|B<rsub|0><around|[|T<rsub|1>|]>=B<rsub|0>*<around|[|T<rsub|2>-s*v|]>>
  implies that <math|\<Phi\><rsup|k*m>*<around|(|T<rsub|2>-s*v|)>=T<rsub|2>-\<lambda\><rsup|k*m>*s*v\<to\>T<rsub|1>>
  as <math|k\<to\>\<infty\>>. Thus, <math|T<rsub|1>\<in\>c*l*<around|{|T<rsub|2>-t*v:t\<in\><R>|}>>.
  If <math|T<rsub|2>-t<rsub|i>*v\<to\>T<rsub|1>>, then
  <math|T<rsub|2>-<around|(|t<rsub|i>+t|)>*v\<to\>T<rsub|1>-t*v>. Thus,
  <math|c*l*<around|{|T<rsub|1>-t*v:t\<in\><R>|}>\<subset\>c*l*<around|{|T<rsub|2>-t*v:t\<in\><R>|}>>.
  Interchanging 1 and 2 and replacing <math|s> by <math|-s> in the foregoing
  shows that <math|c*l*<around|{|T<rsub|1>-t*v:t\<in\><R>|}>=c*l*<around|{|T<rsub|2>-t*v:t\<in\><R>|}>>.

  Note that if <math|<around|(|T,T<rprime|'>|)>> is a periodic line pair with
  <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>> then
  <math|-v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>> so the image
  <math|\<pi\>*<around|(|c*l<around|(|<around|{|T-t*v:t\<in\><R>|}>|)>|)>> in
  the Anderson-Putnam complex <math|X<rsub|\<Phi\>>> equals
  <math|\<cup\><rsub|w\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>>c*l<around|(|<around|{|T-t*w:t\<ge\>0|}>|)>>
  and hence this latter set is a finite union of line segments in
  <math|X<rsub|\<Phi\>>>. As there are only finitely many sets
  <math|c*l<around|(|<around|{|T-t*v:t\<in\><R>|}>|)>> for
  <math|<around|(|T,T<rprime|'>|)>> a periodic line pair and
  <math|v\<in\><wide|\<partial\>|~>S<around|(|T,T<rprime|'>|)>>, there are
  only finitely many such <math|v>, and there are only finitely many corner
  and isolated pairs, <math|K\<assign\>\<pi\><around|(|<with|math-font|cal|P*B*P><around|(|\<Phi\>|)>|)>>
  is a finite union of line segments (some may be degenerate, if there are
  isolated pairs) in <math|X<rsub|\<Phi\>>>. The description of
  <math|<with|math-font|cal|P*B*P><around|(|\<Phi\>|)>> as
  <math|<inv><around|(|f:K\<to\>K|)>> proceeds as in the non-collapsing case.
  <space|stretch><math|\<square\>>

  <\lemma>
    <label|triple>Suppose that <math|\<alpha\><rsub|1>> and
    <math|\<alpha\><rsub|3>> are arcs on <math|\<bbb-S\><rsup|1>> with the
    property that <math|\<alpha\><rsub|1>\<cup\>\<alpha\><rsub|3>> contains a
    closed semi-circle in its interior. If there are distinct tilings
    <math|T<rsub|1>,T<rsub|2>,T<rsub|3>\<in\>\<Omega\><rsub|\<Phi\>>> so that
    <math|T<rsub|i>> and <math|T<rsub|2>> are uniformly asymptotic in
    directions <math|\<alpha\><rsub|i>>, <math|i=1,3>, then there is
    <math|w\<in\><R><rsup|2>> so that <math|T<rsub|2>-w> is
    <math|\<Phi\>>-periodic.
  </lemma>

  <\proof>
    Let <math|T<rsup|n><rsub|i>=\<Phi\><rsup|-n><around|(|T<rsub|i>|)>>,
    <math|i=1,2,3>. By Lemmas <reference|asymptotic directions> and
    <reference|existence of R>, there is an <math|R> so that
    <math|B<rsub|0>*<around|[|T<rsup|n><rsub|i>-t*v|]>=B<rsub|0>*<around|[|T<rsup|n><rsub|2>-t*v|]>>
    for all <math|t\<ge\>R> and <math|v\<in\>\<alpha\><rsub|i>>,
    <math|i=1,3>. It follows that there are only finitely many triples of
    patches <math|<around|(|B<rsub|0><around|[|T<rsup|n><rsub|1>|]>,B<rsub|0><around|[|T<rsup|n><rsub|2>|]>,B<rsub|0><around|[|T<rsup|n><rsub|3>|]>|)>>,
    <math|n\<ge\>0>, up to translation. We may then choose a subsequence and
    a <math|k\<in\><N>> so that the triples
    <math|<around|(|B<rsub|0><around|[|T<rsup|n<rsub|j>><rsub|1>|]>,B<rsub|0><around|[|T<rsup|n<rsub|j>><rsub|2>|]>,B<rsub|0><around|[|T<rsup|n<rsub|j>><rsub|3>|]>|)>>
    and <math|<around|(|B<rsub|0><around|[|T<rsup|n<rsub|j>+k><rsub|1>|]>,B<rsub|0><around|[|T<rsup|n<rsub|j>+k><rsub|2>|]>,B<rsub|0><around|[|T<rsup|n<rsub|j>+k><rsub|3>|]>|)>>
    are all translationally equivalent and (without loss of generality) all
    <math|n<rsub|i>> are divisible by <math|k>. By passing to a further
    subsequence, we may assume that <math|T<rsup|n<rsub|j>><rsub|i>\<to\><wide|T|\<bar\>><rsub|i>\<in\>\<Omega\><rsub|\<Phi\>>>
    as <math|j\<to\>\<infty\>> for <math|i=1,2,3>. Just as in the proof of
    Proposition <reference|branch points> (the \P<math|\<alpha\>\<less\>0>"
    case) we may conclude that <math|<wide|T|\<bar\>><rsub|2>> is fixed by
    <math|\<Phi\><rsup|k>> and <math|<wide|T|\<bar\>><rsub|2>=T<rsub|2>-w>
    for some <math|w>.
  </proof>

  <no-indent><with|font-shape|italic|Proof of Theorem <reference|topological
  invariance 2>>. Let <math|\<Omega\>=\<Omega\><rsub|\<Phi\>>> and
  <math|\<Omega\><rprime|'>=\<Omega\><rsub|\<Psi\>>>. If <math|\<Omega\>> has
  an isolated branch pair or a corner branch pair, then by Lemma
  <reference|existence of R> such a pair is uniformly asymptotic in a set of
  directions containing a closed hemisphere in its interior and we're done by
  Theorem <reference|topological invariance 1>.

  Let <math|h<rsub|0>:\<Omega\><rsub|\<Phi\>>\<to\>\<Omega\><rsub|\<Psi\>>>
  be a homeomorphism for which there is a linear isomorphism <math|L> of
  <math|<R><rsup|2>> so that <math|h<rsub|0>*<around|(|T-x|)>=h<rsub|0><around|(|T|)>-L*x>
  for all <math|T\<in\>\<Omega\><rsub|\<Phi\>>> and all
  <math|x\<in\><R><rsup|2>> (Theorem 1.1 of <cite|Kwapisz>). Suppose that
  <math|<around|(|T<rsub|1>,T<rsub|2>|)>> and
  <math|<around|(|T<rsub|2>,T<rsub|3>|)>> are line branch pairs for
  <math|\<Phi\>> with <math|\<partial\>*S<around|(|T<rsub|1>,T<rsub|2>|)>\<ne\>\<partial\>*S<around|(|T<rsub|2>,T<rsub|3>|)>>.
  Then there is <math|w\<in\><R><rsup|2>> so that <math|T<rsub|2>-w> is
  <math|\<Phi\>>-periodic by Lemma <reference|triple> (in fact, it's not hard
  to show <math|w=0> in this case). By the \Plinearity" and uniform
  continuity of <math|h<rsub|0>>, there are arcs <math|\<alpha\><rsub|i>> in
  <math|\<bbb-S\><rsup|1>>, slightly smaller than the semi-circles
  <math|<around|{|L*v/<around|\||L*v|\|>:v\<in\>S<around|(|T<rsub|i>,T<rsub|2>|)>|}>>,
  <math|i=1,3> so that <math|\<alpha\><rsub|1>\<cup\>\<alpha\><rsub|3>>
  contains a closed semi-circle in its interior and so that
  <math|h<rsub|0><around|(|T<rsub|i>|)>> and
  <math|h<rsub|0><around|(|T<rsub|2>|)>> are uniformly asymptotic in
  directions <math|\<alpha\><rsub|i>>, <math|i=1,3>. By Lemma
  <reference|triple>, there is <math|w<rprime|'>\<in\><R><rsup|2>> so that
  <math|h<around|(|T<rsub|2>|)>-w<rprime|'>> is <math|\<Psi\>>-periodic. Let
  <math|h<rsub|1>:\<Omega\><rsub|\<Phi\>>\<to\>\<Omega\><rsub|\<Psi\>>> by
  <math|h<rsub|1><around|(|T|)>\<assign\>h<rsub|0>*<around|(|T+w|)>-w<rprime|'>>.
  Then <math|h<rsub|1>> is a homeomorphism that takes a
  <math|\<Phi\>>-periodic orbit to a <math|\<Psi\>>-periodic orbit and by
  Corollary 1.5 of <cite|Kwapisz>, there is a \Plinear" homeomorphism
  <math|h:\<Omega\><rsub|\<Phi\>>\<to\>\<Omega\><rsub|\<Psi\>>> that
  conjugates some powers of <math|\<Phi\>> and <math|\<Psi\>>. It follows
  easily that <math|h<around|(|<with|math-font|cal|B*L><around|(|\<Phi\>|)>|)>=<with|math-font|cal|B*L><around|(|\<Psi\>|)>>
  and <math|h<around|(|<with|math-font|cal|P*B*L><around|(|\<Phi\>|)>|)>=<with|math-font|cal|P*B*L><around|(|\<Psi\>|)>>

  Now suppose that <math|\<Omega\><rsub|\<Phi\>>> is Pisot. We are done if
  <math|\<Omega\><rsub|\<Phi\>>> has an isolated branch pair or a corner
  branch pair. Otherwise, there are are non-collapsing line branch pairs
  <math|<around|(|T<rsub|1>,T<rprime|'><rsub|1>|)>> and
  <math|<around|(|T<rsub|2>,T<rprime|'><rsub|2>|)>> with
  <math|\<partial\>*S<around|(|T<rsub|1>,T<rprime|'><rsub|1>|)>\<ne\>\<partial\>*S<around|(|T<rsub|2>,T<rprime|'><rsub|2>|)>>
  (Theorem <reference|two sectors>). Let <math|\<partial\>*S<around|(|T<rsub|i>,T<rprime|'><rsub|i>|)>={\<pm\>v<rsub|i>}>,
  <math|i=1,2>, and let <math|g:\<Omega\><rsub|\<Phi\>>\<to\><wide|<T>|^><rsub|A>>
  be the map onto the maximal equicontinuous factor of the
  <math|<R><rsup|2>>-action on <math|\<Omega\><rsub|\<Phi\>>>. Note that
  <math|g<around|(|T<rsub|i>|)>=g<around|(|T<rprime|'><rsub|i>|)>>,
  <math|i=1,2>, since <math|T<rsub|i>> and <math|T<rprime|'><rsub|i>> are
  proximal. Then <math|\<cup\><rsub|t\<in\><R>>W<rsup|s>*<around|(|g*<around|(|T<rsub|i>-t*v<rsub|i>|)>|)>=\<cup\><rsub|t\<in\><R>>W<rsup|s>*<around|(|g*<around|(|T<rprime|'><rsub|i>-t*v<rsub|i>|)>|)>>,
  <math|i=1,2>, are co-dimension one affine subspaces of
  <math|<wide|<T>|^><rsub|A>> that aren't parallel (since
  <math|{\<pm\>v<rsub|1>}\<ne\>{\<pm\>v<rsub|2>}>). Thus there are
  <math|t<rsub|1>,t<rsub|2>\<in\><R>> with
  <math|g*<around|(|T<rsub|1>-t<rsub|1>*v<rsub|1>|)>=g*<around|(|T<rprime|'><rsub|1>-t<rsub|1>*v<rsub|1>|)>=g*<around|(|T<rsub|2>-t<rsub|2>*v<rsub|2>|)>=g*<around|(|T<rprime|'><rsub|2>-t<rsub|2>*v<rsub|2>|)>>.
  It is proved in <cite|BKS> that, up to translation, there are only finitely
  many sets of the form <math|<around|{|B<rsub|0><around|[|T<rprime|'>|]>:g<around|(|T<rprime|'>|)>=g<around|(|T|)>|}>>
  for <math|T\<in\>\<Omega\><rsub|\<Phi\>>>. Thus there are
  <math|n,k\<in\><N>> and <math|w\<in\><R><rsup|2>> so that
  <math|<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T<rsub|1>-t<rsub|1>*v<rsub|1>|)>|]>,B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T<rprime|'><rsub|1>-t<rsub|1>*v<rsub|1>|)>|]>,B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T<rsub|2>-t<rsub|2>*v<rsub|2>|)>|]>,B<rsub|0>*<around|[|\<Phi\><rsup|n+k>*<around|(|T<rprime|'><rsub|2>-t<rsub|2>*v<rsub|2>|)>|]>|)>=<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rsub|1>-t<rsub|1>*v<rsub|1>|)>|]>-w,B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rprime|'><rsub|1>-t<rsub|1>*v<rsub|1>|)>|]>-w,B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rsub|2>-t<rsub|2>*v<rsub|2>|)>|]>-w,B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rprime|'><rsub|2>-t<rsub|2>*v<rsub|2>|)>-w|]>|)>>.
  Equality of the first two coordinates of these quadruples implies that
  <math|w> is parallel with <math|v<rsub|1>>, while equality of the last two
  coordinates implies that <math|w> is parallel with <math|v<rsub|2>>. Thus
  <math|w=0> and the branch pairs <math|<around|(|<wide|T|\<bar\>><rsub|1>,<wide|T|\<bar\>><rprime|'><rsub|1>|)>>
  and <math|<around|(|<wide|T|\<bar\>><rsub|2>,<wide|T|\<bar\>><rprime|'><rsub|2>|)>>
  defined by <math|<wide|T|\<bar\>><rsub|i>\<assign\>\<cup\><rsub|m\<ge\>0>\<Phi\><rsup|m*k>*<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rsub|i>-t<rsub|i>*v<rsub|i>|)>|]>|)>,<wide|T|\<bar\>><rprime|'><rsub|i>\<assign\>\<cup\><rsub|m\<ge\>0>\<Phi\><rsup|m*k>*<around|(|B<rsub|0>*<around|[|\<Phi\><rsup|n>*<around|(|T<rprime|'><rsub|i>-t<rsub|i>*v<rsub|i>|)>|]>|)>>
  are <math|\<Phi\>>-periodic and <math|\<partial\>*S<around|(|<wide|T|\<bar\>><rsub|i>,<wide|T|\<bar\>><rprime|'><rsub|i>|)>={\<pm\>v<rsub|i>}>,
  <math|i=1,2>. Moreover, <math|g<around|(|<wide|T|\<bar\>><rsub|1>|)>=g<around|(|<wide|T|\<bar\>><rprime|'><rsub|1>|)>=g<around|(|<wide|T|\<bar\>><rsub|2>|)>=g<around|(|<wide|T|\<bar\>><rprime|'><rsub|2>|)>>
  since <math|g> is continuous, <math|g\<circ\><wide|F|^><rsub|A>=<wide|F|^><rsub|A>\<circ\>g>,
  and <math|<wide|T|\<bar\>><rsub|i>=lim<rsub|m\<to\>\<infty\>>
  \<Phi\><rsup|n+m*k>*<around|(|T<rsub|i>-t<rsub|i>*v<rsub|i>|)>,<wide|T|\<bar\>><rprime|'><rsub|i>=lim<rsub|m\<to\>\<infty\>>
  \<Phi\><rsup|n+m*k>*<around|(|T<rprime|'><rsub|i>-t<rsub|i>*v<rsub|i>|)>>,
  <math|i=1,2>. Note that <math|<wide|T|\<bar\>><rsub|i>\<ne\><wide|T|\<bar\>><rprime|'><rsub|i>>,
  <math|i=1,2>, by the non-collapsing condition satisfied by
  <math|<around|(|T<rsub|i>,T<rprime|'><rsub|i>|)>>, <math|i=1,2>.

  Now <math|\<Omega\><rsub|\<Psi\>>> must also be Pisot. (For example, the
  linear nature of <math|h<rsub|0>> guarantees that if <math|\<phi\>> is an
  eigenfuntion of the <math|<R><rsup|2>>-action on
  <math|\<Omega\><rsub|\<Phi\>>>, then <math|\<phi\>\<circ\>h<rsub|0><rsup|-1>>
  is an eigenfunction of the <math|<R><rsup|2>>-action on
  <math|\<Omega\><rsub|\<Psi\>>>, and these <math|<R><rsup|2>>-actions have
  nontrivial eigenfunctions if and only if the inflations are Pisot,
  <cite|Sol>.) Also, the linearity of <math|h<rsub|0>> insures that
  <math|h<rsub|0>> preserves proximality. In particular,
  <math|g<around|(|S<rsub|1>|)>=g<around|(|S<rprime|'><rsub|1>|)>=g<around|(|S<rsub|2>|)>=g<around|(|S<rprime|'><rsub|2>|)>>
  , where <math|g> now denotes the map onto the maximal equi-continuous
  factor of the <math|<R><rsup|2>> action on <math|\<Omega\><rsub|\<Psi\>>>
  and <math|S<rsub|i>\<assign\>h<rsub|0><around|(|<wide|T|\<bar\>><rsub|i>|)>,S<rprime|'><rsub|i>\<assign\>h<rsub|0><around|(|<wide|T|\<bar\>><rprime|'><rsub|i>|)>>,
  <math|i=1,2>. Let <math|u<rsub|1>\<in\>S<around|(|<wide|T|\<bar\>><rsub|1>,<wide|T|\<bar\>><rprime|'><rsub|1>|)>>
  satisfy <math|<around|\<langle\>|u<rsub|1>,v<rsub|1>|\<rangle\>>=0>. Then
  for each <math|\<delta\>\<gtr\>0> there is <math|R=R<around|(|\<delta\>|)>>
  so that if <math|t\<gtr\>R> then <math|d*<around|(|<wide|T|\<bar\>><rsub|1>-s*v<rsub|1>-t*u<rsub|1>,<wide|T|\<bar\>><rprime|'><rsub|1>-s*v<rsub|1>-t*u<rsub|1>|)>\<less\>\<delta\>>
  for all <math|s\<in\><R>> (Lemma <reference|existence of R>). Let
  <math|\<epsilon\>\<gtr\>0> be small enough so that if
  <math|S,S<rprime|'>\<in\>\<Omega\><rsub|\<Psi\>>> and
  <math|w\<in\><R><rsup|2>> are such that
  <math|d*<around|(|S-t*w,S<rprime|'>-t*w|)>\<less\>\<epsilon\>> for all
  <math|t\<gtr\>0> and <math|lim<rsub|t\<to\>\<infty\>>
  d*<around|(|S-t*w,S<rprime|'>-t*w|)>=0>, then
  <math|B<rsub|0>*<around|[|S-t*w|]>=B<rsub|0>*<around|[|S<rprime|'>-t*w|]>>
  for all <math|t\<gtr\>0> (see the proof of Lemma <reference|asymptotic
  direction>). Now if <math|\<delta\>\<gtr\>0> is chosen so that
  <math|d<around|(|T,T<rprime|'>|)>\<less\>\<delta\>\<Rightarrow\>d<around|(|h<rsub|0><around|(|T|)>,h<rsub|0><around|(|T<rprime|'>|)>|)>\<less\>\<epsilon\>>,
  then, for <math|t\<gtr\>R<around|(|\<delta\>|)>>,
  <math|B<rsub|0>*<around|[|S<rsub|1>-s*L*v<rsub|1>-t*L*u<rsub|1>|]>=B<rsub|0>*<around|[|S<rprime|'><rsub|1>-s*L*v<rsub|1>-t*L*u<rsub|1>|]>>
  for all <math|s\<in\><R>>. Similarly for
  <math|S<rsub|2>,S<rprime|'><rsub|2>>. Thus there is
  <math|w\<in\><R><rsup|2>> so that <math|S<rsub|i>-w> and
  <math|S<rprime|'><rsub|i>-w> agree on one of the components of
  <math|<R><rsup|2>\<setminus\><around|{|t*L*v<rsub|i>:t\<in\><R>|}>>,
  <math|i=1,2>. For <math|n\<in\><N>\<cup\><around|{|0|}>>, let
  <math|S<rsub|n,i>\<assign\>\<Psi\><rsup|-n>*<around|(|S<rsub|i>-w|)>> and
  <math|S<rprime|'><rsub|n,i>\<assign\>\<Psi\><rsup|-n>*<around|(|S<rsub|i>-w|)>>,
  <math|i=1,2>. Using the fact that there are only finitely many quadruples
  <math|<around|(|S<rsub|n,1>,S<rprime|'><rsub|n,1>,S<rsub|n,2>,S<rprime|'><rsub|n,2>|)>>,
  up to translation (for any <math|n> the entries in the quadruple have the
  same image under <math|g>), and using that <math|L*v<rsub|1>> is not
  parallel with <math|L*v<rsub|2>> and <math|S<rsub|1>\<ne\>S<rprime|'><rsub|1>,S<rsub|2>\<ne\>S<rprime|'><rsub|2>>,
  we see, exactly as in the proof of Proposition <reference|branch points>,
  that there is <math|w<rprime|'>\<in\><R><rsup|2>> so that
  <math|S<rsub|0,i>-w<rprime|'>> and <math|S<rprime|'><rsub|0,i>-w<rprime|'>>,
  <math|i=1,2>, are <math|\<Psi\>>-periodic. Let
  <math|h<rsub|1>:\<Omega\><rsub|\<Phi\>>\<to\>\<Omega\><rsub|\<Psi\>>> be
  given by <math|h<rsub|1><around|(|T|)>\<assign\>h<rsub|0><around|(|T|)>-<around|(|w+w<rprime|'>|)>>.
  Then <math|h<rsub|1>> is a homeomorphism that takes a
  <math|\<Phi\>>-periodic orbit to a <math|\<Psi\>>-periodic orbit. Corollary
  1.5 of <cite|Kwapisz> supplies the desired
  <math|h:\<Omega\><rsub|\<Phi\>>\<to\>\<Omega\><rsub|\<Psi\>>>, as above.
  <space|stretch><math|\<square\>>

  <\thebibliography|99>
    <bibitem-with-key|A|Aus> J. Auslander, Minimal flows and their
    extensions, <with|font-shape|italic|North-Holland Mathematical Studies>,
    vol. 153, North-Holland, Amsterdam, New York, Oxford, and Tokyo, (1988).

    <bibitem-with-key|AP|AP> J.E. Anderson and I.F. Putnam, Topological
    invariants for substitution tilings and their associated
    <math|C<rsup|\<ast\>>>-algebras, <with|font-shape|italic|Ergodic Theory &
    Dynamical Systems> <with|font-series|bold|18> (1998), 509\U537.

    <bibitem-with-key|BBK|BBK> V. Baker, M. Barge and J. Kwapisz, Geometric
    realization and coincidence for reducible non-unimodular Pisot tiling
    spaces with an application to <math|\<beta\>>-shifts,
    <with|font-shape|italic|J. Instit. Fourier.> <with|font-series|bold|56>
    (7) (2006), 2213-2248.

    <bibitem-with-key|BD|BD1> M. Barge and B. Diamond, A complete invariant
    for the topology of one-demensional substitution tiling spaces,
    <with|font-shape|italic|Ergod. Th. and Dynam.
    Sys.>,<with|font-series|bold|21> (2001), 1333-1358.

    <bibitem-with-key|BD2|bargediamond2> M. Barge and B. Diamond, Proximality
    In Pisot tiling spaces, <em|Fund. Math.>, 194 (2007), 191-238.

    <bibitem-with-key|BDH|BDH> M. Barge, B. Diamond and C. Holton, Asymptotic
    orbits of primitive substitutions, <with|font-shape|italic|Theoretical
    Computer Science>, <with|font-series|bold|301>(2003), 439-450.

    <bibitem-with-key|BDHS|BDHS> Cohomology of substitution tiling spaces,
    2010 preprint.

    <bibitem-with-key|BDS|BDS> M. Barge, B. Diamond and R. Swanson, The
    branch locus in one-dimensional substitution tiling spaces,
    <with|font-shape|italic|Fund. Math.>,<with|font-series|bold|204>(2009),
    215-240.

    <bibitem-with-key|BK|BK> M. Barge and J. Kwapisz, Geometric theory of
    unimodular Pisot substitutions, <with|font-shape|italic|Amer J. Math.>
    <with|font-series|bold|128> (2006), 1219-1282.

    <bibitem-with-key|BKS|BKS> M. Barge, J. Kellendonk and S. Shmieding,
    Maximal equicontinuous factors for Pisot family tiling spaces, 2011
    preprint.

    <bibitem-with-key|BL|BL> M. Boyle and D. Lind, Expansive subdynamics,
    <with|font-shape|italic|Trans. Amer. Math. Soc.>
    <with|font-series|bold|349>, no. 1, (1997), 55-102.

    <bibitem-with-key|BS|BS> M. Barge and R. Swanson, Rigidity in
    one-dimensional tiling spaces, <with|font-shape|italic|Top. and Its
    Appl.>,<with|font-series|bold|154>(17) (2007), 3095-3099.

    <bibitem-with-key|CS|CS> V. Canterini and A. Siegel, Geometric
    representation of substitutions of Pisot type,

    <\with|font-shape|italic>
      Trans. Amer.

      Math. Soc.
    </with>

    \ <with|font-series|bold|353> (2001), 5121-5144.

    <bibitem-with-key|FHK|FHK> A. Forrest, J. Hunton and J. Kellendonk,
    Topological invariants for projection method patterns, with A.H. Forrest
    and J.R. Hunton, <with|font-shape|italic|Memoirs of the AMS>,
    <with|font-series|bold|159>(758), (2002).

    <bibitem-with-key|G-S|G-S> C. Goodman-Strauss, Matching Rules and
    Substitution Tilings, <with|font-shape|italic|Annals of Math.>, Second
    Series, Vol. 147, No. 1 (Jan., 1998), pp. 181-223.

    <bibitem-with-key|KS|KS> R. Kenyon and B. Solomyak, On the
    characterization of expansion maps for self-affine tilings,
    <with|font-shape|italic|Discrete Comp. Geom.> Online, 2009.

    <bibitem-with-key|K|Kwapisz> J. Kwapisz, Rigidity and mapping class group
    for abstract tiling spaces, 2010 preprint.

    <bibitem-with-key|LS|LS> J.-Y. Lee and B. Solomyak, Pisot family
    self-affine tilings, discrete spectrum, and the Meyer property, 2010
    preprint.

    <bibitem-with-key|M|M> S. Mozes, Tilings, substitution systems and
    dynamical systems generated by them, <with|font-shape|italic|J. Analyse
    Math.> <with|font-series|bold|53>(1989), 139-186.

    <bibitem-with-key|O|O> C. Olimb, The branch locus for two dimensional
    substitution tiling spaces, Ph.D. Thesis, Montana State University (2010)

    <bibitem-with-key|Sa|Sa> L. Sadun, Topology of tiling spaces,
    <with|font-shape|italic|American Mathematical Society>, 2008.

    <bibitem-with-key|So1|Solo>Dynamics of self-similar tilings,
    <with|font-shape|italic|Ergod. Thy. and Dynam. Sys.>
    <with|font-series|bold|17> (1997), 695-738.

    <bibitem-with-key|So2|sol> B. Solomyak, Nonperiodicity implies unique
    composition for self-similar translationally finite tilings,
    <with|font-shape|italic|Discrete Comput. Geometry>
    <with|font-series|bold|20> (1998), 265\U279.

    <bibitem-with-key|So3|Sol> B. Solomyak, Eigenfunctions for substitution
    tiling systems,<em|Advanced Studies in Pure Mathematics>,
    <with|font-series|bold|49> (2007), 433\U454.

    <bibitem-with-key|W|W> R. F. Williams, Classification of 1-dimensional
    attractors, <with|font-shape|italic|Proc. Symp. Pure Math.>
    <with|font-series|bold|14>(1970), 341-361.
  </thebibliography>

  <Small|par-first=0pt Department of Mathematics, Montana State University,
  Bozeman, MT 59717, USA<next-line>barge@math.montana.edu<next-line><phantom|asdf><next-line>Department
  of Mathematics, Southwest Minnesota State University, Marshall, MN 56258,
  USA<next-line>Carl.Olimb@smsu.edu >
</body>