<TeXmacs|1.99.7>

<style|<tuple|llncs|std-latex>>

<\body>
  <\hide-preamble>
    <assign|set|<macro|1|{ <arg|1> }>>

    <assign|seq|<macro|1|\<langle\><arg|1> \<rangle\>>>

    <assign|Sig|<macro|1|\<Sigma\><rsub|<arg|1>>>>

    <assign|Sigstar|<macro|\<Sigma\><rsup|*>>>

    <assign|fin|<macro|<math-ss|UniCloOmg>>>

    <assign|PSPACE|<macro|<math-up|PSPACE>>>

    <assign|NPSPACE|<macro|<math-up|NPSPACE>>>

    <assign|NLOGSPACE|<macro|<math-up|NLOGSPACE>>>

    <assign|distword|<macro|<math-up|distword>>>

    <assign|A|<macro|\<cal-A\>>>

    <assign|B|<macro|\<cal-B\>>>

    <assign|C|<macro|\<cal-C\>>>

    <assign|F|<macro|\<cal-F\>>>

    <assign|La|<macro|\<cal-L\>>>

    <assign|LA|<macro|<with|math-font|cal|L(A)>>>

    <assign|LB|<macro|<with|math-font|cal|L(B)>>>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|infi|<macro|<math-up|Inf>>>

    <assign|So|<macro|\<Sigma\><rsup|\<omega\>>>>

    <assign|streett|<macro|<math-up|Streett>(R,G)>>

    <assign|distk|<macro|<math-up|dist><rsub|k>>>

    <assign|nextk|<macro|<math-up|next><rsub|k>>>

    <assign|omegareg|<macro|\<bbb-L\><rsub|\<omega\>>>>

    <assign|finp|<macro|<math-up|FinParity>(p)>>

    <assign|fstreettrg|<macro|<math-up|FinStreett>(R,G)>>

    <assign|fbucf|<macro|<with|math-font-family|rm|FinB<wide|u|\<ddot\>>chi>(F)>>

    <assign|parp|<macro|<math-up|Parity>(p)>>

    <assign|parity|<macro|<math-up|Parity>>>

    <assign|bucf|<macro|<with|math-font-family|rm|B<wide|u|\<ddot\>>chi>(F)>>

    <assign|pref|<macro|1|<math-up|pref>(<arg|1>)>>

    <assign|MSOL|<macro|<math-up|MSOL>>>

    <assign|Final|<macro|<math-up|Final>>>

    <assign|DB|<macro|<math-it|DB>>>

    <assign|DP|<macro|<math-it|DP>>>

    <assign|DS|<macro|<math-it|DS>>>

    <assign|DFB|<macro|<math-it|DFB>>>

    <assign|DFP|<macro|<math-it|DFP>>>

    <assign|DFS|<macro|<math-it|DFS>>>

    <assign|NB|<macro|<math-it|NB>>>

    <assign|NP|<macro|<math-it|NP>>>

    <assign|NS|<macro|<math-it|NS>>>

    <assign|NFB|<macro|<math-it|NFB>>>

    <assign|NFP|<macro|<math-it|NFP>>>

    <assign|NFS|<macro|<math-it|NFS>>>

    <assign|Acc|<macro|<math-it|Acc>>>

    <new-theorem|notation|Notation>

    <assign|mynote|<macro|1|<with|font-family|ss|<math|\<clubsuit\>> <arg|1>
    <math|\<clubsuit\>>>>>

    <assign|qed|<macro|<rule|0.4em|1.4ex>>>
  </hide-preamble>

  <doc-data|<doc-title|Finitary Languages>|<doc-author|<author-data|<author-inst|1>|<author-name|Krishnendu
  Chatterjee>|<author-email|krishnendu.chatterjee@ist.ac.at>|<author-affiliation|IST
  Austria (Institute of Science and Technology,
  Austria)>>>|<doc-author|<author-data|<author-inst|1,2>|<author-name|Nathanal
  Fijalkow>|<author-email|krishnendu.chatterjee@ist.ac.at>|<author-affiliation|IST
  Austria (Institute of Science and Technology, Austria)>>>>

  <input|intro>

  <section|Definitions>

  <subsection|Languages topological complexity>

  Let <math|\<Sigma\>> be a finite set, called the alphabet. A word <math|w>
  is a sequence of letters, which can be either finite or infinite. A
  language is a set of words: <math|L\<subseteq\><Sigstar>> is a language
  over finite words and <math|L\<subseteq\><So>> over infinite words.

  <vspace|0.5fn><no-indent><with|font-series|bold|Cantor topology and Borel
  hierarchy.> Cantor topology on <math|<So>> is given by <em|open> sets: a
  language is open if it can be described as <math|W\<cdot\><So>> where
  <math|W\<subseteq\><Sigstar>>. Let <math|<Sig|1>> denote the open sets and
  <math|\<Pi\><rsub|1>> denote the closed sets (a language is closed if its
  complement is open): they form the first level of the Borel hierarchy.
  Inductively, we define: <math|<Sig|i+1>> is obtained as countable union of
  <math|\<Pi\><rsub|i>> sets; and <math|\<Pi\><rsub|i+1>> is obtained as
  countable intersection of <math|<Sig|i>> sets. The higher a language is in
  the Borel hierarchy, the higher its topological complexity.

  Since the above classes are closed under continuous preimage, we can define
  the notion of Wadge reduction<nbsp><cite|Wadge-Thesis>: <math|L> reduces to
  <math|L<rprime|'>>, denoted by <math|L\<preceq\>L<rprime|'>>, if there
  exists a continuous function <math|f:<So>\<rightarrow\><So>> such
  <math|L=f<rsup|-><around|(|L<rprime|'>|)>>, where
  <math|f<rsup|-><around|(|L<rprime|'>|)>> is the preimage of
  <math|L<rprime|'>> by <math|f>. A language is hard with respect to a class
  if all languages of this class reduce to it. If it additionally belongs to
  this class, then it is complete.

  For <math|L\<subseteq\><So>>, let <math|<pref|L>\<subseteq\><Sigstar>> be
  the set of finite prefixes of words in <math|L>. The following property
  holds:

  <\proposition>
    For all languages <math|L\<subseteq\><So>>, <math|L> is closed if and
    only if, for all infinite words <math|w>, if all finite prefixes of
    <math|w> are in <math|<pref|L>>, then <math|w\<in\>L>.
  </proposition>

  <vspace|0.5fn>

  <no-indent><with|font-series|bold|Classical liveness conditions.> We now
  consider three classes of languages that are widespread in verification and
  specification. They define liveness properties,
  <with|font-shape|italic|i.e>, intuitively say that something good will
  happen \Peventually\Q. For an infinite word <math|w>, let
  <math|<infi><around|(|w|)>\<subseteq\>\<Sigma\>> denote the set of letters
  that appear infinitely often in <math|w>. The class of Bchi languages is
  defined as follows, given <math|F\<subseteq\>\<Sigma\>>:

  <\equation*>
    <bucf>=
  </equation*>

  <with|font-shape|italic|i.e>, the Bchi condition requires that some letter
  in <math|F> appears infinitely often. The class of parity languages is
  defined as follows, given <math|p:\<Sigma\>\<rightarrow\><N>> a priority
  function that maps letters to integers (representing priorities):

  <\equation*>
    <parp>=
  </equation*>

  <with|font-shape|italic|i.e>, the parity condition requires that the lowest
  priority the appears infinitely often is even. The class of Streett
  languages is defined as follows, given <math|<around|(|R,G|)>=<around|(|R<rsub|i>,G<rsub|i>|)><rsub|1\<leq\>i\<leq\>d>>,
  where <math|R<rsub|i>,G<rsub|i>\<subseteq\>\<Sigma\>> are request-grant
  pairs:

  <\equation*>
    <streett>=
  </equation*>

  <with|font-shape|italic|i.e>, the Streett condition requires that for all
  requests <math|R<rsub|i>>, if it appears infinitely often, then the
  corresponding grant <math|G<rsub|i>> also appears infinitely often.

  The following theorem presents the topological complexity of the classical
  languages:

  <\theorem>
    <dueto|Topological complexity of classical
    languages<nbsp><cite|MP92>><label|thrm>

    <\itemize>
      <vspace|-2.5mm>

      <item>For all <math|\<emptyset\>\<subset\>F\<subset\>\<Sigma\>>, the
      language <math|<bucf>> is <math|\<Pi\><rsub|2>>-complete.

      <item>The parity and Streett languages lie in the boolean closure of
      <math|<Sig|2>> and <math|\<Pi\><rsub|2>>.
    </itemize>
  </theorem>

  <subsection|Finitary languages>

  The finitary parity and Streett languages have been defined
  in<nbsp><cite|CHH09-ToCL>. We recall their definitions, and also specialize
  them to finitary Bchi languages. Let <math|<around|(|R,G|)>=<around|(|R<rsub|i>,G<rsub|i>|)><rsub|1\<leq\>i\<leq\>d>>,
  where <math|R<rsub|i>,G<rsub|i>\<subseteq\>\<Sigma\>>, the definition for
  <math|<fstreettrg>> uses distance sequence as follows:

  <\equation*>
    <distk><rsup|j><around|(|w,<around|(|R,G|)>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|w<rsub|k>\<nin\>R<rsub|j>>>|<row|<cell|inf
    <around|{|k<rprime|'>-k\<mid\>k<rprime|'>\<geq\>k,w<rsub|k<rprime|'>>\<in\>G<rsub|j>|}>>|<cell|w<rsub|k>\<in\>R<rsub|j>>>>>>
  </equation*>

  <with|font-shape|italic|i.e>, given a position <math|k> where
  <math|R<rsub|j>> is requested, <math|<distk><rsup|j><around|(|w,<around|(|R,G|)>|)>>
  is the time steps (number of transitions) between the request
  <math|R<rsub|j>> and the corresponding grant <math|G<rsub|j>>. Note that
  <math|inf <around|(|\<emptyset\>|)>=\<infty\>>. Then
  <math|<distk><around|(|w,<around|(|R,G|)>|)>=max> and:

  <\equation*>
    <fstreettrg>=
  </equation*>

  <with|font-shape|italic|i.e>, the finitary Streett condition requires the
  supremum limit of the distance sequence to be bounded.

  Since parity languages can be considered as a particular case of Streett
  languages, where <math|G<rsub|1>\<subseteq\>R<rsub|1>\<subseteq\>G<rsub|2>\<subseteq\>R<rsub|2>*\<ldots\>>,
  the latter allows to define <math|<finp>>. The same applies to finitary
  Bchi languages, which is a particular case of finitary parity languages
  where the letters from the set <math|F> have priority <math|0> and others
  have priority <math|1>. We get the following definitions. Let
  <math|p:\<Sigma\>\<rightarrow\><N>> a priority function, we define:

  <\equation*>
    <distk><around|(|w,p|)>=inf
  </equation*>

  <with|font-shape|italic|i.e>, given a position <math|k> where
  <math|p<around|(|w<rsub|k>|)>> is odd, <math|<distk><around|(|w,p|)>> is
  the time steps between the odd priority <math|p<around|(|w<rsub|k>|)>> and
  a lower even priority. Then <math|<finp>=>. We define similarly the
  finitary Bchi language: given <math|F\<subseteq\>\<Sigma\>>, let:

  <\equation*>
    <nextk><around|(|w,F|)>=inf <around|{|k<rprime|'>-k\<mid\>k<rprime|'>\<geq\>k,w<rsub|k<rprime|'>>\<in\>F|}>
  </equation*>

  <with|font-shape|italic|i.e>, <math|<nextk><around|(|w,F|)>> is the time
  steps before visiting a letter in <math|F>. Then <math|<fbucf>=>.

  <subsection|Automata, <math|\<omega\>>-regular and finitary languages>

  <\definition>
    An automaton is a tuple <math|<A>=<around|(|Q,\<Sigma\>,Q<rsub|0>,\<delta\>,<Acc>|)>>,
    where <math|Q> is a finite set of states, <math|\<Sigma\>> is the finite
    input alphabet, <math|Q<rsub|0>\<subseteq\>Q> is the set of initial
    states, <math|\<delta\>\<subseteq\>Q\<times\>\<Sigma\>\<times\>Q> is the
    transition relation and <math|<Acc>\<subseteq\>Q<rsup|\<omega\>>> is the
    acceptance condition.
  </definition>

  An automaton is deterministic if it has a single initial state and for
  every state and letter there is at most one transition. The transition
  relation of deterministic automata are described by functions
  <math|\<delta\>:Q\<times\>\<Sigma\>\<rightarrow\>Q>. An automaton is
  complete if for every state and letter there is a transition. This is the
  case when the transition function is <em|total>.

  <vspace|1fn><no-indent><with|font-series|bold|Runs.> A run
  <math|\<rho\>=q<rsub|0>*q<rsub|1>*\<ldots\>> is a word over <math|Q>, where
  <math|q<rsub|0>\<in\>Q<rsub|0>>. The run <math|\<rho\>> is accepting if it
  is infinite and <math|\<rho\>\<in\><Acc>>. We will write
  <math|p<long-arrow|\<rubber-rightarrow\>|a>q> to denote
  <math|<around|(|p,a,q|)>\<in\>\<delta\>>. An infinite word
  <math|w=w<rsub|0>*w<rsub|1>*\<ldots\>> induces possibly several runs of
  <math|<A>>: a word <math|w> induces a run
  <math|\<rho\>=q<rsub|0>*q<rsub|1>*\<ldots\>> if for all
  <math|n\<in\><N>,q<rsub|n><long-arrow|\<rubber-rightarrow\>|w<rsub|n>>q<rsub|n+1>*\<ldots\>>.
  The language accepted by <math|<A>>, denoted by
  <math|<LA>\<subseteq\>\<Sigma\><rsup|\<omega\>>>, is:

  <\equation*>
    <LA>=.
  </equation*>

  <vspace|1fn><no-indent><with|font-series|bold|Acceptance conditions.> We
  will consider various acceptance conditions for automata obtained from the
  last section by considering <math|Q> as the alphabet. For example, given
  <math|F\<subseteq\>Q>, the languages <math|<bucf>> and <math|<fbucf>>
  define Bchi and finitary Bchi acceptance conditions, respectively.
  Automata with finitary acceptance conditions are referred as finitary
  automata; classical automata are those equipped with infinitary acceptance
  conditions.

  <\notation>
    We use a standard notation to denote the set of languages recognized by
    some class of automata. The first letter is either <math|N> or <math|D>,
    where <math|N> stands for \Pnon-deterministic\Q and <math|D> stands for
    \Pdeterministic\Q. The last letter refers to the acceptance condition:
    <math|B> stands for \PBchi\Q, <math|P> stands for \Pparity\Q and
    <math|S> stands for \PStreett\Q. The acceptance condition may be prefixed
    by <math|F> for \Pfinitary\Q. For example, <math|<NP>> denotes
    non-deterministic parity automata, and <math|<DFS>> denotes deterministic
    finitary Streett automata. We have the following combination:

    <\equation*>
      <around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|N>>|<row|<cell|D>>>>>|}>\<cdot\><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|F>>|<row|<cell|\<varepsilon\>>>>>>|}>\<cdot\><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|B>>|<row|<cell|P>>|<row|<cell|S>>>>>|}>
    </equation*>
  </notation>

  <no-indent>We denote by <math|<omegareg>> the class of languages accepted
  by deterministic parity automata. The following theorem summarizes the
  results of expressive power of classical
  automata<nbsp><cite|Buc62-CLMPS|Sa92-STOC|Cho74-JCSS|GH82-STOC>:

  <\theorem>
    <dueto|Expressive power results for classical automata><label|classical>

    <\equation*>
      <DB>\<subset\><omegareg>\<doteq\><NB>=<DP>=<NP>=<DS>=<NS>
    </equation*>
  </theorem>

  <section|Topological complexity>

  In this section we define a finitary operator <math|<fin>> that allows us
  to describe finitary Bchi, finitary parity and finitary Streett languages
  topologically and to relate them to the classical Bchi, parity and Streett
  languages; we then give their topological complexity.

  <vspace|1fn><no-indent><with|font-series|bold|Union-closed-omega-regular
  operator on languages.> Given a language <math|L\<subseteq\><So>>, the
  language <math|<fin><around|(|L|)>\<subseteq\><So>> is the <em|union> of
  the languages <math|M> that are subsets of <math|L>,
  <em|<math|\<omega\>>-regular> and <em|closed>,
  <with|font-shape|italic|i.e>, <math|<fin><around|(|L|)>=<big|cup>>.

  <\proposition>
    <label|fin>For all languages <math|L\<subseteq\><So>> we have
    <math|<fin><around|(|L|)>\<in\><Sig|2>>.
  </proposition>

  <\proof>
    Since the set of finite automata can be enumerated in sequence, it
    follows that <math|<omegareg>> is countable. So for all languages
    <math|L>, the set <math|<fin><around|(|L|)>> is described as a countable
    union of closed sets. Hence <math|<fin><around|(|L|)>\<in\><Sig|2>>.
    <htab|0pt><qed>
  </proof>

  We present a <em|pumping lemma> for <math|\<omega\>>-regular languages that
  we will use to prove the topological complexity of finitary languages.

  <\lemma>
    <dueto|A pumping lemma><label|lemm>Let <math|M> be an
    <math|\<omega\>>-regular language. There exists <math|n<rsub|0>> such
    that for all words <math|w\<in\>M>, for all positions
    <math|j\<geq\>n<rsub|0>>, there exist
    <math|j\<leq\>i<rsub|1>\<less\>i<rsub|2>\<leq\>j+n<rsub|0>> such that for
    all <math|\<ell\>\<geq\>0> we have <math|w<rsub|0>*w<rsub|1>*w<rsub|2>*\<ldots\>*w<rsub|i<rsub|1>-1>\<cdot\><around|(|w<rsub|i<rsub|1>>*w<rsub|i<rsub|1>+1>*\<ldots\>*w<rsub|i<rsub|2>-1>|)><rsup|\<ell\>>\<cdot\>w<rsub|i<rsub|2>>*w<rsub|i<rsub|2>+1>*\<ldots\>\<in\>M>.
  </lemma>

  <\proof>
    Given <math|M> is a <math|\<omega\>>-regular language, let <math|<A>> be
    a complete and deterministic parity automata that recognizes <math|M>,
    and let <math|n<rsub|0>> be the number of states of <math|<A>>. Consider
    a word <math|w=w<rsub|0>*w<rsub|1>*w<rsub|2>*\<ldots\>> such that
    <math|w\<in\>M>, and let <math|\<rho\>=q<rsub|0>*q<rsub|1>*q<rsub|2>*\<ldots\>>
    be the unique run induced by <math|w> in <math|<A>>. Consider a position
    <math|j> in <math|w> such that <math|j\<geq\>n<rsub|0>>. Then there exist
    <math|j\<leq\>i<rsub|1>\<less\>i<rsub|2>\<leq\>j+n<rsub|0>> such that
    <math|q<rsub|i<rsub|1>>=q<rsub|i<rsub|2>>>, this must happen as
    <math|<A>> has <math|n<rsub|0>> states. For <math|\<ell\>\<geq\>0>, if we
    consider the word <math|w<rsup|\<ell\>>=w<rsub|0>*w<rsub|1>*w<rsub|2>*\<ldots\>*w<rsub|i<rsub|1>-1>\<cdot\><around|(|w<rsub|i<rsub|1>>*w<rsub|i<rsub|1>+1>*\<ldots\>*w<rsub|i<rsub|2>-1>|)><rsup|\<ell\>>\<cdot\>w<rsub|i<rsub|2>>*w<rsub|i<rsub|2>+1>*\<ldots\>>,
    then the unique run induced by <math|w<rsup|\<ell\>>> in <math|<A>> is
    <math|\<rho\><rsup|\<ell\>>=q<rsub|0>*q<rsub|1>*q<rsub|2>*\<ldots\>*q<rsub|i<rsub|1>-1>\<cdot\><around|(|q<rsub|i<rsub|1>>*q<rsub|i<rsub|1>+1>*\<ldots\>*q<rsub|i<rsub|2>-1>|)><rsup|\<ell\>>\<cdot\>q<rsub|i<rsub|2>>*q<rsub|i<rsub|2>+1>*\<ldots\>>.
    Since the parity condition is independent of finite prefixes and the run
    <math|\<rho\>> is accepted by <math|<A>>, it follows that
    <math|\<rho\><rsup|\<ell\>>> is accepted by <math|<A>>. Since <math|<A>>
    recognizes <math|M>, we have <math|w<rsup|\<ell\>>\<in\>M>.
    <htab|0pt><qed>
  </proof>

  The following lemma shows that <math|<fstreettrg>> is obtained by applying
  the <math|<fin>> operator to <math|<streett>>.

  <\lemma>
    <label|fins>For all <math|<around|(|R,G|)>=<around|(|R<rsub|i>,G<rsub|i>|)><rsub|1\<leq\>i\<leq\>d>>,
    where <math|R<rsub|i>,G<rsub|i>\<subseteq\>\<Sigma\>>, we have

    <\equation*>
      <fin><around|(|<streett>|)>=<fstreettrg>.
    </equation*>
  </lemma>

  <\proof>
    We present the two directions of the proof.

    <\enumerate>
      <item>We first show that <math|<fin><around|(|<streett>|)>\<subseteq\><fstreettrg>>.
      Let <math|M\<subseteq\><streett>> such that <math|M> is closed and
      <math|\<omega\>>-regular. Let <math|w=w<rsub|0>*w<rsub|1>*\<ldots\>\<in\>M>,
      and assume towards contradiction, that
      <math|limsup<rsub|k><distk><around|(|w,<around|(|R,G|)>|)>=\<infty\>>.
      Hence for all <math|n<rsub|0>\<in\><N>>, there exists <math|n\<in\><N>>
      such that <math|n\<geq\>n<rsub|0>> and
      <math|<math-up|dist><rsub|n><around|(|w,<around|(|R,G|)>|)>\<geq\>n<rsub|0>>.
      Let <math|n<rsub|0>\<in\><N>> given by the pumping lemma on <math|M>,
      from above given <math|n<rsub|0>> we obtain <math|j> such that
      <math|j\<geq\>n<rsub|0>> and <math|<math-up|dist><rsub|j><around|(|w,<around|(|R,G|)>|)>\<geq\>n<rsub|0>>.
      By the pumping lemma we obtain the witness
      <math|j\<leq\>i<rsub|1>\<less\>i<rsub|2>\<leq\>j+n<rsub|0>>. Let
      <math|u=w<rsub|0>*w<rsub|1>*\<ldots\>*w<rsub|i<rsub|1>-1>>,
      <math|v=w<rsub|i<rsub|1>>*w<rsub|i<rsub|1>+1>*\<ldots\>*w<rsub|i<rsub|2>-1>>
      and <math|w<rprime|'>=w<rsub|i<rsub|2>>*w<rsub|i<rsub|2>+1>*\<ldots\>>.
      Since <math|w\<in\>M>, by the pumping lemma for all
      <math|\<ell\>\<geq\>0> we have <math|u*v<rsup|\<ell\>>*w<rprime|'>\<in\>M>.
      This entails that all finite prefixes of the infinite word
      <math|u*v<rsup|\<omega\>>> are in <math|<pref|M>>. Since <math|M> is
      closed, it follows that <math|u*v<rsup|\<omega\>>\<in\>M>. Since
      <math|<math-up|dist><rsub|j><around|(|w,<around|(|R,G|)>|)>\<geq\>n<rsub|0>>
      it follows that there is some request <math|i> in position <math|j>,
      and there is no corresponding grant <math|i> for the next
      <math|n<rsub|0>> steps. Hence there is a position <math|j<rprime|'>> in
      <math|v> such that there is request <math|i> at <math|j<rprime|'>> and
      no corresponding grant in <math|v>, and thus it follows that the word
      <math|u*v<rsup|\<omega\>>\<nin\><streett>>. This contradicts that
      <math|M\<subseteq\><streett>>. Hence it follows that
      <math|<fin><around|(|<streett>|)>\<subseteq\><fstreettrg>>.

      <item>We now show the converse: <math|<fin><around|(|<streett>|)>\<supseteq\><fstreettrg>>.
      We have:

      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<fstreettrg>>|<cell|=>|<cell|<around|{|w\<mid\>limsup<rsub|k><distk><around|(|w,<around|(|R,G|)>|)>\<less\>\<infty\>|}>>>|<row|<cell|>|<cell|=>|<cell|<big|cup><rsub|B\<in\><N>><around|{|w\<mid\>limsup<rsub|k><distk><around|(|w,<around|(|R,G|)>|)>\<leq\>B|}>>>|<row|<cell|>|<cell|=>|<cell|<big|cup><rsub|B\<in\><N>><big|cup><rsub|n\<in\><N>><around|{|w\<mid\>\<forall\>k\<geq\>n,<distk><around|(|w,<around|(|R,G|)>|)>\<leq\>B|}>>>>>>
      </equation*>

      The language <math|<around|{|w\<mid\>\<forall\>k\<geq\>n,<distk><around|(|w,<around|(|R,G|)>|)>\<leq\>B|}>>
      is closed, <math|\<omega\>>-regular, and included in <math|<streett>>.
      Hence <math|<fstreettrg>\<subseteq\><fin><around|(|<streett>|)>>.
    </enumerate>

    The result follows. <htab|0pt><qed>
  </proof>

  Lemma<nbsp><reference|fins> naturally extends to finitary parity and
  finitary Bchi languages:

  <\corollary>
    <label|finp>The following assertions hold:

    <\itemize>
      <vspace|-2.5mm>

      <item>For all <math|p:\<Sigma\>\<rightarrow\><N>>, we have
      <math|<fin><around|(|<parp>|)>=<finp>>;

      <item>For all <math|F\<subseteq\>\<Sigma\>>, we have
      <math|<fin><around|(|<bucf>|)>=<fbucf>>.
    </itemize>
  </corollary>

  Bchi languages are a special case of parity languages, and parity
  languages are in turn a special case of Streett languages. Since distance
  sequences for parity and Bchi languages have been defined as a special
  case of Streett languages, Corollary<nbsp><reference|finp> follows from
  Lemma<nbsp><reference|fins>.

  The following lemma states that finitary Bchi languages are
  <math|<Sig|2>>-complete.

  <\theorem>
    <dueto|Topological characterization of finitary languages><label|thrm>The
    finitary Bchi, finitary parity and finitary Streett are
    <math|<Sig|2>>-complete.
  </theorem>

  <\proof>
    We show that if <math|\<emptyset\>\<subset\>F\<subset\>\<Sigma\>>, then
    <math|<fbucf>> is <math|<Sig|2>>-complete. It follows from
    Corollary<nbsp><reference|finp> that <math|<fbucf>\<in\><Sig|2>>. We now
    show that <math|<fbucf>> is <math|<Sig|2>>-hard. By
    Theorem<nbsp><reference|thrm> we have that <math|<bucf>> is
    <math|\<Pi\><rsub|2>>-complete, hence <math|<So>\<setminus\><bucf>> is
    <math|<Sig|2>>-complete. We present a topological reduction to show that
    <math|<So>\<setminus\><bucf>\<preceq\><fbucf>)>. Let
    <math|b:<So>\<rightarrow\><So>> be the stuttering function defined as
    follows:

    <\equation*>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|7|7|cell-rborder|0ln>|<table|<row|<cell|w>|<cell|=>|<cell|w<rsub|0>>|<cell|w<rsub|1>>|<cell|\<ldots\>>|<cell|w<rsub|n>>|<cell|\<ldots\>>>|<row|<cell|b<around|(|w|)>>|<cell|=>|<cell|w<rsub|0>>|<cell|<wide*|w<rsub|1>*w<rsub|1>|\<wide-underbrace\>><rsub|2>>|<cell|\<ldots\>>|<cell|<wide*|w<rsub|n>*w<rsub|n>*\<ldots\>*w<rsub|n>|\<wide-underbrace\>><rsub|2<rsup|n>>>|<cell|\<ldots\>>>>>>
    </equation*>

    The function <math|b> is continuous. We check that the following holds:

    <\equation*>
      <infi><around|(|w|)>\<subseteq\>F<text|iff
      >\<exists\>B\<in\><N>,\<exists\>n\<in\><N>,\<forall\>k\<geq\>n,<nextk><around|(|b<around|(|w|)>,F|)>\<leq\>B.
    </equation*>

    Left to right direction: assume that from the position <math|n> of
    <math|w>, letters belong to <math|F>. Then from the position
    <math|2<rsup|n>-1>, letters of <math|b<around|(|w|)>> belong to <math|F>,
    then <math|<nextk><around|(|b<around|(|w|)>,F|)>=0> for
    <math|k\<geq\>2<rsup|n>-1>.<next-line>Right to left direction: let
    <math|B> and <math|n> be integers such that for all <math|k\<geq\>n> we
    have <math|<nextk><around|(|b<around|(|w|)>,F|)>\<leq\>B>. Assume
    <math|2<rsup|k-1>\<gtr\>B> and <math|k\<geq\>n>, then the letter in
    position <math|2<rsup|k>-1> in <math|b<around|(|w|)>> is repeated
    <math|2<rsup|k-1>> times, thus <math|<nextk><around|(|b<around|(|w|)>,F|)>>
    is either <math|0> or higher than <math|2<rsup|k-1>>. The latter is not
    possible since it must be less than <math|B>. It follows that the letter
    in position <math|k> in <math|w> belongs to <math|F>. Hence we get
    <math|<So>\<setminus\><bucf>\<preceq\><fbucf>>, so <math|<fbucf>> is
    <math|<Sig|2>>-complete. From this we deduce the two other claims as
    special cases.<htab|0pt><qed>
  </proof>

  <section|Expressive power of finitary automata>

  In this section we consider the finitary automata, and compare their
  expressive power to classical automata. We then address the question of
  determinization. Deterministic finitary automata enjoy nice properties that
  allows to describe languages they recognize using the <math|<fin>>
  operator. As a by-product we get boolean closure properties of finitary
  automata.

  <subsection|Comparison with classical automata>

  Finitary conditions allow to express bounds requirements:

  <big-figure|<with|par-mode|center|<label|auto1> >|A finitary Bchi
  automaton <math|<A>>>

  <\example>
    <dueto|<math|<DFB>\<nsubseteq\><omegareg>>><label|examp1>Consider the
    finitary Bchi automaton shown in Fig.<nbsp><reference|auto1>, the state
    labeled<nbsp>0 being its only final state. Its language is
    <math|L<rsub|B>=>. Indeed, <math|0>-labeled state is visited while
    reading the letter <math|b>, and the <math|1>-labeled state is visited
    while reading the letter <math|a>. An infinite word is accepted iff the
    <math|0>-labeled state is visited infinitely often and there is a bound
    between two consecutive visits of the <math|0>-labeled state. We can
    easily see that <math|L<rsub|B>> is not <math|\<omega\>>-regular, using
    proof ideas from<nbsp><cite|BC06-LICS>: its complement would be
    <math|\<omega\>>-regular, so it would contain ultimately periodic words,
    which is not the case.
  </example>

  However, finitary automata cannot distinguish between \Pmany b's\Q and
  \Ponly b's\Q:

  <\example>
    <dueto|<math|<DB>\<nsubseteq\><NFB>>><label|examp2>Consider the language
    of infinitely many <math|a>'s, <with|font-shape|italic|i.e>,
    <math|L<rsub|I>=<around|{|w\<mid\>w*<text|has an infinite number of
    >a|}>>. The language <math|L<rsub|I>> is recognized by a simple
    deterministic Bchi automaton. However, we can show that there is no
    finitary Bchi automata that recognizes <math|L<rsub|I>>. Intuitively,
    such an automaton would, while reading the infinite word
    <math|w=a*b*a*b<rsup|2>*a*b<rsup|3>*a*b<rsup|4>*\<ldots\>*a*b<rsup|n>*\<ldots\>\<in\>L<rsub|I>>,
    have to distinguish between all b's, otherwise it would accept a word
    with only b's at the end. Assume towards contradiction that there exists
    <math|<A>> a non-deterministic finitary Bchi automaton with <math|N>
    states recognizing <math|L<rsub|I>>. Let us consider the infinite word
    <math|w>. Since <math|w> must be accepted by <math|<A>>, there must be an
    accepting run <math|\<rho\>>, represented as follows:

    <\equation*>
      q<rsub|0><long-arrow|\<rubber-rightarrow\>|a>p<rsub|0><long-arrow|\<rubber-rightarrow\>|b>q<rsub|1>*\<ldots\>*q<rsub|n><long-arrow|\<rubber-rightarrow\>|a>p<rsub|n><long-arrow|\<rubber-rightarrow\>|b<rsup|n+1>>q<rsub|n+1>*\<ldots\>
    </equation*>

    and

    <\equation*>
      p<rsub|n-1><long-arrow|\<rubber-rightarrow\>|b>q<rsub|n,1><long-arrow|\<rubber-rightarrow\>|b>q<rsub|n,2>*\<ldots\><long-arrow|\<rubber-rightarrow\>|b>q<rsub|n,n-1><long-arrow|\<rubber-rightarrow\>|b>q<rsub|n,n>=q<rsub|n>*\<ldots\>
    </equation*>

    Since <math|\<rho\>> is accepting, there exists <math|B\<in\><N>>, and
    <math|n\<in\><N>>, such that for all <math|k\<geq\>n> we have
    <math|<distk><around|(|\<rho\>,p|)>\<leq\>B>. Let <math|c> be the lowest
    priority infinitely visited in <math|\<rho\>>. As <math|\<rho\>> is
    accepting, <math|c> is even. The state <math|p<rsub|k-1>> is in position
    <math|<frac|k\<cdot\><around|(|k+1|)>|2>> in <math|\<rho\>>. Let <math|k>
    be an integer such that (a)<nbsp><math|<frac|k\<cdot\><around|(|k+1|)>|2>\<geq\>n>
    and (b)<nbsp><math|k\<geq\><around|(|N+1|)>\<cdot\>B>. Let us consider
    the set of states <math|<around|{|q<rsub|k,1>,\<ldots\>,q<rsub|k,k>|}>>.
    Since the distance function is bounded by <math|B> from the <math|n>-th
    position, the priority <math|c> appears at least once in each set of
    consecutively visited states of size <math|B>. Since
    <math|<frac|k\<cdot\><around|(|k+1|)>|2>\<geq\>n> and <math|q<rsub|k,1>>
    is the state following <math|p<rsub|k-1>>, the latter holds from
    <math|q<rsub|k,1>>. Since <math|k\<geq\><around|(|N+1|)>\<cdot\>B>, it
    appears at least <math|N+1> times in <math|<around|{|q<rsub|k,1>,\<ldots\>,q<rsub|k,k>|}>>.
    Since there is <math|N> states in <math|<A>>, at least one state has been
    reached twice. We can thus iterate: the infinite word
    <math|w<rprime|'>=a*b*a*b<rsup|2>*a*b<rsup|3>*a*b<rsup|4>*\<ldots\>*b<rsup|k-1>*a*b<rsup|\<omega\>>>,
    and the word <math|w<rprime|'>> is accepted by <math|<A>>. However,
    <math|w<rprime|'>\<nin\>L<rsub|I>> and hence we have a contradiction.
  </example>

  We summarize the results in the following theorem.

  <\theorem>
    The following assertions hold: (a)<nbsp><math|<DB>\<nsubseteq\><NFB>>;
    (b)<nbsp><math|<DFB>\<nsubseteq\><NB>>.
  </theorem>

  <subsection|Deterministic finitary automata>

  Given a deterministic complete automaton <math|<A>> with accepting
  condition <math|<Acc>>, we will consider the language obtained by using
  <math|<fin><around|(|<Acc>|)>> as acceptance condition. Treating the
  automaton as a transducer, we consider the following function:
  <math|C<rsub|<A>>:<So>\<to\>Q<rsup|\<omega\>>> which maps an infinite word
  <math|w> to the unique run <math|\<rho\>> of <math|<A>> on <math|w> (there
  is a unique run since <math|<A>> is deterministic and complete). Then:

  <\equation*>
    <LA>=<around|{|w\<mid\>C<rsub|<A>><around|(|w|)>\<in\><Acc>|}>=C<rsub|<A>><rsup|-><around|(|<Acc>|)>.
  </equation*>

  We will focus on the following property:
  <math|C<rsub|<A>><rsup|-><around|(|<fin><around|(|<Acc>|)>|)>=<fin><around|(|C<rsub|<A>><rsup|-><around|(|<Acc>|)>|)>>,
  which follows from the following lemma. Deterministic complete automata,
  regarded as transducers, preserve topology and <math|\<omega\>>-regularity.
  Hence applying the finitary operator <math|<fin>> to the input (the
  language <math|L>) or to the acceptance condition <math|<Acc>> is
  equivalent.

  <\lemma>
    <label|lemm>For all <math|<A>=<around|(|Q,\<Sigma\>,q<rsub|0>,\<delta\>,<Acc>|)>>
    deterministic complete automaton, we have:

    <\enumerate>
      <vspace|-2.5mm>

      <item>for all <math|A\<subseteq\>Q<rsup|\<omega\>>>, <math|A> is closed
      <math|\<Rightarrow\>C<rsub|<A>><rsup|-><around|(|A|)>> closed
      (<math|C<rsub|<A>>> is continuous).

      <item>for all <math|L\<subseteq\><So>>, <math|L> is closed
      <math|\<Rightarrow\>C<rsub|<A>><around|(|L|)>> closed
      (<math|C<rsub|<A>>> is closed).

      <item>for all <math|A\<subseteq\>Q<rsup|\<omega\>>>, <math|A> is
      <math|\<omega\>>-regular <math|\<Rightarrow\>C<rsub|<A>><rsup|-><around|(|A|)>>
      <math|\<omega\>>-regular.

      <item>for all <math|L\<subseteq\><So>>, <math|L> is
      <math|\<omega\>>-regular <math|\<Rightarrow\>C<rsub|<A>><around|(|L|)>>
      <math|\<omega\>>-regular.
    </enumerate>
  </lemma>

  <\proof>
    We prove all the cases below.

    <\enumerate>
      <item>Let <math|A\<subseteq\>Q<rsup|\<omega\>>> such that <math|A> is
      closed. Let <math|w> be such that for all <math|n\<in\><N>> we have
      <math|w<rsub|0>*\<ldots\>*w<rsub|n>\<in\><pref|C<rsub|<A>><rsup|-><around|(|A|)>>>.
      We define the run <math|\<rho\>=C<rsub|<A>><around|(|w|)>> and show
      that <math|\<rho\>=q<rsub|0>*q<rsub|1>*\<ldots\>\<in\>A>. Since
      <math|A> is closed, we will show for all <math|n\<in\><N>> we have
      <math|q<rsub|0>*\<ldots\>*q<rsub|n>\<in\><pref|A>>. From the hypothesis
      we have <math|w<rsub|0>*\<ldots\>*w<rsub|n-1>\<in\><pref|C<rsub|<A>><rsup|-><around|(|A|)>>>,
      and then there exists an infinite word <math|u> such that
      <math|C<rsub|<A>>*<around|(|w<rsub|0>*\<ldots\>*w<rsub|n-1>*u|)>\<in\>A>.
      Let <math|C<rsub|<A>>*<around|(|w<rsub|0>*\<ldots\>*w<rsub|n-1>*u|)>=q<rsub|0>*q<rprime|'><rsub|1>*\<ldots\>*q<rprime|'><rsub|n>*\<ldots\>>,
      then we have <math|q<rsub|0><long-arrow|\<rubber-rightarrow\>|w<rsub|0>>q<rprime|'><rsub|1><long-arrow|\<rubber-rightarrow\>|w<rsub|1>>q<rprime|'><rsub|2>*\<cdots\><long-arrow|\<rubber-rightarrow\>|w<rsub|n-1>>q<rprime|'><rsub|n>*\<cdots\>>.
      Since <math|<A>> is deterministic, we get
      <math|q<rprime|'><rsub|i>=q<rsub|i>>, and hence
      <math|q<rsub|0>*\<ldots\>*q<rsub|n>\<in\><pref|A>>.

      <item>Let <math|L\<subseteq\><So>> such that <math|L> is closed. Let
      <math|\<rho\>=q<rsub|0>*q<rsub|1>*\<ldots\>> such that for all
      <math|n\<in\><N>> we have <math|q<rsub|0>*\<ldots\>*q<rsub|n>\<in\><pref|C<rsub|<A>><around|(|L|)>>>.
      Then for all <math|n\<in\><N>>, there exists a word
      <math|w<rsub|0>*w<rsub|1>*\<ldots\>*w<rsub|n-1>> such that
      <math|q<rsub|0><long-arrow|\<rubber-rightarrow\>|w<rsub|0>>q<rsub|1><long-arrow|\<rubber-rightarrow\>|w<rsub|1>>q<rsub|2>*\<ldots\><long-arrow|\<rubber-rightarrow\>|w<rsub|n-1>>q<rsub|n>>,
      and <math|w<rsub|0>*w<rsub|1>*\<ldots\>*w<rsub|n-1>\<in\><pref|L>>. We
      define by induction on <math|n> an infinite nested sequence of finite
      words <math|w<rsub|0>*w<rsub|1>*\<ldots\>*w<rsub|n>\<in\><pref|L>>. We
      denote by <math|w> the limit of this nested sequence of finite words.
      We have that <math|\<rho\>=C<rsub|<A>><around|(|w|)>>. Since <math|L>
      is closed, <math|w\<in\>L>.

      <item>Let <math|A\<subseteq\>Q<rsup|\<omega\>>> such that <math|A>
      recognized by a Bchi automaton <math|<B>=<around|(|Q<rsub|<B>>,Q,P<rsub|0>,\<tau\>,F|)>>.
      We define the Bchi automaton <math|<C>=<around|(|Q\<times\>Q<rsub|<B>>,\<Sigma\>,\<times\>P<rsub|0>,\<gamma\>,Q<rsub|<B>>\<times\>F|)>>,
      where <math|<around|(|q<rsub|1>,p<rsub|1>|)><long-arrow|\<rubber-rightarrow\>|\<sigma\>><around|(|q<rsub|2>,p<rsub|2>|)>>
      iff <math|q<rsub|1><long-arrow|\<rubber-rightarrow\>|\<sigma\>>q<rsub|2>>
      in <math|<A>> and <math|p<rsub|1><long-arrow|\<rubber-rightarrow\>|q<rsub|1>>p<rsub|2>>
      in <math|<B>>. We now show the correctness of our construction. Let
      <math|w=w<rsub|0>*w<rsub|1>*\<ldots\>> accepted by <math|<C>>, then
      there exists an accepting run <math|\<rho\>>, as follows:

      <\equation*>
        <around|(|q<rsub|0>,p<rsub|0>|)><long-arrow|\<rubber-rightarrow\>|w<rsub|0>><around|(|q<rsub|1>,p<rsub|1>|)><long-arrow|\<rubber-rightarrow\>|w<rsub|1>><around|(|q<rsub|2>,p<rsub|2>|)>*\<ldots\><around|(|q<rsub|n>,p<rsub|n>|)><long-arrow|\<rubber-rightarrow\>|w<rsub|n>><around|(|q<rsub|n+1>,p<rsub|n+1>|)>*\<ldots\>
      </equation*>

      where the second component visits <math|F> infinitely often. Hence:

      <\equation*>
        <around|(|\<dag\>|)><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|q<rsub|0><long-arrow|\<rubber-rightarrow\>|w<rsub|0>>q<rsub|1><long-arrow|\<rubber-rightarrow\>|w<rsub|1>>q<rsub|2>*\<ldots\>*q<rsub|n><long-arrow|\<rubber-rightarrow\>|w<rsub|n>>q<rsub|n+1>*\<ldots\><text|in
        ><A>>>|<row|<cell|p<rsub|0><long-arrow|\<rubber-rightarrow\>|q<rsub|0>>p<rsub|1><long-arrow|\<rubber-rightarrow\>|q<rsub|1>>p<rsub|2>*\<ldots\>*p<rsub|n><long-arrow|\<rubber-rightarrow\>|q<rsub|n>>p<rsub|n+1>*\<ldots\><text|in
        ><B><space|1em>>>>>>|\<nobracket\>>
      </equation*>

      Hence from <math|<around|(|\<dag\>|)>>, we have
      <math|C<rsub|<A>><around|(|w|)>=q<rsub|0>*q<rsub|1>*\<ldots\>\<in\><La><around|(|<B>|)>=A>,
      and it follows that <math|w\<in\>C<rsub|<A>><rsup|-><around|(|A|)>>.
      Conversely, let <math|w\<in\>C<rsub|<A>><rsup|-><around|(|A|)>>, then
      we have <math|\<rho\>=C<rsub|<A>><around|(|w|)>=q<rsub|0>*q<rsub|1>*\<ldots\>\<in\>A=<La><around|(|<B>|)>>.
      Then the above statement <math|<around|(|\<dag\>|)>> holds, which
      entails that <math|w> is accepted by <math|<C>>. It follows that
      <math|<C>> recognizes <math|C<rsub|<A>><rsup|-><around|(|A|)>>.

      <item>Let <math|L\<subseteq\><So>> such that <math|L> is recognized by
      a Bchi automaton <math|<B>=<around|(|Q<rsub|<B>>,\<Sigma\>,P<rsub|0>,\<tau\>,F|)>>.
      We define the Bchi automaton <math|<C>=<around|(|Q\<times\>Q<rsub|<B>>,Q,\<times\>P<rsub|0>,\<gamma\>,Q\<times\>F|)>>,
      where <math|<around|(|q,p<rsub|1>|)><long-arrow|\<rubber-rightarrow\>|q><around|(|q<rprime|'>,p<rsub|2>|)>>
      iff there exists <math|\<sigma\>\<in\>\<Sigma\>>, such that
      <math|q<long-arrow|\<rubber-rightarrow\>|\<sigma\>>q<rprime|'>> in
      <math|<A>> and <math|p<rsub|1><long-arrow|\<rubber-rightarrow\>|\<sigma\>>p<rsub|2>>
      in <math|<B>>. A proof similar to above show that <math|<C>> recognizes
      <math|C<rsub|<A>><around|(|L|)>>.
    </enumerate>

    The desired result follows. <htab|0pt><qed>
  </proof>

  <\theorem>
    <label|findet>For any deterministic complete automaton
    <math|<A>=<around|(|Q,\<Sigma\>,q<rsub|0>,\<delta\>,<Acc>|)>> recognizing
    a language <math|L>, the finitary restriction of this automaton
    <math|<fin><around|(|<A>|)>=<around|(|Q,\<Sigma\>,q<rsub|0>,\<delta\>,<fin><around|(|<Acc>|)>|)>>
    recognizes <math|<fin><around|(|L|)>>.
  </theorem>

  <\proof>
    A word <math|w> is accepted by <math|<fin><around|(|<A>|)>> iff
    <math|w\<in\>C<rsub|<A>><rsup|-><around|(|<fin><around|(|<Acc>|)>|)>=<fin><around|(|C<rsub|<A>><rsup|-><around|(|<Acc>|)>|)>=<fin><around|(|L|)>>.
    <htab|0pt><qed>
  </proof>

  Theorem<nbsp><reference|findet> allows to extend all known results on
  deterministic classes to finitary deterministic classes: as a corollary, we
  have <math|<DFB>\<subset\><DFP>> and <math|<DFP>=<DFS>>.

  We now show that non-deterministic finitary parity automata are more
  expressive than deterministic finitary parity automata. However, for every
  language <math|L\<in\><omegareg>> there exists <math|<A>\<in\><DP>> such
  that <math|<A>> recognizes <math|L>, and by Theorem<nbsp><reference|findet>
  the deterministic finitary parity automaton <math|<fin><around|(|<A>|)>>
  recognizes <math|<fin><around|(|L|)>>.

  <\corollary>
    For every language <math|L\<in\><omegareg>> there is a deterministic
    finitary parity automata <math|<A>> such that
    <math|<LA>=<fin><around|(|L|)>>.
  </corollary>

  <\example>
    <dueto|<math|<DFP>\<subset\><NFP>>><label|examp3>As for
    Example<nbsp><reference|examp1> we consider the languages
    <math|L<rsub|1>=> and <math|L<rsub|2>=>. It follows from
    Example<nbsp><reference|examp1> that both <math|L<rsub|1>> and
    <math|L<rsub|2>> belong to <math|<DFP>>, hence to <math|<NFP>>. A
    finitary parity automaton, relying on non-determinism, is easily built to
    recognize <math|L=L<rsub|1>\<cup\>L<rsub|2>>, hence <math|L\<in\><NFP>>.
    We can show that we cannot bypass this non-determinism, as by reading a
    word we have to decide well in advance which sequence will be bounded:
    a's or b's, <with|font-shape|italic|i.e>, <math|L\<nin\><DFP>>. To prove
    it, we interleave words of the form <math|<around|(|a<rsup|\<ast\>>\<cdot\>b<rsup|\<ast\>>|)><rsup|\<ast\>>\<cdot\>a<rsup|\<omega\>>>
    and <math|<around|(|a<rsup|\<ast\>>\<cdot\>b<rsup|\<ast\>>|)><rsup|\<ast\>>\<cdot\>b<rsup|\<omega\>>>,
    and use a pumping argument to reach a contradiction. Assume towards
    contradiction that <math|L\<in\><DFP>>, and let <math|<A>> be a
    deterministic complete finitary parity automaton with <math|N> states
    that recognizes <math|L>. Let <math|q<rsub|0>> be the starting state.
    Since <math|a<rsup|\<omega\>>> belongs to <math|L>, its unique run on
    <math|<A>> is accepting, and can be decomposed as follows:
    <math|q<rsub|0><long-arrow|\<rubber-rightarrow\>|a<rsup|n<rsub|0>>>s<rsub|0><long-arrow|\<rubber-rightarrow\>|a<rsup|p<rsub|0>>>s<rsub|0><long-arrow|\<rubber-rightarrow\>|a<rsup|p<rsub|0>>>\<ldots\>>
    where <math|s<rsub|0>> is the lowest priority visited infinitely often
    while reading <math|a<rsup|\<omega\>>>. Then,
    <math|a<rsup|n<rsub|0>>*b<rsup|\<omega\>>> belongs to this <math|L>, its
    unique run on <math|<A>> is accepting, and has the following shape:
    <math|q<rsub|0><long-arrow|\<rubber-rightarrow\>|a<rsup|n<rsub|0>>>s<rsub|0><long-arrow|\<rubber-rightarrow\>|b<rsup|n<rprime|'><rsub|0>>>t<rsub|0><long-arrow|\<rubber-rightarrow\>|b<rsup|p<rprime|'><rsub|0>>>t<rsub|0><long-arrow|\<rubber-rightarrow\>|b<rsup|p<rprime|'><rsub|0>>>\<ldots\>>
    where <math|t<rsub|0>> is the lowest priority visited infinitely often
    while reading <math|a<rsup|n<rsub|0>>*b<rsup|\<omega\>>>. Repeating this
    construction and by induction we have, as shown in
    Fig<nbsp><reference|fig>:

    <\big-figure>
      <label|fig>
    </big-figure|Inductive construction showing that <math|L\<nin\><DFP>>.>

    where <math|s<rsub|k>> is the lowest priority visited infinitely often
    while reading <math|a<rsup|n<rsub|0>>*b<rsup|n<rprime|'><rsub|0>>*\<ldots\>*a<rsup|n<rsub|k>>*a<rsup|\<omega\>>>
    and <math|t<rsub|k>> is the lowest priority visited infinitely often
    while reading <math|a<rsup|n<rsub|0>>*b<rsup|n<rprime|'><rsub|0>>*\<ldots\>*a<rsup|n<rsub|k>>*b<rsup|n<rprime|'><rsub|k>>*b<rsup|\<omega\>>>.
    There must be <math|i\<less\>j>, such that <math|t<rsub|i>=t<rsub|j>>.
    Let <math|u=a<rsup|n<rsub|0>>*b<rsup|n<rprime|'><rsub|0>>*\<ldots\>*b<rsup|n<rprime|'><rsub|i>>>
    and <math|v=b<rsup|n<rprime|'><rsub|i+1>>*\<ldots\>*b<rsup|n<rprime|'><rsub|j>>>,
    we have:

    <\equation*>
      q<rsub|0><long-arrow|\<rubber-rightarrow\>|u>t<rsub|i><long-arrow|\<rubber-rightarrow\>|a<rsup|n<rsub|i+1>>>s<rsub|i+1><long-arrow|\<rubber-rightarrow\>|v>t<rsub|j>=t<rsub|i>
    </equation*>

    Consider the words <math|w=u\<cdot\><around|(|a<rsup|n<rsub|i+1>>\<cdot\>v|)><rsup|\<omega\>>>
    and

    <\equation*>
      w<rsup|\<ast\>>=u\<cdot\><around|(|b<rsup|p<rprime|'><rsub|i>>*a<rsup|n<rsub|i>+p<rsub|i>>*v|)>\<cdot\><around|(|b<rsup|2*p<rprime|'><rsub|i>>*a<rsup|n<rsub|i>+2*p<rsub|i>>*v|)>*\<ldots\>*<around|(|b<rsup|k*p<rprime|'><rsub|i>>*a<rsup|n<rsub|i>+k*p<rsub|i>>*v|)>*\<ldots\>
    </equation*>

    <math|w> must be accepted by <math|<A>> since it belongs to <math|L>.
    Hence <math|w<rsup|\<ast\>>> is accepted as well, but does not belong to
    <math|L>. We have a contradiction, and the result follows.
  </example>

  <\theorem>
    <label|thrm>We have <math|<DFP>\<subset\><NFP>>.
  </theorem>

  Observe that Theorem<nbsp><reference|findet> does not hold for
  non-deterministic automata, since we have <math|<DP>=<NP>> but
  <math|<DFP>\<subset\><NFP>>.

  <subsection|Non-deterministic finitary automata>

  We can show that non-deterministic finitary Streett automata can be reduced
  to non-deterministic finitary Bchi automata, and this would complete the
  picture of expressive power comparison. We first show that
  non-deterministic finitary Bchi automata are closed under intersection,
  and use it to show Theorem<nbsp><reference|thrm>.

  <\lemma>
    <label|nfbconjunction><math|<NFB>> is closed under intersection.
  </lemma>

  <\proof>
    Let <math|<A><rsub|1>=<around|(|Q<rsub|1>,\<Sigma\>,\<delta\><rsub|1>,Q<rsup|1><rsub|0>,F<rsub|1>|)>>
    and <math|<A><rsub|2>=<around|(|Q<rsub|2>,\<Sigma\>,\<delta\><rsub|2>,Q<rsup|2><rsub|0>,F<rsub|2>|)>>
    be two non-deterministic finitary Bchi automata. Without loss of
    generality we assume both <math|<A><rsub|1>> and <math|<A><rsub|2>> to be
    complete. We will define a construction similar to the synchronous
    product construction, where a switch between copies will happen while
    visiting <math|F<rsub|1>> or <math|F<rsub|2>>. The finitary Bchi
    automaton is <math|<A>=<around|(|Q<rsub|1>\<times\>Q<rsub|2>\<times\>,\<Sigma\>,\<delta\>,Q<rsup|1><rsub|0>\<times\>Q<rsup|2><rsub|0>\<times\>,F<rsub|1>\<times\>Q<rsub|2>\<times\>\<cup\>Q<rsub|1>\<times\>F<rsub|2>\<times\>|)>>.
    We define the transition relation <math|\<delta\>> below:

    <\equation*>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|\<delta\>>|<cell|=>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>>>>>
    </equation*>

    Intuitively, the transition function <math|\<delta\>> is as follows: the
    first component mimics the transition for automata <math|<A><rsub|1>>,
    the second component mimics the transition for <math|<A><rsub|2>>, and
    there is a switch for the third component from <math|1> to <math|2>
    visiting a state in <math|F<rsub|1>>, and from <math|2> to <math|1>
    visiting a state in <math|F<rsub|2>>.

    We now prove the correctness of the construction. Consider a word
    <math|w> that is accepted by <math|<A><rsub|1>>, and then there exists a
    bound <math|B<rsub|1>> and a run <math|\<rho\><rsub|1>> in
    <math|<A><rsub|1>> such that eventually, the number of steps between two
    visits to <math|F<rsub|1>> in <math|\<rho\><rsub|1>> is at most
    <math|B<rsub|1>>; and similarly, there exists a bound <math|B<rsub|2>>
    and a run <math|\<rho\><rsub|2>> in <math|<A><rsub|2>> such that
    eventually the number of steps between two visits to <math|F<rsub|2>> in
    <math|\<rho\><rsub|2>> is at most <math|B<rsub|2>>. It follows that in
    our construction there is a run <math|\<rho\>> (that mimics the runs
    <math|\<rho\><rsub|1>> and <math|\<rho\><rsub|2>>) in <math|<A>> such
    that eventually within <math|max> steps a state in
    <math|F<rsub|1>\<times\>Q<rsub|2>\<times\>\<cup\>Q<rsub|1>\<times\>F<rsub|2>\<times\>>
    is visited in <math|\<rho\>>. Hence <math|w> is accepted by <math|<A>>.
    Conversely, consider a word <math|w> that is accepted by <math|<A>>, and
    let <math|\<rho\>> be a run and <math|B> be the bound such that
    eventually between two visits to the accepting states in <math|\<rho\>>
    is separated by at most <math|B> steps. Let <math|\<rho\><rsub|1>> and
    <math|\<rho\><rsub|2>> be the decomposition of the run <math|\<rho\>> in
    <math|<A><rsub|1>> and <math|<A><rsub|2>>, respectively. It follows that
    both in <math|<A><rsub|1>> and <math|<A><rsub|2>> the respective final
    states are eventually visited within at most <math|2\<cdot\>B> steps in
    <math|\<rho\><rsub|1>> and <math|\<rho\><rsub|2>>, respectively. It
    follows that <math|w> is accepted by both <math|<A><rsub|1>> and
    <math|<A><rsub|2>>. Hence we have <math|<LA>=<La><around|(|<A><rsub|1>|)>\<cap\><La><around|(|<A><rsub|2>|)>>.
    <htab|0pt><qed>
  </proof>

  <\theorem>
    <label|thrm>We have <math|<NFB>=<NFP>=<NFS>>.
  </theorem>

  <\proof>
    We will present a reduction of <math|<NFS>> to <math|<NFB>> and the
    result will follow. Since the Streett condition is a finite conjunction
    of conditions <math|<infi><around|(|w|)>\<cap\>R<rsub|i>\<neq\>\<emptyset\>\<Rightarrow\><infi><around|(|w|)>\<cap\>G<rsub|i>\<neq\>\<emptyset\>>,
    by Lemma<nbsp><reference|nfbconjunction> it suffices to handle the
    special case when <math|d=1>. Hence we consider a non-deterministic
    Streett automaton <math|<A>=<around|(|Q,\<Sigma\>,\<delta\>,Q<rsub|0>,<around|(|R,G|)>|)>>
    with <math|<around|(|R,G|)>=<around|(|R<rsub|1>,G<rsub|1>|)>>. Without
    loss of generality we assume <math|<A>> to be complete. We construct a
    non-deterministic Bchi automaton <math|<A><rprime|'>=<around|(|Q\<times\>,\<Sigma\>,\<delta\><rprime|'>,Q<rsub|0>\<times\>,Q\<times\>|)>>,
    where the transition relation <math|\<delta\><rprime|'>> is given as
    follows:

    <\equation*>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|\<delta\><rprime|'>>|<cell|=>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>>>>>
    </equation*>

    In other words, the state component mimics the transition of <math|<A>>,
    and in the second component: (a)<nbsp>the automaton can choose to stay in
    component <math|1>, or switch to <math|2>; (b)<nbsp>there is a switch
    from <math|2> to <math|3> upon visiting a state in <math|R<rsub|1>>; and
    (b)<nbsp>there is a switch from <math|3> to <math|2> upon visiting a
    state in <math|G<rsub|1>>. Consider a word <math|w> accepted by
    <math|<A>> and an accepting run <math|\<rho\>> in <math|<A>>, and let
    <math|B> be the bound on the distance sequence. We show that <math|w> is
    accepted by <math|<A><rprime|'>> by constructing an accepting run
    <math|\<rho\><rprime|'>> in <math|<A><rprime|'>>. We consider the
    following cases:

    <\enumerate>
      <item>If infinitely many requests <math|R<rsub|1>> are visited in
      <math|\<rho\>>, then in <math|<A><rprime|'>> immediately switch to
      component <math|2>, and then mimic the run <math|\<rho\>> as a run
      <math|\<rho\><rprime|'>> in <math|<A><rprime|'>>. It follows that from
      some point <math|j> on every request is granted within <math|B> steps,
      and it follows that after position <math|j>, whenever the second
      component is <math|3>, it becomes<nbsp><math|2> within <math|B> steps.
      Hence <math|w> is accepted by <math|<A>>.

      <item>If finitely many requests <math|R<rsub|1>> are visited in
      <math|\<rho\>>, then after some point <math|j>, there are no more
      requests. The automaton <math|<A><rprime|'>> mimics the run
      <math|\<rho\>> by staying in the second component as<nbsp><math|1> for
      <math|j> steps, and then switches to component<nbsp><math|2>. Then
      after <math|j> steps we always have the second component
      as<nbsp><math|2>, and hence the word is accepted.
    </enumerate>

    Conversely, consider a word <math|w> accepted by <math|<A><rprime|'>> and
    consider the accepting run <math|\<rho\><rprime|'>>. We mimic the run in
    <math|<A>>. To accept the word <math|w>, the run <math|\<rho\><rprime|'>>
    must switch to the second component as<nbsp><math|2>, say after <math|j>
    steps. Then, from some point on whenever a state with second component
    <math|3> is visited, within some bound <math|B> steps a state with second
    component <math|2> is visited. Hence the run <math|\<rho\>> is accepting
    in <math|<A>>. Thus the languages of <math|<A>> and <math|<A><rprime|'>>
    coincide, and the desired result follows. <htab|0pt><qed>
  </proof>

  Our results are summarized in Corollary<nbsp><reference|sum> and shown in
  Fig<nbsp><reference|fig>.

  <\corollary>
    <label|sum>We have (a)<nbsp><math|<DFB>\<nsubseteq\><omegareg>>;
    (b)<nbsp><math|<DFB>\<subset\><DFP>=<DFS>\<subset\><NFB>=<NFP>=<NFS>>;
    (c)<nbsp><math|<DB>\<nsubseteq\><NFB>>;
    (d)<nbsp><math|<omegareg>\<nsubseteq\><NFB>>.
  </corollary>

  <subsection|Closure properties>

  <\theorem>
    <dueto|Closure properties><label|closure>The following closure properties
    hold:

    <\enumerate>
      <vspace|-2.5mm>

      <item><math|<DFP>> is closed under intersection.

      <item><math|<DFP>> is not closed under union.

      <item><math|<NFP>> is closed under union and intersection.

      <item><math|<DFP>> and <math|<NFP>> are not closed under
      complementation.
    </enumerate>
  </theorem>

  <\proof>
    We prove all the cases below.

    <\enumerate>
      <item>Intersection closure for <math|<DFP>> follows from
      Theorem<nbsp><reference|findet> and from the observation that for all
      <math|L,L<rprime|'>\<subseteq\><So>> we have
      <math|<fin><around|(|L\<cap\>L<rprime|'>|)>=<fin><around|(|L|)>\<cap\><fin><around|(|L<rprime|'>|)>>.
      The observation is proved as follows. Let
      <math|M\<in\>\<Pi\><rsub|1>\<cap\><omegareg>> and
      <math|M\<subseteq\>L\<cap\>L<rprime|'>>, then
      <math|M\<subseteq\><fin><around|(|L|)>\<cap\><fin><around|(|L<rprime|'>|)>>,
      and hence <math|<fin><around|(|L\<cap\>L<rprime|'>|)>\<subseteq\><fin><around|(|L|)>\<cap\><fin><around|(|L<rprime|'>|)>>.
      Conversely, let <math|M<rsub|1>\<subseteq\><fin><around|(|L|)>> and
      <math|M<rsub|2>\<subseteq\><fin><around|(|L<rprime|'>|)>>, then
      <math|M<rsub|1>\<cap\>M<rsub|2>\<in\>\<Pi\><rsub|1>\<cap\><omegareg>>
      and <math|M<rsub|1>\<cap\>M<rsub|2>\<subseteq\>L\<cap\>L<rprime|'>>.
      Hence <math|M<rsub|1>\<cap\>M<rsub|2>\<subseteq\><fin><around|(|L\<cap\>L<rprime|'>|)>>,
      thus <math|<fin><around|(|L|)>\<cap\><fin><around|(|L<rprime|'>|)>\<subseteq\><fin><around|(|L\<cap\>L<rprime|'>|)>>.

      <item>Failure of closure under union for <math|<DFP>> follows from
      Example<nbsp><reference|examp3>.

      <item>Union closure for <math|<NFP>> is easy and relies on
      non-determinism, while intersection closure follows from
      Lemma<nbsp><reference|nfbconjunction>, since <math|<NFP>=<NFB>>.

      <item>Failure of closure under complementation for <math|<DFP>> follows
      from items 1. and 2., since this closure together with intersection
      closure would imply union closure. Failure of closure under
      complementation for <math|<NFP>> follows from
      Example<nbsp><reference|examp2>. Indeed, the language
      <math|L<rsub|F>=<around|{|a,b|}><rsup|\<omega\>>\<setminus\>L<rsub|I>=<around|{|w\<mid\>w*<text|has
      a finite number of >a|}>> lies in <math|<NFP>>; however,
      Example<nbsp><reference|examp2> shows that its complement is not
      expressible by non-deterministic finitary Bchi automata, hence nor by
      non-deterministic finitary parity automata.
    </enumerate>

    The result follows. <htab|0pt><qed>
  </proof>

  <big-figure|<\with|par-mode|center>
    <\latex_preview|begin-tikzpicture>
      \\begin{tikzpicture}

      \ \ \ \\draw[rotate=90] (0,0) ellipse (1cm and 2cm);

      \ \ \ \\draw[rotate=90] (0,0) ellipse (1.5cm and 3cm);

      \ \ \ \\draw[rotate=90] (0,0) ellipse (2cm and 4cm);

      \;

      \ \ \ \\draw[rotate=60] (.4,1.8) ellipse (1cm and 1.5cm);

      \;

      \ \ \ \\draw[rotate=90,color=gray,line width=2.5pt] (1.2,0) ellipse
      (1.5cm and 3.4cm);

      \ \ \ \\draw (0,-0.7) node {$\\DFB$};

      \ \ \ \\draw (0,-1.2) node {$\\DFP = \\DFS$};

      \ \ \ \\draw (0,-1.7) node {$\\NFB = \\NFP = \\NFS$};

      \ \ \ \\draw (-2,2) node {$\\DB$};

      \ \ \ \\draw (0,2.4) node {$\\omegareg$};

      \\end{tikzpicture}
    </latex_preview>

    <label|fig>\ 
  </with>|Expressive power classification>

  <section|Regular Expression Characterization>

  In this section we address the question of giving a syntactical
  representation of finitary languages, using a special class of regular
  expressions.

  The class of <math|\<omega\>*B>-regular expressions was introduced in the
  work of<nbsp><cite|BC06-LICS> as an extension of <math|\<omega\>>-regular
  expressions, as an attempt to express bounds in regular languages. To
  define <math|\<omega\>*B>-regular expressions, we need regular expressions
  and <math|\<omega\>>-regular expressions.

  Regular expressions define regular languages over finite words, and have
  the following grammar:

  <\equation*>
    L\<assign\>\<emptyset\>\<mid\>\<varepsilon\>\<mid\>\<sigma\>\<mid\>L\<cdot\>L\<mid\>L<rsup|\<ast\>>\<mid\>L+L;<space|1em>\<sigma\>\<in\>\<Sigma\>
  </equation*>

  In the above grammar, <math|\<cdot\>> stands for concatenation,
  <math|\<ast\>> for Kleene star and <math|+> for union. Then
  <math|\<omega\>>-regular languages are finite union of
  <math|L\<cdot\>L<rprime|'><rsup|\<omega\>>>, where <math|L> and
  <math|L<rprime|'>> are regular languages of finite words. The class of
  <math|\<omega\>*B>-regular languages, as defined in<nbsp><cite|BC06-LICS>,
  is described by finite union of <math|L\<cdot\>M<rsup|\<omega\>>>, where
  <math|L> is a regular language over finite words and <math|M> is a
  <math|B>-regular language over infinite sequences of finite words. The
  grammar for <math|B>-regular languages is as follows:

  <\equation*>
    M\<assign\>\<emptyset\>\<mid\>\<varepsilon\>\<mid\>\<sigma\>\<mid\>M\<cdot\>M\<mid\>M<rsup|\<ast\>>\<mid\>M<rsup|B>\<mid\>M+M;<space|1em>\<sigma\>\<in\>\<Sigma\>
  </equation*>

  The semantics of regular languages over infinite sequences of finite words
  will assign to a <math|B>-regular expression <math|M>, a language in
  <math|<around|(|\<Sigma\><rsup|\<ast\>>|)><rsup|\<omega\>>>. The infinite
  sequence <math|<seq|u<rsub|0>,u<rsub|1>,\<ldots\>>> will be denoted by
  <math|<wide|u|\<vect\>>>. The semantics is defined by structural induction
  as follows.

  <\itemize>
    <vspace|-2.5mm>

    <item><math|\<emptyset\>> is the empty language,

    <item><math|\<varepsilon\>> is the language containing the single
    sequence <math|<around|(|\<varepsilon\>,\<varepsilon\>,\<ldots\>|)>>,

    <item><math|a> is the language containing the single sequence
    <math|<around|(|a,a,\<ldots\>|)>>,

    <item><math|M<rsub|1>\<cdot\>M<rsub|2>> is the language <math|>,

    <item><math|M<rsup|\<ast\>>> is the language <math|>,

    <item><math|M<rsup|B>> is defined like <math|M<rsup|\<ast\>>> but we
    additionally require the values <math|f*<around|(|i+1|)>-f<around|(|i|)>>
    to be bounded uniformly in <math|i>,

    <item><math|M<rsub|1>+M<rsub|2>> is <math|>.
  </itemize>

  <no-indent>Finally, the <math|\<omega\>>-operator on sequences with
  nonempty words on infinitely many coordinates is:
  <math|<seq|u<rsub|0>,u<rsub|1>,\<ldots\>><rsup|\<omega\>>=u<rsub|0>*u<rsub|1>*\<ldots\>>.
  This operation is naturally extended to languages of sequences by taking
  the <math|\<omega\>> power of every sequence in the language. The class of
  <math|\<omega\>*B>-regular languages is more expressive than <math|<NFB>>,
  and this is due to the <math|\<ast\>>-operator. We will consider the
  following fragment of <math|\<omega\>*B>-regular languages where we do not
  use the <math|\<ast\>>-operator for <math|B>-regular expressions (however,
  the <math|\<ast\>>-operator is allowed for <math|L>, regular languages over
  finite words). We call this fragment the star-free fragment of
  <math|\<omega\>*B>-regular languages. In the following two lemmas we show
  that star-free <math|\<omega\>*B>-regular expressions express exactly
  <math|<NFB>>.

  <\lemma>
    <label|lemm>All languages in <math|<NFB>> can be described by a star-free
    <math|\<omega\>*B>-regular expression.
  </lemma>

  <\proof>
    Let <math|<A>=<around|(|Q,\<Sigma\>,\<delta\>,Q<rsub|0>,F|)>> be a
    non-deterministic finitary Bchi automaton. Without loss of generality we
    assume <math|Q=>. Let <math|L<rsub|q,q<rprime|'>>=> and
    <math|M<rsup|\<geq\>c><rsub|q>=>. Then

    <\equation*>
      <LA>=<big|cup><rsub|q<rsub|0>\<in\>Q<rsub|0>,q\<in\>F>L<rsub|q<rsub|0>,q>\<cdot\><around|(|M<rsub|q>|)><rsup|\<omega\>>.
    </equation*>

    For all <math|q,q<rprime|'>\<in\>Q> we have
    <math|L<rsub|q,q<rprime|'>>\<subseteq\><Sigstar>> is regular. We now show
    that for all <math|q\<in\>Q> the language <math|M<rsub|q>> is
    <math|B>-regular. For all <math|0\<leq\>k\<leq\>n> and
    <math|q,q<rprime|'>\<in\>Q>, let <math|M<rsup|k><rsub|q,q<rprime|'>>=>.
    We show by induction on <math|0\<leq\>k\<leq\>n> that for all
    <math|q,q<rprime|'>\<in\>Q> the language
    <math|M<rsup|k><rsub|q,q<rprime|'>>> is <math|B>-regular. The base case
    <math|k=0> follows from observation:

    <\equation*>
      M<rsup|0><rsub|q,q<rprime|'>>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|a<rsub|1>+a<rsub|2>+\<ldots\>+a<rsub|l>>|<cell|<text|if
      >q\<neq\>q<rprime|'><text|and ><around|(|q,a,q<rprime|'>|)>\<in\>\<delta\>\<Longleftrightarrow\>\<exists\>i\<in\>,a=a<rsub|i>>>|<row|<cell|\<varepsilon\>+a<rsub|1>+a<rsub|2>+\<ldots\>+a<rsub|l>>|<cell|<text|if
      >q=q<rprime|'><text|and ><around|(|q,a,q<rprime|'>|)>\<in\>\<delta\>\<Longleftrightarrow\>\<exists\>i\<in\>,a=a<rsub|i>>>|<row|<cell|\<emptyset\>>|<cell|<text|otherwise>>>>>>|\<nobracket\>>
    </equation*>

    The inductive case for <math|k\<gtr\>0> follows from observation:

    <\equation*>
      M<rsup|k><rsub|q,q<rprime|'>>=M<rsup|k-1><rsub|q,k>\<cdot\><around|(|M<rsup|k-1><rsub|k,k>|)><rsup|B>\<cdot\>M<rsup|k-1><rsub|k,q<rprime|'>>+M<rsup|k-1><rsub|q,q<rprime|'>>
    </equation*>

    Since <math|M<rsup|n><rsub|q,q>=M<rsub|q>>, we conclude that <math|<LA>>
    is described by a star-free <math|\<omega\>*B>-regular expression.
    <htab|0pt><qed>
  </proof>

  <\lemma>
    <label|lemm>All languages described by a star-free
    <math|\<omega\>*B>-regular expression is recognized by a
    non-deterministic finitary Bchi automaton.
  </lemma>

  <\proof>
    To prove this result, we will describe automata reading infinite
    sequences of finite words, and corresponding acceptance conditions. Let
    <math|<A>=<around|(|Q,\<Sigma\>,\<delta\>,Q<rsub|0>,F|)>> a finitary
    Bchi automaton. While reading an infinite sequence
    <math|<wide|u|\<vect\>>> of finite words, <math|<A>> will accept if the
    following conditions are satisfied: (1)<nbsp><math|\<exists\>q<rsub|0>\<in\>Q<rsub|0>,q<rsub|1>,q<rsub|2>,\<ldots\>\<in\>F,\<forall\>i\<in\><N>>,
    we have <math|q<rsub|i><long-arrow|\<rubber-rightarrow\>|u<rsub|i>>q<rsub|i+1>>
    and (2)<nbsp><math|<around|(|<around|\||u<rsub|n>|\|>|)><rsub|n>> is
    bounded.

    We show that for all <math|M> star-free <math|B>-regular expression,
    there exists a non-deterministic finitary Bchi automaton accepting
    <math|M<rsup|B>>, language of infinite sequence of finite words, as
    described above. We proceed by induction on <math|M>.

    <\itemize>
      <item>The cases <math|\<emptyset\>,\<varepsilon\>> and
      <math|a\<in\>\<Sigma\>> are easy.

      <item>From <math|M> to <math|M<rsup|B>>, the same automaton for
      <math|M> works for <math|M<rsup|B>> as well, since <math|B> is
      idempotent.

      <item>From <math|M<rsub|1>,M<rsub|2>> to <math|M<rsub|1>+M<rsub|2>>:
      this involves non-determinism. The automaton guesses for each finite
      word which word is used. Let <math|<A><rsub|1>=<around|(|Q<rsub|1>,\<Sigma\>,\<delta\><rsub|1>,Q<rsub|1><rsup|0>,F<rsub|1>|)>>
      and <math|<A><rsub|2>=<around|(|Q<rsub|2>,\<Sigma\>,\<delta\><rsub|2>,Q<rsub|2><rsup|0>,F<rsub|2>|)>>
      two non-deterministic finitary Bchi automata accepting
      <math|M<rsub|1><rsup|B>> and <math|M<rsub|2><rsup|B>>, respectively.
      For <math|k\<in\>> and <math|T\<subseteq\>Q<rsub|k>>, we define
      <math|<Final><around|(|T|)>=> to be the state of final states reachable
      from a state in <math|T>. We denote by <math|<Final><rsup|k>> the
      <math|k>-th iteration of <math|<Final>>, e.g.,
      <math|<Final><rsup|3><around|(|T|)>=<Final><around|(|<Final><around|(|<Final><around|(|T|)>|)>|)>>.

      We define a finitary Bchi automaton:

      <\equation*>
        <A>=

        <\around|(>
          <wide*|<around|(|Q<rsub|1>\<times\>2<rsup|Q<rsub|1>>|)>\<cup\><around|(|Q<rsub|2>\<times\>2<rsup|Q<rsub|1>>|)>|\<wide-underbrace\>><rsub|<text|computation
          states>>

          \<cup\><wide*|2<rsup|Q<rsub|1>>\<times\>2<rsup|Q<rsub|2>>|\<wide-underbrace\>><rsub|<text|guess
          states>>,\<Sigma\>,\<delta\>,<around|(|Q<rsub|1><rsup|0>,Q<rsub|2><rsup|0>|)>,F
        </around|)>
      </equation*>

      where

      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|4|4|cell-halign|r>|<cwith|1|-1|4|4|cell-rborder|0ln>|<table|<row|<cell|\<delta\>>|<cell|=>|<cell|>|<cell|<space|1em><around|(|<text|guess
        is >1|)>>>|<row|<cell|>|<cell|\<cup\>>|<cell|>|<cell|<space|1em><around|(|<text|guess
        is >2|)>>>|<row|<cell|>|<cell|\<cup\>>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>|<cell|>>>>>
      </equation*>

      There are two kinds of states. Computation states are
      <math|<around|(|q,T|)>> where <math|q\<in\>Q<rsub|1>> and
      <math|T\<subseteq\>Q<rsub|2>> (or symmetrically <math|q\<in\>Q<rsub|2>>
      and <math|T\<subseteq\>Q<rsub|1>>), where <math|q> is the current state
      of the automaton that has been decided to use for the current finite
      word, and <math|T> is the set of final states of the other automaton
      that would have been reachable if one had chosen this automaton. Guess
      states are <math|<around|(|Q,Q<rprime|'>|)>>, where <math|Q> is the set
      of states from <math|<A><rsub|1>> one can start reading the next word,
      and similarly for <math|Q<rprime|'>>.

      We now prove the correctness of our construction. Consider an infinite
      sequence <math|<wide|w|\<vect\>>> accepted by <math|<A>>, and consider
      an accepting run <math|\<rho\>>. There are three cases:

      <\enumerate>
        <item>either all guesses are <math|1>;

        <item>or all guesses are <math|2>;

        <item>else, both guesses happen.
      </enumerate>

      The first two cases are symmetric. In the first, we can easily see that
      <math|<wide|w|\<vect\>>> is accepted by <math|<A><rsub|1>>, and
      similarly in the second <math|<wide|w|\<vect\>>> is accepted by
      <math|<A><rsub|2>>.

      We now consider the third case. There are two symmetric subcases:
      either the first guess is <math|1>, then

      <\equation*>
        \<rho\>=<around|(|Q<rsub|1><rsup|0>,Q<rsub|2><rsup|0>|)>\<cdot\><around|(|q<rsup|0><rsub|1>,<Final><around|(|Q<rsub|2><rsup|0>|)>|)>*\<ldots\>,
      </equation*>

      with <math|q<rsup|0><rsub|1>\<in\>Q<rsub|1><rsup|0>>; or symmetrically
      the first guess is <math|2>, then

      <\equation*>
        \<rho\>=<around|(|Q<rsub|1><rsup|0>,Q<rsub|2><rsup|0>|)>\<cdot\><around|(|q<rsup|0><rsub|2>,<Final><around|(|Q<rsub|1><rsup|0>|)>|)>*\<ldots\>,
      </equation*>

      with <math|q<rsup|0><rsub|2>\<in\>Q<rsub|2><rsup|0>>. We consider only
      the first subcase. Then

      <\equation*>
        \<rho\>=<around|(|Q<rsub|1><rsup|0>,Q<rsub|2><rsup|0>|)>\<cdot\><around|(|q<rsup|0><rsub|1>,<Final><around|(|Q<rsub|2><rsup|0>|)>|)>*\<ldots\><around|(|q<rsup|1><rsub|1>,<Final><around|(|Q<rsub|2><rsup|0>|)>|)>\<cdot\><around|(|,<Final><around|(|Q<rsub|2><rsup|0>|)>|)>*\<ldots\>,
      </equation*>

      where <math|u<rsub|0>> is a finite prefix of
      <math|<wide|w|\<vect\>><rsup|\<omega\>>> such that
      <math|q<rsup|0><rsub|1><long-arrow|\<rubber-rightarrow\>|u<rsub|0>>q<rsup|1><rsub|1>>
      in <math|<A><rsub|1>> and <math|q<rsup|1><rsub|1>\<in\>F<rsub|1>>. We
      denote by <math|\<rho\><rsub|0>> the finite prefix of <math|\<rho\>> up
      to <math|<around|(|q<rsup|1><rsub|1>,<Final><around|(|Q<rsub|2><rsup|0>|)>|)>>.
      Let <math|k> be the first time when guess is <math|2>: then

      <\equation*>
        \<rho\>=\<rho\><rsub|0>\<cdot\>\<rho\><rsub|1>\<cdot\>\<rho\><rsub|k-1>\<cdot\><around|(|,<Final><rsup|k><around|(|Q<rsub|2><rsup|0>|)>|)>\<cdot\><around|(|q<rsup|0><rsub|2>,<Final><around|(||)>|)>*\<ldots\>,
      </equation*>

      where <math|q<rsup|0><rsub|2>\<in\><Final><rsup|k><around|(|Q<rsub|2><rsup|0>|)>>
      and for <math|1\<leq\>i\<leq\>k-1>, we have

      <\equation*>
        \<rho\><rsub|i>=<around|(|,<Final><rsup|i><around|(|Q<rsub|2><rsup|0>|)>|)>\<cdot\><around|(|q<rsup|i><rsub|1>,<Final><rsup|i+1><around|(|Q<rsub|2><rsup|0>|)>|)>*\<ldots\><around|(|q<rsup|i+1><rsub|1>,<Final><rsup|i+1><around|(|Q<rsub|2><rsup|0>|)>|)>,
      </equation*>

      and <math|u<rsub|i>> is a finite word such that
      <math|q<rsup|i><rsub|1><long-arrow|\<rubber-rightarrow\>|u<rsub|i>>q<rsup|i+1><rsub|1>>
      in <math|<A><rsub|1>,q<rsup|i+1><rsub|1>\<in\>F<rsub|1>> and
      <math|u<rsub|0>*u<rsub|1>*\<ldots\>*u<rsub|k-1>> finite prefix of
      <math|<wide|w|\<vect\>><rsup|\<omega\>>>. Since
      <math|q<rsup|0><rsub|2>\<in\><Final><rsup|k><around|(|Q<rsub|2><rsup|0>|)>>,
      there exists <math|v<rsub|0>,v<rsub|1>,\<ldots\>,v<rsub|k-1>> finite
      words and <math|q<rsup|1><rsub|2>,\<ldots\>,q<rsup|k><rsub|2>\<in\>F<rsub|2>>
      such that: <math|q<rsup|0><rsub|2><long-arrow|\<rubber-rightarrow\>|v<rsub|0>>q<rsup|1><rsub|2><long-arrow|\<rubber-rightarrow\>|v<rsub|1>>\<ldots\><long-arrow|\<rubber-rightarrow\>|v<rsub|k-1>>q<rsup|k><rsub|2>>.
      Then we can repeat this by induction, constructing
      <math|<wide|u|\<vect\>>\<in\>M<rsub|1><rsup|B>> and
      <math|<wide|v|\<vect\>>\<in\>M<rsub|2><rsup|B>>, such that for all
      <math|i\<in\><N>>, we have <math|w<rsub|i>\<in\>>.

      Conversely, let <math|<wide|u|\<vect\>>\<in\>M<rsub|1><rsup|B>> and
      <math|<wide|v|\<vect\>>\<in\>M<rsub|2><rsup|B>>, and
      <math|<wide|w|\<vect\>>> such that <math|\<forall\>i\<in\><N>,w<rsub|i>\<in\>>.
      Using <math|<A><rsub|1>> when <math|w<rsub|i>=u<rsub|i>> and
      <math|<A><rsub|2>> otherwise, one can construct an accepting run for
      <math|<wide|w|\<vect\>>> and <math|<A>>. Hence <math|<A>> recognizes
      <math|<around|(|M<rsub|1>+M<rsub|2>|)><rsup|B>>.

      <item>From <math|M<rsub|1>,M<rsub|2>> to
      <math|M<rsub|1>\<cdot\>M<rsub|2>>: the automaton keeps tracks of
      pending states while reading the other word. Let
      <math|<A><rsub|1>=<around|(|Q<rsub|1>,\<Sigma\>,\<delta\><rsub|1>,Q<rsub|1><rsup|0>,F<rsub|1>|)>>
      and <math|<A><rsub|2>=<around|(|Q<rsub|2>,\<Sigma\>,\<delta\><rsub|2>,Q<rsub|2><rsup|0>,F<rsub|2>|)>>
      two non-deterministic finitary Bchi automata accepting
      <math|M<rsub|1><rsup|B>> and <math|M<rsub|2><rsup|B>>, respectively.
      Let <math|<A>=<around|(|<around|(|Q<rsub|1>\<times\>F<rsub|2>|)>\<cup\><around|(|Q<rsub|2>\<times\>F<rsub|1>|)>,\<Sigma\>,\<delta\>,Q<rsub|1><rsup|0>\<times\>Q<rsub|2><rsup|0>,F<rsub|1>\<times\>F<rsub|2>|)>>,
      where

      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|\<delta\>>|<cell|=>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>>|<row|<cell|>|<cell|\<cup\>>|<cell|>>>>>
      </equation*>

      Intuitively, the transition relation is as follows: either one is
      reading using <math|<A><rsub|1>> or <math|<A><rsub|2>>. In both cases,
      the automaton remembers the last final state visited while reading in
      the other automaton in order to restore this state for the next word.
      Let <math|<wide|w|\<vect\>>> accepted by <math|<A>>, an accepting run
      is as follows:

      <\equation*>
        <around|(|q<rsub|1><rsup|0>,q<rsub|2><rsup|0>|)><long-arrow|\<rubber-rightarrow\>|w<rsub|0>><around|(|q<rsub|1><rsup|1>,q<rsub|2><rsup|1>|)><long-arrow|\<rubber-rightarrow\>|w<rsub|1>>\<ldots\><around|(|q<rsub|1><rsup|i>,q<rsub|2><rsup|i>|)><long-arrow|\<rubber-rightarrow\>|w<rsub|i>><around|(|q<rsub|1><rsup|i+1>,q<rsub|2><rsup|i+1>|)>*\<ldots\>
      </equation*>

      where <math|<around|(|q<rsub|1><rsup|0>,q<rsub|2><rsup|0>|)>\<in\>Q<rsub|1><rsup|0>\<times\>Q<rsub|2><rsup|0>>,
      for all <math|i\<geq\>1>, we have <math|<around|(|q<rsub|1><rsup|i>,q<rsub|2><rsup|i>|)>\<in\>F<rsub|1>\<times\>F<rsub|2>>
      and <math|<around|(|<around|\||w<rsub|n>|\|>|)><rsub|n>> bounded. From
      the construction, for all <math|i\<in\><N>>, we have
      <math|w<rsub|i>=u<rsub|i><rsup|0>\<cdot\>v<rsub|i><rsup|0>\<cdot\>u<rsub|i><rsup|1>\<cdot\>v<rsub|i><rsup|1>*\<ldots\>*u<rsub|i><rsup|k<rsub|i>>\<cdot\>v<rsub|i><rsup|k<rsub|i>>>,
      where

      <\equation*>
        q<rsub|1><rsup|i>=q<rsub|1><rsup|i><around|(|0|)><long-arrow|\<rubber-rightarrow\>|u<rsub|i><rsup|0>>q<rsub|1><rsup|i><around|(|1|)><long-arrow|\<rubber-rightarrow\>|u<rsub|i><rsup|1>>q<rsub|1><rsup|i><around|(|2|)>*\<ldots\><long-arrow|\<rubber-rightarrow\>|u<rsub|i><rsup|k<rsub|i>>>q<rsub|1><rsup|i>*<around|(|k<rsub|i>+1|)>=q<rsub|1><rsup|i+1><space|1em><text|in
        ><A><rsub|1>
      </equation*>

      <\equation*>
        q<rsub|2><rsup|i>=q<rsub|2><rsup|i><around|(|0|)><long-arrow|\<rubber-rightarrow\>|v<rsub|i><rsup|0>>q<rsub|2><rsup|i><around|(|1|)><long-arrow|\<rubber-rightarrow\>|v<rsub|i><rsup|1>>q<rsub|2><rsup|i><around|(|2|)>*\<ldots\><long-arrow|\<rubber-rightarrow\>|v<rsub|i><rsup|k<rsub|i>>>q<rsub|2><rsup|i>*<around|(|k<rsub|i>+1|)>=q<rsub|2><rsup|i+1><space|1em><text|in
        ><A><rsub|2>
      </equation*>

      the states <math|<around|(|q<rsub|1><rsup|i><around|(|k|)>,q<rsub|2><rsup|i><around|(|k|)>|)>>
      belong to <math|F<rsub|1>\<times\>F<rsub|2>>. We define
      <math|u<rsub|i>=u<rsub|i><rsup|0>*u<rsub|i><rsup|1>*\<ldots\>*u<rsub|i><rsup|k<rsub|i>>>
      and <math|v<rsub|i>=v<rsub|i><rsup|0>*v<rsub|i><rsup|1>*\<ldots\>*v<rsub|i><rsup|k<rsub|i>>>.
      From the above follows that <math|<wide|u|\<vect\>>> and
      <math|<wide|v|\<vect\>>> are accepted by <math|<A><rsub|1>> and
      <math|<A><rsub|2>>, respectively. Then
      <math|<wide|w|\<vect\>>\<in\><around|(|M<rsub|1>\<cdot\>M<rsub|2>|)><rsup|B>>.

      Conversely, a sequence in <math|<around|(|M<rsub|1>\<cdot\>M<rsub|2>|)><rsup|B>>
      is clearly accepted by <math|<A>>. Hence <math|<A>> recognizes
      <math|<around|(|M<rsub|1>\<cdot\>M<rsub|2>|)><rsup|B>>.
    </itemize>

    We now prove that all star-free <math|\<omega\>*B>-regular expressions
    are recognized by a non-deterministic finitary Bchi automaton. Since
    <math|<NFB>> are closed under finite union
    (Theorem<nbsp><reference|closure>), we only need to consider expressions
    <math|L\<cdot\>M<rsup|\<omega\>>>, where <math|L\<subseteq\><Sigstar>> is
    regular language of finite words and <math|M> star-free <math|B>-regular
    expression. The constructions above ensure that there exists
    <math|<A><rsub|M>=<around|(|Q<rsub|M>,\<Sigma\>,\<delta\><rsub|M>,Q<rsub|M><rsup|0>,F<rsub|M>|)>>,
    a non-deterministic finitary Bchi automaton that recognizes the language
    <math|M<rsup|B>> of infinite sequences. Let
    <math|<A><rsub|L>=<around|(|Q<rsub|L>,\<Sigma\>,\<delta\><rsub|L>,Q<rsub|L><rsup|0>,F<rsub|L>|)>>
    be a finite automaton over finite words that recognizes <math|L>. We
    construct a non-deterministic finitary Bchi automaton as follows:
    <math|<A>=<around|(|Q<rsub|L>\<cup\>Q<rsub|M>,\<Sigma\>,\<delta\>,Q<rsup|0><rsub|L>,F<rsub|M>|)>>
    where <math|\<delta\>=\<delta\><rsub|L>\<cup\>\<delta\><rsub|M>\<cup\>>.
    In other words, first <math|<A>> simulates <math|<A><rsub|L>>, and when a
    finite prefix is recognized by <math|<A><rsub|L>>, then <math|<A>> turns
    to <math|<A><rsub|M>> and simulates it.

    We argue that <math|<A>> recognizes <math|L\<cdot\>M<rsup|\<omega\>>>.
    Let <math|w> accepted by <math|<A>>, and <math|u> the finite prefix read
    by <math|<A><rsub|L>>, <math|w=u\<cdot\>v>. From <math|v> infinite word,
    we define <math|<wide|v|\<vect\>>> an infinite sequence of finite words
    by sequencing <math|v> each time a final state (i.e., from
    <math|F<rsub|L>>) is visited. The sequence <math|<wide|v|\<vect\>>> is
    accepted by <math|<A><rsub|M>>, hence belongs to <math|M<rsup|B>>, and
    since <math|<wide|v|\<vect\>><rsup|\<omega\>>=v>, we have
    <math|v\<in\><around|(|M<rsup|B>|)><rsup|\<omega\>>=M<rsup|\<omega\>>>,
    and finally <math|w\<in\>L\<cdot\>M<rsup|\<omega\>>>. Conversely, let
    <math|w=u\<cdot\><wide|v|\<vect\>><rsup|\<omega\>>>, where
    <math|u\<in\>L> and <math|<wide|v|\<vect\>>\<in\>M<rsup|B>>. Let
    <math|q<rsub|0>\<in\>Q<rsub|L><rsup|0>,q\<in\>F<rsub|L>> such that
    <math|q<rsub|0><long-arrow|\<rubber-rightarrow\>|u>q>. Let
    <math|q<rprime|'>\<in\>Q<rsub|0>,q<rsub|1>,q<rsub|2>,\<ldots\>\<in\>F<rsub|L>>,
    such that for all <math|i\<in\><N>> we have
    <math|q<rsub|i><long-arrow|\<rubber-rightarrow\>|v<rsub|i>>q<rsub|i+1>>.
    The <em|key>, yet simple observation is that for all star-free
    <math|B>-regular expressions <math|M> and for all
    <math|<wide|v|\<vect\>>\<in\>M> we have
    <math|<around|(|<around|\||v<rsub|n>|\|>|)><rsub|n>> is bounded. This is
    straightforward by induction on <math|M>. Hence, from position
    <math|<around|\||u|\|>>, the set <math|F<rsub|L>> is visited infinitely
    many times, and there is a bound between two consecutive visits. Thus
    <math|w> is accepted by <math|<A>>. <htab|0pt><qed>
  </proof>

  The following theorem follows from Lemma<nbsp><reference|lemm> and
  Lemma<nbsp><reference|lemm>.

  <\theorem>
    <label|starfree><math|<NFB>> has exactly the same expressive power as
    star-free <math|\<omega\>*B>-regular expressions.
  </theorem>

  <section|Decision Problems>

  In this section we consider the complexity of the decision problems for
  finitary languages. We present the results for finitary Bchi automata for
  simplicity, but the arguments for finitary parity and Streett automata are
  similar.

  For the proofs of the results of this section we need to consider co-Bchi
  conditions (dual of Bchi conditions): given a set <math|F>, it requires
  that elements that appear infinitely often are outside <math|F>, in other
  words, elements in <math|F> appear only finitely often. It maybe noted that
  co-Bchi and finitary co-Bchi conditions coincide. We will also consider
  co-finitary Bchi condition, that is the complement of a finitary Bchi
  condition: given a set <math|F> co-finitary Bchi condition for <math|F> is
  the complement of <math|<fbucf>>, that is <math|<So>\<setminus\><fbucf>>.

  <\lemma>
    <label|lem-decision>Let <math|<A>=<around|(|Q,\<Sigma\>,Q<rsub|0>,\<delta\><rsub|,>*F<rsub|b>,F<rsub|c>|)>>
    be an automaton with <math|F<rsub|b>> and <math|F<rsub|c>> are subsets of
    <math|Q>. Consider the acceptance condition <math|\<Phi\><rsub|1>> as the
    conjunction of the finitary Bchi condition with set <math|F<rsub|b>>,
    and the co-finitary Bchi condition with set <math|F<rsub|c>>; and the
    acceptance condition <math|\<Phi\><rsub|2>> as the conjunction of Bchi
    condition with set <math|F<rsub|b>>, and the co-Bchi condition with set
    <math|F<rsub|c>>. The following assertions hold:

    <\enumerate>
      <item>The answer of the emptiness problem of <math|<A>> for
      <math|\<Phi\><rsub|2>> is Yes iff there is a cycle <math|C> in
      <math|<A>> such that <math|C\<cap\>F<rsub|b>\<neq\>\<emptyset\>> and
      <math|C\<cap\>F<rsub|c>=\<emptyset\>>.

      <item>The answer of the emptiness problem for <math|\<Phi\><rsub|1>>
      and <math|\<Phi\><rsub|2>> coincide.

      <item>The emptiness problem for <math|\<Phi\><rsub|1>> is decidable in
      <math|<NLOGSPACE>>.
    </enumerate>
  </lemma>

  <\proof>
    We prove the results as follows.

    <\enumerate>
      <item>We first prove parts 1. and 2. Without loss of generality we
      assume that for all <math|q\<in\>Q>, there exists a path from an
      initial state <math|q<rsub|0>\<in\>Q> to <math|q> (otherwise we can
      delete <math|q>). If there is a cycle <math|C> with
      <math|C\<cap\>F<rsub|b>\<neq\>\<emptyset\>> and
      <math|C\<cap\>F<rsub|c>=\<emptyset\>>, then consider a finite word
      <math|u> to reach <math|C>, and a word <math|v> that execute <math|C>.
      The word <math|u\<cdot\>v<rsup|\<omega\>>> is a witness that <math|<A>>
      with <math|\<Phi\><rsub|1>> as well as <math|\<Phi\><rsub|2>> is
      non-empty. Conversely, the condition <math|\<Phi\><rsub|2>> is a Rabin
      1-pair condition, and by existence of memoryless strategies for Rabin
      condition<nbsp><cite|EJ88-FOCS>, it follows that if <math|<A>> is
      non-empty for <math|\<Phi\><rsub|2>>, then there must be a cycle
      <math|C> in <math|<A>> such that <math|C\<cap\>F<rsub|b>\<neq\>\<emptyset\>>
      and <math|C\<cap\>F<rsub|c>=\<emptyset\>>. The condition
      <math|\<Phi\><rsub|1>> can be specified as a finitary parity condition
      with three priorities (<math|1,2,3>) by assigning priority<nbsp>1 to
      states in <math|F<rsub|c>>, <math|2> to states in
      <math|F<rsub|b>\<setminus\>F<rsub|c>>, and <math|3> to the rest. By
      existence of memoryless strategies for finitary parity
      objectives<nbsp><cite|CHH09-ToCL>, it follows that if <math|<A>> is
      non-empty for <math|\<Phi\><rsub|1>>, then there must be a cycle
      <math|C> in <math|<A>> such that <math|C\<cap\>F<rsub|b>\<neq\>\<emptyset\>>
      and <math|C\<cap\>F<rsub|c>=\<emptyset\>>. The result follows.

      <item>The result follows from the emptiness problem of
      non-deterministic Rabin 1-pair automata. The basic idea of the proof is
      as follows: we show that the witness cycle <math|C> can be guessed and
      verified in logarithmic space. The guesses are as follows: (a)<nbsp>
      first the initial prefix of the path to <math|C> is guessed by guessing
      one state (the next state) at a time (hence only one guess is made at a
      time which is logarithmic space), (b)<nbsp>then the starting state of
      the cycle <math|C> is guessed and stored (again in logarithmic space),
      and (c)<nbsp>the cycle is guessed by again considering one state at a
      time and at each step it is verified that the state generated is in
      <math|Q\<setminus\>F<rsub|c>>; (d)<nbsp>one state in the cycle such
      that the state is in <math|F<rsub|b>> is guessed and verified; and
      (e)<nbsp>finally it is checked that the cycle is completed by visiting
      the starting state of the cycle. Hence at every step only constantly
      many guesses are made, stored and verified. The <math|<NLOGSPACE>>
      upper bound follows.
    </enumerate>

    The desired result follows. <htab|0pt><qed>
  </proof>

  <\theorem>
    <dueto|Decision problems><label|thrm>The following assertions hold:

    <\enumerate>
      <vspace|-2.5mm>

      <item><em|(Emptiness).> Given a finitary Bchi automaton <math|<A>>,
      whether <math|<LA>=\<emptyset\>> is <math|<NLOGSPACE>>-complete and can
      be decided in linear time.

      <item><em|(Universality).> Given a finitary Bchi automaton <math|<A>>
      whether <math|<LA>=\<Sigma\><rsup|\<omega\>>> is
      <math|<PSPACE>>-complete.

      <item><em|(Language inclusion).> Given two finitary Bchi automata
      <math|<A>> and <math|<B>>, whether <math|<LA>\<subseteq\><LB>> is
      <math|<PSPACE>>-complete.
    </enumerate>
  </theorem>

  <\proof>
    We show the three parts of the proof.

    <\enumerate>
      <item>The <math|<NLOGSPACE>> upper bound follows from
      Lemma<nbsp><reference|lem-decision>: we consider the special case where
      the set <math|F<rsub|c>> is empty. The <math|<NLOGSPACE>> lower bound
      follows from <math|<NLOGSPACE>>-hardness of reachability problem in a
      directed graph: given <math|s> and <math|t> two vertices, is there a
      path from <math|s> to <math|t>? Given a directed graph and <math|s,t>
      two vertices, the corresponding automaton has <math|s> as initial
      vertex, <math|t> as unique final vertex, and we add a self-loop over
      <math|t>. Then there is a path from <math|s> to <math|t> if and only if
      the language accepted by this finitary Bchi automaton is non-empty.
      This concludes since co-<math|<NLOGSPACE>=<NLOGSPACE>>.

      <item>The <math|<PSPACE>> upper bound will follow from the following
      <math|<PSPACE>> upper bound for language inclusion, item 3. The
      <math|<PSPACE>> lower bound follows from the <math|<PSPACE>> lower
      bound for finite automata. The universality problem for automata over
      finite words is <math|<PSPACE>>-hard even when all the accepting states
      are absorbing<nbsp><cite|MeySto72>. For such automata over finite words
      the acceptance is the same as for finitary Bchi condition. The result
      follows.

      <item>The <math|<PSPACE>> lower bound follows from item 2. by the
      <math|<PSPACE>>-hardness for universality. We now present the
      <math|<PSPACE>> upper bound. Let <math|<A>=<around|(|Q<rsub|A>,\<Sigma\>,Q<rsub|A,0>,\<delta\><rsub|A>,F<rsub|A>|)>>
      and <math|<B>=<around|(|Q<rsub|B>,\<Sigma\>,Q<rsub|B,0>,\<delta\><rsub|B>,F<rsub|B>|)>>
      be two finitary Bchi automata. Let
      <math|<A>\<times\><wide|<B>|\<bar\>>=<around|(|Q<rsub|A>\<times\>2<rsup|Q<rsub|B>>,\<Sigma\>,<around|(|Q<rsub|A,0>,Q<rsub|B,0>|)>,\<delta\>,F<rsub|b>,F<rsub|c>|)>>
      be an automaton where for all <math|s\<in\>Q<rsub|A>,S\<subseteq\>Q<rsub|B>>
      and <math|\<sigma\>\<in\>\<Sigma\>>,

      <\equation*>
        \<delta\><around|(|<around|(|s,S|)>,\<sigma\>|)>=<big|cup><rsub|q\<in\>S>
      </equation*>

      and <math|F<rsub|b>=> and <math|F<rsub|c>=>. In other words
      <math|<A>\<times\><wide|<B>|\<bar\>>> is synchronous product of
      <math|<A>> and the power set (subset construction) of <math|<B>>. The
      acceptance condition is the conjunction of the finitary Bchi condition
      with set <math|F<rsub|b>> and co-finitary Bchi condition with set
      <math|F<rsub|c>>.

      We claim that <math|<La><around|(|<A>\<times\><wide|<B>|\<bar\>>|)>=\<emptyset\>>
      iff <math|<LA>\<subseteq\><LB>>.

      Assume <math|<La><around|(|<A>\<times\><wide|<B>|\<bar\>>|)>\<neq\>\<emptyset\>>,
      then there is a cycle <math|C> such that
      <math|C\<cap\>F<rsub|b>\<neq\>\<emptyset\>> and
      <math|C\<cap\>F<rsub|c>=\<emptyset\>>. The lasso word that executes the
      finite path to reach <math|C> and then execute it forever is a witness
      word that is accepted by <math|<A>> but not by <math|<B>>. Hence
      <math|<LA>\<nsubseteq\><LB>>.

      Assume <math|<La><around|(|<A>\<times\><wide|<B>|\<bar\>>|)>=\<emptyset\>>,
      then every words accepted by <math|<A>> is not accepted by
      <math|<wide|<B>|\<bar\>>>, hence accepted by <math|<B>>. Thus
      <math|<LA>\<subseteq\><LB>>.

      Since the construction is exponential and the non-emptiness problem can
      be decided in <math|<NLOGSPACE>> (Lemma<nbsp><reference|lem-decision>),
      we obtain a <math|<NPSPACE>=<PSPACE>> upper bound.
    </enumerate>

    The result follows. <htab|0pt><qed>
  </proof>

  <vspace|1fn>

  <no-indent><with|font-series|bold|Acknowledgements.> We thank Thomas
  Colcombet for explaining to us results related to
  <math|\<omega\>*B>-automata.

  <\bibliography|bib|plain|people,short,papers>
    <bib-list|[99]|>
  </bibliography>
</body>