<TeXmacs|1.99.7>

<style|<tuple|ieeetran|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|definition|Definition>

    <new-theorem|proposition|Proposition>

    <new-theorem|corollary|Corollary>

    <new-theorem|assumption|Assumption>

    <new-theorem|lemma|Lemma>

    <new-theorem|theorem|Theorem>

    <new-theorem|remark|Remark>
  </hide-preamble>

  <doc-data|<doc-title|The Theory of Intervention Games for Resource Sharing
  in Wireless Communications>|<doc-author|<author-data|<author-misc|The
  authors are with Electrical Engineering Department, University of
  California, Los Angeles (UCLA), 420 Westwood Plaza, Los Angeles, CA
  90095-1594, USA. e-mail: {jaeok, mihaela}@ee.ucla.edu.>|<author-name|Jaeok
  Park and Mihaela van der Schaar>>>|<doc-date|>>

  <abstract-data|<\abstract>
    This paper develops a game-theoretic framework for the design and
    analysis of a new class of incentive schemes called intervention schemes.
    We formulate intervention games, propose a solution concept of
    intervention equilibrium, and prove its existence in a finite
    intervention game. We apply our framework to resource sharing scenarios
    in wireless communications, whose non-cooperative outcomes without
    intervention yield suboptimal performance. We derive analytical results
    and analyze illustrative examples in the cases of imperfect and perfect
    monitoring. In the case of imperfect monitoring, intervention schemes can
    improve the suboptimal performance of non-cooperative equilibrium when
    the intervention device has a sufficiently accurate monitoring
    technology, although it is impossible to achieve the best feasible
    performance. In the case of perfect monitoring, the best feasible
    performance can be obtained with an intervention scheme when the
    intervention device has a sufficiently strong intervention capability.
  </abstract>|<abstract-keywords| Game theory| incentives| intervention|
  network policing| resource sharing| wireless communications.>>

  <section|Introduction>

  When self-interested users share resources non-cooperatively, it is common
  that the resources are utilized suboptimally from a global point of view
  <cite|Hardin>, <cite|Dubey>. Hence, overcoming the suboptimal performance
  of non-cooperative outcomes poses an important challenge for resource
  management. The aforementioned phenomenon is widely observed in wireless
  communications, where users compete for radio resources interfering with
  each other. For the sake of discussion, consider the following abstract
  scenario of resource sharing in wireless communications. First, users
  determine their resource usage levels, which in turn determine the service
  quality they receive. In general, as the overall usage level increases, the
  service quality is reduced due to interference or congestion. The payoff of
  a user is determined by its own usage level as well as the service quality.
  In such a scenario, users tend to choose a higher usage level than socially
  optimal one. That is, it is in the self-interest of users to choose a high
  usage level, although reducing their usage levels simultaneously would
  benefit all of them. In game theory, such a conflict between private and
  social interests is modeled as the prisoner's dilemma game. In the
  literature, it has been shown that various wireless communication scenarios
  exhibit a prisoner's dilemma phenomenon, including packet forwarding
  <cite|hubaux>, distributed spectrum allocation <cite|laufer>, and medium
  access control (CSMA/CA <cite|Cagalj> and slotted Aloha <cite|ma>).

  Incentive schemes are needed to improve upon the suboptimal performance of
  non-cooperative equilibrium and achieve a better performance. In this
  paper, we propose a class of incentive schemes based on the idea of
  intervention <cite|jpark>. Implementing an intervention scheme requires an
  intervention device that is able to monitor the actions of users and to
  affect their resource usage. A resource manager first chooses an
  intervention rule used by the intervention device, and then users choose
  their actions knowing the intervention rule chosen by the manager. After
  observing a signal about the actions of users, the intervention device
  chooses its action according to the intervention rule. The manager chooses
  an intervention rule to maximize his payoff, anticipating the rational
  behavior of users given the intervention rule. The payoff of the manager
  can be considered as a measure of the system performance, which can
  incorporate various efficiency and fairness criteria. We formulate the
  interaction between users and a manager as an intervention game and propose
  a solution concept called intervention equilibrium. Intervention
  equilibrium predicts the outcome of an intervention game in terms of an
  intervention rule chosen by the manager and an operating point chosen by
  users.

  Intervention can be classified into two types, called type 1 and type 2,
  depending on how the intervention device acts in the system relative to
  users. In type-1 intervention, the intervention device acts in a symmetric
  way as users do while having with an ability to monitor the actions of
  other users. An example of type-1 intervention can be found in
  <cite|jpark>, which considers a random access network where an intervention
  device interferes with other users by transmitting its packets after
  observing the transmission probabilities of users. In type-2 intervention,
  the intervention device acts as a gatekeeper that can control resource
  usage by users. An example of type-2 intervention can be found in
  <cite|garg>, which analyzes scheduling mechanisms where a scheduler
  (intervention device) assigns different priorities to traffic flows
  depending on their input rates. The two types of intervention can be
  applied to the aforementioned resource sharing scenario, as schematically
  shown in Fig.<nbsp><reference|fig:resource>. In the course of discussion in
  this paper, we use two examples of intervention schemes in resource
  sharing. In Section<nbsp><reference|sec:ex1>, we analyze an example of
  type-2 intervention, where the service quality is determined randomly given
  the usage levels of users. The intervention device observes the service
  quality and then determines the probability of intervention, which degrades
  the quality provided to the users. In Section<nbsp><reference|sec:ex2>, we
  discuss an example of type-1 intervention, where the service quality is
  determined deterministically as a function of the total usage level. The
  intervention device observes the usage levels of users and then chooses its
  own usage level, thereby affecting the quality received by users.

  The goal of intervention schemes to improve the suboptimal performance of
  non-cooperative equilibrium and to achieve a better performance is
  illustrated in Fig.<nbsp><reference|fig:twouser> with two users and system
  performance defined by the average payoff of the two users. Our analysis is
  aimed at answering the following two questions.

  <\enumerate>
    <item>When can we construct an intervention scheme that improves the
    suboptimal performance of non-cooperative equilibrium?

    <item>When can we construct an intervention scheme that achieves the best
    feasible performance?
  </enumerate>

  Our analysis suggests that the answers to these questions depend on the
  ability of the intervention device:

  <\itemize>
    <item>Ability to monitor the actions of users (i.e., monitoring
    technology),

    <item>Ability to affect the payoffs of users through its actions (i.e.,
    intervention capability).
  </itemize>

  The discussion on the example in Section<nbsp><reference|sec:ex1> shows
  that an intervention scheme can improve the performance of non-cooperative
  equilibrium when the monitoring technology is sufficiently accurate. This
  result is reinforced by the analytical results and the example in
  Section<nbsp><reference|sec:permon>, which considers the case of perfect
  monitoring. The analytical result in Section<nbsp><reference|sec:impmon>
  shows that intervention schemes cannot achieve the best feasible
  performance when the monitoring technology is noisy. On the other hand, the
  analytical results and the example in Section<nbsp><reference|sec:permon>
  show that intervention schemes can achieve the best feasible performance
  when monitoring is perfect and the intervention device has a sufficiently
  strong intervention capability. When signals are noisy, the manager can
  provide incentives by triggering a punishment following signals that are
  more likely to occur when users deviate. When these signals occur with
  positive probability even when users do not deviate, punishment happens
  from time to time on the equilibrium path, which results in a performance
  loss. On the contrary, when signals are perfectly accurate, punishment
  through intervention can be used only as a threat, which is never used on
  the equilibrium path. Thus, in the case of perfect monitoring, the manager
  can achieve a desired operating point without incurring a performance loss.

  We briefly discuss the advantages of using intervention schemes over other
  forms of incentive schemes, pricing schemes <cite|basar> and incentive
  schemes based on repeated game strategies <cite|La>. Intervention affects
  the payoffs of users by directly influencing their resource usage, whereas
  pricing does so by using an outside instrument, money. Thus, intervention
  schemes can be implemented more robustly in that users cannot avoid
  intervention as long as they use resources. In order to achieve a desired
  outcome through an incentive scheme, the manager needs to know the impact
  of the incentive device on the payoffs of users. Since intervention affects
  the payoffs of users through physical quantities associated with resource
  usage (e.g., throughput, delay), which are easily measurable, this
  information is easier to obtain when the manager uses an intervention
  scheme than a pricing scheme. Implementing an incentive scheme based on a
  repeated game strategy requires long-term relationship among interacting
  users, which may not exist especially in mobile wireless networks.
  Intervention schemes do not require long-term relationship among users,
  which makes them applicable to systems with a dynamically changing user
  population.

  The hierarchical structure in the interaction between the manager and users
  has been modeled as a Stackelberg game in <cite|ma>, <cite|korilis>, and
  <cite|yisu2>. In these works, the manager takes an action before users do,
  whereas in intervention schemes, the manager specifies a complete
  contingent plan for actions to be taken given the observed actions of
  users. This adaptivity of intervention schemes is especially helpful when
  the manager does not have a selfish motive. By creating interference with
  users only when a deviation is observed or when a signal that is suggestive
  of a deviation is realized, the manager can achieve a desired operating
  point while incurring no or little performance loss.

  The rest of this paper is organized as follows. In
  Section<nbsp><reference|sec:formulation>, we formulate intervention games,
  develop a solution concept of intervention equilibrium, and show its
  existence in a finite intervention game. In
  Sections<nbsp><reference|sec:noisy> and <reference|sec:permon>, we derive
  analytical results and discuss illustrative examples in the cases of
  imperfect and perfect monitoring, respectively. In
  Section<nbsp><reference|sec:conclusion>, we conclude.

  <section|Intervention Games and Intervention
  Equilibrium><label|sec:formulation>

  We consider a system (e.g., wireless network) where <math|N> users and an
  intervention device interact. The set of the users is denoted by
  <math|\<cal-N\>=<around|{|1,\<ldots\>,N|}>>. The action space of user
  <math|i> is denoted by <math|A<rsub|i>>, and a pure action for user
  <math|i> is denoted by <math|a<rsub|i>\<in\>A<rsub|i>>, for all
  <math|i\<in\>\<cal-N\>>. A pure action profile is represented by a vector
  <math|a=<around|(|a<rsub|1>,\<ldots\>,a<rsub|N>|)>\<in\>A\<triangleq\><big|prod><rsub|i\<in\>\<cal-N\>>A<rsub|i>>.
  A mixed action for user <math|i> is a probability distribution over
  <math|A<rsub|i>> and is denoted by <math|\<alpha\><rsub|i>\<in\>\<Delta\><around|(|A<rsub|i>|)>>,
  where <math|\<Delta\><around|(|A<rsub|i>|)>> is the set of all probability
  distributions over <math|A<rsub|i>>. A mixed action profile is represented
  by a vector <math|<with|math-font-family|bf|\<alpha\>>=<around|(|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|N>|)>\<in\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>>.
  A mixed action profile of the users other than user<nbsp><math|i> is
  written as <math|\<alpha\><rsub|-i>=<around|(|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|i-1>,\<alpha\><rsub|i+1>,\<ldots\>,\<alpha\><rsub|N>|)>>
  so that <math|\<alpha\>> can be expressed as
  <math|\<alpha\>=<around|(|\<alpha\><rsub|i>,\<alpha\><rsub|-i>|)>>. Once a
  pure action profile of the users is determined, a signal is realized from
  the set of all possible signals, denoted <math|Y>, and is observed by the
  intervention device. The probability distribution of signals for a given
  pure action profile is denoted by <math|\<rho\>:A\<rightarrow\>\<Delta\><around|(|Y|)>>.
  If <math|Y> is finite, the probability that a signal <math|y\<in\>Y> is
  realized given a pure action profile <math|a\<in\>A> is denoted by
  <math|\<rho\><around|(|y\|a|)>>. After observing the realized signal, the
  intervention device takes its action. We use <math|a<rsub|0>>,
  <math|\<alpha\><rsub|0>>, and <math|A<rsub|0>> to denote a pure action, a
  mixed action, and the set of pure actions for the intervention device,
  respectively.

  Since the intervention device chooses its action after observing the
  signal, a strategy for it can be represented by a mapping
  <math|f:Y\<rightarrow\>\<Delta\><around|(|A<rsub|0>|)>>, which is called an
  <em|intervention rule>. The set of all possible intervention rules is
  denoted by <math|\<cal-F\>>. If <math|A<rsub|0>> is finite, the probability
  that the intervention device takes an action <math|a<rsub|0>> when a signal
  <math|y> is realized is denoted by <math|f<around|(|a<rsub|0>\|y|)>>. There
  is a system manager who determines the intervention rule used by the
  intervention device. We assume that the manager can commit to an
  intervention rule, for example, by using a protocol embedded in the
  intervention device. The payoff of user <math|i\<in\>\<cal-N\>> is
  determined by its own action, the realized signal, and the action of the
  intervention device. Thus, we denote the payoff function of user <math|i>
  by <math|u<rsub|i>:A<rsub|0>\<times\>A<rsub|i>\<times\>Y\<rightarrow\>\<bbb-R\>>.
  The payoff of the manager depends on the actions of the intervention device
  and the users and the realized signal, and the payoff function of the
  manager is denoted by <math|u<rsub|0>:A<rsub|0>\<times\>A\<times\>Y\<rightarrow\>\<bbb-R\>>.<footnote|Alternatively,
  we can have <math|u<rsub|i>> and <math|u<rsub|0>> as functions of
  <math|<around|(|a<rsub|0>,a|)>> and have <math|y> as an exogenous signal on
  <math|a> that the intervention device obtains. Our analysis applies to this
  alternative formulation as well.> We call the pair
  <math|<around|(|Y,\<rho\>|)>> the <em|monitoring technology> of the
  intervention device, and <math|A<rsub|0>> its <em|intervention capability>.
  The ability of the intervention device to influence the system outcome is
  represented by these two elements.

  The game played by the manager and the users is formulated as an
  <em|intervention game>, which is summarized by the data

  <align*|<tformat|<table|<row|<cell|\<Gamma\>=<around*|\<langle\>|\<cal-N\><rsub|0>,<around|(|A<rsub|i>|)><rsub|i\<in\>\<cal-N\><rsub|0>>,<around|(|u<rsub|i>|)><rsub|i\<in\>\<cal-N\><rsub|0>>,<around|(|Y,\<rho\>|)>|\<rangle\>>,>>>>>

  where <math|\<cal-N\><rsub|0>\<triangleq\>\<cal-N\>\<cup\><around|{|0|}>>.
  The sequence of events in an intervention game can be listed as follows.

  <\enumerate>
    <item>The manager chooses an intervention rule <math|f\<in\>\<cal-F\>>.

    <item>The users choose their actions <math|<with|math-font-family|bf|\<alpha\>>\<in\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>>
    simultaneously, knowing the intervention rule <math|f> chosen by the
    manager.

    <item>A pure action profile <math|a> is realized following the
    probability distribution <math|\<alpha\>>, and a signal <math|y\<in\>Y>
    is realized following the probability distribution
    <math|\<rho\><around|(|a|)>>.

    <item>The intervention device chooses its action
    <math|a<rsub|0>\<in\>A<rsub|0>> following the probability distribution
    <math|f<around|(|y|)>>.
  </enumerate>

  Ex ante payoffs can be computed by taking expectations over signals and
  pure actions. The ex ante payoff function of user <math|i> is denoted by a
  function <math|v<rsub|i>:\<cal-F\>\<times\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>\<rightarrow\>\<bbb-R\>>,
  while that of the manager is denoted by
  <math|v<rsub|0>:\<cal-F\>\<times\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>\<rightarrow\>\<bbb-R\>>.
  We say that an intervention game is <em|finite> if
  <math|\<cal-N\><rsub|0>>, <math|A<rsub|i>>, for
  <math|i\<in\>\<cal-N\><rsub|0>>, and <math|Y> are all finite. In a finite
  intervention game, ex ante payoffs can be computed as

  <align*|<tformat|<table|<row|<cell|v<rsub|i><around|(|f,\<alpha\>|)>=<big|sum><rsub|a\<in\>A><big|sum><rsub|y\<in\>Y><big|sum><rsub|a<rsub|0>\<in\>A<rsub|0>>u<rsub|i><around|(|a<rsub|0>,a<rsub|i>,y|)>*f<around|(|a<rsub|0>\|y|)>*\<rho\><around|(|y\|a|)>*\<alpha\><around|(|a|)>,>>>>>

  for <math|i\<in\>\<cal-N\>>, where <math|\<alpha\><around|(|a|)>> is the
  probability that <math|a> is played under <math|\<alpha\>>, and

  <align*|<tformat|<table|<row|<cell|v<rsub|0><around|(|f,\<alpha\>|)>=<big|sum><rsub|a\<in\>A><big|sum><rsub|y\<in\>Y><big|sum><rsub|a<rsub|0>\<in\>A<rsub|0>>u<rsub|0><around|(|a<rsub|0>,a,y|)>*f<around|(|a<rsub|0>\|y|)>*\<rho\><around|(|y\|a|)>*\<alpha\><around|(|a|)>.>>>>>

  Once the manager chooses an intervention rule <math|f>, the users play a
  simultaneous game, whose normal form representation is given by

  <align*|<tformat|<table|<row|<cell|\<Gamma\><rsub|f>=<around*|\<langle\>|\<cal-N\>,<around|(|A<rsub|i>|)><rsub|i\<in\>\<cal-N\>>,(v<rsub|i>*<around*|(|f,\<cdot\><around|)||)><rsub|i\<in\>\<cal-N\>>|\<rangle\>>.|\<nobracket\>>>>>>>

  We predict actions chosen by the users given an intervention rule <math|f>
  by applying the solution concept of Nash equilibrium <cite|fudenberg> to
  the induced game <math|\<Gamma\><rsub|f>>.

  <\definition>
    An intervention rule <math|f\<in\>\<cal-F\>> <em|sustains> an action
    profile <math|\<alpha\><rsup|\<ast\>>\<in\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>>
    if <math|\<alpha\><rsup|\<ast\>>> is a Nash equilibrium of the game
    <math|\<Gamma\><rsub|f>>, i.e.,

    <align*|<tformat|<table|<row|<cell|v<rsub|i><around|(|f,\<alpha\><rsub|i><rsup|\<ast\>>,\<alpha\><rsub|-i><rsup|\<ast\>>|)>\<geq\>v<rsub|i><around|(|f,\<alpha\><rsub|i>,\<alpha\><rsub|-i><rsup|\<ast\>>|)>*<space|1em><text|for
    all <math|\<alpha\><rsub|i>\<in\>\<Delta\><around|(|A<rsub|i>|)>>, for
    all >i\<in\>\<cal-N\>.>>>>>

    An action profile <math|\<alpha\><rsup|\<ast\>>> is <em|sustainable> if
    there exists an intervention rule <math|f> that sustains
    <math|\<alpha\><rsup|\<ast\>>>.
  </definition>

  Let <math|\<cal-E\><around|(|f|)>\<subseteq\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>>
  be the set of action profiles sustained by <math|f>. We say that a pair
  <math|<around|(|f,\<alpha\>|)>> is attainable if
  <math|\<alpha\>\<in\>\<cal-E\><around|(|f|)>>. The manager's problem is to
  find an attainable pair that maximizes his ex ante payoff among all
  attainable pairs, which leads to the following solution concept for
  intervention games.

  <\definition>
    <label|def:ie><math|<around|(|f<rsup|\<ast\>>,\<alpha\><rsup|\<ast\>>|)>\<in\>\<cal-F\>\<times\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>>
    is an <em|intervention equilibrium> if
    <math|\<alpha\><rsup|\<ast\>>\<in\>\<cal-E\><around|(|f<rsup|\<ast\>>|)>>
    and

    <align*|<tformat|<table|<row|<cell|v<rsub|0><around|(|f<rsup|\<ast\>>,\<alpha\><rsup|\<ast\>>|)>\<geq\>v<rsub|0><around|(|f,\<alpha\>|)><space|1em><text|for
    all <math|<around|(|f,\<alpha\>|)>> such that
    <math|\<alpha\>\<in\>\<cal-E\><around|(|f|)>>.>>>>>>

    <math|f<rsup|\<ast\>>\<in\>\<cal-F\>> is an <em|optimal intervention
    rule> if there exists an action profile
    <math|\<alpha\><rsup|\<ast\>>\<in\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>>
    such that <math|<around|(|f<rsup|\<ast\>>,\<alpha\><rsup|\<ast\>>|)>> is
    an intervention equilibrium.
  </definition>

  An intervention equilibrium solves the following optimization problem:

  <align|<tformat|<table|<row|<cell|<label|eq:optint>max<rsub|f\<in\>\<cal-F\>>
  max<rsub|\<alpha\>\<in\>\<cal-E\><around|(|f|)>>
  v<rsub|0><around|(|f,\<alpha\>|)>.>>>>>

  An intervention equilibrium can be considered as a subgame perfect
  equilibrium (or Stackelberg equilibrium), with an implicit assumption that
  the manager can induce the users to choose the best Nash equilibrium for
  him in case of multiple Nash equilibria. Our interpretation is that if the
  manager specifies an intervention equilibrium
  <math|<around|(|f<rsup|\<ast\>>,\<alpha\><rsup|\<ast\>>|)>> to the users
  then <math|\<alpha\><rsup|\<ast\>>> becomes a self-enforcing operating
  point for them. In other words, the manager can make
  <math|\<alpha\><rsup|\<ast\>>> a focal point <cite|fudenberg> of the game
  <math|\<Gamma\><rsub|f<rsup|\<ast\>>>> by recommending it to the users.

  We can represent an <em|intervention scheme> formally by
  <math|<around|{|<around|(|Y,\<rho\>|)>,A<rsub|0>,f|}>>. In this paper, we
  focus on the problem of finding an optimal intervention rule given the
  monitoring technology and intervention capability of the intervention
  device. However, our design problem can be generalized so that the design
  choice includes <math|<around|(|Y,\<rho\>|)>> and <math|A<rsub|0>>. Let
  <math|v<rsub|0><rsup|\<ast\>><around|(|<around|(|Y,\<rho\>|)>,A<rsub|0>|)>>
  be the optimal value of the problem <eqref|eq:optint> given
  <math|<around|(|Y,\<rho\>|)>> and <math|A<rsub|0>>. Also, let
  <math|C<around|(|<around|(|Y,\<rho\>|)>,A<rsub|0>|)>> be the cost of
  implementing an intervention device with <math|<around|(|Y,\<rho\>|)>> and
  <math|A<rsub|0>>. Then an optimal intervention scheme can be considered as
  a solution to <math|max v<rsub|0><rsup|\<ast\>><around|(|<around|(|Y,\<rho\>|)>,A<rsub|0>|)>-C<around|(|<around|(|Y,\<rho\>|)>,A<rsub|0>|)>>.

  Below we show the existence of an intervention equilibrium.

  <\proposition>
    <label|prop:existence>Every finite intervention game has an intervention
    equilibrium.
  </proposition>

  We prove Proposition<nbsp><reference|prop:existence> using the following
  two lemmas.

  <\lemma>
    <label|lemma:euhc>The correspondence <math|\<cal-E\>:\<cal-F\>\<rightrightarrows\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>>
    is nonempty, compact-valued, and upper hemi-continuous.
  </lemma>

  <\IEEEproof>
    \ We can show that, for any <math|f\<in\>\<cal-F\>>, the set
    <math|\<cal-E\><around|(|f|)>> is nonempty by applying Nash Theorem
    <cite|nash> to <math|\<Gamma\><rsub|f>>. Since
    <math|<big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>>
    is bounded, it suffices to show that <math|\<cal-E\>> has a closed graph
    to prove that <math|\<cal-E\>> is compact-valued and upper
    hemi-continuous (u.h.c.) (see Theorem 3.4 of <cite|stokey>). Choose a
    sequence <math|<around|{|<around|(|f<rsup|n>,\<alpha\><rsup|n>|)>|}>>
    with <math|<around|(|f<rsup|n>,\<alpha\><rsup|n>|)>\<rightarrow\><around|(|f,\<alpha\>|)>>
    and <math|\<alpha\><rsup|n>\<in\>\<cal-E\><around|(|f<rsup|n>|)>> for all
    <math|n>. Suppose that <math|\<alpha\>\<nin\>\<cal-E\><around|(|f|)>>.
    Then there exists <math|i\<in\>\<cal-N\>> such that
    <math|\<alpha\><rsub|i>> is not a best response to
    <math|\<alpha\><rsub|-i>> in <math|\<Gamma\><rsub|f>>. Then there exist
    <math|\<epsilon\>\<gtr\>0> and <math|\<alpha\><rprime|'><rsub|i>> such
    that <math|v<rsub|i><around|(|f,\<alpha\><rprime|'><rsub|i>,\<alpha\><rsub|-i>|)>\<gtr\>v<rsub|i><around|(|f,\<alpha\><rsub|i>,\<alpha\><rsub|-i>|)>+3*\<epsilon\>>.
    Since <math|v<rsub|i>> is continuous and
    <math|<around|(|f<rsup|n>,\<alpha\><rsup|n>|)>\<rightarrow\><around|(|f,\<alpha\>|)>>,
    for sufficiently large <math|n> we have

    <align*|<tformat|<table|<row|<cell|v<rsub|i><around|(|f<rsup|n>,\<alpha\><rprime|'><rsub|i>,\<alpha\><rsub|-i><rsup|n>|)>\<gtr\>v<rsub|i><around|(|f,\<alpha\><rprime|'><rsub|i>,\<alpha\><rsub|-i>|)>-\<epsilon\>\<gtr\>v<rsub|i><around|(|f,\<alpha\><rsub|i>,\<alpha\><rsub|-i>|)>+2*\<epsilon\>\<gtr\>v<rsub|i><around|(|f<rsup|n>,\<alpha\><rsub|i><rsup|n>,\<alpha\><rsub|-i><rsup|n>|)>+\<epsilon\>,>>>>>

    which contradicts <math|\<alpha\><rsup|n>\<in\>\<cal-E\><around|(|f<rsup|n>|)>>.
  </IEEEproof>

  Define a function <math|<wide|v|\<check\>><rsub|0>:\<cal-F\>\<rightarrow\>\<bbb-R\>>
  by <math|<wide|v|\<check\>><rsub|0><around|(|f|)>=max<rsub|\<alpha\>\<in\>\<cal-E\><around|(|f|)>>
  v<rsub|0><around|(|f,\<alpha\>|)>>. For each <math|f>,
  <math|\<cal-E\><around|(|f|)>> is nonempty and compact by
  Lemma<nbsp><reference|lemma:euhc> and <math|v<rsub|0>*<around|(|f,\<cdot\>|)>>
  is continuous. Hence, the function <math|<wide|v|\<check\>><rsub|0>> is
  well-defined.

  <\lemma>
    <label|lemma:v0usc>The function <math|<wide|v|\<check\>><rsub|0>> is
    upper semi-continuous.
  </lemma>

  <\IEEEproof>
    \ Let <math|E<around|(|f|)>=<around|{|\<alpha\>\<in\>\<cal-E\><around|(|f|)>:v<rsub|0><around|(|f,\<alpha\>|)>=<wide|v|\<check\>><rsub|0><around|(|f|)>|}>>.
    Note that <math|E<around|(|f|)>> is nonempty for all <math|f>. Fix
    <math|f>, and let <math|<around|{|f<rsup|n>|}>> be any sequence
    converging to <math|f>. Choose <math|\<alpha\><rsup|n>\<in\>E<around|(|f<rsup|n>|)>>,
    for all <math|n>. Let <math|v<rsub|0><rsup|s>=limsup<rsub|n\<rightarrow\>\<infty\>>
    <wide|v|\<check\>><rsub|0><around|(|f<rsup|n>|)>>. Then there exists a
    subsequence <math|<around|{|f<rsup|n<rsub|k>>|}>> such that
    <math|v<rsub|0><rsup|s>=lim v<rsub|0><around|(|f<rsup|n<rsub|k>>,\<alpha\><rsup|n<rsub|k>>|)>>.
    Since <math|\<alpha\><rsup|n>\<in\>\<cal-E\><around|(|f<rsup|n>|)>> and
    <math|\<cal-E\>> is u.h.c., there exists a convergent subsequence of
    <math|<around|{|\<alpha\><rsup|n<rsub|k>>|}>>, called
    <math|<around|{|\<alpha\><rsup|j>|}>>, whose limit point <math|\<alpha\>>
    is in <math|\<cal-E\><around|(|f|)>>. Hence, <math|v<rsub|0><rsup|s>=lim
    v<rsub|0><around|(|f<rsup|j>,\<alpha\><rsup|j>|)>=v<rsub|0><around|(|f,\<alpha\>|)>\<leq\><wide|v|\<check\>><rsub|0><around|(|f|)>>
    since <math|\<alpha\>\<in\>\<cal-E\><around|(|f|)>>.
  </IEEEproof>

  Note that the space of intervention rules, <math|\<cal-F\>>, is equivalent
  to <math|<around|(|\<Delta\><around|(|A<rsub|0>|)>|)><rsup|<around|\||Y|\|>>>,
  which is compact. Therefore, a solution to <math|max<rsub|f\<in\>\<cal-F\>>
  <wide|v|\<check\>><rsub|0><around|(|f|)>> exists, which establishes the
  existence of an intervention equilibrium.

  There can be multiple intervention equilibria, all of which yield the same
  payoff for the manager. We can propose different selection criteria for the
  manager to choose an intervention equilibrium out of multiple ones. For
  example, the discussion on affine intervention rules in
  Section<nbsp><reference|sec:permonanal> is motivated by the robustness of
  performance to mistakes by the users.

  <section|Performance with Intervention under Imperfect
  Monitoring><label|sec:noisy>

  <subsection|Analytical Results><label|sec:impmon>

  In this section, we maintain the following assumption.

  <\assumption>
    <label|ass:tilde>There exists an action for the intervention device
    <math|<wide|a|~><rsub|0>\<in\>A<rsub|0>> that satisfies

    <align*|<tformat|<table|<row|<cell|u<rsub|0><around|(|<wide|a|~><rsub|0>,a,y|)>\<gtr\>u<rsub|0><around|(|a<rsub|0>,a,y|)><space|1em><text|for
    all ><math|a<rsub|0>\<neq\><wide|a|~><rsub|0>>,>>>>>

    for all <math|a\<in\>A> and <math|y\<in\>Y>.
  </assumption>

  Define an intervention rule <math|<wide|f|~>> by
  <math|<wide|f|~><around|(|y|)>=<wide|a|~><rsub|0>> for all <math|y>.
  <math|<wide|a|~><rsub|0>> is the action of the intervention device that is
  most preferred by the manager regardless of the action profile of the users
  and the signal, and <math|<wide|f|~>> is the intervention rule that
  prescribes <math|<wide|a|~><rsub|0>> regardless of the realized signal.

  Let <math|<wide|v|\<bar\>><rsub|0>=sup<rsub|<around|(|f,\<alpha\>|)>>
  v<rsub|0><around|(|f,\<alpha\>|)>>, <math|v<rsub|0><rsup|\<ast\>>=sup<rsub|f>
  sup<rsub|\<alpha\>\<in\>\<cal-E\><around|(|f|)>>
  v<rsub|0><around|(|f,\<alpha\>|)>>, and
  <math|<wide|v|~><rsub|0>=sup<rsub|\<alpha\>\<in\>\<cal-E\><around|(|<wide|f|~>|)>>
  v<rsub|0><around|(|<wide|f|~>,\<alpha\>|)>>.
  <math|<wide|v|\<bar\>><rsub|0>> is the best performance that the manager
  can obtain when the users are not subject to the incentive constraints
  (e.g., the actions of the users can be completely controlled by the
  manager). <math|v<rsub|0><rsup|\<ast\>>> is the best performance when the
  manager takes into account the incentives of the users by requiring that
  the action profile should be sustained by the intervention rule. Lastly,
  <math|<wide|v|~><rsub|0>> is the best performance when the manager does not
  engage in active intervention. It is straightforward to see that
  <math|<wide|v|~><rsub|0>\<leq\>v<rsub|0><rsup|\<ast\>>\<leq\><wide|v|\<bar\>><rsub|0>>.
  The following proposition provides a sufficient condition on the
  intervention game for a gap between <math|<wide|v|\<bar\>><rsub|0>> and
  <math|v<rsub|0><rsup|\<ast\>>> to exist.

  <\proposition>
    <label|thm:ineff>Suppose that the intervention game is finite,
    <math|\<rho\>> has full support (i.e.,
    <math|\<rho\><around|(|y\|a|)>\<gtr\>0> for all <math|y> and <math|a>),
    and there is no <math|\<alpha\>> such that
    <math|\<alpha\>\<in\>\<cal-E\><around|(|<wide|f|~>|)>> and
    <math|v<rsub|0><around|(|<wide|f|~>,\<alpha\>|)>=<wide|v|\<bar\>><rsub|0>>.
    Then <math|v<rsub|0><rsup|\<ast\>>\<less\><wide|v|\<bar\>><rsub|0>>.
  </proposition>

  <\IEEEproof>
    \ Suppose that the conclusion does not hold, i.e.,
    <math|v<rsub|0><rsup|\<ast\>>=<wide|v|\<bar\>><rsub|0>>. Since the
    intervention game is finite, <math|v<rsub|0><rsup|\<ast\>>> is attained
    by Proposition<nbsp><reference|lemma:euhc>. Thus, there exists
    <math|<around|(|f,\<alpha\>|)>> such that
    <math|\<alpha\>\<in\>\<cal-E\><around|(|f|)>> and
    <math|v<rsub|0><around|(|f,\<alpha\>|)>=<wide|v|\<bar\>><rsub|0>>. Note
    that <math|<wide|v|\<bar\>><rsub|0>=v<rsub|0><around|(|f,\<alpha\>|)>\<leq\>v<rsub|0><around|(|<wide|f|~>,\<alpha\>|)>\<leq\><wide|v|\<bar\>><rsub|0>>.
    Hence, <math|v<rsub|0><around|(|f,\<alpha\>|)>=v<rsub|0><around|(|<wide|f|~>,\<alpha\>|)>>.
    Since <math|\<rho\>> has full support, we have
    <math|f<around|(|y|)>=<wide|f|~><around|(|y|)>> for all <math|y>. This
    contradicts the hypothesis that there is no <math|\<alpha\>> such that
    <math|\<alpha\>\<in\>\<cal-E\><around|(|<wide|f|~>|)>> and
    <math|v<rsub|0><around|(|<wide|f|~>,\<alpha\>|)>=<wide|v|\<bar\>><rsub|0>>.
  </IEEEproof>

  When the intervention game is finite, <math|<wide|v|\<bar\>><rsub|0>> is
  attained since <math|v<rsub|0>> is continuous and
  <math|<around|(|\<cal-F\>\<times\><big|prod><rsub|i\<in\>\<cal-N\>>\<Delta\><around|(|A<rsub|i>|)>|)>>
  is compact. Since <math|v<rsub|0><around|(|<wide|f|~>,\<alpha\>|)>\<geq\>v<rsub|0><around|(|f,\<alpha\>|)>>
  for all <math|\<alpha\>>, for all <math|f>, we have
  <math|<wide|v|\<bar\>><rsub|0>=sup<rsub|\<alpha\>>
  v<rsub|0><around|(|<wide|f|~>,\<alpha\>|)>>. In fact, when the intervention
  game is finite and <math|\<rho\>> has full support, <math|<wide|f|~>> is
  the only intervention rule that can attain the best feasible performance,
  <math|<wide|v|\<bar\>><rsub|0>>. When <math|<wide|f|~>> sustains no action
  profile that attains <math|<wide|v|\<bar\>><rsub|0>>, the manager needs to
  trigger a punishment following some signals in order to provide appropriate
  incentives for the users to follow an action profile that attains
  <math|<wide|v|\<bar\>><rsub|0>>. However, since <math|\<rho\>> has full
  support, the punishment results in a performance loss, which prevents the
  manager from achieving <math|<wide|v|\<bar\>><rsub|0>>.

  <subsection|Illustrative Example (Type-2 Intervention)><label|sec:ex1>

  We consider a wireless network where two users interfere with each other.
  Each user has two pure actions, <math|a<rsub|L>> and <math|a<rsub|H>>,
  which represent low and high resource usage levels, respectively, and
  satisfy <math|0\<less\>a<rsub|L>\<less\>a<rsub|H>>. The service quality is
  determined randomly given an action profile, and there are two possible
  quality levels, <math|<wide|y|\<bar\>>> and <math|<wide*|y|\<bar\>>>, with
  <math|0\<less\><wide*|y|\<bar\>>\<less\><wide|y|\<bar\>>>. The service
  quality is realized following the distribution

  <align*|<tformat|<table|<row|<cell|\<rho\><around|(|<wide|y|\<bar\>>\|a|)>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|p,<space|1em>>|<cell|<text|if
  <math|a=<around|(|a<rsub|L>,a<rsub|L>|)>>,>>>|<row|<cell|q,<space|1em>>|<cell|<text|if
  <math|a=<around|(|a<rsub|H>,a<rsub|L>|)>> or
  <math|<around|(|a<rsub|L>,a<rsub|H>|)>>,>>>|<row|<cell|r,<space|1em>>|<cell|<text|if
  <math|a=<around|(|a<rsub|H>,a<rsub|H>|)>>,>>>>>>|\<nobracket\>>>>>>>

  where <math|0\<less\>r\<less\>q\<less\>p\<less\>1>. The intervention device
  in this example acts as a gatekeeper (i.e., type-2 intervention) after
  observing the service quality, having two pure actions: intervene
  (<math|<wide|a|^><rsub|0>>) and not intervene
  (<math|<wide|a|~><rsub|0>>).<footnote|We consider the simplest case of two
  users, two pure actions for each agent, and two signals for analytical
  tractability, although the example can be easily extended to a more general
  case. The incentive to choose the high usage level is the strongest with
  two users, which allows us to highlight the role of intervention schemes.
  Also, considering two pure actions and two signals is sufficient to
  generate interesting results without involving too many analytical
  complications.> When the intervention device does not intervene, a user
  receives a payoff given by the product of the quality level and its own
  usage level, i.e., <math|u<rsub|i><around|(|<wide|a|~><rsub|0>,a<rsub|i>,y|)>=y*a<rsub|i>>
  for all <math|a<rsub|i>> and <math|y>, for <math|i=1,2>. When the
  intervention device does intervene, the service stops completely and a user
  receives zero payoff regardless of its usage level, i.e.,
  <math|u<rsub|i><around|(|<wide|a|^><rsub|0>,a<rsub|i>,y|)>=0> for all
  <math|a<rsub|i>> and <math|y>, for <math|i=1,2>. The payoff of the manager
  is set as the average payoff of the users, i.e.,
  <math|u<rsub|0><around|(|a<rsub|0>,a,y|)>=<around|[|u<rsub|1><around|(|a<rsub|0>,a<rsub|1>,y|)>+u<rsub|2><around|(|a<rsub|0>,a<rsub|2>,y|)>|]>/2>.
  Note that denoting the action of not intervening by
  <math|<wide|a|~><rsub|0>> is consistent with
  Assumption<nbsp><reference|ass:tilde>. A communication scenario that fits
  into this example is presented in Fig.<nbsp><reference|fig:type2>.

  Since there are two pure actions for the intervention device, we can
  represent <math|\<cal-F\>=<around|[|0,1|]>> and use <math|f<around|(|y|)>>
  as the probability of not intervening given the signal
  <math|y>.<footnote|An alternative interpretation is that the intervention
  device can degrade the service quality, with <math|f<around|(|y|)>*y>
  representing the quality level after intervention. When the users and the
  manager are expected-utility maximizers, the two interpretations yield the
  same payoff functions.> The ex ante payoff function of user <math|i> for
  pure action profiles is given by

  <align*|<tformat|<table|<row|<cell|v<rsub|i><around|(|f,a|)>=<around|[|\<rho\><around|(|<wide|y|\<bar\>>\|a|)>*f<around|(|<wide|y|\<bar\>>|)>*<wide|y|\<bar\>>+<around|(|1-\<rho\><around|(|<wide|y|\<bar\>>\|a|)>|)>*f<around|(|<wide*|y|\<bar\>>|)><wide*|y|\<bar\>>|]>*a<rsub|i>.>>>>>

  The payoff matrix of the game <math|\<Gamma\><rsub|<wide|f|~>>>, i.e., when
  the intervention device does not intervene at all, is displayed in
  Table<nbsp><reference|table:pd>, where we define
  <math|y<rsub|k>=k*<wide|y|\<bar\>>+<around|(|1-k|)><wide*|y|\<bar\>>>, for
  <math|k=p,q,r>. We assume that the game <math|\<Gamma\><rsub|<wide|f|~>>>
  is the prisoner's dilemma game, i.e., <math|y<rsub|q>*a<rsub|H>\<gtr\>y<rsub|p>*a<rsub|L>\<gtr\>y<rsub|r>*a<rsub|H>\<gtr\>y<rsub|q>*a<rsub|L>>
  and <math|2*y<rsub|p>*a<rsub|L>\<gtr\>y<rsub|q>*<around|(|a<rsub|H>+a<rsub|L>|)>>.
  Then without any intervention, it is the dominant strategy of each user to
  choose the high usage level, which results in the inefficient Nash
  equilibrium. The manager aims to improve upon the inefficiency of the Nash
  equilibrium by providing appropriate incentives through
  intervention.<footnote|In this paper, we focus on the role of intervention
  schemes to improve the prospect of cooperation by applying intervention to
  prisoner's dilemma situations. Intervention schemes can also be used to
  help users achieve coordination by eliminating the multiplicity of Nash
  equilibria in coordination games such as the battle of the sexes and the
  stag hunt <cite|fudenberg>. For example, in the stag-hunt game, an
  intervention scheme may induce players to choose the payoff dominant (but
  not risk dominant) ``all stag'' equilibrium by intervening in the hare
  hunt.> We restrict attention to symmetric action profile, assuming that the
  manager desires to sustain a symmetric action profile.

  <big-table| <with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|3|3|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|<math|a<rsub|L>>>|<cell|<math|a<rsub|H>>>>|<row|<cell|<math|a<rsub|L>>>|<cell|<math|y<rsub|p>*a<rsub|L>>,
  <math|y<rsub|p>*a<rsub|L>>>|<cell|<math|y<rsub|q>*a<rsub|L>>,
  <math|y<rsub|q>*a<rsub|H>>>>|<row|<cell|<math|a<rsub|H>>>|<cell|<math|y<rsub|q>*a<rsub|H>>,
  <math|y<rsub|q>*a<rsub|L>>>|<cell|<math|y<rsub|r>*a<rsub|H>>,
  <math|y<rsub|r>*a<rsub|H>>>>>>><label|table:pd>>|Payoff matrix of the game
  <math|\<Gamma\><rsub|<wide|f|~>>> in the illustrative example of
  Section<nbsp><reference|sec:ex1>.>

  Let <math|w<rsub|0><around|(|\<alpha\>|)>=sup<rsub|f><around|{|v<rsub|0><around|(|f,\<alpha\>|)>:\<alpha\>\<in\>\<cal-E\><around|(|f|)>|}>>.
  That is, <math|w<rsub|0><around|(|\<alpha\>|)>> is the maximum payoff that
  the manager can obtain while sustaining a given action profile
  <math|\<alpha\>>. Since we focus on symmetric action profiles and there are
  two pure actions for each user, let <math|\<alpha\>\<in\><around|[|0,1|]>>
  denote the probability of each user playing <math|a<rsub|L>>. Then we can
  show that <math|w<rsub|0><around|(|0|)>=y<rsub|r>*a<rsub|H>> and, for
  <math|\<alpha\>\<in\><around|(|0,1|]>>,

  <align|<tformat|<table|<row|<cell|<label|eq:w0alpha>w<rsub|0><around|(|\<alpha\>|)>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<frac|<around|{|<around|(|q-r|)>+\<alpha\>*<around|[|<around|(|p-q|)>-<around|(|q-r|)>|]>|}>*a<rsub|H>*a<rsub|L>|<around|[|<around|(|1-r|)>*a<rsub|H>-<around|(|1-q|)>*a<rsub|L>|]>+\<alpha\>*<around|[|<around|(|p*a<rsub|L>-q*a<rsub|H>|)>-<around|(|q*a<rsub|L>-r*a<rsub|H>|)>|]>>*<wide|y|\<bar\>>,>>|<row|<cell|<space|2em><space|2em><space|2em><text|if
  <math|\<alpha\>*<around|[|<around|(|p*a<rsub|L>-q*a<rsub|H>|)>-<around|(|q*a<rsub|L>-r*a<rsub|H>|)>|]>+<around|(|q*a<rsub|L>-r*a<rsub|H>|)>\<geq\>0>,>>>|<row|<cell|0,<space|1em><space|2em><space|2em><text|otherwise.>>>>>>|\<nobracket\>>>>>>>

  The intervention rule that attains <math|w<rsub|0><around|(|0|)>> is given
  by <math|<wide|f|~>> (i.e., no intervention), while the intervention rule
  that attains <math|w<rsub|0><around|(|\<alpha\>|)>>, for
  <math|\<alpha\>\<in\><around|(|0,1|]>>, is given by

  <align*|<tformat|<table|<row|<cell|f<around|(|<wide|y|\<bar\>>|)>=1*<space|1em><text|and><space|1em>f<around|(|<wide*|y|\<bar\>>|)>=<frac|<around|(|q*a<rsub|L>-r*a<rsub|H>|)>+\<alpha\>*<around|[|<around|(|p*a<rsub|L>-q*a<rsub|H>|)>-<around|(|q*a<rsub|L>-r*a<rsub|H>|)>|]>|<around|[|<around|(|1-r|)>*a<rsub|H>-<around|(|1-q|)>*a<rsub|L>|]>+\<alpha\>*<around|[|<around|(|p*a<rsub|L>-q*a<rsub|H>|)>-<around|(|q*a<rsub|L>-r*a<rsub|H>|)>|]>>*<frac|<wide|y|\<bar\>>|<wide*|y|\<bar\>>>.>>>>>

  if <math|\<alpha\>*<around|(|p*a<rsub|L>-q*a<rsub|H>|)>+<around|(|1-\<alpha\>|)>*<around|(|q*a<rsub|L>-r*a<rsub|H>|)>\<geq\>0>,
  and by <math|f<around|(|<wide|y|\<bar\>>|)>=f<around|(|<wide*|y|\<bar\>>|)>=0>
  otherwise. We can think of <math|\<alpha\>*<around|(|p*a<rsub|L>-q*a<rsub|H>|)>+<around|(|1-\<alpha\>|)>*<around|(|q*a<rsub|L>-r*a<rsub|H>|)>>
  as a measure of the sensitivity of signals between the two pure actions
  when the other user plays <math|\<alpha\>>. When signals are sufficiently
  sensitive at <math|\<alpha\>>, an intervention rule can sustain
  <math|\<alpha\>> with a positive payoff by degrading the low quality only.
  On the contrary, when signals are not sensitive, destroying all the payoffs
  is the only method to sustain <math|\<alpha\>>, which yields zero payoff
  for the users. Note that, when <math|p*a<rsub|L>-q*a<rsub|H>\<less\>0> and
  <math|q*a<rsub|L>-r*a<rsub|H>\<gtr\>0>, the pure action profile
  <math|<around|(|a<rsub|L>,a<rsub|L>|)>> cannot be sustained with a positive
  payoff while a completely mixed action profile can be. In this case,
  signals are more sensitive to the action of a user when the other user
  plays <math|a<rsub|H>>. Hence, by inducing the users to play
  <math|a<rsub|H>> with positive probability, the manager can make the signal
  a more informative indicator of a deviation. This allows the possibility
  that an intervention rule improves the performance of non-cooperative
  equilibrium by sustaining a completely mixed action profile even when the
  social optimum <math|<around|(|a<rsub|L>,a<rsub|L>|)>> cannot be sustained
  non-trivially. A similar discussion about the advantage of using mixed
  actions can be found in <cite|kandori> in the context of the repeated
  prisoner's dilemma game.

  In this example, we have <math|<wide|v|~><rsub|0>=w<rsub|0><around|(|0|)>=y<rsub|r>*a<rsub|H>>,
  <math|<wide|v|\<bar\>><rsub|0>=y<rsub|p>*a<rsub|L>>, and
  <math|v<rsub|0><rsup|\<ast\>>=max<rsub|\<alpha\>\<in\><around|[|0,1|]>>
  w<rsub|0><around|(|\<alpha\>|)>>. We summarize the results about the
  performance with intervention, <math|v<rsub|0><rsup|\<ast\>>>, in the
  following proposition.

  <\proposition>
    <label|prop:ex1>(i) Suppose that (a) <math|p*a<rsub|L>-q*a<rsub|H>\<less\>0>
    and <math|q*a<rsub|L>-r*a<rsub|H>\<less\>0>, or (b)
    <math|p*a<rsub|L>-q*a<rsub|H>\<less\>q*a<rsub|L>-r*a<rsub|H>> and
    <math|<around|(|p-q|)>*<around|(|1-r|)>-<around|(|q-r|)>*<around|(|1-q|)>\<leq\>0>.
    Then <math|v<rsub|0><rsup|\<ast\>>=<wide|v|~><rsub|0>>.<next-line>(ii)
    Suppose that (c) <math|p*a<rsub|L>-q*a<rsub|H>\<geq\>q*a<rsub|L>-r*a<rsub|H>\<geq\>0>,
    (d) <math|p*a<rsub|L>-q*a<rsub|H>\<geq\>0\<gtr\>q*a<rsub|L>-r*a<rsub|H>>,
    or (e) <math|0\<leq\>p*a<rsub|L>-q*a<rsub|H>\<less\>q*a<rsub|L>-r*a<rsub|H>>
    and <math|<around|(|p-q|)>*<around|(|1-r|)>-<around|(|q-r|)>*<around|(|1-q|)>\<gtr\>0>.
    Then <math|v<rsub|0><rsup|\<ast\>>=max
    <around|{|<wide|v|~><rsub|0>,w<rsub|0><around|(|1|)>|}>>.<next-line>(iii)
    Suppose that (f) <math|p*a<rsub|L>-q*a<rsub|H>\<less\>0\<leq\>q*a<rsub|L>-r*a<rsub|H>>
    and <math|<around|(|p-q|)>*<around|(|1-r|)>-<around|(|q-r|)>*<around|(|1-q|)>\<gtr\>0>.
    Then <math|v<rsub|0><rsup|\<ast\>>=max
    <around|{|<wide|v|~><rsub|0>,w<rsub|0><around|(|<wide|\<alpha\>|\<bar\>>|)>|}>>,
    where

    <align*|<tformat|<table|<row|<cell|<wide|\<alpha\>|\<bar\>>=<frac|q*a<rsub|L>-r*a<rsub|H>|<around|(|q*a<rsub|L>-r*a<rsub|H>|)>-<around|(|p*a<rsub|L>-q*a<rsub|H>|)>>.>>>>>
  </proposition>

  <\IEEEproof>
    \ See Appendix<nbsp><reference|app:ex1>.
  </IEEEproof>

  Fig.<nbsp><reference|fig:w0> shows that each of the three cases of
  <math|v<rsub|0><rsup|\<ast\>>=<wide|v|~><rsub|0>>,
  <math|v<rsub|0><rsup|\<ast\>>=w<rsub|0><around|(|<wide|\<alpha\>|\<bar\>>|)>>,
  and <math|v<rsub|0><rsup|\<ast\>>=w<rsub|0><around|(|1|)>> can arise
  depending on the parameter values. To obtain the results, we set
  <math|a<rsub|L>=1>, <math|a<rsub|H>=1.19>, <math|<wide|y|\<bar\>>=5>,
  <math|<wide*|y|\<bar\>>=1>, <math|q=0.8>, and <math|r=0.65> while varying
  <math|p=0.9,0.94,0.96>. We can see that, as <math|p> increases, the
  performance with intervention improves, getting closer to its upper bound
  <math|<wide|v|\<bar\>><rsub|0>>. In fact, when
  <math|v<rsub|0><rsup|\<ast\>>=w<rsub|0><around|(|1|)>>, we have

  <align*|<tformat|<table|<row|<cell|<wide|v|\<bar\>><rsub|0>-v<rsub|0><rsup|\<ast\>>=<frac|<around|(|1-p|)>*a<rsub|L>*<around|(|y<rsub|q>*a<rsub|H>-y<rsub|p>*a<rsub|L>|)>|<around|(|1-q|)>*a<rsub|H>-<around|(|1-p|)>*a<rsub|L>>\<gtr\>0,>>>>>

  which is consistent with Proposition<nbsp><reference|thm:ineff>. The gap
  between <math|v<rsub|0><rsup|\<ast\>>> and <math|<wide|v|\<bar\>><rsub|0>>
  vanishes as <math|p> approaches 1, while it increases with the deviation
  gain (<math|y<rsub|q>*a<rsub|H>-y<rsub|p>*a<rsub|L>>). This result is
  intuitive because punishment rarely occurs when <math|p> is close to 1, and
  a stronger punishment is needed as the deviation gain is larger.

  We can consider pricing schemes applied to this example, by having the
  manager charge different payments depending on the realized service
  quality. In order to find a pricing scheme that sustains a certain action
  profile, the manager needs to know how payments affect the payoffs of the
  users (i.e., the function <math|u<rsub|i><around|(|a<rsub|0>,a<rsub|i>,y|)>>,
  where <math|a<rsub|0>> is now interpreted as the charged payment). Suppose,
  for example, that the users care about data rates. With an intervention
  scheme, which influences data rates directly, it is easy to find out the
  relationship between <math|a<rsub|0>> and <math|u<rsub|i>>. In contrast,
  with a pricing scheme, finding out the relationship requires the manager to
  know how the users value payments relative to data rates. This information
  is difficult to obtain since the users' valuations are subjective and thus
  not easily measurable. This discussion points out the informational
  advantage of intervention over pricing.

  <section|Performance with Intervention under Perfect
  Monitoring><label|sec:permon>

  <subsection|Analytical Results><label|sec:permonanal>

  In this section, we consider the case where the intervention device can
  observe the pure action profile without errors (i.e., perfect monitoring),
  as stated formally in the following assumption.

  <\assumption>
    <label|ass:permon><math|Y=A>, and only signal <math|a> can arise in the
    distribution <math|\<rho\><around|(|a|)>> for all <math|a\<in\>A>.
  </assumption>

  With Assumption<nbsp><reference|ass:permon>, the ex post payoff functions
  can be written as <math|u<rsub|i>:A<rsub|0>\<times\>A\<rightarrow\>\<bbb-R\>>,
  for all <math|i\<in\>\<cal-N\><rsub|0>>. We also maintain the following
  assumption in this section.

  <\assumption>
    <label|ass:aligned>There exist two actions for the intervention device
    <math|<wide*|a|\<bar\>><rsub|0>,<wide|a|\<bar\>><rsub|0>\<in\>A<rsub|0>>
    that satisfy for all <math|i\<in\>\<cal-N\><rsub|0>>,

    <align|<tformat|<table|<row|<cell|<label|eq:a0order>u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>\<geq\>u<rsub|i><around|(|a<rsub|0>,a|)>\<geq\>u<rsub|i><around|(|<wide|a|\<bar\>><rsub|0>,a|)><space|1em><text|for
    all <math|a<rsub|0>\<in\>A<rsub|0>>, for all ><math|a\<in\>A>.>>>>>
  </assumption>

  <math|<wide*|a|\<bar\>><rsub|0>> and <math|<wide|a|\<bar\>><rsub|0>> can be
  interpreted as the most and least preferred actions of the intervention
  device, respectively. For any <math|a\<in\>A>, the users and the manager
  receive the highest (resp. lowest) payoff when the intervention device
  takes the most (resp. least) preferred intervention action.
  Assumption<nbsp><reference|ass:aligned> allows the intervention device to
  reward or punish all the users at the same time. The action
  <math|<wide*|a|\<bar\>><rsub|0>> plays a similar role to that of
  <math|<wide|a|~><rsub|0>> in Assumption<nbsp><reference|ass:tilde> in that
  the manager prefers to use <math|<wide*|a|\<bar\>><rsub|0>> for a given
  action profile and that both can be interpreted as the action with which
  the intervention device does not intervene at all.

  In this section, we restrict attention to pure actions (both for the users
  and for the intervention device) while allowing the action spaces to be
  continuous spaces. Thus, an intervention rule is represented by a mapping
  <math|f:A\<rightarrow\>A<rsub|0>>, while user <math|i> chooses a pure
  action <math|a<rsub|i>\<in\>A<rsub|i>> given an intervention rule. Then the
  ex ante payoff function is given by <math|v<rsub|i><around|(|f,a|)>=u<rsub|i><around|(|f<around|(|a|)>,a|)>>,
  for all <math|i\<in\>\<cal-N\><rsub|0>>. We define a class of intervention
  rules.

  <\definition>
    <math|f<rsub|<wide|a|~>>:A\<rightarrow\>A<rsub|0>> is an <em|extreme
    intervention rule with target action profile <math|<wide|a|~>\<in\>A>> if

    <align|<tformat|<table|<row|<cell|<label|eq:polar>f<rsub|<wide|a|~>><around|(|a|)>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<wide*|a|\<bar\>><rsub|0><space|1em>>|<cell|<with|font-family|rm|i*fa=<wide|a|~>,>>>|<row|<cell|<wide|a|\<bar\>><rsub|0><space|1em>>|<cell|<with|font-family|rm|o*t*h*e*r*w*i*s*e>.>>>>>|\<nobracket\>>>>>>>
  </definition>

  With an extreme intervention rule, the intervention device chooses the most
  preferred action when the users follow the target action profile while
  choosing the least preferred action when they deviate. Hence, an extreme
  intervention rule provides the strongest incentive for sustaining a given
  target action profile. Let <math|\<cal-E\><around|(|\<cal-F\>|)>=\<cup\><rsub|f\<in\>\<cal-F\>>\<cal-E\><around|(|f|)>>.
  That is, <math|\<cal-E\><around|(|\<cal-F\>|)>> is the set of sustainable
  action profiles.

  <\lemma>
    <label|lem:ext>If <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|\<cal-F\>|)>>,
    then <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|f<rsub|a<rsup|\<ast\>>>|)>>.
  </lemma>

  <\IEEEproof>
    \ Suppose that <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|\<cal-F\>|)>>.
    Then there exists an intervention rule <math|f> such that
    <math|v<rsub|i><around|(|f,a<rsup|\<ast\>>|)>\<geq\>v<rsub|i><around|(|f,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    for all <math|a<rsub|i>\<in\>A<rsub|i>>, for all <math|i\<in\>\<cal-N\>>.
    Then we obtain <math|v<rsub|i><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>=u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>\<geq\>u<rsub|i><around|(|f<around|(|a<rsup|\<ast\>>|)>,a<rsup|\<ast\>>|)>\<geq\>u<rsub|i><around|(|f<around|(|a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>\<geq\>u<rsub|i><around|(|<wide|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>=v<rsub|i><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    for all <math|a<rsub|i>\<neq\>a<rsub|i><rsup|\<ast\>>>, for all
    <math|i\<in\>\<cal-N\>>, where the first and the third inequalities
    follow from <eqref|eq:a0order>.
  </IEEEproof>

  Let <math|\<cal-E\><rsup|\<ast\>>=<around|{|a\<in\>A:a\<in\>\<cal-E\><around|(|f<rsub|a>|)>|}>>.
  The following results are the consequences of
  Lemma<nbsp><reference|lem:ext>.

  <\proposition>
    <label|thm:char>(i) <math|\<cal-E\><around|(|\<cal-F\>|)>=\<cal-E\><rsup|\<ast\>>>.<next-line>(ii)
    If <math|<around|(|f<rsup|\<ast\>>,a<rsup|\<ast\>>|)>> is an intervention
    equilibrium, then <math|<around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>>
    is also an intervention equilibrium.
  </proposition>

  <\IEEEproof>
    \ (i) Let <math|a<rsup|\<ast\>>\<in\>\<cal-E\><rsup|\<ast\>>>. Then
    <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|f<rsub|a<rsup|\<ast\>>>|)>\<subset\>\<cal-E\><around|(|\<cal-F\>|)>>.
    Hence, <math|\<cal-E\><rsup|\<ast\>>\<subset\>\<cal-E\><around|(|\<cal-F\>|)>>.
    The other inclusion <math|\<cal-E\><around|(|\<cal-F\>|)>\<subset\>\<cal-E\><rsup|\<ast\>>>
    follows from Lemma<nbsp><reference|lem:ext>.

    (ii) Suppose that <math|<around|(|f<rsup|\<ast\>>,a<rsup|\<ast\>>|)>> is
    an intervention equilibrium. Then by Definition<nbsp><reference|def:ie>,
    <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|f<rsup|\<ast\>>|)>> and
    <math|v<rsub|0><around|(|f<rsup|\<ast\>>,a<rsup|\<ast\>>|)>\<geq\>v<rsub|0><around|(|f,a|)>>
    for all <math|<around|(|f,a|)>\<in\>\<cal-F\>\<times\>A> such that
    <math|a\<in\>\<cal-E\><around|(|f|)>>. Since
    <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|\<cal-F\>|)>>,
    <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|f<rsub|a<rsup|\<ast\>>>|)>>
    by Lemma<nbsp><reference|lem:ext>. Hence,
    <math|v<rsub|0><around|(|f<rsup|\<ast\>>,a<rsup|\<ast\>>|)>\<geq\>v<rsub|0><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>>.
    On the other hand, since <math|f<rsub|a<rsup|\<ast\>>><around|(|a<rsup|\<ast\>>|)>=<wide*|a|\<bar\>><rsub|0>>,
    we have <math|v<rsub|0><around|(|f<rsup|\<ast\>>,a<rsup|\<ast\>>|)>\<leq\>v<rsub|0><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>>
    by <eqref|eq:a0order>. Therefore, <math|v<rsub|0><around|(|f<rsup|\<ast\>>,a<rsup|\<ast\>>|)>=v<rsub|0><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>>,
    and thus <math|v<rsub|0><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>\<geq\>v<rsub|0><around|(|f,a|)>>
    for all <math|<around|(|f,a|)>\<in\>\<cal-F\>\<times\>A> such that
    <math|a\<in\>\<cal-E\><around|(|f|)>>. This proves that
    <math|<around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>> is an
    intervention equilibrium.
  </IEEEproof>

  Proposition<nbsp><reference|thm:char> shows that it is without loss of
  generality to restrict attention to pairs of the form
  <math|<around|(|f<rsub|a>,a|)>> when we ask whether a given action profile
  is sustainable and whether there exists an intervention equilibrium. The
  role of extreme intervention rules is analogous to that of grim trigger
  strategies in repeated games with perfect monitoring. To generate the set
  of equilibrium payoffs, it suffices to consider grim trigger strategies
  that trigger the most severe punishment in case of a deviation. Under
  Assumption<nbsp><reference|ass:aligned>, the least preferred intervention
  action <math|<wide|a|\<bar\>><rsub|0>> plays a similar role to that of
  mutual minmaxing <cite|mailath> in that it provides the strongest threat to
  deter a deviation.

  <\proposition>
    <label|prop:charie><math|<around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>>
    is an intervention equilibrium if and only if
    <math|a<rsup|\<ast\>>\<in\>\<cal-E\><rsup|\<ast\>>> and
    <math|u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>\<geq\>u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>>
    for all <math|a\<in\>\<cal-E\><rsup|\<ast\>>>.
  </proposition>

  <\IEEEproof>
    \ Suppose that <math|<around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>>
    is an intervention equilibrium. Then <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|f<rsub|a<rsup|\<ast\>>>|)>>,
    and thus <math|a<rsup|\<ast\>>\<in\>\<cal-E\><rsup|\<ast\>>>. Also,
    <math|v<rsub|0><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>\<geq\>v<rsub|0><around|(|f,a|)>>
    for all <math|<around|(|f,a|)>> such that
    <math|a\<in\>\<cal-E\><around|(|f|)>>. Choose any
    <math|a\<in\>\<cal-E\><rsup|\<ast\>>>. Then
    <math|a\<in\>\<cal-E\><around|(|f<rsub|a>|)>>, and thus
    <math|u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>=v<rsub|0><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>\<geq\>v<rsub|0><around|(|f<rsub|a>,a|)>=u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>>.

    Suppose that <math|a<rsup|\<ast\>>\<in\>\<cal-E\><rsup|\<ast\>>> and
    <math|u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>\<geq\>u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>>
    for all <math|a\<in\>\<cal-E\><rsup|\<ast\>>>. To prove that
    <math|<around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>> is an
    intervention equilibrium, we need to show that (i)
    <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|f<rsub|a<rsup|\<ast\>>>|)>>,
    and (ii) <math|v<rsub|0><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>\<geq\>v<rsub|0><around|(|f,a|)>>
    for all <math|<around|(|f,a|)>> such that
    <math|a\<in\>\<cal-E\><around|(|f|)>>. (i) follows from
    <math|a<rsup|\<ast\>>\<in\>\<cal-E\><rsup|\<ast\>>>. To prove (ii),
    choose any <math|<around|(|f,a|)>> such that
    <math|a\<in\>\<cal-E\><around|(|f|)>>. By Lemma<nbsp><reference|lem:ext>,
    we have <math|a\<in\>\<cal-E\><rsup|\<ast\>>>. Then
    <math|v<rsub|0><around|(|f<rsub|a<rsup|\<ast\>>>,a<rsup|\<ast\>>|)>=u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>\<geq\>u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>\<geq\>v<rsub|0><around|(|f,a|)>>,
    where the first inequality follows from
    <math|a\<in\>\<cal-E\><rsup|\<ast\>>>.
  </IEEEproof>

  Proposition<nbsp><reference|prop:charie> shows that the pair
  <math|<around|(|f<rsub|a>,a|)>> constitutes an intervention equilibrium if
  <math|a> solves

  <align|<tformat|<table|<row|<cell|<label|eq:charie>max<rsub|a\<in\>\<cal-E\><rsup|\<ast\>>>
  u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>.>>>>>

  The next proposition provides a sufficient condition under which an
  intervention equilibrium exists.

  <\proposition>
    <label|prop:exist2>Suppose that <math|A<rsub|i>> is a bounded set in
    Euclidean space, for all <math|i\<in\>\<cal-N\>>, and that
    <math|u<rsub|i><around|(|a<rsub|0>,a|)>> is continuous in <math|a>, for
    <math|a<rsub|0>=<wide*|a|\<bar\>><rsub|0>,<wide|a|\<bar\>><rsub|0>>, for
    all <math|i\<in\>\<cal-N\><rsub|0>>. Then there exists an intervention
    equilibrium.
  </proposition>

  <\IEEEproof>
    \ By Proposition<nbsp><reference|thm:char>(ii) and
    Proposition<nbsp><reference|prop:charie>, an intervention equilibrium
    exists if and only if there exists a solution to the problem
    <eqref|eq:charie>. Since <math|u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>>
    is continuous in <math|a>, the result follows if we show that the
    constraint set <math|\<cal-E\><rsup|\<ast\>>> is compact. Since
    <math|\<cal-E\><rsup|\<ast\>>\<subset\>A> and <math|A> is bounded,
    <math|\<cal-E\><rsup|\<ast\>>> is also bounded. To show that
    <math|\<cal-E\><rsup|\<ast\>>> is closed, choose a sequence
    <math|<around|{|a<rsup|n>|}>> with <math|a<rsup|n>\<rightarrow\>a<rsup|\<ast\>>>
    and <math|a<rsup|n>\<in\>\<cal-E\><rsup|\<ast\>>> for all <math|n>.
    Choose any <math|i\<in\>\<cal-N\>> and
    <math|a<rprime|'><rsub|i>\<in\>A<rsub|i>>. Since
    <math|a<rsup|n>\<in\>\<cal-E\><around|(|f<rsub|a<rsup|n>>|)>>, we have
    <math|u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|n>|)>\<geq\>u<rsub|i><around|(|<wide|a|\<bar\>><rsub|0>,a<rprime|'><rsub|i>,a<rsup|n><rsub|-i>|)>>.
    Since <math|u<rsub|i><around|(|a<rsub|0>,a|)>> is continuous in <math|a>
    for <math|a<rsub|0>=<wide*|a|\<bar\>><rsub|0>,<wide|a|\<bar\>><rsub|0>>,
    we obtain <math|u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>\<geq\>u<rsub|i><around|(|<wide|a|\<bar\>><rsub|0>,a<rprime|'><rsub|i>,a<rsup|\<ast\>><rsub|-i>|)>>
    by taking limits. This proves <math|a<rsup|\<ast\>>\<in\>\<cal-E\><around|(|f<rsub|a<rsup|\<ast\>>>|)>>
    and thus <math|a<rsup|\<ast\>>\<in\>\<cal-E\><rsup|\<ast\>>>.
  </IEEEproof>

  When we find an action profile that constitutes an intervention equilibrium
  by solving the problem <eqref|eq:charie>, we can hold the action of the
  intervention device at <math|a<rsub|0>=<wide*|a|\<bar\>><rsub|0>> because
  any sustainable action can be sustained while the intervention device takes
  <math|<wide*|a|\<bar\>><rsub|0>> on the equilibrium path. Let
  <math|a<rsup|o>> be a solution to the problem <math|max<rsub|a\<in\>A>
  u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>>, which exists when
  <math|u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>> is continuous in
  <math|a> and <math|A> is compact. Then we have
  <math|<wide|v|\<bar\>><rsub|0>=u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|o>|)>>.
  The following result can be obtained as a corollary of
  Proposition<nbsp><reference|prop:charie>.

  <\corollary>
    <label|cor:eff>If <math|a<rsup|o>\<in\>arg max<rsub|a\<in\>A>
    u<rsub|0><around|(|<wide*|a|\<bar\>><rsub|0>,a|)>> and
    <math|u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|o>|)>\<geq\>u<rsub|i><around|(|<wide|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|o>|)>>
    for all <math|a<rsub|i>\<in\>A<rsub|i>>, for all <math|i\<in\>\<cal-N\>>,
    then <math|v<rsub|0><rsup|\<ast\>>=<wide|v|\<bar\>><rsub|0>>.
  </corollary>

  Corollary<nbsp><reference|cor:eff> shows that, with perfect monitoring, the
  manager can achieve the best feasible performance by using an intervention
  scheme when the intervention capability is sufficiently strong. When the
  punishment provided by the action <math|<wide|a|\<bar\>><rsub|0>> is
  sufficiently severe, any deviation from a target action profile can be
  deterred. Also, there is no performance loss in sustaining a target action
  profile because the punishment exists only as a threat, not happening on
  the equilibrium path. This contrasts with the imperfect monitoring case
  (see Proposition<nbsp><reference|thm:ineff>), where providing incentives
  necessarily incurs a performance loss.

  Extreme intervention rules are useful to characterize sustainable action
  profiles and intervention equilibria. However, they may not be desirable in
  practice. For example, when a user chooses an action different from the
  target action by mistake (i.e., trembling hands), an extreme intervention
  rule triggers the most severe punishment, resulting in a large performance
  loss. Thus, it is of interest to investigate intervention rules that use
  weaker punishments than extreme intervention rules do. To obtain concrete
  results, we assume that <math|A<rsub|i>=<around|[|<wide*|a|\<bar\>><rsub|i>,<wide|a|\<bar\>><rsub|i>|]>\<subset\>\<bbb-R\>>
  with <math|<wide*|a|\<bar\>><rsub|i>\<less\><wide|a|\<bar\>><rsub|i>> for
  all <math|i\<in\>\<cal-N\><rsub|0>> in the remainder of this section. Below
  we define another class of intervention rules.

  <\definition>
    <math|f<rsub|<wide|a|~>,c>:A\<rightarrow\>A<rsub|0>> is a <em|(truncated)
    affine intervention rule with target action profile
    <math|<wide|a|~>\<in\>A> and intervention rate profile
    <math|c\<in\>\<bbb-R\><rsup|N>>> if

    <align|<tformat|<table|<row|<cell|<label|eq:affine>f<rsub|<wide|a|~>,c><around|(|a|)>=<around*|[|c\<cdot\><around|(|a-<wide|a|~>|)>+<wide*|a|\<bar\>><rsub|0>|]><rsub|<wide*|a|\<bar\>><rsub|0>><rsup|<wide|a|\<bar\>><rsub|0>>,>>>>>

    where <math|<around|[|x|]><rsub|\<alpha\>><rsup|\<beta\>>=min
    <around|{|max <around|{|x,\<alpha\>|}>,\<beta\>|}>>.
  </definition>

  The following proposition constructs an affine intervention rule to sustain
  an interior target action profile in the differentiable payoff case.

  <\proposition>
    <label|prop:affine>Let <math|a<rsup|\<ast\>>\<in\>\<cal-A\>> be an action
    profile such that <math|a<rsub|i><rsup|\<ast\>>\<in\><around|(|<wide*|a|\<bar\>><rsub|i>,<wide|a|\<bar\>><rsub|i>|)>>
    for all <math|i\<in\>\<cal-N\>>. Suppose that, for all
    <math|i\<in\>\<cal-N\>>, <math|u<rsub|i>> is twice continuously
    differentiable and <math|u<rsub|i><around|(|a<rsub|0>,a<rsup|\<ast\>>|)>>
    is strictly decreasing in <math|a<rsub|0>> on
    <math|<around|[|<wide*|a|\<bar\>><rsub|0>,<wide|a|\<bar\>><rsub|0>|]>>.
    Let

    <align|<tformat|<table|<row|<cell|<label|eq:ci>c<rsub|i><rsup|\<ast\>>=-<frac|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|i>|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|0>>>>>>>

    for all <math|i\<in\>\<cal-N\>>.<footnote|We define
    <math|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|0>>
    as the right partial derivative of <math|u<rsub|i>> with respect to
    <math|a<rsub|0>> at <math|<around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>>.>
    Suppose that

    <align|<tformat|<table|<row|<cell|<label|eq:soc1><frac|\<partial\><rsup|2>*u<rsub|i>|\<partial\>*a<rsub|i><rsup|2>><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>\<leq\>0*<space|1em><text|for
    all >a<rsub|i>\<in\><around|(|<wide*|a|\<bar\>><rsub|i>,<wide|a|\<bar\>><rsub|i>|)>>>>>>

    for all <math|i\<in\>\<cal-N\>> such that
    <math|c<rsub|i><rsup|\<ast\>>=0>,

    <align|<tformat|<table|<row|<cell|<label|eq:soc21><frac|\<partial\><rsup|2>*u<rsub|i>|\<partial\>*a<rsub|i><rsup|2>><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>\<leq\>0*<space|1em><text|for
    all >a<rsub|i>\<in\><around|(|<wide*|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>|)>,>>>>>

    <align|<tformat|<table|<row|<cell|<label|eq:soc22><around*|(|<around|(|c<rsub|i><rsup|\<ast\>>|)><rsup|2><frac|\<partial\><rsup|2>*u<rsub|i>|\<partial\>*a<rsub|0><rsup|2>>+2*c<rsub|i><rsup|\<ast\>>*<frac|\<partial\><rsup|2>*u<rsub|i>|\<partial\>*a<rsub|i>*\<partial\>*a<rsub|0>>+<frac|\<partial\><rsup|2>*u<rsub|i>|\<partial\>*a<rsub|i><rsup|2>>|)><mid|\|><rsub|<around|(|a<rsub|0>,a<rsub|i>,a<rsub|-i>|)>=<around|(|c<rsub|i><rsup|\<ast\>>*<around|(|a<rsub|i>-a<rsub|i><rsup|\<ast\>>|)>+<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>\<leq\>0*<no-number>>>|<row|<cell|<space|1em><text|for
    all <math|a<rsub|i>\<in\><around|(|a<rsub|i><rsup|\<ast\>>,min
    <around|{|<wide|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>|}>|)>>,
    and>>>>>>

    <align|<tformat|<table|<row|<cell|<label|eq:soc23><frac|\<partial\>*u<rsub|i>|\<partial\>*a<rsub|i>><around|(|<wide|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>\<leq\>0*<space|1em><text|for
    all >a<rsub|i>\<in\><around|(|a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>,<wide|a|\<bar\>><rsub|i>|)>>>>>>

    for all <math|i\<in\>\<cal-N\>> such that
    <math|c<rsub|i><rsup|\<ast\>>\<gtr\>0>, and

    <align*|<tformat|<table|<row|<cell|<frac|\<partial\>*u<rsub|i>|\<partial\>*a<rsub|i>><around|(|<wide|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>\<geq\>0*<space|1em><text|for
    all >a<rsub|i>\<in\><around|(|<wide*|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>|)>,>>>>>

    <align|<tformat|<table|<row|<cell|<label|eq:soc32><around*|(|<around|(|c<rsub|i><rsup|\<ast\>>|)><rsup|2><frac|\<partial\><rsup|2>*u<rsub|i>|\<partial\>*a<rsub|0><rsup|2>>+2*c<rsub|i><rsup|\<ast\>>*<frac|\<partial\><rsup|2>*u<rsub|i>|\<partial\>*a<rsub|i>*\<partial\>*a<rsub|0>>+<frac|\<partial\><rsup|2>*u<rsub|i>|\<partial\>*a<rsub|i><rsup|2>>|)><mid|\|><rsub|<around|(|a<rsub|0>,a<rsub|i>,a<rsub|-i>|)>=<around|(|c<rsub|i><rsup|\<ast\>>*<around|(|a<rsub|i>-a<rsub|i><rsup|\<ast\>>|)>+<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>\<leq\>0*<no-number>>>|<row|<cell|<space|1em><text|for
    all <math|a<rsub|i>\<in\><around|(|max
    <around|{|<wide|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>|}>,a<rsub|i><rsup|\<ast\>>|)>>,
    and>>>>>>

    <align*|<tformat|<table|<row|<cell|<frac|\<partial\><rsup|2>*u<rsub|i>|\<partial\>*a<rsub|i><rsup|2>><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>\<leq\>0*<space|1em><text|for
    all >a<rsub|i>\<in\><around|(|a<rsub|i><rsup|\<ast\>>,<wide|a|\<bar\>><rsub|i>|)>>>>>>

    for all <math|i\<in\>\<cal-N\>> such that
    <math|c<rsub|i><rsup|\<ast\>>\<less\>0>.<footnote|We define
    <math|<around|(|\<alpha\>,\<beta\>|)>=\<emptyset\>> if
    <math|\<alpha\>\<geq\>\<beta\>>.> Then
    <math|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>>> sustains
    <math|a<rsup|\<ast\>>>.
  </proposition>

  <\IEEEproof>
    \ See Appendix<nbsp><reference|app:affine>.
  </IEEEproof>

  Note that <math|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|0>\<less\>0>
  for all <math|i\<in\>\<cal-N\>> since <math|u<rsub|i><around|(|a<rsub|0>,a<rsup|\<ast\>>|)>>
  is strictly decreasing in <math|a<rsub|0>>. Thus,
  <math|c<rsub|i><rsup|\<ast\>>>, defined in <eqref|eq:ci>, has the same sign
  as <math|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|i>>.
  With <math|A<rsub|0>=<around|[|<wide*|a|\<bar\>><rsub|0>,<wide|a|\<bar\>><rsub|0>|]>>,
  the action of the intervention device can be interpreted as the
  intervention level, and the users receive higher payoffs as the
  intervention level is smaller. The affine intervention rule
  <math|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>>>, constructed in
  Proposition<nbsp><reference|prop:affine>, has the properties that the
  intervention device uses the minimum intervention level
  <math|<wide*|a|\<bar\>><rsub|0>> when the users choose the target action
  profile <math|a<rsup|\<ast\>>>, i.e., <math|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>><around|(|a<rsup|\<ast\>>|)>=<wide*|a|\<bar\>><rsub|0>>,
  and that the intervention level increases in the rate of
  <math|<around|\||c<rsub|i><rsup|\<ast\>>|\|>> as user <math|i> deviates to
  the direction in which its payoff increases at
  <math|<around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>>. The
  expression of <math|c<rsub|i><rsup|\<ast\>>> in <eqref|eq:ci> has an
  intuitive explanation. Since <math|c<rsub|i><rsup|\<ast\>>> is proportional
  to <math|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|i>>
  and inversely proportional to <math|-\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|0>>,
  a user faces a higher intervention rate as its incentive to deviate from
  <math|<around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>> is stronger
  and as a change in the intervention level has a smaller impact on its
  payoff. The intervention level does not react to the action of user
  <math|i> when <math|c<rsub|i><rsup|\<ast\>>=0>, because user <math|i>
  chooses <math|a<rsub|i><rsup|\<ast\>>> in its self-interest even when the
  intervention level is fixed at <math|<wide*|a|\<bar\>><rsub|0>>, provided
  that the other users choose <math|a<rsub|-i><rsup|\<ast\>>>. Finally, we
  note that if <math|<around|(|f<rsup|\<ast\>>,a<rsup|\<ast\>>|)>> is an
  intervention equilibrium and <math|f<rsub|a<rsup|\<ast\>>,c>> sustains
  <math|a<rsup|\<ast\>>> for some <math|c>, then
  <math|<around|(|f<rsub|a<rsup|\<ast\>>,c>,a<rsup|\<ast\>>|)>> is also an
  intervention equilibrium, since <math|f<rsub|a<rsup|\<ast\>>,c><around|(|a<rsup|\<ast\>>|)>=<wide*|a|\<bar\>><rsub|0>>.

  <subsection|Illustrative Example (Type-1 Intervention)><label|sec:ex2>

  As an illustrative example, we consider another resource sharing scenario
  in a wireless network where two users and an intervention device interfere
  with each other. In this example, the intervention device engages in type-1
  intervention, affecting the service quality through its usage level. The
  actions of the users and the intervention device are their usage levels,
  and the action spaces are given by <math|A<rsub|i>=<around|[|0,<wide|a|\<bar\>><rsub|i>|]>>
  for <math|i=0,1,2>. <math|<wide|a|\<bar\>><rsub|i>> denotes the maximum
  usage level of user <math|i>. The service quality is determined by the
  total usage level, <math|a<rsub|0>+a<rsub|1>+a<rsub|2>>, following the
  relationship

  <align*|<tformat|<table|<row|<cell|Q<around|(|a<rsub|0>,a<rsub|1>,a<rsub|2>|)>=<around|[|q-b*<around|(|a<rsub|0>+a<rsub|1>+a<rsub|2>|)>|]><rsup|+>,>>>>>

  where <math|q,b\<gtr\>0> and <math|<around|[|x|]><rsup|+>=max
  <around|{|x,0|}>>. The payoff of user <math|i\<in\><around|{|1,2|}>> is
  given by the product of the service quality and its own usage level,

  <align|<tformat|<table|<row|<cell|<label|eq:payoffexample>u<rsub|i><around|(|a<rsub|0>,a<rsub|1>,a<rsub|2>|)>=Q<around|(|a<rsub|0>,a<rsub|1>,a<rsub|2>|)>*a<rsub|i>.>>>>>

  The payoff of the manager is given by the average payoff of the two users,

  <align*|<tformat|<table|<row|<cell|u<rsub|0><around|(|a<rsub|0>,a<rsub|1>,a<rsub|2>|)>=<around|[|u<rsub|1><around|(|a<rsub|0>,a<rsub|1>,a<rsub|2>|)>+u<rsub|2><around|(|a<rsub|0>,a<rsub|1>,a<rsub|2>|)>|]>/2.>>>>>

  In this example, we have <math|<wide|v|\<bar\>><rsub|0>=q<rsup|2>/8*b>,
  which is achieved when <math|a<rsub|0>=0> and
  <math|a<rsub|1>+a<rsub|2>=q/2*b>, assuming that
  <math|<wide|a|\<bar\>><rsub|1>+<wide|a|\<bar\>><rsub|2>\<geq\>q/2*b>. The
  symmetric action profile that attains <math|<wide|v|\<bar\>><rsub|0>> is
  thus <math|<around|(|a<rsub|l>,a<rsub|l>|)>>, where
  <math|a<rsub|l>\<triangleq\>q/4*b>. On the other hand, the best performance
  at the non-cooperative equilibrium without intervention (i.e., when
  <math|a<rsub|0>> is held fixed at 0) is given by
  <math|<wide|v|~><rsub|0>=q<rsup|2>/9*b>, which is attained at
  <math|<around|(|a<rsub|h>,a<rsub|h>|)>>, where
  <math|a<rsub|h>\<triangleq\>q/3*b>, assuming that
  <math|<wide|a|\<bar\>><rsub|i>\<geq\>a<rsub|h>>, for <math|i=1,2>. Hence,
  the goal of the manager is to limit the usage levels of the users by using
  intervention as a potential threat.

  Given the structure of the intervention game in this example, the
  intervention capability of the intervention device is represented by its
  maximum intervention level <math|<wide|a|\<bar\>><rsub|0>>. In the
  following proposition, we investigate the performance with intervention as
  we vary <math|<wide|a|\<bar\>><rsub|0>>.

  <\proposition>
    <label|prop:ex2>Suppose that <math|<wide|a|\<bar\>><rsub|i>\<geq\>q/2*b>,
    for <math|i=1,2>. Then (i) <math|v<rsub|0><rsup|\<ast\>>=<wide|v|~><rsub|0>>
    if and only if <math|<wide|a|\<bar\>><rsub|0>=0>, and (ii)
    <math|v<rsub|0><rsup|\<ast\>>=<wide|v|\<bar\>><rsub|0>> if and only if
    <math|<wide|a|\<bar\>><rsub|0>\<geq\><around|(|3*<sqrt|2>-4|)>*q/4*<sqrt|2>*b>.
    Moreover, <math|v<rsub|0><rsup|\<ast\>>> is strictly increasing with
    <math|<wide|a|\<bar\>><rsub|0>> on <math|<around|[|0,<around|(|3*<sqrt|2>-4|)>*q/4*<sqrt|2>*b|]>>.
  </proposition>

  <\IEEEproof>
    \ See Appendix<nbsp><reference|app:ex2>.
  </IEEEproof>

  Since <math|u<rsub|i>> is weakly decreasing in <math|a<rsub|0>>, the set
  <math|\<cal-E\><rsup|\<ast\>>> is weakly increasing as the intervention
  capability <math|<wide|a|\<bar\>><rsub|0>> is larger. This implies that the
  performance with intervention <math|v<rsub|0><rsup|\<ast\>>> is weakly
  increasing with <math|<wide|a|\<bar\>><rsub|0>>.
  Proposition<nbsp><reference|prop:ex2> shows that the performance with
  intervention improves as <math|<wide|a|\<bar\>><rsub|0>> increases,
  eventually reaching the best feasible performance.
  Fig.<nbsp><reference|fig:a0vary> plots the set
  <math|\<cal-E\><rsup|\<ast\>>=\<cal-E\><around|(|\<cal-F\>|)>> as a dark
  region for four different values of <math|<wide|a|\<bar\>><rsub|0>> with
  parameters <math|q=12,b=1>, and <math|<wide|a|\<bar\>><rsub|1>=<wide|a|\<bar\>><rsub|2>=12>.
  We can see that <math|\<cal-E\><rsup|\<ast\>>> expands as
  <math|<wide|a|\<bar\>><rsub|0>> increases. When
  <math|<wide|a|\<bar\>><rsub|0>=0>, <math|\<cal-E\><rsup|\<ast\>>> has only
  two elements, <math|<around|(|a<rsub|h>,a<rsub|h>|)>=<around|(|4,4|)>> and
  <math|<around|(|12,12|)>>. When <math|<wide|a|\<bar\>><rsub|0>=0.1>, there
  are more action profiles in <math|\<cal-E\><rsup|\<ast\>>>. However, the
  symmetric social optimum <math|<around|(|a<rsub|l>,a<rsub|l>|)>=<around|(|3,3|)>>
  does not belong to <math|\<cal-E\><rsup|\<ast\>>>, and
  Proposition<nbsp><reference|prop:charie> implies that the action profile
  <math|<around|(|a<rsub|1>,a<rsub|2>|)>> that minimizes
  <math|a<rsub|1>+a<rsub|2>> among those in <math|\<cal-E\><rsup|\<ast\>>>
  constitutes an intervention equilibrium. When
  <math|<wide|a|\<bar\>><rsub|0>\<geq\><around|(|3*<sqrt|2>-4|)>*q/4*<sqrt|2>*b\<approx\>0.51>,
  the action profiles in <math|\<cal-E\><rsup|\<ast\>>> that satisfy
  <math|a<rsub|1>+a<rsub|2>=2*a<rsub|l>=6> constitute an intervention
  equilibrium, as all of them yield the best feasible performance
  <math|<wide|v|\<bar\>><rsub|0>>. When <math|<wide|a|\<bar\>><rsub|0>\<geq\>q/b=12>,
  the punishment from <math|<wide|a|\<bar\>><rsub|0>> is strong enough to
  make any action profile sustainable, i.e.,
  <math|\<cal-E\><rsup|\<ast\>>=A>.

  Applying Proposition<nbsp><reference|prop:affine>, we can construct an
  affine intervention rule that sustains an action profile
  <math|<around|(|a<rsub|1><rsup|\<ast\>>,a<rsub|2><rsup|\<ast\>>|)>> such
  that <math|a<rsub|i><rsup|\<ast\>>\<in\><around|(|0,<wide|a|\<bar\>><rsub|i>|)>>
  for <math|i=1,2> and <math|a<rsub|1><rsup|\<ast\>>+a<rsub|2><rsup|\<ast\>>\<less\>q/b>,
  provided that the maximum intervention level
  <math|<wide|a|\<bar\>><rsub|0>> is sufficiently large. With the payoff
  functions in <eqref|eq:payoffexample>, the expression of
  <math|c<rsub|i><rsup|\<ast\>>> in <eqref|eq:ci> is given by

  <align*|<tformat|<table|<row|<cell|c<rsub|i><rsup|\<ast\>><around|(|a<rsup|\<ast\>>|)>=<frac|q|b*a<rsub|i><rsup|\<ast\>>>-<frac|a<rsub|-i><rsup|\<ast\>>|a<rsub|i><rsup|\<ast\>>>-2,>>>>>

  for <math|i=1,2>. For example, the affine intervention rule with target
  action profile <math|<around|(|a<rsub|l>,a<rsub|l>|)>> and intervention
  rate profile <math|c<rsup|\<ast\>><around|(|a<rsub|l>,a<rsub|l>|)>> is
  expressed as

  <align|<tformat|<table|<row|<cell|<label|eq:affineexample>f<around|(|a<rsub|1>,a<rsub|2>|)>=<around*|[|a<rsub|1>+a<rsub|2>-<frac|q|2*b>|]><rsub|0><rsup|<wide|a|\<bar\>><rsub|0>>.>>>>>

  Fig.<nbsp><reference|fig:payoffex> plots the payoff of user <math|i>
  against its action <math|a<rsub|i>>, provided that the manager chooses the
  intervention rule in <eqref|eq:affineexample> and the other user chooses
  <math|a<rsub|l>>. It also assumes that <math|<wide|a|\<bar\>><rsub|0>> is
  sufficiently large. Without intervention, the best response of user
  <math|i> to <math|a<rsub|l>> is <math|3*q/8*b>, which shows the instability
  of the symmetric social optimum <math|<around|(|a<rsub|l>,a<rsub|l>|)>>.
  However, when the intervention rule <eqref|eq:affineexample> is used, the
  intervention device begins to intervene as user <math|i> increases its
  usage level from <math|a<rsub|l>>. An increase in payoff due to the
  increased usage level is more than offset by a decrease in payoff due to
  the quality degradation from intervention. As a result, users do not gain
  by a unilateral deviation from <math|<around|(|a<rsub|l>,a<rsub|l>|)>>
  under the intervention rule <eqref|eq:affineexample>.

  <section|Conclusion><label|sec:conclusion>

  In this paper, we have developed a game-theoretic framework for the design
  and analysis of intervention schemes, which are aimed to drive
  self-interested users towards a system objective. Our results suggest that
  we can construct an effective intervention scheme when an intervention
  device with an accurate monitoring technology and a strong intervention
  capability is available. In order to deal with the problem of designing an
  optimal intervention scheme, our framework should be extended to
  incorporate the cost of implementing a particular monitoring technology and
  an intervention capability. Another direction of extension is to consider a
  dynamic model of decision making under intervention, where users and
  intervention devices can use their past observations to adjust their
  behavior. Lastly, we can extend our framework to the one with incomplete
  information on the side of the manager or users.

  <appendices>

  <section|Proof of Proposition<nbsp><reference|prop:ex1>><label|app:ex1>

  <\IEEEproof>
    \ First, note that <math|w<rsub|0><around|(|0|)>\<gtr\>lim<rsub|\<alpha\>\<rightarrow\>0<rsup|+>>
    w<rsub|0><around|(|\<alpha\>|)>>. Suppose that
    <math|p*a<rsub|L>-q*a<rsub|H>\<less\>0> and
    <math|q*a<rsub|L>-r*a<rsub|H>\<less\>0>. Then
    <math|w<rsub|0><around|(|\<alpha\>|)>=0> for all
    <math|\<alpha\>\<in\><around|(|0,1|]>>, and thus
    <math|v<rsub|0><rsup|\<ast\>>=w<rsub|0><around|(|0|)>=<wide|v|~><rsub|0>>.

    Suppose that at least one of the two inequalities
    <math|p*a<rsub|L>-q*a<rsub|H>\<geq\>0> and
    <math|q*a<rsub|L>-r*a<rsub|H>\<geq\>0> holds. We consider three cases.

    <em|Case 1:> <math|p*a<rsub|L>-q*a<rsub|H>=q*a<rsub|L>-r*a<rsub|H>>.

    In this case, <math|\<alpha\>*<around|[|<around|(|p*a<rsub|L>-q*a<rsub|H>|)>-<around|(|q*a<rsub|L>-r*a<rsub|H>|)>|]>+<around|(|q*a<rsub|L>-r*a<rsub|H>|)>\<geq\>0>
    is satisfied for all <math|\<alpha\>\<in\><around|(|0,1|]>>, and
    <math|w<rsub|0><around|(|\<alpha\>|)>> is increasing on
    <math|<around|(|0,1|]>>. Thus, we obtain
    <math|v<rsub|0><rsup|\<ast\>>=max <around|{|w<rsub|0><around|(|0|)>,w<rsub|0><around|(|1|)>|}>>.

    <em|Case 2:> <math|p*a<rsub|L>-q*a<rsub|H>\<gtr\>q*a<rsub|L>-r*a<rsub|H>>.

    <math|\<alpha\>*<around|[|<around|(|p*a<rsub|L>-q*a<rsub|H>|)>-<around|(|q*a<rsub|L>-r*a<rsub|H>|)>|]>+<around|(|q*a<rsub|L>-r*a<rsub|H>|)>\<geq\>0>
    if and only if

    <align|<tformat|<table|<row|<cell|<label|eq:case2al>\<alpha\>\<geq\><frac|-<around|(|q*a<rsub|L>-r*a<rsub|H>|)>|<around|(|p*a<rsub|L>-q*a<rsub|H>|)>-<around|(|q*a<rsub|L>-r*a<rsub|H>|)>>,>>>>>

    where the right-hand side of <eqref|eq:case2al> is smaller than 1. Also,
    <math|p*a<rsub|L>-q*a<rsub|H>\<gtr\>q*a<rsub|L>-r*a<rsub|H>> implies
    <math|p-q\<gtr\>q-r>. We can show that the sign of the first derivative
    of <math|w<rsub|0>> at <math|\<alpha\>\<in\><around|(|0,1|)>> is equal to
    that of <math|<around|(|p-q|)>*<around|(|1-r|)>-<around|(|q-r|)>*<around|(|1-q|)>>,
    which is positive. Hence, we have <math|v<rsub|0><rsup|\<ast\>>=max
    <around|{|w<rsub|0><around|(|0|)>,w<rsub|0><around|(|1|)>|}>>.

    <em|Case 3:> <math|p*a<rsub|L>-q*a<rsub|H>\<less\>q*a<rsub|L>-r*a<rsub|H>>.

    <math|\<alpha\>*<around|[|<around|(|p*a<rsub|L>-q*a<rsub|H>|)>-<around|(|q*a<rsub|L>-r*a<rsub|H>|)>|]>+<around|(|q*a<rsub|L>-r*a<rsub|H>|)>\<geq\>0>
    if and only if

    <align*|<tformat|<table|<row|<cell|\<alpha\>\<leq\><frac|q*a<rsub|L>-r*a<rsub|H>|<around|(|q*a<rsub|L>-r*a<rsub|H>|)>-<around|(|p*a<rsub|L>-q*a<rsub|H>|)>>\<triangleq\><wide|\<alpha\>|\<bar\>>.>>>>>

    Also, the sign of the first derivative of <math|w<rsub|0>> is equal to
    that of <math|<around|(|p-q|)>*<around|(|1-r|)>-<around|(|q-r|)>*<around|(|1-q|)>>.

    <em|Case 3-1:> <math|0\<leq\>p*a<rsub|L>-q*a<rsub|H>\<less\>q*a<rsub|L>-r*a<rsub|H>>.

    We have <math|<wide|\<alpha\>|\<bar\>>\<geq\>1>. Thus, <math|w<rsub|0>>
    is increasing on <math|<around|(|0,1|]>> if
    <math|<around|(|p-q|)>*<around|(|1-r|)>-<around|(|q-r|)>*<around|(|1-q|)>\<gtr\>0>
    and non-increasing if <math|<around|(|p-q|)>*<around|(|1-r|)>-<around|(|q-r|)>*<around|(|1-q|)>\<leq\>0>.

    <em|Case 3-2:> <math|p*a<rsub|L>-q*a<rsub|H>\<less\>0\<leq\>q*a<rsub|L>-r*a<rsub|H>>.

    We have <math|<wide|\<alpha\>|\<bar\>>\<less\>1>. Thus, <math|w<rsub|0>>
    is increasing on <math|<around|(|0,<wide|\<alpha\>|\<bar\>>|]>> if
    <math|<around|(|p-q|)>*<around|(|1-r|)>-<around|(|q-r|)>*<around|(|1-q|)>\<gtr\>0>
    and non-increasing if <math|<around|(|p-q|)>*<around|(|1-r|)>-<around|(|q-r|)>*<around|(|1-q|)>\<leq\>0>.
  </IEEEproof>

  <section|Proof of Proposition<nbsp><reference|prop:affine>><label|app:affine>

  <\IEEEproof>
    \ To prove that <math|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>>> sustains
    <math|a<rsup|\<ast\>>> is equivalent to show that

    <align|<tformat|<table|<row|<cell|<label|eq:maxaffine>a<rsub|i><rsup|\<ast\>>\<in\>arg
    max<rsub|a<rsub|i>\<in\>A<rsub|i>> u<rsub|i><around|(|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>><around|(|a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>>>>>

    for all <math|i\<in\>\<cal-N\>>. Note that
    <math|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>><around|(|a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>=<around*|[|c<rsub|i><rsup|\<ast\>>*<around|(|a<rsub|i>-a<rsub|i><rsup|\<ast\>>|)>+<wide*|a|\<bar\>><rsub|0>|]><rsub|<wide*|a|\<bar\>><rsub|0>><rsup|<wide|a|\<bar\>><rsub|0>>>.
    We consider three cases depending on the sign of
    <math|c<rsub|i><rsup|\<ast\>>>.

    <em|Case 1:> <math|c<rsub|i><rsup|\<ast\>>=0>.

    By <eqref|eq:ci>, we have <math|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|i>=0>.
    Also, we have <math|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>><around|(|a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>=<wide*|a|\<bar\>><rsub|0>>
    for all <math|a<rsub|i>\<in\>A<rsub|i>>. Thus, the objective function in
    <eqref|eq:maxaffine> reduces to <math|u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>.
    The condition <eqref|eq:soc1> implies that
    <math|u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    is a concave function with respect to <math|a<rsub|i>> on
    <math|A<rsub|i>>. Also, the first-order optimality condition is satisfied
    at <math|a<rsub|i>=a<rsub|i><rsup|\<ast\>>> since
    <math|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|i>=0>.
    Therefore, <math|a<rsub|i><rsup|\<ast\>>> maximizes
    <math|u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    on <math|A<rsub|i>>.

    <em|Case 2:> <math|c<rsub|i><rsup|\<ast\>>\<gtr\>0>.

    Since <math|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|0>\<less\>0>,
    we have <math|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|i>\<gtr\>0>
    by <eqref|eq:ci>. First, consider <math|a<rsub|i>\<in\><around|[|<wide*|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>|]>>.
    In this region, <math|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>><around|(|a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>=<wide*|a|\<bar\>><rsub|0>>,
    and thus the objective function can be written as
    <math|u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>.
    Since the condition <eqref|eq:soc21> implies that
    <math|u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    is concave with respect to <math|a<rsub|i>> on
    <math|<around|[|<wide*|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>|]>>,
    <math|u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    is strictly increasing in <math|a<rsub|i>> on
    <math|<around|[|<wide*|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>|]>>.

    Second, consider <math|a<rsub|i>\<in\><around|[|a<rsub|i><rsup|\<ast\>>,min
    <around|{|<wide|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>|}>|]>>.
    In this region, <math|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>><around|(|a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>=c<rsub|i><rsup|\<ast\>>*<around|(|a<rsub|i>-a<rsub|i><rsup|\<ast\>>|)>+<wide*|a|\<bar\>><rsub|0>>,
    and thus the objective function can be written as
    <math|u<rsub|i>*<around|(|c<rsub|i><rsup|\<ast\>>*<around|(|a<rsub|i>-a<rsub|i><rsup|\<ast\>>|)>+<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>.
    The first derivative of <math|u<rsub|i>*<around|(|c<rsub|i><rsup|\<ast\>>*<around|(|a<rsub|i>-a<rsub|i><rsup|\<ast\>>|)>+<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    with respect to <math|a<rsub|i>> is given by

    <align*|<tformat|<table|<row|<cell|<around*|(|c<rsub|i><rsup|\<ast\>>*<frac|\<partial\>*u<rsub|i>|\<partial\>*a<rsub|0>>+<frac|\<partial\>*u<rsub|i>|\<partial\>*a<rsub|i>>|)><mid|\|><rsub|<around|(|a<rsub|0>,a<rsub|i>,a<rsub|-i>|)>=<around|(|c<rsub|i><rsup|\<ast\>>*<around|(|a<rsub|i>-a<rsub|i><rsup|\<ast\>>|)>+<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>,>>>>>

    while the second derivative is given by the left-hand side of
    <eqref|eq:soc22>. The first derivative is zero at
    <math|a<rsub|i>=a<rsub|i><rsup|\<ast\>>> by <eqref|eq:ci>, while the
    second derivative is non-positive by <eqref|eq:soc22>. Hence, the first
    derivative is non-positive on <math|<around|(|a<rsub|i><rsup|\<ast\>>,min
    <around|{|<wide|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>|}>|)>>,
    and thus <math|u<rsub|i>*<around|(|c<rsub|i><rsup|\<ast\>>*<around|(|a<rsub|i>-a<rsub|i><rsup|\<ast\>>|)>+<wide*|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    is non-increasing in <math|a<rsub|i>> on
    <math|<around|[|a<rsub|i><rsup|\<ast\>>,min
    <around|{|<wide|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>|}>|]>>.

    Lastly, consider <math|a<rsub|i>\<in\><around|[|a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>,<wide|a|\<bar\>><rsub|i>|]>>.
    In this region, <math|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>><around|(|a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>=<wide|a|\<bar\>><rsub|0>>,
    and thus the objective function can be written as
    <math|u<rsub|i><around|(|<wide|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>.
    Since the first derivative of <math|u<rsub|i><around|(|<wide|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    with respect to <math|a<rsub|i>> is non-positive on
    <math|<around|(|a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>,<wide|a|\<bar\>><rsub|i>|)>>
    by <eqref|eq:soc23>, <math|u<rsub|i><around|(|<wide|a|\<bar\>><rsub|0>,a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>>
    is non-increasing in <math|a<rsub|i>> on
    <math|<around|[|a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>,<wide|a|\<bar\>><rsub|i>|]>>.

    <em|Case 3:> <math|c<rsub|i><rsup|\<ast\>>\<less\>0>.

    In this case, <math|\<partial\>*u<rsub|i><around|(|<wide*|a|\<bar\>><rsub|0>,a<rsup|\<ast\>>|)>/\<partial\>*a<rsub|i>\<less\>0>
    and

    <align*|<tformat|<table|<row|<cell|f<rsub|a<rsup|\<ast\>>,c<rsup|\<ast\>>><around|(|a<rsub|i>,a<rsub|-i><rsup|\<ast\>>|)>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<wide|a|\<bar\>><rsub|0>,<space|1em>>|<cell|<with|font-family|rm|i*f<math|a<rsub|i>\<in\><around|[|<wide*|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>|]>>,>>>|<row|<cell|c<rsub|i><rsup|\<nosymbol\>>*<around|(|a<rsub|i>-a<rsub|i><rsup|\<nosymbol\>>|)>+<wide*|a|\<bar\>><rsub|0>,<space|1em>>|<cell|<with|font-family|rm|i*f<math|a<rsub|i>\<in\><around|[|max
    <around|{|<wide|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>+<around|(|<wide|a|\<bar\>><rsub|0>-<wide*|a|\<bar\>><rsub|0>|)>/c<rsub|i><rsup|\<ast\>>|}>,a<rsub|i><rsup|\<ast\>>|]>>,>>>|<row|<cell|<wide*|a|\<bar\>><rsub|0>,<space|1em>>|<cell|<with|font-family|rm|i*f<math|a<rsub|i>\<in\><around|[|a<rsub|i><rsup|\<ast\>>,<wide|a|\<bar\>><rsub|i>|]>>>.>>>>>|\<nobracket\>>>>>>>

    Following an analogous argument as in Case 2, we can show that the
    objective function is non-decreasing in <math|a<rsub|i>> on
    <math|<around|[|<wide*|a|\<bar\>><rsub|i>,a<rsub|i><rsup|\<ast\>>|]>> and
    strictly decreasing on <math|<around|[|a<rsub|i><rsup|\<ast\>>,<wide|a|\<bar\>><rsub|i>|]>>,
    implying that <math|a<rsub|i>=a<rsub|i><rsup|\<ast\>>> maximizes the
    objective function on <math|A<rsub|i>>.

    Note that if the inequalities in <eqref|eq:soc1>, <eqref|eq:soc22>, and
    <eqref|eq:soc32> are strict, we have <math|a<rsub|i>=a<rsub|i><rsup|\<ast\>>>
    as a unique maximizer for all <math|i\<in\>\<cal-N\>>.
  </IEEEproof>

  <section|Proof of Proposition<nbsp><reference|prop:ex2>><label|app:ex2>

  <\IEEEproof>
    \ (i) Suppose that <math|<wide|a|\<bar\>><rsub|0>=0>. Then the best
    response correspondence of user <math|i> is given by

    <align*|<tformat|<table|<row|<cell|b*r<rsub|i><around|(|a<rsub|-i>|)>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<around*|{|min
    <around*|{|<around|(|q-b*a<rsub|-i>|)>/2*b,<wide|a|\<bar\>><rsub|i>|}>|}>,<space|1em>>|<cell|<with|font-family|rm|i*f<math|a<rsub|-i>\<less\>q/b>,>>>|<row|<cell|<around*|[|0,<wide|a|\<bar\>><rsub|i>|]>,<space|1em>>|<cell|<with|font-family|rm|i*f<math|a<rsub|-i>\<geq\>q/b>.>>>>>>|\<nobracket\>>>>>>>

    Among possible Nash equilibria, only <math|<around|(|a<rsub|h>,a<rsub|h>|)>>
    yields a positive payoff for the manager, which leads to
    <math|v<rsub|0><rsup|\<ast\>>=<wide|v|~><rsub|0>>. To show the converse,
    suppose that <math|<wide|a|\<bar\>><rsub|0>\<gtr\>0>. We can show that
    <math|<around|(|a<rsub|h>-\<epsilon\>,a<rsub|h>-\<epsilon\>|)>> is
    sustainable for sufficiently small <math|\<epsilon\>\<gtr\>0>, which
    yields <math|v<rsub|0><rsup|\<ast\>>\<gtr\><wide|v|~><rsub|0>>.

    (ii) We have <math|v<rsub|0><rsup|\<ast\>>=<wide|v|\<bar\>><rsub|0>> if
    and only if there exists a sustainable action profile
    <math|<around|(|a<rsub|1>,a<rsub|2>|)>> such that
    <math|a<rsub|1>+a<rsub|2>=q/2*b>. Given <math|a<rsub|1>+a<rsub|2>=q/2*b>,
    the incentive for user <math|i> to deviate is stronger as
    <math|a<rsub|i>> is smaller. Hence, it suffices to check whether the
    symmetric action profile <math|<around|(|a<rsub|l>,a<rsub|l>|)>> is
    sustainable. By Lemma<nbsp><reference|lem:ext>,
    <math|<around|(|a<rsub|l>,a<rsub|l>|)>> is sustainable if and only if

    <align*|<tformat|<table|<row|<cell|max<rsub|a<rsub|i>\<in\><around|[|0,<wide|a|\<bar\>><rsub|i>|]>><around|[|q-b*<around|(|a<rsub|0>+a<rsub|l>+a<rsub|i>|)>|]><rsup|+>*a<rsub|i>\<leq\>q<rsup|2>/8*b,>>>>>

    which is equivalent to <math|<wide|a|\<bar\>><rsub|0>\<geq\><around|(|3*<sqrt|2>-4|)>*q/4*<sqrt|2>*b>.

    Choose <math|<wide|a|\<bar\>><rsub|0>,<wide|a|\<bar\>><rprime|'><rsub|0>\<in\><around|[|0,<around|(|3*<sqrt|2>-4|)>*q/4*<sqrt|2>*b|]>>
    with <math|<wide|a|\<bar\>><rsub|0>\<less\><wide|a|\<bar\>><rprime|'><rsub|0>>.
    Let <math|v<rsub|0><rsup|\<ast\>>> and
    <math|<around|(|v<rsub|0><rsup|\<ast\>>|)><rprime|'>> be the
    corresponding performances with intervention. Since
    <math|<wide|a|\<bar\>><rsub|0>\<less\><around|(|3*<sqrt|2>-4|)>*q/4*<sqrt|2>*b>,
    there exists an action profile <math|<around|(|a<rsub|1>,a<rsub|2>|)>>
    that attains <math|v<rsub|0><rsup|\<ast\>>> with
    <math|<wide|a|\<bar\>><rsub|0>> and satisfies
    <math|q/2*b\<less\>a<rsub|1>+a<rsub|2>\<leq\>2*q/3*b>. We can show that
    <math|<around|(|a<rsub|1>-\<epsilon\>,a<rsub|2>-\<epsilon\>|)>> can be
    sustained with <math|<wide|a|\<bar\>><rprime|'><rsub|0>> for sufficiently
    small <math|\<epsilon\>\<gtr\>0>, which implies
    <math|<around|(|v<rsub|0><rsup|\<ast\>>|)><rprime|'>\<gtr\>v<rsub|0><rsup|\<ast\>>>.
  </IEEEproof>

  <\thebibliography|99>
    <bibitem|Hardin>G. Hardin, \PThe tragedy of the commons,\Q <em|Science>,
    vol. 162, no. 3859, pp. 1243\U1248, Dec. 1968.

    <bibitem|Dubey>P. Dubey, \PInefficiency of Nash equilibria,\Q <em|Math.
    Operations Research>, vol. 11, no. 1, pp. 1\U8, Feb. 1986.

    <bibitem|hubaux>M. Felegyhazi and J.-P. Hubaux, \PGame theory in wireless
    networks: a tutorial,\Q <em|EPFL Technical Report>, LCA-REPORT-2006-002,
    Feb. 2006.

    <bibitem|laufer>A. Laufer and A. Leshem, \PDistributed coordination of
    spectrum and the prisoner's dilemma,\Q in <with|font-shape|italic|Proc.
    DySPAN>, 2005.

    <bibitem|Cagalj>M. <math|<wide|<text|C>|\<breve\>>>agalj, S. Ganeriwal,
    I. Aad, and J.-P. Hubaux, \POn selfish behavior in CSMA/CA networks,\Q in
    <with|font-shape|italic|Proc. INFOCOM>, Miami, FL, Mar. 2005.

    <bibitem|ma>R. T. Ma, V. Misra, and D. Rubenstein, \PAn analysis of
    generalized slotted-Aloha protocols,\Q <em|IEEE/ACM Trans. Netw.>, vol.
    17, no. 3, pp. 936\U949, Jun. 2009.

    <bibitem|jpark>J. Park and M. van der Schaar, \PStackelberg contention
    games in multiuser networks,\Q <with|font-shape|italic|EURASIP J.
    Advances Signal Process.>, vol. 2009, Article ID 305978, 15 pages, 2009.

    <bibitem|garg>R. Garg, A. Kamra, and V. Khurana, \PA game-theoretic
    approach towards congestion control in communication networks,\Q
    <em|Comput. Commun. Review>, vol. 32, no. 3, pp. 47\U61, Jul. 2002.

    <bibitem|basar>T. Baar and R. Srikant, \PA Stackelberg network game with
    a large number of followers,\Q <em|J. Optimization Theory Applicat.>,
    vol. 115, no. 3, pp. 479\U490, Dec. 2002.

    <bibitem|La>R. J. La and V. Anantharam, \POptimal routing control:
    repeated game approach,\Q <em|IEEE Trans. Autom. Control>, vol.47, no.3,
    pp.437\U450, Mar. 2002.

    <bibitem|korilis>Y. A. Korilis, A. A. Lazar, and A. Orda, \PAchieving
    network optima using Stackelberg routing strategies,\Q <em|IEEE/ACM
    Trans. Netw.>, vol. 5, no. 1, pp. 161\U173, Feb. 1997.

    <bibitem|yisu2>Y. Su and M. van der Schaar, \PA new perspective on
    multi-user power control games in interference channels,\Q <em|IEEE
    Trans. Wireless Commun.>, vol. 8, no. 6, pp. 2910\U2919, Jun. 2009.

    <bibitem|fudenberg>D. Fudenberg and J. Tirole, <em|Game Theory>.
    Cambridge, MA: MIT Press, 1991.

    <bibitem|nash>J. F. Nash, \PEquilibrium points in n-person games,\Q
    <em|Proc. Nat. Academy Sci.>, vol. 36, no. 1, pp. 48\U49, Jan. 1950.

    <bibitem|stokey>N. L. Stokey and R. E. Lucas (with E. C. Prescott),
    <em|Recursive Methods in Economic Dynamics>. Cambridge, MA: Harvard Univ.
    Press, 1989.

    <bibitem|kandori>M. Kandori and I. Obara, \PEfficiency in repeated games
    revisited: the role of private strategies,\Q Econometrica, vol. 74, no.
    2, pp. 499\U519, Mar. 2006.

    <bibitem|mailath>G. Mailath and L. Samuelson, <em|Repeated Games and
    Reputations: Long-run Relationships>. Oxford, U.K.: Oxford Univ. Press,
    2006.
  </thebibliography>

  <new-page>

  <big-figure|<with|par-mode|center|<image|resource|0.9tex-text-width|||><label|fig:resource>
  >|Two types of intervention in the resource sharing scenario.>

  <big-figure|<with|par-mode|center|<image|twouser2|1tex-text-width|||><label|fig:twouser>
  >|Performance improvement through an intervention scheme.>

  <big-figure|<with|par-mode|center|<subfloat*|>[]<label|fig:w0-a><image|w01|0.5tex-text-width|||><subfloat*|>[]<label|fig:w0-b><image|w02|0.5tex-text-width|||><next-line><subfloat*|>[]<label|fig:w0-c><image|w03|0.5tex-text-width|||><label|fig:w0>>|The
  graph of the function <math|w<rsub|0><around|(|\<alpha\>|)>> defined in
  <eqref|eq:w0alpha>: <protect><subref|fig:w0-a>
  <math|v<rsub|0><rsup|\<ast\>>=<wide|v|~><rsub|0>> (<math|p=0.9>),
  <protect><subref|fig:w0-b> <math|v<rsub|0><rsup|\<ast\>>=w<rsub|0><around|(|<wide|\<alpha\>|\<bar\>>|)>>
  (<math|p=0.94>), and <protect><subref|fig:w0-c>
  <math|v<rsub|0><rsup|\<ast\>>=w<rsub|0><around|(|1|)>> (<math|p=0.96>).
  (The dotted lines display <math|<wide|v|\<bar\>><rsub|0>=y<rsub|p>*a<rsub|L>>.)>

  <big-figure|<with|par-mode|center|<image|type2|0.9tex-text-width|||><label|fig:type2>>|A
  communication scenario that fits into the example in
  Section<nbsp><reference|sec:ex1>.>

  <big-figure|<with|par-mode|center|<subfloat*|>[<math|<wide|a|\<bar\>><rsub|0>=0.1>]<label|fig:a0vary-a><space|-10mm>
  <image|a001_1|0.4tex-text-width|||><space|14mm>
  <subfloat*|>[<math|<wide|a|\<bar\>><rsub|0>=0.51>]<label|fig:a0vary-b><image|a002_1|0.4tex-text-width|||><next-line><vspace|5mm><subfloat*|>[<math|<wide|a|\<bar\>><rsub|0>=5>]<label|fig:a0vary-c><space|-10mm>
  <image|a003_1|0.4tex-text-width|||><label|fig:a0vary>>|Plot of
  <math|\<cal-E\><rsup|\<ast\>>> as dark regions for the different values of
  <math|<wide|a|\<bar\>><rsub|0>> in the example of
  Section<nbsp><reference|sec:ex2>.>

  <big-figure|<with|par-mode|center|<image|payoffaffine|0.5tex-text-width|||><label|fig:payoffex>>|Plot
  of <math|u<rsub|i>> against <math|a<rsub|i>> when the manager chooses the
  affine intervention rule <eqref|eq:affineexample> and the other user
  chooses <math|a<rsub|l>>.>
</body>