<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <\hide-preamble>
    <assign|NPB|<macro|1|<jnfont>Nucl. Phys. B
    <with|font-series|bold|<arg|1>>,>>

    <assign|PLB|<macro|1|<jnfont>Phys. Lett. B
    <with|font-series|bold|<arg|1>>,>>

    <assign|EPJC|<macro|1|<jnfont>Eur. Phys. Jour. C
    <with|font-series|bold|<arg|1>>,>>

    <assign|PRD|<macro|1|<jnfont>Phys. Rev. D
    <with|font-series|bold|<arg|1>>,>>

    <assign|PRL|<macro|1|<jnfont>Phys. Rev. Lett.
    <with|font-series|bold|<arg|1>>,>>

    <assign|MPLA|<macro|1|<jnfont>Mod. Phys. Lett. A
    <with|font-series|bold|<arg|1>>,>>

    <assign|JPG|<macro|1|<jnfont>J. Phys. G<with|font-series|bold|<arg|1>>,>>

    <assign|CTP|<macro|1|<jnfont>Commun. Theor. Phys.
    <with|font-series|bold|<arg|1>>,>>

    <assign|ZPC|<macro|1|<jnfont>Z. Phys. C
    <with|font-series|bold|<arg|1>>,>>

    <assign|JHEP|<macro|1|<jnfont>JHEP \ <with|font-series|bold|<arg|1>>,>>

    <assign|Rv|<macro|<neg|<kern>-1pt <math|R>>>>

    <assign|p|<macro|<neg|<kern>-3pt <math|p>>>>

    <assign|SLASH|<macro|1|2|<makebox*|<arg|2>ex>[l]<math|<arg|1>>/>>

    <assign|pslash|<macro|<SLASH|p|.2>>>
  </hide-preamble>

  <doc-data|<doc-title|Top quark forward-backward asymmetry, FCNC decays and
  like-sign pair production as a joint probe of new
  physics>|<doc-author|<author-data|<author-name|Junjie Cao<rsup|<math|1>>,
  Lin Wang<rsup|<math|1,2>>, Lei Wu<rsup|<math|2>>, Jin Min
  Yang<rsup|<math|2>><next-line><nbsp> <vspace|-0.3cm>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    Some extensions of the Standard Model often predict a <math|Z<rprime|'>>
    gauge boson which mediates flavor-changing neutral-current (FCNC)
    interaction between up and top quarks. These new physics models are
    phenomenologically attractive because they can explain the top quark
    forward-backward asymmetry <math|A<rsup|t><rsub|F*B>> measured recently
    by the Tevatron collider. In addition, they will induce the top quark
    FCNC decays and the like-sign top pair production which can be explored
    at the LHC. In this work we focus on two such models (the left-right
    model and the <math|<math-up|U><around|(|1|)><rsub|X>> model) to
    investigate their correlated effects on <math|A<rsup|t><rsub|F*B>>, the
    FCNC decays <math|t\<to\>u*V*<around|(|V=g,Z,\<gamma\>|)>> and the
    like-sign top pair production at the LHC. We also pay special attention
    on the most recently measured <math|A<rsup|t><rsub|F*B>> in the large
    invariant mass region. We find that under the current experimental
    constrains both models can alleviate the deviation of
    <math|A<rsup|t><rsub|F*B>> and, meanwhile, enhance some FCNC decays and
    the like-sign pair production to the accessible level of the LHC.
    Further, since the two models give different predictions (for each
    observable and also for the correlation shape between different
    observables), they may even be distinguished by jointly studying these
    top quark observables.
  </abstract>>

  <section|INTRODUCTION>

  Since the top quark has a mass at weak scale and is the heaviest fermion in
  the Standard Model (SM), the top quark physics is speculated to be a
  sensitive probe for new physics beyond the SM <cite|top-review-th>. So far
  the Tevatron collider has measured many properties of the top quark and
  found good agreement with the SM predictions except for the
  forward-backward asymmetry <math|A<rsup|t><rsub|F*B>> in the top pair
  production which shows about <math|2*\<sigma\>> deviation from the
  theoretical expectation <cite|top-afb-exp1>. Although the latest analysis
  based on the <math|5.3*f*b<rsup|-1>> luminosity reduced the deviation of
  the CDF result to about <math|1.8*\<sigma\>>, it indicated that
  <math|A<rsub|F*B><rsup|t>> is dependent on the invariant mass
  (<math|M<rsub|t*<wide|t|\<bar\>>>>) and for the high invariant mass region
  (<math|M<rsub|t*<wide|t|\<bar\>>>\<geq\>450> GeV) the deviation is enlarged
  to more than <math|3*\<sigma\>> <cite|top-afb-exp2>.

  Such a <math|A<rsub|F*B><rsup|t>> deviation reported by the Tevatron has
  recently stimulated many theorists to try to give an explanation in various
  new physics models <cite|top-afb-th1|top-afb-th2|top-afb-th3|top-afb-th4>,
  among which some frameworks predict a <math|Z<rprime|'>> gauge boson
  mediating FCNC interactions between up and top quarks
  <cite|top-afb-th3|top-afb-th4>. Such <math|Z<rprime|'>>-models are
  especially interesting because, in addition to contributing to
  <math|A<rsub|F*B><rsup|t>>, they can simultaneously induce the top quark
  FCNC decays and the like-sign top pair production. As is well known, the
  FCNC interactions for the top quark in the SM are extremely suppressed
  <cite|fcnc-sm> and any observation of top quark FCNC processes will serve
  as an unambiguous evidence for new physics. The like-sign top pair
  production is also a good probe for new physics because it gives two
  isolated like-sign leptons in the final states and is free from the
  <math|t*<wide|t|\<bar\>>> background and the huge QCD <math|W>+jets
  background <cite|like-sign top-th1|like-sign top-th2|like-sign top-th3>.
  Therefore, these different observables jointly can serve as a powerful
  probe for such <math|Z<rprime|'>>-models. Further, since these observables
  are correlated in a given model and the correlation behavior may be
  model-dependent, the models may even be distinguished by jointly studying
  these top quark observables. In this work we study such correlated
  observables in two different <math|Z<rprime|'>>-models: the left-right
  model and the <math|<math-up|U><around|(|1|)><rsub|X>> model. For the
  like-sign top pair production we focus on the process at the LHC (in our
  study the charge conjugate channel, i.e., the production of
  <math|<wide|t|\<bar\>>*<wide|t|\<bar\>>> is also included), while for the
  top quark FCNC processes we focus on the FCNC decays
  <math|t\<to\>u*V*<around|(|V=g,Z,\<gamma\>|)>>. For
  <math|A<rsub|F*B><rsup|t>> we will display the total asymmetry and the
  invariant mass dependent asymmetry.

  This work is organized as follows. In Sec. II we briefly describe the two
  models and give the calculations for the observables. In Sec. III we
  present the numerical results and give some discussions. Finally, the
  conclusion is drawn in Sec. IV.

  <section|Models and Calculations>

  The extra gauge boson <math|Z<rprime|'>> is usually predicted in the
  extensions of the SM with an enlarged gauge group. In general, these models
  can be classified into two categories. One kind of models predict a family
  universal <math|Z<rprime|'>> which mediates the <math|s>-channel
  <math|t*<wide|t|\<bar\>>> production and does not have significant effect
  on <math|A<rsup|t><rsub|F*B>>. The other kind of models predict a
  non-universal <math|Z<rprime|'>> with FCNC top quark couplings (say
  <math|Z<rprime|'>*t*<wide|u|\<bar\>>>) which induces the <math|t>-channel
  <math|t*<wide|t|\<bar\>>> production and may contribute to
  <math|A<rsup|t><rsub|F*B>> sizably. Since we attempt to explain
  <math|A<rsup|t><rsub|F*B>> by new physics effects, we focus on the
  following two models which predict a non-universal <math|Z<rprime|'>>:

  <\itemize>
    <item*|(i)>Model I is a <math|U<around|(|1|)><rsub|X>> model
    <cite|top-afb-th3>. With an additional <math|U<around|(|1|)><rsub|X>>
    gauge symmetry, this model predicts a new gauge boson <math|Z<rprime|'>>
    which mediates FCNC interaction between the up and top quarks:

    <eqnarray|<tformat|<table|<row|<cell|\<cal-L\><rsub|Z<rprime|'>>>|<cell|=>|<cell|g<rsub|x>*<wide|u|\<bar\>>*\<gamma\><rsup|\<mu\>>*P<rsub|R>*t*Z<rprime|'><rsub|\<mu\>>+\<epsilon\><rsub|U>*g<rsub|x><wide|u<rsub|i>|\<bar\>>\<gamma\><rsup|\<mu\>>*P<rsub|R>*u<rsub|i>*Z<rprime|'><rsub|\<mu\>><eq-number>>>>>>

    where <math|g<rsub|x>>(<math|\<alpha\><rsub|x>=g<rsup|2><rsub|x>/4*\<pi\>>)
    and <math|\<epsilon\><rsub|U>> are coupling constants. Since such
    interactions are only for the right-handed quarks, they can safely escape
    the low energy flavor constraints <cite|top-afb-th2|top-afb-th3>. Note
    that the second term is a flavor diagonal interaction so the gauge boson
    <math|Z<rprime|'>> can have decay modes
    <math|Z<rprime|'>\<to\>u<rsub|i>*<wide|u|\<bar\>><rsub|i>> which can
    suppress the like-sign top pair production proceeding through
    <math|u*<wide|u|\<bar\>>\<to\>Z<rprime|'>*Z<rprime|'>> followed by
    <math|Z<rprime|'>\<to\>t*<wide|u|\<bar\>>> at the Tevatron
    <cite|like-sign top-ep1>. The chiral gauge anomalies in this model can be
    avoided by introducing two sets of new heavy fermions <cite|top-afb-th3>.

    <item*|(ii)>Model II is a left-right symmetric model <cite|hexg>. This
    kind of left-right symmetric models are well motivated by the
    explannation of parity violation and neutrino masses. Here we focus on a
    special left-right symmetric model called the third-generation enhanced
    left-right model, which is based on the gauge group
    <math|S*U<around|(|3|)><rsub|C>\<times\>S*U<around|(|2|)><rsub|L>\<times\>S*U<around|(|2|)><rsub|R>\<times\>U<around|(|1|)><rsub|B-L>>
    with gauge couplings <math|g<rsub|3>>, <math|g<rsub|L>>, <math|g<rsub|R>>
    and <math|g> respectively. The key feature of this model is that the
    gauge bosons of <math|S*U<around|(|2|)><rsub|R>> couple only to the
    third-generation fermions and allow for FCNC interaction at tree level
    <cite|hexg|top-afb-th4>. In our analysis, we only consider the
    potentially large contribution from the neutral gauge interactions, which
    are given by

    <\with|font-size|0.84>
      <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|\<cal-L\><rsub|Z,Z<rprime|'>>=-<frac|g<rsub|L>|2*cos
      \<theta\><rsub|W>>*<wide|q|\<bar\>>*\<gamma\><rsup|\<mu\>>*<around|(|g<rsub|V>-g<rsub|A>*\<gamma\><rsub|5>|)>*q*<around|(|cos
      \<xi\><rsub|Z>*Z<rsub|\<mu\>>-sin \<xi\><rsub|Z>*Z<rprime|'><rsub|\<mu\>>|)>>>|<row|<cell|>|<cell|>|<cell|+<frac|g<rsub|Y>|2>*tan
      \<theta\><rsub|R>*<around|(|<frac|1|3>*<wide|q|\<bar\>><rsub|L>*\<gamma\><rsup|\<mu\>>*q<rsub|L>+<frac|4|3>*<wide|u|\<bar\>><rsub|R*i>*\<gamma\><rsup|\<mu\>>*u<rsub|R*i>-<frac|2|3>*<wide|d|\<bar\>><rsub|R*i>*\<gamma\><rsup|\<mu\>>*d<rsub|R*i>|)>*<around|(|sin
      \<xi\><rsub|Z>*Z<rsub|\<mu\>>+cos \<xi\><rsub|Z>*Z<rprime|'><rsub|\<mu\>>|)>>>|<row|<cell|>|<cell|>|<cell|-<frac|g<rsub|Y>|2>*<around|(|tan
      \<theta\><rsub|R>+cot \<theta\><rsub|R>|)>*<around|(|<wide|u|\<bar\>><rsub|R*i>*\<gamma\><rsup|\<mu\>>*V<rsup|u\<ast\>><rsub|R*t*i>*V<rsup|u><rsub|R*t*j>*u<rsub|R*j>-<wide|d|\<bar\>><rsub|R*i>*\<gamma\><rsup|\<mu\>>*V<rsup|d\<ast\>><rsub|R*b*i>*V<rsup|d><rsub|R*b*j>*d<rsub|R*j>|)>*<around|(|sin
      \<xi\><rsub|Z>*Z<rsub|\<mu\>>+cos \<xi\><rsub|Z>*Z<rprime|'><rsub|\<mu\>>|)><eq-number><label|neucoup>>>>>>
    </with>

    <with|font-size|1|where <math|tan \<theta\><rsub|R>=g/g<rsub|R>>,
    <math|g<rsub|Y>=g*cos \<theta\><rsub|R>=g<rsub|R>*sin \<theta\><rsub|R>>,
    <math|\<xi\><rsub|Z>> is the mixing angle between <math|Z<rsub|R>> and
    <math|Z<rsub|0>>, <math|V<rsup|u,d><rsub|R*i*j>> are the unitary matrices
    which rotate the right-handed quarks <math|u<rsub|R*i>> and
    <math|d<rsub|R*i>> from interaction basis to mass eigenstates and the
    repeated generation indices <math|i> and <math|j> are summed. If
    <math|g<rsub|R>\<gg\>g<rsub|Y>> or equally <math|cot
    \<theta\><rsub|R>\<gg\>1>, we can see that the
    <math|Z<rprime|'>*<wide|u|\<bar\>><rsub|i*R>*u<rsub|j*R>> interaction
    will become strong. Note that a sizable <math|u<rsub|R>-t<rsub|R>> mixing
    with other flavor mixings suppressed can still avoid the severe low
    energy constraints <cite|top-afb-th3>, which is similar to model I. About
    the parameters <math|\<xi\><rsub|Z>> and <math|m<rsub|Z<rprime|'>>> in
    this model, the oblique <math|T> parameter and perturbative requirement
    will give constraints on <math|\<xi\><rsub|Z>> (versus
    <math|m<rsub|Z<rprime|'>>>) <cite|hexg>. However, such constraints are
    obtained under the requirement to explain the <math|b>-quark
    forward-backward asymmetry <math|A<rsup|b><rsub|F*B>>, which, of course,
    can be relaxed if we give up the explanation of
    <math|A<rsup|b><rsub|F*B>>. Furthermore, for the
    <math|t*<wide|t|\<bar\>>> and like-sign top pair productions, the main
    contributions are independent of the parameter <math|\<xi\><rsub|Z>>
    <cite|top-afb-th4>. Therefore, the constraints from the <math|T>
    parameter are almost irrelevant to our numerical study. We note that the
    constraints from CDF search for <math|Z<rprime|'>> and from the global
    fitting of the electroweak precision data are invalid here since these
    constraints arise mostly from the processes involving the first- or
    second-generation of fermions. So far the pertinent bound comes from
    <math|e<rsup|+>*e<rsup|->\<to\>b*<wide|b|\<bar\>>> at LEP-II, which
    requires <math|M<rsub|Z<rprime|'>>\<gtrsim\>460> GeV for <math|cot
    \<theta\><rsub|R>\<ge\>10>.>
  </itemize>

  As shown in Fig.1, both models can contribute to the
  <math|t*<wide|t|\<bar\>>> production and thus subject to the constraints
  from the measurements of the cross section and invariant mass distribution
  at the Tevatron <cite|cross section|mtt>. Note that the <math|t->channel
  diagram in Fig.1 can interfere with the QCD process, which may sizably
  alter the <math|t*<wide|t|\<bar\>>> production rate and also make
  significant contribution to <math|A<rsup|t><rsub|F*B>>. The analytic
  results for these processes are available in
  <cite|top-afb-th2|top-afb-th4>.

  <big-figure|<image|fig1.eps|10cm|3cm||> <vspace|-0.5cm><label|fig1>|Feynman
  diagrams contributing to <math|t*<wide|t|\<bar\>>> production.>

  <big-figure|<image|fig2.eps|13cm|3cm||> <vspace|-0.5cm><label|fig2>|The
  loop diagrams contributing to <math|t\<to\>u*V*<around|(|V=g,Z,\<gamma\>|)>>.>

  <big-figure|<image|fig3.eps|10cm|3cm||> <vspace|-0.5cm><label|fig3>|Feynman
  diagrams contributing to <math|t*t> production.>

  As shown in Fig.2, at loop level both models can induce the top quark FCNC
  decays <math|t\<to\>u*V*<around|(|V=g,Z,\<gamma\>|)>>. Note that in model
  II the decay mode <math|t\<to\>u*Z> can occur at tree level. The amplitudes
  of all the loop diagrams are listed in the Appendix. Of course, if
  <math|Z<rprime|'>> is much lighter than the top quark, the rare decay
  <math|t\<to\>u*Z<rprime|'>> can be also open, which may cause the tension
  between the measurements of dilepton and lepton+jets channels for
  <math|t*<wide|t|\<bar\>>> production. In additional, a recent CDF
  measurement for the events of like-sign dilepton plus b-jets severely
  constrained the heavy mass region of <math|Z<rprime|'>>. In our calculation
  we take <math|m<rsub|Z<rprime|'>>> from 120 GeV to 170 GeV to evade such
  constraints <cite|top-afb-th3>.

  Both models can induce the like-sign top pair production, as depicted in
  Fig.3. Such a production has been studied in <cite|top-afb-th2|like-sign
  top-th3>. In our study we consider its correlation with
  <math|A<rsup|t><rsub|F*B>> and the top quark FCNC decays. There are other
  channels for like-sign top pair productions, such as
  <math|u*g\<to\>t*Z<rprime|'>\<to\>t*t*<wide|u|\<bar\>>> and
  <math|u*<wide|u|\<bar\>>\<to\>Z<rprime|'>*Z<rprime|'>\<to\>t*<wide|u|\<bar\>>*t*<wide|u|\<bar\>>>,
  which, however, are suppressed both kinematically and by high order FCNC
  couplings at the LHC.

  <section|Numerical results and discussions>

  To be consistent with the mass of top quark used in the measurements, we
  choose <math|m<rsub|t>=172.5> GeV. Other SM parameters used in our
  numerical calculation are <cite|pdg>

  <eqnarray|<tformat|<table|<row|<cell|m<rsub|Z>=91.19<math-up|<nbsp>GeV>,<nbsp>sin<rsup|2>
  \<theta\><rsub|W>=0.2228,<nbsp>\<alpha\><rsub|s><around|(|m<rsub|t>|)>=0.1095,<nbsp>\<alpha\>=1/128.<eq-number>>>>>>

  Considering the experimental constraints, we scan the new physics
  parameters in the following ranges for model I and model II:

  <with|font-size|0.84|<eqnarray*|<tformat|<table|<row|<cell|>|<cell|>|<cell|<math-up|Model<nbsp>
  I:><nbsp><nbsp>120<math-up|<nbsp>GeV>\<less\>m<rsub|Z<rprime|'>>\<less\>170<math-up|<nbsp>GeV>,0.05\<less\>\<epsilon\><rsub|U>\<less\>0.1,0\<less\>\<alpha\><rsub|x>\<less\>0.05;>>|<row|<cell|>|<cell|>|<cell|<math-up|Model<nbsp>
  II:><nbsp><nbsp>500<math-up|<nbsp>GeV>\<less\>m<rsub|Z<rprime|'>>\<less\>2000<math-up|<nbsp>GeV>,10\<less\>cot
  \<theta\>\<less\>20,0.1\<less\><around|(|V<rsup|u><rsub|R>|)><rsub|u*t>\<less\>0.2,0\<less\>\<xi\><rsub|Z>\<less\>0.02.>>>>>>

  <\with|font-size|1>
    In the calculation we use the CTEQ6L parton distribution function
    <cite|cteq> and the renormalization scale <math|\<mu\><rsub|R>> and
    factorization scale <math|\<mu\><rsub|F>> are chosen to be
    <math|\<mu\><rsub|R>=\<mu\><rsub|F>=m<rsub|t>>. Due to the interference
    of the FCNC <math|t>-channel diagram with the SM QCD diagram, we require
    the total cross section and the differential cross section in each bin to
    be within the <math|2*\<sigma\>> regions of their experimental values
    <cite|cross section|mtt>.

    <big-figure|<image|fig4.eps|17cm|||> <vspace|-1.5cm><label|fig4>|The
    correlations between <math|A<rsup|t><rsub|F*B>> at the Tevatron, the
    branch ratio of top FCNC decays and the cross section of the like-sign
    top pair production at the LHC with <math|<sqrt|s>=14> TeV.>

    <big-figure|<vspace|-0.5cm><image|fig5.eps|15cm|12cm||>
    <vspace|-1.0cm><label|fig6>|Top quark forward-backward asymmetry at the
    Tevatron versus <math|t*<wide|t|\<bar\>>> invariant mass.>

    For each model, we show in Fig.4 the correlations between the
    <math|A<rsup|t><rsub|F*B>> at the Tevatron, the branch ratios of top FCNC
    decays and the cross section of the like-sign top pair production at the
    LHC with <math|<sqrt|s>=14>TeV. We see that for
    <math|A<rsup|t><rsub|F*B>> each model can improve the theoretical
    prediction, allaying the deviation from the experimental value.
    Especially, for model I the theoretical prediction of
    <math|A<rsup|t><rsub|F*B>> can be improved to agree with the experimental
    value at <math|1*\<sigma\>> level. Since the new <math|t>-channel
    contributions will modify the <math|t*<wide|t|\<bar\>>> invariant mass
    distribution, we further investigate their effects on the mass-dependent
    <math|A<rsup|t><rsub|F*B>> which is measured by CDF recently. In the
    calculation of <math|A<rsup|t><rsub|F*B>>, we multiply a K-factor
    (<math|\<sim\>1.31>) <cite|k-factor> to normalize the total cross section
    in the SM to the NLO value. From Fig.5 we see that each model can enhance
    the theoretical value of <math|A<rsup|t><rsub|F*B>> in the large
    invariant mass region and ameliorate the deviation from the experimental
    data. But still the deviation remains larger than <math|2*\<sigma\>>.

    For the top FCNC decays, the present experimental bounds are still weak,
    such as <math|B*r*<around|(|t\<to\>u*g|)>\<less\>0.02%> from D0
    <cite|tug>, <math|B*r*<around|(|t\<to\>u*\<gamma\>|)>\<less\>0.75%> from
    ZEUS <cite|tur>, <math|B*r*<around|(|t\<to\>u*Z|)>\<less\>3.7%> from CDF
    <cite|tuz>. From Fig.4 we see that the branch ratios of these processes
    in the two models are far below the current upper bounds and unlikely to
    reach the sensitivity of the LHC (<math|\<sim\>O<around|(|10<rsup|-6>|)>>
    <cite|top-review-th>) except for the decay <math|t\<to\>u*Z> in model II
    which occurs at tree level and thus can be quite large. Actually,
    although these FCNC decays are usually greatly enhanced in the popular
    new physics models such as low energy supersymmetry <cite|fcnc-susy>,
    technicolor <cite|fcnc-tc> or little Higgs theory <cite|fcnc-lh>,
    detecting such rare decays at the LHC is still quite challanging. For the
    like sign top pair production, we see from Fig.4 that the maximal
    production rate at the LHC can reach 6.8 pb for model I and 3.7 pb for
    model II, which, as discussed below, could be detectable at the LHC. Note
    that both models could also cause sizable top polarization asymmetry in
    <math|t*<wide|t|\<bar\>>> production at the LHC <cite|top-afb-th2|wulei>.

    The different observables are correlated in a given model, as shown in
    Fig.4. The correlation shapes are quite different for the two models.
    Further, as shown in Fig.6, some kinematical distributions (the top quark
    transverse momentum <math|p<rsup|t><rsub|T>> and its pseudo-rapidity
    <math|\<eta\><rsub|t>>, the total transverse energy <math|H<rsub|T>> of
    the process and the separation between the two <math|b>-jets
    <math|\<Delta\>*R<rsub|b*b>\<equiv\><sqrt|<around|(|\<Delta\>*\<phi\>|)><rsup|2>+<around|(|\<Delta\>*\<eta\>|)><rsup|2>>>
    <nbsp>) for the like-sign top pair production at the LHC are also quite
    different for the two models due to their different values of
    <math|M<rsub|Z<rprime|'>>>. All these differences may be useful for
    distinguishing the models.

    <big-figure|<vspace|-1.0cm><image|fig6.eps|17cm|15cm||>
    <vspace|-2.0cm><label|fig6>|The <math|p<rsup|t><rsub|T>>,
    <math|\<eta\><rsub|t>>, <math|\<Delta\>*R<rsub|b*b>> and <math|H<rsub|T>>
    distributions for the like sign top pair production at the LHC.>

    Now we study the observability of the like-sign top pair production at
    the LHC. The like-sign top pair can be identified as a same-charge lepton
    pair plus <math|b>-jets. To be more realistic, we simulate the energy
    resolution of the detector effects by assuming a Gaussian smearing for
    the final leptons and jets <cite|enery resolution>

    <eqnarray|<tformat|<table|<row|<cell|<frac|\<Delta\>*E|E>=<frac|5%|<sqrt|E>>\<oplus\>0.55%,<nbsp><nbsp><nbsp><nbsp><math-up|for<nbsp><nbsp>leptons>;<eq-number>>>|<row|<cell|<frac|\<Delta\>*E|E>=<frac|100%|<sqrt|E>>\<oplus\>5%<nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><math-up|for<nbsp><nbsp>jets><nbsp><nbsp><nbsp><nbsp><nbsp>;<eq-number>>>>>>

    where <math|E> is in GeV, and <math|\<oplus\>> indicates that the
    energy-dependent and energy-independent terms are added in qaudrature.
    Furthermore, we take the <math|b>-jet tagging efficiency as <math|50%>.
    The main backgrounds are from <math|q*q<rprime|'>\<to\>t*<wide|t|\<bar\>>*W<rsup|\<pm\>>>
    and <math|q*q\<to\>W<rsup|\<pm\>>*q<rprime|'>*W<rsup|\<pm\>>*q<rprime|'>>,
    which have been studied in <cite|like-sign top-th2>. In our analysis we
    take the same cuts as in <cite|like-sign top-th2> for the signal:

    <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|p<rsub|T><rsup|\<ell\>>\<gtr\>15<math-up|<nbsp>GeV>,<nbsp>E<rsup|j><rsub|T>\<gtr\>40<math-up|<nbsp>GeV>,<nbsp><around|\||\<eta\><rsub|\<ell\>>|\|>,<around|\||\<eta\><rsub|j>|\|>\<less\>2.5,<nbsp>\<Delta\>*R<rsub|\<ell\>*j>,\<Delta\>*R<rsub|j*j>\<gtr\>0.4>>|<row|<cell|>|<cell|>|<cell|M*<around|(|\<ell\><rsub|1>*j<rsub|1>|)>,M*<around|(|\<ell\><rsub|2>*j<rsub|2>|)>\<less\>160<math-up|<nbsp>GeV>,<nbsp>M*<around|(|\<ell\>*\<ell\>*j*j|)>\<gtr\>500<math-up|<nbsp>GeV><eq-number>>>>>>

    Here <math|E<rsub|T>> denotes the transverse energy and <math|M> is the
    invariant mass of the final states. Note that the numerical results
    displayed in Figs.4 and 6 for the like-sign top pair production were
    obtained with the above kinematic cuts. From the
    <math|\<Delta\>*R<rsub|b*b>> distribution in Fig. 6 we see that the
    distribution exhibits a peak at large <math|\<Delta\>*R<rsub|b*b>> (near
    <math|\<theta\><rsub|b*b>=\<pi\>>) because the two <math|b>-jets come
    from the back-to-back top pair and they are expected to fly into the
    opposite directions. Compared with model I, the heavier
    <math|Z<rprime|'>> in model II will produce the more energetic lepton and
    jet, and then lead to the larger <math|H<rsub|T>> and <math|p<rsub|T>>.
    It is also interesting to notice that the pseudo-rapid distribution shows
    two peaks for model I and one peak for model II.

    <big-figure|<vspace|-1.0cm><image|fig7.eps|15cm|9cm||>
    <vspace|-1.0cm><label|fig7>|The 3<math|\<sigma\>> sensitivity contour for
    the like sign top pair at the LHC. The region above each curve is the
    corresponding 3<math|\<sigma\>> observable region. Here
    <math|C<rsub|x>>'s denote respectively <math|\<alpha\><rsub|x>> and
    <math|V<rsub|t*u><rsup|2>*<around|(|cot \<theta\>+tan
    \<theta\>|)><rsup|2>> for model I and model II.>

    Combining our signal calculation with the background calculation in
    <cite|like-sign top-th2>, we in Fig.7 plot the <math|3*\<sigma\>>
    sensitivity for the like-sign top pair production at the LHC with a
    luminosity of <math|100<nbsp>f*b<rsup|-1>>, where the region above each
    curve is the corresponding observable region. We see that for each model
    there are still a large parameter space in which the like-sign top pair
    production can be above the <math|3*\<sigma\>> sensitivity of the LHC.
  </with>

  <section|conclusion>

  <with|font-size|1|We studied the correlated effects on
  <math|A<rsup|t><rsub|F*B>> at the Tevatron, the FCNC decays
  <math|t\<to\>u*V*<around|(|V=g,Z,\<gamma\>|)>> and the like-sign top pair
  production at the LHC in two new physics models: the left-right model and
  the <math|<math-up|U><around|(|1|)><rsub|X>> model. For
  <math|A<rsup|t><rsub|F*B>> we also investigated its mass dependent
  predictions and compared with the recent CDF results. The deviation of the
  mass dependent <math|A<rsup|t><rsub|F*B>> is found to be improved in both
  models. For each model the production rate of the like-sign top pair at the
  LHC can be large and accessible in a large parameter space. Further, since
  these two models give different predictions for each observable and also
  for the correlation between different observables, these top quark
  observables may be useful for distinguishing the different models.>

  <section*|Acknowledgement>

  <with|font-size|1|This work was supported in part by HASTIT under grant No.
  2009HASTIT004, by the National Natural Science Foundation of China (NNSFC)
  under grant Nos. 10821504, 10725526, 10775039, 11075045 and by the Project
  of Knowledge Innovation Program (PKIP) of Chinese Academy of Sciences under
  grant No. KJCX2.YW.W10.>

  <section|Analytic expressions for FCNC decay amplitudes >

  <\with|font-size|1>
    Here we list the loop amplitude expressions for the processes
    <math|t\<to\>u*V*<around|(|V=g,\<gamma\>,Z|)>> shown in Fig.2 for model I
    and model II. The notation <math|<around|(|u,t|)>> represents the
    <math|u,t> quark appearing respectively in the propagators.

    For model I the amplitudes are given by
  </with>

  <\with|font-size|0.84>
    <eqnarray|<tformat|<table|<row|<cell|\<cal-M\><rsup|<around|(|a|)>><rsub|g><around|(|u,t|)>>|<cell|=>|<cell|a*g<rsub|s>*T<rsup|A><rsub|\<beta\>*\<alpha\>>*<wide|u|\<bar\>><around|(|p<rsub|u>|)>[-4*C<rsup|1*\<nu\>*\<rho\>>*\<gamma\><rsub|\<rho\>>-\<gamma\><rsup|\<nu\>>+2*B<rsub|0><rsup|1>*\<gamma\><rsup|\<nu\>>-2*<around|(|<slashed>p<rsub|t>-<slashed>p<rsub|u>|)>*\<gamma\><rsup|\<nu\>>*\<gamma\><rsup|\<rho\>>*C<rsub|\<rho\>><rsup|1>]P<rsub|R>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|g>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|b|)>><rsub|g><around|(|u,t|)>>|<cell|=>|<cell|a*g<rsub|s>*T<rsup|A><rsub|\<beta\>*\<alpha\>>*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsup|2><rsub|1>+1|)>*m<rsub|t><slashed>p<rsub|u>*\<gamma\><rsup|\<nu\>>*P<rsub|L>|p<rsub|u><rsup|2>-m<rsub|t><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|g>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|c|)>><rsub|g><around|(|u,t|)>>|<cell|=>|<cell|a*g<rsub|s>*T<rsup|A><rsub|\<beta\>*\<alpha\>>*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsub|1><rsup|3>+1|)>*m<rsub|t><rsup|2>*\<gamma\><rsup|\<nu\>>*P<rsub|R>|p<rsub|t><rsup|2>-m<rsub|u><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|g>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|a|)>><rsub|\<gamma\>><around|(|u,t|)>>|<cell|=>|<cell|<frac|2|3>*e*a*<wide|u|\<bar\>><around|(|p<rsub|u>|)>[-4*C<rsup|2*\<nu\>*\<rho\>>*\<gamma\><rsub|\<rho\>>-\<gamma\><rsup|\<nu\>>+2*B<rsub|0><rsup|4>*\<gamma\><rsup|\<nu\>>-2*<around|(|<slashed>p<rsub|t>-<slashed>p<rsub|u>|)>*\<gamma\><rsup|\<nu\>>*\<gamma\><rsup|\<rho\>>*C<rsub|\<rho\>><rsup|2>]P<rsub|R>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|\<gamma\>>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|b|)>><rsub|\<gamma\>><around|(|u,t|)>>|<cell|=>|<cell|<frac|2|3>*e*a*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsup|5><rsub|1>+1|)>*m<rsub|t><slashed>p<rsub|u>*\<gamma\><rsup|\<nu\>>*P<rsub|L>|p<rsub|u><rsup|2>-m<rsub|t><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|\<gamma\>>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|c|)>><rsub|\<gamma\>><around|(|u,t|)>>|<cell|=>|<cell|<frac|2|3>*e*a*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsub|1><rsup|6>+1|)>*m<rsub|t><rsup|2>*\<gamma\><rsup|\<nu\>>*P<rsub|R>|p<rsub|t><rsup|2>-m<rsub|u><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|\<gamma\>>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|a|)>><rsub|Z><around|(|u|)>>|<cell|=>|<cell|-a*\<delta\><rsub|\<alpha\>*\<beta\>>*g*<wide|u|\<bar\>><around|(|p<rsub|u>|)>*<around|(|<frac|2|3>*sin
    \<theta\><rsub|W>*tan \<theta\><rsub|W>|)>[-4*C<rsup|3*\<nu\>*\<rho\>>*\<gamma\><rsub|\<rho\>>-\<gamma\><rsup|\<nu\>>+2*B<rsub|0><rsup|7>*\<gamma\><rsup|\<nu\>>>>|<row|<cell|>|<cell|>|<cell|-2*<around|(|<slashed>p<rsub|t>-<slashed>p<rsub|u>|)>*\<gamma\><rsup|\<nu\>>*\<gamma\><rsup|\<rho\>>*C<rsub|\<rho\>><rsup|3>]P<rsub|R>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|Z>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|a|)>><rsub|Z><around|(|t|)>>|<cell|=>|<cell|-a*\<delta\><rsub|\<alpha\>*\<beta\>>*g*<wide|u|\<bar\>><around|(|p<rsub|u>|)>*<around*|[|<frac|m<rsub|t><rsup|2>|cos
    \<theta\><rsub|W>>*C<rsub|0><rsup|4>*\<gamma\><rsup|\<nu\>>*P<rsub|R>+<frac|2|3>*sin
    \<theta\><rsub|W>*tan \<theta\><rsub|W>|[>-4*C<rsup|4*\<nu\>*\<rho\>>*\<gamma\><rsub|\<rho\>>>>|<row|<cell|>|<cell|>|<cell|-\<gamma\><rsup|\<nu\>>+2*B<rsub|0><rsup|8>*\<gamma\><rsup|\<nu\>>-2*<around|(|<slashed>p<rsub|t>-<slashed>p<rsub|u>|)>*\<gamma\><rsup|\<nu\>>*\<gamma\><rsup|\<rho\>>*C<rsub|\<rho\>><rsup|4>]P<rsub|R>*<around*|]|u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|Z>|)>|\<nobracket\>><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|b|)>><rsub|Z><around|(|u,t|)>>|<cell|=>|<cell|-a*\<delta\><rsub|\<alpha\>*\<beta\>>*g*<wide|u|\<bar\>><around|(|p<rsub|u>|)><around|(|<frac|4*sin<rsup|2>
    \<theta\><rsub|W>-3|6*cos \<theta\><rsub|W>>|)>*<around*|[|<frac|<around|(|2*B<rsup|9><rsub|1>+1|)>*m<rsub|t><slashed>p<rsub|u>*\<gamma\><rsup|\<nu\>>*P<rsub|L>|p<rsub|u><rsup|2>-m<rsub|t><rsup|2>>*<around*|]|u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|Z>|)>|\<nobracket\>>|\<nobracket\>><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|c|)>><rsub|Z><around|(|u,t|)>>|<cell|=>|<cell|-a*\<delta\><rsub|\<alpha\>*\<beta\>>*g*<wide|u|\<bar\>><around|(|p<rsub|u>|)>*<around|(|<frac|2|3>*sin
    \<theta\><rsub|W>*tan \<theta\><rsub|W>|)><frac|<around|(|2*B<rsub|1><rsup|10>+1|)>*m<rsub|t><rsup|2>*\<gamma\><rsup|\<nu\>>*P<rsub|R>|p<rsub|t><rsup|2>-m<rsub|u><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|Z>|)>,<eq-number>>>>>>

    where <math|p<rsub|t>> and <math|p<rsub|u>> denote respectively the
    momenta of the top and up quark, and the loop functions <math|B> and
    <math|C> are defined in <cite|loop> and use LoopTools <cite|Hahn> in the
    calculations. The loop functions' dependence on the momentum and mass is
    given by

    <eqnarray*|<tformat|<table|<row|<cell|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|B<rsup|1><around|(|u|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|u>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|1><around|(|t|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|2><around|(|u|)>=B(-p<rsub|u>,m<rsub|u>,m<rsub|Z<rprime|'>>),>>|<row|<cell|B<rsup|2><around|(|t|)>=B(-p<rsub|u>,m<rsub|t>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|3><around|(|u|)>=B(-p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|3><around|(|t|)>=B(-p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>),>>|<row|<cell|B<rsup|4><around|(|u|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|u>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|4><around|(|t|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|5><around|(|u|)>=B(-p<rsub|u>,m<rsub|u>,m<rsub|Z<rprime|'>>),>>|<row|<cell|B<rsup|5><around|(|t|)>=B(-p<rsub|u>,m<rsub|t>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|6><around|(|u|)>=B(-p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|6><around|(|t|)>=B(-p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>),>>|<row|<cell|B<rsup|7><around|(|u|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|u>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|8><around|(|t|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|9><around|(|u|)>=B(-p<rsub|u>,m<rsub|u>,m<rsub|Z<rprime|'>>),>>|<row|<cell|B<rsup|9><around|(|t|)>=B(-p<rsub|u>,m<rsub|t>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|10><around|(|u|)>=B(-p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|10><around|(|t|)>=B(-p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>)<nbsp><nbsp><nbsp><nbsp>>>>>>>>>>>

    <eqnarray*|<tformat|<table|<row|<cell|C<rsup|1><around|(|u|)>>|<cell|=>|<cell|C(-p<rsub|u>,p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>,m<rsub|u>),<nbsp><nbsp><nbsp><nbsp>C<rsup|1><around|(|t|)>=C(-p<rsub|u>,p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>),<nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp>>>|<row|<cell|C<rsup|2><around|(|u|)>>|<cell|=>|<cell|C(-p<rsub|u>,p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>,m<rsub|u>),<nbsp><nbsp><nbsp><nbsp>C<rsup|2><around|(|t|)>=C(-p<rsub|u>,p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>)>>|<row|<cell|C<rsup|3><around|(|u|)>>|<cell|=>|<cell|C(-p<rsub|u>,p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>,m<rsub|u>),<nbsp><nbsp><nbsp><nbsp>C<rsup|4><around|(|t|)>=C(-p<rsub|u>,p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>).<nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp>>>>>>

    For model II the amplitudes are given by

    <eqnarray|<tformat|<table|<row|<cell|\<cal-M\><rsup|<around|(|a|)>><rsub|g><around|(|u|)>>|<cell|=>|<cell|b*g<rsub|s>*T<rsub|\<beta\>*\<alpha\>><rsup|A>*<wide|u|\<bar\>><around|(|p<rsub|u>|)>[-4*C<rsup|1*\<nu\>*\<rho\>>*\<gamma\><rsub|\<rho\>>-\<gamma\><rsup|\<nu\>>+2*B<rsub|0><rsup|1>*\<gamma\><rsup|\<nu\>>-2*<around|(|<slashed>p<rsub|t>-<slashed>p<rsub|u>|)>*\<gamma\><rsup|\<nu\>>*\<gamma\><rsup|\<rho\>>*C<rsub|\<rho\>><rsup|1>]g<rsup|u><rsub|Z<rprime|'>*R>*P<rsub|R>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|g>|)><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|a|)>><rsub|g><around|(|t|)>>|<cell|=>|<cell|b*g<rsub|s>*T<rsub|\<beta\>*\<alpha\>><rsup|A>*<wide|u|\<bar\>><around|(|p<rsub|u>|)><around|{||[>-4*C<rsup|2*\<nu\>*\<rho\>>*\<gamma\><rsub|\<rho\>>-\<gamma\><rsup|\<nu\>>+2*B<rsub|0><rsup|2>*\<gamma\><rsup|\<nu\>>-2*<around|(|<slashed>p<rsub|t>-<slashed>p<rsub|u>|)>*\<gamma\><rsup|\<nu\>>*\<gamma\><rsup|\<rho\>>*C<rsub|\<rho\>><rsup|2>]g<rsup|t><rsub|Z<rprime|'>*R>*P<rsub|R>>>|<row|<cell|>|<cell|>|<cell|+8*m<rsub|t>*C<rsup|2*\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|L>-4*m<rsub|t>*<around|(|p<rsub|u>-p<rsub|t>|)><rsup|\<nu\>>*C<rsup|2><rsub|0>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|L>}u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|g>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|b|)>><rsub|g><around|(|u|)>>|<cell|=>|<cell|b*g<rsub|s>*T<rsub|\<beta\>*\<alpha\>><rsup|A>*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsup|3><rsub|1>+1|)>*m<rsub|t><slashed>p<rsub|u>*\<gamma\><rsup|\<nu\>>*g<rsup|u><rsub|Z<rprime|'>*R>*P<rsub|L>|p<rsub|u><rsup|2>-m<rsub|t><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|g>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|b|)>><rsub|g><around|(|t|)>>|<cell|=>|<cell|b*g<rsub|s>*T<rsub|\<beta\>*\<alpha\>><rsup|A>*<wide|u|\<bar\>><around|(|p<rsub|u>|)>{<around|(|2*B<rsup|4><rsub|1>+1|)>*m<rsub|t><slashed>p<rsub|u>*\<gamma\><rsup|\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*R>*P<rsub|L>+<around|(|4*B<rsup|4><rsub|0>-2|)>*m<rsub|t><slashed>p<rsub|u>*\<gamma\><rsup|\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|L>>>|<row|<cell|>|<cell|>|<cell|+<around|(|4*B<rsup|4><rsub|0>-2|)>*m<rsub|t><rsup|2>*\<gamma\><rsup|\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|R>}<frac|u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|g>|)>|p<rsub|u><rsup|2>-m<rsub|t><rsup|2>><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|c|)>><rsub|g><around|(|u|)>>|<cell|=>|<cell|b*g<rsub|s>*T<rsub|\<beta\>*\<alpha\>><rsup|A>*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsub|1><rsup|5>+1|)>*m<rsub|t><rsup|2>*\<gamma\><rsup|\<nu\>>*g<rsup|u><rsub|Z<rprime|'>*R>*P<rsub|R>|p<rsub|t><rsup|2>-m<rsub|u><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|g>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|c|)>><rsub|g><around|(|t|)>>|<cell|=>|<cell|b*g<rsub|s>*T<rsub|\<beta\>*\<alpha\>><rsup|A>*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsub|1><rsup|6>+1|)>*m<rsub|t><rsup|2>*\<gamma\><rsup|\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*R>*P<rsub|R>+<around|(|4*B<rsub|0><rsup|6>-2|)>*m<rsub|t>*\<gamma\><rsup|\<nu\>><slashed>p<rsub|t>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|L>|p<rsub|t><rsup|2>-m<rsub|u><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|g>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|a|)>><rsub|\<gamma\>><around|(|u|)>>|<cell|=>|<cell|<frac|2|3>*e*b*<wide|u|\<bar\>><around|(|p<rsub|u>|)>[-4*C<rsup|3*\<nu\>*\<rho\>>*\<gamma\><rsub|\<rho\>>-\<gamma\><rsup|\<nu\>>+2*B<rsub|0><rsup|7>*\<gamma\><rsup|\<nu\>>-2*<around|(|<slashed>p<rsub|t>-<slashed>p<rsub|u>|)>*\<gamma\><rsup|\<nu\>>*\<gamma\><rsup|\<rho\>>*C<rsub|\<rho\>><rsup|3>]g<rsup|u><rsub|Z<rprime|'>*R>*P<rsub|R>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|\<gamma\>>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|a|)>><rsub|\<gamma\>><around|(|t|)>>|<cell|=>|<cell|<frac|2|3>*e*b*<wide|u|\<bar\>><around|(|p<rsub|u>|)><around|{||[>-4*C<rsup|4*\<nu\>*\<rho\>>*\<gamma\><rsub|\<rho\>>-\<gamma\><rsup|\<nu\>>+2*B<rsub|0><rsup|8>*\<gamma\><rsup|\<nu\>>-2*<around|(|<slashed>p<rsub|t>-<slashed>p<rsub|u>|)>*\<gamma\><rsup|\<nu\>>*\<gamma\><rsup|\<rho\>>*C<rsub|\<rho\>><rsup|4>]g<rsup|t><rsub|Z<rprime|'>*R>*P<rsub|R>>>|<row|<cell|>|<cell|>|<cell|+8*m<rsub|t>*C<rsup|4*\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|L>-4*m<rsub|t>*<around|(|p<rsub|u>-p<rsub|t>|)><rsup|\<nu\>>*C<rsup|4><rsub|0>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|L>}u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|\<gamma\>>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|b|)>><rsub|\<gamma\>><around|(|u|)>>|<cell|=>|<cell|<frac|2|3>*e*b*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsup|9><rsub|1>+1|)>*m<rsub|t><slashed>p<rsub|u>*\<gamma\><rsup|\<nu\>>*g<rsup|u><rsub|Z<rprime|'>*R>*P<rsub|L>|p<rsub|u><rsup|2>-m<rsub|t><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|\<gamma\>>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|b|)>><rsub|\<gamma\>><around|(|t|)>>|<cell|=>|<cell|<frac|2|3>*e*b*<wide|u|\<bar\>><around|(|p<rsub|u>|)>{<around|(|2*B<rsup|10><rsub|1>+1|)>*m<rsub|t><slashed>p<rsub|u>*\<gamma\><rsup|\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*R>*P<rsub|L>+<around|(|4*B<rsup|10><rsub|0>-2|)>*m<rsub|t><slashed>p<rsub|u>*\<gamma\><rsup|\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|L>>>|<row|<cell|>|<cell|>|<cell|+<around|(|4*B<rsup|10><rsub|0>-2|)>*m<rsub|t><rsup|2>*\<gamma\><rsup|\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|R>}<frac|u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|\<gamma\>>|)>|p<rsub|u><rsup|2>-m<rsub|t><rsup|2>><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|c|)>><rsub|\<gamma\>><around|(|u|)>>|<cell|=>|<cell|<frac|2|3>*e*b*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsub|1><rsup|11>+1|)>*m<rsub|t><rsup|2>*\<gamma\><rsup|\<nu\>>*g<rsup|u><rsub|Z<rprime|'>*R>*P<rsub|R>|p<rsub|t><rsup|2>-m<rsub|u><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|\<gamma\>>|)><eq-number>>>|<row|<cell|\<cal-M\><rsup|<around|(|c|)>><rsub|\<gamma\>><around|(|t|)>>|<cell|=>|<cell|<frac|2|3>*e*b*<wide|u|\<bar\>><around|(|p<rsub|u>|)><frac|<around|(|2*B<rsub|1><rsup|12>+1|)>*m<rsub|t><rsup|2>*\<gamma\><rsup|\<nu\>>*g<rsup|t><rsub|Z<rprime|'>*R>*P<rsub|R>+<around|(|4*B<rsub|0><rsup|12>-2|)>*m<rsub|t>*\<gamma\><rsup|\<nu\>><slashed>p<rsub|t>*g<rsup|t><rsub|Z<rprime|'>*L>*P<rsub|L>|p<rsub|t><rsup|2>-m<rsub|u><rsup|2>>*u<around|(|p<rsub|t>|)>*\<varepsilon\><rsup|\<ast\>><rsub|\<nu\>><around|(|p<rsub|\<gamma\>>|)>,<eq-number>>>>>>
  </with>

  <with|font-size|1|where the loop function dependence is given by >

  <\with|font-size|0.84>
    <eqnarray*|<tformat|<table|<row|<cell|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|B<rsup|1><around|(|u|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|u>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|2><around|(|t|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|3><around|(|u|)>=B(-p<rsub|u>,m<rsub|u>,m<rsub|Z<rprime|'>>)>>|<row|<cell|B<rsup|4><around|(|t|)>=B(-p<rsub|u>,m<rsub|t>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|5><around|(|u|)>=B(-p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|6><around|(|t|)>=B(-p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>)>>|<row|<cell|B<rsup|7><around|(|u|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|u>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|8><around|(|t|)>=B<around|(|p<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>|)>,<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|9><around|(|u|)>=B(-p<rsub|u>,m<rsub|u>,m<rsub|Z<rprime|'>>)>>|<row|<cell|B<rsup|10><around|(|t|)>=B(-p<rsub|u>,m<rsub|t>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|11><around|(|u|)>=B(-p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>),<nbsp><nbsp><nbsp><nbsp>>|<cell|B<rsup|12><around|(|t|)>=B(-p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>)<nbsp><nbsp><nbsp><nbsp>>>>>>>>>>>

    <eqnarray*|<tformat|<table|<row|<cell|C<rsup|1><around|(|u|)>=C(-p<rsub|u>,p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>,m<rsub|u>),<nbsp><nbsp><nbsp><nbsp>C<rsup|2><around|(|t|)>=C(-p<rsub|u>,p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>)<nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp>>>|<row|<cell|C<rsup|3><around|(|u|)>=C(-p<rsub|u>,p<rsub|t>,m<rsub|u>,m<rsub|Z<rprime|'>>,m<rsub|u>),<nbsp><nbsp><nbsp><nbsp>C<rsup|4><around|(|t|)>=C(-p<rsub|u>,p<rsub|t>,m<rsub|t>,m<rsub|Z<rprime|'>>,m<rsub|t>)<nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp><nbsp>>>>>>
  </with>

  <with|font-size|1|The constants in the above equations are given by >

  <\with|font-size|0.84>
    <eqnarray|<tformat|<table|<row|<cell|a>|<cell|=>|<cell|-<frac|i|16*\<pi\><rsup|2>>*\<epsilon\><rsub|\<mu\>>*g<rsup|2><rsub|x>,<eq-number>>>|<row|<cell|b>|<cell|=>|<cell|<frac|i|16*\<pi\><rsup|2>>*<frac|e<rsup|2>*V<rsup|u\<ast\>><rsub|R*t*u>*V<rsup|u><rsub|R*t*t>|4*cos<rsup|2>
    \<theta\><rsub|W>*sin \<theta\><rsub|W>>*<around|(|tan
    \<theta\><rsub|R>+cot \<theta\><rsub|R>|)><eq-number>>>|<row|<cell|g<rsup|u,t><rsub|Z<rprime|'>*L>>|<cell|=>|<cell|<around|(|1-<frac|4|3>*sin<rsup|2>
    \<theta\><rsub|W>|)>*\<xi\>+<frac|1|3>*sin \<theta\><rsub|W>*tan
    \<theta\><rsub|R>,<eq-number>>>|<row|<cell|g<rsup|u><rsub|Z<rprime|'>*R>>|<cell|=>|<cell|-<frac|4|3>*sin<rsup|2>
    \<theta\><rsub|W>*\<xi\>+<frac|4|3>*sin \<theta\><rsub|W>*tan
    \<theta\><rsub|R><eq-number>>>|<row|<cell|g<rsup|t><rsub|Z<rprime|'>*R>>|<cell|=>|<cell|-<frac|4|3>*sin<rsup|2>
    \<theta\><rsub|W>*\<xi\>+<frac|1|3>*sin \<theta\><rsub|W>*tan
    \<theta\><rsub|R>-sin \<theta\><rsub|W>*cot
    \<theta\><rsub|R><eq-number>>>>>>

    <\thebibliography|99>
      <bibitem|top-review-th>For top quark reviews, see, e.g., W.
      Bernreuther, <JPG|3>5, 083001,(2008) D. Chakraborty, J. Konigsberg, D.
      Rainwater, <with|font-shape|italic|Ann. Rev. Nucl. Part. Sci.>
      <with|font-series|bold|53>, 301 (2003); E.<nbsp>H.<nbsp>Simmons,
      hep-ph/0211335; C.-P. Yuan, hep-ph/0203088; S. Willenbrock,
      hep-ph/0211067; M. Beneke, <with|font-shape|italic|et al.>,
      hep-ph/0003033; T. Han, arXiv:0804.3178; For model-independent new
      physics study, see, e.g., C. T. Hill and S. J. Parke, <PRD|4>9, 4454
      (1994); K. Whisnant, <with|font-shape|italic|et al.>, <PRD|5>6, 467
      (1997); J. M. Yang, B.-L. Young, <PRD|5>6, 5907 (1997); K. Hikasa,
      <with|font-shape|italic|et al.>, <PRD|5>8, 114003 (1998); J. A.
      Aguilar-Saavedra, arXiv:0811.3842; R.A. Coimbra,
      <with|font-shape|italic|et al.>, arXiv:0811.1743.

      <bibitem|top-afb-exp1>G.<nbsp>Stricker <with|font-shape|italic|et al.>,
      CDF note 9724 (2009); T.<nbsp>Aaltonen <with|font-shape|italic|et al.>
      [CDF Collaboration], Phys. Rev. Lett. 101, 202001 (2008);
      V.<nbsp>M.<nbsp>Abazov <with|font-shape|italic|et al.> [D0
      Collaboration], Phys. Rev. Lett. 100, 142002 (2008).

      <bibitem|top-afb-exp2>T.<nbsp>Aaltonen <with|font-shape|italic|et al.>
      [The CDF Collaboration], arXiv:1101.0034 [hep-ex].

      <bibitem|top-afb-th1>A.<nbsp>Djouadi <with|font-shape|italic|et al.>,
      <PRD|8>2, 071702 (2010); P.<nbsp>Ferrario, G.<nbsp>Rodrigo, <PRD|8>0,
      051701 (2009); K.<nbsp>Cheung, W.<nbsp>Y.<nbsp>Keung,
      T.<nbsp>C.<nbsp>Yuan, <PLB|6>82, 287 (2009); S.<nbsp>Jung
      <with|font-shape|italic|et al.>, <PRD|8>1, 015004 (2010); J.<nbsp>Shu,
      T.<nbsp>Tait, K.<nbsp>Wang, <PRD|8>1, 034012 (2010);
      P.<nbsp>H.<nbsp>Frampton, J.<nbsp>Shu, K.<nbsp>Wang, <PRD|6>83, 294
      (2010); A.<nbsp>Arhrib, R.<nbsp>Benbrik, C.<nbsp>H.<nbsp>Chen,
      <PRD|8>2, 034034 (2010); I.<nbsp>Dorsner <with|font-shape|italic|et
      al.>, <PRD|8>1, 055009 (2010); D.<nbsp>W.<nbsp>Jung
      <with|font-shape|italic|et al.>, <PLB|6>91, 238 (2010); V.<nbsp>Ahrens
      <with|font-shape|italic|et al.>, JHEP <with|font-series|bold|1009>, 097
      (2010); M.<nbsp>V.<nbsp>Martynov, A.<nbsp>D.<nbsp>Smirnov, Mod. Phys.
      Lett. A <with|font-series|bold|25>, 2637 (2010); R. S. Chivukula, E. H.
      Simmons, C.-P. Yuan, <PRD|8>2, 094009 (2010); Q.-H.<nbsp>Cao
      <with|font-shape|italic|et al.>, Phys. Rev.
      <with|font-series|bold|D81>, 114004 (2010); G.<nbsp>Rodrigo and
      P.<nbsp>Ferrario, arXiv:1007.4328; V. Barger, W.-Y. Keung, C.-T. Yu,
      <PRD|8>1, 113009 (2010); M.<nbsp>Bauer <with|font-shape|italic|et al.>,
      JHEP 1011, 039 (2010); C. Zhang, S. Willenbrock, arXiv:1008.3869;
      J.<nbsp>A.<nbsp>Aguilar-Saavedra, <NPB|8>43, 638 (2011);
      C.<nbsp>H.<nbsp>Chen, G.<nbsp>Cvetic, C.<nbsp>S.<nbsp>Kim,
      arXiv:1009.4165; K.<nbsp>Kumar <with|font-shape|italic|et al.>, JHEP
      1008, 052 (2010); C.<nbsp>Degrande <with|font-shape|italic|et al.>,
      arXiv:1010.6304 [hep-ph]; B.<nbsp>Xiao, Y.-K. Wang,
      S.<nbsp>h.<nbsp>Zhu, <PRD|8>2, 034026 (2010); arXiv:1011.0152;
      arXiv:1101.2507; G.<nbsp>Burdman, L. Lima, R.<nbsp>D.<nbsp>Matheus,
      arXiv:1011.6380; E.<nbsp>Alvarez, L. Rold, A.<nbsp>Szynkman,
      arXiv:1011.6557; D.<nbsp>W.<nbsp>Jung <with|font-shape|italic|et al.>,
      arXiv:1012.0102; K.<nbsp>Cheung, T.<nbsp>C.<nbsp>Yuan, arXiv:1101.1445.

      <bibitem|top-afb-th2>D.<nbsp>W.<nbsp>Jung, P.<nbsp>Ko and
      J.<nbsp>S.<nbsp>Lee, arXiv:1011.5976; D.<nbsp>Choudhury
      <with|font-shape|italic|et al.>, arXiv:1012.4750.

      <bibitem|top-afb-th3>S.<nbsp>Jung, H.<nbsp>Murayama, A.<nbsp>Pierce and
      J.<nbsp>D.<nbsp>Wells, <PRD|8>1, 015004 (2010).

      <bibitem|top-afb-th4>J. Cao <with|font-shape|italic|et al.>, <PRD|8>1,
      014016 (2010);

      <bibitem|fcnc-sm>G.<nbsp>Eilam, J.<nbsp>L.<nbsp>Hewett and
      A.<nbsp>Soni, <PRD|4>4, 1473 (1991); B.<nbsp>Mele, S.<nbsp>Petrarca and
      A.<nbsp>Soddu, <PLB|4>35, 401 (1998).

      <bibitem|like-sign top-th1>T.<nbsp>Stelzer, Z.<nbsp>Sullivan and
      S.<nbsp>Willenbrock, <PRD|5>8, 094021 (1998); W.<nbsp>S.<nbsp>Hou
      <with|font-shape|italic|et al.>, <PLB|4>09, 344 (1997); F.<nbsp>Larios
      and F.<nbsp>Penunuri, J. Phys. G 30, 895 (2004); J.<nbsp>Cao
      <with|font-shape|italic|et al.>, <PRD|7>0, 114035 (2004); O.<nbsp>Cakir
      <with|font-shape|italic|et al.>, Eur. Phys. J. C 70, 295 (2010);

      <bibitem|like-sign top-th2>Yu.<nbsp>P.<nbsp>Gouz and
      S.<nbsp>R.<nbsp>Slabospitsky, <PLB|4>57, 177 (1999).

      <bibitem|like-sign top-th3>S.<nbsp>K.<nbsp>Gupta, arXiv:1011.4960
      [hep-ph].

      <bibitem|like-sign top-ep1>T.<nbsp>Aaltonen <with|font-shape|italic|et
      al.> [CDF Collaboration], Phys. Rev. Lett. 102, 041801 (2009);

      <bibitem|hexg>X.<nbsp>G.<nbsp>He and G.<nbsp>Valencia, <PRD|6>6, 013004
      (2002); <PRD|6>8, 033011 (2003).

      <bibitem|cross section>T.<nbsp>Aaltonen <with|font-shape|italic|et al.>
      [The CDF Collaboration], <PRD|8>2, 052002 (2010);

      <bibitem|mtt>T.<nbsp>Aaltonen <with|font-shape|italic|et al.> [CDF
      Collaboration], <PRL|1>02, 222003 (2009).

      <bibitem|pdg>C. Amsler <with|font-shape|italic|et al.>, Particle Data
      Group, <PLB|6>67, 1 (2008).

      <bibitem|cteq>J.<nbsp>Pumplin <with|font-shape|italic|et al.>, JHEP
      0602, 032 (2006).

      <bibitem|k-factor>M.<nbsp>Cacciari <with|font-shape|italic|et al.>,
      JHEP 0809, 127 (2008); S.<nbsp>Moch and P.<nbsp>Uwer, <PRD|7>8, 034003
      (2008); N.<nbsp>Kidonakis and R.<nbsp>Vogt, <PRD|7>8, 074005 (2008);

      <bibitem|tug>V.<nbsp>M.<nbsp>Abazov <with|font-shape|italic|et al.> [D0
      Collaboration], <PLB|6>93, 81 (2010).

      <bibitem|tur>S.<nbsp>Chekanov <with|font-shape|italic|et al.> [ZEUS
      Collaboration], <PLB|5>59, 153 (2003).

      <bibitem|tuz>T.<nbsp>Aaltonen <with|font-shape|italic|et al.> [CDF
      Collaboration], Phys. Rev. Lett. 101, 192002 (2008).

      <bibitem|fcnc-susy>See, e.g., C.<nbsp>S.<nbsp>Li,
      R.<nbsp>J.<nbsp>Oakes, J.<nbsp>M.<nbsp>Yang, <PRD|4>9, 293 (1994);
      G.<nbsp>Couture, C.<nbsp>Hamzaoui, H.<nbsp>Konig, <PRD|5>2, 1713
      (1995); J.<nbsp>L.<nbsp>Lopez, D.<nbsp>V.<nbsp>Nanopoulos,
      R.<nbsp>Rangarajan, <PRD|5>6, 3100 (1997); J.<nbsp>M.<nbsp>Yang,
      B.<nbsp>L.<nbsp>Young, X.<nbsp>Zhang, <PRD|5>8, 055001 (1998);
      J.<nbsp>M.<nbsp>Yang, C.<nbsp>S.<nbsp>Li, <PRD|4>9, 3412 (1994);
      J.<nbsp>Guasch, J.<nbsp>Sola, <NPB|5>62, 3 (1999); G.<nbsp>Eilam
      <with|font-shape|italic|et al.>, <PLB|5>10, 227 (2001);
      C.<nbsp>S.<nbsp>Li, L.<nbsp>Yang, L.<nbsp>Jin, <PLB|5>99, 92 (2004);
      Z.<nbsp>Heng <with|font-shape|italic|et al.>, <PRD|7>9, 094029 (2009);
      J.<nbsp>Cao <with|font-shape|italic|et al.>, <PRD|7>9, 054003 (2009);
      <PRD|7>5, 075021 (2007); <PRD|7>4, 031701 (2006); <NPB|6>51, 87 (2003).

      <bibitem|fcnc-tc>X.<nbsp>Wang <with|font-shape|italic|et al.>,
      <PRD|5>0, 5781 (1994); G.<nbsp>Lu <with|font-shape|italic|et al.>,
      <PRD|6>8, 015002 (2003); J.<nbsp>Cao <with|font-shape|italic|et al.>,
      <PRD|7>6, 014004 (2007); <PRD|6>7, 071701 (2003);
      H.<nbsp>J.<nbsp>Zhang, <PRD|7>7, 057501 (2008).

      <bibitem|fcnc-lh>X.-F.<nbsp>Han, L.<nbsp>Wang, J.<nbsp>M.<nbsp>Yang,
      arXiv:0903.5491; X.<nbsp>Wang, <with|font-shape|italic|et al.>,
      <NPB|8>07, 210 (2009); Y.<nbsp>Zhang, G.<nbsp>Lu, X.<nbsp>Wang,
      arXiv:1011.0552;

      <bibitem|wulei>J. Cao, L. Wu, J. M. Yang, arXiv:1011.5564 [hep-ph].

      <bibitem|enery resolution>G.<nbsp>Aad <with|font-shape|italic|et al.>
      [The ATLAS Collaboration], arXiv:0901.0512 [hep-ex].

      <bibitem|loop>B.<nbsp>A.<nbsp>Kniehl, Phys. Rep. 240, 211 (1994).

      <bibitem|Hahn>T.<nbsp>Hahn, M.<nbsp>Perez-Victoria, Comput. Phys.
      Commun. <with|font-series|bold|118>, 153 (1999); T.<nbsp>Hahn, Nucl.
      Phys. Proc. Suppl. <with|font-series|bold|135>, 333 (2004).
    </thebibliography>
  </with>
</body>