<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <\hide-preamble>
    <assign|CP|<macro|<math|C*<space|-0.17em>P>>>

    <assign|en|<macro|<math|e<rsup|->>>>

    <assign|ep|<macro|<math|e<rsup|+>>>>

    <assign|mup|<macro|<math|\<mu\><rsup|+>>>>

    <assign|mun|<macro|<math|\<mu\><rsup|->>>>

    <assign|ellm|<macro|<math|\<ell\><rsup|->>>>

    <assign|ellp|<macro|<math|\<ell\><rsup|+>>>>

    <assign|W|<macro|<math|W>>>

    <assign|Wp|<macro|<math|W<rsup|+>>>>

    <assign|Wm|<macro|<math|W<rsup|->>>>

    <assign|Wpm|<macro|<math|W<rsup|\<pm\>>>>>

    <assign|Wmp|<macro|<math|W<rsup|\<mp\>>>>>

    <assign|b|<macro|<math|b>>>

    <assign|bbar|<macro|<math|<wide|b|\<bar\>>>>>

    <assign|t|<macro|<math|t>>>

    <assign|tbar|<macro|<math|<wide|t|\<bar\>>>>>

    <assign|piz|<macro|<math|\<pi\><rsup|0>>>>

    <assign|pip|<macro|<math|\<pi\><rsup|+>>>>

    <assign|pim|<macro|<math|\<pi\><rsup|->>>>

    <assign|Kbar|<macro|<kern>0.2em<wide|<kern>-0.2em K|\<bar\>>>>

    <assign|Kb|<macro|<math|<Kbar>>>>

    <assign|Kz|<macro|<math|K<rsup|0>>>>

    <assign|Kzb|<macro|<math|<Kbar><rsup|0>>>>

    <assign|Kp|<macro|<math|K<rsup|+>>>>

    <assign|Km|<macro|<math|K<rsup|->>>>

    <assign|KS|<macro|<math|K<rsup|0><rsub|<with|math-level|2|S>>>>>

    <assign|B|<macro|<math|B>>>

    <assign|Bbar|<macro|<kern>0.18em<wide|<kern>-0.18em B|\<bar\>>>>

    <assign|Bb|<macro|<math|<Bbar>>>>

    <assign|Bz|<macro|<math|B<rsup|0>>>>

    <assign|Bzb|<macro|<math|<Bbar><rsup|0>>>>

    <assign|Bu|<macro|<math|B<rsup|+>>>>

    <assign|Bub|<macro|<math|B<rsup|->>>>

    <assign|Bp|<macro|<math|<Bu>>>>

    <assign|Bm|<macro|<math|<Bub>>>>

    <assign|Bs|<macro|<math|B<rsub|s>>>>

    <assign|Bsb|<macro|<math|<Bbar><rsub|s>>>>

    <assign|jpsi|<macro|<math|J<mskip>-3*mu/<mskip>-2*mu
    \<psi\><mskip>2*mu>>>

    <assign|bpsiks|<macro|<math|<Bz>\<to\><jpsi><KS>>>>

    <assign|tprime|<macro|<math|t<rprime|'>>>>

    <assign|bprime|<macro|<math|b<rprime|'>>>>

    <assign|TTT|<macro|<math|T<rsub|2/3>>>>

    <assign|TFT|<macro|<math|T<rsub|5/3>>>>

    <assign|Qbar|<macro|<kern>0.08em<wide|<kern>-0.08em Q|\<bar\>>>>

    <assign|invfb|<macro|<space|0.17em>fb<rsup|<math|-1>>>>

    <assign|mev|<macro|<math|<with|math-font-family|rm|<space|0.17em>Me<kern>-0.1em
    V>>>>

    <assign|mevc|<macro|<math|<with|math-font-family|rm|<space|0.17em>Me<kern>-0.1em
    V<space|-0.17em>/>c>>>

    <assign|mevcc|<macro|<math|<with|math-font-family|rm|<space|0.17em>Me<kern>-0.1em
    V<space|-0.17em>/>c<rsup|2>>>>

    <assign|gev|<macro|<math|<with|math-font-family|rm|<space|0.17em>Ge<kern>-0.1em
    V>>>>

    <assign|gevc|<macro|<math|<with|math-font-family|rm|<space|0.17em>Ge<kern>-0.1em
    V<space|-0.17em>/>c>>>

    <assign|gevcnospace|<macro|<math|<with|math-font-family|rm|<space|0.17em>Ge<kern>-0.1em
    V<space|-0.17em>/>c>>>

    <assign|gevcc|<macro|<math|<with|math-font-family|rm|<space|0.17em>Ge<kern>-0.1em
    V<space|-0.17em>/>c<rsup|2>>>>

    <assign|missET|<macro|<math|<neg|<space|-0.17em>><space|-0.17em>
    E<rsub|T>>>>
  </hide-preamble>

  <doc-data|<doc-title|Search for High Mass Resonances Decaying to Muon Pairs
  in <math|<sqrt|s>=1.96> TeV <math|p<wide|p|\<bar\>>>
  Collisions>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    We present a search for a new narrow, spin-1, high mass resonance
    decaying to <math|\<mu\><rsup|+>*\<mu\><rsup|->+X>, using a matrix
    element based likelihood and a simultaneous measurement of the resonance
    mass and production rate. In data with 4.6 fb<rsup|<math|-1>> of
    integrated luminosity collected by the CDF detector in
    <math|p<wide|p|\<bar\>>> collisions at <math|<sqrt|s>=1960> GeV, the most
    likely signal cross section is consistent with zero at 16% confidence
    level. We therefore do not observe evidence for a high mass resonance,
    and place limits on models predicting spin-1 resonances, including
    <math|M\<gtr\>1071> GeV/<math|c<rsup|2>> at 95% confidence level for a
    <math|Z<rprime|'>> boson with the same couplings to fermions as the
    <math|Z> boson.
  </abstract>>

  <input>March2010<rsub|A>uthors.tex

  We report a search for a narrow spin-1 resonance (<math|Z<rprime|'>>) with
  decays to muon pairs and a mass between 130 GeV/<math|c<rsup|2>> and
  <math|\<approx\>1> TeV/<math|c<rsup|2>>. Such a resonance is predicted
  generically in models with additional gauge groups <cite|langacker>, a
  feature of many extensions to the standard model of particle physics (SM).
  Typical examples are Little Higgs models <cite|littlehiggs> and the
  next-to-minimal supersymmetric model <cite|nmssm>.

  Current 95% confidence level (CL) lower limits on the mass of a
  <math|Z<rprime|'>> boson with the same couplings to fermions as the
  <math|Z> boson (<math|Z<rprime|'><rsub|S*M>>) are <math|1030>
  GeV/<math|c<rsup|2>> from a search of CDF dimuon data with 2.3
  fb<rsup|<math|-1>> of integrated luminosity<nbsp><cite|zprimetemp>, and
  <math|1023> GeV/<math|c<rsup|2>> <cite|d0ee> and <math|963>
  GeV/<math|c<rsup|2>> <cite|cdfee> from respective searches in dielectron
  data from D0 in 5.4 fb<rsup|<math|-1>> and from CDF in 2.5
  fb<rsup|<math|-1>>, respectively.

  This Letter reports a new search of the CDF dimuon data with several
  significant enhancements: twice the integrated luminosity, a matrix element
  based likelihood providing an approximately 20% relative increase in cross
  section sensitivity at large <math|Z<rprime|'>> mass, and a new statistical
  approach designed to maximize simultaneously both discovery potential and
  mass exclusion limits in searches for new physics. This new approach
  directly fits the data to a single <math|Z<rprime|'>> boson hypothesis in
  the plane of boson mass and signal cross section, and can be applied to any
  search for a hypothetical new particle of unknown mass.

  We use a data sample corresponding to an integrated luminosity of 4.6
  fb<rsup|<math|-1>>, collected with the CDF II detector<nbsp><cite|cdf>, a
  general purpose detector designed to study <math|p<wide|p|\<bar\>>>
  collisions at the Fermilab Tevatron. The tracking system consists of a
  cylindrical open-cell drift chamber and silicon microstrip detectors in a
  1.4<nbsp>T magnetic field parallel to the beam axis. The silicon detectors
  provide tracking information for pseudorapidity
  <math|<around|\||\<eta\>|\|>\<less\>2><nbsp><cite|coordinates> and are used
  to reconstruct collision and decay points. The drift chamber surrounds the
  silicon detectors and gives full coverage in the central pseudorapidity
  region (<math|<around|\||\<eta\>|\|>\<less\>1>). For the muon kinematics
  relevant to this search, the tracker provides an invariant mass resolution
  of <math|\<delta\>*M/M<rsup|2>\<approx\>0.17>%/TeV/<math|c<rsup|2>>.
  Electromagnetic and hadronic calorimeters surrounding the tracking system
  measure energy from particle showers and minimum ionizing particles such as
  muons. Drift chambers and scintillators located outside the calorimeters
  detect muons in the central pseudorapidity region
  <math|<around|\||\<eta\>|\|>\<less\>1>.

  Events used for this search are selected online with a trigger requiring a
  muon candidate with <math|p<rsub|T>\<gtr\>18> GeV/<math|c>. The event
  selection is unchanged from the previous search<nbsp><cite|zprimetemp>,
  requiring at least two oppositely charged muons with
  <math|p<rsub|T>\<gtr\>30> GeV<math|/c> and no identified cosmic rays
  <cite|cosmics>. Each muon is required to have calorimeter deposits
  consistent with a minimum ionizing particle and have a track fully within
  the fiducial volume of the drift chamber. At least one muon must have an
  associated muon-chamber track.

  The dominant and irreducible background is standard model
  <math|Z/\<gamma\><rsup|\<ast\>>> production with subsequent decay to muons.
  We model this background using events generated at leading order by
  <with|font-shape|small-caps|pythia> <cite|pythia> with the
  <with|font-shape|small-caps|cteq6l><nbsp><cite|cteq> parton distribution
  functions (PDF). Events are reweighted by the ratio of
  next-to-next-to-leading order to leading-order cross sections as a function
  of dimuon mass<nbsp><cite|carena>. We use the standard CDF simulation
  <cite|cdfsim> to model the detector response to the particles in the event.
  The overall normalization of this background is derived from data near the
  <math|Z> boson pole mass, <math|70\<less\>M<rsub|\<mu\>*\<mu\>>\<less\>110>
  GeV<math|/c<rsup|2>>.

  The remaining background contributions are small relative to standard model
  sources of dimuons. Decays of <math|W*W> (1%) and <math|t*<wide|t|\<bar\>>>
  (1%) to dimuons are described using <with|font-shape|small-caps|pythia> and
  the CDF detector simulation, normalized to NLO cross
  sections<nbsp><cite|ttandww>. The background from objects misidentified as
  muons (0.5%) is estimated using the distribution of calorimeter energy in
  the vicinity of each candidate muon in the sample<nbsp><cite|topdil>.
  Cosmic ray backgrounds (<math|\<less\>0.01%>) are modeled using identified
  cosmic ray events, weighted by the probability to survive the cosmic ray
  removal algorithm<nbsp><cite|cosmics>.

  The observed spectrum of dimuon invariant mass
  (<math|M<rsub|\<mu\>*\<mu\>>>) is in good agreement with the total SM plus
  cosmic-ray prediction, as shown in Fig.<nbsp><reference|fig:mm>. We expect
  <math|1851\<pm\>90> events with <math|M<rsub|\<mu\>*\<mu\>>\<gtr\>130>
  GeV/<math|c<rsup|2>>, and observe 1813 events.

  We model the production and decay of a spin-1 resonance
  <math|Z<rprime|'><rsub|S*M>> using <with|font-shape|small-caps|madevent><nbsp><cite|madgraph>,
  assuming fermionic couplings equal to those of the <math|Z> boson.
  Initial-state QCD radiation, hadronization, and showering are modelled with
  <with|font-shape|small-caps|pythia>. The acceptance for <math|Z<rprime|'>>
  boson events varies with mass, increasing from 20% at 200
  GeV<math|/c<rsup|2>> to nearly 40% at 1 TeV/<math|c<rsup|2>>, then dropping
  for <math|M<rsub|Z<rprime|'>>\<gtr\>1> TeV/<math|c<rsup|2>> due to lack of
  initial-state partons with sufficient momentum.

  <\big-figure>
    <image|paper_mumumass.eps|0.7tex-line-width|||><next-line><image|paper_mumumass_sub.eps|0.7tex-line-width|||><label|fig:mm>
  </big-figure|Top: The distributions of <math|M<rsub|\<mu\>*\<mu\>>> for
  data with 4.6 fb<rsup|<math|-1>> of integrated luminosity (triangles) and
  expected SM backgrounds (histograms) with two example
  <math|Z<rprime|'><rsub|S*M>> signals. Bottom: The relative difference
  between observed and expected data, as a function of dimuon mass. Error
  bars show statistical uncertainty. >

  The previous CDF search <cite|zprimetemp> used a binned likelihood fit with
  bins uniform in the inverse of the reconstructed dimuon mass to extract the
  best-fit signal cross section at a range of masses. That approach weighted
  events in the same reconstructed inverse mass bin equally, independent of
  expected track resolutions. We improve on this method by using an unbinned
  likelihood that includes a theoretical model of the full kinematics of the
  event and the event-by-event knowledge of the muon <math|p<rsub|T>>
  resolution. Well-measured events have narrower likelihoods, reflecting the
  higher quality of their information and making a stronger impact on the
  fitted result. The likelihood is then used both to set limits on the
  <math|Z<rprime|'>> cross section as a function of mass and to construct a
  2D interval that gives a well-defined discovery condition. The likelihood
  is given by

  <\equation*>
    L<around|(|M<rsub|Z<rprime|'>>,s<rsub|Z<rprime|'>>|)>=<frac|<around|(|N<rsub|b*g+Z<rprime|'>>|)><rsup|N>*e<rsup|-<around|(|N<rsub|b*g+Z<rprime|'>>|)>>|N!>*<big|prod><rsup|N><rsub|i>L<around|(|x<rsub|i>\|M<rsub|Z<rprime|'>>,s<rsub|Z<rprime|'>>|)>,
  </equation*>

  <no-indent>where <math|M<rsub|Z<rprime|'>>> is the <math|Z<rprime|'>> pole
  mass, <math|N> is the number of events in the data,
  <math|N<rsub|b*g,Z<rprime|'>>> are the number of events due to background
  and <math|Z<rprime|'>> signal, <math|x<rsub|i>> represents the observed
  kinematics of the <math|i>-th event, and
  <math|s<rsub|Z<rprime|'>>=N<rsub|Z<rprime|'>>/<around|(|N<rsub|b*g>+N<rsub|Z<rprime|'>>|)>>.
  The dependence of the per-event likelihood is given by

  <\equation*>
    L<around|(|x<rsub|i>\|M<rsub|Z<rprime|'>>,s<rsub|Z<rprime|'>>|)>=s<rsub|Z<rprime|'>>*L<rsub|Z<rprime|'>><around|(|x<rsub|i>\|M<rsub|Z<rprime|'>>|)>+<around|(|1-s<rsub|Z<rprime|'>>|)>*L<rsub|Z/\<gamma\><rsup|\<ast\>>><around|(|x<rsub|i>|)>,
  </equation*>

  <no-indent>and the likelihood <math|L<rsub|Z<rprime|'>>> is calculated by
  integrating the matrix element for <math|Z<rprime|'>> production convolved
  with PDFs and the detector resolution functions:

  <\equation*>
    L<rsub|Z<rprime|'>>*<around|(|x<rsub|i>=p<rsub|1>,p<rsub|2>,\<sigma\><rsub|p<rsub|T*1>>,\<sigma\><rsub|p<rsub|T*2>>,N<rsub|<math-up|jets>>\|M<rsub|Z<rprime|'>>|)>=
  </equation*>

  <\equation*>
    <big|int>d*\<Phi\><around|(|q<rsub|1>,q<rsub|2>|)><around|\||\<cal-M\><rsub|Z<rprime|'>><around|(|q<rsub|1>,q<rsub|2>,M<rsub|Z<rprime|'>>|)>|\|><rsup|2>*f<rsub|P*D*F><rsup|p>*f<rsub|P*D*F><rsup|<wide|p|\<bar\>>>
  </equation*>

  <\equation*>
    \<times\>\<times\>T<around|(|p<rsub|1>,q<rsub|1>,\<sigma\><rsub|p<rsub|T*1>>|)>*T<around|(|p<rsub|2>,q<rsub|2>,\<sigma\><rsub|p<rsub|T*2>>|)>\<times\>P<rsub|P*T>*<around|(|q<rsub|1>+q<rsub|2>,N<rsub|<math-up|jets>>|)>,
  </equation*>

  <no-indent>where <math|p<rsub|1,2>> represent the four-vectors of the two
  measured muons, <math|q<rsub|1,2>> represent the unknown four-vectors of
  the two true muons, <math|\<Phi\>> represents phase space for the true
  muons, <math|\<cal-M\>> is the matrix element, <math|f<rsub|P*D*F>> is the
  parton distribution function, <math|T<around|(|p,q,\<sigma\><rsub|p<rsub|T>>|)>>
  is the transfer function that parametrizes the detector resolution as a
  function of the measured uncertainty <math|\<sigma\><rsub|p<rsub|T>>>, and
  <math|P<rsub|P*T>> is the probability density function for <math|p<rsub|T>>
  of the <math|\<mu\>*\<mu\>> system, parameterized in the number of jets
  (<math|N<rsub|j*e*t*s>>) with <math|E<rsub|T>\<gtr\>15> GeV and
  <math|<around|\||\<eta\>|\|>\<less\>2.5>. The distributions of
  <math|\<sigma\><rsub|p<rsub|T>>> for the <math|Z<rprime|'>> signal and
  dominant <math|Z/\<gamma\><rsup|\<ast\>>> background are the same in the
  phase space region near the hypothesized <math|Z<rprime|'>> mass, thus they
  do not affect the likelihood ratio ordering. The distribution of
  <math|P<rsub|P*T>> is obtained from simulated samples with initial- and
  final-state radiation. An analogous expression is used for
  <math|L<rsub|Z/\<gamma\><rsup|\<ast\>>>>, which describes the likelihood
  for the dominant <math|Z/\<gamma\><rsup|\<ast\>>> background.

  We analyze the resulting likelihood in two ways. First, we aim to discover
  the regions in <math|<around|(|M<rsub|Z<rprime|'>>,s<rsub|Z<rprime|'>>|)>>
  that are consistent with the data and inconsistent with the SM, making no
  assumptions about the relationship between <math|M<rsub|Z<rprime|'>>> and
  <math|s<rsub|Z<rprime|'>>>. We refer to this as the
  <with|font-shape|italic|2D interval> analysis. Second, we wish to set
  limits on the <math|Z<rprime|'>> mass in specific models. In that case, we
  perform a <with|font-shape|italic|raster scan>, in which we choose a set of
  values of <math|M<rsub|Z<rprime|'>>>, and at each point derive limits on
  <math|s<rsub|Z<rprime|'>>>. Together with a prediction for
  <math|s<rsub|Z<rprime|'>><around|(|M<rsub|Z<rprime|'>>|)>> in a specific
  theory, we can use the raster scan to place lower limits on
  <math|M<rsub|Z<rprime|'>>>.

  The 2D interval is constructed via the unified ordering
  scheme<nbsp><cite|feldcous> in two dimensions, resonance mass and cross
  section (see Fig.<nbsp><reference|fig:4p6>). At each test point in the
  <math|<around|(|M<rsub|Z<rprime|'>>,s<rsub|Z<rprime|'>>|)>> space, we
  calculate the ratio of the likelihood at the test point to the likelihood
  at the best-fit point where the likelihood is maximized. To determine which
  test points are consistent with the data at a given confidence level, we
  perform pseudo-experiments to determine how often we expect to observe such
  a likelihood ratio. The pseudo-experiments include all backgrounds and
  interference effects between the <math|Z> and <math|Z<rprime|'>>, as well
  as variation of the nuisance parameters from systematic uncertainties
  described below. This approach is well designed for discovery, as it tests
  the background hypothesis exactly once. The significance of an observation
  corresponds to the first confidence-level contour that includes a signal
  rate of zero. It also provides a summary of <math|Z<rprime|'>> models
  consistent with the data without relying on specific model details. In the
  2D interval analysis, the best-fit signal cross section of
  <math|\<sigma\>=26> fb occurs at a resonance mass of <math|M=199>
  GeV/<math|c<rsup|2>>, but is consistent with zero at 16% confidence level.

  <\big-figure>
    <image|paper_1d.eps|0.7tex-line-width|||><next-line><image|paper_2d.eps|0.7tex-line-width|||><label|fig:4p6>
  </big-figure|Observed 95% CL limits in 1D raster scan (top) and 2D
  intervals (bottom) for data with 4.6 fb<rsup|<math|-1>> of integrated
  luminosity. The solid circle indicates the best-fit value and the lines
  define regions in which 25, 50, 68, 95, and 99% of experiments would yield
  results less consistent with the standard model and the data.>

  The raster scan is the traditional approach used in many analyses,
  including the previous <math|Z<rprime|'>> search<nbsp><cite|zprimetemp>. It
  provides mass limits on theories that enforce a relationship between the
  signal fraction and the resonance mass, and is appropriate if outside
  information indicates a particular mass is interesting. In the presence of
  a significant excess above the background-only hyphothesis, one must
  account for the number of possible <math|Z<rprime|'>> masses, each of which
  tests the background-only hypothesis: the
  <with|font-shape|italic|look-elsewhere effect>. The 2D analysis needs no
  such correction. While the resulting discovery significance of the
  corrected raster scan will be correct, one will still be left with an
  interval in the signal fraction at every mass. In contrast, in the presence
  of a signal, the 2D analysis will provide a range of masses that is
  consistent with the signal.

  <\big-figure>
    <image|limits_cucd.eps|0.95tex-line-width|||><label|fig:4p6>
  </big-figure|Observed 95% CL limits for data with 4.6 fb<rsup|<math|-1>> of
  integrated luminosity expressed as limits on the up and down type charges
  <math|c<rsub|u>> and <math|c<rsub|d>><nbsp><cite|carena>. The solid and
  dotted lines show possible models in <math|U<around|(|1|)><rsub|B-X*L>> and
  <math|U<around|(|1|)><rsub|10+x*<wide|5|\<bar\>>>> groups, respectively.
  The dashed lines show the range for models in the
  <math|U<around|(|1|)><rsub|q+x*u>> group.>

  <\big-table>
    \ <ruledtabular| <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|r>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|4|4|cell-halign|r>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|6|6|cell-halign|r>|<cwith|1|-1|7|7|cell-halign|r>|<cwith|1|-1|8|8|cell-halign|r>|<cwith|1|-1|8|8|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|Model>|<cell|<math|Z<rprime|'><rsub|l>>>|<cell|<math|Z<rprime|'><rsub|s*e*c>>>|<cell|<math|Z<rprime|'><rsub|N>>>|<cell|<math|Z<rprime|'><rsub|\<psi\>>>>|<cell|<math|Z<rprime|'><rsub|\<chi\>>>>|<cell|<math|Z<rprime|'><rsub|\<eta\>>>>|<cell|<math|Z<rprime|'><rsub|S*M>>>>|<row|<cell|Mass
    Limit (GeV/<math|c<rsup|2>>)>|<cell|817>|<cell|858>|<cell|900>|<cell|917>|<cell|930>|<cell|938>|<cell|1071>>>>>>

    <label|tab:limits>
  </big-table|Mass limits on specific spin-1 <math|Z<rprime|'>>
  models<nbsp><cite|carena> in data with 4.6 fb<rsup|<math|-1>> of integrated
  luminosity at 95% confidence level.>

  Dominant systematic uncertainties<nbsp><cite|zprimetemp> include
  uncertainties on the PDFs and the dependence of the next-to-leading order
  cross section on the dimuon invariant mass. These weaken the final limits
  by 5-10% depending on mass. Additional uncertainties are the level of
  initial state radiation and muon acceptance at large transverse momentum.

  The raster scan in mass allows us to set strong limits on specific models
  of <math|Z<rprime|'>> production; see Fig.<nbsp><reference|fig:4p6> and
  Table <nbsp><reference|tab:limits>. The production cross section times
  branching fraction to the dimuon final state is determined by the couplings
  of the fermions to the <math|Z<rprime|'>>. Figure<nbsp><reference|fig:4p6>
  shows how mass limits depend on the charges of the up- and down-type
  fermions to the U(1) group associated with the <math|Z<rprime|'>>. Table
  <nbsp><reference|tab:limits> shows the limits for the specific models
  described in Ref<nbsp><cite|carena>.

  In conclusion, we have applied the matrix-element-based likelihood
  technique to a search for new spin-1 resonances decaying to muon pairs, set
  the strongest limits to date on the resonance cross section and mass, and
  introduced a statistical analysis approach that is useful for this analysis
  as well as for potential LHC discoveries.

  <\acknowledgments*>
    We acknowledge useful conversations with Tim Tait. We thank the Fermilab
    staff and the technical staffs of the participating institutions for
    their vital contributions. This work was supported by the U.S. Department
    of Energy and National Science Foundation; the Italian Istituto Nazionale
    di Fisica Nucleare; the Ministry of Education, Culture, Sports, Science
    and Technology of Japan; the Natural Sciences and Engineering Research
    Council of Canada; the National Science Council of the Republic of China;
    the Swiss National Science Foundation; the A.P. Sloan Foundation; the
    Bundesministerium fr Bildung und Forschung, Germany; the World Class
    University Program, the National Research Foundation of Korea; the
    Science and Technology Facilities Council and the Royal Society, UK; the
    Institut National de Physique Nucleaire et Physique des Particules/CNRS;
    the Russian Foundation for Basic Research; the Ministerio de Ciencia e
    Innovacin, and Programa Consolider-Ingenio 2010, Spain; the Slovak R&D
    Agency; and the Academy of Finland.
  </acknowledgments*>

  <\thebibliography|99>
    <bibitem|langacker>P. Langacker, Rev. Mod. Phys.
    <with|font-series|bold|81>, 1199 (2009), and references
    therein.<bibitem|littlehiggs>N. Arkani-Hamed, A. G. Cohen, and H. Georgi,
    Phys. Lett. B <with|font-series|bold|513>, 232 (2001); T. Han, H. E.
    Logan, B. McElrath and L.-T. Wang, Phys. Rev. D
    <with|font-series|bold|67>, 095004 (2003); T. Han, H. E. Logan, and L.-T.
    Wang, J. High Energy Phys. <with|font-series|bold|01>, 099 (2006); M.
    Perelstein, Prog. Part. Nucl. Phys. <with|font-series|bold|58>, 247
    (2007).<bibitem|nmssm>M. Cvetic and P. Langacker, Phys. Rev. D
    <with|font-series|bold|54>, 3570 (1996); M. Cvetic
    <with|font-shape|italic|et al.>, Phys. Rev. D <with|font-series|bold|56>,
    2861 (1997); E. Keith and E. Ma, Phys. Rev. D <with|font-series|bold|56>,
    7155 (1997); P. Langacker and J. Wang, Phys. Rev. D
    <with|font-series|bold|58>, 115010 (1998).

    <bibitem|zprimetemp>T. Aaltonen <with|font-shape|italic|et al.> (CDF
    Collaboration), Phys. Rev. Lett. <with|font-series|bold|102>, 091805
    (2009).<bibitem|d0ee>V. Abazov <with|font-shape|italic|et al.> (D0
    Collaboration), arXiv:1008.2023v1 (2010).<bibitem|cdfee>T. Aaltonen
    <with|font-shape|italic|et al.> (CDF Collaboration), Phys. Rev. Lett.
    <with|font-series|bold|102>, 031801 (2009).

    <bibitem|cdf>D.<nbsp>E.<nbsp>Acosta <with|font-shape|italic|et al.> (CDF
    Collaboration), Phys. Rev. D <with|font-series|bold|71>, 032001 (2005);
    A. Abulencia <with|font-shape|italic|et al.> (CDF Collaboration), J.
    Phys. G <with|font-series|bold|34>, 2457 (2007); T. Aaltonen
    <with|font-shape|italic|et al.> (CDF Collaboration), Phys. Rev. D
    <with|font-series|bold|77>, 112001 (2008).

    <bibitem|coordinates>CDF uses a cylindrical coordinate system with the
    <math|z> axis along the proton beam axis. Pseudorapidity is
    <math|\<eta\>\<equiv\>-ln <around|(|tan <around|(|\<theta\>/2|)>|)>>,
    where <math|\<theta\>> is the polar angle relative to the proton beam
    direction, and <math|\<phi\>> is the azimuthal angle while
    <math|p<rsub|T>=<around|\||p|\|>*sin \<theta\>>, <math|E<rsub|T>=E*sin
    \<theta\>>.

    <bibitem|cosmics>A. V. Kotwal, H. K. Gerberich, and C. Hays, Nucl.
    Instrum. Methods Phys. Res., Sect. A <with|font-series|bold|506>, 110
    (2003).

    <bibitem|pythia>T. Sjstrand <with|font-shape|italic|et al.>, Comput.
    Phys. Commun. <with|font-series|bold|135> (2001) 238 T. Sjstrand,
    Comput. Phys. Commun. <with|font-series|bold|82>, 74 (1994).

    <bibitem|cteq>J. Pumplin <with|font-shape|italic|et al.> (CTEQ
    Collaboration), J. High. Energy Phys. 07 (2002) 012.

    <bibitem|carena>M. Carena, A. Daleo, B. A. Dobrescu, and T. M. P. Tait,
    Phys. Rev. D <with|font-series|bold|70>, 093009 (2004).

    <bibitem|cdfsim>T.<nbsp>Affolder <with|font-shape|italic|et al.> (CDF
    Collaboration), Nucl. Instrum. Methods <with|font-series|bold|A447>, 1
    (2000).

    <bibitem|ttandww>J. M. Campbell and R. K. Ellis, Phys. Rev. D
    <with|font-series|bold|60>, 113006 (1999); R. Bonciani, S. Catani, M. L.
    Mangano, and P. Nason, Nucl. Phys. B <with|font-series|bold|529>, 424
    (1998); M. Cacciari <with|font-shape|italic|et al.>, J. High Energy Phys.
    04 (2004) 068.

    <bibitem|topdil>D. Acosta <with|font-shape|italic|et al.> (CDF
    Collaboration), Phys. Rev. Lett. <with|font-series|bold|93>, 142001
    (2004).

    <bibitem|madgraph>J. Alwall <with|font-shape|italic|et al.> J. High
    Energy Phys 07 (2007) 028

    <bibitem|feldcous>G.<nbsp>J.<nbsp>Feldman and R.<nbsp>D.<nbsp>Cousins,
    Phys. Rev. D <with|font-series|bold|57>, 3873 (1998).
  </thebibliography>
</body>