<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <\hide-preamble>
    <assign|be|<macro|>>

    <assign|ee|<macro|>>

    <assign|a|<macro|\<alpha\>>>

    <assign|drcn|<macro|\<delta\>R<rsup|c/n>>>

    <assign|dsb|<macro|<wide|D|\<bar\>><rsup|*0>>>

    <assign|x|<macro|X(3872)>>

    <assign|lsim|<macro|<move|<math|<above|\<sim\>|<with|math-display|false|\<less\>>>>|0pt|-0.6ex>>>

    <assign|gsim|<macro|<move|<math|<above|\<sim\>|<with|math-display|false|\<gtr\>>>>|0pt|-0.6ex>>>

    <assign|ltap|<macro|<move|<rlap|<math|\<sim\>>>|0pt|-.4ex>
    <move|<math|\<less\>>|0pt|.4ex>>>

    <assign|gtap|<macro|<move|<rlap|<math|\<sim\>>>|0pt|-.4ex>
    <move|<math|\<gtr\>>|0pt|.4ex>>>

    <assign|pp|<macro|\<psi\>(2S)>>

    <assign|jp|<macro|J/\<psi\>>>

    <assign|ypp|<macro|\<Upsilon\>(2S)>>

    <assign|yp|<macro|\<Upsilon\>>>

    <assign|yppp|<macro|\<Upsilon\>(3S)>>
  </hide-preamble>

  <doc-data|<doc-title|Neutrino-impact ionization of atoms in searches for
  neutrino magnetic moment>|<doc-author|<author-data|<author-name|Konstantin
  A. Kouzakov>>>|<doc-author|<author-data|<author-name|Alexander I.
  Studenikin>>>|<doc-author|<author-data|<author-name|Mikhail B.
  Voloshin>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    The ionization of atomic electrons by scattering of neutrinos is
    revisited. This process is the one studied in the experimental searches
    for a neutrino magnetic moment using germanium detectors. Current
    experiments are sensitive to the ionization energy comparable with the
    atomic energies, and the effects of the electron binding should be taken
    into account. We find that the so-called stepping approximation to the
    neutrino-impact ionization is in fact exact in the semiclassical limit
    and also that the deviations from this approximation are very small
    already for the lowest bound Coulomb states. We also consider the effects
    of electron-electron correlations and argue that the resulting
    corrections to the ionization of independent electrons are quite small.
    In particular we estimate that in germanium these are at a one percent
    level at the energy transfer down to a fraction of keV. Exact sum rules
    are also presented as well as analytical results for a few lowest
    hydrogen-like states.
  </abstract>>

  <section|Introduction>

  The neutrino magnetic moments (NMM) expected in the Standard Model are very
  small and proportional to the neutrino masses<nbsp><cite|fs>:
  <math|\<mu\><rsub|\<nu\>>\<approx\>3\<times\>10<rsup|-19>*<space|0.17em>\<mu\><rsub|B>*<space|0.17em><around|(|m<rsub|\<nu\>>/1*<space|0.17em>e*V|)>>
  with <math|\<mu\><rsub|B>=e/2*m> being the electron Bohr magneton, and
  <math|m> is the electron mass. Thus any larger value of
  <math|\<mu\><rsub|\<nu\>>> can arise only from physics beyond the Standard
  Model (a recent review of this subject can be found in
  Ref.<nbsp><cite|gs>). Current direct experimental
  searches<nbsp><cite|tx|ge1|ge2> for a magnetic moment of the electron
  (anti)neutrinos from reactors have lowered the upper limit on
  <math|\<mu\><rsub|\<nu\>>> down to <math|\<mu\><rsub|\<nu\>>\<less\>3.2\<times\>10<rsup|-11>*<space|0.17em>\<mu\><rsub|B>><nbsp><cite|ge2>.
  These ultra low background experiments use germanium crystal detectors
  exposed to the neutrino flux from a reactor and search for scattering
  events by measuring the energy <math|T> deposited by the neutrino
  scattering in the detector. The sensitivity of such a search to NMM
  crucially depends on lowering the threshold for the energy transfer
  <math|T>, due to the enhancement of the magnetic scattering relative to the
  standard electroweak one at low <math|T>. Namely, the differential cross
  section <math|d*\<sigma\>/d*T> is given by the incoherent sum of the
  magnetic and the standard cross section, and for the scattering on free
  electrons the NMM contribution is given by the formula<nbsp><cite|dn|ve>

  <\equation>
    <frac|d*\<sigma\><rsub|<around|(|\<mu\>|)>>|d*T>=4*\<pi\>*<space|0.17em>\<alpha\>*<space|0.17em>\<mu\><rsub|\<nu\>><rsup|2>*<space|0.17em><around*|(|<frac|1|T>-<frac|1|E<rsub|\<nu\>>>|)>=\<pi\>*<space|0.17em><frac|\<alpha\><rsup|2>|m<rsup|2>><space|0.17em><around*|(|<frac|\<mu\><rsub|\<nu\>>|\<mu\><rsub|B>>|)><rsup|2>*<space|0.17em><around*|(|<frac|1|T>-<frac|1|E<rsub|\<nu\>>>|)><nbsp><label|fe>
  </equation>

  where <math|E<rsub|\<nu\>>> is the energy of the incident neutrino, and
  displays a <math|1/T> enhancement at low energy transfer. The standard
  electroweak contribution is constant in <math|T> at
  <math|E<rsub|\<nu\>>\<gg\>T>:

  <\equation>
    <frac|d*\<sigma\><rsub|E*W>|d*T>=<frac|G<rsub|F><rsup|2>*<space|0.17em>m|2*\<pi\>>*<around*|(|1+4*<space|0.17em>sin<rsup|2>\<theta\><rsub|W>+8*<space|0.17em>sin<rsup|4>\<theta\><rsub|W>|)>*<space|0.17em><around*|[|1+O<around*|(|<frac|T|E<rsub|\<nu\>>>|)>|]>\<approx\>5\<times\>10<rsup|-48><space|0.17em><math-up|cm<rsup|2>
    / keV>.<label|sew>
  </equation>

  In what follows we refer to these two types of contribution to the
  scattering as, respectively, the magnetic and the weak.

  The current experiments have reached threshold values of <math|T> as low as
  few keV and are likely to further improve the sensitivity to low energy
  deposition in the detector. At low energies however one can expect a
  modification of the free-electron formulas (<reference|fe>) and
  (<reference|sew>) due to the binding of electrons in the germanium atoms,
  where e.g. the energy of the <math|K<rsub|\<alpha\>>> line,
  9.89<space|0.17em>keV, indicates that at least some of the atomic binding
  energies are comparable to the already relevant to the experiment values of
  <math|T>. Thus a proper treatment of the atomic effects in neutrino
  scattering is necessary and important for the analysis of the current and
  even more of the future data with a still lower threshold. Furthermore,
  there is no known means of independently calibrating experimentally the
  response of atomic systems, such as the germanium, to the scattering due to
  the interactions relevant for the neutrino experiments. Therefore one has
  to rely on a pure theoretical analysis in interpreting the neutrino data.
  This problem had been addressed numerically in the
  past<nbsp><cite|kmsf|fms> and the interest to the problem was renewed in
  several recent papers, which however are ridden by a `trial and error'
  approach. The early claim<nbsp><cite|wll> of a significant enhancement of
  the NMM contribution by the atomic effects has been later
  disproved<nbsp><cite|mv|wll2> and it was argued<nbsp><cite|mv> that the
  modification of the formulas (<reference|fe>) and (<reference|sew>) by the
  atomic binding effects is insignificant down to very low values of
  <math|T>. It has been subsequently pointed out<nbsp><cite|ks> that the
  analysis of Ref.<nbsp><cite|mv> is generally invalidated in multi-electron
  systems, including atoms with <math|Z\<gtr\>1>. Furthermore, the analysis
  of Ref.<nbsp><cite|mv> is also generally invalidated by singularities of
  the relevant correlation function in the complex plane of momentum
  transfer, so that the claimed behavior of the cross section at low <math|T>
  applies only in the semiclassical limit, although, as will be shown here,
  it gives a very good approximation to the actual behavior for an electron
  bound by a Coulomb potential.

  In this paper we revisit the subject of neutrino scattering on atoms at low
  energy transfer. We aim at describing this process at <math|T> in the range
  of few keV and lower, so that the motion of the electrons is considered as
  strictly nonrelativistic. Also in this range the energy of the dominant
  part of the incident neutrinos from the reactor is much larger than
  <math|T> and we thus neglect any terms whose relative value is proportional
  to <math|T/E<rsub|\<nu\>>> (in particular, in this range one can neglect
  the <math|1/E<rsub|\<nu\>>> term in Eq.(<reference|fe>) in comparison with
  <math|1/T>). Furthermore any recoil of the germanium atom as a whole
  results in an energy transfer less than
  <math|2*E<rsub|\<nu\>><rsup|2>/M<rsub|G*e>>, which at the typical reactor
  neutrino energy is well below the considered here keV range of the energy
  transfer. Thus we formally set the mass of the atomic nucleus to infinity
  and neglect any recoil by the atom as a whole. In particular, under these
  conditions the interaction of the neutrino with the nucleus can be entirely
  neglected, and only the scattering on the atomic electrons is to be
  considered.

  We find that in the scattering on realistic atoms, such as germanium, the
  so-called stepping approximation works with a very good accuracy. The
  stepping approach, introduced in Ref.<nbsp><cite|kmsf> from an
  interpretation of numerical data, threats the process as scattering on
  individual independent electrons occupying atomic orbitals and suggests
  that the cross section follows the free-electron behavior in
  Eqs.(<reference|fe>) and (<reference|sew>) down to <math|T> equal to the
  ionization threshold for the orbital, and that below that energy the
  electron on the corresponding orbital is `deactivated' thus producing a
  sharp `step' in the dependence of the cross section on <math|T>. In the
  present paper, we consider general relations for the discussed scattering
  on atomic systems in Sec.<nbsp><reference|genform> and present in
  Appendix<nbsp><reference|A> sum rules for the theoretical objects involved
  in the calculations<nbsp><footnote|The sum rules of
  Appendix<nbsp><reference|A> correct the omissions made in
  Ref.<nbsp><cite|mv>>. In Sec.<nbsp><reference|1e> we prove that for the
  scattering on individual electrons the stepping approximation becomes exact
  in the semiclassical limit, so that its applicability is improved with the
  principal number <math|n> of the atomic orbital. We also find by an
  explicit calculation (Appendix<nbsp><reference|B>) for a hydrogen-like
  ground state, i.e. at <math|n=1>, that the deviation from the stepping
  behavior is less than 5% at the worst point, where the energy transfer
  <math|T> is exactly at the threshold. The accuracy of the approach based on
  considering the scattering on individual electrons is limited by the
  existence of the electron-electron correlations in the process. We consider
  the correction introduced by these correlations in
  Sec.<nbsp><reference|elcorr> and, in Sec.<nbsp><reference|TF>, apply the
  derived formula to an estimate of the effect for germanium, using the
  Thomas-Fermi model. We find that the correlation correction grows at
  smaller <math|T> but is still small, of order of a few percent, for
  <math|T> in the range of a few hundred eV. We thus argue that the stepping
  approach describes the scattering cross section with a sufficient for
  practical purposes accuracy, and that it can be applied to the analysis of
  the present and future data of searches for NMM with germanium detectors
  down to the values of the energy deposition
  <math|T\<sim\>0.3><space|0.17em>keV.

  <section|General formulas for neutrino scattering on atomic
  electrons><label|genform>

  In this section we briefly recapitulate the general expressions and
  introduce the relevant atomic objects for the neutrino scattering on atomic
  electrons. We start with the magnetic process and then also apply a similar
  treatment to the standard weak part of the cross section.

  The kinematics of the scattering of a neutrino on atomic electrons is
  generally characterized by the components of the four-momentum transfer,
  the energy transfer <math|T> and the spatial momentum transfer
  <math|<wide|q|\<vect\>>>, from the neutrino to the electrons with two
  rotationally invariant variables being <math|T> and
  <math|q<rsup|2>=<wide|q|\<vect\>><space|0.17em><rsup|2>>. At small <math|T>
  the electrons can be treated nonrelativistically both in the initial and
  the final state, so that the process is that of scattering of an NMM in the
  electromagnetic field <math|A=<around|(|A<rsub|0>,<wide|A|\<vect\>>|)>> of
  the electrons: <math|A<rsub|0><around|(|<wide|q|\<vect\>>|)>=<sqrt|4*\<pi\>*\<alpha\>>*<space|0.17em>\<rho\><around|(|<wide|q|\<vect\>>|)>/<wide|q|\<vect\>><rsup|<space|0.17em>2>>,
  <math|<wide|A|\<vect\>><around|(|<wide|q|\<vect\>>|)>=<sqrt|4*\<pi\>*\<alpha\>>*<space|0.17em><wide|j|\<vect\>><around|(|<wide|q|\<vect\>>|)>/<wide|q|\<vect\>><rsup|<space|0.17em>2>>,
  where <math|\<rho\><around|(|<wide|q|\<vect\>>|)>> and
  <math|<wide|j|\<vect\>><around|(|<wide|q|\<vect\>>|)>> are the Fourier
  transforms of the electron number density and current density operators,
  respectively,

  <\equation>
    \<rho\><around|(|<wide|q|\<vect\>>|)>=<big|sum><rsub|a=1><rsup|Z>exp
    <around|(|i*<wide|q|\<vect\>>\<cdot\><wide|r|\<vect\>><rsub|a>|)><nbsp>,<label|ne>
  </equation>

  <\equation>
    <wide|j|\<vect\>><around|(|<wide|q|\<vect\>>|)>=-<frac|i|2*m>*<big|sum><rsub|a=1><rsup|Z><around*|[|exp
    <around|(|i*<wide|q|\<vect\>>\<cdot\><wide|r|\<vect\>><rsub|a>|)><frac|\<partial\>|\<partial\>*<wide|r|\<vect\>><rsub|a>>+<frac|\<partial\>|\<partial\>*<wide|r|\<vect\>><rsub|a>>*exp
    <around|(|i*<wide|q|\<vect\>>\<cdot\><wide|r|\<vect\>><rsub|a>|)>|]>,<label|ce>
  </equation>

  and the sums run over the positions <math|<wide|r|\<vect\>><rsub|a>> of all
  the <math|Z> electrons in the atom.

  In this limit the expression for the double differential cross section is
  given by<nbsp><cite|ks>

  <\equation>
    <frac|d<rsup|2>*\<sigma\><rsub|<around|(|\<mu\>|)>>|d*T*<space|0.17em>d*q<rsup|2>>=4*\<pi\>*<space|0.17em>\<alpha\>*<space|0.17em><frac|\<mu\><rsub|\<nu\>><rsup|2>|q<rsup|2>>*<space|0.17em><around*|[|<around*|(|1-<frac|T<rsup|2>|q<rsup|2>>|)>*S<around|(|T,q<rsup|2>|)>+<around*|(|1-<frac|q<rsup|2>|4*E<rsub|\<nu\>><rsup|2>>|)>*R<around|(|T,q<rsup|2>|)>|]><nbsp>,<label|d2s>
  </equation>

  where <math|S<around|(|T,q<rsup|2>|)>>, also known as the dynamical
  structure factor<nbsp><cite|vh>, and <math|R<around|(|T,q<rsup|2>|)>> are

  <\equation>
    S<around|(|T,q<rsup|2>|)>=<big|sum><rsub|n><space|0.17em>\<delta\>*<around|(|T-E<rsub|n>+E<rsub|0>|)><space|0.17em><around*|\||<around|\<langle\>|n<around|\||\<rho\><around|(|<wide|q|\<vect\>>|)>|\|>*0|\<rangle\>>|\|><rsup|2>,<label|dsf>
  </equation>

  <\equation>
    R<around|(|T,q<rsup|2>|)>=<big|sum><rsub|n><space|0.17em>\<delta\>*<around|(|T-E<rsub|n>+E<rsub|0>|)><space|0.17em><around*|\||<around|\<langle\>|n<around|\||j<rsub|\<perp\>><around|(|<wide|q|\<vect\>>|)>|\|>*0|\<rangle\>>|\|><rsup|2>,<label|dsfc>
  </equation>

  with <math|j<rsub|\<perp\>>> being the <math|<wide|j|\<vect\>>> component
  perpendicular to <math|<wide|q|\<vect\>>> and parallel to the scattering
  plane, which is formed by the incident and final neutrino momenta. The sums
  in Eqs.<nbsp>(<reference|dsf>) and<nbsp>(<reference|dsfc>) run over all the
  states <math|<around|\||n|\<rangle\>>> with energies <math|E<rsub|n>> of
  the electron system, with <math|<around|\||0|\<rangle\>>> being the initial
  state.

  Clearly, the factors <math|S<around|(|T,q<rsup|2>|)>> and
  <math|R<around|(|T,q<rsup|2>|)>> are related to respectively the
  density-density and current-current Green's functions

  <\equation>
    <around*|\<nobracket\>|<around*|\<nobracket\>|F<around|(|T,q<rsup|2>|)>=<big|sum><rsub|n><frac|<around*|\||<around|\<langle\>|n<around|\||\<rho\><around|(|<wide|q|\<vect\>>|)>|\|>*0|\<rangle\>>|\|><rsup|2>|T-E<rsub|n>+E<rsub|0>-i*<space|0.17em>\<epsilon\>><space|0.17em>=<around*|\<langle\>|0<around*|\||\<rho\>|(>-<wide|q|\<vect\>>|)>*<space|0.17em><frac|1|T-H+E<rsub|0>-i*<space|0.17em>\<epsilon\>>*<space|0.17em>\<rho\><around|(|<wide|q|\<vect\>>|)>|\|>*0|\<rangle\>><nbsp>,<label|fdef>
  </equation>

  <\equation>
    <around*|\<nobracket\>|<around*|\<nobracket\>|L<around|(|T,q<rsup|2>|)>=<big|sum><rsub|n><frac|<around*|\||<around|\<langle\>|n<around|\||j<rsub|\<perp\>><around|(|<wide|q|\<vect\>>|)>|\|>*0|\<rangle\>>|\|><rsup|2>|T-E<rsub|n>+E<rsub|0>-i*<space|0.17em>\<epsilon\>><space|0.17em>=<around*|\<langle\>|0<around*|\||j<rsub|\<perp\>>|(>-<wide|q|\<vect\>>|)>*<space|0.17em><frac|1|T-H+E<rsub|0>-i*<space|0.17em>\<epsilon\>>*<space|0.17em>j<rsub|\<perp\>><around|(|<wide|q|\<vect\>>|)>|\|>*0|\<rangle\>><nbsp>,<label|fdefc>
  </equation>

  as

  <\equation>
    S<around|(|T,q<rsup|2>|)>=<frac|1|\<pi\>><space|0.17em><math-up|Im>F<around|(|T,q<rsup|2>|)><nbsp>,<label|sfrel>
  </equation>

  <\equation>
    R<around|(|T,q<rsup|2>|)>=<frac|1|\<pi\>><space|0.17em><math-up|Im>L<around|(|T,q<rsup|2>|)><nbsp>,<label|sfrelc>
  </equation>

  with <math|H> being the Hamiltonian for the system of electrons. For small
  values of <math|q>, in particular, such that <math|q\<sim\>T>, only the
  lowest-order non-zero terms of the expansion of
  Eqs.<nbsp>(<reference|sfrel>) and<nbsp>(<reference|sfrelc>) in powers of
  <math|q<rsup|2>> are of relevance (the so-called dipole approximation). In
  this case, one has<nbsp><cite|ks>

  <\equation>
    R<around|(|T,q<rsup|2>|)>=<frac|T<rsup|2>|q<rsup|2>>*S<around|(|T,q<rsup|2>|)>.<label|da>
  </equation>

  Taking into account Eq.<nbsp>(<reference|da>), the experimentally measured
  singe-differential inclusive cross section is, to a good approximation,
  given by (see e.g. in Refs.<nbsp><cite|mv|ks>)

  <\equation>
    <frac|d*\<sigma\><rsub|<around|(|\<mu\>|)>>|d*T>=4*\<pi\>*<space|0.17em>\<alpha\>*<space|0.17em>\<mu\><rsub|\<nu\>><rsup|2>*<space|0.17em><big|int><rsub|T<rsup|2>><rsup|4*E<rsub|\<nu\>><rsup|2>><space|0.17em>S<around|(|T,q<rsup|2>|)><space|0.17em><frac|d*q<rsup|2>|q<rsup|2>><nbsp>.<label|d1s>
  </equation>

  The standard electroweak contribution to the cross section can be similarly
  expressed in terms of the same factor <math|S<around|(|T,q<rsup|2>|)>><nbsp><cite|mv>
  as

  <\equation>
    <frac|d*\<sigma\><rsub|E*W>|d*T>=<frac|G<rsub|F><rsup|2>|4*\<pi\>>*<around*|(|1+4*<space|0.17em>sin<rsup|2>\<theta\><rsub|W>+8*<space|0.17em>sin<rsup|4>\<theta\><rsub|W>|)>*<space|0.17em><big|int><rsub|T<rsup|2>><rsup|4*E<rsub|\<nu\>><rsup|2>><space|0.17em>S<around|(|T,q<rsup|2>|)>*<space|0.17em>d*q<rsup|2><nbsp>,<label|d1sw><nbsp>,
  </equation>

  where the factor <math|S<around|(|T,q<rsup|2>|)>> is integrated over
  <math|q<rsup|2>> with a unit weight, rather than <math|q<rsup|-2>> as in
  Eq.(<reference|d1s>).

  The kinematical limits for <math|q<rsup|2>> in an actual neutrino
  scattering are explicitly indicated in Eqs.(<reference|d1s>) and
  (<reference|d1sw>). At large <math|E<rsub|\<nu\>>>, typical for the reactor
  neutrinos, the upper limit can in fact be extended to infinity, since in
  the discussed here nonrelativistic limit the range of momenta
  <math|\<sim\>E<rsub|\<nu\>>> is indistinguishable from infinity. The lower
  limit can be shifted to <math|q<rsup|2>=0>, since the contribution of the
  region of <math|q<rsup|2>\<less\>T<rsup|2>> can be expressed in terms of
  the photoelectric cross section<nbsp><cite|mv> and is negligibly small (at
  the level of below one percent in the considered range of <math|T>). For
  this reason we henceforth discuss the momentum-transfer integrals in
  Eqs.<nbsp>(<reference|d1s>) and<nbsp>(<reference|d1sw>) running from
  <math|q<rsup|2>=0> to <math|q<rsup|2>=\<infty\>>:

  <\equation>
    I<rsub|1><around|(|T|)>=<big|int><rsub|0><rsup|\<infty\>><space|0.17em>S<around|(|T,q<rsup|2>|)><space|0.17em><frac|d*q<rsup|2>|q<rsup|2>><nbsp>,<space|2em><math-up|and><space|2em>I<rsub|2><around|(|T|)>=<big|int><rsub|0><rsup|\<infty\>><space|0.17em>S<around|(|T,q<rsup|2>|)>*<space|0.17em>d*q<rsup|2><nbsp>.<label|defi>
  </equation>

  For a free electron, which is initially at rest, the density-density
  correlator is the free particle Green's function

  <\equation>
    F<rsub|<around|(|F*E|)>><around|(|T,q<rsup|2>|)>=<around*|(|T-<frac|q<rsup|2>|2*m>-i*<space|0.17em>\<epsilon\>|)><rsup|-1><nbsp><label|ff>
  </equation>

  so that the dynamical structure factor is given by
  <math|S<rsub|<around|(|F*E|)>><around|(|T,q<rsup|2>|)>=\<delta\>*<around|(|T-q<rsup|2>/2*m|)>>,
  and the discussed here integrals are in the free-electron limit as follows:

  <\equation>
    I<rsub|1><rsup|<around|(|F*E|)>>=<big|int><rsub|0><rsup|\<infty\>><space|0.17em>S<rsub|<around|(|F*E|)>><around|(|T,q<rsup|2>|)><space|0.17em><frac|d*q<rsup|2>|q<rsup|2>>=<frac|1|T><nbsp>,<space|2em>I<rsub|2><rsup|<around|(|F*E|)>>=<big|int><rsub|0><rsup|\<infty\>><space|0.17em>S<rsub|<around|(|F*E|)>><around|(|T,q<rsup|2>|)>*<space|0.17em>d*q<rsup|2>=2*<space|0.17em>m<nbsp>.<label|intf>
  </equation>

  Clearly, these expressions, when used in the formulas (<reference|d1s>) and
  (<reference|d1sw>), result in the free-electron cross section in
  Eqs.<nbsp>(<reference|fe>) and<nbsp>(<reference|sew>).

  <section|Scattering on one bound electron><label|1e>

  The binding effects generally deform the density-density Green's function,
  so that both the integrals (<reference|defi>) are somewhat modified.
  Namely, the binding effects spread the free-electron <math|\<delta\>>-peak
  in the dynamical structure function at <math|q<rsup|2>=2*m*T> and also
  shift it by the scale of characteristic electron momenta in the bound
  state. However it turns out that the free electron expressions are quite
  robust in the sense that in realistic systems the modification of the
  integrals relative to their free-electron limit, are quite small. As a
  formal statement, we will show in the Appendix<nbsp><reference|A> that when
  the function <math|F<around|(|T,q<rsup|2>|)>> is analytically continued in
  complex plane of <math|q<rsup|2>> the free-electron expressions are valid
  for the integrals over <math|q<rsup|2>> extending from <math|-\<infty\>> to
  <math|+\<infty\>>, and in the case of the integral, similar to
  <math|I<rsub|2>> i.e. with the weight <math|q<rsup|0>>, this property also
  holds for scattering on multi-electron atomic systems, while for that with
  the weight <math|q<rsup|-2>> it generally holds only for the scattering on
  one electron, or on independent electrons. Clearly the latter integrals
  over the full axis of <math|q<rsup|2>> differ from those of physical
  interest in Eq.(<reference|defi>) by the contribution of negative
  <math|q<rsup|2>>, which although numerically small even at low <math|T>,
  still makes the scattering on bound electrons different from that on free
  electrons.

  In this section we consider the scattering on just one electron. The
  Hamiltonian for the electron has the form
  <math|H=p<rsup|2>/2*m+V<around|(|r|)>>, and the density-density Green's
  function from Eq.(<reference|fdef>) can be written as

  <eqnarray|<tformat|<table|<row|<cell|F<around|(|T,q<rsup|2>|)>>|<cell|=>|<cell|<around*|\<langle\>|0*<around*|\||<space|0.17em>e<rsup|-i*<wide|q|\<vect\>>\<cdot\><wide|r|\<vect\>>>*<space|0.17em><around*|[|T-H<around|(|<wide|p|\<vect\>>,<wide|r|\<vect\>>|)>+E<rsub|0>|]><rsup|-1>*<space|0.17em>e<rsup|i*<wide|q|\<vect\>>\<cdot\><wide|r|\<vect\>>><space|0.17em>|\|>*0|\<rangle\>>>>|<row|<cell|>|<cell|=>|<cell|<around*|\<langle\>|0<around*|\||<space|0.17em><around*|[|T-H*<around|(|<wide|p|\<vect\>>+<wide|q|\<vect\>>,<wide|r|\<vect\>>|)>+E<rsub|0>|]><rsup|-1><space|0.17em>|\|>*0|\<rangle\>>>>|<row|<cell|>|<cell|=>|<cell|<around*|\<langle\>|0<around*|\||<space|0.17em><around*|[|T-<frac|<wide|q|\<vect\>><rsup|<space|0.17em>2>|2*m>-<frac|<wide|p|\<vect\>>\<cdot\><wide|q|\<vect\>>|m>-H<around|(|<wide|p|\<vect\>>,<wide|r|\<vect\>>|)>+E<rsub|0>|]><rsup|-1><space|0.17em>|\|>*0|\<rangle\>><space|0.17em>,<eq-number><label|f1>>>>>>

  where the infinitesimal shift <math|T\<to\>T-i*\<epsilon\>> is implied.

  Clearly, a nontrivial behavior of the latter expression in
  Eq.(<reference|f1>) is generated by the presence of the operator
  <math|<around|(|<wide|p|\<vect\>>\<cdot\><wide|q|\<vect\>>|)>> in the
  denominator, and the fact that it does not commute with the Hamiltonian
  <math|H>. Thus an analytical calculation of the Green's function as well as
  the dynamical structure factor is feasible in only few specific problems.
  In Appendix<nbsp><reference|B> we present such a calculation for ionization
  from the <math|1*s>, <math|2*s> and <math|2*p> hydrogen-like states. In
  particular, we find that the deviation of the discussed integrals
  (<reference|defi>) from their free values are very small: the largest
  deviation is exactly at the ionization threshold, where, for instance, each
  of the <math|1*s> integrals is equal to the free-electron value multiplied
  by the factor <math|<around|(|1-7*<space|0.17em>e<rsup|-4>/3|)>\<approx\>0.957><nbsp><footnote|It
  can be also noted that both integrals are modified in exactly the same
  proportion, so that their ratio is not affected at any <math|T>:
  <math|I<rsub|2><around|(|T|)>/I<rsub|1><around|(|T|)>=2*m*<space|0.17em>T>.
  We find however that this exact proportionality is specific for the
  ionization from the ground state in the Coulomb potential.>.

  The problem of calculating the integrals (<reference|defi>) however can be
  solved in the semiclassical limit, where one can neglect the
  noncommutativity of the momentum <math|<wide|p|\<vect\>>> with the
  Hamiltonian, and rather treat this operator as a number vector. Taking also
  into account that <math|<around|(|H-E<rsub|0>|)><space|0.17em>\|0\<rangle\>=0>,
  one can then readily average the latter expression in Eq.(<reference|f1>)
  over the directions of <math|<wide|q|\<vect\>>> and find the formula for
  the dynamical structure factor:

  <\equation>
    S<around|(|T,q<rsup|2>|)>=<frac|m|2*<space|0.17em>p*<space|0.17em>q>*<space|0.17em><around*|[|\<theta\>*<around*|(|T-<frac|q<rsup|2>|2*m>+<frac|p*<space|0.17em>q|m>|)>-\<theta\>*<around*|(|T-<frac|q<rsup|2>|2*m>+<frac|p*<space|0.17em>q|m>|)>|]><nbsp>,<label|scls>
  </equation>

  where <math|p=<around|\||<wide|p|\<vect\>>|\|>> and <math|\<theta\>> is the
  standard Heaviside step function. The expression in Eq.(<reference|scls>)
  is nonzero only in the range of <math|q> satisfying the condition
  <math|-p*<space|0.17em>q/m\<less\>T-q<rsup|2>/2*m\<less\>p*<space|0.17em>q/m>,
  i.e. between the (positive) roots of the binomials in the arguments of the
  step functions: <math|q<rsub|m*i*n>=<sqrt|2*m*<space|0.17em>T+p<rsup|2>>-p>
  and <math|q<rsub|m*a*x>=<sqrt|2*m*<space|0.17em>T+p<rsup|2>>+p>. One can
  notice that the previously mentioned `spread and shift' of the peak in the
  dynamical structure function in this limit corresponds to a flat pedestal
  between <math|q<rsub|m*i*n>> and <math|q<rsub|m*a*x>>. The calculation of
  the integrals (<reference|defi>) with the expression (<reference|scls>) is
  straightforward, and yields the free-electron expressions
  (<reference|intf>) for the discussed here integrals in the semiclassical
  (WKB) limit<nbsp><footnote|The appearance of the free-electron expressions
  here is not surprising, since the equation (<reference|scls>) can be also
  viewed as the one for scattering on an electron boosted to the momentum
  <math|p>>:

  <\equation>
    I<rsub|1><rsup|<around|(|W*K*B|)>>=<frac|1|T><nbsp>,<space|2em>I<rsub|2><rsup|<around|(|W*K*B|)>>=2*<space|0.17em>m<nbsp>.<label|wkbi>
  </equation>

  The difference from the pure free-electron case however is in the range of
  the energy transfer <math|T>. Namely, the expressions (<reference|wkbi>)
  are applicable in this case only above the ionization threshold, i.e. at
  <math|T\<ge\><around|\||E<rsub|0>|\|>>. Below the threshold the electron
  becomes `inactive'.

  It is instructive to point out that the validity of the result in
  Eq.(<reference|wkbi>) is based on the semiclassical approximation and is
  not directly related to the value of the energy <math|T>. In particular,
  for a Coulomb interaction the WKB approximation is applicable at energy
  near the threshold<nbsp><cite|ll>. For <math|T> exactly at the threshold,
  <math|T=-E<rsub|0>>, the criterion for applicability of the semiclassical
  approach in terms of the force <math|F=<around|\||<wide|F|\<vect\>>|\|>=<around|\||<around|[|<wide|p|\<vect\>>,H|]>|\|>>
  acting on the electron and the momentum <math|p> of the electron is
  that<nbsp><cite|ll> the ratio of the characteristic values
  <math|m*F/p<rsup|3>> is small. For the excitation of a state with the
  principal number <math|n> this ratio behaves parametrically as
  <math|1/n><nbsp><footnote|Indeed one has
  <math|<around|\||F|\|>=\<alpha\>/r<rsup|2>\<sim\>m<rsup|2>*<space|0.17em>\<alpha\><rsup|3>*<space|0.17em>n<rsup|4>>
  and <math|p\<sim\>m*<space|0.17em>\<alpha\>/n>, so that
  <math|m<around|\||F|\|>/p<rsup|3>\<sim\>1/n>.>. Thus the applicability of a
  semiclassical treatment of the ionization near the threshold improves for
  initial states with large <math|n>. As previously mentioned, the
  modification of the integrals (<reference|defi>) by the binding is already
  less than 5% for <math|n=1>, so that we fully expect this deviation to be
  smaller for the higher states, and even smaller at larger values of
  <math|T> above the threshold due to the approach to the free-electron
  behavior at <math|T\<gg\>E<rsub|0>>.

  We believe that the latter conclusion explains the so-called stepping
  behavior observed empirically<nbsp><cite|kmsf> in the results of numerical
  calculations. Namely the calculated cross section <math|d*\<sigma\>/d*T>
  for ionization of an electron from an atomic orbital follows the
  free-electron dependence on <math|T> all the way down to the threshold for
  the corresponding orbital with a very small, at most a few percent,
  deviation. This observation lead the authors of Ref.<nbsp><cite|kmsf> to
  suggest the stepping approximation for the ratio of the atomic cross
  section (per target electron) to the free-electron one:

  <\equation>
    f<around|(|T|)>\<equiv\><frac|d*\<sigma\>/d*T|<around|(|d*\<sigma\>/d*T|)><rsub|F*E>>=<frac|1|Z>*<space|0.17em><big|sum><rsub|i><space|0.17em>n<rsub|i>*<space|0.17em>\<theta\>*<around|(|T-<around|\||E<rsub|i>|\|>|)><nbsp>,<label|step>
  </equation>

  where the sum runs over the atomic orbitals with the binding energies
  <math|E<rsub|i>> and the filling numbers <math|n<rsub|i>>. Clearly, the
  factor <math|f<around|(|T|)>> simply counts the fraction of `active'
  electrons at the energy <math|T>, i.e. those for which the ionization is
  kinematically possible. For this reason we refer to <math|f<around|(|t|)>>
  as an <with|font-shape|italic|activation factor>. We conclude here that the
  stepping approximation is indeed justified with a high accuracy in the
  approximation of the scattering on independent electrons, i.e. if one
  neglects the two-electron correlations induced by the interference of terms
  in the operator <math|\<rho\><around|(|<wide|q|\<vect\>>|)>> in
  Eq.(<reference|ne>) corresponding to different electrons. In the next
  section we estimate the effect of such an interference and find that the
  resulting corrections are small, at least in atoms with large <math|Z>,
  such as the germanium.

  <section|Two-electron correlation><label|elcorr>

  In this section we discuss the correction arising from a correlation
  between two electrons. We consider the energy <math|T> and hence the
  relevant momentum transfer <math|q> as large in comparison with the atomic
  scale. In this way we estimate the relevant parameter for the significance
  of the correlation effect.

  We start with consider an isolated system of two electrons interacting
  among themselves through the Coulomb potential <math|V<around|(|r|)>>. The
  Hamiltonian for this system thus has the form

  <\equation>
    H=<frac|P<rsup|2>|4*m>+<frac|p<rsup|2>|m>+V<around|(|r|)><nbsp>,<label|h2>
  </equation>

  where <math|<wide|P|\<vect\>>=-i*\<partial\>/\<partial\>*<wide|R|\<vect\>>>
  and <math|<wide|p|\<vect\>>=-i*\<partial\>/\<partial\>*<wide|r|\<vect\>>>
  are, as usual, the momenta conjugate to respectively the center of mass
  coordinate <math|<wide|R|\<vect\>>> and the relative coordinate
  <math|<wide|r|\<vect\>>>.

  The spatial part of the wave function of the system factorizes into the
  product <math|\<phi\><around|(|<wide|R|\<vect\>>|)>*<space|0.17em>\<psi\><around|(|<wide|r|\<vect\>>|)>>
  with <math|\<phi\><around|(|<wide|R|\<vect\>>|)>> while the spin part will
  be considered later. We consider here the system at rest, i.e.
  <math|\<phi\><around|(|R|)>=><with|font-family|rm|const>, since a boost to
  a momentum <math|P> does not change the cross section.

  The density-density Green's function then takes the form

  <\equation>
    F<around|(|T,q<rsup|2>|)>=<big|sum><rsub|n><frac|<around*|\<langle\>|0*<around*|\||e<rsup|i*<wide|q|\<vect\>>*<wide|r|\<vect\>>/2>+e<rsup|-i*<wide|q|\<vect\>>*<wide|r|\<vect\>>/2>|\|>*n|\<rangle\>>*<space|0.17em><around*|\<langle\>|n*<around*|\||e<rsup|i*<wide|q|\<vect\>>*<wide|r|\<vect\>>/2>+e<rsup|-i*<wide|q|\<vect\>>*<wide|r|\<vect\>>/2>|\|>*0|\<rangle\>>|T-<frac|q<rsup|2>|4*m>-E<rsub|n>+E<rsub|0>><nbsp>,<label|f2>
  </equation>

  where the states <math|<around|\||0|\<rangle\>>,<nbsp>\|n\<rangle\>> and
  the energies <math|E<rsub|0>,<nbsp>E<rsub|n>> refer to the relative motion
  in the system with <math|<around|\||0|\<rangle\>>> standing for the initial
  state. Clearly, it is implied in Eq.(<reference|f2>) that the corresponding
  matrix elements for the (trivial) dynamics of the system as a whole are
  already taken, which results in replacing in the energy denominator the
  excitation energy <math|T> by its value corrected for the recoil of the
  system as a whole: <math|T\<to\>T-q<rsup|2>/4*m>.

  The cross terms between <math|exp <around|(|i*<wide|q|\<vect\>>\<cdot\><wide|r|\<vect\>>/2|)>>
  and <math|exp (-i*<wide|q|\<vect\>>\<cdot\><wide|r|\<vect\>>/2)> in the
  expression (<reference|f2>) result in the previously discussed one-particle
  Green's function

  <\equation>
    F<rsub|1><around|(|T,q<rsup|2>|)>=2*<space|0.17em><around*|\<langle\>|0<around*|\||<around*|(|T-<frac|q<rsup|2>|2*m>-<frac|<wide|p|\<vect\>>\<cdot\><wide|q|\<vect\>>|m>-H+E<rsub|0>|)><rsup|-1>|\|>*0|\<rangle\>><nbsp>,<label|f21>
  </equation>

  where the overall factor of 2 arises from the two identical (after
  averaging over the direction of <math|<wide|q|\<vect\>>>) cross terms, and
  physically is corresponding to the presence of two particles in the system.

  The discussed here contribution of the two-electron correlation arises from
  the diagonal terms, whose contribution is given by

  <\equation>
    F<rsub|c><around|(|T,q<rsup|2>|)>=2*<space|0.17em>\<eta\>*<space|0.17em><big|sum><rsub|n><frac|<around*|\<langle\>|0<around*|\||e<rsup|i*<wide|q|\<vect\>>*<wide|r|\<vect\>>/2>|\|>*n|\<rangle\>>*<space|0.17em><around*|\<langle\>|n<around*|\||e<rsup|i*<wide|q|\<vect\>>*<wide|r|\<vect\>>/2>|\|>*0|\<rangle\>>|T-<frac|q<rsup|2>|4*m>-E<rsub|n>+E<rsub|0>><nbsp>,<label|fc>
  </equation>

  where, again, the two terms give the same contribution after the averaging
  over the direction of <math|<wide|q|\<vect\>>>, which is accounted for by
  the factor of 2 in the latter expression. The factor <math|\<eta\>> is the
  symmetry factor for the spin part of the two-electron system:
  <math|\<eta\>=-1> for the spin-singlet state of the pair and
  <math|\<eta\>=+1> for the spin-triplet. The appearance of this factor can
  be explained as follows. The discussed correlation arises from the
  situation where an excitation of one electron by the operator
  <math|\<rho\>> produces the same spatial wave function as an excitation of
  another one. In order for the wave functions to be identical the spin
  variables of the two electrons should also be switched, which operation
  results in the factor <math|\<eta\>>. Clearly, no such factor arises in the
  one-particle term (<reference|f21>) since the spin of both electrons simply
  `goes through'. It can be also mentioned that, naturally, the symmetry of
  the spatial wave function <math|\<psi\><around|(|<wide|r|\<vect\>>|)>> is
  opposite to <math|\<eta\>>.

  One can notice that unlike in the one-particle contribution
  (Eq.(<reference|f21>)) where the momentum <math|<wide|q|\<vect\>>> flows in
  and out of the system, the correlation contribution in Eq.(<reference|fc>)
  corresponds to the net momentum <math|<wide|q|\<vect\>>> flowing into the
  system. Clearly, for non-interacting particles such contribution would
  vanish and the whole correlation effect arises only due to the interaction
  between the electrons, which interaction absorbs the momentum transfer. The
  term (<reference|fc>) can be graphically represented as shown in Fig.1,
  where the system lines correspond to the propagation of the system in the
  potential <math|V> with the outer legs corresponding to the wave functions
  of the initial state in the momentum space
  <math|<around|\<langle\>|\<psi\><around|(|<wide|p|\<vect\>><space|0.17em><rprime|'>|)>|\|>>
  and <math|<around|\||\<psi\><around|(|<wide|p|\<vect\>>|)>|\<rangle\>>> and
  the line between the action of the operators <math|exp
  <around|(|i*<wide|q|\<vect\>>\<cdot\><wide|r|\<vect\>>/2|)>> corresponding
  to the Green's function. One can write in terms of these objects the
  expression for <math|F<rsub|c><around|(|T,q<rsup|2>|)>> as

  <\equation>
    F<rsub|c><around|(|T,q<rsup|2>|)>=2*<big|int><space|0.17em><frac|d<rsup|3>*p*'|<around|(|2*\<pi\>|)><rsup|3>>*<space|0.17em><big|int><space|0.17em><frac|d<rsup|3>*p|<around|(|2*\<pi\>|)><rsup|3>>*<space|0.17em>\<psi\><rsup|\<nosymbol\>>*<around|(|<wide|p|\<vect\>>*<space|0.17em>'|)>*<space|0.17em>G*<around|(|E;<wide|p|\<vect\>>*<space|0.17em>'-<wide|q|\<vect\>>,<wide|p|\<vect\>>+<wide|q|\<vect\>>|)>*<space|0.17em>\<psi\><around|(|<wide|p|\<vect\>>|)><nbsp>,<label|fcp>
  </equation>

  where <math|G<around|(|E,<wide|k|\<vect\>><space|0.17em><rprime|'>,<wide|k|\<vect\>>|)>>
  is the Green's function <math|<around|(|E-H|)><rsup|-1>> in the momentum
  representation at the energy <math|E=T+E<rsub|0>-q<rsup|2>/4*m>.<next-line>

  <\big-figure>
    <leavevmode> <epsfxsize>=6cm <epsfbox|corr1.eps>
  </big-figure|>

  We shall consider separately the effect of the interaction in the wave
  functions and in the Green's function. For the zeroth order Green's
  function

  <\equation>
    G<rsub|0><around|(|E,<wide|k|\<vect\>><space|0.17em>',<wide|k|\<vect\>>|)>=<frac|<around|(|2*\<pi\>|)><rsup|3>*<space|0.17em>\<delta\><rsup|<around|(|3|)>>*<around|(|<wide|k|\<vect\>><space|0.17em>'-<wide|k|\<vect\>>|)>|E-k<rsup|2>/m><label|g0>
  </equation>

  and the exact wave functions one finds

  <\equation>
    F<rsub|c><rsup|<around|(|0|)>><around|(|T,q<rsup|2>|)>=2*<space|0.17em>\<eta\>*<space|0.17em><big|int><space|0.17em><frac|d<rsup|3>*p|<around|(|2*\<pi\>|)><rsup|3>>*<space|0.17em><frac|\<psi\><rsup|\<nosymbol\>>*<around|(|<wide|p|\<vect\>>+<wide|q|\<vect\>>|)>*<space|0.17em>\<psi\><around|(|<wide|p|\<vect\>>|)>|T-<frac|q<rsup|2>|2*m>-<frac|<around|(|<wide|p|\<vect\>>\<cdot\><wide|q|\<vect\>>|)>|m>-<frac|p<rsup|2>|m>+E<rsub|0>><nbsp>.<label|fc0>
  </equation>

  Let us consider now <math|q> as a large parameter in comparison with the
  characteristic momenta <math|p<rsub|0>> in
  <math|\<psi\><around|(|<wide|p|\<vect\>>|)>>, beyond which the wave
  function falls off. At such values of <math|q> the product
  <math|\<psi\><rsup|\<ast\>>*<around|(|<wide|p|\<vect\>>+<wide|q|\<vect\>>|)>*<space|0.17em>\<psi\><around|(|<wide|p|\<vect\>>|)>>
  carries a suppression in only one of the factors in two regions of
  <math|<wide|p|\<vect\>>>: one where <math|p\<sim\>p<rsub|0>> and the other
  where <math|<around|\||<wide|p|\<vect\>>+<wide|q|\<vect\>>|\|>\<sim\>p<rsub|0>>.
  Clearly, by shifting the integration variable
  <math|<wide|p|\<vect\>>+<wide|q|\<vect\>>\<to\><wide|p|\<vect\>>> one can
  readily see that both integration regions the contribution of the latter
  region is the same as of the first one, so that one evaluates the integral
  in Eq.(<reference|fc0>) by considering only the contribution of the region
  <math|p\<ll\>q> and taking it with a factor of two. Then the leading at
  large <math|q> expression for the function in Eq.(<reference|fc0>) takes
  the form

  <\equation>
    F<rsub|c><rsup|<around|(|0|)>><around|(|T,q<rsup|2>|)>=4*<space|0.17em>\<eta\>*<space|0.17em><frac|\<psi\><around|(|<wide|q|\<vect\>>|)>|T-<frac|q<rsup|2>|2*m>>*<space|0.17em><big|int><space|0.17em><frac|d<rsup|3>*p|<around|(|2*\<pi\>|)><rsup|3>>*<space|0.17em>\<psi\><around|(|<wide|p|\<vect\>>|)>=4*<space|0.17em>\<eta\>*<space|0.17em><frac|\<psi\><rsup|\<nosymbol\>><around|(|<wide|q|\<vect\>>|)>*<space|0.17em>\<psi\><around|(|0|)>|T-<frac|q<rsup|2>|2*m>><nbsp>,<label|fc0q>
  </equation>

  The appearance of the wave function at the origin
  <math|<wide|r|\<vect\>>=0>, <math|\<psi\><around|(|0|)>>, in this
  expression implies that at large <math|q> the considered contribution to
  the correlation arises only for an <math|S>-wave relative motion within the
  electron pair, which thus have to be a spin-singlet, and therefore
  <math|\<eta\>=-1>.

  In fact for an for an <math|S>-wave motion the momentum-space wave function
  <math|\<psi\><around|(|<wide|q|\<vect\>>|)>> can be also expressed at large
  <math|q> in terms of the position-space wave function at the origin
  <math|\<psi\><around|(|0|)>>. Indeed, in the <math|S>-wave the wave
  function is a function of <math|r>: <math|\<psi\><around|(|r|)>>. At small
  <math|r> the Coulomb repulsion between the electrons dominates over all
  other interactions and the Schrdinger equation for
  <math|\<psi\><around|(|r|)>> reads

  <\equation>
    -<frac|1|m>*<space|0.17em>\<psi\>*'*'-<frac|2|m*r>*<space|0.17em>\<psi\>*'<around|(|r|)>+<frac|\<alpha\>|r>*<space|0.17em>\<psi\><around|(|r|)>=E*<space|0.17em>\<psi\><around|(|r|)><nbsp>.
  </equation>

  By requiring the two singular at <math|r\<to\>0> as <math|1/r> terms to
  match in this expression, one finds that the derivative of
  <math|\<psi\><around|(|r|)>> over <math|r> at the origin is expressed in
  terms of <math|\<psi\><around|(|0|)>>:

  <\equation>
    \<psi\>*'<around|(|0|)>=<frac|m*<space|0.17em>\<alpha\>|2>*<space|0.17em>\<psi\><around|(|0|)><nbsp>.<label|der0>
  </equation>

  A finite derivative over <math|r> implies that the gradient
  <math|<wide|\<nabla\>|\<vect\>>*\<psi\><around|(|r|)>=<wide|r|\<vect\>>*<space|0.17em>\<psi\><rprime|'><around|(|r|)>/r>
  is singular at <math|r=0>, so that the asymptotic at large
  <math|<around|\||<wide|q|\<vect\>>|\|>> behavior of the momentum space wave
  function is proportional to <math|1/<around|\||<wide|q|\<vect\>>|\|><rsup|4>>
  with the coefficient determined by <math|\<psi\><rprime|'><around|(|0|)>>,
  which in turn is determined, according to Eq.(<reference|der0>), by
  <math|\<psi\><around|(|0|)>>:

  <\equation>
    <around*|\<nobracket\>|\<psi\><around|(|<wide|q|\<vect\>>|)>|\|><rsub|<around|\||<wide|q|\<vect\>>|\|>\<to\>\<infty\>>=-<frac|4*\<pi\>*<space|0.17em>m*<space|0.17em>\<alpha\>*<space|0.17em>\<psi\><around|(|0|)>|<around|\||<wide|q|\<vect\>>|\|><rsup|4>><nbsp>.<label|asq>
  </equation>

  Using this relation in Eq.(<reference|fc0q>) one finds in the large
  <math|q<rsup|2>> limit

  <\equation>
    F<rsub|c><rsup|<around|(|0|)>><around|(|T,q<rsup|2>|)>=16*<space|0.17em>\<pi\>*<space|0.17em>\<alpha\>*<space|0.17em><frac|m<space|0.17em><around|\||\<psi\><around|(|0|)>|\|><rsup|2>|q<rsup|4>>*<space|0.17em><frac|1|T-<frac|q<rsup|2>|2*m>><nbsp>.<label|fc0f>
  </equation>

  The latter expression is manifestly proportional to first power of the
  interaction between the electrons. Therefore a similar contribution can
  arise from the first order in the expansion of the Green's function in the
  interaction potential <math|V>. In this order one finds for the discussed
  correlation part of <math|F<around|(|T,q<rsup|2>|)>>:

  <\equation>
    F<rsub|c><rsup|<around|(|1|)>><around|(|T,q<rsup|2>|)>=2*\<eta\>*<space|0.17em><big|int><space|0.17em><frac|d<rsup|3>*p*'|<around|(|2*\<pi\>|)><rsup|3>>*<space|0.17em><big|int><space|0.17em><frac|d<rsup|3>*p|<around|(|2*\<pi\>|)><rsup|3>>*<space|0.17em><frac|\<psi\><rsup|\<nosymbol\>>*<around|(|<wide|p|\<vect\>>*<space|0.17em>'|)>*<space|0.17em>V(-<wide|q|\<vect\>>+<wide|p|\<vect\>>*<space|0.17em>'-<wide|p|\<vect\>>)<space|0.17em>\<psi\><around|(|<wide|p|\<vect\>>|)>|<around*|[|T-<frac|q<rsup|2>|2*m>+<frac|<around|(|<wide|p|\<vect\>>*<space|0.17em>'\<cdot\><wide|q|\<vect\>>|)>|m>-<frac|p*'<rsup|2>|m>+E<rsub|0>|]>*<space|0.17em><around*|[|T-<frac|q<rsup|2>|2*m>-<frac|<around|(|<wide|p|\<vect\>>\<cdot\><wide|q|\<vect\>>|)>|m>-<frac|p<rsup|2>|m>+E<rsub|0>|]>><nbsp>,<label|fc1>
  </equation>

  where <math|V<around|(|<wide|k|\<vect\>>|)>> is the Fourier transform of
  the potential, so that for the Coulomb repulsion between the electrons

  <\equation>
    V<around|(|<wide|k|\<vect\>>|)>=<frac|4*\<pi\>*\<alpha\>|k<rsup|2>>.<label|vk>
  </equation>

  Considering as before the limit of large <math|q> and thus neglecting
  <math|p> and <math|p<rprime|'>> in comparison with <math|q>, one readily
  finds that the result is again proportional to
  <math|<around|\||\<psi\><around|(|0|)>|\|><rsup|2>>, so that the effect
  remains only in the <math|S>-wave (and hence <math|\<eta\>=-1>):

  <\equation>
    <around*|\<nobracket\>|F<rsub|c><rsup|<around|(|1|)>><around|(|T,q<rsup|2>|)>|\|><rsub|m*T,q<rsup|2>\<gg\>p<rsup|2>,p*'<rsup|2>>=-8*\<pi\>*<space|0.17em>\<alpha\>*<frac|<around|\||\<psi\><around|(|0|)>|\|><rsup|2>|q<rsup|2>*<space|0.17em><around*|(|T-<frac|q<rsup|2>|2*m>|)><rsup|2>><label|fc11>
  </equation>

  Collecting the formulas (<reference|fc0f>) and (<reference|fc11>) together
  one finds the estimate of the two-electron correlation part of
  <math|F<around|(|T,q<rsup|2>|)>> in the limit of large <math|T> and
  <math|q<rsup|2>>:

  <\equation>
    F<rsub|c><around|(|T,q<rsup|2>|)>=8*\<pi\>*<space|0.17em>\<alpha\><space|0.17em><around|\||\<psi\><around|(|0|)>|\|><rsup|2>*<space|0.17em><around*|[|<frac|2*<space|0.17em>m|q<rsup|4>*<space|0.17em><around*|(|T-<frac|q<rsup|2>|2*m>|)>>-<frac|1|q<rsup|2>*<space|0.17em><around*|(|T-<frac|q<rsup|2>|2*m>|)><rsup|2>>|]><nbsp>.<label|fcff>
  </equation>

  The corresponding two-electron correlation correction to the integrals for
  the neutrino scattering cross section, is then calculated by shifting
  <math|T\<to\>T-i*\<epsilon\>> and considering only the contribution of the
  singularity at <math|q<rsup|2>=2*m*<space|0.17em>T>:

  <\equation>
    <frac|1|\<pi\>>*<space|0.17em><big|int><space|0.17em><math-up|Im>F<rsub|c><around|(|T,q<rsup|2>|)><space|0.17em><frac|d*q<rsup|2>|q<rsup|2>>=-4*\<pi\>*<space|0.17em>\<alpha\>*<space|0.17em><frac|<around|\||\<psi\><around|(|0|)>|\|><rsup|2>|m*<space|0.17em>T<rsup|3>><nbsp>,<nbsp><nbsp><nbsp><nbsp><nbsp><frac|1|\<pi\>>*<space|0.17em><big|int><space|0.17em><math-up|Im>F<rsub|c><around|(|T,q<rsup|2>|)>*<space|0.17em>d*q<rsup|2>=0<nbsp>.<label|dic>
  </equation>

  Notice, that the two-electron contribution to the integral relevant for the
  standard electroweak scattering vanishes in the discussed approximation due
  to a cancellation of the two terms in Eq.(<reference|fcff>).

  The discussed here calculation shows, as expected, that at large <math|q>
  the two-electron correlation arises only when the electrons are separated
  by a short distance. For this reason one can relax the assumption, we made
  in the beginning of this section, that the system of two electrons is in a
  free motion. Indeed the same result would apply in the situation, where the
  pair as a whole moves in a potential that is sufficiently smooth so that
  the `tidal force' interaction with the rest of the atomic system does not
  overcome the Coulomb singularity of the repulsion between the electrons at
  distances of order <math|1/q>.

  <section|Scattering on atomic electrons in germanium><label|TF>

  In considering the neutrino scattering on actual atoms one needs to
  evaluate the dependence of the number of active electrons on <math|T> and
  generally also evaluate the effect of the two-electron correlations. The
  energies of the inner <math|K,<nbsp>L> and <math|M> orbitals in the
  germanium atom are well known (see e.g. Ref.<nbsp><cite|fms> and references
  therein) and provide the necessary data for a description of the neutrino
  scattering by the stepping formula (<reference|step>) down to the values of
  the energy transfer <math|T> in the range of the binding of the <math|M>
  electrons, i.e. at <math|T\<gtr\><around|\||E<rsub|M>|\|>\<approx\>0.18><space|0.17em>keV.
  The corresponding steps in the activation factor are shown in Fig.<nbsp>2.
  It can be mentioned that if one applies formulas of the
  Appendix<nbsp><reference|B> to the onset of the <math|K> shell step, i.e.
  just above 10.9<space|0.17em>keV, the difference from the shown in the plot
  step function would be practically invisible in the scale of Fig.<nbsp>2.

  Our goal in this section is to estimate the effect of the two-electron
  correlations in the scattering on germanium. We shall estimate this effect
  by considering the atomic number <math|Z> as a large parameter and using
  the Thomas-Fermi model, which, in spite of its known shortcomings, appears
  to be appropriate for evaluating average bulk properties of atomic
  electrons at large <math|Z>, such as in the problem at hand.

  In the Thomas-Fermi model (see e.g. Ref.<nbsp><cite|ll>) the atomic
  electrons are described as a degenerate free electron gas in a master
  potential <math|\<phi\><around|(|r|)>> filling the momentum space up to the
  zero Fermi energy, i.e. up to the momentum <math|p<rsub|0><around|(|r|)>>
  such that <math|p<rsub|0><rsup|2>/2*m-e*\<phi\>=0>. The electron density
  <math|n<around|(|r|)>=p<rsub|0><rsup|3>/<around|(|3*\<pi\><rsup|2>|)>> then
  determines the potential <math|\<phi\><around|(|r|)>> from the usual Gauss
  equation. In the discussed picture at an energy transfer <math|T> the
  ionization is possible only for the electrons whose energies in the
  potential are above <math|-T>, i.e. with momenta above
  <math|p<rsub|T><around|(|r|)>> with <math|p<rsub|T><rsup|2>/2*m-e*\<phi\>=-T>.
  The electrons with lower energy are inactive. Calculating the density of
  the inactive electrons as <math|p<rsub|T><rsup|3>/<around|(|3*\<pi\><rsup|2>|)>>
  and subtracting their total number from Z, one readily arrives at the
  formula for the activation factor, i.e. the effective fraction of the
  active electrons <math|Z<rsub|<math-up|eff>>/Z> as a function of <math|T>:

  <\equation>
    f<around|(|T|)>=<frac|Z<rsub|<math-up|eff>><around|(|T|)>|Z>=1-<big|int><rsub|0><rsup|x<around|(|T|)>><space|0.17em><around*|[|<frac|\<chi\><around|(|x|)>|x>-<frac|T|T<rsub|0>>|]><rsup|3/2>*<space|0.17em>x<rsup|2>*<space|0.17em>d*x<nbsp>,<label|zeff>
  </equation>

  where <math|\<chi\><around|(|x|)>> is the Thomas-Fermi function, well known
  and tabulated, of the scaling variable <math|x=2*<around|(|4/3*\<pi\>|)><rsup|2/3>*m*\<alpha\>*Z<rsup|1/3>>,
  the energy scale <math|T<rsub|0>> is given by

  <\equation>
    T<rsub|0>=2<space|0.17em><around*|(|<frac|4|3*\<pi\>>|)><rsup|2/3>*<space|0.17em>m*<space|0.17em>\<alpha\><rsup|2>*<space|0.17em>Z<rsup|4/3>\<approx\>30.8*<space|0.17em>Z<rsup|4/3><space|0.17em><math-up|eV><nbsp>,<label|t0>
  </equation>

  and, finally, <math|x<rsub|0><around|(|T|)>> is the point where the
  integrand becomes zero, i.e. corresponding to the radius beyond which all
  the electrons are active at the given energy <math|T>. The energy scale
  <math|T<rsub|0>> in germanium (Z=32) evaluates to
  <math|T<rsub|0>\<approx\>3.1><space|0.17em>keV. The Thomas-Fermi activation
  factor for germanium calculated from the formula (<reference|zeff>) is
  shown by the dashed line in the plot of Fig.<nbsp>2. One can see that in
  the shown energy range it reasonably approximates the stepping behavior of
  the atomic orbitals. The discussed statistical model is known to
  approximate the average bulk properties of the atomic electrons with a
  relative accuracy <math|O<around|(|Z<rsup|-2/3>|)>> and as long as the
  essential distances <math|r> satisfy the condition
  <math|Z<rsup|-1>\<ll\>m*\<alpha\>*r\<ll\>1>, which condition in terms of
  the scaling variable <math|x> reads as <math|Z<rsup|-2/3>\<ll\>x\<ll\>Z<rsup|1/3>>.
  In terms of the formula (<reference|zeff>) for the number of active
  electrons, the lower bound on the applicability of the model is formally
  broken at <math|T\<sim\>Z<rsup|2/3>*T<rsub|0>>, i.e. at the energy scale of
  the inner atomic shells. However the effect of the deactivation of the
  inner electrons is small, of order <math|Z<rsup|-1>> in comparison with the
  total number <math|Z> of the electrons. On the other hand, at low <math|T>,
  including the most interesting region of <math|T\<sim\>T<rsub|0>>, the
  integral in Eq.(<reference|zeff>) is determined by the range of <math|x> of
  order one, where the model treatment is reasonably justified.<next-line>

  <\big-figure>
    <leavevmode> <epsfxsize>=12cm <epsfbox|ftbw.eps>
  </big-figure|The activation factor <math|f> for germanium in the stepping
  approximation with the actual energies of the orbitals (solid line) and its
  interpolation in the Thomas-Fermi model (dashed). >

  In order to apply the same model for an estimate of the correlation effect
  we replace in the estimated correlation contribution to the magnetic
  neutrino scattering in Eq.(<reference|dic>) the factor
  <math|<around|\||\<psi\><around|(|0|)>|\|><rsup|2>> by the total density of
  the electrons that an active electron `sees' at its location in the atom.
  Then the resulting correction to the integral <math|I<rsub|1>> for an atom
  can be written in terms of the density <math|n<rsub|a><around|(|r|)>> of
  the active electrons and the total density <math|n<around|(|r|)>> of the
  electrons in the atom:

  <\equation>
    I<rsub|1*c>=-<frac|\<pi\>*<space|0.17em>\<alpha\>|2*<space|0.17em>m*<space|0.17em>T<rsup|3>>*<space|0.17em><big|int><space|0.17em>n<rsub|a><around|(|r|)>*<space|0.17em>n<around|(|r|)>*<space|0.17em>d<rsup|3>*r.<label|ica>
  </equation>

  It should be pointed out that the numerical coefficient in this expression
  contains a factor of 1/8 as compared to Eq.(<reference|dic>). This is
  because of a factor of 1/4 corresponding to the statistical weight of the
  spin-singlet state and an extra 1/2 compensating for the double counting of
  electrons in the pairs.

  One can write the correction described by Eq.(<reference|ica>) in terms of
  a correction to the activation factor in the Thomas-Fermi model as

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|f<rsub|c><around|(|T|)>\<equiv\>T*<space|0.17em><frac|I<rsub|1*c>|Z>=>>|<row|<cell|>|<cell|>|<cell|-<around*|(|<frac|T<rsub|1>|T>|)><rsup|2>*<space|0.17em><around*|{|<big|int><rsub|x<around|(|T|)>><rsup|\<infty\>><space|0.17em>\<chi\><rsup|3><around|(|x|)><space|0.17em><frac|d*x|x>+<big|int><rsub|0><rsup|x<around|(|T|)>><space|0.17em>\<chi\><rsup|3/2><around|(|x|)>*<space|0.17em><around*|[|\<chi\><rsup|3/2><around|(|x|)>-<around*|(|\<chi\><around|(|x|)>-<frac|T|T<rsub|0>>*<space|0.17em>x|)><rsup|3/2>|]>*<space|0.17em><frac|d*x|x><space|0.17em>|}><nbsp>,<eq-number><label|dfc>>>>>>

  where the correlation energy scale <math|T<rsub|1>> is given by

  <\equation>
    T<rsub|1>=<frac|<sqrt|2>|3*\<pi\>>*<space|0.17em>m*<space|0.17em>\<alpha\><rsup|2>*<space|0.17em>Z\<approx\>4.1*<space|0.17em>Z<space|0.17em><math-up|eV><label|t1>
  </equation>

  and evaluates to about 131<space|0.17em>eV in germanium. The plot of the
  estimated correlation correction in germanium is shown in Fig.<nbsp>3. One
  can readily see that this correction is below 1.5% at
  <math|T\<approx\>0.3><space|0.17em>keV and rapidly decreases at higher
  energy transfer. Clearly, this estimate refers only to the magnetic part of
  the scattering, while for the weak part we find no correlation effect in
  the considered order due to the cancellation found in Eq.(<reference|dic>).
  We thus conclude that in the range of values of <math|T> above a few
  hundred eV the correlation effect can be safely neglected for both
  contributions to the neutrino scattering on germanium.<next-line>

  <\big-figure>
    <leavevmode> <epsfxsize>=12cm <epsfbox|fcbw.eps>
  </big-figure|The correlation correction <math|f<rsub|c>> to the activation
  factor <math|f> for germanium in the Thomas-Fermi model. >

  <section|Summary>

  We have considered the scattering of neutrinos on electrons bound in atoms.
  Our main finding is that the differential over the energy transfer cross
  section given by the free-electron formulas (<reference|fe>) and
  (<reference|sew>) and the stepping behavior of the activation factor given
  by Eq.(<reference|step>) provides a very accurate description of the
  neutrino-impact ionization of a complex atom, such as germanium, down to
  quite low energy transfer. The deviation from this approximation due to the
  onset of the ionization near the threshold is less than 5% (of the height
  of the step) for the <math|K> electrons, if one applies the analytical
  behavior of this onset that we find for the ground state of a hydrogen-like
  ion. We also find that the free-electron expressions for the cross section
  are not affected by the atomic binding effects in the semiclassical limit
  and for independent electrons. For this reason we expect that the deviation
  of the actual onset from a step function at the threshold for ionization of
  higher atomic orbitals is even smaller than for the ground state, since the
  motion in the higher states is closer to the semiclassical limit. The
  approximation of independent electrons lacks an account for the
  two-electron correlations arising from the Coulomb interaction between the
  electrons in the atom. We estimate this effect in the large <math|Z> limit
  using the Thomas-Fermi model and argue that the effect of the correlations
  is small in germanium for the values of the energy transfer above
  <math|0.2\<div\>0.3><space|0.17em>keV. We thus argue that for practical
  applications, i.e. for the analysis of data of the searches for NMM one can
  safely apply the free-electron formulas and the stepping approximation at
  the energy transfer down to this range.

  <\acknowledgments*>
    We thank A.S. Starostin and Yu.V. Popov for useful and stimulating
    discussions. The work of MBV is supported in part by the DOE grant
    DE-FG02-94ER40823.
  </acknowledgments*>

  <section|Sum rules><label|A>

  We consider here the general sum rules for the dynamical structure factor
  <math|S<around|(|T,q<rsup|2>|)>>, which stem from the analyticity of the
  density-density Green's function <math|F<around|(|T,q<rsup|2>|)>> at a
  fixed <math|T> and complex <math|q<rsup|2>> and also from its asymptotic
  behavior at large large <math|<around|\||q<rsup|2>|\|>>. At a non zero
  <math|T> the dynamical structure function, defined by Eq.(<reference|dsf>),
  vanishes at <math|q<rsup|2>=0>, due to the orthogonality of the excited
  states <math|<around|\||n|\<rangle\>>> and the initial state
  <math|<around|\||0|\<rangle\>>> in Eq.(<reference|dsf>) since
  <math|\<rho\><around|(|0|)>> reduces to a unit operator. For this reason
  the function <math|F<around|(|T,q<rsup|2>|)>> is real at <math|q<rsup|2>=0>
  and thus satisfies in the complex plane the condition
  <math|F<around|(|T,z<rsup|\<ast\>>|)>=F<rsup|\<ast\>><around|(|T,z|)>>. At
  a non zero real <math|q<rsup|2>> the imaginary part of this function is not
  vanishing for both positive and <with|font-shape|italic|negative
  <math|q<rsup|2>>>, so that it has cuts along the real axis extending from
  zero to both infinities<nbsp><footnote|It is not clear what physical
  meaning can be ascribed in this problem to negative <math|q<rsup|2>>.
  However a formal analytical continuation to negative <math|q<rsup|2>>
  exists and results in a cut along the negative real axis. It is the
  omission of this cut that resulted in a somewhat incorrect treatment of the
  problem in Ref.<nbsp><cite|mv>.>. On the other hand, the asymptotic at
  large <math|<around|\||q<rsup|2>|\|>> behavior of the Green's function
  <math|F<around|(|T,q<rsup|2>|)>> is determined by the free-electron formula
  (<reference|ff>), since at <math|<around|\||q<rsup|2>|\|>\<to\>\<infty\>>
  any interaction terms can be neglected. For a scattering on an atom with
  <math|Z> electrons one finds

  <\equation>
    <around*|\<nobracket\>|F<around|(|T,q<rsup|2>|)>|\|><rsub|<around|\||q<rsup|2>|\|>\<to\>\<infty\>>\<to\>-<frac|2*m*<space|0.17em>Z|q<rsup|2>><nbsp>.<label|asymp>
  </equation>

  This behavior enables one to write a dispersion relation for the Green's
  function with no subtractions:

  <\equation>
    F<around|(|T,q<rsup|2>|)>=<frac|1|\<pi\>>*<space|0.17em><big|int><rsub|-\<infty\>><rsup|\<infty\>><space|0.17em><frac|<math-up|Im>F<around|(|T,Q<rsup|2>|)>|q<rsup|2>-Q<rsup|2>-i*\<epsilon\>>*<space|0.17em>d*q<rsup|2><nbsp>.<label|disp>
  </equation>

  By comparing the dispersion relation at <math|Q<rsup|2>\<to\>\<infty\>>
  with the asymptotic behavior in Eq.(<reference|asymp>) one readily finds
  the sum rule for an integral similar to <math|I<rsub|2>>, but extended to
  include also the negative <math|q<rsup|2>>:

  <\equation>
    <big|int><rsub|-\<infty\>><rsup|\<infty\>><space|0.17em>S<around|(|T,q<rsup|2>|)>*<space|0.17em>d*q<rsup|2>=2*m*<space|0.17em>Z<nbsp>,<label|sr2>
  </equation>

  where the dynamical structure function at negative <math|q<rsup|2>> is
  defined by the analytical continuation and Eq.(<reference|sfrel>), rather
  than by Eq.(<reference|dsf>).

  In order to derive from Eq.(<reference|disp>) a relation for an integral
  similar to <math|I<rsub|1>> it is necessary to consider the Green's
  function near the origin, i.e. at <math|q<rsup|2>\<to\>0>. In
  multi-electron systems the behavior in this region is generally complicated
  by the two-electron correlations. For this reason we limit the
  consideration here to the system with just one electron, <math|Z=1>. In
  such a system one has <math|\<rho\><around|(|<wide|q|\<vect\>>|)>\<to\>1>
  at <math|q\<to\>0>, so that the Green's function in Eq.(<reference|fdef>)
  is contributed by only the initial state <math|<around|\||0|\<rangle\>>>:

  <\equation>
    F<around|(|T,0|)>=<frac|1|T><nbsp>.
  </equation>

  By comparing this formula with Eq.(<reference|disp>) at
  <math|Q<rsup|2>\<to\>0> one immediately finds the sum rule

  <\equation>
    <big|int><rsub|-\<infty\>><rsup|\<infty\>><space|0.17em>S<around|(|T,q<rsup|2>|)><space|0.17em><frac|d*q<rsup|2>|q<rsup|2>>=<frac|1|T><nbsp>.<label|sr1>
  </equation>

  It should be pointed out that unlike the sum rule (<reference|sr2>) this
  latter relation is generally invalidated in multi-electron system by the
  correlation effects. In fact an indication of such a difference in the
  behavior of the two integrals can be seen in Eq.(<reference|dic>), where
  the discussed there correlation effect vanishes for the integral
  <math|I<rsub|2>>, but not for the <math|I<rsub|1>>.

  The sum rule (<reference|sr1>) can also be derived from the latter
  expression in Eq.(<reference|f1>). Indeed one can rewrite the formula as

  <\equation>
    F<around|(|T,q<rsup|2>|)>=<frac|1|T-<frac|q<rsup|2>|2*m>>+<frac|1|T-<frac|q<rsup|2>|2*m>>*<space|0.17em><around*|\<langle\>|0*<around*|\||<frac|1|T-<frac|q<rsup|2>|2*m>-<frac|<around|(|<wide|p|\<vect\>>\<cdot\><wide|q|\<vect\>>|)>|m>-H+E<rsub|0>>*<space|0.17em><frac|<around|(|<wide|p|\<vect\>>\<cdot\><wide|q|\<vect\>>|)>|m>|\|>*0|\<rangle\>><nbsp>,<label|f1exp>
  </equation>

  and consider the expansion of the last term in powers of
  <math|<around|(|<wide|p|\<vect\>>\<cdot\><wide|q|\<vect\>>|)>>. Only the
  even terms in this expansion are non vanishing, since the odd terms give
  zero due to the parity. One can readily see that in each term in the
  expansion the pole in <math|q<rsup|2>> is of a higher order than the power
  of <math|q<rsup|2>> in the numerator, so that the imaginary part of each
  term integrates to zero in the integral as in Eq.(<reference|sr1>), while
  the term of the zeroth order in <math|<around|(|<wide|p|\<vect\>>\<cdot\><wide|q|\<vect\>>|)>>
  in Eq.(<reference|f1exp>) gives the sum rule (<reference|sr1>). It is again
  important here that the integration runs over all values of
  <math|q<rsup|2>> i.e. from <math|-\<infty\>> to <math|+\<infty\>>, since
  only in this case all the poles of the terms in the expansion are within
  the integration range. Any restriction of the range of integration over
  <math|q<rsup|2>> may leave some poles out so that the vanishing of the
  contribution of all higher terms in the expansion is generally not
  guaranteed.

  <section|Momentum-transfer integrals for hydrogen-like states><label|B>

  Consider the situation when the initial electron occupies the discrete
  <math|n*l> orbital in a Coulomb potential
  <math|V<around|(|<wide|r|\<vect\>>|)>=-\<alpha\>*Z/r>. The dynamical
  structure factor for this hydrogen-like system is given by

  <\equation>
    S<rsub|<around|(|n*l|)>><around|(|T,q<rsup|2>|)>=<frac|m*k|<around|(|2*\<pi\>|)><rsup|3>>*<frac|1|2*l+1>*<big|sum><rsub|m<rsub|l>=-l><rsup|l><big|int>d*\<Omega\><rsub|k><around|\||<around|\<langle\>|\<varphi\><rsup|-><rsub|<wide|k|\<vect\>>><around|\||\<rho\><around|(|<wide|q|\<vect\>>|)>|\|>*\<varphi\><rsub|n*l*m<rsub|l>>|\<rangle\>>|\|><rsup|2>,<label|sfnl>
  </equation>

  where <math|\<varphi\><rsub|n*l*m<rsub|l>>> is the bound-state wave
  function, <math|\<varphi\><rsup|-><rsub|<wide|k|\<vect\>>>> is the outgoing
  Coulomb wave for the ejected electron with momentum
  <math|<wide|k|\<vect\>>>, and <math|k=<around|\||<wide|k|\<vect\>>|\|>=<sqrt|2*m*T-p<rsub|n><rsup|2>>>,
  with <math|p<rsub|n>=\<alpha\>*Z*m/n> being the electron momentum in the
  <math|n>th Bohr orbit. The closed-form expressions for the bound-free
  transition matrix elements in Eq.<nbsp>(<reference|sfnl>) can be found, for
  instance, in Ref.<nbsp><cite|belckic81>. In principle, they allow for
  performing angular integrations in Eq.<nbsp>(<reference|sfnl>)
  analytically. This task, however, turns out to be formidable for large
  values of <math|n>. Therefore, below we restrict our consideration to the
  <math|n=1,2> states only, which nevertheless is enough for demonstrating
  the validity of the semiclassical approach developed in
  Sec.<nbsp><reference|1e>.

  Using results of Ref.<nbsp><cite|holt69>, we can present the
  function<nbsp>(<reference|sfnl>) when <math|n=1,2> as

  <eqnarray|<tformat|<table|<row|<cell|<label|sfnl1>S<rsub|<around|(|n*l|)>><around|(|T,q<rsup|2>|)>>|<cell|=>|<cell|<frac|2<rsup|8>*m*p<rsub|n><rsup|6>|3*<around|[|1-exp|(>-2*\<pi\>*\<eta\>)]>*<frac|q<rsup|2>*f<rsub|n*l><around|(|q<rsup|2>|)>|<around|[|<around|(|q<rsup|2>-k<rsup|2>+p<rsub|n><rsup|2>|)><rsup|2>+4*p<rsub|n><rsup|2>*k<rsup|2>|]><rsup|2*n+1>>>>|<row|<cell|>|<cell|>|<cell|\<times\>exp
  <around*|[|-2*\<eta\>*arctan <around*|(|<frac|2*p<rsub|n>*k|q<rsup|2>-k<rsup|2>+p<rsub|n><rsup|2>>|)>|]>,<eq-number>>>>>>

  where the branch of the arctangent function should be used that lies
  between 0 and <math|\<pi\>>, <math|\<eta\>=\<alpha\>*Z*m/k> is the
  Sommerfeld parameter, and

  <eqnarray|<tformat|<table|<row|<cell|f<rsub|1*s><around|(|q<rsup|2>|)>>|<cell|=>|<cell|3*q<rsup|2>+k<rsup|2>+p<rsub|1><rsup|2>,<eq-number><label|f1s>>>|<row|<cell|<label|f2s>f<rsub|2*s><around|(|q<rsup|2>|)>>|<cell|=>|<cell|8*<around*|[|3*q<rsup|10>-<around|(|32*p<rsub|2><rsup|2>+11*k<rsup|2>|)>*q<rsup|8>+<around|(|82*p<rsub|2><rsup|4>+72*p<rsub|2><rsup|2>*k<rsup|2>+14*k<rsup|2>|)>*q<rsup|6>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|+<around|(|20*p<rsub|2><rsup|6>-62*p<rsub|2><rsup|4>*k<rsup|2>-20*p<rsub|2><rsup|2>*k<rsup|4>-6*k<rsup|6>|)>*q<rsup|4>+<around|(|p<rsub|2><rsup|2>+k<rsup|2>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|\<times\><around*|(|<frac|47|5>*p<rsub|2><rsup|6>-<frac|47|5>*p<rsub|2><rsup|4>*k<rsup|2>-7*p<rsub|2><rsup|2>*k<rsup|4>-k<rsup|6>|)>*q<rsup|2>+<around|(|4*p<rsub|2><rsup|2>+k<rsup|2>|)>*<around|(|p<rsub|2><rsup|2>+k<rsup|2>|)><rsup|4>|]>,<eq-number>>>|<row|<cell|<label|f2p>f<rsub|2*p><around|(|q<rsup|2>|)>>|<cell|=>|<cell|2*p<rsub|2><rsup|2>*<around*|[|36*q<rsup|8>-48*<around|(|p<rsub|2><rsup|2>+k<rsup|2>|)>*q<rsup|6>+<around|(|152*p<rsub|2><rsup|4>-48*p<rsub|2><rsup|2>*k<rsup|2>-8*k<rsup|4>|)>*q<rsup|4>+<around|(|p<rsub|2><rsup|2>+k<rsup|2>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|\<times\><around*|(|<frac|1712|15>*p<rsub|2><rsup|4>+<frac|1568|15>*p<rsub|2><rsup|2>*k<rsup|2>+16*k<rsup|4>|)>*q<rsup|2>+<around*|(|<frac|44|3>*p<rsub|2><rsup|2>+4*k<rsup|2>|)>*<around|(|p<rsub|2><rsup|2>+k<rsup|2>|)><rsup|3>|]>.<eq-number>>>>>>

  Insertion of Eq.<nbsp>(<reference|sfnl1>) into the
  integrals<nbsp>(<reference|defi>) and integration over <math|q<rsup|2>>,
  using the change of variable

  <\equation*>
    <frac|2*p<rsub|n>*k|q<rsup|2>-k<rsup|2>+p<rsub|n><rsup|2>>=tan x
  </equation*>

  and the standard integrals involving the products of the exponential
  function and the powers of sine and cosine functions, yields

  <eqnarray|<tformat|<table|<row|<cell|<label|mw1s>I<rsub|1><rsup|<around|(|1*s|)>><around|(|T|)>=<frac|I<rsub|2><rsup|<around|(|1*s|)>><around|(|T|)>|2*m*T>>|<cell|=>|<cell|<frac|T<rsup|-1>|1-exp
  (-<frac|2*\<pi\>|<sqrt|y<rsub|1>-1>>)>*<around*|{|1-exp
  <around*|(|-<frac|\<pi\>|<sqrt|y<rsub|1>-1>>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|\<times\>exp
  <around*|[|<frac|-2|<sqrt|y<rsub|1>-1>>*arctan
  <around*|(|<frac|y<rsub|1>-2|2*<sqrt|y<rsub|1>-1>>|)>|]>*<around*|(|1-<frac|4|y<rsub|1>>+<frac|16|3*y<rsub|1><rsup|2>>|)>|}>,<eq-number>>>>>>

  <eqnarray|<tformat|<table|<row|<cell|<label|m2s>I<rsub|1><rsup|<around|(|2*s|)>><around|(|T|)>>|<cell|=>|<cell|<frac|T<rsup|-1>|1-exp
  (-<frac|4*\<pi\>|<sqrt|y<rsub|2>-1>>)>*<around*|{|1-exp
  <around*|(|-<frac|2*\<pi\>|<sqrt|y<rsub|2>-1>>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|\<times\>exp
  <around*|[|<frac|-4|<sqrt|y<rsub|2>-1>>*arctan
  <around*|(|<frac|y<rsub|2>-2|2*<sqrt|y<rsub|2>-1>>|)>|]>*<around*|(|1-<frac|8|y<rsub|2>>+<frac|80|3*y<rsub|2><rsup|2>>-<frac|448|15*y<rsub|2><rsup|3>>+<frac|1792|15*y<rsub|2><rsup|4>>|)>|}>,>>|<row|<cell|>|<cell|>|<cell|<eq-number>>>>>>

  <eqnarray|<tformat|<table|<row|<cell|<label|w2s>I<rsub|2><rsup|<around|(|2*s|)>><around|(|T|)>>|<cell|=>|<cell|<frac|2*m|1-exp
  (-<frac|4*\<pi\>|<sqrt|y<rsub|2>-1>>)>*<around*|{|1-exp
  <around*|(|-<frac|2*\<pi\>|<sqrt|y<rsub|2>-1>>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|\<times\>exp
  <around*|[|<frac|-4|<sqrt|y<rsub|2>-1>>*arctan
  <around*|(|<frac|y<rsub|2>-2|2*<sqrt|y<rsub|2>-1>>|)>|]>*<around*|(|1-<frac|8|y<rsub|2>>+<frac|80|3*y<rsub|2><rsup|2>>-<frac|448|15*y<rsub|2><rsup|3>>+<frac|1024|15*y<rsub|2><rsup|4>>|)>|}>,>>|<row|<cell|>|<cell|>|<cell|<eq-number>>>>>>

  <eqnarray|<tformat|<table|<row|<cell|<label|m2p>I<rsub|1><rsup|<around|(|2*p|)>><around|(|T|)>>|<cell|=>|<cell|<frac|T<rsup|-1>|1-exp
  (-<frac|4*\<pi\>|<sqrt|y<rsub|2>-1>>)>*<around*|{|1-exp
  <around*|(|-<frac|2*\<pi\>|<sqrt|y<rsub|2>-1>>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|\<times\>exp
  <around*|[|<frac|-4|<sqrt|y<rsub|2>-1>>*arctan
  <around*|(|<frac|y<rsub|2>-2|2*<sqrt|y<rsub|2>-1>>|)>|]>*<around*|(|1-<frac|8|y<rsub|2>>+<frac|80|3*y<rsub|2><rsup|2>>-<frac|704|15*y<rsub|2><rsup|3>>+<frac|3328|45*y<rsub|2><rsup|4>>|)>|}>,>>|<row|<cell|>|<cell|>|<cell|<eq-number>>>>>>

  <eqnarray|<tformat|<table|<row|<cell|<label|w2p>I<rsub|2><rsup|<around|(|2*p|)>><around|(|T|)>>|<cell|=>|<cell|<frac|2*m|1-exp
  (-<frac|4*\<pi\>|<sqrt|y<rsub|2>-1>>)>*<around*|{|1-exp
  <around*|(|-<frac|2*\<pi\>|<sqrt|y<rsub|2>-1>>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|\<times\>exp
  <around*|[|<frac|-4|<sqrt|y<rsub|2>-1>>*arctan
  <around*|(|<frac|y<rsub|2>-2|2*<sqrt|y<rsub|2>-1>>|)>|]>*<around*|(|1-<frac|8|y<rsub|2>>+<frac|80|3*y<rsub|2><rsup|2>>-<frac|704|15*y<rsub|2><rsup|3>>+<frac|512|15*y<rsub|2><rsup|4>>|)>|}>,>>|<row|<cell|>|<cell|>|<cell|<eq-number>>>>>>

  where <math|y<rsub|n>=2*m*T/p<rsub|n><rsup|2>\<equiv\>T/<around|\||E<rsub|n>|\|>>.
  The largest deviations of these integrals from the free-electron
  analogs<nbsp>(<reference|intf>) occur at the ionization threshold
  <math|T=<around|\||E<rsub|n>|\|>>. The corresponding relative values in
  this specific case are

  <\equation*>
    <frac|I<rsup|<around|(|1*s|)>><rsub|1>|I<rsup|<around|(|F*E|)>><rsub|1>>=<frac|I<rsup|<around|(|1*s|)>><rsub|2>|I<rsup|<around|(|F*E|)>><rsub|2>>=1-<frac|7|3>*e<rsup|-4>=0.9572635093,
  </equation*>

  <\equation*>
    <frac|I<rsup|<around|(|2*s|)>><rsub|1>|I<rsup|<around|(|F*E|)>><rsub|1>>=1-<frac|1639|15>*e<rsup|-8>=0.9633451168,<space|2em><frac|I<rsup|<around|(|2*s|)>><rsub|2>|I<rsup|<around|(|F*E|)>><rsub|2>>=1-<frac|871|15>*e<rsup|-8>=0.9805208034,
  </equation*>

  <\equation*>
    <frac|I<rsup|<around|(|2*p|)>><rsub|1>|I<rsup|<around|(|F*E|)>><rsub|1>>=1-<frac|2101|45>*e<rsup|-8>=0.9843376226,<space|2em><frac|I<rsup|<around|(|2*p|)>><rsub|2>|I<rsup|<around|(|F*E|)>><rsub|2>>=1-<frac|103|15>*e<rsup|-8>=0.9976964900.
  </equation*>

  The above results indicate a clear tendency: the larger <math|n> and
  <math|l>, the closer <math|I<rsub|1><rsup|<around|(|n*l|)>>> and
  <math|I<rsub|2><rsup|<around|(|n*l|)>>> are to the free-electron values.
  The departure from the free-electron behavior does not exceed several
  percent at most. These observations provide a solid base for the
  semiclassical approach of Sec.<nbsp><reference|1e>.

  <\thebibliography|99>
    <bibitem|fs>K.<nbsp>Fujikawa and R.<nbsp>Shrock, Phys. Rev. Lett.
    <with|font-series|bold|45>, 963 (1980).

    <bibitem|gs>C.<nbsp>Giunti and A.<nbsp>Studenikin, Phys. Atom. Nucl.
    <with|font-series|bold|72>, 2089 (2009) [arXiv:0812.3646 [hep-ph]].

    <bibitem|tx>H.<nbsp>T.<nbsp>Wong <with|font-shape|italic|et al.> [TEXONO
    Collaboration], Phys. Rev. D <with|font-series|bold|75>, 012001 (2007)
    [arXiv:hep-ex/0605006].<bibitem|ge1>A.<nbsp>G.<nbsp>Beda
    <with|font-shape|italic|et al.>, Phys. Atom. Nucl.
    <with|font-series|bold|70>, 1873 (2007) [arXiv:0705.4576
    [hep-ex]].<bibitem|ge2>A.<nbsp>G.<nbsp>Beda <with|font-shape|italic|et
    al.>, arXiv:1005.2736 [hep-ex].

    <bibitem|dn>G.<nbsp>V.<nbsp>Domogatskii and D.<nbsp>K.<nbsp>Nadezhin,
    Sov. J. Nucl. Phys. <with|font-series|bold|12>, 678 (1971)

    <bibitem|ve>P.<nbsp>Vogel and J.<nbsp>Engel, Phys. Rev. D
    <with|font-series|bold|39>, 3378 (1989).

    <bibitem|kmsf>V.<nbsp>I.<nbsp>Kopeikin, L.<nbsp>A.<nbsp>Mikaelyan,
    V.<nbsp>V.<nbsp>Sinev and S.<nbsp>A.<nbsp>Fayans, Yad. Fiz.
    <with|font-series|bold|60>, 2032 (1997).

    <bibitem|fms>S.<nbsp>A.<nbsp>Fayans, L.<nbsp>A.<nbsp>Mikaelyan and
    V.<nbsp>V.<nbsp>Sinev, Phys. Atom. Nucl. <with|font-series|bold|64>, 1475
    (2000) [Yad. Fiz. <with|font-series|bold|64>, 1551 (2000);
    \ arXiv:hep-ph/0004158]

    <bibitem|wll>H.<nbsp>T.<nbsp>Wong, H.<nbsp>B.<nbsp>Li and
    S.<nbsp>T.<nbsp>Lin, Phys. Rev. Lett. <with|font-series|bold|105>, 061801
    (2010) [arXiv:1001.2074v2 [hep-ph]].

    <bibitem|mv>M.<nbsp>B.<nbsp>Voloshin, Phys. Rev. Lett.
    <with|font-series|bold|105>, 201801 (2010) [arXiv:1008.2171 [hep-ph]].

    <bibitem|wll2>H.<nbsp>T.<nbsp>Wong, H.<nbsp>B.<nbsp>Li and
    S.<nbsp>T.<nbsp>Lin, arXiv:1001.2074v3 [hep-ph], November 2010.

    <bibitem|ks>K.<nbsp>A.<nbsp>Kouzakov and A.<nbsp>I.<nbsp>Studenikin,
    Phys. Lett. B <with|font-series|bold|696>, 252 (2011) [arXiv:1011.5847
    [hep-ph]].

    <bibitem|ll>L.<nbsp>D.<nbsp>Landau and E.<nbsp>M.<nbsp>Lifshits,
    <with|font-shape|italic|Quantum Mechanics (Non-relativistic Theory)>,
    Third Edition, Pergamon, Oxford, 1977.

    <bibitem|vh>L.<nbsp>Van Hove, Phys. Rev. <with|font-series|bold|95>, 249
    (1954).

    <bibitem|belckic81>D.<nbsp>Belki, J. Phys. B: At. Mol. Phys.
    <with|font-series|bold|14>, 1907 (1981).

    <bibitem|holt69>A.<nbsp>R.<nbsp>Holt, J. Phys. B: At. Mol. Phys.
    <with|font-series|bold|2>, 1209 (1969).
  </thebibliography>
</body>