<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <doc-data|<doc-title|Studies of electroweak boson production in the forward
  region with LHCb>|<doc-author|<author-data|<author-misc|The author would
  like to acknowledge the support of Science Foundation
  Ireland>|<author-name|<speaker|James Keaveney (on behalf of the LHCb
  collaboration><next-line>University college Dublin<next-line>E-mail:
  <email|james.keaveney@ucdconnect.ie>>>>>

  <section|Introduction>

  The LHCb experiment <cite|alves>, one of the four main experiments at the
  LHC, has begun taking data at <math|<sqrt|s>> = 7TeV and expects to take
  1fb<rsup|<math|-1>> by the end of 2011. Studies of electroweak boson
  production in this data form a significant component of the early physics
  programme at the LHC for numerous reasons. Firstly, these studies can make
  a precise test of the standard model at a new energy regime and provide an
  input to proton PDF constraining procedures. Secondly, the low theoretical
  uncertainty on the Z boson production cross section coupled with the
  ability to select signal samples of high purity makes an indirect
  luminosity measurement possible with a relatively small data sample.
  Thirdly, the clean experimental signature of the muonic decay channels
  allows detector calibration and performance studies to be performed using
  early data.

  As electroweak theory can currently describe the fundamental partonic
  processes of electroweak boson production at the LHC at
  next-to-next-to-leading order <cite|melnikov>, the dominant uncertainties
  on theoretical predictions of these processes arise from the knowledge of
  proton PDFs. In kinematic regions where PDF uncertainties are low, precise
  measurements of electroweak bosons provide a stringent test of the standard
  model. In other regions where PDF uncertainties are large, these studies
  can constrain PDFs. Uniquely among the LHC experiments, LHCb is
  instrumented in one direction only, with acceptance in the pseudorapidity
  region <math|1.9\<less\>\<eta\>\<less\>4.9>. This angular acceptance is
  complimented by the ability to trigger and reconstruct muons in the
  kinematic range (<math|P<rsub|\<mu\>>\<gtr\>6> GeV,
  <math|P*t<rsub|\<mu\>>\<gtr\>1> GeV). By studying the low mass
  <math|\<gamma\>\<ast\>\<rightarrow\>-\<gtr\>\<mu\><rsup|+>*\<mu\><rsup|->>
  LHCb can access two distinct regions of <math|<around|(|x,Q<rsup|2>|)>>
  space, one of which is previously unexplored.

  We present the methods developed to select samples of
  <math|W\<rightarrow\>\<mu\>*\<nu\>,Z\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->>
  and <math|\<gamma\>\<ast\>\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->>
  events. The efficiencies, purities and yields of these methods are
  estimated using Monte Carlo data.

  <section|Triggering and offline selection of signal events>

  <subsection|<math|W\<rightarrow\>\<mu\>*\<nu\>> selection>

  The muonic decay channel of the W boson is characterized by a single,
  isolated muon with a large transverse momentum. At LHCb, these events will
  be initially triggered by requiring a muon with <math|P<rsub|T>\<gtr\>1>
  GeV in the Level-0 hardware trigger. In the subsequent software stages of
  the LHCb trigger we require a muon with <math|P<rsub|T>\<gtr\>20> GeV to be
  reconstructed. The largest backgrounds to these events arise from the
  semi-leptonic decay of heavy quark hadrons,
  <math|Z\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->> events in which one
  muon decays outside the LHCb acceptance and mis-identification of high
  momentum hadrons as muons. To suppress these backgrounds offline, the
  candidate muon track is required to have <math|P<rsub|T>\<gtr\>30> GeV.
  Isolation requirements are then imposed on the remaining candidate tracks.
  In Equation <reference|eq:solve> we define an asymmetry,
  <math|A<rsub|p*t>>, between the <math|P<rsub|T>> of the candidate track and
  the summed <math|P<rsub|T>> of all other tracks in the event and an
  asymmetry <math|C<rsub|p*t>> between the <math|P<rsub|T>> of the candidate
  track and the summed <math|P<rsub|T>> of all tracks in an imaginary cone
  around the candidate of radius 1 in eta-phi space,

  <align|<tformat|<table|<row|<cell|<label|eq:solve>A<rsub|p*t>=<frac|P*t<rsub|\<mu\>>-P*t<rsub|o*t*h*e*r*<space|0.22em>t*r*a*c*k*s*<space|0.22em>i*n*<space|0.27em>e*v*e*n*t>|P*t<rsub|\<mu\>>+P*t<rsub|o*t*h*e*r*<space|0.27em>t*r*a*c*k*s*<space|0.27em>i*n*<space|0.27em>e*v*e*n*t>>*<space|1.5cm>C<rsub|p*t>=<frac|P*t<rsub|\<mu\>>-P*t<rsub|a*l*l*<space|0.27em>t*r*a*c*k*s*<space|0.27em>i*n*<space|0.27em>c*o*n*e>|P*t<rsub|\<mu\>>+P*t<rsub|a*l*l*<space|0.27em>t*r*a*c*k*s*<space|0.27em>i*n*<space|0.27em>c*o*n*e>>>>>>>

  and require <math|A<rsub|p*t>\<gtr\>0.3*a*n*d*C<rsub|p*t>\<gtr\>0.7>

  In Fig.<nbsp><reference|fig:subfigureExample> the effect of the selection
  cuts on signal and background is shown.

  <big-figure|<with|par-mode|center|<subfigure*|Before selection
  cuts|<image|noCut.eps||||><label|fig:Wselscheme> > <subfigure*|After
  selection cuts|<image|After.eps||||><label|fig:subfig2>
  ><label|fig:subfigureExample><caption*|Optional caption for list of
  figures|<math|P*t<rsub|\<mu\>>> distributions for
  <math|W\<rightarrow\>\<mu\>*\<nu\>> and background components before and
  after selection criteria are applied. The <math|P*t<rsub|\<mu\>>\<gtr\>30>
  GeV requirement is illustrated. >>|>

  <subsection|Z and <math|\<gamma\>\<ast\>> selection>

  Similar techniques are used to the select dimuons arising from the decays
  of Z and <math|\<gamma\>\<ast\>> bosons. These events are triggered by the
  requirement of a di-muon with <math|P<rsub|T>\<gtr\>1.5> GeV in the initial
  L0 hardware trigger and requirement of a dimuon with an invariant mass in
  the range <math|2.5\<less\>m<rsub|\<mu\>*\<mu\>>\<less\>40> GeV for
  <math|\<gamma\>\<ast\>\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->> events
  and <math|m<rsub|\<mu\>*\<mu\>>\<gtr\>40> GeV for
  <math|Z\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->> events in the
  subsequent software trigger. Backgrounds are dominated by the decays of
  heavy quarks and the mis-ID of high momentum di-hadrons as di-muons. In the
  offline selection of Z bosons, requiring two muons that originated at the
  primary vertex, each with <math|P<rsub|T>\<gtr\>20> GeV and the hadronic
  energy associated to each track \<less\>50GeV with
  <math|71\<less\>m<rsub|\<mu\>*\<mu\>>\<less\>111> GeV, yields a selected
  signal sample with 97% purity and 91% efficiency on triggered events
  <cite|anderson>. To further suppress backgrounds and increase selected
  signal sample purity the isolated nature of muon tracks from electroweak
  boson decay is exploited. For a given dimuon candidate, the cone isolation
  (<math|C<rsub|p*t>>, previously defined in (<reference|eq:solve>)) of each
  muon is used to construct a dimuon asymmetry <math|I<rsub|p*t>>

  <\equation>
    <label|eq:Di>I<rsub|p*t>=<sqrt|<frac|<around|(|C<rsub|p*t><rsup|\<mu\>+>-1|)><rsup|2>+<around|(|C<rsub|p*t><rsup|\<mu\>->-1|)><rsup|2>|8>>
  </equation>

  By requiring dimuon candidates to have <math|I<rsub|p*t>\<less\>0.2>, the
  purity of the selected sample is increased to 99%. The background
  components described are far more dominant at the low invariant mass region
  corresponding to <math|\<gamma\>\<ast\>\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->>
  events. To suppress this large background the candidate tracks are required
  to pass a pre-selection based on impact parameter significance (IPS
  \<less\> 3) and track <math|\<chi\><rsup|2>> per degree of freedom less
  than 2.5. A muon hypothesis likelihood is constructed from subdetector
  information associated to a muon candidate and a requirement is placed on
  this variable to reject background arising from mis-identified pions and
  kaons. Finally, a Fisher discriminant is constructed from four asymmetries
  of the form <math|A<around|(|x,y|)>=<around|(|x-y|)>/<around|(|x+y|)>>:

  <align|<tformat|<table|<row|<cell|A<around|(|P<rsub|\<mu\><rsup|+>>,P<rsub|c*o*n*e<rsup|+>>|)>,<space|.4cm>A<around|(|P<rsub|\<mu\><rsup|->>,P<rsub|c*o*n*e<rsup|->>|)>,<space|.4cm>A*<around|(|P<rsub|\<mu\><rsup|+>>+P<rsub|\<mu\><rsup|->>,P<rsub|o*t*h*e*r*<space|0.27em>t*r*a*c*k*s*<space|0.27em>i*n*<space|0.27em>e*v*e*n*t>|)>,<space|.4cm>A*<around|(|P<rsub|c*o*n*e<rsup|+>>+P<rsub|c*o*n*e<rsup|->>,P<rsub|o*t*h*e*r*<space|0.27em>t*r*a*c*k*s*<space|0.27em>i*n*<space|0.27em>e*v*e*n*t>|)>,>>>>>

  and cuts on the Fisher discriminant are optimized for purity in four
  distinct regions of the <math|\<gamma\>\<ast\>\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->>
  mass spectrum <cite|andersonDIS>.

  <subsection|Expected yields, efficiencies, purities and uncertainties>

  The selection schemes described above have been tested using Monte Carlo
  data and the full LHCb detector simulation framework. In
  Table<nbsp><reference|tab:PPer>, the yields , efficiencies and purities are
  estimated. Systematic errors have been estimated for size of the background
  components, reconstruction efficiencies, trigger efficiencies and
  integrated lumnosity. With 1fb<rsup|<math|-1>> of data, it is forseen that
  uncertainties will be dominated by the knowledge of the integrated
  luminosity.

  <\big-table>
    \;

    <\with|par-mode|center>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|r>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|4|4|cell-halign|r>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|5|5|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-valign|top>|<cwith|1|1|1|-1|cell-vmode|exact>|<cwith|1|1|1|-1|cell-height|<plus|1fn|0.2ex>>|<cwith|1|1|1|-1|cell-bborder|2ln>|<cwith|2|2|1|-1|cell-valign|top>|<cwith|2|2|1|-1|cell-vmode|exact>|<cwith|2|2|1|-1|cell-height|<plus|1fn|0.25ex>>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|3|3|1|-1|cell-valign|top>|<cwith|3|3|1|-1|cell-vmode|exact>|<cwith|3|3|1|-1|cell-height|<plus|1fn|-1ex>>|<cwith|4|4|1|-1|cell-valign|top>|<cwith|4|4|1|-1|cell-vmode|exact>|<cwith|4|4|1|-1|cell-height|<plus|1fn|0.2ex>>|<cwith|4|4|1|-1|cell-bborder|1ln>|<cwith|5|5|1|-1|cell-valign|top>|<cwith|5|5|1|-1|cell-vmode|exact>|<cwith|5|5|1|-1|cell-height|<plus|1fn|-1ex>>|<cwith|6|6|1|-1|cell-valign|top>|<cwith|6|6|1|-1|cell-vmode|exact>|<cwith|6|6|1|-1|cell-height|<plus|1fn|0.2ex>>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|7|7|1|-1|cell-valign|top>|<cwith|7|7|1|-1|cell-vmode|exact>|<cwith|7|7|1|-1|cell-height|<plus|1fn|-1ex>>|<cwith|8|8|1|-1|cell-valign|top>|<cwith|8|8|1|-1|cell-vmode|exact>|<cwith|8|8|1|-1|cell-height|<plus|1fn|0.2ex>>|<cwith|8|8|1|-1|cell-bborder|1ln>|<cwith|9|9|1|-1|cell-valign|top>|<cwith|9|9|1|-1|cell-vmode|exact>|<cwith|9|9|1|-1|cell-height|<plus|1fn|-1ex>>|<cwith|10|10|1|-1|cell-valign|top>|<cwith|10|10|1|-1|cell-vmode|exact>|<cwith|10|10|1|-1|cell-height|<plus|1fn|0.2ex>>|<cwith|10|10|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-valign|top>|<cwith|11|11|1|-1|cell-vmode|exact>|<cwith|11|11|1|-1|cell-height|<plus|1fn|-1ex>>|<cwith|12|12|1|-1|cell-valign|top>|<cwith|12|12|1|-1|cell-vmode|exact>|<cwith|12|12|1|-1|cell-height|<plus|1fn|0.2ex>>|<cwith|12|12|1|-1|cell-bborder|1ln>|<cwith|13|13|1|-1|cell-valign|top>|<cwith|13|13|1|-1|cell-vmode|exact>|<cwith|13|13|1|-1|cell-height|<plus|1fn|-1ex>>|<cwith|14|14|1|-1|cell-valign|top>|<cwith|14|14|1|-1|cell-vmode|exact>|<cwith|14|14|1|-1|cell-height|<plus|1fn|0.25ex>>|<cwith|14|14|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|Channel>|<cell|#
      events in LHCb in 1 fb<rsup|<math|-1>>>|<cell|total efficiency>|<cell|#
      events recorded>|<cell|purity>>|<row|<cell|<math|W\<rightarrow\>\<mu\>*\<nu\>>>|<cell|3470000>|<cell|.81>|<cell|2810000>|<cell|.94>>|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|<math|Z\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->>>|<cell|170000>|<cell|.79>|<cell|134300>|<cell|.99>>|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|<math|\<gamma\>\<ast\>\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->>>|<cell|124000>|<cell|.19>|<cell|23732>|<cell|.95>>|<row|<cell|(<math|2.5\<less\>m<rsub|\<mu\>*\<mu\>>\<less\>5>GeV)>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|<math|\<gamma\>\<ast\>\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->>>|<cell|154835>|<cell|.37>|<cell|57289>|<cell|.95>>|<row|<cell|(<math|5\<less\>m<rsub|\<mu\>*\<mu\>>\<less\>10>GeV)>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|<math|\<gamma\>\<ast\>\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->>>|<cell|75023>|<cell|.39>|<cell|29259>|<cell|.95>>|<row|<cell|(<math|10\<less\>m<rsub|\<mu\>*\<mu\>>\<less\>20>
      GeV)>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|<math|\<gamma\>\<ast\>\<rightarrow\>\<mu\><rsup|+>*\<mu\><rsup|->>>|<cell|21549>|<cell|.39>|<cell|8404>|<cell|.95>>|<row|<cell|(
      <math|20\<less\>m<rsub|\<mu\>*\<mu\>>\<less\>40>
      GeV)>|<cell|>|<cell|>|<cell|>|<cell|>>>>><label|tab:PPer>
    </with>
  </big-table|Estimated performances of the selection schemes >

  <section|Conclusions>

  In 2010 and 2011, the LHCb experiment will collect
  <nbsp>1fb<rsup|<math|-1>> of data. Analysis techniques to select the muonic
  decays of electroweak bosons in this dataset with high purity have been
  developed. These studies have numerous motivations: testing of the standard
  model; constrainment of proton PDFs in an unexplored area of
  (<math|x,Q<rsup|2>>) space; integrated luminosity estimation and detector
  calibration.

  <\thebibliography|9>
    <bibitem|alves>The LHCb Collaboration and A Augusto Alves Jr et al 2008
    JINST 3 S08005.

    <bibitem|melnikov>Melnikov, Kirill and Petriello, Frank, Electroweak
    gauge boson production at hadron colliders through
    <math|O<around|(|\<alpha\><rsub|s>|)>>, PhysRevD.74.114017

    <bibitem|anderson>J. Anderson, Testing the electroweak sector and
    determining the absolute luminosity at LHCb using dimuon final states,
    CERN-THESIS-2009-020 (2009).

    <bibitem|andersonDIS>J. Anderson, Probing low-x with Drell-Yan events at
    LHCb, LHCb-PROC-2009-014.
  </thebibliography>
</body>