<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <\hide-preamble>
    <assign|gguide|<macro|<with|font-shape|italic|Preparing graphics for IOP
    journals>>>
  </hide-preamble>

  <doc-data|<doc-title|Universal form for the minimal
  Fisher-measure>|<doc-author|<author-data|<author-name|S. P. Flego
  <rsup|<math|2>>, A. Plastino<rsup|<math|1,<space|0.17em>3,<space|0.17em>5>>,
  and A. R. Plastino<rsup|<math|3,<space|0.17em>4>>>>>>

  <abstract-data|<\abstract>
    <nd>The information-optimizing principle based on Fisher's information
    measure (FIM) requires, in order to extremize the measure, to tackle a
    Schrdinger's equation (SE). We present here a novel FIM-treatment that
    is able to bypass this SE. It is based on the virial theorem and it
    yields a general, analytic solution for the physically relevant FIM, that
    which is minimal subject to the constraints posed by the prior
    information. Simple illustrations are provided.

    <no-indent>KEYWORDS: Information Theory, Fisher's Information measure,
    Legendre transform, Virial theorem.

    <pacs|02.50.Tt, 02.50.-r, 02.70.Rr, 05.70.-a>
  </abstract>>

  <assign|be|<macro|>><assign|ee|<macro|>><assign|ben|<macro|>><assign|een|<macro|>><assign|n|<macro|<no-number>>><assign|nn|<macro|<no-number><next-line>>><assign|nd|<macro|<no-indent>>><assign|p|<macro|\<partial\>>>

  \ <ead|plastino@fisica.unlp.edu.ar>

  <section|Introduction>

  <nd>Interest in the physical applications of Fisher's information measure
  (FIM) <math|I> <cite|frieden|frieden2|frieden3|pla7|flego|reginatto> has
  been growing exponentially since the appearance of Frieden and Soffer's
  seminal paper <cite|frieden3>. A small, and certainly not exhaustive sample
  is that of Refs. <cite|KS09|CPF07|L02|DGS07|KSC10|FS09|U09|LADY08|2011|SAA07|N07|N06|rigid|alp2|alp3|alp4|olivares|pla5|flavia>.

  <nd>In this work we exhibit novel links between <math|I> and the
  one-dimensional Schrdinger equation that, via the virial theorem, lead in
  natural fashion to a differential equation for <math|I>. Such equation,
  that has an analytical solution, encodes the available prior knowledge
  concerning the system at hand in terms of adequately selected expectation
  values. Such solution adds to the rather large Fisher literature a general,
  explicit expression for that particular FIM <math|I<rsub|M*i*n>> that
  arises out of any constrained <math|I->extremization problem. It is
  important to note that, once in possession of this <math|I<rsub|M*i*n>>,
  one does not need to ever address any explicit minimization task nor to
  solve the FIM-associated Schrdinger equation. <vspace|3mm><nd>To better
  understand <with|font-shape|italic|why> this is of importance one should
  recall that Fisher's information and Shannon's entropy play complementary
  roles: the later is a local information measure while the former is a
  global one, FIM is convex, Shannon's is concave. When one grows, the other
  diminishes, etc <cite|frieden2|ppglobal>. The associated Shannon's MaxEnt
  problem has as its solution, always, an exponential form that contains
  those physical quantities whose mean values are a priori known. The
  solution of the FIM minimization problem is instead a Schrdinger like
  differential equation<cite|pla7|reginatto>, whose solutions exhibit a
  panoply of mathematical forms. We provide here a universal form for
  <math|I<rsub|M*i*n>>, expressed in terms of those mean values that are a
  priori known, filling thus a gap in the literature of the physics of
  information. We review basic materials below and start with our
  presentation in Sections III-V. We give illustrative examples in Section VI
  and present conclusions in Section VII.

  <section|Review of basic ideas>

  <nd>We briefly review here the formalism developed in Ref.<cite|pla7>.
  Consider a system that is specified by a physical parameter
  <math|\<theta\>> and let <math|f<around|(|x,\<theta\>|)>> describe the
  normalized probability distribution function (PDF) for this parameter. If
  an observer were to make a measurement of <math|x> and had to best infer
  <math|\<theta\>> from such measurement, calling the resulting estimate
  <math|<wide|\<theta\>|~>=<wide|\<theta\>|~><around|(|x|)>>, one might well
  wonder how well <math|\<theta\>> could be determined. Estimation
  theory<nbsp><cite|frieden2> asserts that the <with|font-shape|italic|best
  possible estimator> <math|<wide|\<theta\>|~><around|(|x|)>>, after a very
  large number of <math|x>-samples is examined, suffers a mean-square error
  <math|e<rsup|2>> from <math|\<theta\>> obeying the rule
  <math|I*e<rsup|2>=1>, where the Fisher information measure (FIM) <math|I>,
  a functional of the PDF, reads

  <\equation>
    <label|eq.1-1>I<space|0.17em>=<space|0.17em><big|int><nbsp>d*x<nbsp>f<around|(|x,\<theta\>|)><around*|{|<frac|\<partial\><nbsp>|\<partial\>*\<theta\>><nbsp>ln
    <around|[|f<around|(|x,\<theta\>|)>|]>|}><rsup|2>.
  </equation>

  Any other estimator must have a larger mean-square error (all estimators
  must be unbiased, i.e., satisfy <math|<around|\<langle\>|<wide|\<theta\>|~><around|(|<with|font-series|bold|x>|)>|\<rangle\>>=<space|0.17em>\<theta\><label|unbias>>).
  Thus, FIM has a lower bound. No matter what the parameter <math|\<theta\>>
  of the system might be, <math|I> has to obey

  <\equation>
    <label|rao>I*<space|0.17em>e<rsub|\<theta\>><rsup|2><space|0.17em>\<ge\><space|0.17em>1,
  </equation>

  the celebrated Cramer\URao bound <cite|frieden2>. The particular instance
  of translational families merits a word. They are mono-parametric
  distribution families of the form <math|f<around|(|x,\<theta\>|)>=f*<around|(|x-\<theta\>|)>>,
  known up to the shift parameter <math|\<theta\>>. All family members
  exhibit identical shape. After introducing the amplitudes <math|\<psi\>>
  such that <math|f<around|(|x|)>=\<psi\><around|(|x|)><rsup|2>>, FIM adopts
  the simpler aspect <cite|frieden3>

  <\equation>
    <label|eq.1-2>I<space|0.17em>=<space|0.17em><big|int><nbsp>d*x<nbsp>f<around|(|x|)><around*|{|<frac|\<partial\><nbsp>|\<partial\>*x><nbsp>ln
    <around|[|f<around|(|x|)>|]>|}><rsup|2>=4*<space|0.17em><big|int>d*x*<space|0.17em><around*|[|\<psi\>*'<around|(|x|)>|]><rsup|2>;<space|0.17em><space|0.17em><space|0.17em><space|0.17em><space|0.17em><around|(|d*\<psi\>/d*x=\<psi\>*'|)>.
  </equation>

  Note that for the uniform distribution <math|f<around|(|x|)>=c*o*n*s*t*a*n*t>
  one has <math|I=0>. Focus attention now a system that is specified by a set
  of <math|M> physical parameters <math|\<mu\><rsub|k>>. We can write
  <math|\<mu\><rsub|k>=<around|\<langle\>|A<rsub|k>|\<rangle\>>> with
  <math|A<rsub|k>=A<rsub|k><around|(|x|)>>. The set of
  <math|\<mu\><rsub|k>>-values constitutes the prior knowledge. It represents
  available empirical information. Let the pertinent probability distribution
  function (PDF) be <math|f<around|(|x|)>>. Then,

  <\equation>
    <label|eq.1-4><around|\<langle\>|A<rsub|k>|\<rangle\>><space|0.17em>=<space|0.17em><big|int><nbsp>d*x<nbsp>A<rsub|k><around|(|x|)><nbsp>f<around|(|x|)>,<space|0.5cm>k=1,\<ldots\>,M.
  </equation>

  In this context it can be shown (see for example <cite|pla7|reginatto>)
  that the <with|font-shape|italic|physically relevant> PDF
  <math|f<around|(|x|)>> minimizes the FIM (<reference|eq.1-2>) subject to
  the prior conditions and the normalization condition. In the celebrated
  MaxEnt approach of Jaynes' <cite|katz> one
  <with|font-shape|italic|maximizes> the entropy, that behaves
  information-wise in opposite fashion to that of Fisher's measure
  <cite|frieden3>. Normalization entails <math|<big|int>d*x*f<around|(|x|)>=1>,
  and, consequently, our Fisher-based extremization problem adopts the
  appearance

  <\equation>
    <label|eq.1-6>\<delta\>*<around*|(|I-\<alpha\>*<big|int><nbsp>d*x<nbsp>f<around|(|x|)>-<big|sum><rsub|k=1><rsup|M><nbsp>\<lambda\><rsub|k>*<big|int><nbsp>d*x<nbsp>A<rsub|k><around|(|x|)><nbsp>f<around|(|x|)>|)>=<nbsp>0
  </equation>

  where we have introduced the <math|<around|(|M+1|)>> Lagrange multipliers
  <math|\<lambda\><rsub|k>> (<math|\<lambda\><rsub|0>=\<alpha\>>). In Ref.
  <cite|pla7> on can find the details that lead from (<reference|eq.1-6>) to
  a Schrdinger's equation (SE) that yields the desired PDF in terms of an
  amplitude <math|\<psi\><around|(|x|)>> referred to above before Eq.
  (<reference|eq.1-2>). This SE is of the form

  <\equation>
    <label|eq.1-8>-<nbsp><frac|1|2><nbsp><frac|\<partial\><rsup|2><nbsp>|\<partial\>*x<rsup|2>>*\<psi\><nbsp>-<nbsp><big|sum><rsub|k=1><rsup|M><nbsp><frac|\<lambda\><rsub|k>|8><nbsp>A<rsub|k>*<space|0.17em>\<psi\><nbsp>=<nbsp><frac|\<alpha\>|8><nbsp>\<psi\>,
  </equation>

  which can be formally interpreted as the (real) Schrdinger equation for a
  particle of unit mass (<math|\<hbar\>=1>) moving in the effective,
  \Pinformation-related pseudo-potential" <cite|pla7>

  <\equation>
    <label|eq.1-9>U<nbsp>=<nbsp>U<around|(|x|)>=<nbsp>-<frac|1|8><nbsp><big|sum><rsub|k=1><rsup|M><space|0.17em>\<lambda\><rsub|k><nbsp>A<rsub|k><around|(|x|)>,
  </equation>

  in which the normalization-Lagrange multiplier (<math|\<alpha\>/8>) plays
  the role of an energy eigenvalue. The <math|\<lambda\><rsub|k>> are fixed,
  of course, by recourse to the available prior information. Note that
  <math|\<psi\><around|(|x|)>> is always real in the case of one-dimensional
  scenarios, or for the ground state of a real potential in N dimensions
  <cite|richard>. In terms of the amplitudes <math|\<psi\><around|(|x|)>> we
  have

  <eqnarray|<tformat|<table|<row|<cell|I>|<cell|=>|<cell|<space|0.17em><big|int>d*x<nbsp>f<around*|(|<frac|\<partial\>*ln
  f|\<partial\>*x>|)><rsup|2><space|0.17em>=<space|0.17em><big|int>d*x<nbsp>\<psi\><rsub|n><rsup|2><nbsp><around*|(|<frac|\<partial\>*ln
  \<psi\><rsub|n><rsup|2>|\<partial\>*x>|)><rsup|2><space|0.17em>=<space|0.17em>4*<big|int>d*x<nbsp><around*|(|<frac|\<partial\>*\<psi\><rsub|n>|\<partial\>*x>|)><rsup|2>=<n><eq-number><label|eq.1-12->>>|<row|<cell|>|<cell|=>|<cell|<space|0.17em>-<nbsp>4*<big|int>\<psi\><rsub|n>*<frac|\<partial\><rsup|2><nbsp>|\<partial\>*x<rsup|2>>*\<psi\><rsub|n><nbsp>d*x=<space|0.17em>-<nbsp>4<around*|\<langle\>|<frac|\<partial\><rsup|2><nbsp>|\<partial\>*x<rsup|2>>|\<rangle\>>=<big|int><nbsp>\<psi\><rsub|n>*<around*|(|\<alpha\>+<big|sum><rsub|k=1><rsup|M><nbsp>\<lambda\><rsub|k><nbsp>A<rsub|k>|)>*\<psi\><rsub|n><nbsp>d*x,<n><eq-number>>>>>>

  <nd>i.e.,

  <eqnarray|<tformat|<table|<row|<cell|I=<space|0.17em>\<alpha\>+<big|sum><rsub|k=1><rsup|M><nbsp>\<lambda\><rsub|k><around*|\<langle\>|A<rsub|k>|\<rangle\>>.<eq-number><label|eq.1-12>>>>>>

  a form that we will employ in our developments below. The connection
  between our variational solutions <math|f> and thermodynamics was
  established in Refs. <cite|pla7> and <cite|flego> in the guise of
  reciprocity relations that express the Legendre-transform structure of
  thermodynamics. They constitute its essential formal ingredient
  <cite|deslog> and were re-derived  la Fisher in <cite|pla7> by recasting
  (<reference|eq.1-12>) in a fashion that emphasizes the relevant independent
  variables

  <eqnarray|<tformat|<table|<row|<cell|I<around|(|<around*|\<langle\>|A<rsub|1>|\<rangle\>>,\<ldots\>,<around*|\<langle\>|A<rsub|M>|\<rangle\>>|)><space|0.17em>=<space|0.17em>\<alpha\>+<big|sum><rsub|k=1><rsup|M><nbsp>\<lambda\><rsub|k><around*|\<langle\>|A<rsub|k>|\<rangle\>>.<eq-number><label|eq.1-13a>>>>>>

  The Legendre transform changes the relevant variables. In the case of
  <math|I> this is

  <\equation>
    <label|eq.1-13b>\<alpha\>=I<around|(|<around*|\<langle\>|A<rsub|1>|\<rangle\>>,\<ldots\>,<around*|\<langle\>|A<rsub|M>|\<rangle\>>|)>-<big|sum><rsub|k=1><rsup|M><nbsp>\<lambda\><rsub|k><around*|\<langle\>|A<rsub|k>|\<rangle\>>=\<alpha\><around|(|\<lambda\><rsub|1>,\<ldots\>,\<lambda\><rsub|M>|)>,
  </equation>

  so that we encounter the three reciprocity relations proved in <cite|pla7>

  <\equation>
    <label|RR-1><frac|\<partial\>*\<alpha\>|\<partial\>*\<lambda\><rsub|i>>=-<around|\<langle\>|A<rsub|i>|\<rangle\>><nbsp>;<space|1.cm>\<lambda\><rsub|k><space|0.17em>=<space|0.17em><frac|\<partial\>*I|\<partial\><around*|\<langle\>|A<rsub|k>|\<rangle\>>><nbsp>;<space|1.cm><frac|\<partial\>*I|\<partial\>*\<lambda\><rsub|i>>=<big|sum><rsub|k><rsup|M>\<lambda\><rsub|k>*<frac|\<partial\><around|\<langle\>|A<rsub|k>|\<rangle\>>|\<partial\>*\<lambda\><rsub|i>>,
  </equation>

  the last one being a generalized Fisher-Euler theorem.

  <section|Present results>

  <nd>Our previous Fisher considerations lead to a scenario for which

  <eqnarray|<tformat|<table|<row|<cell|H=-<frac|1|2><nbsp><frac|\<partial\><rsup|2><nbsp>|\<partial\>*x<rsup|2>><nbsp>+U<around|(|x|)><nbsp>,<space|0.5cm>U<around|(|x|)>=-<nbsp><frac|1|8>*<big|sum><rsub|k><space|0.17em>\<lambda\><rsub|k>*<space|0.17em>A<rsub|k><nbsp>,<space|0.5cm>E<rsub|n>=<frac|\<alpha\>|8><nbsp>.<eq-number><label|SWE-1>>>>>>

  <nd>Enters here, as essential new ingredient in the present considerations,
  the celebrated virial theorem <cite|virial> that of course applies in this
  Schrdinger-scenario <cite|greiner>. This theorem is intimately related to
  the reciprocity relations of the preceding Section, as discussed in
  <cite|nuestro2> and states that

  <eqnarray|<tformat|<table|<row|<cell|<around*|\<langle\>|-<nbsp><frac|\<partial\><rsup|2><nbsp>|\<partial\>*x<rsup|2>>|\<rangle\>>=<around*|\<langle\>|x<nbsp><frac|\<partial\><nbsp>|\<partial\>*x>*U<around|(|x|)>|\<rangle\>>.<eq-number><label|virial-4>>>>>>

  The potential function <math|U<around|(|x|)>> belongs to
  <math|\<cal-L\><rsub|2>> and thus admit of a series expansion in
  <math|x,<space|0.17em>x<rsup|2>*<space|0.17em>x<rsup|3>,<space|0.17em>>etc.
  <cite|greiner>. The <math|A<rsub|k><around|(|x|)>> themselves belong to
  <math|\<cal-L\><rsub|2>> as well and can be series-expanded in similar
  fashion. This enables us to base our future considerations on the
  assumption that the a priori knowledge refers to moments <math|x<rsup|k>>
  of the independent variable, i.e.,

  <\equation>
    <around|\<langle\>|A<rsub|k>|\<rangle\>><nbsp>=<nbsp><around|\<langle\>|x<rsup|k>|\<rangle\>><nbsp>,
  </equation>

  and that one possesses information on <math|M> moment-mean values
  <math|<around|\<langle\>|x<rsup|k>|\<rangle\>>>. Our \Pinformation"
  potential <math|U> then reads

  <\equation>
    <label|virial-5>U<around|(|x|)>=-<nbsp><frac|1|8>*<big|sum><rsub|k><space|0.17em>\<lambda\><rsub|k>*<space|0.17em>x<rsup|k><space|0.17em>.
  </equation>

  and Eq. (<reference|virial-4>) allows one to immediately obtain

  <eqnarray|<tformat|<table|<row|<cell|<around*|\<langle\>|<frac|\<partial\><rsup|2><nbsp>|\<partial\>*x<rsup|2>>|\<rangle\>><space|0.17em>=<space|0.17em><nbsp><frac|1|8><nbsp><big|sum><rsub|k=1><rsup|M><space|0.17em>k*<space|0.17em>\<lambda\><rsub|k><nbsp><around*|\<langle\>|A<rsub|k>|\<rangle\>>;<space|1.2cm><around|(|A<rsub|k>=x<rsup|k>|)>,<eq-number><label|virial-6>>>>>>

  and thus, via (<reference|virial-6>) and the above mentioned relation
  <math|I=-<nbsp>4<around*|\<langle\>|<frac|\<partial\><rsup|2><nbsp>|\<partial\>*x<rsup|2>>|\<rangle\>>>,
  a useful, virial-related expression for Fisher's information measure can be
  arrived at.

  <eqnarray|<tformat|<table|<row|<cell|I<space|0.17em>=<space|0.17em>-<nbsp><nbsp><big|sum><rsub|k=1><rsup|M><space|0.17em><frac|k|2>*<space|0.17em>\<lambda\><rsub|k><nbsp><around|\<langle\>|x<rsup|k>|\<rangle\>>,<eq-number><label|virial-7>>>>>>

  which is an explicit function of the M physical parameters
  <math|<around|\<langle\>|x<rsup|k>|\<rangle\>>> and their respective
  Lagrange multipliers <math|\<lambda\><rsub|k>>. Eq. (<reference|virial-7>)
  encodes the information provided by the virial theorem. Thus, we have two
  different ways of expressing <math|I>, namely, (<reference|eq.1-12>) and
  (<reference|virial-7>). Interesting things happen if we put them together.
  Since <math|\<lambda\><rsub|k>> is given by (<reference|RR-1>) as
  <math|<around|[|\<partial\>*I/\<partial\><around|\<langle\>|x<rsup|k>|\<rangle\>>|]>>,
  inserting the reciprocity relations (<reference|RR-1>) into
  (<reference|virial-7>) we are led to

  <eqnarray|<tformat|<table|<row|<cell|<frac|\<partial\>*I|\<partial\><around|\<langle\>|x<rsup|k>|\<rangle\>>><space|0.17em>=<space|0.17em>\<lambda\><rsub|k><space|0.5cm>>|<cell|<space|1.cm>\<longrightarrow\><space|1.cm>>|<cell|I<space|0.17em>=<space|0.17em>-<nbsp><big|sum><rsub|k=1><rsup|M><space|0.17em><frac|k|2><nbsp><around|\<langle\>|x<rsup|k>|\<rangle\>><nbsp><frac|\<partial\>*I|\<partial\><around*|\<langle\>|x<rsup|k>|\<rangle\>>><space|0.17em>.<eq-number><label|gov-1>>>>>>

  Eq. (<reference|gov-1>) constitutes an important result, since we have now
  at our disposal a <with|font-shape|italic|differential FIM-equation>.
  Dealing with it should allow us to find <math|I> in terms of the
  <math|<around|\<langle\>|x<rsup|k>|\<rangle\>>>
  <with|font-shape|italic|without passing first through a Schrdinger
  equation first>, a commendable achievement. For convenience we now recast
  our key relations using dimensionless magnitudes

  <eqnarray|<tformat|<table|<row|<cell|\<forall\><nbsp><around|\<langle\>|A<rsub|k>|\<rangle\>>\<equiv\><around|\<langle\>|x<rsup|k>|\<rangle\>><nbsp>\<neq\><nbsp>0*<space|0.3cm>\<cal-I\><nbsp>=<nbsp><frac|I|<around|[|I|]>><nbsp>=<nbsp><frac|I|<around|[|x|]><rsup|-2>>;<space|0.3cm><around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>><nbsp>=<nbsp><frac|<around|\<langle\>|x<rsup|k>|\<rangle\>>|<around|[|<around|\<langle\>|x<rsup|k>|\<rangle\>>|]>><nbsp>=<nbsp><frac|<around|\<langle\>|x<rsup|k>|\<rangle\>>|<around|[|x|]><rsup|k>><nbsp>,<eq-number><label|gov-2>>>>>>

  where <math|<around|[|I|]>> and <math|<around|[|<around|\<langle\>|x<rsup|k>|\<rangle\>>|]>>
  denote the dimension of <math|I> and <math|<around|\<langle\>|x<rsup|k>|\<rangle\>>>,
  respectively. Thus, the differential equation that governs the
  FIM-behavior, i.e., (<reference|gov-1>), can be translated into

  <eqnarray|<tformat|<table|<row|<cell|\<cal-I\><space|0.17em>=<space|0.17em>-<nbsp><big|sum><rsub|k=1><rsup|M><space|0.17em><frac|k|2><nbsp><around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>><nbsp><frac|\<partial\>*\<cal-I\>|\<partial\><around*|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>>><space|0.17em>,<eq-number><label|gov-3>>>>>>

  and is easily solved. <vspace|0.3cm><nd> We first set

  <eqnarray|<tformat|<table|<row|<cell|\<cal-I\>=<nbsp><big|sum><rsub|k=1><rsup|M><nbsp>\<cal-I\><rsub|k><nbsp>=<nbsp><big|sum><rsub|k=1><rsup|M><nbsp>exp
  <around*|[|<nbsp>g<around|(|<around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>>|)><nbsp>|]>,<eq-number><label|gov-4>>>>>>

  and substituting (<reference|gov-4>) into (<reference|gov-3>) leads to

  <eqnarray|<tformat|<table|<row|<cell|\<cal-I\><space|0.17em>=<space|0.17em>-<nbsp><big|sum><rsub|k=1><rsup|M><space|0.17em><frac|k|2><nbsp><around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>><nbsp>g*'<around|(|<around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>>|)><nbsp>\<cal-I\><rsub|k><space|0.17em>.<eq-number><label|gov-5>>>>>>

  The above relation entails

  <eqnarray|<tformat|<table|<row|<cell|<nbsp>g*'<around|(|<around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>>|)>=-<nbsp><frac|2|k<nbsp><around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>>><space|1.cm>\<longrightarrow\><space|1.cm><nbsp>g<around|(|<around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>>|)>=-<nbsp><frac|2|k><nbsp>ln
  <around*|\||<around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>>|\|>+c<rsub|k><space|0.17em>,<eq-number><label|gov-6>>>>>>

  where <math|c<rsub|k>> is an integration constant. Finally, substituting
  (<reference|gov-6>) into (<reference|gov-4>) we arrive at

  <eqnarray|<tformat|<table|<row|<cell|\<cal-I\>=<big|sum><rsub|k=1><rsup|M><nbsp>C<rsub|k><nbsp>exp
  <around*|(|-<nbsp><frac|2|k><nbsp>ln <around*|\||<around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>>|\|>|)><nbsp>,<space|1.2cm>C<rsub|k>=<nbsp>e<rsup|c<rsub|k>><nbsp>\<gtr\><nbsp>0<nbsp>,<eq-number><label|gov-7>>>>>>

  which can be recast as

  <eqnarray|<tformat|<table|<row|<cell|\<cal-I\><around|(|<around|\<langle\>|\<cal-X\><rsub|1>|\<rangle\>>,...,<around|\<langle\>|\<cal-X\><rsub|M>|\<rangle\>>|)>=<nbsp><big|sum><rsub|k=1><rsup|M><nbsp>C<rsub|k><nbsp><nbsp><around*|\||<around|\<langle\>|\<cal-X\><rsub|k>|\<rangle\>>|\|><rsup|-2/k><nbsp>,<eq-number><label|gov-8>>>>>>

  or, in function of the original input-quantities (<reference|gov-2>)

  <eqnarray|<tformat|<table|<row|<cell|I<around|(|<around|\<langle\>|x<rsup|1>|\<rangle\>>,...,<around|\<langle\>|x<rsup|M>|\<rangle\>>|)>=<nbsp><big|sum><rsub|k=1><rsup|M><nbsp>C<rsub|k><nbsp><nbsp><around*|\||<around|\<langle\>|x<rsup|k>|\<rangle\>>|\|><rsup|-2/k><nbsp>,<eq-number><label|gov-9>>>>>>

  our main present result. We enumerate below the main properties of our
  minimal <math|I>.

  <\itemize>
    <item><with|font-series|bold|FIM-domain>

    <nd>Obviously, it is

    <\equation*>
      <with|font-shape|italic|D*o*m><around|[|I|]>=<around*|{|<around|(|<around|\<langle\>|x<rsup|1>|\<rangle\>>,...,<around|\<langle\>|x<rsup|M>|\<rangle\>>|)>/<around|\<langle\>|x<rsup|k>|\<rangle\>><nbsp>\<in\><nbsp>\<Re\><rsub|o>|}>
    </equation*>

    <item><with|font-series|bold|FIM-monotonicity>

    <nd>From the reciprocity relations we know that

    <eqnarray|<tformat|<table|<row|<cell|\<lambda\><rsub|k><nbsp>=<nbsp><frac|\<partial\>*I|\<partial\><around|\<langle\>|x<rsup|k>|\<rangle\>>><nbsp>=<nbsp>-<nbsp><frac|2|k<nbsp><around|\<langle\>|x<rsup|k>|\<rangle\>>>*I<rsub|k>.<eq-number><label|prop-2>>>>>>

    Therefore, if <math|<around|\<langle\>|x<rsup|k>|\<rangle\>><nbsp>\<gtr\><nbsp>0<nbsp><around|(|\<lambda\><rsub|k>\<less\>0|)>>
    then <math|I> is a monotonically decreasing function in the
    <math|<around|\<langle\>|x<rsup|k>|\<rangle\>>>-direction.

    <item><with|font-series|bold|FIM-convexity>

    <nd>This is a necessary property, since the entropy is concave. By
    differentiation of the expression (<reference|prop-2>) one obtains

    <eqnarray|<tformat|<table|<row|<cell|<frac|\<partial\><rsup|2>*I|\<partial\><around|\<langle\>|x<rsup|n>|\<rangle\>>*\<partial\><around|\<langle\>|x<rsup|k>|\<rangle\>>><space|0.17em>=<space|0.17em><around*|(|1+<frac|k|2>|)>*<frac|4|k<rsup|2>><nbsp><frac|1|<around|\<langle\>|x<rsup|k>|\<rangle\>><rsup|2>><nbsp>I<rsub|k><nbsp>\<delta\><rsub|k*n>,<eq-number><label|prop-3>>>>>>

    from which we can assert that the Fisher measure is a convex function. It
    is then guaranteed that the inverse of
    <math|\<partial\><rsub|k>*\<partial\><rsub|j>*<wide|\<alpha\>|\<bar\>>>
    exists.

    <item><with|font-series|bold|Scaling-property>

    <nd>Under the scaling transform <math|x=a*<wide|x|\<bar\>>> we have

    <eqnarray|<tformat|<table|<row|<cell|I<around|(|<around|\<langle\>|x<rsup|1>|\<rangle\>>,...,<around|\<langle\>|x<rsup|M>|\<rangle\>>|)>>|<cell|=>|<cell|<nbsp><big|sum><rsub|k=1><rsup|M><nbsp>C<rsub|k><nbsp><around*|\||<around|\<langle\>|x<rsup|k>|\<rangle\>>|\|><rsup|-2/k>=<nbsp><n><eq-number><label|prop-4>>>|<row|<cell|>|<cell|=>|<cell|<nbsp><big|sum><rsub|k=1><rsup|M><nbsp>C<rsub|k><nbsp><around*|\||<around|\<langle\>|<around|(|a*<wide|x|\<bar\>>|)><rsup|k>|\<rangle\>>|\|><rsup|-2/k>=<nbsp><n><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<nbsp><big|sum><rsub|k=1><rsup|M><nbsp>C<rsub|k><nbsp><around*|\||a<rsup|k>|\|><rsup|-2/k><nbsp><around*|\||<around|\<langle\>|<wide|x|\<bar\>><rsup|k>|\<rangle\>>|\|><rsup|-2/k>=<nbsp><n><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<nbsp><big|sum><rsub|k=1><rsup|M><nbsp>C<rsub|k><nbsp>a<rsup|-2><nbsp><around*|\||<around|\<langle\>|<wide|x|\<bar\>><rsup|k>|\<rangle\>>|\|><rsup|-2/k>=<nbsp><n><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<nbsp>a<rsup|-2><nbsp><wide|I|\<bar\>><around|(|<around|\<langle\>|<wide|x|\<bar\>><rsup|1>|\<rangle\>>,...,<around|\<langle\>|<wide|x|\<bar\>><rsup|M>|\<rangle\>>|)>,<eq-number>>>>>>

    as one should expect. Why? Because that is the well-known behavior of the
    eigenvalues of Schrdinger's equation.

    <item><with|font-series|bold|Appropriate referential system>

    <nd>The reference quantities <math|C<rsub|k>> should contain important
    information concerning the referential system with respect the which
    prior conditions are experimentally determined. Note that when FIM is
    constrained to obey the bound (<reference|rao>) <cite|frieden2>, since
    the best estimator exhibits a CR relation as close to unity as possibly,
    it is convenient that all integration constants <math|c<rsub|k>> should
    vanish and <math|C<rsub|k><nbsp>=<nbsp>e<rsup|c<rsub|k>><nbsp>=<nbsp>1>
    for all <math|k>. Of course, such a statement is merely conjectural at
    this point.
  </itemize>

  <section|MINIMUM OF THE INFORMATION POTENTIAL>

  <nd>It is convenient to incorporate at the outset, within the
  <math|I->form, information concerning the minimum of the information
  potential. Assume that this information-potential

  <eqnarray|<tformat|<table|<row|<cell|U<around|(|x|)>=-<nbsp><frac|1|8>*<big|sum><rsub|x=1><rsup|M>\<lambda\><rsub|k>*x<rsup|k>,<n><eq-number>>>>>>

  achieves its absolute minimum at the \Pcritical point" <math|x=\<xi\>>,

  <eqnarray|<tformat|<table|<row|<cell|U<rsup|<nbsp>'><around|(|\<xi\>|)><nbsp>=<nbsp>0<nbsp>,<space|2.cm>U<rsub|m*i*n><nbsp>=<nbsp>U<around|(|\<xi\>|)>,<eq-number>>>>>>

  <nd>then effecting the FIM-translational transform <math|u=x-\<xi\>> leads
  us to

  <eqnarray|<tformat|<table|<row|<cell|I=-<nbsp><big|sum><rsub|k=1><rsup|M><nbsp><frac|k|2><nbsp>\<lambda\><rsub|k><nbsp><around|\<langle\>|x<rsup|k>|\<rangle\>>=<nbsp>-<nbsp><big|sum><rsub|k=1><rsup|M><nbsp><frac|k|2><nbsp>\<lambda\><rsub|k><rsup|\<nosymbol\>><nbsp><around|\<langle\>|u<rsup|k>|\<rangle\>>*',<eq-number><label|sys-1>>>>>>

  with (see the Appendix)

  <eqnarray|<tformat|<table|<row|<cell|\<lambda\><rsub|k><rsup|\<nosymbol\>><nbsp>=<nbsp>-<nbsp><frac|8|k!><nbsp>U<rsup|<around|(|k|)>><around|(|\<xi\>|)><nbsp>,<space|1.2cm><around|\<langle\>|u<rsup|k>|\<rangle\>>*'<space|0.17em>=<space|0.17em><around|\<langle\>|<around|(|x-\<xi\>|)><rsup|k>|\<rangle\>><nbsp><eq-number><label|sys-2>>>>>>

  where <math|U<rsup|<around|(|k|)>><around|(|\<xi\>|)>> is the
  <math|k<rsup|t*h>> derivative of U(x) evaluate in <math|x=\<xi\>> and
  <math|<around|\<langle\>|<nbsp>|\<rangle\>><rprime|'>> indicates that the
  moment is calculated for translation-transform eigenfunctions. <nd>The
  corresponding FIM-explicit functional expression is built up with the
  <math|N->non-vanishing momenta (<math|N\<less\>M>)
  (<math|<around|\<langle\>|u<rsup|k>|\<rangle\>><rprime|'>\<neq\>0>) and is
  given by

  <eqnarray|<tformat|<table|<row|<cell|I=<nbsp><big|sum><rsub|k=2><rsup|N><nbsp><nbsp><around*|\||<around|\<langle\>|u<rsup|k>|\<rangle\>>*'|\|><rsup|-2/k><nbsp>=<nbsp><big|sum><rsub|k=2><rsup|N><nbsp><nbsp><around*|\||<around|\<langle\>|<around|(|x-\<xi\>|)><rsup|k>|\<rangle\>>|\|><rsup|-2/k><nbsp>,<eq-number><label|sys-3>>>>>>

  <nd>where we kept in mind that <math|\<lambda\><rsub|1><rsup|\<ast\>>=-8*U<rprime|'><around|(|\<xi\>|)><nbsp>=<nbsp>0>.
  A glance at the above FIM-expression suggests that we re-arrange things in
  the fashion

  <eqnarray|<tformat|<table|<row|<cell|I=<nbsp><around*|\||<around|\<langle\>|<around|(|x-\<xi\>|)><rsup|2>|\<rangle\>>|\|><rsup|-1>+<big|sum><rsub|k=3><rsup|N><nbsp><nbsp><around*|\||<around|\<langle\>|<around|(|x-\<xi\>|)><rsup|k>|\<rangle\>>|\|><rsup|-2/k><nbsp>.<eq-number><label|CR-1>>>>>>

  Taking now into account that

  <eqnarray|<tformat|<table|<row|<cell|<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<around|\<langle\>|<nbsp>x-\<xi\><nbsp>|\<rangle\>>=0>>|<row|<cell|<around|\<langle\>|<around|(|x-\<xi\>|)><rsup|2>|\<rangle\>>=<around|\<langle\>|x<rsup|2>|\<rangle\>>-2*\<xi\><around|\<langle\>|x|\<rangle\>>+\<xi\><rsup|2>>>>>>|\<nobracket\>>\<rightarrow\><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<around|\<langle\>|<nbsp>x<nbsp>|\<rangle\>><nbsp>=<nbsp>\<xi\>>>|<row|<cell|<around|\<langle\>|<around|(|x-\<xi\>|)><rsup|2>|\<rangle\>>=<around|\<langle\>|x<rsup|2>|\<rangle\>>-<around|\<langle\>|x|\<rangle\>><rsup|2>=\<sigma\><rsup|2>>>>>>|\<nobracket\>><nbsp><eq-number><label|CR-2>>>>>>

  we get

  <eqnarray|<tformat|<table|<row|<cell|I=<nbsp><frac|1|\<sigma\><rsup|2>><nbsp>+<big|sum><rsub|k=3><rsup|N><nbsp><nbsp><around*|\||<around|\<langle\>|<around|(|x-\<xi\>|)><rsup|k>|\<rangle\>>|\|><rsup|-2/k><nbsp>,<eq-number><label|CR-3>>>>>>

  from which we obtain

  <eqnarray|<tformat|<table|<row|<cell|I<nbsp>\<sigma\><rsup|2>=<nbsp>1<nbsp>+<nbsp>\<sigma\><rsup|2>*<big|sum><rsub|k=3><rsup|N><nbsp><nbsp><around*|\||<around|\<langle\>|<around|(|x-\<xi\>|)><rsup|k>|\<rangle\>>|\|><rsup|-2/k><nbsp>\<geq\><nbsp>1<nbsp>.<eq-number><label|CR-4>>>>>>

  Therefore, <math|I> preserves the well-known Cramer-Rao <math|I->bound
  <cite|frieden3> <math|I<nbsp>\<sigma\><rsup|2><nbsp>\<geq\><nbsp>1>. The
  above seems to indicate that the lower bound can be reached only if no
  moment <math|k\<ge\>3> is a priori known.

  <section|Fisher-practitioner's manual>

  Specific instructions for encoding the prior information into FIM are given
  below.

  <\itemize>
    <item>First of all look for the <math|\<xi\>>-point at which the
    potential <math|V> achieves its minimum value

    <\equation*>
      V<rsub|m*i*n>=V<around|(|\<xi\>|)><nbsp>.
    </equation*>

    <vspace|0.2cm>

    <item>Define <math|u=x-\<xi\>> and, by recourse to the Newton-binomial,
    calculate

    <eqnarray|<tformat|<table|<row|<cell|<around|\<langle\>|u<rsup|n>|\<rangle\>>*'=<around|\<langle\>|<around|(|x-\<xi\>|)><rsup|n>|\<rangle\>>=<big|sum><rsub|j=1><rsup|n><nbsp>(-1)<rsup|j><nbsp><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|n>>|<row|<cell|j>>>>>|)><nbsp>\<xi\><rsup|j><nbsp><around|\<langle\>|x<rsup|n-j>|\<rangle\>>.<eq-number><label|manual-1>>>>>>

    <vspace|0.2cm>

    <item>Construct FIM explicitly as

    <eqnarray|<tformat|<table|<row|<cell|I=<nbsp><big|sum><rsub|k=2><rsup|N><nbsp><nbsp><around*|\||<around|\<langle\>|u<rsup|k>|\<rangle\>>*'|\|><rsup|-2/k><nbsp>.<eq-number><label|manual-2>>>>>>

    <item>Obtain the Lagrange multipliers by recourse to the reciprocity
    relations by following one of these alternative procedures.

    <with|font-series|bold|a.> Evaluate

    <eqnarray|<tformat|<table|<row|<cell|\<lambda\><rsub|k><rsup|\<nosymbol\>>=<frac|\<partial\>*I|\<partial\><around|\<langle\>|u<rsup|k>|\<rangle\>>*'>=-<frac|2|k>*<around*|\||<around|\<langle\>|u<rsup|k>|\<rangle\>>*'|\|><rsup|-<around|(|2/k|)>-1>.<eq-number><label|manual-3a>>>>>>

    and obtain the <math|\<lambda\><rsub|k>>-values by solving the system of
    equations (<reference|sys-2>).

    <with|font-series|bold|b.> Evaluate

    <eqnarray|<tformat|<table|<row|<cell|>|<cell|\<lambda\><rsub|k><space|0.17em>=<space|0.17em><frac|\<partial\>*I|\<partial\><around|\<langle\>|x<rsup|k>|\<rangle\>>><space|0.17em>=<space|0.17em><big|sum><rsub|k=1><rsup|M><frac|\<partial\>*I|\<partial\><around|\<langle\>|u<rsup|k>|\<rangle\>>*'>*<frac|\<partial\><around|\<langle\>|u<rsup|k>|\<rangle\>>*'|\<partial\><around|\<langle\>|x<rsup|k>|\<rangle\>>><space|0.17em>=<eq-number><label|manual-3b>>>|<row|<cell|>|<cell|=-<big|sum><rsub|k=1><rsup|M><frac|2|k>*<around*|\||<around|\<langle\>|u<rsup|k>|\<rangle\>>*'|\|><rsup|-<around|(|2/k|)>-1><frac|\<partial\><around|\<langle\>|u<rsup|k>|\<rangle\>>*'|\<partial\><around|\<langle\>|x<rsup|k>|\<rangle\>>>,<eq-number>>>>>>

    using (<reference|manual-1>) for calculating
    <math|<around|(|\<partial\><around|\<langle\>|u<rsup|k>|\<rangle\>><rprime|'>|)>/<around|(|\<partial\><around|\<langle\>|x<rsup|k>|\<rangle\>>|)>>.

    <vspace|0.2cm>

    <item>Encode into the <math|\<lambda\><rsub|k>> the prior information
    using the expression (<reference|manual-1>).

    <vspace|0.2cm>

    <item>Express <math|I> as a function of the prior knowledge by recourse
    to (<reference|virial-7>)

    <eqnarray|<tformat|<table|<row|<cell|I=-<big|sum><rsub|k=1><rsup|M><nbsp><frac|k|2><nbsp>\<lambda\><rsub|k><nbsp><around|\<langle\>|x<rsup|k>|\<rangle\>>.<eq-number><label|manual-4>>>>>>

    or using (<reference|manual-2>),

    <eqnarray|<tformat|<table|<row|<cell|I=<nbsp><big|sum><rsub|k=2><rsup|N><nbsp><nbsp><around*|\||<around|\<langle\>|u<rsup|k>|\<rangle\>>*'|\|><rsup|-2/k>.<eq-number><label|manual-4->>>>>>

    <vspace|0.2cm>

    <item>Compute the <math|\<alpha\>>-value by means of
    (<reference|eq.1-12>)

    <eqnarray|<tformat|<table|<row|<cell|\<alpha\>=I-<big|sum><rsub|k=1><rsup|M><nbsp>\<lambda\><rsub|k><nbsp><around|\<langle\>|x<rsup|k>|\<rangle\>>.<eq-number><label|manual-5>>>>>>
  </itemize>

  <vspace|0.3cm>

  <section|Illustrative examples>

  <nd>So as to illustrate the above considerations we are going to consider
  two simple and instructive examples. We take the mass <math|m=1> and
  <math|\<hbar\>=1>.

  <subsection|Harmonic oscillator (HO)>

  <nd>The prior information is given by

  <\equation*>
    <nbsp><around|\<langle\>|x<rsup|2>|\<rangle\>><nbsp>=<nbsp><frac|1|2*\<omega\>><nbsp>,<space|1.5cm>M<nbsp>=<nbsp>1<nbsp>,<space|1.5cm>k<nbsp>=<nbsp>2<nbsp>.
  </equation*>

  <\itemize>
    <item>The minimum of the potential function obtains at the origin
    <math|\<xi\>=0>,

    <\equation*>
      V<around|(|x|)>=\<lambda\><rsub|2><nbsp>x<rsup|2><space|0.5cm>\<longrightarrow\><space|0.5cm>V<rprime|'><around|(|\<xi\>|)>=2*\<lambda\><rsub|2><nbsp>\<xi\>=0<space|1.cm>\<longrightarrow\><space|0.5cm>\<xi\>=0.
    </equation*>

    <item>The pertinent FIM can be obtained using (<reference|manual-2>) with
    <math|u=x-\<xi\>=x>,

    <eqnarray|<tformat|<table|<row|<cell|I<nbsp>=<nbsp>I<around|(|<around|\<langle\>|x<rsub|2>|\<rangle\>>|)><nbsp>=<nbsp><around*|\||<around|\<langle\>|x<rsup|2>|\<rangle\>>|\|><rsup|-1><nbsp>.<eq-number><label|ex-2a>>>>>>

    <item>The corresponding Lagrange multiplier can be obtained from
    (<reference|manual-3b>) and (<reference|ex-2a>),

    <eqnarray|<tformat|<table|<row|<cell|\<lambda\><rsub|2><space|0.17em>=<space|0.17em>-<nbsp><around*|\||<around|\<langle\>|x<rsup|2>|\<rangle\>>|\|><rsup|-2><nbsp>=<nbsp>-<nbsp>4*\<omega\><rsup|2>.<eq-number><label|ex-2b>>>>>>

    <item>The prior-knowledge is encoded into the FIM from
    (<reference|manual-4>), and the <math|\<alpha\>->value can be obtained
    from (<reference|manual-5>), with <math|\<lambda\><rsub|2>> given by
    (<reference|ex-2b>)

    <eqnarray|<tformat|<table|<row|<cell|I<nbsp>>|<cell|=>|<cell|<nbsp>-\<lambda\><rsub|2><nbsp><around|\<langle\>|x<rsup|2>|\<rangle\>><nbsp>=<nbsp>2*\<omega\>;<space|0.17em><space|0.17em><space|0.17em>I<around|\<langle\>|x<rsup|2>|\<rangle\>>=1*<space|0.17em><space|0.17em><space|0.17em><around|(|C*R*<space|0.17em><space|0.17em>b*o*u*n*d*<space|0.17em><space|0.17em>i*s*<space|0.17em><space|0.17em>s*a*t*u*r*a*t*e*d|)>.<eq-number><label|ex-2c>>>|<row|<cell|\<alpha\>>|<cell|=>|<cell|<space|0.17em>I-<nbsp>\<lambda\><rsub|2><nbsp><around|\<langle\>|x<rsup|2>|\<rangle\>>=<nbsp><nbsp>4*\<omega\>.<eq-number><label|ex-2d>>>>>>
  </itemize>

  <subsection|Harmonic oscillator in a uniform field>

  <nd> We consider a charged unit-mass particle moving in the HO potential.
  The electrical charge is q and there is a uniform electric field
  <math|\<epsilon\>>, in the <math|x->direction. Our prior knowledge is given
  by <cite|greiner>

  <eqnarray|<tformat|<table|<row|<cell|<around|\<langle\>|x|\<rangle\>><nbsp>=<nbsp><frac|q<nbsp>\<epsilon\>|\<omega\><rsup|2>><nbsp>,<space|2.cm><around|\<langle\>|x<rsup|2>|\<rangle\>><nbsp>=<nbsp><frac|1|2*\<omega\>>+<around*|(|<frac|q<nbsp>\<epsilon\>|\<omega\><rsup|2>>|)><rsup|2><nbsp>.<eq-number><label|ex-3>>>>>>

  <vspace|4mm>We look first for the <math|\<xi\>>-point at which
  <math|V<around|(|x|)>> is minimal.

  <eqnarray|<tformat|<table|<row|<cell|<space|0.2cm>V*'<around|(|\<xi\>|)>=0<space|1.4cm>\<Longrightarrow\><space|1.4cm>\<xi\>=-<nbsp><frac|\<lambda\><rsub|1>|2<nbsp>\<lambda\><rsub|2>>.<eq-number><label|ex3-F1>>>>>>

  <nd>The translational transform <math|u=x-\<xi\>> implies that

  <eqnarray|<tformat|<table|<row|<cell|<around|\<langle\>|u|\<rangle\>>*'>|<cell|=>|<cell|<around|\<langle\>|x-\<xi\>|\<rangle\>>=<around|\<langle\>|x|\<rangle\>>-\<xi\><nbsp>,<n><eq-number><label|ex3-F2>>>|<row|<cell|<around|\<langle\>|u<rsup|2>|\<rangle\>>*'>|<cell|=>|<cell|<around|\<langle\>|<around|(|x-\<xi\>|)><rsup|2>|\<rangle\>>=<around|\<langle\>|x<rsup|2>|\<rangle\>>-2*\<xi\><around|\<langle\>|x|\<rangle\>>+\<xi\><rsup|2><nbsp>.<eq-number><label|ex3-F3>>>>>>

  <nd>The translation transformed FIM is now given by

  <eqnarray|<tformat|<table|<row|<cell|I<nbsp>=<nbsp><around*|\||<around|\<langle\>|u<rsup|2>|\<rangle\>>*'|\|><rsup|-1>.<eq-number><label|ex3-F4>>>>>>

  The reciprocity relations lead us to

  <eqnarray|<tformat|<table|<row|<cell|\<lambda\><rsub|1><space|0.17em>>|<cell|=>|<cell|<space|0.17em><frac|\<partial\><nbsp>I|\<partial\><around|\<langle\>|x|\<rangle\>>><space|0.17em>=<space|0.17em><space|0.17em><frac|\<partial\><nbsp>I|\<partial\><around|\<langle\>|u<rsup|2>|\<rangle\>>*'>*<space|0.17em><frac|\<partial\><around|\<langle\>|u<rsup|2>|\<rangle\>>*'|\<partial\><around|\<langle\>|x|\<rangle\>>><nbsp>=<nbsp>-<around*|\||<around|\<langle\>|u<rsup|2>|\<rangle\>>*'|\|><rsup|-2><nbsp>(-2<nbsp>\<xi\>)<nbsp><eq-number><label|ex3-F5>>>|<row|<cell|\<lambda\><rsub|2><space|0.17em>>|<cell|=>|<cell|<space|0.17em><frac|\<partial\><nbsp>I|\<partial\><around|\<langle\>|x<rsup|2>|\<rangle\>>><space|0.17em>=<space|0.17em><space|0.17em><frac|\<partial\><nbsp>I|\<partial\><around|\<langle\>|u<rsup|2>|\<rangle\>>*'>*<space|0.17em><frac|\<partial\><around|\<langle\>|u<rsup|2>|\<rangle\>>*'|\<partial\><around|\<langle\>|x<rsup|2>|\<rangle\>>><nbsp>=<nbsp>-<around*|\||<around|\<langle\>|u<rsup|2>|\<rangle\>>*'|\|><rsup|-2><nbsp>.<eq-number><label|ex3-F6>>>>>>

  From the prior knowledge (<reference|ex-3>) and (<reference|ex3-F2>) we
  have

  <eqnarray|<tformat|<table|<row|<cell|<around|\<langle\>|x|\<rangle\>>=\<xi\><nbsp>=<nbsp><frac|q<nbsp>\<epsilon\>|\<omega\><rsup|2>><nbsp><nbsp>,<eq-number><label|ex3-F7>>>>>>

  <eqnarray|<tformat|<table|<row|<cell|<around|\<langle\>|u<rsup|2>|\<rangle\>>*'<nbsp>=<nbsp><around|\<langle\>|x<rsup|2>|\<rangle\>>-\<xi\><rsup|2><nbsp>=<nbsp><frac|1|2*\<omega\>>+<around*|(|<frac|q<nbsp>\<epsilon\>|\<omega\><rsup|2>>|)><rsup|2><nbsp>-<nbsp><around*|(|<frac|q<nbsp>\<epsilon\>|\<omega\><rsup|2>>|)><rsup|2><nbsp>=<nbsp><frac|1|2*\<omega\>><nbsp>,<eq-number><label|ex3-F8>>>>>>

  and inserting (<reference|ex3-F7>) - (<reference|ex3-F8>) into
  (<reference|ex3-F4>), (<reference|ex3-F5>), and (<reference|ex3-F6>) we get

  <eqnarray|<tformat|<table|<row|<cell|I<nbsp>=<nbsp><around*|\||<around|\<langle\>|u<rsup|2>|\<rangle\>>*'|\|><rsup|-1><nbsp>=<nbsp><around*|\||<frac|1|2*\<omega\>>|\|><rsup|-1><nbsp>=<nbsp>2*\<omega\>,<eq-number><label|ex3-F9>>>>>>

  so that, again, the CR bound is saturated. As for the Lagrange multipliers,

  <eqnarray|<tformat|<table|<row|<cell|\<lambda\><rsub|1><space|0.17em>>|<cell|=>|<cell|<space|0.17em>2<nbsp>\<xi\><nbsp><around*|\||<around|\<langle\>|u<rsup|2>|\<rangle\>>*'|\|><rsup|-2><nbsp>=<nbsp>2<nbsp><frac|q<nbsp>\<epsilon\>|\<omega\><rsup|2>><nbsp><around|(|2<nbsp>\<omega\>|)><rsup|2><nbsp>=<nbsp>8<nbsp>q<nbsp>\<epsilon\><eq-number><label|ex3-F10>>>|<row|<cell|\<lambda\><rsub|2><space|0.17em>>|<cell|=>|<cell|<space|0.17em>-<around*|\||<around|\<langle\>|u<rsup|2>|\<rangle\>>*'|\|><rsup|-2><nbsp>=<nbsp>-<around|(|2<nbsp>\<omega\>|)><rsup|2><nbsp>=<nbsp>-4<nbsp>\<omega\><rsup|2><eq-number><label|ex3-F11>>>>>>

  The corresponding <math|\<alpha\>->value can be obtained from
  (<reference|eq.1-13b>) and (<reference|ex3-F9>-<reference|ex3-F11>)

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|\<alpha\>=<space|0.17em>I<nbsp>-\<lambda\><rsub|1><around|\<langle\>|x|\<rangle\>>-\<lambda\><rsub|2><around|\<langle\>|x<rsup|2>|\<rangle\>><nbsp>=<eq-number><label|ex3-F12>>>|<row|<cell|>|<cell|=<nbsp>2*\<omega\>-8*q*\<epsilon\><frac|q*\<epsilon\>|\<omega\><rsup|2>><nbsp>+4*\<omega\><rsup|2>*<around*|(|<frac|1|2*\<omega\>>+<around*|(|<frac|q<nbsp>\<epsilon\>|\<omega\><rsup|2>>|)><rsup|2>|)><nbsp>=<nbsp>4*\<omega\>.<eq-number>>>>>>

  <section|Conclusions>

  <nd>It was known for some time <cite|pla7> that, for one-dimensional
  scenarios, a minimal Fisher's information measure <math|I> is associated to
  a Schrdinger's equation in which the role of the potential is played by a
  weighted sum of the a priori known expectation values of <math|M>
  quantities <math|<around|\<langle\>|x<rsup|k>|\<rangle\>>>. The weights are
  the corresponding Lagrange multipliers <math|\<lambda\><rsub|k>>. Legendre
  reciprocity relations linking <math|I>, the <math|\<lambda\><rsub|k>> and
  the <math|<around|\<langle\>|x<rsup|k>|\<rangle\>>> apply.
  <vspace|4mm><nd>We have here demonstrated that insertion of virial
  theorem-tenets into this Legendre structure leads to a differential
  equation for <math|I>. The equation is analytically solvable and its
  solution provides us with a general, explicit new expression for <math|I>
  in terms of the input-information contained in the M expectation values
  <math|<around|\<langle\>|x<rsup|k>|\<rangle\>>>. <vspace|4mm><nd>An
  application to simple examples harmonic has illustrated these
  considerations. Of course, as is the case in the MaxEnt environment, the
  usefulness of (<reference|gov-9>) depends on how adequate is our input
  information for describing the situation at hand. Maximal entropy or
  minimum FIM are just the best ways to exploit that knowledge.
  <vspace|4mm><nd>It is important to note that, once in possession of this
  minimal <math|I>, one does not need to ever address any explicit
  <math|I->minimization task nor solve the FIM-associated Schrdinger
  equation, a fact that should be of interest to the large number of Fisher
  practitioners. Additionally, some new light on the Legendre transform
  substructure that underlies Schrdinger's equation has been here shed.

  <vspace|0.5cm><vspace|0.5cm><section|Appendix>

  <nd>The potential function

  <eqnarray|<tformat|<table|<row|<cell|U<around|(|x|)>=-<nbsp><frac|1|8>*<big|sum><rsub|k=1><rsup|M>\<lambda\><rsub|k>*x<rsup|k>.<n><eq-number><label|ap-1>>>>>>

  <nd>can be Taylor-expanded about <math|x=\<xi\>>

  <eqnarray|<tformat|<table|<row|<cell|U<around|(|x|)>=<big|sum><rsub|k=0><rsup|M><frac|U<rsup|<around|(|k|)>><around|(|\<xi\>|)>|k<nbsp>!>*<around|(|x-\<xi\>|)><rsup|k><n><eq-number><label|ap-2>>>>>>

  <vspace|0.2cm><nd>The translational transform <math|u=x-\<xi\>> leads to

  <eqnarray|<tformat|<table|<row|<cell|<wide|U|\<bar\>><around|(|u|)>=<nbsp>U*<around|(|u+\<xi\>|)>=<nbsp><big|sum><rsub|k=0><rsup|M><nbsp><frac|U<rsup|<around|(|k|)>><around|(|\<xi\>|)>|k<nbsp>!>*u<rsup|k>,<eq-number><label|ap-3>>>>>>

  <nd>which can be recast as

  <eqnarray|<tformat|<table|<row|<cell|<wide|U|\<bar\>><around|(|u|)>=-<nbsp><frac|1|8>*<big|sum><rsub|k=0><rsup|M><nbsp>\<lambda\><rsup|\<nosymbol\>><rsub|k>*u<rsup|k><nbsp>,<eq-number><label|ap-4>>>>>>

  <nd>with

  <eqnarray|<tformat|<table|<row|<cell|\<lambda\><rsup|\<nosymbol\>><rsub|k><nbsp>\<equiv\><nbsp>-<nbsp>8<nbsp><frac|U<rsup|<around|(|k|)>><around|(|\<xi\>|)>|k<nbsp>!>=-<nbsp><frac|8|k!>*<big|sum><rsub|j=1><rsup|M><nbsp>j*<around|(|j-1|)>*<around|(|j-2|)>*\<cdots\>*<around|(|j-k+1|)><nbsp>\<lambda\><rsub|j><nbsp>\<xi\><rsup|j-k><nbsp>.<eq-number><label|ap-5>>>>>>

  <nd>The FIM-translational transform <math|u=x-\<xi\>> is obtained from
  (<reference|eq.1-12>) in the fashion (<math|<around|\<langle\>|<nbsp>|\<rangle\>><rprime|'>>
  indicates that the moment is calculated for translation-transform
  eigenfunctions)

  <eqnarray|<tformat|<table|<row|<cell|I<space|0.17em>=<space|0.17em>-<nbsp>4*<big|int>\<psi\>*<frac|\<partial\><rsup|2><nbsp>|\<partial\>*x<rsup|2>>*\<psi\><nbsp>d*x=<space|0.17em>-<nbsp>4*<big|int><wide|\<psi\>|\<bar\>>*<frac|\<partial\><rsup|2><nbsp>|\<partial\>*u<rsup|2>>*<wide|\<psi\>|\<bar\>><nbsp>d*u=<space|0.17em>-<nbsp>4<around*|\<langle\>|<frac|\<partial\><rsup|2><nbsp>|\<partial\>*u<rsup|2>>|\<rangle\>>*',<eq-number><label|ap-6>>>>>>

  where <math|<wide|\<psi\>|\<bar\>>=<wide|\<psi\>|\<bar\>><around|(|u|)>> is
  the translation transform of <math|\<psi\><around|(|x|)>>. Now, using the
  translation transform of (<reference|eq.1-8>) one easily finds

  <eqnarray|<tformat|<table|<row|<cell|I<space|0.17em>=<space|0.17em><big|int><nbsp><wide|\<psi\>|\<bar\>><rsub|n>*<around*|(|\<alpha\>+<big|sum><rsub|k=0><rsup|M><nbsp>\<lambda\><rsup|\<nosymbol\>><rsub|k><nbsp>u<rsup|k>|)>*<wide|\<psi\>|\<bar\>><rsub|n><nbsp>d*u<nbsp>,<eq-number><label|ap-7>>>>>>

  <nd>and one realizes that

  <eqnarray|<tformat|<table|<row|<cell|I<space|0.17em>=<space|0.17em>\<alpha\>+<big|sum><rsub|k=0><rsup|M><nbsp>\<lambda\><rsup|\<nosymbol\>><rsub|k><around|\<langle\>|u<rsup|k>|\<rangle\>>*'<space|0.17em>=<space|0.17em><wide|\<alpha\>|\<bar\>>+<big|sum><rsub|k=1><rsup|M><nbsp>\<lambda\><rsup|\<nosymbol\>><rsub|k><around|\<langle\>|u<rsup|k>|\<rangle\>>*'<nbsp>,<eq-number><label|ap-8>>>>>>

  where

  <eqnarray|<tformat|<table|<row|<cell|<wide|\<alpha\>|\<bar\>>=\<alpha\>+\<lambda\><rsup|\<nosymbol\>><rsub|0>=\<alpha\>-8*U<around|(|\<xi\>|)>.<eq-number><label|ap-9>>>>>>

  <vspace|0.2cm><nd>Also, the virial theorem (<reference|virial-4>) leads to

  <eqnarray|<tformat|<table|<row|<cell|I=4<nbsp><around*|\<langle\>|<nbsp><frac|\<partial\><rsup|2><nbsp>|\<partial\>*u<rsup|2>>|\<rangle\>>*'=-<nbsp>4<nbsp><around*|\<langle\>|u<nbsp><frac|\<partial\><nbsp>|\<partial\>*u>*<wide|U|\<bar\>><around|(|u|)>|\<rangle\>>*'<nbsp>=<nbsp>-<nbsp><big|sum><rsub|k=1><rsup|M><nbsp><frac|k|2><nbsp>\<lambda\><rsup|\<nosymbol\>><rsub|k><nbsp><around|\<langle\>|u<rsup|k>|\<rangle\>>*'<eq-number><label|ap-10>>>>>>

  <vspace|0.5cm><nd>The translation-transformed moments
  <math|<around|\<langle\>|u<rsup|k>|\<rangle\>><rprime|'>> are related to
  the original moments as

  <eqnarray|<tformat|<table|<row|<cell|<around|\<langle\>|u<rsup|k>|\<rangle\>>*'<space|0.17em>=<space|0.17em><big|int>u<rsup|k><nbsp><wide|\<psi\>|\<bar\>><rsup|2><around|(|u|)><nbsp>d*u<space|0.17em>=<space|0.17em><big|int>u<rsup|k><nbsp>\<psi\><rsup|2>*<around|(|u+\<xi\>|)><nbsp>d*u<space|0.17em>=<space|0.17em><big|int><around|(|x-\<xi\>|)><rsup|k><nbsp>\<psi\><rsup|2><around|(|x|)><nbsp>d*x<space|0.17em>=<space|0.17em><around|\<langle\>|<around|(|x-\<xi\>|)><rsup|k>|\<rangle\>><nbsp><n><eq-number><label|ap-11>>>>>>

  <vspace|0.5cm><nd>By recourse to the Newton-binomial we write

  <eqnarray|<tformat|<table|<row|<cell|<big|int><around|(|x-\<xi\>|)><rsup|k><nbsp>\<psi\><rsup|2><around|(|x|)><nbsp>d*x<nbsp>=<nbsp><big|sum><rsub|j=1><rsup|k><nbsp>(-1)<rsup|j><nbsp><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|k>>|<row|<cell|j>>>>>|)><nbsp>\<xi\><rsup|j><nbsp><big|int>x<rsup|k-j><nbsp>\<psi\><rsup|2><around|(|x|)><nbsp>d*x,<eq-number><label|ap-12>>>>>>

  <nd>and then we finally have

  <eqnarray|<tformat|<table|<row|<cell|<around|\<langle\>|u<rsup|k>|\<rangle\>>*'<nbsp>=<space|0.17em><around|\<langle\>|<around|(|x-\<xi\>|)><rsup|k>|\<rangle\>><nbsp>=<nbsp><big|sum><rsub|j=1><rsup|k><nbsp>(-1)<rsup|j><nbsp><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|k>>|<row|<cell|j>>>>>|)><nbsp>\<xi\><rsup|j><nbsp><around|\<langle\>|x<rsup|k-j>|\<rangle\>>.<eq-number><label|ap-13>>>>>>

  <vspace|0.5cm><section*|References>

  <\thebibliography|10>
    <bibitem|frieden>B R Frieden 1990 <with|font-shape|italic|Phys. Rev. A>
    <with|font-series|bold|41> 4265.

    <bibitem|frieden2>B R Frieden 1998 <with|font-shape|italic|Physics from
    Fisher information> (Cambrodge: Cambridge University Press); 2004
    <with|font-shape|italic|Science from Fisher information> (Cambridge:
    Cambridge University Press).

    <bibitem|frieden3>B R Frieden and B H Soffer 1995
    <with|font-shape|italic|Phys. Rev. E> <with|font-series|bold|5> 2274.

    <bibitem|pla7>B R Frieden, A Plastino, A R Plastino, B H Soffer 1999
    <with|font-shape|italic|Phys. Rev. E> <with|font-series|bold|60 >48.

    <bibitem|flego>S P Flego, B R Frieden, A Plastino, A R Plastino, B H
    Soffer 2003 <with|font-shape|italic|Phys. Rev. E>
    <with|font-series|bold|68> 016105.

    <bibitem|reginatto>M. Reginatto 1998 <with|font-shape|italic|Phys. Rev.
    E> <with|font-series|bold|58> 1775.

    <bibitem|KS09>Kapsa V and Skla L 2009 <with|font-shape|italic|J. Phys.
    A> <with|font-series|bold|42> 315202

    <bibitem|CPF07>S. Curilef, F. Pennini, A. Plastino, G.L. Ferri, J. Phys.
    A <with|font-series|bold|40> (2007) 5127

    <bibitem|L02>Luo S 2002 <with|font-shape|italic|J. Phys. A>
    <with|font-series|bold|35> 5181

    <bibitem|DGS07>Dehesa J S, Gonzlez-Frez R, Snchez-Moreno P 2007
    <with|font-shape|italic|J. Phys. A: Math. Theor.>
    <with|font-series|bold|40> 1845

    <bibitem|KSC10>V Kapsa, L Skala and J. Chen 2010
    <with|font-shape|italic|Physica E> <with|font-series|bold|42> 293.

    <bibitem|FS09>B R Frieden and B H Soffer 2009
    <with|font-shape|italic|Physica A> <with|font-series|bold|388> 1315.

    <bibitem|U09>M R Ubriaco 2009 <with|font-shape|italic|Phys. Lett. A>
    <with|font-series|bold|373> 4017.

    <bibitem|LADY08>S Lopez-Rosa, J C Angulo, J S Dehesa, R J Yanez 2998
    <with|font-shape|italic|Physica A> <with|font-series|bold|387> 2243.

    <bibitem|2011>S P Flego, F Olivares, A Plastino, M Casas 2011
    <with|font-shape|italic|Entropy> <with|font-series|bold|13> 184.

    <bibitem|SAA07>K D Sen, J. Antolin, J C Angulo 2007
    <with|font-shape|italic|Phys. Rev. A> <with|font-series|bold|76> 032502.

    <bibitem|N07>A Nagy 2007 <with|font-shape|italic|Chem. Phys. Lett.>
    <with|font-series|bold|449> 212.

    <bibitem|N06>A Nagy 2006 <with|font-shape|italic|Chem. Phys. Lett.>
    <with|font-series|bold|425> 154.

    <bibitem|rigid>S Curilef, F Pennini, A Plastino, G L Ferri 2008
    <with|font-shape|italic|J. Phys.: Conference Series>
    <with|font-series|bold|134> 012029.

    <bibitem|alp2>A Hernando, C Vesperinas, A Plastino 2010
    <with|font-shape|italic|Physica A> <with|font-series|bold|389> 490.

    <bibitem|alp3>A Hernando, C Vesperinas, A Plastino 2009
    <with|font-shape|italic|Phys. Lett. A> <with|font-series|bold|374> 18.

    <bibitem|alp4>F Pennini, G L Ferri, A Plastino 2009
    <with|font-shape|italic|Entropy> <with|font-series|bold|11> 972.

    (1998) 498.

    <bibitem|olivares>F Olivares, F Pennini, A Plastino 2010
    <with|font-shape|italic|Physica A> <with|font-series|bold|389> 2218.

    <bibitem|pla5>F Pennini, A Plastino, B H Soffer, C Vignat 2009
    <with|font-shape|italic|Phys. Lett. A> <with|font-series|bold|373> 817.

    <bibitem|flavia>F Pennini and A Plastino 2005
    <with|font-shape|italic|Phys. Rev. E> <with|font-series|bold|71> 047102.

    <bibitem|ppglobal>F. Pennini and A. Plastino 2007 Phys. Lett. A
    <with|font-series|bold|365> 263.

    <bibitem|katz>A Katz 1967 <with|font-shape|italic|Principles of
    Statistical Mechanics, The Information Theory Approach> (San Francisco:
    Freeman).

    <bibitem|richard>R P Feynman 1939 <with|font-shape|italic|Phys. Rev.>
    <with|font-series|bold|56> 340.

    <bibitem|deslog>Desloge E. A. 1968 <with|font-shape|italic|Thermal
    Physics> (New York: Holt, Rinehart and Winston, New York).

    <bibitem|virial>For any quantum system in stationary state, with a
    Hamiltonian does not involve time explicitly,
    <math|H=-<frac|\<hbar\><rsup|2>|2*m><nbsp><wide|\<nabla\>|\<vect\>><nbsp>+<nbsp>U<around|(|<wide|x|\<vect\>>|)>,<nbsp>>the
    virial theorem states that <cite|greiner>
    <math|<around*|\<langle\>|-<frac|\<hbar\><rsup|2>|m>*<wide|\<nabla\>|\<vect\>>|\<rangle\>>=<around*|\<langle\>|<wide|x|\<vect\>>.*<wide|\<nabla\>|\<vect\>>*U<around|(|<wide|x|\<vect\>>|)>|\<rangle\>>>,
    where the expectation value is taken for stationary states of the
    Hamiltonian.

    <bibitem|greiner>W. Geiner and B. Mller, <with|font-shape|italic|Quantum
    mechanics. An Introduction>(Springer, Berlin, 1988).

    <bibitem|nuestro2>S. P. Flego, A. Plastino, A. R. Plastino, Cond-mat-stat
    mech, ArXiv/0183006 (2011).

    <bibitem|cassels>J. M. Cassesl, <with|font-shape|italic|Basic quantum
    mechanics> (McGraw Hill, New York, 1970).
  </thebibliography>
</body>