<TeXmacs|1.99.4>

<style|llncs>

<\body>
  <doc-data|<doc-title|Mathematical Font Art>|<doc-author|<author-data|<author-name|Joris
  van der Hoeven>|<\author-affiliation>
    Laboratoire d'informatique, UMR 7161 CNRS

    Campus de l'cole polytechnique

    1, rue Honor d'Estienne d'Orves

    Btiment Alan Turing, CS35003

    91120 Palaiseau
  </author-affiliation>>>|<doc-date|<date>>>

  <abstract-data|<\abstract>
    Currently, only a limited number of fonts are available for high quality
    mathematical typesetting, such as Knuth's computer modern font, the
    <name|Stix> font, and several fonts from the <TeX> <name|Gyre> family. An
    interesting challenge is to develop tools which allow users to pick any
    existing favorite font and to use it for writing mathematical texts. We
    will present progress on this problem as part of recent developments in
    the GNU <TeXmacs> scientific text editor.
  </abstract>>

  <section|Introduction>

  For a long period, most documents with mathematical formulas were typeset
  using Knuth's <name|Computer Modern> font<nbsp><cite|Kn86b>. Recently, a
  few alternative fonts were designed, such as the <name|Stix>
  font<nbsp><cite|STIX> and the <TeX> <name|Gyre> fonts<nbsp><cite|TeXGyre>.
  These handcrafted fonts all admit a high quality, but they required an
  important development effort. Now there exists thousands of fonts for non
  mathematical purposes. To what extent is it possible to use such fonts for
  mathematical texts or presentations, or on the web?

  In this paper we describe recent developments inside the GNU <TeXmacs>
  scientific text editor<nbsp><cite|vdH:icms14> which aim at a better support
  of general purpose fonts, thereby making life a bit more colorful. The
  focus is on fully automatic techniques for using existing fonts inside
  structured documents with mathematical formulas. Further fine tuning for
  specific characters in particular fonts is another interesting topic which
  will not be discussed here.

  There are obvious limitations of what we can do with a font if bold and
  italic declinations or glyphs for various important characters are missing.
  Nevertheless we will see that quite a lot is often possible even though the
  resulting quality may be inferior to what can be achieved <em|via> manual
  design. Since various special characters or font effects are often only
  used at a reduced number of places inside actual documents, the occasional
  loss of quality may remain within acceptable bounds, even for professional
  purposes.

  Our general strategy for turning existing fonts into full fledged
  mathematical font families is to remedy each of the font's insufficiencies.
  The most common problems are the following:

  <\itemize>
    <item>Lack of the most important font declinations as needed in
    scientific documents: <strong|Bold>, <em|Italic>, <name|Small Capitals>,
    <samp|Sans Serif>, <verbatim|Typewriter>.

    <item>Lack of specific glyphs: non English languages, mathematical
    symbols, and in particular big operators, extensible brackets and wide
    accents.

    <item>Inconsistencies: sloppy design of some glyphs that are important
    for mathematics (such as <math|->, <math|\<less\>>, <abbr|etc.>), leading
    to inconsistencies.
  </itemize>

  The main countermeasures are <em|font substitution> and <em|font
  emulation>. The first technique (see Section<nbsp><reference|font-subst-sec>)
  consists of borrowing missing glyphs from other fonts. This can either be
  done on the level of an entire font (<abbr|e.g.> for obtaining bold or
  italic declinations) or for individual characters (<abbr|e.g.> a
  missing<nbsp><math|\<propto\>> symbol, or lacking Greek characters). Font
  emulation consists of combining and altering the glyphs of symbols in a
  font in order to generate new ones. This can again be done for entire fonts
  (Section<nbsp><reference|poor-man-sec>) or individual
  glyphs<nbsp>(Sections<nbsp><reference|virt-sec>
  and<nbsp><reference|rubber-sec>).

  All techniques described in this paper have been implemented in <TeXmacs>,
  version<nbsp>1.99.5 and beyond. The software can freely be downloaded from
  our website <slink|www.texmacs.org>. The virtual character definitions
  described in Section<nbsp><reference|virt-sec> below can be found in the
  <verbatim|TeXmacs/fonts/virtual> directory; interested users may play with
  these definitions. Longer examples of what can be obtained using the
  techniques described in this paper are available here:

  <\padded>
    <\indent>
      <slink|http://www.texmacs.org/joris/fontart/fontart-abs.html>
    </indent>
  </padded>

  In the <TeX>/<LaTeX> universe, there have also been several efforts towards
  better support for modern <name|OpenType> fonts, most notably
  <name|Xe><TeX><nbsp><cite|XeTeX> and <name|Lua><TeX><nbsp><cite|LuaTeX>.
  The first system also contains features that are similar to those described
  in Section<nbsp><reference|poor-man-sec>. However, these systems do not
  support full mathematical font emulation as presented in this paper.
  <name|Xe><TeX> and <name|Lua><TeX> also tend to diverge from standard
  <LaTeX> through the introduction of incompatibilities.

  <section|Font analysis and font substitution><label|font-subst-sec>

  In order to borrow missing characters from other fonts, it is important to
  be able to determine fonts with a similar design, so that the alien glyphs
  fit nicely into the main text:

  <\padded>
    <\with|par-first|0tab>
      <\indent>
        <with|font|Justus|The symbols <math|\<#3B1\>>, <math|\<beta\>>,
        <math|\<gamma\>> are acceptable inside
        <math|x+\<alpha\>+y+\<beta\>+z+\<gamma\>>>.<htab|5mm>(<next-equation><the-equation>)<label|ok-mix>

        <with|font|Papyrus|The symbols <math|<with|font|Marker
        Felt|\<alpha\>>,<with|font|Marker Felt|\<beta\>>,<with|font|Marker
        Felt|\<gamma\>>> do not look very well inside
        <math|x+<with|font|Marker Felt|\<alpha\>>+y+<with|font|Marker
        Felt|\<beta\>>+z+<with|font|Marker
        Felt|\<gamma\>>>.><htab|5mm>(<next-equation><the-equation>)<label|not-ok-mix>
      </indent>
    </with>
  </padded>

  Usually, rules for font substitution are specified manually for each
  individual font. Although this often yields the most precise and
  predictable results, it can be tedious to write such rules. For this
  reason, we also implemented a more automatic mechanism in order to
  determine good substitutes.

  A prerequisite for our algorithm for automatic font substitutions is a
  detailed analysis of the main characteristics of all supported fonts. The
  results of this analysis are stored in a database. Using this database, we
  may then compute the<nbsp>distance between two fonts. In the case when a
  symbol <math|\<sigma\>> is missing in a<nbsp>font<nbsp><math|F<rsub|1>>, it
  then suffices to find the closest font <math|F<rsub|2>> that supports this
  symbol<nbsp><math|\<sigma\>>. Notice that the best substitution font may
  depend on the fonts which are installed on your system.

  In our database we both use discrete font characteristics (<abbr|e.g.> sans
  serif, small capitals, handwritten, ancient, gothic, <abbr|etc.>) and
  continuous ones (<abbr|e.g.> italic slant, height of an \Px\Q symbol,
  <abbr|etc.>). Most characteristics are determined automatically by
  analyzing the name of the font (for some of the discrete characteristics)
  or individual glyphs (for the continuous ones). Some \Pfont categories\Q
  (such as handwritten, gothic, <abbr|etc.>) can be specified manually.

  One of the most important font characteristics is the height of the \Px\Q
  symbol (with respect to the design size). When the font <math|F<rsub|1>>
  borrows a symbol from the font <math|F<rsub|2>> we first scale it by the
  quotient of these x-heights inside <math|F<rsub|1>>
  and<nbsp><math|F<rsub|2>>. In the example<nbsp>(<reference|ok-mix>) this
  was done correctly, contrary to<nbsp>(<reference|not-ok-mix>).

  Other common font characteristics are also taken into account into our
  database, such as the italic slant, the width of the \PM\Q symbol, the
  ascent and descent (above and above the<nbsp>\Px\Q symbol), etc. In
  addition, we carefully analyze the glyphs themselves in order to determine
  the horizontal and vertical stroke widths for the \Po\Q and \PO\Q symbols,
  the average aspect-ratios of uppercase and lowercase letters, and the
  average area of glyphs that is filled (how much ink will be used).

  Our current implementation manages to find reasonably good font
  substitutions. Notice that this may even be a problem on certain occasions.
  For instance, in the example<nbsp>(<reference|overly-good>) below, the sans
  serif font is such a good match that it can barely be distinguished from
  the serif font, thereby defeating its purpose:

  <\padded>
    <\with|par-first|0tab>
      <\indent>
        <with|font|TeX Gyre Pagella|This <samp|sample> text is a bit too
        good.><htab|5mm>(<next-equation><the-equation>)<label|overly-good>
      </indent>
    </with>
  </padded>

  <section|Poor man's font emulation><label|poor-man-sec>

  Various font alterations such as <strong|Bold>, <em|Italic> and <name|Small
  Capitals> can be emulated in rather obvious ways, although with significant
  loss of quality:

  <\itemize>
    <item>Emboldening can be achieved through the replacement of pixels by
    small lines. In addition, it may be worth it to horizontally stretch
    certain characters such as \Pm\Q. The appropriate stretching factors are
    highly font and character dependent, but using the factors corresponding
    to the computer modern font usually leads to reasonable results.

    <item>Italic fonts can be approximated by slanted fonts, which may be
    further narrowed for a better result. The most important drawback of this
    method is that it often falls short of producing the correct italic
    versions of certain characters (a/<with|font-shape|slanted|a>/<em|a>,
    f/<with|font-shape|slanted|f>/<em|f>,
    g/<with|font-shape|slanted|g>/<em|g>, <abbr|etc.>).

    <item>Small capitals can be emulated by rescaling capitals using a factor
    that roughly turns an \PX\Q into an \Px\Q. Instead of conserving the
    aspect-ratio, we found it more pleasing to slightly widen characters as
    well. The transformed version of \PX\Q may also be taken slightly higher
    than \Px\Q.
  </itemize>

  With more work, the above \Ppoor man's\Q strategies might be further
  enhanced. For instance, the italic <em|a> might be better approximated
  using a shortened version of <with|font-shape|slanted|d> instead of
  <with|font-shape|slanted|a>. In order to improve bold font emulation, we
  might also replace pixels by small lines of cleverly adjusted lengths.

  More elaborate emulation strategies might greatly benefit from a toolkit
  for \Pretro-engineering\Q the design of existing fonts. For instance, given
  an outline, we might want to determine the curve(s) followed by a \Ppen\Q
  and the size (or shape) of the pen at each point of the curve. This would
  then make it easy to produce high quality narrowed and widened versions of
  a font, as well as better emboldened fonts, or variants in which the pen's
  size is uniform (as needed for sans serif and typewriter fonts). Another
  interesting question is whether it is possible to automatically detect
  serifs and to add or remove them.

  We have started to experiment with more elaborate emulation algorithms for
  the generation of \Pblackboard bold\Q variants of glyphs. The easiest
  strategy is to produce an outlined version of the possibly emboldened input
  glyph. The standard AMS blackboard bold font uses this method
  (<math|<with|font|Bbb|C>>, <math|<with|font|Bbb|N>>,
  <math|<with|font|Bbb|Q>>, <math|<with|font|Bbb|R>>,
  <math|<with|font|Bbb|Z>>), but we consider the result suboptimal with
  respect to adding a single stroke (<math|\<bbb-C\>>, <math|\<bbb-N\>>,
  <math|\<bbb-Q\>>, <math|\<bbb-R\>>, <math|\<bbb-Z\>>). We implemented an
  algorithm for the detection of the part of contour to be \Pdouble
  stroked\Q. We next embolden this part and hollow it out.

  <\big-figure|<tabular|<tformat|<cwith|9|9|1|-1|font|Papyrus>|<cwith|8|8|1|-1|font|Comic
  MS>|<cwith|1|-1|1|-1|cell-bsep|0.5spc>|<cwith|1|-1|1|-1|cell-tsep|0.5spc>|<cwith|2|2|1|-1|font|Cochin>|<cwith|1|1|1|-1|cell-tborder|0ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-tborder|1ln>|<cwith|1|1|6|6|cell-rborder|0ln>|<cwith|1|1|1|1|cell-tborder|0ln>|<cwith|9|9|1|1|cell-bborder|0ln>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-lborder|1ln>|<cwith|7|7|1|-1|font|Chalkduster>|<cwith|7|7|1|-1|font-base-size|8>|<cwith|5|5|1|-1|font|Essays1743>|<cwith|6|6|1|-1|font|Meyne
  Textur>|<cwith|4|4|1|6|cell-bsep|0.5spc>|<cwith|4|4|1|6|cell-tsep|0.5spc>|<cwith|4|4|1|1|cell-lborder|0ln>|<cwith|4|4|1|1|cell-rborder|1ln>|<cwith|4|4|2|2|cell-lborder|1ln>|<cwith|4|4|1|6|font|Chartrand>|<cwith|3|3|1|6|cell-bsep|0.5spc>|<cwith|3|3|1|6|cell-tsep|0.5spc>|<cwith|3|3|1|6|font|Cochin>|<cwith|3|3|1|1|cell-rborder|1ln>|<cwith|3|3|2|2|cell-lborder|1ln>|<cwith|2|2|1|6|cell-bsep|0.5spc>|<cwith|2|2|1|6|cell-tsep|0.5spc>|<cwith|2|2|1|1|cell-lborder|0ln>|<cwith|2|2|1|1|cell-rborder|1ln>|<cwith|2|2|2|2|cell-lborder|1ln>|<cwith|2|2|1|6|font|Optima>|<cwith|3|3|1|-1|cell-tborder|0ln>|<cwith|2|2|1|-1|cell-bborder|0ln>|<cwith|3|3|1|-1|cell-bborder|0ln>|<cwith|3|3|1|1|cell-lborder|0ln>|<cwith|3|3|6|6|cell-rborder|0ln>|<table|<row|<cell|Regular>|<cell|Bold>|<cell|Italic>|<cell|Small
  Caps>|<cell|Blackboard Bold>|<cell|Mathematics>>|<row|<cell|Optima>|<cell|<strong|Bold><rsup|*>>|<cell|<em|Italic>>|<cell|<name|Small
  Caps>>|<cell|<math|\<bbb-C\>>, <math|\<bbb-N\>>, <math|\<bbb-Q\>>,
  <math|\<bbb-R\>>, <math|\<bbb-Z\>>>|<cell|<math|x<rsup|2>+f<around*|(|x,<frac|a|b+c>|)>>>>|<row|<cell|Cochin>|<cell|<strong|Bold><rsup|<with|font|roman|*>>>|<cell|<em|Italic><rsup|<with|font|roman|*>>>|<cell|<name|Small
  Caps>>|<cell|<math|\<bbb-C\>>, <math|\<bbb-N\>>, <math|\<bbb-Q\>>,
  <math|\<bbb-R\>>, <math|\<bbb-Z\>>>|<cell|<math|x<rsup|2>+f<around*|(|x,<frac|a|b+c>|)>>>>|<row|<cell|Chartrand>|<cell|<strong|Bold>>|<cell|<em|Italic>>|<cell|<name|Small
  Caps>>|<cell|<math|\<bbb-C\>>, <math|\<bbb-N\>>, <math|\<bbb-Q\>>,
  <math|\<bbb-R\>>, <math|\<bbb-Z\>>>|<cell|<math|x<rsup|2>+f<around*|(|x,<frac|a|b+c>|)>>>>|<row|<cell|Essays1743>|<cell|<strong|Bold><rsup|*>>|<cell|<em|Italic><rsup|*>>|<cell|<name|Small
  Caps>>|<cell|<math|\<bbb-C\>>,<space|-0.4spc>
  <math|\<bbb-N\>>,<space|-0.4spc> <math|\<bbb-Q\>>,<space|-0.4spc>
  <math|\<bbb-R\>>,<space|-0.4spc> <math|\<bbb-Z\>><rsup|*>>|<cell|<math|x<rsup|2>+f<around*|(|x,<frac|a|b+c>|)>>>>|<row|<cell|Meyne
  Textur>|<cell|<strong|Bold>>|<cell|<em|Italic>>|<cell|<with|font-shape|small-caps|Small
  Caps>>|<cell|<math|\<bbb-C\>>, <math|\<bbb-N\>>, <math|\<bbb-Q\>>,
  <math|\<bbb-R\>>, <math|\<bbb-Z\>>>|<cell|<math|x<rsup|2>+f<around*|(|x,<frac|a|b+c>|)>>>>|<row|<cell|Chalkduster>|<cell|<strong|Bold>>|<cell|<em|Italic>>|<cell|<name|Small
  Caps>>|<cell|<math|\<bbb-C\>>, <math|\<bbb-N\>>, <math|\<bbb-Q\>>,
  <math|\<bbb-R\>>, <math|\<bbb-Z\>>>|<cell|<math|x<rsup|2>+f<around*|(|x,<frac|a|b+c>|)>>>>|<row|<cell|Comic
  Sans>|<cell|<strong|Bold>>|<cell|<em|Italic>>|<cell|<name|Small
  Caps>>|<cell|<math|\<bbb-C\>>, <math|\<bbb-N\>>, <math|\<bbb-Q\>>,
  <math|\<bbb-R\>>, <math|\<bbb-Z\>>>|<cell|<math|x<rsup|2>+f<around*|(|x,<frac|a|b+c>|)>>>>|<row|<cell|Papyrus>|<cell|<strong|Bold>>|<cell|<em|Italic>>|<cell|<name|Small
  Caps>>|<cell|<math|\<bbb-C\>>, <math|\<bbb-N\>>, <math|\<bbb-Q\>>,
  <math|\<bbb-R\>>, <math|\<bbb-Z\>>>|<cell|<math|x<rsup|2>+f<around*|(|x,<frac|a|b+c>|)>>>>>>>>
    Emulation of bold, italic, small capitals and blackboard bold.

    <no-indent>* These declinations are already supported by the original
    font.
  </big-figure>

  <section|Virtual characters><label|virt-sec>

  Missing glyphs can be generated automatically from existing ones using a
  combination of the following main techniques, listed by increasing
  complexity:

  <\itemize>
    <item>Superposition of several glyphs: <math|+> and <math|-> can be
    combined into <math|\<pm\>>, and<nbsp><math|\<ll\>> be obtained by
    juxtaposing two <math|\<less\>> symbols.

    <item>Clipping rectangular areas: cutting <math|\<mapsto\>> and
    <math|\<twoheadrightarrow\>> in their midsts and combining them yields
    <math|\<twoheadmapsto\>>.

    <item>Linear transformations: combining a crushed O and an I, we may
    produce the Greek capital \<Phi*\>. Turning around <math|\<rightarrow\>>,
    we obtain <math|\<uparrow\>>.

    <item>Simple graphical constructs such as circles and lines. This can for
    instance be used for producing the missing half circle of
    <math|\<subset\>>.

    <item>Special <em|ad hoc> transformations that directly operate on the
    pixels of a<nbsp>glyph (or on their outlines if possible). For instance,
    we designed a<nbsp>special \Pcurlyfication\Q method that turns
    <math|\<less\>> into <math|\<prec*\>> and
    <move|<large|<math|<with|font|Papyrus|\<less\>>>>||-0.2ex> into
    <move|<large|<math|<with|font|Papyrus|\<prec*\>>>>||-0.2ex>. Similarly,
    we implemented a \Pflood fill\Q algorithm for transforming
    <math|\<vartriangleleft\>> into <math|\<blacktriangleleft\>>.
  </itemize>

  In a similar vein, we need various querying mechanisms: all glyphs come
  with logical and physical bounding boxes, but we sometimes may want to
  compute the exact width of some stroke or obtain other kinds of
  information.

  We developed a small language that can be used for defining new \Pvirtual\Q
  characters in terms of existing ones. The design of every new virtual glyph
  can be regarded as a puzzle: finding a clever way to combine existing
  glyphs into the desired one using the primitives from the language. Of
  course, we are looking for robust solutions in the sense that they should
  work for <em|any> reasonable font in which the required basic glyphs are
  available.

  Let us consider a few examples. For the construction of arrows, it turns
  out that the single <em|guillemets> \N and \O are often well suited for the
  heads (the rescaled symbols<nbsp>\<less\> and \<gtr\> are acceptable
  fallbacks). The arrow bars are obtained from the minus sign <math|->, but
  the determination of an appropriate minus is non trivial. For instance, the
  width of the dash - is usually too large, so we should avoid using this
  symbol. The underscore is a better candidate; one may also cut the plus
  sign into several pieces (avoiding the vertical stroke) and recombine them.

  Assuming that we have an appropriate arrow bar and head, we may use the
  following code for producing an actual arrow:

  <\flat-size>
    <\scm-code>
      (rightarrow (right-fit arrowbar (align righthead arrowbar * 0.5)))
    </scm-code>
  </flat-size>

  The <scm|align> primitive is used to vertically align the arrow head at the
  center of the arrow bar. The <verbatim|right-fit> primitive is less basic
  and corresponds to sliding the arrowhead from the right to the left until
  the arrow bar goes past the head on its right. More direct ways to produce
  arrows turn out to be less robust. Left and left-right arrows can be
  defined using

  <\flat-size>
    <\scm-code>
      (leftarrow (left-flip rightarrow))

      (leftrightarrow (join (part leftarrow * 0.5) (part rightarrow 0.5 *)))
    </scm-code>
  </flat-size>

  These definitions potentially take advantage of an existing
  <verbatim|rightarrow> in the base font. The <verbatim|part> primitive
  performs two horizontal clippings between the middle and the extremities,
  whereas <verbatim|join> is used for superposition.

  An interesting challenge is the emulation of Greek characters. This seems
  intractable for the lowercase symbols, but is less hopeless for the
  capitals. For instance, \<Gamma*\> can be obtained by flipping the Roman L
  upside down and we already mentioned how to obtain a reasonable \<Phi*\>.
  More interesting is the case of \<Pi*\>, which can be obtained from H by
  moving the horizontal bar to the top. However, extracting this bar is not
  so easy in some fonts: consider <with|font|Chalkduster|H>. For a robust
  method, we therefore cut the H into pieces: we first extract \<H1\> \<H2\>
  \<H4\> and recombine them into \<H5\>. We next take a tiny piece of the
  central bar, extend it to the desired length, and move it to the top.

  <\big-figure|<tabular|<tformat|<cwith|10|10|1|-1|font|Papyrus>|<cwith|1|-1|1|-1|cell-bsep|0.5spc>|<cwith|1|-1|1|-1|cell-tsep|0.5spc>|<cwith|1|1|1|-1|cell-tborder|0ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-tborder|1ln>|<cwith|1|1|1|1|cell-tborder|0ln>|<cwith|10|10|1|1|cell-bborder|0ln>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-lborder|1ln>|<cwith|9|9|1|-1|font|Chalkduster>|<cwith|6|6|1|-1|font|Essays1743>|<cwith|4|4|1|12|cell-bsep|0.5spc>|<cwith|4|4|1|12|cell-tsep|0.5spc>|<cwith|4|4|1|1|cell-lborder|0ln>|<cwith|4|4|1|1|cell-rborder|1ln>|<cwith|3|3|1|12|cell-bsep|0.5spc>|<cwith|3|3|1|12|cell-tsep|0.5spc>|<cwith|3|3|1|1|cell-rborder|1ln>|<cwith|2|2|1|12|cell-bsep|0.5spc>|<cwith|2|2|1|12|cell-tsep|0.5spc>|<cwith|2|2|1|1|cell-lborder|0ln>|<cwith|2|2|1|1|cell-rborder|1ln>|<cwith|3|3|1|-1|cell-tborder|0ln>|<cwith|2|2|1|-1|cell-bborder|0ln>|<cwith|3|3|1|-1|cell-bborder|0ln>|<cwith|3|3|1|1|cell-lborder|0ln>|<cwith|7|7|2|12|cell-bsep|0.5spc>|<cwith|7|7|2|12|cell-tsep|0.5spc>|<cwith|7|7|2|2|cell-lborder|1ln>|<cwith|7|7|2|12|cell-bsep|0.5spc>|<cwith|7|7|2|12|cell-tsep|0.5spc>|<cwith|7|7|1|-1|font|American
  Typewriter>|<cwith|9|9|1|-1|font-base-size|9>|<cwith|1|-1|2|-1|cell-halign|c>|<cwith|8|8|1|20|cell-bsep|0.5spc>|<cwith|8|8|1|20|cell-tsep|0.5spc>|<cwith|8|8|1|1|cell-lborder|0ln>|<cwith|8|8|1|1|cell-rborder|1ln>|<cwith|8|8|2|2|cell-lborder|1ln>|<cwith|8|8|2|20|cell-halign|c>|<cwith|1|-1|2|-1|cell-lsep|0.5spc>|<cwith|1|-1|2|-1|cell-rsep|0.5spc>|<cwith|3|3|1|-1|font|Cochin>|<cwith|2|2|1|-1|font|Optima>|<cwith|8|8|1|-1|font|Chalkboard>|<cwith|4|4|1|-1|font|Didot>|<cwith|5|5|1|22|cell-bsep|0.5spc>|<cwith|5|5|1|22|cell-tsep|0.5spc>|<cwith|5|5|1|1|cell-lborder|0ln>|<cwith|5|5|1|1|cell-rborder|1ln>|<cwith|5|5|2|2|cell-lborder|1ln>|<cwith|5|5|1|12|cell-bsep|0.5spc>|<cwith|5|5|1|12|cell-tsep|0.5spc>|<cwith|5|5|1|1|cell-lborder|0ln>|<cwith|5|5|1|1|cell-rborder|1ln>|<cwith|5|5|2|22|cell-halign|c>|<cwith|5|5|2|22|cell-lsep|0.5spc>|<cwith|5|5|2|22|cell-rsep|0.5spc>|<cwith|5|5|1|-1|font|Cuprum>|<cwith|11|11|1|22|cell-bsep|0.5spc>|<cwith|11|11|1|22|cell-tsep|0.5spc>|<cwith|11|11|1|1|cell-bborder|0ln>|<cwith|11|11|1|1|cell-lborder|0ln>|<cwith|11|11|1|1|cell-rborder|1ln>|<cwith|11|11|2|2|cell-lborder|1ln>|<cwith|11|11|2|22|cell-halign|c>|<cwith|11|11|2|22|cell-lsep|0.5spc>|<cwith|11|11|2|22|cell-rsep|0.5spc>|<cwith|11|11|1|-1|font|Paper
  Cuts 2>|<table|<row|<cell|>|<cell|\<Gamma\>>|<cell|\<Delta\>>|<cell|\<Theta\>>|<cell|\<Lambda\>>|<cell|\<Xi\>>|<cell|\<Pi\>>|<cell|\<Sigma\>>|<cell|\<Upsilon\>>|<cell|\<Phi\>>|<cell|\<Psi\>>|<cell|\<Omega\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|\<asympasymp\>>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|><math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|Optima>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|\<asympasymp\>>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|Cochin>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|\<asympasymp\>>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|Didot>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|\<asympasymp\>>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|Cuprum>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|Essays1743>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|\<asympasymp\>>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|<small|Am.
  Typewr.>>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|\<asympasymp\>>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|Chalkboard>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|\<asympasymp\>>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|Chalkduster>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|\<asympasymp\>>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|Papyrus>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|<math|\<asympasymp\>>>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>|<row|<cell|Paper
  Cuts>|<cell|\<Gamma*\>>|<cell|\<Delta*\>>|<cell|\<Theta*\>>|<cell|\<Lambda*\>>|<cell|\<Xi*\>>|<cell|\<Pi*\>>|<cell|\<Sigma*\>>|<cell|\<Upsilon*\>>|<cell|\<Phi*\>>|<cell|\<Psi*\>>|<cell|\<Omega*\>>|<cell|<math|\<mp\>>>|<cell|<math|\<assign\>>>|<cell|<math|\<approxeq\>>>|<cell|>|<cell|<math|\<nVdash\>>>|<cell|<math|\<rightarrow\>>>|<cell|<math|\<leftrightharpoons\>>>|<cell|<math|\<lneq\>>>|<cell|<math|\<varsqsubsetneq\>>>|<cell|<math|\<blacktrianglerighteqslant\>>>>>>>>
    Emulation of various mathematical symbols in various fonts.
  </big-figure>

  <section|Rubber characters><label|rubber-sec>

  One specific problem with mathematical fonts is the need for rubber
  characters. There are essentially four types of them: big operators
  (<math|<op|<big|sum>>>, <math|<op|<big|prod>>>, <math|<op|<big|otimes>>>),
  large delimiters <math|<around|(|<around|<left|(|1>|<around|<left|(|2>||<right|)|2>>|<right|)|1>>|)>>
  <math|<around|{|<around|<left|{|1>|<around|<left|{|2>||<right|}|2>>|<right|}|1>>|}>>,
  wide accents (<math|<wide||^>,<wide|<space|1.1em>|^>>,
  <math|<wide|<space|1.8em>|^>>), and long arrows
  (<math|<long-arrow|\<rubber-rightarrow\>|<space|2.7em>>>,
  <math|<long-arrow|\<rubber-leftrightharpoons\>|<space|2.8em>>>).

  We produce these rubber characters using essentially the same techniques as
  in the previous section. Especially horizontal and vertical scaling are
  very useful, as well as cutting symbols into several parts and reassembling
  them appropriately.

  For instance, moderately large versions of the bracket ( are obtained
  through magnification, typically with a higher stretch factor in the
  vertical direction. For larger sizes, this method produces results that are
  unacceptably thick. In that case, we rather cut the bracket into a top, a
  bottom, and a tiny middle part. We next repeat the middle part as many
  times as necessary in order to obtain a bracket of the desired size.

  The use of scaling is a very delicate matter. For instance, in the case of
  square brackets [ (and their potential derivatives
  <math|<around*|\<lceil\>||\<nobracket\>>> and
  <math|<around*|\<lfloor\>||\<nobracket\>>>), the point where horizontally
  magnified versions get too fat is usually reached much earlier than for
  ordinary or curly brackets. In the case of wide accents, we typically need
  very large horizontal stretch factors, which yield unacceptable results.
  Magnified versions of <math|<op|<big|sum>>> and<nbsp><math|<op|<big|prod>>>
  typically look allright, but this is much less so for
  <math|<op|<big|otimes>>>.

  We are still in the process of fine tuning our implementation. For better
  results, one major challenge is to develop magnification methods with a
  finer control over the stroke widths. In particular, we need a reliable
  magnification method that preserves all relevant widths.

  <\big-figure>
    <math|<tabular*|<tformat|<cwith|2|2|1|-1|font|American
    Typewriter>|<cwith|3|3|1|-1|font|Didot>|<cwith|4|4|1|-1|font|Essays1743>|<cwith|5|5|1|-1|font|Optima>|<cwith|6|6|1|-1|font|Chalkboard>|<cwith|7|7|1|-1|font|Chalkduster>|<cwith|8|8|1|-1|font|Papyrus>|<table|<row|<cell|\<rubber-Leftarrow-20\>>|<cell|\<rubber-leftrightharpoons-20\>>|<cell|\<rubber-mapsto-20\>>>|<row|<cell|\<rubber-Leftarrow-20\>>|<cell|\<rubber-leftrightharpoons-20\>>|<cell|\<rubber-mapsto-20\>>>|<row|<cell|\<rubber-Leftarrow-20\>>|<cell|\<rubber-leftrightharpoons*-20\>>|<cell|\<rubber-mapsto*-20\>>>|<row|<cell|\<rubber-Leftarrow-20\>>|<cell|\<rubber-leftrightharpoons-20\>>|<cell|\<rubber-mapsto-20\>>>|<row|<cell|\<rubber-Leftarrow-20\>>|<cell|\<rubber-leftrightharpoons-20\>>|<cell|\<rubber-mapsto-20\>>>|<row|<cell|\<rubber-Leftarrow-20\>>|<cell|\<rubber-leftrightharpoons*-20\>>|<cell|\<rubber-mapsto*-20\>>>|<row|<cell|\<rubber-Leftarrow-20\>>|<cell|\<rubber-leftrightharpoons*-20\>>|<cell|\<rubber-mapsto*-20\>>>|<row|<cell|\<rubber-Leftarrow-20\>>|<cell|\<rubber-leftrightharpoons-20\>>|<cell|\<rubber-mapsto-20\>>>>>>><space|2em><tabular*|<tformat|<cwith|1|1|2|2|cell-halign|r>|<cwith|2|2|2|2|cell-halign|r>|<cwith|3|3|2|2|cell-halign|r>|<cwith|4|4|2|2|cell-halign|r>|<cwith|5|5|2|2|cell-halign|r>|<cwith|6|6|2|2|cell-halign|r>|<cwith|2|2|1|-1|font|American
    Typewriter>|<cwith|3|3|1|-1|font|Didot>|<cwith|4|4|1|-1|font|Chalkboard>|<cwith|5|5|1|-1|font|Chalkduster>|<cwith|6|6|1|-1|font|Papyrus>|<table|<row|<cell|<math|<op|<big|sum>>>>|<cell|<math|<with|math-display|true|<op|<big|sum>>>>>|<cell|<math|<with|math-display|true|<op|<big|prod>>>>>|<cell|<math|<op|<big|prod>>>>>|<row|<cell|<math|<op|<big|sum>>>>|<cell|<math|<with|math-display|true|<op|<big|sum>>>>>|<cell|<math|<with|math-display|true|<op|<big|prod>>>>>|<cell|<math|<op|<big|prod>>>>>|<row|<cell|<math|<op|<big|sum>>>>|<cell|<math|<with|math-display|true|<op|<big|sum>>>>>|<cell|<math|<with|math-display|true|<op|<big|prod>>>>>|<cell|<math|<op|<big|prod>>>>>|<row|<cell|<math|<op|<big|sum>>>>|<cell|<math|<with|math-display|true|<op|<big|sum>>>>>|<cell|<math|<with|math-display|true|<op|<big|prod>>>>>|<cell|<math|<op|<big|prod>>>>>|<row|<cell|<math|<op|<big|sum>>>>|<cell|<math|<with|math-display|true|<op|<big|sum>>>>>|<cell|<math|<with|math-display|true|<op|<big|prod>>>>>|<cell|<math|<op|<big|prod>>>>>|<row|<cell|<math|<op|<big|sum>>>>|<cell|<math|<with|math-display|true|<op|<big|sum>>>>>|<cell|<math|<with|math-display|true|<op|<big|prod>>>>>|<cell|<math|<op|<big|prod>>>>>>>><space|1em><math|<with|font|Chalkduster|<around*|\<lfloor\>|<tabular*|<tformat|<cwith|2|2|1|-1|font|American
    Typewriter>|<cwith|3|3|1|-1|font|Didot>|<cwith|4|4|1|-1|font|Essays1743>|<cwith|1|1|1|-1|font|Chalkboard>|<cwith|1|-1|1|-1|cell-lsep|0.25spc>|<cwith|1|-1|1|-1|cell-rsep|0.25spc>|<cwith|5|5|1|2|cell-lsep|0.25spc>|<cwith|5|5|1|2|cell-rsep|0.25spc>|<cwith|5|5|1|2|font|TriangleETcircle
    Shadowed>|<table|<row|<cell|<around|<left|(|3>|<around|<left|(|2>|<around|<left|(|1>|<around|(||)>|<right|)|1>>|<right|)|2>>|<right|)|3>>>|<cell|<around|<left|{|3>|<around|<left|{|2>|<around|<left|{|1>|<around|{||}>|<right|}|1>>|<right|}|2>>|<right|}|3>>>>|<row|<cell|<around|<left|(|3>|<around|<left|(|2>|<around|<left|(|1>|<around|(||)>|<right|)|1>>|<right|)|2>>|<right|)|3>>>|<cell|<around|<left|{|3>|<around|<left|{|2>|<around|<left|{|1>|<around|{||}>|<right|}|1>>|<right|}|2>>|<right|}|3>>>>|<row|<cell|<around|<left|(|3>|<around|<left|(|2>|<around|<left|(|1>|<around|(||)>|<right|)|1>>|<right|)|2>>|<right|)|3>>>|<cell|<around|<left|{|3>|<around|<left|{|2>|<around|<left|{|1>|<around|{||}>|<right|}|1>>|<right|}|2>>|<right|}|3>>>>|<row|<cell|<around|<left|(|3>|<around|<left|(|2>|<around|<left|(|1>|<around|(||)>|<right|)|1>>|<right|)|2>>|<right|)|3>>>|<cell|<around|<left|{|4>|<around|<left|{|3>|<around|<left|{|2>|<around|<left|{|1>||<right|}|1>>|<right|}|2>>|<right|}|3>>|<right|}|4>>>>|<row|<cell|<around|<left|(|3>|<around|<left|(|2>|<around|<left|(|1>|<around|(||)>|<right|)|1>>|<right|)|2>>|<right|)|3>>>|<cell|<around|<left|{|3>|<around|<left|{|2>|<around|<left|{|1>|<around|{||}>|<right|}|1>>|<right|}|2>>|<right|}|3>>>>>>>|\<rceil\>>>>

    \;
  </big-figure|Assorted rubber symbols from various fonts.>

  <section|Conclusion and perspectives>

  After a moderate development investment, we are now able to use a lot of
  existing fonts for mathematical typesetting. The quality of the obtained
  results ranges from \Pbetter than nothing\Q to \Pprofessional typesetting
  quality\Q. Our virtual font implementation can be regarded as a genuine
  \Pmetafont\Q. Paradoxically, and in comparison, Knuth's <name|Metafont>
  initiative<nbsp><cite|Kn86a> has essentially resulted in the creation of a
  single mathematical font of extremely high quality.

  One interesting question that occurred during our development of a virtual
  mathematical metafont concerns the \Pessence of a font\Q: which font
  features essentially contain all necessary information to reproduce the
  entire font, and how? For instance, most mathematical symbols can be
  reconstructed from a few basic glyphs:<nbsp><math|->, <math|=>,
  <math|\<sim\>>, <math|\<less\>>, <math|\<prec\>>, <math|\<subset\>>, \O (or
  <math|\<rightarrow\>>), <math|.>, <math|\<circ\>>, <math|^>, (, [ and {.
  Similarly, the Greek capitals can essentially be reconstructed from E, H,
  O, X and Z. So what is the real \Pfingerprint\Q of a font?

  The development of more and better glyph emulation tools might be valuable
  for font designers. On the one hand, such tools may be used to
  automatically generate lots of glyphs. On the other hand, they allow
  designers to compare their own handcrafted glyphs with automatically
  generated alternatives. This may help to spot errors or increase
  consciousness about the distinctive features of a personal design.

  For the moment, we developed all our font substitution and emulation tools
  inside <TeXmacs>. It might be worthwhile to conceive a separate library
  with even more systematic tools for font analysis, retro-engineering and
  glyph emulation. Such a library might come with command line tools for
  generating mathematically enriched fonts, emboldened or narrowed versions,
  etc. For the moment, several of our algorithms are also limitated to
  operating on bitmaps. In the future, it would be nice to systematically
  work with vector graphics only.

  One final issue concerns the purpose of alternative fonts. For instance,
  certain fonts such as <with|font|Chalkboard|Chalkboard>,
  <with|font|Chalkduster|Chalkduster>, <with|font|Essays1743|Essays1743>,
  <with|font|Yiggivoo Unicode 3D|Yiggivoo 3D> are mainly used in order to
  produce specific graphical effects: emulate text on a<nbsp>chalkboard or on
  a blackboard, imitating a degraded retro-font, or producing a<nbsp>3D
  sensation. It can be questioned whether these purposes are always best
  served through the use of a special font. For instance, handwriting might
  be imitated better by dynamically generating many different versions of the
  same letter. Better retro and 3D effects might be obtained by applying a
  suitable graphical filter to an entire portion of text. This might even
  more be true in the presence of fractions, square roots or geometric
  pictures.

  <\bibliography|bib|tm-plain|>
    <\bib-list|7>
      <bibitem*|1><label|bib-vdH:icms14>Massimiliano Gubinelli, Joris van
      der<nbsp>Hoeven, Franois Poulain<localize|, and >Denis Raux.<newblock>
      GNU TeXmacs: towards a scientific office suite.<newblock> <localize|In
      ><with|font-shape|italic|Mathematical Software - ICMS 2014 - 4th
      International Congress, Seoul, South Korea, August 5-9, 2014.
      Proceedings>, <localize|pages >562\U569. 2014.<newblock>

      <bibitem*|2><label|bib-LuaTeX>T.<nbsp>Hoekwater,
      H.<nbsp>Henkel<localize|, and >H.<nbsp>Hagen.<newblock>
      Luatex.<newblock> <slink|http://www.luatex.org/>, 2007.<newblock>

      <bibitem*|3><label|bib-TeXGyre>B.<nbsp>Jackowski,
      J.<nbsp>Nowacki<localize|, and >J.<nbsp>Ludwichowski.<newblock> The
      <TeX> Gyre collection of fonts.<newblock>
      <slink|http://www.gust.org.pl/projects/e-foundry/tex-gyre/>.<newblock>

      <bibitem*|4><label|bib-XeTeX>J.<nbsp>Kew.<newblock> Xetex.<newblock>
      <slink|http://tug.org/xetex/>, 2005.<newblock>

      <bibitem*|5><label|bib-Kn86b>Donald<nbsp>E.<nbsp>Knuth.<newblock>
      <with|font-shape|italic|Computer Modern Typefaces>,
      <localize|volume><nbsp>E<localize| of
      ><with|font-shape|italic|Computers and Typesetting>.<newblock>
      Addison-Wesley, 1986.<newblock>

      <bibitem*|6><label|bib-Kn86a>Donald<nbsp>E.<nbsp>Knuth.<newblock>
      <with|font-shape|italic|The METAFONTbook>,
      <localize|volume><nbsp>C<localize| of
      ><with|font-shape|italic|Computers and Typesetting>.<newblock>
      Addison-Wesley, 1986.<newblock>

      <bibitem*|7><label|bib-STIX>STI Pub companies.<newblock> STIX fonts
      project.<newblock> <slink|http://www.stixfonts.org/>, 2010.<newblock>
    </bib-list>
  </bibliography>
</body>

<initial|<\collection>
</collection>>

<\attachments>
  <\collection>
    <\associate|bib-bibliography>
      <\db-entry|+EpghD2oOtkhQhH|book|Kn86b>
        <db-field|newer|+EpghD2oOtkhQhF>

        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1461179880>
      <|db-entry>
        <db-field|author|Donald E. <name|Knuth>>

        <db-field|title|Computer Modern Typefaces>

        <db-field|publisher|Addison-Wesley>

        <db-field|year|1986>

        <db-field|volume|E>

        <db-field|series|Computers and Typesetting>
      </db-entry>

      <\db-entry|+EpghD2oOtkhQhI|misc|STIX>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1461180837>
      <|db-entry>
        <db-field|author|<name|STI Pub companies>>

        <db-field|title|STIX fonts project>

        <db-field|howpublished|<slink|http://www.stixfonts.org/>>

        <db-field|year|2010>
      </db-entry>

      <\db-entry|+EpghD2oOtkhQhJ|misc|TeXGyre>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1461180837>
      <|db-entry>
        <db-field|author|B. <name|Jackowski><name-sep>J.
        <name|Nowacki><name-sep>J. <name|Ludwichowski>>

        <db-field|title|The <TeX> Gyre collection of fonts>

        <db-field|howpublished|<slink|http://www.gust.org.pl/projects/e-foundry/tex-gyre/>>
      </db-entry>

      <\db-entry|+Y7Wf699OJGUOey|inproceedings|vdH:icms14>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1451240634>

        <db-field|newer|+dG1O0ihIeNj9ea>

        <db-field|newer|+WuEkwkWErJdSHW>
      <|db-entry>
        <db-field|author|Massimiliano <name|Gubinelli><name-sep>Joris
        <name-von|van der> <name|Hoeven><name-sep>Franois
        <name|Poulain><name-sep>Denis <name|Raux>>

        <db-field|title|GNU TeXmacs: towards a scientific office suite>

        <db-field|booktitle|Mathematical Software - ICMS 2014 - 4th
        International Congress, Seoul, South Korea, August 5-9, 2014.
        Proceedings>

        <db-field|pages|562\U569>

        <db-field|year|2014>
      </db-entry>

      <\db-entry|+Qn9bkiMchkrOh6|misc|XeTeX>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1461258437>
      <|db-entry>
        <db-field|author|J. <name|Kew>>

        <db-field|title|Xetex>

        <db-field|howpublished|<slink|http://tug.org/xetex/>>

        <db-field|year|2005>
      </db-entry>

      <\db-entry|+Qn9bkiMchkrOh5|misc|LuaTeX>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1461258437>
      <|db-entry>
        <db-field|author|T. <name|Hoekwater><name-sep>H.
        <name|Henkel><name-sep>H. <name|Hagen>>

        <db-field|title|Luatex>

        <db-field|howpublished|<slink|http://www.luatex.org/>>

        <db-field|year|2007>
      </db-entry>

      <\db-entry|+EpghD2oOtkhQhG|book|Kn86a>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1461179794>
      <|db-entry>
        <db-field|author|Donald E. <name|Knuth>>

        <db-field|title|The METAFONTbook>

        <db-field|publisher|Addison-Wesley>

        <db-field|year|1986>

        <db-field|volume|C>

        <db-field|series|Computers and Typesetting>
      </db-entry>
    </associate>
  </collection>
</attachments>

<\references>
  <\collection>
    <associate|auto-1|<tuple|1|1>>
    <associate|auto-10|<tuple|6|8>>
    <associate|auto-2|<tuple|2|2>>
    <associate|auto-3|<tuple|3|3>>
    <associate|auto-4|<tuple|1|4>>
    <associate|auto-5|<tuple|4|4>>
    <associate|auto-6|<tuple|2|6>>
    <associate|auto-7|<tuple|5|6>>
    <associate|auto-8|<tuple|3|7>>
    <associate|auto-9|<tuple|6|7>>
    <associate|bib-Kn86a|<tuple|6|8>>
    <associate|bib-Kn86b|<tuple|5|8>>
    <associate|bib-LuaTeX|<tuple|2|?>>
    <associate|bib-STIX|<tuple|7|8>>
    <associate|bib-TeXGyre|<tuple|3|8>>
    <associate|bib-XeTeX|<tuple|4|?>>
    <associate|bib-vdH:icms14|<tuple|1|8>>
    <associate|font-subst-sec|<tuple|2|2>>
    <associate|not-ok-mix|<tuple|2|2>>
    <associate|ok-mix|<tuple|1|2>>
    <associate|overly-good|<tuple|3|3>>
    <associate|poor-man-sec|<tuple|3|3>>
    <associate|rubber-sec|<tuple|5|6>>
    <associate|virt-sec|<tuple|4|4>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|bib>
      Kn86b

      STIX

      TeXGyre

      vdH:icms14

      XeTeX

      LuaTeX

      Kn86a
    </associate>
    <\associate|figure>
      <\tuple|normal>
        Emulation of bold, italic, small capitals and blackboard bold.

        <no-indent>* These declinations are already supported by the original
        font.
      </tuple|<pageref|auto-4>>

      <\tuple|normal>
        Emulation of various mathematical symbols in various fonts.
      </tuple|<pageref|auto-6>>

      <tuple|normal|Assorted rubber symbols from various
      fonts.|<pageref|auto-8>>
    </associate>
    <\associate|toc>
      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|1<space|2spc>Introduction>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-1><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|2<space|2spc>Font
      analysis and font substitution> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-2><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|3<space|2spc>Poor
      man's font emulation> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-3><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|4<space|2spc>Virtual
      characters> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-5><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|5<space|2spc>Rubber
      characters> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-7><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|6<space|2spc>Conclusion
      and perspectives> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-9><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|Bibliography>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-10><vspace|0.5fn>
    </associate>
  </collection>
</auxiliary>