<TeXmacs|1.0.6>

<style|elsart>

<\body>
  <doc-data|<doc-title|Around the numeric-symbolic computation<next-line>of
  differential Galois groups>|<doc-running-title|Around the numeric-symbolic
  computation of differential Galois groups>|<doc-author-data|<author-name|Joris
  van der Hoeven>|<\author-address>
    <abbr|Dpt.> de Mathmatiques (<abbr|bt.> 425)

    Universit Paris-Sud

    91405 Orsay Cedex

    France
  </author-address>|<author-email|vdhoeven@texmacs.org>>|<doc-date|<date>>>

  <\abstract>
    Let <with|mode|math|L\<in\>\<bbb-K\>(z)[\<partial\>]> be a linear
    differential operator, where <with|mode|math|\<bbb-K\>> is an effective
    algebraically closed subfield of<nbsp><with|mode|math|\<bbb-C\>>. It can
    be shown that the differential Galois group of <with|mode|math|L> is
    generated (as a closed algebraic group) by a finite number of monodromy
    matrices, Stokes matrices and matrices in local exponential groups.
    Moreover, there exist fast algorithms for the approximation of the
    entries of these matrices.

    In this paper, we present a numeric-symbolic algorithm for the
    computation of the closed algebraic subgroup generated by a finite number
    of invertible matrices. Using the above results, this yields an algorithm
    for the computation of differential Galois groups, when computing with a
    sufficient precision.

    Even though there is no straightforward way to find a ``sufficient
    precision'' for guaranteeing the correctness of the end-result, it is
    often possible to check <em|a posteriori> whether the end-result is
    correct. In particular, we present a non-heuristic algorithm for the
    factorization of linear differential operators.
  </abstract>

  <with|mode|math|<assign|Mat|<with|math-font-family|ms|Mat>><assign|bd|<with|math-font-series|bold|\<partial\>>><assign|Lie|<with|math-font-family|ms|Lie>><assign|GL|<with|math-font-family|ms|GL>><assign|Mono|<with|math-font-family|ms|Mono>><assign|Sto|<with|math-font-family|ms|Sto>><assign|Diag|<with|math-font-family|ms|Diag>><assign|Vect|<with|math-font-family|ms|Vect>><assign|Expo|<with|math-font-family|ms|Expo>><assign|Alg|<with|math-font-family|ms|Alg>><assign|Tor|<with|math-font-family|ms|Tor>><assign|Inv|<with|math-font-family|ms|Inv>>><section|Introduction>

  Let <with|mode|math|L\<in\>\<bbb-K\>(z)[\<partial\>]> be a monic linear
  differential operator of order <with|mode|math|n>, where
  <with|mode|math|\<bbb-K\>> is an effective algebraically closed subfield of
  <with|mode|math|\<bbb-C\>>. A holonomic function is a solution to the
  equation<nbsp><with|mode|math|L f=0>. The differential Galois group
  <with|mode|math|\<cal-G\>> of <with|mode|math|L> is a linear algebraic
  group which acts on the space <with|mode|math|H> of solutions (see section
  <reference|diff-Gal-sec> and <cite|Kap57|vdPS03|Kol73>). It carries a lot
  of information about the solutions in <with|mode|math|H> and on the
  relations between different solutions. For instance, the existence of
  non-trivial factorizations of <with|mode|math|L> and the existence of
  Liouvillian solutions can be read off from the Galois group. This makes it
  an interesting problem to explicitly compute the Galois group of
  <with|mode|math|L>.

  A classical approach in this area is to let <with|mode|math|\<cal-G\>> act
  on other vector spaces obtained from<nbsp><with|mode|math|H> by the
  constructions from linear algebra, such as symmetric powers
  <with|mode|math|<op|\<otimes\><rsup|k>H>> and exterior powers
  <with|mode|math|<op|\<wedge\><rsup|k>H>> <cite|Beke94|SU93>. For a suitable
  such space <with|mode|math|S>, the Galois group <with|mode|math|\<cal-G\>>
  consists precisely of those invertible <with|mode|math|n\<times\>n>
  matrices which leave a certain one-dimensional subspace of
  <with|mode|math|S> invariant <cite-detail|Hum81|chapter 11>. Invariants in
  <with|mode|math|<op|\<otimes\><rsup|k>H>> or
  <with|mode|math|<op|\<wedge\><rsup|k>H>> under <with|mode|math|\<cal-G\>>
  may be computed more efficiently by considering the local solutions of
  <with|mode|math|L f=0> at singularities <cite|vHW97|vH97b|vH:phd>. More
  recently, and assuming (for instance) that the coefficients of
  <with|mode|math|L> are actually in <with|mode|math|\<bbb-Q\>(z)>,
  alternative algorithms appeared which are based on the reduction of the
  equation <with|mode|math|L f=0> modulo a prime number <with|mode|math|p>
  <cite|Cl04|vdP95|vdPS03>.

  In this paper, we will study another type of ``analytic modular''
  algorithms, by studying the operator <with|mode|math|L> in greater detail
  near its singularities using the theory of
  accelero-summation<nbsp><cite|Ec85|Ec87|Ec92|Ec93|Br91|Br92>. More
  precisely, we will use the following facts:

  <\itemize>
    <item>The differential Galois group of <with|mode|math|L> is generated
    (as a closed algebraic group) by a finite number of monodromy matrices,
    Stokes matrices and matrices in so called local exponential groups (see
    <cite|Ram85b|MR91> and theorem<nbsp><reference|as-galois-th> below).

    <item>There exists an algorithm \ for the approximation of the entries of
    the above matrices (see <cite|vdH:hol|vdH:singhol|vdH:reshol> and
    theorem<nbsp><reference|eff-reshol> below). If
    <with|mode|math|\<bbb-K\>=\<bbb-Q\><rsup|alg>> is the algebraic closure
    of <with|mode|math|\<bbb-Q\>>, then <with|mode|math|d>-digit
    approximations can be computed in time<nbsp><with|mode|math|O(d*log<rsup|4>
    d*log log d)>.
  </itemize>

  When using these facts for the computation of differential Galois groups,
  the bulk of the computations is reduced to linear algebra in dimension
  <with|mode|math|n> with multiple precision coefficients.

  In comparison with previous methods, this approach is expected to be much
  faster than algorithms which rely on the use of exterior powers. A detailed
  comparison with arithmetic modular methods would be interesting. One
  advantage of arithmetic methods is that they are easier to implement in
  existing systems. On the other hand, our analytic approach relies on linear
  algebra in dimension <with|mode|math|n> (with floating coefficients),
  whereas modulo <with|mode|math|p> methods rely on linear algebra in
  dimension <with|mode|math|n*p> (with coefficients modulo
  <with|mode|math|p>), so the first approach might be a bit faster. Another
  advantage of the analytic approach is that it is more easily adapted to
  coefficients fields <with|mode|math|\<bbb-K\>> with transcendental
  constants.

  Let us outline the structure of this paper. In section
  <reference|prelim-sec>, we start by recalling some standard terminology and
  we shortly review the theorems on which our algorithms rely. We start with
  a survey of differential Galois theory, monodromy and local exponential
  groups. We next recall some basic definitions and theorems from the theory
  of accelero-summation and the link with Stokes matrices and differential
  Galois groups. We finally recall some theorems about the effective
  approximation of the transcendental numbers involved in the whole process.

  Before coming to the computation of differential Galois groups, we first
  consider the simpler problem of factoring <with|mode|math|L> in section
  <reference|factor-sec>. We recall that there exists a non-trivial
  factorization of <with|mode|math|L> if and only if the Galois group of
  <with|mode|math|L> admits a non-trivial invariant subspace. By using
  computations with limited precision, we show how to use this criterion in
  order to compute candidate factorizations or a proof that there exist no
  factorizations. It is easy to check <em|a posteriori> whether a candidate
  factorization is correct, so we obtain a factorization algorithm by
  increasing the precision until we obtain a correct candidate or a proof
  that there are no factorizations.

  In section <reference|galgr-sec> we consider the problem of computing the
  differential Galois group of <with|mode|math|L>. Using the results from
  section <reference|prelim-sec>, it suffices to show how to compute the
  algebraic closure of a matrix group <with|mode|math|\<cal-G\>> generated by
  a finite number of given elements. A theoretical solution for this problem
  based on Grbner basis techniques has been given in <cite|DJK03>. The main
  idea behind the present algorithm is similar, but more emphasis is put on
  efficiency (in contrast to generality).

  First of all, in our context of complex numbers with arbitrary precisions,
  we may use the LLL-algorithm for the computation of linear and
  multiplicative dependencies <cite|LLL82>. Secondly, the connected component
  of <with|mode|math|\<cal-G\>> is represented as the exponential of a Lie
  algebra <with|mode|math|\<cal-L\>> given by a basis. Computations with such
  Lie algebras essentially boil down to linear algebra. Finally, we use
  classical techniques for finite groups in order to represent and compute
  with the elements in <with|mode|math|\<cal-G\>/\<mathe\><rsup|\<cal-L\>>>
  <cite|Sims70|Sims71|MOB95>. Moreover, we will present an algorithm for
  non-commutative lattice reduction, similar to the LLL-algorithm, for the
  efficient computation with elements in <with|mode|math|\<cal-G\>/\<mathe\><rsup|\<cal-L\>>>
  near the identity.

  The algorithms in section <reference|galgr-sec> are all done using a fixed
  precision. Although we do prove that we really compute the Galois group
  when using a sufficiently large precision, it is not clear <em|a priori>
  how to find such a ``sufficient precision''. Nevertheless, we have already
  seen in section <reference|factor-sec> that it is often possible to check
  the correctness of the result <em|a<nbsp>posteriori>, especially when we
  are not interested in the Galois group <with|mode|math|\<cal-G\>> itself,
  but only in some information provided by <with|mode|math|\<cal-G\>>. Also,
  it might be possible to reduce the amount of dependence on ``transcendental
  arguments'' in the algorithm modulo a further development of our ideas.
  Some hints are given in the last section.

  <\remark>
    The author first suggested the main approach behind this paper during his
    visit at the MSRI in 1998. The outline of the algorithm in section
    <reference|galgr-alg-sec> came up in a discussion with Harm Derksen (see
    also <cite|DJK03>). The little interest manifested by specialists in
    effective differential Galois theory for this approach is probably due to
    the fact that current computer algebra systems have very poor support for
    analytic computations. We hope that the present article will convince
    people to put more effort in the implementation of such algorithms. We
    started such an effort <cite|vdH:mml>, but any help would be appreciated.
    Currently, none of the algorithms presented in this paper has been
    implemented.
  </remark>

  <section|Preliminaries><label|prelim-sec>

  In this section, we recall several classical results about differential
  Galois theory and its link with accelero-summation theory. We also recall
  previous work on the efficient evaluation of holonomic constants. The main
  result of this section is theorem<nbsp><reference|gal-gen-th>.

  <subsection|Notations>

  Throughout this paper, we will use the following notations:

  <\with|item-strong|<macro|name|<arg|name>>>
    <\description>
      <item*|<with|mode|math|\<bbb-K\>\<subseteq\>\<bbb-C\>>>An algebraically
      closed field of constants.

      <item*|<with|mode|math|<value|Mat><rsub|n>(\<bbb-K\>)>>The algebra of
      <with|mode|math|n\<times\>n> matrices with coefficients in
      <with|mode|math|\<bbb-K\>>.

      <item*|<with|mode|math|<value|GL><rsub|n>(\<bbb-K\>)>>The subgroup of
      <with|mode|math|<value|Mat><rsub|n>(\<bbb-K\>)> of invertible matrices.

      <item*|<with|mode|math|<value|Vect>(S)>>The vector space generated by a
      subset <with|mode|math|S> of a larger vector space.

      <item*|<with|mode|math|<value|Alg>(S)>>The algebra generated by a
      subset <with|mode|math|S> of a larger algebra.
    </description>
  </with>

  Vectors are typeset in bold face <with|mode|math|\<b-v\>=(v<rsub|1>,\<ldots\>,v<rsub|n>)>
  and we use the following vector notations:

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-v\>\<cdot\>\<b-w\>>|<cell|=>|<cell|v<rsub|1>*w<rsub|1>+\<cdots\>+v<rsub|n>*w<rsub|n>>>|<row|<cell|\<b-v\><rsup|\<b-k\>>>|<cell|=>|<cell|v<rsub|1><rsup|k<rsub|1>>*\<cdots\>*v<rsub|n><rsup|k<rsub|n>>>>>>
  </eqnarray*>

  Matrices <with|mode|math|M\<in\><value|Mat><rsub|n>(\<bbb-K\>)> will also
  be used as mappings <with|mode|math|M:\<bbb-K\><rsup|n>\<rightarrow\>\<bbb-K\><rsup|n>;\<b-v\>\<mapsto\>M*\<b-v\>>.
  When making a base change in <with|mode|math|\<bbb-K\><rsup|n>>, we
  understand that we perform the corresponding transformations
  <with|mode|math|M\<rightarrow\>P*M*P<rsup|\<um\>1>> on all matrices under
  consideration. We denote <with|mode|math|Diag(X<rsub|1>,\<ldots\>,X<rsub|p>)>
  for the diagonal matrix with entries <with|mode|math|X<rsub|1>,\<ldots\>,X<rsub|p>>.
  The <with|mode|math|X<rsub|i>> may either be scalars or square matrices.
  Given a matrix <with|mode|math|M\<in\><value|Mat><rsub|n>(\<bbb-K\>)> and a
  vector <with|mode|math|\<b-v\>\<in\>\<bbb-K\><rsup|n>>, we write
  <with|mode|math|\<b-v\><rsup|M>> for the vector <with|mode|math|\<b-w\>>
  with <with|mode|math|w<rsub|i>=v<rsub|1><rsup|M<rsub|i,1>>*\<cdots\>*v<rsub|n><rsup|M<rsub|i,n>>>
  for all <with|mode|math|i>.

  <subsection|Differential Galois groups><label|diff-Gal-sec>

  Consider a monic linear differential operator
  <with|mode|math|L=\<partial\><rsup|n>+L<rsub|n-1>*\<partial\>+\<cdots\>+L<rsub|0>\<in\>\<cal-F\>[\<partial\>]>,
  where <with|mode|math|\<bbb-K\>> is an algebraically closed subfield of
  <with|mode|math|\<bbb-C\>> and <with|mode|math|\<cal-F\>=\<bbb-K\>(z)>. We
  will denote by <with|mode|math|\<cal-S\>=\<cal-S\><rsub|L>\<subseteq\>\<bbb-K\>\<cup\><no-break>{\<infty\>}>
  the finite set of singularities of <with|mode|math|L> (in the case of
  <with|mode|math|\<infty\>>, one considers the transformation
  <with|mode|math|z\<mapsto\>z<rsup|\<um\>1>>). A <em|Picard-Vessiot
  extension> of <with|mode|math|\<cal-F\>> is a differential field
  <with|mode|math|\<cal-K\>\<supseteq\>\<cal-F\>> such that

  <\description>
    <item*|PV1><with|mode|math|\<cal-K\>=\<cal-F\>\<langle\>h<rsub|1>,\<ldots\>,h<rsub|n>\<rangle\>>
    is differentially generated by <with|mode|math|\<cal-F\>> and a basis of
    solutions <with|mode|math|\<b-h\>=(h<rsub|1>,\<ldots\>,h<rsub|n>)\<in\>\<cal-K\><rsup|n>>
    to the equation <with|mode|math|L f=0>.<no-page-break>

    <item*|PV2><with|mode|math|\<cal-K\>> has <with|mode|math|\<bbb-K\>> as
    its field of constants.
  </description>

  A Picard-Vessiot extension always exists: given a point
  <with|mode|math|z<rsub|0>\<in\>\<bbb-K\>\<setminus\>\<cal-S\>> and
  <with|mode|math|i\<in\>{1,\<ldots\>,n}>,
  let<nbsp><with|mode|math|h<rsub|i>> be the unique solution to
  <with|mode|math|L f=0> with <with|mode|math|h<rsub|i><rsup|(j)>(z<rsub|0>)=\<delta\><rsub|i,j+1>>
  for <with|mode|math|j\<in\>{0,\<ldots\>,n-1}>. We call
  <with|mode|math|\<b-h\>=\<b-h\><rsup|z<rsub|0>>=(h<rsub|1>,\<ldots\>,h<rsub|n>)>
  the <em|canonical basis> for the solution space of <with|mode|math|L f=0>
  at <with|mode|math|z<rsub|0>>, and regard<nbsp><with|mode|math|\<b-h\>> as
  a column vector. Taking <with|mode|math|\<cal-K\>=\<cal-F\>\<langle\>h<rsub|1>,\<ldots\>,h<rsub|n>\<rangle\>>,
  the condition <strong|PV2> is trivially satisfied since
  <with|mode|math|\<b-h\>(z<rsub|0>+\<varepsilon\>)\<in\>\<bbb-K\>[[\<varepsilon\>]]\<subseteq\>\<bbb-K\>((\<varepsilon\>))>
  and the constant field of <with|mode|math|\<bbb-K\>((z))>
  is<nbsp><with|mode|math|\<bbb-K\>>.

  Let <with|mode|math|\<cal-K\>> be a Picard-Vessiot extension of
  <with|mode|math|\<cal-F\>> and let <with|mode|math|\<b-h\>\<in\>\<cal-K\><rsup|n>>
  be as in <strong|PV1>. The <em|differential Galois group>
  <with|mode|math|\<cal-G\><rsub|\<cal-K\>/\<cal-F\>>> of the extension
  <with|mode|math|\<cal-K\>/\<cal-F\>> is the group of differential
  automorphisms which leave <with|mode|math|\<cal-F\>> pointwise invariant.
  It is classical <cite|Kol73> that <with|mode|math|\<cal-G\><rsub|\<cal-K\>/\<cal-F\>>>
  is independent (up to isomorphism) of the particular choice of the
  Picard-Vessiot extension <with|mode|math|\<cal-K\>>.

  Given an automorphism <with|mode|math|\<sigma\>\<in\>\<cal-G\><rsub|\<cal-K\>/\<cal-F\>>>,
  any solution <with|mode|math|f> to <with|mode|math|L f=0> is sent to
  another solution. In particular, there exists a unique matrix
  <with|mode|math|M=M<rsub|\<sigma\>,\<b-h\>>\<in\><value|GL><rsub|n>(\<bbb-K\>)>
  with <with|mode|math|\<sigma\> h<rsub|i>=M
  h<rsub|i>\<assign\><big|sum><rsub|j=1><rsup|n>M<rsub|i,j>*h<rsub|j>> for
  all <with|mode|math|i>. This yields an embedding
  <with|mode|math|\<rho\><rsub|\<b-h\>>> of
  <with|mode|math|\<cal-G\><rsub|\<cal-K\>/\<cal-F\>>> into
  <with|mode|math|<value|GL><rsub|n>(\<bbb-K\>)> and we define
  <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>\<assign\>\<rho\><rsub|\<b-h\>>(\<cal-G\><rsub|\<cal-K\>/\<cal-F\>>)>.
  Conversely, <with|mode|math|M\<in\><value|GL><rsub|n>(\<bbb-K\>)> belongs
  to <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>> if every differential
  relation <with|mode|math|P(h<rsub|1>,\<ldots\>,h<rsub|n>)=0> satisfied by
  <with|mode|math|h<rsub|1>,\<ldots\>,h<rsub|n>> is also satisfied by
  <with|mode|math|M h<rsub|1>,\<ldots\>,M h<rsub|n>> (with
  <with|mode|math|P\<in\>\<bbb-K\>{F<rsub|1>,\<ldots\>,F<rsub|n>}>). Since
  this assumption constitutes an infinite number of algebraic conditions on
  the coefficients of <with|mode|math|M>, it follows that
  <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>> is a Zariski closed algebraic
  matrix group. Whenever <with|mode|math|\<b-g\>=P*\<b-h\>> is another basis,
  we obtain the same matrix group <with|mode|math|\<cal-G\><rsub|L,\<b-g\>>=P*\<cal-G\><rsub|L,\<b-h\>>*P<rsup|\<um\>1>>
  up to conjugation.

  Assume now that <with|mode|math|<wide|\<bbb-K\>|^>\<supseteq\>\<bbb-K\>> is
  a larger algebraically closed subfield of <with|mode|math|\<bbb-C\>>. Then
  the field <with|mode|math|<wide|\<cal-K\>|^>=<wide|\<bbb-K\>|^>(z)\<langle\>h<rsub|1>,\<ldots\>,h<rsub|n>\<rangle\>=\<cal-K\>\<otimes\><wide|\<bbb-K\>|^>>
  is again a Picard-Vessiot extension of <with|mode|math|<wide|\<bbb-K\>|^>(z)>.
  Furthermore, the Ritt-Raudenbush theorem <cite|Ritt50> implies that the
  perfect differential ideal of all <with|mode|math|P\<in\>\<bbb-K\>{F<rsub|1>,\<ldots\>,F<rsub|n>}>
  with <with|mode|math|P(h<rsub|1>,\<ldots\>,h<rsub|n>)=0> is finitely
  generated, say by <with|mode|math|G<rsub|1>,\<ldots\>,G<rsub|k>>. But then
  <with|mode|math|G<rsub|1>,\<ldots\>,G<rsub|k>> is still a finite system of
  generators of the perfect differential ideal of all
  <with|mode|math|P\<in\><wide|\<bbb-K\>|^>{F<rsub|1>,\<ldots\>,F<rsub|n>}>
  with <with|mode|math|P(h<rsub|1>,\<ldots\>,h<rsub|n>)=0>. Consequently,
  <with|mode|math|<wide|\<cal-G\>|^><rsub|L,\<b-g\>>\<subseteq\><value|GL><rsub|n>(<wide|\<bbb-K\>|^>)>
  (<abbr|i.e.> as an algebraic group over
  <with|mode|math|<wide|\<bbb-K\>|^>>) is determined by the same algebraic
  equations as <with|mode|math|\<cal-G\><rsub|L,\<b-g\>>>. We conclude that
  <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>=<wide|\<cal-G\>|^><rsub|L,\<b-h\>>\<cap\><value|GL><rsub|n>(\<bbb-K\>)>.

  Let <with|mode|math|\<cal-K\>> be a Picard-Vessiot extension of
  <with|mode|math|\<cal-F\>>. Any differential field
  <with|mode|math|\<cal-L\>> with <with|mode|math|\<cal-F\>\<subseteq\>\<cal-L\>\<subseteq\>\<cal-K\>>
  naturally induces an algebraic subgroup
  <with|mode|math|\<cal-L\><rprime|'>\<subseteq\>\<cal-G\><rsub|\<cal-K\>/\<cal-F\>>>
  of automorphisms of <with|mode|math|\<cal-K\>> which leave
  <with|mode|math|\<cal-L\>> fixed. Inversely, any algebraic subgroup
  <with|mode|math|\<cal-H\>> of <with|mode|math|\<cal-G\><rsub|\<cal-K\>/\<cal-L\>>>
  gives rise to the differential field <with|mode|math|\<cal-H\><rprime|'>>
  with <with|mode|math|\<cal-F\>\<subseteq\>\<cal-H\><rprime|'>\<subseteq\>\<cal-K\>>
  of all elements which are invariant under the action of
  <with|mode|math|\<cal-H\>>. We say that<nbsp><with|mode|math|\<cal-L\>>
  (<abbr|resp.> <with|mode|math|\<cal-H\>>) is <em|closed> if
  <with|mode|math|\<cal-L\>=\<cal-L\><rprime|''>> (<abbr|resp.>
  <with|mode|math|\<cal-H\><rprime|''>=\<cal-H\>>). In that case, the
  extension <with|mode|math|\<cal-L\>/\<cal-F\>> is said to be <em|normal>,
  <abbr|i.e.> every element in <with|mode|math|\<cal-L\>\<setminus\>\<cal-F\>>
  is moved by an automorphism of <with|mode|math|\<cal-L\>>
  over<nbsp><with|mode|math|\<cal-F\>>. The main theorem from differential
  Galois theory states that the Galois correspondences are
  bijective<nbsp><cite-detail|Kap57|Theorem 5.9>.

  <\theorem>
    With the above notations:

    <\enumerate-alpha>
      <item>The correspondences <with|mode|math|\<cal-L\>\<mapsto\>\<cal-L\><rprime|'>>
      and <with|mode|math|\<cal-H\>\<mapsto\>\<cal-H\><rprime|'>> are
      bijective.

      <item>The group <with|mode|math|\<cal-H\>> is a closed normal subgroup
      of <with|mode|math|\<cal-G\><rsub|\<cal-K\>/\<cal-F\>>> if and only if
      the extension <with|mode|math|\<cal-H\><rprime|'>/<no-break>\<cal-F\>>
      is normal. In that case, <with|mode|math|\<cal-G\><rsub|\<cal-K\>/\<cal-F\>>/\<cal-H\>\<cong\>\<cal-G\><rsub|\<cal-H\><rprime|'>/\<cal-F\>>>.
    </enumerate-alpha>
  </theorem>

  <\corollary>
    <label|rat-inv-cor>Let <with|mode|math|f\<in\>\<cal-F\>\<langle\>h<rsub|1>,\<ldots\>,h<rsub|n>\<rangle\>>.
    If <with|mode|math|M f=f> for all <with|mode|math|M\<in\>\<cal-G\><rsub|L,\<b-h\>>>,
    then <with|mode|math|f\<in\>\<cal-F\>>.
  </corollary>

  <subsection|Monodromy><label|mono-sec>

  Consider a continuous path <with|mode|math|\<gamma\>> on
  <with|mode|math|\<bbb-C\>\<cup\>{\<infty\>}\<setminus\>\<cal-S\>> from
  <with|mode|math|z<rsub|0>\<in\>\<bbb-K\>> to
  <with|mode|math|z<rsub|1>\<in\>\<bbb-K\>>. Then analytic continuation of
  the canonical basis <with|mode|math|\<b-h\><rsup|z<rsub|0>>> at
  <with|mode|math|z<rsub|0>> along <with|mode|math|\<gamma\>> yields a basis
  of solutions to <with|mode|math|L f=0> at <with|mode|math|z<rsub|1>>. The
  matrix <with|mode|math|\<Delta\><rsub|\<gamma\>>\<in\><value|GL><rsub|n>(\<bbb-K\>)>
  with

  <\equation>
    <label|tmat-def-eq>\<b-h\><rsup|z<rsub|1>>=\<Delta\><rsub|\<gamma\>>*\<b-h\><rsup|z<rsub|0>>
  </equation>

  is called the <em|connection matrix> or <em|transition matrix> along
  <with|mode|math|\<gamma\>>. In particular, if
  <with|mode|math|z<rsub|1>=z<rsub|0>>, then we call
  <with|mode|math|\<Delta\><rsub|\<gamma\>>> a <em|monodromy matrix> based in
  <with|mode|math|z<rsub|0>>. We clearly have

  <\equation*>
    \<Delta\><rsub|\<gamma\><rsub|2>\<circ\>\<gamma\><rsub|1>>=\<Delta\><rsub|\<gamma\><rsub|2>>*\<Delta\><rsub|\<gamma\><rsub|1>>
  </equation*>

  for the composition of paths, so the monodromy matrices based in
  <with|mode|math|z<rsub|0>> form a group
  <with|mode|math|<value|Mono><rsub|z<rsub|0>>> which is called the
  <em|monodromy group>. Given a path <with|mode|math|\<gamma\>> from
  <with|mode|math|z<rsub|0>> to <with|mode|math|z<rsub|1>>, we notice that
  <with|mode|math|<value|Mono><rsub|z<rsub|1>>=\<Delta\><rsub|\<gamma\>>*<value|Mono><rsub|z<rsub|0>>*\<Delta\><rsub|\<gamma\>><rsup|\<um\>1>>.
  Since any differential relation satisfied by
  <with|mode|math|\<b-h\><rsup|z<rsub|0>>> is again satisfied by its analytic
  continuation along <with|mode|math|\<gamma\>>, we have
  <with|mode|math|<value|Mono><rsub|z<rsub|0>>\<subseteq\>\<cal-G\><rsub|L,\<b-h\><rsup|z<rsub|0>>>>
  and <with|mode|math|\<cal-G\><rsub|L,\<b-h\><rsup|z<rsub|1>>>=\<Delta\><rsub|\<gamma\>>*\<cal-G\><rsub|L,\<b-h\><rsup|z<rsub|0>>>*\<Delta\><rsub|\<gamma\>><rsup|\<um\>1>>.

  <\remark>
    The definition of transition matrices can be slightly changed depending
    on the purpose <cite-detail|vdH:reshol|Section 4.3.1>: when interpreting
    <with|mode|math|\<b-h\><rsup|z<rsub|0>>> and
    <with|mode|math|\<b-h\><rsup|z<rsub|1>>> as row vectors,
    then<nbsp>(<reference|tmat-def-eq>) has to be transposed. The roles of
    <with|mode|math|\<b-h\><rsup|z<rsub|0>>> and
    <with|mode|math|\<b-h\><rsup|z<rsub|1>>> may also be interchanged modulo
    inversion of<nbsp><with|mode|math|\<Delta\><rsub|\<gamma\>>>.
  </remark>

  Now assume that <with|mode|math|L> admits a singularity at
  <with|mode|math|0> (if <with|mode|math|\<cal-S\>\<neq\>\<varnothing\>> then
  we may reduce to this case modulo a translation; singularities at infinity
  may be brought back to zero using the transformation
  <with|mode|math|z\<rightarrow\>z<rsup|\<um\>1>>). It is well-known
  <cite|Fab1885|vH:phd> that <with|mode|math|L f> admits a computable formal
  basis of solutions of the form

  <\equation>
    <label|sing-form>f=(f<rsub|0>(<sqrt|z|p>)+\<cdots\>+f<rsub|n-1>(<sqrt|z|p>)*log<rsup|n-1>
    z)*z<rsup|\<alpha\>>*\<mathe\><rsup|P(<sqrt|z|p>)>,
  </equation>

  with <with|mode|math|h<rsub|0>,\<ldots\>,h<rsub|n-1>\<in\>\<bbb-K\>[[z]]>,
  <with|mode|math|p\<in\>\<bbb-N\><rsup|\<gtr\>>>,
  <with|mode|math|\<alpha\>\<in\>\<bbb-K\>> and
  <with|mode|math|P\<in\>\<bbb-K\>[z]>. We will denote by
  <with|mode|math|\<bbb-S\>> the set of finite sums of expressions of the
  form (<reference|sing-form>). We may see <with|mode|math|\<bbb-S\>> as a
  differential subring of a<nbsp>formal differential field of ``complex
  transseries'' <with|mode|math|\<bbb-T\>> <cite|vdH:osc> with constant field
  <with|mode|math|\<bbb-C\>>.

  We recall that transseries in <with|mode|math|\<bbb-T\>> are infinite
  linear combinations <with|mode|math|f=<big|sum><rsub|\<frak-m\>\<in\>\<frak-T\>>f<rsub|\<frak-m\>>*\<frak-m\>>
  of ``transmonomials'' with ``grid-based support''. The set
  <with|mode|math|\<frak-T\>> of transmonomials forms a totally ordered
  vector space for exponentiation by reals and the asymptotic ordering
  <with|mode|math|<op|\<preccurlyeq\>>>. In particular, each non-zero
  transseries <with|mode|math|f> admits a unique dominant monomial
  <with|mode|math|\<frak-d\><rsub|f>>. It can be shown <cite|vdH:osc> that
  there exists a unique basis <with|mode|math|\<b-h\>=(h<rsub|1>,\<ldots\>,h<rsub|n>)>
  of solutions to <with|mode|math|L f=0> of the form (<reference|sing-form>),
  with <with|mode|math|h<rsub|1>\<prec\>\<cdots\>\<prec\>h<rsub|n>> and
  <with|mode|math|(h<rsub|i>)<rsub|\<frak-d\>(h<rsub|j>)>=\<delta\><rsub|i,j>>
  for all <with|mode|math|i,j\<in\>{1,\<ldots\>,n}>. We call
  <with|mode|math|\<b-h\><rsup|0>=\<b-h\>> the canonical basis of solutions
  in <with|mode|math|0> and there is an algorithm which computes
  <with|mode|math|\<b-h\>> as a function of <with|mode|math|L>.

  Let <with|mode|math|\<bbb-L\>> be the subset of <with|mode|math|\<bbb-S\>>
  of all finite sums of expressions of the form (<reference|sing-form>) with
  <with|mode|math|P=0>. Then any <with|mode|math|f\<in\>\<bbb-S\>> can
  uniquely be written as a finite sum <with|mode|math|f=<big|sum><rsub|\<frak-e\>\<in\>\<frak-E\>>f<rsub|\<frak-e\>>*\<frak-e\>>,
  where <with|mode|math|\<frak-E\>=exp(<big|cup><rsub|p>\<bbb-C\>[<sqrt|z|p>])>.
  Let <with|mode|math|<value|Expo><rsub|0>> be the group of all automorphisms
  <with|mode|math|\<sigma\>:\<bbb-S\>\<rightarrow\>\<bbb-S\>> for which there
  exists a mapping <with|mode|math|\<lambda\>:\<frak-E\>\<rightarrow\>\<bbb-K\><rsup|\<neq\>>;\<frak-e\>\<mapsto\>\<lambda\><rsub|\<frak-e\>>>
  with <with|mode|math|\<sigma\>(f)=<big|sum><rsub|\<frak-e\>\<in\>\<frak-E\>>\<lambda\><rsub|\<frak-e\>>*f<rsub|\<frak-e\>>*\<frak-e\>>
  for all <with|mode|math|f\<in\>\<bbb-S\>>. Then every
  <with|mode|math|\<sigma\>\<in\><no-break>\<bbb-S\>> preserves
  differentiation and maps the Picard-Vessiot extension
  <with|mode|math|\<cal-K\>=\<cal-F\>\<langle\>h<rsub|1>,\<ldots\>,h<rsub|n>\<rangle\>>
  of <with|mode|math|\<cal-F\>> into itself. In particular, the restriction
  <with|mode|math|<value|Expo><rsub|0,\<b-h\>>> of
  <with|mode|math|<value|Expo><rsub|0>> to<nbsp><with|mode|math|\<cal-K\>> is
  a subset of <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>>.

  <\proposition>
    Assume that <with|mode|math|f\<in\>\<bbb-S\>> is fixed under
    <with|mode|math|<value|Expo><rsub|0>>. Then
    <with|mode|math|f\<in\>\<bbb-L\>>.
  </proposition>

  <\proof>
    Assume that <with|mode|math|f\<nin\>\<bbb-L\>> and let
    <with|mode|math|\<frak-e\>\<in\>\<frak-E\>> be a ``generalized exponent''
    with <with|mode|math|f<rsub|\<frak-e\>>\<neq\>0>. Let
    <with|mode|math|\<cal-H\>> be a supplement of the
    <with|mode|math|\<bbb-Q\>>-vector space <with|mode|math|log \<frak-E\>>.
    Let <with|mode|math|\<sigma\>:\<bbb-S\>\<rightarrow\>\<bbb-S\>> be the
    mapping in <with|mode|math|<value|Expo><rsub|0>> which sends
    <with|mode|math|\<frak-e\><rsup|\<alpha\>>*\<frak-f\>> to
    <with|mode|math|\<mathe\><rsup|\<alpha\>>*\<frak-e\><rsup|\<alpha\>>*\<frak-f\>>
    for each <with|mode|math|\<alpha\>\<in\>\<bbb-Q\>> and
    <with|mode|math|\<frak-f\>\<in\>exp \<cal-H\>>. Then we clearly have
    <with|mode|math|\<sigma\>(f)\<neq\>f>.
  </proof>

  Let <with|mode|math|\<frak-e\><rsub|1>,\<ldots\>,\<frak-e\><rsub|n>> be the
  set of generalized exponents corresponding to the generalized exponents of
  the elements of the canonical basis <with|mode|math|\<b-h\><rsup|0>>. Using
  linear algebra, we may compute a multiplicatively independent set
  <with|mode|math|\<frak-f\><rsub|1>,\<ldots\>,\<frak-f\><rsub|r>\<in\>\<frak-e\><rsub|1><rsup|\<bbb-Q\>>*\<cdots\>*\<frak-e\><rsub|n><rsup|\<bbb-Q\>>>
  such that <with|mode|math|\<frak-e\><rsub|i>=\<frak-f\><rsub|1><rsup|\<beta\><rsub|i,1>>*\<cdots\>*\<frak-f\><rsub|r><rsup|\<beta\><rsub|i,r>>>
  for certain <with|mode|math|\<beta\><rsub|i,j>\<in\>\<bbb-Z\>> and all
  <with|mode|math|i>.

  <\proposition>
    <label|expo-fin-prop>With the above notations, the algebraic group
    <with|mode|math|<value|Expo><rsub|0,\<b-h\>>> is generated by the
    matrices <with|mode|math|Diag(\<lambda\><rsup|\<beta\><rsub|i,1>>,\<ldots\>,\<lambda\><rsup|\<beta\><rsub|i,n>>)>
    where <with|mode|math|\<lambda\>\<in\>\<bbb-K\><rsup|\<neq\>>\<setminus\>{\<mu\>:\<exists\>n,\<mu\><rsup|n>=1}>
    is chosen arbitrarily.
  </proposition>

  <\proof>
    Let <with|mode|math|\<cal-E\>> be the group generated by the matrices
    <with|mode|math|Diag(\<lambda\><rsup|\<beta\><rsub|i,1>>,\<ldots\>,\<lambda\><rsup|\<beta\><rsub|i,n>>)>.
    Notice that each individual matrix <with|mode|math|Diag(\<lambda\><rsup|\<beta\><rsub|i,1>>,\<ldots\>,\<lambda\><rsup|\<beta\><rsub|i,n>>)>
    generates <with|mode|math|\<cal-S\>={Diag(\<alpha\><rsup|\<beta\><rsub|i,1>>,\<ldots\>,\<alpha\><rsup|\<beta\><rsub|i,n>>):\<alpha\>\<in\>\<bbb-K\><rsup|\<neq\>>}>:
    assuming <with|mode|math|\<frak-e\><rsub|i>\<neq\>1>, the variety
    <with|mode|math|\<cal-S\>> is irreducible of dimension <with|mode|math|1>
    and <with|mode|math|Diag(\<lambda\><rsup|\<beta\><rsub|i,1>>,\<ldots\>,\<lambda\><rsup|\<beta\><rsub|i,n>>)>
    is not contained in an algebraic group of dimension <with|mode|math|0>.
    Now any <with|mode|math|\<sigma\>\<in\><value|Expo><rsub|0,\<b-h\>>> is a
    diagonal matrix <with|mode|math|Diag(\<lambda\><rsub|\<frak-e\><rsub|1>>,\<ldots\>,\<lambda\><rsub|\<frak-e\><rsub|n>>)>
    for some multiplicative mapping <with|mode|math|\<lambda\>:\<frak-E\>\<mapsto\>\<bbb-K\><rsup|\<neq\>>>.
    Hence

    <\equation*>
      Diag(\<lambda\><rsub|\<frak-e\><rsub|1>>,\<ldots\>,\<lambda\><rsub|\<frak-e\><rsub|n>>)=Diag(\<lambda\><rsub|\<frak-f\><rsub|1>><rsup|\<beta\><rsub|1,1>>,\<ldots\>,\<lambda\><rsub|\<frak-f\><rsub|1>><rsup|\<beta\><rsub|n,1>>)*\<cdots\>*Diag(\<lambda\><rsub|\<frak-f\><rsub|r>><rsup|\<beta\><rsub|1,r>>,\<ldots\>,\<lambda\><rsub|\<frak-f\><rsub|r>><rsup|\<beta\><rsub|n,r>>)\<in\>\<cal-E\>.
    </equation*>

    Conversely, each element

    <\equation*>
      \<sigma\>\<in\>Diag(\<alpha\><rsub|1><rsup|\<beta\><rsub|1,1>>,\<ldots\>,\<alpha\><rsub|1><rsup|\<beta\><rsub|n,1>>)*\<cdots\>*Diag(\<alpha\><rsub|r><rsup|\<beta\><rsub|1,r>>,\<ldots\>,\<alpha\><rsub|r><rsup|\<beta\><rsub|n,r>>)\<in\>\<cal-E\>
    </equation*>

    determines a multiplicative mapping <with|mode|math|\<lambda\>:\<frak-f\><rsub|1><rsup|\<bbb-Z\>>*\<cdots\>*\<frak-f\><rsub|r><rsup|\<bbb-Z\>>\<rightarrow\>\<bbb-K\><rsup|\<neq\>>;f<rsub|1><rsup|k<rsub|1>>*\<cdots\>*f<rsub|r><rsup|k<rsub|r>>\<mapsto\>\<alpha\><rsub|1><rsup|k<rsub|1>>*\<cdots\>*\<alpha\><rsub|r><rsup|k<rsub|r>>>
    which may be further extended to<nbsp><with|mode|math|\<frak-E\>> using
    Zorn's lemma and the fact that <with|mode|math|\<bbb-K\>> is
    algebraically closed. It follows that<nbsp><with|mode|math|\<sigma\>\<in\><no-break><value|Expo><rsub|0,\<b-h\>>>.
  </proof>

  Assume that <with|mode|math|2*\<mathpi\>*\<mathi\>\<in\>\<bbb-K\>> and let
  <with|mode|math|M<rsub|0>:\<bbb-S\>\<rightarrow\>\<bbb-S\>> be the
  transformation which sends <with|mode|math|log z> to <with|mode|math|log
  z+2*\<mathpi\>*\<mathi\>>, <with|mode|math|z<rsup|\<alpha\>>> to
  <with|mode|math|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*\<alpha\>>*z<rsup|\<alpha\>>>
  and <with|mode|math|\<mathe\><rsup|P(<sqrt|z|p>)>> to
  <with|mode|math|\<mathe\><rsup|M<rsub|0>(P(<sqrt|z|p>))>>.
  Then<nbsp><with|mode|math|\<sigma\>> preserves differentiation, so any
  solution to <with|mode|math|L f=0> of the form (<reference|sing-form>) is
  sent to another solution of the same form. In particular, there exists a
  matrix <with|mode|math|\<Delta\><rsub|\<circlearrowleft\>0>> with
  <with|mode|math|M<rsub|0> \<b-h\>=\<Delta\><rsub|\<circlearrowleft\>0>*\<b-h\>>,
  called the <em|formal monodromy matrix> around<nbsp><with|mode|math|0>. We
  have <with|mode|math|\<Delta\><rsub|\<circlearrowleft\>0>\<in\>\<cal-G\><rsub|L,\<b-h\>>>.

  <\proposition>
    <label|expo-mon-fixed-prop>Assume that <with|mode|math|f\<in\>\<bbb-S\>>
    is fixed under <with|mode|math|<value|Expo><rsub|0>> and
    <with|mode|math|M<rsub|0>>. Then <with|mode|math|f\<in\>\<bbb-K\>((z))>.
  </proposition>

  <\proof>
    We already know that <with|mode|math|f\<in\>\<bbb-L\>>. Interpreting
    <with|mode|math|f=c<rsub|k> *log<rsup|k> z+\<cdots\>+c<rsub|0>> as a
    polynomial in <with|mode|math|log z> with
    <with|mode|math|k\<gtr\>0\<Rightarrow\>c<rsub|k>\<neq\>0>, we must have
    <with|mode|math|k=0> since

    <\equation*>
      M<rsub|0>(f)-f=2*\<pi\>*\<mathi\>*k*c<rsub|k>*log<rsup|k-1>
      z+\<cdots\>=0.
    </equation*>

    Consequently, <with|mode|math|f> is of the form
    <with|mode|math|f=<big|sum><rsub|\<alpha\>\<in\>\<bbb-K\>>f<rsub|\<alpha\>>*z<rsup|\<alpha\>>>
    and

    <\equation*>
      M<rsub|0>(f)=<big|sum><rsub|\<alpha\>\<in\>\<bbb-K\>>\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*\<alpha\>>*f<rsub|\<alpha\>>*z<rsup|\<alpha\>>=<big|sum><rsub|\<alpha\>\<in\>\<bbb-K\>>f<rsub|\<alpha\>>*z<rsup|\<alpha\>>=f(z),
    </equation*>

    We conclude that <with|mode|math|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*\<alpha\>>=1>
    for every <with|mode|math|\<alpha\>\<in\>\<bbb-K\>> with
    <with|mode|math|f<rsub|\<alpha\>>\<neq\>0>, whence
    <with|mode|math|f\<in\>\<bbb-C\>((z))>.
  </proof>

  <subsection|The process of accelero-summation>

  Let <with|mode|math|\<bbb-C\>[[z<rsup|\<bbb-Q\><rsup|\<gtr\>>>]]> be the
  differential <with|mode|math|\<bbb-C\>>-algebra of infinitesimal Puiseux
  series in <with|mode|math|z> for <with|mode|math|\<delta\>=z*\<partial\>>
  and consider a formal power series solution
  <with|mode|math|<wide|f|~>\<in\>\<bbb-O\>=\<bbb-C\>[[z<rsup|\<bbb-Q\><rsup|\<gtr\>>>]][log
  z]> to <with|mode|math|L <wide|f|~>=0>. The process of accelero-summation
  enables to associate an analytic meaning <with|mode|math|f> to
  <with|mode|math|<wide|f|~>> in a sector near the origin of the Riemann
  surface <with|mode|math|<wide|\<bbb-C\>|\<dot\>>> of <with|mode|math|log>,
  even in the case when <with|mode|math|<wide|f|~>> is divergent.
  Schematically speaking, we obtain <with|mode|math|f> through a succession
  of transformations:

  <\equation>
    <label|reshol:AS><tabular*|<tformat|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|10|10|cell-halign|c>|<cwith|1|-1|11|11|cell-halign|l>|<cwith|1|-1|9|9|cell-halign|l>|<cwith|1|-1|1|1|cell-halign|r>|<table|<row|<cell|<wide|f|~>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|f>>|<row|<cell|<with|math-level|1|<wide|\<cal-B\>|~><rsub|z<rsub|1>>>\<longdownarrow\>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|\<longuparrow\><with|math-level|1|\<cal-L\><rsub|z<rsub|p>><rsup|\<alpha\><rsub|p>>>>>|<row|<cell|<wide|f|^><rsub|1>>|<cell|\<longrightarrowlim\><rsub|\<cal-A\><rsub|z<rsub|1>\<rightarrow\>z<rsub|2>><rsup|\<alpha\><rsub|1>>>>|<cell|<wide|f|^><rsub|2>>|<cell|\<longrightarrow\>>|<cell|\<cdots\>>|<cell|\<longrightarrow\>>|<cell|<wide|f|^><rsub|p-1>>|<cell|\<longrightarrowlim\><rsub|\<cal-A\><rsub|z<rsub|p-1>\<rightarrow\>z<rsub|p>><rsup|\<alpha\><rsub|p-1>>>>|<cell|<wide|f|^><rsub|n>>>>>>
  </equation>

  Each <with|mode|math|<wide|f|^><rsub|i>> is a ``resurgent function'' which
  realizes <with|mode|math|<wide|f|~><rsub|i>(z<rsub|i>)=<wide|f|~>(z)> in
  the ``convolution model'' with respect to the <with|mode|math|i>-th
  ``critical time'' <with|mode|math|z<rsub|i>=<sqrt|z|k<rsub|i>>> (with
  <with|mode|math|k<rsub|i>\<in\>\<bbb-Q\><rsup|\<gtr\>>> and
  <with|mode|math|k<rsub|1>\<gtr\>\<cdots\>\<gtr\>k<rsub|p>>). In our case,
  <with|mode|math|<wide|f|^><rsub|i>> is an analytic function which admits
  only a finite number of singularities above<nbsp><with|mode|math|\<bbb-C\>>.
  In general, the singularities of a resurgent function are usually located
  on a finitely generated grid. Let us describe the transformations
  <with|mode|math|<wide|\<cal-B\>|~>>, <with|mode|math|\<cal-A\><rsup|\<alpha\><rsub|i>><rsub|z<rsub|i>\<rightarrow\>z<rsub|i+1>>>
  and<nbsp><with|mode|math|\<cal-L\><rsub|z<rsub|p>><rsup|\<alpha\><rsub|p>>>
  in more detail.

  <paragraph|<with|font-shape|small-caps|The Borel transform>>We start by
  applying the <em|formal Borel transform> to the series
  <with|mode|math|<wide|f|~><rsub|1>(z<rsub|1>)=<wide|f|~>(z)=<big|sum><rsub|\<sigma\>,r><wide|f|~><rsub|1,\<sigma\>,r>*z<rsub|1><rsup|\<sigma\>>*log<rsup|r>
  z<rsub|1>\<in\>\<bbb-C\>[[z<rsub|1><rsup|\<bbb-Q\><rsup|\<gtr\>>>]][log
  z<rsub|1>]>. This transformation sends each
  <with|mode|math|z<rsub|1><rsup|\<sigma\>>*log<rsup|r> z<rsub|1>> to

  <\equation*>
    (<wide|\<cal-B\>|~><rsub|z<rsub|1>> z<rsub|1><rsup|\<sigma\>>*log<rsup|r>
    z<rsub|1>)(\<zeta\><rsub|1>)=\<zeta\><rsub|1><rsup|\<sigma\>-1><big|sum><rsub|i=0><rsup|r><binom|r|i>\<gamma\><rsup|(r-i)>(\<sigma\>)*log<rsup|i>
    \<zeta\><rsub|1>,
  </equation*>

  where <with|mode|math|\<gamma\>(\<sigma\>)=1/\<Gamma\>(\<sigma\>)>, and
  extends by strong linearity:

  <\equation*>
    <wide|f|^><rsub|1>(\<zeta\><rsub|1>)=(<wide|\<cal-B\>|~><rsub|z<rsub|1>>
    <wide|f|~><rsub|1>)(\<zeta\><rsub|1>)=<big|sum><rsub|<stack|<tformat|<table|<row|<cell|\<sigma\>\<in\>\<bbb-Q\><rsup|\<gtr\>>>>|<row|<cell|r\<in\>\<bbb-N\>>>>>>><wide|f|~><rsub|1,r,\<sigma\>>*(<wide|\<cal-B\>|~><rsub|z<rsub|1>>
    z<rsub|1><rsup|\<sigma\>>*log<rsup|r> z<rsub|1>)(\<zeta\><rsub|1>),
  </equation*>

  The result is a formal series <with|mode|math|<wide|f|^><rsub|1>\<in\>\<zeta\><rsub|1><rsup|\<um\>1>*\<bbb-C\>[[\<zeta\><rsub|1><rsup|\<bbb-Q\><rsup|\<gtr\>>>]][log
  \<zeta\><rsub|1>]> in <with|mode|math|\<zeta\><rsub|1>> which converges
  near the origin of <with|mode|math|<wide|\<bbb-C\>|\<dot\>>>. The formal
  Borel transform is a morphism of differential algebras which sends
  multiplication to the convolution product, <abbr|i.e.>
  <with|mode|math|<wide|\<cal-B\>|~><rsub|z<rsub|1>>(f*g)=(<wide|\<cal-B\>|~><rsub|z<rsub|1>>
  f)\<ast\>(<wide|\<cal-B\>|~><rsub|z<rsub|1>> g)>.

  <paragraph|<with|font-shape|small-caps|Accelerations>>Given
  <with|mode|math|i\<less\>p>, the function
  <with|mode|math|<wide|f|^><rsub|i>> is defined near the origin of
  <with|mode|math|<wide|\<bbb-C\>|\<dot\>>>, can be analytically continued on
  the axis <with|mode|math|\<mathe\><rsup|\<alpha\><rsub|i>*\<mathi\>>*\<bbb-R\><rsup|\<gtr\>>\<subseteq\><wide|\<bbb-C\>|\<dot\>>>,
  and admits a growth of the form <with|mode|math|<wide|f|^><rsub|i>(\<zeta\><rsub|i>)=exp
  O(\|\<zeta\><rsub|i>\|<rsup|k<rsub|i>/(k<rsub|i>-k<rsub|i+1>)>)> at
  infinity. The next function <with|mode|math|<wide|f|^><rsub|i+1>> is
  obtained from <with|mode|math|<wide|f|^><rsub|i>> by an <em|acceleration>
  of the form

  <\equation*>
    <wide|f|^><rsub|i+1>(\<zeta\><rsub|i+1>)=(\<cal-A\><rsub|z<rsub|i>\<rightarrow\>z<rsub|i+1>><rsup|\<alpha\><rsub|i>>
    <wide|f|^><rsub|i>)(\<zeta\><rsub|i+1>)=<big|int><rsub|\<zeta\><rsub|i>\<in\>\<mathe\><rsup|\<alpha\><rsub|i>*\<mathi\>>*\<bbb-R\><rsup|\<gtr\>>>K<rsub|k<rsub|i>,k<rsub|i+1>>(\<zeta\><rsub|i>,\<zeta\><rsub|i+1>)*<wide|f|^><rsub|i>(\<zeta\><rsub|i>)*\<mathd\>
    \<zeta\><rsub|i>,
  </equation*>

  where the acceleration kernel <with|mode|math|K<rsub|k<rsub|i>,k<rsub|i+1>>>
  is given by

  <\eqnarray*>
    <tformat|<table|<row|<cell|K<rsub|k<rsub|i>,k<rsub|i+1>>(\<zeta\><rsub|i>,\<zeta\><rsub|i+1>)>|<cell|=>|<cell|<with|math-display|false|<frac|1|\<zeta\><rsub|i+1>>>*K<rsub|k<rsub|i+1>/k<rsub|i>><left|(|2><with|math-display|false|<frac|\<zeta\><rsub|i>|\<zeta\><rsub|i+1><rsup|k<rsub|i+1>/k<rsub|i>>>><right|)|2>>>|<row|<cell|K<rsub|\<lambda\>>(\<zeta\>)>|<cell|=>|<cell|<frac|1|2*\<mathpi\>*\<mathi\>><big|int><rsub|c-\<infty\>*\<mathi\>><rsup|c+\<infty\>*\<mathi\>>\<mathe\><rsup|z-\<zeta\>*z<rsup|\<lambda\>>>\<mathd\>
    z.<eq-number><label|accel-kerner>>>>>
  </eqnarray*>

  For large <with|mode|math|\<zeta\>> on an axis with <with|mode|math|\|arg
  \<zeta\>\|\<less\>(1-\<lambda\>)*\<mathpi\>/2>, it can be shown that
  <with|mode|math|K<rsub|\<lambda\>>(\<zeta\>)\<leqslant\>exp(\<um\><no-break>C*\|\<zeta\>\|<rsup|1/(1-\<lambda\>)>)>
  for some constant <with|mode|math|C\<gtr\>0>. Assuming that
  <with|mode|math|\<alpha\><rsub|i+1>> satisfies

  <\equation>
    <label|dir-constraint>\|k<rsub|i+1>*\<alpha\><rsub|i+1>-k<rsub|i>*\<alpha\><rsub|i>\|\<less\>(k<rsub|i>-k<rsub|i+1>)*\<mathpi\>/2,
  </equation>

  it follows that the acceleration<nbsp><with|mode|math|<wide|f|^><rsub|i+1>>
  of <with|mode|math|<wide|f|^><rsub|i>> is well-defined for small
  <with|mode|math|\<zeta\><rsub|i+1>> on <with|mode|math|\<mathe\><rsup|\<alpha\><rsub|i+1>>*\<bbb-R\><rsup|\<gtr\>>>.
  The set <with|mode|math|\<cal-D\><rsub|i>\<subseteq\>\<bbb-R\>> of
  directions<nbsp><with|mode|math|\<alpha\>> such
  <with|mode|math|<wide|f|^><rsub|i>> admits a singularity on
  <with|mode|math|\<mathe\><rsup|\<alpha\>*\<mathi\>>*\<bbb-R\><rsup|\<gtr\>>>
  is called the set of <em|Stokes directions>. Accelerations are morphisms of
  differential <with|mode|math|\<bbb-C\>>-algebras which preserve the
  convolution product.

  <paragraph|<with|font-shape|small-caps|The Laplace transform>> The last
  function <with|mode|math|<wide|f|^><rsub|p>> is defined near the origin of
  <with|mode|math|<wide|\<bbb-C\>|\<dot\>>>, can be analytically continued on
  the axis <with|mode|math|\<mathe\><rsup|\<alpha\><rsub|i>*\<mathi\>>*\<bbb-R\><rsup|\<gtr\>>\<subseteq\><wide|\<bbb-C\>|\<dot\>>>
  and admits at most exponential growth at infinity. The function
  <with|mode|math|f> is now obtained using the analytic <em|Laplace
  transform>

  <\equation*>
    f(z)=f<rsub|p>(z<rsub|p>)=(\<cal-L\><rsub|z<rsub|p>><rsup|\<alpha\><rsub|p>>
    <wide|f|^><rsub|p>)(z<rsub|p>)=<big|int><rsub|\<zeta\><rsub|p>\<in\>\<mathe\><rsup|\<alpha\><rsub|p>*\<mathi\>>*\<bbb-R\><rsup|\<gtr\>>><wide|f|^><rsub|p>(\<zeta\><rsub|p>)*\<mathe\><rsup|\<um\>\<zeta\><rsub|p>/z<rsub|p>>*\<mathd\>
    \<zeta\><rsub|p>.
  </equation*>

  On an axis with

  <\equation>
    <label|lapl-constraint>\|arg z<rsub|p>-\<alpha\><rsub|p>\|\<less\>\<mathpi\>/2,
  </equation>

  the function <with|mode|math|f<rsub|p>> is defined for all sufficiently
  small <with|mode|math|z<rsub|p>>. The set
  <with|mode|math|\<cal-D\><rsub|p>> of Stokes directions is defined in a
  similar way as in the case of accelerations. The Laplace transform is
  a<nbsp>morphism of differential <with|mode|math|\<bbb-C\>>-algebras which
  is inverse to the Borel transform and sends the convolution product to
  multiplication.

  <\remark>
    <no-page-break*>Intuitively speaking, one has
    <with|mode|math|\<cal-A\><rsub|z<rsub|i>\<rightarrow\>z<rsub|i+1>><rsup|\<alpha\><rsub|i>>=\<cal-B\><rsub|z<rsub|i+1>>\<circ\>\<cal-L\><rsub|z<rsub|i>><rsup|\<alpha\><rsub|i>>>.
  </remark>

  Given critical times <with|mode|math|k<rsub|1>\<gtr\>\<cdots\>\<gtr\>k<rsub|p>>
  in <with|mode|math|\<bbb-Q\><rsup|\<gtr\>>> and directions
  <with|mode|math|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|p>> satisfying
  (<reference|dir-constraint>), we say that a formal power series
  <with|mode|math|<wide|f|~>\<in\><wide|\<bbb-O\>|~>> is
  <em|accelero-summable> in the multi-direction
  <with|mode|math|\<b-alpha\>=(\<alpha\><rsub|1>,\<ldots\>,<no-break>\<alpha\><rsub|p>)>
  if the above scheme yields an analytic function <with|mode|math|f(z)> near
  the origin of any axis on <with|mode|math|<wide|\<bbb-C\>|\<dot\>>>
  satisfying<nbsp>(<reference|lapl-constraint>). We denote the set of such
  power series by <with|mode|math|\<bbb-O\><rsub|\<b-k\>,\<b-alpha\>>>, where
  <with|mode|math|\<b-k\>=(k<rsub|1>,\<ldots\>,<no-break>k<rsub|p>)>.
  Inversely, given <with|mode|math|<wide|f|~>\<in\>\<bbb-O\>>, we denote by
  <with|mode|math|dom<rsub|as> <wide|f|~>> the set of all triples
  <with|mode|math|\<gamma\>=(\<b-k\>,<no-break>\<b-alpha\>,<no-break>z)> such
  that <with|mode|math|<wide|f|~>\<in\>\<bbb-O\><rsub|\<b-k\>,\<b-alpha\>>>
  and so that <with|mode|math|f(z)> is well-defined. In that case, we write
  <with|mode|math|f=sum<rsub|\<b-k\>,\<b-alpha\>>> and
  <with|mode|math|f(z)=<wide|f|~>(\<gamma\>)>.

  The set <with|mode|math|\<bbb-O\><rsub|\<b-k\>,\<b-alpha\>>> forms a
  differential subring of <with|mode|math|\<bbb-O\>> and the map
  <with|mode|math|<wide|f|~>\<mapsto\>f> for
  <with|mode|math|<wide|f|~>\<in\>\<bbb-O\><rsub|\<b-k\>,\<b-alpha\>>> is
  injective. If <with|mode|math|\<b-k\><rprime|'>> and
  <with|mode|math|\<b-alpha\><rprime|'>> are obtained from
  <with|mode|math|\<b-k\>> and <with|mode|math|\<b-alpha\>> by inserting a
  new critical time and an arbitrary direction, then we have
  <with|mode|math|\<bbb-O\><rsub|\<b-k\>,\<b-alpha\>>\<varsubsetneq\>\<bbb-O\><rsub|\<b-k\><rprime|'>,\<b-alpha\><rprime|'>>>.
  In particular, <with|mode|math|\<bbb-O\><rsub|\<b-k\>,\<b-alpha\>>>
  contains <with|mode|math|\<bbb-O\><rsub|cv>=\<bbb-C\>{<space|-0.6spc>{z<rsup|\<bbb-Q\><rsup|\<gtr\>>>}<space|-0.6spc>}[log
  z]>, where <with|mode|math|\<bbb-C\>{<space|-0.6spc>{z<rsup|\<bbb-Q\><rsup|\<gtr\>>>}<space|-0.6spc>}>
  denotes the ring of convergent infinitesimal Puiseux series. Let
  <with|mode|math|\<cal-R\><rsub|1>=\<bbb-R\>\<setminus\>\<cal-D\><rsub|1>\<subseteq\>\<bbb-R\>,\<ldots\>,\<cal-R\><rsub|p>=\<bbb-R\>\<setminus\>\<cal-D\><rsub|p>\<subseteq\>\<bbb-R\>>
  be sets of directions such that each<nbsp><with|mode|math|\<cal-D\><rsub|i>>
  is finite modulo<nbsp><with|mode|math|2*\<mathpi\>>. Let
  <with|mode|math|\<b-cal-R\>> be the subset of
  <with|mode|math|\<cal-R\><rsub|1>\<times\>\<cdots\>\<times\>\<cal-R\><rsub|p>>
  of multi-directions <with|mode|math|\<b-alpha\>> which
  verify<nbsp>(<reference|dir-constraint>). We denote
  <with|mode|math|\<bbb-O\><rsub|\<b-k\>,\<b-cal-R\>>=<big|cap><rsub|\<b-alpha\>\<in\>\<b-cal-R\>>\<bbb-O\><rsub|\<b-k\>,\<b-alpha\>>>,
  <with|mode|math|\<bbb-O\><rsub|\<b-k\>>=<big|cup><rsub|\<b-cal-R\>>\<bbb-O\><rsub|\<b-k\>,\<b-cal-R\>>>
  and<nbsp><with|mode|math|\<bbb-O\><rsub|as>=<no-break><big|cup><rsub|\<b-k\>>\<bbb-O\><rsub|\<b-k\>>>.

  Taking <with|mode|math|\<bbb-K\>=\<bbb-C\>>, the notion of
  accelero-summation extends to formal expressions of the form
  (<reference|sing-form>) and more general elements of
  <with|mode|math|\<bbb-S\>> as follows. Given
  <with|mode|math|<wide|g|~>\<in\>\<bbb-O\><rsub|\<b-k\>,\<b-alpha\>>>,
  <with|mode|math|\<sigma\>\<in\>\<bbb-C\>>,
  <with|mode|math|\<frak-e\>=<no-break>\<mathe\><rsup|P(<sqrt|z|p>)>\<in\><no-break>\<frak-E\>>
  and <with|mode|math|\<gamma\>=(\<b-k\>,\<b-alpha\>,z)\<in\>dom<rsub|as>
  <wide|g|~>>, we simply define <with|mode|math|(<wide|g|~>*z<rsup|\<sigma\>>*\<frak-e\>)(\<gamma\>)=<wide|g|~>(\<gamma\>)*z<rsup|\<sigma\>>*\<mathe\><rsup|P(<sqrt|z|p>)>>.
  It can be checked that this definition is coherent when replacing
  <with|mode|math|<wide|g|~>*z<rsup|\<sigma\>>> by
  <with|mode|math|(z<rsup|k>*<wide|g|~>)*z<rsup|\<sigma\>-k>> for some
  <with|mode|math|k\<in\>\<bbb-Q\>>. \ By linearity, we thus obtain a natural
  differential subalgebra <with|mode|math|\<bbb-S\><rsub|\<b-k\>,\<b-alpha\>>\<subseteq\>\<bbb-S\>>
  of accelero-summable transseries with critical times
  <with|mode|math|\<b-k\>> and in the multi-direction
  <with|mode|math|\<b-alpha\>>. We also have natural analogues
  <with|mode|math|\<bbb-S\><rsub|\<b-k\>>> and
  <with|mode|math|\<bbb-S\><rsub|as>> of <with|mode|math|\<bbb-O\><rsub|\<b-k\>>>
  and <with|mode|math|\<bbb-O\><rsub|as>>.

  The main result we need from the theory of accelero-summation is the
  following theorem <cite|Ec87|Br91>.

  <\theorem>
    <label|as-lin-th>Let <with|mode|math|<wide|f|~>\<in\>\<bbb-O\>> be a
    formal solution to <with|mode|math|L <wide|f|~>=0>. Then
    <with|mode|math|<wide|f|~>\<in\>\<bbb-O\><rsub|as>>.
  </theorem>

  <\corollary>
    <label|as-basis-cor>Let <with|mode|math|\<b-h\><rsup|0>\<in\>\<bbb-S\><rsup|n>>
    be the canonical basis of formal solutions to <with|mode|math|L
    <wide|f|~>=0> at the origin. We have <with|mode|math|\<b-h\><rsup|0>\<in\>\<bbb-S\><rsub|as><rsup|n>>.
  </corollary>

  <\proof>
    Holonomy is preserved under multiplication with elements of
    <with|mode|math|z<rsup|\<bbb-C\>>*\<frak-E\>>.
  </proof>

  <\remark>
    We have aimed to keep our survey of the accelero-summation process as
    brief as possible. It is more elegant to develop this theory using
    resurgent functions and resurgence monomials<nbsp><cite|Ec85|CNP93>.
  </remark>

  <subsection|The Stokes phenomenon>

  We say that <with|mode|math|<wide|f|~>\<in\>\<bbb-S\><rsub|\<b-k\>,\<b-cal-R\>>>
  is <em|stable under Stokes morphisms> is for all
  <with|mode|math|\<b-alpha\>,\<b-beta\>\<in\>\<b-cal-R\>>, there exists a
  <with|mode|math|<wide|g|~>\<in\>\<bbb-S\><rsub|\<b-k\>,\<b-cal-R\>>> with
  <with|mode|math|sum<rsub|\<b-k\>,\<b-alpha\>>
  <wide|f|~>=sum<rsub|\<b-k\>,\<b-beta\>> <wide|g|~>>, and if the same
  property is recursively satisfied by <with|mode|math|<wide|g|~>>. We denote
  by <with|mode|math|<wide|\<bbb-S\>|\<breve\>><rsub|\<b-k\>,\<b-cal-R\>>>
  the differential subring of <with|mode|math|\<bbb-S\><rsub|\<b-k\>,\<b-cal-R\>>>
  which is stable under Stokes morphisms. The mappings
  <with|mode|math|\<Sigma\><rsub|\<b-k\>,\<b-alpha\>,\<b-beta\>>:<wide|f|~>\<mapsto\>sum<rsub|\<b-k\>,\<b-beta\>><rsup|\<um\>1>
  sum<rsub|\<b-k\>,\<b-alpha\>> <wide|f|~>> will be called <em|Stokes
  morphisms> and we denote by <with|mode|math|<value|Sto><rsub|0,\<b-k\>,\<b-cal-R\>>>
  the group of all such maps.

  <\proposition>
    <label|fixed-stokes-prop>Assume that <with|mode|math|<wide|f|~>\<in\>\<bbb-S\><rsub|\<b-k\>,\<b-cal-R\>>>
    is fixed under <with|mode|math|<value|Sto><rsub|0,\<b-k\>,\<b-cal-R\>>>.
    Then <with|mode|math|<wide|f|~>> is convergent.
  </proposition>

  <\proof>
    Assume that one of the <with|mode|math|<wide|f|^><rsub|i>> admits a
    singularity at <with|mode|math|\<omega\>=\<rho\>*\<mathe\><rsup|\<theta\>*\<mathi\>>\<neq\>0>
    and choose <with|mode|math|i> maximal and <with|mode|math|\<rho\>>
    minimal. Modulo the removal of unnecessary critical times, we may assume
    without loss of generality that<nbsp><with|mode|math|i=p>. Let
    <with|mode|math|\<b-alpha\>> with <with|mode|math|\<alpha\><rsub|p>=\<theta\>>
    be a multi-direction satisfying (<reference|dir-constraint>), such that
    <with|mode|math|\<alpha\><rsub|i>\<in\>\<cal-R\><rsub|i>> for all
    <with|mode|math|i\<less\>p>. Then

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<b-alpha\><rsup|\<less\>>>|<cell|=>|<cell|(\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|p-1>,\<alpha\><rsub|p>-\<varepsilon\>)\<in\>\<b-cal-R\>>>|<row|<cell|\<b-alpha\><rsup|\<gtr\>>>|<cell|=>|<cell|(\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|p-1>,\<alpha\><rsub|p>+\<varepsilon\>)\<in\>\<b-cal-R\>>>>>
    </eqnarray*>

    for all sufficiently small <with|mode|math|\<varepsilon\>\<gtr\>0>. Now
    <with|mode|math|g<rsub|p>=\<cal-L\><rsub|z<rsub|p>><rsup|\<theta\>+\<varepsilon\>>
    <wide|f|^><rsub|p>-\<cal-L\><rsub|z<rsub|p>><rsup|\<theta\>-\<varepsilon\>>
    <wide|f|^><rsub|p>> is obtained by integration around
    <with|mode|math|\<omega\>> along the axis
    <with|mode|math|\<mathe\><rsup|\<theta\>*\<mathi\>>*\<bbb-R\><rsup|\<gtr\>>>.
    By classical properties of the Laplace integral
    <cite-detail|CNP93|Pr<nbsp>I.2>, the function <with|mode|math|g<rsub|p>>
    cannot vanish, since <with|mode|math|<wide|f|^><rsub|i>> admits a
    singularity in <with|mode|math|\<omega\>> (if the Laplace integrals
    corresponding to both directions <with|mode|math|\<theta\>\<pm\>\<varepsilon\>>
    coincide, then the Laplace transform can be analytically continued to a
    larger sector, which is only possible if
    <with|mode|math|<wide|f|^><rsub|i>> is analytic in a sector which
    contains both directions <with|mode|math|\<theta\>\<pm\>\<varepsilon\>>).
    We conclude that <with|mode|math|g(z)=g<rsub|p>(z<rsub|p>)=(sum<rsub|\<b-k\>,\<b-alpha\><rsup|\<gtr\>>>-sum<rsub|\<b-k\>,\<b-alpha\><rsup|\<less\>>>)(<wide|f|~>)\<neq\>0>,
    so <with|mode|math|f> is not fixed under
    <with|mode|math|<value|Sto><rsub|0,\<b-k\>,\<b-cal-R\>>>.
  </proof>

  <\remark>
    <label|fin-stokes-dir>Let <with|mode|math|\<b-cal-D\>> be a set of
    multi-directions <with|mode|math|\<b-alpha\>> satisfying
    (<reference|dir-constraint>), with <with|mode|math|\<alpha\><rsub|i>\<in\>\<cal-D\><rsub|i>>
    for exactly one<nbsp><with|mode|math|i>, and so that for all
    <with|mode|math|j\<neq\>i>, we have either
    <with|mode|math|\<alpha\><rsub|j>=k<rsub|i>*\<alpha\><rsub|i>/k<rsub|j>>
    or <with|mode|math|k<rsub|i>*\<alpha\><rsub|i>/k<rsub|j>\<in\>\<cal-D\><rsub|j>>
    and <with|mode|math|\<alpha\><rsub|j>=k<rsub|i>*(\<alpha\><rsub|i>\<pm\>\<varepsilon\>)/k<rsub|j>>
    for some small <with|mode|math|\<varepsilon\>\<gtr\>0>. For every
    <with|mode|math|\<b-alpha\>\<in\>\<b-cal-D\>>, we have

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<b-alpha\><rsup|\<less\>>>|<cell|=>|<cell|(\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|i-1>,\<alpha\><rsub|i>-\<varepsilon\>,\<alpha\><rsub|i+1>,\<ldots\>,\<alpha\><rsub|p>)\<in\>\<b-cal-R\>>>|<row|<cell|\<b-alpha\><rsup|\<gtr\>>>|<cell|=>|<cell|(\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|i-1>,\<alpha\><rsub|i>+\<varepsilon\>,\<alpha\><rsub|i+1>,\<ldots\>,\<alpha\><rsub|p>)\<in\>\<b-cal-R\>.>>>>
    </eqnarray*>

    By looking more carefully at the proof of proposition
    <reference|fixed-stokes-prop>, we observe that it suffices to assume that
    <with|mode|math|<wide|f|~>> is fixed under all Stokes morphisms of the
    form <with|mode|math|\<Sigma\><rsub|\<b-k\>,\<b-alpha\><rsup|\<less\>>,\<b-alpha\><rsup|\<gtr\>>>>,
    instead of all elements in <with|mode|math|<value|Sto><rsub|0,\<b-k\>,\<b-cal-R\>>>.

    We say that <with|mode|math|\<b-alpha\>,\<b-beta\>\<in\>\<b-cal-D\>> are
    equivalent, if <with|mode|math|\<alpha\><rsub|i>-\<beta\><rsub|i>\<in\>2*\<mathpi\>*\<mathi\>*q<rsub|i>>
    for all <with|mode|math|i>, where <with|mode|math|q<rsub|i>> is the
    denominator of <with|mode|math|k<rsub|i>>. We notice that
    <with|mode|math|\<b-cal-D\>> is finite modulo this equivalent relation.
    We denote by <with|mode|math|\<b-cal-D\><rsup|gen>> a subset of
    <with|mode|math|\<b-cal-D\>> with one element in each equivalence class.
  </remark>

  Let us now come back to our differential equation <with|mode|math|L f=0>.
  Given <with|mode|math|\<gamma\>=(\<b-k\>,\<b-alpha\>,z)\<in\>dom<rsub|as>
  \<b-h\><rsup|0>\<assign\>dom<rsub|as> h<rsup|0><rsub|1>\<cap\>\<cdots\>\<cap\>dom<rsub|as>
  h<rsup|0><rsub|n>>, the map <with|mode|math|sum<rsub|\<b-k\>,\<b-alpha\>>>
  induces an isomorphism between <with|mode|math|<value|Vect>(\<b-h\><rsup|0>)>
  and <with|mode|math|<value|Vect>(\<b-h\><rsup|z>)>. We denote by
  <with|mode|math|\<Delta\><rsub|\<gamma\>>\<in\><value|GL><rsub|n>(\<bbb-C\>)>
  the unique matrix with <with|mode|math|\<b-h\><rsup|z>=\<Delta\><rsub|\<gamma\>>*sum<rsub|\<b-k\>,\<b-alpha\>>
  \<b-h\><rsup|0>>. Given a second <with|mode|math|\<gamma\><rprime|'>=(\<b-k\>,\<b-alpha\><rprime|'>,z)\<in\>dom<rsub|as>
  \<b-h\><rsup|0>>, the vector <with|mode|math|sum<rsub|\<b-k\>,\<b-alpha\><rprime|'>><rsup|\<um\>1>
  sum<rsub|\<b-k\>,\<b-alpha\>> \<b-h\><rsup|0>> is again in
  <with|mode|math|\<bbb-S\><rsub|\<b-k\>,\<b-cal-R\>><rsup|n>>, whence
  <with|mode|math|\<b-h\><rsup|0>\<in\><wide|\<bbb-S\>|\<breve\>><rsub|\<b-k\>,\<b-cal-R\>>>
  by repeating the argument. In particular, the Stokes morphism
  <with|mode|math|\<Sigma\><rsub|\<b-k\>,\<b-alpha\>,\<b-alpha\><rprime|'>>>
  induces the <em|Stokes matrix> <with|mode|math|\<Delta\><rsub|(0,\<b-k\>,\<b-alpha\>\<rightarrow\>\<b-alpha\><rprime|'>)>=\<Delta\><rsub|\<gamma\><rprime|'>><rsup|\<um\>1>*\<Delta\><rsub|\<gamma\>>>.

  We are now in the position that we can construct a finite set
  <with|mode|math|\<cal-M\>> of generators for the Galois group
  <with|mode|math|\<cal-G\><rsub|L,\<b-h\><rsup|z<rsub|0>>>> in a regular
  point <with|mode|math|z<rsub|0>\<in\>\<bbb-C\>\<cup\>{\<upl\>\<infty\>}\<setminus\>\<cal-S\>>.

  <\algorithm|Compute_generators>
    <\with|mode|math>
      (L,z<rsub|0>)<with|mode|text|<no-page-break>>
    </with>

    <strong|Input:> an operator <with|mode|math|L\<in\>\<cal-F\>[\<partial\>]<rsup|\<neq\>>>
    and a regular point <with|mode|math|z<rsub|0>\<in\>\<bbb-C\>\<cup\>{\<upl\>\<infty\>}\<setminus\>\<cal-S\>><no-page-break>

    <strong|Output:> a set <with|mode|math|\<cal-M\>> of generators for
    <with|mode|math|\<cal-G\><rsub|L,\<b-h\><rsup|z<rsub|0>>>><no-page-break>

    <\body>
      <with|mode|math|\<cal-M\>\<assign\>\<varnothing\>>

      <strong|for each> <with|mode|math|z<rsub|i>\<in\>\<cal-S\>> <strong|do>

      <\with|item*|<macro|x|<assign|last-item|<arg|x>><current-item|<arg|x>>>>
        <\itemize>
          <item>Reduce to the case when <with|mode|math|z<rsub|i>=0> modulo a
          suitable transformation of the form <with|mode|math|z\<mapsto\>z+c>
          or<nbsp><with|mode|math|z\<mapsto\>z<rsup|\<um\>1>>.

          <item>Let <with|mode|math|\<gamma\><rsub|i>> be an arbitrary path
          <with|mode|math|(\<b-k\>,\<b-alpha\>,u<rsub|i>)\<in\>dom<rsub|as>
          \<b-h\><rsup|z<rsub|i>>> from <with|mode|math|z<rsub|i>> to a point
          <with|mode|math|u<rsub|i>> nearby <with|mode|math|z<rsub|i>>,
          composed with an arbitrary path from <with|mode|math|u<rsub|i>> to
          <with|mode|math|z<rsub|0>> on <with|mode|math|\<bbb-C\>\<cup\>{\<upl\>\<infty\>}\<setminus\>\<cal-S\>>.

          <item>Compute a finite set of generators
          <with|mode|math|\<cal-X\><rsub|i>> for
          <with|mode|math|<value|Expo><rsub|z<rsub|i>,\<b-h\><rsup|z<rsub|i>>>>
          using proposition <reference|expo-fin-prop> and add
          <with|mode|math|\<Delta\><rsub|\<gamma\><rsub|i>>*\<Chi\>*\<Delta\><rsub|\<gamma\><rsub|i>><rsup|\<um\>1>>
          to <with|mode|math|\<cal-M\>> for all
          <with|mode|math|\<Chi\>\<in\>\<cal-X\><rsub|i>>.

          <item>Add <with|mode|math|\<Delta\><rsub|\<gamma\><rsub|i>>*\<Delta\><rsub|\<circlearrowleft\>z<rsub|i>>*\<Delta\><rsub|\<gamma\><rsub|i>><rsup|\<um\>1>*>
          to <with|mode|math|\<cal-M\>>.

          <item>For each <with|mode|math|\<b-alpha\>\<in\>\<b-cal-D\><rsup|gen>>
          with <with|mode|math|\<b-cal-D\><rsup|gen>> as in remark
          <reference|fin-stokes-dir>, add
          <with|mode|math|\<Delta\><rsub|\<gamma\><rsub|i>>*\<Delta\><rsub|(z<rsub|i>,\<b-k\>,\<b-alpha\><rsup|\<less\>>\<rightarrow\>\<b-alpha\><rsup|\<gtr\>>)>*\<Delta\><rsub|\<gamma\><rsub|i>><rsup|\<um\>1>>
          to <with|mode|math|\<cal-M\>>.
        </itemize>
      </with>
    </body>

    <strong|return> <with|mode|math|\<cal-M\>>
  </algorithm>

  <\theorem>
    <label|as-galois-th>With <with|mode|math|\<cal-M\>> constructed as above,
    the differential Galois group <with|mode|math|\<cal-G\><rsub|L,\<b-h\><rsup|z<rsub|0>>>>
    is generated by <with|mode|math|\<cal-M\>> as a closed algebraic subgroup
    of <with|mode|math|<value|Mat><rsub|n>(\<bbb-C\>)>.
  </theorem>

  <\proof>
    Assume that <with|mode|math|f\<in\>\<cal-F\>\<langle\>h<rsub|1><rsup|z<rsub|0>>,\<ldots\>,h<rsub|n><rsup|z<rsub|0>>\<rangle\>>
    is fixed by each element of <with|mode|math|\<cal-M\>>. We have to prove
    that <with|mode|math|f\<in\>\<cal-F\>>. Given a singularity
    <with|mode|math|z<rsub|i>>, let <with|mode|math|<wide|g|~>> be the
    ``continuation'' of <with|mode|math|f> along
    <with|mode|math|\<gamma\><rsub|i><rsup|\<um\>1>> (which involves analytic
    continuation until <with|mode|math|u<rsub|i>> followed by
    ``decelero-unsummation''). By proposition
    <reference|expo-mon-fixed-prop>, we have
    <with|mode|math|<wide|g|~>\<in\>\<bbb-C\>((z))>. From proposition
    <reference|fixed-stokes-prop> and remark <reference|fin-stokes-dir>, we
    next deduce that <with|mode|math|<wide|g|~>> is convergent. Indeed, since
    <with|mode|math|<wide|g|~>\<in\>\<bbb-C\>((z))>, its realization
    <with|mode|math|<wide|g|^><rsub|i>> in the convolution model with
    critical time <with|mode|math|z<rsub|i>=z<rsup|1/k<rsub|i>>=z<rsup|q<rsub|i>/p<rsub|i>>>
    is a function in <with|mode|math|<sqrt|\<zeta\><rsub|i>|q<rsub|i>>>.
    Consequently, <with|mode|math|\<Sigma\><rsub|\<b-k\>,\<b-alpha\><rsup|\<less\>>,\<b-alpha\><rsup|\<gtr\>>>=\<Sigma\><rsub|\<b-k\>,\<b-beta\><rsup|\<less\>>,\<b-beta\><rsup|\<gtr\>>>>
    whenever <with|mode|math|\<b-alpha\>> and <with|mode|math|\<b-beta\>> are
    equivalent. At this point we have shown that <with|mode|math|f> is
    meromorphic at <with|mode|math|z<rsub|i>>. But a function which is
    meromorphic at all points of the Riemann sphere
    <with|mode|math|\<bbb-C\>\<cup\>{\<upl\>\<infty\>}> is actually a
    rational function. It follows that <with|mode|math|f\<in\>\<cal-F\>>.
  </proof>

  <\remark>
    Theorem <reference|as-galois-th> is essentially due to Ramis
    <cite|Ram85b|MR91>. Our presentation is a more constructive version of
    the one from <cite|MR91>. Notice that both proofs by Ramis crucially
    build upon calle's theory of resurgent functions and
    accelero-summability. In the Fuchsian case, <abbr|i.e.> in absence of
    divergence, the result is due to Schlesinger <cite|Schl95|Schl97>.
  </remark>

  <\remark>
    We have tried to keep our exposition as short as possible by considering
    only ``directional Stokes-morphisms''. In fact, calle's theory of
    resurgent functions gives a more fine-grained control over what happens
    in the convolution model by considering the <em|pointed alien
    derivatives><nbsp><with|mode|math|<wide|\<Delta\>|\<dot\>><rsub|\<omega\>>>
    for <with|mode|math|\<omega\>\<in\><wide|\<bbb-C\>|\<dot\>>>. Modulo the
    identification of functions in the formal model, the convolution models
    and the geometric model via accelero-summation, the pointed alien
    derivatives commute with the usual derivation
    <with|mode|math|\<partial\>>. Consequently, if <with|mode|math|f> is a
    solution to <with|mode|math|L f=0>, then we also have <with|mode|math|L
    <wide|\<Delta\>|\<dot\>><rsub|\<omega\>> f=0>. In particular, given the
    canonical basis of solutions <with|mode|math|\<b-h\><rsup|0>> to
    <with|mode|math|L f=0>, there exists a unique matrix
    <with|mode|math|B<rsub|\<omega\>>> with

    <\equation*>
      <wide|\<Delta\>|\<dot\>><rsub|\<omega\>>
      \<b-h\><rsup|0>=B<rsub|\<omega\>>*\<b-h\><rsup|0>.
    </equation*>

    This equation is called the <em|bridge equation>. Since
    <with|mode|math|<wide|f|^><rsub|i>> admits only a finite number of
    singularities and the alien derivations ``translate singularities'', we
    have <with|mode|math|<wide|\<Delta\>|\<dot\>><rsub|\<omega\>><rsup|l>
    \<b-h\><rsup|0>=0> for some<nbsp><with|mode|math|l>, so the matrices
    <with|mode|math|B<rsub|\<omega\>>> are nilpotent. More generally, if
    <with|mode|math|\<omega\><rsub|1>,\<ldots\>,\<omega\><rsub|r>\<in\>\<bbb-C\><rsup|\<neq\>>>
    are <with|mode|math|\<bbb-N\>>-linearly independent, then all elements in
    the algebra generated by <with|mode|math|B<rsub|\<omega\><rsub|1>>,\<ldots\>,B<rsub|\<omega\><rsub|r>>>
    are nilpotent.

    It is easily shown that the Stokes morphisms correspond to the
    exponentials <with|mode|math|\<mathe\><rsup|<wide|\<Delta\>|\<dot\>><rsub|\<theta\>>>>
    of directional Alien derivations <with|mode|math|<wide|\<Delta\>|\<dot\>><rsub|\<theta\>>=<big|sum><rsub|\<omega\>\<in\>\<mathe\><rsup|\<theta\>*\<mathi\>>*\<bbb-R\><rsup|\<gtr\>>><wide|\<Delta\>|\<dot\>><rsub|\<omega\>>>.
    This yields a way to reinterpret the Stokes matrices in terms of the
    <with|mode|math|B<rsub|\<omega\>>> with<nbsp><with|mode|math|\<omega\>\<in\>\<mathe\><rsup|\<theta\>*\<mathi\>>*\<bbb-R\><rsup|\<gtr\>>>.
    In particular, the preceding discussion implies that the Stokes matrices
    are unipotent. \ The extra flexibility provided by pointwise over
    directional alien derivatives admits many applications, such as the
    preservation of realness<nbsp><cite|Men96>. For further details, see
    <cite|Ec85|Ec87|Ec92|Ec93>.
  </remark>

  <subsection|Effective complex numbers>

  A complex number <with|mode|math|z> is said to be <em|effective> if there
  exists an <em|approximation algorithm> for<nbsp><with|mode|math|z> which
  takes <with|mode|math|\<varepsilon\>\<in\>\<bbb-N\><rsup|\<gtr\>>*2<rsup|\<bbb-Z\>>>
  on input and which returns an <em|<with|mode|math|\<varepsilon\>>-approximation>
  <with|mode|math|<wide|z|~>\<in\>(\<bbb-Z\>+\<mathi\>*\<bbb-Z\>)*2<rsup|\<bbb-Z\>>>
  of <with|mode|math|z> for which <with|mode|math|\|<wide|z|~>-<no-break>z\|\<less\><no-break>\<varepsilon\>>.
  The <em|time complexity> of this approximation algorithm is the time
  <with|mode|math|T(d)> it takes to compute a
  <with|mode|math|2<rsup|-d>>-approximation for <with|mode|math|z>. It is not
  hard to show that the set <with|mode|math|\<bbb-C\><rsup|eff>> of effective
  complex numbers forms a field. However, given
  <with|mode|math|z\<in\>\<bbb-C\><rsup|eff>> the question whether
  <with|mode|math|z=0> is undecidable. The following theorems were proved in
  <cite|CC90|vdH:hol|vdH:singhol>.

  <\theorem>
    <label|eff-hol>Let <with|mode|math|L\<in\>\<bbb-Q\><rsup|alg>(z)[\<partial\>]>,
    <with|mode|math|z<rsub|0>\<in\>\<bbb-Q\><rsup|alg>\<setminus\>\<cal-S\>>,
    <with|mode|math|\<b-v\>\<in\>(\<bbb-Q\><rsup|alg>)<rsup|n>> and
    <with|mode|math|f=\<b-v\>\<cdot\>\<b-h\><rsup|z<rsub|0>>>. Given a broken
    line path \ <with|mode|math|\<gamma\>=z<rsub|0>\<rightarrow\>\<cdots\>\<rightarrow\>z<rsub|k>>
    on <with|mode|math|\<bbb-C\><rsup|eff>\<setminus\>\<cal-S\>>, we have

    <\enumerate-alpha>
      <item>The value <with|mode|math|f(\<gamma\>)> of the analytic
      continuation of <with|mode|math|f> at the end-point of
      <with|mode|math|\<gamma\>> is effective.

      <item>There exists an approximation algorithm of time complexity
      <with|mode|math|<with|mode|math|O(d*log<rsup|3> d*log<rsup|2> log d)>>
      for<nbsp><with|mode|math|f(\<gamma\>)>, when not counting the
      approximation time of the input data <with|mode|math|L>,
      <with|mode|math|\<gamma\>> and <with|mode|math|\<b-v\>>.

      <item>There exists an algorithm which computes an approximation
      algorithm for <with|mode|math|f(\<gamma\>)> as in (<em|b>) as a
      function of <with|mode|math|L>, <with|mode|math|\<gamma\>> and
      <with|mode|math|\<b-v\>>.
    </enumerate-alpha>
  </theorem>

  <\theorem>
    <label|eff-singhol>Let <with|mode|math|L\<in\>\<bbb-Q\><rsup|alg>(z)[\<partial\>]>
    be regular singular in <with|mode|math|0>. Let
    <with|mode|math|z<rsub|0>\<in\>\<bbb-Q\><rsup|alg>\<setminus\>\<cal-S\>>,
    <with|mode|math|\<b-v\>\<in\>(\<bbb-Q\><rsup|alg>)<rsup|n>> and
    <with|mode|math|f=\<b-v\>\<cdot\>\<b-h\><rsup|z<rsub|0>>>. Then
    <with|mode|math|f(z)> is well-defined for all sufficiently small
    <with|mode|math|\<gamma\>> on the effective Riemann surface
    <with|mode|math|<wide|\<bbb-C\>|\<dot\>><rsup|eff>> of
    <with|mode|math|log> above <with|mode|math|\<bbb-C\><rsup|eff>>, and

    <\enumerate-alpha>
      <item><with|mode|math|f(\<gamma\>)> is effective.

      <item>There exists an approximation algorithm of time complexity
      <with|mode|math|<with|mode|math|O(d*log<rsup|3> d*log<rsup|2> log d)>>
      for<nbsp><with|mode|math|f(\<gamma\>)>, when not counting the
      approximation time of the input data <with|mode|math|L>,
      <with|mode|math|\<gamma\>> and <with|mode|math|\<b-v\>>.

      <item>There exists an algorithm which computes an approximation
      algorithm for <with|mode|math|f(\<gamma\>)> as in (<em|b>) as a
      function of <with|mode|math|L>, <with|mode|math|\<gamma\>> and
      <with|mode|math|\<b-v\>>.
    </enumerate-alpha>
  </theorem>

  <yes-indent>In general, the approximation of <with|mode|math|f(\<gamma\>)>
  involves the existence of certain bounds. In each of the above theorems,
  the assertion (<em|c>) essentially states that there exists an algorithm
  for computing these bounds as a function of the input data. This property
  does not merely follow from (<em|a>) and (<em|b>) alone.

  The following theorem has been proved in <cite|vdH:reshol>.

  <\theorem>
    <label|eff-reshol>Let <with|mode|math|L\<in\>\<bbb-Q\><rsup|alg>(z)[\<partial\>]>
    be singular in <with|mode|math|0>. Let <with|mode|math|\<b-k\>> be as in
    theorem <reference|as-basis-cor> and <with|mode|math|\<Gamma\>={(\<b-k\>,<no-break>\<b-alpha\>,<no-break>z)\<in\>dom<rsub|as>
    \<b-h\><rsup|0>:\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|p>,z\<in\>\<bbb-C\><rsup|eff>}>.
    Given <with|mode|math|f=\<b-v\>\<cdot\>*\<b-h\><rsup|0>> with
    <with|mode|math|\<b-v\>\<in\>(\<bbb-C\><rsup|eff>)<rsup|n>> and
    <with|mode|math|\<gamma\>\<in\>\<Gamma\>>, we have

    <\enumerate-alpha>
      <item><with|mode|math|f(\<gamma\>)> is effective.

      <item>There exists an approximation algorithm of time complexity
      <with|mode|math|<with|mode|math|O(d*log<rsup|4> d*log log d)>>
      for<nbsp><with|mode|math|f(\<gamma\>)>, when not counting the
      approximation time of the input data <with|mode|math|L>,
      <with|mode|math|\<gamma\>> and <with|mode|math|\<b-v\>>.

      <item>There exists an algorithm which computes an approximation
      algorithm for <with|mode|math|f(\<gamma\>)> as in (<em|b>) as a
      function of <with|mode|math|L>, <with|mode|math|\<gamma\>> and
      <with|mode|math|\<b-v\>>.
    </enumerate-alpha>
  </theorem>

  <yes-indent>If we replace <with|mode|math|\<bbb-Q\><rsup|alg>> by an
  arbitrary effective algebraically closed subfield
  <with|mode|math|\<bbb-K\>> of <with|mode|math|\<bbb-C\><rsup|eff>>, then
  the assertions (<em|a>) and (<em|c>) in the three above theorems remain
  valid (see<nbsp><cite|vdH:effan|vdH:maj> in the cases of theorems
  <reference|eff-hol> and <reference|eff-singhol>), but the complexity in
  (<em|b>) usually drops back to<nbsp><with|mode|math|O(d<rsup|2>*log<rsup|O(1)>
  d)>. Notice also that we may replace<nbsp><with|mode|math|f(\<gamma\>)> by
  the transition matrix along <with|mode|math|\<gamma\>> in each of the
  theorems. The following theorem summarizes the results from section
  <reference|prelim-sec>.

  <\theorem>
    <label|gal-gen-th>Let <with|mode|math|\<bbb-K\>> be an effective
    algebraically closed constant field of
    <with|mode|math|\<bbb-C\><rsup|eff>>. Then there exists an algorithm
    which takes <with|mode|math|L\<in\>\<bbb-K\>(z)[\<partial\>]> and
    <with|mode|math|z<rsub|0>\<in\>\<bbb-K\>\<cup\>{\<infty\>}> on input, and
    which computes a finite set <with|mode|math|\<cal-M\>\<subseteq\><value|Mat>(\<bbb-C\><rsup|eff>)>,
    such that

    <\enumerate-alpha>
      <item>The group <with|mode|math|\<cal-G\><rsub|L,\<b-h\><rsup|z<rsub|0>>>>
      is generated by <with|mode|math|\<cal-M\>> as a closed algebraic
      subgroup of <with|mode|math|<value|Mat><rsub|n>(\<bbb-C\>)>.

      <item>If <with|mode|math|\<bbb-K\>=\<bbb-Q\><rsup|alg>>, then the
      entries of the matrices in <with|mode|math|\<cal-M\>> have time
      complexity <with|mode|math|O(d*log<rsup|4> d*log log d)>.
    </enumerate-alpha>
  </theorem>

  <\proof>
    It is classical that the set <with|mode|math|\<bbb-C\><rsup|eff>> of
    effective complex numbers forms a field. Similarly, the set
    <with|mode|math|\<bbb-C\><rsup|fast>> of effective complex numbers with
    an approximation algorithm of time complexity
    <with|mode|math|O(d*log<rsup|4> d*log log d)> forms a field, since the
    operations <with|mode|math|<op|+>>, <with|mode|math|<op|->>,
    <with|mode|math|<op|\<times\>>> and <with|mode|math|/> can all be
    performed in time <with|mode|math|O(d*log d*log log d)>. In particular,
    the classes of matrices with entries in
    <with|mode|math|\<bbb-C\><rsup|eff>> <abbr|resp.>
    <with|mode|math|\<bbb-C\><rsup|fast>> are stable under the same
    operations. Now in the algorithm <verbatim|Compute_generators>, we may
    take broken-line paths with vertices above <with|mode|math|\<bbb-K\>> for
    the <with|mode|math|\<gamma\><rsub|i>>. Hence (<em|a>) and (<em|b>)
    follow from theorem <reference|eff-reshol>(<em|a>) <abbr|resp.> (<em|b>)
    and the above observations.
  </proof>

  <yes-indent>Given <with|mode|math|\<varepsilon\>\<in\>\<bbb-N\><rsup|\<gtr\>>*2<rsup|\<bbb-Z\>>>,
  we may endow <with|mode|math|\<bbb-C\><rsup|eff>> with an approximate
  zero-test for which <with|mode|math|z=0> if and only if
  <with|mode|math|\|z\|\<less\>\<varepsilon\>>. We will denote this field by
  <with|mode|math|\<bbb-C\><rsup|\<approx\>\<varepsilon\>>>. Clearly, this
  zero-test is not compatible with the field structure of
  <with|mode|math|\<bbb-C\><rsup|eff>>. Nevertheless, any finite computation,
  which can be carried out in <with|mode|math|\<bbb-C\><rsup|eff>> with an
  oracle for zero-testing, can be carried out in exactly the same way in
  <with|mode|math|\<bbb-C\><rsup|\<approx\>\<varepsilon\>>> for a
  sufficiently small <with|mode|math|\<varepsilon\>>. Given
  <with|mode|math|z\<in\>\<bbb-C\><rsup|eff>>, we will denote by
  <with|mode|math|z<rsup|\<approx\>\<varepsilon\>>\<in\>\<bbb-C\><rsup|\<approx\>\<varepsilon\>>>
  the ``cast'' of <with|mode|math|z> to <with|mode|math|\<bbb-C\><rsup|\<approx\>\<varepsilon\>>>
  and similarly for matrices with coefficients in
  <with|mode|math|\<bbb-C\><rsup|eff>>.

  <\remark>
    In practice <cite|vdH:effreal>, effective complex numbers
    <with|mode|math|z> usually come with a natural
    bound<nbsp><with|mode|math|M\<in\>\<bbb-N\><rsup|\<gtr\>>*2<rsup|\<bbb-Z\>>>
    for <with|mode|math|\|z\|>. Then, given
    <with|mode|math|\<varepsilon\>\<in\>\<bbb-N\><rsup|\<gtr\>>*2<rsup|\<bbb-Z\>>>
    with <with|mode|math|\<varepsilon\>\<less\>1>, it is even better to use
    the approximate zero-test <with|mode|math|z=0> if and only if
    <with|mode|math|\|z\|\<less\>\<varepsilon\>*M>. Notice that the bound
    <with|mode|math|M> usually depends on the internal representation of
    <with|mode|math|z> and not merely on <with|mode|math|z> as a number in
    <with|mode|math|\<bbb-C\><rsup|eff>>.
  </remark>

  <section|Factoring linear differential operators><label|factor-sec>

  Let <with|mode|math|\<bbb-K\>> be an effective algebraically closed
  subfield of <with|mode|math|\<bbb-C\><rsup|eff>>. Consider a monic linear
  differential operator <with|mode|math|L=\<partial\><rsup|n>+L<rsub|n-1>*\<partial\>+\<cdots\>+L<rsub|0>\<in\>\<cal-F\>[\<partial\>]>,
  where <with|mode|math|\<cal-F\>=\<bbb-K\>(z)>. In this section, we present
  an algorithm for finding a non-trivial factorization
  <with|mode|math|L=K<rsub|1>*K<rsub|2>> with
  <with|mode|math|K<rsub|1>,K<rsub|2>\<in\>\<cal-F\>[\<partial\>]> whenever
  such a factorization exists.

  <subsection|Factoring <with|mode|math|L> and invariant subspaces under
  <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>>>

  Let <with|mode|math|\<b-h\>=(h<rsub|1>,\<ldots\>,h<rsub|n>)\<in\>\<cal-K\><rsup|n>>
  be a basis of solutions for the equation <with|mode|math|L f=0>, where
  <with|mode|math|\<cal-K\>\<supseteq\>\<cal-F\>> is <with|mode|math|>an
  abstract differential field. We denote the Wronskian of
  <with|mode|math|\<b-h\>> by

  <\equation*>
    W<rsub|\<b-h\>>=W<rsub|h<rsub|1>,\<ldots\>,h<rsub|n>>=<det|<tformat|<table|<row|<cell|h<rsub|1>>|<cell|\<cdots\>>|<cell|h<rsub|n>>>|<row|<cell|\<vdots\>>|<cell|>|<cell|\<vdots\>>>|<row|<cell|h<rsub|1><rsup|(n-1)>>|<cell|\<cdots\>>|<cell|h<rsub|n><rsup|(n-1)>>>>>>.
  </equation*>

  It is classical (and easy to check) that

  <\equation>
    <label|lde-by-wronskian>L f=<frac|W<rsub|f,h<rsub|1>,\<ldots\>,h<rsub|n>>|W<rsub|h<rsub|1>,\<ldots\>,h<rsub|n>>>.
  </equation>

  When expanding the determinant <with|mode|math|W<rsub|f,h<rsub|1>,\<ldots\>,h<rsub|n>>>
  in terms of the matrices

  <\equation*>
    W<rsub|i>=W<rsub|\<b-h\>,i>=<det|<tformat|<table|<row|<cell|h<rsub|1>>|<cell|\<cdots\>>|<cell|h<rsub|n>>>|<row|<cell|\<vdots\>>|<cell|>|<cell|\<vdots\>>>|<row|<cell|h<rsub|1><rsup|(n-i-1)>>|<cell|\<cdots\>>|<cell|h<rsub|n><rsup|(n-i-1)>>>|<row|<cell|h<rsub|1><rsup|(n-i+1)>>|<cell|\<cdots\>>|<cell|h<rsub|n><rsup|(n-i+1)>>>|<row|<cell|\<vdots\>>|<cell|>|<cell|\<vdots\>>>|<row|<cell|h<rsub|1><rsup|(n-1)>>|<cell|\<cdots\>>|<cell|h<rsub|n><rsup|(n-1)>>>>>>,
  </equation*>

  it follows that

  <\equation*>
    L=\<partial\><rsup|n>-<frac|W<rsub|1>|W<rsub|0>>*\<partial\><rsup|n-1>+\<cdots\>+(\<um\>1)<rsup|n>*<frac|W<rsub|n>|W<rsub|0>>.
  </equation*>

  Denoting by <with|mode|math|\<varphi\><rprime|\<dag\>>> the logarithmic
  derivative of <with|mode|math|\<varphi\>>, it can also be checked by
  induction that

  <\equation*>
    <wide|L|~>=<left|(|3>\<partial\>-<left|(><frac|W<rsub|h<rsub|1>,\<ldots\>,h<rsub|n>>|W<rsub|h<rsub|1>,\<ldots\>,h<rsub|n-1>>><right|)><rprime|\<dag\>><right|)|3>*\<cdots\>*<left|(|3>\<partial\>-<left|(><frac|W<rsub|h<rsub|1>,h<rsub|2>>|W<rsub|h<rsub|1>>><right|)><rprime|\<dag\>><right|)|3>*(\<partial\>-W<rsub|h<rsub|1>><rprime|\<dag\>>)
  </equation*>

  admits <with|mode|math|h<rsub|1>,\<ldots\>,h<rsub|n>> as solutions, whence
  <with|mode|math|<wide|L|~>=L>, using Euclidean division in the skew
  polynomial ring <with|mode|math|\<cal-F\>[\<partial\>]>.

  <\proposition>
    <label|fact-prop>

    <\enumerate-alpha>
      <item>If <with|mode|math|L> admits a factorization
      <with|mode|math|L=K<rsub|1>*K<rsub|2>>, then
      <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>> leaves <with|mode|math|ker
      K<rsub|2>> invariant.

      <item>If <with|mode|math|V> is an invariant subvector space of
      <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>>, then <with|mode|math|L>
      admits a factorization <with|mode|math|L=<no-break>K<rsub|1>*K<rsub|2>>
      with <with|mode|math|V=ker K<rsub|2>>.
    </enumerate-alpha>
  </proposition>

  <\proof>
    Assume that <with|mode|math|L> admits a factorization
    <with|mode|math|L=K<rsub|1>*K<rsub|2>>. Then, given
    <with|mode|math|f\<in\>ker K<rsub|2>> and
    <with|mode|math|M\<in\>\<cal-G\><rsub|L,\<b-h\>>>, we have
    <with|mode|math|K<rsub|2>*f=0=M*K<rsub|2> f=K<rsub|2>*M*f>, whence
    <with|mode|math|M*f\<in\>ker K<rsub|2>>. Conversely, assume that
    <with|mode|math|V> is an invariant subvector space of
    <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>> and let
    <with|mode|math|\<b-g\>> be a basis of <with|mode|math|V>. Then we
    observe that <with|mode|math|M*W<rsub|\<b-g\>,i>=(det
    M)*W<rsub|\<b-g\>,i>> for all <with|mode|math|i>. Consequently,

    <\equation*>
      M*<frac|W<rsub|\<b-g\>,i>|W<rsub|\<b-g\>,0>>=<frac|W<rsub|\<b-g\>,i>|W<rsub|\<b-g\>,0>>
    </equation*>

    for all <with|mode|math|i>, so that <with|mode|math|W<rsub|\<b-g\>,i>/W<rsub|\<b-g\>,0>\<in\>\<cal-F\>>,
    by corollary <reference|rat-inv-cor>. Hence

    <\equation>
      <label|K2-eq>K<rsub|2>=\<partial\><rsup|r>-<frac|W<rsub|\<b-g\>,1>|W<rsub|\<b-g\>,0>>*\<partial\><rsup|r-1>+\<cdots\>+(\<um\>1)<rsup|r>*<frac|W<rsub|\<b-g\>,r>|W<rsub|\<b-g\>,0>>
    </equation>

    is a differential operator with coefficients in
    <with|mode|math|\<cal-F\>> which vanishes on <with|mode|math|V>. But this
    is only possible if <with|mode|math|K<rsub|2>> divides
    <with|mode|math|L>.
  </proof>

  <subsection|A lemma from linear algebra>

  <\lemma>
    <label|nil-diag-lem>Let <with|mode|math|\<cal-A\>> be a non-unitary
    algebra of nilpotent matrices in <with|mode|math|<value|Mat><rsub|n>(\<bbb-K\>)>.
    Then there exists a basis of <with|mode|math|\<bbb-K\><rsup|n>> in which
    <with|mode|math|M> is lower triangular for all
    <with|mode|math|M\<in\>\<cal-A\>>.
  </lemma>

  <\proof>
    Let <with|mode|math|M\<in\>\<cal-A\>> be a matrix such that
    <with|mode|math|V=im M> is a non-zero vector space of minimal dimension.
    Given <with|mode|math|\<b-v\>\<in\>V> and
    <with|mode|math|N\<in\>\<cal-A\>>, we claim that <with|mode|math|N
    \<b-v\>\<in\>ker M>. Assume the contrary, so that
    <with|mode|math|0\<neq\>M*N*\<b-v\>\<in\>im M*N\<subseteq\>V>. By the
    minimality hypothesis, we must have <with|mode|math|im M*N=V>. In
    particular, <with|mode|math|\<b-v\>\<in\>im M*N> and
    <with|mode|math|0\<neq\>M*N*\<b-v\>\<in\>im M*N*M*N>. Again by the
    minimality hypothesis, it follows that <with|mode|math|im M*N*M*N=V>. In
    other words, the restriction of <with|mode|math|M*N> to
    <with|mode|math|V> is an isomorphism on <with|mode|math|V>. Hence
    <with|mode|math|M*N> admits a non-zero eigenvector in <with|mode|math|V>,
    which contradicts the fact that <with|mode|math|M*N> is nilpotent.

    Let us now prove the lemma by induction over <with|mode|math|n>. If
    <with|mode|math|n\<leqslant\>1> or <with|mode|math|\<cal-A\>=0>, then we
    have nothing to do, so assume that <with|mode|math|n\<gtr\>1> and
    <with|mode|math|\<cal-A\>\<neq\>0>. We claim that
    <with|mode|math|\<bbb-K\><rsup|n>> admits a non-trivial invariant
    subvector space <with|mode|math|W>. Indeed, we may take
    <with|mode|math|W=V> if <with|mode|math|\<cal-A\>*V=0> and
    <with|mode|math|W=\<cal-A\>*V> if <with|mode|math|\<cal-A\>*V\<neq\>0>.
    Now consider a basis <with|mode|math|(\<b-b\><rsub|m+1>,\<ldots\>,\<b-b\><rsub|n>)>
    of <with|mode|math|W> and complete it to a basis
    <with|mode|math|(\<b-b\><rsub|1>,\<ldots\>,\<b-b\><rsub|n>)> of
    <with|mode|math|\<bbb-K\><rsup|n>>. Then each matrix in
    <with|mode|math|\<cal-A\>> is lower triangular with respect to this
    basis. Let <with|mode|math|\<cal-A\><rsub|1>>
    and<nbsp><with|mode|math|\<cal-A\><rsub|2>> be the algebras of lower
    dimensional matrices which occur as upper left <abbr|resp.> lower right
    blocks of matrices in <with|mode|math|\<cal-A\>>. We conclude by applying
    the induction hypothesis on <with|mode|math|\<cal-A\><rsub|1>> and
    <with|mode|math|\<cal-A\><rsub|2>>.
  </proof>

  Let <with|mode|math|\<cal-M\>> be a finite set of non-zero nilpotent
  matrices. If all matrices in the <with|mode|math|\<bbb-K\>>-algebra<nbsp><with|mode|math|\<cal-A\>>
  generated by <with|mode|math|\<cal-M\>> are nilpotent, then it is easy to
  compute a basis for which all matrices in <with|mode|math|\<cal-M\>> are
  lower triangular. Indeed, setting <with|mode|math|K<rsub|i>=<big|cap><rsub|M\<in\>\<cal-M\><rsup|i>>ker
  M> for all <with|mode|math|i>, we first compute a basis of
  <with|mode|math|K<rsub|1>>. We successively complete this basis into a
  basis of <with|mode|math|K<rsub|2>>, <with|mode|math|K<rsub|3>> and so on
  until <with|mode|math|K<rsub|p>=\<bbb-K\><rsup|n>>.

  If not all matrices in <with|mode|math|\<cal-A\>> are nilpotent, then the
  proof of lemma <reference|nil-diag-lem> indicates a method for the
  computation of a matrix in <with|mode|math|\<cal-A\>> which is not
  nilpotent. Indeed, we start by picking an <with|mode|math|M\<in\>\<cal-M\>>
  and set <with|mode|math|V\<assign\>im M<rsup|p-1>>, where
  <with|mode|math|p> is smallest with <with|mode|math|M<rsup|p>=0>. We next
  set <with|mode|math|\<cal-N\>\<assign\>\<cal-M\>\<setminus\>{M}> and
  iterate the following loop. Take a matrix <with|mode|math|N\<in\>\<cal-N\>>
  and distinguish the following three cases:

  <\description>
    <item*|<with|mode|math|M*N*V=0>>Set <with|mode|math|\<cal-N\>\<assign\>\<cal-N\>\<setminus\>{N}>
    and continue.<no-page-break>

    <item*|<with|mode|math|0\<varsubsetneq\>M*N*V\<varsubsetneq\>V>>Set
    <with|mode|math|M\<assign\>M*N*M>, <with|mode|math|V\<assign\>im M> and
    continue.<no-page-break>

    <item*|<with|mode|math|M*N*V=V>>Return the non-nilpotent matrix
    <with|mode|math|M*N>.
  </description>

  At the end of our loop, we either found a non-nilpotent matrix, or we have
  <with|mode|math|N*V\<subseteq\>ker M> for all
  <with|mode|math|N\<in\>\<cal-M\>>. In the second case, we obtain a
  non-trivial invariant subspace of <with|mode|math|\<bbb-K\><rsup|n>> as in
  the proof of lemma <reference|nil-diag-lem> and we recursively apply the
  algorithm on this subspace and a complement. In fact, the returned matrix
  is not even <em|monopotent> (<abbr|i.e.> not of the form
  <with|mode|math|\<lambda\>+N>, where <with|mode|math|N> is a nilpotent
  matrix), since it both admits zero and a non-zero number as eigenvalues.

  <subsection|Computation of non-trivial invariant subspaces>

  Proposition <reference|fact-prop> in combination with theorem
  <reference|gal-gen-th> implies that the factorization of linear
  differential operators in <with|mode|math|\<cal-F\>[\<partial\>]> reduces
  to the computation of non-trivial invariant subvector spaces under the
  action of <with|mode|math|\<cal-M\><rsub|L,\<b-h\>>> whenever they exist.

  In this section, we will first solve a slightly simpler problem: assuming
  that <with|mode|math|\<bbb-K\>> is an effective algebraically closed field
  and given a<nbsp>finite set of matrices
  <with|mode|math|\<cal-M\>\<subseteq\><value|Mat><rsub|n>(\<bbb-K\>)>, we
  will show how to compute a non-trivial invariant subspace
  <with|mode|math|V> of <with|mode|math|\<bbb-K\><rsup|n>> under the action
  of<nbsp><with|mode|math|\<cal-M\>>, whenever such a <with|mode|math|V>
  exists.

  <paragraph|Good candidate vectors <with|mode|math|\<b-v\>>>Given a vector
  <with|mode|math|\<b-v\>\<in\>\<bbb-K\><rsup|n>> it is easy to compute the
  smallest subspace <with|mode|math|<value|Inv><rsub|\<cal-M\>>(\<b-v\>)> of
  <with|mode|math|\<bbb-K\><rsup|n>> which is invariant under the action of
  <with|mode|math|\<cal-M\>> and which contains<nbsp><with|mode|math|\<b-v\>>.
  Indeed, starting with a basis <with|mode|math|\<cal-B\>={\<b-v\>}>, we keep
  enlarging <with|mode|math|\<cal-B\>> with elements in
  <with|mode|math|\<cal-M\>*\<cal-B\>\<setminus\><value|Vect>(\<cal-B\>)>
  until saturation. Since <with|mode|math|\<cal-B\>> will never contain more
  than <with|mode|math|n> elements, this algorithm terminates. A
  <em|candidate vector> <with|mode|math|\<b-v\>\<in\>\<bbb-K\><rsup|n>> for
  generating a non-trivial invariant subspace
  of<nbsp><with|mode|math|\<bbb-K\><rsup|n>> is said to be <em|good> if
  <with|mode|math|0\<less\>dim <value|Inv><rsub|\<cal-M\>>(\<b-v\>)\<less\>n>.

  <paragraph|The <with|mode|math|\<bbb-K\>>-algebra generated by
  <with|mode|math|\<cal-M\>>>We notice that
  <with|mode|math|V\<subseteq\>\<bbb-K\><rsup|n>> is an invariant subspace
  for<nbsp><with|mode|math|\<cal-M\>>, if and only if <with|mode|math|V> is
  an invariant subspace for the <with|mode|math|\<bbb-K\>>-algebra
  <with|mode|math|<value|Alg>(\<cal-M\>)> generated
  by<nbsp><with|mode|math|\<cal-M\>>. Again it is easy to compute a basis for
  <with|mode|math|<value|Alg>(\<cal-M\>)>. We start with a basis
  <with|mode|math|\<cal-B\>> of <with|mode|math|<value|Vect>(\<cal-M\>)> and
  keep adjoining elements in <with|mode|math|\<cal-B\><rsup|2>\<setminus\><value|Vect>(\<cal-B\>)>
  to <with|mode|math|\<cal-B\>> until saturation. We will avoid the explicit
  basis of <with|mode|math|<value|Alg>(\<cal-M\>)>, which may contain as much
  as <with|mode|math|n<rsup|2>> elements, and rather focus on the efficient
  computation of good candidate vectors.

  <paragraph|<with|mode|math|\<cal-M\>>-splittings>A decomposition
  <with|mode|math|\<bbb-K\><rsup|n>=E<rsub|1>\<oplus\>\<cdots\>\<oplus\>E<rsub|k>>,
  where <with|mode|math|E<rsub|1>,\<ldots\>,E<rsub|k>> are non-empty vector
  spaces, will be called an <em|<with|mode|math|\<cal-M\>>-splitting> of
  <with|mode|math|\<bbb-K\><rsup|n>>, if the projections
  <with|mode|math|P<rsub|i>=P<rsub|E<rsub|i>>> of
  <with|mode|math|\<bbb-K\><rsup|n>> on <with|mode|math|E<rsub|i>> are all in
  <with|mode|math|<value|Alg>(\<cal-M\>)>. Then, given
  <with|mode|math|M\<in\><value|Mat><rsub|n>(\<bbb-K\>)>, we have
  <with|mode|math|M\<in\><value|Alg>(\<cal-M\>)> if and only if
  <with|mode|math|P<rsub|i>*M*P<rsub|j>\<in\><value|Alg>(\<cal-M\>)> for
  all<nbsp><with|mode|math|i,j>. If we choose a basis for
  <with|mode|math|\<bbb-K\><rsup|n>> which is a union of bases for the
  <with|mode|math|E<rsub|i>>, we notice that the
  <with|mode|math|P<rsub|i>*M*P<rsub|j>> are <with|mode|math|dim
  E<rsub|i>\<times\>dim E<rsub|j>> block matrices. In the above algorithm for
  computing the <with|mode|math|\<bbb-K\>>-algebra generated by
  <with|mode|math|\<cal-M\>> it now suffices to compute with block matrices
  of this form. In particular, the computed basis of
  <with|mode|math|<value|Alg>(\<cal-M\>)> will consist of such matrices. The
  trivial decomposition <with|mode|math|\<bbb-K\><rsup|n>=\<bbb-K\><rsup|n>>
  is clearly an <with|mode|math|\<cal-M\>>-splitting. Given
  <with|mode|math|N\<in\><value|Alg>(\<cal-M\>)>, we notice that any
  <with|mode|math|{N}>-splitting is also an
  <with|mode|math|\<cal-M\>>-<no-break>splitting.

  <paragraph|Refining <with|mode|math|\<cal-M\>>-splittings>An
  <with|mode|math|\<cal-M\>>-splitting <with|mode|math|\<bbb-K\><rsup|n>=F<rsub|1>\<oplus\>\<cdots\>\<oplus\>F<rsub|l>>
  is said to be <em|finer> than the <with|mode|math|\<cal-M\>>-splitting
  <with|mode|math|\<bbb-K\><rsup|n>=E<rsub|1>\<oplus\>\<cdots\>\<oplus\>E<rsub|k>>
  if <with|mode|math|E<rsub|i>> is a direct sum of a subset of the
  <with|mode|math|F<rsub|j>> for each <with|mode|math|i>. Given an
  <with|mode|math|><with|mode|math|\<cal-M\>>-splitting
  <with|mode|math|\<bbb-K\><rsup|n>=F<rsub|1>\<oplus\>\<cdots\>\<oplus\>F<rsub|l>>
  and an arbitrary element <with|mode|math|M\<in\><value|Alg>(\<cal-M\>)>, we
  may obtain a finer <em|<with|mode|math|\<cal-M\>>-splitting <abbr|w.r.t>
  <with|mode|math|M>> as follows. Let <with|mode|math|i\<in\>{1,\<ldots\>,k}>
  and consider <with|mode|math|M<rsub|i>=P<rsub|i>*M*P<rsub|i>>. If
  <with|mode|math|\<lambda\><rsub|1>,\<ldots\>,<no-break>\<lambda\><rsub|p>>
  are the eigenvalues of <with|mode|math|M<rsub|i>>, then
  <with|mode|math|E<rsub|i>=ker (M<rsub|i>-\<lambda\><rsub|1>)<rsup|n<rsub|i>>\<oplus\>\<cdots\>\<oplus\>ker
  (M<rsub|i>-\<lambda\><rsub|k>)<rsup|n<rsub|i>>> is an
  <with|mode|math|(P<rsub|i>*\<cal-M\>*P<rsub|i>)>-splitting of
  <with|mode|math|E<rsub|i>>, where <with|mode|math|n<rsub|i>=dim E<rsub|i>>.
  Collecting these <with|mode|math|(P<rsub|i>*\<cal-M\>*P<rsub|i>)>-splittings,
  we obtain a finer <with|mode|math|\<cal-M\>>-splitting
  <with|mode|math|F<rsub|1>\<oplus\>\<cdots\>\<oplus\>F<rsub|l>> of
  <with|mode|math|\<bbb-K\><rsup|n>>. This
  <with|mode|math|\<cal-M\>>-splitting, which is said to be <em|refined
  <abbr|w.r.t.> <with|mode|math|M>>, has the property that
  <with|mode|math|P<rsub|F<rsub|i>>*M*P<rsub|F<rsub|i>>> is monopotent on
  <with|mode|math|F<rsub|i>> for each<nbsp><with|mode|math|i>, with unique
  eigenvalue<nbsp><with|mode|math|\<lambda\><rsub|M,F<rsub|i>>>.

  <vspace*|1fn>We now have the following algorithm for computing non-trivial
  <with|mode|math|\<cal-M\>>-invariant subspaces of
  <with|mode|math|\<bbb-K\><rsup|n>> when they exist.

  <\algorithm|Invariant_subspace>
    <\with|mode|math>
      (\<cal-M\>)<with|mode|text|<no-page-break>>
    </with>

    <strong|Input:> a set of non-zero matrices in
    <with|mode|math|<value|Mat><rsub|n>(\<bbb-K\>)><no-page-break>

    <strong|Output:> an <with|mode|math|\<cal-M\>>-invariant subspace of
    <with|mode|math|\<bbb-K\><rsup|n>> or <strong|fail><no-page-break>

    <\body>
      <item*|Step 1.>[Initial <with|mode|math|\<cal-M\>>-splitting]<no-page-break>

      <\indent>
        Compute a ``random non-zero element'' <with|mode|math|N> of
        <with|mode|math|<value|Alg>(\<cal-M\>)><no-page-break>

        Compute an <with|mode|math|\<cal-M\>>-splitting
        <with|mode|math|\<bbb-K\><rsup|n>=E<rsub|1>\<oplus\>\<cdots\>\<oplus\>E<rsub|k>>
        <abbr|w.r.t.> <with|mode|math|N> and each
        <with|mode|math|M\<in\>\<cal-M\>><no-page-break>

        <with|mode|math|\<cal-D\>\<assign\>\<varnothing\>>
      </indent>

      <item*|Step 2.>[One dimensional components]<no-page-break>

      <\indent>
        For every <with|mode|math|E<rsub|i>> with <with|mode|math|dim
        E<rsub|i>=1> and <with|mode|math|E<rsub|i>\<nin\>\<cal-D\>>, do the
        following:<no-page-break>

        <\indent>
          Pick a <with|mode|math|\<b-v\>\<in\>E<rsub|i><rsup|\<neq\>>> and
          compute <with|mode|math|<value|Inv><rsub|\<cal-M\>>(\<b-v\>)><no-page-break>

          If <with|mode|math|<value|Inv><rsub|\<cal-M\>>(\<b-v\>)\<varsubsetneq\>\<bbb-K\><rsup|n>>
          then return <with|mode|math|<value|Inv><rsub|\<cal-M\>>(\<b-v\>)><no-page-break>

          Otherwise, set <with|mode|math|\<cal-D\>\<assign\>\<cal-D\>\<cup\>E<rsub|i>><no-page-break>
        </indent>

        If <with|mode|math|dim E<rsub|i>=1> for all <with|mode|math|i> then
        return <strong|fail>
      </indent>

      <item*|Step 3.>[Higher dimensional components]<no-page-break>

      <\indent>
        Let <with|mode|math|i> be such that <with|mode|math|dim
        E<rsub|i>\<gtr\>1><no-page-break>

        Let <with|mode|math|\<cal-M\><rsub|i>\<assign\>{P<rsub|i>*(M-\<lambda\><rsub|M,E<rsub|i>>)*P<rsub|i>:M\<in\>\<cal-M\>}><no-page-break>

        Let <with|mode|math|K<rsub|i>\<assign\>E<rsub|i>\<cap\><big|cap><rsub|M\<in\>\<cal-M\><rsub|i>>ker
        M><no-page-break>

        If <with|mode|math|K<rsub|i>=0> then go to step 4 and otherwise to
        step 5
      </indent>

      <item*|Step 4.>[Non-triangular case]<no-page-break>

      <\indent>
        Let <with|mode|math|N\<in\><value|Alg>(\<cal-M\><rsub|i>)> be
        non-monopotent on <with|mode|math|E<rsub|i>> (cf. previous
        section)<no-page-break>

        Refine the <with|mode|math|\<cal-M\>>-splitting <abbr|w.r.t.>
        <with|mode|math|N> and return to step 2
      </indent>

      <item*|Step 5.>[Potentially triangular case]<no-page-break>

      <\indent>
        Choose <with|mode|math|\<b-v\>\<in\>K<rsub|i>> and compute
        <with|mode|math|<value|Inv><rsub|\<cal-M\>>(\<b-v\>)><no-page-break>

        If <with|mode|math|<value|Inv><rsub|\<cal-M\>>(\<b-v\>)\<varsubsetneq\>\<bbb-K\><rsup|n>>
        then return <with|mode|math|<value|Inv><rsub|\<cal-M\>>(\<b-v\>)><no-page-break>

        Otherwise, let <with|mode|math|N> be in
        <with|mode|math|<value|Alg>(\<cal-M\>)> with
        <with|mode|math|P<rsub|i>*N*\<b-v\>\<nin\>K<rsub|i>><no-page-break>

        Refine the <with|mode|math|\<cal-M\>>-splitting <abbr|w.r.t.>
        <with|mode|math|N><no-page-break>

        If this yields a finer <with|mode|math|\<cal-M\>>-splitting then
        return to step 2<no-page-break>

        Otherwise, set <with|mode|math|\<cal-M\>\<assign\>\<cal-M\>\<cup\>{N}>
        and repeat step 5
      </indent>
    </body>
  </algorithm>

  The algorithm needs a few additional explanations. In step
  <with|mode|math|1>, we may take <with|mode|math|N> to be an arbitrary
  element in <with|mode|math|\<cal-M\>>. However, it is better to take a
  ``small random expression in the elements of <with|mode|math|\<cal-M\>>''
  for <with|mode|math|N>. With high probability, this yields an
  <with|mode|math|\<cal-M\>>-splitting which will not need to be refined in
  the sequel. Indeed, the subset of matrices in
  <with|mode|math|<value|Alg>(\<cal-M\>)> which yield non-maximal
  <with|mode|math|\<cal-M\>>-<no-break>splittings is a closed algebraic
  subset of measure zero, since it is determined by coinciding eigenvalues.
  In particular, given an <with|mode|math|\<cal-M\>>-splitting
  <with|mode|math|\<bbb-K\><rsup|n>=E<rsub|1>\<oplus\>\<cdots\>\<oplus\>E<rsub|k>>
  <abbr|w.r.t.><nbsp><with|mode|math|N>, it will usually suffice to check
  that each <with|mode|math|M\<in\>\<cal-M\>> is monopotent on
  each<nbsp><with|mode|math|E<rsub|i>>, in order to obtain an
  <with|mode|math|\<cal-M\>>-splitting <abbr|w.r.t.> the other elements in
  <with|mode|math|\<cal-M\>>.

  Throughout the algorithm, the <with|mode|math|\<cal-M\>>-splitting gets
  finer and finer, so the <with|mode|math|\<cal-M\>>-splitting ultimately
  remains constant. From this point on, the space <with|mode|math|K<rsub|i>>
  can only strictly decrease in step <with|mode|math|5>, so
  <with|mode|math|K<rsub|i>> also remains constant, ultimately. But then we
  either find a non-trivial invariant subspace in step 5, or all components
  of the <with|mode|math|\<cal-M\>>-splitting become one-dimensional. In the
  latter case, we either obtain a non-trivial invariant subspace in step 1,
  or a proof that <with|mode|math|<value|Inv><rsub|\<cal-M\>>(\<b-v\>)=\<bbb-K\><rsup|n>>
  for every <with|mode|math|\<b-v\>\<in\>E<rsub|1><rsup|\<neq\>>\<cup\>\<cdots\>\<cup\><no-break>E<rsub|n><rsup|\<neq\>>>
  (and thus for every <with|mode|math|\<b-v\>\<in\>\<bbb-K\><rsup|n>\<setminus\>0>).

  <\remark>
    <label|inv-subsp-rem>Assume that <with|mode|math|\<bbb-K\>> is no longer
    an effective algebraically closed field, but rather a field
    <with|mode|math|\<bbb-C\><rsup|\<approx\>\<varepsilon\>>> with an
    approximate zero-test. In that case, we recall that a number which is
    approximately zero is not necessarily zero. On the other hand, a number
    which is not approximately zero is <em|surely> non-zero. Consequently, in
    our algorithm for the computation of <with|mode|math|<value|Inv>(\<b-v\>)>,
    the dimension of <with|mode|math|<value|Inv>(\<b-v\>)> can be too small,
    but it is never too large. In particular, if the algorithm
    <verbatim|Invariant_subspace> fails, then the approximate proof that
    <with|mode|math|<value|Inv><rsub|\<cal-M\>>(\<b-v\>)=\<bbb-K\><rsup|n>>
    for every <with|mode|math|\<b-v\>\<in\>E<rsub|1><rsup|\<neq\>>\<cup\>\<cdots\>\<cup\><no-break>E<rsub|n><rsup|\<neq\>>>
    yields a genuine proof that there are no non-trivial invariant subspaces.
  </remark>

  <subsection|Factoring linear differential operators><label|factor-alg-sec>

  Putting together the results from the previous sections, we now have the
  following algorithm for finding a right factor of <with|mode|math|L>.

  <\algorithm|Right_factor>
    <with|mode|math|(L)><no-page-break>

    <strong|Input:> <with|mode|math|L=\<partial\><rsup|n>+L<rsub|n-1>*\<partial\><rsup|n-1>+\<cdots\>+L<rsub|0>\<in\>\<bbb-K\>(z)[\<partial\>]><no-page-break>

    <strong|Output:> a non-trivial right-factor of <with|mode|math|L> or
    <strong|fail><no-page-break>

    <\body>
      <item*|Step 1.>[Compute generators]<no-page-break>

      <\indent>
        Choose <with|mode|math|z<rsub|0>\<in\>\<bbb-K\>\<setminus\>\<cal-S\>>
        and let <with|mode|math|\<b-h\>=\<b-h\><rsup|z<rsub|0>>><no-page-break>

        Compute a finite set <with|mode|math|\<cal-M\>\<subseteq\><value|GL><rsub|n>(\<bbb-C\><rsup|eff>)>
        of generators for <with|mode|math|\<cal-G\><rsub|L,\<b-h\>>>
        (<abbr|cf.> theorem <reference|gal-gen-th>)
      </indent>

      <item*|Step 2.>[Initial precision]<no-page-break>

      <\indent>
        <with|mode|math|T\<assign\>max(deg L<rsub|0>,\<ldots\>,deg
        L<rsub|n-1>)+1><no-page-break>

        <with|mode|math|\<delta\>\<assign\>2<rsup|\<um\>32>><no-page-break>

        <strong|while> <with|mode|math|\<delta\><rprime|'>\<assign\>min{M<rsub|i,j>/M<rsub|i<rprime|'>,j<rprime|'>>:M\<in\>\<cal-M\>,M<rsub|i<rprime|'>,j<rprime|'>><rsup|\<approx\>\<delta\>/2<rsup|T>>\<neq\>0}\<less\>\<delta\>>
        <strong|do> <with|mode|math|\<delta\>\<assign\>\<delta\><rprime|'>><no-page-break>

        <with|mode|math|\<varepsilon\>\<assign\>\<delta\>/2<rsup|T>>
      </indent>

      <item*|Step 3.>[Produce invariant subspace]<no-page-break>

      <\indent>
        Let <with|mode|math|V\<assign\><with|mode|text|<verbatim|Invariant_subspace>>(\<cal-M\><rsup|\<approx\>\<varepsilon\>>)><no-page-break>

        If <with|mode|math|V=<with|mode|text|<strong|fail>>> then return
        <strong|fail><no-page-break>

        Let <with|mode|math|B\<in\><value|Mat><rsub|n,r>(\<bbb-C\><rsup|\<approx\>\<varepsilon\>>)>
        be a column basis of <with|mode|math|V><no-page-break>

        Let <with|mode|math|\<b-g\>\<assign\><lsup|t<space|0.6spc>>B*\<b-h\>\<in\>([\<bbb-C\><rsup|eff>]<rsup|\<approx\>\<varepsilon\>>[[z]]<rsup|eff>)<rsup|r>>
      </indent>

      <item*|Step 4.>[Produce and check guess]<no-page-break>

      <\indent>
        Let <with|mode|math|K\<assign\>\<partial\><rsup|r>-<frac|W<rsub|\<b-g\>,1>|W<rsub|\<b-g\>,0>>*\<partial\><rsup|r-1>+\<cdots\>+(\<um\>1)<rsup|r>*<frac|W<rsub|\<b-g\>,r>|W<rsub|\<b-g\>,0>>><no-page-break>

        Divide <with|mode|math|L> by <with|mode|math|K>, producing
        <with|mode|math|Q,R\<in\>[\<bbb-C\><rsup|\<approx\>\<varepsilon\>>((z))]<rsup|eff>[\<partial\>]>
        with <with|mode|math|L=Q*K+R><no-page-break>

        If <with|mode|math|R\<neq\>0 mod z<rsup|T>> then go to step
        5<no-page-break>

        Reconstruct <with|mode|math|<wide|Q|~>,<wide|K|~>\<in\>\<bbb-K\>(z)[\<partial\>]>
        from <with|mode|math|Q> and <with|mode|math|K> with precision
        <with|mode|math|(\<varepsilon\>,T)><no-page-break>

        If we obtain no good approximations or
        <with|mode|math|L\<neq\><wide|Q|~>*<wide|K|~>> then go to step
        5<no-page-break>

        Return <with|mode|math|<wide|K|~>>
      </indent>

      <item*|Step 5.>[Increase precision]<no-page-break>

      <\indent>
        <with|mode|math|T\<assign\>2*T><no-page-break>

        <with|mode|math|\<varepsilon\>\<assign\>\<delta\>/2<rsup|T>><no-page-break>

        Go to step 3
      </indent>
    </body>
  </algorithm>

  The main idea behind the algorithm is to use proposition
  <reference|fact-prop> in combination with <verbatim|Invariant_subspace> so
  as to provide good candidate right factors of <with|mode|math|L> in
  <with|mode|math|\<bbb-C\><rsup|eff>((z))[\<partial\>]>. Using
  reconstruction of coefficients in <with|mode|math|\<bbb-K\>(z)> from
  Laurent series in <with|mode|math|\<bbb-C\><rsup|eff>((z))> with increasing
  precisions, we next produce good candidate right factors in
  <with|mode|math|\<bbb-K\>(z)>. We keep increasing the precision until we
  find a right factor or a proof that <with|mode|math|L> is irreducible. Let
  us detail the different steps a bit more:

  <\description>
    <item*|Step 2>We will work with power series approximations of
    <with|mode|math|T> terms and approximate zero-tests in
    <with|mode|math|\<bbb-C\><rsup|\<approx\>\<varepsilon\>>>. The degree of
    a rational function <with|mode|math|P/Q> is defined by
    <with|mode|math|deg P/Q=max (deg P,deg Q)>. The initial precisions
    <with|mode|math|T> and <with|mode|math|\<um\>log \<varepsilon\>> have
    been chosen as small as possible. Indeed, we want to take advantage of a
    possible quick answer when computing with a small precision (see also the
    explanations below of step 5).

    <item*|Step 3>If <verbatim|Invariant_subspace> fails, then there exists
    no factorization of <with|mode|math|L>, by
    remark<nbsp><reference|inv-subsp-rem>. Effective power series and Laurent
    series are defined in a similar way as effective real numbers (in
    particular, we don't assume the existence of an effective zero-test).
    Efficient algorithm for such computations are described in
    <cite|vdH:relax>.

    <item*|Step 4>The reconstruction of <with|mode|math|<wide|Q|~>> and
    <with|mode|math|<wide|K|~>> from <with|mode|math|Q> and
    <with|mode|math|K> contains two ingredients: we use Pad approximation to
    find rational function approximations of degree
    <with|mode|math|<op|\<leqslant\>> T> and the LLL-algorithm to approximate
    numbers <with|mode|math|\<bbb-C\><rsup|\<approx\>\<varepsilon\>>> by
    numbers in<nbsp><with|mode|math|\<bbb-K\>>.

    <item*|Step 5>Doubling the precision at successive steps heuristically
    causes the computation time to increase geometrically at each step. In
    particular, unsuccessful computations at lower precisions don't take much
    time with respect to the last successful computation with respect to the
    required precision. Instead of multiplying the precisions by two, we also
    notice that it would be even better to increase by a factor which doubles
    the estimated computation time at each step. Of course, this would
    require a more precise complexity analysis of the algorithm.
  </description>

  The problem of reconstructing elements in <with|mode|math|\<bbb-K\>> from
  elements in <with|mode|math|\<bbb-C\><rsup|\<approx\>\<varepsilon\>>> is an
  interesting topic on its own. In theory, one may consider the polynomial
  algebra over <with|mode|math|\<bbb-Z\>> generated by all coefficients
  occurring in <with|mode|math|L> and the number <with|mode|math|z> we wish
  to reconstruct. We may then apply the LLL-algorithm <cite|LLL82> on the
  lattice spanned by <with|mode|math|<sqrt|T>> monomials of smallest total
  degree (for instance) and search for minimal
  <with|mode|math|<op|\<leqslant\>> <sqrt|T>>-digit relations. If
  <with|mode|math|\<bbb-K\>=\<bbb-Q\><rsup|alg>> is the algebraic closure of
  <with|mode|math|\<bbb-Q\>>, then we may simply use the lattice spanned by
  the first <with|mode|math|n> powers of <with|mode|math|z>.

  At a sufficiently large precision <with|mode|math|T>, the LLL-algorithm
  will ultimately succeed for all coefficients of a candidate factorization
  which need to be reconstructed. If there are no factorizations, then the
  algorithm will ultimately fail at step 3. This proofs the termination of
  <verbatim|Right_factor>.

  <\remark>
    In practice, and especially if <with|mode|math|\<bbb-K\>\<neq\>\<bbb-Q\><rsup|alg>>,
    it would be nice to use more of the structure of the original problem.
    For instance, a factorization of <with|mode|math|L> actually yields
    relations on the coefficients which we may try to use. For high precision
    computations, it is also recommended to speed the LLL-algorithm up using
    a similar dichotomic algorithm as for fast <abbr|g.c.d.> computations
    <cite|Moe73|PW02>.
  </remark>

  <\remark>
    Notice that we did not use bounds for the degrees of coefficients of
    possible factors in our algorithm. If a bound <with|mode|math|T<rsup|B>>
    is available, using techniques from <cite|BBeuk85|vH97b|vdPS03>, then one
    may take <with|mode|math|T\<assign\>min(2*T,T<rsup|B>)> instead of
    <with|mode|math|T\<assign\>2*T> in step 5. Of course, bounds for the
    required precision <with|mode|math|\<varepsilon\>> are even harder to
    obtain. See <cite|BBeuk85> for some results in that direction.
  </remark>

  <section|Computing differential Galois groups><label|galgr-sec>

  <subsection|Introduction>

  Throughout this section, <with|mode|math|\<bbb-F\>> will stand for the
  field <with|mode|math|\<bbb-C\><rsup|\<approx\>\<varepsilon\>>> of
  effective complex number with the approximate zero-test at precision
  <with|mode|math|\<varepsilon\>\<gtr\>0>. This field has the following
  properties:

  <\description>
    <item*|EH1>We have an effective zero-test in
    <with|mode|math|\<bbb-F\>>.<no-page-break>

    <item*|EH2>There exists an algorithm which takes on input
    <with|mode|math|\<b-c\>\<in\>(\<bbb-F\><rsup|\<neq\>>)<rsup|n>> and which
    computes a finite set of generators for the
    <with|mode|math|\<bbb-Z\>>-vector space of integers
    <with|mode|math|\<b-k\>\<in\>\<bbb-Z\><rsup|n>>
    with<nbsp><with|mode|math|\<b-c\><rsup|\<b-k\>>=1>.

    <item*|EH3>There exists an algorithm which takes on input
    <with|mode|math|\<b-c\>\<in\>\<bbb-F\><rsup|n>> and which computes a
    finite set of generators for the <with|mode|math|\<bbb-Z\>>-vector space
    of integers <with|mode|math|\<b-k\>\<in\>\<bbb-Z\><rsup|n>> with
    <with|mode|math|\<b-c\>\<cdot\>\<b-k\>=0>.<no-page-break>

    <item*|EH4><with|mode|math|\<bbb-F\>> is closed under exponentiation and
    logarithm.
  </description>

  Indeed, we obtain <strong|EH2> and <strong|EH3> using the LLL-algorithm.
  Some of the results in this section go through when only a subset of the
  conditions are satisfied. In that case, we notice that
  <strong|EH2><with|mode|math|\<Rightarrow\>><strong|EH1>,
  <strong|EH3><with|mode|math|\<Rightarrow\>><strong|EH1> and
  <strong|EH4><with|mode|math|\<Rightarrow\>>(<strong|EH2><with|mode|math|\<Leftrightarrow\>><strong|EH3>).

  Given a finite set of matrices <with|mode|math|\<cal-M\>\<subseteq\><value|GL><rsub|n>(\<bbb-F\>)>,
  we give a numerical algorithm for the computation of the smallest closed
  algebraic subgroup <with|mode|math|\<cal-G\>=\<langle\>\<cal-M\>\<rangle\>>
  of <with|mode|math|<value|GL><rsub|n>(\<bbb-F\>)> which
  contains<nbsp><with|mode|math|\<cal-M\>>. We will represent
  <with|mode|math|\<cal-G\>> by a finite set
  <with|mode|math|\<cal-F\>\<subseteq\><value|GL><rsub|n>(\<bbb-F\>)> and the
  finite basis <with|mode|math|\<cal-B\>\<subseteq\><value|GL>(\<bbb-F\>)> of
  a Lie algebra<nbsp><with|mode|math|\<cal-L\>> over
  <with|mode|math|\<bbb-C\>>, such that

  <\equation*>
    \<cal-G\>=\<cal-F\>*\<mathe\><rsup|\<cal-L\>>,
  </equation*>

  and each <with|mode|math|N\<in\>\<cal-F\>> corresponds to a unique
  connected component <with|mode|math|N*\<mathe\><rsup|\<cal-L\>>=\<mathe\><rsup|\<cal-L\>>*N>
  of<nbsp><with|mode|math|\<cal-G\>>. We will also prove that there exists a
  precision <with|mode|math|\<varepsilon\><rsub|0>> such that the algorithm
  yields the theoretically correct result for all
  <with|mode|math|\<varepsilon\>\<less\>\<varepsilon\><rsub|0>>.

  <subsection|The algebraic group generated by a diagonal matrix>

  Let <with|mode|math|<value|Tor><rsub|n>(\<bbb-F\>)> be the group of
  invertible diagonal matrices. Each matrix <with|mode|math|M> has the form
  <with|mode|math|M=Diag(\<b-alpha\>)>, where
  <with|mode|math|\<b-alpha\>=(\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|n>)>
  is the vector in <with|mode|math|(\<bbb-F\><rsup|\<neq\>>)<rsup|n>> of the
  elements on the diagonal of <with|mode|math|M>. The coordinate ring
  <with|mode|math|\<cal-R\>> of <with|mode|math|<value|Tor><rsub|n>(\<bbb-F\>)>
  is the set <with|mode|math|\<bbb-F\>[\<b-alpha\>,\<b-alpha\><rsup|\<um\>1>]>
  of Laurent polynomials in <with|mode|math|\<b-alpha\>>.

  Now consider the case when <with|mode|math|\<cal-M\>> consists of a single
  diagonal matrix <with|mode|math|M=Diag(\<b-lambda\>)>. Let
  <with|mode|math|\<frak-i\>\<subseteq\>\<cal-R\>> be the ideal which defines
  <with|mode|math|\<langle\>M\<rangle\>\<subseteq\><value|Tor><rsub|n>(\<bbb-F\>)>.
  Given a relation <with|mode|math|\<b-lambda\><rsup|\<b-k\>>=1<space|1.2spc>(\<b-k\>\<in\>\<bbb-Z\><rsup|n>)>
  between the<nbsp><with|mode|math|\<lambda\><rsub|i>>, any power
  <with|mode|math|M<rsup|i>=Diag(\<b-lambda\><rsup|i>)> satisfies the same
  relation <with|mode|math|(\<b-lambda\><rsup|i>)<rsup|\<b-k\>>=1>, whence
  <with|mode|math|\<b-alpha\><rsup|\<b-k\>>-1\<in\>\<frak-i\>>. Let
  <with|mode|math|\<frak-j\>> be the ideal generated by all
  <with|mode|math|\<b-alpha\><rsup|\<b-k\>>-1>, such that
  <with|mode|math|\<b-lambda\><rsup|\<b-k\>>=1>.

  <\lemma>
    <label|diag-lem>We have <with|mode|math|\<frak-j\>=\<frak-i\>>.
  </lemma>

  <\proof>
    We already observed that <with|mode|math|\<frak-j\>\<subseteq\>\<frak-i\>>.
    Assuming for contradiction that <with|mode|math|\<frak-j\>\<neq\>\<frak-i\>>,
    choose

    <\equation*>
      f=<big|sum><rsub|i=1><rsup|r>f<rsub|i>*\<b-alpha\><rsup|\<b-k\><rsub|i>>\<in\>\<frak-i\>\<setminus\>\<frak-j\>
    </equation*>

    such that <with|mode|math|r> is minimal. If <with|mode|math|i\<neq\>j>,
    then <with|mode|math|\<b-lambda\><rsup|\<b-k\><rsub|i>-\<b-k\><rsub|j>>\<neq\>1>,
    since otherwise <with|mode|math|\<b-lambda\><rsup|\<b-k\><rsub|i>-\<b-k\><rsub|j>>\<in\>\<frak-j\>>
    and <with|mode|math|f-f<rsub|i>*\<b-alpha\><rsup|\<b-k\><rsub|i>>+f<rsub|i>*\<b-alpha\><rsup|\<b-k\><rsub|j>>\<in\>\<frak-i\>\<setminus\>\<frak-j\>>
    has less than <with|mode|math|r> terms. In particular, the vectors
    <with|mode|math|(1,\<b-lambda\><rsup|\<b-k\><rsub|i>>,\<ldots\>,\<b-lambda\><rsup|(r-1)*\<b-k\><rsub|i>>)>
    with <with|mode|math|i\<in\>{1,\<ldots\>,r}> are linearly independent.
    But this contradicts the fact that <with|mode|math|f(\<b-lambda\><rsup|j>)=<big|sum><rsub|i=1><rsup|r>f<rsub|i>*\<b-lambda\><rsup|j*\<b-k\><rsub|i>>=0>
    for all <with|mode|math|j\<in\>{0,\<ldots\>,r-1}>.
  </proof>

  By <strong|EH2>, we may compute a minimal finite set
  <with|mode|math|\<b-g\><rsub|1>,\<ldots\>,\<b-g\><rsub|p>> of generators
  for the <with|mode|math|\<bbb-Z\>>-vector space of
  <with|mode|math|\<b-k\>\<in\>\<bbb-Z\><rsup|n>> with
  <with|mode|math|\<b-lambda\><rsup|\<b-k\>>=1>. We may also compute a basis
  <with|mode|math|\<cal-B\>> for <with|mode|math|ker \<varphi\>>, where
  <with|mode|math|\<varphi\>:\<bbb-Z\><rsup|n>\<rightarrow\>\<bbb-Z\><rsup|p>;\<b-k\>\<mapsto\>(\<b-k\>\<cdot\>\<b-g\><rsub|1>,\<ldots\>,\<b-k\>\<cdot\>\<b-g\><rsub|p>)>.
  Then<nbsp><with|mode|math|\<mathe\><rsup|\<cal-L\>>=\<mathe\><rsup|<value|Vect>(\<cal-B\>)>>
  is the connected component of <with|mode|math|\<langle\>M\<rangle\>>, since
  <with|mode|math|(\<mathe\><rsup|\<cal-L\>>)<rsup|\<b-g\><rsub|i>>=1> for
  all <with|mode|math|i>, and <with|mode|math|\<cal-L\>> cannot be further
  enlarged while conserving this property.

  Let <with|mode|math|\<cal-V\>=(\<b-g\><rsub|1>*\<bbb-Q\>\<oplus\>\<cdots\>\<oplus\>\<b-g\><rsub|p>*\<bbb-Q\>)\<cap\>\<bbb-Z\><rsup|n>>.
  We construct a basis <with|mode|math|\<b-h\><rsub|1>,\<ldots\>,\<b-h\><rsub|n>>
  of <with|mode|math|\<bbb-Z\><rsup|n>>, by taking
  <with|mode|math|\<b-h\><rsub|i>> to be shortest in
  <with|mode|math|\<cal-V\>> (if <with|mode|math|i\<leqslant\>p>) or
  <with|mode|math|\<bbb-Z\><rsup|n>> (if <with|mode|math|i\<gtr\>p>), such
  that <with|mode|math|\<b-h\><rsub|i>\<nin\><value|Vect>(\<b-h\><rsub|1>,\<ldots\>,\<b-h\><rsub|i-1>)>.
  This basis determines a toric change of coordinates
  <with|mode|math|\<b-alpha\>\<rightarrow\>\<b-alpha\><rsup|P>> with
  <with|mode|math|P\<in\><value|GL><rsub|n>(\<bbb-Z\>)> such that
  <with|mode|math|\<b-g\><rsub|1>,\<ldots\>,\<b-g\><rsub|p>\<in\>\<bbb-Z\><rsup|p>\<times\>0<rsup|n-p>>
  with respect to the new coordinates. Similarly, we may construct a basis
  <with|mode|math|\<b-b\><rsub|1>,\<ldots\>,\<b-b\><rsub|p>> of
  <with|mode|math|\<bbb-Z\><rsup|p>>, by taking each
  <with|mode|math|\<b-b\><rsub|i>> to be shortest in
  <with|mode|math|\<bbb-Z\><rsup|p>\<setminus\><value|Vect>(\<b-b\><rsub|1>,\<ldots\>,\<b-b\><rsub|i-1>)>
  such that <with|mode|math|r<rsub|i>=min
  {r\<in\>\<bbb-N\><rsup|\<gtr\>>:r*\<b-b\><rsub|i>\<in\>\<bbb-Z\>*\<b-g\><rsub|1>\<oplus\>\<cdots\>\<oplus\>\<bbb-Z\>*\<b-g\><rsub|p>}>
  is maximal. This basis determines a second toric change of coordinates
  <with|mode|math|\<b-alpha\>\<rightarrow\>\<b-alpha\><rsup|Q>> with
  <with|mode|math|Q\<in\><value|GL><rsub|n>(\<bbb-Z\>)> such that
  <with|mode|math|\<b-g\><rsub|i>=r<rsub|i>*\<b-e\><rsub|i>>
  (<with|mode|math|i=1,\<ldots\>,p>) with respect to the new coordinates.

  After the above changes of coordinates, the ideal
  <with|mode|math|\<frak-j\>> is determined by the equations
  <with|mode|math|\<alpha\><rsub|1><rsup|r<rsub|1>>=\<cdots\>=\<alpha\><rsub|p><rsup|r<rsub|p>>=1>.
  Setting

  <\equation*>
    \<cal-F\>={(\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*s<rsub|1>/r<rsub|1>>,\<ldots\>,\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*s<rsub|p>/r<rsub|p>>,1,\<ldots\>,1):\<b-s\>\<in\>\<bbb-N\><rsup|p>,s<rsub|1>\<less\>r<rsub|1>,\<ldots\>,s<rsub|p>\<less\>r<rsub|p>},
  </equation*>

  it follows that <with|mode|math|\<langle\>M\<rangle\>=\<cal-F\>*\<mathe\><rsup|\<cal-L\>>>.
  Rewriting <with|mode|math|\<cal-F\>> with respect to the original
  coordinates now completes the computation of
  <with|mode|math|\<langle\>M\<rangle\>>.

  <subsection|The algebraic group generated by a single matrix>

  Let us now consider the case when <with|mode|math|\<cal-M\>> consists of a
  single arbitrary matrix <with|mode|math|M>. Then we first compute the
  multiplicative Jordan decomposition of <with|mode|math|M>. Modulo a change
  of basis of <with|mode|math|\<bbb-F\><rsup|n>>, this means that

  <\equation*>
    M=D*U=U*D,
  </equation*>

  where <with|mode|math|D=M<rsub|s>> and <with|mode|math|U=M<rsub|u>> are the
  <em|semi-simple> and <em|unipotent> parts of <with|mode|math|M>:

  <\equation*>
    D=<matrix|<tformat|<table|<row|<cell|\<lambda\><rsub|1>*I<rsub|n<rsub|1>>>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<ddots\>>|<cell|>>|<row|<cell|>|<cell|>|<cell|\<lambda\><rsub|k>*I<rsub|n<rsub|k>>>>>>>,U=<matrix|<tformat|<table|<row|<cell|J<rsub|n<rsub|1>>>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<ddots\>>|<cell|>>|<row|<cell|>|<cell|>|<cell|J<rsub|n<rsub|k>>>>>>>,
  </equation*>

  where

  <\equation*>
    J<rsub|n>=<matrix|<tformat|<table|<row|<cell|1>|<cell|1>|<cell|>|<cell|>>|<row|<cell|>|<cell|1>|<cell|\<ddots\>>|<cell|>>|<row|<cell|>|<cell|>|<cell|\<ddots\>>|<cell|1>>|<row|<cell|>|<cell|>|<cell|>|<cell|1>>>>>.
  </equation*>

  <\proposition>
    We have <with|mode|math|\<langle\>U\<rangle\>={exp(\<mu\>*log
    U):\<mu\>\<in\>\<bbb-F\>}.>
  </proposition>

  <\remark*>
    Notice that <with|mode|math|f(N)=<big|sum><rsub|i=0><rsup|\<infty\>>f<rsub|i>*N<rsup|i>=<big|sum><rsub|i=0><rsup|n-1>f<rsub|i>*N<rsup|i>>
    is well-defined for power series <with|mode|math|f\<in\>\<bbb-F\>[[z]]>
    and nilpotent matrices <with|mode|math|N\<in\><value|Mat><rsub|n>(\<bbb-F\>)>;
    in this case, <with|mode|math|f=(1+z)<rsup|\<mu\>>> and
    <with|mode|math|N=U-1>.
  </remark*>

  <\proof>
    The assertion is clear if <with|mode|math|U=I<rsub|n>>, so assume
    <with|mode|math|U\<neq\>I<rsub|n>>. Let
    <with|mode|math|\<cal-X\>={exp(\<mu\>*log U):\<mu\>\<in\>\<bbb-F\>}>. We
    clearly have <with|mode|math|\<langle\>U\<rangle\>\<subseteq\>\<cal-X\>>,
    since <with|mode|math|\<cal-X\>> is a closed algebraic group which
    contains <with|mode|math|U>. Moreover, the set
    <with|mode|math|U,U<rsup|2>,U<rsup|3>,\<ldots\>> is infinite, so
    <with|mode|math|dim \<langle\>U\<rangle\>\<geqslant\>1>. Since
    <with|mode|math|\<cal-X\>> is irreducible and <with|mode|math|dim
    \<cal-X\>=1>, we conclude that <with|mode|math|\<langle\>U\<rangle\>=\<cal-X\>>.
  </proof>

  <\proposition>
    We have <with|mode|math|\<langle\>M\<rangle\>=\<langle\>D\<rangle\>*\<langle\>U\<rangle\>>.
  </proposition>

  <\proof>
    Since <with|mode|math|\<langle\>M\<rangle\>> is a commutative group,
    <cite-detail|Hum81|Theorem 15.5> implies that
    <with|mode|math|\<langle\>M\<rangle\>=\<langle\>M\<rangle\><rsub|s>*\<langle\>M\<rangle\><rsub|u>>,
    where <with|mode|math|\<langle\>M\<rangle\><rsub|s>={N<rsub|s>:N\<in\>\<langle\>M\<rangle\>}>
    and <with|mode|math|\<langle\>M\<rangle\><rsub|u>={N<rsub|u>:N\<in\>\<langle\>M\<rangle\>}>
    are closed subgroups of <with|mode|math|\<langle\>M\<rangle\>>. Now
    <with|mode|math|\<langle\>D\<rangle\>> and
    <with|mode|math|\<langle\>U\<rangle\>> are closed subgroups of
    <with|mode|math|\<langle\>M\<rangle\><rsub|s>> <abbr|resp.>
    <with|mode|math|\<langle\>M\<rangle\><rsub|u>>, so
    <with|mode|math|\<langle\>D\<rangle\>*\<langle\>U\<rangle\>> is a closed
    subgroup of <with|mode|math|\<langle\>M\<rangle\>>. Since
    <with|mode|math|M\<in\>\<langle\>D\<rangle\>*\<langle\>U\<rangle\>>, it
    follows that <with|mode|math|\<langle\>M\<rangle\>=\<langle\>D\<rangle\>*\<langle\>U\<rangle\>>.
  </proof>

  <\corollary>
    If <with|mode|math|\<langle\>D\<rangle\>=\<cal-F\>*\<mathe\><rsup|\<cal-L\>>>,
    then <with|mode|math|\<langle\>M\<rangle\>=\<cal-F\>*\<mathe\><rsup|\<cal-L\>+\<bbb-F\>*log
    U>>.
  </corollary>

  <subsection|Membership testing for the connected
  component><label|membership-sec>

  In order to compute the closure of the product of a finite number of
  algebraic groups of the form <with|mode|math|\<cal-F\>*\<mathe\><rsup|\<cal-L\>>>,
  an important subproblem is to test whether a given matrix
  <with|mode|math|M\<in\><value|GL><rsub|n>(\<bbb-F\>)> belongs to
  <with|mode|math|\<mathe\><rsup|\<cal-L\>>>.

  We first observe that <with|mode|math|M\<in\>\<mathe\><rsup|\<cal-L\>>>
  implies <with|mode|math|\<langle\>M\<rangle\>\<subseteq\>\<mathe\><rsup|\<cal-L\>>>.
  After the computation of <with|mode|math|\<cal-F\><rprime|'>> and
  <with|mode|math|\<cal-L\><rprime|'>> with
  <with|mode|math|\<langle\>M\<rangle\>=\<cal-F\><rprime|'>*\<mathe\><rsup|\<cal-L\><rprime|'>>>
  it therefore suffices to check that <with|mode|math|\<cal-L\><rprime|'>\<subseteq\>\<cal-L\>>
  and <with|mode|math|\<cal-F\><rprime|'>\<subseteq\>\<mathe\><rsup|\<cal-L\>>>.
  In fact, it suffices to check whether <with|mode|math|M<rprime|'>\<in\>\<mathe\><rsup|\<cal-L\>>>,
  where <with|mode|math|M<rprime|'>> is the unique matrix in
  <with|mode|math|\<cal-F\><rprime|'>> with
  <with|mode|math|M\<in\>M<rprime|'>*\<mathe\><rsup|\<cal-L\><rprime|'>>>.
  Modulo a suitable base change, we have thus reduced the general problem to
  the case when <with|mode|math|M> is a diagonal matrix whose eigenvalues are
  all roots of unity.

  Assume that <with|mode|math|M\<in\>\<mathe\><rsup|\<cal-L\>>> and
  <with|mode|math|\<ell\>\<in\>\<cal-L\>> are such that
  <with|mode|math|M\<in\>\<mathe\><rsup|\<bbb-C\>*\<ell\>>>. Since
  <with|mode|math|M> and <with|mode|math|\<ell\>> commute, it follows that
  <with|mode|math|M> and <with|mode|math|\<ell\>> can be diagonalized
  <abbr|w.r.t.> a common basis. The elements of this basis are elements of
  the different eigenspaces of <with|mode|math|M>. In other words, if
  <with|mode|math|M=Diag(\<lambda\><rsub|1>*I<rsub|n<rsub|1>>,\<ldots\>,\<lambda\><rsub|k>*I<rsub|n<rsub|k>>)>
  with pairwise distinct <with|mode|math|\<lambda\><rsub|i>>, then
  <with|mode|math|P<rsup|\<um\>1>*\<ell\>*P> is diagonal for some block
  matrix <with|mode|math|P=Diag(P<rsub|1>,\<ldots\>,P<rsub|k>)> with
  <with|mode|math|P<rsub|i>\<in\><value|GL><rsub|n<rsub|i>>(\<bbb-F\>)> for
  each <with|mode|math|i>. It follows that
  <with|mode|math|\<ell\>=Diag(\<ell\><rsub|1>,\<ldots\>,\<ell\><rsub|k>)>
  for certain <with|mode|math|\<ell\><rsub|i>\<in\><value|Mat><rsub|n<rsub|i>>(\<bbb-F\>)>.
  Without loss of generality, we may therefore replace
  <with|mode|math|\<cal-L\>> by the intersection of
  <with|mode|math|\<cal-L\>> with <with|mode|math|Diag(<value|Mat><rsub|n<rsub|1>>(\<bbb-F\>),\<ldots\>,<value|Mat><rsub|n<rsub|k>>(\<bbb-F\>))>.

  From now on, we assume that the above two reductions have been made. Let
  <with|mode|math|\<ell\>=Diag(\<mu\><rsub|1>,\<ldots\>,\<mu\><rsub|n>)> be a
  diagonal matrix in <with|mode|math|\<cal-L\>>. By lemma
  <reference|diag-lem>, we have <with|mode|math|M\<in\>\<mathe\><rsup|\<bbb-C\>*\<ell\>>>
  if and only if any <with|mode|math|\<bbb-Z\>>-linear relation
  <with|mode|math|\<b-l\>\<cdot\>\<b-mu\>=0> induces a relation
  <with|mode|math|\<b-lambda\><rsup|\<pi\>(\<b-l\>)>=1>, where
  <with|mode|math|\<pi\>(\<b-l\>)=(l<rsub|1>+\<cdots\>+l<rsub|n<rsub|1>>,\<ldots\>,l<rsub|n-n<rsub|k>>+\<cdots\>+l<rsub|n>)>.
  Now consider a random matrix <with|mode|math|R> in
  <with|mode|math|\<cal-L\>>, <abbr|i.e.> a linear combination of the basis
  elements with small random integer coefficients. We compute its blockwise
  Jordan normal form <with|mode|math|J=P<rsup|\<um\>1>*R*P> so that
  <with|mode|math|P\<in\>Diag(<value|GL><rsub|n<rsub|1>>(\<bbb-F\>),\<ldots\>,<value|GL><rsub|n<rsub|k>>(\<bbb-F\>))>
  and let <with|mode|math|\<ell\>> be the restriction of <with|mode|math|J>
  to the diagonal. We have <with|mode|math|M\<in\>\<mathe\><rsup|\<bbb-C\>*\<ell\>>\<Leftrightarrow\>M\<in\>\<mathe\><rsup|\<bbb-C\>*J>\<Leftrightarrow\>M=P*M*P<rsup|\<um\>1>\<in\>\<mathe\><rsup|\<bbb-C\>*R>>.
  Computing a basis for the <with|mode|math|\<bbb-Z\>>-linear relations of
  the form <with|mode|math|\<b-l\>\<cdot\>\<b-mu\>=0> using <strong|EH3>, the
  above criterion now enables us to check whether
  <with|mode|math|M\<in\>\<mathe\><rsup|\<bbb-C\>*R>>.

  If the check whether <with|mode|math|M\<in\>\<mathe\><rsup|\<bbb-C\>*R>>
  succeeds, then we are clearly done. Otherwise, since <with|mode|math|R> was
  chosen in a random way, the relation <with|mode|math|\<b-l\>\<cdot\>\<b-mu\>>
  is very likely to be satisfied for all possible choices of
  <with|mode|math|R\<in\>\<cal-L\>> (up to permutations of coordinates inside
  each block). Indeed, the<nbsp><with|mode|math|R> for which this is not the
  case lie on a countable union <with|mode|math|\<cal-U\>> of algebraic
  variety of a lower dimension, so<nbsp><with|mode|math|\<cal-U\>> has
  measure <with|mode|math|0>. Heuristically speaking, we may therefore
  conclude that <with|mode|math|M\<nin\>\<mathe\><rsup|\<cal-L\>>> if the
  check fails (at least temporarily, modulo some final checks when the
  overall computation of <with|mode|math|\<langle\>\<cal-M\>\<rangle\>> will
  be completed).

  Theoretically speaking, we may perform the above computations with
  <with|mode|math|R<rprime|'>=<op|<big|sum><rsub|B\<in\>\<cal-B\>>>
  \<alpha\><rsub|B>*B> instead of <with|mode|math|R>, where
  <with|mode|math|\<cal-B\>> is a basis of <with|mode|math|\<cal-L\>> and the
  <with|mode|math|\<alpha\><rsub|B>> are formal parameters. We then check
  whether the relation <with|mode|math|\<b-l\>\<cdot\>\<b-mu\><rprime|'>> is
  still satisfied for the analogue <with|mode|math|\<ell\><rprime|'>=Diag(\<mu\><rsub|1><rprime|'>,\<ldots\>,\<mu\><rsub|n><rprime|'>)>
  of <with|mode|math|\<ell\>>. If so, then we are sure that
  <with|mode|math|M\<nin\>\<mathe\><rsup|\<cal-L\>>>. Otherwise, we keep
  trying with other random elements of<nbsp><with|mode|math|\<cal-L\>>.

  It is likely that a more efficient theoretical algorithm can be designed
  for testing <with|mode|math|\<bbb-Z\>>-linear relations between the
  eigenvalues of elements in <with|mode|math|\<cal-L\>>. One of the referees
  suggested to use similar methods as in <cite|Mas88|Ber95|CS98>. However, we
  did not study this topic in more detail, since our final algorithm for the
  computation of Galois groups will be based on heuristics anyway. We also
  notice that a ``really good'' random number generator should actually
  <em|never> generate points which satisfy non-trivial algebraic relations.

  <subsection|Computing the closure of <with|mode|math|\<cal-M\>>><label|galgr-alg-sec>

  A Lie algebra <with|mode|math|\<cal-L\>> is said to be <em|algebraic>, if
  it is the Lie algebra of some algebraic group, <abbr|i.e.> if
  <with|mode|math|\<mathe\><rsup|\<cal-L\>>> is an algebraic subset of
  <with|mode|math|<value|GL><rsub|n>(\<bbb-F\>)>. It is classical
  <cite-detail|Bor91|Corollary 7.7> that the smallest Lie algebra generated
  by a finite number of algebraic Lie algebras is again algebraic. The Lie
  algebras we will consider in our algorithms will always assumed to be
  algebraic. Given a finite number <with|mode|math|\<cal-L\><rsub|1>,\<ldots\>,\<cal-L\><rsub|l>>
  of algebraic Lie algebras and a basis <with|mode|math|\<cal-B\>> for
  <with|mode|math|\<cal-L\><rsub|1>+\<cdots\>+\<cal-L\><rsub|l>>, it is easy
  to enrich <with|mode|math|\<cal-B\>> so that
  <with|mode|math|\<cal-L\>=<value|Vect>(\<cal-B\>)> is a Lie algebra: as
  long as <with|mode|math|[\<b-b\><rsub|1>,\<b-b\><rsub|2>]\<nin\>\<cal-L\>>
  for two elements <with|mode|math|\<b-b\><rsub|1>,\<b-b\><rsub|2>\<in\>\<cal-B\>>,
  we add <with|mode|math|[\<b-b\><rsub|1>,\<b-b\><rsub|2>]> to
  <with|mode|math|\<cal-B\>>. By what precedes, the computed Lie algebra
  <with|mode|math|\<cal-L\>> is again algebraic.

  Putting together the ingredients from the previous sections, we now have
  the following algorithm for computing the smallest closed algebraic group
  <with|mode|math|\<langle\>\<cal-M\>\<rangle\>> which
  contains<nbsp><with|mode|math|\<cal-M\>>.

  <\algorithm|Closure>
    (<with|mode|math|\<cal-M\>>)<no-page-break>

    <strong|Input: >A subset <with|mode|math|\<cal-M\>={M<rsub|1>,\<ldots\>,M<rsub|m>}>
    of <with|mode|math|<value|GL><rsub|n>(\<bbb-F\>)><no-page-break>

    <strong|Output: >a numeric approximation of
    <with|mode|math|\<langle\>\<cal-M\>\<rangle\>><no-page-break>

    <\body>
      <item*|Step 1.>[Initialize algorithm]<no-page-break>

      <\indent>
        Compute <with|mode|math|\<langle\>M<rsub|i>\<rangle\>=\<cal-F\><rsub|i>*\<mathe\><rsup|\<cal-L\><rsub|i>>>
        for each <with|mode|math|i\<in\>{1,\<ldots\>,m}><no-page-break>

        Let <with|mode|math|\<cal-F\>\<assign\>\<cal-F\><rsub|1>\<cup\>\<cdots\>\<cup\>\<cal-F\><rsub|m>>
        (notice that <with|mode|math|1\<in\>\<cal-F\>>)<no-page-break>

        Let <with|mode|math|\<cal-L\>\<assign\><value|Lie>(\<cal-L\><rsub|1>+\<cdots\>+\<cal-L\><rsub|m>)>
      </indent>

      <item*|Step 2.>[Closure]<no-page-break>

      <\indent>
        While there exists an <with|mode|math|N\<in\>\<cal-F\>\<setminus\>{1}>
        with <with|mode|math|N*\<cal-L\>*N<rsup|\<um\>1>\<nsubseteq\>\<cal-L\>>
        set <with|mode|math|\<cal-L\>\<assign\><value|Lie>(\<cal-L\>+N*\<cal-L\>*N<rsup|\<um\>1>)><no-page-break>

        While there exists an <with|mode|math|N\<in\>\<cal-F\>\<setminus\>{1}>
        with <with|mode|math|N\<in\>\<mathe\><rsup|\<cal-L\>>> set
        <with|mode|math|\<cal-F\>\<assign\>\<cal-F\>\<setminus\>{N}><no-page-break>

        While there exists <with|mode|math|N\<in\>\<cal-F\><rsup|2>> with
        <with|mode|math|N\<nin\>\<cal-F\>*\<mathe\><rsup|\<cal-L\>>>
        do<no-page-break>

        <\indent>
          Compute <with|mode|math|\<langle\>N\<rangle\>=\<cal-F\><rprime|'>*\<mathe\><rsup|\<cal-L\><rprime|'>>><no-page-break>

          If <with|mode|math|\<cal-L\><rprime|'>\<nsubseteq\>\<cal-L\>> then
          set <with|mode|math|\<cal-L\>\<assign\><value|Lie>(\<cal-L\>+\<cal-L\><rprime|'>)>,
          quit loop and repeat step 2<no-page-break>

          Otherwise, set <with|mode|math|\<cal-F\>\<assign\>\<cal-F\>\<cup\>{N}><no-page-break>
        </indent>

        Return <with|mode|math|\<cal-F\>*\<mathe\><rsup|\<cal-L\>>>
      </indent>
    </body>
  </algorithm>

  The termination of this algorithm relies on a lemma, whose proof was kindly
  communicated to the author by J.-Y. He.

  <\lemma>
    Let <with|mode|math|\<cal-H\>> be a closed algebraic subgroup of
    <with|mode|math|<value|GL><rsub|n>(\<bbb-C\>)> and let
    <with|mode|math|M<rsub|1>,\<ldots\>,M<rsub|m>\<in\><value|GL><rsub|n>(\<bbb-C\>)>
    be a<nbsp>finite number of matrices in the normalizer of
    <with|mode|math|\<cal-H\>>. Denote by <with|mode|math|\<cal-G\>> the
    group generated by<nbsp><with|mode|math|\<cal-H\>>
    and<nbsp><with|mode|math|M<rsub|1>,\<ldots\>,<no-break>M<rsub|m>>. If all
    elements in <with|mode|math|\<cal-G\>/\<cal-H\>> have finite order, then
    <with|mode|math|\<cal-G\>/\<cal-H\>> is finite.
  </lemma>

  <\proof>
    In the case when <with|mode|math|\<cal-H\>={1}>, the result is classical
    <cite-detail|Dix71|Theorem 9.2>. In the general case, the normalizer
    <with|mode|math|\<cal-N\>> of <with|mode|math|\<cal-H\>> is a closed
    algebraic subgroup of <with|mode|math|<value|GL><rsub|n>(\<bbb-C\>)> and
    <with|mode|math|\<cal-H\>> is a normal subgroup of
    <with|mode|math|\<cal-N\>>. By <cite-detail|Bor91|Theorem 6.8 and
    Proposition 1.10>, it follows that<nbsp><with|mode|math|\<cal-N\>/\<cal-G\>>
    is an affine algebraic group which is isomorphic to a closed algebraic
    matrix group. This reduces the general case to the special case when
    <with|mode|math|\<cal-H\>={1}>.
  </proof>

  <\theorem>
    There exists an <with|mode|math|\<varepsilon\><rsub|0>\<in\>\<bbb-N\><rsup|\<gtr\>>*2<rsup|\<bbb-Z\>>>
    such that, for every <with|mode|math|\<varepsilon\>\<in\>\<bbb-N\><rsup|\<gtr\>>*2<rsup|\<bbb-Z\>>>
    with <with|mode|math|\<varepsilon\>\<less\>\<varepsilon\><rsub|0>>, the
    set <with|mode|math|\<cal-F\>*\<mathe\><rsup|\<cal-L\>>> returned by
    <with|font-shape|right|<verbatim|Closure>>, considered as a subset of
    <with|mode|math|<value|GL><rsub|n>(\<bbb-C\><rsup|eff>)>, coincides with
    the smallest closed algebraic subgroup
    <with|mode|math|\<langle\>\<cal-M\>\<rangle\>> of
    <with|mode|math|<value|GL><rsub|n>(\<bbb-C\><rsup|eff>)> which contains
    <with|mode|math|\<cal-M\>>.
  </theorem>

  <\proof>
    Clearly, the dimension of <with|mode|math|\<cal-L\>> increases throughout
    the execution of the algorithm, so it remains ultimately constant. At
    this point, the set <with|mode|math|\<cal-F\>> will keep growing and the
    lemma implies that<nbsp><with|mode|math|\<cal-F\>> ultimately stabilizes.
    When this happens, <with|mode|math|\<cal-F\>> is closed under
    multiplication modulo <with|mode|math|\<mathe\><rsup|\<cal-L\>>>, as well
    as under multiplicative inverses, since each element in
    <with|mode|math|\<cal-F\>> has finite order modulo
    <with|mode|math|\<mathe\><rsup|\<cal-L\>>>. We conclude that
    <with|mode|math|\<cal-F\>*\<mathe\><rsup|\<cal-L\>>> is indeed the
    smallest closed algebraic subgroup of
    <with|mode|math|<value|GL><rsub|n>(\<bbb-F\>)> which
    contains<nbsp><with|mode|math|\<cal-M\>>, provided that the approximate
    zero-test always returns the right result.

    In order to prove the correctness at a sufficient precision, we assume
    that we use the theoretic membership test from
    section<nbsp><reference|membership-sec> and that the random number
    generator successively generates the same random numbers each time we
    relaunch the algorithm at a higher precision. Now consider the trace of
    the execution of our algorithm when using an infinite precision. Let
    <with|mode|math|\<varepsilon\><rsub|0>> be a sufficient precision such
    that all zero-tests in this execution tree are still correct when we
    replace the infinite precision by a precision
    <with|mode|math|\<varepsilon\>\<less\>\<varepsilon\><rsub|0>>. Then the
    trace of the execution any finite precision
    <with|mode|math|\<varepsilon\>\<less\>\<varepsilon\><rsub|0>> coincides
    with the trace of the execution at infinite precision. This completes the
    proof.
  </proof>

  <\remark>
    The main improvement of the algorithm <verbatim|Closure> <abbr|w.r.t.>
    the algorithm from<nbsp><cite|DJK03> lies in the more efficient treatment
    of the connected component (using linear algebra). On the other hand, the
    mere enumeration of representatives in each connected component can be
    very unefficient (although a Grbner basis might be of the same size).
    Fortunately, we will see in the next sections how to remove this
    drawback.
  </remark>

  Assume now that <with|mode|math|\<cal-M\>> is the set of generators for
  <with|mode|math|\<cal-G\><rsub|L,\<b-h\><rsup|z<rsub|0>>>> as computed in
  theorem <reference|gal-gen-th>. Assume that we have computed a reasonable
  candidate <with|mode|math|\<cal-F\>*\<mathe\><rsup|\<cal-L\>>> for
  <with|mode|math|\<langle\>\<cal-M\>\<rangle\>>, expressed in the original
  basis corresponding to <with|mode|math|\<b-h\><rsup|z<rsub|0>>>. We still
  have to reconstruct <with|mode|math|<wide|\<cal-F\>|~>\<subseteq\><value|GL><rsub|n>(\<bbb-K\>)>
  and <with|mode|math|<wide|\<cal-L\>|~>=<value|Vect>(<wide|\<cal-B\>|~>)>
  with <with|mode|math|<wide|\<cal-B\>|~>\<in\><value|Mat><rsub|n>(\<bbb-K\>)>
  such that <with|mode|math|><with|mode|math|\<cal-F\>*\<mathe\><rsup|\<cal-L\>>\<cap\><value|GL><rsub|n>(\<bbb-K\>)=<wide|\<cal-F\>|~>*\<mathe\><rsup|<wide|\<cal-L\>|~>>\<cap\><value|GL><rsub|n>(\<bbb-K\>)>.

  In the case of <with|mode|math|<wide|\<cal-L\>|~>>, by selecting a suitable
  basis of <with|mode|math|<value|Mat><rsub|n>(\<bbb-F\>)>, we may consider
  <with|mode|math|<wide|\<cal-B\>|~>> as a big
  <with|mode|math|d\<times\>n<rsup|2>> matrix whose first <with|mode|math|d>
  columns are linearly independent. We compute the row-echelon form of this
  basis:

  <\equation*>
    E=<matrix|<tformat|<table|<row|<cell|1>|<cell|>|<cell|>|<cell|\<ast\>>|<cell|\<cdots\>>|<cell|\<ast\>>>|<row|<cell|>|<cell|\<ddots\>>|<cell|>|<cell|\<vdots\>>|<cell|>|<cell|\<vdots\>>>|<row|<cell|>|<cell|>|<cell|1>|<cell|\<ast\>>|<cell|\<cdots\>>|<cell|\<ast\>>>>>>.
  </equation*>

  The entries of <with|mode|math|E> must be in <with|mode|math|\<bbb-K\>>:
  provided that <with|mode|math|<wide|\<cal-L\>|~>> is indeed generated by a
  basis of matrices with entries in <with|mode|math|\<bbb-K\>>, the
  row-echelon form of this second basis coincides with <with|mode|math|E>. It
  therefore suffices to reconstruct the entries of <with|mode|math|E> using
  the LLL-algorithm.

  In the case of a matrix <with|mode|math|M\<in\>\<cal-F\>>, the set
  <with|mode|math|M*\<mathe\><rsup|<wide|\<cal-L\>|~>>> is an algebraic
  variety of dimension <with|mode|math|d>
  over<nbsp><with|mode|math|\<bbb-K\>>. Now choose
  <with|mode|math|<wide|M|~>\<in\>M*\<mathe\><rsup|<wide|\<cal-L\>|~>>> close
  to <with|mode|math|M> in such a way that <with|mode|math|d> independent
  coordinates of <with|mode|math|<wide|M|~>> are all in
  <with|mode|math|\<bbb-Q\>\<subseteq\>\<bbb-K\>>. Then the other coordinates
  of <with|mode|math|<wide|M|~>>, considered as elements of
  <with|mode|math|\<bbb-C\><rsup|eff>>, are easily found using Newton's
  method. Since <with|mode|math|M*\<mathe\><rsup|<wide|\<cal-L\>|~>>> is an
  algebraic variety, these other coordinates are actually in
  <with|mode|math|\<bbb-K\>>, and we reconstruct them using the
  LLL-algorithm.

  <subsection|Fast computations with the connected components>

  The algorithm <verbatim|Closure> from the previous section is quite
  inefficient when the set <with|mode|math|\<cal-F\>> becomes large. It is
  therefore useful to seek for a better computational representation
  of<nbsp><with|mode|math|\<cal-F\>>. For finite groups
  <with|mode|math|\<cal-G\>>, one classical idea is to search for a sequence
  of subgroups

  <\equation>
    <label|subgroup-seq>1=\<cal-G\><rsub|0>\<varsubsetneq\>\<cal-G\><rsub|1>\<varsubsetneq\>\<cdots\>\<varsubsetneq\>\<cal-G\><rsub|k>=\<cal-G\>
  </equation>

  such that the indices <with|mode|math|\<cal-G\><rsub|i><op|:>\<cal-G\><rsub|i-1>>
  are small. Then we may represent elements in <with|mode|math|\<cal-F\>> by
  sequences <with|mode|math|(a<rsub|1>,\<ldots\>,a<rsub|k>)> with
  <with|mode|math|a<rsub|i>\<in\>\<cal-G\><rsub|i>/\<cal-G\><rsub|i-1>> for
  each <with|mode|math|i>. This representation is particularly useful if
  <with|mode|math|\<cal-F\>> operates on a set <with|mode|math|\<cal-S\>> and
  if there exists points <with|mode|math|a<rsub|1>,\<ldots\>,a<rsub|k>> in
  <with|mode|math|\<cal-S\>> such that

  <\equation*>
    \<cal-G\><rsub|i>=S<rsub|a<rsub|1>,\<ldots\>,a<rsub|k-i>>
  </equation*>

  is the stabilizer of the set <with|mode|math|{a<rsub|1>,\<ldots\>,a<rsub|k-i>}>
  for each <with|mode|math|i>. Then the set
  <with|mode|math|S<rsub|a<rsub|1>,\<ldots\>,a<rsub|i-1>>/S<rsub|a<rsub|1>,\<ldots\>,a<rsub|i>>>
  corresponds to the orbit of <with|mode|math|a<rsub|i>> while leaving
  <with|mode|math|a<rsub|1>,\<ldots\>,a<rsub|i-1>> fixed
  <cite|Sims70|Sims71>.

  In the case of matrix groups, one often takes
  <with|mode|math|\<bbb-F\><rsup|n>> for <with|mode|math|\<cal-S\>>
  <cite|MOB95>. However, this approach only yields interesting results when
  there exist non-trivial invariant subspaces under the action of the group,
  which will usually not be the case for us (otherwise we may
  factor<nbsp><with|mode|math|L> and consider smaller problems). A
  theoretical way out of this is to also consider the action
  of<nbsp><with|mode|math|\<cal-F\>> on exterior
  powers<nbsp><with|mode|math|\<wedge\><rsup|p> \<bbb-F\><rsup|n>>. However,
  this approach is very expensive from a computational point of view. In our
  more specific context of matrices with complex entries, we will therefore
  combine two other approaches: non-commutative lattice reduction and the
  operation of <with|mode|math|\<cal-F\>> on
  <with|mode|math|<value|Mat><rsub|n>(\<bbb-F\>)/\<mathe\><rsup|\<cal-L\>>>
  via conjugations <with|mode|math|M\<mapsto\><no-break>M*N*M<rsup|-1>>.

  The algebra <with|mode|math|<value|Mat><rsub|n>(\<bbb-F\>)> admits a
  natural (multiplicative) norm, given by

  <\equation*>
    \<\|\|\>M\<\|\|\>=sup {\|M*V\|:V\<in\>\<bbb-F\><rsup|n>,\|V\|=1},
  </equation*>

  where <with|mode|math|\|*\<cdot\>\|> stands for the Euclidean norm on
  <with|mode|math|\<bbb-F\><rsup|n>>. If <with|mode|math|\<cal-G\>=\<langle\>\<cal-M\>\<rangle\>/\<mathe\><rsup|\<cal-L\>>>
  is finite, this enables us to construct
  <with|mode|math|\<cal-G\><rsub|0>=1,\<cal-G\><rsub|1>,\<ldots\>,\<cal-G\><rsub|k>>
  as in (<reference|subgroup-seq>) as follows. Assuming that
  <with|mode|math|\<cal-G\><rsub|0>,\<ldots\>,\<cal-G\><rsub|i-1>> have been
  constructed, we consider a matrix <with|mode|math|M<rsub|i>\<in\>\<langle\>\<cal-M\>\<rangle\>\<setminus\>\<cal-G\><rsub|i-1>*\<mathe\><rsup|\<cal-L\>>>
  for which <with|mode|math|\<\|\|\>M<rsub|i>-1\<\|\|\>> is minimal, and let
  <with|mode|math|\<cal-G\><rsub|i>> be the set generated by
  <with|mode|math|M<rsub|i>*\<mathe\><rsup|\<cal-L\>>> and
  <with|mode|math|\<cal-G\><rsub|i-1>> in <with|mode|math|\<cal-G\>>. This
  construction allows us to rapidly identify a big commutative part of
  <with|mode|math|\<cal-G\>>. More precisely, we have

  <\proposition>
    <label|comm-bound>Let <with|mode|math|A,B\<in\><value|GL><rsub|n>(\<bbb-F\>)>
    be such that <with|mode|math|\<varepsilon\>=\<\|\|\>A-1\<\|\|\>\<less\>1>
    and <with|mode|math|\<delta\>=\<\|\|\>B-1\<\|\|\>\<less\>1>. Then we have

    <\equation*>
      \<\|\|\>A*B*A<rsup|\<um\>1>*B<rsup|\<um\>1>-1\<\|\|\>\<leqslant\>B(\<delta\>,\<varepsilon\>)=<frac|2*\<varepsilon\><rsup|2>|1-\<varepsilon\>>+<frac|2*\<delta\><rsup|2>|1-\<delta\>>+<frac|4*\<varepsilon\>*\<delta\>|(1-\<varepsilon\>)*(1-\<delta\>)>.
    </equation*>
  </proposition>

  <\proof>
    Writing <with|mode|math|A=1+\<Delta\>> and
    <with|mode|math|B=1+\<Epsilon\>>, we expand
    <with|mode|math|A<rsup|\<um\>1>=1-\<Delta\>+\<Delta\><rsup|2>+\<cdots\>>
    and <with|mode|math|B<rsup|\<um\>1>=1-\<Epsilon\>+\<Epsilon\><rsup|2>+\<cdots\>>
    in <with|mode|math|A*B*A<rsup|-1>*B<rsup|\<um\>1>>. This yields a
    non-commutative power series in <with|mode|math|\<Delta\>> and
    <with|mode|math|\<Epsilon\>> whose terms in <with|mode|math|1,\<Delta\>>
    and <with|mode|math|\<Epsilon\>> vanish. It follows that

    <\equation*>
      \<\|\|\>A*B*A<rsup|\<um\>1>*B<rsup|\<um\>1>-1\<\|\|\>\<leqslant\>(1+\<delta\>)*(1+\<varepsilon\>)*<frac|1|1-\<delta\>>*<frac|1|1-\<varepsilon\>>-1-2*\<delta\>-2*\<varepsilon\>=B(\<delta\>,\<varepsilon\>).
    </equation*>
  </proof>

  <yes-indent>The proposition implies that
  <with|mode|math|\<\|\|\>A*B*A<rsup|\<um\>1>*B<rsup|\<um\>1>-1\<\|\|\>\<less\>min(\<varepsilon\>,\<delta\>)>
  whenever <with|mode|math|max(\<varepsilon\>,<no-break>\<delta\>)\<less\>5-<sqrt|24>>.
  Now take <with|mode|math|A=M<rsub|i>> and <with|mode|math|B=M<rsub|j>> with
  <with|mode|math|i\<less\>j>, where the <with|mode|math|M<rsub|i>> are as
  above. Then it follows that <with|mode|math|A> and <with|mode|math|B>
  commute whenever <with|mode|math|B(\<delta\>,\<varepsilon\>)\<less\>\<\|\|\>M<rsub|1>-1\<\|\|\>>.
  What is more, proposition<nbsp><reference|comm-bound> shows that taking
  commutators is a convenient way to construct matrices close to identity
  from a set of non-commutative generators.

  However, from the effective point of view, we will not compute the
  <em|exact> computation of minimal representatives
  <with|mode|math|M<rsub|i>> in cosets of algebraic groups in detail. We will
  rather simulate such a computation in a way which is sufficient for our
  purpose. If <with|mode|math|M\<in\>\<cal-F\>> is such that
  <with|mode|math|\<\|\|\>M-1\<\|\|\>> is small, then we will also try to use
  the fact that the centralizer <with|mode|math|C<rsub|M>> of
  <with|mode|math|M> is often a big subgroup of
  <with|mode|math|\<langle\>\<cal-M\>\<rangle\>/\<mathe\><rsup|\<cal-L\>>>,
  so the orbit of <with|mode|math|N\<mapsto\>N<rsup|-1>*M*N> is small.

  <subsection|Non-commutative lattice reduction>

  Let <with|mode|math|\<cal-G\>> be a closed algebraic subgroup of
  <with|mode|math|<value|Mat><rsub|n>(\<bbb-F\>)> with associated Lie-algebra
  <with|mode|math|\<cal-L\>>. In this section, we will show how to compute
  efficiently with elements of the finite group
  <with|mode|math|\<cal-H\>=\<cal-G\>/\<mathe\><rsup|\<cal-L\>>>. Until the
  very end of this section, we assume that <with|mode|math|\<cal-G\>> is
  included in the connected component of the normalizer of
  <with|mode|math|\<mathe\><rsup|\<cal-L\>>> in
  <with|mode|math|<value|Mat><rsub|n>(\<bbb-F\>)>. We denote by
  <with|mode|math|\<cal-N\>> the Lie algebra of this connected component. By
  <cite-detail|Hum81|Theorem 13.3>, we have
  <with|mode|math|\<cal-N\>={N\<in\><value|Mat><rsub|n>(\<bbb-F\>):[N,\<cal-L\>]\<subseteq\>\<cal-L\>}>.

  <paragraph|Orthogonal projection>Let <with|mode|math|M\<in\>\<cal-G\>> and
  recall that <with|mode|math|M> belongs to the normalizer
  of<nbsp><with|mode|math|\<mathe\><rsup|\<cal-L\>>>. If
  <with|mode|math|\<\|\|\>M-1\<\|\|\>\<less\>1>, then <with|mode|math|X=log
  (1+(M-1))> also belongs to the normalizer of
  <with|mode|math|\<mathe\><rsup|\<cal-L\>>>. Since
  <with|mode|math|M\<in\>\<mathe\><rsup|\<bbb-F\>*X>> lies in the connected
  component of this normalizer, we have <with|mode|math|X\<in\>\<cal-N\>>.
  Now consider the orthogonal supplement <with|mode|math|\<cal-L\><rsup|\<perp\>>>
  of <with|mode|math|\<cal-L\>> for the Hermitian product on
  <with|mode|math|<value|Mat><rsub|n>(\<bbb-F\>)>. We define
  <with|mode|math|\<pi\><rsub|\<cal-L\>>(M)=\<mathe\><rsup|Y>>, where
  <with|mode|math|Y> is the orthogonal projection of <with|mode|math|X> on
  <with|mode|math|\<cal-L\><rsup|\<perp\>>>. From
  <with|mode|math|[X,\<cal-L\>]\<subseteq\>\<cal-L\>>, it follows that
  <with|mode|math|\<pi\><rsub|\<cal-L\>>(M)\<in\>M*\<mathe\><rsup|\<cal-L\>>>,
  and we denote <with|mode|math|\<\|\|\>M\<\|\|\><rsub|\<cal-L\>>=\<\|\|\>\<pi\><rsub|\<cal-L\>>(M)\<\|\|\>>.
  Since <with|mode|math|\<mathe\><rsup|\<cal-N\>>> is connected, the function
  <with|mode|math|M\<mapsto\>log M> may actually be analytically continued to
  a multivalued function <with|mode|math|\<mathe\><rsup|\<cal-N\>>\<rightarrow\>\<cal-N\>>.
  After choosing branch cuts (the way this is done is not crucial for what
  follows, provided that we make the standard choice for <with|mode|math|M>
  with <with|mode|math|\<\|\|\>M-1\<\|\|\>\<less\>1>), this allows us to
  extend the definitions of <with|mode|math|\<pi\><rsub|\<cal-L\>>> and
  <with|mode|math|\<\|\|\>\<cdot\>\<\|\|\><rsub|\<cal-L\>>> to the case when
  <with|mode|math|\<\|\|\>M-<no-break>1\<\|\|\>\<geqslant\><no-break>1>.

  <paragraph|Representation of the elements in <with|mode|math|\<cal-H\>>>Let
  <with|mode|math|X\<in\>\<cal-N\>> and <with|mode|math|M=\<mathe\><rsup|X>>
  be such that

  <\itemize>
    <item><with|mode|math|M*\<mathe\><rsup|\<cal-L\>>\<in\>\<cal-H\>>.

    <item><with|mode|math|M*\<mathe\><rsup|\<cal-L\>>> generates
    <with|mode|math|(\<mathe\><rsup|\<bbb-F\>*X>\<cap\>\<cal-G\>)/\<mathe\><rsup|\<cal-L\>>>.

    <item><with|mode|math|\<\|\|\>M\<\|\|\><rsub|\<cal-L\>>\<leqslant\>\<\|\|\>M<rsup|k>\<\|\|\><rsub|\<cal-L\>>>
    whenever <with|mode|math|M<rsup|k>\<in\>M<rsup|\<bbb-Z\>>> is another
    such generator.
  </itemize>

  Let <with|mode|math|p<rsub|1>*\<cdots\>*p<rsub|l>> be the
  prime-decomposition of the order of <with|mode|math|M> modulo
  <with|mode|math|\<mathe\><rsup|\<cal-L\>>>, with
  <with|mode|math|p<rsub|1>\<geqslant\>\<cdots\>\<geqslant\>p<rsub|l>>. Let
  <with|mode|math|A<rsub|0>=X> and <with|mode|math|A<rsub|i>=M<rsup|p<rsub|1>*\<cdots\>*p<rsub|i>>>
  for all <with|mode|math|i\<in\>{1,\<ldots\>,l}>. Let
  <with|mode|math|\<cal-H\><rsub|i>> be the subgroup of
  <with|mode|math|\<cal-H\>> of elements which commute with
  <with|mode|math|A<rsub|i>> modulo <with|mode|math|\<mathe\><rsup|\<cal-L\>>>,
  so that <with|mode|math|\<cal-H\><rsub|0>\<subseteq\>\<cdots\>\<subseteq\>\<cal-H\><rsub|l>=\<cal-H\>>.
  For <with|mode|math|i\<in\>{1,\<ldots\>,r}>, we represent elements in the
  quotient <with|mode|math|\<cal-H\><rsub|i>/\<cal-H\><rsub|i-1>> by elements
  in the orbit of the action <with|mode|math|\<Phi\><rsub|A<rsub|i>>:N\<mapsto\>A<rsub|i>*N*A<rsub|i><rsup|-1>>
  modulo <with|mode|math|\<cal-H\><rsub|i-1>>. Since
  <with|mode|math|[X,\<cal-L\>]\<subseteq\>\<cal-L\>>, the set
  <with|mode|math|\<cal-L\><rprime|'>=\<cal-L\>\<oplus\>\<bbb-F\>*X> is a Lie
  algebra whose normalizer contains <with|mode|math|\<cal-H\><rsub|0>>.
  Consequently, <with|mode|math|\<cal-H\><rsub|0>\<cong\>M<rsup|\<bbb-Z\>>\<times\>\<cal-H\><rsub|0>/\<mathe\><rsup|\<cal-L\><rprime|'>>>,
  and we represent elements in <with|mode|math|\<cal-H\><rsub|0>> by products
  <with|mode|math|M<rsup|k>*P>, with <with|mode|math|k\<in\>\<bbb-Z\>> and
  <with|mode|math|P*\<mathe\><rsup|\<cal-L\><rprime|'>>\<in\>\<cal-H\><rsub|0>/\<mathe\><rsup|\<cal-L\><rprime|'>>>.
  The elements in <with|mode|math|\<cal-H\><rsub|0>/\<mathe\><rsup|\<cal-L\><rprime|'>>>
  are represented in a similar way as the elements in
  <with|mode|math|\<cal-H\>>, using recursion. The successive matrices
  <with|mode|math|M> for <with|mode|math|\<cal-G\>/\<mathe\><rsup|\<cal-L\>>>,
  <with|mode|math|\<cal-H\><rsub|0>/\<mathe\><rsup|\<cal-L\><rprime|'>>>,
  <abbr|etc.> will be called a <em|basis> for <with|mode|math|\<cal-H\>>. A
  basis <with|mode|math|(B<rsub|1>,\<ldots\>,B<rsub|m>)> is said to be
  <em|sorted> if <with|mode|math|\<\|\|\>B<rsub|1>\<\|\|\><rsub|\<cal-L\>>\<leqslant\>\<cdots\>\<leqslant\>\<\|\|\>B<rsub|m>\<\|\|\><rsub|\<cal-L\>>>.

  <paragraph|Adding new elements to a basis>Let
  <with|mode|math|(B<rsub|1>,\<ldots\>,B<rsub|m>)> be a sorted basis for
  <with|mode|math|\<cal-H\>=\<cal-G\>/\<mathe\><rsup|\<cal-L\>>> and assume
  that we want to compute the extension <with|mode|math|<wide|\<cal-G\>|^>=\<langle\>\<cal-G\>,N\<rangle\>>
  of <with|mode|math|\<cal-G\>> by a new matrix<nbsp><with|mode|math|N>.
  Whenever we hit an element <with|mode|math|<wide|M|^>*\<mathe\><rsup|\<cal-L\>>\<in\><wide|\<cal-H\>|^>=<wide|\<cal-G\>|^>/\<mathe\><rsup|\<cal-L\>>>
  with <with|mode|math|\<\|\|\><wide|M|^>\<\|\|\><rsub|\<cal-L\>>\<less\>\<\|\|\>B<rsub|1>\<\|\|\><rsub|\<cal-L\>>>
  during our computations, then we start the process of basis reduction,
  which is described below. Whenever we find an element in
  <with|mode|math|<wide|\<cal-L\>|^>\<setminus\>\<cal-L\>>, then we abort all
  computations and return this element (indeed, in that case, we may continue
  with the closure of the connected component in <verbatim|Closure>).

  Let <with|mode|math|M=B<rsub|1>>, <with|mode|math|X>, <abbr|etc.> be as
  above. We start by computing the orbit of
  <with|mode|math|<wide|\<cal-G\>|^>> modulo
  <with|mode|math|\<cal-H\><rsub|r-1>> for
  <with|mode|math|\<Phi\><rsub|A<rsub|r>>>. Whenever we hit an element
  <with|mode|math|P\<neq\>1> (modulo <with|mode|math|\<mathe\><rsup|\<cal-L\>>>)
  with <with|mode|math|\<\|\|\>B<rsub|1>*P*B<rsub|1><rsup|\<um\>1>*P<rsup|\<um\>1>\<\|\|\><rsub|\<cal-L\>>\<less\>\<\|\|\>B<rsub|1>\<\|\|\><rsub|\<cal-L\>>>
  or <with|mode|math|\<\|\|\>P\<\|\|\><rsub|\<cal-L\>>\<less\>\<\|\|\>B<rsub|1>\<\|\|\><rsub|\<cal-L\>>>,
  then we start the process of basis reduction. Otherwise, we obtain a finite
  orbit, together with a finite number of matrices by which we have to extend
  <with|mode|math|\<cal-H\><rsub|r-1>>. We keep doing this using the same
  method for <with|mode|math|\<cal-H\><rsub|r-1>> until
  <with|mode|math|\<cal-H\><rsub|1>>.

  At the end, we still have to show how to extend
  <with|mode|math|\<cal-H\><rsub|0>> with a new matrix
  <with|mode|math|<wide|N|~>>. Now recursive application of the algorithm to
  <with|mode|math|<wide|\<cal-H\>|~>=\<cal-H\><rsub|0>/\<mathe\><rsup|\<cal-L\><rprime|'>>>
  and <with|mode|math|<wide|N|~>> yields a sorted basis
  <with|mode|math|<wide|B|~><rsub|1>,\<ldots\>,<wide|B|~><rsub|<wide|m|~>>>.
  When keeping track of the corresponding powers of
  <with|mode|math|\<mathe\><rsup|X>> during the computations, we also obtain
  a finite system of generators for <with|mode|math|<wide|\<cal-G\>|^>\<cap\>\<mathe\><rsup|\<bbb-F\>*X>>.
  Using <abbr|g.c.d.> computations we either obtain a<nbsp>minimal generator
  <with|mode|math|<wide|B|^><rsub|1>> or a new element in the connected
  component. In the first case, we return
  <with|mode|math|(<wide|B|^><rsub|1>,<wide|B|~><rsub|2>,\<ldots\>,<wide|B|~><rsub|<wide|m|~>>)>
  if <with|mode|math|\<\|\|\><wide|B|^><rsub|1>\<\|\|\><rsub|\<cal-L\>>\<less\>\<\|\|\><wide|B|~><rsub|2>\<\|\|\><rsub|\<cal-L\>>>
  and apply basis reduction otherwise.

  <paragraph|Basis reduction>Let <with|mode|math|B<rsub|1>,\<ldots\>,B<rsub|m>>
  be in <with|mode|math|\<cal-G\>> with <with|mode|math|\<\|\|\>B<rsub|1>\<\|\|\><rsub|\<cal-L\>>\<leqslant\>\<cdots\>\<leqslant\>\<\|\|\>B<rsub|m>\<\|\|\><rsub|\<cal-L\>>>.
  We call <with|mode|math|(B<rsub|1>,\<ldots\>,B<rsub|m>)> a <em|raw basis>.
  In the above algorithms, raw bases occur when we are given an ordered basis
  <with|mode|math|(B<rsub|2>,\<ldots\>,B<rsub|m>)> for
  <with|mode|math|\<cal-G\>>, and we find a new element
  <with|mode|math|B<rsub|1>> with <with|mode|math|\<\|\|\>B<rsub|1>\<\|\|\><rsub|\<cal-L\>>\<less\>\<\|\|\>B<rsub|2>\<\|\|\><rsub|\<cal-L\>>>.

  Using the above base extension procedure, we may transform a raw basis
  <with|mode|math|(B<rsub|1>,\<ldots\>,<no-break>B<rsub|m>)> into a basis for
  <with|mode|math|\<cal-G\>>: starting with <with|mode|math|(B<rsub|1>)>, we
  successively add <with|mode|math|B<rsub|2>,\<ldots\>,B<rsub|m>>. However,
  it is more efficient to reduce <with|mode|math|(B<rsub|1>,\<ldots\>,B<rsub|m>)>
  first. More precisely, let us now describe a procedure which tries to
  replace <with|mode|math|(B<rsub|1>,\<ldots\>,B<rsub|m>)> by a better raw
  basis <with|mode|math|(<wide|B|~><rsub|1>,\<ldots\>,<wide|B|~><rsub|<wide|m|~>>)>,
  with <math|\<langle\><wide|B|~><rsub|1>,\<ldots\>,<no-break><wide|B|~><rsub|<wide|m|~>>\<rangle\>=\<langle\>B<rsub|1>,\<ldots\>,<no-break>B<rsub|m>\<rangle\>>,
  and whose elements are closer to identity. Of course, we may always return
  the original basis if a better one could not be found.

  We first test whether all basis elements are roots of unity modulo
  <with|mode|math|\<cal-L\>>. If not, then we found a new element in the
  connected component. We next test whether there exist <with|mode|math|i,j>
  with <with|mode|math|\<\|\|\>B<rsub|i>*B<rsub|j>*B<rsub|i><rsup|\<um\>1>*B<rsub|j><rsup|\<um\>1>\<\|\|\><rsub|\<cal-L\>>\<less\>\<\|\|\>B<rsub|1>\<\|\|\><rsub|\<cal-L\>>>,
  in which case we keep adding the smallest such commutator to the basis.
  Whenever this stops, we write <with|mode|math|B<rsub|1>=\<mathe\><rsup|X<rsub|1>>,\<ldots\>,B<rsub|m>=\<mathe\><rsup|X<rsub|m>>>
  with <with|mode|math|X<rsub|1>,\<ldots\>,X<rsub|m>\<in\>\<cal-L\><rsup|\<perp\>>>
  and consider all lattice reductions <with|mode|math|X<rsub|i>\<leftarrow\>X<rsub|i>+k*X<rsub|j><space|1.2spc>(k\<in\>\<bbb-Z\>)>
  proposed by the LLL-algorithm in the commutative vector space
  <with|mode|math|\<cal-L\><rsup|\<perp\>>>. Whenever
  <with|mode|math|0\<less\>\<\|\|\>B<rsub|i>*B<rsub|j><rsup|k>\<\|\|\><rsub|\<cal-L\>>\<less\>\<\|\|\>B<rsub|i>\<\|\|\>>,
  for one such reduction, then we perform the corresponding reduction
  <with|mode|math|B<rsub|i>\<leftarrow\>B<rsub|i>*B<rsub|j><rsup|k>> on our
  basis and keep repeating the basis reduction process.

  <paragraph|The general case>We still have to show how to deal with the case
  when <with|mode|math|\<cal-G\>> is not included in the connected component
  <with|mode|math|\<mathe\><rsup|\<cal-N\>>> of the normalizer of
  <with|mode|math|\<mathe\><rsup|\<cal-L\>>> in
  <with|mode|math|<value|Mat><rsub|n>(\<bbb-F\>)>. In that case, we start
  with the computation of a basis for <with|mode|math|\<cal-N\>>, using
  linear algebra. Since <with|mode|math|\<mathe\><rsup|\<cal-N\>>\<cap\>\<cal-G\>>
  is a normal subgroup of <with|mode|math|\<cal-G\>>, we have
  <with|mode|math|\<cal-G\>\<cong\>(\<cal-G\>/\<mathe\><rsup|\<cal-N\>>)*(\<mathe\><rsup|\<cal-N\>>\<cap\>\<cal-G\>)>.
  Now we have explained above how to compute with elements in
  <with|mode|math|\<mathe\><rsup|\<cal-N\>>\<cap\>\<cal-G\>>. If
  <with|mode|math|\<cal-N\>\<varsupsetneq\>\<cal-L\>>, then may use recursion
  for computations in the finite group <with|mode|math|\<cal-G\>/\<mathe\><rsup|\<cal-N\>>>.
  If <with|mode|math|\<cal-N\>=\<cal-L\>>, then elements in
  <with|mode|math|\<cal-G\>/\<mathe\><rsup|\<cal-N\>>> have necessarily small
  order, so we simply list the elements of
  <with|mode|math|\<cal-G\>/\<mathe\><rsup|\<cal-L\>>>.

  <section|Conclusion and final notes>

  We hope that we provided convincing evidence that analytic methods may be
  used for the efficient computation of differential Galois groups and
  related problems like the factorization of linear differential operators.

  The two main remaining challenges are the concrete implementation of the
  algorithms presented here (as part of a more general library for the
  computation with analytic functions such as <cite|vdH:mml>) and the
  development of <em|a priori> or <em|a posteriori> methods for ensuring the
  correctness of the computed result. Some ideas into this direction are as
  follows:

  <\itemize>
    <item>Use theoretical bounds on the number of connected components of the
    computed Galois group and related bounds on the sizes of the basis
    elements in <strong|EH2> and<nbsp><strong|EH3>. See
    <cite-detail|DJK03|Section 3.2> for some results.

    <item>Use the classification theory for algebraic groups in order to
    gather more information about the computed Galois group
    <with|mode|math|\<cal-G\>>. In particular, it is useful to compute the
    radical (or unipotent radical) of <with|mode|math|\<cal-G\>>, thereby
    reducing the study of <with|mode|math|\<cal-G\>> to the study of a finite
    group, a semisimple (or reductive) group and a solvable (or unipotent)
    group<nbsp><cite-detail|Hum81|page<nbsp>125>. We refer to <cite|dG00> for
    computational aspects of the corresponding Lie algebras.

    <item>Use the classical theory of invariant subspaces in symmetric
    products or exterior powers as an <em|a posteriori> correctness check and
    search for an effective version of Chevalley's theorem
    <cite-detail|Hum81|Theorem 11.2>. One may start with
    generalizing<nbsp><cite|vHW97|CS98> and notice that a better knowledge of
    the Galois group <with|mode|math|\<cal-G\>> helps to further restrict the
    number of monomials (<abbr|i.e.> ``generalized exponents'') to be
    considered. Indeed, if <with|mode|math|\<cal-H\>> is an arbitrary
    algebraic subgroup of <with|mode|math|\<cal-G\>>, for which the ring of
    invariants is easy to compute, then the invariants for
    <with|mode|math|\<cal-G\>> must be searched in this ring. Also, their are
    known algorithms for computing the invariants for certain types of
    algebraic groups, like linearly reductive groups <cite|Der99>.

    <item>The representation for algebraic groups <with|mode|math|\<cal-G\>>
    we used in section <reference|galgr-sec> is efficient for computations
    (we merely do linear algebra in dimension <with|mode|math|n<rsup|2>>,
    lattice reduction and computations with small finite groups).
    Nevertheless, it may be interesting to reconstruct the algebraic
    equations for <with|mode|math|\<cal-G\>> and search for equations which
    are particularly sparse with respect to suitably chosen coordinates. For
    instance, a big cyclic group admits a particularly nice (<abbr|resp.>
    large) Grbner basis <abbr|w.r.t.> well chosen (<abbr|resp.> badly
    chosen) coordinates. Conversely, it may be interesting to switch back
    from a Grbner basis representation to our representation.

    <item>Carefully identify those parts of the algorithm which either prove
    or disprove certain matrices to belong to the Galois group. For instance,
    we know that all Stokes matrices are unipotent. Given a non-zero
    transcendental number <with|mode|math|\<lambda\>>, we may then reliably
    conclude that a Stokes matrix of the form
    <with|mode|math|<matrix|<tformat|<table|<row|<cell|1>|<cell|\<lambda\>>>|<row|<cell|0>|<cell|1>>>>>>
    generates the group <with|mode|math|{<matrix|<tformat|<table|<row|<cell|1>|<cell|\<alpha\>>>|<row|<cell|0>|<cell|1>>>>>:\<alpha\>\<in\>\<bbb-K\>}>.

    <item>An interesting idea to get rid of the transcendental part of the
    computations might be to quotient the values of the functions in our
    basis <with|mode|math|\<b-h\>> of solutions by the action of the Galois
    group. For instance, if <with|mode|math|z<rsub|0>> and
    <with|mode|math|z<rsub|1>> are close regular points in
    <with|mode|math|\<bbb-K\>>, is it true that the orbit of
    <with|mode|math|\<b-h\><rsup|z<rsub|0>>(z<rsub|1>)> under the action of
    the Galois group necessarily contains a point in
    <with|mode|math|\<bbb-K\><rsup|n>>? This is clearly the case for finite
    Galois groups and the full Galois group, as well as for the equations
    <with|mode|math|f<rprime|'>=f> and <with|mode|math|(z*f<rprime|'>)<rprime|'>=0>.
    More generally, as soon as <with|mode|math|\<b-h\><rsup|z<rsub|0>>(z<rsub|1>)>
    becomes more transcendental, its orbit under the action of the Galois
    group becomes larger, so the likelihood of finding a point in the
    intersection with<nbsp><with|mode|math|\<bbb-K\><rsup|n>> increases.
  </itemize>

  Besides the above ideas for improving the algorithms, this paper also
  raises a few other interesting questions:

  <\itemize>
    <item>Are there more efficient approaches for the reconstruction of
    elements in <with|mode|math|\<bbb-K\>> in
    section<nbsp><reference|factor-alg-sec>, both in the cases when
    <with|mode|math|\<bbb-K\>=\<bbb-Q\><rsup|alg>> and when
    <with|mode|math|\<bbb-K\>> is more general? Also, as pointed out above,
    we may want to reconstruct equations for <with|mode|math|\<cal-G\>> from
    the variety.

    <item>Does there exists an efficient membership test in section
    <reference|membership-sec> which does not rely on probabilistic
    arguments?

    <item>Can the approach of section <reference|galgr-sec> be adapted to the
    computation of a ``basis'' for the usual topological closure of a
    finitely generated matrix group?
  </itemize>

  Of course, a better mastering of the algorithms in this paper may also lead
  to more efficient algorithms for other computations which rely on
  differential Galois theory, like the computation of Liouvillian or other
  forms of solutions. More generally, our algorithms may be used for other
  computations with algebraic matrix groups over <with|mode|math|\<bbb-C\>>
  and other fields of characteristic <with|mode|math|0>. We also expect all
  results to generalize to holonomic systems of linear partial differential
  equations.

  <paragraph|Acknowledgment>The author would like to thank <abbr|J.-Y.> He,
  <abbr|W.> de Graaf, <abbr|F.> Zara, <abbr|J.><nbsp>calle and the referees
  for several helpful comments and references.<nocite|Mit96>

  <\bibliography|bib|elsart-harv|all.bib>
    <\bib-list|51>
      <bibitem*|Beke(1894)><label|bib-Beke94>Beke, E., 1894. Die
      Irreduzibilitt der homogenen linearen Differentialgleichungen. Math.
      Ann. 45.

      <bibitem*|Bertrand(1995)><label|bib-Ber95>Bertrand, D., 1995. Minimal
      heights and polarizations on group varieties. Duke Math. J.
      80<nbsp>(1), 223--250.

      <bibitem*|Bertrand and Beukers(1985)><label|bib-BBeuk85>Bertrand, D.,
      Beukers, F., 1985. quations diffrentielles linaires et majorations
      de multiplicits. Ann. Sci. de l'cole Norm. Sup. 28<nbsp>(4-5),
      473--494.

      <bibitem*|Borel(1991)><label|bib-Bor91>Borel, A., 1991. Linear
      algebraic groups, 2nd Edition. Springer-Verlag.

      <bibitem*|Braaksma(1991)><label|bib-Br91>Braaksma, B., 1991.
      Multisummability and Stokes multipliers of linear meromorphic
      differential equations. J. Diff. Eq 92, 45--75.

      <bibitem*|Braaksma(1992)><label|bib-Br92>Braaksma, B., 1992.
      Multisummability of formal power series solutions to nonlinear
      meromorphic differential equations. Ann. Inst. Fourier de Grenoble 42,
      517--540.

      <bibitem*|Candelberger et<nbsp>al.(1993)Candelberger, Nosmas, and
      Pham><label|bib-CNP93>Candelberger, B., Nosmas, J., Pham, F., 1993.
      Approche de la rsurgence. Actualits mathmatiques. Hermann.

      <bibitem*|Chudnovsky and Chudnovsky(1990)><label|bib-CC90>Chudnovsky,
      D., Chudnovsky, G., 1990. Computer algebra in the service of
      mathematical physics and number theory (computers in mathematics,
      stanford, ca, 1986). In: Lect. Notes in Pure and Applied Math. Vol.
      125. Dekker, New-York, pp. 109--232.

      <bibitem*|Cluzeau(2004)><label|bib-Cl04>Cluzeau, T., 2004.
      Algorithmique modulaire des quations diffrentielles linaires. Ph.D.
      thesis, Universit de Limoges.

      <bibitem*|Compoint and Singer(1998)><label|bib-CS98>Compoint, E.,
      Singer, M., 1998. Computing Galois groups of completely reducible
      differential equations. JSC 11, 1--22.

      <bibitem*|de<nbsp>Graaf(2000)><label|bib-dG00>de<nbsp>Graaf, W., 2000.
      Lie Algebras: Theory and Algorithms. Vol.<nbsp>56 of North Holland
      Mathematical Library. Elsevier science.

      <bibitem*|Derksen(1999)><label|bib-Der99>Derksen, H., 1999. Computation
      of reductive group invariants. Adv. in Math. 141, 366--384.

      <bibitem*|Derksen et<nbsp>al.(2003)Derksen, Jaendel, and
      Koiran><label|bib-DJK03>Derksen, H., Jaendel, E., Koiran, P., 2003.
      Quantum automata and algebraic groups. Tech. Rep. 2003-39, LIP, cole
      Norm. Sup. de Lyon, presented at MEGA 2003; to appear in JSC.

      <bibitem*|Dixon(1971)><label|bib-Dix71>Dixon, J., 1971. The structure
      of linear groups. Van Nostrand Reinhold Company.

      <bibitem*|calle(1985)><label|bib-Ec85>calle, J., 1985. Les fonctions
      rsurgentes I--III. Publ. Math. d'Orsay 1981 and 1985.

      <bibitem*|calle(1987)><label|bib-Ec87>calle, J., 1987. L'acclration
      des fonctions rsurgentes (survol), unpublished manuscript.

      <bibitem*|calle(1992)><label|bib-Ec92>calle, J., 1992. Introduction
      aux fonctions analysables et preuve constructive de la conjecture de
      Dulac. Hermann, collection: Actualits mathmatiques.

      <bibitem*|calle(1993)><label|bib-Ec93>calle, J., 1993. Six lectures
      on transseries, analysable functions and the constructive proof of
      Dulac's conjecture. In: Schlomiuk, D. (Ed.), Bifurcations and periodic
      orbits of vector fields. Kluwer, pp. 75--184.

      <bibitem*|Fabry(1885)><label|bib-Fab1885>Fabry, E., 1885. Sur les
      intgrales des quations diffrentielles linaires  coefficients
      rationnels. Ph.D. thesis, Paris.

      <bibitem*|Humphreys(1981)><label|bib-Hum81>Humphreys, J., 1981. Linear
      algebraic groups. Graduate Texts in Math. Springer.

      <bibitem*|Kaplansky(1957)><label|bib-Kap57>Kaplansky, I., 1957. An
      introduction to differential algebra. Hermann.

      <bibitem*|Kolchin(1973)><label|bib-Kol73>Kolchin, E., 1973.
      Differential algebra and algebraic groups. Academic Press, New York.

      <bibitem*|Lenstra et<nbsp>al.(1982)Lenstra, Lenstra, and
      Lovsz><label|bib-LLL82>Lenstra, A., Lenstra, H., Lovsz, L., 1982.
      Factoring polynomials with rational coefficients. Math. Ann. 261,
      515--534.

      <bibitem*|Martinet and Ramis(1991)><label|bib-MR91>Martinet, J., Ramis,
      J.-P., 1991. Elementary acceleration and multisummability. Ann. Inst.
      Henri Poincar 54<nbsp>(4), 331--401.

      <bibitem*|Masser(1988)><label|bib-Mas88>Masser, D., 1988. Linear
      relations on algebraic groups. In: Baker, A. (Ed.), New advances in
      transendence theory. Cambridge Univ. Press, pp. 248--262.

      <bibitem*|Menous(1996)><label|bib-Men96>Menous, F., 1996. Les bonnes
      moyennes uniformisantes et leur application  la resommation relle.
      Ph.D. thesis, Universit Paris-Sud, France.

      <bibitem*|Mitschi(1996)><label|bib-Mit96>Mitschi, C., 1996.
      Differential Galois groups of confluent generalized hypergeometric
      equations: an approach using stokes multipliers. Pac. J. Math.
      176<nbsp>(2), 365--405.

      <bibitem*|Moenck(1973)><label|bib-Moe73>Moenck, R., 1973. Fast
      computation of gcds. In: Proc. of the 5th ACM Annual Symposium on
      Theory of Computing. ACM Press, New York, pp. 142--171.

      <bibitem*|Murray and O'Brien(1995)><label|bib-MOB95>Murray, S.<nbsp>H.,
      O'Brien, E.<nbsp>A., 1995. Selecting base points for the Schreier-Sims
      algorithm for matrix groups. J.S.C. 18, 577--584.

      <bibitem*|Pan and Wang(2002)><label|bib-PW02>Pan, V.<nbsp>Y., Wang, X.,
      July 2002. Acceleration of euclidean algorithm and extensions. In:
      Mora, T. (Ed.), Proc. ISSAC '02. Lille, France, pp. 207--213.

      <bibitem*|Ramis(1985)><label|bib-Ram85b>Ramis, J.-P., 1985. Phnomne
      de Stokes et filtration Gevrey sur le groupe de Picard-Vessiot. Notes
      aux CRAS 301<nbsp>(I/5), 165--167.

      <bibitem*|Ritt(1950)><label|bib-Ritt50>Ritt, J., 1950. Differential
      algebra. Amer. Math. Soc., New York.

      <bibitem*|Schlesinger(1895)><label|bib-Schl95>Schlesinger, L., 1895.
      Handbuch der Theorie der linearen Differentialgleichungen. Vol.<nbsp>I.
      Teubner, Leipzig.

      <bibitem*|Schlesinger(1897)><label|bib-Schl97>Schlesinger, L., 1897.
      Handbuch der Theorie der linearen Differentialgleichungen.
      Vol.<nbsp>II. Teubner, Leipzig.

      <bibitem*|Sims(1970)><label|bib-Sims70>Sims, C., 1970. Computational
      problems in abstract algebra. Pergamon press, Oxford, Ch. Computational
      methods in the study of permutation groups, pp. 169--183.

      <bibitem*|Sims(1971)><label|bib-Sims71>Sims, C., 1971. Determining the
      conjugacy classes of permutation groups. In: Birkhoff, G., Jr.,
      M.<nbsp>H. (Eds.), Computers in algebra and number theory. Vol.<nbsp>4
      of Proc. A.M.S. A.M.S., New York, pp. 191--195.

      <bibitem*|Singer and Ulmer(1993)><label|bib-SU93>Singer, M., Ulmer, F.,
      1993. Galois groups of second and third order linear differential
      equations. J.S.C. 16, 9--36.

      <bibitem*|van<nbsp>der Hoeven(1999)><label|bib-vdH:hol>van<nbsp>der
      Hoeven, J., 1999. Fast evaluation of holonomic functions. TCS 210,
      199--215.

      <bibitem*|van<nbsp>der Hoeven(2001<natexlab|a>)><label|bib-vdH:osc>van<nbsp>der
      Hoeven, J., 2001<natexlab|a>. Complex transseries solutions to
      algebraic differential equations. Tech. Rep. 2001-34, Univ. d'Orsay.

      <bibitem*|van<nbsp>der Hoeven(2001<natexlab|b>)><label|bib-vdH:singhol>van<nbsp>der
      Hoeven, J., 2001<natexlab|b>. Fast evaluation of holonomic functions
      near and in singularities. JSC 31, 717--743.

      <bibitem*|van<nbsp>der Hoeven(2002)><label|bib-vdH:relax>van<nbsp>der
      Hoeven, J., 2002. Relax, but don't be too lazy. JSC 34, 479--542.

      <bibitem*|van<nbsp>der Hoeven(2003)><label|bib-vdH:maj>van<nbsp>der
      Hoeven, J., 2003. Majorants for formal power series. Tech. Rep.
      2003-15, Universit Paris-Sud, Orsay, France.

      <bibitem*|van<nbsp>der Hoeven(2005<natexlab|a>)><label|bib-vdH:effan>van<nbsp>der
      Hoeven, J., 2005<natexlab|a>. Effective complex analysis. J.S.C. 39,
      433--449.

      <bibitem*|van<nbsp>der Hoeven(2005<natexlab|b>)><label|bib-vdH:reshol>van<nbsp>der
      Hoeven, J., 2005<natexlab|b>. Efficient accelero-summation of holonomic
      functions. Tech. Rep. 2005-54, Universit Paris-Sud, Orsay, France,
      submitted to JSC.

      <bibitem*|van<nbsp>der Hoeven(2006)><label|bib-vdH:effreal>van<nbsp>der
      Hoeven, J., 2006. Computations with effective real numbers. TCS 351,
      52--60.

      <bibitem*|van<nbsp>der Hoeven et al.(2002--2005)><label|bib-vdH:mml>van<nbsp>der
      Hoeven et al., J., 2002--2005. Mmxlib: the standard library for
      Mathemagix. <with|font-family|tt|http://www.mathemagix.org/mmxweb/web/welcome-mml.en.html>.

      <bibitem*|van<nbsp>der Put(1995)><label|bib-vdP95>van<nbsp>der Put, M.,
      1995. Differential equations modulo <with|mode|math|p>. Compositio
      Mathematica 97, 227--251.

      <bibitem*|van<nbsp>der Put and Singer(2003)><label|bib-vdPS03>van<nbsp>der
      Put, M., Singer, M., 2003. Galois Theory of Linear Differential
      Equations. Vol. 328 of Grundlehren der mathematischen Wissenschaften.
      Springer.

      <bibitem*|van Hoeij(1996)><label|bib-vH:phd>van Hoeij, M., 1996.
      Factorization of linear differential operators. Ph.D. thesis, Univ. of
      Nijmegen, The Netherlands.

      <bibitem*|van Hoeij(1997)><label|bib-vH97b>van Hoeij, M., 1997.
      Factorization of differential operators with rational functions
      coefficients. J.S.C. 24, 537--561.

      <bibitem*|van Hoeij and Weil(1997)><label|bib-vHW97>van Hoeij, M.,
      Weil, J., 1997. An algorithm for computing invariants of differential
      Galois groups. J. Pure Appl. Algebra 117--118, 353--379.
    </bib-list>
  </bibliography>
</body>

<\initial>
  <\collection>
    <associate|font-base-size|11>
    <associate|par-hyphen|professional>
    <associate|preamble|false>
  </collection>
</initial>

<\references>
  <\collection>
    <associate||<tuple|9|?>>
    <associate|K2-eq|<\tuple>
      2
    </tuple|13>>
    <associate|accel-kerner|<\tuple>
      4
    </tuple|7>>
    <associate|as-basis-cor|<\tuple>
      9
    </tuple|8>>
    <associate|as-galois-th|<\tuple>
      13
    </tuple|9>>
    <associate|as-lin-th|<\tuple>
      8
    </tuple|8>>
    <associate|auto-1|<tuple|1|1>>
    <associate|auto-10|<tuple|2.5|8>>
    <associate|auto-11|<tuple|2.6|10>>
    <associate|auto-12|<tuple|3|12>>
    <associate|auto-13|<tuple|3.1|12>>
    <associate|auto-14|<tuple|3.2|13>>
    <associate|auto-15|<tuple|3.3|14>>
    <associate|auto-16|<tuple|4|14>>
    <associate|auto-17|<tuple|5|14>>
    <associate|auto-18|<tuple|6|14>>
    <associate|auto-19|<tuple|7|14>>
    <associate|auto-2|<tuple|2|3>>
    <associate|auto-20|<tuple|3.4|15>>
    <associate|auto-21|<tuple|4|17>>
    <associate|auto-22|<tuple|4.1|17>>
    <associate|auto-23|<tuple|4.2|18>>
    <associate|auto-24|<tuple|4.3|19>>
    <associate|auto-25|<tuple|4.4|19>>
    <associate|auto-26|<tuple|4.5|20>>
    <associate|auto-27|<tuple|4.6|22>>
    <associate|auto-28|<tuple|4.7|23>>
    <associate|auto-29|<tuple|8|23>>
    <associate|auto-3|<tuple|2.1|3>>
    <associate|auto-30|<tuple|9|23>>
    <associate|auto-31|<tuple|10|24>>
    <associate|auto-32|<tuple|11|24>>
    <associate|auto-33|<tuple|12|24>>
    <associate|auto-34|<tuple|5|24>>
    <associate|auto-35|<tuple|13|26>>
    <associate|auto-36|<tuple|13|26>>
    <associate|auto-37|<tuple|A.1|?>>
    <associate|auto-38|<tuple|A.2|?>>
    <associate|auto-39|<tuple|A.3|?>>
    <associate|auto-4|<tuple|2.2|3>>
    <associate|auto-40|<tuple|A.4|?>>
    <associate|auto-41|<tuple|36|?>>
    <associate|auto-5|<tuple|2.3|4>>
    <associate|auto-6|<tuple|2.4|6>>
    <associate|auto-7|<tuple|1|7>>
    <associate|auto-8|<tuple|2|7>>
    <associate|auto-9|<tuple|3|7>>
    <associate|bib-BBeuk85|<tuple|Bertrand and Beukers(1985)|26>>
    <associate|bib-Beke94|<tuple|Beke(1894)|26>>
    <associate|bib-Ber95|<tuple|Bertrand(1995)|?>>
    <associate|bib-Bor91|<tuple|Borel(1991)|26>>
    <associate|bib-Br91|<tuple|Braaksma(1991)|26>>
    <associate|bib-Br92|<tuple|Braaksma(1992)|26>>
    <associate|bib-CC90|<tuple|Chudnovsky and Chudnovsky(1990)|26>>
    <associate|bib-CNP93|<tuple|Candelberger et
    <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>al.(1993)Candelberger,
    Nosmas, and Pham|26>>
    <associate|bib-CS98|<tuple|Compoint and Singer(1998)|?>>
    <associate|bib-Cl04|<tuple|Cluzeau(2004)|26>>
    <associate|bib-DJK03|<tuple|Derksen et
    <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>al.(2003)Derksen,
    Jaendel, and Koiran|26>>
    <associate|bib-Der99|<tuple|Derksen(1999)|26>>
    <associate|bib-Dix71|<tuple|Dixon(1971)|26>>
    <associate|bib-Ec85|<tuple|calle(1985)|26>>
    <associate|bib-Ec87|<tuple|calle(1987)|26>>
    <associate|bib-Ec89|<tuple||25>>
    <associate|bib-Ec92|<tuple|calle(1992)|26>>
    <associate|bib-Ec93|<tuple|calle(1993)|27>>
    <associate|bib-Fab1885|<tuple|Fabry(1885)|27>>
    <associate|bib-Hum81|<tuple|Humphreys(1981)|27>>
    <associate|bib-Kap57|<tuple|Kaplansky(1957)|27>>
    <associate|bib-Kol73|<tuple|Kolchin(1973)|27>>
    <associate|bib-LLL82|<tuple|Lenstra et
    <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>al.(1982)Lenstra,
    Lenstra, and Lovsz|27>>
    <associate|bib-MOB95|<tuple|Murray and O'Brien(1995)|27>>
    <associate|bib-MR91|<tuple|Martinet and Ramis(1991)|27>>
    <associate|bib-Mas88|<tuple|Masser(1988)|?>>
    <associate|bib-Men96|<tuple|Menous(1996)|27>>
    <associate|bib-Mit96|<tuple|Mitschi(1996)|?>>
    <associate|bib-Moe73|<tuple|Moenck(1973)|27>>
    <associate|bib-PW02|<tuple|Pan and Wang(2002)|27>>
    <associate|bib-Ram85b|<tuple|Ramis(1985)|27>>
    <associate|bib-Ritt50|<tuple|Ritt(1950)|27>>
    <associate|bib-SU93|<tuple|Singer and Ulmer(1993)|27>>
    <associate|bib-Schl95|<tuple|Schlesinger(1895)|27>>
    <associate|bib-Schl97|<tuple|Schlesinger(1897)|27>>
    <associate|bib-Sims70|<tuple|Sims(1970)|27>>
    <associate|bib-Sims71|<tuple|Sims(1971)|27>>
    <associate|bib-dG00|<tuple|de <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>Graaf(2000)|26>>
    <associate|bib-vH97b|<tuple|van Hoeij(1997)|28>>
    <associate|bib-vH:phd|<tuple|van Hoeij(1996)|28>>
    <associate|bib-vHW97|<tuple|van Hoeij and Weil(1997)|28>>
    <associate|bib-vdH:effan|<tuple|van <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Hoeven(2005a)|27>>
    <associate|bib-vdH:effreal|<tuple|van
    <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Hoeven(2006)|27>>
    <associate|bib-vdH:hol|<tuple|van <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Hoeven(1999)|27>>
    <associate|bib-vdH:maj|<tuple|van <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Hoeven(2003)|27>>
    <associate|bib-vdH:mml|<tuple|van <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Hoeven et al.(2002--2005)|27>>
    <associate|bib-vdH:osc|<tuple|van <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Hoeven(2001a)|27>>
    <associate|bib-vdH:relax|<tuple|van <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Hoeven(2002)|27>>
    <associate|bib-vdH:reshol|<tuple|van <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Hoeven(2005b)|27>>
    <associate|bib-vdH:singhol|<tuple|van
    <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Hoeven(2001b)|27>>
    <associate|bib-vdP95|<tuple|van <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Put(1995)|27>>
    <associate|bib-vdPS03|<tuple|van <no-break><specific|screen|<resize|<move|<with|color|<quote|#A0A0FF>|->|-0.3em|>|0em||0em||>>der
    Put and Singer(2003)|28>>
    <associate|comm-bound|<\tuple>
      8
    </tuple|22>>
    <associate|diag-lem|<\tuple>
      1
    </tuple|18>>
    <associate|diff-Gal-sec|<tuple|2.2|3>>
    <associate|dir-constraint|<\tuple>
      5
    </tuple|7>>
    <associate|eff-hol|<\tuple>
      16
    </tuple|10>>
    <associate|eff-reshol|<\tuple>
      18
    </tuple|11>>
    <associate|eff-singhol|<\tuple>
      17
    </tuple|11>>
    <associate|expo-fin-prop|<\tuple>
      5
    </tuple|5>>
    <associate|expo-mon-fixed-prop|<\tuple>
      6
    </tuple|6>>
    <associate|fact-prop|<\tuple>
      1
    </tuple|12>>
    <associate|factor-alg-sec|<tuple|3.4|15>>
    <associate|factor-sec|<tuple|3|12>>
    <associate|fin-stokes-dir|<\tuple>
      12
    </tuple|9>>
    <associate|fixed-stokes-prop|<\tuple>
      11
    </tuple|8>>
    <associate|gal-gen-th|<\tuple>
      19
    </tuple|11>>
    <associate|galgr-alg-sec|<tuple|4.5|20>>
    <associate|galgr-sec|<tuple|4|17>>
    <associate|hol-stab-1|<tuple|30|?>>
    <associate|hol-stab-2|<tuple|31|?>>
    <associate|inv-subsp-rem|<\tuple>
      3
    </tuple|15>>
    <associate|lapl-constraint|<\tuple>
      6
    </tuple|7>>
    <associate|lde-by-wronskian|<\tuple>
      1
    </tuple|12>>
    <associate|membership-sec|<tuple|4.4|19>>
    <associate|mono-sec|<tuple|2.3|4>>
    <associate|mul-law-2|<tuple|5|3>>
    <associate|nil-diag-lem|<\tuple>
      2
    </tuple|13>>
    <associate|nil-diag-prop|<tuple|3|?>>
    <associate|prelim-sec|<tuple|2|3>>
    <associate|rat-inv-cor|<\tuple>
      2
    </tuple|4>>
    <associate|reshol:AS|<\tuple>
      3
    </tuple|6>>
    <associate|reshol:calB|<tuple|4|?>>
    <associate|reshol:kernel|<tuple|3|?>>
    <associate|reshol:tcalB|<tuple|3|?>>
    <associate|sing-form|<\tuple>
      2
    </tuple|5>>
    <associate|subgroup-seq|<\tuple>
      1
    </tuple|22>>
    <associate|sym-ass-1|<tuple|3|2>>
    <associate|sym-ass-2|<tuple|4|3>>
    <associate|tmat-def-eq|<\tuple>
      1
    </tuple|4>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|bib>
      Kap57

      vdPS03

      Kol73

      Beke94

      SU93

      Hum81

      vHW97

      vH97b

      vH:phd

      Cl04

      vdP95

      vdPS03

      Ec85

      Ec87

      Ec92

      Ec93

      Br91

      Br92

      Ram85b

      MR91

      vdH:hol

      vdH:singhol

      vdH:reshol

      DJK03

      LLL82

      Sims70

      Sims71

      MOB95

      DJK03

      vdH:mml

      Kol73

      Ritt50

      Kap57

      vdH:reshol

      Fab1885

      vH:phd

      vdH:osc

      vdH:osc

      Ec87

      Br91

      Ec85

      CNP93

      CNP93

      Ram85b

      MR91

      MR91

      Schl95

      Schl97

      Men96

      Ec85

      Ec87

      Ec92

      Ec93

      CC90

      vdH:hol

      vdH:singhol

      vdH:reshol

      vdH:effan

      vdH:maj

      vdH:effreal

      vdH:relax

      LLL82

      Moe73

      PW02

      BBeuk85

      vH97b

      vdPS03

      BBeuk85

      Hum81

      Mas88

      Ber95

      CS98

      Bor91

      Dix71

      Bor91

      DJK03

      Sims70

      Sims71

      MOB95

      Hum81

      vdH:mml

      DJK03

      Hum81

      dG00

      Hum81

      vHW97

      CS98

      Der99

      Mit96
    </associate>
    <\associate|toc>
      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|1<space|1.1fn>Introduction>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-1><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|2<space|1.1fn>Preliminaries>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-2><vspace|0.5fn>

      <with|par-left|<quote|1.5fn>|2.1<space|1.1fn>Notations
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-3>>

      <with|par-left|<quote|1.5fn>|2.2<space|1.1fn>Differential Galois groups
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-4>>

      <with|par-left|<quote|1.5fn>|2.3<space|1.1fn>Monodromy
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-5>>

      <with|par-left|<quote|1.5fn>|2.4<space|1.1fn>The process of
      accelero-summation <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-6>>

      <with|par-left|<quote|6fn>|1<space|1.1fn><with|font-shape|<quote|small-caps>|The
      Borel transform> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-7><vspace|0.15fn>>

      <with|par-left|<quote|6fn>|2<space|1.1fn><with|font-shape|<quote|small-caps>|Accelerations>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-8><vspace|0.15fn>>

      <with|par-left|<quote|6fn>|3<space|1.1fn><with|font-shape|<quote|small-caps>|The
      Laplace transform> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-9><vspace|0.15fn>>

      <with|par-left|<quote|1.5fn>|2.5<space|1.1fn>The Stokes phenomenon
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-10>>

      <with|par-left|<quote|1.5fn>|2.6<space|1.1fn>Effective complex numbers
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-11>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|3<space|1.1fn>Factoring
      linear differential operators> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-12><vspace|0.5fn>

      <with|par-left|<quote|1.5fn>|3.1<space|1.1fn>Factoring
      <with|mode|<quote|math>|L> and invariant subspaces under
      <with|mode|<quote|math>|\<cal-G\><rsub|L,\<b-h\>>>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-13>>

      <with|par-left|<quote|1.5fn>|3.2<space|1.1fn>A lemma from linear
      algebra <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-14>>

      <with|par-left|<quote|1.5fn>|3.3<space|1.1fn>Computation of non-trivial
      invariant subspaces <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-15>>

      <with|par-left|<quote|6fn>|4<space|1.1fn>Good candidate vectors
      <with|mode|<quote|math>|\<b-v\>> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-16><vspace|0.15fn>>

      <with|par-left|<quote|6fn>|5<space|1.1fn>The
      <with|mode|<quote|math>|\<bbb-K\>>-algebra generated by
      <with|mode|<quote|math>|\<cal-M\>> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-17><vspace|0.15fn>>

      <with|par-left|<quote|6fn>|6<space|1.1fn><with|mode|<quote|math>|\<cal-M\>>-splittings
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-18><vspace|0.15fn>>

      <with|par-left|<quote|6fn>|7<space|1.1fn>Refining
      <with|mode|<quote|math>|\<cal-M\>>-splittings
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-19><vspace|0.15fn>>

      <with|par-left|<quote|1.5fn>|3.4<space|1.1fn>Factoring linear
      differential operators <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-20>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|4<space|1.1fn>Computing
      differential Galois groups> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-21><vspace|0.5fn>

      <with|par-left|<quote|1.5fn>|4.1<space|1.1fn>Introduction
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-22>>

      <with|par-left|<quote|1.5fn>|4.2<space|1.1fn>The algebraic group
      generated by a diagonal matrix <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-23>>

      <with|par-left|<quote|1.5fn>|4.3<space|1.1fn>The algebraic group
      generated by a single matrix <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-24>>

      <with|par-left|<quote|1.5fn>|4.4<space|1.1fn>Membership testing for the
      connected component <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-25>>

      <with|par-left|<quote|1.5fn>|4.5<space|1.1fn>Computing the closure of
      <with|mode|<quote|math>|\<cal-M\>> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-26>>

      <with|par-left|<quote|1.5fn>|4.6<space|1.1fn>Fast computations with the
      connected components <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-27>>

      <with|par-left|<quote|1.5fn>|4.7<space|1.1fn>Non-commutative lattice
      reduction <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-28>>

      <with|par-left|<quote|6fn>|8<space|1.1fn>Orthogonal projection
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-29><vspace|0.15fn>>

      <with|par-left|<quote|6fn>|9<space|1.1fn>Representation of the elements
      in <with|mode|<quote|math>|\<cal-H\>>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-30><vspace|0.15fn>>

      <with|par-left|<quote|6fn>|10<space|1.1fn>Adding new elements to a
      basis <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-31><vspace|0.15fn>>

      <with|par-left|<quote|6fn>|11<space|1.1fn>Basis reduction
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-32><vspace|0.15fn>>

      <with|par-left|<quote|6fn>|12<space|1.1fn>The general case
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-33><vspace|0.15fn>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|5<space|1.1fn>Conclusion
      and final notes> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-34><vspace|0.5fn>

      <with|par-left|<quote|6fn>|13<space|1.1fn>Acknowledgment
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-35><vspace|0.15fn>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|References>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-36><vspace|0.5fn>
    </associate>
  </collection>
</auxiliary>