<TeXmacs|1.0.0.8>

<style|<tuple|acmconf|vdh>>

<\body>
  <\expand|make-title>
    <title|A new zero-test for formal power series>

    <author|Joris van der Hoeven>

    <\address>
      <abbr|Dpt.> de Mathmatiques (<abbr|Bt.> 425)

      Universit Paris-Sud

      91405 Orsay Cedex

      France

      Email: <verbatim|joris@texmacs.org>
    </address>

    <expand|title-date|<date|%B %d, %Y>>
  </expand>

  <\abstract>
    In this paper, we present a new zero-test for expressions which are
    constructed from formal power solutions to algebraic differential
    equations using the ring operations and differentiation. We also provide
    a survey of all existing methods that we know of and a detailed
    comparison of these methods with our approach.
  </abstract>

  <with|mode|math|<assign|C|\<cal-C\>><assign|R|\<cal-R\>><assign|K|\<cal-K\>\
  >><section|Introduction>

  Zero-testing is an important issue on the analysis side of symbolic
  computation. Standard mathematical notation provides a way of representing
  many transcendental functions. However, trivial cases apart, this notation
  gives rise to the following problems:

  <\itemize>
    <item>Expressions may not be defined: consider <with|mode|math|1/0>,
    <with|mode|math|log(0)> or <with|mode|math|log(e<rsup|x+y>-e<rsup|x>*e<rs\
    up|y>)>.

    <item>Expressions may be ambiguous: what values should we take for
    <with|mode|math|log(<with|math condensed|true|-1>)> or
    <with|mode|math|<sqrt|z<rsup|2>|>><space|0.4spc>?

    <item>Expressions may be redundant: <with|mode|math|sin<rsup|2>
    x+cos<rsup|2> <format|no line break>x> and <with|mode|math|1> are
    different expressions, but they represent the same function.
  </itemize>

  Often, one is interested in expressions which represent functions in a
  ring. In that case, the third problem reduces to deciding when a given
  expression represents the zero function.

  As to the first two problems, one has to decide where and how we want our
  functions to be defined. In this paper, we will be concerned with
  expressions that represent formal power series (in fact, this approach
  covers most elementary calculus on special functions, using analytic
  continuation if necessary). The expressions will then be formed from the
  constants and the indeterminates using the ring operations and power series
  solutions to algebraic differential equations. The correctness and
  non-ambiguity of expressions may be ensured by structural induction. This
  may involve zero-testing for the series represented by
  subexpressions.<format|no page break after>

  Several classical approaches for zero-testing exist
  <apply|cite|Ris75|Khov91|Sh3|Sh4|Peladan95|ShVdH01> and we provide a quick
  survey of them in section <format|no line break><reference|survey>. Our new
  zero-test, which is described in section <reference|zt>, is based on a
  similar approach as <apply|cite|Sh3|Sh4|ShVdH01>. We believe the algorithm
  to be interesting for five main reasons:

  <\itemize>
    <item>We treat differential equations of arbitrary order.

    <item>Our method accommodates divergent power series solutions.

    <item>It reformulates previous work from <apply|cite|Sh3|Sh4|ShVdH01> in
    the more standard setting of differential algebra.

    <item>We believe it to be more efficient. With some more work, it might
    be possible to give complexity bounds for the algorithm (or a modified
    version of it) along the same lines as <apply|cite|ShVdH01>. Such bounds
    are also interesting in relation to ``witness conjectures''
    <apply|cite|vdH:witness|vdH:phd|vdH:singhol|Rich01>.

    <item>On the longer run, the algorithm might generalize to the
    multivariate setting of partial differential equations with initial
    conditions on a subspace of dimension <with|mode|math|\<gtr\>0>.
  </itemize>

  Throughout the paper, we will assume that the reader is familiar with
  differential algebra and the notations used in this field; see section
  <reference|setup> and <apply|cite|Boul94> for a nice introduction. The
  proof of our algorithm also uses a result from the preprint
  <apply|cite|vdH:osc>, which is too complicated to be presented here,
  although we do provide a sketch of the proof in section <reference|logtr>.

  We plan to provide some examples and more explanations in a forthcoming
  journal paper. We are also writing a lecture note about the subject of
  section <format|no line break>4. No implementations are available yet.

  <section|A survey of the existing approaches><label|survey>

  A <em|differentially algebraic power series> is a power series
  <with|mode|math|f> which satisfies a non-trivial algebraic differential
  equation <with|mode|math|P(f)=0>. Consider a power series expression
  constructed from <with|mode|math|z> and the constants in some field
  <with|mode|math|<value|C>> like <with|mode|math|\<bbb-Q\>>, using
  <with|mode|math|+,-,\<cdot\>> and left composition of infinitesimal power
  series by differentially algebraic power series
  <with|mode|math|\<varphi\><rsub|1>,\<ldots\>,\<varphi\><rsub|p>>. Then it
  is a classical problem to test whether such an expression represents zero.
  There are many approaches for this problem.

  <expand|paragraph|Structural approaches.>If the differentially algebraic
  power series are particularly simple, then it is sometimes possible to
  characterize all possible relations between the power series under
  consideration. This is clearly the case if we restrict the differentially
  algebraic power series to be algebraic.

  A more interesting example is obtained when we also allow left composition
  with <with|mode|math|log (1+z)> and <with|mode|math|exp <format|no line
  break>z>. In this case, the Ax theorem <apply|cite|Ax71> and the Risch
  structure theorem <apply|cite|Ris75> may be used to design a fast
  zero-test.

  The structural approach may yield very efficient algorithms when it works.
  However, it requires the characterization of all possible relations in a
  given context, where we merely asked for a test whether a particular one
  holds. Consequently, the approach usually only applies in very specific
  situations.

  <expand|paragraph|Bounding the valuation.>An obvious way to test whether an
  expression represents the zero power series is to obtain a bound for its
  valuation in terms of its size if the expression does <em|not> represent
  zero. Khovanskii has given reasonably good uniform bounds (of the form
  <with|mode|math|O(2<rsup|s<rsup|2>>)>, where <with|mode|math|s> denotes the
  input size) for the number of zeros for systems of real Pfaffian functions
  <format|no line break><apply|cite|Khov91>. These bounds may be adapted to
  the power series context.

  This approach is interesting because it only requires fast power series
  expansions <apply|cite|BK78|vdH:relax> for implementing a zero-test.
  However, such a zero-test might be slow for expressions which can be
  quickly rewritten to zero (like <with|mode|math|x-x>, where
  <with|mode|math|x> is a complicated expression). Also, if we want the
  approach to be efficient, good bounds (such as the ones predicted by
  witness conjectures <apply|cite|vdH:witness|vdH:phd|vdH:singhol|Rich01>)
  would be necessary. At the moment, we only have Khovanskii-type bounds in
  the case of Pfaffian functions. A new strategy for obtaining bounds, which
  might generalize to higher order equations by adapting the algorithm in
  this paper, has been proposed in <apply|cite|ShVdH01>. However, the
  obtained bounds are still doubly exponential.

  <expand|paragraph|The logical approach.>From a theoretical point, it is
  also interesting to ask whether zero-tests always exist. This question has
  been answered very precisely and in a very general context by Denef and
  Lipschitz <apply|cite|DL84|DL89>. In the present setting of power series
  expressions, their approach uses the well-known fact that the set of
  differentially algebraic power series is closed under the ring operations
  and composition. However, the equations one obtains for sums, products,
  <abbr|etc.> may be very complicated, so that that approaches which
  essentially use this fact are deemed to be very inefficient.

  <expand|paragraph|Groebner bases and saturation.>Another simple approach
  was proposed by Shackell in <apply|cite|Sh4> (see the first algorithm). The
  idea is to keep all algebraic relations which hold between a finite number
  of power series in a Groebner basis <with|mode|math|G>. If we want to test
  a new relation, then we include it in <with|mode|math|G> and look whether
  we obtain a contradiction. If not, then we keep on adding the derivatives
  of all relations in <with|mode|math|G> into <with|mode|math|G>. Under
  certain hypotheses, this process always ends up in a contradiction or a
  proof that the added relations all hold. However, the approach does not
  seem to provide any reasonable complexity bounds.

  <expand|paragraph|Varying the initial conditions.>Yet another interesting
  approach <format|no line break><apply|cite|Peladan95> to the zero-test
  problem is to change our point of view. The differentially algebraic power
  series <with|mode|math|\<varphi\><rsub|i>> at the top of this section are
  usually specified by a finite number of algebraic differential equations
  and initial conditions. Now instead of asking whether a given expression
  represents zero, we may ask for which initial conditions for
  <with|mode|math|\<varphi\><rsub|1>,\<ldots\>,\<varphi\><rsub|p>> the
  expression represents zero.

  It turns out that the set of such initial conditions is a closed algebraic
  set <with|mode|math|V>. The ``difficult'' cases in the zero-test correspond
  to the situation in which the original initial conditions are in the
  closure of an open subset <with|mode|math|W> of <with|mode|math|V> where
  the answer is ``easier''. It would be interesting to investigate whether
  this approach of varying the initial conditions may yield a better power
  series analogue for Khovanskii's results. A present disadvantage of the
  method is that it only applies in the convergent case and that it is not
  yet clear how to obtain complexity bounds.

  <expand|paragraph|The generalized solution approach.>The approach in this
  paper is similar to the algorithm in <apply|cite|Sh3>. A better
  understanding (and a complexity analysis) of this algorithm were obtained
  in <apply|cite|ShVdH01>. In order to explain the underlying idea behind the
  present algorithm, let us assume for simplicity that <with|mode|math|p=1>
  and that <with|mode|math|f=\<varphi\><rsub|1>> satisfies the algebraic
  differential equation <with|mode|math|Q(f)=0>.

  Now suppose that we want to test whether <with|mode|math|P(f)=0> for a
  second algebraic differential polynomial <with|mode|math|P>. Then we first
  use differential algebra to determine a third equation
  <with|mode|math|R(f)=<format|no line break>0> which is equivalent to
  <with|mode|math|P(f)=0> and <with|mode|math|Q(f)=0> under certain
  non-degeneracy conditions. Now we consider <with|mode|math|f> as an
  indeterminate and try to solve <with|mode|math|R(f)=<format|no line
  break>0> in a suitable differential overfield <with|mode|math|\<bbb-L\>> of
  <with|mode|math|<value|C>[[z]]>. This field <with|mode|math|\<bbb-L\>>
  consists of so called logarithmic transseries and has the nice property
  that <with|mode|math|Q(f)=<format|no line break>0> still has a unique
  solution in <with|mode|math|\<bbb-L\>> for the initial conditions of
  <with|mode|math|f>. Hence, <with|mode|math|Q(f)=0> if and only if
  <with|mode|math|R(f)=<format|no line break>0> admits a solution
  <with|mode|math|<wide|f|~>> in <with|mode|math|\<bbb-L\>>, in which case we
  <em|necessarily> have <with|mode|math|<wide|f|~>=f>.

  The approach has the advantages that it accommodates divergent
  differentially algebraic power series <with|mode|math|\<varphi\><rsub|1>,\<\
  ldots\>,\<varphi\><rsub|p>> and that the degeneracy of the initial
  conditions is not amplified during the resolution process. We also have a
  good hope to obtain complexity bounds along the same lines as in
  <apply|cite|ShVdH01> and some hope to generalize the approach to the
  multivariate setting. We finally expect the approach to be one of the most
  efficient ones in practice, although no implementations are available yet.

  <section|The effective setup><label|setup>

  Let <with|mode|math|<value|C>> be an <em|effective field of constants> of
  characteristic <with|mode|math|0>. This means that all elements of
  <with|mode|math|<value|C>> can be represented effectively and that there
  are algorithms for performing the field operations and testing equality
  (or, equivalently, for zero-testing).

  Let <with|mode|math|<value|R>> be an <em|effective differential ring>
  (<abbr|i.e.> the differentiation is effective too). We assume that the
  elements of <with|mode|math|<value|R>> are formal power series in
  <with|mode|math|<value|C>[[z]]>, that <with|mode|math|<value|R>\<supseteq\>\
  C[z]>, and that the differentiation <with|mode|math|\<delta\>> on
  <with|mode|math|<value|R>> corresponds to the differentiation
  <with|mode|math|\<delta\>=z*\<partial\>/\<partial\> z> on
  <with|mode|math|<value|C>[[z]]>. Moreover, we will assume that
  <with|mode|math|<value|R>> is an <em|effective power series domain>,
  <abbr|i.e.> there exists an algorithm which takes
  <with|mode|math|f\<in\><value|R>> and <with|mode|math|k\<in\>\<bbb-N\>> on
  input and which computes the coefficient
  <with|mode|math|f<rsub|k>\<in\><value|C>> of <with|mode|math|z<rsup|k>> in
  <with|mode|math|f>. Notice that this implies the existence of an algorithm
  to compute the valuation of <with|mode|math|f\<in\><value|R>>.

  Now consider a non zero differential polynomial
  <with|mode|math|Q\<in\><value|R>[F,\<ldots\>,F<rsup|(r)>]\<subseteq\><value\
  |R>{F}> of order <with|mode|math|r> (recall that
  <with|mode|math|F<rsup|(r)>=\<delta\><rsup|r> F>) and a power series
  solution <with|mode|math|f\<in\><value|C>[[z]]> to <with|mode|math|Q(f)=0>.
  We will assume that <with|mode|math|f> is not a multiple solution,
  <abbr|i.e.> <with|mode|math|<frac|\<partial\> Q|\<partial\> F<rsup|(i)>>
  (f)\<neq\>0> for some <with|mode|math|i\<in\>{0,\<ldots\>,r}> (if
  <with|mode|math|f> is a multiple solution, then we may always replace
  <with|mode|math|Q> by a non-zero <with|mode|math|<frac|\<partial\>
  Q|\<partial\> F<rsup|(i)>>> and continue doing this until
  <with|mode|math|f> is no longer a multiple solution). Choose
  <with|mode|math|i> such that the valuation of
  <with|mode|math|<frac|\<partial\> Q|\<partial\> F<rsup|(i)>> (f)> is
  minimal, say <with|mode|math|k>. Then modulo a transformation of the form

  <\expand|equation*>
    f\<rightarrow\>f<rsub|0>+\<cdots\>+f<rsub|k>*z<rsup|k>+<wide|f|~>*z<rsup|\
    k+1>
  </expand>

  and division of the equation by a suitable power of <format|no line
  break><with|mode|math|z>, we may also assume that

  <\equation>
    <label|decomp>Q=L F+z*M,
  </equation>

  where <with|mode|math|L\<in\><value|C>[\<delta\>]> and
  <with|mode|math|M\<in\><value|R>{F}>. Let
  <with|mode|math|\<Lambda\>\<in\><value|C>[k]> be the polynomial we get from
  <with|mode|math|L> when reinterpreting <with|mode|math|\<delta\>> as an
  indeterminate <with|mode|math|k>. Then (<reference|decomp>) yields a
  recurrence relation for all but a finite number of coefficients of
  <format|no line break><with|mode|math|f>:

  <\equation>
    <label|recrel>f<rsub|k>=-<frac|1|\<Lambda\>(k)>*(M(f))<rsub|k-1>.
  </equation>

  Indeed, the only <with|mode|math|k> for which this relation does not hold
  are roots of <with|mode|math|\<Lambda\>>. There are at most
  <with|mode|math|r> such <with|mode|math|k> and they correspond to the
  initial conditions for <with|mode|math|f>. Let <with|mode|math|s> be the
  largest root of <with|mode|math|\<Lambda\>> in <with|mode|math|\<bbb-N\>>
  (or <with|mode|math|\<um\>1> if such a root does not exist). Then we notice
  in particular that <with|mode|math|f> is the unique solution to
  <with|mode|math|Q(f)=0> whose first <with|mode|math|s+1> coefficients are
  <with|mode|math|f<rsub|0>,\<ldots\>,f<rsub|s>>.

  In what follows, we will show that the differential ring
  <with|mode|math|<value|R>{f}> is again an effective power series domain.
  Now elements in <with|mode|math|<value|R>{f}> can naturally be represented
  as the images of differential polynomials in <with|mode|math|<value|R>{F}>
  under the substitution <with|mode|math|F\<rightarrow\>f>. It therefore
  suffices to design an algorithm to test whether <with|mode|math|P(f)=0> for
  a given differential polynomial <with|mode|math|P\<in\><value|R>{F}>. Our
  algorithm is based on Ritt reduction and the resolution of algebraic
  equation in more general rings of formal power series. We will use standard
  notations from differential algebra:

  <\itemize>
    <item><with|mode|math|I<rsub|P>> denotes the <em|initial> and
    <with|mode|math|S<rsub|P>> denotes the <em|separant> of a differential
    polynomial <with|mode|math|P>.

    <item>The <em|rank> of <with|mode|math|P\<in\><value|R>{F}> is given by
    <with|mode|math|rank <format|no line break>P=(r,d)\<in\>\<bbb-N\><rsup|2>\
    >, where <with|mode|math|r> is the order of <with|mode|math|P> and
    <with|mode|math|d=deg<rsub|F<rsup|(r)>> <format|no line break>P> the
    degree of <with|mode|math|P> in <with|mode|math|F<rsup|(r)>>. Notice that
    the set <with|mode|math|\<bbb-N\><rsup|2>> of possible ranks is
    well-ordered <abbr|w.r.t.> the lexicographical ordering. We will write
    <with|mode|math|V<rsub|P>> for <with|mode|math|(F<rsup|(r)>)<rsup|d>>.

    <item>Given <with|mode|math|A,B\<in\><value|R>{F}>, we denote by
    <with|mode|math|A rem B> the <em|Ritt reduction> of <with|mode|math|A>
    with respect to <with|mode|math|B>. We thus have a relation

    <\expand|equation*>
      I<rsub|B><rsup|\<alpha\>>*H<rsub|B><rsup|\<beta\>>*A=X*B+(A rem B),
    </expand>

    where <with|mode|math|\<alpha\>,\<beta\>\<in\>\<bbb-N\>>,
    <with|mode|math|X\<in\><value|R>{F}> and <with|mode|math|rank (A rem
    B)\<less\>rank B>.
  </itemize>

  <\remark>
    At a first glance, our setting may seem less general than the one in the
    beginning of section <reference|survey>. However, since we will prove
    that <with|mode|math|<value|R>{f}> is again an effective power series
    domain, we may repeat the construction after replacing
    <with|mode|math|<value|R>> by <with|mode|math|<value|R>{f}>, and add as
    many other functions <with|mode|math|f<rsub|2>,\<ldots\>,f<rsub|p>> as we
    like. In fact, it suffices to add one <with|mode|math|f<rsub|i>> for each
    new subexpression of the form <with|mode|math|\<varphi\><rsub|j>\<circ\>g\
    >.
  </remark>

  <section|Logarithmic transseries solutions to algebraic differential
  equations><label|logtr>

  It is well known that any non-trivial algebraic equation with coefficients
  in <with|mode|math|<value|C>[[z]]> has a solution in the field
  <with|mode|math|<value|C><rsup|alg><gb|z<rsup|\<bbb-Q\>>>> of Puiseux
  series over the algebraic closure <with|mode|math|<value|C><rsup|alg>> of
  <with|mode|math|<value|C>>. We will sketch the proof of an analogous result
  in the case of algebraic differential equations. For a full proof (of a
  more general result) we refer to <apply|cite|vdH:osc>.

  <subsection|Logarithmic transseries>

  In order to solve equations of the form <with|mode|math|\<delta\> f=1>, it
  is clear that solutions to such equations might involve logarithms. In
  fact, they may even involve iterated logarithms.

  Let <with|mode|math|\<frak-L\>> be the totally ordered group of
  <em|logarithmic monomials> with powers in <with|mode|math|\<bbb-Q\>>. More
  precisely, the elements of <with|mode|math|\<frak-L\>> are monomials

  <\equation>
    <label|lmons>\<frak-m\>=z<rsup|-\<alpha\><rsub|0>>*(log
    z)<rsup|\<alpha\><rsub|1>>*\<cdots\>*(log<rsub|l>
    z)<rsup|\<alpha\><rsub|l>>,
  </equation>

  where <with|mode|math|\<alpha\><rsub|0>,\<ldots\>,\<alpha\><rsub|l>\<in\>\<\
  bbb-Q\>> and <with|mode|math|log<rsub|l>> stands for the
  <with|mode|math|l>-th iterated logarithm. Given such a monomial, we write
  <with|mode|math|\<frak-m\>\<succ\>1> if and only if
  <with|mode|math|\<alpha\><rsub|i>\<gtr\>0>, where <with|mode|math|i>
  denotes the least <with|mode|math|i> with
  <with|mode|math|\<alpha\><rsub|i>\<neq\>0> in (<reference|lmons>). This
  defines a total ordering <with|mode|math|<op|\<succ\>>> on
  <with|mode|math|\<frak-L\>>. The asymptotic relation
  <with|mode|math|\<frak-m\>\<prec\>\<frak-n\>> corresponds to writing
  <with|mode|math|\<frak-m\>=o(\<frak-n\>)> as
  <with|mode|math|z\<rightarrow\>0> in analysis.

  A subset <with|mode|math|\<frak-S\>\<subseteq\>\<frak-L\>> is said to be
  <em|grid-based>, if there exist monomials
  <with|mode|math|\<frak-m\><rsub|1>\<prec\>1,\<ldots\>,\<frak-m\><rsub|m>\<p\
  rec\>1> and <with|mode|math|\<frak-n\>> in <format|no line
  break><with|mode|math|\<frak-L\>>, such that
  <with|mode|math|\<frak-S\>\<subseteq\>\<frak-m\><rsub|1><rsup|\<bbb-N\>>*\<\
  cdots\>*\<frak-m\><rsub|m><rsup|\<bbb-N\>>*\<frak-n\>>. A <em|grid-based
  logarithmic transseries> is a mapping <with|mode|math|\<frak-L\>\<rightarro\
  w\><value|C>> with grid-based support. We will usually write such series
  using the infinite sum notation <with|mode|math|f=<big|sum><rsub|\<frak-m\>\
  \<in\>\<frak-L\>>f<rsub|\<frak-m\>>*\<frak-m\>> and we denote the set of
  all logarithmic transseries by <with|mode|math|\<bbb-L\>=<value|C><gb|\<fra\
  k-L\>>>. Since the support of each non-zero
  <with|mode|math|f\<in\>\<bbb-L\>> is grid-based (whence well-ordered), this
  support admits a <with|mode|math|<op|\<succcurlyeq\>>>-maximal element
  <with|mode|math|\<frak-d\><rsub|f>> which is called the <em|dominant
  monomial> of <with|mode|math|f>.

  It can be shown <apply|cite|vdH:phd> that
  <with|mode|math|><with|mode|math|C<gb|\<frak-L\>>> is a field for the
  operations

  <\expand|eqnarray*>
    <tformat|<table|<row|<cell|f+g>|<cell|=>|<cell|<big|sum><rsub|\<frak-m\>\\
    <in\>\<frak-L\>>(f<rsub|\<frak-m\>>+g<rsub|\<frak-m\>>)*\<frak-m\>;>>|<ro\
    w|<cell|f*g>|<cell|=>|<cell|<big|sum><rsub|\<frak-m\>\<in\>\<frak-L\>><le\
    ft|(><big|sum><rsub|\<frak-m\>=\<frak-v\>*\<frak-w\>>f<rsub|\<frak-v\>>*g\
    <rsub|\<frak-w\>><right|)>*\<frak-m\>.>>>>
  </expand>

  In the second formula, the grid-based support property ensures that
  <with|mode|math|<big|sum><rsub|\<frak-m\>=\<frak-v\>*\<frak-w\>>f<rsub|\<fr\
  ak-v\>>*g<rsub|\<frak-w\>>> is a finite sum. There also exists a natural
  derivation <with|mode|math|\<delta\>> on
  <with|mode|math|<value|C><gb|\<frak-L\>>>, which sends each monomial
  <with|mode|math|\<frak-m\>\<in\>\<frak-L\>> of the form <format|no line
  break>(<reference|lmons>) to

  <\equation>
    \<delta\> \<frak-m\>=<left|(><group|-\<alpha\><rsub|0>>+<frac|\<alpha\><r\
    sub|1>|log z>+\<cdots\>+<frac|\<alpha\><rsub|l>|log
    z*\<cdots\>*log<rsub|l> z><right|)>*\<frak-m\>.
  </equation>

  This derivation extends to the whole of <with|mode|math|\<bbb-L\>> by
  (infinitary) ``strong linearity'' <apply|cite|vdH:phd>.

  Before proving that solutions to algebraic differential equations with
  coefficients in <with|mode|math|\<bbb-L\>> always exist, we first observe
  that we have the following uniqueness result:

  <\lemma>
    <label|uniqueness>Let <with|mode|math|Q\<in\><value|R>{F}> be a
    differential polynomial of the form <with|font
    shape|right|(<reference|decomp>)>, let
    <with|mode|math|f\<in\><value|C>[[z]]> be a solution to
    <with|mode|math|Q(f)=0> and let <with|mode|math|s> be defined as in
    section <reference|setup>. Then the equation
    <with|mode|math|Q(<wide|f|~>)=0> with side condition
    <with|mode|math|<wide|f|~>-f\<prec\>z<rsup|s>> admits <with|mode|math|f>
    as its unique solution in <with|mode|math|\<bbb-L\>>.
  </lemma>

  <\proof>
    Each series <with|mode|math|f> in <with|mode|math|\<bbb-L\>> may be
    expanded as a Puiseux series in <with|mode|math|z>

    <\equation>
      <label|expf>f=<big|sum><rsub|k\<in\>\<bbb-Q\>>f<rsub|k>*z<rsup|k>,
    </equation>

    where the coefficients <with|mode|math|f<rsub|k>> are series in
    <with|mode|math|<value|C><gb|\<frak-F\>>> and
    <with|mode|math|\<frak-F\>=(log z)<rsup|\<bbb-Q\>>*(log log
    z)<rsup|\<bbb-Q\>>*\<cdots\>>. Notice that we may interpret
    <with|mode|math|\<frak-L\>> as the lexicographical product of
    <with|mode|math|z<rsup|\<bbb-Q\>>> and <with|mode|math|\<frak-F\>>. For
    the expansion (<reference|expf>), the recurrence relation <format|no line
    break>(<reference|recrel>) still determines the coefficients of
    <with|mode|math|f> in a unique way for all <with|mode|math|k\<gtr\>s>.
  </proof>

  <subsection|Asymptotic differential equations>

  A classical way to solve algebraic equations over power series is to use
  the Newton polygon method. We have generalized this method to algebraic
  differential equations. In fact, it is more convenient to solve
  <em|asymptotic differential equations> of the form

  <\equation>
    <label|aade>P(f)=0<space|1fn>(f\<prec\>\<frak-m\>),
  </equation>

  where <with|mode|math|P\<in\>\<bbb-L\>{F}> and
  <with|mode|math|\<frak-m\>\<in\>\<frak-L\>>. In the sequel, we will assume
  that <with|mode|math|<value|C>> is algebraically closed.

  In order to solve (<reference|aade>), we start by determining all possible
  dominant monomials <with|mode|math|\<frak-n\>\<prec\>\<frak-m\>> of
  non-zero solutions and their corresponding coefficients. Actually, it is
  convenient to characterize such <em|potential dominant monomials> first. It
  suffices to characterize when <with|mode|math|1> is a potential dominant
  monomial: we will then say that <with|mode|math|\<frak-n\>> is a potential
  dominant monomial, if <with|mode|math|1> is a potential dominant monomial
  for the equation

  <\expand|equation*>
    P<rsub|\<times\>\<frak-n\>>(f)=0<space|1fn>(f\<prec\>\<frak-m\>/\<frak-n\\
    >).
  </expand>

  Here <with|mode|math|P<rsub|\<times\>\<frak-n\>>> denotes the unique
  differential polynomial in <with|mode|math|\<bbb-L\>{F}> with
  <with|mode|math|P<rsub|\<times\>\<frak-n\>>(f)=P(f*\<frak-n\>)> for all
  <with|mode|math|f>.

  Write <with|mode|math|P=<big|sum><rsub|\<b-i\>>P<rsub|\<b-i\>>*F<rsup|(\<b-\
  i\>)>> using multi-indices <with|mode|math|\<b-i\>> and let
  <with|mode|math|\<frak-d\><rsub|P>=max<rsub|\<preccurlyeq\>>\<frak-d\><rsub\
  |P<rsub|\<b-i\>>>>. Then the <em|dominant part> of <with|mode|math|P> is
  defined to be the scalar differential polynomial

  <\expand|equation*>
    \<Delta\><rsub|P>=<big|sum><rsub|\<b-i\>>P<rsub|\<b-i\>,\<frak-d\><rsub|P\
    >>*F<rsup|(\<b-i\>)>
  </expand>

  in <with|mode|math|<value|C>{F}>, where
  <with|mode|math|P<rsub|\<b-i\>,\<frak-d\><rsub|P>>=(P<rsub|\<b-i\>>)<rsub|\\
  <frak-d\><rsub|P>>>. We also define the dominant part
  <with|mode|math|\<Delta\><rsub|P;z>\<in\><value|C><gb|\<frak-F\>>{F}> of
  <with|mode|math|P> <abbr|w.r.t.> <format|no line break><with|mode|math|z>
  by

  <\expand|equation*>
    \<Delta\><rsub|P;z>=<big|sum><rsub|\<b-i\>>P<rsub|\<b-i\>,\<nu\>>*F<rsup|\
    (\<b-i\>)>,
  </expand>

  where <with|mode|math|\<nu\>> is the valuation of <with|mode|math|P> in
  <with|mode|math|z> and <with|mode|math|P<rsub|\<b-i\>,\<nu\>>> denotes the
  coefficient of <with|mode|math|z<rsup|\<nu\>>> in
  <with|mode|math|P<rsub|\<b-i\>>>.

  Assume first that <with|mode|math|\<Delta\><rsub|P>\<in\><value|C>[F]*(\<de\
  lta\> F)<rsup|\<bbb-N\>>> and <with|mode|math|\<Delta\><rsub|P>=\<Delta\><r\
  sub|P;z>>. Then we define the <em|differential Newton polynomial> of
  <with|mode|math|P> by <with|mode|math|N<rsub|P>=\<Delta\><rsub|P>> and we
  have

  <\expand|equation*>
    P(c+\<varepsilon\>)-N<rsub|P>(c)\<prec\><rsub|z>\<frak-d\><rsub|P>
  </expand>

  for all <with|mode|math|c\<in\><value|C>> and
  <with|mode|math|\<varepsilon\>\<prec\><rsub|z>1>. Here
  <with|mode|math|\<frak-v\>\<prec\><rsub|z>\<frak-w\>>, if
  <with|mode|math|\<frak-w\>/\<frak-v\>=z<rsup|-\<alpha\><rsub|0>>*\<cdots\>*\
  (log<rsub|l> z)<rsup|\<alpha\><rsub|l>>> with
  <with|mode|math|\<alpha\><rsub|0>\<gtr\>0>. We say that <with|mode|math|1>
  is a potential dominant monomial of a solution to <with|mode|math|P(f)=0>
  if and only if <with|mode|math|N<rsub|P>> admits such a non-zero constant
  root <with|mode|math|c\<in\><value|C><rsup|\<ast\>>> (and
  <with|mode|math|c> is a potential dominant term). Furthermore,
  <with|mode|math|N<rsub|P>> admits a non-zero root if and only if
  <with|mode|math|N<rsub|P>\<nin\><format|no line break><value|C>>, because
  <with|mode|math|N<rsub|P>\<in\><value|C>[F]*(\<delta\>*F)<rsup|\<bbb-N\>>>
  and <with|mode|math|<value|C>> is algebraically closed.

  If <with|mode|math|\<Delta\><rsub|P>\<neq\>\<Delta\><rsub|P;z>> or
  <with|mode|math|\<Delta\><rsub|P>\<nin\><value|C>[F]*(\<delta\>
  F)<rsup|\<bbb-N\>>>, then we use the technique of ``upward shifting''.
  Given <with|mode|math|A\<in\><value|C><gb|\<frak-F\>>{F}>, we define
  <with|mode|math|A\<uparrow\>> to be the unique differential polynomial in
  <with|mode|math|\<bbb-L\>{F}> such that

  <\expand|equation*>
    A\<uparrow\>(f\<circ\>e<rsup|1/z>)=A(f)\<circ\>(e<rsup|1/z>)
  </expand>

  for all <with|mode|math|f>. For instance, <with|mode|math|(\<delta\>
  F-1)\<uparrow\>=-z*\<delta\> F-1>, and we notice that the logarithmic
  solution <with|mode|math|log z> of <with|mode|math|\<delta\> f=1>
  transforms to the non-logarithmic solution <with|mode|math|z<rsup|-1>> of
  <with|mode|math|-z*\<delta\> f=1> under upward shifting
  <with|mode|math|f\<mapsto\>f\<uparrow\>=f\<circ\>e<rsup|1/z>>. Now we
  proved in <apply|cite|vdH:osc> that after a finite number of replacements
  <with|mode|math|P\<rightarrow\>\<Delta\><rsub|P;z>\<uparrow\>> we obtain a
  differential polynomial <with|mode|math|<wide|P|~>> with
  <with|mode|math|\<Delta\><rsub|<wide|P|~>>=\<Delta\><rsub|<wide|P|~>;z>>
  and <with|mode|math|\<Delta\><rsub|<wide|P|~>>\<in\><value|C>[F]*(\<delta\>
  F)<rsup|\<bbb-N\>>>. We say that <with|mode|math|1> is a potential dominant
  monomial <abbr|w.r.t.> (<reference|aade>) if and only if
  <with|mode|math|1\<prec\>\<frak-m\>> and
  <with|mode|math|N<rsub|P>\<assign\>N<rsub|<wide|P|~>>> admits a non-zero
  root in <with|mode|math|<value|C><rsup|\<ast\>>>.

  It is clear that if <with|mode|math|f> is a solution to (<reference|aade>),
  then <with|mode|math|\<frak-d\><rsub|f>> must be a potential dominant
  monomial of a solution. We say that a potential dominant monomial
  <with|mode|math|\<frak-n\>\<prec\>\<frak-m\>> is <em|classical>, if
  <with|mode|math|N<rsub|P<rsub|\<times\>\<frak-n\>>>> is not homogeneous
  (<abbr|i.e.> <with|mode|math|N<rsub|P<rsub|\<times\>\<frak-n\>>>\<nin\><val\
  ue|C>*(\<delta\> F)<rsup|\<bbb-N\>>>). These classical potential dominant
  monomials are finite in number and they can be determined from something
  which resembles the Newton polygon in the algebraic case <format|no line
  break><apply|cite|vdH:phd|vdH:osc>, by using a succession of multiplicative
  conjugations <with|mode|math|P\<rightarrow\>P<rsub|\<times\>z<rsup|\<alpha\\
  >>>> and upward shiftings <with|mode|math|P\<rightarrow\>\<Delta\><rsub|P;z\
  >\<uparrow\>> of the dominant parts <abbr|w.r.t.> <with|mode|math|z>.

  Once we have found a potential dominant term
  <with|mode|math|\<varphi\>=\<tau\>> of a solution to (<reference|aade>), we
  may consider the <em|refinement>

  <\equation>
    f=\<varphi\>+<wide|f|~><space|1fn>(<wide|f|~>\<prec\><wide|\<frak-m\>|~>)\
    .
  </equation>

  In other words, a refinement is a change of variables together with the
  imposition of a new asymptotic constraint. It transforms (<reference|aade>)
  into a new asymptotic differential equation

  <\equation>
    P<rsub|+\<varphi\>>(<wide|f|~>)=0<space|1fn>(<wide|f|~>\<prec\><wide|\<fr\
    ak-m\>|~>).
  </equation>

  Using the possibly transfinite process of determining \ potential dominant
  terms and making refinements, one finds all solutions to
  (<reference|aade>). However, a more careful study is required to ensure
  that one remains in the context of grid-based transseries and that (for
  instance) no transseries like

  <\equation>
    <label|badseries>log z+log<rsub|2> z+log<rsub|3> z+\<cdots\>
  </equation>

  may occur as solutions of (<reference|aade>).

  In order to do this, it is convenient to associate an invariant to the
  equation (<reference|aade>): the highest possible degree of the
  <em|differential> Newton polynomial <with|mode|math|N<rsub|P<rsub|\<times\>\
  \<frak-n\>>>> that we can achieve for a monomial
  <with|mode|math|\<frak-n\>\<prec\>\<frak-m\>> is called the <em|Newton
  degree> of <format|no line break>(<reference|aade>) and we denote it by
  <with|mode|math|deg<rsub|\<prec\>\<frak-m\>> P>. In the algebraic case, the
  Newton degree measures the number of solutions to the asymptotic equation
  (<reference|aade>), when counting with multiplicities. In the differential
  case, it only gives a lower bound (see theorem <reference|existence>
  below). Also, an equation of Newton degree <with|mode|math|0> does not
  admit any solutions.

  Now we have shown in <apply|cite|vdH:phd|vdH:osc> that the Newton degree
  decreases during refinements and that quasi-linear equations (<abbr|i.e.>
  equations of Newton degree <format|no line break><with|mode|math|1>) always
  admit solutions. Finally, in the case when
  <with|mode|math|deg<rsub|\<prec\><wide|\<frak-m\>|~>>
  P<rsub|+\<varphi\>>=deg<rsub|\<prec\>\<frak-m\>> P\<geqslant\>2>, it is
  possible to replace <with|mode|math|\<varphi\>> by a solution to a
  quasi-linear equation of the form

  <\equation>
    <frac|\<partial\><rsup|\<alpha\><rsub|0>+\<cdots\>+\<alpha\><rsub|r>>
    P|(\<partial\> F)<rsup|\<alpha\><rsub|0>>*\<cdots\>*(\<partial\>
    F<rsup|(r)>)<rsup|\<alpha\><rsub|r>>>
    (\<varphi\>)=0<space|1fn>(\<varphi\>\<prec\>\<frak-m\>),
  </equation>

  and force the Newton degree to strictly decrease after a finite number of
  steps. In other words, the transfinite resolution process has been replaced
  by an essentially finite algorithm, which avoids solutions of the form
  (<reference|badseries>). In particular, these methods yield the following
  theorem:

  <\theorem>
    <label|existence>Consider an asymptotic algebraic differential equation
    <with|font shape|right|(<reference|aade>)> of Newton degree
    <with|mode|math|d\<gtr\>0> over <with|mode|math|\<bbb-L\>>. Then
    <with|font shape|right|(<reference|aade>)> admits at least
    <with|mode|math|d> solutions in <with|mode|math|\<bbb-L\>> when counting
    with multiplicities.
  </theorem>

  <section|The algorithm><label|zt>

  In this sequel, we assume that <with|mode|math|Q>, <with|mode|math|f> and
  <with|mode|math|s> are as in section <reference|setup>. We will give an
  algorithm to test whether <with|mode|math|P(f)=0> for given
  <with|mode|math|P\<in\><value|R>{F}>. We will write
  <with|mode|math|P\<equiv\>0> if and only <with|mode|math|P(f)=0>.

  <subsection|Statement of the algorithm>

  <\algorithm|>
    <with|mode|math|P\<equiv\>>0

    <name|Input>: a differential polynomial
    <with|mode|math|P\<in\><value|R>{F}>

    <name|Output:> <with|mode|math|<with|math font series|bold|true>> if and
    only if <with|mode|math|P\<equiv\>0>

    <\body>
      <expand|item*|Step 1.>[Initialize]

      <\indent>
        <with|mode|math|H\<assign\>1>

        <with|mode|math|R\<assign\>P>

        <with|mode|math|reducing\<assign\><with|math font series|bold|true>>
      </indent>

      <expand|item*|Step 2.>[Reduction]

      <\indent>
        <strong|while> <with|mode|math|reducing>

        <\indent>
          <strong|if> <with|mode|math|R\<in\><value|R>> <strong|then>
          <strong|return> <with|mode|math|R=0>

          <strong|else if> <with|mode|math|I<rsub|R>\<equiv\>0> <strong|then>
          <with|mode|math|R\<assign\>R-I<rsub|R>*V<rsub|R>>

          <strong|else if> <with|mode|math|S<rsub|R>\<equiv\>0> <strong|then>

          <indent|<with|mode|math|H\<assign\>I<rsub|R>*H, R\<assign\>R rem
          S<rsub|R>>>

          <strong|else if> <with|mode|math|Q rem R\<neq\>0> <strong|then>

          <indent|<with|mode|math|><with|mode|math|H\<assign\>I<rsub|R>*S<rsu\
          b|R>*H, R\<assign\>Q rem R>>

          <strong|else> <with|mode|math|H\<assign\>I<rsub|R>*S<rsub|R>*H,
          reducing\<assign\><with|math font series|bold|false>>
        </indent>
      </indent>

      <expand|item*|Step 3.>[Final test]<format|no page break after>

      <\indent>
        let <with|mode|math|k> be minimal with
        <with|mode|math|deg<rsub|\<prec\>z<rsup|k>>
        H<rsub|+f<rsub|0>+\<cdots\>+f<rsub|k>*z<rsup|k>>=0><format|no page
        break after>

        <with|mode|math|k\<assign\>max{k,s}><format|no page break after>

        <strong|return> <with|mode|math|deg<rsub|\<prec\>z<rsup|k>>
        R<rsub|+f<rsub|0>+\<cdots\>+f<rsub|k>*z<rsup|k>>\<neq\>0>
      </indent>
    </body>
  </algorithm>

  <\remark>
    In the particular case when an asymptotic differential equation
    (<reference|aade>) has power series coefficients in
    <with|mode|math|<value|C>[[z]]> and <with|mode|math|\<frak-m\>=z<rsup|k>>\
    , its Newton degree <with|mode|math|deg<rsub|\<prec\>z<rsup|k>> P> is the
    minimal degree of a term <with|mode|math|P<rsub|\<times\>z<rsup|k>,\<b-i\\
    >>*f<rsup|(\<b-i\>)>> in <with|mode|math|P<rsub|\<times\>z<rsup|k>>> with
    <with|mode|math|\<frak-d\><rsub|P<rsub|\<times\>z<rsup|k>,\<b-i\>>>=\<fra\
    k-d\><rsub|P<rsub|\<times\>z<rsup|k>>>>.

    In particular, the minimal <with|mode|math|k> in step 3 can be found by
    expanding the power series coefficients
    <with|mode|math|H<rsub|\<b-i\>>(f)> of <with|mode|math|H> in
    <with|mode|math|z> using any fast expansion algorithm for solutions to
    differential equations <format|no line break><apply|cite|BK78|vdH:relax>.
  </remark>

  <subsection|Correctness and termination proof>

  <\theorem>
    The above algorithm for testing whether <with|mode|math|P\<equiv\>0>
    terminates and is correct.
  </theorem>

  <\proof>
    In the loop in step 2, we notice that the rank of <with|mode|math|R>
    strictly decreases at each iteration. Also, the rank of
    <with|mode|math|I<rsub|R>> (or <with|mode|math|S<rsub|R>>) in each
    recursive call of the zero-test is strictly smaller than the rank of
    <with|mode|math|R> (and whence the rank of <with|mode|math|P>). These two
    observations, and the fact that the set of possible ranks is
    well-ordered, imply the termination of the algorithm; the existence of a
    minimal <with|mode|math|k> with <with|mode|math|deg<rsub|\<prec\>z<rsup|k\
    >> H<rsub|+f<rsub|0>+\<cdots\>+f<rsub|k>*z<rsup|k>>=0> will be proved
    below.

    As to the correctness of the algorithm, we claim that at the start and
    the end inside the loop in step <format|no line break>2, we maintain the
    properties that <with|mode|math|H\<nequiv\>0> and the existence of a
    relation of the form

    <\equation>
      <label|PRrel>H<rsup|\<alpha\>>*P=A*R+B
    </equation>

    for <with|mode|math|\<alpha\>\<in\>\<bbb-N\>> and differential
    polynomials <with|mode|math|A> and <with|mode|math|B> with
    <with|mode|math|B\<equiv\>0>. Indeed, we have <with|mode|math|H=A=1> and
    <with|mode|math|B=0> at the first entry. If
    <with|mode|math|I<rsub|R>\<equiv\>0> and
    <with|mode|math|<wide|R|~>=R-I<rsub|R>*V<rsub|R>>, then we have
    <with|mode|math|H<rsup|\<alpha\>>*P=A*R+B=A*<wide|R|~>+(B+A*I<rsub|R>*V<r\
    sub|R>)>, with <with|mode|math|B+A*I<rsub|R>*V<rsub|R>\<equiv\>0>. If
    <with|mode|math|S<rsub|R>\<equiv\>0>,
    <with|mode|math|<wide|H|~>=I<rsub|R>*H> and <with|mode|math|<wide|R|~>=R
    rem S<rsub|R>>, then <with|mode|math|I<rsub|S<rsub|R>><rsup|\<beta\>>*R=X\
    *S<rsub|R>+<wide|R|~>> for some <with|mode|math|\<beta\>\<in\><format|no
    line break>\<bbb-N\>> and differential polynomial <format|no line
    break><with|mode|math|X>. Also, <with|mode|math|I<rsub|S<rsub|R>>=d*I<rsu\
    b|R>>, where <with|mode|math|d\<geqslant\>2> is the degree of
    <with|mode|math|R> in the highest <with|mode|math|f<rsup|(r)>> occurring
    in <with|mode|math|R>. Consequently, denoting
    <with|mode|math|<wide|\<alpha\>|~>=max(\<alpha\>,\<beta\>)>, we have
    <with|mode|math|<wide|H|~><rsup|<wide|\<alpha\>|~>>*<format|no line
    break>P=I<rsub|R><rsup|<wide|\<alpha\>|~>>*<format|no line
    break>H<rsup|<wide|\<alpha\>|~>>*<format|no line
    break>P=I<rsub|R><rsup|<wide|\<alpha\>|~>>*<format|no line
    break>H<rsup|<wide|\<alpha\>|~>-\<alpha\>>*<format|no line
    break>R+I<rsub|R><rsup|<wide|\<alpha\>|~>>*<format|no line
    break>H<rsup|<wide|\<alpha\>|~>-\<alpha\>>*<format|no line
    break>B=d<rsup|-<wide|\<alpha\>|~>>*<format|no line
    break>I<rsub|R><rsup|<wide|\<alpha\>|~>-\<beta\>>*<format|no line
    break>H<rsup|<wide|\<alpha\>|~>-\<alpha\>>*<wide|R|~>+(d<rsup|-<wide|\<al\
    pha\>|~>>*<format|no line break>I<rsub|R><rsup|<wide|\<alpha\>|~>-\<beta\\
    >>*<format|no line break>H<rsup|<wide|\<alpha\>|~>-\<alpha\>>*X*S<rsub|R>\
    +I<rsub|R><rsup|<wide|\<alpha\>|~>>*<format|no line
    break>H<rsup|<wide|\<alpha\>|~>-\<alpha\>>*<format|no line break>B)>. The
    case when <with|mode|math|Q rem R\<neq\>0> is treated in a similar way.
    This proves our claim; notice that <format|no line
    break>(<reference|PRrel>) implies <with|mode|math|P\<equiv\>0\<Leftrighta\
    rrow\>R\<equiv\>0>. By definition, we also have
    <with|mode|math|R=0\<Leftrightarrow\>R\<equiv\>0> if
    <with|mode|math|R\<in\><value|R>> at the first test in the loop.

    Let us now assume that the algorithm reaches step 3. Since
    <with|mode|math|H\<nequiv\>0>, we may write
    <with|mode|math|H(f)=c<rsub|l>*<format|no line
    break>z<rsup|l>+O(z<rsup|l+1>)> with <with|mode|math|c<rsub|l>\<neq\>0>
    for some <with|mode|math|l\<in\>\<bbb-N\>>. For this <with|mode|math|l>,
    we have <with|mode|math|deg<rsub|\<prec\>z<rsup|l>>
    H<rsub|+f<rsub|0>+\<cdots\>+f<rsub|l>*z<rsup|l>>=0>, which implies that
    there exists a minimal number <with|mode|math|k>, such that both
    <with|mode|math|deg<rsub|\<prec\>z<rsup|k>>
    H<rsub|+f<rsub|0>+\<cdots\>+f<rsub|k>*z<rsup|k>>=0> and
    <with|mode|math|k\<geqslant\>s>. If <with|mode|math|deg<rsub|\<prec\>z<rs\
    up|k>> R<rsub|+f<rsub|0>+\<cdots\>+f<rsub|k>*z<rsup|k>>=0>, then we have
    <with|mode|math|R(f)\<sim\>R(f<rsub|0>+\<cdots\>+f<rsub|k>*z<rsup|k>)\<ne\
    q\>0>, whence <with|mode|math|R\<nequiv\>0> and
    <with|mode|math|P\<nequiv\>0>. Conversely, assume that
    <with|mode|math|deg<rsub|\<prec\>z<rsup|k>>
    R<rsub|+f<rsub|0>+\<cdots\>+f<rsub|k>*z<rsup|k>>\<neq\>0>. Then theorem
    <reference|existence> implies the existence of a series
    <with|mode|math|<wide|f|~>\<in\>C<gb|\<frak-L\>>> with
    <with|mode|math|R(<wide|f|~>)=0> and <with|mode|math|<wide|f|~>-f\<prec\>\
    z<rsup|k>>. Since <with|mode|math|Q rem R=0> and
    <with|mode|math|I<rsub|R>*S<rsub|R>\|H>, we have a relation of the form

    <\equation>
      H<rsup|\<beta\>>*Q=X<rsub|0>*R+\<cdots\>+X<rsub|t>*R<rsup|(t)>,
    </equation>

    where <with|mode|math|\<beta\>\<in\>\<bbb-N\>> and
    <with|mode|math|X<rsub|0>,\<ldots\>,X<rsub|t>> are differential
    polynomials. Now <with|mode|math|deg<rsub|\<prec\>z<rsup|l>>
    H<rsub|+f<rsub|0>+\<cdots\>+f<rsub|l>*z<rsup|l>>=0> implies
    <with|mode|math|H(<wide|f|~>)\<neq\><format|no line break>0>, so that
    <with|mode|math|Q(<wide|f|~>)=0>. But, by lemma <reference|uniqueness>,
    there exists a unique solution in <with|mode|math|C<gb|\<frak-L\>>> to
    the equation <with|mode|math|Q(<wide|f|~>)=0> with the side condition
    <with|mode|math|<wide|f|~>-f\<prec\><format|no line break>z<rsup|s>>.
    Hence <with|mode|math|<wide|f|~>=f>, <with|mode|math|R(f)=0> and
    <with|mode|math|P\<equiv\>0>.
  </proof>

  <\bibliography|bib|acm|zerotest>
    <apply|bibitem*|1><label|bib-Ax71><with|font shape|small-caps|Ax, J.>
    <apply|newblock>On Schanuel's conjecture. <apply|newblock><with|font
    shape|italic|Ann. of Math. 93> (1971), 252--268.

    <apply|bibitem*|2><label|bib-Boul94><with|font shape|small-caps|Boulier,
    F.> <apply|newblock><with|font shape|italic|tude et implantation de
    quelques algorithmes en algbre diffrentielle>. <apply|newblock>PhD
    thesis, University of Lille I, 1994.

    <apply|bibitem*|3><label|bib-BK78><with|font shape|small-caps|Brent, R.,
    and Kung, H.> <apply|newblock>Fast algorithms for manipulating formal
    power series. <apply|newblock><with|font shape|italic|Journal of the ACM
    25> (1978), 581--595.

    <apply|bibitem*|4><label|bib-DL84><with|font shape|small-caps|Denef, J.,
    and Lipshitz, L.> <apply|newblock>Power series solutions of algebraic
    differential equations. <apply|newblock><with|font shape|italic|Math.
    Ann. 267> (1984), 213--238.

    <apply|bibitem*|5><label|bib-DL89><with|font shape|small-caps|Denef, J.,
    and Lipshitz, L.> <apply|newblock>Decision problems for differential
    equations. <apply|newblock><with|font shape|italic|The Journ. of Symb.
    Logic 54>, 3 (1989), 941--950.

    <apply|bibitem*|6><label|bib-Khov91><with|font
    shape|small-caps|Khovanskii, A. G.> <apply|newblock><with|font
    shape|italic|Fewnomials>. <apply|newblock>American Mathematical Society,
    Providence, RI, 1991.

    <apply|bibitem*|7><label|bib-Peladan95><with|font
    shape|small-caps|Pladan-Germa, A.> <apply|newblock>Testing identities of
    series defined by algebraic partial differential equations.
    <apply|newblock>In <with|font shape|italic|Applied Algebra, Algebraic
    Algorithms and Error-Correcting Codes> (1995), G. Cohen, M. Giusti, and
    T. Mora, Eds., Springer-Verlag, pp. 393--407. <apply|newblock>Proceedings
    of the 11th International Symposium, AAECC-11, Paris, France, July 1995.

    <apply|bibitem*|8><label|bib-Rich01><with|font
    shape|small-caps|Richardson, D.> <apply|newblock>The uniformity
    conjecture. <apply|newblock>In <with|font shape|italic|Lecture Notes in
    Computer Science> (2001), vol. 2064, Springer Verlag, pp. 253--272.

    <apply|bibitem*|9><label|bib-Ris75><with|font shape|small-caps|Risch, R.>
    <apply|newblock>Algebraic properties of elementary functions in analysis.
    <apply|newblock><with|font shape|italic|Amer. Journ. of Math. 4>, 101
    (1975), 743--759.

    <apply|bibitem*|10><label|bib-Sh3><with|font shape|small-caps|Shackell,
    J.> <apply|newblock>A differential-equations approach to functional
    equivalence. <apply|newblock>In <with|font shape|italic|ISSAC '89
    Proceedings> (Portland, Oregon, 1989), G. Gonnet, Ed., A.C.M. Press, pp.
    7--10.

    <apply|bibitem*|11><label|bib-Sh4><with|font shape|small-caps|Shackell,
    J.> <apply|newblock>Zero-equivalence in function fields defined by
    algebraic differential equations. <apply|newblock><with|font
    shape|italic|Trans. Amer. Math. Soc. 336/1> (1993), 151--172.

    <apply|bibitem*|12><label|bib-ShVdH01><with|font
    shape|small-caps|Shackell, J., and van der Hoeven, J.>
    <apply|newblock>Complexity bounds for zero-test algorithms.
    <apply|newblock>Tech. Rep. 2001-63, Prpublications d'Orsay, 2001.

    <apply|bibitem*|13><label|bib-vdH:phd><with|font shape|small-caps|van der
    Hoeven, J.> <apply|newblock><with|font shape|italic|Automatic
    asymptotics>. <apply|newblock>PhD thesis, cole polytechnique, France,
    1997.

    <apply|bibitem*|14><label|bib-vdH:relax><with|font shape|small-caps|van
    der Hoeven, J.> <apply|newblock>Relax, but don't be too lazy.
    <apply|newblock>Tech. Rep. 78, Prpublications d'Orsay, 1999.
    <apply|newblock>Submitted to JSC.

    <apply|bibitem*|15><label|bib-vdH:osc><with|font shape|small-caps|van der
    Hoeven, J.> <apply|newblock>Complex transseries solutions to algebraic
    differential equations. <apply|newblock>Tech. Rep. 2001-34, Univ.
    d'Orsay, 2001.

    <apply|bibitem*|16><label|bib-vdH:singhol><with|font shape|small-caps|van
    der Hoeven, J.> <apply|newblock>Fast evaluation of holonomic functions
    near and in singularities. <apply|newblock><with|font shape|italic|JSC
    31> (2001), 717--743.

    <apply|bibitem*|17><label|bib-vdH:witness><with|font shape|small-caps|van
    der Hoeven, J.> <apply|newblock>Zero-testing, witness conjectures and
    differential diophantine approximation. <apply|newblock>Tech. Rep.
    2001-62, Prpublications d'Orsay, 2001.
  </bibliography>
</body>

<\initial>
  <\collection>
    <associate|odd page margin|30mm>
    <associate|paragraph width|150mm>
    <associate|page medium|paper>
    <associate|shrinking factor|4>
    <associate|page top margin|30mm>
    <associate|page right margin|30mm>
    <associate|reduction page right margin|5mm>
    <associate|paragraph hyphenation|professional>
    <associate|page type|a4>
    <associate|reduction page bottom margin|5mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|5mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|5mm>
    <associate|show header and footer|true>
    <associate|language|english>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|decomp|<tuple|1|3>>
    <associate|bib-vdH:witness|<tuple|17|6>>
    <associate|bib-vdH:relax|<tuple|14|6>>
    <associate|bib-Ris75|<tuple|9|6>>
    <associate|survey|<tuple|2|1>>
    <associate|bib-vdHoeven97|<tuple|vdH97|?>>
    <associate|existence|<tuple|3|5>>
    <associate|bib-Sh3|<tuple|10|6>>
    <associate|bib-Sh4|<tuple|11|6>>
    <associate|bib-Boul94|<tuple|2|6>>
    <associate|bib-ShVdH01|<tuple|12|6>>
    <associate|bib-vdH:singhol|<tuple|16|6>>
    <associate|setup|<tuple|3|2>>
    <associate|logexp|<tuple|3.5|?>>
    <associate|toc-10|<tuple|4|3>>
    <associate|toc-11|<tuple|4.1|3>>
    <associate|epd|<tuple|3|1>>
    <associate|bib-Peladan95|<tuple|7|6>>
    <associate|toc-12|<tuple|4.2|4>>
    <associate|bib-Khov91|<tuple|6|6>>
    <associate|toc-13|<tuple|5|5>>
    <associate|toc-14|<tuple|5.1|5>>
    <associate|toc-15|<tuple|5.2|5>>
    <associate|aade|<tuple|6|4>>
    <associate|toc-16|<tuple|12|6>>
    <associate|expf|<tuple|5|4>>
    <associate|bib-vdH:osc|<tuple|15|6>>
    <associate|bib-vdH:phd|<tuple|13|6>>
    <associate|PRrel|<tuple|11|5>>
    <associate|bib-Ax71|<tuple|1|6>>
    <associate|zt|<tuple|5|5>>
    <associate|toc-1|<tuple|1|1>>
    <associate|logtr|<tuple|4|3>>
    <associate|bib-Rich01|<tuple|8|6>>
    <associate|toc-2|<tuple|2|1>>
    <associate|lmons|<tuple|3|3>>
    <associate|toc-3|<tuple|2|1>>
    <associate|bib-DL84|<tuple|4|6>>
    <associate|badseries|<tuple|9|5>>
    <associate|toc-4|<tuple|2|2>>
    <associate|toc-5|<tuple|2|2>>
    <associate|toc-6|<tuple|2|2>>
    <associate|toc-7|<tuple|2|2>>
    <associate|bib-BK78|<tuple|3|6>>
    <associate|toc-8|<tuple|2|2>>
    <associate|uniqueness|<tuple|2|4>>
    <associate|bib-DL89|<tuple|5|6>>
    <associate|toc-9|<tuple|3|2>>
    <associate|recrel|<tuple|2|3>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|bib>
      Ris75

      Khov91

      Sh3

      Sh4

      Peladan95

      ShVdH01

      Sh3

      Sh4

      ShVdH01

      Sh3

      Sh4

      ShVdH01

      ShVdH01

      vdH:witness

      vdH:phd

      vdH:singhol

      Rich01

      Boul94

      vdH:osc

      Ax71

      Ris75

      Khov91

      BK78

      vdH:relax

      vdH:witness

      vdH:phd

      vdH:singhol

      Rich01

      ShVdH01

      DL84

      DL89

      Sh4

      Peladan95

      Sh3

      ShVdH01

      ShVdH01

      vdH:osc

      vdH:phd

      vdH:phd

      vdH:osc

      vdH:phd

      vdH:osc

      vdH:phd

      vdH:osc

      BK78

      vdH:relax
    </associate>
    <\associate|toc>
      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|1<space|2spc>Introduction><value|toc-dots><pageref|\
      toc-1><vspace|0.5fn>

      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|2<space|2spc>A survey of the existing
      approaches><value|toc-dots><pageref|toc-2><vspace|0.5fn>

      <with|left margin|<quote|6fn>|font size|<quote|0.84>|Structural
      approaches.<value|toc-dots><pageref|toc-3>>

      <with|left margin|<quote|6fn>|font size|<quote|0.84>|Bounding the
      valuation.<value|toc-dots><pageref|toc-4>>

      <with|left margin|<quote|6fn>|font size|<quote|0.84>|The logical
      approach.<value|toc-dots><pageref|toc-5>>

      <with|left margin|<quote|6fn>|font size|<quote|0.84>|Groebner bases and
      saturation.<value|toc-dots><pageref|toc-6>>

      <with|left margin|<quote|6fn>|font size|<quote|0.84>|Varying the
      initial conditions.<value|toc-dots><pageref|toc-7>>

      <with|left margin|<quote|6fn>|font size|<quote|0.84>|The generalized
      solution approach.<value|toc-dots><pageref|toc-8>>

      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|3<space|2spc>The effective
      setup><value|toc-dots><pageref|toc-9><vspace|0.5fn>

      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|4<space|2spc>Logarithmic transseries solutions to
      algebraic differential equations><value|toc-dots><pageref|toc-10><vspac\
      e|0.5fn>

      4.1<space|2spc>Logarithmic transseries<value|toc-dots><pageref|toc-11>

      4.2<space|2spc>Asymptotic differential
      equations<value|toc-dots><pageref|toc-12>

      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|5<space|2spc>The
      algorithm><value|toc-dots><pageref|toc-13><vspace|0.5fn>

      5.1<space|2spc>Statement of the algorithm<value|toc-dots><pageref|toc-1\
      4>

      5.2<space|2spc>Correctness and termination
      proof<value|toc-dots><pageref|toc-15>

      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|Bibliography><value|toc-dots><pageref|toc-16><vspac\
      e|0.5fn>
    </associate>
  </collection>
</auxiliary>
